use std::env;
use std::{
    fs::write,
    fs::File,
    io::{prelude::*, BufReader},
    iter::repeat,
    path::Path,
};

fn lines_from_file(filename: impl AsRef<Path>) -> Vec<String> {
    let file = File::open(filename).expect("no such file");
    let buf = BufReader::new(file);
    buf.lines()
        .map(|l| l.expect("Could not parse line"))
        .collect()
}

fn main() {
    println!("prepare submission file.\n{:-<1$}", "", 100);
    let f_import = "src/tmp.rs";
    let lines: Vec<String> = lines_from_file(f_import)
        .into_iter()
        .filter(|line| !line.contains("struct Solution"))
        .collect();

    for line in &lines {
        println!("{}", line);
    }
    println!("{}", repeat("-").take(100).collect::<String>());

    let joined = lines.join("\n");
    let args: Vec<String> = env::args().collect();
    let f_export = &args[1];
    println!("Export submission code to: [{}]", f_export);
    write(f_export, joined).expect("Unable to write file");
}
