/*
 * @lc app=leetcode id=961 lang=rust
 *
 * [961] N-Repeated Element in Size 2N Array
 *
 * https://leetcode.com/problems/n-repeated-element-in-size-2n-array/description/
 *
 * algorithms
 * Easy (73.01%)
 * Total Accepted:    97.7K
 * Total Submissions: 133.8K
 * Testcase Example:  '[1,2,3,3]'
 *
 * In a array A of size 2N, there are N+1 unique elements, and exactly one of
 * these elements is repeated N times.
 * 
 * Return the element repeated N times.
 * 
 * 
 * 
 * 
 * 
 * 
 * 
 * Example 1:
 * 
 * 
 * Input: [1,2,3,3]
 * Output: 3
 * 
 * 
 * 
 * Example 2:
 * 
 * 
 * Input: [2,1,2,5,3,2]
 * Output: 2
 * 
 * 
 * 
 * Example 3:
 * 
 * 
 * Input: [5,1,5,2,5,3,5,4]
 * Output: 5
 * 
 * 
 * 
 * 
 * Note:
 * 
 * 
 * 4 <= A.length <= 10000
 * 0 <= A[i] < 10000
 * A.length is even
 * 
 * 
 * 
 * 
 * 
 */
use std::collections::HashSet; 

impl Solution {
    pub fn repeated_n_times(a: Vec<i32>) -> i32 {
        let mut hs = HashSet::with_capacity(a.len()/2);
        for n in a{
            match hs.contains(&n){
                true => return n, 
                false => hs.insert(n),
            };
        }
        unreachable!()
    }
}
// pub structSolution; 
