#![allow(clippy::all)]

use crate::common::complex::Scaler;

#[rustfmt::skip]
pub const W_N80_10MS: [Scaler; 160] = [
    -7.078546706512391e-04, -2.098197727900724e-03, -4.525198076002370e-03, -8.233976327300612e-03,
    -1.337713096257934e-02, -1.999721557401502e-02, -2.800909464274782e-02, -3.721502082245055e-02,
    -4.731768261606175e-02, -5.794654834034055e-02, -6.867606753531441e-02, -7.904647440788692e-02,
    -8.859705468085925e-02, -9.688303623049199e-02, -1.034961241263523e-01, -1.080766457616878e-01,
    -1.103242262600913e-01, -1.099809851424550e-01, -1.068172142230882e-01, -1.006190418791648e-01,
    -9.116452506492527e-02, -7.820617483254730e-02, -6.146688124166948e-02, -4.063362855701623e-02,
    -1.536329520788766e-02, 1.470155068746303e-02, 4.989736509080558e-02, 9.050369257152079e-02, 1.366911019414417e-01,
    1.884686389218322e-01, 2.456456803467095e-01, 3.077789078889820e-01, 3.741642373060188e-01, 4.438114799213576e-01,
    5.154735456539700e-01, 5.876661722564289e-01, 6.587619767809000e-01, 7.270576699841359e-01, 7.908752989295335e-01,
    8.486643364959733e-01, 8.991320235484349e-01, 9.413348145272842e-01, 9.747634827941575e-01, 9.994114730415857e-01,
    1.015760373791603e00, 1.024736164069697e00, 1.027634294456205e00, 1.025991493983836e00, 1.021427210603284e00,
    1.015439859549357e00, 1.009366925499550e00, 1.003508162416449e00, 9.988898206257559e-01, 9.953133902427869e-01,
    9.925943919208190e-01, 9.905771957917731e-01, 9.891371616557014e-01, 9.881790747212391e-01, 9.876249269174586e-01,
    9.874056275509585e-01, 9.874524849192456e-01, 9.876951134084213e-01, 9.880640617030884e-01, 9.884926873551375e-01,
    9.889230031022089e-01, 9.893074965384659e-01, 9.896146331889107e-01, 9.898319269347060e-01, 9.899693102025342e-01,
    9.900603352632121e-01, 9.901575015155720e-01, 9.903255289051605e-01, 9.906303787150326e-01, 9.911298894709990e-01,
    9.918665491182922e-01, 9.928619727154252e-01, 9.941156069136238e-01, 9.956033775539884e-01, 9.972793109558521e-01,
    9.990784840729244e-01, 1.000922365901945e00, 1.002728111386909e00, 1.004416038098237e00, 1.005919224127911e00,
    1.007189345025525e00, 1.008200146369426e00, 1.008949493525753e00, 1.009458241425143e00, 1.009768980817384e00,
    1.009940336228694e00, 1.010039453539107e00, 1.010132323996401e00, 1.010272524848519e00, 1.010494354532353e00,
    1.010808068774316e00, 1.011201071127927e00, 1.011641272406023e00, 1.012080125934687e00, 1.012458183122033e00,
    1.012706955800289e00, 1.012755013843985e00, 1.012530134411619e00, 1.011962331100864e00, 1.010982135506986e00,
    1.009512438049510e00, 1.007460860286395e00, 1.004708677491086e00, 1.001111413242302e00, 9.965041017623596e-01,
    9.907199995730845e-01, 9.823765865983288e-01, 9.708821747608998e-01, 9.546732976073705e-01, 9.321553861564006e-01,
    9.018003682081348e-01, 8.623984077953557e-01, 8.132817365236141e-01, 7.544551974836834e-01, 6.866580716267418e-01,
    6.113488038789190e-01, 5.306181649316597e-01, 4.471309850999502e-01, 3.639114681156236e-01, 2.841647033392408e-01,
    2.110209448747969e-01, 1.472287968327703e-01, 9.482665349502291e-02, 5.482436608328477e-02, 2.701461405056264e-02,
    9.996743588367519e-03, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N160_10MS: [Scaler; 320] = [
    -4.619898752628163e-04, -9.747166718929050e-04, -1.664473096973725e-03, -2.597106916737789e-03,
    -3.806285163352241e-03, -5.324608721716763e-03, -7.175885277771099e-03, -9.382480860899108e-03,
    -1.195270300743193e-02, -1.489528159506296e-02, -1.820666399965468e-02, -2.187570925786862e-02,
    -2.588471937157619e-02, -3.020862738245264e-02, -3.481597793538342e-02, -3.967067992672979e-02,
    -4.472698045914417e-02, -4.994225863256500e-02, -5.526334794593565e-02, -6.063717235243996e-02,
    -6.600961519440657e-02, -7.131966266443390e-02, -7.651178225890490e-02, -8.152964005319532e-02,
    -8.631137544905677e-02, -9.080411291245728e-02, -9.495377758870335e-02, -9.870736514214426e-02,
    -1.020202684361974e-01, -1.048438825017798e-01, -1.071382314127799e-01, -1.088690135027248e-01,
    -1.099969655786929e-01, -1.104898474883336e-01, -1.103225838568563e-01, -1.094621746650760e-01,
    -1.078834293141886e-01, -1.055612509762041e-01, -1.024650162703341e-01, -9.857014566194629e-02,
    -9.384684920715425e-02, -8.826309993000785e-02, -8.178792716809512e-02, -7.438785600211463e-02,
    -6.602189797715241e-02, -5.665655641133161e-02, -4.624456893420224e-02, -3.474585776145929e-02,
    -2.211581608120528e-02, -8.310425696208936e-03, 6.717697635290676e-03, 2.300642061077823e-02,
    4.060106462625085e-02, 5.953239090915557e-02, 7.983354189816511e-02, 1.015233140203748e-01, 1.246171387327525e-01,
    1.491152519299797e-01, 1.750067399059861e-01, 2.022699854906251e-01, 2.308655379767671e-01, 2.607365124918583e-01,
    2.918144694729168e-01, 3.240095704645023e-01, 3.572175180786021e-01, 3.913146885756875e-01, 4.261571642320424e-01,
    4.615925445090212e-01, 4.974471592901086e-01, 5.335326819631583e-01, 5.696546730080154e-01, 6.056083823929643e-01,
    6.411830842823245e-01, 6.761653499550255e-01, 7.103400549562944e-01, 7.434943718765665e-01, 7.754281892901473e-01,
    8.059437233154637e-01, 8.348589373399948e-01, 8.620108336276733e-01, 8.872599706865123e-01, 9.104863121445679e-01,
    9.315962496426278e-01, 9.505220861927248e-01, 9.672366712325431e-01, 9.817397501303696e-01, 9.940557180662704e-01,
    1.004247514102417e00, 1.012407428282884e00, 1.018650990561848e00, 1.023118841384460e00, 1.025972450969440e00,
    1.027397523939210e00, 1.027585830688143e00, 1.026738673647482e00, 1.025061777648234e00, 1.022756514615106e00,
    1.020009139549275e00, 1.016996499560845e00, 1.013915946100629e00, 1.011044869639164e00, 1.007773858455400e00,
    1.004848753962734e00, 1.002245009135684e00, 9.999393169239009e-01, 9.979055415627330e-01, 9.961203379971326e-01,
    9.945597525471822e-01, 9.932031606606762e-01, 9.920297273323891e-01, 9.910230654424902e-01, 9.901668953434221e-01,
    9.894488374513719e-01, 9.888556356037892e-01, 9.883778520531268e-01, 9.880051626345804e-01, 9.877295459610343e-01,
    9.875412739766566e-01, 9.874329809802893e-01, 9.873949921033299e-01, 9.874197049003676e-01, 9.874973205882319e-01,
    9.876201238703241e-01, 9.877781920433015e-01, 9.879637979933339e-01, 9.881678007807095e-01, 9.883835200189653e-01,
    9.886022219397892e-01, 9.888182771263505e-01, 9.890247977602895e-01, 9.892178658748239e-01, 9.893923680007577e-01,
    9.895463342815009e-01, 9.896772011542693e-01, 9.897859195209235e-01, 9.898725363809847e-01, 9.899410789223559e-01,
    9.899945557067980e-01, 9.900394023736973e-01, 9.900814722948890e-01, 9.901293790312005e-01, 9.901902265696609e-01,
    9.902734448815004e-01, 9.903862280081246e-01, 9.905379830873822e-01, 9.907348826312993e-01, 9.909842592301273e-01,
    9.912905118607647e-01, 9.916586940166509e-01, 9.920906151219310e-01, 9.925887208794144e-01, 9.931516528513824e-01,
    9.937790866568735e-01, 9.944668184371617e-01, 9.952116634297566e-01, 9.960068616185641e-01, 9.968461329825753e-01,
    9.977203369515556e-01, 9.986213520769593e-01, 9.995382582242990e-01, 1.000461955079660e00, 1.001380551217109e00,
    1.002284871786226e00, 1.003163845364970e00, 1.004009147462043e00, 1.004811375053364e00, 1.005563968008037e00,
    1.006259855360867e00, 1.006895570408563e00, 1.007466616298057e00, 1.007972441990187e00, 1.008411468616852e00,
    1.008786009787269e00, 1.009097763850333e00, 1.009351762546296e00, 1.009552401900961e00, 1.009707093778162e00,
    1.009822090220407e00, 1.009906958448099e00, 1.009969021400474e00, 1.010017890428877e00, 1.010060809299530e00,
    1.010106564965965e00, 1.010161131093372e00, 1.010231078494249e00, 1.010319484524512e00, 1.010430470494512e00,
    1.010564099281000e00, 1.010721360243234e00, 1.010899655674578e00, 1.011096993993037e00, 1.011308167670753e00,
    1.011529185153809e00, 1.011753008569803e00, 1.011973876511603e00, 1.012182837094955e00, 1.012373028737774e00,
    1.012535058602453e00, 1.012660975529858e00, 1.012740575296603e00, 1.012765922449960e00, 1.012726958954961e00,
    1.012615904116265e00, 1.012422888521601e00, 1.012140460211194e00, 1.011758810583150e00, 1.011269960947744e00,
    1.010663676735228e00, 1.009930754807923e00, 1.009058249873833e00, 1.008034308295421e00, 1.006843352506855e00,
    1.005470005637052e00, 1.003894772403371e00, 1.002098854400575e00, 1.000060686758758e00, 9.977600196406868e-01,
    9.951746430061121e-01, 9.922861082472264e-01, 9.890757868707590e-01, 9.847362453480265e-01, 9.798613526271561e-01,
    9.741378617337759e-01, 9.673331975559332e-01, 9.592539757044516e-01, 9.496984081652284e-01, 9.384634163826711e-01,
    9.253567968750328e-01, 9.101986790930605e-01, 8.928338316495705e-01, 8.731437835983047e-01, 8.510420440685049e-01,
    8.264839911291133e-01, 7.994681492797084e-01, 7.700431275216928e-01, 7.383028603058783e-01, 7.043814340356083e-01,
    6.684616478236647e-01, 6.307755329382612e-01, 5.915799587176216e-01, 5.511703155400274e-01, 5.098915423728179e-01,
    4.681017110047964e-01, 4.261772971493010e-01, 3.845172335531009e-01, 3.435228672445613e-01, 3.036004651973099e-01,
    2.651434678028531e-01, 2.285283969438072e-01, 1.941021906320984e-01, 1.621735416384830e-01, 1.330015240938615e-01,
    1.067840430193724e-01, 8.365057236623041e-02, 6.365188111381356e-02, 4.676538412257621e-02, 3.288072750732215e-02,
    2.183057564646270e-02, 1.336381425803019e-02, 6.758124889697787e-03, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N240_10MS: [Scaler; 480] = [
    -3.613496418928369e-04, -7.078546706512391e-04, -1.074443637110903e-03, -1.533478537964509e-03,
    -2.098197727900724e-03, -2.778420871815740e-03, -3.584129920673041e-03, -4.525198076002370e-03,
    -5.609327243712055e-03, -6.843234536105624e-03, -8.233976327300612e-03, -9.785314755557023e-03,
    -1.149880303071551e-02, -1.337713096257934e-02, -1.542181679511618e-02, -1.762979910961727e-02,
    -1.999721557401502e-02, -2.252080561390149e-02, -2.519406300389030e-02, -2.800909464274782e-02,
    -3.095765092956728e-02, -3.402996266948349e-02, -3.721502082245055e-02, -4.050053247568393e-02,
    -4.387219218706189e-02, -4.731768261606175e-02, -5.082325342672667e-02, -5.437166635159518e-02,
    -5.794654834034055e-02, -6.153426201732499e-02, -6.511708163113709e-02, -6.867606753531441e-02,
    -7.219447805250771e-02, -7.565695975592170e-02, -7.904647440788692e-02, -8.234442557322251e-02,
    -8.553324579905185e-02, -8.859705468085925e-02, -9.152091100798199e-02, -9.428847446755965e-02,
    -9.688303623049198e-02, -9.929123258537813e-02, -1.015008467688577e-01, -1.034961241263523e-01,
    -1.052637003544443e-01, -1.067939984687745e-01, -1.080766457616878e-01, -1.090997300590506e-01,
    -1.098524491515805e-01, -1.103242262600913e-01, -1.105084619148789e-01, -1.103977408741932e-01,
    -1.099809851424550e-01, -1.092492774392824e-01, -1.081974227416502e-01, -1.068172142230882e-01,
    -1.050995803285455e-01, -1.030360111111103e-01, -1.006190418791648e-01, -9.784120023411771e-02,
    -9.469304216883027e-02, -9.116452506492527e-02, -8.724644532866996e-02, -8.293043914044632e-02,
    -7.820617483254730e-02, -7.306142427456862e-02, -6.748468182105991e-02, -6.146688124166948e-02,
    -5.499497258200362e-02, -4.805444424454820e-02, -4.063362855701623e-02, -3.272045590229335e-02,
    -2.430122582451853e-02, -1.536329520788766e-02, -5.891434269890659e-03, 4.126595858583295e-03,
    1.470155068746303e-02, 2.584738191459814e-02, 3.757652772246801e-02, 4.989736509080558e-02, 6.282034030592902e-02,
    7.635397728566121e-02, 9.050369257152079e-02, 1.052747118478660e-01, 1.206703467513333e-01, 1.366911019414417e-01,
    1.533343890681390e-01, 1.705954709184399e-01, 1.884686389218322e-01, 2.069449962574092e-01, 2.260093000067393e-01,
    2.456456803467095e-01, 2.658346019332584e-01, 2.865543814049772e-01, 3.077789078889820e-01, 3.294769437072290e-01,
    3.516171481750350e-01, 3.741642373060188e-01, 3.970739591211551e-01, 4.203043046885219e-01, 4.438114799213576e-01,
    4.675442291623012e-01, 4.914498631045615e-01, 5.154735456539700e-01, 5.395557644293222e-01, 5.636399817032525e-01,
    5.876661722564289e-01, 6.115695310143157e-01, 6.352890592874099e-01, 6.587619767809000e-01, 6.819230974423550e-01,
    7.047092819314779e-01, 7.270576699841359e-01, 7.489068963384272e-01, 7.701990187606995e-01, 7.908752989295335e-01,
    8.108788692151807e-01, 8.301579139160681e-01, 8.486643364959733e-01, 8.663548164329093e-01, 8.831896853053627e-01,
    8.991320235484349e-01, 9.141540563656075e-01, 9.282282546151819e-01, 9.413348145272842e-01, 9.534619388400459e-01,
    9.646048250501910e-01, 9.747634827941575e-01, 9.839435385219192e-01, 9.921529097154242e-01, 9.994114730415857e-01,
    1.005746084650236e00, 1.011183971347815e00, 1.015760373791603e00, 1.019515072412387e00, 1.022490937034641e00,
    1.024736164069697e00, 1.026304095700693e00, 1.027250978292214e00, 1.027634294456205e00, 1.027511063644843e00,
    1.026942795115598e00, 1.025991493983836e00, 1.024716149969084e00, 1.023175976163407e00, 1.021427210603284e00,
    1.019521566634239e00, 1.017510118327508e00, 1.015439859549357e00, 1.013460916839174e00, 1.011654901040475e00,
    1.009366925499550e00, 1.007263182132894e00, 1.005313192386866e00, 1.003508162416449e00, 1.001840787319378e00,
    1.000303927234380e00, 9.988898206257559e-01, 9.975915283480670e-01, 9.964015284765968e-01, 9.953133902427869e-01,
    9.943201078053212e-01, 9.934158959186011e-01, 9.925943919208190e-01, 9.918510277326026e-01, 9.911797988363887e-01,
    9.905771957917731e-01, 9.900381047643838e-01, 9.895594394179152e-01, 9.891371616557014e-01, 9.887684373604154e-01,
    9.884497924570929e-01, 9.881790747212391e-01, 9.879528358230726e-01, 9.877691368590689e-01, 9.876249269174586e-01,
    9.875179947346887e-01, 9.874458127312921e-01, 9.874056275509585e-01, 9.873951115886979e-01, 9.874115368168944e-01,
    9.874524849192456e-01, 9.875149888347144e-01, 9.875968894760857e-01, 9.876951134084213e-01, 9.878075819424549e-01,
    9.879311998177238e-01, 9.880640617030884e-01, 9.882032571565917e-01, 9.883471084085503e-01, 9.884926873551375e-01,
    9.886386592120545e-01, 9.887825578295630e-01, 9.889230031022089e-01, 9.890581715933395e-01, 9.891867674284610e-01,
    9.893074965384659e-01, 9.894196399062921e-01, 9.895220757174378e-01, 9.896146331889107e-01, 9.896970346678272e-01,
    9.897692596535289e-01, 9.898319269347060e-01, 9.898852572653667e-01, 9.899307640365727e-01, 9.899693102025343e-01,
    9.900025692522435e-01, 9.900321562263099e-01, 9.900603352632121e-01, 9.900889812894406e-01, 9.901206586012907e-01,
    9.901575015155720e-01, 9.902023946214220e-01, 9.902575406142213e-01, 9.903255289051605e-01, 9.904087914462694e-01,
    9.905096491583045e-01, 9.906303787150326e-01, 9.907727108894024e-01, 9.909387444078919e-01, 9.911298894709990e-01,
    9.913476318763218e-01, 9.915928560402563e-01, 9.918665491182922e-01, 9.921691315380984e-01, 9.925010851461232e-01,
    9.928619727154252e-01, 9.932519181564613e-01, 9.936700207375173e-01, 9.941156069136238e-01, 9.945873147903244e-01,
    9.950837402063278e-01, 9.956033775539884e-01, 9.961439922621166e-01, 9.967034533921340e-01, 9.972793109558521e-01,
    9.978690858367024e-01, 9.984697087896268e-01, 9.990784840729244e-01, 9.996919011206490e-01, 1.000308193833526e00,
    1.000922365901945e00, 1.001532636590676e00, 1.002135464655177e00, 1.002728111386909e00, 1.003307449770187e00,
    1.003870934089686e00, 1.004416038098237e00, 1.004940548815171e00, 1.005442141810160e00, 1.005919224127911e00,
    1.006370303149314e00, 1.006793927824538e00, 1.007189345025525e00, 1.007555573455895e00, 1.007892674961336e00,
    1.008200146369426e00, 1.008478423284851e00, 1.008727884997619e00, 1.008949493525753e00, 1.009144112734761e00,
    1.009313224929575e00, 1.009458241425143e00, 1.009581280555682e00, 1.009684090687164e00, 1.009768980817384e00,
    1.009838308708799e00, 1.009894548257807e00, 1.009940336228694e00, 1.009977916643680e00, 1.010010230290263e00,
    1.010039453539107e00, 1.010068202038694e00, 1.010098388689342e00, 1.010132323996401e00, 1.010171656775640e00,
    1.010218096148412e00, 1.010272524848519e00, 1.010336490294771e00, 1.010410221483215e00, 1.010494354532353e00,
    1.010588873699422e00, 1.010693501186928e00, 1.010808068774316e00, 1.010931436739342e00, 1.011062876503041e00,
    1.011201071127927e00, 1.011344700694417e00, 1.011491904228184e00, 1.011641272406023e00, 1.011790282474963e00,
    1.011937567254485e00, 1.012080125934687e00, 1.012216235487353e00, 1.012342907951334e00, 1.012458183122033e00,
    1.012558879696851e00, 1.012642857380847e00, 1.012706955800289e00, 1.012748952907404e00, 1.012765799894453e00,
    1.012755013843985e00, 1.012713798678211e00, 1.012639775003457e00, 1.012530134411619e00, 1.012382309473470e00,
    1.012194068117524e00, 1.011962331100864e00, 1.011685173724601e00, 1.011359143572147e00, 1.010982135506986e00,
    1.010550715971368e00, 1.010062133151922e00, 1.009512438049510e00, 1.008898689394160e00, 1.008215923600973e00,
    1.007460860286395e00, 1.006627741823389e00, 1.005712337656749e00, 1.004708677491086e00, 1.003611467285588e00,
    1.002414286392268e00, 1.001111413242302e00, 9.996961651093181e-01, 9.981625949525345e-01, 9.965041017623596e-01,
    9.947148884277037e-01, 9.927891912841345e-01, 9.907199995730845e-01, 9.884793707533194e-01, 9.855347660016696e-01,
    9.823765865983286e-01, 9.789747333404933e-01, 9.751623811486372e-01, 9.708821747608998e-01, 9.660805524695870e-01,
    9.606976399184645e-01, 9.546732976073706e-01, 9.479479345282376e-01, 9.404609052933396e-01, 9.321553861564006e-01,
    9.229775478442888e-01, 9.128745354570823e-01, 9.018003682081348e-01, 8.897163275605041e-01, 8.765908974996186e-01,
    8.623984077953557e-01, 8.471200801854385e-01, 8.307479727020245e-01, 8.132817365236141e-01, 7.947291447585267e-01,
    7.751108841891807e-01, 7.544551974836834e-01, 7.327963552921717e-01, 7.101790843209148e-01, 6.866580716267418e-01,
    6.622962432368731e-01, 6.371684119604742e-01, 6.113488038789190e-01, 5.849206604934815e-01, 5.579747428663487e-01,
    5.306181649316717e-01, 5.029523957059122e-01, 4.750868825511614e-01, 4.471309850999535e-01, 4.192049917945288e-01,
    3.914252910998820e-01, 3.639114681156252e-01, 3.367837772954476e-01, 3.101627843160973e-01, 2.841647033392418e-01,
    2.589033711808454e-01, 2.344880603710975e-01, 2.110209448747974e-01, 1.885997642296488e-01, 1.673100807904834e-01,
    1.472287968327706e-01, 1.284223074167396e-01, 1.109422548710344e-01, 9.482665349502306e-02, 8.009914366829558e-02,
    6.676765847398403e-02, 5.482436608328485e-02, 4.424588851571281e-02, 3.499361000717621e-02, 2.701461405056267e-02,
    2.024370180670145e-02, 1.460796755137538e-02, 9.996743588367531e-03, 5.305235098871444e-03, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N320_10MS: [Scaler; 640] = [
    -3.021153494057143e-04, -5.867737487939294e-04, -8.366504004139796e-04, -1.126635355725494e-03,
    -1.470492941694331e-03, -1.873473391018495e-03, -2.339292362082021e-03, -2.872008069419264e-03,
    -3.476256385086407e-03, -4.155963816705528e-03, -4.914563787665504e-03, -5.755172503953251e-03,
    -6.680623380533122e-03, -7.693816924650567e-03, -8.796760749750191e-03, -9.990503073705982e-03,
    -1.127574117138621e-02, -1.265334152129685e-02, -1.412438986522702e-02, -1.568889620430290e-02,
    -1.734512089366117e-02, -1.909097368362797e-02, -2.092546711168754e-02, -2.284684792818856e-02,
    -2.485207716234951e-02, -2.693746704328349e-02, -2.909952486193999e-02, -3.133504629493832e-02,
    -3.363960728361352e-02, -3.600820974457969e-02, -3.843601741746971e-02, -4.091746034850161e-02,
    -4.344654894948344e-02, -4.601786724624048e-02, -4.862598509282497e-02, -5.126474204655663e-02,
    -5.392644753556616e-02, -5.660384311081047e-02, -5.929116747072080e-02, -6.198268202511926e-02,
    -6.467025548071184e-02, -6.734542216184526e-02, -7.000099017198280e-02, -7.263057011354321e-02,
    -7.522784961377151e-02, -7.778525942347714e-02, -8.029480247839878e-02, -8.274924535373614e-02,
    -8.514125464087215e-02, -8.746379123238275e-02, -8.971069341834263e-02, -9.187564084638347e-02,
    -9.395176975347193e-02, -9.593137735886889e-02, -9.780843257659243e-02, -9.957851303827886e-02,
    -1.012361165314596e-01, -1.027741036495644e-01, -1.041861222641119e-01, -1.054680247057000e-01,
    -1.066160875985523e-01, -1.076255384835563e-01, -1.084912299471198e-01, -1.092087422379003e-01,
    -1.097736146613313e-01, -1.101808861640070e-01, -1.104271876052675e-01, -1.105108362290460e-01,
    -1.104281465492726e-01, -1.101739218186236e-01, -1.097437360338336e-01, -1.091353125572511e-01,
    -1.083467335729228e-01, -1.073739938306107e-01, -1.062130155324388e-01, -1.048606145834788e-01,
    -1.033132401525343e-01, -1.015673163469357e-01, -9.962005506126154e-02, -9.746803229469267e-02,
    -9.510723623306666e-02, -9.253303383231506e-02, -8.974125216128212e-02, -8.672877689119252e-02,
    -8.349213839083708e-02, -8.002639902061687e-02, -7.632679536516856e-02, -7.238806162166744e-02,
    -6.820576796149519e-02, -6.377611429172260e-02, -5.909386001558149e-02, -5.415316322402774e-02,
    -4.894812724598650e-02, -4.347347112195197e-02, -3.772461300253332e-02, -3.169587609244436e-02,
    -2.538179830690266e-02, -1.877689096555516e-02, -1.187461378850388e-02, -4.669099247423082e-03,
    2.844096748870385e-03, 1.066976124794342e-02, 1.881355950582949e-02, 2.728156010437695e-02, 3.607810469851272e-02,
    4.520702759803914e-02, 5.467238802204326e-02, 6.447866054615346e-02, 7.462862199422061e-02, 8.512490568723846e-02,
    9.596983987496970e-02, 1.071650779014335e-01, 1.187115850305241e-01, 1.306101067250375e-01, 1.428596447589721e-01,
    1.554584725339102e-01, 1.684041609371527e-01, 1.816947894623263e-01, 1.953273880886783e-01, 2.092963206850239e-01,
    2.235945635254679e-01, 2.382160219461597e-01, 2.531529721334063e-01, 2.683961570569586e-01, 2.839361392493072e-01,
    2.997624255177811e-01, 3.158619077906196e-01, 3.322210551086769e-01, 3.488264676990591e-01, 3.656640377499646e-01,
    3.827152968157059e-01, 3.999611859760947e-01, 4.173843265025887e-01, 4.349669624916473e-01, 4.526876397402144e-01,
    4.705242008503956e-01, 4.884539254831315e-01, 5.064545550235134e-01, 5.245006748662190e-01, 5.425674372882107e-01,
    5.606312044701524e-01, 5.786672646386708e-01, 5.966477035050948e-01, 6.145458904162185e-01, 6.323361944662236e-01,
    6.499926319211774e-01, 6.674874032292857e-01, 6.847932667399612e-01, 7.018835463513400e-01, 7.187322544823347e-01,
    7.353128213893310e-01, 7.516001985652684e-01, 7.675699252273948e-01, 7.831974571624924e-01, 7.984583859818390e-01,
    8.133295347030278e-01, 8.277892271515950e-01, 8.418178561101360e-01, 8.553961300139363e-01, 8.685068980898102e-01,
    8.811334436653052e-01, 8.932596784799233e-01, 9.048748835980528e-01, 9.159657608120536e-01, 9.265215299450000e-01,
    9.365339988633418e-01, 9.459977028429117e-01, 9.549088408436811e-01, 9.632658122557368e-01, 9.710688896122810e-01,
    9.783204156360773e-01, 9.850226760127131e-01, 9.911792082081333e-01, 9.967989944502682e-01, 1.001894024615659e00,
    1.006474342231823e00, 1.010552057109195e00, 1.014142538208007e00, 1.017262593268930e00, 1.019928842669923e00,
    1.022159867011177e00, 1.023976320927187e00, 1.025400734608122e00, 1.026455340400072e00, 1.027164510654160e00,
    1.027552729180790e00, 1.027644462380432e00, 1.027463246660797e00, 1.027035903410657e00, 1.026389068000259e00,
    1.025548201799728e00, 1.024537134749709e00, 1.023380803775376e00, 1.022103695693341e00, 1.020728359657958e00,
    1.019275334687329e00, 1.017765178792830e00, 1.016217355867531e00, 1.014665311686846e00, 1.013249071090664e00,
    1.011948006992127e00, 1.010189090179223e00, 1.008557961167850e00, 1.007011287608451e00, 1.005548764575910e00,
    1.004168417268956e00, 1.002867268893035e00, 1.001641769115897e00, 1.000489068954641e00, 9.994060799749374e-01,
    9.983898865406841e-01, 9.974370849972721e-01, 9.965444836911705e-01, 9.957098545943852e-01, 9.949302413030897e-01,
    9.942024045863540e-01, 9.935241604969254e-01, 9.928930430130044e-01, 9.923068103443909e-01, 9.917633778190438e-01,
    9.912597642374404e-01, 9.907954498484041e-01, 9.903677893656558e-01, 9.899751611066148e-01, 9.896160337369861e-01,
    9.892890160408989e-01, 9.889928511129679e-01, 9.887260333430423e-01, 9.884868721088945e-01, 9.882751039537586e-01,
    9.880892168751595e-01, 9.879277114724612e-01, 9.877898261218510e-01, 9.876743442038471e-01, 9.875807496078497e-01,
    9.875072021876561e-01, 9.874529447589979e-01, 9.874169741527905e-01, 9.873984685207834e-01, 9.873958301311858e-01,
    9.874080027710336e-01, 9.874343401290739e-01, 9.874736235387018e-01, 9.875243137719285e-01, 9.875856201221135e-01,
    9.876563785063032e-01, 9.877358921155149e-01, 9.878225576787804e-01, 9.879150968481590e-01, 9.880132731565830e-01,
    9.881156946084619e-01, 9.882211314188272e-01, 9.883289032519310e-01, 9.884378310018685e-01, 9.885476787868710e-01,
    9.886568414746639e-01, 9.887645868459630e-01, 9.888708540445242e-01, 9.889744320992592e-01, 9.890747269455915e-01,
    9.891710038703801e-01, 9.892631024032380e-01, 9.893507219573624e-01, 9.894330645494204e-01, 9.895096919388534e-01,
    9.895810813422480e-01, 9.896467469067676e-01, 9.897067365020641e-01, 9.897606930400666e-01, 9.898094478563998e-01,
    9.898530133261707e-01, 9.898914705684924e-01, 9.899254194103574e-01, 9.899554202030650e-01, 9.899824494486951e-01,
    9.900065116928948e-01, 9.900284805353695e-01, 9.900497484789281e-01, 9.900709561632662e-01, 9.900928358611601e-01,
    9.901163920607219e-01, 9.901427479709606e-01, 9.901734275350572e-01, 9.902087332329851e-01, 9.902498637985275e-01,
    9.902983686695558e-01, 9.903548501470234e-01, 9.904205084933333e-01, 9.904959297726740e-01, 9.905825150202904e-01,
    9.906812569810133e-01, 9.907922087340426e-01, 9.909165464981378e-01, 9.910550740962871e-01, 9.912084614290896e-01,
    9.913768610980639e-01, 9.915605826937839e-01, 9.917604214872976e-01, 9.919767175562684e-01, 9.922091101818779e-01,
    9.924579135466506e-01, 9.927231225056266e-01, 9.930049538427406e-01, 9.933027281437943e-01, 9.936161084869942e-01,
    9.939453714404443e-01, 9.942895145656371e-01, 9.946481676207727e-01, 9.950203031067961e-01, 9.954058173659507e-01,
    9.958038713694317e-01, 9.962130271017117e-01, 9.966324689957675e-01, 9.970615306490058e-01, 9.974990583293081e-01,
    9.979437430375855e-01, 9.983940572002874e-01, 9.988493116887893e-01, 9.993083430214909e-01, 9.997689221333534e-01,
    1.000231131275969e00, 1.000692135698996e00, 1.001152013920163e00, 1.001608526000461e00, 1.002060493867275e00,
    1.002507212061815e00, 1.002947129400411e00, 1.003378909587027e00, 1.003801368578070e00, 1.004213810320699e00,
    1.004615386562846e00, 1.005004618375781e00, 1.005380628601598e00, 1.005743282364652e00, 1.006091510392348e00,
    1.006424907424988e00, 1.006742427727669e00, 1.007044321511378e00, 1.007330218597112e00, 1.007599401798709e00,
    1.007852064386603e00, 1.008088176165563e00, 1.008308033204578e00, 1.008511247273756e00, 1.008698144207627e00,
    1.008869515256392e00, 1.009025659761512e00, 1.009166718967367e00, 1.009293362609020e00, 1.009406398832440e00,
    1.009507017171120e00, 1.009595264293017e00, 1.009672145744679e00, 1.009739084785160e00, 1.009796675060142e00,
    1.009846137382005e00, 1.009888083631667e00, 1.009924092276850e00, 1.009955384765721e00, 1.009982268770147e00,
    1.010006298177305e00, 1.010028618428735e00, 1.010050254076988e00, 1.010071952131355e00, 1.010094366238073e00,
    1.010118917317053e00, 1.010146497096682e00, 1.010177110711677e00, 1.010211755260102e00, 1.010251003469427e00,
    1.010295468653759e00, 1.010345234996637e00, 1.010400316698172e00, 1.010461564316351e00, 1.010528615445659e00,
    1.010601521285347e00, 1.010679788081867e00, 1.010763905869062e00, 1.010853429760676e00, 1.010947547074519e00,
    1.011045953108263e00, 1.011148486293359e00, 1.011254397791134e00, 1.011363082075863e00, 1.011473302008831e00,
    1.011584996312149e00, 1.011697416504599e00, 1.011808919793469e00, 1.011919264025716e00, 1.012027240794153e00,
    1.012132151631041e00, 1.012232734564333e00, 1.012327560477901e00, 1.012416383754384e00, 1.012497890726292e00,
    1.012570434021054e00, 1.012633295255708e00, 1.012685277016726e00, 1.012725564992284e00, 1.012752577651415e00,
    1.012765062889864e00, 1.012762356719162e00, 1.012743376077777e00, 1.012706484200181e00, 1.012650842226435e00,
    1.012575427778520e00, 1.012479473490919e00, 1.012361105121003e00, 1.012219809594718e00, 1.012054359992419e00,
    1.011864000215460e00, 1.011647223869087e00, 1.011402518267713e00, 1.011129654652857e00, 1.010826951260377e00,
    1.010492924436361e00, 1.010126353960416e00, 1.009725892479312e00, 1.009290060983833e00, 1.008817301052548e00,
    1.008305027555130e00, 1.007752833675443e00, 1.007157827358150e00, 1.006518049344503e00, 1.005831403532018e00,
    1.005095592119373e00, 1.004308630055050e00, 1.003467498305776e00, 1.002569500413888e00, 1.001612710105563e00,
    1.000594272975683e00, 9.995111701168786e-01, 9.983609218719522e-01, 9.971409288327860e-01, 9.958488863050556e-01,
    9.944818543153893e-01, 9.930375282832211e-01, 9.915146560759479e-01, 9.899136802423638e-01, 9.881930623810997e-01,
    9.859422591203311e-01, 9.835667898378924e-01, 9.811423034808365e-01, 9.785214441250228e-01, 9.756636036109838e-01,
    9.725453442532574e-01, 9.691456634185092e-01, 9.654406178310209e-01, 9.614043615076308e-01, 9.570113065179300e-01,
    9.522367669696690e-01, 9.470548839544214e-01, 9.414403740008491e-01, 9.353691612846549e-01, 9.288190093977164e-01,
    9.217662887169115e-01, 9.141896283466009e-01, 9.060694681113471e-01, 8.973891675497357e-01, 8.881332000806269e-01,
    8.782893885841422e-01, 8.678469565343039e-01, 8.567970644671067e-01, 8.451334654019180e-01, 8.328542805780399e-01,
    8.199594783897041e-01, 8.064511006873497e-01, 7.923346478686025e-01, 7.776204488292163e-01, 7.623206183595970e-01,
    7.464486491227057e-01, 7.300205729992958e-01, 7.130567383226717e-01, 6.955805444755916e-01, 6.776173229836567e-01,
    6.591955305148172e-01, 6.403486426892321e-01, 6.211072197441818e-01, 6.015049275244730e-01, 5.815787608870452e-01,
    5.613674511156324e-01, 5.409188627354076e-01, 5.202736834971303e-01, 4.994780733459294e-01, 4.785774177949064e-01,
    4.576172599874928e-01, 4.366490208265804e-01, 4.157221460415995e-01, 3.948856590950757e-01, 3.741903189229770e-01,
    3.536868899553974e-01, 3.334260017756462e-01, 3.134586473252229e-01, 2.938337904395871e-01, 2.745992637590817e-01,
    2.558030636168172e-01, 2.374902188466697e-01, 2.197036032185785e-01, 2.024855415115456e-01, 1.858749915117319e-01,
    1.699067802117410e-01, 1.546132267478873e-01, 1.400238206749695e-01, 1.261637395672913e-01, 1.130534434072719e-01,
    1.007084973747940e-01, 8.914024389873081e-02, 7.835612100141792e-02, 6.835821233920988e-02, 5.914211536028976e-02,
    5.069893012340832e-02, 4.301717763585550e-02, 3.608020726673359e-02, 2.986316337017630e-02, 2.433722657129812e-02,
    1.947675241971700e-02, 1.525710171255895e-02, 1.163787492636240e-02, 8.433087782643718e-03, 4.449668997344735e-03,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N480_10MS: [Scaler; 960] = [
    -2.353032150516754e-04, -4.619898752628163e-04, -6.262931535610879e-04, -7.929180432976445e-04,
    -9.747166718929050e-04, -1.180256894474562e-03, -1.409209039594871e-03, -1.664473096973725e-03,
    -1.946591608170231e-03, -2.257081732588478e-03, -2.597106916737789e-03, -2.967607624839524e-03,
    -3.370454877988472e-03, -3.806285163352241e-03, -4.276873767639064e-03, -4.782469904501813e-03,
    -5.324608721716763e-03, -5.903403814095400e-03, -6.520419726599805e-03, -7.175885277771099e-03,
    -7.871422820642307e-03, -8.606586039759667e-03, -9.382480860899108e-03, -1.019827182163307e-02,
    -1.105520547739066e-02, -1.195270300743193e-02, -1.289205910303846e-02, -1.387263484323160e-02,
    -1.489528159506296e-02, -1.595856621933800e-02, -1.706288556735433e-02, -1.820666399965468e-02,
    -1.939065975232718e-02, -2.061355417582714e-02, -2.187570925786862e-02, -2.317526315266411e-02,
    -2.451227449041489e-02, -2.588471937157619e-02, -2.729263737090799e-02, -2.873390902713615e-02,
    -3.020862738245264e-02, -3.171440372994384e-02, -3.325098858986303e-02, -3.481597793538342e-02,
    -3.640892406933019e-02, -3.802742318209150e-02, -3.967067992672979e-02, -4.133575417353826e-02,
    -4.302203371734278e-02, -4.472698045914417e-02, -4.645022292934329e-02, -4.818891490266687e-02,
    -4.994225863256500e-02, -5.170690802826666e-02, -5.348162036097223e-02, -5.526334794593565e-02,
    -5.705123152423822e-02, -5.884271749745559e-02, -6.063717235243996e-02, -6.243104027829089e-02,
    -6.422303545004304e-02, -6.600961519440657e-02, -6.778962269634495e-02, -6.955996868581379e-02,
    -7.131966266443390e-02, -7.306581273272733e-02, -7.479758913001458e-02, -7.651178225890490e-02,
    -7.820711420768856e-02, -7.988010693411644e-02, -8.152964005319532e-02, -8.315237353264004e-02,
    -8.474728946770714e-02, -8.631137544905677e-02, -8.784374452959058e-02, -8.934164364321417e-02,
    -9.080411291245728e-02, -9.222795761428432e-02, -9.361232867223340e-02, -9.495377758870335e-02,
    -9.625155313139856e-02, -9.750284620437569e-02, -9.870736514214426e-02, -9.986271288271026e-02,
    -1.009680221406219e-01, -1.020202684361974e-01, -1.030183804850491e-01, -1.039596356759290e-01,
    -1.048438825017798e-01, -1.056686838192766e-01, -1.064342821660323e-01, -1.071382314127799e-01,
    -1.077799961121537e-01, -1.083570625865931e-01, -1.088690135027248e-01, -1.093135588677235e-01,
    -1.096903559498340e-01, -1.099969655786929e-01, -1.102332261219973e-01, -1.103972812085189e-01,
    -1.104898474883336e-01, -1.105086416532167e-01, -1.104537426996073e-01, -1.103225838568563e-01,
    -1.101145827722143e-01, -1.098276928170364e-01, -1.094621746650760e-01, -1.090163960055733e-01,
    -1.084908852561722e-01, -1.078834293141886e-01, -1.071937180231978e-01, -1.064196358069465e-01,
    -1.055612509762041e-01, -1.046162812518618e-01, -1.035849043557610e-01, -1.024650162703341e-01,
    -1.012568997532046e-01, -9.995864571932928e-02, -9.857014566194627e-02, -9.708911135857967e-02,
    -9.551545820689084e-02, -9.384684920715425e-02, -9.208300062891550e-02, -9.022171021406450e-02,
    -8.826309993000785e-02, -8.620493821803937e-02, -8.404742152815330e-02, -8.178792716809512e-02,
    -7.942625026703617e-02, -7.695980775819990e-02, -7.438785600211463e-02, -7.170797002873608e-02,
    -6.891994783815969e-02, -6.602189797715241e-02, -6.301349420724424e-02, -5.989191912667712e-02,
    -5.665655641133161e-02, -5.330406164482222e-02, -4.983427241976235e-02, -4.624456893420224e-02,
    -4.253455686336916e-02, -3.870195772538443e-02, -3.474585776145929e-02, -3.066341518682682e-02,
    -2.645425077642105e-02, -2.211581608120528e-02, -1.764740541599136e-02, -1.304581363895818e-02,
    -8.310425696208936e-03, -3.438268661133170e-03, 1.570315476576933e-03, 6.717697635290676e-03,
    1.200477020244778e-02, 1.743398319747869e-02, 2.300642061077823e-02, 2.872481423270595e-02, 3.458896350634671e-02,
    4.060106462625085e-02, 4.676102915752826e-02, 5.307133911821893e-02, 5.953239090915557e-02, 6.614647812869151e-02,
    7.291293184312803e-02, 7.983354189816511e-02, 8.690807412770696e-02, 9.413813765275064e-02, 1.015233140203748e-01,
    1.090651518336202e-01, 1.167626546016197e-01, 1.246171387327525e-01, 1.326272948938113e-01, 1.407938190608664e-01,
    1.491152519299797e-01, 1.575921408388593e-01, 1.662224799248571e-01, 1.750067399059861e-01, 1.839431938620024e-01,
    1.930318183054904e-01, 2.022699854906251e-01, 2.116567430906184e-01, 2.211888523410642e-01, 2.308655379767671e-01,
    2.406837992341654e-01, 2.506420640291662e-01, 2.607365124918583e-01, 2.709659073501196e-01, 2.813259021832532e-01,
    2.918144694729168e-01, 3.024270279840051e-01, 3.131603499997996e-01, 3.240095704645023e-01, 3.349719592361666e-01,
    3.460422935204829e-01, 3.572175180786021e-01, 3.684915649120530e-01, 3.798595119591716e-01, 3.913146885756875e-01,
    4.028532873867052e-01, 4.144688328137527e-01, 4.261571642320424e-01, 4.379113897565727e-01, 4.497256320417501e-01,
    4.615925445090212e-01, 4.735067030065239e-01, 4.854600184866710e-01, 4.974471592901086e-01, 5.094597228333853e-01,
    5.214909841729947e-01, 5.335326819631583e-01, 5.455789811615239e-01, 5.576217157959890e-01, 5.696546730080154e-01,
    5.816685576268035e-01, 5.936560624526468e-01, 6.056083823929643e-01, 6.175192060085208e-01, 6.293796611336280e-01,
    6.411830842823245e-01, 6.529203544876097e-01, 6.645840786371451e-01, 6.761653499550255e-01, 6.876573952173626e-01,
    6.990511539119996e-01, 7.103400549562944e-01, 7.215149331458728e-01, 7.325691772738999e-01, 7.434943718765665e-01,
    7.542846327442048e-01, 7.649313654540612e-01, 7.754281892901473e-01, 7.857670170752049e-01, 7.959414651061612e-01,
    8.059437233154637e-01, 8.157687070715176e-01, 8.254086223972127e-01, 8.348589373399948e-01, 8.441125827416620e-01,
    8.531651194538425e-01, 8.620108336276733e-01, 8.706456337542150e-01, 8.790631561061171e-01, 8.872599706865123e-01,
    8.952313288619367e-01, 9.029751680353524e-01, 9.104863121445679e-01, 9.177625550620636e-01, 9.247997426966093e-01,
    9.315962496426278e-01, 9.381494858921667e-01, 9.444588390359354e-01, 9.505220861927248e-01, 9.563402921286364e-01,
    9.619114522936701e-01, 9.672366712325431e-01, 9.723156637834687e-01, 9.771501187120180e-01, 9.817397501303696e-01,
    9.860865871353246e-01, 9.901906380163595e-01, 9.940557180662704e-01, 9.976842395284637e-01, 1.001080961257010e00,
    1.004247514102417e00, 1.007188578458507e00, 1.009906654565108e00, 1.012407428282884e00, 1.014694702432600e00,
    1.016774659209400e00, 1.018650990561848e00, 1.020330464463111e00, 1.021817328911793e00, 1.023118841384460e00,
    1.024240262467000e00, 1.025189721888128e00, 1.025972450969440e00, 1.026596938589443e00, 1.027069179375841e00,
    1.027397523939210e00, 1.027587902203109e00, 1.027648951922701e00, 1.027585830688143e00, 1.027408519661012e00,
    1.027122986826984e00, 1.026738673647482e00, 1.026261663878092e00, 1.025701002415063e00, 1.025061777648234e00,
    1.024353980976701e00, 1.023582385618774e00, 1.022756514615106e00, 1.021880604350422e00, 1.020963871317665e00,
    1.020009139549275e00, 1.019027285501251e00, 1.018019442784231e00, 1.016996499560845e00, 1.015957433206324e00,
    1.014923441259795e00, 1.013915946100629e00, 1.013047565149327e00, 1.012216130365610e00, 1.011044869639164e00,
    1.009914592130044e00, 1.008824888092573e00, 1.007773858455400e00, 1.006761700412993e00, 1.005786648810854e00,
    1.004848753962734e00, 1.003946083413733e00, 1.003078846506546e00, 1.002245009135684e00, 1.001444733905817e00,
    1.000676188436651e00, 9.999393169239009e-01, 9.992320848298057e-01, 9.985548127155425e-01, 9.979055415627330e-01,
    9.972842679758880e-01, 9.966890948441745e-01, 9.961203379971326e-01, 9.955761256313581e-01, 9.950565724564597e-01,
    9.945597525471822e-01, 9.940860378486615e-01, 9.936337788972491e-01, 9.932031606606759e-01, 9.927921871265732e-01,
    9.924015177880798e-01, 9.920297273323891e-01, 9.916767775088281e-01, 9.913408767719142e-01, 9.910230654424902e-01,
    9.907216425865902e-01, 9.904366799536263e-01, 9.901668953434221e-01, 9.899131011580791e-01, 9.896735637374597e-01,
    9.894488374513719e-01, 9.892374835404283e-01, 9.890401927796704e-01, 9.888556356037892e-01, 9.886843467692753e-01,
    9.885247606051014e-01, 9.883778520531268e-01, 9.882423270582524e-01, 9.881185638915363e-01, 9.880051626345804e-01,
    9.879032023766432e-01, 9.878111744348976e-01, 9.877295459610343e-01, 9.876571983429736e-01, 9.875949843246187e-01,
    9.875412739766566e-01, 9.874969061399389e-01, 9.874606249127551e-01, 9.874329809802893e-01, 9.874126414437681e-01,
    9.874004750404033e-01, 9.873949921033299e-01, 9.873969162747074e-01, 9.874049060317581e-01, 9.874197049003676e-01,
    9.874399717110517e-01, 9.874663281231737e-01, 9.874973205882319e-01, 9.875338926695315e-01, 9.875746535410983e-01,
    9.876201238703241e-01, 9.876689801932402e-01, 9.877221556193183e-01, 9.877781920433015e-01, 9.878376489591358e-01,
    9.878991990245439e-01, 9.879637979933339e-01, 9.880300303653743e-01, 9.880984675859855e-01, 9.881678007807095e-01,
    9.882390300097154e-01, 9.883107693992456e-01, 9.883835200189653e-01, 9.884560159878955e-01, 9.885294200392185e-01,
    9.886022219397892e-01, 9.886749404176028e-01, 9.887466261142505e-01, 9.888182771263505e-01, 9.888882480852147e-01,
    9.889574384705896e-01, 9.890247977602895e-01, 9.890911247701029e-01, 9.891551701556196e-01, 9.892178658748239e-01,
    9.892779555818088e-01, 9.893365186903538e-01, 9.893923680007577e-01, 9.894462830852175e-01, 9.894972124952000e-01,
    9.895463342815009e-01, 9.895923617530382e-01, 9.896362652966239e-01, 9.896772011542693e-01, 9.897162195263046e-01,
    9.897520286480039e-01, 9.897859195209235e-01, 9.898170267411330e-01, 9.898462068764986e-01, 9.898725363809847e-01,
    9.898975138787787e-01, 9.899200050208486e-01, 9.899410789223559e-01, 9.899600605054418e-01, 9.899782261038060e-01,
    9.899945557067980e-01, 9.900103500807507e-01, 9.900248320990181e-01, 9.900394023736973e-01, 9.900532105829365e-01,
    9.900674746047259e-01, 9.900814722948890e-01, 9.900966926051257e-01, 9.901122448734595e-01, 9.901293790312005e-01,
    9.901474648912307e-01, 9.901680598867444e-01, 9.901902265696609e-01, 9.902151896501201e-01, 9.902424418296485e-01,
    9.902734448815004e-01, 9.903071270768942e-01, 9.903448913950654e-01, 9.903862280081246e-01, 9.904324484666853e-01,
    9.904825650601110e-01, 9.905379830873822e-01, 9.905980602136440e-01, 9.906640366554630e-01, 9.907348826312993e-01,
    9.908120376822228e-01, 9.908947858311721e-01, 9.909842592301273e-01, 9.910795247770178e-01, 9.911819240108124e-01,
    9.912905118607647e-01, 9.914064705361564e-01, 9.915288011543961e-01, 9.916586940166509e-01, 9.917952720685562e-01,
    9.919396217291009e-01, 9.920906151219310e-01, 9.922495028313456e-01, 9.924152398352751e-01, 9.925887208794144e-01,
    9.927688708468421e-01, 9.929569112537944e-01, 9.931516528513824e-01, 9.933539244159140e-01, 9.935626893131695e-01,
    9.937790866568735e-01, 9.940016434044485e-01, 9.942312024833810e-01, 9.944668184371617e-01, 9.947093441694513e-01,
    9.949572854565533e-01, 9.952116634297566e-01, 9.954712635321227e-01, 9.957367951478069e-01, 9.960068616185641e-01,
    9.962823025614079e-01, 9.965617986382630e-01, 9.968461329825753e-01, 9.971338271912752e-01, 9.974256691222113e-01,
    9.977203369515556e-01, 9.980185087055744e-01, 9.983185871761977e-01, 9.986213520769593e-01, 9.989255426466267e-01,
    9.992317314100975e-01, 9.995382582242990e-01, 9.998461160718275e-01, 1.000153907612080e00, 1.000461955079660e00,
    1.000768859280338e00, 1.001075613053728e00, 1.001380551217109e00, 1.001684244734497e00, 1.001985425397567e00,
    1.002284871786226e00, 1.002580975161843e00, 1.002874411368430e00, 1.003163845364970e00, 1.003450063374329e00,
    1.003731570287893e00, 1.004009147462043e00, 1.004281457582935e00, 1.004549339226336e00, 1.004811375053364e00,
    1.005068272394360e00, 1.005318795748286e00, 1.005563968008037e00, 1.005802269635282e00, 1.006034554002353e00,
    1.006259855360867e00, 1.006479018139540e00, 1.006690541428116e00, 1.006895570408563e00, 1.007093045696527e00,
    1.007283799246233e00, 1.007466616298057e00, 1.007642728426847e00, 1.007811036585595e00, 1.007972441990187e00,
    1.008125875904472e00, 1.008272602383284e00, 1.008411468616852e00, 1.008543573152632e00, 1.008668018334797e00,
    1.008786009787269e00, 1.008896526233555e00, 1.009000766336071e00, 1.009097763850333e00, 1.009188880897370e00,
    1.009273163797313e00, 1.009351762546296e00, 1.009423944949143e00, 1.009491175244507e00, 1.009552401900961e00,
    1.009608886895764e00, 1.009659973830751e00, 1.009707093778162e00, 1.009749238562067e00, 1.009787744284661e00,
    1.009822090220407e00, 1.009853706282597e00, 1.009881498943010e00, 1.009906958448099e00, 1.009929567021562e00,
    1.009950573483366e00, 1.009969021400474e00, 1.009986499185054e00, 1.010002363879044e00, 1.010017890428877e00,
    1.010032170180360e00, 1.010046722045583e00, 1.010060809299530e00, 1.010075674445289e00, 1.010090449982098e00,
    1.010106564965965e00, 1.010123226584120e00, 1.010141762173145e00, 1.010161131093372e00, 1.010182635897876e00,
    1.010205587931660e00, 1.010231078494249e00, 1.010257950227988e00, 1.010287732968580e00, 1.010319484524512e00,
    1.010354079663767e00, 1.010390635488037e00, 1.010430470494512e00, 1.010472266495074e00, 1.010517096381509e00,
    1.010564099281000e00, 1.010614266894512e00, 1.010666285876455e00, 1.010721360243234e00, 1.010778416755264e00,
    1.010838252644461e00, 1.010899655674578e00, 1.010963729626641e00, 1.011029191301694e00, 1.011096993993037e00,
    1.011165861239173e00, 1.011236610341260e00, 1.011308167670753e00, 1.011381453638912e00, 1.011454785713102e00,
    1.011529185153809e00, 1.011603680910505e00, 1.011678803938046e00, 1.011753008569803e00, 1.011827484797985e00,
    1.011900936547881e00, 1.011973876511603e00, 1.012044885003304e00, 1.012114985644919e00, 1.012182837094955e00,
    1.012249023976742e00, 1.012312095063070e00, 1.012373028737774e00, 1.012430463679316e00, 1.012484972246822e00,
    1.012535058602453e00, 1.012581678169188e00, 1.012623472898504e00, 1.012660975529858e00, 1.012692758750213e00,
    1.012719789201144e00, 1.012740575296603e00, 1.012755753887085e00, 1.012763948841204e00, 1.012765922449960e00,
    1.012760298661069e00, 1.012747819936584e00, 1.012726958954961e00, 1.012698607692183e00, 1.012661400539405e00,
    1.012615904116265e00, 1.012560833005713e00, 1.012497050269805e00, 1.012422888521601e00, 1.012339226241367e00,
    1.012244921966297e00, 1.012140460211194e00, 1.012024302085441e00, 1.011897560567707e00, 1.011758810583150e00,
    1.011608449127642e00, 1.011445162723270e00, 1.011269960947744e00, 1.011081255645969e00, 1.010879608424312e00,
    1.010663676735228e00, 1.010434184200640e00, 1.010189681124657e00, 1.009930754807923e00, 1.009655660215271e00,
    1.009365251564694e00, 1.009058249873833e00, 1.008734758578989e00, 1.008393079963091e00, 1.008034308295421e00,
    1.007656661215973e00, 1.007260142622887e00, 1.006843352506855e00, 1.006407009542103e00, 1.005949145170711e00,
    1.005470005637052e00, 1.004967986424467e00, 1.004443531995945e00, 1.003894772403371e00, 1.003321903663793e00,
    1.002723127308148e00, 1.002098854400575e00, 1.001447278873483e00, 1.000768505317086e00, 1.000060686758758e00,
    9.993242684851855e-01, 9.985573503390627e-01, 9.977600196406868e-01, 9.969306036935497e-01, 9.960694269553644e-01,
    9.951746430061121e-01, 9.942466438407230e-01, 9.932837131068657e-01, 9.922861082472264e-01, 9.912523092989319e-01,
    9.901827419790691e-01, 9.890757868707590e-01, 9.879313024174022e-01, 9.863553220272523e-01, 9.847362453480265e-01,
    9.831750948772566e-01, 9.815583336011345e-01, 9.798613526271561e-01, 9.780617486993630e-01, 9.761574317374303e-01,
    9.741378617337759e-01, 9.719990112065752e-01, 9.697327413658168e-01, 9.673331975559332e-01, 9.647915124057732e-01,
    9.621011497566145e-01, 9.592539757044516e-01, 9.562427177295731e-01, 9.530600909726344e-01, 9.496984081652284e-01,
    9.461498120176854e-01, 9.424071613625743e-01, 9.384634163826711e-01, 9.343112966094085e-01, 9.299449872197452e-01,
    9.253567968750328e-01, 9.205404627076625e-01, 9.154896280575360e-01, 9.101986790930605e-01, 9.046620597741508e-01,
    8.988755194372424e-01, 8.928338316495705e-01, 8.865337190368053e-01, 8.799712722567934e-01, 8.731437835983047e-01,
    8.660476534563131e-01, 8.586812520174252e-01, 8.510420440685049e-01, 8.431297226886574e-01, 8.349435141989714e-01,
    8.264839911291133e-01, 8.177505366573690e-01, 8.087449817124315e-01, 7.994681492797084e-01, 7.899235162194718e-01,
    7.801137731566502e-01, 7.700431275216928e-01, 7.597145736971065e-01, 7.491330971820804e-01, 7.383028603058783e-01,
    7.272298755824693e-01, 7.159201919962611e-01, 7.043814340356083e-01, 6.926196927377140e-01, 6.806438831866077e-01,
    6.684616478236647e-01, 6.560830137986515e-01, 6.435179268559957e-01, 6.307755329382612e-01, 6.178641647786525e-01,
    6.047954625702541e-01, 5.915799587176216e-01, 5.782289366005894e-01, 5.647535885752191e-01, 5.511703155400274e-01,
    5.374905090437071e-01, 5.237263500445715e-01, 5.098915423728255e-01, 4.960008074926423e-01, 4.820662943337458e-01,
    4.681017110048007e-01, 4.541216995958746e-01, 4.401421815729068e-01, 4.261772971493010e-01, 4.122417888542512e-01,
    3.983499612526493e-01, 3.845172335531009e-01, 3.707583717376236e-01, 3.570886786795506e-01, 3.435228672445627e-01,
    3.300763764703638e-01, 3.167640325043893e-01, 3.036004651973109e-01, 2.905996158436682e-01, 2.777758503744847e-01,
    2.651434678028531e-01, 2.527161881181577e-01, 2.405069849650012e-01, 2.285283969438072e-01, 2.167933432162879e-01,
    2.053139897833021e-01, 1.941021906320988e-01, 1.831680872008943e-01, 1.725221947208913e-01, 1.621735416384834e-01,
    1.521320683467849e-01, 1.424052801149985e-01, 1.330015240938615e-01, 1.239260664828526e-01, 1.151858295527293e-01,
    1.067840430193724e-01, 9.872637505002878e-02, 9.101379000888035e-02, 8.365057236623055e-02, 7.663508305536153e-02,
    6.997033405748826e-02, 6.365188111381365e-02, 5.768176015814392e-02, 5.205244216987966e-02, 4.676538412257621e-02,
    4.180950541438362e-02, 3.718640251368464e-02, 3.288072750732215e-02, 2.889548499582958e-02, 2.520980565928884e-02,
    2.183057564646272e-02, 1.872896194002638e-02, 1.592127815153420e-02, 1.336381425803020e-02, 1.108558877807282e-02,
    8.943474189364638e-03, 6.758124889697787e-03, 3.504438130619497e-03, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N60_7P5MS: [Scaler; 120] = [
    2.950608593187313e-03, 7.175411316438510e-03, 1.376953735371754e-02, 2.309535564877266e-02, 3.540362298325999e-02,
    5.082893035710152e-02, 6.946962925951473e-02, 9.138842778133426e-02, 1.166045748296231e-01, 1.450735459839195e-01,
    1.767111740534608e-01, 2.113429529554800e-01, 2.487686144599148e-01, 2.887011017469859e-01, 3.308238711499938e-01,
    3.748145444067251e-01, 4.203080130472308e-01, 4.669049179648736e-01, 5.141853413578332e-01, 5.617100406669413e-01,
    6.090263461524341e-01, 6.556710162134097e-01, 7.012183842298189e-01, 7.452406787622362e-01, 7.873692060484326e-01,
    8.272238334368036e-01, 8.645136750188277e-01, 8.989774146126214e-01, 9.304075179845523e-01, 9.585999373974852e-01,
    9.834477193784226e-01, 1.004882833289021e00, 1.022853807278541e00, 1.037404947967044e00, 1.048597914202596e00,
    1.056561843427440e00, 1.061493706243562e00, 1.063625783716980e00, 1.063259727973876e00, 1.060745048351166e00,
    1.056435897894500e00, 1.050695001011264e00, 1.043924345068839e00, 1.036477246028582e00, 1.028728673666003e00,
    1.021064859918030e00, 1.014006582262175e00, 1.007274550102931e00, 1.001722497437142e00, 9.973095916665831e-01,
    9.939851582601669e-01, 9.916833348089591e-01, 9.903253250249126e-01, 9.898226125376152e-01, 9.900747339893667e-01,
    9.909753143689592e-01, 9.924128512256524e-01, 9.942731493578623e-01, 9.964391574315900e-01, 9.987916157534086e-01,
    1.001209846205687e00, 1.003573567479612e00, 1.005759836364722e00, 1.007645153692818e00, 1.009106872290545e00,
    1.010024764464639e00, 1.010282031682720e00, 1.009769188700535e00, 1.008386412173240e00, 1.006051238984656e00,
    1.002697666156926e00, 9.982804644584213e-01, 9.927779867939798e-01, 9.861868921689572e-01, 9.776341643922554e-01,
    9.674472695701162e-01, 9.551297254161167e-01, 9.403898774115922e-01, 9.229592799642977e-01, 9.026073499372684e-01,
    8.792026885629480e-01, 8.526417497265664e-01, 8.228812716163106e-01, 7.899717151715774e-01, 7.540303276706357e-01,
    7.152557417328465e-01, 6.739369112409073e-01, 6.304147162292445e-01, 5.850788579084674e-01, 5.383985182966198e-01,
    4.908337531732809e-01, 4.428858232573716e-01, 3.950910240537553e-01, 3.480043431985102e-01, 3.021967102409465e-01,
    2.582274305805284e-01, 2.166414164389013e-01, 1.779221215201146e-01, 1.424805471287674e-01, 1.106521943353717e-01,
    8.269959669528287e-02, 5.883345162013132e-02, 3.920308484545646e-02, 2.386291074479415e-02, 1.269762234246248e-02,
    5.356653610215987e-03, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N120_7P5MS: [Scaler; 240] = [
    2.208248743046650e-03, 3.810144195090351e-03, 5.915524734289813e-03, 8.583614568030036e-03, 1.187597226083452e-02,
    1.583353014097089e-02, 2.049186515516006e-02, 2.588835928921542e-02, 3.204158944817544e-02, 3.896167212395468e-02,
    4.667421691393490e-02, 5.518493372761350e-02, 6.450383844383757e-02, 7.464110714806732e-02, 8.560001618878993e-02,
    9.738467025048170e-02, 1.099936025389733e-01, 1.234192774722812e-01, 1.376554565476283e-01, 1.526904374639564e-01,
    1.685133626404965e-01, 1.850931046131430e-01, 2.024104194879864e-01, 2.204503651331880e-01, 2.391679406203077e-01,
    2.585261682883327e-01, 2.784985387736362e-01, 2.990384315995911e-01, 3.201048623655521e-01, 3.416586222430363e-01,
    3.636600340252121e-01, 3.860626951895035e-01, 4.088152724594432e-01, 4.318710458458660e-01, 4.551769877048139e-01,
    4.786765926352632e-01, 5.023248131381035e-01, 5.260609162248473e-01, 5.498312828850233e-01, 5.735768827770059e-01,
    5.972413384410342e-01, 6.207702424193973e-01, 6.440996624336124e-01, 6.671763816763950e-01, 6.899588537658654e-01,
    7.123799800931302e-01, 7.343963718694788e-01, 7.559666880505324e-01, 7.770369811015168e-01, 7.975581136897942e-01,
    8.174908555311138e-01, 8.367969496408532e-01, 8.554473095679163e-01, 8.734007983991156e-01, 8.906357189698083e-01,
    9.071287701238782e-01, 9.228487835702877e-01, 9.377633225341820e-01, 9.518602062527468e-01, 9.651306001536289e-01,
    9.775565405467248e-01, 9.891262086779957e-01, 9.998469191683163e-01, 1.009700729703874e00, 1.018682286908352e00,
    1.026814550859190e00, 1.034089812751720e00, 1.040511956629397e00, 1.046108368522362e00, 1.050885649534276e00,
    1.054862887578656e00, 1.058072205849552e00, 1.060534138670111e00, 1.062276617517642e00, 1.063338150260194e00,
    1.063755566766962e00, 1.063566320618061e00, 1.062821557530121e00, 1.061559958917576e00, 1.059817091581481e00,
    1.057658760384513e00, 1.055120057365395e00, 1.052239850719546e00, 1.049087785713381e00, 1.045698595146235e00,
    1.042108306824389e00, 1.038380985588667e00, 1.034552762539362e00, 1.030671997181282e00, 1.026791666942681e00,
    1.022955584022344e00, 1.019207332137853e00, 1.015872887197225e00, 1.012210174593533e00, 1.008845591036958e00,
    1.005778512486221e00, 1.003002618498964e00, 1.000514601809148e00, 9.983092287560527e-01, 9.963786013745719e-01,
    9.947181322797367e-01, 9.933162157118496e-01, 9.921669569649387e-01, 9.912586027088507e-01, 9.905811038723256e-01,
    9.901231181863754e-01, 9.898737119947000e-01, 9.898187066647253e-01, 9.899468001787191e-01, 9.902431753677082e-01,
    9.906955635514434e-01, 9.912885401035934e-01, 9.920094690635668e-01, 9.928426927501408e-01, 9.937750666306635e-01,
    9.947903979828719e-01, 9.958755336221258e-01, 9.970143670156726e-01, 9.981928706842119e-01, 9.993945064762333e-01,
    1.000605860368296e00, 1.001810400944408e00, 1.002994573682287e00, 1.004141548053574e00, 1.005236884099094e00,
    1.006263925890636e00, 1.007208903587772e00, 1.008054893814649e00, 1.008788016348394e00, 1.009391822060050e00,
    1.009852958217732e00, 1.010155293011166e00, 1.010286018304889e00, 1.010229878703309e00, 1.009975407736885e00,
    1.009508455280294e00, 1.008818483155921e00, 1.007894884001199e00, 1.006728757854175e00, 1.005309913983530e00,
    1.003634560818982e00, 1.001693634792953e00, 9.994856628696702e-01, 9.970063702291652e-01, 9.942546868773952e-01,
    9.912319673936767e-01, 9.879371153343368e-01, 9.843751246861034e-01, 9.798909633127684e-01, 9.752698788428587e-01,
    9.701804980040253e-01, 9.645800268203278e-01, 9.584255335155275e-01, 9.516840138455831e-01, 9.443202322315050e-01,
    9.362906241698766e-01, 9.275805069442316e-01, 9.181534137230351e-01, 9.079765240138057e-01, 8.970500584793123e-01,
    8.853513603848177e-01, 8.728579265043998e-01, 8.595798186504622e-01, 8.455026150386550e-01, 8.306199433014801e-01,
    8.149466481575340e-01, 7.984893775294407e-01, 7.812624496601451e-01, 7.632917692550881e-01, 7.445908434203883e-01,
    7.251992870809165e-01, 7.051536683608545e-01, 6.844905446038185e-01, 6.632452099313783e-01, 6.414771616618185e-01,
    6.192353336355413e-01, 5.965591325427860e-01, 5.735199893648143e-01, 5.501738510234542e-01, 5.265685382300127e-01,
    5.027811586638018e-01, 4.788608890561979e-01, 4.548778943490807e-01, 4.308981228989757e-01, 4.069939642056274e-01,
    3.832340305827807e-01, 3.596800983344559e-01, 3.364081000913040e-01, 3.134964181526467e-01, 2.910105654938709e-01,
    2.690195851087463e-01, 2.475843475618672e-01, 2.267884333851992e-01, 2.066777706538489e-01, 1.873103432384193e-01,
    1.687396441250691e-01, 1.510123820588979e-01, 1.341718422797088e-01, 1.182546623256353e-01, 1.032907339774596e-01,
    8.931173602725516e-02, 7.634297866041775e-02, 6.440772914585903e-02, 5.352437147393933e-02, 4.370844528199230e-02,
    3.496670991534089e-02, 2.729846292648297e-02, 2.068958080348781e-02, 1.511251252352759e-02, 1.052287538118900e-02,
    6.855473143120779e-03, 4.023511190940974e-03, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N180_7P5MS: [Scaler; 360] = [
    1.970849076512990e-03, 2.950608593187313e-03, 4.124477213467950e-03, 5.526886639437362e-03, 7.175411316438510e-03,
    9.087577304291669e-03, 1.128191051703656e-02, 1.376953735371754e-02, 1.656002661605294e-02, 1.966508945492317e-02,
    2.309535564877266e-02, 2.686128938982976e-02, 3.096325597431720e-02, 3.540362298325999e-02, 4.019156101100901e-02,
    4.533314033337320e-02, 5.082893035710152e-02, 5.668154478534839e-02, 6.289353044640154e-02, 6.946962925951473e-02,
    7.641063136809326e-02, 8.371600156519982e-02, 9.138842778133426e-02, 9.942940076792395e-02, 1.078347249723074e-01,
    1.166045748296231e-01, 1.257365027864348e-01, 1.352268113395951e-01, 1.450735459839195e-01, 1.552738186648721e-01,
    1.658221942341435e-01, 1.767111740534608e-01, 1.879287758848813e-01, 1.994731798188807e-01, 2.113429529554800e-01,
    2.235245540318082e-01, 2.360030996517997e-01, 2.487686144599148e-01, 2.618138107489893e-01, 2.751291608544314e-01,
    2.887011017469859e-01, 3.025140336309949e-01, 3.165588052366450e-01, 3.308238711499938e-01, 3.452955666730954e-01,
    3.599639915662127e-01, 3.748145444067251e-01, 3.898318165532388e-01, 4.050010096015846e-01, 4.203080130472308e-01,
    4.357395152859960e-01, 4.512778173547499e-01, 4.669049179648736e-01, 4.826090405673480e-01, 4.983754662664123e-01,
    5.141853413578332e-01, 5.300214783136831e-01, 5.458693517886994e-01, 5.617100406669413e-01, 5.775281514417204e-01,
    5.933046964262578e-01, 6.090263461524341e-01, 6.246741889386914e-01, 6.402275547146322e-01, 6.556710162134097e-01,
    6.709959346439072e-01, 6.861845587972498e-01, 7.012183842298189e-01, 7.160784485622184e-01, 7.307560841550591e-01,
    7.452406787622362e-01, 7.595151215738793e-01, 7.735619554086122e-01, 7.873692060484326e-01, 8.009231377307978e-01,
    8.142113863131932e-01, 8.272238334368036e-01, 8.399523741938065e-01, 8.523861023610134e-01, 8.645136750188277e-01,
    8.763240788355384e-01, 8.878142883924764e-01, 8.989774146126214e-01, 9.098033189281092e-01, 9.202843119253094e-01,
    9.304075179845523e-01, 9.401696522166354e-01, 9.495677949302647e-01, 9.585999373974852e-01, 9.672602600117832e-01,
    9.755451659417252e-01, 9.834477193784226e-01, 9.909719572606611e-01, 9.981192686440387e-01, 1.004882833289021e00,
    1.011257731140136e00, 1.017244362189382e00, 1.022853807278541e00, 1.028087338709125e00, 1.032937063258800e00,
    1.037404947967044e00, 1.041501641198980e00, 1.045232355730946e00, 1.048597914202596e00, 1.051603395002874e00,
    1.054255050268478e00, 1.056561843427440e00, 1.058534002822506e00, 1.060174135407872e00, 1.061493706243562e00,
    1.062499430330238e00, 1.063205771472337e00, 1.063625783716980e00, 1.063764865344437e00, 1.063637778334477e00,
    1.063259727973876e00, 1.062646953245063e00, 1.061804962699513e00, 1.060745048351166e00, 1.059484915739590e00,
    1.058045332777575e00, 1.056435897894500e00, 1.054662178717384e00, 1.052740474459255e00, 1.050695001011264e00,
    1.048538935354313e00, 1.046278982648917e00, 1.043924345068839e00, 1.041495397384132e00, 1.039010026880522e00,
    1.036477246028582e00, 1.033907928361672e00, 1.031319893754215e00, 1.028728673666003e00, 1.026148319362665e00,
    1.023589880840269e00, 1.021064859918030e00, 1.018562619376553e00, 1.016557703375972e00, 1.014006582262175e00,
    1.011629525863078e00, 1.009385901800645e00, 1.007274550102931e00, 1.005296164582239e00, 1.003445259887302e00,
    1.001722497437142e00, 1.000127924463537e00, 9.986575334669062e-01, 9.973095916665831e-01, 9.960835710929218e-01,
    9.949765689814285e-01, 9.939851582601669e-01, 9.931075300522219e-01, 9.923413052310536e-01, 9.916833348089591e-01,
    9.911300696314259e-01, 9.906783251641723e-01, 9.903253250249126e-01, 9.900675621816006e-01, 9.899012818722897e-01,
    9.898226125376152e-01, 9.898278454016073e-01, 9.899132411259368e-01, 9.900747339893667e-01, 9.903082558387314e-01,
    9.906098517881138e-01, 9.909753143689592e-01, 9.914003304461825e-01, 9.918809661701072e-01, 9.924128512256524e-01,
    9.929917790758115e-01, 9.936133813858116e-01, 9.942731493578623e-01, 9.949669577858075e-01, 9.956903701113655e-01,
    9.964391574315900e-01, 9.972085721948355e-01, 9.979942749676792e-01, 9.987916157534086e-01, 9.995960619759856e-01,
    1.000404101255877e00, 1.001209846205687e00, 1.002009756050340e00, 1.002799241686241e00, 1.003573567479612e00,
    1.004328283187225e00, 1.005058501867633e00, 1.005759836364722e00, 1.006427669689071e00, 1.007057682723931e00,
    1.007645153692818e00, 1.008185492117307e00, 1.008674265369618e00, 1.009106872290545e00, 1.009479158919060e00,
    1.009786593319936e00, 1.010024764464639e00, 1.010189538289831e00, 1.010276690684798e00, 1.010282031682720e00,
    1.010201742651156e00, 1.010032080837507e00, 1.009769188700535e00, 1.009409386073207e00, 1.008949310126241e00,
    1.008386412173240e00, 1.007717803066923e00, 1.006940305796912e00, 1.006051238984656e00, 1.005048793283357e00,
    1.003931827630468e00, 1.002697666156926e00, 1.001344271172154e00, 9.998720918990379e-01, 9.982804644584213e-01,
    9.965665691741982e-01, 9.947317370056415e-01, 9.927779867939798e-01, 9.907013741881066e-01, 9.885041652445283e-01,
    9.861868921689572e-01, 9.837119886839835e-01, 9.805846431095010e-01, 9.776341643922554e-01, 9.744550331507363e-01,
    9.710629155613092e-01, 9.674472695701162e-01, 9.635939262874074e-01, 9.594913983473223e-01, 9.551297254161167e-01,
    9.505013259120755e-01, 9.455928103144016e-01, 9.403898774115922e-01, 9.348867604141315e-01, 9.290805587106350e-01,
    9.229592799642976e-01, 9.165095791928667e-01, 9.097244560733702e-01, 9.026073499372684e-01, 8.951550837577193e-01,
    8.873561542082500e-01, 8.792026885629480e-01, 8.706996978416294e-01, 8.618474244579353e-01, 8.526417497265664e-01,
    8.430778332415034e-01, 8.331549046805315e-01, 8.228812716163106e-01, 8.122575969197091e-01, 8.012854392434710e-01,
    7.899717151715774e-01, 7.783181771724644e-01, 7.663377104116385e-01, 7.540303276706357e-01, 7.414079909457567e-01,
    7.284775008035390e-01, 7.152557417328465e-01, 7.017517394571592e-01, 6.879756318118113e-01, 6.739369112409073e-01,
    6.596525732013095e-01, 6.451394890668392e-01, 6.304147162292445e-01, 6.154836219271654e-01, 6.003658519413984e-01,
    5.850788579084674e-01, 5.696495364564049e-01, 5.540848098312343e-01, 5.383985182966198e-01, 5.226147377537511e-01,
    5.067568049662954e-01, 4.908337531732726e-01, 4.748660326525270e-01, 4.588765658108130e-01, 4.428858232573716e-01,
    4.269065392300330e-01, 4.109709733914872e-01, 3.950910240537540e-01, 3.792913270170828e-01, 3.635874169858631e-01,
    3.480043431985094e-01, 3.325632006175457e-01, 3.172874848823412e-01, 3.021967102409465e-01, 2.873094025754711e-01,
    2.726439916003860e-01, 2.582274305805277e-01, 2.440728561740129e-01, 2.302089773823469e-01, 2.166414164389010e-01,
    2.033984806897052e-01, 1.904861615463941e-01, 1.779221215201146e-01, 1.657266744835887e-01, 1.539063966799855e-01,
    1.424805471287671e-01, 1.314539801011583e-01, 1.208417782380949e-01, 1.106521943353716e-01, 1.008917341936222e-01,
    9.157188508647542e-02, 8.269959669528287e-02, 7.428155288862677e-02, 6.632423815331720e-02, 5.883345162013123e-02,
    5.181406762377953e-02, 4.526983455651076e-02, 3.920308484545643e-02, 3.361441594214110e-02, 2.850233081562859e-02,
    2.386291074479415e-02, 1.968942265531783e-02, 1.597205270240860e-02, 1.269762234246247e-02, 9.849377394464552e-03,
    7.407244632998355e-03, 5.356653610215985e-03, 3.832265518746914e-03, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N240_7P5MS: [Scaler; 480] = [
    1.848330370601890e-03, 2.564818394430541e-03, 3.367621175255762e-03, 4.287366172947020e-03, 5.338301429131479e-03,
    6.526792229804446e-03, 7.861125872744963e-03, 9.346281793294168e-03, 1.099168677073023e-02, 1.280111724327587e-02,
    1.478059105262588e-02, 1.693070430750747e-02, 1.925923070409017e-02, 2.176969372101092e-02, 2.446859826144651e-02,
    2.735565427385896e-02, 3.043192302576378e-02, 3.369804639006632e-02, 3.715835772551574e-02, 4.081481795207546e-02,
    4.467080684234739e-02, 4.872629952625619e-02, 5.298206325441551e-02, 5.743824696664848e-02, 6.209685798752235e-02,
    6.696097666085293e-02, 7.202983636789818e-02, 7.730391464771366e-02, 8.278255740953620e-02, 8.846821015931731e-02,
    9.436075664518449e-02, 1.004602720036002e-01, 1.067638237504515e-01, 1.132736794406103e-01, 1.199864202730101e-01,
    1.269035206805856e-01, 1.340208531277774e-01, 1.413395568701277e-01, 1.488572112889720e-01, 1.565736853381255e-01,
    1.644846220563571e-01, 1.725890765381433e-01, 1.808790898204713e-01, 1.893543196006846e-01, 1.980122435284018e-01,
    2.068541409946420e-01, 2.158753187570538e-01, 2.250686723708130e-01, 2.344274072499690e-01, 2.439483137105153e-01,
    2.536279928378056e-01, 2.634640609879333e-01, 2.734504944781370e-01, 2.835821889865098e-01, 2.938534694786572e-01,
    3.042573734615632e-01, 3.147909140113310e-01, 3.254491234269504e-01, 3.362274096618026e-01, 3.471187602907065e-01,
    3.581201769604495e-01, 3.692246633783371e-01, 3.804277928712796e-01, 3.917200227416179e-01, 4.030970221548365e-01,
    4.145519552168687e-01, 4.260817186124239e-01, 4.376763184816823e-01, 4.493301956572350e-01, 4.610348550393067e-01,
    4.727860432828289e-01, 4.845767771787368e-01, 4.964017067665196e-01, 5.082524575564947e-01, 5.201220784839651e-01,
    5.320020770005417e-01, 5.438880897441558e-01, 5.557716011811357e-01, 5.676457387746829e-01, 5.795027863150121e-01,
    5.913350345927856e-01, 6.031383674734400e-01, 6.149041716859808e-01, 6.266239411056014e-01, 6.382888344252021e-01,
    6.498933747767719e-01, 6.614323601501731e-01, 6.729025139063478e-01, 6.842937498334491e-01, 6.956004595358826e-01,
    7.068117836489756e-01, 7.179234245192330e-01, 7.289313857272890e-01, 7.398327727973596e-01, 7.506189823719328e-01,
    7.612840534177552e-01, 7.718189187016244e-01, 7.822209919639922e-01, 7.924813304551203e-01, 8.025994477230463e-01,
    8.125652295019083e-01, 8.223771289200885e-01, 8.320305183749199e-01, 8.415232076745133e-01, 8.508483129483138e-01,
    8.600024117819522e-01, 8.689798808251054e-01, 8.777783467294870e-01, 8.863959039558345e-01, 8.948294207910807e-01,
    9.030776256602892e-01, 9.111326521556180e-01, 9.189935853649371e-01, 9.266529369336567e-01, 9.341114204165168e-01,
    9.413643442928993e-01, 9.484129673709889e-01, 9.552556295973936e-01, 9.618920131378678e-01, 9.683163629086772e-01,
    9.745301563621191e-01, 9.805283381417256e-01, 9.863139277672938e-01, 9.918860486198928e-01, 9.972463447664014e-01,
    1.002391896644578e00, 1.007319464375827e00, 1.012027073435850e00, 1.016516541512393e00, 1.020794302688699e00,
    1.024860815794490e00, 1.028714705809749e00, 1.032351702719174e00, 1.035773750472822e00, 1.038984315074006e00,
    1.041987855398911e00, 1.044785643573356e00, 1.047378184121997e00, 1.049767431495211e00, 1.051954045543143e00,
    1.053942898562160e00, 1.055734631473796e00, 1.057341767323983e00, 1.058757264938716e00, 1.059986744473714e00,
    1.061036716870687e00, 1.061906510844496e00, 1.062603694906377e00, 1.063132893292572e00, 1.063502373941053e00,
    1.063709808061891e00, 1.063763223461893e00, 1.063667646046172e00, 1.063430118187021e00, 1.063056564385666e00,
    1.062554210368898e00, 1.061922346664364e00, 1.061167017783231e00, 1.060294689234573e00, 1.059314689493745e00,
    1.058234647303768e00, 1.057058907527535e00, 1.055789482473656e00, 1.054429786866560e00, 1.052987925902714e00,
    1.051475051645344e00, 1.049899300533228e00, 1.048262129495776e00, 1.046566906015578e00, 1.044816992642391e00,
    1.043021249196200e00, 1.041187680907488e00, 1.039323391025476e00, 1.037431684165083e00, 1.035517573311265e00,
    1.033585105989712e00, 1.031643708543028e00, 1.029699545977279e00, 1.027759438517856e00, 1.025827187037112e00,
    1.023907910886626e00, 1.022008050685529e00, 1.020139101207016e00, 1.018263100813380e00, 1.016879010849981e00,
    1.014921948187593e00, 1.013096623369458e00, 1.011342052440818e00, 1.009659122960534e00, 1.008050363886717e00,
    1.006517540250988e00, 1.005057992517306e00, 1.003669560904293e00, 1.002353273092562e00, 1.001109808447114e00,
    9.999375230640204e-01, 9.988345237783536e-01, 9.978006059268592e-01, 9.968357558473706e-01, 9.959388811568640e-01,
    9.951084589555501e-01, 9.943434110903315e-01, 9.936429211981983e-01, 9.930058324270904e-01, 9.924309837770386e-01,
    9.919174926403282e-01, 9.914638980147298e-01, 9.910682139572967e-01, 9.907292184488009e-01, 9.904462245644213e-01,
    9.902178185518503e-01, 9.900419630667118e-01, 9.899170852600004e-01, 9.898419746989491e-01, 9.898150482937847e-01,
    9.898343291371600e-01, 9.898982107247224e-01, 9.900054030605746e-01, 9.901541892638673e-01, 9.903424269195302e-01,
    9.905684589910844e-01, 9.908309527413479e-01, 9.911280379271901e-01, 9.914575656842904e-01, 9.918178809274675e-01,
    9.922075589719793e-01, 9.926247572992801e-01, 9.930673584123647e-01, 9.935333982795475e-01, 9.940214100660039e-01,
    9.945296851337717e-01, 9.950559636181178e-01, 9.955983505434736e-01, 9.961555801042186e-01, 9.967256267769223e-01,
    9.973060922083319e-01, 9.978952138542876e-01, 9.984914406319209e-01, 9.990928899877792e-01, 9.996970625756828e-01,
    1.000303029223210e00, 1.000907933607887e00, 1.001510838557739e00, 1.002109225614564e00, 1.002701184533730e00,
    1.003285129964668e00, 1.003859256498246e00, 1.004421109631332e00, 1.004968601327613e00, 1.005500403806944e00,
    1.006014548452834e00, 1.006508690831783e00, 1.006981038626341e00, 1.007430041056790e00, 1.007853640055005e00,
    1.008249618432853e00, 1.008616036239346e00, 1.008951378362138e00, 1.009253896674588e00, 1.009521341935844e00,
    1.009751751331617e00, 1.009943714668776e00, 1.010095497366507e00, 1.010204876790192e00, 1.010270073045154e00,
    1.010289752336835e00, 1.010262269696272e00, 1.010185615431975e00, 1.010058196828792e00, 1.009878817836722e00,
    1.009645930489341e00, 1.009357533197330e00, 1.009012281815637e00, 1.008609594360786e00, 1.008148366592626e00,
    1.007626743165711e00, 1.007043430506158e00, 1.006397749801444e00, 1.005688767931258e00, 1.004915585834316e00,
    1.004077678781271e00, 1.003174288376062e00, 1.002204242070086e00, 1.001166836141424e00, 1.000062480839591e00,
    9.988914218622672e-01, 9.976522518001048e-01, 9.963438555404762e-01, 9.949674620221296e-01, 9.935246630184282e-01,
    9.920139269077016e-01, 9.904332831340030e-01, 9.887851470099116e-01, 9.870726808604894e-01, 9.852974426119764e-01,
    9.834011611313795e-01, 9.809494177655508e-01, 9.787827290446353e-01, 9.764682383490441e-01, 9.740428502007106e-01,
    9.714988482797869e-01, 9.688299679017578e-01, 9.660309739278938e-01, 9.630951038651144e-01, 9.600181976898812e-01,
    9.567957384046786e-01, 9.534262666962353e-01, 9.499034823039632e-01, 9.462221151684139e-01, 9.423758195026390e-01,
    9.383617015143452e-01, 9.341777978631194e-01, 9.298231239088762e-01, 9.252923195046721e-01, 9.205801200661107e-01,
    9.156797929682001e-01, 9.105906042938267e-01, 9.053150301587091e-01, 8.998527561071954e-01, 8.941994971184931e-01,
    8.883501524279332e-01, 8.823016313374981e-01, 8.760548741525249e-01, 8.696123849407055e-01, 8.629727993296973e-01,
    8.561351975749198e-01, 8.490981786073120e-01, 8.418570243421116e-01, 8.344140550191105e-01, 8.267746168752393e-01,
    8.189392440268611e-01, 8.109048914872936e-01, 8.026753184506191e-01, 7.942537505258295e-01, 7.856416615920516e-01,
    7.768386086617421e-01, 7.678531932560713e-01, 7.586851806705738e-01, 7.493306577133620e-01, 7.398091711550503e-01,
    7.301099443577747e-01, 7.202477806201014e-01, 7.102241609901638e-01, 7.000443258461506e-01, 6.897118895404929e-01,
    6.792311541046628e-01, 6.686081789247391e-01, 6.578509967842496e-01, 6.469657182336516e-01, 6.359596166227444e-01,
    6.248403358991607e-01, 6.136035026791002e-01, 6.022650906421884e-01, 5.908290833732823e-01, 5.793094079430561e-01,
    5.677111240020907e-01, 5.560374156751429e-01, 5.442936643492620e-01, 5.324897680536480e-01, 5.206360841136255e-01,
    5.087432727680400e-01, 4.968111660413653e-01, 4.848498807089364e-01, 4.728681073650310e-01, 4.608759183794885e-01,
    4.488810806327018e-01, 4.368910387727512e-01, 4.249120223507826e-01, 4.129606031641687e-01, 4.010358962877044e-01,
    3.891578667449375e-01, 3.773221988116735e-01, 3.655437668630012e-01, 3.538323564250667e-01, 3.421961154339837e-01,
    3.306448201086834e-01, 3.191875589898712e-01, 3.078333093391901e-01, 2.965881816516454e-01, 2.854637165360221e-01,
    2.744624088577634e-01, 2.636095844768899e-01, 2.528831011433226e-01, 2.423234889711821e-01, 2.319257462841697e-01,
    2.216908373695833e-01, 2.116380576950307e-01, 2.017669202945304e-01, 1.920822358183417e-01, 1.825891600132626e-01,
    1.733059967407588e-01, 1.642292000450303e-01, 1.553626542479246e-01, 1.467170785977411e-01, 1.382993914151456e-01,
    1.301050780767305e-01, 1.221453099291547e-01, 1.144234581921691e-01, 1.069410759923033e-01, 9.970258934460623e-02,
    9.271242833748693e-02, 8.597374270620267e-02, 7.948933111952143e-02, 7.326165794605345e-02, 6.729341023108891e-02,
    6.158740810076327e-02, 5.614580025932222e-02, 5.097007470356519e-02, 4.606170471457775e-02, 4.142201169265410e-02,
    3.705141887506228e-02, 3.294946662279392e-02, 2.911533269413120e-02, 2.554764013238235e-02, 2.224377112828603e-02,
    1.920006589797908e-02, 1.641222045266977e-02, 1.387476111201306e-02, 1.158063529909875e-02, 9.522136642215920e-03,
    7.691373795814687e-03, 6.072078331193099e-03, 4.625812168742676e-03, 3.606851641625968e-03, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];

#[rustfmt::skip]
pub const W_N360_7P5MS: [Scaler; 720] = [
    1.721526681611966e-03, 2.208248743046650e-03, 2.689017522595345e-03, 3.226133417706577e-03, 3.810144195090351e-03,
    4.453719317184182e-03, 5.153692399681317e-03, 5.915524734289813e-03, 6.738691584410875e-03, 7.628618406907552e-03,
    8.583614568030036e-03, 9.609384374613759e-03, 1.070607532160120e-02, 1.187597226083452e-02, 1.311901297315944e-02,
    1.443901078588673e-02, 1.583353014097089e-02, 1.730630810758647e-02, 1.885847112173313e-02, 2.049186515516006e-02,
    2.220614764140174e-02, 2.400571662419946e-02, 2.588835928921542e-02, 2.785523259150068e-02, 2.990591454016386e-02,
    3.204158944817544e-02, 3.426100132985917e-02, 3.656809727321165e-02, 3.896167212395468e-02, 4.144358235567028e-02,
    4.401407955156517e-02, 4.667421691393490e-02, 4.942146249896087e-02, 5.225884889914327e-02, 5.518493372761350e-02,
    5.820051428449914e-02, 6.130598448769178e-02, 6.450383844383757e-02, 6.779139227807153e-02, 7.117078328947134e-02,
    7.464110714806732e-02, 7.820280530933912e-02, 8.185495207937329e-02, 8.560001618878993e-02, 8.943576174662307e-02,
    9.336425891679158e-02, 9.738467025048170e-02, 1.014967178422148e-01, 1.056987601379146e-01, 1.099936025389733e-01,
    1.143782870006880e-01, 1.188535076446910e-01, 1.234192774722812e-01, 1.280759966861818e-01, 1.328205805921621e-01,
    1.376554565476283e-01, 1.425786478649834e-01, 1.475905216894996e-01, 1.526904374639564e-01, 1.578788527293271e-01,
    1.631525285166384e-01, 1.685133626404965e-01, 1.739579689655531e-01, 1.794847365410843e-01, 1.850931046131430e-01,
    1.907848350801405e-01, 1.965564972779563e-01, 2.024104194879864e-01, 2.083454334275949e-01, 2.143598248322309e-01,
    2.204503651331880e-01, 2.266172963796335e-01, 2.328562792793315e-01, 2.391679406203077e-01, 2.455506417347264e-01,
    2.520039508016560e-01, 2.585261682883327e-01, 2.651184076263592e-01, 2.717759113203786e-01, 2.784985387736362e-01,
    2.852846062288917e-01, 2.921324591263930e-01, 2.990384315995911e-01, 3.060042559686472e-01, 3.130265290443111e-01,
    3.201048623655521e-01, 3.272373243719107e-01, 3.344232095441687e-01, 3.416586222430363e-01, 3.489449761645191e-01,
    3.562792519116003e-01, 3.636600340252121e-01, 3.710851463600319e-01, 3.785543267164805e-01, 3.860626951895035e-01,
    3.936105536140438e-01, 4.011952247532815e-01, 4.088152724594432e-01, 4.164684603494585e-01, 4.241554113955093e-01,
    4.318710458458660e-01, 4.396147439144481e-01, 4.473840194903529e-01, 4.551769877048139e-01, 4.629901375019677e-01,
    4.708246187885389e-01, 4.786765926352632e-01, 4.865454331135768e-01, 4.944287144003222e-01, 5.023248131381035e-01,
    5.102294714645887e-01, 5.181429265558146e-01, 5.260609162248473e-01, 5.339828176544869e-01, 5.419068167854945e-01,
    5.498312828850233e-01, 5.577512337479950e-01, 5.656676362338563e-01, 5.735768827770059e-01, 5.814766655477682e-01,
    5.893646610908023e-01, 5.972413384410342e-01, 6.051020131945327e-01, 6.129461702965266e-01, 6.207702424193973e-01,
    6.285720938000074e-01, 6.363485261821292e-01, 6.440996624336124e-01, 6.518209733012164e-01, 6.595138217057872e-01,
    6.671763816763950e-01, 6.748067951703918e-01, 6.824007108459023e-01, 6.899588537658654e-01, 6.974757223488888e-01,
    7.049501447553026e-01, 7.123799800931302e-01, 7.197654340542331e-01, 7.271038329243241e-01, 7.343963718694788e-01,
    7.416385606661200e-01, 7.488296394277816e-01, 7.559666880505324e-01, 7.630492594418218e-01, 7.700722734566787e-01,
    7.770369811015168e-01, 7.839411079555614e-01, 7.907812565704104e-01, 7.975581136897942e-01, 8.042713809653173e-01,
    8.109149005929875e-01, 8.174908555311138e-01, 8.239970937711972e-01, 8.304327850184938e-01, 8.367969496408532e-01,
    8.430892979726279e-01, 8.493058471422328e-01, 8.554473095679163e-01, 8.615110365133289e-01, 8.674962806836773e-01,
    8.734007983991156e-01, 8.792275183442975e-01, 8.849724383046952e-01, 8.906357189698083e-01, 8.962171727097513e-01,
    9.017164138681113e-01, 9.071287701238782e-01, 9.124565781610174e-01, 9.176972608396821e-01, 9.228487835702877e-01,
    9.279099172570797e-01, 9.328825964768623e-01, 9.377633225341820e-01, 9.425533559491475e-01, 9.472524281763984e-01,
    9.518602062527468e-01, 9.563760599307146e-01, 9.608006016536426e-01, 9.651306001536289e-01, 9.693666888567923e-01,
    9.735088121912839e-01, 9.775565405467248e-01, 9.815072260762016e-01, 9.853645802900605e-01, 9.891262086779957e-01,
    9.927942006806012e-01, 9.963675450849775e-01, 9.998469191683163e-01, 1.003228124845146e00, 1.006513411821911e00,
    1.009700729703874e00, 1.012790289606342e00, 1.015782934360887e00, 1.018682286908352e00, 1.021486570410198e00,
    1.024197718428813e00, 1.026814550859190e00, 1.029335981099974e00, 1.031760429936344e00, 1.034089812751720e00,
    1.036323258515780e00, 1.038463607653629e00, 1.040511956629397e00, 1.042468314695544e00, 1.044333310154580e00,
    1.046108368522362e00, 1.047790183156567e00, 1.049383335559126e00, 1.050885649534276e00, 1.052299234616223e00,
    1.053625218490635e00, 1.054862887578656e00, 1.056015206502275e00, 1.057087459299065e00, 1.058072205849552e00,
    1.058975241719203e00, 1.059794467230661e00, 1.060534138670111e00, 1.061194118632638e00, 1.061773655564821e00,
    1.062276617517642e00, 1.062703237255151e00, 1.063055685508735e00, 1.063338150260194e00, 1.063547997184066e00,
    1.063686067900426e00, 1.063755566766962e00, 1.063757434953141e00, 1.063693583520601e00, 1.063566320618061e00,
    1.063377073891492e00, 1.063127819699189e00, 1.062821557530121e00, 1.062457815392427e00, 1.062036342819983e00,
    1.061559958917576e00, 1.061029510184661e00, 1.060447965083549e00, 1.059817091581481e00, 1.059141628118411e00,
    1.058421358875364e00, 1.057658760384513e00, 1.056853774077034e00, 1.056007614360998e00, 1.055120057365395e00,
    1.054195045438248e00, 1.053233455551333e00, 1.052239850719546e00, 1.051216675517538e00, 1.050166369287038e00,
    1.049087785713381e00, 1.047983664181190e00, 1.046853337647985e00, 1.045698595146235e00, 1.044520564730305e00,
    1.043323481681635e00, 1.042108306824389e00, 1.040879073476582e00, 1.039636032987793e00, 1.038380985588667e00,
    1.037114029603682e00, 1.035838134533162e00, 1.034552762539362e00, 1.033262000621490e00, 1.031967497567261e00,
    1.030671997181282e00, 1.029375639312502e00, 1.028082437365047e00, 1.026791666942681e00, 1.025506352493464e00,
    1.024226550306258e00, 1.022955584022344e00, 1.021692989563247e00, 1.020444748460154e00, 1.019207332137853e00,
    1.017999919156420e00, 1.017160217193961e00, 1.015872887197225e00, 1.014617829299498e00, 1.013397380801344e00,
    1.012210174593533e00, 1.011056516187721e00, 1.009934436494794e00, 1.008845591036958e00, 1.007789557609578e00,
    1.006767901472734e00, 1.005778512486221e00, 1.004821733696763e00, 1.003895920161236e00, 1.003002618498964e00,
    1.002140907258662e00, 1.001312127031557e00, 1.000514601809148e00, 9.997489875663875e-01, 9.990134860651736e-01,
    9.983092287560527e-01, 9.976349335738018e-01, 9.969918851181095e-01, 9.963786013745719e-01, 9.957959823242557e-01,
    9.952422174315529e-01, 9.947181322797367e-01, 9.942221216035205e-01, 9.937553132700969e-01, 9.933162157118496e-01,
    9.929058092648040e-01, 9.925224215680564e-01, 9.921669569649387e-01, 9.918377038474807e-01, 9.915355084098528e-01,
    9.912586027088507e-01, 9.910078784250421e-01, 9.907817226664765e-01, 9.905811038723256e-01, 9.904043360106435e-01,
    9.902522665150607e-01, 9.901231181863754e-01, 9.900177259420802e-01, 9.899343252516752e-01, 9.898737119947000e-01,
    9.898341100636087e-01, 9.898163585163330e-01, 9.898187066647253e-01, 9.898419976335596e-01, 9.898844376083749e-01,
    9.899468001787191e-01, 9.900272871794666e-01, 9.901266804330273e-01, 9.902431753677082e-01, 9.903775935673591e-01,
    9.905281337320039e-01, 9.906955635514434e-01, 9.908780432538649e-01, 9.910763016962206e-01, 9.912885401035934e-01,
    9.915156019790364e-01, 9.917556658638569e-01, 9.920094690635668e-01, 9.922751554325331e-01, 9.925534864640656e-01,
    9.928426927501408e-01, 9.931435333387140e-01, 9.934540796611835e-01, 9.937750666306635e-01, 9.941046890713076e-01,
    9.944437415635388e-01, 9.947903979828719e-01, 9.951453611435701e-01, 9.955067995758305e-01, 9.958755336221258e-01,
    9.962496814968456e-01, 9.966299185765186e-01, 9.970143670156726e-01, 9.974037994063020e-01, 9.977964044701016e-01,
    9.981928706842119e-01, 9.985912855613679e-01, 9.989924362978263e-01, 9.993945064762333e-01, 9.997982470741876e-01,
    1.000201793638269e00, 1.000605860368296e00, 1.001008579910682e00, 1.001410701714506e00, 1.001810400944408e00,
    1.002208462087081e00, 1.002602958395831e00, 1.002994573682287e00, 1.003381477277237e00, 1.003764436338408e00,
    1.004141548053574e00, 1.004513480396200e00, 1.004878321344784e00, 1.005236884099094e00, 1.005587302935534e00,
    1.005930271724399e00, 1.006263925890636e00, 1.006589051746658e00, 1.006903802351948e00, 1.007208903587772e00,
    1.007502380110983e00, 1.007784982346051e00, 1.008054893814649e00, 1.008312868199207e00, 1.008556999006399e00,
    1.008788016348394e00, 1.009004047709048e00, 1.009205932867561e00, 1.009391822060050e00, 1.009562440424896e00,
    1.009715896739930e00, 1.009852958217732e00, 1.009971774079105e00, 1.010073169648632e00, 1.010155293011166e00,
    1.010218932642345e00, 1.010262246288524e00, 1.010286018304889e00, 1.010288415013601e00, 1.010270296641665e00,
    1.010229878703309e00, 1.010168022758243e00, 1.010082924574326e00, 1.009975407736885e00, 1.009843687123529e00,
    1.009688632854747e00, 1.009508455280294e00, 1.009304044596942e00, 1.009073713509976e00, 1.008818483155921e00,
    1.008536750845889e00, 1.008229467503460e00, 1.007894884001199e00, 1.007533913863759e00, 1.007144877861525e00,
    1.006728757854175e00, 1.006283927891016e00, 1.005811456284196e00, 1.005309913983530e00, 1.004780527277797e00,
    1.004221766054862e00, 1.003634560818982e00, 1.003017190938855e00, 1.002370673225852e00, 1.001693634792953e00,
    1.000987488105603e00, 1.000251075456674e00, 9.994856628696702e-01, 9.986895923896904e-01, 9.978636664333774e-01,
    9.970063702291652e-01, 9.961191991291183e-01, 9.952014038559622e-01, 9.942546868773952e-01, 9.932775951012806e-01,
    9.922706506028359e-01, 9.912319673936767e-01, 9.901632857185525e-01, 9.890643935223216e-01, 9.879371153343368e-01,
    9.867797361083076e-01, 9.855927730842358e-01, 9.843751246861034e-01, 9.831292878900623e-01, 9.813484629113276e-01,
    9.798909633127684e-01, 9.784004589849064e-01, 9.768604354115724e-01, 9.752698788428587e-01, 9.736273532416118e-01,
    9.719313409832228e-01, 9.701804980040253e-01, 9.683726519652567e-01, 9.665069522597068e-01, 9.645800268203277e-01,
    9.625923175883123e-01, 9.605409863432730e-01, 9.584255335155275e-01, 9.562443932750193e-01, 9.539984159028931e-01,
    9.516840138455831e-01, 9.493011853637791e-01, 9.468468843298323e-01, 9.443202322315050e-01, 9.417184043233268e-01,
    9.390425796467096e-01, 9.362906241698766e-01, 9.334640497363101e-01, 9.305608538768808e-01, 9.275805069442316e-01,
    9.245195917195164e-01, 9.213784714413848e-01, 9.181534137230349e-01, 9.148446956130220e-01, 9.114516516017124e-01,
    9.079765240138057e-01, 9.044175450831859e-01, 9.007763077278617e-01, 8.970500584793123e-01, 8.932383978549314e-01,
    8.893386805647778e-01, 8.853513603848177e-01, 8.812740229566767e-01, 8.771096379139661e-01, 8.728579265043998e-01,
    8.685195050926551e-01, 8.640927964490425e-01, 8.595798186504622e-01, 8.549760065595760e-01, 8.502852201263446e-01,
    8.455026150386550e-01, 8.406304703204051e-01, 8.356679254927833e-01, 8.306199433014801e-01, 8.254820069905587e-01,
    8.202589087059164e-01, 8.149466481575340e-01, 8.095466959213909e-01, 8.040599778581757e-01, 7.984893775294406e-01,
    7.928314173180783e-01, 7.870906681120101e-01, 7.812624496601451e-01, 7.753539468965313e-01, 7.693636129738075e-01,
    7.632917692550881e-01, 7.571390164385375e-01, 7.509017111797436e-01, 7.445908434203883e-01, 7.382051359832217e-01,
    7.317380750199757e-01, 7.251992870809165e-01, 7.185882252895927e-01, 7.119056866892599e-01, 7.051536683608545e-01,
    6.983326341551366e-01, 6.914441012238667e-01, 6.844905446038185e-01, 6.774701192768717e-01, 6.703883753752553e-01,
    6.632452099313783e-01, 6.560457800753937e-01, 6.487886269109083e-01, 6.414771616618185e-01, 6.341143226974428e-01,
    6.267020002885999e-01, 6.192353336355413e-01, 6.117205957668128e-01, 6.041616120083719e-01, 5.965591325427860e-01,
    5.889144007425270e-01, 5.812347834141942e-01, 5.735199893648143e-01, 5.657706158383411e-01, 5.579880671567978e-01,
    5.501738510234542e-01, 5.423301939386325e-01, 5.344607980557825e-01, 5.265685382300127e-01, 5.186563241060174e-01,
    5.107288126105302e-01, 5.027811586638018e-01, 4.948194909906872e-01, 4.868451392486417e-01, 4.788608890561871e-01,
    4.708699282370115e-01, 4.628751440565413e-01, 4.548778943490807e-01, 4.468825120278060e-01, 4.388893249911809e-01,
    4.308981228989757e-01, 4.229183223777856e-01, 4.149508779761170e-01, 4.069939642056243e-01, 3.990526483957498e-01,
    3.911346135115557e-01, 3.832340305827807e-01, 3.753546526584436e-01, 3.675020596488621e-01, 3.596800983344559e-01,
    3.518873119772211e-01, 3.441301658282572e-01, 3.364081000913025e-01, 3.287289661673846e-01, 3.210905051632958e-01,
    3.134964181526467e-01, 3.059515649397201e-01, 2.984543187240678e-01, 2.910105654938703e-01, 2.836211093775042e-01,
    2.762854150573731e-01, 2.690195851087454e-01, 2.618124452057962e-01, 2.546592323719683e-01, 2.475843475618672e-01,
    2.405786941912602e-01, 2.336470086662776e-01, 2.267884333851989e-01, 2.200019917678347e-01, 2.133013251703927e-01,
    2.066777706538484e-01, 2.001404091043453e-01, 1.936836302775967e-01, 1.873103432384193e-01, 1.810273838836248e-01,
    1.748394760623094e-01, 1.687396441250690e-01, 1.627372734819174e-01, 1.568252770506826e-01, 1.510123820588976e-01,
    1.452982295367473e-01, 1.396874693829809e-01, 1.341718422797088e-01, 1.287625441360194e-01, 1.234555620731477e-01,
    1.182546623256352e-01, 1.131596767663045e-01, 1.081714392735899e-01, 1.032907339774594e-01, 9.852029779063426e-02,
    9.386000226048140e-02, 8.931173602725516e-02, 8.487521028829931e-02, 8.055237373221881e-02, 7.634297866041770e-02,
    7.224892456088809e-02, 6.826991195487858e-02, 6.440772914585895e-02, 6.066200028414472e-02, 5.703437111472432e-02,
    5.352437147393933e-02, 5.013346896851077e-02, 4.686107896077298e-02, 4.370844528199226e-02, 4.067483652594974e-02,
    3.776122690656316e-02, 3.496670991534084e-02, 3.229192748331241e-02, 2.973576687031024e-02, 2.729846292648297e-02,
    2.497871856111264e-02, 2.277625418320712e-02, 2.068958080348780e-02, 1.871781693470649e-02, 1.685934175287805e-02,
    1.511251252352758e-02, 1.347570944951177e-02, 1.194627091218482e-02, 1.052287538118900e-02, 9.201309412840026e-03,
    7.981243163732707e-03, 6.855473143120775e-03, 5.826573343851640e-03, 4.878385254226555e-03, 4.023511190940970e-03,
    3.154186627586960e-03, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
    0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00, 0.000000000000000e00,
];
