use lc3_codec::{
    common::config::{FrameDuration, Lc3Config, SamplingFrequency},
    decoder::{side_info::SnsVq, spectral_noise_shaping},
};

pub fn main() {
    let config = Lc3Config::new(SamplingFrequency::Hz48000, FrameDuration::TenMs, 1);
    let sns_vq = SnsVq {
        ind_lf: 4,
        ind_hf: 23,
        ls_inda: 0,
        ls_indb: 0,
        idx_a: 282923,
        idx_b: 0,
        submode_lsb: 1,
        submode_msb: 1,
        g_ind: 1,
    };

    let mut x_hat = vec![
        -3010.7263, 3224.4155, 843.30865, -1484.3759, 324.3495, 1179.1057, 446.45752, 0.0, 202.24144, -80.1334,
        80.1334, 80.1334, 141.18742, -19.758884, 195.78009, 302.85767, 200.19202, 1449.2006, 399.45996, -377.37885,
        473.714, -323.22815, 522.5331, 387.1023, -269.3435, 1040.3253, -1536.5151, -2044.9348, -299.37134, -2029.9937,
        -149.60034, 833.5304, -472.91345, 284.12292, -922.24457, -728.61316, 529.04285, 102.71062, 259.5889, 353.51114,
        351.38373, 177.913, 129.48813, 64.55688, -101.30058, 149.0453, 57.781242, -5.201025, 43.46162, -36.37163,
        -59.86196, -98.03962, -117.99986, 241.8753, 311.2033, 12.945595, 238.67587, 14.87133, 27.1989, 210.18813,
        -27.024132, 167.31425, -25.020943, 27.701948, 98.38553, -29.578548, 77.93503, -146.78511, 96.16429, -110.92733,
        92.1926, 965.2187, 251.73932, -33.561104, 194.80981, -82.73023, 93.578445, -64.9294, 41.35941, -65.051765,
        -385.0532, 4.99234, -62.48469, -79.348694, 37.74311, -40.02237, -18.775711, -57.991676, -59.923485, 5.82917,
        99.27249, -53.736046, -16.098087, 20.626308, -45.196953, -24.529823, -141.20695, -13.524452, -69.06046,
        -13.798968, -1.0102386, -64.342155, 88.32887, -165.73033, -241.35516, -290.4107, -50.20676, 256.3272, 52.9813,
        -2.8017578, -150.25673, -59.46541, 56.18451, 55.769356, 33.584682, -26.786224, 101.397766, 105.58726,
        52.061085, -96.54164, -11.750801, -71.17774, -203.21161, -157.91689, -626.6571, -490.50436, -30.059631,
        -68.53883, 83.31279, 208.69096, 125.21935, 173.2462, 228.76846, -13.459351, -197.10747, -189.60486, -285.5866,
        -417.2583, -512.411, -609.8527, -768.9725, -687.2765, -815.424, -953.2716, -551.2804, -356.52814, -373.93295,
        -104.25845, 24.54942, 48.12262, 223.0623, 231.99725, 274.51492, 174.24074, 61.62627, 93.86131, 2.472334,
        -128.00786, -68.90458, 75.99748, -31.365078, -201.24693, -194.44128, -26.296425, -42.11641, 5.9352007,
        107.63636, 63.927383, 127.602844, -80.86493, -141.18536, -197.90659, -42.845055, 127.11714, -313.91016,
        220.40598, -218.6484, -48.112408, 1049.7952, -670.75134, -654.7163, 177.9105, -373.3244, 91.585495, -74.23524,
        9.73695, 134.13936, -207.76877, -125.97827, -117.09581, 28.60088, 22.106157, 17.379986, 17.679386, 7.6593475,
        56.590084, 37.87044, 36.51715, -30.484245, 31.221088, 0.0, -61.05402, 0.0, 0.0, 0.0, -61.05402, 0.0, 0.0, 0.0,
        0.0, 0.0, 183.16206, 0.0, 671.59424, 305.2701, -1037.9183, -427.37814, -61.05402, -183.16206, 0.0, -122.10804,
        0.0, -61.05402, 0.0, 0.0, 0.0, -11.447629, -11.447629, 11.447629, 11.447629, -11.447629, 11.447629, 11.447629,
        -11.447629, 0.0, 0.0, 0.0, -61.05402, 61.05402, -61.05402, -61.05402, 122.10804, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
        61.05402, 0.0, 0.0, -61.05402, -61.05402, 0.0, -61.05402, 61.05402, 0.0, 0.0, 0.0, 0.0, 0.0, -61.05402,
        61.05402, -61.05402, 0.0, 0.0, 0.0, 122.10804, 0.0, 0.0, 0.0, 11.447629, 11.447629, -11.447629, 0.0, 0.0, 0.0,
        -61.05402, 61.05402, -61.05402, 61.05402, 0.0, 183.16206, 183.16206, 122.10804, 1098.9724, -183.16206,
        -1037.9183, -61.05402, -244.21608, -61.05402, -61.05402, -122.10804, 0.0, -61.05402, 61.05402, -61.05402, 0.0,
        0.0, 0.0, 0.0, 0.0, 61.05402, 61.05402, 0.0, -61.05402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 122.10804, 122.10804,
        0.0, 61.05402, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 305.2701, 0.0, -61.05402, 61.05402, -61.05402, 61.05402, 0.0, 0.0,
        0.0, 11.447629, -11.447629, -11.447629, 11.447629, 11.447629, -11.447629, -11.447629, 11.447629, 11.447629,
        -11.447629, 0.0, 0.0, 0.0, -61.05402, 0.0, 0.0, 0.0, 11.447629, -11.447629, 11.447629, -11.447629, 11.447629,
        -11.447629, 0.0, 0.0, 0.0, 61.05402, 0.0, -61.05402, 0.0, 0.0, 0.0, -11.447629, 11.447629, -11.447629,
        11.447629, -11.447629, -11.447629, 11.447629, 11.447629, 11.447629, -11.447629, -11.447629, -11.447629,
        -11.447629, -11.447629, -11.447629, -11.447629, -11.447629, 11.447629, 11.447629, 11.447629, 11.447629,
        -11.447629, 11.447629, 11.447629, 11.447629, -11.447629, -11.447629, 11.447629, -11.447629, 11.447629,
        -11.447629, -11.447629, 11.447629, 11.447629, 11.447629, -11.447629, -11.447629,
    ];

    let _foo = 5;
    for _ in 0..200000 {
        spectral_noise_shaping::decode(&config, &sns_vq, &mut x_hat);
    }
    let _cha = 3;
}
