# Summary

[Introduction](./introduction.md)

# User Guide

- [Installation](./installation.md)
- [Getting Started](./getting_started.md)
- [Running Laze](./execution.md)

# Concepts

- [Build Files](./concepts/lazefiles.md)
- [Apps, Builders, Contexts, Modules](./concepts/types.md)
- [Tasks]()
- [Module Dependencies](./concepts/dependencies.md)

# Reference

- [laze file format](./reference/laze_yaml.md)
  - [apps](./reference/apps.md)
  - [builders](./reference/builders.md)
  - [contexts](./reference/contexts.md)
    - [name](./reference/context/name.md)
    - [parent](./reference/context/parent.md)
    - [env](./reference/context/env.md)
    - [selects](./reference/context/selects.md)
    - [disables](./reference/context/disables.md)
    - [rules](./reference/context/rules.md)
      - [name](./reference/context/rule/name.md)
      - [cmd](./reference/context/rule/name.md)
      - [description](./reference/context/rule/description.md)
      - [in](./reference/context/rule/in.md)
      - [out](./reference/context/rule/out.md)
      - [options](./reference/context/rule/option.md)
      - [gcc_deps](./reference/context/rule/gcc_deps.md)
      - [rspfile](./reference/context/rule/rspfile.md)
      - [rspfile_content](./reference/context/rule/rspfile_content.md)
      - [pool](./reference/context/rule/pool.md)
      - [always](./reference/context/rule/always.md)
    - [tasks](./reference/context/tasks.md)
    - [var_options](./reference/context/var_options.md)
  - [modules](./reference/modules.md)
    - [name]()
    - [sources]()
    - [depends]()
    - [selects]()
    - [uses]()
    - [conflicts]()
    - [build]()
    - [notify_all]()
    - [env]()
    - [blocklist]()
    - [allowlist]()
    - [srcdir]()
  - [subdirs](./reference/subdirs.md)
  - [imports](./reference/imports.md)
    - [git](./reference/import/git.md)
    - [laze](./reference/import/laze.md)
  - [defaults]()
