use std::path::PathBuf;

use serde::{Deserialize, Serialize};

use layeredconf::{Builder, Format, LayeredConf, Source};

#[derive(LayeredConf, Deserialize, Serialize, Clone, Debug)]
struct Config {
    #[clap(long)]
    config: String,
    #[clap(long)]
    name: String,
    #[clap(long)]
    data_path: PathBuf,
    #[clap(long)]
    optional: Option<String>,
    #[layered(subconfig)]
    subconfig: submod::SubConfig,
}

mod submod {
    use std::time::Duration;

    use serde::{Deserialize, Serialize};

    use layeredconf::LayeredConf;

    #[derive(LayeredConf, Deserialize, Serialize, Clone, Debug)]
    #[layered(subconfig)]
    pub struct SubConfig {
        #[clap(long)]
        flibble: u64,
        #[clap(skip)]
        duration: Duration,
    }
}

#[test]
fn test_submod() {
    let source = r#"
config: Rar
name: Name goes here
data_path: /tmp/rar
subconfig:
    flibble: 100
    duration: { secs: 60, nanos: 0 }
"#;
    assert!(Builder::<Config>::new()
        .new_layer(Source::String(source.to_string(), Format::Yaml))
        .solidify()
        .is_ok());
}
