# Latex Clean

This command line application is useful in cleaning the auxiliary files
generated by LaTeX tools like [latexmk](https://personal.psu.edu/~jcc8/software/latexmk/),
[TexStudio](https://www.texstudio.org/). This program recursively traverses the
given folder and deletes the files with extensions in the following blocked
list.

## List of Extensions removed

- aux
- lof
- log
- lot
- fls
- out
- toc
- fmt
- fot
- cb
- cb3
- lb
- bbl
- bcf
- blg
- xml
- fdb_latexmk
- synctex
- synctex(busy)
- pdfsync
- alg
- loa
- nav
- pre
- snm
- vrb
- acn
- acr
- glg
- glo
- gls
- glsdefs
- lzo
- lzs
- slg
- slo
- sls
- nlg
- nlo
- nls

## Installation

### Installation from Crates.io

The program is written completely in [Rust](https://www.rust-lang.org/), and can
be installed using [cargo](https://doc.rust-lang.org/cargo/).

To install this program, first install cargo by following the [installation steps](https://doc.rust-lang.org/cargo/getting-started/installation.html)
for your operating system.

Subsequently run the following command to install this crate -

```shell
cargo install latexclean
```

### Installation from source

Optionally, you could also install this application directly from source by
running the following command

```shell
cargo install --git https://github.com/SoutrikBandyopadhyay/latexclean
```

## Usage

### Basic Usage

```shell
$ cd \path\to\your\latex\workspace
$ latexclean
```
To enable verbose output,

```shell
latexclean --verbose
```

```shell
latexclean -v
```

### List all the extensions that are purged

```shell
latexclean --list
```

Alternatively,

```shell
latexclean -l
```
