## How to contribute to larz

#### **Did you find a bug?**

* **Do not open up a GitHub issue if the bug is a security vulnerability
  in larz**, and instead to refer to our [security policy](https://github.com/Dirout/larz/blob/master/SECURITY.md).

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/Dirout/larz/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/Dirout/larz/issues/new/choose). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

#### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number, if applicable.

#### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of larz will generally not be accepted (read more about [the rationale behind this, from the Ruby on Rails project](https://github.com/rails/rails/pull/13771#issuecomment-32746700)).

#### **Do you intend to add a new feature or change an existing one?**

* If someone hasn't already suggested the same thing, [open a new issue](https://github.com/Dirout/larz/issues/new/choose) and start writing code.

larz is a volunteer effort. We encourage you to pitch in and join [The Team](https://github.com/Dirout/larz/graphs/contributors)!

Merci!

The Team
