# langenv

langenv aims to be a cross-platform package manager for Linux, macOS, and Windows.

> Please note that this project is currently a Work In Progress and isn't currently functional.

## Goals

- Releases
- To support the following Operating Systems:
  - Linux
  - macOS
  - Windows
- To support managing packages with the following scopes:
  - Project-space
  - User-space
  - System-space packages
- To support the following CPU Architectures:
  - amd64 (aka. "x86-64")
  - arm64
- For `langenv` to be a statically linked binary that can:
  - Install itself onto the system
  - Install & Manage packages
  - And do it all without any external package dependencies (work in a `scratch` docker container)

## Current Limitations

- Only manages pre-built static binaries (Dependency management can be very difficult to fix if done incorrectly. Until a solid plan is made, I'm avoiding the problem.)
- Only installs the latest versions of the packages (The repo format & syntax is unstable. Until the repo system is stablized, I'm limiting the versions so that large changes can be refactored quickly.)
- Only installs & manages packages in User-space

## Inspiration

The following package managers are great projects with many cool features.

- [asdf](https://asdf-vm.com): My favorite Project-space package manager for \*nix environments.
- [homebrew](https://brew.sh): My favorite User-space package manager for macOS.
- [scoop](https://scoop.sh): My favorite User-space package manager for Windows.
- [nix](https://nixos.org): Has a very cool build-system and dependency management system.
