use std::{env, process::Command};

use anyhow::{anyhow, Result};

const TARGET: &str = "aarch64-unknown-linux-gnu";

fn main() -> Result<()> {
    let exit_status = Command::new("cargo")
        .arg("build")
        .arg("--release")
        .args(&["--target", TARGET])
        .args(env::args_os().skip(1))
        .spawn()?
        .wait()?;

    match exit_status.success() {
        true => Ok(()),
        false => Err(anyhow!("cargo build exited with status {}", exit_status)),
    }
}
