/**
 * 发布 crate 到 crates.io
 * 
 * crates.io
 * · 可以通过发布包来共享你的代码
 * · crate 的注册表在 https://crates.io/
 *      - 它会分发已注册的包的源代码
 *      - 主要托管开源的代码
 * 
 * 文档注释
 * · 文档注释：用于生成文档
 *      - 生成 HTML 文档
 *      - 显式公共 API 的文档注释：如何使用 API
 *      - 使用 ///
 *      - 支持 Markdown
 *      - 放置在被说明条目之前
 * 
 * 生成 HTML 文档的命令
 * · cargo doc
 *      - 它会运行 rustdoc 工具 （Rust 安装包自带）
 *      - 把生成的 HTML 文档放在 target/doc 目录下
 * · cargo doc --open
 *      - 构建当前 crate 的文档 （也包含 crate 依赖项的文档）
 *      - 在浏览器打开文档
 * 
 * 常用章节
 * · # Examples
 * · 其它常用的章节：
 *      - Panics: 函数可能发生 panic 的场景
 *      - Errors: 如果函数返回 Result，描述可能的错误种类，以及可导致错误的条件
 *      - Safety: 如果函数处于 unsafe 调用，就应该解释函数 unsafe 的原因，以及调用者确保的使用前提
 * 
 * 为包含注释的项添加文档注释
 * · 符号： //! 
 * · 这类注释通常用描述 crate 和 模块
 *      - crate root （按惯例 src/lib.rs）
 *      - 一个模块内，将 crate 或 模块作为一个整体进行记录
 * 
 * 使用 pub use 导出方便使用的公共 API 
 * · 问题： crate 的程序结构在开发时对于开发者很合理，但对于它的使用者不够方便
 *      - 开发者会把程序结构分为很多层，使用者想找到这种深层结构中的某个类型很费劲
 * · 例如：
 *      - 麻烦：use my_crate::some_module::another_module::UsefulType;
 *      - 方便: use my_crate::UsefulType;
 * · 解决办法：
 *      - 不需要重新组织内部代码结构
 *      - 使用 pub use： 可以重新导出，创建一个与内部私有结构不同的外部公共结构
 * 
 * 创建并设置 crates.io 账号
 * · 发布 crate 前，需要在 crates.io 创建账号并获得 API token
 * · 运行命令： cargo login [你的API token]
 *      - 通知 cargo，你的 API token 存储在本地 ~/.cargo/credentials
 * · API token 可以在 https://crates.io/ 进行撤销
 * 
 * 为新的 crate 添加元数据
 * · 在发布 crate 前，需要在Cargo.toml 的 [package] 区域为 crate 添加一些元数据：
 *      - name: crate 需要唯一的名称
 *      - description： 一两句话即可，会出现在 crate 搜索的结果里
 *      - license： 需提供许可证标识符 （可到 http://spdx.org/license/ 查找）
 *          - 可指定多个 license： 用 OR
 *      - version
 *      - author
 * · 发布： cargo publish 命令
 */

fn main() {
    println!("Hello, world!");
}
