﻿/// Нелинейное биективное преобразование множества двоичных векторов
pub const K_PI : [u8; 256] = [
	252, 238, 221, 17, 207, 110, 49, 22, 251, 196, 250, 218, 35, 197, 4, 77,
	233, 119, 240, 219, 147, 46, 153, 186, 23, 54, 241, 187, 20, 205, 95, 193,
	249, 24, 101, 90, 226, 92, 239, 33, 129, 28, 60, 66, 139, 1, 142, 79, 5,
	132, 2, 174, 227, 106, 143, 160, 6, 11, 237, 152, 127, 212, 211, 31, 235,
	52, 44, 81, 234, 200, 72, 171, 242, 42, 104, 162, 253, 58, 206, 204, 181,
	112, 14, 86, 8, 12, 118, 18, 191, 114, 19, 71, 156, 183, 93, 135, 21, 161,
	150, 41, 16, 123, 154, 199, 243, 145, 120, 111, 157, 158, 178, 177, 50, 117,
	25, 61, 255, 53, 138, 126, 109, 84, 198, 128, 195, 189, 13, 87, 223, 245,
	36, 169, 62, 168, 67, 201, 215, 121, 214, 246, 124, 34, 185, 3, 224, 15,
	236, 222, 122, 148, 176, 188, 220, 232, 40, 80, 78, 51, 10, 74, 167, 151,
	96, 115, 30, 0, 98, 68, 26, 184, 56, 130, 100, 159, 38, 65, 173, 69, 70,
	146, 39, 94, 85, 47, 140, 163, 165, 125, 105, 213, 149, 59, 7, 88, 179, 64,
	134, 172, 29, 247, 48, 55, 107, 228, 136, 217, 231, 137, 225, 27, 131, 73,
	76, 63, 248, 254, 141, 83, 170, 144, 202, 216, 133, 97, 32, 113, 103, 164,
	45, 43, 9, 91, 203, 155, 37, 208, 190, 229, 108, 82, 89, 166, 116, 210, 230,
	244, 180, 192, 209, 102, 175, 194, 57, 75, 99, 182 
];


/// Обратное нелинейное биективное преобразование множества двоичных векторов
pub const K_PI_REV: [u8; 256] = [
	0xa5, 0x2d, 0x32, 0x8f, 0x0e, 0x30, 0x38, 0xc0, 0x54, 0xe6, 0x9e, 0x39,
	0x55, 0x7e, 0x52, 0x91, 0x64, 0x03, 0x57, 0x5a, 0x1c, 0x60, 0x07, 0x18,
	0x21, 0x72, 0xa8, 0xd1, 0x29, 0xc6, 0xa4, 0x3f, 0xe0, 0x27, 0x8d, 0x0c,
	0x82, 0xea, 0xae, 0xb4, 0x9a, 0x63, 0x49, 0xe5, 0x42, 0xe4, 0x15, 0xb7,
	0xc8, 0x06, 0x70, 0x9d, 0x41, 0x75, 0x19, 0xc9, 0xaa, 0xfc, 0x4d, 0xbf,
	0x2a, 0x73, 0x84, 0xd5, 0xc3, 0xaf, 0x2b, 0x86, 0xa7, 0xb1, 0xb2, 0x5b,
	0x46, 0xd3, 0x9f, 0xfd, 0xd4, 0x0f, 0x9c, 0x2f, 0x9b, 0x43, 0xef, 0xd9,
	0x79, 0xb6, 0x53, 0x7f, 0xc1, 0xf0, 0x23, 0xe7, 0x25, 0x5e, 0xb5, 0x1e,
	0xa2, 0xdf, 0xa6, 0xfe, 0xac, 0x22, 0xf9, 0xe2, 0x4a, 0xbc, 0x35, 0xca,
	0xee, 0x78, 0x05, 0x6b, 0x51, 0xe1, 0x59, 0xa3, 0xf2, 0x71, 0x56, 0x11,
	0x6a, 0x89, 0x94, 0x65, 0x8c, 0xbb, 0x77, 0x3c, 0x7b, 0x28, 0xab, 0xd2,
	0x31, 0xde, 0xc4, 0x5f, 0xcc, 0xcf, 0x76, 0x2c, 0xb8, 0xd8, 0x2e, 0x36,
	0xdb, 0x69, 0xb3, 0x14, 0x95, 0xbe, 0x62, 0xa1, 0x3b, 0x16, 0x66, 0xe9,
	0x5c, 0x6c, 0x6d, 0xad, 0x37, 0x61, 0x4b, 0xb9, 0xe3, 0xba, 0xf1, 0xa0,
	0x85, 0x83, 0xda, 0x47, 0xc5, 0xb0, 0x33, 0xfa, 0x96, 0x6f, 0x6e, 0xc2,
	0xf6, 0x50, 0xff, 0x5d, 0xa9, 0x8e, 0x17, 0x1b, 0x97, 0x7d, 0xec, 0x58,
	0xf7, 0x1f, 0xfb, 0x7c, 0x09, 0x0d, 0x7a, 0x67, 0x45, 0x87, 0xdc, 0xe8,
	0x4f, 0x1d, 0x4e, 0x04, 0xeb, 0xf8, 0xf3, 0x3e, 0x3d, 0xbd, 0x8a, 0x88,
	0xdd, 0xcd, 0x0b, 0x13, 0x98, 0x02, 0x93, 0x80, 0x90, 0xd0, 0x24, 0x34,
	0xcb, 0xed, 0xf4, 0xce, 0x99, 0x10, 0x44, 0x40, 0x92, 0x3a, 0x01, 0x26,
	0x12, 0x1a, 0x48, 0x68, 0xf5, 0x81, 0x8b, 0xc7, 0xd6, 0x20, 0x0a, 0x08,
	0x00, 0x4c, 0xd7, 0x74 
];

/// Таблица умножения
pub const MULT_TABLE: [[u8; 256]; 7] = [
/* 16 */ [
		0x00,   0x10,   0x20,   0x30,   0x40,   0x50,   0x60,   0x70,
		0x80,   0x90,   0xa0,   0xb0,   0xc0,   0xd0,   0xe0,   0xf0,
		0xc3,   0xd3,   0xe3,   0xf3,   0x83,   0x93,   0xa3,   0xb3,
		0x43,   0x53,   0x63,   0x73,   0x03,   0x13,   0x23,   0x33,
		0x45,   0x55,   0x65,   0x75,   0x05,   0x15,   0x25,   0x35,
		0xc5,   0xd5,   0xe5,   0xf5,   0x85,   0x95,   0xa5,   0xb5,
		0x86,   0x96,   0xa6,   0xb6,   0xc6,   0xd6,   0xe6,   0xf6,
		0x06,   0x16,   0x26,   0x36,   0x46,   0x56,   0x66,   0x76,
		0x8a,   0x9a,   0xaa,   0xba,   0xca,   0xda,   0xea,   0xfa,
		0x0a,   0x1a,   0x2a,   0x3a,   0x4a,   0x5a,   0x6a,   0x7a,
		0x49,   0x59,   0x69,   0x79,   0x09,   0x19,   0x29,   0x39,
		0xc9,   0xd9,   0xe9,   0xf9,   0x89,   0x99,   0xa9,   0xb9,
		0xcf,   0xdf,   0xef,   0xff,   0x8f,   0x9f,   0xaf,   0xbf,
		0x4f,   0x5f,   0x6f,   0x7f,   0x0f,   0x1f,   0x2f,   0x3f,
		0x0c,   0x1c,   0x2c,   0x3c,   0x4c,   0x5c,   0x6c,   0x7c,
		0x8c,   0x9c,   0xac,   0xbc,   0xcc,   0xdc,   0xec,   0xfc,
		0xd7,   0xc7,   0xf7,   0xe7,   0x97,   0x87,   0xb7,   0xa7,
		0x57,   0x47,   0x77,   0x67,   0x17,   0x07,   0x37,   0x27,
		0x14,   0x04,   0x34,   0x24,   0x54,   0x44,   0x74,   0x64,
		0x94,   0x84,   0xb4,   0xa4,   0xd4,   0xc4,   0xf4,   0xe4,
		0x92,   0x82,   0xb2,   0xa2,   0xd2,   0xc2,   0xf2,   0xe2,
		0x12,   0x02,   0x32,   0x22,   0x52,   0x42,   0x72,   0x62,
		0x51,   0x41,   0x71,   0x61,   0x11,   0x01,   0x31,   0x21,
		0xd1,   0xc1,   0xf1,   0xe1,   0x91,   0x81,   0xb1,   0xa1,
		0x5d,   0x4d,   0x7d,   0x6d,   0x1d,   0x0d,   0x3d,   0x2d,
		0xdd,   0xcd,   0xfd,   0xed,   0x9d,   0x8d,   0xbd,   0xad,
		0x9e,   0x8e,   0xbe,   0xae,   0xde,   0xce,   0xfe,   0xee,
		0x1e,   0x0e,   0x3e,   0x2e,   0x5e,   0x4e,   0x7e,   0x6e,
		0x18,   0x08,   0x38,   0x28,   0x58,   0x48,   0x78,   0x68,
		0x98,   0x88,   0xb8,   0xa8,   0xd8,   0xc8,   0xf8,   0xe8,
		0xdb,   0xcb,   0xfb,   0xeb,   0x9b,   0x8b,   0xbb,   0xab,
		0x5b,   0x4b,   0x7b,   0x6b,   0x1b,   0x0b,   0x3b,   0x2b,
	], /* 32 */ [
		0x00,   0x20,   0x40,   0x60,   0x80,   0xa0,   0xc0,   0xe0,
		0xc3,   0xe3,   0x83,   0xa3,   0x43,   0x63,   0x03,   0x23,
		0x45,   0x65,   0x05,   0x25,   0xc5,   0xe5,   0x85,   0xa5,
		0x86,   0xa6,   0xc6,   0xe6,   0x06,   0x26,   0x46,   0x66,
		0x8a,   0xaa,   0xca,   0xea,   0x0a,   0x2a,   0x4a,   0x6a,
		0x49,   0x69,   0x09,   0x29,   0xc9,   0xe9,   0x89,   0xa9,
		0xcf,   0xef,   0x8f,   0xaf,   0x4f,   0x6f,   0x0f,   0x2f,
		0x0c,   0x2c,   0x4c,   0x6c,   0x8c,   0xac,   0xcc,   0xec,
		0xd7,   0xf7,   0x97,   0xb7,   0x57,   0x77,   0x17,   0x37,
		0x14,   0x34,   0x54,   0x74,   0x94,   0xb4,   0xd4,   0xf4,
		0x92,   0xb2,   0xd2,   0xf2,   0x12,   0x32,   0x52,   0x72,
		0x51,   0x71,   0x11,   0x31,   0xd1,   0xf1,   0x91,   0xb1,
		0x5d,   0x7d,   0x1d,   0x3d,   0xdd,   0xfd,   0x9d,   0xbd,
		0x9e,   0xbe,   0xde,   0xfe,   0x1e,   0x3e,   0x5e,   0x7e,
		0x18,   0x38,   0x58,   0x78,   0x98,   0xb8,   0xd8,   0xf8,
		0xdb,   0xfb,   0x9b,   0xbb,   0x5b,   0x7b,   0x1b,   0x3b,
		0x6d,   0x4d,   0x2d,   0x0d,   0xed,   0xcd,   0xad,   0x8d,
		0xae,   0x8e,   0xee,   0xce,   0x2e,   0x0e,   0x6e,   0x4e,
		0x28,   0x08,   0x68,   0x48,   0xa8,   0x88,   0xe8,   0xc8,
		0xeb,   0xcb,   0xab,   0x8b,   0x6b,   0x4b,   0x2b,   0x0b,
		0xe7,   0xc7,   0xa7,   0x87,   0x67,   0x47,   0x27,   0x07,
		0x24,   0x04,   0x64,   0x44,   0xa4,   0x84,   0xe4,   0xc4,
		0xa2,   0x82,   0xe2,   0xc2,   0x22,   0x02,   0x62,   0x42,
		0x61,   0x41,   0x21,   0x01,   0xe1,   0xc1,   0xa1,   0x81,
		0xba,   0x9a,   0xfa,   0xda,   0x3a,   0x1a,   0x7a,   0x5a,
		0x79,   0x59,   0x39,   0x19,   0xf9,   0xd9,   0xb9,   0x99,
		0xff,   0xdf,   0xbf,   0x9f,   0x7f,   0x5f,   0x3f,   0x1f,
		0x3c,   0x1c,   0x7c,   0x5c,   0xbc,   0x9c,   0xfc,   0xdc,
		0x30,   0x10,   0x70,   0x50,   0xb0,   0x90,   0xf0,   0xd0,
		0xf3,   0xd3,   0xb3,   0x93,   0x73,   0x53,   0x33,   0x13,
		0x75,   0x55,   0x35,   0x15,   0xf5,   0xd5,   0xb5,   0x95,
		0xb6,   0x96,   0xf6,   0xd6,   0x36,   0x16,   0x76,   0x56,
	], /* 133 */ [
		0x00,   0x85,   0xc9,   0x4c,   0x51,   0xd4,   0x98,   0x1d,
		0xa2,   0x27,   0x6b,   0xee,   0xf3,   0x76,   0x3a,   0xbf,
		0x87,   0x02,   0x4e,   0xcb,   0xd6,   0x53,   0x1f,   0x9a,
		0x25,   0xa0,   0xec,   0x69,   0x74,   0xf1,   0xbd,   0x38,
		0xcd,   0x48,   0x04,   0x81,   0x9c,   0x19,   0x55,   0xd0,
		0x6f,   0xea,   0xa6,   0x23,   0x3e,   0xbb,   0xf7,   0x72,
		0x4a,   0xcf,   0x83,   0x06,   0x1b,   0x9e,   0xd2,   0x57,
		0xe8,   0x6d,   0x21,   0xa4,   0xb9,   0x3c,   0x70,   0xf5,
		0x59,   0xdc,   0x90,   0x15,   0x08,   0x8d,   0xc1,   0x44,
		0xfb,   0x7e,   0x32,   0xb7,   0xaa,   0x2f,   0x63,   0xe6,
		0xde,   0x5b,   0x17,   0x92,   0x8f,   0x0a,   0x46,   0xc3,
		0x7c,   0xf9,   0xb5,   0x30,   0x2d,   0xa8,   0xe4,   0x61,
		0x94,   0x11,   0x5d,   0xd8,   0xc5,   0x40,   0x0c,   0x89,
		0x36,   0xb3,   0xff,   0x7a,   0x67,   0xe2,   0xae,   0x2b,
		0x13,   0x96,   0xda,   0x5f,   0x42,   0xc7,   0x8b,   0x0e,
		0xb1,   0x34,   0x78,   0xfd,   0xe0,   0x65,   0x29,   0xac,
		0xb2,   0x37,   0x7b,   0xfe,   0xe3,   0x66,   0x2a,   0xaf,
		0x10,   0x95,   0xd9,   0x5c,   0x41,   0xc4,   0x88,   0x0d,
		0x35,   0xb0,   0xfc,   0x79,   0x64,   0xe1,   0xad,   0x28,
		0x97,   0x12,   0x5e,   0xdb,   0xc6,   0x43,   0x0f,   0x8a,
		0x7f,   0xfa,   0xb6,   0x33,   0x2e,   0xab,   0xe7,   0x62,
		0xdd,   0x58,   0x14,   0x91,   0x8c,   0x09,   0x45,   0xc0,
		0xf8,   0x7d,   0x31,   0xb4,   0xa9,   0x2c,   0x60,   0xe5,
		0x5a,   0xdf,   0x93,   0x16,   0x0b,   0x8e,   0xc2,   0x47,
		0xeb,   0x6e,   0x22,   0xa7,   0xba,   0x3f,   0x73,   0xf6,
		0x49,   0xcc,   0x80,   0x05,   0x18,   0x9d,   0xd1,   0x54,
		0x6c,   0xe9,   0xa5,   0x20,   0x3d,   0xb8,   0xf4,   0x71,
		0xce,   0x4b,   0x07,   0x82,   0x9f,   0x1a,   0x56,   0xd3,
		0x26,   0xa3,   0xef,   0x6a,   0x77,   0xf2,   0xbe,   0x3b,
		0x84,   0x01,   0x4d,   0xc8,   0xd5,   0x50,   0x1c,   0x99,
		0xa1,   0x24,   0x68,   0xed,   0xf0,   0x75,   0x39,   0xbc,
		0x03,   0x86,   0xca,   0x4f,   0x52,   0xd7,   0x9b,   0x1e,
	], /* 148 */ [
		0x00,   0x94,   0xeb,   0x7f,   0x15,   0x81,   0xfe,   0x6a,
		0x2a,   0xbe,   0xc1,   0x55,   0x3f,   0xab,   0xd4,   0x40,
		0x54,   0xc0,   0xbf,   0x2b,   0x41,   0xd5,   0xaa,   0x3e,
		0x7e,   0xea,   0x95,   0x01,   0x6b,   0xff,   0x80,   0x14,
		0xa8,   0x3c,   0x43,   0xd7,   0xbd,   0x29,   0x56,   0xc2,
		0x82,   0x16,   0x69,   0xfd,   0x97,   0x03,   0x7c,   0xe8,
		0xfc,   0x68,   0x17,   0x83,   0xe9,   0x7d,   0x02,   0x96,
		0xd6,   0x42,   0x3d,   0xa9,   0xc3,   0x57,   0x28,   0xbc,
		0x93,   0x07,   0x78,   0xec,   0x86,   0x12,   0x6d,   0xf9,
		0xb9,   0x2d,   0x52,   0xc6,   0xac,   0x38,   0x47,   0xd3,
		0xc7,   0x53,   0x2c,   0xb8,   0xd2,   0x46,   0x39,   0xad,
		0xed,   0x79,   0x06,   0x92,   0xf8,   0x6c,   0x13,   0x87,
		0x3b,   0xaf,   0xd0,   0x44,   0x2e,   0xba,   0xc5,   0x51,
		0x11,   0x85,   0xfa,   0x6e,   0x04,   0x90,   0xef,   0x7b,
		0x6f,   0xfb,   0x84,   0x10,   0x7a,   0xee,   0x91,   0x05,
		0x45,   0xd1,   0xae,   0x3a,   0x50,   0xc4,   0xbb,   0x2f,
		0xe5,   0x71,   0x0e,   0x9a,   0xf0,   0x64,   0x1b,   0x8f,
		0xcf,   0x5b,   0x24,   0xb0,   0xda,   0x4e,   0x31,   0xa5,
		0xb1,   0x25,   0x5a,   0xce,   0xa4,   0x30,   0x4f,   0xdb,
		0x9b,   0x0f,   0x70,   0xe4,   0x8e,   0x1a,   0x65,   0xf1,
		0x4d,   0xd9,   0xa6,   0x32,   0x58,   0xcc,   0xb3,   0x27,
		0x67,   0xf3,   0x8c,   0x18,   0x72,   0xe6,   0x99,   0x0d,
		0x19,   0x8d,   0xf2,   0x66,   0x0c,   0x98,   0xe7,   0x73,
		0x33,   0xa7,   0xd8,   0x4c,   0x26,   0xb2,   0xcd,   0x59,
		0x76,   0xe2,   0x9d,   0x09,   0x63,   0xf7,   0x88,   0x1c,
		0x5c,   0xc8,   0xb7,   0x23,   0x49,   0xdd,   0xa2,   0x36,
		0x22,   0xb6,   0xc9,   0x5d,   0x37,   0xa3,   0xdc,   0x48,
		0x08,   0x9c,   0xe3,   0x77,   0x1d,   0x89,   0xf6,   0x62,
		0xde,   0x4a,   0x35,   0xa1,   0xcb,   0x5f,   0x20,   0xb4,
		0xf4,   0x60,   0x1f,   0x8b,   0xe1,   0x75,   0x0a,   0x9e,
		0x8a,   0x1e,   0x61,   0xf5,   0x9f,   0x0b,   0x74,   0xe0,
		0xa0,   0x34,   0x4b,   0xdf,   0xb5,   0x21,   0x5e,   0xca,
	], /* 192 */ [
		0x00,   0xc0,   0x43,   0x83,   0x86,   0x46,   0xc5,   0x05,
		0xcf,   0x0f,   0x8c,   0x4c,   0x49,   0x89,   0x0a,   0xca,
		0x5d,   0x9d,   0x1e,   0xde,   0xdb,   0x1b,   0x98,   0x58,
		0x92,   0x52,   0xd1,   0x11,   0x14,   0xd4,   0x57,   0x97,
		0xba,   0x7a,   0xf9,   0x39,   0x3c,   0xfc,   0x7f,   0xbf,
		0x75,   0xb5,   0x36,   0xf6,   0xf3,   0x33,   0xb0,   0x70,
		0xe7,   0x27,   0xa4,   0x64,   0x61,   0xa1,   0x22,   0xe2,
		0x28,   0xe8,   0x6b,   0xab,   0xae,   0x6e,   0xed,   0x2d,
		0xb7,   0x77,   0xf4,   0x34,   0x31,   0xf1,   0x72,   0xb2,
		0x78,   0xb8,   0x3b,   0xfb,   0xfe,   0x3e,   0xbd,   0x7d,
		0xea,   0x2a,   0xa9,   0x69,   0x6c,   0xac,   0x2f,   0xef,
		0x25,   0xe5,   0x66,   0xa6,   0xa3,   0x63,   0xe0,   0x20,
		0x0d,   0xcd,   0x4e,   0x8e,   0x8b,   0x4b,   0xc8,   0x08,
		0xc2,   0x02,   0x81,   0x41,   0x44,   0x84,   0x07,   0xc7,
		0x50,   0x90,   0x13,   0xd3,   0xd6,   0x16,   0x95,   0x55,
		0x9f,   0x5f,   0xdc,   0x1c,   0x19,   0xd9,   0x5a,   0x9a,
		0xad,   0x6d,   0xee,   0x2e,   0x2b,   0xeb,   0x68,   0xa8,
		0x62,   0xa2,   0x21,   0xe1,   0xe4,   0x24,   0xa7,   0x67,
		0xf0,   0x30,   0xb3,   0x73,   0x76,   0xb6,   0x35,   0xf5,
		0x3f,   0xff,   0x7c,   0xbc,   0xb9,   0x79,   0xfa,   0x3a,
		0x17,   0xd7,   0x54,   0x94,   0x91,   0x51,   0xd2,   0x12,
		0xd8,   0x18,   0x9b,   0x5b,   0x5e,   0x9e,   0x1d,   0xdd,
		0x4a,   0x8a,   0x09,   0xc9,   0xcc,   0x0c,   0x8f,   0x4f,
		0x85,   0x45,   0xc6,   0x06,   0x03,   0xc3,   0x40,   0x80,
		0x1a,   0xda,   0x59,   0x99,   0x9c,   0x5c,   0xdf,   0x1f,
		0xd5,   0x15,   0x96,   0x56,   0x53,   0x93,   0x10,   0xd0,
		0x47,   0x87,   0x04,   0xc4,   0xc1,   0x01,   0x82,   0x42,
		0x88,   0x48,   0xcb,   0x0b,   0x0e,   0xce,   0x4d,   0x8d,
		0xa0,   0x60,   0xe3,   0x23,   0x26,   0xe6,   0x65,   0xa5,
		0x6f,   0xaf,   0x2c,   0xec,   0xe9,   0x29,   0xaa,   0x6a,
		0xfd,   0x3d,   0xbe,   0x7e,   0x7b,   0xbb,   0x38,   0xf8,
		0x32,   0xf2,   0x71,   0xb1,   0xb4,   0x74,   0xf7,   0x37,
	], /* 194 */ [
		0x00,   0xc2,   0x47,   0x85,   0x8e,   0x4c,   0xc9,   0x0b,
		0xdf,   0x1d,   0x98,   0x5a,   0x51,   0x93,   0x16,   0xd4,
		0x7d,   0xbf,   0x3a,   0xf8,   0xf3,   0x31,   0xb4,   0x76,
		0xa2,   0x60,   0xe5,   0x27,   0x2c,   0xee,   0x6b,   0xa9,
		0xfa,   0x38,   0xbd,   0x7f,   0x74,   0xb6,   0x33,   0xf1,
		0x25,   0xe7,   0x62,   0xa0,   0xab,   0x69,   0xec,   0x2e,
		0x87,   0x45,   0xc0,   0x02,   0x09,   0xcb,   0x4e,   0x8c,
		0x58,   0x9a,   0x1f,   0xdd,   0xd6,   0x14,   0x91,   0x53,
		0x37,   0xf5,   0x70,   0xb2,   0xb9,   0x7b,   0xfe,   0x3c,
		0xe8,   0x2a,   0xaf,   0x6d,   0x66,   0xa4,   0x21,   0xe3,
		0x4a,   0x88,   0x0d,   0xcf,   0xc4,   0x06,   0x83,   0x41,
		0x95,   0x57,   0xd2,   0x10,   0x1b,   0xd9,   0x5c,   0x9e,
		0xcd,   0x0f,   0x8a,   0x48,   0x43,   0x81,   0x04,   0xc6,
		0x12,   0xd0,   0x55,   0x97,   0x9c,   0x5e,   0xdb,   0x19,
		0xb0,   0x72,   0xf7,   0x35,   0x3e,   0xfc,   0x79,   0xbb,
		0x6f,   0xad,   0x28,   0xea,   0xe1,   0x23,   0xa6,   0x64,
		0x6e,   0xac,   0x29,   0xeb,   0xe0,   0x22,   0xa7,   0x65,
		0xb1,   0x73,   0xf6,   0x34,   0x3f,   0xfd,   0x78,   0xba,
		0x13,   0xd1,   0x54,   0x96,   0x9d,   0x5f,   0xda,   0x18,
		0xcc,   0x0e,   0x8b,   0x49,   0x42,   0x80,   0x05,   0xc7,
		0x94,   0x56,   0xd3,   0x11,   0x1a,   0xd8,   0x5d,   0x9f,
		0x4b,   0x89,   0x0c,   0xce,   0xc5,   0x07,   0x82,   0x40,
		0xe9,   0x2b,   0xae,   0x6c,   0x67,   0xa5,   0x20,   0xe2,
		0x36,   0xf4,   0x71,   0xb3,   0xb8,   0x7a,   0xff,   0x3d,
		0x59,   0x9b,   0x1e,   0xdc,   0xd7,   0x15,   0x90,   0x52,
		0x86,   0x44,   0xc1,   0x03,   0x08,   0xca,   0x4f,   0x8d,
		0x24,   0xe6,   0x63,   0xa1,   0xaa,   0x68,   0xed,   0x2f,
		0xfb,   0x39,   0xbc,   0x7e,   0x75,   0xb7,   0x32,   0xf0,
		0xa3,   0x61,   0xe4,   0x26,   0x2d,   0xef,   0x6a,   0xa8,
		0x7c,   0xbe,   0x3b,   0xf9,   0xf2,   0x30,   0xb5,   0x77,
		0xde,   0x1c,   0x99,   0x5b,   0x50,   0x92,   0x17,   0xd5,
		0x01,   0xc3,   0x46,   0x84,   0x8f,   0x4d,   0xc8,   0x0a,
	], /* 251 */ [
		0x00,   0xfb,   0x35,   0xce,   0x6a,   0x91,   0x5f,   0xa4,
		0xd4,   0x2f,   0xe1,   0x1a,   0xbe,   0x45,   0x8b,   0x70,
		0x6b,   0x90,   0x5e,   0xa5,   0x01,   0xfa,   0x34,   0xcf,
		0xbf,   0x44,   0x8a,   0x71,   0xd5,   0x2e,   0xe0,   0x1b,
		0xd6,   0x2d,   0xe3,   0x18,   0xbc,   0x47,   0x89,   0x72,
		0x02,   0xf9,   0x37,   0xcc,   0x68,   0x93,   0x5d,   0xa6,
		0xbd,   0x46,   0x88,   0x73,   0xd7,   0x2c,   0xe2,   0x19,
		0x69,   0x92,   0x5c,   0xa7,   0x03,   0xf8,   0x36,   0xcd,
		0x6f,   0x94,   0x5a,   0xa1,   0x05,   0xfe,   0x30,   0xcb,
		0xbb,   0x40,   0x8e,   0x75,   0xd1,   0x2a,   0xe4,   0x1f,
		0x04,   0xff,   0x31,   0xca,   0x6e,   0x95,   0x5b,   0xa0,
		0xd0,   0x2b,   0xe5,   0x1e,   0xba,   0x41,   0x8f,   0x74,
		0xb9,   0x42,   0x8c,   0x77,   0xd3,   0x28,   0xe6,   0x1d,
		0x6d,   0x96,   0x58,   0xa3,   0x07,   0xfc,   0x32,   0xc9,
		0xd2,   0x29,   0xe7,   0x1c,   0xb8,   0x43,   0x8d,   0x76,
		0x06,   0xfd,   0x33,   0xc8,   0x6c,   0x97,   0x59,   0xa2,
		0xde,   0x25,   0xeb,   0x10,   0xb4,   0x4f,   0x81,   0x7a,
		0x0a,   0xf1,   0x3f,   0xc4,   0x60,   0x9b,   0x55,   0xae,
		0xb5,   0x4e,   0x80,   0x7b,   0xdf,   0x24,   0xea,   0x11,
		0x61,   0x9a,   0x54,   0xaf,   0x0b,   0xf0,   0x3e,   0xc5,
		0x08,   0xf3,   0x3d,   0xc6,   0x62,   0x99,   0x57,   0xac,
		0xdc,   0x27,   0xe9,   0x12,   0xb6,   0x4d,   0x83,   0x78,
		0x63,   0x98,   0x56,   0xad,   0x09,   0xf2,   0x3c,   0xc7,
		0xb7,   0x4c,   0x82,   0x79,   0xdd,   0x26,   0xe8,   0x13,
		0xb1,   0x4a,   0x84,   0x7f,   0xdb,   0x20,   0xee,   0x15,
		0x65,   0x9e,   0x50,   0xab,   0x0f,   0xf4,   0x3a,   0xc1,
		0xda,   0x21,   0xef,   0x14,   0xb0,   0x4b,   0x85,   0x7e,
		0x0e,   0xf5,   0x3b,   0xc0,   0x64,   0x9f,   0x51,   0xaa,
		0x67,   0x9c,   0x52,   0xa9,   0x0d,   0xf6,   0x38,   0xc3,
		0xb3,   0x48,   0x86,   0x7d,   0xd9,   0x22,   0xec,   0x17,
		0x0c,   0xf7,   0x39,   0xc2,   0x66,   0x9d,   0x53,   0xa8,
		0xd8,   0x23,   0xed,   0x16,   0xb2,   0x49,   0x87,   0x7c,
	],
];
