use anyhow::Result;
use assert_cmd::Command;
use common::{BIN, GNUPGHOME, PASSWORD_STORE_DIR};
use tempfile::tempdir;
mod common;

const KUBEPASSGEN: &str = r#"
[opaque.name]
SECRET="test_pass"
"#;

const EXPECTED: &str = r#"---
apiVersion: v1
kind: Secret
type: Opaque
metadata:
  name: name
data:
  SECRET: VGVzdFNlY3JldAo=

"#;

#[test]
fn opaque_withoutns() -> Result<()> {
    let gpg_home = tempdir()?;
    let work_dir = tempdir()?;

    common::setup(&gpg_home, &work_dir, &KUBEPASSGEN)?;

    Command::cargo_bin(BIN)?
        .env(GNUPGHOME, gpg_home.path())
        .env(PASSWORD_STORE_DIR, work_dir.path().join(".password-store"))
        .current_dir(work_dir.path())
        .assert()
        .success()
        .stdout(EXPECTED);

    Ok(())
}
