use assert_cmd::Command;
use std::io::Write;
use tempfile::TempDir;

use super::{GNUPGHOME, PASSWORD_STORE_DIR};

const GPG_BATCH: &str = r#"
    %no-protection
    %transient-key
    Key-Type: default
    Subkey-Type: default
    Name-Real: Joe Tester
    Name-Comment: with stupid passphrase
    Name-Email: joe@foo.bar
    Expire-Date: 0
"#;

pub fn setup(gpg_home: &TempDir, work_dir: &TempDir, kubepassgentoml: &str) -> anyhow::Result<()> {
    Command::new("gpg")
        .env(GNUPGHOME, gpg_home.path())
        .arg("--batch")
        .arg("--generate-key")
        .write_stdin(GPG_BATCH)
        .assert()
        .success();

    Command::new("pass")
        .env(GNUPGHOME, gpg_home.path())
        .env(PASSWORD_STORE_DIR, work_dir.path().join(".password-store"))
        .arg("init")
        .arg("joe@foo.bar")
        .assert()
        .success();

    Command::new("pass")
        .env(GNUPGHOME, gpg_home.path())
        .env(PASSWORD_STORE_DIR, work_dir.path().join(".password-store"))
        .arg("insert")
        .arg("-e")
        .arg("test_pass")
        .write_stdin("TestSecret")
        .assert()
        .success();

    Command::new("pass")
        .env(GNUPGHOME, gpg_home.path())
        .env(PASSWORD_STORE_DIR, work_dir.path().join(".password-store"))
        .arg("insert")
        .arg("-e")
        .arg("other_pass")
        .write_stdin("OtherSecret")
        .assert()
        .success();

    let kube_pass_gen = work_dir.path().join("kubepassgen.toml");

    let mut config = std::fs::File::create(kube_pass_gen)?;
    config.write_all(kubepassgentoml.as_bytes())?;

    Ok(())
}
