use serde::Serialize;
use std::collections::BTreeMap;

#[derive(Serialize, Debug)]
pub struct Manifest {
    #[serde(rename = "apiVersion")]
    pub api_version: ApiVersion,
    pub kind: Kind,
    #[serde(rename = "type")]
    pub type_: Type,
    pub metadata: Metadata,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub data: Option<Data>,
}

#[derive(Serialize, Debug)]
pub enum ApiVersion {
    #[serde(rename = "v1")]
    V1,
}

#[derive(Serialize, Debug)]
pub enum Kind {
    Secret,
}

#[derive(Serialize, Debug)]
pub enum Type {
    Opaque,
}

#[derive(Serialize, Debug)]
pub struct Metadata {
    pub name: String,

    #[serde(skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
}

#[derive(Serialize, Debug)]
pub struct Data(pub BTreeMap<Key, Base64>);

#[derive(Serialize, Debug, Hash, PartialEq, Eq, Ord, PartialOrd)]
#[serde(transparent)]
pub struct Key(pub String);

#[derive(Serialize, Debug)]
#[serde(transparent)]
pub struct Base64(String);

impl Base64 {
    pub fn encode(bytes: &[u8]) -> Base64 {
        let text = base64::encode(bytes);
        Base64(text)
    }
}
