# kubepassgen

A tool for converting [passwordstore.org](https://www.passwordstore.org/) 
passwords to kubernetes secrets

## Usage

Run `kubepassgen` and it will read the kubepassgen.toml file in the current directory, emitting the secrets to stdout.
Theis could be written to a file with `kubepassgen > mysecrets.yaml` though this is not default behaviour just in case (these are secrets you know)

Run `kubepassgen --help` for various flags.

## Motivation

This was a way of easily extracting the secrets to be used with kubernetes. Password store allows you to use git and gpg to keep your secrets
shared, but managed without any third party services. By combining the too, you don't need extra providers and can use the simple and proven pass cli.

A key part of the motivation of this tool is the sample script for usage with kustomize. This is a bit of a wrapper, but can be used to build deploys, with
secrets in passwordstore. Password store can be even added as a git subrepo, which would allow precise tracking of the secrets in the deploy git repo.
You would need to set some environment variables to use this

## Contributing

This project is hosted on sourcehut, and will accept patches via the ~btrepp/public-inbox@lists.sr.ht mailing list.
If reporting a bug or adding extra functionality, they must come with an associated cli test (see tests).

The CLI tests will generate gpg keys and password store configurations. So they should be self-contained.

## Configuration file

The `kubepassgen.toml` file is where all the configuration happens
this can store multiple secrets, and will ultimately lead to multiple secrets being generated.

This is in toml as it is very easy to read and parse. It also helps visually seperate that this tool
isn't part of k8s.


### Opaque

```
[opaque.namespace.secret]
KEY="pass/path"
```

This will generate

```
apiVersion: v1
kind: Secret
type: Opaque
metadata:
  name: name
  namespace: namespace
data:
  KEY: ...
```

Note: if the namespace is omitted such as `[opaque.secret]` it won't be written out.
This is useful if you don't care for the namespace

### Dockerconfigjson

Intent is to write this, though it isn't done yet.


## Kustomize

The below shell is an example of using with kustomize
It creates a new kustomization directory, and adds in the secret.

This then patches the base with your password store secrets, and prints to std out

```
#!/bin/sh
WORK=$(mktemp -d)
trap 'rm -rf -- "$WORK"' EXIT
BASE=$(realpath --relative-to=$WORK $PWD)

cat << EOF > $WORK/kustomization.yaml
resources:
- $BASE

patchesStrategicMerge:
- secret.yaml
EOF

kubepassgen > $WORK/secret.yaml
kustomize build $WORK
```