#![allow(unused_must_use)]

mod cli;
mod goodies;
mod send;
mod read;

use structopt::StructOpt;

fn main() {
    let opt = cli::Opt::from_args();

    if opt.is_requesting_uptime() {
        send::uptime(opt.get_timeout(), read::uptime());
        return;
    }

    if opt.is_requesting_date_time() {
        send::date_time(opt.get_timeout(), read::date_time());
        return;
    }

    if opt.is_requesting_battery() {
        send::battery(opt.get_timeout(), read::battery());
        return;
    }

    if opt.is_requesting_network() {
        send::network(opt.get_timeout(), read::network(opt.get_interface()));
        return;
    }

    if opt.is_requesting_memory() {
        send::memory(opt.get_timeout(), read::memory());
    }
}
