# ksynth-rs

## Dissection of a patch

WizooIni is a Kawai K5000 single patch found in the book "Introduction to Additive Synthesis:
Advanced Sound Design Tips and Tricks" by Dave Bellingham and Peter Gorges.

I exported it as a MIDI System Exclusive file from the Kawai K5000 and created a hex dump.

    0xf0, 0x40, 0x00, 0x20, 0x00, 0x0a, 0x00, 0x00, 0x00,   // System Exclusive header, Tone No. 00
    0x09,  // checksum

    // Effect data
    0x00,  // effect algorithm
    0x00,  // reverb type
    0x02,  // reverb dry/wet
    0x02,  // reverb param 1
    0x0d,  // reverb param 2
    0x41,  // reverb param 3
    0x0a,  // reverb param 4
    0x10,  // effect 1 type
    0x00,  // effect 1 depth
    0x58,  // effect 1 param 1
    0x33,  // effect 1 param 2
    0x69,  // effect 1 param 3
    0x22,  // effect 1 param 4
    0x1d, 0x00, 0x4a, 0x00, 0x00, 0x00,  // effect 2 (as above)
    0x24, 0x00, 0x04, 0x3a, 0x04, 0x38,  // effect 3 (as above)
    0x2a, 0x00, 0x0c, 0x0c, 0x63, 0x00,  // effect 4 (as above)
    0x42, 0x41, 0x40, 0x40, 0x3f, 0x3e, 0x41, // GEQ
    0x00,  // "drum mark"
    0x57, 0x69, 0x7a, 0x6f, 0x6f, 0x49, 0x6e, 0x69,  // name "WizooIni"
    0x73,  // volume
    0x00,  // polyphony
    0x00,  // "no use"
    0x02,  // no. of sources
    0x01,  // source mutes
    0x00,  // AM

    // Effect control
    0x02, 0x01, 0x40,  // control source 1, destination, depth
    0x01, 0x03, 0x40,  // control source 2, destination, depth
    0x00, 0x00,  // portamento flag and p. speed

    // Macro controllers
    0x00, 0x00,  // macro controller 1 params 1 and 2
    0x00, 0x00,  // macro controller 2 params 1 and 2
    0x00, 0x00,  // macro controller 3 params 1 and 2
    0x00, 0x00,  // macro controller 4 params 1 and 2
    0x40, 0x40,  // macro controller 1 param 1 and param 2 depths
    0x40, 0x40,  // macro controller 2 param 1 and param 2 depths
    0x40, 0x40,  // macro controller 3 param 1 and param 2 depths
    0x40, 0x40,  // macro controller 4 param 1 and param 2 depths
    0x00, 0x00, 0x00, 0x00,  // SW1, SW2, F.SW1, F.SW2

    // COMMON = 81 bytes

    // Source 1
    0x00, 0x7f,  // zone low and high
    0x10,  // velocity switch
    0x00,  // effect path
    0x78,  // volume
    0x02, 0x0c,  // bender pitch and cutoff
    0x01, 0x4f, 0x03, 0x40,  // press: destination 1, depth, destination 2, depth
    0x03, 0x59, 0x01, 0x40,  // wheel: destination 1, depth, destination 2, depth
    0x02, 0x5f, 0x00, 0x40,  // express: destination 1, depth, destination 2, depth
    0x02, 0x0d, 0x40,  // assignable: control source 1, destination, depth
    0x02, 0x09, 0x40,  // assignable: control source 2, destination, depth
    0x00,  // key on delay
    0x00, 0x40,  // pan type and value
    0x04, 0x00,  // wave kit MSB and LSB
    0x40,  // coarse
    0x40,  // fine
    0x00,  // fixed key
    0x00,  // ks pitch
    0x40, 0x04, 0x40, 0x40, 0x40, 0x40,  // pitch envelope

    // DCF
    0x00,  // 0=active, 1=bypass
    0x00,  // mode: 0=low pass, 1=high pass
    0x04,  // velocity curve
    0x00,  // resonance
    0x00,  // DCF level
    0x37,  // cutoff
    0x60,  // cutoff ks depth
    0x40,  // cutoff velo depth
    0x59,  // DCF env depth
    0x00, 0x78, 0x7f, 0x50, 0x7f, 0x14,  // DCF envelope
    0x40, 0x40,  // DCF KS to Env
    0x5e, 0x40, 0x40,  // DCF Vel to Env

    // DCA
    0x04,  // vel curve
    0x01, 0x5e, 0x7f, 0x3f, 0x7f, 0x0f,  // DCA env
    0x40, 0x40, 0x40, 0x40,  // DCA KS to Env
    0x14, 0x40, 0x40, 0x40,  // DCA Vel Sense
    0x00,  // LFO waveform
    0x5d,  // LFO speed
    0x00,  // LFO delay onset
    0x00,  //  fade in time
    0x00,  //  fade in to speed
    0x00, 0x40,  // pitch (vibrato) depth and KS
    0x00, 0x40,  // DCF (growl) depth and KS
    0x00, 0x40,  // DCA (tremolo) depth and KS

    // Source 2
    0x00, 0x7f,
    0x10,
    0x00,
    0x78,
    0x02, 0x0c,
    0x01, 0x4f, 0x03, 0x40,
    0x03, 0x59, 0x01, 0x40,
    0x02, 0x5f, 0x00, 0x40,
    0x02, 0x0d, 0x40,
    0x02, 0x09, 0x40,
    0x00,
    0x00, 0x40,
    0x03, 0x1b,  // wave kit LSB and MSB
    0x40,
    0x40,
    0x00,
    0x00,
    0x40, 0x04, 0x40, 0x40, 0x40, 0x40,

    0x00,
    0x00,
    0x04,
    0x00,
    0x00,
    0x37,
    0x60,
    0x40,
    0x59,
    0x00, 0x78, 0x7f, 0x50, 0x7f, 0x14,
    0x40, 0x40,
    0x5e, 0x40, 0x40,

    0x04,
    0x01, 0x5e, 0x7f, 0x3f, 0x7f, 0x0f,
    0x40, 0x40, 0x40, 0x40,
    0x14, 0x40, 0x40, 0x40,
    0x00,
    0x5d,
    0x00,
    0x00,
    0x00,
    0x00, 0x40,
    0x00, 0x40,
    0x00, 0x40,

    // Additive kit
    0x26,  // checksum

    // MORF common
    0x00,  // MORF flag
    0x37,  // total gain
    0x00,
    0x40,  // KS to gain
    0x04,  // balance vel curve
    0x00,  // balance vel depth

    0x00, 0x00,  // HC1 patch and source
    0x00, 0x00,  // HC2 patch and source
    0x00, 0x00,  // HC3 patch and source
    0x00, 0x00,  // HC4 patch and source
    0x40, 0x40, 0x40, 0x40, 0x00,  // HE time1...4 and loop

    // Formant filter
    0x36,  // bias
    0x00,  // env/LFO sel

    0x40,  // env depth
    0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x01, 0x40, 0x40, 0x40, 0x00, 0x00,
    0x7f, 0x79, 0x75, 0x71, 0x6e, 0x6a, 0x66, 0x65, 0x64, 0x63,
    0x62, 0x61, 0x60, 0x5f, 0x5e, 0x5d, 0x5c, 0x5b, 0x5a, 0x59,
    0x58, 0x57, 0x56, 0x55, 0x54, 0x53, 0x52, 0x51, 0x50, 0x4f,
    0x4e, 0x4e, 0x4e, 0x4d, 0x4d, 0x4d, 0x4c, 0x4c, 0x4c, 0x4b,
    0x4b, 0x4b, 0x4a, 0x49, 0x48, 0x47, 0x46, 0x45, 0x44, 0x43,
    0x42, 0x41, 0x40, 0x3f, 0x3e, 0x3d, 0x3c, 0x3b, 0x3a, 0x39,
    0x38, 0x37, 0x36, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f,
    0x76, 0x69, 0x5a, 0x3c, 0x1e, 0x01, 0x7f, 0x3f, 0x7f, 0x3f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x3f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x3f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f,
    0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f,
    0x7f, 0x3f, 0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f,
    0x00, 0x00, 0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00,
    0x7f, 0x3f, 0x7f, 0x7f, 0x7f, 0x3f, 0x00, 0x00, 0x00, 0xf7
]