# Milestone: 0.1.0

| Command | Introduced | Use |
| :--- | :--- | :-- |
| `append`  | [`9c23bf7`] | `Command::Strings(StringCommand::Append("seinfeld", "kramer")))` |
| `blpop`   | [`d27df86`] | `ListCommand::Pop(Side::Left, "seinfeld", Some((None, 10)))` |
| `brpop`   | [`d27df86`] | `ListCommand::Pop(Side::Right, "seinfeld", Some((None, 10)))` |
| `decr`    | [`d27df86`] | `Command::Decr("seinfeld", 1)` |
| `decrby`  | [`d51737e`] | `Command::Decr("seinfeld", 2)` |
| `del`     | [`1a15a9e`] | `Command::Del(Arity::One("seinfeld"))` |
| `echo`    | [`a851137`] | `Command::Echo("seinfeld")` |
| `exists`  | [`1a15a9e`] | `Command::Exists("seinfeld")` |
| `get`     | [`9c23bf7`] | `StringCommand::Get(Arity::One("seinfeld"))` |
| `hdel`    | [`cd15162`] | `HashCommand::Del("seinfeld", "name", None))` |
| `hexists` | [`220d748`] | `HashCommand::Exists("seinfeld", "name"))` |
| `hget`    | [`220d748`] | `HashCommand::Get("seinfeld", Some(Arity::One("name"))))` |
| `hgetall` | [`220d748`] | `HashCOmmand::Get("Seinfeld", None))` |
| `hincrby` | [`9ccd5fe`] | `HashCommand::Incr("counters", "episodes", 10)` |
| `hkeys`   | [`220d748`] | `HashCommand::Keys("seinfeld")` |
| `hlen`    | [`220d748`] | `HashCommand::Len("seinfeld")` |
| `hmget`   | [`220d748`] | `HashCommand::Get("seinfeld", Some(Arity::Many(vec!["name", "friend"])))` |
| `hset`    | [`9e08436`] | `HashCommand::Set("seinfeld", Arity::One(("name", "kramer")), Insertion::Always)` |
| `hsetnx`  | [`9e08436`] | `HashCommand::Set("seinfeld", Arity::One(("name", "kramer")), Insertion::IfNotExists)` |
| `hstrlen` | [`9ccd5fe`] | `HashCommand::StrLen("seinfeld", "name")` |
| `hvals`   | [`9ccd5fe`] | `HashCommand::Vals("seinfeld")` |
| `incr`    | [`ea58902`] | `StringCommand::Incr("episodes", 1)` |
| `incrby`  | [`ea58902`] | `StringCommand::Incr("episodes", 10)` |
| `keys`    | [`1a15a9e`] | `Command::Keys("*")` |
| `lindex`  | [`ea58902`] | `Command::List(ListCommand::Index("episodes", 1))` |
| `linsert` | [`ea58902`] | `Command::List(ListCommand::Insert("episodes", Side::Left, "10", "100"))` |
| `llen`    | [`1a15a9e`] | `ListCommand::Len(key))` |
| `lpop`    | [`1a15a9e`] | `ListCommand::Pop(Side::Left, key, None))` |
| `lpush`   | [`1a15a9e`] | `ListCommand::Push((Side::Left, Insertion::Always), key, Arity::One("kramer")))` |
| `lpushx`  | [`7b4f430`] | `ListCommand::Push((Side::Left, Insertion::IfExists), key, Arity::One("kramer")))` |
| `lrange`  | [`1a15a9e`] | `ListCommand::Range("seinfeld", 0, -1)` |
| `lrem`    | [`ea58902`] | `Command::List(ListCommand::Rem("episodes", "10", 100))` |
| `lset`    | [`ea58902`] | `Command::List(ListCommand::Set("episodes", 1, "pilot"))` |
| `ltrim`   | [`ea58902`] | `Command::List(ListCommand::Trim("episodes", 0, 10))` |
| `mget`    | [`1a15a9e`] | `StringCommand::Get(Arity::Many(vec!["seinfeld", "peaky"]))` |
| `mset`    | [`8e6cab7`] | `StringCommand::Set(Arity::Many(vec![("name", "jerry")]), None, Insertion::Always)` |
| `mset`    | [`8e6cab7`] | `StringCommand::Set(Arity::Many(vec![("name", "jerry")]), None, Insertion::IfNotExists)` |
| `rpop`    | [`1a15a9e`] | `ListCommand::Pop(Side::Right, key, None)` |
| `rpush`   | [`1a15a9e`] | `ListCommand::Push((Side::Right, Insertion::Always), key, Arity::One("kramer")))` |
| `rpushx`  | [`1a15a9e`] | `ListCommand::Push((Side::Right, Insertion::IfExists), key, Arity::One("kramer")))` |
| `set`     | [`1a15a9e`] | `StringCommand::Set(Arity::One((key, "kramer")), None, Insertion::Always)` |

# Milestone: 0.2.0

| Command     | Introduced  | Use      |
| :---        | :----       | :----    |
| `spop`      | [`c7064d0`] |          |
| `srem`      | [`c7064d0`] |          |
| `sunion`    | [`5a42d0f`] |          |
| `sadd`      | [`4989ff3`] |          |
| `scard `    | [`dbcc06b`] |          |
| `sdiff`     | [`4a562fd`] |          |
| `sismember` | [`9ee6154`] |          |
| `sinter`    | [`9ee6154`] |          |
| `smembers`  | [`4989ff3`] |          |

# Milestone: 0.2.1

| Command     | Introduced  | Use      |
| :---        | :----       | :----    |
| `strlen`    |             |          |

# Milestone: 0.X.0

These commands are not currently in planning and _may_ not be implemented in this library.

- [ ] auth
- [ ] bitcount
- [ ] bitfield
- [ ] bitop
- [ ] bitpos
- [ ] bgrewriteaof
- [ ] bgsave
- [ ] brpoplpush
- [ ] bzpopmin
- [ ] bzpopmax
- [ ] discard
- [ ] dump
- [ ] eval
- [ ] evalsha
- [ ] exec
- [ ] expire
- [ ] expireat
- [ ] flushall
- [ ] flushdb
- [ ] geoadd
- [ ] geohash
- [ ] geopos
- [ ] geodist
- [ ] georadius
- [ ] georadiusbymember
- [ ] getbit
- [ ] getrange
- [ ] getset
- [ ] hincrbyfloat
- [ ] incrbyfloat
- [ ] info
- [ ] lastsave
- [ ] migrate
- [ ] move
- [ ] multi
- [ ] object
- [ ] persist
- [ ] pexpire
- [ ] pexpireat
- [ ] pfadd
- [ ] pfcount
- [ ] pfmerge
- [ ] ping
- [ ] psetex
- [ ] psubscribe
- [ ] pubsub
- [ ] pttl
- [ ] publish
- [ ] punsubscribe
- [ ] quit
- [ ] randomkey
- [ ] readonly
- [ ] readwrite
- [ ] rename
- [ ] renamenx
- [ ] restore
- [ ] role
- [ ] rpoplpush
- [ ] save
- [ ] sdiffstore
- [ ] select
- [ ] setbit
- [ ] setrange
- [ ] shutdown
- [ ] sinterstore
- [ ] slaveof
- [ ] replicaof
- [ ] slowlog
- [ ] smove
- [ ] sort
- [ ] srandmember
- [ ] subscribe
- [ ] sunionstore
- [ ] swapdb
- [ ] sync
- [ ] psync
- [ ] time
- [ ] touch
- [ ] ttl
- [ ] type
- [ ] unsubscribe
- [ ] unlink
- [ ] unwatch
- [ ] wait
- [ ] watch
- [ ] zadd
- [ ] zcard
- [ ] zcount
- [ ] zincrby
- [ ] zinterstore
- [ ] zlexcount
- [ ] zpopmax
- [ ] zpopmin
- [ ] zrange
- [ ] zrangebylex
- [ ] zrevrangebylex
- [ ] zrangebyscore
- [ ] zrank
- [ ] zrem
- [ ] zremrangebylex
- [ ] zremrangebyrank
- [ ] zremrangebyscore
- [ ] zrevrange
- [ ] zrevrangebyscore
- [ ] zrevrank
- [ ] zscore
- [ ] zunionstore
- [ ] scan
- [ ] sscan
- [ ] hscan
- [ ] zscan
- [ ] xinfo
- [ ] xadd
- [ ] xtrim
- [ ] xdel
- [ ] xrange
- [ ] xrevrange
- [ ] xlen
- [ ] xread
- [ ] xgroup
- [ ] xreadgroup
- [ ] xack
- [ ] xclaim
- [ ] xpending

# Wont-Do

The following commands are not part of the roadmap for this library.

- [ ] command
- [ ] command count
- [ ] command getkeys
- [ ] command info
- [ ] config get
- [ ] config rewrite
- [ ] config set
- [ ] config resetstat
- [ ] dbsize
- [ ] debug object
- [ ] debug segfault
- [ ] client id
- [ ] client kill
- [ ] client list
- [ ] client getname
- [ ] client pause
- [ ] client reply
- [ ] client setname
- [ ] client unblock
- [ ] cluster addslots
- [ ] cluster bumpepoch
- [ ] cluster count-failure-reports
- [ ] cluster countkeysinslot
- [ ] cluster delslots
- [ ] cluster failover
- [ ] cluster flushslots
- [ ] cluster forget
- [ ] cluster getkeysinslot
- [ ] cluster info
- [ ] cluster keyslot
- [ ] cluster meet
- [ ] cluster myid
- [ ] cluster nodes
- [ ] cluster replicate
- [ ] cluster reset
- [ ] cluster saveconfig
- [ ] cluster set-config-epoch
- [ ] cluster setslot
- [ ] cluster slaves
- [ ] cluster replicas
- [ ] cluster slots
- [ ] script debug
- [ ] script exists
- [ ] script flush
- [ ] script kill
- [ ] script load
- [ ] latency doctor
- [ ] latency graph
- [ ] latency history
- [ ] latency latest
- [ ] latency reset
- [ ] latency help
- [ ] lolwut
- [ ] memory doctor
- [ ] memory help
- [ ] memory malloc-stats
- [ ] memory purge
- [ ] memory stats
- [ ] memory usage
- [ ] module list
- [ ] module load
- [ ] module unload
- [ ] monitor

# Exceptions

- [ ] `setex` - unlikely to implement; can be accomplished with `set`
- [ ] `setnx` - unlikely to implement; can be accomplished with `set`
- [ ] `hmset` - `hset` can do many

> This list was generated by running the following script in the chrome developer tools on the [command][command-li]
> list page of the official redis website:
>
>     var items = Array.from(document.querySelectorAll('#commands li[data-name]'));
>     copy(items.map(li => li.getAttribute('data-name')).join('\n'))

[command-li]: https://redis.io/commands


[`1a15a9e`]: https://github.com/sizethree/kramer/commit/1a15a9eb89f0c5a23bb4ad9e52f0082997e017a0
[`220d748`]: https://github.com/sizethree/kramer/commit/220d748
[`7b4f430`]: https://github.com/sizethree/kramer/commit/7b4f430
[`8e6cab7`]: https://github.com/sizethree/kramer/commit/8e6cab7076527f00efc59d39b3c5258e6cd3f404
[`9c23bf7`]: https://github.com/sizethree/kramer/commit/9c23bf7a4282a4803b96a41824d47a60b3c176b5
[`9ccd5fe`]: https://github.com/sizethree/kramer/commit/9ccd5fe6f17aa6a1839fafb75859ff1b3ad3a49d
[`9e08436`]: https://github.com/sizethree/kramer/commit/9e08436
[`a851137`]: https://github.com/sizethree/kramer/commit/a8511379c77b52f78e85e3f2d5a4dd94ef1cd84e
[`cd15162`]: https://github.com/sizethree/kramer/commit/cd1516296c31707bb9bc5878b3b323b1629ba692
[`d27df86`]: https://github.com/sizethree/kramer/commit/d27df866b9c62ce47b18980354b3fc145e0fb3a2
[`d51737e`]: https://github.com/sizethree/kramer/commit/d51737e2911d883bf26d1659fb3b6be6057594fb
[`ea58902`]: https://github.com/sizethree/kramer/commit/ea58902003a13a951d60d37b7b7705082af6ee36
[`c7064d0`]: https://github.com/sizethree/kramer/pull/4/commits/c7064d0db30700ce071d83f1abe3323b2d49f0be
[`5a42d0f`]: https://github.com/sizethree/kramer/pull/4/commits/5a42d0fd256a6841b4ffb8bc13912f8ea06e4615
[`4989ff3`]: https://github.com/sizethree/kramer/pull/4/commits/4989ff39658be91db6b1c5a71aeaad3ee861602a
[`dbcc06b`]: https://github.com/sizethree/kramer/pull/4/commits/dbcc06b8faccaefba7f5bbb84a231c9e4eca1181
[`4a562fd`]: https://github.com/sizethree/kramer/pull/4/commits/4a562fd07ad954b608f6f4bdf5cc3ebd330b1b2f
[`9ee6154`]: https://github.com/sizethree/kramer/pull/4/commits/9ee615452da77fb343656b11ea1ba644fd1fb33c
