use super::Membership;

/// For each radical, a list of which kanji contain it from the `radkfile`
pub const MEMBERSHIPS: &[Membership] = &[
    Membership {
        radical: '一',
        strokes: 1,
        kanji: &[
            '一', '丁', '丂', '丄', '丅', '万', '丈', '三', '上', '下', '丌', '不', '与', '丐',
            '丑', '丒', '且', '丕', '世', '丘', '丙', '丞', '両', '丣', '两', '並', '丰', '丵',
            '丹', '乁', '乃', '乇', '乍', '乎', '乕', '乗', '乞', '乴', '乾', '了', '予', '争',
            '亊', '事', '云', '互', '井', '亘', '亙', '亜', '亞', '亨', '亯', '亳', '亶', '亹',
            '仃', '今', '仗', '仛', '仠', '仡', '令', '仨', '仱', '仵', '仾', '仿', '伂', '伃',
            '伕', '伖', '伳', '伶', '伹', '伺', '伻', '伾', '佂', '但', '佇', '佈', '低', '佐',
            '佑', '体', '何', '余', '作', '你', '佣', '佩', '佮', '佰', '佱', '併', '佽', '使',
            '侁', '侄', '來', '侉', '侊', '侌', '侑', '侖', '侗', '供', '侟', '侼', '便', '俁',
            '俅', '俉', '俌', '俒', '俜', '俣', '俸', '倁', '倄', '倉', '倎', '倚', '倛', '倢',
            '値', '倫', '倲', '倳', '倵', '倶', '倹', '偁', '偂', '偅', '偆', '偈', '偌', '偏',
            '偒', '偓', '偙', '停', '偪', '偰', '偱', '偸', '傃', '傓', '傔', '傖', '傞', '傷',
            '僀', '僅', '僉', '働', '像', '僐', '僓', '僔', '僜', '僱', '僵', '儀', '儃', '儇',
            '儈', '儉', '儐', '儗', '儙', '儛', '儜', '儞', '儧', '優', '儭', '儯', '儱', '儳',
            '儴', '兀', '兂', '光', '免', '兏', '兓', '兕', '兤', '兩', '兪', '共', '兵', '其',
            '具', '典', '兼', '円', '冉', '冊', '册', '再', '冓', '写', '冝', '冡', '冨', '冭',
            '冱', '冷', '冺', '冾', '凂', '凍', '减', '凑', '凘', '凮', '凳', '凸', '函', '刁',
            '刑', '刱', '券', '刼', '剄', '剅', '前', '剏', '剘', '剚', '剞', '剪', '副', '剰',
            '剳', '創', '剷', '剸', '劂', '劃', '劊', '劌', '劍', '劒', '劓', '劔', '劖', '劘',
            '劥', '劶', '劷', '勄', '勅', '勌', '動', '勤', '勩', '勪', '勬', '勲', '勶', '勷',
            '匀', '匌', '匐', '匬', '匱', '匲', '匳', '匼', '匾', '卅', '卋', '卌', '卍', '卙',
            '卡', '卣', '厇', '厈', '厔', '厦', '厷', '叀', '参', '友', '叙', '叚', '叠', '叮',
            '可', '右', '号', '司', '吂', '合', '同', '后', '吏', '吓', '君', '吟', '否', '含',
            '吴', '呞', '呭', '命', '咀', '咑', '咟', '咮', '咲', '咺', '哄', '哈', '哊', '哥',
            '哬', '哶', '哼', '哽', '哿', '唅', '唉', '唏', '唐', '唖', '唪', '唫', '唳', '唸',
            '唾', '啊', '啓', '啛', '啞', '啿', '喂', '喔', '喘', '喧', '喩', '喪', '喲', '嗄',
            '嗆', '嗉', '嗌', '嗒', '嗛', '嗞', '嗣', '嗶', '嘆', '嘈', '嘍', '嘎', '嘑', '嘒',
            '嘩', '嘳', '嘵', '嘸', '嘻', '嘼', '嘽', '噁', '噄', '噉', '噏', '噔', '噞', '噦',
            '噲', '嚅', '嚋', '嚌', '嚙', '嚝', '嚢', '嚥', '嚨', '嚩', '嚫', '嚭', '嚳', '嚷',
            '囂', '囊', '囍', '囏', '囙', '囥', '囨', '囹', '囿', '圇', '圊', '圏', '圑', '圚',
            '圛', '圜', '圢', '在', '圪', '圴', '圷', '坅', '坍', '坏', '坥', '坦', '坧', '坯',
            '坵', '坷', '坻', '坾', '垁', '垂', '型', '垌', '垕', '垙', '垞', '垣', '垪', '垸',
            '埡', '埧', '埵', '基', '埼', '堈', '堊', '堍', '堕', '堙', '堛', '堞', '堠', '堯',
            '場', '堹', '堿', '塀', '塍', '塐', '塔', '塗', '塘', '塞', '塟', '塧', '塩', '塲',
            '墈', '墊', '墌', '墖', '墝', '墟', '墠', '墡', '墲', '壇', '壎', '壐', '壔', '壖',
            '壙', '壡', '壤', '壩', '壳', '壷', '壺', '壼', '壽', '夆', '夏', '夒', '夓', '夔',
            '夤', '天', '央', '夷', '奇', '奉', '奏', '奔', '奡', '奣', '奫', '奭', '奯', '奵',
            '奼', '妋', '妌', '妍', '妒', '妗', '妛', '妤', '妰', '妲', '妳', '妷', '妺', '妻',
            '姃', '姈', '姍', '姝', '姤', '姧', '姮', '姯', '姶', '姷', '娀', '娉', '娒', '娨',
            '娪', '娭', '婀', '婁', '婌', '婞', '婭', '婷', '婻', '婾', '媋', '媙', '媟', '媠',
            '媵', '媸', '媺', '媻', '媾', '嫠', '嫣', '嫥', '嫮', '嫵', '嬈', '嬗', '嬛', '嬝',
            '嬭', '嬴', '孁', '孃', '孋', '孒', '存', '孳', '孺', '宁', '宅', '宏', '宐', '宑',
            '宜', '宣', '宥', '宱', '寄', '寅', '富', '寒', '寗', '寘', '寠', '寡', '實', '寧',
            '寨', '寰', '寴', '寿', '專', '尗', '尟', '尫', '尬', '尭', '尮', '尰', '尲', '尵',
            '尶', '尹', '屍', '屏', '展', '屙', '屜', '屢', '屧', '屨', '屰', '屼', '屽', '岑',
            '岝', '岡', '岢', '岨', '岳', '岴', '岺', '岻', '峇', '峒', '峝', '峠', '峯', '峰',
            '峱', '峺', '崋', '崎', '崘', '崙', '崤', '崴', '嵊', '嵑', '嵜', '嵿', '嶁', '嶧',
            '嶫', '嶮', '嶹', '嶺', '巃', '巎', '巘', '巙', '巠', '左', '巧', '巩', '巵', '巹',
            '巽', '帀', '布', '希', '師', '席', '帮', '帯', '帲', '帶', '幅', '幉', '幋', '幐',
            '幘', '幞', '幪', '幬', '幰', '干', '年', '并', '庁', '序', '庢', '度', '廃', '廈',
            '廌', '廔', '廕', '廡', '廥', '廳', '延', '廿', '弇', '弌', '弎', '弐', '弖', '弮',
            '弻', '弽', '弿', '彀', '彁', '彅', '彊', '彌', '彍', '彘', '形', '彤', '彧', '彲',
            '彽', '彾', '征', '徐', '徑', '得', '徝', '徧', '復', '徰', '忐', '忑', '忓', '忔',
            '忝', '忢', '忬', '忳', '念', '忸', '怍', '怎', '怔', '怖', '怚', '怛', '怜', '怵',
            '恆', '恒', '恝', '恠', '恡', '恫', '恰', '恵', '悑', '悔', '悕', '悘', '悪', '悷',
            '悻', '惎', '惜', '惠', '惡', '惨', '惰', '惵', '惹', '惼', '惽', '愃', '愈', '愉',
            '愊', '愓', '愖', '愫', '愰', '愱', '愴', '慈', '慎', '慝', '慧', '慯', '慲', '慸',
            '慻', '慼', '憂', '憃', '憒', '憓', '憙', '憜', '憠', '憨', '憮', '憸', '懀', '懁',
            '懂', '懜', '懝', '懞', '懟', '懢', '懣', '懧', '懩', '懯', '或', '戛', '戞', '戣',
            '戫', '戴', '戸', '戹', '戻', '戽', '房', '所', '扁', '扃', '扆', '扇', '扈', '扉',
            '才', '托', '扚', '扤', '抔', '抦', '抨', '抶', '抷', '抹', '抺', '抿', '担', '拔',
            '拖', '拝', '拱', '拳', '拵', '拼', '拾', '拿', '挃', '挄', '挊', '挓', '挪', '挭',
            '挽', '捂', '捄', '捧', '捩', '捭', '捲', '捻', '捿', '掄', '掎', '掚', '措', '掭',
            '掮', '掵', '揃', '揄', '揅', '揎', '揓', '揚', '揜', '揲', '揳', '援', '揸', '揹',
            '搆', '搠', '搤', '搭', '搴', '搶', '搽', '搿', '摋', '摏', '摒', '摓', '摜', '摟',
            '摣', '摭', '摴', '撅', '撘', '撝', '撫', '撿', '擄', '擅', '擐', '擥', '擰', '擻',
            '擾', '攀', '攁', '攉', '攏', '攓', '攙', '攦', '攮', '攼', '政', '敃', '敍', '敔',
            '敘', '敟', '整', '數', '斁', '斂', '斅', '斒', '斜', '斠', '断', '斲', '施', '斿',
            '旂', '旉', '旎', '旐', '旖', '旟', '旦', '旰', '旴', '旿', '昀', '昈', '昊', '昔',
            '昜', '昞', '昤', '春', '昩', '昬', '昰', '昳', '昼', '晃', '晅', '晉', '晊', '晋',
            '晗', '晘', '晝', '晞', '晡', '晪', '普', '晸', '暄', '暋', '暌', '暖', '暘', '暙',
            '暛', '暢', '暴', '暿', '曁', '曄', '曎', '曛', '曝', '曨', '曩', '曬', '更', '曹',
            '最', '會', '有', '朎', '朕', '朞', '末', '本', '朮', '朽', '朾', '朿', '杌', '材',
            '杔', '杖', '束', '杤', '杮', '杯', '東', '枅', '枎', '枑', '枦', '枰', '枵', '枻',
            '枼', '枽', '柂', '柃', '柄', '柈', '柒', '柦', '柯', '柵', '査', '柾', '栔', '栟',
            '栢', '栨', '栫', '栯', '桄', '桊', '桎', '桐', '桓', '桛', '桮', '桱', '桺', '桻',
            '梂', '梆', '梈', '梗', '梚', '梣', '梹', '梺', '棄', '棆', '棊', '棏', '棒', '棗',
            '棙', '棟', '棨', '棫', '棬', '棯', '棰', '椅', '椏', '椖', '椣', '椪', '椱', '椵',
            '椸', '椿', '楂', '楅', '楉', '楊', '楕', '楡', '楦', '楩', '業', '楱', '楲', '極',
            '榎', '榖', '榘', '榛', '榡', '榥', '榨', '榺', '槇', '構', '槍', '槗', '槥', '槻',
            '槽', '樁', '樓', '樝', '樠', '樤', '樺', '樻', '樾', '橅', '橆', '橊', '橐', '橒',
            '橛', '橢', '橳', '橿', '檀', '檑', '檜', '檢', '檯', '檸', '檽', '櫃', '櫌', '櫕',
            '櫜', '櫤', '櫬', '櫼', '欃', '欄', '欉', '欐', '欛', '欞', '欤', '欵', '欷', '欹',
            '歌', '歎', '歖', '歛', '歝', '歟', '正', '歪', '歵', '死', '殂', '殛', '殢', '殤',
            '殨', '殬', '殭', '殮', '段', '殹', '殽', '殿', '毉', '毌', '毚', '毧', '毹', '氂',
            '氈', '氐', '氶', '汀', '求', '汔', '汚', '汛', '汧', '汫', '汯', '汴', '汻', '沍',
            '沔', '沗', '沲', '河', '泆', '泍', '泜', '泰', '洊', '洞', '洦', '洧', '洪', '洯',
            '洹', '洽', '浗', '浜', '浤', '浯', '浼', '涇', '涔', '涘', '涙', '涬', '涵', '淆',
            '淎', '淏', '淒', '淟', '淠', '淢', '淪', '淰', '淵', '添', '渝', '渲', '湊', '湎',
            '湔', '湛', '湢', '湯', '湲', '湳', '湽', '満', '溓', '溙', '溝', '溠', '溮', '溱',
            '滁', '滄', '滇', '滋', '滍', '滬', '滯', '滹', '滿', '漊', '漍', '演', '漕', '漛',
            '漢', '漦', '漩', '潓', '潝', '潰', '澍', '澐', '澑', '澓', '澚', '澦', '澪', '澮',
            '澰', '澱', '澵', '澶', '濃', '濔', '濨', '濽', '瀀', '瀑', '瀗', '瀣', '瀰', '瀲',
            '瀹', '瀼', '灃', '灊', '灋', '灞', '灯', '炉', '炗', '炳', '烔', '烕', '烜', '烝',
            '烤', '焉', '焏', '無', '煁', '煅', '煆', '煉', '煊', '煎', '煖', '煚', '煠', '煬',
            '煹', '煽', '熀', '熚', '熢', '熯', '熺', '燁', '燙', '燸', '燾', '爆', '爗', '爚',
            '爝', '爟', '爨', '爯', '爰', '爴', '爽', '爾', '牁', '牃', '牏', '牖', '牱', '牼',
            '犀', '犄', '犛', '犠', '犲', '犴', '狃', '狉', '狙', '狟', '狳', '猂', '猓', '猗',
            '猘', '猞', '猤', '猵', '獟', '獧', '獩', '獪', '獫', '獮', '獯', '獱', '獸', '獼',
            '玁', '玎', '玕', '玞', '玲', '珂', '珊', '珖', '珷', '珻', '琁', '琦', '琫', '琴',
            '瑃', '瑄', '瑇', '瑒', '瑜', '瑧', '瑱', '瑲', '瑾', '璇', '璏', '璑', '璢', '璮',
            '璯', '環', '璵', '璹', '璽', '璿', '瓉', '瓌', '瓞', '瓤', '瓦', '瓨', '瓪', '瓫',
            '瓯', '瓴', '瓶', '瓸', '瓺', '瓻', '瓼', '瓿', '甆', '甒', '甖', '甗', '甚', '甦',
            '甹', '町', '画', '甼', '畇', '畏', '畐', '畢', '畫', '畭', '異', '畱', '畳', '畴',
            '畸', '畺', '畻', '畼', '畽', '疅', '疆', '疎', '疔', '疙', '疜', '疴', '疸', '痄',
            '病', '症', '痌', '痏', '痗', '痞', '痡', '痾', '瘂', '瘇', '瘈', '瘉', '瘊', '瘍',
            '瘕', '瘛', '瘡', '瘥', '瘩', '瘻', '癁', '癃', '癅', '癊', '癋', '癟', '癥', '癸',
            '百', '皌', '皕', '皝', '皟', '皢', '皣', '皭', '皽', '盃', '盈', '益', '盒', '盔',
            '盦', '盪', '盬', '盰', '直', '盻', '眄', '眊', '看', '眜', '真', '眮', '眹', '睅',
            '睎', '睠', '睡', '睪', '睰', '睺', '睽', '瞔', '瞖', '瞚', '瞞', '瞶', '瞼', '矃',
            '矉', '矗', '矜', '矢', '矤', '矦', '矪', '矬', '矰', '矱', '矴', '矸', '矻', '砆',
            '砉', '研', '砢', '砰', '砵', '砺', '硃', '硄', '硎', '硜', '硡', '硬', '硾', '碁',
            '碍', '碔', '碕', '碘', '碟', '碡', '碣', '碬', '碭', '碱', '碳', '磁', '磌', '磡',
            '礆', '礐', '礜', '礞', '礠', '礱', '礿', '祆', '祐', '祑', '祓', '祖', '祗', '祠',
            '祩', '祫', '禌', '福', '禓', '禛', '禪', '禫', '禮', '禰', '禱', '禳', '禴', '秉',
            '租', '秠', '秡', '秣', '秦', '秪', '秫', '称', '秱', '秼', '稀', '稉', '稌', '稔',
            '稧', '稫', '稱', '稴', '稵', '稹', '穙', '穥', '穪', '穰', '窒', '窘', '窬', '窶',
            '窹', '窺', '竆', '竑', '竒', '竡', '竩', '竱', '笄', '笔', '笥', '笧', '笨', '笪',
            '笭', '笮', '笴', '筒', '答', '筠', '筭', '箐', '箚', '箞', '箠', '箬', '箭', '箯',
            '箺', '箼', '箽', '篇', '篝', '篲', '篳', '篶', '篼', '簂', '簍', '簑', '簔', '簣',
            '簳', '簴', '簺', '簽', '籍', '籑', '籒', '籜', '籝', '籡', '籥', '籭', '籲', '粐',
            '粗', '粡', '粤', '粨', '粭', '粳', '糄', '糇', '糍', '糓', '糞', '糟', '糦', '糧',
            '糩', '糫', '紇', '紐', '紑', '紘', '絁', '組', '絑', '絙', '絚', '絜', '絣', '給',
            '絧', '絨', '絰', '絺', '絻', '絿', '綁', '綆', '綋', '綞', '綟', '綮', '綱', '綸',
            '綺', '緎', '編', '緩', '緪', '緱', '緶', '緻', '縀', '縉', '縑', '縗', '縝', '縠',
            '縣', '縧', '縨', '縫', '縬', '縯', '縳', '縶', '縷', '繄', '繐', '繖', '繢', '繥',
            '繪', '繮', '繯', '繾', '纁', '纕', '纚', '缻', '缽', '缾', '缿', '罔', '罘', '罝',
            '罡', '罭', '置', '罱', '罾', '羀', '羋', '羐', '羚', '羜', '羢', '群', '義', '羭',
            '羶', '翃', '翎', '翕', '翦', '翩', '翼', '翽', '翾', '翿', '耊', '耓', '耝', '耟',
            '耠', '耰', '耵', '耹', '耾', '聆', '聘', '聠', '聤', '聵', '肇', '肈', '肧', '肩',
            '肱', '肴', '肹', '胆', '胚', '胴', '胼', '脜', '脵', '脼', '腆', '腠', '腧', '腩',
            '腷', '腸', '腹', '膁', '膆', '膐', '膓', '膖', '膞', '膮', '膴', '膸', '膻', '膾',
            '膿', '臉', '臏', '臝', '臨', '臰', '至', '臵', '臶', '臸', '臹', '臿', '與', '興',
            '舉', '舔', '舞', '舡', '舢', '舨', '舮', '舲', '舴', '舺', '艃', '艄', '艅', '艆',
            '艋', '艎', '艏', '艑', '艖', '艙', '艚', '艜', '艠', '艣', '艧', '艭', '芉', '芊',
            '芋', '芣', '芦', '芩', '芼', '芾', '苆', '苒', '苓', '苛', '若', '苧', '苪', '苯',
            '苴', '茉', '茊', '茣', '茬', '茮', '茼', '荅', '荊', '荎', '荐', '荓', '荷', '荼',
            '莄', '莍', '莓', '莖', '莟', '莬', '菏', '菐', '菫', '華', '菶', '菹', '萓', '萱',
            '萹', '葅', '葊', '葍', '葘', '葚', '葜', '董', '葥', '葬', '葳', '葴', '葶', '蒒',
            '蒩', '蒪', '蒴', '蒸', '蒹', '蒺', '蒼', '蓆', '蓑', '蓧', '蓬', '蓱', '蓴', '蓻',
            '蓽', '蔕', '蔗', '蔧', '蔫', '蔭', '蔶', '蕐', '蕘', '蕢', '蕩', '蕪', '薈', '薉',
            '薑', '薟', '薧', '薫', '薴', '薽', '薾', '薿', '藇', '藉', '藊', '藎', '藤', '藪',
            '藼', '蘀', '蘍', '蘘', '蘙', '蘛', '蘞', '蘩', '蘭', '蘯', '虀', '虁', '虖', '虗',
            '虘', '虚', '號', '虡', '虣', '虱', '虷', '虺', '蚈', '蚌', '蚕', '蚨', '蚩', '蚯',
            '蚱', '蚳', '蚵', '蛃', '蛉', '蛕', '蛤', '蛬', '蛭', '蜂', '蜍', '蜮', '蜯', '蜽',
            '蝅', '蝋', '蝓', '蝙', '蝨', '蝪', '蝻', '螄', '螆', '螌', '螓', '螠', '螣', '螬',
            '螮', '螻', '螾', '蟈', '蟎', '蟚', '蟢', '蟪', '蟱', '蟺', '蟻', '蠉', '蠊', '蠒',
            '蠓', '蠙', '蠚', '蠭', '蠮', '蠰', '蠲', '蠹', '蠺', '衃', '衄', '衋', '衎', '衕',
            '衘', '衙', '衟', '衠', '衰', '衾', '衿', '袒', '袖', '袘', '袛', '袜', '袟', '袠',
            '袷', '袾', '裱', '裲', '裷', '褄', '褊', '褎', '褏', '褕', '褙', '褠', '褨', '褰',
            '褸', '褺', '襀', '襄', '襅', '襆', '襗', '襢', '襫', '襳', '覉', '覔', '覗', '覥',
            '覦', '覯', '覷', '覼', '觥', '觩', '觭', '觱', '觳', '觴', '訂', '託', '訶', '証',
            '詅', '詍', '評', '詝', '詞', '詥', '詵', '詷', '誉', '誒', '誙', '誷', '誼', '諈',
            '諔', '論', '諗', '諞', '諠', '諡', '諭', '諴', '諵', '諶', '諾', '謄', '謆', '謇',
            '謌', '講', '謭', '謼', '譁', '譃', '譆', '譓', '譜', '譞', '譣', '議', '譴', '譸',
            '譼', '譾', '讌', '讏', '讓', '谸', '谹', '谽', '豊', '豏', '豓', '豔', '豗', '象',
            '豣', '豨', '豭', '豺', '豻', '豾', '貆', '貋', '貐', '財', '貪', '貯', '貴', '賄',
            '賆', '賓', '賕', '賚', '賰', '賸', '購', '賽', '賾', '贉', '趕', '趬', '趷', '趼',
            '跇', '跊', '跋', '跙', '跚', '跰', '跲', '踁', '踡', '踦', '踰', '踱', '踳', '踸',
            '蹀', '蹁', '蹇', '蹌', '蹕', '蹛', '蹜', '蹠', '蹣', '蹹', '蹺', '躚', '躛', '躧',
            '軆', '軇', '軏', '軨', '軰', '輈', '輊', '輌', '輝', '輞', '輧', '輪', '輳', '輸',
            '輺', '轃', '轘', '轝', '轞', '農', '辷', '迀', '迊', '迕', '迣', '迤', '迭', '迮',
            '迵', '迶', '迸', '送', '途', '逕', '逘', '速', '逬', '逼', '逾', '逿', '遍', '遘',
            '遣', '遭', '遮', '遰', '遺', '還', '邅', '邇', '邐', '邗', '邢', '邱', '邳', '邴',
            '邶', '邾', '郁', '郃', '郄', '郅', '郈', '郗', '郡', '郵', '鄀', '鄈', '鄢', '鄯',
            '鄴', '鄶', '鄼', '酈', '酊', '酭', '醋', '醎', '醡', '醢', '醭', '醰', '醳', '醴',
            '醶', '醻', '醼', '釀', '釂', '釃', '重', '量', '釘', '釜', '釬', '釮', '鈇', '鈐',
            '鈕', '鈜', '鈣', '鈩', '鈳', '鈴', '鈵', '鈼', '鉃', '鉇', '鉏', '鉢', '鉦', '鉰',
            '鉶', '鉼', '鉿', '銅', '銊', '銍', '銒', '銗', '銙', '銧', '銲', '銶', '鋂', '鋐',
            '鋒', '鋘', '鋙', '錀', '錈', '錏', '錑', '錘', '錡', '錬', '錶', '鍑', '鍚', '鍥',
            '鍩', '鍭', '鍮', '鍱', '鍳', '鍽', '鍿', '鎋', '鎗', '鎡', '鎤', '鎩', '鎭', '鎮',
            '鎶', '鎺', '鏄', '鏇', '鏊', '鏋', '鏤', '鏷', '鏸', '鐂', '鐟', '鐮', '鐱', '鑈',
            '鑌', '鑓', '鑡', '鑨', '鑯', '鑰', '鑲', '镸', '镹', '镾', '閂', '閈', '閉', '開',
            '閎', '関', '閤', '閧', '闋', '闐', '闚', '闞', '闟', '闠', '闤', '阢', '阱', '阷',
            '阸', '阻', '阼', '阿', '陁', '陏', '陘', '除', '陰', '陲', '陳', '陽', '隂', '隃',
            '隋', '随', '隔', '隤', '隨', '險', '隯', '隳', '雄', '雇', '雘', '雫', '雲', '零',
            '霉', '霊', '霰', '霳', '靊', '靕', '靗', '靣', '靧', '靪', '靮', '靻', '靼', '鞕',
            '鞢', '鞭', '鞲', '鞳', '鞶', '鞸', '鞼', '鞾', '韁', '韉', '韎', '韐', '韑', '韘',
            '韝', '韠', '韡', '韯', '韱', '韴', '韸', '頂', '頇', '預', '領', '頙', '頜', '頷',
            '顑', '顢', '顣', '顧', '顪', '顫', '颪', '颫', '颴', '颺', '飅', '飡', '飣', '飥',
            '飦', '飧', '飪', '飳', '飾', '餂', '餅', '餇', '餈', '餑', '餕', '餖', '餗', '餘',
            '餚', '餛', '餜', '餧', '餱', '餲', '餳', '餵', '餺', '餻', '餼', '饀', '饁', '饆',
            '饈', '饉', '饋', '饍', '饎', '饔', '饘', '饛', '饜', '饞', '饟', '饠', '馦', '馲',
            '馿', '駈', '駓', '駔', '駞', '駢', '駧', '駫', '騁', '騃', '騎', '騐', '騙', '騞',
            '騢', '騤', '騫', '騰', '騸', '驁', '驊', '驑', '驗', '骵', '骶', '骾', '骿', '髄',
            '髏', '髐', '髒', '髓', '髕', '髩', '髪', '髯', '鬂', '鬈', '鬋', '鬌', '鬒', '鬟',
            '鬠', '鬹', '鬺', '鬻', '魖', '魗', '魣', '魳', '鮇', '鮝', '鮦', '鮩', '鮪', '鮸',
            '鯁', '鯑', '鯗', '鯰', '鯳', '鯸', '鯿', '鰏', '鰑', '鰖', '鰘', '鰙', '鰚', '鰜',
            '鰦', '鰧', '鰵', '鰷', '鰽', '鱁', '鱃', '鱄', '鱏', '鱔', '鱖', '鱞', '鱟', '鱠',
            '鱣', '鱮', '鱵', '鴒', '鴞', '鴿', '鵃', '鵇', '鵲', '鵶', '鶄', '鶬', '鶱', '鶼',
            '鶿', '鷇', '鷓', '鷖', '鷟', '鷰', '鸇', '鸒', '鸙', '鸝', '鹺', '鹻', '鹼', '麗',
            '黋', '黔', '黬', '黭', '黮', '黰', '黱', '黻', '鼂', '鼉', '鼎', '鼏', '鼐', '鼑',
            '鼒', '鼯', '鼿', '齄', '齇', '齓', '齕', '齖', '齗', '齘', '齚', '齝', '齞', '齡',
            '齢', '齨', '齩', '齭', '齮', '齯', '齰', '齱', '齳', '齵', '齺', '齽', '龏', '龐',
            '龑', '龒', '龔', '龕', '龖', '龗', '龞', '龠', '龡', '龢', '龣', '龥',
        ],
    },
    Membership {
        radical: 'ノ',
        strokes: 1,
        kanji: &[
            '七', '万', '丈', '丌', '不', '丑', '丒', '丕', '丞', '丣', '丫', '丱', '丵', '丹',
            '丼', '丿', '乂', '乃', '乄', '久', '乇', '乍', '乎', '乏', '乑', '乕', '乖', '乗',
            '乘', '乞', '乴', '乾', '井', '亙', '亥', '亦', '亳', '亹', '仍', '仗', '仛', '仟',
            '仡', '仯', '仵', '任', '仿', '伖', '伾', '佈', '佐', '佑', '佖', '佚', '佛', '作',
            '你', '佬', '併', '使', '侁', '侂', '侅', '侏', '侑', '侘', '侟', '侶', '侾', '便',
            '俁', '係', '俈', '俤', '俰', '俾', '倁', '倄', '倉', '偅', '偊', '偌', '偑', '偒',
            '偗', '偢', '偽', '傁', '傄', '傓', '傔', '傞', '傯', '傷', '働', '僑', '儇', '儈',
            '儍', '儐', '儗', '儛', '儞', '儳', '儹', '兂', '兇', '先', '兎', '兟', '冘', '冭',
            '决', '冼', '凂', '减', '凑', '凞', '凢', '凭', '凮', '凶', '刅', '刋', '刎', '刑',
            '刱', '制', '刹', '刻', '刼', '剃', '剏', '剤', '剰', '剷', '劊', '劌', '劓', '劖',
            '劗', '劘', '劚', '劣', '劷', '劾', '勀', '勄', '動', '勧', '勨', '勪', '勲', '勿',
            '匁', '匆', '匘', '匫', '匲', '区', '匾', '匿', '千', '卅', '升', '午', '卛', '卥',
            '卵', '卸', '厇', '厤', '厷', '叅', '及', '友', '叕', '史', '右', '后', '吏', '吚',
            '君', '否', '吨', '吪', '吵', '吸', '吻', '呂', '告', '呏', '呑', '呼', '咈', '咋',
            '咏', '咤', '咮', '咳', '咷', '咸', '咿', '哊', '响', '哎', '哠', '哽', '唀', '唉',
            '唌', '唎', '唏', '唪', '唾', '啤', '喊', '喬', '喭', '営', '嗆', '嗛', '嗟', '嘆',
            '嘑', '嘯', '嘸', '嘹', '噃', '噢', '噦', '嚟', '嚦', '嚬', '嚭', '嚳', '囉', '囋',
            '囌', '囍', '囟', '囤', '囨', '囫', '囱', '囷', '囿', '在', '圪', '圽', '圿', '坏',
            '坧', '坯', '垁', '垂', '型', '垓', '垕', '垗', '垝', '垞', '垢', '垧', '垩', '垪',
            '埀', '城', '埏', '埓', '埕', '埤', '埵', '執', '埸', '堍', '堕', '堠', '堹', '堿',
            '塀', '塉', '塌', '塨', '塩', '墀', '墦', '墲', '壈', '壎', '壐', '壢', '壬', '夭',
            '央', '夰', '失', '夷', '奔', '奡', '奯', '奲', '奼', '妊', '妋', '妍', '妎', '妒',
            '妖', '妙', '妰', '妳', '妷', '妼', '姊', '姒', '姙', '姝', '姤', '姷', '娀', '威',
            '娍', '娑', '娒', '娣', '娭', '娰', '婬', '婾', '媙', '媛', '媠', '媲', '嫪', '嫵',
            '嫽', '嬀', '嬌', '嬥', '嬪', '嬸', '孕', '存', '孩', '孫', '孼', '孽', '宅', '宎',
            '宏', '宓', '宥', '宨', '宬', '宭', '宮', '宯', '宱', '宷', '密', '寗', '察', '寿',
            '少', '尓', '尞', '尟', '尠', '尬', '尮', '尰', '尲', '尵', '尶', '尹', '屏', '属',
            '屩', '屯', '屹', '屻', '岇', '岝', '峮', '峲', '峺', '崣', '崤', '崴', '嵃', '嵆',
            '嵈', '嵊', '嵕', '嵙', '嵡', '嵢', '嵯', '嵰', '嶓', '嶛', '嶠', '嶫', '嶴', '巋',
            '巐', '巤', '左', '差', '布', '希', '帔', '帙', '帟', '帮', '帲', '帾', '幑', '幞',
            '年', '并', '幾', '庎', '庨', '庳', '廜', '廡', '廥', '弈', '弗', '弟', '弥', '弼',
            '彘', '形', '彿', '徏', '御', '復', '必', '忔', '忝', '忤', '忳', '忽', '怍', '怎',
            '怖', '怫', '怭', '怱', '怵', '恁', '恌', '恖', '恠', '恡', '悉', '悌', '悎', '悔',
            '悕', '悘', '悤', '惕', '惰', '惹', '愓', '感', '愡', '愱', '慝', '慟', '慯', '慸',
            '慼', '憁', '憍', '憜', '憭', '憮', '憾', '懂', '懝', '懟', '懡', '懢', '懸', '戊',
            '戌', '戍', '成', '戚', '戧', '戫', '扄', '才', '托', '扳', '扽', '承', '抄', '抍',
            '抔', '抛', '抶', '抷', '拂', '拔', '拖', '拜', '括', '拲', '拵', '拽', '挓', '挘',
            '挭', '挿', '捁', '捃', '捗', '捭', '捶', '捼', '掦', '掽', '揅', '插', '揓', '揔',
            '揪', '援', '搘', '搢', '搤', '搥', '携', '搾', '摋', '摒', '摔', '摛', '摠', '摯',
            '撇', '撟', '撦', '撫', '撬', '撼', '擥', '擦', '擯', '攈', '攊', '攟', '攢', '攸',
            '敽', '斉', '斎', '斒', '斕', '斫', '斲', '施', '斿', '旂', '旅', '旈', '旎', '旐',
            '旖', '旟', '旾', '旿', '昄', '昇', '昒', '易', '昜', '映', '昦', '昨', '昳', '晀',
            '晌', '晑', '晜', '晞', '晟', '晠', '晧', '晹', '暖', '暘', '暛', '暭', '曛', '曫',
            '更', '朇', '有', '朓', '朱', '朶', '材', '杔', '杖', '杤', '杪', '杯', '杵', '杶',
            '枅', '枕', '枖', '枡', '枰', '柀', '柂', '柉', '柞', '柲', '栧', '栫', '栯', '栳',
            '栴', '核', '桊', '桘', '桫', '桮', '梆', '梏', '梗', '梠', '梯', '梼', '棅', '棰',
            '椑', '椱', '椸', '楉', '楓', '楕', '楤', '楥', '楩', '楲', '楹', '楿', '榘', '榨',
            '榭', '槎', '槗', '槢', '樁', '樑', '樒', '樨', '橅', '橆', '橋', '橎', '橑', '機',
            '橢', '檁', '檋', '檳', '櫁', '櫚', '櫧', '櫰', '櫱', '櫲', '欉', '欑', '欧', '欫',
            '欬', '欵', '欷', '歃', '歩', '歪', '歰', '歳', '歾', '殀', '殊', '殢', '殤', '殯',
            '殴', '段', '殹', '殺', '殽', '殾', '毉', '毖', '毟', '毡', '毣', '毦', '毧', '毮',
            '毱', '毷', '毹', '毿', '氂', '氄', '氅', '氉', '氍', '氎', '氒', '気', '氦', '汔',
            '汛', '汧', '汫', '汯', '汲', '汹', '汻', '沃', '沕', '沙', '沲', '沸', '泆', '泌',
            '泖', '泛', '泲', '洊', '洗', '洙', '洧', '洩', '洮', '活', '浤', '浩', '浰', '涎',
            '涒', '涕', '涘', '涛', '涹', '淆', '淠', '淫', '淴', '添', '済', '渉', '渊', '渢',
            '渺', '渻', '湲', '溓', '溠', '溮', '溱', '滃', '滅', '滹', '滻', '漖', '漛', '漩',
            '潑', '潒', '潙', '潨', '澓', '澔', '澚', '澟', '濊', '濫', '濱', '瀕', '瀟', '灕',
            '炒', '炖', '炛', '炸', '為', '烑', '烕', '烤', '焄', '焅', '無', '煅', '煖', '煬',
            '熈', '熏', '熯', '燙', '營', '燻', '爉', '爰', '牎', '牏', '牐', '牕', '牣', '物',
            '牿', '犀', '犂', '犮', '犲', '狉', '狒', '狳', '猘', '猤', '猨', '獠', '獩', '獯',
            '獱', '玅', '玠', '珋', '珌', '珠', '珦', '珧', '珵', '珹', '珺', '珻', '珽', '琁',
            '琇', '瑀', '瑒', '瑗', '瑛', '瑟', '瑧', '瑨', '瑳', '璁', '璇', '璏', '璑', '璒',
            '璙', '璠', '璱', '璻', '瓈', '瓌', '瓚', '瓞', '瓩', '瓪', '瓯', '瓶', '瓻', '甒',
            '産', '甦', '甪', '甶', '畈', '畊', '畍', '畡', '畴', '畼', '畽', '畿', '疙', '疚',
            '疥', '疺', '痄', '痎', '痏', '痗', '痜', '痞', '痧', '痬', '瘇', '瘊', '瘍', '瘏',
            '瘝', '瘥', '瘳', '癁', '癱', '皓', '皤', '皥', '皽', '盃', '盈', '盉', '盔', '盛',
            '盪', '盬', '盹', '省', '眇', '眊', '看', '眔', '眨', '眽', '眾', '着', '睇', '睎',
            '睗', '睠', '睡', '睰', '睺', '睽', '瞖', '瞪', '矉', '矢', '矤', '矦', '矪', '矬',
            '矯', '矰', '矱', '矻', '砂', '砎', '研', '砕', '砭', '硃', '硇', '硡', '硣', '硬',
            '硾', '碭', '碰', '碱', '碳', '磇', '磓', '磠', '磤', '磯', '磻', '磿', '礐', '礜',
            '祄', '祅', '祆', '祊', '祐', '祑', '祓', '祔', '祕', '祚', '祛', '祜', '祢', '祧',
            '祩', '祫', '祲', '祷', '祹', '祼', '禋', '禓', '禔', '禕', '禖', '禘', '禛', '禡',
            '禩', '禫', '禱', '禴', '禹', '离', '禽', '禾', '秀', '秂', '秄', '秇', '秈', '秉',
            '秊', '秏', '秒', '秔', '秖', '秘', '秚', '秝', '秞', '秠', '秡', '秢', '秥', '秩',
            '秪', '秫', '秭', '称', '秱', '秸', '秼', '稀', '稂', '稃', '稇', '稉', '稊', '稌',
            '稑', '稕', '稛', '稞', '稡', '稧', '稫', '稭', '種', '稯', '稰', '稴', '稵', '稸',
            '稹', '稺', '穄', '穅', '穇', '穈', '穌', '穕', '穖', '穙', '穜', '穝', '穟', '穠',
            '穢', '穥', '穧', '穪', '穭', '穽', '穾', '窀', '窄', '窆', '窖', '窘', '窻', '竆',
            '竏', '竑', '竬', '笄', '笈', '笋', '笏', '笔', '笮', '筥', '筬', '筰', '筳', '筵',
            '箄', '箞', '箠', '箥', '箬', '箯', '箲', '箴', '箵', '箺', '箽', '篺', '篼', '篾',
            '簃', '簉', '簥', '簦', '簫', '簴', '簶', '簺', '籍', '籓', '籕', '籞', '粆', '粛',
            '粳', '粺', '糇', '糉', '糙', '糵', '系', '紇', '紉', '紑', '紒', '紗', '紘', '級',
            '紝', '紞', '紱', '絁', '絍', '絏', '絑', '絣', '絨', '絺', '絻', '絽', '綁', '綆',
            '綈', '綉', '綋', '綖', '綞', '綦', '緆', '緌', '緘', '緜', '緩', '緫', '緱', '緲',
            '緵', '緶', '縅', '縑', '縬', '縭', '繄', '繇', '繍', '繽', '纁', '纘', '缺', '缿',
            '网', '罓', '罘', '罤', '羀', '羞', '羢', '羣', '群', '羿', '翃', '翎', '翟', '翣',
            '翥', '翬', '翮', '翯', '翲', '翺', '翽', '翾', '翿', '耇', '耈', '耊', '耒', '耓',
            '耔', '耕', '耖', '耗', '耘', '耙', '耜', '耝', '耞', '耟', '耠', '耡', '耤', '耦',
            '耨', '耬', '耮', '耰', '耾', '聦', '肞', '肧', '肫', '肱', '肴', '胏', '胙', '胚',
            '胲', '胸', '胼', '脗', '脠', '脾', '腇', '腠', '腫', '腯', '腹', '膁', '膐', '膓',
            '膴', '膸', '臏', '臓', '臟', '臧', '臨', '臶', '臹', '臻', '臿', '舂', '舓', '舞',
            '舨', '舴', '艠', '艾', '芊', '芚', '芛', '芣', '芨', '芲', '芴', '芼', '苐', '苤',
            '若', '英', '苾', '茂', '茆', '茇', '茬', '茰', '茱', '荄', '荊', '荐', '荖', '荗',
            '荿', '莄', '莎', '莒', '莙', '莚', '莛', '莠', '菐', '菝', '萆', '萙', '董', '葳',
            '葴', '葵', '葼', '蒒', '蒓', '蒩', '蒸', '蒺', '蒼', '蓀', '蓖', '蓱', '蔑', '蔢',
            '蔤', '蔥', '蔵', '蕆', '蕎', '蕏', '蕟', '蕪', '蕭', '蕯', '蕿', '薁', '薉', '薩',
            '薫', '薭', '薿', '藂', '藉', '藊', '藋', '藍', '藏', '藕', '藳', '藶', '蘋', '蘍',
            '蘐', '蘒', '蘙', '蘩', '蘯', '蘶', '蘺', '虖', '虙', '虝', '虡', '虱', '蚧', '蚱',
            '蛕', '蛗', '蛛', '蛜', '蛧', '蜏', '蜑', '蜒', '蜓', '蜜', '蜱', '蜲', '蜴', '蝨',
            '蝪', '蝯', '螄', '螉', '螓', '螕', '螧', '螭', '螮', '蟉', '蟜', '蟟', '蟱', '蠃',
            '蠊', '蠚', '蠛', '蠟', '蠮', '衃', '衊', '衘', '衝', '袘', '袚', '袟', '袠', '袮',
            '袾', '裎', '裙', '裟', '裷', '裼', '褎', '褚', '褨', '褰', '褵', '襆', '襏', '襒',
            '襪', '襮', '覔', '覕', '覛', '覜', '覠', '覧', '覴', '覷', '觘', '觱', '觴', '訊',
            '訒', '託', '訞', '訦', '訬', '許', '詐', '詖', '詡', '詫', '該', '詵', '詾', '誄',
            '誅', '誒', '誕', '誗', '誘', '誟', '誠', '誥', '誮', '諈', '諉', '諬', '諴', '諼',
            '諾', '謆', '謊', '謐', '謼', '譃', '譌', '譏', '譒', '譼', '譾', '讅', '讚', '谸',
            '谹', '豏', '豑', '豘', '豣', '豨', '豺', '豾', '財', '貶', '賄', '賅', '賓', '賡',
            '贊', '贓', '趫', '趯', '趲', '趷', '跋', '跌', '跣', '踄', '踢', '踵', '踷', '踽',
            '蹋', '蹏', '蹙', '蹛', '蹬', '蹯', '蹴', '蹻', '躐', '躭', '躯', '躱', '躳', '躵',
            '軔', '軼', '輧', '轃', '轇', '轎', '轑', '轓', '轗', '轞', '辥', '辨', '迁', '迍',
            '迕', '迤', '迩', '迭', '迮', '迶', '迸', '逈', '透', '逘', '造', '逬', '逷', '逸',
            '逿', '遃', '遜', '遝', '遰', '邋', '邌', '邎', '邥', '邦', '邲', '邳', '邾', '郁',
            '郄', '郕', '郗', '郜', '郡', '郫', '郵', '鄀', '鄅', '鄈', '鄧', '鄮', '鄱', '鄴',
            '鄹', '酇', '酗', '酢', '酭', '酷', '醎', '醓', '醔', '醡', '醢', '醨', '醭', '醱',
            '醺', '重', '釜', '釮', '釰', '鈓', '鈔', '鈜', '鈹', '鈼', '鉂', '鉃', '鉄', '鉇',
            '鉍', '鉚', '鉥', '銊', '銑', '銖', '銗', '銠', '銹', '銻', '鋂', '鋈', '鋋', '鋌',
            '鋐', '鋓', '鋮', '鋳', '錈', '錍', '錘', '鍐', '鍑', '鍚', '鍤', '鍩', '鍭', '鍯',
            '鍰', '鍳', '鍺', '鍼', '鍾', '鎈', '鎋', '鎌', '鎏', '鎗', '鎞', '鎦', '鎫', '鏇',
            '鏊', '鏓', '鏷', '鏺', '鐈', '鐮', '鐯', '鑌', '鑙', '鑽', '钃', '镹', '閉', '開',
            '閎', '閟', '閡', '閭', '闋', '闒', '阡', '阼', '陁', '陏', '陔', '陞', '陟', '陦',
            '陲', '陴', '陼', '隋', '随', '際', '隠', '隥', '隨', '隩', '隲', '隳', '雀', '雄',
            '霃', '霉', '靜', '靠', '靣', '鞉', '鞕', '鞞', '鞭', '韈', '韌', '韛', '頖', '頦',
            '頫', '頲', '頵', '頻', '顊', '顑', '顖', '顣', '顪', '顰', '風', '颫', '颭', '颮',
            '颰', '颴', '颷', '颸', '颺', '颻', '颿', '飂', '飅', '飈', '飌', '飥', '飪', '飫',
            '飶', '飾', '餅', '餚', '餧', '餱', '餳', '饈', '饑', '馛', '馝', '馟', '馦', '馲',
            '駆', '駓', '駛', '駜', '駞', '駢', '駪', '駭', '駲', '騃', '騣', '騤', '騭', '騮',
            '騸', '驁', '驄', '驋', '驕', '骸', '骾', '髄', '髎', '髓', '髕', '髜', '髧', '髬',
            '髲', '髴', '髿', '鬀', '鬁', '鬄', '鬈', '鬉', '鬌', '鬐', '鬛', '鬢', '鬷', '鬺',
            '魖', '魦', '魨', '魪', '魫', '魹', '鮅', '鮍', '鮓', '鮪', '鮱', '鮷', '鯀', '鯁',
            '鯊', '鯎', '鯑', '鯗', '鯘', '鯣', '鯸', '鯺', '鰀', '鰄', '鰑', '鰔', '鰖', '鰙',
            '鰜', '鰵', '鱁', '鱃', '鱎', '鱪', '鱰', '鱲', '鱵', '鴎', '鵇', '鵜', '鵠', '鵥',
            '鶍', '鶖', '鶬', '鶱', '鶹', '鶼', '鷖', '鷚', '鷟', '鷮', '鸒', '鹹', '鹺', '鹻',
            '麇', '麏', '麘', '麨', '麬', '麿', '黆', '黕', '黧', '黬', '黻', '鼒', '鼗', '鼙',
            '鼟', '齕', '齘', '齚', '齭', '齲', '龞', '龢',
        ],
    },
    Membership {
        radical: '｜',
        strokes: 1,
        kanji: &[
            '丄', '丅', '万', '下', '丌', '不', '丑', '丕', '世', '丗', '両', '丣', '並', '丨',
            '个', '丫', '中', '丮', '丯', '丰', '丱', '串', '丼', '乃', '乍', '乑', '乕', '乗',
            '也', '井', '亜', '亹', '以', '仲', '伂', '伊', '伳', '伴', '伷', '伸', '伾', '佀',
            '佈', '佛', '作', '佣', '併', '來', '侓', '供', '侟', '便', '俌', '俜', '俤', '修',
            '俸', '倆', '倌', '倎', '倏', '倐', '倔', '候', '倛', '倜', '倢', '値', '倫', '偁',
            '假', '偈', '偏', '偙', '偰', '傁', '傏', '僀', '働', '僎', '僐', '僓', '僢', '儂',
            '儐', '儙', '儛', '儞', '儣', '儳', '儴', '儵', '免', '兎', '児', '兕', '兤', '兩',
            '共', '典', '兼', '兾', '円', '冉', '冊', '再', '冓', '冲', '冸', '冿', '凂', '凍',
            '凧', '凲', '凸', '出', '判', '刱', '剃', '剌', '剏', '剘', '剤', '剩', '剰', '劊',
            '劓', '劖', '劘', '劚', '勅', '動', '勩', '勲', '勳', '勷', '匜', '匣', '匱', '匾',
            '卅', '半', '卋', '卌', '卍', '卙', '印', '厝', '厴', '叀', '収', '叏', '叓', '叚',
            '叫', '否', '吽', '呭', '味', '呷', '呻', '咃', '咄', '咈', '咋', '哄', '哶', '唐',
            '唖', '唪', '唶', '唾', '啁', '啛', '啞', '啿', '喇', '喎', '喘', '喪', '嗉', '嗛',
            '嗣', '嗶', '嗽', '嘈', '嘍', '嘒', '嘩', '嘯', '嘳', '嘸', '嘽', '嘿', '噀', '噁',
            '噄', '噉', '噦', '噲', '嚅', '嚝', '嚢', '嚩', '嚭', '嚳', '嚷', '囅', '囊', '囏',
            '囨', '圇', '圊', '圑', '圕', '圚', '圛', '在', '圿', '坏', '坐', '坢', '坤', '坯',
            '垂', '垩', '垪', '垬', '埕', '埠', '埡', '埼', '埽', '堀', '堍', '堙', '堞', '堹',
            '塀', '塐', '塘', '塨', '塿', '墀', '墈', '墉', '墌', '墟', '墠', '墲', '壂', '壎',
            '壐', '壖', '壙', '壤', '壩', '壷', '夅', '夆', '夤', '夰', '奉', '奝', '奡', '奯',
            '她', '妍', '妎', '妕', '妯', '妰', '妹', '妻', '姈', '姊', '姍', '娉', '娣', '婁',
            '婭', '媚', '媟', '媻', '媾', '嫂', '嫌', '嫥', '嫩', '嫮', '嫵', '嬋', '嬝', '嬭',
            '嬾', '孁', '孃', '存', '孺', '孼', '孽', '官', '宙', '宱', '宺', '寗', '寠', '寨',
            '寯', '尬', '尰', '尲', '屈', '届', '屏', '展', '屜', '屧', '屨', '岝', '岫', '岬',
            '岺', '岼', '峠', '峯', '峰', '崋', '崎', '崘', '崙', '崛', '崫', '崹', '嵂', '嵊',
            '嵋', '嵰', '嶁', '嶒', '嶫', '嶰', '嶲', '巋', '州', '巸', '巽', '巾', '帀', '帇',
            '帍', '帒', '帔', '帕', '帘', '帟', '帠', '帥', '帨', '師', '帮', '帯', '帲', '帵',
            '帾', '幉', '幋', '幐', '幑', '幖', '幘', '幛', '幜', '幞', '幨', '幪', '幫', '幬',
            '幭', '幮', '幰', '幽', '庎', '座', '庽', '廉', '廌', '廔', '廡', '廥', '廸', '廿',
            '弊', '弔', '引', '弗', '弝', '弟', '弽', '弿', '彇', '彈', '彌', '彍', '彵', '彾',
            '彿', '徠', '徤', '徧', '忠', '忡', '念', '忸', '怍', '怎', '怫', '怵', '恆', '恝',
            '悌', '悑', '悕', '悚', '悠', '患', '悪', '惎', '惜', '惠', '惵', '惼', '愑', '愖',
            '愫', '慊', '慟', '慧', '慲', '慸', '憋', '憒', '憓', '憖', '憚', '憨', '憮', '憹',
            '懀', '懏', '懜', '懟', '懣', '懯', '懶', '戃', '戰', '戴', '扁', '扭', '抔', '抷',
            '抹', '抻', '押', '抽', '拂', '拌', '拖', '拙', '拝', '拱', '拲', '挫', '挽', '挿',
            '捁', '捜', '捧', '捵', '捶', '捻', '捿', '掄', '掘', '掚', '措', '掽', '揀', '揓',
            '揥', '揲', '揳', '揵', '揹', '搆', '搜', '搢', '搥', '搪', '搴', '搾', '摒', '摓',
            '摟', '摭', '摴', '撇', '撒', '撫', '撰', '擕', '擻', '攉', '攏', '攓', '攙', '攮',
            '收', '攸', '敒', '敕', '敝', '敟', '整', '數', '斅', '斉', '斎', '斒', '斠', '断',
            '斮', '斲', '斷', '旈', '旉', '旔', '旟', '旧', '旹', '昔', '昢', '昤', '昦', '昧',
            '昨', '晎', '晜', '晡', '晪', '普', '暢', '暴', '曂', '曄', '曝', '曨', '曩', '曲',
            '曹', '朇', '朎', '朏', '未', '末', '朮', '朱', '朿', '杝', '束', '来', '杮', '杯',
            '東', '杻', '果', '枻', '枼', '柀', '柂', '柙', '柚', '柞', '柮', '柵', '柿', '栔',
            '栙', '栱', '桘', '桮', '桺', '桻', '梚', '條', '梯', '棆', '棒', '棗', '棘', '棟',
            '棰', '棺', '椣', '椪', '椵', '椸', '楗', '楣', '業', '榊', '榡', '榨', '槇', '槌',
            '槥', '槵', '槽', '樓', '樠', '樤', '樨', '横', '樺', '樻', '樾', '橅', '橊', '橒',
            '橡', '橧', '檇', '檋', '檑', '檞', '檰', '檱', '檽', '櫃', '櫔', '櫜', '櫰', '櫱',
            '欃', '欄', '欉', '欛', '欞', '歉', '歪', '歵', '歸', '殊', '殢', '殨', '段', '殸',
            '殿', '毚', '氬', '汧', '汫', '沔', '沖', '沫', '沲', '沸', '油', '泏', '泠', '泧',
            '泮', '泰', '洊', '洙', '洚', '洪', '洯', '洲', '浟', '浼', '涕', '淈', '淎', '淒',
            '淛', '淟', '淠', '淪', '淵', '済', '渊', '渦', '渧', '湄', '湛', '湯', '湿', '満',
            '溂', '溍', '溏', '溓', '溝', '溮', '溿', '滌', '滍', '滫', '滭', '滽', '漊', '漕',
            '漶', '潒', '潚', '潨', '潰', '潽', '澌', '澐', '澑', '澔', '澥', '澧', '澮', '澱',
            '濂', '濃', '濅', '濔', '濵', '濹', '瀑', '瀗', '瀟', '瀬', '瀰', '瀷', '瀹', '瀼',
            '瀾', '灃', '灊', '灋', '灎', '灔', '灞', '炸', '烘', '烽', '焔', '無', '煁', '煅',
            '煆', '煉', '煠', '煹', '熏', '熚', '熢', '燁', '燸', '燻', '燼', '爆', '爗', '爚',
            '爛', '爟', '爯', '爾', '牃', '牅', '牠', '犀', '犍', '狃', '狆', '狉', '狎', '狒',
            '猓', '猘', '猵', '獅', '獘', '獬', '獮', '獯', '獱', '獼', '玁', '玠', '珅', '珊',
            '珋', '珒', '珙', '珠', '琪', '琫', '琯', '瑇', '瑕', '瑨', '瑭', '瑾', '璑', '璢',
            '璯', '璵', '璽', '瓌', '瓤', '瓴', '瓺', '瓻', '甒', '由', '甲', '申', '甹', '畃',
            '畊', '畍', '畔', '畢', '畱', '疎', '疥', '痄', '痞', '痡', '痯', '瘂', '瘄', '瘈',
            '瘕', '瘛', '瘝', '瘻', '癅', '癋', '癟', '皟', '皣', '皥', '盅', '直', '眉', '眒',
            '眔', '眛', '眾', '睂', '睇', '睎', '睡', '睫', '瞔', '瞚', '瞞', '瞥', '瞱', '瞶',
            '矉', '矗', '矠', '矧', '矪', '矰', '砉', '砎', '研', '砭', '砷', '确', '硾', '碏',
            '碕', '碘', '碟', '碡', '碣', '碬', '碰', '碲', '磓', '磡', '磳', '礐', '礜', '祄',
            '祅', '祆', '祊', '祔', '祚', '祛', '祜', '神', '祟', '祧', '祫', '祲', '祹', '祼',
            '禋', '禔', '禕', '禖', '禘', '禛', '禡', '禩', '禪', '禫', '禮', '禯', '禰', '禱',
            '禳', '禴', '秉', '秚', '秞', '秠', '秣', '秫', '秭', '稊', '稧', '種', '稱', '稲',
            '稴', '穙', '穠', '穥', '穪', '穰', '穽', '窄', '窋', '窟', '窶', '竦', '竾', '笄',
            '笛', '笧', '笭', '笮', '筁', '策', '筪', '筭', '筰', '筱', '箐', '箠', '管', '箻',
            '篇', '篊', '篖', '篝', '篠', '篩', '篲', '篳', '簉', '簍', '簎', '簣', '簨', '簫',
            '簱', '簴', '簶', '簺', '簾', '籍', '籒', '籟', '籥', '籲', '粛', '粠', '糄', '糙',
            '糞', '糟', '糩', '糵', '糶', '糾', '紐', '紑', '紒', '紖', '紬', '紳', '絀', '絁',
            '絆', '絛', '絜', '絣', '絺', '絻', '綈', '継', '綞', '綦', '綰', '綸', '緞', '編',
            '練', '縀', '縋', '縑', '縣', '縧', '縫', '縯', '縷', '繍', '繒', '繖', '繡', '繢',
            '繼', '繾', '纁', '纕', '罄', '罘', '罤', '置', '羀', '羋', '羐', '翀', '翈', '翎',
            '翛', '翩', '翼', '耒', '耕', '耗', '耘', '耙', '耜', '耡', '耤', '耦', '耨', '聘',
            '聵', '肁', '肈', '肧', '胄', '胏', '胖', '胙', '胚', '胛', '胮', '胼', '脩', '脯',
            '脼', '腆', '腊', '腗', '腫', '膁', '膄', '膅', '膆', '膖', '膴', '膿', '臋', '臏',
            '臶', '舉', '舏', '舘', '舝', '舞', '舡', '舢', '舨', '舲', '舳', '舴', '舺', '艃',
            '艄', '艅', '艆', '艋', '艎', '艏', '艑', '艖', '艚', '艜', '艠', '艣', '艧', '艭',
            '艶', '芇', '芣', '芾', '苐', '苒', '苚', '苡', '苢', '苤', '茁', '茉', '茟', '茬',
            '茱', '茽', '荍', '莜', '莬', '莱', '菅', '菐', '菟', '菫', '華', '菶', '萁', '萋',
            '萹', '葏', '葜', '董', '葪', '葭', '葮', '蒒', '蒪', '蒹', '蓚', '蓧', '蓬', '蓽',
            '蔧', '蔶', '蔽', '蕀', '蕐', '蕢', '蕩', '蕪', '蕭', '蕯', '蕻', '蕽', '薓', '薛',
            '薢', '薫', '薾', '藂', '藇', '藉', '藊', '藎', '藕', '藤', '藪', '藼', '藾', '蘍',
            '蘖', '蘘', '蘛', '蘭', '虀', '虁', '虡', '虯', '虵', '蚌', '蚓', '蚧', '蚰', '蚱',
            '蛗', '蛛', '蛬', '蜂', '蜞', '蜡', '蜯', '蜽', '蝋', '蝙', '螄', '螋', '螌', '螗',
            '螬', '螮', '螻', '螾', '蟎', '蟕', '蟖', '蟤', '蟱', '蠊', '蠒', '蠨', '蠭', '蠰',
            '蠹', '衃', '衄', '衅', '衋', '衖', '衙', '衝', '袖', '袘', '袢', '裯', '裱', '裲',
            '褄', '褊', '褎', '褏', '褙', '褠', '褰', '褸', '襀', '襄', '襅', '襆', '襒', '襛',
            '襮', '襺', '覔', '覥', '覯', '覷', '覼', '角', '觔', '觕', '觖', '觗', '觘', '觥',
            '觩', '觫', '觭', '觱', '觳', '觶', '觹', '觽', '觿', '訑', '訠', '訷', '詍', '詐',
            '評', '詘', '詜', '誄', '誅', '誳', '諆', '諈', '諌', '論', '諞', '諫', '諶', '謄',
            '謇', '謊', '謙', '譁', '譂', '譃', '譄', '譔', '譜', '譴', '讏', '讓', '豊', '豏',
            '豑', '豓', '豔', '豨', '豫', '豭', '豾', '貤', '貴', '費', '賙', '賺', '購', '賽',
            '賾', '贃', '贉', '贐', '贒', '赧', '赮', '赳', '趞', '跇', '跚', '踈', '踑', '踖',
            '踵', '踸', '蹀', '蹁', '蹇', '蹍', '蹕', '蹛', '蹩', '蹭', '躛', '躰', '軆', '軨',
            '軰', '軸', '輂', '輈', '輌', '輛', '輨', '輪', '輾', '轝', '辣', '辥', '農', '迆',
            '迊', '迚', '迣', '迤', '迪', '迭', '迮', '迸', '追', '逄', '逓', '速', '逢', '逪',
            '逭', '遍', '遐', '遘', '遝', '遣', '遭', '遰', '選', '遺', '邇', '邳', '邶', '郗',
            '郜', '郵', '郿', '鄘', '鄲', '鄴', '鄶', '鄷', '鄹', '酏', '酢', '酬', '醋', '醡',
            '醭', '醲', '醴', '醺', '醼', '釀', '釂', '釉', '重', '釐', '鈕', '鈯', '鈰', '鈼',
            '鈾', '鉀', '鉇', '鉞', '鉡', '鉮', '鉷', '銉', '銖', '銟', '銻', '鋒', '錀', '錏',
            '錘', '錤', '錧', '錪', '錬', '錶', '鍗', '鍜', '鍥', '鍱', '鍽', '鍾', '鎀', '鎋',
            '鎏', '鎕', '鎚', '鎭', '鏅', '鏊', '鏋', '鏞', '鏤', '鏧', '鏷', '鏽', '鐁', '鐂',
            '鐉', '鐮', '鑈', '鑓', '鑰', '鑲', '钃', '镸', '镹', '镾', '閘', '閧', '闌', '闠',
            '闦', '阜', '阤', '阼', '陁', '陥', '陲', '陳', '隂', '隤', '雘', '雫', '霊', '霰',
            '靊', '靕', '靧', '靷', '靺', '靽', '鞗', '鞢', '鞣', '鞬', '鞲', '鞶', '鞸', '鞼',
            '鞾', '韉', '韘', '韛', '韝', '韠', '韡', '韴', '韷', '韸', '頔', '頖', '頥', '頼',
            '顆', '顊', '顒', '顢', '飅', '飮', '餅', '餠', '館', '餹', '饆', '饈', '饉', '饋',
            '饌', '饟', '馦', '馽', '駓', '駞', '駢', '駲', '騁', '騙', '騞', '騢', '騫', '驁',
            '驊', '驌', '驑', '驤', '驥', '髃', '髏', '體', '髩', '髬', '髯', '髴', '髷', '鬀',
            '鬙', '鬠', '鬦', '鬨', '鬫', '鬭', '魅', '魌', '魎', '魖', '魪', '魳', '鮋', '鮓',
            '鮷', '鮸', '鯈', '鯿', '鰊', '鰕', '鰜', '鰤', '鰥', '鰰', '鰷', '鰽', '鱃', '鱅',
            '鱉', '鱐', '鱛', '鱟', '鱧', '鱮', '鴨', '鵃', '鵜', '鵥', '鵪', '鵰', '鵲', '鵶',
            '鶄', '鶇', '鶫', '鶱', '鶼', '鷩', '鷫', '鷰', '鸒', '鸙', '鹻', '麯', '黜', '黮',
            '鼎', '鼏', '鼐', '鼑', '鼒', '鼬', '鼼', '齘', '齚', '齰', '龔', '龞', '龡', '龢',
            '龣', '龥',
        ],
    },
    Membership {
        radical: '丶',
        strokes: 1,
        kanji: &[
            '丈', '不', '丒', '丕', '丫', '丱', '丵', '丶', '丸', '丹', '主', '丼', '乀', '乁',
            '乂', '乄', '之', '乏', '乑', '亙', '亥', '亯', '仗', '仞', '仢', '以', '仭', '仱',
            '仿', '伋', '似', '伾', '住', '佟', '侌', '侭', '俁', '俅', '俌', '俍', '倄', '倵',
            '偂', '偙', '偬', '偽', '傄', '傅', '傖', '傜', '傯', '傺', '僦', '僱', '儇', '儈',
            '儍', '儞', '儳', '儴', '兇', '兎', '兔', '冢', '冤', '冬', '冭', '凑', '凡', '凶',
            '刃', '刅', '刢', '刱', '刹', '刻', '刼', '剱', '剷', '劊', '劒', '劔', '劚', '劥',
            '劾', '勆', '勢', '勪', '勶', '勺', '匀', '匁', '匆', '匍', '匘', '匛', '匲', '区',
            '匾', '博', '卛', '卥', '卵', '厎', '厖', '厴', '叅', '叉', '及', '双', '叕', '吂',
            '吏', '否', '启', '呎', '呤', '呧', '咏', '咫', '咳', '咷', '哎', '哺', '唅', '唪',
            '喭', '喲', '嗆', '嗛', '嗿', '嘹', '嚈', '嚩', '嚭', '囈', '囉', '囍', '囐', '囟',
            '囥', '囱', '国', '圃', '圑', '圴', '圾', '坅', '坍', '坏', '坯', '坻', '坼', '垓',
            '垗', '垡', '垩', '埌', '埔', '埝', '埶', '執', '堍', '塉', '塍', '塨', '塼', '塾',
            '墀', '墊', '墏', '壐', '太', '奃', '奟', '妁', '妒', '妗', '姈', '姒', '娰', '婾',
            '媱', '媲', '媵', '媻', '嫏', '嫽', '嬴', '孋', '孩', '孰', '孵', '宊', '宐', '宔',
            '宝', '宨', '寃', '密', '寒', '尞', '尤', '尦', '尨', '就', '尲', '尶', '尺', '尽',
            '岒', '岺', '崤', '嵃', '嵆', '嵕', '嵢', '嵰', '嶈', '嶛', '嶫', '巉', '巘', '州',
            '巤', '巩', '帆', '帍', '帟', '幋', '幞', '幾', '庬', '廕', '廥', '弈', '弤', '彤',
            '彲', '彴', '彽', '彾', '往', '徧', '忍', '忲', '怟', '怱', '怵', '怺', '恌', '恐',
            '恖', '恡', '悑', '悕', '悢', '悷', '愡', '愵', '愽', '慅', '憭', '懕', '懟', '懢',
            '懩', '懯', '戌', '戍', '戧', '戹', '戽', '扂', '扃', '扄', '扆', '扚', '扠', '扨',
            '抔', '択', '抷', '拄', '拆', '拎', '拔', '挟', '挭', '捄', '捕', '掖', '掭', '掮',
            '掴', '掽', '揔', '揬', '搏', '搔', '搢', '搤', '摋', '摔', '摛', '摯', '撇', '撡',
            '擥', '擪', '攁', '攉', '攙', '攞', '攦', '救', '敷', '斒', '斕', '斥', '旉', '旐',
            '昀', '昈', '昑', '昤', '昶', '昹', '昼', '晀', '晗', '晡', '晵', '暀', '暭', '曏',
            '曫', '曬', '朎', '朓', '朮', '杈', '杓', '极', '枰', '柃', '柉', '柊', '柝', '柱',
            '核', '栿', '桊', '桮', '桹', '梁', '梂', '梣', '梵', '棙', '棜', '棭', '棽', '椓',
            '椖', '楤', '楩', '榑', '榒', '槳', '樁', '樃', '樑', '樒', '樣', '樨', '橑', '機',
            '橪', '檋', '檫', '檿', '櫁', '櫤', '櫰', '欂', '欃', '欉', '欐', '欧', '歪', '殠',
            '殴', '殺', '殽', '殾', '毬', '氐', '気', '氷', '永', '求', '汊', '汋', '汍', '汎',
            '汰', '汴', '汹', '沢', '泌', '泜', '泝', '泠', '注', '泳', '洑', '洮', '洲', '浗',
            '浦', '涔', '涿', '淰', '溓', '溥', '溻', '滃', '滹', '滻', '漈', '漛', '漭', '漰',
            '漾', '潑', '潨', '澀', '瀅', '瀛', '灕', '灼', '炙', '炷', '為', '烑', '烺', '熟',
            '熯', '熱', '爇', '爉', '牎', '牏', '牖', '牻', '犬', '犮', '犱', '犹', '犾', '狉',
            '狭', '狳', '猋', '猒', '猤', '猵', '猺', '獃', '獒', '獘', '獠', '玉', '玓', '玪',
            '珏', '珧', '琀', '球', '瑟', '瑤', '瑨', '瑲', '璒', '璙', '瓌', '瓛', '瓞', '瓨',
            '瓪', '瓫', '瓯', '瓴', '瓺', '瓻', '瓼', '瓿', '甆', '甒', '甖', '甗', '甫', '畃',
            '畇', '畎', '畿', '疣', '疺', '疼', '痞', '痡', '瘀', '瘃', '瘙', '瘝', '瘵', '瘹',
            '癊', '癱', '的', '皥', '盙', '盦', '眔', '眨', '眽', '睎', '睠', '睽', '瞪', '矪',
            '砡', '砭', '硇', '硠', '硺', '碰', '磇', '磠', '磯', '礴', '礿', '祓', '祕', '祧',
            '离', '禽', '秇', '秘', '秚', '秠', '秡', '秢', '秪', '秫', '稀', '稂', '稉', '稯',
            '稴', '穄', '穙', '窆', '窬', '竛', '笂', '笭', '筑', '筠', '筤', '筺', '箞', '箯',
            '箺', '築', '篾', '簄', '簗', '簙', '簠', '簦', '簴', '簺', '簿', '籑', '籝', '籭',
            '籾', '粏', '糉', '糔', '糗', '約', '紈', '紑', '紱', '絚', '絥', '絺', '絿', '綆',
            '綛', '綦', '緪', '緫', '緵', '緶', '縛', '縭', '縶', '繇', '繎', '纚', '缻', '网',
            '罓', '罘', '罜', '羀', '羪', '羸', '翥', '翺', '耹', '聦', '肁', '肈', '肞', '肧',
            '肬', '肴', '胚', '胸', '脉', '脯', '膁', '膊', '臗', '臝', '舖', '舗', '舡', '舢',
            '舨', '舲', '舴', '舺', '艃', '艄', '艅', '艆', '艋', '艎', '艏', '艑', '艖', '艜',
            '艠', '艣', '艧', '艭', '芃', '芄', '芍', '芣', '芨', '芩', '芺', '苤', '苳', '茇',
            '茋', '茰', '荗', '荵', '莄', '莆', '莍', '菐', '菝', '菟', '菸', '萹', '葡', '葢',
            '葯', '葱', '葼', '蒁', '蒪', '蒯', '蒱', '蒲', '蓈', '蓖', '蓺', '蓻', '蔣', '蕟',
            '薄', '薽', '藂', '藊', '藝', '蘺', '虡', '蚘', '蚳', '蚸', '蛀', '蛧', '蛩', '蜅',
            '蜋', '蜜', '螌', '螕', '螣', '螭', '螽', '螿', '蟄', '蟟', '蠃', '蠊', '蠛', '蠟',
            '衂', '衃', '衊', '衑', '術', '衩', '衱', '袚', '袛', '裘', '補', '裷', '褰', '褵',
            '褹', '褺', '褻', '襆', '襏', '襒', '襮', '襼', '覔', '覛', '覜', '覴', '覷', '觩',
            '訯', '訳', '訴', '註', '詅', '詠', '詧', '該', '詶', '詾', '認', '誏', '誧', '諑',
            '諗', '諬', '謆', '謐', '譃', '譅', '譏', '譼', '譾', '讞', '谽', '豋', '豏', '豓',
            '豨', '豹', '豾', '賕', '賡', '賻', '贄', '趵', '趻', '跅', '跋', '跫', '蹁', '蹡',
            '蹬', '蹴', '躐', '躧', '躯', '軨', '輈', '輔', '轑', '轞', '述', '逋', '逑', '遃',
            '遙', '遝', '邋', '邎', '邐', '邳', '郄', '郒', '郗', '郙', '鄈', '鄧', '鄴', '鄹',
            '酈', '酌', '酓', '酗', '酬', '酺', '醨', '醬', '醭', '醱', '釃', '釈', '釜', '釣',
            '釩', '釵', '釻', '釼', '鈐', '鈒', '鈦', '鈬', '鈺', '鉂', '鉥', '鉯', '銎', '銶',
            '鋃', '鋡', '鋪', '錈', '錑', '錜', '鍐', '鍯', '鍳', '鍽', '鎌', '鎛', '鎞', '鎫',
            '鏷', '鏺', '鐮', '鑙', '鑮', '钃', '閝', '閠', '閬', '闋', '闙', '阸', '阺', '隃',
            '隥', '雘', '雫', '霡', '靫', '靭', '靮', '靸', '鞉', '鞏', '鞕', '鞶', '頫', '頯',
            '顖', '颰', '颻', '飡', '飣', '飥', '飦', '飧', '飪', '飳', '飶', '餂', '餇', '餈',
            '餑', '餔', '餕', '餖', '餗', '餚', '餛', '餜', '餟', '餢', '餦', '餧', '餫', '餱',
            '餲', '餳', '餴', '餵', '餹', '餺', '餻', '餼', '饀', '饁', '饆', '饇', '饈', '饍',
            '饎', '饑', '饔', '饘', '饙', '饛', '饜', '饞', '饟', '饠', '馦', '馰', '馺', '馿',
            '駄', '駅', '駆', '駐', '駓', '駭', '駲', '駹', '騐', '騣', '騤', '騷', '騸', '驇',
            '驋', '骪', '骶', '骸', '骾', '髆', '髖', '髬', '鬈', '鬉', '鬋', '鬛', '鬴', '鬷',
            '魃', '魖', '魡', '魥', '魷', '魿', '鮲', '鯁', '鯆', '鯗', '鯳', '鯿', '鰧', '鰩',
            '鰶', '鱁', '鱜', '鱲', '鳹', '鴎', '鵃', '鵩', '鶪', '鶬', '鶱', '鶼', '鷙', '鷲',
            '鸑', '鸒', '鸝', '鹻', '麈', '黈', '黻', '黼', '鼕', '鼗', '鼟', '齅', '龞',
        ],
    },
    Membership {
        radical: '亅',
        strokes: 1,
        kanji: &[
            '丁', '丞', '丹', '乎', '乴', '亅', '了', '予', '争', '亊', '事', '亍', '于', '亦',
            '亨', '亭', '仃', '伃', '伺', '佇', '何', '余', '俄', '俆', '倚', '倫', '倳', '停',
            '儀', '儜', '冊', '凈', '刁', '刺', '剚', '剞', '劌', '匾', '叅', '叮', '可', '司',
            '吁', '后', '呞', '呵', '呼', '咑', '哥', '哦', '哬', '哼', '哿', '啊', '嗣', '嘑',
            '嚬', '圇', '圢', '圩', '坷', '坾', '垢', '埩', '塌', '塗', '塨', '奇', '奵', '妤',
            '妳', '姈', '姊', '姍', '娍', '娥', '婀', '婷', '嬀', '嬝', '孒', '宁', '宇', '宬',
            '寄', '寐', '寧', '寯', '屙', '岢', '岺', '峨', '峩', '崢', '嵜', '嵿', '嶬', '嶲',
            '帟', '庁', '序', '廓', '弙', '弥', '彁', '彾', '徏', '徧', '忬', '惼', '懏', '懧',
            '我', '才', '打', '扜', '承', '抒', '挶', '掄', '掎', '掙', '掭', '撝', '撡', '擕',
            '擰', '敧', '斒', '斿', '旖', '旴', '昤', '晠', '曦', '朎', '朾', '杅', '材', '杼',
            '柃', '柯', '柵', '梈', '梮', '椅', '檇', '檸', '櫲', '欤', '欹', '歌', '殛', '汀',
            '汙', '沔', '河', '泠', '泲', '浄', '淨', '減', '渟', '渮', '滹', '漪', '潙', '澦',
            '濘', '瀞', '瀹', '灋', '灯', '烝', '烹', '焏', '爚', '爭', '牁', '牱', '犄', '犠',
            '犲', '狳', '猗', '猙', '猵', '獰', '玎', '玗', '珂', '珊', '珹', '琤', '琦', '瓴',
            '町', '甼', '畸', '疔', '疴', '痾', '癟', '盂', '盱', '眄', '睜', '矃', '矴', '研',
            '砢', '磤', '礒', '祠', '禴', '秭', '竒', '竚', '竫', '竽', '笥', '笧', '笫', '笭',
            '笴', '策', '筝', '箏', '箞', '篹', '籲', '糄', '紆', '紵', '綺', '罅', '羇', '羜',
            '義', '翎', '耓', '耕', '耵', '聤', '聹', '胏', '臹', '舒', '舲', '舸', '艑', '艤',
            '苛', '苧', '荷', '荼', '荿', '莪', '菏', '萹', '葶', '蒸', '蔫', '蕷', '薴', '藊',
            '蘅', '虖', '虶', '蚵', '蛾', '蜍', '蟻', '覉', '覗', '觭', '觹', '觽', '訂', '訏',
            '訶', '詅', '詝', '詞', '諍', '諺', '謌', '謼', '議', '豫', '豺', '財', '貯', '踦',
            '蹁', '軨', '軻', '迂', '迹', '途', '邘', '郕', '郭', '酊', '野', '釘', '釪', '釮',
            '鈣', '鈳', '鉰', '鋮', '錀', '錚', '錡', '鍽', '鎶', '鏊', '閉', '阿', '隸', '雋',
            '静', '靜', '靪', '頂', '預', '飣', '飼', '餓', '餘', '騎', '驁', '骬', '髩', '鬦',
            '鬨', '鬫', '鬭', '魣', '鯎', '鯿', '鵝', '鵞', '鸙', '鼒', '齮', '龡', '龢', '龣',
            '龥',
        ],
    },
    Membership {
        radical: '乙',
        strokes: 1,
        kanji: &[
            '七', '乇', '之', '乏', '乙', '乚', '乜', '乞', '也', '乢', '乣', '乨', '乩', '乱',
            '乳', '乴', '乵', '乹', '乾', '乿', '亀', '亂', '亳', '仛', '仡', '侘', '俋', '俺',
            '僀', '儱', '儳', '兂', '兦', '冘', '凂', '凢', '剦', '劖', '劜', '匜', '卂', '厇',
            '吃', '吧', '吨', '吪', '吼', '咃', '咤', '唈', '唵', '嘅', '嚨', '囤', '圠', '圪',
            '垞', '垡', '堍', '墍', '夿', '奄', '奙', '她', '奼', '孔', '宅', '尬', '尮', '尰',
            '尲', '尵', '尶', '屯', '屹', '岊', '崦', '巃', '巤', '巩', '巴', '彵', '忔', '忳',
            '怵', '惽', '慸', '戹', '扎', '托', '扽', '抿', '拖', '拽', '挓', '挖', '挹', '掩',
            '揓', '撬', '攏', '敃', '旈', '旾', '晻', '曨', '曳', '札', '杔', '杝', '杶', '枕',
            '柂', '柉', '柒', '栧', '栬', '梍', '椸', '殗', '殢', '毡', '毣', '毦', '毧', '毮',
            '毱', '毷', '毹', '毿', '氂', '氄', '氅', '氉', '氍', '氎', '氾', '汔', '汛', '沲',
            '泛', '洩', '浥', '淝', '淹', '灉', '灔', '炖', '炛', '煢', '爉', '爸', '牠', '犯',
            '獵', '瓨', '瓪', '瓫', '瓯', '瓴', '瓺', '瓻', '瓼', '瓿', '甆', '甒', '甖', '甗',
            '甩', '疙', '疤', '疺', '皅', '盹', '眊', '眨', '矻', '砭', '礱', '礼', '秏', '秫',
            '穐', '穵', '窀', '窆', '竃', '竉', '竜', '竾', '笔', '箞', '範', '篹', '簄', '糺',
            '紇', '紞', '紦', '紮', '絁', '絻', '縄', '缻', '罨', '羗', '耴', '肫', '脃', '腌',
            '臫', '艜', '艴', '芚', '芤', '芲', '芼', '苆', '菴', '萙', '蒓', '蕝', '薽', '蘎',
            '蘒', '虬', '虱', '虵', '蜣', '蝨', '蝿', '螮', '蠃', '袘', '裛', '訑', '訖', '託',
            '訦', '詫', '誮', '謊', '讋', '豅', '豘', '豝', '貤', '貶', '赩', '趷', '蹛', '蹴',
            '躐', '躭', '軋', '輒', '迄', '迅', '迆', '迍', '迤', '遰', '邋', '邕', '邥', '郌',
            '郒', '郶', '酏', '醃', '醓', '釓', '釔', '鈀', '鉇', '鉥', '銫', '銸', '錷', '鎏',
            '鑨', '鑱', '閹', '阤', '阸', '陁', '雝', '電', '霃', '靶', '飥', '饞', '馲', '駞',
            '髧', '鬛', '鬮', '魨', '魫', '魹', '鮿', '鱲', '鳦', '黆', '黕', '黤', '齆', '齓',
            '齕', '龏', '龐', '龑', '龒', '龔', '龖', '龗', '龜', '龝', '龞',
        ],
    },
    Membership {
        radical: 'ハ',
        strokes: 2,
        kanji: &[
            '乗', '乘', '亦', '介', '份', '伀', '伵', '伻', '余', '佾', '來', '侏', '供', '俆',
            '俗', '倊', '倎', '倛', '倦', '倰', '倶', '側', '偵', '傊', '傎', '傛', '傟', '債',
            '傾', '僎', '僓', '僔', '僨', '價', '儋', '儍', '儐', '儞', '償', '儣', '儧', '儨',
            '儬', '儹', '兊', '兗', '兤', '全', '八', '公', '六', '兮', '共', '兵', '其', '具',
            '典', '兼', '兾', '冀', '冥', '冸', '凕', '凘', '凲', '刅', '分', '刱', '刺', '則',
            '剌', '剘', '劀', '劕', '劗', '劵', '勌', '勛', '勜', '勣', '勩', '匱', '匵', '卙',
            '卷', '卻', '厠', '厮', '叡', '只', '叭', '吩', '呉', '呮', '味', '咫', '哄', '員',
            '唄', '啿', '喇', '嗌', '嗔', '嗩', '嗽', '嗿', '嘖', '嘳', '嘶', '噀', '噡', '噴',
            '噸', '嚝', '嚢', '嚬', '嚶', '囂', '囋', '囎', '囧', '囶', '圓', '圚', '坌', '坴',
            '坹', '垗', '垬', '埧', '埶', '基', '堺', '塀', '塍', '塕', '塗', '塞', '塡', '塤',
            '塧', '填', '墈', '墳', '壂', '壌', '壐', '壑', '壙', '壝', '壡', '夋', '夌', '夒',
            '夓', '夔', '夤', '奕', '妳', '妹', '娧', '娯', '婈', '媜', '媵', '嫆', '嫌', '嫩',
            '嬢', '嬪', '嬭', '嬰', '嬾', '孾', '宍', '容', '寅', '寏', '寐', '寒', '寘', '寡',
            '實', '寨', '寳', '寶', '尣', '尦', '尩', '尵', '屓', '屭', '岔', '岼', '峪', '崆',
            '崱', '嵕', '嵡', '嵿', '嶒', '嶺', '嶼', '巎', '巓', '巙', '巷', '巽', '帘', '帟',
            '帨', '幀', '幎', '幘', '幨', '庱', '廁', '廉', '廎', '廝', '廣', '弈', '弯', '弿',
            '彌', '彍', '彛', '彸', '徠', '忩', '忪', '忿', '怦', '恋', '恭', '恱', '悚', '悾',
            '惧', '惻', '愌', '愖', '愪', '愹', '愼', '慎', '慣', '慻', '慾', '憋', '憒', '憖',
            '憙', '憤', '懬', '懭', '懶', '戇', '戝', '戴', '扒', '扮', '抨', '抹', '拌', '拱',
            '挖', '挙', '挩', '捘', '捴', '捵', '掕', '揀', '揁', '揕', '揬', '損', '搤', '搴',
            '摜', '撇', '撕', '撙', '撰', '擧', '擯', '擴', '擷', '攀', '攅', '攓', '攖', '攘',
            '攛', '攢', '攽', '敕', '敗', '斯', '旗', '旟', '昖', '昧', '晎', '晙', '晪', '暝',
            '暴', '曂', '曌', '曝', '曠', '曩', '曾', '朙', '朞', '期', '未', '末', '朱', '朳',
            '朿', '束', '松', '枌', '枩', '枰', '枳', '柈', '柗', '栱', '梖', '梥', '梲', '梹',
            '棊', '棋', '棗', '棘', '棬', '棱', '棻', '棼', '椣', '楝', '楨', '榕', '榠', '榨',
            '榺', '槇', '槓', '槙', '樌', '横', '樻', '橳', '檟', '檱', '檳', '櫃', '櫕', '櫝',
            '櫻', '欅', '欑', '欲', '欺', '歟', '歵', '殊', '殞', '殨', '殯', '殰', '殿', '氄',
            '氛', '汾', '沫', '沿', '泙', '泬', '泮', '洙', '洪', '浚', '浜', '浴', '涗', '淇',
            '淞', '淟', '淩', '測', '港', '湏', '湓', '湞', '溂', '溟', '溢', '溭', '溳', '溶',
            '溿', '滃', '滇', '滾', '演', '漬', '潁', '潏', '潢', '潰', '澃', '澌', '澒', '澦',
            '澱', '濂', '濆', '濔', '濬', '濱', '濵', '濺', '濽', '瀆', '瀇', '瀍', '瀑', '瀕',
            '瀬', '瀰', '瀴', '瀷', '灝', '烘', '焌', '煁', '煉', '煩', '熔', '熕', '熲', '熿',
            '燌', '爆', '爇', '爛', '爨', '爾', '牘', '犢', '狖', '狻', '狽', '猽', '獖', '獘',
            '獝', '獮', '獱', '獷', '獺', '獼', '玐', '玜', '玢', '珙', '珠', '琛', '琪', '瑍',
            '瑢', '瑣', '瑱', '璒', '璚', '璜', '璵', '璽', '璿', '瓉', '瓔', '瓚', '瓫', '瓮',
            '瓰', '甖', '畟', '畯', '異', '痠', '瘓', '癀', '癜', '癩', '癪', '癭', '癲', '皟',
            '盆', '益', '盨', '盻', '盼', '眛', '眞', '真', '眹', '睖', '睠', '睿', '瞋', '瞑',
            '瞔', '瞚', '瞶', '瞾', '矉', '矞', '矰', '砰', '硲', '碁', '碘', '碩', '碵', '碽',
            '磌', '磒', '磡', '磧', '磺', '礥', '礦', '礩', '祺', '祾', '禎', '禛', '禩', '禳',
            '秉', '秚', '秣', '稑', '稘', '稯', '稹', '穃', '積', '穎', '穟', '穣', '穥', '穪',
            '穴', '穵', '穸', '穾', '窀', '窂', '窅', '窆', '窊', '窋', '窐', '窑', '窔', '窞',
            '窠', '窣', '窬', '窳', '窵', '窹', '窺', '窻', '窼', '竆', '竇', '竉', '竴', '策',
            '箕', '箞', '篊', '篔', '簀', '簛', '簣', '簧', '簨', '簱', '簴', '簾', '籍', '籏',
            '籟', '籩', '籲', '粉', '粠', '糉', '紛', '綌', '綗', '総', '練', '緵', '縜', '縝',
            '縯', '績', '繒', '繘', '繢', '繸', '繽', '纇', '纈', '纉', '纊', '續', '纐', '纓',
            '纘', '罇', '罌', '罾', '翁', '翼', '耒', '耕', '耗', '耘', '耙', '耜', '耡', '耨',
            '聡', '聵', '肦', '肸', '肹', '脧', '腆', '膩', '臀', '臋', '臏', '與', '興', '舉',
            '舚', '舩', '船', '芬', '苹', '茉', '茣', '茱', '荼', '莔', '菘', '萁', '萯', '葖',
            '葚', '葰', '葼', '蓂', '蓉', '蓊', '蓺', '蔶', '蕀', '蕆', '蕒', '蕡', '蕢', '蕷',
            '蕻', '薋', '薝', '薠', '藇', '藉', '藕', '藚', '藭', '藾', '蘋', '蘛', '蘡', '虁',
            '虞', '虡', '蚡', '蚣', '蛛', '蛬', '蛽', '蜈', '蜙', '蜞', '蝤', '螉', '螟', '螠',
            '螣', '螾', '蟖', '蠒', '蠙', '蠲', '蠵', '衅', '衖', '衠', '袞', '裕', '裹', '褹',
            '襀', '襄', '襏', '襚', '襜', '襭', '襰', '襼', '覥', '覼', '覿', '觿', '訟', '詮',
            '詹', '誄', '誅', '誤', '諆', '諡', '諫', '諶', '謇', '謙', '譄', '譔', '譲', '譽',
            '讀', '讃', '讚', '讟', '谷', '谸', '谹', '谺', '谽', '谾', '豁', '豅', '豶', '貝',
            '貞', '負', '財', '貢', '貤', '貧', '貨', '販', '貪', '貫', '責', '貭', '貮', '貯',
            '貰', '貲', '貳', '貴', '貶', '買', '貸', '貹', '貺', '費', '貼', '貽', '貿', '賀',
            '賁', '賂', '賃', '賄', '賅', '賆', '資', '賈', '賉', '賊', '賋', '賍', '賎', '賏',
            '賑', '賓', '賕', '賖', '賙', '賚', '賛', '賜', '賝', '賞', '賠', '賡', '賢', '賣',
            '賤', '賦', '賨', '質', '賬', '賭', '賯', '賰', '賲', '賵', '賷', '賸', '賺', '賻',
            '購', '賽', '賾', '賿', '贁', '贃', '贄', '贅', '贇', '贈', '贉', '贊', '贋', '贍',
            '贏', '贐', '贒', '贓', '贔', '贖', '贗', '贛', '赬', '趲', '踆', '踈', '踑', '踡',
            '踸', '蹇', '蹎', '蹞', '蹟', '蹩', '蹭', '躓', '躮', '躻', '軹', '輂', '輘', '輶',
            '輿', '轒', '轝', '迹', '途', '速', '逧', '遉', '遦', '選', '遹', '遺', '邇', '邉',
            '邠', '郤', '郥', '鄍', '鄖', '鄮', '鄺', '鄼', '鄽', '酇', '酚', '醡', '醸', '釁',
            '釐', '金', '釟', '釡', '鈆', '鈖', '鉙', '鉛', '鉡', '鉷', '銖', '鋇', '鋲', '錂',
            '錤', '錪', '錬', '錴', '鍐', '鍘', '鍞', '鎌', '鎔', '鎖', '鎫', '鎭', '鎮', '鎰',
            '鎹', '鏆', '鐁', '鐄', '鐉', '鐍', '鐏', '鐐', '鑈', '鑌', '鑕', '鑚', '鑛', '鑜',
            '鑟', '鑽', '镾', '関', '閧', '閴', '闌', '闐', '闝', '闠', '陖', '隕', '隤', '雟',
            '雰', '霣', '霱', '靧', '靺', '靽', '鞚', '鞼', '韆', '韇', '韻', '頁', '頂', '頃',
            '項', '順', '頇', '須', '頊', '頌', '頍', '頎', '頏', '預', '頑', '頒', '頓', '頔',
            '頖', '頗', '領', '頙', '頚', '頜', '頞', '頠', '頡', '頣', '頤', '頥', '頦', '頫',
            '頬', '頭', '頮', '頯', '頰', '頲', '頳', '頴', '頵', '頷', '頸', '頻', '頼', '頽',
            '頾', '顄', '顆', '顇', '顊', '顋', '題', '額', '顎', '顏', '顑', '顒', '顓', '顔',
            '顕', '顖', '顗', '願', '顙', '顚', '顛', '類', '顢', '顣', '顥', '顦', '顧', '顪',
            '顫', '顬', '顯', '顰', '顱', '顳', '顴', '颶', '餕', '餘', '饋', '饌', '饙', '騏',
            '騣', '騫', '驇', '驤', '驥', '髕', '鬂', '鬆', '鬉', '鬒', '鬙', '鬚', '鬢', '鬨',
            '鬷', '魅', '魌', '魵', '鮝', '鮻', '鯥', '鯪', '鰂', '鰌', '鰧', '鱉', '鱊', '鱛',
            '鱝', '鱮', '鴪', '鵔', '鵙', '鵼', '鶇', '鶲', '鷆', '鷏', '鷩', '鸎', '鸚', '麄',
            '麌', '麒', '黄', '黆', '黈', '黋', '黌', '黮', '黰', '黵', '黷', '黹', '黻', '黼',
            '鼕', '鼢', '齎', '齞', '龔', '龞', '龥',
        ],
    },
    Membership {
        radical: '二',
        strokes: 2,
        kanji: &[
            '三', '並', '丮', '丰', '丼', '二', '亍', '于', '云', '井', '亖', '亗', '亘', '亙',
            '些', '亝', '亞', '亟', '仁', '仨', '伕', '会', '伝', '伴', '佘', '余', '佚', '佞',
            '併', '侉', '侓', '供', '侠', '俆', '俉', '俌', '俣', '俵', '俸', '倜', '借', '倦',
            '倧', '倩', '偁', '偆', '偰', '傃', '傞', '傲', '債', '傺', '僄', '僅', '僎', '僕',
            '僣', '僵', '儖', '儣', '儬', '儴', '儺', '兂', '元', '兘', '兤', '共', '兾', '冀',
            '冃', '冄', '冐', '冑', '冓', '冕', '冱', '冸', '冿', '凑', '凛', '刑', '刓', '判',
            '刱', '刳', '制', '券', '剏', '剘', '割', '剽', '劵', '劷', '勌', '勖', '勝', '勡',
            '勣', '勤', '勷', '匏', '半', '卷', '卾', '厝', '厪', '叚', '叞', '吁', '吽', '呍',
            '呩', '味', '咢', '咲', '哄', '哪', '哶', '唍', '唪', '唶', '啁', '喫', '嗉', '嘆',
            '嘏', '嘒', '嘖', '嘷', '嘿', '噀', '噁', '噄', '噤', '嚝', '嚷', '囅', '囈', '囊',
            '囏', '囓', '园', '圈', '圊', '圏', '圑', '圕', '圩', '圬', '均', '坢', '型', '垩',
            '垪', '垬', '垸', '埕', '堊', '塀', '塉', '塐', '塨', '墀', '墁', '墈', '墐', '壂',
            '壎', '壙', '壜', '壤', '壩', '壼', '夅', '夆', '天', '夫', '夬', '失', '夳', '夸',
            '奈', '奉', '奏', '契', '奝', '妋', '妌', '妍', '妧', '妰', '妹', '姱', '娜', '娪',
            '婧', '媋', '媢', '媾', '嫖', '嫮', '孁', '孮', '完', '宗', '害', '宼', '寇', '寐',
            '察', '寿', '尉', '尰', '屏', '展', '岏', '岝', '岼', '峡', '崇', '崿', '嵂', '嵈',
            '巻', '巽', '帙', '帮', '幖', '幘', '幞', '幰', '并', '廑', '弍', '弎', '弐', '弙',
            '弿', '彍', '彗', '形', '彯', '徖', '徤', '徱', '忈', '忝', '忢', '忨', '快', '忶',
            '怍', '恗', '恝', '悆', '悑', '悥', '悰', '情', '惎', '惓', '惜', '惡', '惷', '愃',
            '愕', '愫', '慓', '慬', '慰', '憃', '憲', '懃', '懢', '懩', '懯', '戃', '戩', '戴',
            '扜', '扶', '承', '抉', '抎', '抏', '拌', '拱', '拲', '拳', '挟', '捁', '捂', '捧',
            '捲', '捶', '捺', '措', '掽', '揆', '揎', '揳', '揵', '搢', '搴', '摓', '摴', '摽',
            '撒', '撥', '撬', '撰', '撲', '擦', '攁', '攅', '攓', '攘', '攤', '攮', '敔', '敖',
            '散', '斎', '斠', '斮', '斳', '旔', '旴', '昀', '昊', '昔', '春', '昧', '晉', '晎',
            '普', '晴', '暄', '暙', '暛', '暭', '暴', '曂', '曄', '曇', '替', '未', '朱', '杅',
            '杇', '来', '杬', '枅', '枏', '柈', '柡', '柰', '栔', '栙', '栱', '桍', '桟', '桧',
            '桻', '梛', '梡', '梼', '棈', '棒', '棕', '棰', '椏', '椦', '椿', '楔', '楗', '楥',
            '楱', '榛', '榡', '槻', '槿', '樁', '樗', '標', '横', '樰', '樲', '樸', '橒', '檋',
            '檑', '檫', '檱', '檻', '檽', '欖', '欛', '欞', '欫', '款', '歎', '歵', '殊', '残',
            '殣', '殿', '毒', '毡', '毣', '毦', '毧', '毮', '毱', '毷', '毹', '毿', '氂', '氄',
            '氅', '氉', '氍', '氎', '氬', '汙', '汚', '汫', '決', '沅', '沫', '泮', '泰', '洙',
            '洪', '洯', '洿', '浅', '浣', '浯', '涂', '涛', '淎', '淙', '添', '清', '渓', '渕',
            '湊', '湲', '満', '溌', '溍', '溙', '溠', '溱', '溿', '滕', '滭', '滽', '漂', '漈',
            '漌', '漢', '漬', '潔', '潜', '潽', '澌', '澐', '澔', '澱', '濫', '濹', '瀑', '瀗',
            '瀞', '瀷', '瀼', '灘', '灞', '烘', '烽', '煹', '熛', '熢', '熨', '燵', '燸', '爗',
            '牅', '犀', '犍', '狭', '狳', '猜', '猨', '獯', '玗', '玩', '珒', '珙', '珠', '琪',
            '琫', '琮', '瑃', '瑇', '瑗', '瑧', '瑨', '瑾', '璞', '瓞', '瓢', '瓤', '瓶', '甩',
            '畉', '畊', '畔', '畴', '瘄', '瘠', '瘥', '瘭', '瘵', '癈', '癋', '癪', '癱', '癸',
            '発', '皐', '皖', '皟', '皣', '皥', '盂', '監', '盱', '盶', '看', '眎', '眛', '眷',
            '睆', '睛', '瞎', '瞔', '瞟', '瞱', '矠', '砉', '研', '硾', '碏', '碡', '碰', '碾',
            '磦', '磧', '礌', '礭', '礵', '示', '祅', '祆', '祊', '祔', '祘', '祛', '祜', '祟',
            '祧', '票', '祫', '祭', '祲', '祷', '祹', '祼', '禀', '禁', '禊', '禋', '禔', '禕',
            '禖', '禘', '禛', '禜', '禡', '禦', '禩', '禫', '禱', '禴', '秏', '秚', '秠', '秦',
            '穄', '積', '穙', '穽', '窹', '窺', '竺', '竽', '笄', '筦', '筭', '箐', '箠', '箺',
            '箻', '篊', '篝', '篨', '篲', '簀', '簆', '簉', '簎', '簛', '簨', '簱', '簶', '簺',
            '籃', '籍', '籐', '籘', '籞', '粠', '粽', '精', '糙', '糞', '紆', '紜', '素', '絆',
            '絚', '絜', '絝', '絣', '絳', '絵', '綜', '綣', '綦', '綪', '緪', '縉', '縢', '縹',
            '績', '繖', '繧', '繿', '纁', '纉', '纕', '纛', '纜', '缺', '罅', '罎', '羋', '羦',
            '羮', '翲', '翺', '翼', '耓', '耘', '耝', '耟', '耤', '耺', '耼', '肁', '肈', '胖',
            '胮', '胯', '胼', '脊', '脘', '腊', '腭', '膆', '膖', '膘', '膩', '臋', '臛', '臻',
            '舂', '舉', '舝', '舞', '艦', '艱', '芙', '芫', '芸', '芼', '苚', '苤', '茟', '茱',
            '荂', '荊', '荼', '莞', '莱', '菁', '菐', '菫', '菶', '萁', '萼', '葏', '葜', '葵',
            '蒄', '蒜', '蒨', '蒪', '蓁', '蓽', '蔚', '蔡', '蔧', '蔭', '蔲', '蔳', '蔶', '蕐',
            '蕓', '蕚', '蕯', '蕻', '蕿', '薑', '薷', '薸', '薽', '藉', '藍', '藝', '藤', '藼',
            '藿', '蘅', '蘎', '蘐', '蘘', '虂', '虧', '虶', '蚌', '蚕', '蚖', '蚦', '蛛', '蛬',
            '蜍', '蜞', '蜡', '蜯', '蜷', '蜻', '蝯', '螓', '螱', '螵', '蟖', '蟤', '蠢', '蠭',
            '蠰', '衅', '衋', '衖', '表', '衻', '袂', '袢', '袴', '裯', '裱', '褠', '褨', '褰',
            '褾', '襀', '襆', '襟', '襤', '襮', '襼', '規', '覧', '覲', '訏', '訣', '評', '誅',
            '誇', '諆', '請', '諠', '諤', '諼', '謄', '謹', '譔', '譛', '譜', '讃', '豁', '豢',
            '豣', '責', '貳', '賎', '賖', '賙', '賛', '賨', '賰', '賵', '賾', '趞', '趺', '跌',
            '跨', '践', '踑', '踖', '踪', '踳', '蹍', '蹐', '蹟', '蹼', '転', '軼', '輂', '輐',
            '輦', '輳', '輾', '轃', '轄', '迂', '运', '迭', '迸', '送', '逄', '逓', '逢', '逪',
            '遌', '選', '邘', '那', '邦', '郜', '鄂', '鄘', '鄞', '鄠', '酃', '酛', '酴', '醋',
            '醗', '醭', '醽', '釐', '釪', '鈨', '鉄', '鉡', '鉷', '銉', '銖', '銭', '鋆', '鋎',
            '鋙', '錆', '錈', '錏', '錝', '錤', '錯', '錶', '鍔', '鍥', '鍰', '鎋', '鎹', '鏊',
            '鏞', '鏢', '鏷', '鐁', '鐉', '鐚', '鐳', '鑑', '鑒', '鑚', '鑮', '開', '関', '閧',
            '闒', '闥', '阮', '院', '陦', '陰', '際', '隷', '隸', '難', '雩', '雯', '雱', '雲',
            '雺', '霂', '霃', '霅', '霉', '霊', '霚', '霛', '霝', '霡', '霢', '霣', '霨', '霰',
            '霱', '霳', '靁', '靃', '靆', '靉', '靊', '靎', '靏', '青', '靕', '靖', '靗', '靘',
            '静', '靚', '靛', '靜', '靽', '鞬', '鞲', '鞸', '鞾', '韛', '韝', '韠', '韡', '韸',
            '頑', '頖', '頬', '頴', '顎', '顬', '飃', '飄', '餅', '餘', '饉', '饌', '饟', '駢',
            '騌', '騞', '騰', '驁', '驃', '驊', '驤', '驥', '骬', '骻', '髥', '髬', '鬃', '鬨',
            '魂', '魅', '魌', '魭', '魹', '鮬', '鯇', '鯖', '鯗', '鰀', '鰆', '鰐', '鰲', '鰶',
            '鰾', '鱃', '鱅', '鱩', '鴃', '鵥', '鵰', '鶎', '鶏', '鶚', '鶱', '鶺', '鸖', '鹺',
            '麦', '麩', '麸', '麹', '麺', '黿', '鼇', '鼯', '鼱', '齧', '齰', '齶', '齽', '龒',
            '龔', '龗',
        ],
    },
    Membership {
        radical: '十',
        strokes: 2,
        kanji: &[
            '丗', '丵', '乖', '乘', '乵', '乹', '乾', '什', '仐', '仟', '仠', '仵', '伎', '伜',
            '估', '伳', '伴', '伻', '侁', '來', '侼', '俌', '俜', '俾', '倅', '個', '倖', '倝',
            '値', '倨', '倬', '做', '偱', '傁', '傎', '傘', '傳', '傽', '僀', '僂', '僖', '僤',
            '僨', '僻', '儎', '克', '兢', '冉', '冓', '凄', '凅', '凖', '刋', '判', '剋', '劈',
            '劘', '勀', '勃', '勸', '匍', '匰', '十', '卂', '千', '卅', '卆', '升', '午', '卉',
            '半', '卋', '卍', '卑', '卒', '卓', '協', '南', '単', '卙', '博', '卛', '厈', '厪',
            '叀', '叏', '叓', '叟', '古', '叫', '叶', '吱', '呄', '咕', '哶', '哺', '唕', '唫',
            '啅', '啇', '啐', '啚', '啛', '啤', '喃', '單', '嗔', '嘏', '嘙', '嘲', '嘷', '嘻',
            '嘽', '噴', '嚏', '嚔', '嚩', '嚭', '囀', '囅', '囊', '囍', '囏', '固', '圃', '圉',
            '團', '圛', '埔', '埠', '埣', '埤', '埴', '執', '堌', '報', '填', '墇', '墊', '墐',
            '墠', '墳', '壁', '壊', '壩', '夲', '奔', '奲', '妓', '姑', '姧', '娨', '婞', '婢',
            '婥', '婻', '媾', '嫜', '嫡', '嫥', '嬋', '嬖', '孛', '孼', '孽', '宰', '寘', '専',
            '尅', '專', '尌', '尭', '居', '屐', '屽', '岐', '岵', '崒', '嶂', '嶧', '巓', '帔',
            '帲', '幛', '幮', '干', '幸', '幹', '庋', '庪', '庳', '廋', '廑', '廟', '廰', '廳',
            '弾', '彈', '彰', '徝', '循', '徳', '忓', '忤', '忮', '忰', '怘', '怙', '悑', '悖',
            '悳', '悴', '悻', '悼', '愂', '愽', '慎', '慞', '慬', '慱', '憄', '憘', '憚', '憤',
            '懌', '懐', '懥', '懽', '戁', '戇', '戟', '戦', '戰', '技', '抨', '拌', '括', '挿',
            '捕', '捭', '据', '捽', '掉', '插', '搆', '搏', '搜', '摔', '摘', '摯', '摶', '撣',
            '撻', '擇', '擗', '擘', '擿', '攮', '支', '攱', '攼', '故', '敵', '敷', '斁', '斡',
            '斳', '旉', '早', '旰', '旴', '旿', '昇', '晘', '晡', '晫', '晬', '暁', '暤', '暭',
            '暲', '暵', '暿', '曎', '曺', '朇', '朝', '杵', '枝', '枠', '枯', '枰', '枽', '柀',
            '桒', '桲', '梓', '棝', '棲', '棹', '椊', '植', '椐', '椑', '楛', '楜', '楠', '楯',
            '榑', '榦', '榫', '構', '槙', '槫', '槹', '樀', '樟', '樾', '樿', '橲', '檗', '櫉',
            '櫱', '欂', '權', '欛', '欟', '歃', '歒', '歖', '歝', '歡', '歧', '殖', '殣', '殫',
            '殬', '氒', '汁', '汛', '汻', '沽', '活', '浡', '浦', '涬', '涸', '淖', '淬', '渀',
            '渤', '湖', '湳', '準', '溝', '溥', '溲', '滇', '滓', '滭', '滴', '滷', '漌', '漳',
            '潓', '潬', '潭', '潮', '潰', '澍', '澎', '澣', '澤', '澼', '濆', '瀚', '灌', '灞',
            '焠', '焯', '焼', '煢', '熯', '熹', '熺', '燀', '燌', '爯', '牌', '牐', '牖', '牯',
            '犀', '犴', '猂', '猝', '猞', '猢', '献', '獐', '獖', '率', '玕', '琚', '瑚', '瑱',
            '璋', '璧', '璻', '瓣', '瓧', '瓩', '甎', '甓', '甫', '畔', '畞', '疐', '痲', '痺',
            '痼', '瘁', '瘦', '瘴', '癉', '癖', '癱', '癲', '皁', '皋', '皐', '皷', '皽', '盙',
            '盬', '盰', '直', '盾', '真', '睅', '睟', '睥', '睪', '睾', '瞋', '瞍', '瞕', '瞽',
            '矗', '矸', '砕', '砰', '碎', '碑', '磌', '磚', '磠', '礴', '祜', '祻', '禅', '禛',
            '禧', '禫', '离', '秊', '稗', '稙', '稡', '稯', '稱', '稹', '稺', '穂', '窣', '竍',
            '竏', '章', '竨', '箄', '箇', '箥', '箪', '箶', '篝', '篺', '簓', '簙', '簟', '簠',
            '簳', '簿', '籜', '籵', '粁', '粋', '粹', '粺', '糊', '糦', '糵', '糾', '索', '紣',
            '絆', '綍', '綷', '綽', '緙', '縛', '縝', '縡', '縶', '繟', '繥', '繹', '罩', '置',
            '罱', '翅', '翆', '翠', '翰', '翺', '耬', '聴', '聽', '肢', '肸', '胖', '胡', '胾',
            '脖', '脯', '脺', '脾', '腒', '腩', '腯', '膊', '膞', '膢', '膨', '膵', '臂', '臎',
            '臡', '臿', '舖', '舗', '芉', '芊', '芰', '芾', '苒', '苦', '草', '荸', '莆', '莘',
            '莾', '菇', '萃', '萆', '葡', '葧', '葫', '蒪', '蒱', '蒲', '蓱', '蓴', '蓻', '蔐',
            '蔞', '蔢', '蕈', '蕙', '蕡', '薄', '薛', '薜', '薭', '蘀', '蘄', '蘖', '蘗', '虷',
            '蚑', '蛄', '蜅', '蜱', '蝉', '蝴', '蝻', '螋', '蟀', '蟄', '蟚', '蟢', '蟪', '蟫',
            '蠎', '衎', '術', '衘', '衚', '衠', '衷', '袢', '補', '裨', '裾', '褝', '褺', '襌',
            '襗', '襞', '覃', '覉', '覩', '觀', '觶', '計', '許', '詁', '詖', '誖', '誧', '誶',
            '諵', '講', '謫', '譆', '譚', '譬', '譯', '讁', '讙', '豉', '豣', '豶', '豻', '貋',
            '貭', '賁', '賊', '賷', '賻', '購', '贄', '贉', '贛', '趕', '趠', '跂', '踔', '踞',
            '蹎', '蹢', '躃', '躄', '躕', '軁', '軃', '輔', '輧', '輴', '轉', '轒', '辛', '辜',
            '辝', '辞', '辟', '辠', '辡', '辣', '辤', '辥', '辦', '辧', '辨', '辭', '辮', '辯',
            '辻', '迀', '迁', '迅', '迕', '述', '逋', '逩', '逬', '逴', '逹', '遁', '遖', '遦',
            '遧', '適', '避', '邗', '郙', '郫', '鄞', '鄣', '鄲', '酔', '酤', '酺', '醉', '醐',
            '醰', '醳', '釋', '針', '釬', '鈘', '鈷', '鈹', '鉥', '銒', '銲', '鋅', '鋍', '鋪',
            '鋸', '錍', '錮', '鍤', '鎍', '鎛', '鎨', '鎮', '鏄', '鏆', '鏑', '鏸', '鐔', '鐴',
            '鐸', '鑮', '鑵', '閈', '闐', '闡', '闢', '闥', '阜', '阡', '降', '陴', '障', '隦',
            '隼', '霹', '革', '靪', '靮', '靳', '靶', '靷', '靸', '靻', '靽', '靿', '鞀', '鞉',
            '鞕', '鞖', '鞗', '鞙', '鞚', '鞞', '鞟', '鞢', '鞬', '鞮', '鞱', '鞲', '鞵', '鞶',
            '鞸', '鞹', '鞺', '鞼', '鞾', '鞿', '韁', '韄', '韅', '韇', '韉', '韊', '韓', '韯',
            '頇', '頍', '顇', '顊', '顛', '顰', '顴', '飦', '餑', '餔', '餬', '餴', '餺', '饎',
            '饙', '騂', '騨', '驔', '驖', '驛', '驩', '髀', '髆', '髯', '髲', '鬍', '鬒', '鬴',
            '鮍', '鯆', '鯝', '鱄', '鱆', '鱏', '鱓', '鱚', '鱝', '鳷', '鴇', '鴣', '鵇', '鵓',
            '鵫', '鵯', '鶘', '鷏', '鷙', '鸊', '鹵', '鹸', '鹹', '鹺', '鹻', '鹼', '鹽', '麞',
            '麥', '麨', '麩', '麪', '麬', '麭', '麮', '麯', '麰', '麳', '麴', '麵', '黰', '黼',
            '鼓', '鼔', '鼕', '鼖', '鼗', '鼙', '鼚', '鼛', '鼟',
        ],
    },
    Membership {
        radical: '丷',
        strokes: 2,
        kanji: &[
            '並', '丫', '丵', '乎', '亊', '伴', '佯', '併', '侠', '侻', '俤', '倦', '偂', '偐',
            '偙', '偽', '傍', '傞', '僐', '僔', '僕', '僖', '僜', '僧', '儀', '儈', '儯', '儵',
            '兌', '兼', '兾', '冸', '凒', '凱', '凲', '凳', '判', '券', '剃', '剅', '前', '剏',
            '剛', '剪', '剴', '劂', '劊', '劷', '勝', '勬', '半', '南', '卷', '厥', '厨', '叛',
            '叢', '呼', '咩', '咲', '哾', '唫', '商', '啇', '啻', '啼', '喃', '善', '喜', '嗌',
            '嗞', '嗟', '嘑', '嘻', '嘿', '噂', '噌', '噎', '噔', '噠', '噲', '噵', '噺', '嚭',
            '嚱', '囍', '囎', '囏', '圈', '圏', '圛', '坢', '坪', '垟', '垩', '垪', '堈', '塍',
            '塏', '塑', '塧', '墊', '増', '墜', '墟', '墡', '墫', '墱', '壎', '壹', '夔', '奠',
            '姜', '娣', '娧', '婞', '婻', '媵', '嫌', '嫡', '嬁', '嬉', '孳', '寮', '尊', '尌',
            '對', '導', '尲', '屏', '層', '屰', '岡', '峡', '崗', '崹', '嵜', '嵭', '嵯', '嵰',
            '嵳', '嶒', '嶝', '嶟', '嶧', '嶫', '嶬', '巇', '巙', '差', '巻', '帝', '帨', '幐',
            '幞', '幣', '幮', '平', '并', '庠', '廉', '廚', '廥', '弊', '弟', '弮', '彅', '彜',
            '彦', '彭', '徉', '従', '恙', '悌', '悦', '悻', '惓', '惘', '愬', '愷', '慈', '慊',
            '慫', '慻', '憋', '憎', '憘', '憠', '懀', '懟', '懩', '懿', '戃', '戠', '戲', '抨',
            '拳', '拼', '挟', '捲', '掽', '揃', '揥', '搒', '搓', '搠', '搤', '摒', '摘', '撅',
            '撇', '撙', '撩', '撲', '擲', '擶', '擿', '攁', '攔', '攩', '敝', '敵', '斁', '斃',
            '斕', '新', '旁', '旘', '晜', '普', '暛', '暟', '暸', '暼', '暿', '曀', '曎', '曛',
            '曦', '曽', '朇', '朔', '朕', '枰', '柬', '栟', '桊', '梪', '梯', '棡', '棬', '椦',
            '椪', '楠', '楢', '業', '楴', '榜', '榺', '榿', '槊', '槎', '様', '樀', '樅', '樣',
            '樴', '樸', '樹', '樽', '橙', '橛', '橧', '橱', '橲', '橳', '檥', '櫈', '櫉', '櫤',
            '欉', '欗', '歉', '歒', '歔', '歖', '歝', '殪', '殬', '氧', '泮', '洋', '涕', '涬',
            '渕', '渞', '渧', '渼', '湅', '湔', '湳', '溓', '溠', '溢', '溯', '溿', '滂', '滋',
            '滏', '滕', '滴', '滹', '滻', '漛', '漾', '潦', '潽', '澄', '澍', '澎', '澧', '澮',
            '濨', '濮', '濹', '瀁', '灃', '灊', '灎', '灔', '為', '烊', '煎', '熹', '熺', '燈',
            '燎', '燧', '燵', '爤', '牂', '牓', '犠', '犧', '狭', '献', '猶', '猷', '獃', '獗',
            '獘', '獯', '瑳', '璒', '璞', '璯', '璲', '瓓', '瓶', '甆', '甑', '産', '畔', '畻',
            '痒', '痘', '瘥', '療', '癢', '癬', '登', '皚', '皷', '益', '盖', '眷', '眹', '着',
            '睇', '睠', '睪', '瞥', '瞪', '瞭', '瞽', '短', '矰', '砰', '碰', '碲', '磁', '磅',
            '磋', '磑', '磳', '磴', '礒', '礠', '祥', '禌', '禘', '禧', '禮', '秚', '秤', '稊',
            '税', '稵', '穙', '穟', '窯', '竒', '竕', '竦', '竴', '箞', '箭', '簦', '籐', '籘',
            '籜', '籣', '粉', '粱', '糍', '糕', '糞', '糦', '糩', '絆', '絣', '綈', '綣', '綱',
            '網', '締', '縊', '縑', '縒', '縢', '縦', '縶', '繒', '繕', '繚', '繥', '繸', '纁',
            '纆', '缾', '罅', '罇', '罔', '罤', '罱', '罾', '羊', '羌', '羍', '美', '羏', '羑',
            '羔', '羖', '羗', '羚', '羜', '羝', '羞', '羡', '羢', '羣', '群', '羦', '羨', '義',
            '羪', '羭', '羮', '羯', '羲', '羴', '羶', '羸', '羹', '羼', '翔', '翦', '聠', '聳',
            '胖', '胼', '脰', '脱', '腩', '膀', '膁', '膨', '膳', '臱', '艏', '艖', '艠', '艤',
            '艶', '艷', '荓', '荳', '菐', '萍', '葥', '蒂', '蒡', '蒴', '蒹', '蓱', '蓻', '蔐',
            '蔽', '蕕', '蕨', '薘', '薩', '薪', '蘀', '蘍', '蘚', '虀', '虁', '虖', '蛻', '蜣',
            '蜷', '蝤', '蝻', '螃', '螆', '螘', '螠', '螣', '蟚', '蟢', '蟻', '蠊', '蠲', '衅',
            '衜', '袢', '裋', '裞', '裷', '褨', '褺', '襆', '襒', '襗', '襚', '襷', '襽', '親',
            '覬', '覴', '觧', '評', '詳', '誉', '説', '誷', '諦', '諵', '諺', '謗', '謙', '謚',
            '謫', '謭', '謼', '譄', '譆', '證', '譜', '議', '譱', '譾', '讁', '讕', '讜', '谿',
            '豆', '豇', '豈', '豉', '豊', '豋', '豌', '豎', '豏', '豐', '豑', '豓', '豔', '豙',
            '豢', '賆', '賸', '贈', '跰', '踡', '蹄', '蹉', '蹢', '蹤', '蹩', '蹬', '蹭', '蹰',
            '蹲', '蹶', '蹼', '躂', '躑', '躕', '躝', '躾', '軆', '輞', '輶', '迸', '送', '逆',
            '逗', '遂', '遃', '遅', '遒', '道', '達', '遖', '遡', '適', '遵', '遼', '邃', '鄧',
            '鄭', '鄯', '鄴', '鄶', '鄷', '酋', '醭', '醳', '醴', '金', '釜', '釟', '釡', '鉛',
            '鉡', '鉼', '銖', '銻', '鋀', '鋭', '鋲', '鋼', '錈', '錬', '鍗', '鎂', '鎈', '鎊',
            '鎌', '鎔', '鎡', '鎧', '鎭', '鎮', '鎰', '鏑', '鏟', '鏷', '鐏', '鐐', '鐙', '鐡',
            '鐮', '鐽', '鑭', '鑿', '钄', '関', '閲', '闓', '闕', '闘', '闦', '隊', '隑', '隘',
            '隥', '隧', '靊', '靽', '韃', '韊', '頖', '頬', '頭', '顗', '餅', '養', '餖', '餻',
            '饈', '饍', '饎', '饐', '首', '馗', '馘', '馦', '駢', '駾', '騰', '骿', '髈', '體',
            '鬀', '鬈', '鬋', '鬙', '鬠', '鬪', '鬳', '鬴', '鬵', '鬷', '鬹', '鬺', '魍', '鮃',
            '鮝', '鮩', '鮮', '鮷', '鯗', '鰊', '鰜', '鰦', '鰧', '鱃', '鱉', '鱒', '鱔', '鱖',
            '鱚', '鱛', '鱶', '鵜', '鵥', '鶫', '鶼', '鶿', '鷁', '鷊', '鷧', '鷩', '鷯', '鹺',
            '鹻', '黕', '黟', '黤', '黧', '黬', '黭', '黮', '黰', '黱', '黲', '黵', '黸', '黹',
            '黻', '黼', '鼓', '鼔', '鼖', '鼗', '鼙', '鼚', '鼛', '鼟', '龞',
        ],
    },
    Membership {
        radical: '亠',
        strokes: 2,
        kanji: &[
            '之', '乏', '亠', '亡', '亢', '交', '亥', '亦', '亨', '享', '京', '亭', '亮', '亯',
            '亰', '亳', '亶', '亹', '伉', '佼', '侅', '依', '侠', '俲', '俵', '俼', '倅', '倖',
            '倞', '倩', '偐', '停', '傍', '傐', '傚', '傲', '債', '僦', '僭', '儃', '儕', '儬',
            '儴', '充', '兗', '兤', '六', '円', '冥', '凉', '凕', '凛', '凜', '刻', '剠', '割',
            '剷', '劑', '劥', '効', '劾', '勍', '勣', '勶', '勷', '匟', '匱', '卒', '卞', '吂',
            '吭', '呟', '味', '咬', '咳', '哀', '哼', '商', '啇', '啍', '啐', '啻', '啼', '喇',
            '喨', '喪', '喫', '喭', '嗃', '嘖', '噋', '噺', '嚆', '嚌', '嚢', '嚷', '囃', '囓',
            '囥', '圉', '圊', '坑', '垓', '埣', '執', '堉', '報', '塙', '塾', '墩', '壅', '壇',
            '壈', '壊', '壌', '壕', '壞', '壤', '変', '夜', '夣', '契', '奒', '奕', '妄', '妹',
            '姉', '姟', '姣', '婧', '婷', '嫡', '嬗', '嬝', '嬢', '嬴', '孃', '孩', '孰', '宍',
            '害', '就', '峡', '崒', '崹', '嵃', '嵜', '嵩', '嵪', '嵭', '巐', '市', '帝', '帟',
            '幎', '幜', '幸', '廓', '廩', '弃', '弈', '弦', '弯', '弴', '弶', '彗', '彦', '影',
            '徬', '徹', '忘', '忙', '忭', '忼', '恋', '恔', '恾', '悥', '悴', '情', '惇', '惊',
            '愫', '慉', '慱', '憝', '憬', '憲', '懌', '懍', '懐', '懷', '戠', '扆', '抃', '抗',
            '抜', '抹', '拄', '挍', '挟', '捽', '掖', '掠', '揥', '搐', '搒', '搞', '摔', '摘',
            '摛', '撤', '撩', '撻', '擁', '擅', '擇', '擒', '擠', '擿', '攅', '攘', '效', '敐',
            '敖', '敦', '敲', '敵', '新', '旁', '旈', '旒', '旘', '旹', '昡', '昧', '晬', '景',
            '晴', '晾', '暀', '暝', '暠', '暸', '暻', '暾', '曟', '曩', '替', '朜', '未', '末',
            '来', '杭', '柬', '柿', '校', '核', '梈', '梳', '梼', '棄', '棈', '棗', '棘', '棭',
            '椁', '椉', '椊', '椋', '楔', '楝', '楴', '榜', '榠', '榱', '槁', '槨', '樀', '樴',
            '檀', '檁', '檎', '櫰', '欬', '歊', '歒', '毃', '毅', '毒', '毓', '毫', '毬', '氈',
            '氦', '汒', '汴', '沆', '沛', '沫', '泛', '泫', '洨', '流', '涛', '液', '涼', '淬',
            '淯', '淳', '清', '渟', '渧', '湻', '湾', '溟', '滀', '滂', '滈', '滴', '滻', '滾',
            '漓', '漘', '漬', '潔', '潡', '潦', '澈', '澋', '澟', '澤', '澶', '濟', '濠', '瀞',
            '瀼', '灕', '灘', '灝', '炕', '炫', '炷', '烹', '焞', '焠', '熇', '熟', '燉', '燎',
            '燵', '爽', '牓', '牨', '牽', '犉', '犒', '狡', '狭', '猄', '猜', '猝', '猽', '玄',
            '玅', '玆', '率', '玹', '珓', '琉', '璃', '璟', '璮', '璻', '瓌', '瓤', '甎', '甕',
            '産', '甿', '畆', '畒', '畗', '畜', '畝', '畡', '畩', '疏', '痃', '痎', '瘁', '癕',
            '癪', '皎', '皜', '皽', '盲', '眩', '睛', '睟', '睾', '瞎', '瞑', '瞮', '硫', '碎',
            '碲', '碻', '磅', '磚', '磧', '祷', '禀', '禊', '禘', '禳', '离', '禽', '秔', '秣',
            '稕', '稟', '稡', '稸', '稾', '稿', '積', '穠', '穣', '穥', '穧', '穰', '窔', '窣',
            '竒', '笇', '箐', '篙', '簀', '簑', '簔', '籍', '籝', '籬', '粇', '粹', '精', '素',
            '絃', '絞', '統', '綂', '綧', '綪', '綷', '締', '縗', '縞', '縭', '績', '繚', '繹',
            '纉', '纐', '纕', '纛', '罔', '羶', '翠', '翯', '聤', '肓', '育', '肺', '胘', '胲',
            '胶', '脤', '脺', '腋', '膀', '膂', '膏', '膵', '膻', '臃', '臎', '臝', '航', '舷',
            '芒', '芝', '芾', '茉', '茭', '茱', '茺', '荄', '莀', '莱', '菁', '萃', '葶', '蒂',
            '蒡', '蒨', '蒿', '蓂', '蓄', '蓑', '蔐', '蔬', '蔳', '蕹', '薧', '薩', '薪', '薺',
            '藁', '藇', '藳', '蘘', '蘛', '蘺', '虀', '虠', '虻', '蚿', '蛟', '蛮', '蜟', '蜻',
            '蝱', '螃', '螟', '螭', '蟀', '蟄', '蟺', '蠃', '蠐', '蠔', '蠰', '衁', '衒', '衣',
            '表', '衰', '衾', '袈', '袋', '袞', '袠', '袤', '袨', '袰', '裁', '裂', '装', '裊',
            '裏', '裒', '裔', '裘', '裛', '裝', '裟', '裱', '裳', '裴', '裵', '裹', '製', '褎',
            '褏', '褒', '褜', '褧', '褰', '褱', '褵', '褺', '褻', '襃', '襄', '襛', '襞', '襢',
            '襲', '親', '詃', '該', '誶', '誷', '諄', '請', '諒', '諦', '諺', '謊', '謗', '謞',
            '謫', '譈', '譯', '譲', '譹', '讁', '讃', '讓', '豁', '豙', '豪', '責', '貶', '賅',
            '賋', '賛', '贄', '跡', '跤', '蹄', '蹟', '蹢', '蹴', '躋', '較', '輞', '輬', '轄',
            '轍', '轝', '迒', '迹', '逑', '逳', '逹', '遃', '適', '邅', '邙', '郊', '郭', '鄍',
            '鄐', '鄗', '醇', '醉', '醕', '醡', '醨', '醯', '醸', '釀', '釋', '釯', '鈰', '鉉',
            '鉸', '銃', '銥', '鋠', '鋳', '錆', '錞', '錥', '鍄', '鍗', '鎊', '鎏', '鎒', '鎬',
            '鏑', '鏟', '鐐', '鐓', '鐸', '鑲', '閌', '閙', '閡', '闥', '阬', '陔', '隮', '雍',
            '雜', '離', '難', '霈', '霽', '青', '靕', '靖', '靗', '靘', '静', '靚', '靛', '靜',
            '靺', '鞟', '鞹', '韲', '頏', '頦', '顇', '顔', '顥', '顫', '飳', '餃', '饔', '饘',
            '饟', '駭', '駮', '驛', '驤', '驪', '骯', '骸', '骹', '髈', '高', '髛', '髜', '髞',
            '鬧', '魅', '魑', '鮫', '鯖', '鯨', '鰲', '鱣', '鱮', '鵁', '鵺', '鶉', '鶮', '鷙',
            '鷯', '鷲', '鸇', '麎', '麖', '麦', '麸', '麹', '麺', '黐', '黥', '鼇', '鼱', '齊',
            '齎', '齏', '齧', '齩',
        ],
    },
    Membership {
        radical: '冂',
        strokes: 2,
        kanji: &[
            '丙', '両', '两', '亂', '亹', '伂', '佈', '侖', '侗', '倆', '倎', '倘', '倜', '偁',
            '偂', '偊', '偏', '偑', '偙', '偶', '傐', '僀', '僑', '僘', '儞', '儷', '兩', '冂',
            '冃', '冄', '内', '円', '冉', '冊', '冋', '册', '再', '冎', '冏', '冐', '冑', '冓',
            '冕', '凋', '凧', '凸', '刪', '刺', '剛', '剮', '劀', '勖', '勪', '勱', '匾', '南',
            '厰', '厲', '同', '向', '吶', '周', '咼', '响', '啁', '商', '啇', '喁', '喃', '喎',
            '喘', '喚', '喬', '嗃', '嗗', '嗣', '噢', '嚆', '嚮', '囐', '囘', '圇', '圊', '圑',
            '坍', '坰', '垌', '垧', '埽', '堈', '堝', '塍', '塙', '墁', '墺', '壐', '夐', '奐',
            '奝', '奟', '奥', '奧', '姍', '婻', '婾', '媢', '媧', '媵', '媻', '媾', '嫡', '嫮',
            '嬌', '嬭', '孋', '孺', '寓', '寘', '尚', '屩', '岡', '峒', '峝', '崗', '崹', '嵩',
            '嵪', '嶠', '嶴', '巋', '巐', '巘', '巾', '帀', '帇', '帍', '帒', '帔', '帕', '帘',
            '帟', '帠', '帨', '帮', '帲', '帵', '帾', '幉', '幋', '幐', '幑', '幖', '幘', '幛',
            '幜', '幞', '幣', '幤', '幨', '幪', '幫', '幬', '幭', '幮', '幰', '庽', '廠', '弊',
            '彌', '彤', '彫', '彲', '徜', '徧', '怏', '恫', '悑', '悕', '惆', '惘', '惝', '惼',
            '愌', '愚', '慲', '慵', '慸', '憋', '憍', '懊', '懣', '懯', '扁', '扃', '扄', '抐',
            '抦', '掄', '掚', '換', '揥', '搆', '搞', '搰', '摘', '摛', '撇', '撟', '撾', '擿',
            '攜', '攦', '敇', '敝', '敞', '敲', '敵', '敽', '斃', '斒', '旃', '昞', '晌', '晑',
            '暎', '暠', '暼', '曬', '朙', '朿', '杮', '枏', '枘', '柄', '柵', '柿', '栴', '桐',
            '棗', '棘', '棡', '椆', '楠', '槁', '槅', '構', '槗', '樀', '樠', '橋', '橘', '檎',
            '檛', '檰', '櫔', '櫤', '欐', '歊', '歒', '殃', '殢', '毃', '毷', '氄', '氅', '汭',
            '泂', '泱', '洓', '洞', '淌', '淛', '渙', '渢', '渦', '渧', '湳', '満', '溝', '溮',
            '滈', '滑', '滴', '滽', '滿', '漰', '潏', '澚', '澳', '濅', '濔', '瀰', '瀹', '灊',
            '灑', '灕', '炯', '炳', '烔', '烱', '焫', '煥', '熇', '燠', '爚', '爨', '爯', '爾',
            '牅', '牏', '犒', '猘', '猧', '献', '猵', '猾', '獘', '獝', '獮', '獻', '獼', '珊',
            '珦', '琱', '瑀', '瑁', '瑍', '璚', '璽', '瓊', '瓛', '瓻', '甗', '甩', '病', '痌',
            '瘓', '瘸', '癟', '皜', '眮', '睎', '瞞', '瞥', '矞', '矪', '矯', '碲', '碻', '磆',
            '礇', '禍', '禑', '禘', '禫', '禰', '禴', '禸', '禹', '禺', '离', '禽', '秧', '秱',
            '稠', '稱', '稾', '稿', '穪', '窩', '窬', '竇', '竊', '竬', '笧', '筒', '策', '箆',
            '箐', '篇', '篙', '篝', '簓', '簥', '籭', '籲', '粡', '糄', '納', '絅', '絧', '絺',
            '綗', '綢', '綱', '網', '編', '緺', '縞', '縭', '繘', '繭', '纚', '网', '罓', '罔',
            '罱', '羀', '翮', '翯', '耦', '耼', '肉', '肦', '肭', '胔', '胴', '胾', '脧', '脼',
            '腆', '腡', '腩', '膈', '膐', '臋', '臡', '興', '舡', '舢', '舨', '舲', '舴', '舺',
            '艃', '艄', '艅', '艆', '艋', '艎', '艏', '艑', '艖', '艜', '艠', '艣', '艧', '艭',
            '芇', '芮', '芾', '苒', '苚', '苪', '茼', '莿', '萬', '萵', '萹', '蒒', '蒪', '蒯',
            '蒿', '蓇', '蔐', '蔽', '蕀', '蕎', '薁', '薓', '薾', '藁', '藊', '藳', '蘺', '蚋',
            '蚦', '蛃', '蛧', '蜩', '蜹', '蜽', '蝸', '蝻', '螄', '螌', '融', '螣', '螭', '螮',
            '蟎', '蟜', '蠆', '蠒', '蠵', '衕', '衲', '衻', '裔', '裯', '裲', '褠', '褵', '襒',
            '襖', '襺', '覯', '覶', '覼', '觿', '訥', '詗', '詷', '誷', '調', '諵', '講', '謞',
            '謫', '譎', '譾', '讁', '讏', '讞', '豨', '賙', '賵', '購', '趟', '趫', '跚', '踽',
            '蹁', '蹛', '蹢', '蹣', '蹩', '蹻', '躉', '躛', '躧', '躺', '軜', '輈', '輌', '輖',
            '輛', '輞', '轎', '辭', '迊', '迥', '迵', '逈', '週', '遇', '遍', '過', '遖', '遘',
            '適', '遰', '遹', '邇', '邐', '邴', '郗', '鄅', '鄗', '鄘', '酈', '醨', '醰', '釁',
            '釃', '鈉', '鈰', '鈵', '銅', '銟', '鋼', '鋿', '錀', '鍋', '鍗', '鍽', '鎘', '鎫',
            '鎬', '鏋', '鏑', '鏞', '鐈', '鐍', '鑈', '鑮', '鑰', '镾', '闒', '陋', '隃', '隅',
            '隔', '隩', '雋', '雕', '雘', '雟', '霙', '霱', '靕', '靹', '鞅', '鞆', '鞲', '鞶',
            '韝', '韴', '顒', '顢', '颫', '颭', '颮', '颰', '颴', '颷', '颸', '颺', '颻', '颿',
            '飂', '飅', '飈', '飌', '餇', '餉', '駉', '駧', '騙', '騧', '驕', '驪', '骨', '骪',
            '骬', '骭', '骮', '骯', '骰', '骲', '骴', '骵', '骶', '骸', '骹', '骻', '骼', '骾',
            '骿', '髀', '髁', '髃', '髆', '髈', '髎', '髏', '髐', '髑', '髒', '髓', '體', '髕',
            '髖', '髗', '高', '髛', '髜', '髞', '髥', '髯', '鬋', '鬲', '鬳', '鬴', '鬵', '鬷',
            '鬹', '鬺', '鬻', '魍', '魎', '魳', '鮦', '鯛', '鯯', '鯿', '鰤', '鰧', '鱅', '鱉',
            '鱊', '鱎', '鱏', '鵃', '鵩', '鵰', '鶄', '鶮', '鶻', '鷊', '鷩', '鷮', '鷸', '鸙',
            '鸝', '麗', '黹', '黻', '黼', '鼈', '齲', '齵', '龞', '龡', '龢', '龣', '龥',
        ],
    },
    Membership {
        radical: '儿',
        strokes: 2,
        kanji: &[
            '亮', '价', '佻', '侁', '侊', '侻', '俊', '俒', '俛', '俿', '倥', '倪', '傀', '傹',
            '僔', '僥', '儋', '儍', '儭', '儳', '儹', '儿', '兀', '允', '元', '兄', '充', '兆',
            '兇', '先', '光', '兊', '克', '兌', '免', '兎', '兏', '児', '兒', '兔', '兕', '兗',
            '兘', '党', '兜', '兟', '兢', '兤', '冏', '冕', '冠', '冤', '冦', '况', '冼', '凂',
            '凌', '刓', '剋', '劖', '劗', '劘', '勀', '勉', '勘', '勢', '匵', '匹', '厩', '吮',
            '呪', '咷', '哯', '哾', '唆', '唍', '唲', '商', '啌', '喚', '喨', '嘵', '嚫', '囈',
            '囋', '囐', '四', '园', '圀', '圥', '坴', '垗', '垙', '垸', '埈', '埶', '堄', '堍',
            '堪', '堯', '堺', '塊', '境', '墝', '売', '夋', '夌', '夔', '奐', '妧', '姚', '姯',
            '娧', '娩', '媺', '媿', '嬈', '完', '宨', '宺', '宼', '寃', '寇', '寴', '尅', '尠',
            '尣', '尦', '尩', '尫', '尭', '屼', '岏', '岲', '峴', '峻', '崆', '崚', '崧', '嵬',
            '嶢', '巉', '巍', '巘', '帘', '帨', '帶', '幌', '幨', '廃', '廆', '廛', '弈', '彪',
            '忨', '忱', '怳', '恌', '恍', '恱', '悓', '悗', '悛', '悦', '悾', '愖', '愧', '愰',
            '憺', '戡', '扤', '抏', '挄', '挑', '挖', '挩', '挽', '探', '控', '揕', '換', '揬',
            '搾', '撓', '撥', '擔', '攙', '攛', '攜', '攢', '斟', '旐', '晀', '晁', '晃', '晄',
            '晙', '晛', '晩', '暁', '曉', '朓', '朙', '朮', '杌', '杬', '柶', '柷', '桃', '桄',
            '梘', '梚', '梡', '梭', '梲', '棱', '椌', '椶', '椹', '榥', '榨', '槅', '槐', '橈',
            '橘', '檐', '櫆', '櫝', '櫬', '欃', '欑', '殰', '殼', '毚', '氄', '沅', '沇', '況',
            '泗', '洗', '洮', '洸', '浣', '浼', '涗', '涜', '淕', '淩', '深', '渙', '湛', '溌',
            '滉', '滯', '澆', '澹', '濳', '瀆', '瀍', '灊', '灮', '烑', '烱', '焌', '焼', '煥',
            '熀', '熱', '燒', '爇', '牘', '犢', '狁', '狻', '猇', '猊', '獍', '獟', '獻', '玩',
            '珖', '珧', '琛', '琥', '瑍', '瑰', '瓚', '瓛', '甗', '甚', '界', '畯', '痠', '痲',
            '瘓', '瘣', '癈', '発', '皃', '皖', '皝', '皢', '皴', '盶', '眺', '睆', '睍', '睦',
            '睨', '瞻', '瞾', '矞', '硄', '碪', '磈', '磡', '磽', '祝', '祧', '禝', '禿', '税',
            '稑', '稜', '稷', '穴', '穵', '究', '穸', '穹', '空', '穽', '穿', '窀', '突', '窂',
            '窃', '窄', '窅', '窆', '窈', '窊', '窐', '窒', '窓', '窔', '窕', '窖', '窗', '窘',
            '窟', '窠', '窣', '窪', '窬', '窮', '窯', '窰', '窳', '窵', '窶', '窹', '窺', '窻',
            '窼', '窿', '竃', '竄', '竅', '竆', '竇', '竈', '竊', '竟', '竣', '競', '竸', '筅',
            '筦', '箜', '箲', '篪', '篼', '簆', '簷', '籞', '籩', '糂', '糉', '絖', '統', '絸',
            '絻', '綂', '綗', '続', '綾', '緵', '縨', '繞', '續', '纏', '纔', '纘', '罕', '羌',
            '羦', '翫', '翮', '翹', '耀', '聭', '胤', '胱', '脘', '脱', '腔', '膈', '膣', '膮',
            '膽', '臗', '舚', '芥', '芫', '茺', '莔', '莞', '莧', '莬', '莵', '菟', '菱', '葚',
            '葰', '葼', '蒄', '蒐', '蓺', '蔆', '蔕', '蔲', '蕘', '薐', '薝', '藐', '藝', '藭',
            '蘶', '虁', '虎', '虒', '虓', '號', '虢', '虣', '虺', '蚖', '蛻', '蜣', '蜺', '融',
            '蟯', '蟾', '裔', '裞', '褫', '褹', '襜', '襼', '見', '覍', '覐', '覔', '覕', '覛',
            '覜', '覟', '覠', '覥', '覰', '覴', '覵', '覶', '覷', '覼', '覿', '觥', '觿', '訵',
            '詵', '詹', '誂', '説', '読', '諶', '謖', '譎', '譫', '讀', '讒', '讚', '讞', '豗',
            '貌', '貎', '貺', '贊', '贍', '贖', '趬', '趲', '跣', '跳', '踆', '蹏', '蹺', '躔',
            '躻', '軏', '輐', '輓', '輗', '輘', '輝', '逃', '逡', '逵', '逸', '遞', '遶', '遹',
            '邃', '邈', '邉', '邊', '鄽', '酇', '酛', '酸', '醗', '醜', '鈨', '銃', '銑', '銚',
            '銧', '鋎', '鋧', '鋭', '錂', '鍖', '鎘', '鎤', '鏡', '鐃', '鐍', '鑁', '鑚', '鑽',
            '閲', '闚', '阢', '阮', '院', '陵', '陸', '隔', '隗', '霓', '霱', '靗', '靚', '鞉',
            '鞚', '韑', '頏', '頑', '頫', '餕', '餽', '饒', '饕', '駟', '駪', '駫', '駾', '駿',
            '騣', '驍', '髐', '髖', '鬉', '鬩', '鬲', '鬳', '鬴', '鬵', '鬷', '鬹', '鬺', '鬻',
            '鬼', '鬽', '魁', '魂', '魃', '魄', '魅', '魈', '魋', '魌', '魍', '魎', '魏', '魑',
            '魔', '魕', '魖', '魗', '魘', '魭', '鮸', '鮻', '鯇', '鯢', '鯥', '鯪', '鯱', '鱊',
            '鴪', '鵼', '鶃', '鷉', '鷸', '麑', '黋', '黮', '黷', '黿', '鼗', '鼿', '齯',
        ],
    },
    Membership {
        radical: '勹',
        strokes: 2,
        kanji: &[
            '丂', '与', '丒', '亀', '争', '仢', '佝', '佹', '佽', '侉', '侚', '侷', '俛', '俜',
            '俽', '偈', '偒', '偽', '傯', '傷', '僃', '像', '儆', '儋', '儳', '免', '兔', '冕',
            '写', '冤', '冩', '凂', '刎', '別', '刨', '刳', '劂', '劅', '劖', '劚', '劬', '勉',
            '勨', '勹', '勺', '勾', '勿', '匀', '匁', '匂', '匃', '包', '匆', '匈', '匊', '匋',
            '匌', '匍', '匏', '匐', '匑', '匓', '匛', '匫', '危', '卾', '厃', '句', '号', '吻',
            '呴', '咆', '咢', '啗', '喚', '喝', '喣', '喲', '噡', '噣', '嚟', '囑', '囫', '圬',
            '圴', '圽', '均', '垉', '垝', '埩', '埸', '堍', '夐', '夸', '奐', '妁', '妳', '姁',
            '姱', '娉', '娩', '婅', '嫮', '宐', '寃', '寏', '寫', '尦', '屬', '岣', '峋', '峗',
            '崁', '崿', '嵑', '嶔', '嶰', '巉', '巧', '幨', '庖', '廌', '廞', '彴', '徇', '忺',
            '忽', '怐', '急', '怱', '恂', '恑', '恗', '恟', '悗', '您', '惂', '惕', '惞', '惸',
            '愌', '愒', '愓', '愕', '愡', '慯', '憠', '憺', '憼', '扚', '抱', '拘', '挽', '捌',
            '捔', '掏', '掐', '掦', '掬', '掲', '揈', '揔', '換', '搊', '摴', '撅', '撳', '擉',
            '擎', '擔', '攙', '敬', '斣', '旬', '昀', '昒', '易', '昜', '昫', '晩', '晹', '暍',
            '暘', '曔', '曷', '朅', '朽', '杇', '杓', '杴', '构', '枵', '枸', '枹', '栨', '栬',
            '栲', '桅', '桍', '梚', '椈', '楤', '楬', '樕', '樗', '橛', '橡', '檞', '檠', '櫲',
            '欃', '欠', '欤', '欨', '欫', '欬', '欯', '欵', '欶', '欻', '欿', '歆', '歇', '歊',
            '歍', '歒', '歖', '歘', '歝', '歠', '歾', '歿', '殉', '殤', '毚', '毱', '汋', '汚',
            '沕', '沟', '泡', '洵', '洶', '洿', '浄', '浼', '淊', '淘', '淴', '渇', '渹', '潒',
            '潟', '澚', '澥', '濁', '瀉', '灔', '灼', '炮', '炰', '為', '烤', '焔', '焰', '煞',
            '煦', '煬', '燄', '燙', '燭', '爓', '牎', '物', '犓', '狗', '狥', '猲', '獦', '獨',
            '獬', '玓', '玽', '珣', '琤', '瑍', '瑒', '瓈', '瓟', '甸', '甹', '畃', '畇', '畼',
            '疱', '痀', '痬', '瘍', '瘓', '瘹', '的', '皰', '皺', '盪', '盻', '眗', '眴', '睗',
            '瞻', '矚', '矦', '砍', '砲', '确', '碣', '碭', '磶', '礿', '祹', '禓', '穐', '窞',
            '竃', '竫', '竭', '笏', '笣', '笱', '筍', '筝', '筠', '箰', '簌', '粤', '粷', '約',
            '絇', '絝', '絢', '絻', '綯', '緆', '緫', '縄', '縐', '纔', '缼', '羡', '羯', '考',
            '耇', '耈', '聘', '聦', '肹', '胞', '胯', '胸', '脃', '脆', '脗', '腭', '膽', '臅',
            '臈', '臲', '臽', '舓', '舚', '色', '艴', '艶', '芍', '芡', '芴', '芻', '苞', '苟',
            '荀', '荂', '莬', '菊', '菟', '萄', '萏', '萢', '萯', '萼', '葛', '葡', '葪', '葯',
            '蒟', '蒭', '蔌', '蔔', '蔫', '蕚', '蕝', '薋', '薝', '薢', '薥', '藜', '藹', '蘅',
            '蘒', '蘯', '虝', '號', '虧', '蚫', '蜀', '蜔', '蜴', '蝎', '蝪', '蝿', '蟕', '蠋',
            '蠍', '蠲', '衡', '袀', '袍', '袴', '裼', '褐', '褜', '襜', '襡', '襰', '角', '觔',
            '觕', '觖', '觗', '觘', '觥', '觩', '觫', '觭', '觱', '觳', '觴', '觶', '觸', '觹',
            '觽', '觿', '訇', '訽', '詢', '詭', '詹', '詾', '誇', '諊', '諡', '諤', '謁', '謅',
            '警', '譫', '讒', '象', '豫', '豹', '負', '賯', '赥', '赩', '趂', '趑', '趦', '趨',
            '趵', '跑', '跔', '跨', '跪', '踢', '躅', '輓', '輡', '輵', '輷', '轕', '逷', '逸',
            '逿', '遌', '遏', '遬', '邌', '郇', '鄒', '鄠', '鄢', '酌', '釣', '鈎', '鈞', '鉋',
            '鉤', '鉨', '銙', '銫', '鋆', '鍔', '鍚', '鍧', '鍯', '鏉', '鐲', '鑱', '钃', '閻',
            '陒', '陥', '陶', '陷', '雊', '雛', '雩', '雹', '靄', '静', '靤', '靮', '鞄', '鞠',
            '鞨', '鞫', '韉', '韵', '頠', '顎', '颮', '颺', '飽', '餈', '餲', '餳', '饞', '馰',
            '駒', '騁', '騶', '驚', '骲', '骻', '髑', '髱', '鬄', '鬮', '鬺', '魡', '鮑', '鮬',
            '鮸', '鯣', '鰐', '鰑', '鱖', '鴝', '鴞', '鶍', '鶚', '鶡', '鶵', '麁', '麅', '麭',
            '麴', '麹', '黧', '黵', '齁', '齃', '齣', '齶', '齺', '龜', '龝', '龞', '龡',
        ],
    },
    Membership {
        radical: '⺅',
        strokes: 2,
        kanji: &[
            '什', '仁', '仂', '仃', '仆', '仇', '仍', '仏', '仔', '仕', '他', '仗', '付', '仙',
            '仛', '仞', '仟', '仠', '仡', '仢', '代', '仨', '仭', '仮', '仯', '仰', '仱', '仲',
            '仳', '仵', '件', '价', '任', '份', '仾', '仿', '伀', '伂', '伃', '伈', '伉', '伊',
            '伋', '伌', '伍', '伎', '伏', '伐', '休', '伒', '伕', '伖', '伙', '伜', '伝', '伮',
            '伯', '估', '伱', '伳', '伴', '伵', '伶', '伷', '伸', '伹', '伺', '伻', '似', '伽',
            '伾', '佀', '佂', '佃', '但', '佇', '佈', '佉', '佋', '佌', '位', '低', '住', '佐',
            '佑', '佒', '体', '佔', '何', '佖', '佗', '佚', '佛', '作', '佝', '佞', '佟', '你',
            '佣', '佩', '佪', '佬', '佮', '佯', '佰', '佳', '併', '佶', '佷', '佸', '佹', '佺',
            '佻', '佼', '佽', '佾', '使', '侁', '侂', '侃', '侄', '侅', '侈', '侉', '侊', '例',
            '侍', '侎', '侏', '侐', '侑', '侒', '侓', '侔', '侗', '侘', '侙', '侚', '供', '依',
            '侞', '侟', '侠', '価', '侫', '侭', '侮', '侯', '侲', '侵', '侶', '侷', '侹', '侻',
            '侼', '侽', '侾', '便', '俀', '俁', '係', '促', '俄', '俅', '俆', '俈', '俉', '俊',
            '俋', '俌', '俍', '俏', '俐', '俑', '俒', '俔', '俗', '俘', '俚', '俛', '俜', '保',
            '俟', '俠', '信', '俢', '俣', '俤', '俥', '修', '俯', '俰', '俲', '俳', '俵', '俶',
            '俸', '俺', '俼', '俽', '俾', '俿', '倀', '倁', '倄', '倅', '倆', '倇', '倊', '個',
            '倌', '倍', '倎', '倏', '倐', '們', '倒', '倓', '倔', '倖', '倗', '倘', '候', '倚',
            '倛', '倜', '倞', '借', '倡', '倢', '倣', '値', '倥', '倦', '倧', '倨', '倩', '倪',
            '倫', '倬', '倭', '倮', '倰', '倲', '倳', '倵', '倶', '倹', '倻', '偀', '偁', '偂',
            '偃', '偅', '偆', '假', '偈', '偉', '偊', '偌', '偎', '偏', '偐', '偑', '偒', '偓',
            '偕', '偖', '偗', '偙', '做', '停', '偟', '偠', '偢', '偣', '健', '偦', '偧', '偪',
            '偬', '偭', '偰', '偱', '偲', '側', '偵', '偶', '偸', '偽', '傀', '傁', '傃', '傄',
            '傅', '傆', '傊', '傍', '傎', '傏', '傐', '傑', '傒', '傓', '傔', '傖', '備', '傚',
            '傛', '傜', '傞', '傟', '傠', '傡', '傢', '傪', '催', '傭', '傯', '傰', '傲', '傳',
            '傴', '債', '傷', '傹', '傺', '傽', '傾', '僀', '僂', '僃', '僄', '僅', '僇', '僊',
            '僌', '働', '僎', '像', '僐', '僑', '僓', '僔', '僕', '僖', '僘', '僚', '僜', '僝',
            '僞', '僟', '僢', '僣', '僤', '僥', '僦', '僧', '僨', '僩', '僭', '僮', '僯', '僱',
            '僲', '僵', '僶', '價', '僺', '僻', '僾', '儀', '儁', '儂', '儃', '億', '儆', '儇',
            '儈', '儉', '儋', '儌', '儍', '儎', '儒', '儔', '儕', '儖', '儗', '儘', '儙', '儚',
            '儛', '儜', '儝', '儞', '償', '儡', '儣', '儧', '儨', '優', '儬', '儭', '儯', '儱',
            '儲', '儳', '儴', '儵', '儷', '儸', '儹', '儺', '儻', '儼', '凭', '化', '吪', '咃',
            '咐', '咻', '咿', '哬', '喉', '囮', '坿', '垈', '垡', '埖', '堠', '堡', '夜', '姙',
            '娰', '媬', '宱', '宿', '岱', '帒', '府', '庥', '弣', '怤', '恁', '恷', '悠', '您',
            '憊', '應', '拊', '捬', '掖', '攉', '敒', '柎', '栰', '栿', '條', '梻', '棭', '椛',
            '椨', '楩', '樤', '洑', '浟', '涖', '液', '滌', '滫', '濮', '炛', '烋', '牮', '猴',
            '玳', '瘊', '眾', '睺', '硴', '祔', '符', '笩', '筏', '筰', '筱', '箯', '篌', '篠',
            '糀', '糇', '絍', '絛', '絥', '緥', '緱', '緶', '縧', '縮', '縱', '翛', '胕', '脩',
            '腋', '腐', '腑', '膺', '花', '芿', '苻', '茯', '茷', '茽', '荏', '荷', '莅', '莜',
            '葆', '葠', '葰', '蒞', '蒨', '蓓', '蓚', '蓧', '蓿', '蚹', '蛜', '袋', '袱', '袵',
            '褒', '褓', '訛', '誮', '譍', '貅', '貨', '貸', '賃', '賲', '贋', '贗', '跗', '蹜',
            '軅', '軈', '輦', '鉜', '錵', '鍭', '鎀', '鏅', '鏥', '閥', '附', '雁', '靴', '鞗',
            '鞭', '餱', '駙', '髹', '鮒', '鮲', '鮴', '鯈', '鯸', '鰷', '鴈', '鵂', '鵺', '鷹',
            '黛',
        ],
    },
    Membership {
        radical: '厶',
        strokes: 2,
        kanji: &[
            '丟', '乨', '亂', '云', '亝', '仏', '伀', '会', '伝', '佉', '侄', '侌', '侔', '俊',
            '俟', '俼', '倊', '倒', '偊', '偓', '偶', '傀', '傟', '傪', '傳', '允', '充', '兊',
            '兘', '公', '冶', '刧', '到', '刼', '剸', '劉', '劫', '劺', '勆', '勜', '勱', '勶',
            '勾', '匓', '匥', '却', '厔', '厲', '厶', '厷', '厸', '厺', '去', '厽', '叀', '参',
            '參', '叅', '叝', '台', '吮', '呍', '呿', '咍', '咥', '唆', '唉', '喁', '喔', '嗑',
            '嘅', '嚠', '囀', '囈', '囜', '團', '坮', '垤', '埃', '埈', '堉', '堲', '塊', '塕',
            '塼', '壒', '壜', '夋', '夣', '套', '奙', '始', '姪', '娭', '媿', '嫏', '嫥', '宏',
            '宖', '室', '寓', '寙', '專', '屋', '峅', '峻', '崧', '嵡', '嵬', '嵾', '巍', '幄',
            '広', '庢', '庽', '廆', '廕', '弁', '弃', '弆', '弘', '強', '彸', '徹', '忩', '忪',
            '忶', '怠', '怡', '怯', '恈', '恡', '恱', '悛', '惠', '惨', '愚', '愧', '態', '慘',
            '慱', '憓', '懡', '懥', '戩', '払', '抎', '抬', '抾', '拚', '拡', '挃', '挨', '捘',
            '捴', '握', '搢', '摛', '摡', '摶', '摻', '撡', '撤', '擡', '擺', '旈', '旒', '昖',
            '昪', '昿', '晉', '晊', '晙', '曇', '曏', '朅', '朎', '松', '构', '枩', '枱', '枲',
            '桎', '桙', '桧', '梥', '梭', '梳', '棄', '椡', '榁', '榴', '榼', '槐', '槫', '槮',
            '樃', '橒', '檎', '檯', '櫆', '櫔', '欸', '殆', '毓', '毿', '汯', '沇', '沟', '治',
            '泒', '泓', '法', '流', '浚', '浤', '涘', '淞', '淯', '渥', '溘', '溜', '滃', '滲',
            '潓', '澈', '澐', '灋', '灎', '灕', '炱', '焌', '熊', '爝', '牟', '牽', '狁', '狻',
            '玜', '珆', '琉', '琺', '瑀', '瑠', '瑰', '瓜', '瓞', '瓟', '瓤', '瓮', '瓺', '畆',
            '留', '畚', '畯', '疏', '痠', '瘣', '瘤', '癊', '癤', '皭', '皴', '盍', '眙', '眸',
            '瞌', '瞮', '矣', '砝', '砿', '硡', '硫', '磈', '磕', '磚', '礚', '祛', '禑', '禸',
            '离', '禽', '私', '穇', '窊', '窒', '窓', '窳', '竊', '竑', '竢', '竣', '竬', '竱',
            '笞', '笟', '箛', '箼', '篸', '簒', '籀', '籕', '糝', '紘', '紜', '紭', '紿', '絋',
            '絰', '統', '絵', '綋', '総', '緻', '縉', '縭', '縿', '繦', '繧', '罎', '罛', '罷',
            '羆', '羗', '翁', '翃', '翎', '耊', '耋', '耘', '耦', '耺', '耾', '聡', '聭', '肆',
            '肱', '育', '胍', '胎', '胠', '能', '脚', '脧', '腟', '膞', '膣', '至', '致', '臵',
            '臶', '臸', '臹', '臺', '臻', '舝', '舩', '芸', '苔', '苽', '茺', '荎', '莭', '菘',
            '葈', '葰', '蒐', '蓈', '蓊', '蓋', '蓏', '蔇', '蔘', '蔬', '蔭', '蕓', '薌', '薹',
            '藝', '蘛', '蘶', '蘺', '蚣', '蛑', '蛭', '蜐', '蜙', '蜟', '蝍', '螉', '螭', '蟪',
            '蠁', '蠆', '蠞', '袪', '裁', '褦', '褵', '襁', '襂', '襼', '覶', '訟', '詒', '詓',
            '誒', '谹', '豔', '貽', '貿', '跆', '踆', '踋', '踽', '躉', '転', '軱', '輊', '轉',
            '轍', '辝', '运', '迨', '逘', '逡', '逳', '遇', '遛', '邰', '郄', '郅', '郒', '鄅',
            '鄮', '酸', '醘', '醜', '醦', '醨', '醯', '釂', '鈆', '鈎', '鈜', '鈶', '鉱', '鉾',
            '銃', '銍', '鋐', '錥', '鎏', '鎦', '鏄', '鏸', '鏹', '镸', '镹', '镾', '閎', '閞',
            '闔', '阹', '陖', '陰', '隂', '隅', '隗', '雄', '雲', '霤', '靆', '靉', '頌', '顒',
            '颱', '飣', '飥', '飦', '飳', '飴', '飶', '餂', '餇', '餑', '餕', '餖', '餗', '餚',
            '餛', '餜', '餟', '餢', '餦', '餧', '餫', '餱', '餲', '餳', '餴', '餵', '餹', '餺',
            '餻', '餼', '餽', '餾', '饀', '饁', '饆', '饇', '饈', '饍', '饎', '饘', '饙', '饛',
            '饞', '饟', '饠', '駘', '駿', '騃', '騮', '驂', '髃', '髯', '髷', '鬆', '鬖', '鬼',
            '鬽', '魁', '魂', '魃', '魄', '魅', '魈', '魋', '魌', '魍', '魎', '魏', '魑', '魔',
            '魕', '魖', '魗', '魘', '鮐', '鮻', '鯵', '鯽', '鰘', '鰡', '鰪', '鰺', '鱄', '鱜',
            '鴘', '鴾', '鵄', '鵔', '鶲', '鶹', '麮', '麰', '黲', '齝', '齵', '齷',
        ],
    },
    Membership {
        radical: '𠆢',
        strokes: 2,
        kanji: &[
            '个', '今', '介', '仐', '仚', '令', '仱', '价', '企', '众', '会', '伱', '伶', '佘',
            '余', '佮', '佱', '佺', '侌', '侖', '俆', '俗', '倉', '倫', '倹', '偸', '傖', '傘',
            '傛', '傪', '傺', '僇', '僉', '儈', '儉', '全', '兪', '冷', '冾', '凳', '刢', '刼',
            '剣', '剱', '剳', '創', '剹', '劊', '劍', '劒', '劔', '勠', '匌', '匬', '匳', '匼',
            '參', '叅', '叙', '合', '吟', '含', '呤', '命', '哈', '唅', '唫', '唸', '唹', '喩',
            '嗆', '嗒', '嗿', '嘐', '噏', '噞', '噲', '嚟', '囹', '圇', '圿', '坅', '埝', '塔',
            '塕', '塗', '墖', '壑', '壡', '妎', '妗', '姈', '姶', '嫆', '嫪', '容', '寥', '尬',
            '岑', '峇', '峪', '崘', '崙', '嵢', '嵺', '嶮', '嶺', '幹', '庎', '廕', '廖', '廥',
            '弇', '彾', '徐', '念', '怜', '恰', '悆', '愈', '愉', '愹', '慘', '慾', '憀', '憸',
            '懀', '戧', '戮', '拎', '拴', '拾', '拿', '捨', '捻', '掄', '掵', '揄', '揜', '搭',
            '搶', '搽', '搿', '摎', '摻', '撘', '撡', '撿', '擒', '敍', '敘', '斂', '斜', '斡',
            '於', '昑', '昣', '昤', '晗', '會', '朇', '朎', '柃', '栓', '桧', '桼', '梣', '棆',
            '棜', '棯', '棽', '検', '楡', '榕', '榦', '槍', '槮', '樛', '檎', '檜', '檢', '欲',
            '歙', '歛', '殄', '殮', '毹', '毿', '沴', '泠', '洽', '浴', '涂', '涔', '淤', '淪',
            '淰', '渝', '溶', '滁', '滄', '漆', '漻', '潝', '澣', '澪', '澮', '澰', '濬', '瀚',
            '瀲', '瀹', '熔', '爚', '牏', '牷', '狳', '猞', '獪', '獫', '玠', '玪', '玲', '珍',
            '珡', '琀', '琴', '瑜', '瑢', '瑲', '璆', '璯', '璿', '瓈', '瓴', '界', '畍', '畛',
            '畭', '疁', '疥', '疹', '痊', '瘀', '瘉', '瘡', '瘩', '瘳', '癊', '癒', '癟', '盒',
            '盦', '眕', '睂', '睿', '瞼', '矜', '砎', '硲', '磟', '礆', '祄', '祫', '祭', '禴',
            '禽', '秢', '稌', '稔', '穃', '穇', '窬', '竛', '笭', '筌', '答', '箚', '篨', '篸',
            '簳', '簽', '籡', '籥', '籲', '粭', '糝', '糩', '紒', '紾', '給', '絵', '綌', '綸',
            '縿', '繆', '繪', '羚', '羭', '翎', '翏', '翕', '翰', '耠', '耹', '聄', '聆', '胗',
            '腧', '膝', '膠', '膾', '臉', '舍', '舎', '舒', '舖', '舗', '舘', '艅', '艙', '芥',
            '芩', '芲', '苓', '苶', '茶', '荃', '荅', '荼', '莟', '菸', '葊', '蒼', '蓉', '蓼',
            '蔭', '薈', '薋', '薟', '藜', '蘞', '蚧', '蛉', '蛤', '蜍', '蝓', '蟉', '衾', '衿',
            '袗', '袷', '裕', '褕', '襂', '覦', '診', '詅', '詥', '詮', '論', '諗', '諭', '謬',
            '譣', '谷', '谸', '谹', '谺', '谽', '谾', '谿', '豁', '豅', '貐', '貪', '賖', '賿',
            '趁', '趻', '跈', '跧', '踰', '蹌', '蹹', '軨', '軫', '輇', '輪', '輸', '轇', '途',
            '逧', '逾', '邌', '郃', '郤', '鄶', '酓', '酴', '醦', '醪', '醶', '金', '鈐', '鈴',
            '鉩', '鉿', '銓', '鋏', '鋡', '鋭', '錀', '錜', '錵', '鍮', '鎔', '鎗', '鏐', '鏥',
            '鐱', '鑰', '閝', '閤', '閦', '閼', '闟', '除', '陰', '険', '隂', '隃', '險', '隳',
            '零', '鞳', '韐', '領', '頜', '頷', '飂', '飡', '飣', '飥', '飦', '飧', '飪', '飮',
            '飳', '飶', '飼', '餂', '餇', '餈', '餑', '餕', '餖', '餗', '餘', '餚', '餛', '餜',
            '餟', '餢', '餦', '餧', '餫', '餮', '餱', '餲', '餳', '餴', '餵', '餹', '餺', '餻',
            '餼', '饀', '饁', '饆', '饇', '饈', '饎', '饔', '饘', '饙', '饛', '饜', '饞', '饟',
            '饠', '騐', '験', '驂', '驗', '髎', '鬖', '鬠', '魪', '魿', '鯰', '鯲', '鰺', '鱠',
            '鳹', '鴒', '鴿', '鶬', '鷚', '鸙', '鹸', '鹼', '黔', '黭', '黲', '齘', '齝', '齡',
            '齢', '龕', '龠', '龡', '龢', '龣', '龥',
        ],
    },
    Membership {
        radical: '冖',
        strokes: 2,
        kanji: &[
            '亭', '亮', '亳', '亹', '侵', '侼', '偙', '停', '傍', '僀', '僢', '僾', '儋', '儚',
            '儝', '償', '優', '儳', '儻', '党', '冖', '冗', '冘', '写', '冝', '冠', '冡', '冢',
            '冣', '冤', '冥', '冦', '冨', '冩', '冪', '凕', '労', '勃', '勞', '受', '叠', '叡',
            '啻', '啼', '喗', '喨', '営', '嗗', '嘗', '噎', '噯', '嚅', '嚏', '嚔', '嚢', '嚳',
            '囊', '埽', '堂', '塋', '塚', '壑', '壕', '壖', '壡', '壩', '壱', '売', '壳', '壷',
            '壹', '壺', '壼', '夢', '夣', '央', '婦', '婷', '嫈', '嬡', '孁', '孛', '学', '學',
            '寖', '寝', '寢', '崹', '嵤', '嵭', '嶸', '巋', '帚', '帝', '帯', '帰', '帶', '常',
            '幎', '幪', '彀', '彙', '徬', '忱', '怏', '悖', '您', '惲', '愂', '愛', '愨', '慶',
            '慸', '憂', '憥', '懜', '懞', '懥', '懿', '戃', '戞', '掃', '授', '掌', '探', '揥',
            '揮', '搉', '搒', '搰', '摚', '摴', '撈', '撐', '撑', '撹', '擋', '擡', '擩', '擾',
            '攉', '攩', '攮', '斅', '斝', '旁', '映', '暈', '暉', '暎', '暝', '曀', '曖', '曚',
            '朦', '枕', '栄', '桲', '棠', '楎', '楴', '榖', '榜', '榠', '榮', '榷', '榾', '槖',
            '樰', '橐', '橒', '橕', '橖', '檑', '檬', '檯', '檽', '檾', '櫌', '櫜', '欛', '欞',
            '歸', '殃', '殢', '殪', '殻', '殼', '毫', '沈', '沉', '泱', '浡', '浸', '涜', '深',
            '渟', '渤', '渧', '渾', '溟', '滂', '滎', '滑', '滞', '滯', '澇', '澐', '濅', '濚',
            '濛', '濠', '濬', '瀀', '瀅', '瀠', '瀯', '灞', '焭', '煇', '煢', '熒', '營', '燸',
            '爨', '牓', '牚', '牽', '犖', '猽', '猾', '琛', '琿', '瑛', '瑩', '璦', '璫', '璿',
            '甍', '甞', '畳', '當', '疂', '疊', '疐', '瘒', '癆', '皧', '皸', '皹', '眈', '睴',
            '睿', '瞑', '瞠', '瞢', '瞬', '瞹', '矇', '矒', '碲', '磅', '磆', '礌', '礐', '礑',
            '礞', '礭', '礵', '祲', '禘', '禜', '秧', '穀', '箒', '簹', '簺', '糓', '紞', '索',
            '綅', '綍', '続', '綬', '締', '縈', '縠', '罃', '罕', '翬', '耮', '耰', '耽', '聤',
            '肎', '脖', '膀', '膋', '膏', '膛', '臛', '臺', '舜', '舝', '艜', '艨', '英', '荸',
            '菷', '萙', '葠', '葧', '葶', '葷', '蒂', '蒄', '蒙', '蒡', '蓂', '蓇', '蔕', '蕓',
            '蕣', '薆', '薋', '薓', '薧', '薨', '薷', '薹', '藿', '蘎', '虂', '蛍', '螃', '螟',
            '螢', '螮', '螳', '蟐', '蟷', '蠑', '蠓', '蠔', '蠧', '蠹', '裳', '褌', '襠', '覚',
            '覺', '觳', '訦', '誖', '読', '諢', '諦', '謗', '譹', '讜', '豪', '賝', '賞', '賷',
            '蹄', '蹛', '躭', '軍', '輝', '轂', '辤', '運', '遰', '邉', '邥', '鄆', '鄍', '鄠',
            '酃', '酖', '醓', '醽', '鋍', '鋟', '鍕', '鍗', '鎊', '鎍', '鎣', '鏜', '鐳', '鐺',
            '鑅', '鑜', '閿', '隚', '隺', '雩', '雯', '雱', '雺', '霂', '霃', '霅', '霉', '霙',
            '霚', '霛', '霝', '霡', '霢', '霣', '霨', '霱', '霳', '靁', '靃', '靉', '靊', '靎',
            '靏', '鞅', '鞺', '韗', '顬', '餑', '餫', '饐', '饛', '駸', '驝', '骨', '骪', '骬',
            '骭', '骮', '骯', '骰', '骲', '骴', '骵', '骶', '骸', '骹', '骻', '骼', '骾', '骿',
            '髀', '髁', '髃', '髄', '髆', '髈', '髎', '髏', '髐', '髑', '髒', '髓', '體', '髕',
            '髖', '髗', '髧', '鬱', '魫', '鮼', '鱟', '鱨', '鱩', '鱫', '鴆', '鴦', '鴬', '鵓',
            '鶤', '鶯', '鶴', '鶻', '鷇', '鷧', '鷽', '鸖', '黆', '黌', '黕', '黨', '鼏', '鼲',
            '齳', '龗',
        ],
    },
    Membership {
        radical: '人',
        strokes: 2,
        kanji: &[
            '丙', '两', '乞', '乾', '亥', '人', '仄', '从', '以', '伕', '众', '似', '佚', '佽',
            '侅', '來', '侠', '俎', '俠', '俸', '俽', '倅', '倆', '倝', '倹', '偈', '傘', '傷',
            '僉', '僟', '儉', '兦', '内', '决', '刔', '券', '刻', '剉', '剣', '剱', '劂', '劍',
            '劒', '劔', '劵', '劾', '勑', '勝', '匃', '匧', '匳', '卒', '卷', '吶', '咎', '咲',
            '咳', '唻', '啐', '嗇', '嗢', '嘰', '噞', '噬', '嚙', '囃', '囚', '圈', '圏', '坐',
            '垓', '埣', '塉', '塩', '墻', '夐', '夫', '夬', '失', '夾', '奉', '奏', '姨', '婾',
            '嬙', '孅', '岒', '岺', '峡', '峽', '崁', '崍', '崒', '嵑', '嵾', '嶔', '嶮', '巫',
            '帙', '幭', '庚', '座', '庾', '廞', '廫', '弻', '從', '徠', '復', '快', '忺', '怏',
            '悔', '悴', '惞', '惥', '愒', '愜', '愴', '慲', '憖', '憗', '憠', '憸', '懎', '懺',
            '扶', '抉', '抐', '抦', '挟', '挫', '挾', '捧', '捽', '揆', '搵', '撅', '撩', '撲',
            '撳', '撿', '擌', '攅', '斂', '昃', '昞', '春', '晬', '晷', '暍', '暎', '替', '朅',
            '朕', '杴', '枘', '柄', '栨', '核', '梜', '棒', '棶', '椊', '検', '椿', '楬', '楰',
            '榛', '槻', '樕', '橛', '檢', '檣', '櫼', '欞', '欠', '欤', '欨', '欫', '欬', '欯',
            '欵', '欶', '欻', '欿', '歆', '歊', '歍', '歒', '歖', '歘', '歛', '歝', '歠', '殃',
            '殮', '殲', '毉', '氳', '汭', '決', '泅', '泰', '泱', '洟', '浹', '淬', '淶', '渓',
            '渕', '湊', '滕', '滿', '澨', '澰', '濇', '瀲', '炔', '炳', '焠', '焫', '熅', '熌',
            '爽', '牆', '狭', '狹', '猍', '猝', '猲', '獦', '獫', '玦', '璞', '璣', '璻', '畉',
            '畒', '病', '痍', '痤', '瘁', '瘞', '瘠', '瘲', '眷', '眾', '睞', '睟', '瞼', '矬',
            '砍', '硤', '碎', '碣', '礆', '禨', '秂', '秦', '秧', '秩', '稡', '穖', '穡', '窣',
            '筮', '筴', '筷', '篋', '篵', '簌', '簽', '籐', '籘', '籡', '籤', '粹', '納', '綣',
            '綷', '緃', '縕', '縢', '縱', '纉', '纖', '缺', '缼', '羡', '羮', '翠', '聳', '肉',
            '肭', '脊', '脞', '脺', '腴', '腹', '膵', '臉', '臎', '臥', '臨', '臾', '舲', '艢',
            '艱', '芙', '芡', '芮', '苡', '苪', '莝', '莢', '萃', '萊', '萸', '葅', '葵', '蒕',
            '蓌', '蓙', '蓯', '蔌', '蕐', '薀', '薔', '薟', '蘞', '蚋', '蛃', '蛺', '蜷', '蜹',
            '蟣', '衑', '衲', '袂', '裌', '襳', '規', '覡', '觖', '訣', '訥', '該', '誣', '誶',
            '諛', '譛', '譣', '讃', '讖', '豢', '豵', '賚', '賛', '赥', '趑', '趦', '趹', '趺',
            '跌', '跲', '蹐', '蹼', '軜', '軼', '輦', '輳', '輵', '轀', '轕', '逨', '遬', '邴',
            '郟', '醉', '醞', '醶', '鈉', '鈌', '鈵', '鉯', '銕', '銼', '鋏', '鎹', '鏉', '鏦',
            '鏷', '鐖', '鐱', '鑚', '鑡', '鑯', '閃', '閄', '関', '閦', '陋', '陜', '陝', '険',
            '陿', '險', '雜', '靈', '靹', '鞅', '鞆', '鞿', '韞', '韤', '韱', '頬', '頰', '顇',
            '飾', '餈', '餲', '駃', '駭', '騋', '験', '騰', '驗', '骸', '髽', '魕', '鰆', '鰮',
            '鱖', '鴂', '鴃', '鵊', '鵐', '鶆', '鶊', '鶏', '鶡', '鶺', '鹸', '鹼', '麥', '麨',
            '麩', '麪', '麬', '麭', '麮', '麯', '麰', '麳', '麴', '麵', '麸', '齃', '齒', '齓',
            '齕', '齖', '齗', '齘', '齚', '齞', '齡', '齨', '齩', '齭', '齮', '齯', '齰', '齱',
            '齳', '齵', '齺', '齽', '龡',
        ],
    },
    Membership {
        radical: '又',
        strokes: 2,
        kanji: &[
            '亟', '仮', '伋', '伎', '伖', '伮', '侵', '俶', '假', '傁', '冣', '冦', '凾', '剟',
            '努', '匓', '又', '叉', '友', '双', '反', '収', '叏', '叒', '叓', '叔', '叕', '取',
            '受', '叙', '叚', '叛', '叝', '叞', '叟', '叠', '叡', '叢', '吱', '呶', '啜', '嗓',
            '嘏', '嘙', '嘬', '嚄', '圣', '圾', '坂', '坡', '坺', '埾', '堅', '報', '墁', '墢',
            '墼', '壂', '壑', '壡', '奴', '妓', '妭', '娵', '娶', '婆', '婌', '媛', '媻', '嫂',
            '嫚', '孥', '孯', '寂', '寇', '寖', '寝', '寢', '屐', '岐', '嵈', '帑', '帔', '幋',
            '幔', '庋', '度', '庪', '廋', '廏', '廢', '弢', '弩', '彀', '彠', '役', '彼', '径',
            '忮', '怒', '怓', '怪', '惄', '惙', '愨', '慅', '慇', '慢', '慳', '戄', '扠', '扳',
            '技', '投', '抜', '披', '拏', '捜', '掇', '授', '掔', '掫', '掻', '援', '搔', '搜',
            '搬', '摋', '撃', '撮', '擊', '擭', '攫', '支', '攱', '敠', '敧', '敺', '敽', '斅',
            '昄', '暇', '暖', '曼', '最', '服', '杈', '板', '枝', '柀', '桑', '椒', '椴', '椵',
            '楥', '極', '楹', '榖', '槃', '槾', '樫', '樶', '樷', '檴', '欆', '欉', '歠', '歧',
            '歿', '殛', '殩', '殳', '殴', '段', '殷', '殸', '殹', '殺', '殻', '殼', '殽', '殾',
            '殿', '毀', '毃', '毄', '毅', '毆', '毉', '汊', '汳', '沒', '没', '波', '浸', '淑',
            '渡', '湲', '溲', '漫', '潑', '澯', '澱', '濅', '濩', '瀣', '焏', '煅', '煆', '煖',
            '熳', '燦', '燬', '燮', '爰', '版', '犮', '猨', '獲', '玃', '玻', '瑕', '瑗', '璨',
            '瓪', '畈', '畷', '疫', '疲', '痩', '瘕', '瘙', '瘢', '瘦', '癜', '發', '皈', '皮',
            '皰', '皴', '皷', '皸', '皹', '皺', '皽', '盈', '盋', '盤', '督', '瞍', '瞖', '瞽',
            '矍', '矱', '砮', '破', '碆', '碬', '磉', '磐', '磤', '磬', '礥', '祋', '祲', '穀',
            '穝', '穫', '竪', '笯', '箙', '箥', '篗', '簆', '簸', '籆', '籰', '粲', '糓', '糔',
            '紱', '経', '綅', '綬', '綴', '緅', '緊', '緞', '緩', '縀', '縠', '縵', '繄', '繋',
            '繫', '罄', '羖', '翅', '翳', '聚', '聲', '肞', '股', '肢', '胈', '腎', '膄', '臀',
            '臋', '臤', '舨', '般', '艘', '艧', '艭', '芟', '芨', '芰', '茇', '茎', '菔', '菝',
            '菠', '菽', '葠', '葭', '葮', '蒦', '蔎', '蔓', '蔢', '蕞', '蕟', '蕿', '薓', '藂',
            '蘐', '蘙', '蘰', '蚑', '蚤', '蝃', '蝦', '蝯', '螋', '螌', '蟿', '蠖', '蠮', '蠼',
            '衩', '袚', '被', '裰', '襏', '覶', '觳', '設', '詉', '詖', '詜', '諏', '諔', '諼',
            '謦', '謾', '譭', '護', '豉', '豎', '豛', '豭', '貜', '販', '賢', '赧', '赮', '趣',
            '跂', '跛', '踧', '踱', '躞', '躩', '軷', '軽', '輙', '輟', '轂', '辤', '辭', '返',
            '遐', '郰', '鄹', '酘', '醊', '醫', '醱', '釵', '鈑', '鈘', '鈸', '鈹', '鋟', '鋬',
            '鋻', '錣', '鍍', '鍛', '鍜', '鍰', '鎩', '鏗', '鏝', '鏧', '鏺', '鑊', '鑿', '钁',
            '閿', '阪', '陂', '陬', '隻', '雘', '雙', '霞', '靫', '鞁', '鞶', '韄', '韍', '頍',
            '頗', '頚', '顙', '颰', '飯', '餐', '餟', '饅', '馛', '馨', '馭', '駑', '駸', '騒',
            '騢', '騷', '驋', '驟', '骰', '髮', '髲', '鬘', '魬', '鮍', '鮼', '鯫', '鰀', '鰕',
            '鰹', '鰻', '鳷', '鴑', '鵩', '鷇', '鷖', '麬', '鼓', '鼔', '鼕', '鼖', '鼗', '鼙',
            '鼚', '鼛', '鼟', '齱',
        ],
    },
    Membership {
        radical: '匕',
        strokes: 2,
        kanji: &[
            '七', '乖', '乘', '乜', '也', '些', '仳', '佌', '佗', '佬', '侂', '俿', '偈', '傀',
            '傎', '傾', '儗', '儳', '冀', '凝', '切', '剩', '劇', '劖', '勴', '匂', '匕', '化',
            '北', '匘', '匙', '匜', '叱', '吡', '吪', '呢', '呰', '咃', '咜', '咾', '喈', '喝',
            '嗁', '嗜', '嘅', '嘑', '嘗', '嘘', '嘴', '噱', '嚥', '嚧', '嚱', '囐', '囮', '坒',
            '坨', '坭', '垞', '埀', '埖', '埿', '堦', '堲', '塊', '塟', '塡', '墍', '墟', '壚',
            '壱', '她', '奼', '妮', '姥', '媲', '媿', '孋', '它', '寘', '尼', '屍', '嵊', '嵬',
            '嶷', '巇', '巍', '巘', '庀', '廆', '廎', '廬', '彘', '彪', '彲', '彵', '怩', '恉',
            '悂', '愧', '愼', '態', '慮', '懝', '戯', '戲', '抳', '拕', '拖', '指', '掲', '揓',
            '揹', '搘', '摝', '摣', '擄', '據', '擬', '擺', '攄', '攈', '攙', '攟', '攦', '斃',
            '旎', '旨', '昵', '曁', '曏', '曬', '曷', '杝', '柁', '柂', '柅', '柒', '柴', '栳',
            '梍', '椛', '椸', '槐', '樚', '樝', '櫆', '櫖', '櫨', '欃', '欐', '欵', '歇', '歔',
            '此', '死', '毖', '毚', '沘', '沱', '沲', '泚', '泥', '渇', '湝', '滇', '滮', '滹',
            '潁', '瀘', '炛', '熊', '熲', '燕', '爈', '爐', '牝', '牠', '狴', '猇', '獹', '獻',
            '玭', '玼', '琥', '琨', '瑰', '瑱', '璏', '璩', '瓐', '瓛', '甗', '疑', '疕', '疵',
            '痆', '瘣', '瘧', '癡', '癤', '皀', '皍', '盧', '眞', '眤', '眥', '眦', '矑', '砌',
            '砣', '砦', '硴', '碣', '磇', '磈', '磌', '礙', '禛', '稭', '稹', '稽', '穎', '窃',
            '竭', '竾', '箎', '篪', '簏', '簴', '籚', '籧', '籭', '糀', '紪', '紫', '紽', '絁',
            '緄', '縝', '纑', '纚', '罅', '罏', '罷', '羆', '羯', '老', '耄', '耆', '耈', '耋',
            '聭', '肄', '背', '胒', '胔', '能', '脂', '膚', '臈', '臕', '臙', '臚', '臰', '舵',
            '艣', '艫', '芘', '花', '芲', '苆', '苨', '茈', '荖', '莵', '葛', '葬', '葹', '蒐',
            '蓍', '薌', '薧', '薨', '薼', '薿', '藘', '藨', '藹', '蘆', '蘧', '蘶', '虍', '虎',
            '虐', '虒', '虓', '虔', '處', '虖', '虗', '虘', '虙', '虚', '虜', '虝', '虞', '號',
            '虠', '虡', '虢', '虣', '虤', '虧', '虩', '虵', '蚍', '蚭', '蛇', '蛯', '蝎', '螕',
            '螧', '蟕', '蠍', '袘', '褐', '褙', '褦', '褫', '覰', '覷', '觜', '訑', '訛', '訾',
            '詑', '詣', '誮', '諕', '謁', '謔', '謼', '譃', '讌', '讞', '豦', '貤', '貨', '貲',
            '跎', '蹏', '躧', '軰', '輥', '轤', '迆', '迤', '迱', '遏', '遞', '遽', '邐', '邶',
            '鄜', '酈', '酏', '酡', '醜', '醵', '醼', '釃', '釶', '鈮', '鉇', '鉈', '銠', '錕',
            '錵', '鍇', '鎞', '鎭', '鐻', '鑙', '鑢', '鑣', '鑪', '鑱', '闐', '阤', '陀', '陁',
            '隗', '雌', '靄', '靴', '鞨', '頃', '頴', '頾', '顚', '顱', '餛', '餽', '饕', '饞',
            '駝', '駞', '驢', '驥', '骴', '髒', '髗', '髢', '髭', '鬐', '鬒', '鬯', '鬱', '鬳',
            '鬼', '鬽', '魁', '魂', '魃', '魄', '魅', '魈', '魋', '魌', '魍', '魎', '魏', '魑',
            '魔', '魕', '魖', '魗', '魘', '魮', '鮀', '鮆', '鮨', '鮱', '鯱', '鯽', '鰭', '鱜',
            '鱨', '鱸', '鴇', '鴕', '鴜', '鴲', '鵾', '鷆', '鷉', '鷰', '鸕', '鸝', '麀', '麂',
            '麃', '麄', '麅', '麇', '麎', '麏', '麖', '麘', '麛', '麞', '麤', '黰', '黸', '齇',
            '齔',
        ],
    },
    Membership {
        radical: '厂',
        strokes: 2,
        kanji: &[
            '乕', '仄', '仮', '伌', '佹', '侲', '俿', '偐', '偱', '傆', '傓', '備', '儋', '儼',
            '兏', '减', '剷', '劂', '劇', '劌', '励', '劶', '勴', '勵', '卬', '卮', '危', '厂',
            '厃', '厄', '厇', '厈', '厎', '厓', '厔', '厖', '厘', '厙', '厚', '厝', '原', '厠',
            '厡', '厤', '厥', '厦', '厨', '厩', '厪', '厫', '厭', '厮', '厯', '厰', '厲', '厳',
            '厵', '反', '叛', '后', '呃', '唇', '啀', '喭', '嗁', '嘊', '嘑', '嘘', '嘙', '噡',
            '噦', '噱', '嚈', '嚦', '嚧', '嚱', '嚴', '囐', '圧', '坂', '垕', '垝', '垢', '堿',
            '墟', '壓', '壚', '壢', '壥', '奯', '威', '娍', '娠', '媙', '嫄', '嫠', '宬', '宸',
            '屵', '岸', '峗', '崕', '崖', '崴', '嵃', '嵟', '巇', '巌', '巖', '巘', '巵', '幨',
            '廬', '彦', '彪', '循', '恑', '恢', '愿', '慝', '慮', '慼', '憊', '憠', '憹', '憺',
            '懕', '戌', '戍', '戯', '戲', '扳', '扼', '振', '捱', '摣', '撅', '擄', '擔', '據',
            '擪', '攄', '攊', '敐', '昃', '昄', '晠', '暦', '曟', '曮', '板', '枙', '柀', '栃',
            '桅', '梔', '楯', '楲', '槈', '樝', '橛', '橱', '檐', '檿', '櫉', '櫔', '櫖', '櫨',
            '櫪', '歔', '歴', '殷', '氂', '汳', '派', '涯', '源', '滮', '滹', '滻', '漄', '漘',
            '漦', '澹', '濃', '濊', '濾', '瀘', '瀝', '灰', '炭', '烕', '爈', '爐', '版', '犛',
            '猇', '獗', '獩', '獹', '獻', '玁', '珹', '琥', '璩', '瓐', '瓛', '甅', '甗', '産',
            '畈', '瘧', '癧', '皈', '盧', '盾', '睂', '睚', '瞻', '矑', '矦', '砺', '碱', '磿',
            '礪', '禯', '穠', '竰', '箎', '箥', '篪', '篾', '簴', '簷', '籚', '籧', '糎', '糒',
            '糲', '縬', '纑', '纒', '罅', '罏', '罽', '翽', '脆', '脈', '脤', '腯', '膚', '膽',
            '膿', '臓', '臚', '臲', '臹', '舚', '艣', '艫', '荗', '荿', '莀', '葳', '葴', '蔢',
            '蔵', '蕆', '蕨', '蕽', '薅', '薉', '薝', '薩', '藘', '藶', '蘆', '蘧', '虍', '虎',
            '虐', '虒', '虓', '虔', '處', '虖', '虗', '虘', '虙', '虚', '虜', '虝', '虞', '號',
            '虠', '虡', '虢', '虣', '虤', '虧', '虩', '蛎', '蜄', '螈', '蟾', '蠛', '蠣', '衊',
            '褫', '襛', '襜', '覛', '覰', '覷', '觱', '詖', '詬', '詭', '詹', '詼', '諕', '諴',
            '謔', '謜', '謼', '譃', '譫', '讞', '豦', '販', '貭', '贋', '贍', '贗', '跪', '蹏',
            '蹰', '蹶', '軅', '軛', '輴', '轣', '轤', '辰', '辱', '農', '返', '逅', '逓', '遁',
            '遃', '遞', '遽', '郈', '郕', '醎', '醲', '醵', '釅', '釐', '鈑', '銊', '銗', '鋠',
            '鋬', '鋮', '鎒', '鏟', '鐻', '鑢', '鑪', '阨', '阪', '陒', '雁', '震', '霢', '靂',
            '靨', '鞴', '韛', '頠', '顏', '顑', '顔', '願', '顣', '顪', '顱', '飯', '饕', '饜',
            '騵', '驢', '髗', '髲', '鬳', '魖', '魘', '魬', '鮠', '鯎', '鯱', '鱖', '鱵', '鱸',
            '鳫', '鴈', '鷉', '鸕', '麎', '黬', '黵', '黶', '黸', '齇',
        ],
    },
    Membership {
        radical: '𠂉',
        strokes: 2,
        kanji: &[
            '乍', '乞', '乾', '作', '侮', '侯', '俟', '修', '候', '倣', '做', '傚', '傲', '傷',
            '儖', '儼', '凝', '勧', '医', '午', '卸', '厰', '厳', '吃', '啓', '啣', '喉', '嗷',
            '嗾', '嘸', '噬', '嚴', '埃', '塩', '塰', '塲', '嫉', '嫩', '孜', '寳', '尓', '履',
            '屹', '嶷', '巌', '巖', '幣', '幤', '年', '廠', '廡', '弊', '弥', '御', '復', '微',
            '徴', '徹', '忤', '怎', '悔', '悠', '愍', '愎', '愾', '慯', '憮', '懲', '挨', '撒',
            '撤', '撫', '擬', '攬', '攵', '收', '攷', '攸', '改', '攻', '放', '政', '故', '效',
            '敏', '救', '敕', '敖', '敗', '敘', '教', '敝', '敞', '敢', '散', '敦', '敬', '数',
            '整', '敵', '敷', '數', '斂', '斃', '施', '旃', '旄', '旅', '旆', '旋', '旌', '族',
            '旒', '旗', '旛', '晦', '智', '暼', '暾', '杵', '枚', '栴', '梅', '條', '椥', '権',
            '橄', '檄', '檠', '檻', '櫛', '欖', '欸', '歓', '殤', '毎', '毓', '气', '気', '氛',
            '氣', '氤', '汽', '海', '液', '游', '滌', '滸', '潅', '澂', '激', '濫', '瀲', '無',
            '熬', '燉', '牧', '猴', '珎', '畋', '疑', '疾', '痴', '癡', '監', '瞥', '瞰', '矢',
            '矣', '知', '矧', '矩', '短', '矮', '矯', '礙', '禦', '称', '竅', '竢', '竹', '竺',
            '竿', '笂', '笄', '笆', '笈', '笊', '笋', '笏', '笑', '笘', '笙', '笛', '笞', '笠',
            '笥', '符', '笨', '第', '笳', '笵', '笶', '笹', '筅', '筆', '筈', '等', '筋', '筌',
            '筍', '筏', '筐', '筑', '筒', '答', '策', '筝', '筥', '筧', '筬', '筮', '筰', '筱',
            '筴', '筵', '筺', '箆', '箇', '箋', '箍', '箏', '箒', '箔', '箕', '算', '箘', '箙',
            '箚', '箜', '箝', '箟', '管', '箪', '箭', '箱', '箴', '箸', '節', '篁', '範', '篆',
            '篇', '篋', '篌', '篏', '篝', '篠', '篤', '篥', '篦', '篩', '篭', '篳', '篶', '篷',
            '簀', '簇', '簍', '簑', '簒', '簓', '簔', '簗', '簟', '簡', '簣', '簧', '簪', '簫',
            '簷', '簸', '簽', '簾', '簿', '籀', '籃', '籌', '籍', '籏', '籐', '籔', '籖', '籘',
            '籟', '籠', '籤', '籥', '籬', '絛', '綮', '緻', '繁', '繖', '繿', '纂', '纜', '翳',
            '聟', '肄', '肇', '脩', '腹', '膂', '膓', '臨', '致', '舞', '艦', '莓', '葹', '蓚',
            '蔟', '蔽', '蕪', '薇', '薙', '薮', '藍', '藪', '蜘', '蝣', '蝮', '螫', '螯', '袮',
            '複', '襤', '覆', '覈', '覧', '観', '覽', '觴', '訖', '許', '誨', '警', '變', '贅',
            '赦', '踟', '輹', '轍', '迄', '迩', '迭', '遊', '遨', '邀', '醫', '釐', '鉄', '鏃',
            '鐓', '鑑', '鑒', '雉', '霰', '飭', '飾', '馥', '驚', '鰒', '鰲', '鶩', '鹽', '黴',
            '鼇', '鼈',
        ],
    },
    Membership {
        radical: '卜',
        strokes: 2,
        kanji: &[
            '上', '下', '与', '乩', '仆', '佔', '俶', '俿', '倬', '偵', '兏', '冦', '劇', '勴',
            '卓', '卜', '卞', '占', '卡', '卣', '卥', '卦', '卵', '叔', '叡', '吓', '呫', '哶',
            '啅', '喒', '嗁', '嘑', '嘘', '噱', '嚧', '嚱', '囐', '圤', '圷', '坫', '垰', '墟',
            '壑', '壚', '壡', '外', '婌', '婥', '媜', '寂', '寇', '尗', '岾', '峠', '巇', '巘',
            '帖', '幀', '店', '廎', '廬', '彪', '忐', '忑', '忭', '怗', '悼', '惉', '慮', '慼',
            '懜', '戚', '戯', '戲', '扂', '扑', '抃', '拈', '挊', '掂', '掉', '掛', '揁', '摣',
            '擄', '據', '攄', '敠', '敧', '敺', '斅', '昝', '晫', '晷', '朴', '桌', '桛', '梺',
            '棹', '椒', '楨', '槭', '樝', '檆', '櫖', '櫜', '櫨', '欤', '歔', '殩', '毡', '汴',
            '沾', '淑', '淖', '湞', '滮', '滷', '滹', '澯', '濬', '濾', '瀘', '瀣', '点', '焯',
            '爈', '爐', '爟', '猇', '獹', '獻', '玷', '琥', '璨', '璩', '璿', '瓐', '瓛', '甗',
            '疜', '痁', '瘧', '盧', '督', '睿', '矑', '砧', '碵', '磠', '禎', '秥', '竊', '站',
            '竨', '笇', '笘', '箎', '篪', '簆', '簴', '籚', '籧', '粘', '粲', '綹', '綽', '縬',
            '纑', '罅', '罏', '罩', '罫', '羋', '羐', '膚', '臚', '艣', '艫', '苫', '茮', '菽',
            '藘', '蘆', '蘧', '虁', '虍', '虎', '虐', '虒', '虓', '虔', '處', '虖', '虗', '虘',
            '虙', '虚', '虜', '虝', '虞', '號', '虠', '虡', '虢', '虣', '虤', '虧', '虩', '蛅',
            '裃', '褂', '褫', '覘', '覰', '覷', '訃', '詀', '諔', '諕', '謔', '謼', '譃', '讞',
            '豦', '貞', '貼', '赬', '赴', '趈', '趠', '跕', '踔', '蹏', '蹙', '蹞', '轤', '迠',
            '迯', '逌', '逴', '遉', '遞', '遽', '醵', '釙', '鉆', '鍞', '鐻', '鑢', '鑪', '閇',
            '阽', '霑', '鞐', '顣', '顱', '颪', '颭', '飪', '饕', '驢', '髗', '鬳', '魖', '鮎',
            '鯱', '鱸', '鵫', '鷉', '鸕', '鹹', '黏', '點', '黸', '鼑', '鼔', '鼛', '齇',
        ],
    },
    Membership {
        radical: '冫',
        strokes: 2,
        kanji: &[
            '佻', '傓', '傟', '僇', '兆', '冫', '冰', '冱', '冲', '决', '冴', '况', '冶', '冷',
            '冸', '冺', '冼', '冽', '冾', '冿', '凂', '凄', '凅', '准', '凈', '凉', '凋', '凌',
            '凍', '减', '凑', '凒', '凓', '凕', '凖', '凘', '凛', '凜', '凝', '凞', '凴', '剹',
            '勜', '勠', '咨', '咷', '唹', '嘐', '嘙', '嘷', '噏', '均', '垗', '塁', '塉', '塌',
            '塕', '墀', '姚', '姿', '嫋', '嫪', '嬥', '宨', '寥', '嵡', '嵶', '嵺', '廖', '廫',
            '弱', '恌', '恣', '愵', '慴', '慿', '憀', '憑', '懿', '戮', '扇', '挑', '挧', '搦',
            '搨', '摂', '摎', '摔', '摺', '擽', '旐', '晀', '晁', '暭', '朓', '栨', '栩', '桃',
            '楽', '榒', '榻', '槢', '樛', '樨', '檪', '櫰', '次', '歙', '毣', '洮', '淤', '渋',
            '溺', '溻', '滃', '漻', '潝', '瀚', '瀷', '烑', '煽', '熠', '爍', '率', '珝', '珧',
            '璆', '璻', '瓌', '瓷', '疁', '疂', '疼', '瘳', '皥', '盗', '眺', '磖', '磟', '礫',
            '祧', '窕', '篛', '籊', '粢', '繆', '羡', '羽', '羿', '翀', '翁', '翃', '翅', '翆',
            '翈', '翊', '翌', '翎', '翏', '習', '翔', '翕', '翛', '翟', '翠', '翡', '翣', '翥',
            '翦', '翨', '翩', '翫', '翬', '翮', '翯', '翰', '翲', '翳', '翹', '翺', '翻', '翼',
            '翽', '翾', '翿', '聚', '肦', '脧', '膠', '臎', '臧', '茨', '蒻', '蓊', '蓼', '薋',
            '薬', '藋', '蘙', '螉', '蟀', '蟉', '蠮', '袀', '褶', '覜', '詡', '誂', '諮', '謆',
            '謬', '譾', '資', '賿', '贓', '趐', '趑', '趦', '趯', '跳', '蹋', '蹹', '躢', '軣',
            '轇', '轢', '逃', '遢', '醪', '鈞', '銚', '鋆', '鏐', '鑃', '鑠', '钃', '閼', '闒',
            '闟', '鞉', '韵', '頫', '飂', '飡', '餈', '馮', '騸', '髎', '鮗', '鯲', '鰥', '鰨',
            '鰯', '鶲', '鶸', '鷚', '鸐', '鼕', '鼗',
        ],
    },
    Membership {
        radical: '凵',
        strokes: 2,
        kanji: &[
            '傜', '儍', '兇', '凵', '凶', '凷', '凸', '凹', '函', '凾', '匈', '匋', '卋', '吨',
            '啣', '嚙', '嚥', '囓', '囤', '墼', '媱', '寚', '寶', '屆', '屯', '崗', '崫', '嵕',
            '席', '帶', '幽', '度', '廿', '徭', '忳', '恟', '悩', '慸', '懣', '扽', '掏', '掣',
            '揺', '搖', '摛', '擊', '擒', '旆', '旾', '昢', '暚', '杶', '枽', '棄', '棡', '椶',
            '樠', '歯', '汹', '泏', '洶', '涵', '淈', '淘', '滍', '滯', '滿', '漓', '灕', '炖',
            '炗', '熚', '猺', '瑶', '璃', '画', '盹', '瞞', '祹', '离', '禽', '稯', '窀', '窋',
            '窑', '窰', '籬', '糉', '絀', '綯', '緵', '縭', '繇', '繫', '缶', '缸', '缺', '缻',
            '缼', '缽', '缾', '缿', '罃', '罄', '罅', '罇', '罌', '罍', '罎', '罏', '罐', '羇',
            '肫', '胸', '脳', '臙', '艷', '芚', '茁', '葼', '蒓', '蓆', '蔕', '蔗', '蘺', '螭',
            '蟎', '蟿', '褵', '襅', '詘', '詜', '詾', '誳', '謠', '謡', '讌', '豐', '豘', '贉',
            '踱', '蹠', '蹣', '躚', '迍', '遥', '酗', '醨', '醰', '醼', '鈯', '鍐', '鏋', '鑁',
            '鑡', '雋', '離', '靺', '鞅', '鞣', '韷', '顄', '顢', '颻', '騣', '鬉', '鬯', '鬱',
            '鬷', '魑', '魨', '鰩', '鱏', '鷂', '鷓', '鷰', '黐', '齒', '齓', '齔', '齕', '齖',
            '齗', '齘', '齚', '齝', '齞', '齟', '齠', '齡', '齢', '齣', '齦', '齧', '齨', '齩',
            '齪', '齬', '齭', '齮', '齯', '齰', '齱', '齲', '齳', '齵', '齶', '齷', '齺', '齽',
        ],
    },
    Membership {
        radical: '几',
        strokes: 2,
        kanji: &[
            '亢', '伉', '佩', '俿', '冗', '几', '凡', '凢', '凥', '処', '凧', '凩', '凪', '凭',
            '凮', '凰', '凱', '凲', '凳', '凴', '劥', '匓', '匟', '吭', '咒', '嗁', '囥', '坑',
            '墢', '墼', '壂', '壳', '夙', '媺', '媻', '嬴', '巩', '帆', '幋', '廏', '廢', '彀',
            '役', '忼', '恐', '愨', '慇', '投', '抗', '拠', '搬', '摋', '撃', '擊', '机', '杭',
            '梵', '椴', '楓', '榖', '槃', '櫈', '殳', '殴', '段', '殷', '殸', '殹', '殺', '殻',
            '殼', '殽', '殾', '殿', '毀', '毃', '毄', '毅', '毆', '毉', '汎', '沆', '沉', '没',
            '滮', '潑', '澱', '瀛', '炕', '焭', '煅', '燬', '牨', '猇', '猟', '珮', '疫', '痜',
            '瘋', '瘢', '癜', '發', '盤', '瞖', '磐', '磤', '磬', '祋', '秔', '穀', '竌', '筑',
            '箎', '築', '篪', '籝', '粇', '糓', '緞', '縠', '繄', '繋', '繫', '罄', '羖', '羸',
            '翳', '聲', '肌', '股', '臀', '臋', '臝', '航', '般', '芁', '芃', '芟', '葮', '蔎',
            '蕟', '薇', '蘙', '虒', '虓', '處', '虝', '虠', '虢', '虣', '虤', '虩', '蛩', '蝋',
            '螌', '蟿', '蠃', '蠮', '襏', '觳', '訊', '設', '諕', '諷', '謦', '譭', '豛', '跫',
            '蹏', '轂', '迒', '酘', '醫', '醱', '釩', '銎', '鍛', '鎩', '鏧', '鏺', '鑿', '閌',
            '阬', '鞏', '鞶', '頽', '風', '颪', '颯', '颱', '颶', '飃', '飄', '飆', '飢', '馨',
            '驋', '骪', '骯', '骰', '髠', '鳧', '鳬', '鳳', '鷇', '鷉', '鷖', '麂',
        ],
    },
    Membership {
        radical: '刀',
        strokes: 2,
        kanji: &[
            '仞', '仭', '份', '佋', '偰', '儕', '刀', '刃', '刄', '刅', '分', '切', '刕', '初',
            '刧', '刱', '券', '刼', '剏', '剪', '剱', '劈', '劑', '劒', '劔', '劭', '卲', '叧',
            '叨', '召', '吩', '哪', '喫', '噄', '嚌', '嚠', '囓', '囹', '坌', '契', '娜', '寡',
            '屶', '屻', '岔', '嶰', '廨', '弨', '彅', '彛', '彜', '忉', '忍', '忿', '怊', '恝',
            '懈', '扨', '扮', '拐', '招', '挈', '挪', '揳', '擠', '攽', '昭', '朷', '枌', '枴',
            '栔', '梁', '梛', '棻', '棼', '楔', '榴', '樑', '檞', '歰', '氛', '汾', '沼', '洯',
            '湓', '溜', '潔', '澀', '澥', '濟', '炤', '照', '牣', '獬', '玢', '玿', '瑠', '瓫',
            '瓰', '留', '瘈', '瘛', '瘤', '盆', '盼', '砌', '禊', '稧', '穧', '窃', '竕', '簗',
            '籀', '籕', '籾', '粉', '粱', '紉', '紛', '紹', '絜', '綛', '纃', '肦', '脃', '脋',
            '臍', '芀', '芬', '苆', '苕', '茘', '荵', '葜', '薢', '薺', '虀', '蚡', '蛁', '蟹',
            '蠏', '蠐', '衂', '解', '訒', '詔', '認', '謭', '譅', '貂', '貧', '貿', '超', '躋',
            '躮', '躵', '軔', '軺', '辧', '辺', '迢', '遛', '邂', '邠', '那', '邵', '鄮', '酚',
            '釁', '釖', '釰', '釼', '鈖', '鉊', '鍥', '鎦', '隮', '雰', '霤', '霽', '靭', '靱',
            '鞀', '韌', '韲', '韶', '頒', '餾', '騮', '髫', '魛', '魵', '鮉', '鰡', '鶹', '麄',
            '鼢', '鼦', '齊', '齋', '齎', '齏', '齠', '齧',
        ],
    },
    Membership {
        radical: '⺉',
        strokes: 2,
        kanji: &[
            '例', '俐', '倒', '偂', '側', '偸', '冽', '刂', '刈', '刊', '刋', '刎', '刑', '划',
            '刓', '刔', '刖', '列', '刘', '刢', '判', '別', '刨', '利', '刪', '刮', '到', '刲',
            '刳', '刵', '制', '刷', '刹', '刺', '刻', '剃', '剄', '剅', '則', '剉', '削', '剋',
            '剌', '前', '剔', '剕', '剖', '剗', '剘', '剚', '剛', '剜', '剞', '剟', '剠', '剡',
            '剣', '剤', '剥', '剦', '剩', '剪', '剮', '副', '剰', '割', '剳', '剴', '創', '剷',
            '剸', '剹', '剽', '剿', '劀', '劂', '劃', '劅', '劇', '劉', '劊', '劌', '劍', '劑',
            '劓', '劕', '劖', '劗', '劘', '劚', '劽', '匬', '厠', '咧', '唎', '喇', '喩', '嚠',
            '型', '姴', '峲', '崱', '帰', '廁', '彅', '悧', '惻', '愈', '愉', '捌', '掣', '揃',
            '揄', '擶', '梨', '椡', '楡', '櫤', '毹', '洌', '浰', '淛', '渕', '渝', '測', '湔',
            '溂', '瀏', '烈', '煎', '牏', '犁', '猘', '班', '瑜', '痢', '瘉', '瘌', '癒', '硎',
            '窬', '箚', '箭', '罰', '罽', '羭', '翦', '腧', '苅', '茢', '荊', '莂', '莉', '莿',
            '葥', '葪', '蒯', '薊', '蛚', '蜊', '蝓', '蝲', '裂', '製', '褕', '覦', '誗', '諭',
            '謭', '譾', '貐', '踰', '輸', '迾', '逾', '釗', '鉶', '鋓', '鍘', '鍮', '隃', '鬁',
            '鬋', '鬎', '鯏', '鯯', '鰂', '鵥',
        ],
    },
    Membership {
        radical: '匚',
        strokes: 2,
        kanji: &[
            '偃', '傴', '凞', '劻', '勘', '匚', '匛', '匜', '匝', '匞', '匟', '匠', '匡', '匣',
            '匥', '匧', '匨', '匩', '匪', '匫', '匬', '匭', '匯', '匰', '匱', '匲', '匳', '匵',
            '匸', '匹', '区', '医', '匼', '匽', '匾', '匿', '區', '卙', '叵', '吂', '啿', '嘔',
            '嚚', '堪', '堰', '塸', '墈', '奆', '奩', '媐', '嫗', '孯', '尠', '尶', '岠', '嶇',
            '巨', '巸', '弡', '弫', '弬', '彄', '怇', '恇', '悘', '愖', '愜', '慝', '懢', '戡',
            '拒', '挋', '掔', '揕', '揠', '摳', '擥', '敺', '斟', '暱', '朢', '枢', '柜', '柩',
            '框', '椹', '椻', '榘', '榧', '樞', '櫃', '欧', '歐', '歫', '殴', '殹', '毆', '毉',
            '渠', '湛', '漚', '炬', '煁', '煕', '煚', '熙', '熰', '瓯', '甌', '盬', '眶', '瞖',
            '碪', '磡', '磲', '礥', '筐', '筪', '筺', '箍', '篋', '篚', '粔', '糂', '繄', '繼',
            '翳', '耟', '臣', '臤', '茝', '茞', '葚', '蓲', '蕖', '蘙', '蘛', '虐', '蚷', '蝘',
            '蠮', '詎', '誆', '諶', '謔', '謳', '譼', '貙', '賾', '贒', '距', '踸', '躯', '軀',
            '軭', '轞', '郾', '醫', '鋻', '鍖', '鍳', '陿', '隁', '頣', '頤', '頥', '饇', '駆',
            '驅', '鮔', '鰋', '鴎', '鷖', '鷗', '黮', '鼴',
        ],
    },
    Membership {
        radical: '力',
        strokes: 2,
        kanji: &[
            '仂', '伽', '侽', '俲', '働', '別', '力', '劜', '功', '加', '劣', '劤', '劥', '劦',
            '劧', '助', '努', '劫', '劬', '劭', '劯', '劰', '励', '労', '劵', '劶', '劷', '劸',
            '効', '劺', '劻', '劼', '劽', '劾', '勀', '勁', '勃', '勄', '勅', '勆', '勇', '勈',
            '勉', '勌', '勍', '勏', '勑', '勒', '勔', '動', '勖', '勗', '勘', '務', '勛', '勜',
            '勝', '勞', '募', '勠', '勡', '勢', '勣', '勤', '勥', '勦', '勧', '勨', '勩', '勪',
            '勬', '勰', '勱', '勲', '勳', '勴', '勵', '勶', '勷', '勸', '協', '另', '呦', '咖',
            '哿', '嗋', '嘉', '坳', '墈', '夯', '娚', '嫐', '嬲', '屴', '幼', '忇', '恊', '愂',
            '愑', '愶', '慟', '憥', '懃', '扐', '抛', '拗', '挘', '捌', '撈', '擄', '昮', '朸',
            '架', '枷', '椦', '橳', '氻', '沒', '泐', '泑', '渤', '湧', '澇', '牞', '狕', '珈',
            '甥', '男', '痂', '瘸', '癆', '磡', '窈', '竻', '笳', '筋', '筯', '箉', '耞', '耡',
            '耮', '肋', '脅', '脇', '舅', '艣', '艻', '苭', '茄', '荔', '荕', '莂', '莇', '葧',
            '蘍', '虜', '蚴', '蛠', '蜐', '袈', '觔', '賀', '跏', '踴', '辦', '迦', '釛', '鋤',
            '阞', '霧', '靿', '飭', '駕', '鶒', '黝',
        ],
    },
    Membership {
        radical: '卩',
        strokes: 2,
        kanji: &[
            '令', '仰', '伌', '伶', '佹', '倇', '倦', '冷', '剜', '勌', '卩', '卬', '卭', '卮',
            '卯', '印', '危', '卲', '即', '却', '卵', '卷', '卸', '卹', '卻', '卾', '卿', '厄',
            '叝', '叩', '呃', '命', '啘', '啣', '喞', '圈', '垝', '埦', '報', '堲', '夘', '婉',
            '孵', '宛', '岇', '峗', '嶺', '帵', '御', '怜', '怨', '恑', '惋', '扼', '抑', '捥',
            '掵', '昂', '昴', '晼', '服', '枙', '柳', '桅', '棬', '椀', '櫛', '氾', '泖', '涴',
            '澪', '熈', '犯', '玲', '珋', '琬', '畹', '癤', '皍', '盌', '眢', '睠', '碗', '禦',
            '笵', '箙', '節', '範', '籞', '羚', '聆', '聊', '脆', '脚', '腕', '臲', '苑', '苓',
            '范', '茆', '莭', '菀', '菔', '蛉', '蜿', '蝍', '蠞', '裷', '詭', '豌', '跪', '踋',
            '踠', '踡', '軛', '迎', '鈴', '鉚', '鋺', '阨', '零', '領', '頠', '餾', '鮠', '鯽',
            '鴒', '鴛', '鵷', '齡', '齢',
        ],
    },
    Membership {
        radical: 'マ',
        strokes: 2,
        kanji: &[
            '予', '伃', '俑', '儗', '凝', '刢', '劀', '勇', '勈', '呤', '埇', '墅', '壄', '妤',
            '姈', '婺', '岺', '序', '彾', '忬', '恿', '愑', '愗', '慂', '懋', '懝', '抒', '拎',
            '揉', '擬', '昤', '柃', '柔', '桶', '楺', '樋', '櫲', '氄', '泠', '涌', '湧', '潏',
            '澦', '猱', '獝', '璚', '瓴', '疑', '痛', '瞀', '矛', '矜', '矞', '矟', '矠', '礙',
            '秢', '竛', '笭', '筩', '糅', '紓', '繘', '舒', '舲', '芧', '葇', '蓪', '薿', '蛹',
            '蝥', '蟊', '衑', '覶', '詅', '豫', '踊', '踴', '蹂', '軨', '輮', '通', '遹', '銿',
            '鍒', '鍪', '鐍', '閝', '雺', '霚', '霱', '鞣', '預', '騖', '髳', '魣', '魿', '鱊',
        ],
    },
    Membership {
        radical: '九',
        strokes: 2,
        kanji: &[
            '丸', '九', '仇', '伜', '勢', '匭', '卆', '囈', '埶', '執', '塾', '墊', '孰', '宄',
            '尻', '忰', '抛', '摯', '旭', '枠', '染', '氿', '汍', '熟', '熱', '爇', '犱', '砕',
            '秇', '究', '笂', '粋', '紈', '紣', '縶', '翆', '艽', '芄', '蒅', '蓺', '蓻', '藝',
            '虓', '蟄', '褹', '褺', '褻', '襼', '訄', '訅', '贄', '軌', '酔', '釚', '釻', '雑',
            '馗', '駹', '驇', '髛', '鳩', '鷙', '鼽',
        ],
    },
    Membership {
        radical: '入',
        strokes: 2,
        kanji: &[
            '久', '入', '兩', '兪', '叺', '圦', '懣', '扖', '抐', '掚', '杁', '枘', '柩', '樠',
            '汭', '滿', '焫', '疚', '瘸', '瞞', '窩', '糴', '胔', '胾', '脼', '膐', '臋', '臡',
            '芮', '蜹', '蜽', '蟎', '裲', '蹣', '輛', '込', '釞', '鈉', '鏋', '镹', '陝', '顢',
            '魎', '魞', '鳰',
        ],
    },
    Membership {
        radical: 'ユ',
        strokes: 2,
        kanji: &[
            '侌', '侯', '候', '偽', '决', '刔', '叏', '堠', '夬', '峱', '廕', '快', '憨', '抉',
            '曮', '決', '炔', '為', '玦', '瘊', '癊', '睺', '矙', '筷', '篌', '糇', '緱', '缺',
            '舝', '袂', '觖', '訣', '讏', '趹', '躛', '鈌', '鍭', '餱', '駃', '鬫', '鯸', '鴂',
            '鴃',
        ],
    },
    Membership {
        radical: '乃',
        strokes: 2,
        kanji: &[
            '乃', '仍', '伋', '及', '呄', '唀', '圾', '垜', '奶', '孕', '尮', '扔', '携', '朶',
            '极', '桗', '楹', '琇', '疓', '盁', '礽', '秀', '綉', '艿', '芨', '芿', '蔿', '蜏',
            '衱', '訯', '誘', '跥', '躱', '辸', '透', '鈒', '銹', '靸', '馺', '魥', '鼐',
        ],
    },
    Membership {
        radical: '口',
        strokes: 3,
        kanji: &[
            '丣', '中', '串', '乨', '乩', '乱', '事', '亜', '亟', '亨', '享', '京', '亭', '亮',
            '亯', '亳', '亶', '亹', '仲', '估', '伵', '伺', '伽', '佀', '佋', '佑', '佔', '何',
            '佝', '佪', '佮', '佶', '佸', '使', '侃', '侗', '侞', '侶', '侷', '侻', '俁', '促',
            '俈', '俉', '俋', '俗', '俜', '保', '俣', '俰', '倁', '倉', '個', '倌', '倍', '倘',
            '倚', '倜', '倞', '倨', '倲', '倳', '倹', '偉', '偊', '偌', '做', '停', '偪', '傊',
            '傏', '傐', '傖', '傛', '傯', '傴', '僅', '僉', '像', '僐', '僑', '僓', '僖', '僘',
            '僜', '僤', '僦', '僺', '僻', '儃', '儆', '儇', '儈', '儉', '儔', '儙', '償', '儳',
            '儴', '儻', '儼', '兄', '克', '兌', '免', '兎', '兗', '兘', '党', '兢', '冋', '冎',
            '冏', '冨', '冲', '况', '冶', '冾', '凂', '凅', '凉', '凋', '减', '凒', '凛', '凜',
            '凱', '凳', '凾', '別', '刮', '剅', '剋', '剌', '剖', '剚', '剞', '剠', '剣', '剮',
            '副', '剱', '割', '剳', '剴', '創', '劀', '劈', '劊', '劍', '劒', '劔', '劖', '加',
            '劬', '劭', '劯', '劶', '劼', '勀', '勅', '勍', '勏', '勛', '勤', '勥', '勨', '勪',
            '勷', '勸', '匌', '匐', '匘', '匰', '匱', '匲', '匳', '匵', '匼', '匿', '區', '占',
            '卣', '卥', '卲', '卻', '卾', '厨', '厪', '厰', '叓', '叚', '口', '古', '句', '另',
            '叧', '叨', '叩', '只', '叫', '召', '叭', '叮', '可', '台', '叱', '史', '右', '叵',
            '叶', '号', '司', '叺', '吁', '吂', '吃', '各', '合', '吉', '吊', '吋', '同', '名',
            '后', '吏', '吐', '向', '吓', '吚', '君', '吝', '吟', '吠', '吡', '否', '吧', '吨',
            '吩', '吪', '含', '听', '吭', '吮', '启', '吱', '吴', '吵', '吶', '吸', '吹', '吻',
            '吼', '吽', '吾', '呀', '呂', '呃', '呄', '呆', '呇', '呈', '呉', '告', '呍', '呎',
            '呏', '呑', '呞', '呟', '呢', '呤', '呦', '呧', '周', '呩', '呪', '呫', '呭', '呮',
            '呰', '呱', '味', '呴', '呵', '呶', '呷', '呻', '呼', '命', '呿', '咀', '咁', '咃',
            '咄', '咅', '咆', '咈', '咉', '咋', '和', '咍', '咎', '咏', '咐', '咑', '咒', '咕',
            '咖', '咜', '咟', '咡', '咢', '咤', '咥', '咦', '咧', '咨', '咩', '咪', '咫', '咬',
            '咭', '咮', '咯', '咱', '咲', '咳', '咷', '咸', '咹', '咺', '咻', '咼', '咽', '咾',
            '咿', '哀', '品', '哂', '哄', '哆', '哇', '哈', '哉', '哊', '响', '哎', '哘', '哠',
            '員', '哢', '哥', '哦', '哨', '哩', '哪', '哬', '哭', '哮', '哯', '哲', '哶', '哺',
            '哼', '哽', '哾', '哿', '唀', '唁', '唄', '唅', '唆', '唇', '唈', '唉', '唌', '唍',
            '唎', '唏', '唐', '唔', '唕', '唖', '唪', '唫', '售', '唯', '唱', '唲', '唳', '唵',
            '唶', '唸', '唹', '唻', '唼', '唽', '唾', '啀', '啁', '啄', '啅', '商', '啇', '啉',
            '啊', '啌', '啍', '問', '啐', '啑', '啓', '啖', '啗', '啘', '啚', '啛', '啜', '啝',
            '啞', '啠', '啡', '啣', '啤', '啦', '啻', '啼', '啾', '啿', '喀', '喁', '喂', '喃',
            '善', '喆', '喇', '喈', '喉', '喊', '喋', '喎', '喏', '喑', '喒', '喓', '喔', '喗',
            '喘', '喙', '喚', '喜', '喝', '喞', '喟', '喣', '喤', '喧', '喨', '喩', '喪', '喫',
            '喬', '喭', '單', '喰', '喲', '営', '喿', '嗁', '嗃', '嗄', '嗅', '嗆', '嗇', '嗉',
            '嗋', '嗌', '嗎', '嗑', '嗒', '嗓', '嗔', '嗗', '嗘', '嗚', '嗛', '嗜', '嗞', '嗟',
            '嗢', '嗣', '嗤', '嗩', '嗶', '嗷', '嗹', '嗽', '嗾', '嗿', '嘅', '嘆', '嘈', '嘉',
            '嘊', '嘍', '嘎', '嘏', '嘐', '嘑', '嘒', '嘔', '嘖', '嘗', '嘘', '嘙', '嘛', '嘩',
            '嘬', '嘯', '嘰', '嘱', '嘲', '嘳', '嘴', '嘵', '嘶', '嘷', '嘸', '嘹', '嘻', '嘼',
            '嘽', '嘿', '噀', '噁', '噂', '噃', '噄', '噆', '噉', '噋', '噌', '噍', '噎', '噏',
            '噐', '噔', '噛', '噞', '噠', '噡', '噢', '噣', '噤', '噦', '器', '噩', '噪', '噫',
            '噬', '噭', '噯', '噱', '噲', '噴', '噵', '噸', '噺', '嚀', '嚄', '嚅', '嚆', '嚇',
            '嚈', '嚊', '嚋', '嚌', '嚏', '嚔', '嚕', '嚙', '嚚', '嚝', '嚞', '嚟', '嚠', '嚢',
            '嚥', '嚦', '嚧', '嚨', '嚩', '嚫', '嚬', '嚭', '嚮', '嚱', '嚳', '嚴', '嚶', '嚷',
            '嚼', '嚾', '囀', '囁', '囂', '囃', '囅', '囈', '囉', '囊', '囋', '囌', '囍', '囎',
            '囏', '囐', '囑', '囓', '囗', '回', '囧', '固', '圄', '國', '圍', '園', '圓', '圖',
            '圚', '圜', '坧', '坫', '坮', '坰', '坷', '垌', '垕', '垢', '垧', '埕', '域', '埠',
            '培', '埼', '堂', '堌', '堍', '堛', '堝', '堡', '堿', '塏', '塔', '塘', '塙', '塤',
            '塩', '塸', '塾', '塿', '墐', '墖', '墠', '墡', '墩', '墱', '墻', '壁', '壇', '壈',
            '壎', '壑', '壔', '壕', '壡', '壤', '壩', '壷', '壹', '壽', '夡', '奆', '奇', '奝',
            '奩', '奲', '如', '妕', '妬', '姁', '始', '姑', '姞', '姤', '姶', '娟', '娧', '娪',
            '娯', '婀', '婁', '婄', '婷', '媧', '媬', '媲', '嫆', '嫗', '嫡', '嫦', '嫩', '嬁',
            '嬉', '嬋', '嬌', '嬖', '嬗', '嬙', '嬛', '嬴', '嬾', '孁', '孃', '孰', '孼', '孽',
            '宕', '官', '客', '宭', '宮', '宲', '害', '容', '宺', '寄', '富', '寏', '寠', '寤',
            '寰', '尅', '尋', '尌', '尚', '就', '局', '居', '屙', '屢', '屨', '屩', '岠', '岢',
            '岣', '岩', '岲', '岵', '岷', '岾', '峇', '峉', '峒', '峝', '峪', '峮', '崎', '崿',
            '嵒', '嵜', '嵢', '嵩', '嵪', '嵹', '嶁', '嶇', '嶒', '嶝', '嶠', '嶮', '嶹', '巇',
            '巉', '巋', '巐', '巖', '巘', '巤', '巸', '帖', '帥', '帨', '師', '常', '幃', '幅',
            '幗', '幜', '幤', '幬', '幮', '店', '廑', '廓', '廔', '廚', '廠', '廥', '廩', '廱',
            '廻', '弇', '弡', '弨', '弴', '弶', '彁', '彄', '彈', '彠', '彧', '彫', '彭', '影',
            '徊', '徜', '徫', '忠', '忡', '怇', '怊', '怐', '怗', '怘', '怙', '怠', '怡', '怳',
            '恕', '恖', '恪', '恫', '恬', '恰', '悁', '悋', '悎', '悒', '悚', '悞', '悟', '患',
            '悤', '悥', '悦', '悪', '惆', '惇', '惉', '惊', '惑', '惝', '惹', '愇', '愊', '愍',
            '愕', '愙', '感', '愪', '愴', '愷', '愹', '慁', '慝', '慥', '慬', '慾', '憁', '憇',
            '憍', '憒', '憘', '憙', '憚', '憝', '憩', '憬', '憸', '憼', '憾', '懀', '懁', '懃',
            '懆', '懍', '懎', '懶', '懽', '懿', '戁', '戃', '戓', '或', '戜', '戢', '戧', '戫',
            '戰', '戲', '扂', '扃', '扄', '扈', '扣', '抬', '拈', '拐', '拓', '拘', '招', '括',
            '拮', '拾', '拿', '挌', '挐', '挩', '挭', '挶', '挹', '捁', '捂', '捃', '捆', '捉',
            '捌', '捐', '捒', '捛', '捨', '捭', '据', '掂', '掊', '掌', '掎', '掠', '掵', '揅',
            '揖', '揜', '損', '搞', '搥', '搪', '搭', '搵', '搶', '搿', '摑', '摘', '摚', '摟',
            '摠', '摳', '撏', '撐', '撑', '撘', '撟', '撣', '撼', '撾', '撿', '擅', '擋', '操',
            '擎', '擐', '擑', '擗', '擘', '擡', '擣', '擱', '擷', '擻', '擿', '攓', '攔', '攘',
            '攙', '攜', '攟', '攩', '攮', '故', '敔', '敕', '敞', '敦', '敧', '敬', '敲', '整',
            '敵', '數', '敺', '敽', '斂', '斕', '斝', '斫', '斲', '斳', '旖', '昫', '昭', '晌',
            '晑', '晗', '晤', '晧', '景', '晷', '智', '晾', '暐', '暟', '暠', '暱', '暵', '暻',
            '暾', '暿', '曀', '曔', '曮', '朇', '朙', '朜', '杏', '束', '枯', '枱', '枲', '枳',
            '枴', '枵', '架', '枷', '枸', '柗', '柘', '柜', '柯', '柶', '柷', '栝', '格', '桐',
            '桔', '桘', '桮', '桯', '桰', '桾', '梈', '梏', '梚', '梠', '梧', '梪', '梮', '梲',
            '棓', '棝', '棠', '棫', '棺', '椁', '椅', '椆', '椋', '椐', '検', '椥', '楅', '楉',
            '楛', '楜', '楫', '極', '榀', '榕', '榦', '榾', '榿', '槁', '槅', '槌', '槍', '槑',
            '槖', '槗', '槨', '槵', '槿', '樀', '樓', '樕', '樞', '樹', '樻', '樿', '橋', '橐',
            '橕', '橖', '橘', '橙', '橡', '橧', '橱', '橲', '橾', '檀', '檁', '檆', '檉', '檗',
            '檛', '檝', '檠', '檢', '檣', '檮', '檯', '櫃', '櫈', '櫉', '櫚', '櫜', '櫝', '櫱',
            '櫲', '櫺', '欃', '權', '欗', '欛', '欞', '欟', '欨', '欯', '欲', '欶', '欹', '歊',
            '歌', '歎', '歐', '歒', '歖', '歙', '歛', '歡', '歫', '歸', '殆', '殕', '殛', '殞',
            '殣', '殨', '殪', '殫', '殮', '殰', '毃', '毄', '毆', '毚', '毡', '毫', '氄', '氅',
            '氈', '氉', '民', '氓', '氳', '沖', '沰', '河', '治', '沼', '沽', '沾', '沿', '況',
            '泂', '泯', '洄', '洇', '洛', '洞', '洳', '活', '洽', '浞', '浥', '浧', '浩', '浯',
            '浴', '浼', '涑', '涒', '涓', '涗', '涪', '涸', '涼', '淌', '淢', '淳', '減', '渟',
            '渦', '渮', '渶', '湅', '湉', '湋', '湒', '湖', '湢', '湻', '溂', '溏', '溮', '溳',
            '溶', '滄', '滈', '滬', '滭', '滴', '滾', '漊', '漌', '漍', '漚', '漢', '漪', '漱',
            '漶', '潏', '潒', '潝', '潞', '潡', '潬', '潯', '潰', '澄', '澋', '澍', '澎', '澔',
            '澟', '澡', '澧', '澮', '澰', '澶', '澼', '濇', '濈', '濠', '濤', '濶', '濹', '瀆',
            '瀛', '瀬', '瀯', '瀲', '瀹', '瀼', '灃', '灉', '灊', '灌', '灎', '灔', '灘', '灝',
            '灞', '炤', '炯', '炱', '炴', '点', '烔', '烙', '烱', '烹', '焄', '焅', '焆', '焏',
            '焙', '焞', '煐', '煒', '煦', '照', '熅', '熇', '熔', '熙', '熚', '熟', '熯', '熰',
            '熹', '熺', '燀', '燈', '燉', '燕', '燖', '營', '燥', '燾', '爉', '爚', '爟', '爤',
            '爨', '爴', '牁', '牆', '牕', '牚', '牯', '牱', '牾', '牿', '犄', '犉', '犒', '狆',
            '狗', '狢', '狷', '猄', '猓', '猗', '猞', '猢', '猧', '猿', '獃', '獅', '獝', '獣',
            '獧', '獫', '獵', '獸', '獺', '獻', '玁', '玷', '玽', '玿', '珂', '珆', '珈', '珞',
            '珦', '珵', '珸', '珺', '珿', '琀', '琄', '琚', '琦', '琯', '琱', '瑋', '瑚', '瑢',
            '瑭', '瑲', '瑾', '璁', '璐', '璒', '璚', '璟', '璧', '璪', '璫', '璮', '璯', '環',
            '璹', '瓓', '瓘', '瓛', '瓤', '瓿', '甌', '甓', '甗', '甜', '甞', '畐', '畗', '略',
            '畧', '當', '畸', '疇', '疎', '疴', '痀', '痁', '痂', '痌', '痘', '痞', '痯', '痴',
            '痼', '痾', '瘌', '瘕', '瘡', '瘩', '瘸', '瘻', '癉', '癌', '癖', '癩', '癰', '癱',
            '登', '皓', '皚', '皜', '皷', '皽', '盅', '盎', '盒', '盬', '眗', '眙', '眠', '眮',
            '睊', '睰', '瞎', '瞠', '瞪', '瞶', '瞼', '瞽', '矞', '知', '短', '矯', '矰', '石',
            '矴', '矸', '矻', '矼', '砂', '砅', '砆', '砉', '砌', '砍', '砎', '砑', '砒', '研',
            '砕', '砝', '砠', '砡', '砢', '砣', '砥', '砦', '砧', '砭', '砮', '砰', '砲', '破',
            '砵', '砷', '砺', '砿', '硃', '硄', '硅', '硇', '硈', '硌', '硎', '硒', '硜', '硝',
            '硞', '硠', '硡', '硣', '硤', '硨', '硪', '硫', '硬', '确', '硯', '硲', '硴', '硺',
            '硼', '硾', '碁', '碆', '碇', '碊', '碌', '碍', '碎', '碏', '碑', '碓', '碔', '碕',
            '碗', '碘', '碚', '碝', '碞', '碟', '碡', '碣', '碤', '碧', '碨', '碩', '碪', '碬',
            '碭', '碯', '碰', '碱', '碲', '碳', '碵', '確', '碻', '碼', '碽', '碾', '碿', '磁',
            '磅', '磆', '磇', '磈', '磉', '磊', '磋', '磌', '磎', '磐', '磑', '磒', '磓', '磔',
            '磕', '磖', '磚', '磛', '磟', '磠', '磡', '磤', '磦', '磧', '磨', '磪', '磬', '磯',
            '磲', '磳', '磴', '磶', '磷', '磺', '磻', '磽', '磿', '礀', '礁', '礆', '礇', '礌',
            '礎', '礐', '礑', '礒', '礙', '礚', '礜', '礞', '礟', '礠', '礥', '礦', '礧', '礩',
            '礪', '礫', '礬', '礭', '礱', '礴', '礵', '祏', '祐', '祜', '祝', '祠', '祫', '祻',
            '禀', '禍', '福', '禕', '禧', '禪', '禮', '禱', '禳', '禴', '秥', '秱', '秸', '程',
            '税', '稕', '稟', '稠', '稫', '稾', '稿', '穃', '穡', '穰', '窖', '窘', '窩', '窶',
            '窹', '窻', '竆', '竒', '站', '竦', '竬', '競', '笘', '笞', '笥', '笱', '笳', '笴',
            '笿', '筈', '筎', '筒', '答', '筥', '箇', '箉', '箚', '管', '箬', '箴', '箶', '篔',
            '篖', '篙', '篩', '簂', '簄', '簉', '簌', '簍', '簑', '簓', '簔', '簣', '簥', '簦',
            '簬', '簹', '簽', '籌', '籝', '籟', '籡', '籣', '籥', '籲', '粔', '粘', '粡', '粭',
            '糊', '糖', '糙', '糦', '糩', '糫', '糵', '紹', '紿', '絅', '絇', '結', '絗', '絡',
            '給', '絧', '絮', '絹', '絻', '絽', '綂', '綌', '綗', '綢', '綧', '綰', '綹', '綺',
            '緎', '緘', '緙', '緝', '緡', '緥', '緯', '緺', '縀', '縋', '縕', '縗', '縜', '縞',
            '縷', '繒', '繕', '繘', '繟', '繢', '繥', '繯', '繰', '繾', '纁', '纆', '纈', '纕',
            '缿', '罐', '罟', '罠', '罥', '罭', '罾', '羂', '羇', '羣', '群', '羶', '羸', '翀',
            '翕', '翮', '翯', '翾', '翿', '耇', '耈', '耜', '耞', '耟', '耠', '耬', '聒', '聖',
            '聟', '聤', '聵', '胎', '胡', '胳', '胴', '脗', '脰', '脱', '脵', '腒', '腡', '腭',
            '腷', '膅', '膈', '膏', '膕', '膛', '膢', '膨', '膳', '膻', '臂', '臉', '臊', '臙',
            '臝', '臡', '臨', '臵', '臺', '興', '舌', '舍', '舎', '舏', '舐', '舒', '舓', '舔',
            '舖', '舗', '舘', '舙', '舚', '舸', '船', '艙', '艠', '艢', '艶', '艷', '苔', '苕',
            '苛', '苟', '苢', '若', '苦', '苫', '茄', '茖', '茗', '茣', '茴', '茹', '茼', '茽',
            '荅', '荳', '荷', '莂', '莒', '莔', '莕', '莙', '莟', '莬', '菅', '菇', '菏', '菟',
            '菩', '菪', '菫', '萵', '萼', '落', '葆', '葈', '葊', '葍', '葦', '葫', '葴', '葶',
            '葺', '蒒', '蒕', '蒟', '蒼', '蒿', '蓉', '蓓', '蓲', '蔀', '蔃', '蔌', '蔐', '蔔',
            '蔞', '蔥', '蕁', '蕎', '蕖', '蕗', '蕚', '蕠', '蕢', '蕺', '薀', '薔', '薗', '薛',
            '薜', '薟', '薧', '薹', '藁', '藪', '藳', '藻', '藾', '蘄', '蘍', '蘑', '蘖', '蘗',
            '蘘', '蘞', '虂', '虞', '號', '蚵', '蚷', '蛁', '蛄', '蛅', '蛒', '蛔', '蛗', '蛞',
            '蛣', '蛤', '蛻', '蜈', '蜎', '蜘', '蜩', '蜮', '蝠', '蝦', '蝲', '蝴', '蝸', '螄',
            '融', '螕', '螗', '螘', '螳', '螻', '蟈', '蟐', '蟚', '蟜', '蟢', '蟳', '蟶', '蟷',
            '蟺', '蠃', '蠉', '蠔', '蠚', '蠟', '蠧', '蠰', '蠵', '蠹', '衉', '衕', '衙', '衚',
            '衛', '衞', '衷', '袁', '袈', '袞', '袷', '袺', '袽', '裋', '裎', '裔', '裕', '裙',
            '裛', '裞', '裯', '裳', '裾', '褒', '褓', '褘', '褸', '襃', '襌', '襞', '襠', '襢',
            '襭', '襰', '襽', '覉', '覗', '覘', '覠', '覬', '覲', '覴', '觀', '觫', '觭', '觱',
            '觶', '觿', '訶', '訽', '詀', '詁', '詇', '詎', '詒', '詔', '詗', '詞', '詥', '詬',
            '詰', '話', '詷', '詺', '詻', '語', '誤', '誥', '説', '調', '諄', '諒', '諤', '諫',
            '諮', '諱', '諴', '諾', '諿', '謌', '謞', '謫', '謳', '謹', '譂', '譄', '譆', '譈',
            '證', '譎', '譞', '譟', '譣', '警', '譬', '譴', '譸', '譹', '讁', '讌', '讍', '讏',
            '讒', '讓', '讕', '讙', '讜', '讞', '谷', '谸', '谹', '谺', '谽', '谾', '谿', '豁',
            '豅', '豆', '豇', '豈', '豉', '豊', '豋', '豌', '豎', '豏', '豐', '豑', '豓', '豔',
            '象', '豪', '豫', '豭', '貂', '貉', '貙', '貛', '貴', '貺', '貼', '貽', '賀', '賂',
            '賙', '賞', '賠', '賲', '賷', '贃', '贏', '贒', '赧', '赮', '超', '趈', '趟', '趦',
            '趫', '足', '趵', '趷', '趹', '趺', '趻', '趼', '趾', '跀', '跂', '跅', '跆', '跇',
            '跈', '跊', '跋', '跌', '跎', '跏', '跑', '跔', '跕', '跖', '跗', '跙', '跚', '跛',
            '距', '跟', '跡', '跣', '跤', '跥', '跧', '跨', '跪', '跫', '跬', '路', '跰', '跱',
            '跲', '跳', '跴', '践', '跼', '跽', '跿', '踁', '踄', '踅', '踆', '踈', '踉', '踊',
            '踋', '踏', '踐', '踑', '踔', '踖', '踝', '踞', '踟', '踠', '踡', '踢', '踣', '踦',
            '踧', '踪', '踰', '踱', '踳', '踴', '踵', '踶', '踷', '踸', '踹', '踽', '蹀', '蹁',
            '蹂', '蹄', '蹇', '蹈', '蹉', '蹊', '蹋', '蹌', '蹍', '蹎', '蹏', '蹐', '蹔', '蹕',
            '蹙', '蹛', '蹜', '蹝', '蹞', '蹟', '蹠', '蹡', '蹢', '蹣', '蹤', '蹩', '蹬', '蹭',
            '蹯', '蹰', '蹱', '蹲', '蹴', '蹶', '蹹', '蹺', '蹻', '蹼', '躁', '躂', '躃', '躄',
            '躅', '躇', '躉', '躊', '躋', '躍', '躐', '躑', '躒', '躓', '躔', '躕', '躙', '躚',
            '躛', '躝', '躞', '躡', '躢', '躧', '躩', '躪', '躳', '躺', '軀', '軁', '軃', '軆',
            '軇', '軮', '軹', '軺', '軻', '輅', '輖', '輨', '輬', '輯', '輻', '轀', '轄', '轅',
            '轎', '轗', '轘', '轡', '辜', '辝', '辞', '辟', '辣', '辥', '迚', '迠', '迢', '迥',
            '迦', '迨', '迴', '迵', '追', '适', '逅', '逈', '逌', '逗', '逞', '速', '造', '逧',
            '逭', '週', '逼', '遌', '過', '遐', '違', '遠', '遣', '遦', '適', '遬', '遹', '遺',
            '避', '還', '邅', '邉', '邋', '邑', '邕', '邰', '邵', '郃', '郈', '郌', '郒', '郘',
            '郜', '郡', '郢', '郤', '部', '郭', '郶', '鄀', '鄂', '鄅', '鄖', '鄗', '鄙', '鄞',
            '鄧', '鄩', '鄯', '鄲', '鄶', '鄷', '酃', '酤', '酩', '酪', '酲', '酷', '醅', '醇',
            '醎', '醐', '醕', '醞', '醢', '醴', '醶', '醻', '醼', '醽', '釀', '釅', '釦', '鈳',
            '鈶', '鈷', '鉂', '鉆', '鉊', '鉐', '鉙', '鉛', '鉠', '鉤', '鉰', '鉻', '鉿', '銅',
            '銗', '銘', '銛', '銽', '鋀', '鋁', '鋗', '鋘', '鋙', '鋜', '鋡', '鋥', '鋭', '鋸',
            '鋿', '錞', '錡', '錧', '錮', '鍄', '鍈', '鍋', '鍔', '鍩', '鍼', '鎋', '鎔', '鎕',
            '鎗', '鎘', '鎚', '鎞', '鎧', '鎬', '鎶', '鏆', '鏉', '鏑', '鏓', '鏜', '鏤', '鏹',
            '鐈', '鐍', '鐙', '鐡', '鐱', '鐴', '鐵', '鐶', '鐺', '鑄', '鑓', '鑜', '鑭', '鑰',
            '鑱', '鑲', '鑵', '钄', '閣', '閤', '閫', '閭', '閲', '閾', '闆', '闈', '闊', '闓',
            '闘', '闙', '闟', '闠', '闡', '闢', '闤', '闦', '阜', '阽', '阿', '陪', '険', '隑',
            '隔', '隕', '隚', '隤', '隥', '隦', '險', '隯', '雊', '雒', '雕', '雖', '雚', '雝',
            '雟', '難', '霑', '霝', '霣', '霱', '露', '霹', '靈', '靊', '靠', '靣', '靧', '革',
            '靪', '靮', '靳', '靶', '靷', '靸', '靺', '靻', '靽', '靿', '鞀', '鞅', '鞉', '鞕',
            '鞖', '鞗', '鞙', '鞚', '鞞', '鞟', '鞢', '鞣', '鞬', '鞮', '鞱', '鞲', '鞳', '鞵',
            '鞶', '鞸', '鞹', '鞺', '鞼', '鞾', '鞿', '韁', '韄', '韅', '韇', '韉', '韊', '韋',
            '韌', '韍', '韎', '韐', '韑', '韓', '韔', '韗', '韘', '韙', '韛', '韜', '韝', '韞',
            '韠', '韡', '韤', '韶', '韺', '韻', '頜', '頡', '頭', '頵', '頷', '頼', '顊', '額',
            '顎', '顑', '顖', '顗', '顥', '顫', '顴', '颭', '颱', '飅', '飌', '飴', '飼', '餂',
            '餇', '餉', '餖', '餗', '餢', '館', '餬', '餹', '饇', '饉', '饋', '饍', '饎', '饐',
            '饕', '饘', '饞', '饟', '馘', '馽', '駉', '駒', '駕', '駘', '駚', '駛', '駧', '駱',
            '駵', '駽', '駾', '騎', '験', '騞', '騢', '騧', '驄', '驅', '驕', '驖', '驗', '驚',
            '驝', '驩', '骼', '髏', '體', '高', '髛', '髜', '髞', '髫', '髺', '髻', '鬍', '鬎',
            '鬙', '鬛', '鬟', '鬠', '鬪', '鬭', '鬲', '鬳', '鬴', '鬵', '鬷', '鬹', '鬺', '鬻',
            '魗', '鮉', '鮎', '鮐', '鮔', '鮖', '鮚', '鮦', '鮰', '鮸', '鯛', '鯝', '鯨', '鰊',
            '鰏', '鰐', '鰔', '鰕', '鰙', '鰤', '鱊', '鱎', '鱓', '鱔', '鱘', '鱚', '鱛', '鱞',
            '鱣', '鱨', '鱲', '鱵', '鱷', '鳴', '鴝', '鴞', '鴣', '鴰', '鴼', '鴽', '鴿', '鵅',
            '鵑', '鵠', '鵣', '鵰', '鶉', '鶒', '鶘', '鶚', '鶫', '鶬', '鶮', '鷊', '鷕', '鷗',
            '鷧', '鷮', '鷰', '鷲', '鷸', '鷺', '鸇', '鸊', '鸙', '鸛', '鹸', '鹹', '鹼', '麌',
            '麏', '麖', '麿', '黏', '黕', '點', '黟', '黠', '黤', '黥', '黧', '黨', '黬', '黭',
            '黮', '黰', '黱', '黲', '黵', '黸', '鼉', '鼓', '鼔', '鼕', '鼖', '鼗', '鼙', '鼚',
            '鼛', '鼟', '鼦', '鼫', '鼯', '齁', '齆', '齝', '齞', '齠', '齣', '齪', '齬', '齮',
            '齶', '龕', '龗', '龠', '龡', '龢', '龣', '龥',
        ],
    },
    Membership {
        radical: '土',
        strokes: 3,
        kanji: &[
            '佉', '佬', '佳', '侁', '侄', '侍', '侾', '俈', '俵', '倒', '倜', '倢', '倩', '倰',
            '偓', '傃', '傲', '債', '僅', '僓', '僥', '儎', '儬', '儹', '先', '兟', '冼', '凋',
            '凌', '凷', '刧', '到', '刲', '剉', '割', '剷', '劗', '劫', '劸', '勢', '勣', '勤',
            '卡', '卦', '却', '厓', '厔', '厫', '去', '叝', '吐', '告', '周', '呿', '咥', '哇',
            '哉', '哠', '唫', '啀', '啁', '啑', '喔', '喫', '嗇', '嗑', '嗷', '嘊', '嘖', '嘵',
            '噠', '嚇', '嚳', '囈', '囋', '囓', '囶', '圉', '圊', '園', '圛', '土', '圠', '圢',
            '圣', '圤', '圥', '圦', '圧', '在', '圩', '圪', '圬', '圭', '圮', '圯', '地', '圳',
            '圴', '圷', '圸', '圻', '圽', '圾', '圿', '址', '坂', '坅', '坆', '均', '坊', '坌',
            '坍', '坎', '坏', '坐', '坑', '坒', '坡', '坢', '坤', '坥', '坦', '坧', '坨', '坩',
            '坪', '坫', '坭', '坮', '坯', '坰', '坱', '坳', '坴', '坵', '坷', '坹', '坺', '坻',
            '坼', '坾', '坿', '垁', '垃', '垈', '垉', '型', '垌', '垓', '垔', '垕', '垗', '垙',
            '垚', '垜', '垝', '垞', '垟', '垠', '垡', '垢', '垣', '垤', '垧', '垨', '垩', '垪',
            '垬', '垰', '垳', '垸', '垽', '埀', '埃', '埆', '埇', '埈', '埋', '埌', '城', '埏',
            '埒', '埓', '埔', '埕', '埖', '埜', '埝', '埞', '域', '埠', '埡', '埣', '埤', '埦',
            '埧', '埩', '埭', '埰', '埴', '埵', '埶', '執', '埸', '培', '基', '埼', '埽', '埾',
            '埿', '堀', '堂', '堃', '堄', '堅', '堆', '堈', '堉', '堊', '堋', '堌', '堍', '堕',
            '堙', '堛', '堝', '堞', '堟', '堠', '堡', '堤', '堦', '堧', '堪', '堭', '堯', '堰',
            '報', '堲', '場', '堵', '堹', '堺', '堽', '堿', '塀', '塁', '塉', '塊', '塋', '塌',
            '塍', '塏', '塐', '塑', '塒', '塔', '塕', '塗', '塘', '塙', '塚', '塞', '塟', '塡',
            '塢', '塤', '塧', '塨', '塩', '填', '塰', '塲', '塵', '塸', '塹', '塼', '塾', '塿',
            '墀', '墁', '境', '墅', '墇', '墈', '墉', '墊', '墌', '墍', '墏', '墐', '墓', '墔',
            '墖', '増', '墜', '墝', '墟', '墠', '墡', '墢', '墦', '墨', '墩', '墫', '墮', '墱',
            '墲', '墳', '墸', '墹', '墺', '墻', '墼', '墾', '壁', '壂', '壄', '壅', '壇', '壈',
            '壊', '壌', '壍', '壎', '壐', '壑', '壒', '壓', '壔', '壕', '壖', '壗', '壘', '壙',
            '壚', '壜', '壝', '壞', '壟', '壡', '壢', '壤', '壥', '壩', '壻', '夅', '夌', '奎',
            '契', '奝', '奲', '姪', '娃', '婈', '婕', '婞', '婧', '嬈', '嬙', '室', '宯', '害',
            '寁', '寺', '封', '屆', '屋', '峙', '崁', '崕', '崖', '崚', '嶢', '嶧', '帾', '幄',
            '幇', '幘', '幫', '庄', '庢', '庤', '座', '庨', '庱', '廒', '廛', '廜', '弆', '彗',
            '彫', '彭', '径', '待', '徍', '徒', '徢', '怪', '怯', '恃', '恚', '恠', '悂', '悎',
            '悻', '惄', '情', '惆', '愫', '慠', '慥', '慳', '憲', '懃', '懌', '懎', '懴', '截',
            '戴', '抾', '拄', '持', '挂', '挃', '挈', '挫', '捁', '捏', '捨', '捱', '掕', '掛',
            '握', '搘', '摚', '撓', '撦', '撻', '擇', '擡', '攅', '攢', '敖', '斁', '時', '晆',
            '晊', '晧', '晴', '暀', '曉', '曎', '朅', '杜', '栳', '栽', '桂', '桎', '梏', '梼',
            '棈', '棱', '椆', '椡', '楔', '榁', '榯', '榸', '榼', '槿', '樫', '樹', '樾', '橈',
            '檣', '檯', '櫧', '欑', '歝', '殬', '殱', '殼', '殾', '毀', '毒', '汢', '法', '洗',
            '洙', '洼', '浩', '浬', '涅', '涛', '涬', '涯', '淕', '淩', '清', '渓', '渥', '湗',
            '湮', '溘', '漄', '漖', '漬', '潔', '澆', '澎', '澔', '澤', '濇', '濳', '濹', '瀍',
            '瀞', '灋', '灎', '灶', '炷', '烓', '烖', '烤', '焃', '焅', '煙', '熬', '熱', '燒',
            '燵', '爀', '爇', '牆', '牡', '特', '牿', '犎', '狴', '猜', '猿', '獒', '獟', '珪',
            '珵', '珽', '琱', '琺', '瑾', '瓚', '甄', '畤', '畦', '畻', '疆', '痔', '痤', '瘏',
            '瘞', '癪', '皓', '皢', '皨', '盍', '眭', '睖', '睚', '睛', '睦', '睪', '睫', '睳',
            '睾', '瞌', '瞎', '瞠', '矬', '砝', '硅', '硞', '硣', '磕', '磧', '磽', '礚', '社',
            '祛', '祷', '祾', '禊', '禋', '秩', '稑', '稜', '稠', '積', '穡', '窐', '窒', '窖',
            '窪', '竃', '竈', '筀', '筅', '等', '筠', '筳', '箐', '箑', '箲', '箼', '篈', '簀',
            '簉', '簺', '籍', '籖', '籜', '粧', '精', '糙', '素', '経', '絓', '絰', '綢', '綪',
            '綾', '緻', '縱', '縶', '績', '繊', '繞', '繹', '纆', '纎', '纏', '纒', '纘', '纛',
            '罣', '罫', '羐', '翥', '翹', '耇', '耈', '耊', '耋', '耕', '聱', '肚', '胠', '胾',
            '脚', '脞', '腟', '膛', '膣', '膨', '膮', '至', '致', '臵', '臶', '臸', '臹', '臺',
            '臻', '舎', '舗', '艢', '茎', '茬', '荎', '荖', '荰', '莛', '莝', '菁', '菫', '菱',
            '葑', '蒔', '蒨', '蓋', '蓌', '蓙', '蓺', '蓻', '蔆', '蔳', '蕏', '蕘', '薐', '薔',
            '薗', '薘', '薹', '薼', '薽', '藝', '蘀', '蛙', '蛭', '蜐', '蜓', '蜨', '蜩', '蜻',
            '螧', '螫', '螯', '螳', '蟯', '蠘', '街', '表', '袁', '袪', '袿', '裁', '裎', '裯',
            '裱', '褂', '褚', '褹', '褺', '褻', '襗', '襭', '襼', '規', '覲', '詓', '詩', '詵',
            '詿', '誟', '誥', '調', '請', '謷', '謹', '譯', '讚', '豁', '豔', '責', '賍', '賙',
            '贅', '贊', '赤', '赥', '赦', '赧', '赩', '赫', '赬', '赭', '赮', '走', '赱', '赳',
            '赴', '起', '赿', '趁', '趂', '趄', '超', '趈', '越', '趍', '趐', '趑', '趕', '趙',
            '趞', '趟', '趠', '趣', '趦', '趨', '趫', '趬', '趯', '趲', '跌', '跣', '跬', '跱',
            '跿', '踋', '踧', '踷', '蹟', '蹺', '躂', '躔', '軼', '軽', '載', '輊', '輖', '輘',
            '轄', '轅', '造', '週', '逵', '達', '遠', '遨', '遶', '邽', '郅', '郜', '郝', '鄄',
            '鄽', '酇', '酷', '醘', '醳', '釷', '銈', '銍', '銑', '銠', '銼', '鋆', '鋌', '鋳',
            '錂', '錆', '錴', '鍺', '鏊', '鏗', '鏜', '鐃', '鐡', '鐯', '鐵', '鐽', '鑽', '閨',
            '闉', '闔', '闥', '阹', '陛', '陞', '陡', '陦', '陵', '陸', '陻', '陼', '隉', '隚',
            '青', '靕', '靖', '靗', '靘', '静', '靚', '靛', '靜', '靠', '鞋', '鞺', '韃', '韯',
            '頚', '頳', '飳', '饁', '饉', '饒', '駪', '驁', '驇', '驍', '驖', '髐', '髽', '鬐',
            '鮭', '鮱', '鯐', '鯖', '鯛', '鯥', '鯪', '鯺', '鰘', '鰣', '鰪', '鰲', '鰹', '鱪',
            '鱰', '鵄', '鵠', '鵰', '鶄', '鶏', '麦', '麮', '麸', '麹', '麺', '黕', '黟', '黤',
            '黧', '黬', '黭', '黮', '黰', '黱', '黲', '黵', '黸', '鼃', '鼇', '鼱', '齧', '齷',
        ],
    },
    Membership {
        radical: '⺾',
        strokes: 3,
        kanji: &[
            '偀', '偌', '備', '僃', '僅', '僨', '儆', '儚', '儺', '冪', '剳', '募', '勤', '勱',
            '勸', '匿', '厲', '哎', '喏', '嗒', '嘆', '嘩', '噴', '嚄', '嚆', '嚾', '囈', '囌',
            '埖', '塔', '塟', '墓', '墳', '墸', '壒', '夢', '媖', '孽', '寛', '寞', '幕', '幪',
            '幭', '庿', '彠', '恾', '惹', '慌', '慕', '慝', '憊', '憤', '憼', '懂', '懃', '懜',
            '懞', '懽', '描', '搭', '搽', '摸', '擎', '擭', '攤', '敬', '暎', '暮', '暱', '曄',
            '曔', '曚', '朠', '朦', '桒', '棻', '椛', '楉', '楛', '槿', '模', '樺', '檠', '檬',
            '檴', '櫔', '欂', '權', '欗', '欟', '歎', '歡', '渮', '渶', '満', '滭', '漠', '漢',
            '漭', '濆', '濛', '濩', '瀟', '灌', '灘', '焫', '煐', '燁', '燌', '燕', '爇', '爗',
            '爟', '爤', '猫', '獏', '獖', '獦', '獲', '瑛', '瑾', '瓘', '甍', '瘩', '瘼', '癘',
            '皣', '睰', '瞄', '瞢', '瞱', '矇', '矒', '矱', '硴', '碤', '礚', '礞', '礪', '礴',
            '穫', '箬', '籆', '糀', '糒', '糚', '糢', '糲', '糵', '緢', '繭', '罐', '羃', '膜',
            '膵', '臈', '臓', '臗', '臟', '舊', '艧', '艨', '艱', '艸', '艻', '艽', '艾', '艿',
            '芀', '芁', '芃', '芄', '芇', '芉', '芊', '芋', '芍', '芎', '芑', '芒', '芔', '芖',
            '芘', '芙', '芚', '芛', '芝', '芟', '芠', '芡', '芣', '芤', '芥', '芦', '芧', '芨',
            '芩', '芪', '芫', '芬', '芭', '芮', '芯', '芰', '花', '芲', '芳', '芴', '芷', '芸',
            '芹', '芺', '芻', '芼', '芽', '芾', '芿', '苅', '苆', '苐', '苑', '苒', '苓', '苔',
            '苕', '苗', '苙', '苚', '苛', '苜', '苞', '苟', '苠', '苡', '苢', '苣', '苤', '若',
            '苦', '苧', '苨', '苪', '苫', '苭', '苯', '英', '苳', '苴', '苶', '苷', '苹', '苺',
            '苻', '苽', '苾', '茀', '茁', '茂', '范', '茄', '茅', '茆', '茇', '茈', '茉', '茊',
            '茋', '茎', '茖', '茗', '茘', '茛', '茜', '茝', '茞', '茟', '茡', '茢', '茣', '茨',
            '茫', '茬', '茭', '茮', '茯', '茰', '茱', '茲', '茳', '茴', '茵', '茶', '茷', '茸',
            '茹', '茺', '茼', '茽', '荀', '荂', '荃', '荄', '荅', '荇', '草', '荊', '荍', '荎',
            '荏', '荐', '荑', '荒', '荓', '荔', '荕', '荖', '荗', '荘', '荰', '荳', '荵', '荷',
            '荸', '荻', '荼', '荽', '荿', '莀', '莂', '莄', '莅', '莆', '莇', '莉', '莊', '莍',
            '莎', '莒', '莓', '莔', '莕', '莖', '莘', '莙', '莚', '莛', '莜', '莝', '莞', '莟',
            '莠', '莢', '莦', '莧', '莨', '莩', '莪', '莫', '莬', '莭', '莱', '莵', '莽', '莾',
            '莿', '菀', '菁', '菅', '菇', '菉', '菊', '菌', '菎', '菏', '菑', '菓', '菔', '菖',
            '菘', '菜', '菝', '菟', '菠', '菨', '菩', '菪', '菫', '華', '菰', '菱', '菲', '菴',
            '菶', '菷', '菸', '菹', '菻', '菼', '菽', '萁', '萃', '萄', '萆', '萇', '萊', '萋',
            '萌', '萍', '萎', '萏', '萑', '萓', '萕', '萙', '萠', '萢', '萩', '萪', '萬', '萯',
            '萱', '萵', '萸', '萹', '萼', '落', '葅', '葆', '葇', '葈', '葉', '葊', '葍', '葎',
            '葏', '葑', '葒', '葖', '著', '葘', '葙', '葚', '葛', '葜', '葠', '葡', '葢', '董',
            '葤', '葥', '葦', '葧', '葩', '葪', '葫', '葬', '葭', '葮', '葯', '葰', '葱', '葳',
            '葴', '葵', '葶', '葷', '葸', '葹', '葺', '葼', '葽', '蒁', '蒂', '蒄', '蒅', '蒋',
            '蒐', '蒒', '蒓', '蒔', '蒕', '蒙', '蒜', '蒞', '蒟', '蒡', '蒦', '蒨', '蒩', '蒪',
            '蒭', '蒯', '蒱', '蒲', '蒴', '蒸', '蒹', '蒺', '蒻', '蒼', '蒽', '蒾', '蒿', '蓀',
            '蓁', '蓂', '蓄', '蓆', '蓇', '蓈', '蓉', '蓊', '蓋', '蓌', '蓍', '蓏', '蓐', '蓑',
            '蓓', '蓖', '蓙', '蓚', '蓜', '蓧', '蓪', '蓬', '蓮', '蓯', '蓰', '蓱', '蓲', '蓴',
            '蓷', '蓺', '蓻', '蓼', '蓽', '蓿', '蔀', '蔂', '蔃', '蔆', '蔇', '蔌', '蔎', '蔐',
            '蔑', '蔓', '蔔', '蔕', '蔗', '蔘', '蔚', '蔜', '蔞', '蔟', '蔡', '蔢', '蔣', '蔤',
            '蔥', '蔦', '蔧', '蔪', '蔫', '蔬', '蔭', '蔯', '蔲', '蔳', '蔴', '蔵', '蔶', '蔽',
            '蔿', '蕀', '蕁', '蕃', '蕆', '蕈', '蕉', '蕊', '蕋', '蕎', '蕏', '蕐', '蕑', '蕒',
            '蕓', '蕕', '蕖', '蕗', '蕘', '蕙', '蕚', '蕜', '蕝', '蕞', '蕟', '蕠', '蕡', '蕢',
            '蕣', '蕤', '蕨', '蕩', '蕪', '蕫', '蕭', '蕯', '蕷', '蕹', '蕺', '蕻', '蕽', '蕾',
            '蕿', '薀', '薁', '薄', '薅', '薆', '薇', '薈', '薉', '薊', '薋', '薌', '薏', '薐',
            '薑', '薓', '薔', '薗', '薘', '薙', '薛', '薜', '薝', '薟', '薠', '薢', '薤', '薥',
            '薦', '薧', '薨', '薩', '薪', '薫', '薬', '薭', '薮', '薯', '薴', '薶', '薷', '薸',
            '薹', '薺', '薼', '薽', '薾', '薿', '藁', '藂', '藇', '藉', '藊', '藋', '藍', '藎',
            '藏', '藐', '藕', '藘', '藚', '藜', '藝', '藟', '藠', '藤', '藥', '藦', '藨', '藩',
            '藪', '藭', '藳', '藶', '藷', '藹', '藺', '藻', '藼', '藾', '藿', '蘀', '蘂', '蘄',
            '蘅', '蘆', '蘇', '蘊', '蘋', '蘍', '蘎', '蘐', '蘑', '蘒', '蘓', '蘖', '蘗', '蘘',
            '蘙', '蘚', '蘛', '蘞', '蘡', '蘢', '蘧', '蘩', '蘭', '蘯', '蘰', '蘶', '蘸', '蘺',
            '蘼', '蘽', '蘿', '虀', '虁', '虂', '虆', '蜹', '蟆', '蟇', '蟒', '蠆', '蠎', '蠓',
            '蠖', '蠚', '蠛', '蠣', '蠨', '衊', '襪', '襺', '襼', '襽', '覲', '觀', '誮', '諾',
            '謊', '謨', '謹', '譁', '警', '護', '讙', '豶', '貓', '貘', '貛', '賁', '躇', '躉',
            '躪', '轒', '轕', '轥', '邁', '鄀', '鄒', '鄚', '鋩', '錨', '錵', '錺', '鍈', '鍩',
            '鏌', '鐯', '鑊', '鑮', '鑵', '钄', '雘', '雚', '難', '霙', '鞳', '鞴', '鞾', '韄',
            '韈', '韉', '韊', '韛', '韡', '韤', '韮', '韺', '顴', '飌', '餝', '饉', '饙', '饛',
            '驀', '驊', '驚', '驩', '髒', '髖', '鰙', '鱝', '鶓', '鸛', '鼖',
        ],
    },
    Membership {
        radical: '大',
        strokes: 3,
        kanji: &[
            '伕', '佒', '佚', '侉', '侠', '俁', '俠', '俣', '俸', '俺', '倁', '倚', '倦', '偀',
            '偆', '偧', '偰', '傄', '傒', '僊', '僑', '僕', '僚', '僣', '儗', '儧', '儯', '儺',
            '冪', '冭', '决', '凑', '刔', '刳', '券', '剞', '剦', '劵', '勌', '勝', '募', '勪',
            '勬', '匏', '匧', '匲', '卷', '厴', '厺', '吴', '呑', '咉', '咦', '咲', '咽', '唉',
            '唪', '唳', '唵', '喚', '喫', '喬', '嗅', '嗘', '嘆', '嘹', '噢', '器', '嚈', '囏',
            '囐', '因', '圈', '圏', '坱', '垁', '埼', '堠', '堧', '塍', '墓', '墺', '大', '夨',
            '天', '太', '夫', '夬', '夭', '央', '夯', '夰', '失', '夲', '夳', '夵', '夶', '夷',
            '夸', '夾', '夿', '奃', '奄', '奆', '奇', '奈', '奉', '奎', '奏', '奐', '契', '奒',
            '奓', '奔', '奕', '套', '奘', '奙', '奚', '奛', '奝', '奞', '奟', '奠', '奡', '奢',
            '奣', '奥', '奧', '奨', '奩', '奪', '奫', '奬', '奭', '奮', '奯', '奲', '妋', '妖',
            '妷', '姨', '姱', '姻', '娭', '媋', '媖', '媵', '嫽', '嬌', '宊', '宎', '実', '寄',
            '寏', '寞', '寮', '尖', '尞', '屩', '岟', '峡', '峽', '崍', '崎', '崦', '嵜', '嵠',
            '嶛', '嶠', '嶴', '巻', '帙', '幐', '幕', '幞', '庵', '弮', '彘', '徯', '忝', '快',
            '忲', '怏', '恗', '恩', '悘', '悞', '悷', '惓', '惥', '惷', '愌', '愜', '愞', '愱',
            '慕', '慻', '憃', '憍', '憭', '懊', '懕', '懝', '懩', '戁', '戣', '戻', '扶', '抉',
            '抶', '拳', '挟', '挾', '捧', '捩', '捲', '捺', '掎', '掩', '掭', '揆', '換', '揬',
            '揳', '摏', '摸', '撟', '撦', '撩', '撲', '擌', '擪', '擲', '攀', '攁', '攅', '敧',
            '敽', '旖', '旲', '昊', '映', '春', '昦', '昳', '晻', '暌', '暎', '暙', '暤', '暮',
            '暵', '暸', '替', '朕', '朠', '杕', '枎', '枖', '栿', '桊', '桍', '梜', '棒', '棙',
            '棬', '椅', '椦', '椿', '楔', '楰', '楱', '榘', '榺', '槻', '樁', '樊', '模', '橑',
            '橪', '橳', '檿', '欵', '欹', '歎', '殀', '殃', '殗', '殠', '殹', '毉', '氤', '汏',
            '汰', '決', '沃', '沗', '泆', '泰', '泱', '洇', '洑', '洟', '洿', '浹', '涘', '涙',
            '淎', '淏', '淹', '添', '渀', '渓', '渕', '渙', '渶', '渼', '湊', '溙', '溪', '溱',
            '滕', '滲', '漛', '漠', '漢', '漪', '漭', '潜', '潦', '澳', '濮', '濽', '灘', '炴',
            '烟', '煐', '煗', '煥', '熯', '燎', '燠', '爨', '犄', '犬', '犮', '犾', '狭', '狹',
            '猋', '猒', '猗', '猤', '獃', '獏', '獒', '獘', '獠', '玞', '琦', '琫', '瑃', '瑍',
            '瑛', '瑧', '璏', '璙', '璞', '瓉', '瓛', '瓞', '瓠', '畉', '畎', '畚', '畸', '畻',
            '痍', '瘈', '瘊', '瘓', '瘞', '瘼', '療', '癱', '癸', '皋', '盎', '眷', '眹', '睠',
            '睳', '睺', '睽', '瞖', '瞭', '矢', '矤', '矦', '矪', '矬', '矯', '矰', '矱', '砆',
            '硤', '碕', '碝', '碤', '磎', '礇', '礜', '礬', '祅', '祆', '祑', '禊', '秦', '秧',
            '秩', '稧', '穙', '穾', '突', '窺', '笑', '筴', '箞', '箺', '篋', '篹', '簒', '簥',
            '籐', '籑', '籘', '粏', '糇', '糗', '糢', '紱', '絝', '絥', '絪', '綟', '綣', '綺',
            '緱', '縢', '繄', '繎', '繚', '纉', '缺', '罨', '羃', '羇', '羍', '美', '羮', '羹',
            '耎', '耷', '胭', '胯', '胰', '脵', '腌', '腠', '膎', '膜', '臡', '臭', '臻', '舂',
            '舔', '艱', '芖', '芙', '芺', '英', '茵', '荂', '荑', '莢', '莫', '莽', '莾', '菐',
            '菴', '菶', '葖', '葜', '葢', '葵', '蒺', '蒽', '蓁', '蔘', '蕎', '薁', '薿', '藤',
            '蘅', '蘙', '蚕', '蚨', '蛺', '蜯', '蜷', '蝅', '蝡', '螇', '螓', '螣', '蟆', '蟇',
            '蟒', '蟜', '蟟', '蠎', '蠜', '蠢', '蠮', '蠺', '衡', '袂', '袟', '袠', '袴', '裀',
            '裌', '裷', '襆', '襖', '襫', '襻', '覉', '規', '觭', '訞', '訣', '詇', '誇', '誒',
            '謄', '謑', '謨', '譛', '讃', '讞', '谿', '豓', '豢', '貘', '賛', '賰', '賸', '趫',
            '趺', '跌', '跨', '踡', '踦', '踳', '蹊', '蹻', '蹼', '躑', '躚', '躾', '軑', '軮',
            '軼', '輦', '輭', '輳', '轃', '轎', '轑', '达', '迭', '送', '逘', '逩', '遷', '遼',
            '郟', '鄈', '鄚', '鄭', '鄼', '醃', '醭', '釱', '鈇', '鈦', '鉃', '鉄', '鉠', '銕',
            '銙', '鋈', '鋏', '鋘', '錈', '錑', '錡', '鍈', '鍥', '鍭', '鎂', '鎹', '鏌', '鏷',
            '鐈', '鐐', '鐟', '鑚', '関', '閹', '闋', '闚', '陜', '陝', '陾', '隩', '雞', '難',
            '霙', '鞅', '鞵', '韺', '頬', '類', '颫', '飫', '餱', '餴', '饜', '馱', '駄', '駚',
            '駰', '騃', '騎', '騤', '騰', '驀', '驂', '驕', '骻', '鬈', '鬹', '鮝', '鮧', '鮬',
            '鮲', '鯵', '鯸', '鰆', '鰧', '鱎', '鴃', '鴦', '鴺', '鵊', '鵪', '鶏', '鶪', '鷄',
            '鷖', '鷞', '鷟', '鷮', '鷯', '鸂', '鸑', '麌', '麩', '麸', '黤', '黱', '鼷', '齅',
            '齮', '龑',
        ],
    },
    Membership {
        radical: '小',
        strokes: 3,
        kanji: &[
            '乿', '京', '亰', '仯', '伱', '佘', '余', '你', '係', '俆', '俏', '俶', '倘', '倞',
            '倧', '偗', '傃', '傆', '傺', '僄', '僘', '僚', '僦', '儭', '儸', '冸', '凉', '凛',
            '剠', '剽', '劣', '勍', '勡', '勬', '原', '厵', '叔', '叞', '吵', '呩', '喲', '嗉',
            '嗩', '嘹', '噄', '噤', '嚩', '嚫', '嚬', '囉', '圝', '塐', '夵', '奈', '妙', '妳',
            '娑', '婌', '嫄', '嫖', '嫽', '嬪', '孌', '孫', '孮', '孿', '宗', '寂', '察', '寮',
            '寳', '寴', '尉', '小', '少', '尓', '尖', '尗', '尞', '尟', '尠', '就', '崇', '嶛',
            '巒', '幖', '幜', '弥', '弶', '彎', '彝', '彯', '影', '徏', '徖', '徜', '徱', '徽',
            '悆', '您', '悰', '惄', '惊', '惝', '愫', '愿', '慓', '慰', '慼', '憬', '憭', '懸',
            '戀', '戚', '抄', '挘', '捎', '捗', '捺', '掠', '搽', '摋', '摽', '撩', '擦', '擯',
            '攞', '攣', '敍', '敘', '斃', '斎', '景', '晾', '暸', '暻', '暼', '曫', '杪', '柰',
            '桫', '棕', '椋', '椒', '榡', '槭', '樏', '標', '樤', '橑', '檫', '檰', '檳', '櫞',
            '櫬', '欏', '欒', '款', '歩', '歳', '殯', '毟', '毮', '沙', '涂', '涼', '淑', '淙',
            '渉', '渺', '渻', '源', '滁', '漂', '漈', '漯', '潔', '潦', '澋', '澵', '濊', '濰',
            '濱', '瀕', '瀠', '灝', '灣', '灤', '炒', '焇', '熛', '熨', '燎', '狳', '猄', '猻',
            '獠', '獩', '玀', '玅', '珎', '琮', '璙', '璟', '瓢', '畭', '痟', '痧', '瘭', '瘰',
            '瘵', '療', '癴', '省', '眇', '県', '眎', '督', '瞟', '瞭', '矕', '砂', '磦', '示',
            '祘', '祟', '祢', '票', '祭', '禀', '禁', '禜', '禦', '秒', '称', '稌', '穄', '穆',
            '穢', '筲', '箵', '篨', '籘', '籮', '粆', '粽', '糸', '糺', '系', '糾', '紀', '紂',
            '紃', '約', '紅', '紆', '紇', '紈', '紉', '紊', '紋', '納', '紏', '紐', '紑', '紒',
            '紓', '純', '紕', '紖', '紗', '紘', '紙', '級', '紛', '紜', '紝', '紞', '素', '紡',
            '索', '紣', '紦', '紪', '紫', '紬', '紭', '紮', '累', '細', '紱', '紲', '紳', '紵',
            '紹', '紺', '紼', '紽', '紾', '紿', '絀', '絁', '終', '絃', '組', '絅', '絆', '絇',
            '絈', '絋', '経', '絍', '絎', '絏', '結', '絑', '絓', '絖', '絗', '絙', '絚', '絛',
            '絜', '絝', '絞', '絡', '絢', '絣', '絥', '給', '絧', '絨', '絪', '絮', '絰', '統',
            '絲', '絳', '絵', '絶', '絸', '絹', '絺', '絻', '絽', '絿', '綁', '綂', '綃', '綅',
            '綆', '綈', '綉', '綋', '綌', '綍', '綏', '綑', '經', '綖', '綗', '継', '続', '綛',
            '綜', '綝', '綞', '綟', '綢', '綣', '綦', '綧', '綪', '綫', '綬', '維', '綮', '綯',
            '綰', '綱', '網', '綳', '綴', '綵', '綶', '綷', '綸', '綹', '綺', '綻', '綽', '綾',
            '綿', '緂', '緃', '緄', '緅', '緆', '緇', '緊', '緋', '緌', '緍', '緎', '総', '緑',
            '緒', '緕', '緗', '緘', '緙', '線', '緜', '緝', '緞', '締', '緡', '緢', '緤', '緥',
            '緦', '編', '緩', '緪', '緫', '緬', '緭', '緯', '緱', '緲', '練', '緵', '緶', '緹',
            '緺', '緻', '縀', '縁', '縄', '縅', '縈', '縉', '縊', '縋', '縐', '縑', '縒', '縕',
            '縗', '縛', '縜', '縝', '縞', '縟', '縠', '縡', '縢', '縣', '縦', '縧', '縨', '縫',
            '縬', '縭', '縮', '縯', '縱', '縲', '縳', '縵', '縶', '縷', '縹', '縺', '縻', '總',
            '績', '縿', '繁', '繃', '繄', '繅', '繆', '繇', '繊', '繋', '繍', '繎', '繐', '繒',
            '織', '繕', '繖', '繘', '繙', '繚', '繝', '繞', '繟', '繡', '繢', '繥', '繦', '繧',
            '繩', '繪', '繫', '繭', '繮', '繯', '繰', '繳', '繸', '繹', '繻', '繼', '繽', '繾',
            '繿', '纁', '纂', '纃', '纆', '纇', '纈', '纉', '纊', '續', '纍', '纎', '纏', '纐',
            '纑', '纒', '纓', '纔', '纕', '纖', '纘', '纚', '纛', '纜', '纝', '纞', '羂', '羅',
            '翲', '翽', '耖', '膆', '膘', '臠', '艅', '苶', '茮', '荼', '莎', '菽', '葒', '葤',
            '葯', '蒓', '蒜', '蓀', '蓧', '蔂', '蔚', '蔡', '蕝', '蕠', '薉', '薸', '蘊', '蘋',
            '蘩', '蘰', '蘿', '虆', '虩', '蜍', '螈', '螱', '螵', '螺', '蟟', '蠙', '蠻', '袮',
            '裟', '褒', '褾', '襟', '襺', '覍', '觘', '訬', '諒', '諔', '謜', '變', '賓', '賖',
            '賨', '趂', '踄', '踧', '踪', '蹙', '蹴', '輬', '轑', '轡', '辮', '迩', '遜', '遼',
            '邎', '邏', '酴', '醿', '釥', '鈔', '鉨', '鉩', '銯', '錝', '鍄', '鎍', '鎩', '鏍',
            '鏢', '鐐', '鑌', '鑼', '鑾', '陟', '隙', '際', '隲', '隷', '隸', '雀', '霨', '頴',
            '頻', '願', '顣', '顥', '顪', '顰', '飃', '飄', '饠', '騌', '騭', '騵', '騾', '驃',
            '髕', '髿', '鬃', '鬢', '魈', '魦', '鯀', '鯊', '鯨', '鰶', '鰷', '鰾', '鶎', '鷥',
            '鷯', '鷲', '鸞', '麖', '麨', '黥', '鼈', '齋', '齽', '龒',
        ],
    },
    Membership {
        radical: '⺡',
        strokes: 3,
        kanji: &[
            '匯', '嘙', '垽', '埿', '塗', '塰', '壍', '奫', '娑', '婆', '寖', '惉', '愆', '慂',
            '懣', '柒', '染', '桫', '梁', '樑', '欂', '氵', '氻', '氾', '氿', '汀', '汁', '汊',
            '汋', '汍', '汎', '汏', '汐', '汒', '汔', '汕', '汗', '汙', '汚', '汛', '汜', '汝',
            '江', '池', '汢', '汧', '汨', '汪', '汫', '汭', '汯', '汰', '汲', '汳', '汴', '汶',
            '汸', '汹', '決', '汻', '汽', '汾', '沁', '沂', '沃', '沅', '沆', '沇', '沈', '沉',
            '沌', '沍', '沐', '沒', '沔', '沕', '沖', '沘', '沙', '沚', '沛', '沜', '沟', '没',
            '沢', '沫', '沮', '沰', '沱', '沲', '河', '沴', '沸', '油', '沺', '治', '沼', '沽',
            '沾', '沿', '況', '泂', '泄', '泅', '泆', '泊', '泌', '泍', '泏', '泐', '泑', '泒',
            '泓', '泔', '法', '泖', '泗', '泙', '泚', '泛', '泜', '泝', '泠', '泡', '波', '泣',
            '泥', '泧', '注', '泩', '泪', '泫', '泬', '泮', '泯', '泱', '泲', '泳', '洄', '洇',
            '洊', '洋', '洌', '洎', '洏', '洑', '洒', '洓', '洗', '洙', '洚', '洛', '洞', '洟',
            '津', '洦', '洧', '洨', '洩', '洪', '洫', '洮', '洱', '洲', '洳', '洵', '洶', '洸',
            '洹', '活', '洼', '洽', '派', '洿', '流', '浄', '浅', '浗', '浙', '浚', '浜', '浞',
            '浟', '浡', '浣', '浤', '浥', '浦', '浧', '浩', '浪', '浬', '浮', '浯', '浰', '浴',
            '海', '浸', '浹', '浼', '涂', '涅', '涇', '消', '涌', '涎', '涑', '涒', '涓', '涔',
            '涕', '涖', '涗', '涘', '涙', '涛', '涜', '涪', '涬', '涯', '液', '涴', '涵', '涷',
            '涸', '涹', '涼', '涽', '涿', '淀', '淄', '淅', '淆', '淇', '淈', '淊', '淋', '淌',
            '淎', '淏', '淑', '淒', '淕', '淖', '淘', '淙', '淛', '淝', '淞', '淟', '淠', '淡',
            '淢', '淤', '淥', '淦', '淨', '淩', '淪', '淫', '淬', '淮', '淯', '淰', '深', '淳',
            '淴', '淵', '淶', '混', '淹', '淺', '添', '渀', '渄', '清', '渇', '済', '渉', '渊',
            '渋', '渓', '渕', '渙', '渚', '減', '渝', '渞', '渟', '渠', '渡', '渢', '渣', '渤',
            '渥', '渦', '渧', '温', '渫', '測', '渭', '渮', '港', '渲', '渶', '游', '渹', '渺',
            '渻', '渼', '渾', '湃', '湄', '湅', '湈', '湉', '湊', '湋', '湍', '湎', '湏', '湑',
            '湒', '湓', '湔', '湖', '湗', '湘', '湛', '湜', '湝', '湞', '湟', '湢', '湣', '湧',
            '湨', '湫', '湮', '湯', '湲', '湳', '湶', '湻', '湽', '湾', '湿', '満', '溂', '溌',
            '溍', '溏', '源', '溓', '準', '溘', '溙', '溜', '溝', '溟', '溠', '溢', '溥', '溧',
            '溪', '溭', '溮', '溯', '溱', '溲', '溳', '溶', '溷', '溺', '溻', '溽', '溿', '滀',
            '滁', '滂', '滃', '滄', '滅', '滇', '滈', '滉', '滊', '滋', '滌', '滍', '滏', '滑',
            '滓', '滔', '滝', '滞', '滫', '滬', '滭', '滮', '滯', '滲', '滴', '滷', '滸', '滹',
            '滻', '滽', '滾', '滿', '漁', '漂', '漄', '漆', '漈', '漉', '漊', '漌', '漍', '漏',
            '漑', '漓', '演', '漕', '漖', '漘', '漚', '漛', '漠', '漢', '漣', '漩', '漪', '漫',
            '漬', '漭', '漯', '漰', '漱', '漲', '漳', '漶', '漸', '漻', '漼', '漾', '潅', '潏',
            '潑', '潒', '潓', '潔', '潗', '潘', '潙', '潚', '潛', '潜', '潝', '潞', '潟', '潡',
            '潢', '潤', '潦', '潨', '潬', '潭', '潮', '潯', '潰', '潴', '潸', '潺', '潼', '潽',
            '潾', '澀', '澁', '澂', '澄', '澆', '澇', '澈', '澋', '澌', '澍', '澎', '澐', '澑',
            '澒', '澓', '澔', '澖', '澗', '澚', '澟', '澠', '澡', '澣', '澤', '澥', '澦', '澧',
            '澨', '澪', '澮', '澯', '澰', '澱', '澳', '澵', '澶', '澹', '澼', '激', '濁', '濂',
            '濃', '濅', '濆', '濇', '濈', '濊', '濔', '濕', '濘', '濚', '濛', '濞', '濟', '濠',
            '濡', '濤', '濨', '濩', '濫', '濬', '濮', '濯', '濰', '濱', '濳', '濵', '濶', '濹',
            '濺', '濼', '濽', '濾', '瀀', '瀁', '瀅', '瀆', '瀇', '瀉', '瀋', '瀍', '瀏', '瀑',
            '瀕', '瀗', '瀘', '瀚', '瀛', '瀝', '瀞', '瀟', '瀠', '瀣', '瀦', '瀧', '瀬', '瀯',
            '瀰', '瀲', '瀴', '瀷', '瀹', '瀼', '瀾', '灃', '灄', '灈', '灉', '灊', '灋', '灌',
            '灎', '灑', '灔', '灕', '灘', '灝', '灞', '灣', '灤', '燙', '琺', '痧', '盜', '盪',
            '碆', '磲', '礴', '窪', '笵', '箔', '箥', '箲', '篊', '簗', '簿', '籓', '粱', '羨',
            '范', '茫', '茳', '莎', '菏', '菠', '菹', '萍', '萢', '落', '葏', '蒅', '蒞', '蒲',
            '蓱', '蔆', '蔢', '蔳', '蕖', '蕩', '薀', '薄', '薓', '薸', '藩', '藻', '蘯', '衍',
            '裟', '酒', '鋈', '鎏', '鑮', '闊', '霂', '霃', '霈', '霑', '霪', '髿', '鯊', '鴻',
            '鸂',
        ],
    },
    Membership {
        radical: '幺',
        strokes: 3,
        kanji: &[
            '乣', '乿', '侅', '係', '傃', '傒', '僟', '儸', '勬', '卛', '呟', '呦', '喲', '嗉',
            '嗘', '嗞', '嘰', '噄', '嚩', '嚮', '囉', '圝', '坳', '塐', '壅', '奒', '奚', '姟',
            '孌', '孫', '孳', '孿', '嵠', '巒', '幺', '幻', '幼', '幽', '幾', '弦', '彎', '彝',
            '後', '徯', '徽', '愫', '慈', '慉', '懸', '戀', '拗', '搐', '摔', '擁', '擽', '攞',
            '攣', '斷', '昡', '曏', '曫', '榡', '樂', '樏', '機', '檰', '櫞', '櫟', '欏', '欒',
            '欬', '氦', '泑', '泫', '溪', '滀', '滋', '漯', '潔', '濕', '濨', '濰', '濼', '瀠',
            '灣', '灤', '炫', '狕', '猻', '玀', '玄', '玅', '玆', '率', '玹', '璣', '甆', '甕',
            '畜', '畡', '畿', '痃', '痎', '瘰', '癕', '癴', '皪', '眩', '矕', '磁', '磎', '磯',
            '礠', '禌', '禨', '稵', '稸', '穖', '窈', '籘', '籮', '糍', '糸', '糺', '系', '糾',
            '紀', '紂', '紃', '約', '紅', '紆', '紇', '紈', '紉', '紊', '紋', '納', '紏', '紐',
            '紑', '紒', '紓', '純', '紕', '紖', '紗', '紘', '紙', '級', '紛', '紜', '紝', '紞',
            '素', '紡', '索', '紣', '紦', '紪', '紫', '紬', '紭', '紮', '累', '細', '紱', '紲',
            '紳', '紵', '紹', '紺', '紼', '紽', '紾', '紿', '絀', '絁', '終', '絃', '組', '絅',
            '絆', '絇', '絈', '絋', '経', '絍', '絎', '絏', '結', '絑', '絓', '絖', '絗', '絙',
            '絚', '絛', '絜', '絝', '絞', '絡', '絢', '絣', '絥', '給', '絧', '絨', '絪', '絮',
            '絰', '統', '絲', '絳', '絵', '絶', '絸', '絹', '絺', '絻', '絽', '絿', '綁', '綂',
            '綃', '綅', '綆', '綈', '綉', '綋', '綌', '綍', '綏', '綑', '經', '綖', '綗', '継',
            '続', '綛', '綜', '綝', '綞', '綟', '綢', '綣', '綦', '綧', '綪', '綫', '綬', '維',
            '綮', '綯', '綰', '綱', '網', '綳', '綴', '綵', '綶', '綷', '綸', '綹', '綺', '綻',
            '綽', '綾', '綿', '緂', '緃', '緄', '緅', '緆', '緇', '緊', '緋', '緌', '緍', '緎',
            '総', '緑', '緒', '緕', '緗', '緘', '緙', '線', '緜', '緝', '緞', '締', '緡', '緢',
            '緤', '緥', '緦', '編', '緩', '緪', '緫', '緬', '緭', '緯', '緱', '緲', '練', '緵',
            '緶', '緹', '緺', '緻', '縀', '縁', '縄', '縅', '縈', '縉', '縊', '縋', '縐', '縑',
            '縒', '縕', '縗', '縛', '縜', '縝', '縞', '縟', '縠', '縡', '縢', '縣', '縦', '縧',
            '縨', '縫', '縬', '縭', '縮', '縯', '縱', '縲', '縳', '縵', '縶', '縷', '縹', '縺',
            '縻', '總', '績', '縿', '繁', '繃', '繄', '繅', '繆', '繇', '繊', '繋', '繍', '繎',
            '繐', '繒', '織', '繕', '繖', '繘', '繙', '繚', '繝', '繞', '繟', '繡', '繢', '繥',
            '繦', '繧', '繩', '繪', '繫', '繭', '繮', '繯', '繰', '繳', '繸', '繹', '繻', '繼',
            '繽', '繾', '繿', '纁', '纂', '纃', '纆', '纇', '纈', '纉', '纊', '續', '纍', '纎',
            '纏', '纐', '纑', '纒', '纓', '纔', '纕', '纖', '纘', '纚', '纛', '纜', '纝', '纞',
            '羂', '羅', '聨', '聯', '胘', '胤', '胲', '膆', '膎', '臃', '臠', '舷', '苭', '茲',
            '荄', '葒', '葤', '葯', '蒓', '蓀', '蓄', '蔂', '蕝', '蕠', '蕹', '薌', '藥', '蘊',
            '蘩', '蘰', '蘿', '虆', '蚴', '蚿', '螆', '螇', '螺', '蟀', '蟣', '蠁', '蠻', '衒',
            '袨', '襺', '詃', '謑', '譏', '變', '谿', '賅', '蹊', '躒', '轡', '辮', '遜', '邎',
            '邏', '郷', '鄐', '酳', '醿', '鉉', '銯', '鎍', '鎡', '鏍', '鐖', '鑼', '鑾', '閡',
            '關', '陔', '隰', '雍', '雞', '靿', '鞵', '鞿', '韅', '響', '頦', '顯', '饑', '饔',
            '饗', '饠', '騾', '魕', '鯀', '鰦', '鱜', '鶿', '鷄', '鷥', '鸂', '鸞', '麼', '黝',
            '鼷',
        ],
    },
    Membership {
        radical: '扌',
        strokes: 3,
        kanji: &[
            '咑', '哲', '啦', '娎', '嶊', '庪', '悊', '扌', '扎', '扐', '扑', '扒', '打', '扔',
            '払', '扖', '托', '扚', '扛', '扜', '扞', '扠', '扣', '扤', '扨', '扭', '扮', '扯',
            '扱', '扳', '扶', '批', '扺', '扼', '扽', '找', '技', '抂', '抃', '抄', '抉', '把',
            '抍', '抎', '抏', '抐', '抑', '抒', '抓', '抔', '投', '抖', '抗', '折', '抛', '抜',
            '択', '抦', '抨', '披', '抬', '抱', '抳', '抵', '抶', '抷', '抹', '抺', '抻', '押',
            '抽', '抾', '抿', '拂', '拄', '担', '拆', '拇', '拈', '拉', '拊', '拌', '拍', '拎',
            '拐', '拑', '拒', '拓', '拔', '拕', '拖', '拗', '拘', '拙', '拚', '招', '拜', '拝',
            '拠', '拡', '拪', '括', '拭', '拮', '拯', '拱', '拴', '拵', '拶', '拷', '拼', '拽',
            '拾', '持', '挂', '挃', '挄', '指', '按', '挊', '挋', '挌', '挍', '挑', '挓', '挖',
            '挘', '挟', '挧', '挨', '挩', '挪', '挫', '挭', '振', '挵', '挶', '挹', '挺', '挼',
            '挽', '挾', '挿', '捁', '捂', '捃', '捄', '捆', '捉', '捊', '捋', '捌', '捍', '捎',
            '捏', '捐', '捒', '捓', '捔', '捕', '捗', '捘', '捛', '捜', '捥', '捦', '捧', '捨',
            '捩', '捫', '捬', '捭', '据', '捱', '捲', '捴', '捵', '捶', '捷', '捸', '捺', '捻',
            '捼', '捽', '捿', '掀', '掂', '掃', '掄', '掇', '授', '掉', '掊', '掎', '掏', '掐',
            '排', '掕', '掖', '掘', '掙', '掚', '掛', '掞', '掟', '掠', '採', '探', '掤', '接',
            '掦', '控', '推', '掩', '措', '掫', '掬', '掭', '掮', '掯', '掲', '掴', '掵', '掻',
            '掽', '掾', '揀', '揁', '揃', '揄', '揆', '揈', '揉', '揎', '描', '提', '揑', '插',
            '揓', '揔', '揕', '揖', '揚', '換', '揜', '揠', '握', '揣', '揥', '揩', '揪', '揬',
            '揮', '揲', '揳', '援', '揵', '揶', '揸', '揹', '揺', '搆', '搉', '搊', '損', '搏',
            '搐', '搒', '搓', '搔', '搖', '搗', '搘', '搜', '搞', '搠', '搢', '搤', '搥', '搦',
            '搨', '搩', '搪', '搬', '搭', '搯', '搰', '搵', '搶', '携', '搽', '搾', '摂', '摋',
            '摎', '摏', '摑', '摒', '摓', '摔', '摘', '摚', '摛', '摜', '摝', '摟', '摠', '摡',
            '摣', '摧', '摭', '摳', '摴', '摶', '摸', '摺', '摻', '摽', '撅', '撇', '撈', '撏',
            '撐', '撑', '撒', '撓', '撕', '撘', '撙', '撚', '撛', '撝', '撞', '撟', '撡', '撣',
            '撤', '撥', '撦', '撨', '撩', '撫', '撬', '播', '撮', '撰', '撲', '撳', '撹', '撻',
            '撼', '撽', '撾', '撿', '擁', '擂', '擄', '擅', '擇', '擉', '擋', '擌', '操', '擐',
            '擑', '擒', '擔', '擕', '擗', '據', '擠', '擡', '擢', '擣', '擤', '擦', '擩', '擬',
            '擭', '擯', '擰', '擱', '擲', '擴', '擵', '擶', '擷', '擺', '擻', '擽', '擾', '擿',
            '攁', '攄', '攅', '攈', '攉', '攊', '攏', '攓', '攔', '攖', '攘', '攙', '攛', '攜',
            '攝', '攞', '攟', '攢', '攤', '攦', '攩', '攪', '攫', '攬', '攮', '晢', '毮', '浙',
            '湃', '狾', '箉', '箍', '箝', '篺', '簎', '籀', '籒', '籜', '籡', '菝', '蒱', '蓷',
            '蘀', '蜇', '誓', '踅', '逝', '鋬',
        ],
    },
    Membership {
        radical: '宀',
        strokes: 3,
        kanji: &[
            '佇', '佗', '侒', '侘', '俒', '倇', '倌', '倥', '倧', '傛', '傢', '儐', '儜', '剜',
            '割', '叠', '咜', '咤', '咹', '唍', '啌', '啘', '喀', '喧', '嚀', '坨', '坹', '坾',
            '垞', '垨', '垸', '埞', '埦', '塞', '夤', '姲', '婉', '嫁', '嫆', '嬪', '嬸', '字',
            '孮', '宀', '宁', '它', '宄', '宅', '宆', '宇', '守', '安', '宊', '宋', '完', '宍',
            '宎', '宏', '宐', '宑', '宓', '宔', '宕', '宖', '宗', '官', '宙', '定', '宛', '宜',
            '宝', '実', '客', '宣', '室', '宥', '宦', '宨', '宩', '宬', '宭', '宮', '宯', '宰',
            '宱', '宲', '害', '宴', '宵', '家', '宷', '宸', '容', '宺', '宼', '宿', '寀', '寁',
            '寂', '寃', '寄', '寅', '密', '寇', '寉', '富', '寍', '寏', '寐', '寒', '寓', '寔',
            '寖', '寗', '寙', '寚', '寛', '寝', '寞', '察', '寠', '寡', '寢', '寤', '寥', '實',
            '寧', '寨', '審', '寫', '寮', '寯', '寰', '寱', '寳', '寴', '寵', '寶', '崆', '崇',
            '帘', '帵', '幰', '弿', '彍', '徖', '悰', '悾', '惋', '愃', '愙', '愹', '憲', '懧',
            '拕', '按', '挓', '挖', '捥', '掟', '控', '揎', '揬', '搴', '搾', '擦', '擯', '擰',
            '攓', '攛', '晏', '晼', '暄', '曌', '柁', '案', '梡', '梥', '棕', '棺', '椀', '椗',
            '楦', '榁', '榕', '榨', '樒', '檫', '檳', '檸', '櫁', '殯', '氎', '氨', '沱', '泬',
            '浣', '浤', '涴', '淀', '淙', '渲', '溶', '滓', '演', '濅', '濘', '濱', '濵', '瀉',
            '瀋', '瀗', '灾', '煊', '熔', '牢', '牸', '狖', '狩', '獰', '獱', '琬', '琮', '琯',
            '瑄', '瑢', '甯', '畹', '疉', '痯', '皖', '睆', '瞎', '瞚', '瞾', '矃', '矉', '砣',
            '硡', '碇', '碗', '確', '稼', '穃', '穴', '穵', '究', '穸', '穹', '空', '穽', '穾',
            '穿', '窀', '突', '窂', '窃', '窄', '窅', '窆', '窈', '窊', '窋', '窐', '窑', '窒',
            '窓', '窔', '窕', '窖', '窗', '窘', '窞', '窟', '窠', '窣', '窩', '窪', '窬', '窮',
            '窯', '窰', '窳', '窵', '窶', '窹', '窺', '窻', '窼', '窿', '竃', '竄', '竅', '竆',
            '竇', '竈', '竉', '竊', '竚', '竩', '筦', '箜', '管', '簆', '籩', '粽', '糘', '紵',
            '紽', '綋', '綜', '綰', '綻', '縡', '縮', '縯', '繽', '羜', '羦', '聢', '聹', '胺',
            '脘', '腔', '腕', '腟', '膣', '臏', '臗', '臱', '舘', '舵', '苧', '茡', '莞', '菀',
            '菅', '菪', '萓', '萱', '葖', '蓉', '蓿', '蔤', '蔲', '薴', '藭', '藼', '蛇', '蜜',
            '蜿', '螾', '蠙', '褰', '詑', '詝', '詫', '誼', '諚', '諠', '謇', '讅', '谾', '豁',
            '豌', '貯', '賓', '賨', '賽', '跎', '踠', '踪', '蹇', '蹜', '躻', '輐', '輨', '轄',
            '迱', '逭', '邃', '邊', '酡', '酧', '鉈', '銨', '鋎', '鋐', '鋺', '錝', '錠', '錧',
            '鎋', '鎔', '鎵', '鏥', '鑌', '陀', '院', '靛', '鞍', '鞚', '頞', '額', '館', '駝',
            '騌', '騫', '髕', '髖', '鬃', '鬢', '鮀', '鮟', '鯇', '鰘', '鰚', '鴕', '鴪', '鴳',
            '鵷', '鵼', '鶎', '鶱', '鶴', '鷃', '鼹',
        ],
    },
    Membership {
        radical: '女',
        strokes: 3,
        kanji: &[
            '伮', '佞', '侒', '侞', '侫', '俀', '倭', '偃', '偠', '僂', '凄', '努', '匽', '呶',
            '咹', '唼', '啛', '喓', '嘍', '嘙', '嚶', '囡', '堰', '塿', '女', '奴', '奵', '奶',
            '奸', '她', '奻', '奼', '好', '妁', '如', '妃', '妄', '妊', '妋', '妌', '妍', '妎',
            '妒', '妓', '妕', '妖', '妗', '妙', '妛', '妝', '妟', '妣', '妤', '妥', '妧', '妨',
            '妬', '妭', '妮', '妯', '妰', '妲', '妳', '妷', '妹', '妺', '妻', '妼', '妾', '姁',
            '姃', '姄', '姆', '姈', '姉', '姊', '始', '姍', '姐', '姑', '姒', '姓', '委', '姙',
            '姚', '姜', '姞', '姟', '姣', '姤', '姥', '姦', '姧', '姨', '姪', '姫', '姮', '姯',
            '姱', '姲', '姴', '姶', '姷', '姻', '姿', '娀', '威', '娃', '娄', '娉', '娌', '娍',
            '娎', '娑', '娒', '娓', '娘', '娚', '娜', '娞', '娟', '娠', '娣', '娤', '娥', '娧',
            '娨', '娩', '娪', '娭', '娯', '娰', '娵', '娶', '娼', '婀', '婁', '婄', '婅', '婆',
            '婇', '婈', '婉', '婌', '婐', '婕', '婚', '婞', '婢', '婣', '婥', '婦', '婧', '婪',
            '婬', '婭', '婷', '婺', '婻', '婾', '婿', '媋', '媐', '媒', '媓', '媖', '媙', '媚',
            '媛', '媜', '媞', '媟', '媠', '媢', '媧', '媬', '媱', '媲', '媳', '媵', '媸', '媺',
            '媻', '媼', '媽', '媾', '媿', '嫁', '嫂', '嫄', '嫆', '嫈', '嫉', '嫋', '嫌', '嫏',
            '嫐', '嫖', '嫗', '嫚', '嫜', '嫠', '嫡', '嫣', '嫥', '嫦', '嫩', '嫪', '嫮', '嫵',
            '嫶', '嫺', '嫻', '嫽', '嬀', '嬁', '嬈', '嬉', '嬋', '嬌', '嬖', '嬗', '嬙', '嬛',
            '嬝', '嬡', '嬢', '嬥', '嬪', '嬬', '嬭', '嬰', '嬲', '嬴', '嬶', '嬸', '嬾', '孀',
            '孁', '孃', '孅', '孋', '孌', '孥', '孾', '安', '宴', '宼', '寠', '屡', '屢', '屨',
            '崣', '崴', '嶁', '巍', '帑', '廔', '弩', '怒', '怓', '恕', '悽', '拏', '按', '挐',
            '挼', '捼', '捿', '接', '揠', '摟', '擻', '攖', '数', '數', '晏', '案', '桜', '桵',
            '棲', '椄', '椻', '楲', '楼', '樓', '櫻', '氨', '汝', '洳', '涹', '淒', '漊', '瀛',
            '瀴', '珱', '瓔', '痿', '瘻', '癭', '矮', '砮', '窶', '笯', '筎', '簍', '籔', '籝',
            '籹', '絮', '綏', '緌', '縅', '縷', '纓', '翣', '耍', '耬', '胺', '腇', '腰', '膢',
            '茹', '荽', '菇', '菨', '萋', '萎', '葳', '葽', '蔞', '蔢', '蕠', '薅', '薮', '藪',
            '蘡', '蘶', '蜲', '蝘', '螻', '袽', '褄', '褸', '要', '詉', '諉', '軁', '逶', '郾',
            '釹', '銨', '鏤', '隁', '霎', '鞍', '鞖', '頞', '餒', '餧', '駑', '髏', '魏', '鮟',
            '鮾', '鯘', '鰄', '鰋', '鴑', '鴳', '鴽', '鷃', '鸚', '鼴', '鼹',
        ],
    },
    Membership {
        radical: '山',
        strokes: 3,
        kanji: &[
            '丗', '両', '乢', '亗', '仙', '仚', '倔', '傜', '催', '傰', '凒', '凱', '出', '剛',
            '剴', '匋', '匩', '咄', '喘', '嗤', '嘊', '圌', '圸', '堀', '堈', '塏', '墔', '墼',
            '妛', '媱', '媸', '媺', '密', '寚', '屈', '山', '屴', '屵', '屶', '屹', '屺', '屻',
            '屼', '屽', '岇', '岈', '岊', '岌', '岏', '岐', '岑', '岒', '岔', '岝', '岟', '岠',
            '岡', '岢', '岣', '岦', '岨', '岩', '岪', '岫', '岬', '岱', '岲', '岳', '岴', '岵',
            '岶', '岷', '岸', '岺', '岻', '岼', '岾', '峅', '峇', '峉', '峋', '峒', '峗', '峙',
            '峝', '峠', '峡', '峨', '峩', '峪', '峭', '峮', '峯', '峰', '峱', '峲', '峴', '島',
            '峺', '峻', '峽', '崁', '崆', '崇', '崋', '崍', '崎', '崑', '崒', '崔', '崕', '崖',
            '崗', '崘', '崙', '崚', '崛', '崟', '崢', '崣', '崤', '崦', '崧', '崩', '崫', '崱',
            '崴', '崹', '崽', '崿', '嵂', '嵃', '嵆', '嵈', '嵊', '嵋', '嵌', '嵎', '嵐', '嵑',
            '嵒', '嵕', '嵙', '嵜', '嵟', '嵠', '嵡', '嵢', '嵤', '嵩', '嵪', '嵬', '嵭', '嵯',
            '嵰', '嵳', '嵶', '嵹', '嵺', '嵾', '嵿', '嶁', '嶂', '嶃', '嶄', '嶇', '嶈', '嶊',
            '嶋', '嶌', '嶐', '嶒', '嶓', '嶔', '嶕', '嶙', '嶛', '嶝', '嶟', '嶠', '嶢', '嶧',
            '嶫', '嶬', '嶮', '嶰', '嶲', '嶴', '嶷', '嶸', '嶹', '嶺', '嶼', '嶽', '巃', '巇',
            '巉', '巋', '巌', '巍', '巎', '巐', '巒', '巓', '巖', '巘', '巙', '幑', '弢', '微',
            '徴', '徽', '惴', '愷', '懲', '拙', '掘', '揣', '搗', '摧', '攜', '旵', '旹', '昢',
            '暚', '暟', '朏', '杣', '柮', '梣', '棡', '榿', '槝', '槯', '樒', '氙', '汕', '泏',
            '涔', '淈', '湍', '満', '漄', '漰', '漼', '澂', '灃', '炭', '猯', '猺', '獃', '瑞',
            '璀', '疝', '癌', '癥', '皚', '皠', '眄', '碳', '磑', '磪', '祟', '祹', '秈', '窑',
            '窟', '端', '篅', '籼', '糶', '綱', '繃', '繇', '缶', '缻', '缼', '缽', '缾', '缿',
            '罃', '罄', '罇', '罏', '耑', '腨', '舢', '艷', '蔤', '薇', '蚩', '螘', '蠵', '褍',
            '覬', '觽', '觿', '訔', '訕', '豈', '豐', '豓', '豔', '豳', '貒', '踹', '輌', '辿',
            '遄', '銟', '鋼', '鍴', '鎧', '鏙', '閊', '闓', '隑', '靊', '顓', '顗', '颻', '鰩',
            '黜', '黴',
        ],
    },
    Membership {
        radical: 'ヨ',
        strokes: 3,
        kanji: &[
            '争', '亊', '事', '互', '亹', '仾', '伊', '侓', '侵', '倢', '倳', '傁', '傏', '傔',
            '傭', '儘', '兼', '冿', '凄', '凈', '凲', '剥', '吚', '君', '咿', '唐', '啑', '啛',
            '喙', '嗛', '嘒', '嘯', '嚳', '圕', '埩', '埭', '埽', '堟', '塘', '墉', '壗', '夓',
            '夛', '妻', '婕', '婦', '嫌', '宐', '宭', '寁', '寖', '寝', '寢', '尋', '尲', '尹',
            '峮', '崢', '嵂', '嵰', '巋', '帇', '帚', '帠', '帰', '庚', '康', '庸', '廉', '彇',
            '彐', '彑', '当', '彔', '彗', '彘', '彙', '彛', '彜', '彝', '彠', '徢', '徤', '急',
            '悽', '慊', '慧', '慵', '慷', '戳', '扭', '挪', '捃', '捷', '捸', '捿', '掃', '掙',
            '掾', '揵', '搪', '撏', '擢', '斅', '旔', '旟', '曃', '曜', '杻', '枑', '档', '桾',
            '棅', '棣', '棲', '椽', '楗', '槥', '樰', '檃', '櫂', '櫞', '櫽', '歉', '歸', '沍',
            '浄', '浸', '涒', '淒', '淥', '淨', '溏', '溓', '滽', '潚', '潯', '濂', '濅', '濯',
            '瀞', '瀟', '灵', '焄', '煞', '燖', '燼', '燿', '爭', '牅', '犍', '猙', '珒', '珺',
            '琤', '琭', '瑑', '瑭', '璏', '疉', '癮', '盠', '盡', '睜', '睫', '碌', '磤', '祲',
            '禄', '秉', '稴', '穅', '穏', '穩', '窘', '竫', '笋', '筝', '箏', '箑', '箒', '箻',
            '篖', '篲', '簫', '簶', '簾', '籙', '粛', '粶', '糠', '糴', '糶', '綅', '緑', '縁',
            '縑', '繍', '繡', '羞', '羣', '群', '耀', '肁', '肅', '肈', '膁', '膅', '膤', '艝',
            '芛', '茟', '莙', '菉', '菷', '萋', '葏', '葠', '蒹', '蔧', '蕁', '蕭', '薓', '藎',
            '蛜', '蜨', '蝝', '螗', '蟳', '蠊', '蠨', '衋', '裙', '褄', '褖', '覠', '諍', '謙',
            '讔', '豏', '賡', '賺', '贐', '躍', '轌', '轝', '逮', '逯', '郡', '鄘', '鄩', '醁',
            '銉', '鋟', '錚', '録', '鎌', '鎕', '鏞', '鏽', '鐮', '隠', '隱', '隶', '隷', '隸',
            '雪', '靆', '静', '靜', '鞬', '頵', '餹', '饈', '馦', '駸', '騄', '驌', '鮼', '鰜',
            '鱃', '鱅', '鱇', '鱈', '鱐', '鱘', '鱟', '鱮', '鶊', '鶼', '鷫', '鸒', '鹻', '麏',
            '龞', '龣',
        ],
    },
    Membership {
        radical: '尸',
        strokes: 3,
        kanji: &[
            '侭', '侷', '倉', '倔', '倨', '偏', '偓', '傓', '傖', '僝', '僱', '僻', '冺', '凥',
            '刷', '劈', '劚', '匾', '叞', '启', '呎', '呢', '咫', '唳', '啓', '喔', '嗆', '嘏',
            '嘱', '囅', '囑', '坭', '埿', '堀', '塀', '墀', '壁', '壂', '声', '妒', '妮', '姄',
            '娓', '媚', '嬖', '孱', '尉', '尸', '尺', '尻', '尼', '尽', '尾', '尿', '局', '屁',
            '居', '屆', '屈', '届', '屋', '屍', '屎', '屏', '屐', '屑', '屓', '展', '屙', '屚',
            '屜', '属', '屠', '屡', '屢', '屣', '層', '履', '屧', '屨', '屩', '屬', '屭', '岷',
            '崛', '崢', '崫', '嵋', '帍', '幄', '廜', '徧', '怩', '悷', '惼', '惽', '愍', '愴',
            '慰', '戸', '戹', '戻', '戽', '房', '所', '扁', '扂', '扃', '扄', '扆', '扇', '扈',
            '扉', '択', '抳', '抿', '挶', '捩', '据', '掘', '掮', '握', '搶', '摒', '撝', '擗',
            '擘', '攺', '敃', '斒', '旎', '昈', '昬', '昵', '昼', '晵', '暋', '枦', '柅', '桾',
            '梮', '梶', '棙', '棨', '椐', '椖', '楣', '榍', '樨', '檗', '殸', '殿', '民', '氓',
            '沢', '泥', '泯', '涙', '淈', '渥', '湄', '湣', '滄', '滬', '漏', '潺', '澱', '澼',
            '濵', '炉', '煽', '熨', '爲', '牖', '犀', '猵', '珉', '琚', '瑲', '璧', '甓', '痆',
            '瘡', '瘺', '癖', '癜', '眉', '眠', '眤', '矚', '碾', '碿', '磬', '稺', '穉', '窟',
            '箼', '篇', '簄', '粐', '糄', '糏', '綟', '綮', '緡', '編', '罄', '罠', '羼', '翩',
            '聲', '肁', '肇', '肈', '肩', '胒', '腒', '臀', '臂', '臋', '舮', '艑', '艙', '芦',
            '苠', '苨', '萹', '蔚', '薜', '藊', '蘗', '蚭', '蝙', '螱', '蟁', '裙', '裾', '褊',
            '襞', '訳', '誳', '諞', '謆', '謦', '譬', '跼', '踞', '蹁', '蹌', '蹍', '躃', '躄',
            '輾', '轏', '辟', '遅', '遍', '遲', '避', '郿', '釈', '鈩', '鈬', '鈮', '鋸', '錑',
            '鍽', '鏧', '鐴', '钃', '闙', '闢', '阸', '隦', '雇', '霨', '霹', '顧', '馨', '馿',
            '駅', '騙', '騸', '髛', '鯿', '鳲', '鵩', '鸊', '齷',
        ],
    },
    Membership {
        radical: '廾',
        strokes: 3,
        kanji: &[
            '丼', '併', '侖', '倎', '借', '倫', '偏', '僀', '儕', '冊', '刑', '刪', '剏', '剤',
            '劑', '劓', '匥', '匾', '升', '卉', '厪', '呏', '咈', '哢', '嚊', '嚌', '圇', '型',
            '垪', '塀', '壩', '奔', '妌', '妍', '姍', '嬶', '宑', '尭', '屏', '岪', '峅', '崘',
            '崙', '巐', '廑', '廾', '弁', '异', '弃', '弄', '弆', '弇', '弈', '弉', '弊', '彛',
            '彜', '彝', '形', '徧', '悈', '惼', '慬', '慸', '慿', '戁', '戒', '扁', '抍', '拚',
            '拼', '挵', '掄', '揅', '揜', '摒', '撒', '擠', '擤', '散', '斉', '斎', '斒', '斳',
            '昇', '昪', '暁', '暵', '枅', '枡', '柵', '栟', '桺', '械', '梻', '棆', '横', '欛',
            '殢', '殣', '氟', '汧', '汫', '淠', '淪', '渀', '済', '漌', '漭', '濞', '濟', '瀹',
            '灞', '熯', '爚', '猵', '珊', '畀', '疿', '痹', '癟', '癱', '睤', '研', '硎', '禴',
            '竎', '笄', '笧', '笰', '筭', '算', '篇', '籥', '籲', '糄', '紼', '絣', '綸', '緙',
            '編', '纃', '缾', '羿', '翩', '聠', '聨', '胼', '腗', '臍', '臡', '舁', '艑', '艜',
            '艴', '茀', '荊', '荓', '莽', '莾', '萕', '萹', '葊', '葬', '蓱', '薺', '藊', '蚈',
            '蝙', '螮', '蟒', '蠎', '裓', '褊', '襣', '覉', '誡', '論', '諞', '賆', '趼', '跚',
            '跰', '蹁', '蹛', '躋', '輪', '迸', '逩', '遍', '遰', '邢', '鄞', '鉘', '鉶', '鉼',
            '錀', '錯', '鍽', '鑰', '開', '閞', '阢', '阱', '陞', '霽', '革', '靪', '靮', '靳',
            '靶', '靷', '靸', '靻', '靽', '靿', '鞀', '鞉', '鞕', '鞖', '鞗', '鞙', '鞚', '鞞',
            '鞟', '鞢', '鞬', '鞮', '鞱', '鞲', '鞵', '鞶', '鞸', '鞹', '鞺', '鞼', '鞾', '鞿',
            '韁', '韄', '韅', '韇', '韉', '韊', '韲', '頮', '頯', '餅', '餴', '馵', '駢', '駴',
            '駵', '騙', '骿', '髒', '髜', '鮄', '鮩', '鯿', '鴘', '鸙', '黭', '鼖', '鼻', '鼼',
            '鼽', '鼾', '鼿', '齁', '齃', '齄', '齅', '齆', '齇', '齊', '齋', '齎', '齏', '龏',
            '龠', '龡', '龢', '龣', '龥',
        ],
    },
    Membership {
        radical: '夂',
        strokes: 3,
        kanji: &[
            '佟', '俊', '俢', '倏', '倐', '倰', '傯', '僾', '儍', '優', '儵', '冬', '凌', '処',
            '匛', '厦', '各', '咎', '咯', '唆', '喀', '喒', '嗄', '噯', '囱', '埈', '夂', '夅',
            '夆', '変', '夊', '夋', '夌', '夏', '夐', '夒', '夓', '夔', '婈', '嬡', '客', '履',
            '峉', '峯', '峰', '峻', '崚', '嵕', '嶐', '巎', '巙', '庱', '廈', '後', '復', '徼',
            '恪', '悛', '悠', '悤', '愎', '愙', '愛', '慶', '憁', '憂', '戇', '抜', '拠', '挌',
            '捘', '掕', '掖', '摓', '摠', '撒', '擱', '擾', '数', '昝', '晙', '晷', '曖', '条',
            '杦', '柊', '栙', '格', '桻', '梭', '棭', '棱', '椱', '椶', '榎', '樤', '櫌', '櫜',
            '洚', '洛', '浚', '淩', '溭', '滫', '潞', '澓', '瀀', '烙', '烽', '焌', '熢', '牕',
            '狢', '狻', '珞', '璁', '璐', '璦', '瓊', '畞', '畟', '略', '畧', '畯', '疼', '痠',
            '癁', '癃', '皧', '皴', '睖', '瞹', '硌', '祾', '禝', '稜', '稯', '稷', '窻', '窿',
            '竣', '笿', '篷', '簬', '糉', '終', '絛', '絡', '絳', '綹', '綾', '緵', '縧', '縫',
            '總', '羐', '羑', '翛', '耰', '聰', '胮', '胳', '脧', '腹', '膖', '臵', '苳', '茖',
            '菱', '落', '葰', '葼', '蓌', '蓧', '蓬', '蔆', '蔥', '蕗', '蕯', '薆', '薐', '薮',
            '虁', '虂', '處', '蛒', '蜂', '蝮', '螽', '蠭', '衉', '複', '覆', '詻', '謖', '警',
            '貉', '賂', '贛', '路', '踆', '輅', '輘', '輹', '逄', '逡', '逢', '酪', '酸', '鉻',
            '鋒', '錂', '鍐', '鍑', '鎀', '鎫', '鏅', '鏓', '鑁', '閣', '降', '陖', '陵', '隆',
            '雒', '露', '霳', '靉', '鞗', '韸', '額', '餕', '馥', '駱', '駿', '騣', '驄', '驚',
            '骼', '髪', '鬉', '鬷', '鮗', '鮻', '鯈', '鯪', '鰒', '鰷', '鱫', '鴼', '鵅', '鵔',
            '鷺', '麥', '麦', '麨', '麩', '麪', '麬', '麭', '麮', '麯', '麰', '麳', '麴', '麵',
            '麸', '麹', '麺', '鼕', '鼛',
        ],
    },
    Membership {
        radical: '⺖',
        strokes: 3,
        kanji: &[
            '忄', '忇', '忉', '忋', '忓', '忔', '忖', '忙', '忡', '忤', '忨', '忪', '快', '忬',
            '忭', '忮', '忯', '忰', '忱', '忲', '忳', '忶', '忸', '忺', '忻', '忼', '怇', '怊',
            '怍', '怏', '怐', '怓', '怔', '怕', '怖', '怗', '怙', '怚', '怛', '怜', '怟', '怡',
            '怦', '性', '怩', '怪', '怫', '怭', '怯', '怳', '怵', '怺', '恀', '恂', '恃', '恆',
            '恇', '恈', '恉', '恊', '恌', '恍', '恑', '恒', '恔', '恗', '恟', '恠', '恡', '恢',
            '恤', '恨', '恪', '恫', '恬', '恰', '恱', '恾', '悁', '悂', '悃', '悄', '悈', '悋',
            '悌', '悍', '悎', '悑', '悒', '悓', '悔', '悕', '悖', '悗', '悚', '悛', '悝', '悞',
            '悟', '悢', '悦', '悧', '悩', '悰', '悱', '悴', '悵', '悷', '悸', '悻', '悼', '悽',
            '悾', '惂', '情', '惆', '惇', '惈', '惊', '惋', '惏', '惓', '惔', '惕', '惘', '惙',
            '惚', '惛', '惜', '惝', '惞', '惟', '惧', '惨', '惰', '惱', '惲', '惴', '惵', '惶',
            '惸', '惺', '惻', '惼', '惽', '愀', '愃', '愇', '愉', '愊', '愌', '愎', '愐', '愑',
            '愒', '愓', '愔', '愕', '愖', '愜', '愞', '愡', '愢', '愧', '愪', '愫', '愰', '愱',
            '愴', '愵', '愶', '愷', '愹', '愼', '愽', '愾', '慄', '慅', '慆', '慉', '慊', '慌',
            '慍', '慎', '慓', '慘', '慚', '慞', '慟', '慠', '慢', '慣', '慥', '慨', '慬', '慯',
            '慱', '慲', '慳', '慴', '慵', '慷', '慻', '憀', '憁', '憍', '憎', '憐', '憒', '憓',
            '憔', '憘', '憚', '憜', '憟', '憤', '憧', '憪', '憫', '憬', '憭', '憮', '憶', '憸',
            '憹', '憺', '憾', '懀', '懁', '懂', '懆', '懈', '懊', '懌', '懍', '懎', '懏', '懐',
            '懜', '懝', '懞', '懡', '懢', '懥', '懦', '懧', '懩', '懭', '懴', '懶', '懷', '懺',
            '懼', '懽', '懾', '戃', '戄', '湉', '筷', '緪', '罹',
        ],
    },
    Membership {
        radical: '⻌',
        strokes: 3,
        kanji: &[
            '儙', '嗹', '噠', '噵', '導', '巡', '慥', '搥', '摓', '撻', '撾', '擿', '暹', '曃',
            '槌', '樋', '檛', '漣', '熢', '燧', '燵', '璉', '璡', '璲', '磓', '穟', '篴', '篷',
            '簉', '籧', '籩', '糙', '縋', '縫', '縺', '繸', '繾', '腿', '膖', '膸', '蒁', '蒾',
            '蓪', '蓬', '蓮', '薘', '蘧', '蠭', '褪', '襚', '謎', '謰', '譴', '讁', '躂', '躚',
            '辶', '辷', '辸', '辺', '辻', '込', '达', '辿', '迀', '迁', '迂', '迄', '迅', '迆',
            '迊', '迋', '迍', '迎', '运', '近', '迒', '迓', '返', '迕', '迚', '迠', '迢', '迣',
            '迤', '迥', '迦', '迨', '迩', '迪', '迫', '迭', '迮', '迯', '述', '迱', '迴', '迵',
            '迶', '迷', '迸', '迹', '迺', '迻', '追', '迾', '退', '送', '适', '逃', '逄', '逅',
            '逆', '逈', '逋', '逌', '逍', '逎', '透', '逐', '逑', '逓', '途', '逕', '逖', '逗',
            '逘', '這', '通', '逛', '逝', '逞', '速', '造', '逡', '逢', '連', '逧', '逨', '逩',
            '逪', '逬', '逭', '逮', '逯', '週', '進', '逳', '逴', '逵', '逶', '逷', '逸', '逹',
            '逼', '逾', '逿', '遁', '遂', '遃', '遄', '遅', '遇', '遉', '遊', '運', '遌', '遍',
            '過', '遏', '遐', '遑', '遒', '道', '達', '違', '遖', '遘', '遙', '遛', '遜', '遝',
            '遞', '遠', '遡', '遢', '遣', '遥', '遦', '遧', '遨', '適', '遬', '遭', '遮', '遯',
            '遰', '遲', '遴', '遵', '遶', '遷', '選', '遹', '遺', '遼', '遽', '避', '邀', '邁',
            '邂', '邃', '還', '邅', '邇', '邈', '邉', '邊', '邋', '邌', '邎', '邏', '邐', '鎚',
            '鎹', '鏈', '鐽', '鑓', '闥', '随', '隧', '隨', '靆', '韃', '韆', '髄', '髓', '鰱',
            '鱁',
        ],
    },
    Membership {
        radical: '广',
        strokes: 3,
        kanji: &[
            '侂', '俯', '傏', '傭', '儣', '儷', '兤', '凢', '劘', '唐', '嘛', '嚝', '塘', '塵',
            '墉', '墌', '壙', '孋', '席', '幮', '广', '庀', '庁', '広', '庄', '庇', '床', '庋',
            '庎', '序', '底', '庖', '店', '庚', '府', '庠', '庢', '庤', '庥', '度', '座', '庨',
            '庪', '庫', '庬', '庭', '庱', '庳', '庵', '庶', '康', '庸', '庽', '庾', '庿', '廁',
            '廂', '廃', '廆', '廈', '廉', '廊', '廋', '廌', '廎', '廏', '廐', '廑', '廒', '廓',
            '廔', '廕', '廖', '廚', '廛', '廜', '廝', '廞', '廟', '廠', '廡', '廢', '廣', '廥',
            '廨', '廩', '廫', '廬', '廰', '廱', '廳', '彲', '応', '慵', '慶', '慷', '應', '懡',
            '懬', '懭', '拡', '捬', '掂', '搪', '摝', '摩', '摭', '擴', '擵', '攈', '攟', '攦',
            '昿', '暦', '曠', '曬', '椨', '樚', '欐', '歴', '渡', '溏', '滽', '漉', '濂', '瀇',
            '瀍', '灋', '灑', '牅', '獷', '瑭', '砿', '磨', '礦', '穅', '穈', '篖', '簏', '簾',
            '籭', '粧', '糖', '糜', '糠', '絋', '縻', '纊', '纏', '纚', '腐', '腑', '膅', '膺',
            '臕', '蓆', '蓙', '蔗', '蔴', '薦', '薼', '藦', '藨', '蘑', '蘼', '螗', '蠊', '褲',
            '譍', '賍', '賡', '踱', '蹠', '躔', '躕', '躧', '軈', '轆', '遮', '邐', '鄘', '鄜',
            '鄺', '鄽', '酈', '醿', '釃', '鉱', '鍍', '鎕', '鏖', '鏞', '鐮', '鑛', '鑣', '靡',
            '韉', '餹', '驪', '魔', '鯳', '鱅', '鱇', '鶊', '鷓', '鷹', '鸝', '鹿', '麀', '麁',
            '麂', '麃', '麄', '麅', '麇', '麈', '麋', '麌', '麎', '麏', '麑', '麒', '麓', '麕',
            '麖', '麗', '麘', '麛', '麝', '麞', '麟', '麤', '麻', '麼', '麾', '麿', '龐',
        ],
    },
    Membership {
        radical: '寸',
        strokes: 3,
        kanji: &[
            '付', '侍', '俯', '傅', '傠', '傳', '僔', '儔', '冠', '剸', '博', '厨', '吋', '咐',
            '噂', '嚋', '嚩', '嚼', '囀', '団', '圑', '團', '坿', '垨', '埒', '埓', '塒', '塼',
            '墏', '墫', '壔', '壽', '奨', '奪', '奬', '嫥', '守', '寸', '寺', '寽', '対', '寿',
            '封', '専', '射', '尅', '将', '將', '專', '尉', '尊', '尋', '尌', '對', '導', '峙',
            '嶈', '嶟', '嶹', '幇', '幫', '幬', '幮', '府', '庤', '廚', '弣', '彠', '待', '得',
            '忖', '怤', '恃', '愽', '慰', '慱', '懟', '拊', '持', '捋', '捬', '搏', '摶', '撏',
            '撙', '擣', '時', '村', '柎', '梼', '棏', '椨', '榑', '榭', '榯', '槈', '槫', '槳',
            '樹', '樽', '橱', '檮', '櫉', '欂', '欝', '涛', '湗', '溥', '溽', '漿', '潯', '澍',
            '濤', '熨', '燖', '燾', '爝', '爵', '特', '犎', '狩', '獎', '璹', '甎', '畤', '畴',
            '疇', '痔', '皭', '碍', '磚', '礴', '祔', '祷', '禱', '竱', '竴', '符', '等', '篈',
            '簙', '簿', '籌', '紂', '縛', '縟', '縳', '罇', '罸', '翿', '耐', '耨', '肘', '胕',
            '腐', '腑', '膊', '膞', '苻', '葑', '葤', '蒄', '蒋', '蒔', '蒪', '蓐', '蓴', '蔚',
            '蔣', '蕁', '薄', '薅', '虢', '蚹', '螱', '螿', '蟳', '褥', '討', '詩', '謝', '譸',
            '賻', '跗', '跱', '蹡', '蹰', '蹲', '躊', '躕', '軇', '轉', '辱', '遵', '鄩', '酎',
            '酧', '酹', '醤', '醬', '醻', '釂', '鉜', '鋝', '鋳', '鎒', '鎛', '鏄', '鏘', '鐏',
            '鑄', '鑮', '闘', '附', '陦', '隯', '霨', '餺', '駙', '髆', '鬪', '魗', '鮒', '鰣',
            '鱄', '鱒', '鱘', '麝',
        ],
    },
    Membership {
        radical: '士',
        strokes: 3,
        kanji: &[
            '仕', '任', '佶', '俵', '僖', '儔', '凭', '劼', '匨', '匵', '厫', '吉', '咭', '喆',
            '喜', '嘉', '嘻', '噎', '嚋', '嚞', '嚭', '囍', '囏', '壔', '士', '壬', '壮', '壯',
            '声', '壱', '売', '壳', '壷', '壹', '壺', '壼', '壽', '夡', '奘', '妊', '姙', '姞',
            '娤', '婬', '嬉', '孛', '実', '尌', '屆', '嶹', '幬', '幮', '廚', '廷', '弉', '彀',
            '志', '恁', '愨', '慠', '憘', '憙', '懿', '拮', '擡', '擣', '擷', '暿', '曀', '桔',
            '榖', '槖', '橲', '檮', '檯', '櫉', '櫝', '欯', '款', '歖', '殪', '殰', '殸', '殻',
            '涜', '淫', '澍', '濤', '瀆', '焋', '熹', '熺', '燾', '牘', '犢', '獒', '珽', '璹',
            '疇', '痣', '皷', '瞽', '硈', '磬', '禧', '禱', '秸', '穀', '竇', '筳', '籌', '糓',
            '糚', '糦', '紝', '絍', '結', '続', '縠', '繥', '纈', '續', '罄', '罟', '翿', '耗',
            '聱', '聲', '臺', '荏', '荘', '莊', '莛', '蔜', '薹', '藚', '蛣', '蜓', '蟚', '蟢',
            '蠧', '表', '衽', '袺', '装', '裝', '覟', '覿', '觳', '詰', '誌', '読', '謦', '謷',
            '譆', '譸', '讀', '讟', '賣', '贖', '躊', '躕', '軇', '轂', '郌', '醻', '鈓', '銺',
            '鋌', '鋕', '鏊', '鏧', '鑄', '鑟', '隯', '隷', '雕', '韇', '頡', '頲', '飪', '饎',
            '饐', '馨', '驁', '驝', '髻', '魗', '鮚', '鱚', '鷇', '鷔', '鷧', '黠', '黷', '鼓',
            '鼔', '鼕', '鼖', '鼗', '鼙', '鼚', '鼛', '鼟',
        ],
    },
    Membership {
        radical: '囗',
        strokes: 3,
        kanji: &[
            '亶', '佪', '個', '傯', '儃', '冎', '凅', '凛', '剮', '口', '咽', '啚', '嗇', '囗',
            '囙', '囚', '四', '囜', '囝', '回', '囟', '因', '囡', '団', '囤', '囥', '囦', '囧',
            '囨', '囫', '园', '囮', '困', '囱', '囲', '図', '囶', '囷', '囹', '固', '国', '囿',
            '圀', '圁', '圂', '圃', '圄', '圇', '圈', '圉', '圊', '國', '圌', '圍', '圏', '圑',
            '園', '圓', '圕', '圖', '團', '圚', '圜', '圝', '堌', '墻', '壇', '壈', '姻', '嬗',
            '嬙', '幗', '廩', '廻', '徊', '恩', '悃', '惱', '懍', '懎', '捆', '掴', '摑', '撾',
            '擅', '朙', '梱', '棝', '椢', '檁', '檣', '氈', '氤', '泅', '泗', '洄', '涸', '湎',
            '溷', '滷', '漍', '澟', '澶', '濇', '烟', '爴', '牆', '牕', '牘', '犢', '瑙', '璮',
            '痼', '皽', '睏', '硇', '碯', '磇', '磠', '祻', '禀', '稇', '稛', '稟', '穡', '窗',
            '箇', '箘', '篦', '簂', '粤', '絗', '絪', '綑', '總', '續', '羶', '聰', '胭', '腦',
            '膕', '膻', '臘', '艢', '茴', '茵', '莔', '菌', '蒽', '蓖', '薔', '薗', '蛔', '蟈',
            '蟺', '裀', '裍', '襢', '覿', '訵', '讀', '貔', '贖', '迴', '鄙', '錮', '鐓', '鑞',
            '靣', '顫', '饘', '駟', '駰', '鬣', '鮰', '鯝', '鰮', '鱣', '鸇', '鹵', '鹸', '鹹',
            '鹺', '鹻', '鹼', '鹽', '麕', '黷',
        ],
    },
    Membership {
        radical: '巾',
        strokes: 3,
        kanji: &[
            '乕', '伂', '佈', '佩', '偙', '僀', '冪', '凧', '制', '刷', '刺', '匝', '吊', '唏',
            '啻', '啼', '圑', '埽', '壐', '姉', '婦', '嫦', '崹', '巋', '巾', '帀', '市', '布',
            '帆', '帇', '帋', '希', '帍', '帑', '帒', '帔', '帕', '帖', '帘', '帙', '帚', '帛',
            '帝', '帟', '帠', '帥', '帨', '師', '席', '帮', '帯', '帰', '帲', '帳', '帵', '帶',
            '帷', '常', '帽', '帾', '幀', '幃', '幄', '幅', '幇', '幉', '幋', '幌', '幎', '幐',
            '幑', '幔', '幕', '幖', '幗', '幘', '幛', '幜', '幞', '幟', '幡', '幢', '幣', '幤',
            '幨', '幪', '幫', '幬', '幭', '幮', '幰', '弊', '怖', '悕', '慲', '慸', '憋', '掃',
            '掣', '揥', '敝', '斃', '旆', '晞', '暼', '杮', '柬', '柿', '棉', '棗', '棘', '楝',
            '楴', '檰', '欷', '歸', '殢', '沛', '淛', '渧', '溮', '滞', '滯', '濅', '猘', '獅',
            '珮', '瓻', '睎', '瞥', '碲', '禘', '稀', '策', '箍', '箒', '篩', '絺', '綿', '緜',
            '締', '羃', '肺', '艜', '芇', '芾', '菷', '蒂', '蒒', '蓆', '蔕', '蔽', '薓', '螄',
            '螮', '蟐', '衞', '製', '諦', '讏', '豨', '蹄', '蹛', '蹩', '躛', '迊', '逓', '遰',
            '郗', '鈰', '銟', '錦', '鍗', '閙', '霈', '韴', '飾', '鬧', '魳', '鯑', '鰤', '鱉',
            '鷩', '龞',
        ],
    },
    Membership {
        radical: '彡',
        strokes: 3,
        kanji: &[
            '丯', '俢', '修', '偐', '偰', '傪', '僇', '剹', '勠', '厖', '参', '參', '喭', '嘐',
            '嫪', '寥', '尨', '嵃', '嵺', '嵾', '庬', '廖', '廫', '彡', '形', '彣', '彤', '彦',
            '彧', '彩', '彪', '彫', '彬', '彭', '彯', '彰', '影', '彲', '恝', '惨', '慘', '憀',
            '戮', '摎', '摻', '昣', '杉', '槮', '樛', '殄', '毿', '沴', '洯', '滮', '滲', '漻',
            '澃', '澎', '牻', '珍', '璆', '畛', '疁', '疹', '瘛', '瘳', '盨', '眕', '砉', '磟',
            '穆', '穇', '篸', '簓', '糝', '紾', '縿', '繆', '羏', '翏', '耏', '聄', '肜', '胗',
            '膠', '膨', '蓚', '蓼', '蔘', '蟉', '蟚', '衫', '袗', '襂', '診', '諺', '謬', '賿',
            '趁', '跈', '軫', '轇', '辵', '遃', '醦', '醪', '釤', '鎀', '鏐', '須', '頾', '顏',
            '顔', '飂', '餮', '駹', '驂', '髎', '髟', '髠', '髢', '髣', '髤', '髥', '髦', '髧',
            '髩', '髪', '髫', '髬', '髭', '髮', '髯', '髱', '髲', '髳', '髴', '髵', '髷', '髹',
            '髺', '髻', '髽', '髿', '鬀', '鬁', '鬂', '鬃', '鬄', '鬅', '鬆', '鬈', '鬉', '鬋',
            '鬌', '鬍', '鬎', '鬐', '鬒', '鬖', '鬘', '鬙', '鬚', '鬛', '鬜', '鬟', '鬠', '鬢',
            '鬣', '鬱', '鬽', '鯵', '鰺', '鷚', '黲',
        ],
    },
    Membership {
        radical: '工',
        strokes: 3,
        kanji: &[
            '佐', '侙', '倥', '傞', '儔', '剄', '功', '勁', '匞', '卭', '啌', '嗟', '噐', '噬',
            '嚋', '墮', '壔', '壽', '媠', '尋', '崆', '嵯', '嵳', '嶹', '巠', '工', '左', '巧',
            '巩', '巫', '差', '幬', '式', '弑', '彠', '徑', '恐', '悾', '惘', '惰', '憜', '戇',
            '扛', '拭', '控', '揑', '搓', '撏', '擣', '攻', '昮', '暛', '曌', '杠', '杢', '栻',
            '桱', '椌', '楕', '槎', '槓', '橢', '檃', '檮', '櫽', '欞', '毉', '汞', '江', '涇',
            '溠', '潯', '澒', '澨', '濤', '熕', '燖', '燾', '牼', '瑳', '璹', '瓨', '畭', '疇',
            '痙', '瘥', '癮', '瞾', '矼', '硜', '碽', '磋', '禱', '穩', '空', '筇', '筑', '筮',
            '箜', '築', '籌', '紅', '經', '縒', '缸', '翿', '肛', '脛', '腔', '膸', '舡', '艖',
            '茳', '莖', '葒', '蕁', '虹', '蛩', '蟳', '褨', '覡', '訌', '試', '誙', '誣', '譭',
            '譸', '讔', '谾', '豇', '貢', '贛', '跫', '踁', '蹉', '躊', '躻', '軇', '軾', '輕',
            '逕', '邛', '鄩', '醻', '釅', '釭', '鉽', '銎', '鎈', '鑄', '陘', '隉', '隋', '隨',
            '隯', '隱', '隳', '靈', '鞏', '鞚', '項', '頸', '髓', '鬌', '鬫', '魗', '鰖', '鱘',
            '鴻', '鵐', '鵼', '鹺',
        ],
    },
    Membership {
        radical: '⺌',
        strokes: 3,
        kanji: &[
            '侊', '俏', '倘', '僘', '償', '儻', '光', '党', '兤', '削', '剿', '労', '勦', '単',
            '厰', '厳', '哨', '営', '嗩', '嘗', '垙', '堂', '姯', '嫦', '学', '宵', '尚', '屑',
            '峭', '巌', '巣', '常', '幌', '幤', '廠', '弊', '弰', '弾', '当', '徜', '恍', '悄',
            '悩', '惝', '愰', '戃', '戦', '挄', '挙', '捎', '掌', '摚', '撐', '撑', '撹', '擋',
            '攩', '敝', '敞', '斃', '晃', '晄', '暼', '栄', '桄', '桜', '档', '梢', '棠', '榍',
            '榥', '樔', '橕', '橖', '欅', '氅', '洸', '消', '淌', '溢', '滉', '焇', '熀', '牚',
            '猟', '獣', '珖', '珱', '琑', '瑣', '璫', '甞', '畄', '當', '痟', '皝', '瞠', '瞥',
            '矟', '硄', '硝', '碿', '礑', '禅', '稍', '筲', '箪', '簹', '糏', '絖', '綃', '縨',
            '耀', '肖', '胱', '脳', '膛', '艄', '莦', '蔽', '虩', '蛍', '蛸', '蝉', '蝋', '螳',
            '蟐', '蟷', '裳', '褝', '襠', '襷', '覚', '觥', '誉', '誚', '讜', '賞', '趙', '趟',
            '躺', '輝', '逍', '銧', '銷', '鋿', '鎖', '鎤', '鏜', '鐺', '鑜', '陗', '隚', '隠',
            '霄', '靗', '靜', '鞘', '鞺', '韑', '駫', '騨', '魈', '鮹', '鱨', '鴬', '黋', '黨',
            '鼈', '鼡',
        ],
    },
    Membership {
        radical: '夕',
        strokes: 3,
        kanji: &[
            '侈', '倇', '偧', '傑', '傜', '傺', '僢', '僯', '僲', '儚', '儛', '剜', '卥', '名',
            '哆', '啘', '埦', '塟', '墏', '夕', '外', '夘', '多', '夛', '夜', '夝', '夡', '夢',
            '夣', '夤', '夥', '奓', '奬', '婉', '媱', '宛', '將', '屍', '嶈', '嶙', '帵', '徭',
            '怨', '恀', '惋', '憐', '懜', '拶', '捥', '掖', '搖', '搩', '撚', '撛', '斃', '斘',
            '斴', '晼', '曻', '桀', '桝', '梦', '椀', '椉', '槳', '橉', '橪', '檫', '死', '殩',
            '氎', '汐', '液', '涴', '漈', '漿', '潾', '澯', '瀣', '炙', '然', '燃', '燐', '燦',
            '爹', '猺', '獎', '琬', '瑤', '璘', '璨', '畹', '瘵', '盌', '眢', '眵', '瞬', '瞵',
            '碗', '磔', '磷', '移', '穄', '穸', '窗', '窰', '簃', '粦', '粲', '粼', '繇', '繎',
            '腋', '腕', '臰', '舛', '舜', '舞', '苑', '茗', '菀', '葬', '蔣', '蕣', '薧', '薨',
            '蛥', '蜿', '螿', '詧', '詺', '誃', '謋', '謠', '豋', '豌', '趍', '踠', '蹡', '轔',
            '迯', '迻', '遙', '遴', '邎', '鄰', '酩', '醬', '鉹', '銘', '鋺', '鏘', '鏻', '隣',
            '頯', '颻', '飧', '餐', '驎', '髒', '鰩', '鰶', '鱗', '鴛', '鵷', '鵺', '鷂', '麟',
            '黟',
        ],
    },
    Membership {
        radical: '弓',
        strokes: 3,
        kanji: &[
            '丐', '佛', '俤', '兮', '剃', '勥', '匑', '咈', '咦', '墢', '夷', '姨', '娣', '嫋',
            '宆', '宖', '岪', '嵶', '嵹', '廢', '弓', '弔', '引', '弖', '弗', '弘', '弙', '弛',
            '弜', '弝', '弟', '弡', '弢', '弣', '弤', '弥', '弦', '弧', '弨', '弩', '弫', '弬',
            '弭', '弮', '弯', '弰', '弱', '弴', '張', '弶', '強', '弸', '弻', '弼', '弽', '弾',
            '弿', '彀', '彁', '彄', '彅', '彇', '彈', '彊', '彌', '彍', '彎', '彿', '怫', '悌',
            '愵', '拂', '搦', '晜', '梯', '梻', '榒', '氟', '沸', '泓', '洟', '涕', '湾', '溺',
            '漲', '潑', '瀰', '灣', '狒', '獼', '疆', '疿', '痍', '發', '睇', '矤', '矧', '稊',
            '穹', '窮', '第', '笰', '篛', '粥', '紖', '紭', '紼', '綈', '繦', '罤', '胰', '艴',
            '芎', '苐', '茀', '荑', '蒻', '蔃', '蕟', '藭', '蚓', '襁', '襏', '訠', '豑', '費',
            '躬', '醱', '鉘', '銕', '銻', '鏹', '鏺', '霛', '靷', '驋', '髴', '鬀', '鬻', '鮄',
            '鮧', '鮷', '鰯', '鴺', '鵜', '鶸', '麛',
        ],
    },
    Membership {
        radical: '⻏',
        strokes: 3,
        kanji: &[
            '俋', '倻', '哪', '唈', '啊', '嚮', '娜', '嫏', '帮', '廊', '廓', '扈', '挪', '挹',
            '捓', '揶', '擲', '曏', '梆', '梛', '椰', '榔', '槨', '浥', '灉', '爺', '琊', '瑯',
            '祁', '筇', '簄', '綁', '耶', '蓈', '蔀', '薌', '螂', '蠁', '裛', '躑', '邕', '邗',
            '邘', '邙', '邛', '邠', '邡', '邢', '那', '邥', '邦', '邨', '邪', '邯', '邰', '邱',
            '邲', '邳', '邴', '邵', '邶', '邸', '邽', '邾', '郁', '郃', '郄', '郅', '郇', '郈',
            '郊', '郌', '郎', '郒', '郕', '郗', '郘', '郙', '郛', '郜', '郝', '郟', '郡', '郢',
            '郤', '郥', '部', '郫', '郭', '郯', '郰', '郴', '郵', '郶', '郷', '都', '郾', '郿',
            '鄀', '鄂', '鄄', '鄅', '鄆', '鄈', '鄍', '鄐', '鄒', '鄔', '鄖', '鄗', '鄘', '鄙',
            '鄚', '鄜', '鄞', '鄠', '鄢', '鄣', '鄥', '鄧', '鄩', '鄭', '鄮', '鄯', '鄰', '鄱',
            '鄲', '鄴', '鄶', '鄷', '鄹', '鄺', '鄼', '鄽', '酃', '酇', '酈', '鋣', '鎁', '鞹',
            '響', '饗', '鱜', '齆',
        ],
    },
    Membership {
        radical: '子',
        strokes: 3,
        kanji: &[
            '乳', '享', '仔', '侟', '侼', '侾', '俘', '僝', '勃', '厚', '吼', '哮', '啍', '噋',
            '囝', '塾', '墩', '好', '子', '孑', '孒', '孔', '孕', '孖', '字', '存', '孚', '孛',
            '孜', '孝', '孞', '孟', '季', '孤', '孥', '学', '孨', '孩', '孫', '孮', '孯', '孰',
            '孱', '孳', '孵', '學', '孺', '孼', '孽', '孾', '孿', '宯', '序', '庨', '廓', '弴',
            '悖', '悸', '惇', '惸', '愂', '憝', '拵', '捊', '教', '敦', '斅', '斈', '暾', '朜',
            '李', '栫', '桲', '桴', '椁', '槨', '殍', '洊', '浡', '浮', '淳', '渤', '游', '漖',
            '潡', '潺', '焞', '熟', '燉', '牸', '犉', '猛', '猻', '硣', '秄', '稃', '稕', '箛',
            '箰', '籽', '粰', '綍', '綧', '罦', '耔', '脖', '脬', '臶', '艀', '艋', '芤', '茡',
            '荐', '荸', '莩', '菰', '葧', '蓀', '蜉', '蝣', '誖', '誟', '諄', '譈', '賯', '轏',
            '遊', '遜', '郛', '郭', '酵', '酻', '醇', '鋍', '錞', '錳', '鐓', '鞟', '鞹', '餑',
            '馟', '鵓', '鶉',
        ],
    },
    Membership {
        radical: '干',
        strokes: 3,
        kanji: &[
            '丵', '仠', '仵', '伻', '刊', '午', '南', '厈', '哶', '唫', '喃', '圉', '圛', '坪',
            '奸', '姧', '娨', '婞', '婻', '宇', '屽', '岸', '岼', '嶧', '帲', '干', '平', '年',
            '幵', '并', '幹', '忓', '忤', '怦', '悍', '悻', '扞', '抨', '拌', '拜', '拝', '捍',
            '揺', '攼', '敍', '敘', '斁', '旆', '旰', '旱', '旴', '旿', '晘', '曎', '杆', '杵',
            '枰', '栞', '桿', '楠', '歝', '殬', '汗', '汻', '泙', '涬', '湃', '湳', '滸', '澣',
            '犴', '猂', '猞', '献', '玕', '盬', '盰', '睅', '睪', '矸', '砰', '秤', '稈', '竿',
            '簳', '籜', '粁', '縶', '罕', '罱', '肝', '腩', '臿', '舒', '舘', '芉', '芊', '芋',
            '苹', '萍', '蓱', '蓻', '蘀', '虷', '蝻', '衎', '衘', '褺', '襗', '訐', '許', '諵',
            '謡', '豣', '豻', '貋', '趕', '軒', '輧', '迀', '迂', '迕', '逬', '遖', '遥', '邗',
            '醳', '釜', '釬', '銒', '銲', '鑿', '閈', '頇', '飦', '餘', '餠', '駻', '骭', '鮃',
            '鵇', '鼾',
        ],
    },
    Membership {
        radical: '已',
        strokes: 3,
        kanji: &[
            '俋', '倦', '僊', '僎', '凞', '刨', '包', '匏', '吧', '咆', '唈', '噀', '囘', '圏',
            '圮', '圯', '垉', '夒', '夔', '夿', '妃', '媐', '屺', '岊', '巎', '巙', '己', '已',
            '巳', '巴', '巷', '巸', '巹', '巻', '巽', '庖', '异', '弝', '忋', '忌', '惓', '抱',
            '挹', '捲', '撰', '改', '杞', '枹', '栬', '汜', '泡', '浥', '淝', '港', '灉', '灔',
            '炮', '炰', '煕', '熈', '熙', '爬', '爸', '玘', '瓟', '疤', '疱', '皅', '皰', '砲',
            '祀', '笣', '簄', '簨', '紀', '紦', '綣', '胞', '脃', '艴', '芑', '苞', '萢', '蓜',
            '蕝', '蘎', '虁', '蚫', '蜷', '蟤', '袍', '裛', '裷', '褜', '記', '誋', '譔', '豝',
            '赩', '起', '跑', '跽', '踠', '踡', '躚', '遷', '選', '邕', '郌', '郒', '郶', '配',
            '鈀', '鉋', '銫', '錈', '鐉', '鑱', '陒', '雝', '雹', '靤', '靶', '鞄', '韆', '颮',
            '飽', '饌', '饞', '骲', '髱', '鬈', '鮑', '麅', '麭', '齆',
        ],
    },
    Membership {
        radical: '⻖',
        strokes: 3,
        kanji: &[
            '啊', '埠', '堕', '墜', '墮', '婀', '屙', '嶐', '廕', '憜', '橢', '檃', '櫽', '泐',
            '滁', '痾', '癃', '癊', '癮', '窿', '篨', '蔭', '蔯', '蕯', '薩', '讔', '阜', '阝',
            '阞', '阡', '阢', '阤', '阥', '阦', '阨', '阪', '阬', '阮', '阯', '阱', '防', '阳',
            '阷', '阸', '阹', '阺', '阻', '阼', '阽', '阿', '陀', '陁', '陂', '附', '陋', '陌',
            '降', '陏', '限', '陒', '陔', '陖', '陗', '陘', '陛', '陜', '陝', '陞', '陟', '陡',
            '院', '陣', '除', '陥', '陦', '陪', '陬', '陮', '陰', '陲', '陳', '陴', '陵', '陶',
            '陷', '陸', '険', '陻', '陼', '陽', '陾', '陿', '隁', '隂', '隃', '隄', '隅', '隆',
            '隈', '隉', '隊', '隋', '隍', '階', '随', '隑', '隔', '隕', '隖', '隗', '隘', '隙',
            '隚', '際', '障', '隝', '隟', '隠', '隣', '隤', '隥', '隦', '隧', '隨', '隩', '險',
            '隮', '隯', '隰', '隱', '隲', '隳', '隴', '霳', '騭',
        ],
    },
    Membership {
        radical: '彳',
        strokes: 3,
        kanji: &[
            '勶', '哘', '垳', '屐', '屜', '屣', '履', '屧', '屨', '屩', '嵂', '幑', '彳', '彴',
            '彵', '彷', '彸', '役', '彺', '彼', '彽', '彾', '彿', '往', '征', '徂', '徃', '径',
            '待', '徇', '很', '徉', '徊', '律', '後', '徍', '徏', '徐', '徑', '徒', '従', '徖',
            '得', '徘', '徙', '徜', '徝', '從', '徠', '御', '徢', '徤', '徧', '徨', '復', '循',
            '徫', '徬', '徭', '微', '徯', '徰', '徱', '徳', '徴', '徸', '徹', '徼', '徽', '愆',
            '慫', '憄', '懲', '暀', '桁', '樅', '澓', '珩', '瘲', '癁', '癥', '禦', '筕', '箻',
            '篵', '簁', '籞', '絎', '縦', '縱', '聳', '荇', '葎', '蓯', '蓰', '薇', '蘅', '行',
            '衍', '衎', '衑', '衒', '術', '衕', '衖', '街', '衘', '衙', '衚', '衛', '衜', '衝',
            '衞', '衟', '衠', '衡', '衢', '裄', '覆', '讏', '豵', '蹝', '蹤', '躛', '銜', '鏦',
            '鴴', '鵆', '黴',
        ],
    },
    Membership {
        radical: '⺨',
        strokes: 3,
        kanji: &[
            '墾', '峱', '懇', '漪', '潴', '犭', '犯', '犱', '犲', '犴', '犹', '犾', '狁', '狂',
            '狃', '狄', '狆', '狇', '狉', '狌', '狎', '狐', '狒', '狕', '狖', '狗', '狘', '狙',
            '狛', '狟', '狠', '狡', '狢', '狥', '狩', '独', '狭', '狳', '狴', '狷', '狸', '狹',
            '狺', '狻', '狼', '狽', '狾', '猂', '猄', '猅', '猇', '猊', '猍', '猓', '猖', '猗',
            '猘', '猙', '猛', '猜', '猝', '猞', '猟', '猢', '猤', '猥', '猧', '猨', '猩', '猪',
            '猫', '猬', '猯', '猱', '猲', '猴', '猵', '猶', '猺', '猻', '猽', '猾', '猿', '獄',
            '獅', '獍', '獏', '獐', '獖', '獗', '獝', '獞', '獟', '獠', '獦', '獧', '獨', '獩',
            '獪', '獫', '獬', '獮', '獯', '獰', '獱', '獲', '獵', '獷', '獹', '獺', '獼', '玀',
            '玁', '玃', '荻', '蕏', '蕕', '誑', '逖', '逛', '鱁', '鵟', '鸑',
        ],
    },
    Membership {
        radical: '巛',
        strokes: 3,
        kanji: &[
            '剄', '剿', '勁', '勦', '匘', '巛', '巠', '巡', '巤', '廱', '徑', '惱', '拶', '桱',
            '樔', '涇', '淄', '湽', '灉', '災', '爉', '牼', '獵', '瑙', '璅', '甾', '痙', '癰',
            '硜', '碯', '窼', '經', '緇', '繅', '脛', '腦', '臘', '舝', '莖', '菑', '葘', '蠟',
            '衟', '誙', '踁', '躐', '輕', '輜', '輺', '逕', '邋', '邕', '錙', '鍿', '鏁', '鑞',
            '陘', '隟', '雝', '頸', '鬣', '鯔', '鱲', '齆',
        ],
    },
    Membership {
        radical: '弋',
        strokes: 3,
        kanji: &[
            '代', '侙', '倵', '坺', '垈', '妭', '岱', '帒', '弋', '弌', '弍', '弎', '式', '弐',
            '弑', '彧', '忒', '拭', '斌', '曵', '杙', '栻', '樲', '武', '犮', '玳', '珷', '盋',
            '碔', '笩', '紱', '胈', '膩', '茇', '菝', '虣', '袋', '袚', '試', '貮', '貳', '貸',
            '賦', '軷', '軾', '鈸', '鉽', '韍', '颰', '馛', '骮', '鳶', '鵡', '黛',
        ],
    },
    Membership {
        radical: '屮',
        strokes: 3,
        kanji: &[
            '劂', '匩', '厥', '塑', '媸', '孼', '屮', '屰', '弢', '愬', '憠', '搊', '搠', '撅',
            '朔', '槊', '橛', '櫱', '溯', '犓', '獗', '皺', '縐', '艸', '芔', '芻', '蒭', '蒴',
            '蕨', '蚩', '詜', '謅', '趨', '蹶', '辥', '逆', '遡', '鄒', '闕', '雛', '雟', '騶',
            '鱖', '鶵', '齺',
        ],
    },
    Membership {
        radical: '廴',
        strokes: 3,
        kanji: &[
            '之', '乏', '侹', '健', '唌', '埏', '庭', '廴', '延', '廷', '廸', '建', '廻', '廼',
            '徤', '挺', '揵', '旔', '梃', '楗', '涎', '犍', '珽', '筳', '筵', '綖', '脠', '腱',
            '艇', '莚', '莛', '蜑', '蜒', '蜓', '誕', '鋋', '鋌', '鍵', '霆', '鞬', '頲',
        ],
    },
    Membership {
        radical: '尢',
        strokes: 3,
        kanji: &[
            '僦', '兂', '兓', '冘', '厖', '尢', '尤', '尨', '就', '嵆', '巘', '庬', '忱', '枕',
            '沈', '牻', '犹', '疣', '眈', '紞', '耽', '肬', '萙', '蚘', '訦', '諬', '蹴', '躭',
            '邥', '酖', '醓', '鑙', '霃', '髧', '魫', '魷', '鴆', '鷲', '黆', '黕',
        ],
    },
    Membership {
        radical: '川',
        strokes: 3,
        kanji: &[
            '侃', '卅', '圳', '宺', '川', '州', '巤', '慌', '旈', '旒', '梳', '毓', '洲', '流',
            '爉', '琉', '甽', '疏', '硫', '紃', '荒', '蔬', '蠟', '訓', '詶', '謊', '躐', '邋',
            '酬', '醯', '釧', '鎏', '順', '馴', '駲', '鬛', '鱲',
        ],
    },
    Membership {
        radical: '亡',
        strokes: 3,
        kanji: &[
            '亡', '侫', '妄', '嬴', '忘', '忙', '恾', '慌', '望', '氓', '汒', '瀛', '甿', '盲',
            '籝', '網', '罔', '羸', '肓', '臝', '芒', '茫', '荒', '虻', '蝱', '蠃', '衁', '誷',
            '謊', '贏', '輞', '邙', '釯', '鋩', '魍',
        ],
    },
    Membership {
        radical: '也',
        strokes: 3,
        kanji: &[
            '也', '他', '匜', '咃', '地', '她', '弛', '彵', '拖', '揓', '施', '杝', '柂', '椸',
            '池', '沲', '牠', '竾', '絁', '葹', '虵', '袘', '訑', '貤', '迆', '迤', '酏', '釶',
            '鉇', '阤', '陁', '馳', '駞', '髢',
        ],
    },
    Membership {
        radical: '彑',
        strokes: 3,
        kanji: &[
            '互', '仾', '冱', '堟', '宐', '彑', '彔', '彖', '彘', '彙', '彜', '彝', '恆', '枑',
            '沍', '淥', '瑑', '璏', '盠', '祿', '篆', '籙', '粶', '菉', '蝝', '蠡', '褖', '逯',
        ],
    },
    Membership {
        radical: '及',
        strokes: 3,
        kanji: &[
            '伋', '及', '吸', '圾', '岌', '扱', '极', '汲', '笈', '級', '芨', '衱', '訯', '鈒',
            '靸', '馺', '魥',
        ],
    },
    Membership {
        radical: '久',
        strokes: 3,
        kanji: &['久', '柩', '灸', '玖', '畝', '疚', '粂', '镹'],
    },
    Membership {
        radical: '日',
        strokes: 4,
        kanji: &[
            '乹', '乾', '亘', '亯', '亰', '亶', '伷', '伸', '但', '侚', '便', '倎', '倝', '借',
            '倡', '倬', '倲', '偃', '偆', '偈', '偒', '偖', '偟', '偣', '傆', '傖', '傷', '傹',
            '傽', '働', '僚', '僣', '僤', '僧', '僭', '儂', '儃', '億', '儈', '儌', '儣', '儲',
            '児', '兤', '典', '冒', '冥', '冪', '凍', '凕', '凮', '剔', '剦', '剸', '劊', '劰',
            '勆', '動', '勗', '募', '勲', '匓', '匙', '匫', '匰', '匽', '卓', '厚', '厝', '厡',
            '厭', '厴', '厵', '叀', '咟', '咺', '唕', '唱', '唵', '唶', '啅', '啤', '喈', '喑',
            '喒', '喝', '喤', '喧', '嗆', '嗜', '嗢', '嘅', '嘈', '嘍', '嘗', '嘬', '嘲', '嘹',
            '嘽', '噆', '噌', '噫', '噭', '噲', '嚈', '嚕', '嚝', '囅', '囎', '圕', '坤', '坦',
            '垣', '埤', '埸', '堤', '堦', '堭', '堰', '堲', '場', '堵', '堹', '塌', '塒', '塲',
            '塼', '塿', '墁', '境', '墇', '墍', '墓', '増', '墠', '墸', '墹', '壇', '壓', '壜',
            '奄', '奙', '奛', '奢', '奣', '奭', '奲', '妟', '妯', '妲', '姮', '娨', '娼', '婐',
            '婚', '婥', '媋', '媓', '媞', '媼', '嫄', '嫏', '嫚', '嫜', '嫥', '嫺', '嫽', '嬗',
            '嬝', '宙', '宣', '宴', '寔', '寞', '寠', '寮', '尞', '尟', '尰', '届', '屠', '屢',
            '層', '履', '屨', '岬', '峋', '崑', '崦', '嵑', '嵢', '嶁', '嶂', '嶒', '嶛', '巐',
            '帕', '帽', '帾', '幌', '幎', '幔', '幕', '幛', '幜', '幟', '幫', '幹', '庳', '廔',
            '廜', '廟', '廥', '廸', '彰', '影', '徇', '得', '復', '怛', '恂', '恉', '恒', '悍',
            '悼', '惈', '惕', '惛', '惜', '惠', '惷', '惸', '惺', '惽', '愃', '愎', '意', '愒',
            '愓', '愔', '愰', '慇', '慍', '慕', '慞', '慟', '慢', '慯', '憎', '憓', '憬', '憭',
            '憶', '憹', '懀', '懕', '戇', '戟', '戠', '戧', '戩', '抻', '押', '抽', '担', '拽',
            '指', '挭', '挿', '捍', '捏', '捜', '捭', '捵', '掉', '掦', '掩', '措', '掲', '揀',
            '揎', '提', '揚', '揠', '揸', '搘', '搢', '搨', '摟', '摡', '摸', '撣', '撦', '撩',
            '撮', '撽', '擅', '擪', '擻', '敒', '敫', '斡', '斮', '旉', '旘', '日', '旦', '旧',
            '旨', '早', '旬', '旭', '旰', '旱', '旲', '旴', '旵', '旹', '旺', '旻', '旾', '旿',
            '昀', '昂', '昃', '昄', '昆', '昇', '昈', '昉', '昊', '昌', '昍', '明', '昏', '昑',
            '昒', '易', '昔', '昕', '昖', '昜', '昝', '昞', '星', '映', '昡', '昢', '昣', '昤',
            '春', '昦', '昧', '昨', '昩', '昪', '昫', '昬', '昭', '昮', '是', '昰', '昱', '昳',
            '昴', '昵', '昶', '昷', '昹', '昼', '昿', '晀', '晁', '時', '晃', '晄', '晅', '晆',
            '晉', '晊', '晋', '晌', '晎', '晏', '晑', '晒', '晗', '晘', '晛', '晜', '晝', '晞',
            '晟', '晠', '晡', '晢', '晤', '晦', '晧', '晨', '晩', '晪', '晫', '晬', '普', '景',
            '晰', '晳', '晴', '晵', '晶', '晷', '晸', '晹', '智', '晻', '晼', '晾', '晿', '暀',
            '暁', '暃', '暄', '暇', '暈', '暉', '暋', '暌', '暍', '暎', '暐', '暑', '暒', '暖',
            '暗', '暘', '暙', '暚', '暛', '暜', '暝', '暟', '暠', '暢', '暤', '暦', '暫', '暭',
            '暮', '暱', '暲', '暴', '暵', '暸', '暹', '暻', '暼', '暾', '暿', '曀', '曁', '曂',
            '曃', '曄', '曇', '曈', '曉', '曌', '曎', '曏', '曔', '曖', '曙', '曚', '曛', '曜',
            '曝', '曟', '曠', '曦', '曨', '曩', '曫', '曬', '曮', '曲', '曳', '更', '曷', '書',
            '曹', '曺', '曻', '曼', '曽', '曾', '替', '最', '會', '朅', '朇', '朝', '東', '杲',
            '杳', '柑', '柙', '柚', '柦', '栧', '桌', '桓', '桿', '梗', '棍', '棏', '棔', '棟',
            '棰', '棹', '椑', '椙', '椣', '椱', '椻', '椿', '楂', '楊', '楦', '楩', '楬', '楮',
            '楻', '楿', '榊', '榠', '榥', '榦', '榯', '榲', '榻', '槢', '槽', '槾', '樃', '樟',
            '模', '横', '樴', '樶', '樿', '橑', '橧', '橸', '檀', '檍', '檜', '檰', '檿', '櫓',
            '櫔', '櫧', '欂', '欄', '歆', '歇', '殉', '殗', '殟', '殤', '殾', '毌', '氈', '汨',
            '沓', '油', '洦', '洩', '洵', '洹', '涅', '涷', '涽', '淏', '淖', '淟', '混', '淹',
            '渇', '渚', '温', '渲', '湜', '湝', '湣', '湯', '湻', '湿', '溍', '溟', '溲', '溻',
            '滉', '漊', '漕', '漠', '漫', '漳', '潓', '潛', '潜', '潦', '潬', '潭', '潮', '潴',
            '潽', '澋', '澓', '澔', '澗', '澣', '澧', '澮', '澶', '濃', '濕', '濳', '濼', '瀑',
            '瀚', '瀦', '瀾', '灎', '灔', '灝', '灥', '炅', '烜', '焔', '焜', '焯', '焸', '煉',
            '煊', '煋', '煚', '煜', '煦', '照', '煬', '煮', '熀', '熏', '熠', '熳', '熾', '燀',
            '燎', '燙', '燻', '爆', '爗', '爛', '爝', '狎', '狟', '狥', '猂', '猒', '猖', '猩',
            '猪', '猲', '猽', '獍', '獏', '獐', '獠', '獦', '獪', '珅', '珣', '琨', '琩', '瑃',
            '瑄', '瑆', '瑒', '瑝', '瑨', '璋', '璙', '璟', '璮', '璯', '瓸', '甑', '甠', '甦',
            '由', '甲', '申', '甹', '畃', '畼', '疸', '痬', '瘄', '瘍', '瘏', '瘖', '瘟', '瘴',
            '瘼', '癁', '療', '癇', '癉', '癤', '皁', '皅', '皌', '皍', '皕', '皛', '皜', '皝',
            '皟', '皠', '皢', '皣', '皤', '皥', '皦', '皧', '皨', '皪', '皭', '皽', '盟', '盪',
            '眒', '眴', '睅', '睗', '睧', '睲', '睹', '瞑', '瞕', '瞚', '瞭', '矠', '矰', '砷',
            '硬', '碍', '碏', '碘', '碣', '碭', '磖', '磳', '神', '祼', '禓', '禔', '禪', '禫',
            '禮', '禯', '禺', '秞', '稈', '稉', '稞', '稭', '種', '稲', '稽', '穗', '穝', '穠',
            '穭', '窠', '窼', '竟', '章', '竨', '竭', '竱', '竸', '笛', '笪', '筁', '筍', '筪',
            '箄', '箟', '箯', '箰', '箸', '箺', '篂', '篳', '篺', '篼', '簎', '簟', '簠', '簡',
            '簪', '簳', '籍', '粺', '粿', '糟', '糢', '糧', '糩', '紬', '紳', '絈', '絏', '絙',
            '絢', '綆', '綶', '綽', '緄', '緆', '緍', '緒', '緡', '練', '緶', '緹', '縉', '縨',
            '縯', '縵', '繅', '繒', '織', '繚', '繝', '繟', '繪', '繳', '罎', '罨', '罩', '署',
            '罾', '羃', '羯', '羶', '翈', '翥', '翨', '翰', '者', '耆', '耤', '耦', '聘', '職',
            '胄', '胆', '胛', '脂', '腆', '腊', '腌', '腗', '腥', '腫', '腴', '腸', '腹', '膃',
            '膊', '膓', '膜', '膞', '膻', '膾', '膿', '臆', '臈', '舓', '舳', '舺', '艎', '艘',
            '艚', '艪', '艶', '茰', '荀', '草', '莄', '莫', '莭', '菎', '菖', '菴', '萆', '萌',
            '萬', '萱', '萸', '著', '葛', '董', '蒔', '蒪', '蓂', '蓈', '蓍', '蓴', '蓽', '蔇',
            '蔓', '蔯', '蕈', '蕏', '蕞', '蕩', '蕽', '薈', '薌', '薏', '薫', '薬', '薭', '薯',
            '藉', '藐', '藕', '藠', '藷', '藹', '蘄', '蘊', '蘭', '蘯', '蘰', '虩', '蚰', '蜡',
            '蜱', '蜴', '蜾', '蝀', '蝍', '蝎', '蝘', '蝪', '蝮', '螈', '螟', '螧', '螬', '螾',
            '蟆', '蟇', '蟙', '蟟', '蟪', '蟫', '蟺', '蠁', '蠆', '蠍', '蠞', '蠢', '蠶', '蠺',
            '衝', '衵', '袒', '裼', '褁', '褆', '複', '褏', '褐', '褚', '褞', '襛', '襢', '襫',
            '襮', '襴', '覃', '覆', '覥', '覩', '觴', '觶', '訷', '詢', '詣', '誯', '誻', '諌',
            '諛', '諟', '諠', '諳', '諸', '謁', '謜', '謨', '謾', '譂', '譄', '譖', '識', '譚',
            '譛', '譜', '豊', '豑', '豬', '貆', '貋', '貘', '賜', '賭', '賯', '賰', '贈', '贉',
            '贛', '赭', '趕', '趞', '趠', '踏', '踔', '踖', '踢', '踳', '踵', '踶', '踷', '蹋',
            '蹜', '蹭', '躇', '躒', '躢', '軃', '軄', '軆', '軸', '輥', '輵', '輹', '轑', '轕',
            '農', '迪', '逪', '逴', '逷', '逿', '遏', '遢', '遧', '遭', '遼', '邅', '邈', '郇',
            '郒', '郫', '都', '郾', '鄍', '鄚', '鄣', '鄶', '鄷', '醃', '醋', '醍', '醒', '醕',
            '醰', '醲', '醴', '釂', '釉', '重', '量', '鈤', '鈾', '鉀', '鉑', '鉮', '銲', '錍',
            '錔', '錕', '錩', '錪', '錫', '錬', '錯', '鍇', '鍉', '鍑', '鍚', '鍺', '鍾', '鎛',
            '鎤', '鏁', '鏄', '鏌', '鏝', '鏡', '鏸', '鐐', '鐔', '鐕', '鐟', '鐯', '鐿', '鑙',
            '間', '閘', '閶', '閹', '閺', '閽', '闇', '闌', '闍', '闒', '闦', '阳', '陥', '陳',
            '陴', '陼', '陽', '隁', '隄', '隅', '隙', '障', '隟', '隰', '靄', '靨', '靼', '鞕',
            '鞜', '鞨', '鞭', '鞮', '鞸', '韅', '韓', '韙', '韞', '韠', '音', '韴', '韵', '韶',
            '韷', '韸', '韺', '韻', '響', '頔', '顆', '題', '顒', '顕', '顥', '顫', '顯', '颺',
            '飣', '飥', '飦', '飪', '飳', '飶', '餂', '餇', '餑', '餕', '餖', '餗', '餚', '餛',
            '餜', '餟', '餢', '餦', '餧', '餫', '餱', '餲', '餳', '餴', '餵', '餹', '餺', '餻',
            '餼', '饀', '饁', '饂', '饅', '饆', '饇', '饈', '饍', '饎', '饘', '饙', '饛', '饜',
            '饞', '饟', '饠', '香', '馛', '馝', '馟', '馥', '馦', '馨', '馹', '駻', '騁', '騠',
            '騵', '驀', '驔', '骾', '髃', '髆', '體', '髜', '髷', '鬄', '鬐', '鬘', '鬙', '鬠',
            '鬺', '魘', '魯', '鮊', '鮋', '鮨', '鯁', '鯟', '鯣', '鯤', '鯧', '鯷', '鯹', '鯺',
            '鯽', '鰆', '鰋', '鰑', '鰒', '鰚', '鰛', '鰣', '鰨', '鰭', '鰻', '鰽', '鱄', '鱆',
            '鱏', '鱓', '鱛', '鱜', '鱠', '鱣', '鱧', '鱨', '鱪', '鱰', '鴨', '鴲', '鵪', '鵫',
            '鵲', '鵾', '鶇', '鶍', '鶕', '鶗', '鶡', '鶬', '鷃', '鷯', '鷾', '鸇', '麘', '麞',
            '麯', '黤', '黯', '黶', '鼂', '鼙', '鼬', '鼴', '鼹', '齃', '齄', '齰', '齵',
        ],
    },
    Membership {
        radical: '木',
        strokes: 4,
        kanji: &[
            '休', '体', '來', '侏', '保', '俰', '倮', '倲', '偢', '傑', '傔', '僺', '儝', '凍',
            '凓', '凩', '刹', '刺', '剌', '剿', '劘', '勅', '勑', '勦', '厤', '厯', '呆', '味',
            '咮', '咻', '唀', '唎', '唻', '唽', '啉', '喇', '喋', '喿', '嗓', '嗽', '嘛', '噤',
            '噪', '噺', '嚟', '嚦', '囃', '囌', '困', '囷', '垜', '埜', '埰', '堞', '堡', '塗',
            '壄', '壈', '壢', '夥', '妹', '妺', '姝', '婇', '婐', '婪', '媒', '媟', '媬', '嫠',
            '嫩', '嫻', '嬾', '孀', '宋', '宲', '寀', '寨', '寱', '尮', '屧', '峲', '崣', '崧',
            '嵆', '嵊', '嵙', '嶫', '嶸', '巣', '幉', '床', '庥', '廂', '弑', '弽', '彙', '彩',
            '彬', '徠', '怵', '恷', '悃', '悚', '惈', '惏', '想', '惵', '慄', '憖', '憗', '懆',
            '懋', '懡', '懶', '抹', '抺', '捆', '捒', '捼', '採', '探', '揀', '揉', '揪', '揲',
            '揸', '搩', '搽', '摩', '操', '擵', '擽', '攀', '攈', '攊', '攔', '攟', '敇', '敕',
            '整', '斕', '新', '昧', '昩', '晰', '晳', '暦', '木', '未', '末', '本', '札', '朮',
            '朱', '朳', '朴', '朶', '朷', '朸', '机', '朽', '朾', '朿', '杁', '杅', '杆', '杇',
            '杈', '杉', '杌', '李', '杏', '材', '村', '杓', '杔', '杕', '杖', '杙', '杜', '杝',
            '杞', '束', '杠', '条', '杢', '杣', '杤', '来', '杦', '杪', '杬', '杭', '杮', '杯',
            '杰', '東', '杲', '杳', '杴', '杵', '杶', '杷', '杻', '杼', '松', '板', '极', '构',
            '枅', '枇', '枉', '枋', '枌', '枎', '枏', '析', '枑', '枓', '枕', '枖', '林', '枘',
            '枙', '枚', '枛', '果', '枝', '枠', '枡', '枢', '枦', '枩', '枯', '枰', '枱', '枲',
            '枳', '枴', '枵', '架', '枷', '枸', '枹', '枻', '枼', '枽', '柀', '柁', '柂', '柃',
            '柄', '柅', '柆', '柈', '柉', '柊', '柎', '柏', '某', '柑', '柒', '染', '柔', '柗',
            '柘', '柙', '柚', '柜', '柝', '柞', '柡', '柢', '柤', '柦', '柧', '柩', '柬', '柮',
            '柯', '柰', '柱', '柲', '柳', '柴', '柵', '柶', '柷', '柹', '査', '柾', '柿', '栂',
            '栃', '栄', '栓', '栔', '栖', '栗', '栙', '栝', '栞', '栟', '校', '栢', '栧', '栨',
            '栩', '株', '栫', '栬', '栭', '栯', '栰', '栱', '栲', '栳', '栴', '核', '根', '栻',
            '格', '栽', '栿', '桀', '桁', '桂', '桃', '桄', '桅', '框', '案', '桊', '桌', '桍',
            '桎', '桐', '桑', '桒', '桓', '桔', '桕', '桗', '桘', '桙', '桛', '桜', '桝', '桟',
            '档', '桧', '桫', '桮', '桯', '桰', '桱', '桲', '桴', '桵', '桶', '桷', '桹', '桺',
            '桻', '桼', '桾', '桿', '梁', '梂', '梃', '梄', '梅', '梆', '梈', '梍', '梏', '梓',
            '梔', '梖', '梗', '梘', '梚', '梛', '梜', '條', '梟', '梠', '梡', '梢', '梣', '梥',
            '梦', '梧', '梨', '梩', '梪', '梭', '梮', '梯', '械', '梱', '梲', '梳', '梵', '梶',
            '梹', '梺', '梻', '梼', '棄', '棅', '棆', '棈', '棉', '棊', '棋', '棌', '棍', '棏',
            '棐', '棑', '棒', '棓', '棔', '棕', '棖', '棗', '棘', '棙', '棚', '棜', '棝', '棟',
            '棠', '棡', '棣', '棥', '棧', '棨', '棪', '棫', '棬', '棭', '森', '棯', '棰', '棱',
            '棲', '棵', '棶', '棹', '棺', '棻', '棼', '棽', '椀', '椁', '椄', '椅', '椆', '椈',
            '椉', '椊', '椋', '椌', '植', '椎', '椏', '椐', '椑', '椒', '椓', '椖', '椗', '椙',
            '椚', '椛', '検', '椡', '椢', '椣', '椥', '椦', '椨', '椪', '椰', '椱', '椳', '椴',
            '椵', '椶', '椸', '椹', '椻', '椽', '椿', '楂', '楅', '楉', '楊', '楎', '楓', '楔',
            '楕', '楗', '楙', '楚', '楛', '楜', '楝', '楞', '楠', '楡', '楢', '楣', '楤', '楥',
            '楦', '楨', '楩', '楪', '楫', '楬', '業', '楮', '楯', '楰', '楱', '楲', '楳', '楴',
            '極', '楷', '楸', '楹', '楺', '楻', '楼', '楽', '楾', '楿', '榀', '榁', '概', '榊',
            '榍', '榎', '榑', '榒', '榔', '榕', '榖', '榘', '榛', '榜', '榠', '榡', '榥', '榦',
            '榧', '榨', '榫', '榭', '榮', '榯', '榱', '榲', '榴', '榷', '榸', '榺', '榻', '榼',
            '榾', '榿', '槁', '槃', '槅', '槇', '槈', '槊', '構', '槌', '槍', '槎', '槐', '槑',
            '槓', '槖', '槗', '様', '槙', '槝', '槞', '槢', '槥', '槧', '槨', '槫', '槭', '槮',
            '槯', '槱', '槲', '槳', '槵', '槹', '槻', '槽', '槾', '槿', '樀', '樁', '樂', '樃',
            '樅', '樊', '樋', '樌', '樏', '樑', '樒', '樓', '樔', '樕', '樗', '標', '樚', '樛',
            '樝', '樞', '樟', '樠', '模', '樢', '樣', '樤', '樨', '権', '横', '樫', '樮', '樰',
            '樲', '樴', '樵', '樶', '樷', '樸', '樹', '樺', '樻', '樽', '樾', '樿', '橄', '橅',
            '橆', '橇', '橈', '橉', '橊', '橋', '橎', '橐', '橑', '橒', '橕', '橖', '橘', '橙',
            '橛', '機', '橡', '橢', '橤', '橦', '橧', '橪', '橱', '橲', '橳', '橸', '橾', '橿',
            '檀', '檁', '檃', '檄', '檆', '檇', '檉', '檋', '檍', '檎', '檐', '檑', '檗', '檛',
            '檜', '檝', '檞', '檟', '檠', '檢', '檣', '檥', '檪', '檫', '檬', '檮', '檯', '檰',
            '檱', '檳', '檴', '檸', '檻', '檽', '檾', '檿', '櫁', '櫂', '櫃', '櫆', '櫈', '櫉',
            '櫌', '櫐', '櫑', '櫓', '櫔', '櫕', '櫖', '櫚', '櫛', '櫜', '櫝', '櫞', '櫟', '櫤',
            '櫧', '櫨', '櫪', '櫬', '櫰', '櫱', '櫲', '櫺', '櫻', '櫼', '櫽', '欂', '欃', '欄',
            '欅', '欆', '欇', '欉', '權', '欏', '欐', '欑', '欒', '欖', '欗', '欛', '欝', '欟',
            '欶', '歴', '殊', '殺', '氂', '氉', '沐', '沫', '泍', '洓', '洙', '浰', '涑', '涷',
            '涹', '淅', '淋', '淞', '深', '淶', '渠', '渣', '渫', '湅', '湈', '湘', '湨', '溂',
            '溧', '溱', '滌', '漆', '漦', '漱', '潗', '潸', '澖', '澟', '澡', '澵', '濚', '濼',
            '瀝', '瀬', '瀾', '灤', '烋', '焚', '煉', '煠', '煤', '燓', '燥', '爍', '爛', '爤',
            '爨', '牀', '牃', '牒', '犛', '狇', '猍', '猓', '猱', '獺', '珠', '琇', '琛', '琳',
            '琹', '瑧', '瑮', '璅', '璪', '瓈', '瓓', '疎', '痜', '痲', '痳', '瘌', '癧', '癩',
            '皌', '皙', '皪', '盉', '相', '眛', '眜', '睏', '睞', '睬', '砵', '硃', '碟', '磉',
            '磔', '磨', '磲', '磿', '礎', '礫', '礬', '礵', '祩', '祼', '禁', '禖', '禾', '秂',
            '秄', '秇', '秈', '秊', '秏', '秔', '秖', '秚', '秝', '秞', '秠', '秢', '秣', '秥',
            '秪', '秫', '秭', '秱', '秸', '秼', '稂', '稃', '稇', '稉', '稊', '稌', '稑', '稕',
            '稛', '稞', '稡', '稧', '稫', '稭', '稯', '稰', '稴', '稵', '稸', '稹', '稺', '穄',
            '穅', '穇', '穈', '穌', '穕', '穖', '穙', '穜', '穝', '穟', '穠', '穥', '穧', '穪',
            '穭', '窠', '窼', '竦', '笨', '策', '箖', '箱', '築', '篠', '篥', '簃', '簌', '簗',
            '籍', '籕', '籟', '籣', '粿', '糅', '糜', '紮', '絑', '綑', '綝', '綵', '綶', '緌',
            '緗', '緤', '緥', '練', '縧', '縻', '繅', '繰', '缽', '罧', '耒', '耓', '耔', '耕',
            '耖', '耗', '耘', '耙', '耜', '耝', '耞', '耟', '耠', '耡', '耤', '耦', '耨', '耬',
            '耮', '耰', '腇', '膝', '臊', '臝', '臬', '臲', '苯', '茉', '茱', '茶', '荰', '莕',
            '莱', '莿', '菓', '菘', '菜', '菻', '萊', '萙', '葆', '葇', '葈', '葉', '葙', '蒁',
            '蒅', '蒩', '蓧', '蔌', '蔯', '蔴', '蕀', '蕖', '薪', '薬', '薭', '藁', '藉', '藊',
            '藕', '藥', '藦', '藳', '藶', '藻', '藾', '蘂', '蘑', '蘒', '蘖', '蘗', '蘭', '蘶',
            '蘼', '蘽', '蛛', '蜏', '蜙', '蜥', '蜲', '蜾', '蝀', '蝲', '蝶', '螓', '螙', '蠑',
            '蠜', '術', '袜', '袾', '裍', '裸', '裹', '褁', '褎', '褓', '襃', '襍', '襟', '襯',
            '襰', '襴', '襻', '襽', '親', '觫', '誄', '誅', '誗', '課', '諃', '諉', '諌', '諜',
            '諫', '諬', '謀', '謋', '譟', '讕', '貅', '賚', '賝', '賲', '跊', '跥', '踈', '踝',
            '蹀', '蹂', '躁', '躒', '躝', '躰', '躱', '輠', '輮', '轃', '轢', '轣', '辣', '述',
            '途', '速', '逨', '遬', '邌', '邾', '郴', '醂', '醔', '醿', '采', '釐', '鉢', '鉥',
            '銖', '鋓', '錬', '鍒', '鍱', '鏁', '鏉', '鑅', '鑙', '鑠', '鑭', '钄', '閑', '閫',
            '闌', '闑', '陳', '陿', '隟', '隸', '集', '雑', '雜', '霂', '霖', '霜', '靂', '靡',
            '靺', '鞢', '鞣', '韊', '韎', '韘', '頰', '頼', '顆', '顙', '餗', '餜', '餧', '馛',
            '馝', '馟', '馦', '騋', '驝', '骵', '髁', '髞', '髤', '髹', '鬁', '鬆', '鬎', '鬱',
            '魅', '魔', '鮇', '鮴', '鯘', '鯟', '鰈', '鰊', '鰷', '鵂', '鵣', '鶆', '鶇', '鶒',
            '鶖', '鶫', '鷴', '麇', '麓', '麘', '麨', '麬', '麮', '麯', '麰', '麳', '麴', '麵',
            '麻', '麼', '麾', '麿', '黧', '齄', '齽', '龢',
        ],
    },
    Membership {
        radical: '月',
        strokes: 4,
        kanji: &[
            '佾', '侑', '俏', '俼', '倄', '倗', '倩', '偁', '偂', '偦', '偸', '傰', '僩', '儬',
            '儱', '兪', '冐', '冑', '冕', '刖', '削', '前', '剪', '勝', '勶', '匬', '厭', '厴',
            '哊', '哨', '喟', '喩', '嗋', '嗗', '嘲', '嚈', '嚨', '囿', '圊', '堉', '堋', '堕',
            '塉', '塍', '塑', '墉', '墮', '壓', '壟', '壩', '壻', '奛', '奟', '奣', '姷', '娟',
            '婧', '婾', '婿', '媠', '媵', '嬴', '宥', '宵', '寗', '寵', '屑', '峭', '崤', '崩',
            '嶰', '巃', '幐', '廟', '廫', '弰', '弸', '彅', '徹', '悁', '悄', '悑', '情', '惰',
            '愈', '愉', '愑', '愬', '愶', '態', '憜', '憪', '懕', '戫', '捎', '捐', '掤', '掮',
            '掯', '揃', '揄', '揹', '搠', '搰', '撒', '撤', '擪', '擶', '擺', '攏', '散', '斠',
            '明', '晡', '晴', '曌', '曨', '月', '有', '朋', '服', '朎', '朏', '朓', '朔', '朕',
            '朖', '朗', '朙', '望', '朜', '朝', '朞', '期', '朠', '朢', '朦', '朧', '枏', '栯',
            '梢', '棈', '棚', '楕', '楜', '楡', '榍', '榺', '榾', '槊', '樃', '橢', '橳', '檞',
            '檿', '櫤', '欛', '殽', '毹', '洧', '消', '涓', '淆', '淝', '淯', '清', '渝', '渭',
            '湑', '湔', '湖', '溯', '滑', '滕', '滫', '漘', '漰', '潮', '潸', '澈', '澥', '瀛',
            '瀞', '瀧', '灞', '焆', '焇', '煎', '煹', '熊', '燗', '爯', '牏', '牖', '狷', '猒',
            '猜', '猢', '猬', '猾', '獬', '玥', '琄', '琑', '瑚', '瑜', '瓏', '甧', '甩', '痏',
            '痟', '痡', '瘉', '瘠', '癒', '盙', '盟', '眀', '睊', '睛', '瞮', '瞯', '矟', '硝',
            '确', '硼', '碿', '磆', '礀', '礱', '礴', '稍', '稰', '窬', '竉', '筋', '筲', '箐',
            '箙', '箭', '箶', '簙', '簠', '籐', '籘', '籝', '籠', '精', '糈', '糊', '糏', '絹',
            '綃', '綪', '綳', '緭', '縢', '繃', '繖', '罥', '罷', '羂', '羆', '羭', '羸', '翦',
            '耼', '聾', '肋', '肌', '肎', '肓', '肖', '肘', '肚', '肛', '肜', '肝', '肞', '股',
            '肢', '肥', '肦', '肧', '肩', '肪', '肫', '肬', '肭', '肯', '肱', '育', '肴', '肸',
            '肹', '肺', '胃', '胄', '胆', '胈', '背', '胍', '胎', '胏', '胒', '胕', '胖', '胗',
            '胘', '胙', '胚', '胛', '胝', '胞', '胠', '胡', '胤', '胥', '胭', '胮', '胯', '胰',
            '胱', '胲', '胳', '胴', '胶', '胸', '胹', '胺', '胼', '能', '脂', '脃', '脅', '脆',
            '脇', '脈', '脉', '脊', '脋', '脖', '脗', '脘', '脚', '脛', '脜', '脞', '脠', '脣',
            '脤', '脧', '脩', '脬', '脯', '脰', '脱', '脳', '脵', '脹', '脺', '脼', '脾', '腅',
            '腆', '腇', '腊', '腋', '腌', '腎', '腑', '腒', '腓', '腔', '腕', '腗', '腟', '腠',
            '腡', '腥', '腦', '腧', '腨', '腩', '腫', '腭', '腮', '腯', '腰', '腱', '腴', '腷',
            '腸', '腹', '腺', '腿', '膀', '膁', '膂', '膃', '膄', '膅', '膆', '膈', '膊', '膋',
            '膎', '膏', '膓', '膕', '膖', '膘', '膚', '膛', '膜', '膝', '膞', '膠', '膢', '膣',
            '膤', '膨', '膩', '膮', '膰', '膲', '膳', '膴', '膵', '膸', '膺', '膻', '膽', '膾',
            '膿', '臀', '臂', '臃', '臅', '臆', '臈', '臉', '臊', '臍', '臎', '臏', '臑', '臓',
            '臕', '臗', '臘', '臙', '臚', '臛', '臝', '臞', '臟', '艄', '荕', '莆', '莦', '菁',
            '菔', '萌', '萠', '葥', '葪', '葫', '蒨', '蒯', '蒱', '蒴', '蓇', '蔳', '蕑', '薢',
            '藤', '蘎', '蘛', '蘢', '蚦', '蛕', '蛸', '蜅', '蜎', '蜟', '蜻', '蝓', '蝟', '蝴',
            '螣', '蟕', '蠃', '衚', '衻', '褕', '褙', '褜', '褠', '褦', '襉', '襲', '覇', '覦',
            '覵', '角', '觔', '觕', '觖', '觗', '觘', '觥', '觩', '觫', '觭', '觱', '觳', '觶',
            '觹', '觽', '觿', '誚', '誧', '請', '諝', '諭', '謂', '謄', '謭', '譾', '讋', '豅',
            '豚', '貐', '賄', '賸', '贏', '趙', '跀', '踰', '蹐', '輣', '輸', '轍', '迶', '逍',
            '逳', '逾', '遡', '遯', '郁', '郙', '鄘', '酭', '酳', '酺', '醐', '醑', '鈅', '銷',
            '鋗', '錆', '錥', '鍮', '鏅', '鏞', '鐗', '鑨', '陏', '陗', '隃', '隋', '随', '隨',
            '隳', '隴', '霄', '霡', '霢', '霰', '霸', '青', '靕', '靖', '靗', '靘', '静', '靚',
            '靛', '靜', '鞘', '鞙', '鞲', '韝', '餚', '餬', '餺', '饜', '駽', '騰', '骨', '骪',
            '骬', '骭', '骮', '骯', '骰', '骲', '骴', '骵', '骶', '骸', '骹', '骻', '骼', '骾',
            '骿', '髀', '髁', '髃', '髄', '髆', '髈', '髎', '髏', '髐', '髑', '髒', '髓', '體',
            '髕', '髖', '髗', '髥', '鬅', '鬋', '鬌', '鬍', '鬜', '鬴', '魈', '魘', '鮪', '鮹',
            '鯖', '鰖', '鰧', '鱅', '鵑', '鵩', '鵬', '鶄', '鶘', '鶺', '鶻', '鷳', '黱', '鼱',
            '龍', '龏', '龐', '龑', '龒', '龔', '龕', '龖', '龗',
        ],
    },
    Membership {
        radical: '⺣',
        strokes: 4,
        kanji: &[
            '偽', '僞', '儘', '儵', '儻', '冩', '凞', '勲', '勳', '叅', '喣', '嗚', '嘸', '嘿',
            '噍', '嚕', '嚥', '囌', '塢', '塨', '墌', '墨', '墲', '壎', '壗', '壥', '媽', '嫣',
            '嫵', '嫶', '嬀', '寫', '嶋', '嶌', '嶕', '庶', '廌', '廡', '憑', '憔', '憮', '戃',
            '掭', '摭', '撚', '撝', '撡', '撨', '撫', '攩', '曛', '杰', '槱', '樢', '樵', '橅',
            '橪', '櫓', '歍', '漁', '潙', '潟', '濕', '濹', '瀉', '灋', '灬', '炁', '炰', '点',
            '為', '烈', '烋', '烏', '烝', '烹', '焄', '焉', '焏', '無', '焦', '然', '煎', '煕',
            '煞', '煦', '照', '煮', '熈', '熊', '熏', '熙', '熟', '熬', '熱', '熹', '燃', '燋',
            '燕', '燼', '燾', '爇', '爲', '獯', '瑦', '瑪', '璑', '甒', '癄', '癬', '瞧', '碼',
            '磶', '礁', '穌', '穭', '窯', '窵', '篤', '篶', '糕', '繎', '纁', '纆', '纒', '罵',
            '羆', '羈', '羔', '羮', '羹', '膲', '膴', '臕', '臙', '舃', '舔', '艪', '蒸', '蔗',
            '蔦', '蔫', '蔿', '蕉', '蕪', '薊', '薦', '薫', '藎', '藨', '蘇', '蘍', '蘓', '蘚',
            '蘸', '螐', '蟭', '蟱', '裊', '覊', '譌', '譙', '讌', '讜', '贐', '贗', '蹠', '遮',
            '鄔', '鄢', '鄥', '醮', '醺', '醼', '鐎', '鑣', '闖', '隖', '隝', '隰', '隲', '隳',
            '靎', '靏', '韅', '韉', '顦', '顯', '餻', '馬', '馭', '馮', '馳', '馴', '馼', '駁',
            '駄', '駅', '駆', '駈', '駐', '駑', '駒', '駕', '駘', '駛', '駝', '駟', '駢', '駭',
            '駮', '駱', '駲', '駸', '駻', '駿', '騁', '騅', '騎', '騏', '騒', '験', '騙', '騨',
            '騫', '騰', '騷', '騾', '驀', '驂', '驃', '驅', '驍', '驕', '驗', '驚', '驛', '驟',
            '驢', '驤', '驥', '驩', '驪', '驫', '魚', '魛', '魞', '魡', '魣', '魥', '魦', '魨',
            '魪', '魫', '魬', '魭', '魮', '魯', '魳', '魴', '魵', '魷', '魸', '魹', '魿', '鮀',
            '鮃', '鮄', '鮅', '鮆', '鮇', '鮉', '鮊', '鮋', '鮍', '鮎', '鮏', '鮐', '鮑', '鮒',
            '鮓', '鮔', '鮖', '鮗', '鮚', '鮝', '鮞', '鮟', '鮠', '鮦', '鮧', '鮨', '鮩', '鮪',
            '鮫', '鮬', '鮭', '鮮', '鮰', '鮱', '鮲', '鮴', '鮷', '鮸', '鮹', '鮻', '鮼', '鮾',
            '鮿', '鯀', '鯁', '鯆', '鯇', '鯈', '鯉', '鯊', '鯎', '鯏', '鯐', '鯑', '鯒', '鯔',
            '鯖', '鯗', '鯘', '鯛', '鯝', '鯟', '鯡', '鯢', '鯣', '鯤', '鯥', '鯧', '鯨', '鯪',
            '鯫', '鯯', '鯰', '鯱', '鯲', '鯳', '鯵', '鯷', '鯸', '鯹', '鯺', '鯽', '鯿', '鰀',
            '鰂', '鰄', '鰆', '鰈', '鰉', '鰊', '鰋', '鰌', '鰍', '鰏', '鰐', '鰑', '鰒', '鰓',
            '鰔', '鰕', '鰖', '鰘', '鰙', '鰚', '鰛', '鰜', '鰞', '鰡', '鰢', '鰣', '鰤', '鰥',
            '鰦', '鰧', '鰨', '鰩', '鰪', '鰭', '鰮', '鰯', '鰰', '鰱', '鰲', '鰵', '鰶', '鰷',
            '鰹', '鰺', '鰻', '鰽', '鰾', '鱁', '鱃', '鱄', '鱅', '鱆', '鱇', '鱈', '鱉', '鱊',
            '鱎', '鱏', '鱐', '鱒', '鱓', '鱔', '鱖', '鱗', '鱘', '鱚', '鱛', '鱜', '鱝', '鱞',
            '鱟', '鱠', '鱣', '鱧', '鱨', '鱩', '鱪', '鱫', '鱮', '鱰', '鱲', '鱵', '鱶', '鱷',
            '鱸', '鱻', '鳥', '鳦', '鳧', '鳩', '鳫', '鳰', '鳲', '鳳', '鳴', '鳶', '鳷', '鳹',
            '鴂', '鴃', '鴆', '鴇', '鴈', '鴉', '鴋', '鴎', '鴑', '鴒', '鴕', '鴗', '鴘', '鴛',
            '鴜', '鴝', '鴞', '鴟', '鴣', '鴦', '鴨', '鴪', '鴫', '鴬', '鴯', '鴰', '鴲', '鴳',
            '鴴', '鴺', '鴻', '鴼', '鴽', '鴾', '鴿', '鵁', '鵂', '鵃', '鵄', '鵅', '鵆', '鵇',
            '鵈', '鵊', '鵐', '鵑', '鵓', '鵔', '鵙', '鵜', '鵝', '鵞', '鵟', '鵠', '鵡', '鵢',
            '鵣', '鵤', '鵥', '鵩', '鵪', '鵫', '鵬', '鵯', '鵰', '鵲', '鵶', '鵷', '鵺', '鵻',
            '鵼', '鵾', '鶃', '鶄', '鶆', '鶇', '鶉', '鶊', '鶍', '鶎', '鶏', '鶒', '鶓', '鶕',
            '鶖', '鶗', '鶘', '鶚', '鶡', '鶤', '鶩', '鶪', '鶫', '鶬', '鶮', '鶯', '鶱', '鶲',
            '鶴', '鶵', '鶸', '鶹', '鶺', '鶻', '鶼', '鶿', '鷁', '鷂', '鷃', '鷄', '鷆', '鷇',
            '鷉', '鷊', '鷏', '鷓', '鷔', '鷕', '鷖', '鷗', '鷙', '鷚', '鷞', '鷟', '鷠', '鷥',
            '鷦', '鷧', '鷩', '鷫', '鷭', '鷮', '鷯', '鷰', '鷲', '鷳', '鷴', '鷸', '鷹', '鷺',
            '鷽', '鷾', '鸂', '鸇', '鸊', '鸎', '鸐', '鸑', '鸒', '鸕', '鸖', '鸙', '鸚', '鸛',
            '鸜', '鸝', '鸞', '麃', '黒', '黔', '黕', '默', '黙', '黛', '黜', '黝', '點', '黟',
            '黠', '黤', '黥', '黧', '黨', '黬', '黭', '黮', '黯', '黰', '黱', '黲', '黴', '黵',
            '黶', '黷', '黸',
        ],
    },
    Membership {
        radical: '王',
        strokes: 4,
        kanji: &[
            '丟', '主', '任', '住', '佯', '佺', '侹', '偟', '傞', '僐', '僕', '儀', '全', '再',
            '凰', '劷', '劻', '匡', '匩', '叢', '呈', '咩', '哢', '善', '喤', '嗟', '噠', '噩',
            '国', '垟', '埕', '堭', '墡', '妊', '姜', '媓', '宔', '宝', '寚', '寳', '寶', '對',
            '尩', '尫', '嵯', '嵳', '嶫', '嶬', '差', '幞', '庠', '庭', '廳', '廷', '弄', '彺',
            '往', '徉', '徨', '徴', '恇', '恙', '惶', '懟', '懲', '戜', '抂', '拄', '拴', '挵',
            '挺', '掴', '搓', '撲', '撻', '斑', '旺', '暀', '曦', '望', '朢', '枉', '柱', '栓',
            '框', '桯', '梃', '椢', '業', '楻', '槎', '様', '樣', '檉', '檥', '欉', '氧', '汪',
            '注', '洋', '浧', '淫', '渼', '湟', '滏', '漾', '潤', '澂', '濮', '瀁', '瀅', '炷',
            '烊', '煌', '燬', '牂', '牷', '犠', '犧', '狂', '玉', '王', '玎', '玐', '玓', '玕',
            '玖', '玗', '玘', '玜', '玞', '玟', '玠', '玢', '玥', '玦', '玩', '玪', '玫', '玭',
            '玲', '玳', '玵', '玷', '玹', '玻', '玼', '玽', '玿', '珀', '珂', '珅', '珆', '珈',
            '珉', '珊', '珋', '珌', '珍', '珎', '珏', '珒', '珓', '珖', '珙', '珝', '珞', '珠',
            '珡', '珣', '珥', '珦', '珧', '珩', '珪', '班', '珮', '珱', '珴', '珵', '珷', '珸',
            '珹', '珺', '珻', '珽', '現', '珿', '琀', '琁', '球', '琄', '琅', '理', '琇', '琉',
            '琊', '琑', '琚', '琛', '琢', '琤', '琥', '琦', '琨', '琩', '琪', '琬', '琭', '琮',
            '琯', '琰', '琱', '琲', '琳', '琴', '琵', '琶', '琹', '琺', '琿', '瑀', '瑁', '瑃',
            '瑄', '瑆', '瑇', '瑋', '瑍', '瑑', '瑒', '瑕', '瑗', '瑙', '瑚', '瑛', '瑜', '瑝',
            '瑞', '瑟', '瑠', '瑢', '瑣', '瑤', '瑦', '瑧', '瑨', '瑩', '瑪', '瑫', '瑭', '瑮',
            '瑯', '瑰', '瑱', '瑲', '瑳', '瑶', '瑾', '璀', '璁', '璃', '璅', '璆', '璇', '璉',
            '璋', '璏', '璐', '璑', '璒', '璘', '璙', '璚', '璜', '璞', '璟', '璠', '璡', '璢',
            '璣', '璦', '璧', '璨', '璩', '璪', '璫', '璮', '璯', '環', '璱', '璲', '璵', '璹',
            '璻', '璽', '璿', '瓈', '瓉', '瓊', '瓌', '瓏', '瓐', '瓓', '瓔', '瓘', '瓚', '瓛',
            '痊', '痒', '瘥', '癢', '癥', '癬', '皇', '皝', '盖', '眶', '着', '砡', '碧', '磋',
            '礒', '祥', '程', '窯', '筌', '筐', '筳', '筺', '篁', '糕', '紝', '絍', '縒', '繕',
            '罜', '羊', '羌', '羍', '美', '羏', '羑', '羔', '羖', '羗', '羚', '羜', '羝', '羞',
            '羡', '羢', '羣', '群', '羦', '羨', '義', '羪', '羭', '羮', '羯', '羲', '羴', '羶',
            '羸', '羹', '羼', '聖', '聽', '膳', '艇', '艎', '艖', '艤', '荃', '莛', '薘', '蘚',
            '蛀', '蜓', '蜣', '蝗', '蟶', '蟻', '衽', '袵', '裎', '褨', '觧', '註', '詮', '詳',
            '誆', '誑', '議', '譱', '讍', '賃', '跧', '蹉', '蹼', '躂', '躾', '軭', '輇', '迋',
            '逛', '逞', '遅', '遑', '達', '郢', '鄯', '鄴', '酲', '金', '釜', '鈺', '銓', '鋌',
            '鋥', '鍠', '鎂', '鎈', '鎌', '鏷', '鐵', '鐽', '閏', '閠', '闥', '隍', '霆', '霪',
            '韃', '頊', '頲', '飳', '養', '餻', '饈', '饍', '駐', '驖', '鬦', '鬫', '鬭', '鮮',
            '鯗', '鰉', '鱃', '鱔', '鱶', '鱷', '鵟', '鹺', '麈', '黈',
        ],
    },
    Membership {
        radical: '止',
        strokes: 4,
        kanji: &[
            '丐', '些', '企', '佂', '佌', '佱', '促', '倵', '凪', '劌', '卸', '呰', '唌', '啣',
            '嘴', '噛', '噦', '嚙', '嚦', '嚬', '囓', '址', '埏', '堽', '壢', '夒', '夔', '奯',
            '姃', '嫣', '尟', '屣', '巋', '巎', '巙', '延', '征', '徏', '徙', '御', '徰', '怔',
            '懥', '扯', '捉', '捗', '掯', '攊', '政', '整', '斌', '昰', '晸', '柴', '柾', '樾',
            '櫪', '欫', '止', '正', '此', '武', '歧', '歩', '歪', '歫', '歮', '歯', '歰', '歳',
            '歴', '歵', '歸', '沚', '泚', '涎', '渉', '渋', '潞', '澀', '澁', '濊', '瀕', '瀝',
            '焉', '獩', '玼', '珷', '璐', '疎', '疏', '疵', '症', '瘲', '癧', '眥', '眦', '砦',
            '碔', '祉', '禦', '穢', '筵', '篵', '篶', '簁', '籞', '紪', '紫', '綖', '緃', '罡',
            '翽', '耻', '肯', '胔', '脠', '芷', '茈', '莚', '蓯', '蓰', '蔫', '蔬', '蕋', '蕗',
            '薉', '藶', '蘋', '虁', '虣', '蜑', '蜒', '蟕', '衘', '觜', '証', '訾', '誕', '譅',
            '豵', '貲', '賦', '贇', '足', '趵', '趷', '趹', '趺', '趻', '趼', '趾', '跀', '跂',
            '跅', '跆', '跇', '跈', '跊', '跋', '跌', '跎', '跏', '跑', '跔', '跕', '跖', '跗',
            '跙', '跚', '跛', '距', '跟', '跡', '跣', '跤', '跥', '跧', '跨', '跪', '跫', '跬',
            '路', '跰', '跱', '跲', '跳', '跴', '践', '跼', '跽', '跿', '踁', '踄', '踆', '踈',
            '踉', '踊', '踋', '踏', '踐', '踑', '踔', '踖', '踝', '踞', '踟', '踠', '踡', '踢',
            '踣', '踦', '踪', '踰', '踱', '踳', '踴', '踵', '踶', '踷', '踸', '踹', '踽', '蹀',
            '蹁', '蹂', '蹄', '蹇', '蹈', '蹉', '蹊', '蹋', '蹌', '蹍', '蹎', '蹏', '蹐', '蹕',
            '蹙', '蹛', '蹜', '蹝', '蹞', '蹟', '蹠', '蹡', '蹢', '蹣', '蹤', '蹬', '蹭', '蹯',
            '蹰', '蹱', '蹲', '蹴', '蹶', '蹹', '蹺', '蹻', '蹼', '躁', '躂', '躃', '躄', '躅',
            '躇', '躊', '躋', '躍', '躐', '躑', '躒', '躓', '躔', '躕', '躙', '躚', '躝', '躞',
            '躡', '躢', '躧', '躩', '躪', '轣', '辵', '鄢', '鈣', '鉦', '鋋', '錻', '鏦', '鑡',
            '阯', '阷', '陟', '雌', '露', '靂', '靕', '頙', '頻', '頾', '顪', '顰', '騭', '骴',
            '髭', '鮆', '鯐', '鴜', '鵡', '鷺', '麪', '齒', '齓', '齔', '齕', '齖', '齗', '齘',
            '齚', '齝', '齞', '齟', '齠', '齡', '齢', '齣', '齦', '齧', '齨', '齩', '齪', '齬',
            '齭', '齮', '齯', '齰', '齱', '齲', '齳', '齵', '齶', '齷', '齺', '齽',
        ],
    },
    Membership {
        radical: '心',
        strokes: 4,
        kanji: &[
            '伈', '佖', '倊', '偬', '偲', '傯', '僾', '億', '儜', '優', '勰', '勴', '厯', '唸',
            '噁', '噫', '噯', '嚀', '埝', '妼', '媳', '嬡', '孞', '宓', '密', '寍', '寗', '寧',
            '崽', '幰', '廰', '廳', '徳', '心', '必', '忈', '忌', '忍', '忐', '忑', '忒', '志',
            '忘', '応', '忝', '忞', '忠', '忢', '忩', '念', '忽', '忿', '怎', '怒', '怘', '思',
            '怠', '怤', '急', '怨', '怭', '怱', '恁', '恋', '恐', '恕', '恖', '恙', '恚', '恝',
            '恣', '恥', '恧', '恩', '恭', '息', '恵', '恷', '恿', '悆', '悉', '悊', '悘', '悠',
            '患', '悤', '悥', '您', '悪', '悲', '悳', '悶', '惄', '惉', '惎', '惑', '惚', '惠',
            '惡', '惢', '惣', '惥', '想', '惷', '惹', '愁', '愂', '愆', '愈', '愍', '意', '愗',
            '愙', '愚', '愛', '感', '愡', '愢', '愨', '愬', '愿', '慁', '慂', '慇', '慈', '態',
            '慕', '慙', '慝', '慧', '慫', '慮', '慰', '慶', '慸', '慼', '慾', '慿', '憁', '憂',
            '憃', '憄', '憇', '憊', '憋', '憑', '憓', '憖', '憗', '憙', '憝', '憠', '憥', '憨',
            '憩', '憲', '憶', '憼', '憾', '懃', '懇', '應', '懋', '懕', '懟', '懣', '懧', '懬',
            '懯', '懲', '懸', '懿', '戀', '戁', '戇', '捴', '捻', '揔', '摠', '撼', '擰', '擾',
            '攄', '曖', '柲', '棯', '楤', '槵', '樒', '橤', '檍', '檸', '櫁', '櫌', '櫖', '櫽',
            '毖', '沁', '泌', '淰', '淴', '添', '漶', '潓', '濘', '濨', '濾', '瀀', '瀗', '熄',
            '燜', '爈', '牎', '牕', '獰', '珌', '瑟', '璁', '璦', '璱', '甯', '痣', '瘛', '瘜',
            '癋', '癒', '癮', '皧', '瞹', '矃', '礠', '祕', '秘', '稔', '穂', '穏', '穗', '穩',
            '窓', '窻', '綛', '総', '緦', '緫', '總', '繐', '纞', '耰', '聡', '聦', '聰', '聴',
            '聹', '聽', '腮', '臆', '芯', '苾', '荵', '葱', '葸', '蒽', '蔤', '蔥', '蕊', '蕙',
            '蕜', '薆', '薏', '薴', '藘', '藼', '蘂', '虙', '蜜', '螅', '蟋', '蟪', '覕', '覟',
            '訫', '誋', '誌', '認', '諗', '諰', '謐', '譓', '讔', '贃', '贒', '跽', '躵', '軈',
            '轗', '邲', '鈊', '鉍', '鋕', '錜', '鍯', '鍶', '鎴', '鏓', '鏸', '鐚', '鐿', '鑢',
            '閟', '隠', '隱', '靉', '顋', '顖', '颸', '飶', '馝', '駜', '騐', '驄', '鮅', '鯰',
            '鰓', '鱫', '鷾',
        ],
    },
    Membership {
        radical: '戈',
        strokes: 4,
        kanji: &[
            '伐', '俄', '僟', '儀', '儎', '减', '划', '剗', '劌', '咸', '哉', '哦', '喊', '嘎',
            '嘰', '噦', '嚱', '國', '垡', '城', '域', '堿', '奯', '娀', '威', '娍', '娥', '媙',
            '孅', '宬', '峨', '峩', '崴', '嶬', '巇', '幗', '幟', '幭', '幾', '悈', '惑', '感',
            '慼', '憾', '懴', '懺', '戈', '戉', '戊', '戌', '戍', '戎', '成', '我', '戒', '戓',
            '戔', '戕', '或', '戚', '戛', '戜', '戝', '戞', '戟', '戠', '戡', '戢', '戣', '戦',
            '戧', '戩', '截', '戫', '戮', '戯', '戰', '戲', '戳', '戴', '找', '摑', '撼', '擑',
            '旘', '晟', '晠', '曦', '栰', '栽', '桟', '械', '棧', '棫', '楲', '槭', '樴', '樾',
            '機', '檝', '檥', '櫼', '歳', '残', '殘', '殱', '殲', '毧', '泧', '浅', '淢', '淺',
            '減', '滅', '漍', '濈', '濊', '濺', '烕', '烖', '熾', '爴', '牋', '牫', '牮', '犠',
            '犧', '狘', '獩', '珴', '珹', '璣', '畿', '盛', '盞', '硪', '碊', '碱', '磯', '礒',
            '禨', '穖', '穢', '筏', '筬', '箋', '箴', '篾', '簂', '籖', '籛', '籤', '絨', '綫',
            '緎', '緘', '縅', '縬', '繊', '織', '纎', '纖', '罭', '羢', '義', '羲', '翽', '聀',
            '職', '肈', '胾', '膕', '臓', '臟', '臧', '臹', '艤', '茂', '茷', '荗', '荿', '莪',
            '葳', '葴', '蔑', '蔵', '蕆', '蕺', '薉', '藏', '蛾', '蜮', '蟈', '蟙', '蟣', '蟻',
            '蠘', '蠛', '衊', '裁', '裓', '襪', '襳', '觱', '誐', '誠', '誡', '諓', '諴', '譏',
            '識', '議', '讖', '賊', '賎', '賤', '贇', '贓', '越', '践', '踐', '蹙', '軄', '軾',
            '載', '轗', '郕', '醆', '醎', '鉞', '銊', '銭', '鋨', '鋮', '錢', '錻', '鍼', '鐖',
            '鐡', '鐵', '鑯', '閥', '閾', '鞿', '韈', '韤', '韯', '韱', '顑', '顣', '顪', '餓',
            '餞', '饑', '馘', '駴', '驖', '魕', '鯎', '鰄', '鰔', '鱵', '鵝', '鵞', '鵡', '鹹',
            '黬',
        ],
    },
    Membership {
        radical: '火',
        strokes: 4,
        kanji: &[
            '伙', '倐', '倓', '偢', '儝', '剡', '勞', '啖', '啾', '塋', '嫈', '嵤', '嶸', '恢',
            '惔', '愀', '愁', '憥', '掞', '揪', '撈', '棪', '楸', '榮', '樮', '檆', '檾', '欻',
            '歘', '毯', '氮', '淡', '湫', '滅', '滎', '澇', '濚', '瀅', '瀯', '火', '灮', '灯',
            '灰', '灵', '灶', '灸', '灼', '災', '灾', '炅', '炆', '炉', '炊', '炎', '炒', '炔',
            '炕', '炖', '炗', '炘', '炙', '炛', '炤', '炫', '炬', '炭', '炮', '炯', '炱', '炳',
            '炴', '炷', '炸', '烊', '烑', '烓', '烔', '烕', '烖', '烘', '烙', '烜', '烟', '烤',
            '烱', '烺', '烽', '焃', '焅', '焆', '焇', '焋', '焌', '焔', '焙', '焚', '焜', '焞',
            '焠', '焫', '焭', '焯', '焰', '焱', '焸', '焼', '煁', '煅', '煆', '煇', '煉', '煊',
            '煋', '煌', '煐', '煒', '煖', '煗', '煙', '煚', '煜', '煠', '煢', '煤', '煥', '煨',
            '煩', '煬', '煹', '煽', '熀', '熄', '熅', '熇', '熌', '熒', '熔', '熕', '熚', '熛',
            '熠', '熢', '熨', '熯', '熰', '熲', '熳', '熺', '熾', '熿', '燀', '燁', '燃', '燄',
            '燈', '燉', '燋', '燌', '燎', '燐', '燒', '燓', '燔', '燖', '燗', '燙', '燚', '燜',
            '營', '燠', '燥', '燦', '燧', '燬', '燭', '燮', '燵', '燸', '燹', '燻', '燼', '燿',
            '爀', '爆', '爈', '爉', '爍', '爐', '爓', '爗', '爚', '爛', '爝', '爟', '爤', '爨',
            '犖', '狄', '琰', '瑩', '甃', '畑', '疢', '痰', '癆', '盔', '睒', '碳', '禜', '秋',
            '緂', '縈', '罃', '罽', '耮', '耿', '腅', '膋', '荻', '菼', '萩', '蕿', '薠', '螢',
            '蠑', '裧', '褧', '詼', '談', '躞', '逖', '郯', '醔', '鈥', '錟', '鍬', '鎣', '鑅',
            '阦', '鞦', '颷', '飈', '餤', '鰍', '鶖', '鶯',
        ],
    },
    Membership {
        radical: '攵',
        strokes: 4,
        kanji: &[
            '修', '倏', '倣', '做', '傚', '傲', '僌', '僘', '儆', '儌', '儵', '儼', '冬', '処',
            '務', '勶', '厫', '厰', '厳', '各', '啓', '嗷', '噉', '噋', '噭', '嚴', '坆', '墩',
            '夂', '婺', '媺', '嫠', '嫩', '孜', '巌', '巖', '幑', '幣', '幤', '廒', '廠', '弊',
            '微', '徴', '徹', '徽', '悠', '愍', '愗', '慠', '憋', '憗', '憝', '憨', '憼', '懯',
            '懲', '撇', '撒', '撤', '撽', '擎', '擻', '攴', '攵', '收', '攷', '攸', '改', '攺',
            '攻', '攼', '攽', '放', '政', '敃', '故', '敇', '效', '敉', '敍', '敏', '敐', '救',
            '敒', '敔', '敕', '敖', '敗', '敘', '教', '敝', '敞', '敟', '敢', '散', '敦', '敫',
            '敬', '数', '敲', '整', '敵', '敷', '數', '斁', '斂', '斃', '晵', '晸', '暋', '暼',
            '暾', '曔', '曮', '条', '枚', '條', '棨', '橄', '檄', '檠', '氂', '氅', '浟', '液',
            '滌', '滫', '漖', '漦', '潡', '澂', '澈', '激', '瀲', '煞', '熬', '燉', '牧', '犛',
            '獒', '獘', '玁', '玫', '畋', '癥', '皦', '瞀', '瞥', '瞮', '瞰', '矙', '竅', '筱',
            '篠', '籔', '絛', '綮', '緻', '繁', '繖', '繳', '聱', '肇', '脩', '致', '荍', '莜',
            '蓚', '蔜', '蔲', '蔽', '薇', '薮', '藪', '蘞', '蘩', '蝥', '螫', '螯', '襒', '覈',
            '謷', '譈', '警', '變', '贁', '贅', '赦', '蹩', '轍', '遨', '邀', '釅', '釐', '鍪',
            '鏊', '鐓', '闙', '闝', '闞', '霚', '霧', '霰', '騖', '驁', '驚', '髮', '鬫', '魃',
            '鰲', '鰵', '鰷', '鱉', '鶩', '鷔', '鷩', '黴', '鼇', '鼈', '龞',
        ],
    },
    Membership {
        radical: '爪',
        strokes: 4,
        kanji: &[
            '乳', '乿', '亂', '俀', '俘', '偁', '傒', '傜', '僞', '僢', '僾', '凈', '受', '嗘',
            '噯', '嚼', '埒', '埰', '墾', '奚', '奨', '妥', '娞', '婇', '婬', '媛', '媱', '嬀',
            '嬡', '孚', '孵', '寀', '寽', '将', '崢', '嵈', '嵠', '彩', '徯', '愛', '慆', '懇',
            '抓', '挼', '捊', '捋', '授', '掙', '採', '援', '揺', '搯', '撝', '暖', '暚', '曖',
            '枛', '桴', '桵', '棌', '楥', '檃', '櫽', '殍', '浮', '淨', '淫', '渓', '湲', '溪',
            '滔', '潙', '煖', '爝', '爪', '爫', '爬', '爭', '爯', '爰', '爲', '爴', '爵', '猙',
            '猨', '猺', '琤', '瑗', '瑫', '瑶', '璦', '癮', '皧', '皭', '睜', '睬', '瞬', '瞹',
            '磎', '稃', '稱', '稲', '稻', '穏', '穩', '竫', '笊', '箏', '粰', '綏', '綬', '綵',
            '緩', '繇', '罦', '脬', '膎', '舀', '舜', '艀', '荽', '莩', '菜', '蒋', '蔿', '蕣',
            '蕿', '薆', '蘐', '虢', '蜉', '蝯', '螇', '覓', '覶', '諍', '諼', '謑', '謟', '謡',
            '譌', '讔', '谿', '蹈', '蹊', '轁', '辤', '辭', '遥', '郛', '酹', '酻', '醤', '釂',
            '采', '釽', '鋝', '錚', '鍰', '閿', '隱', '雞', '霪', '靉', '靜', '鞖', '鞱', '鞵',
            '韜', '颻', '餒', '饀', '馟', '鮾', '鰀', '鰩', '鱫', '鶏', '鷄', '鸂', '鼷',
        ],
    },
    Membership {
        radical: '曰',
        strokes: 4,
        kanji: &[
            '亯', '倝', '倬', '偒', '傹', '傽', '凕', '勆', '匫', '噆', '墇', '嫽', '嵑', '嶂',
            '嶛', '幜', '廜', '廥', '戠', '掉', '揎', '撦', '斮', '旵', '旾', '旿', '昍', '昒',
            '昖', '昝', '昣', '昦', '昩', '昷', '昹', '晀', '晆', '晊', '晘', '晵', '晹', '晼',
            '晿', '暚', '暛', '暜', '暟', '曂', '曃', '曌', '曎', '曔', '曫', '曮', '曰', '曵',
            '曷', '朇', '柦', '椱', '楦', '殟', '涽', '溍', '溻', '潭', '澓', '焸', '煋', '煚',
            '狟', '猲', '獠', '瑨', '璋', '璮', '畼', '瘴', '睗', '碏', '磳', '箺', '篂', '簟',
            '緄', '緆', '緍', '翨', '蔇', '蕈', '蟙', '蟺', '蠞', '誯', '誻', '譚', '貋', '賯',
            '趞', '趠', '踷', '躢', '逿', '遢', '郒', '鄍', '鄶', '鈤', '鍺', '鐔', '鐕', '鐟',
            '鐯', '鑙', '陼', '韅', '飦', '飶', '餇', '餟', '餴', '餹', '饇', '饙', '饛', '馛',
            '馝', '馟', '驔', '鬄', '鬺', '鯹', '鰑', '鰨', '鰽', '鶕', '鶗', '麘', '齃', '齄',
        ],
    },
    Membership {
        radical: '方',
        strokes: 4,
        kanji: &[
            '仿', '倣', '傍', '傲', '儌', '厫', '唹', '嗷', '嗾', '噭', '圀', '坊', '堃', '妨',
            '嵭', '廒', '彷', '徬', '徼', '慠', '懯', '房', '揓', '搒', '撽', '放', '敖', '敫',
            '敷', '方', '於', '施', '斿', '旁', '旂', '旃', '旄', '旅', '旆', '旈', '旉', '旋',
            '旌', '旎', '族', '旐', '旒', '旔', '旖', '旗', '旘', '旙', '旛', '旟', '昉', '枋',
            '棜', '椖', '椸', '楞', '榜', '檄', '汸', '淤', '游', '滂', '漩', '激', '熬', '牓',
            '獒', '璇', '瘀', '皦', '眆', '磅', '祊', '竅', '簇', '簱', '籏', '籩', '紡', '繳',
            '聱', '肪', '膀', '膂', '膐', '臱', '舫', '芳', '菸', '葹', '蒡', '蔜', '蔟', '蝣',
            '螃', '螯', '覈', '訪', '謗', '謷', '贅', '遊', '遨', '邀', '邊', '邡', '鈁', '錺',
            '鎊', '鏃', '鏇', '鏊', '閍', '閼', '防', '雱', '餝', '驁', '髈', '髣', '魴', '鯲',
            '鰲', '鴋', '鷔', '鷟', '鼇',
        ],
    },
    Membership {
        radical: '水',
        strokes: 4,
        kanji: &[
            '俅', '冰', '函', '剥', '劚', '厡', '呇', '咏', '嘯', '嚟', '囦', '埭', '尿', '巹',
            '康', '彔', '怺', '慷', '拯', '捄', '捸', '救', '昶', '昹', '暴', '曃', '曝', '柡',
            '桼', '梂', '棣', '楾', '様', '樣', '毬', '水', '氶', '氷', '永', '氺', '求', '汞',
            '沓', '沗', '泉', '泰', '泳', '泴', '洯', '浗', '涵', '淥', '淼', '湶', '溙', '滎',
            '滕', '漆', '漛', '漦', '漾', '漿', '潁', '澃', '瀑', '瀟', '瀠', '灥', '烝', '爆',
            '球', '琭', '瓈', '盥', '砅', '碌', '祿', '禄', '穅', '簫', '簶', '籐', '籙', '粶',
            '糠', '絿', '緑', '線', '繍', '脉', '腺', '膝', '莍', '菉', '藜', '藤', '裘', '褱',
            '襮', '觩', '詠', '誻', '賕', '踏', '逑', '逮', '逯', '遲', '邌', '醁', '銶', '錔',
            '録', '閖', '阥', '隶', '隷', '隸', '霡', '靆', '鞜', '頮', '顄', '騄', '鱇', '黍',
            '黎', '黏', '黐', '龣',
        ],
    },
    Membership {
        radical: '斤',
        strokes: 4,
        kanji: &[
            '丘', '乴', '伒', '俽', '偱', '儨', '兵', '凘', '劕', '劤', '励', '匠', '厮', '后',
            '听', '哲', '唽', '啠', '嘶', '噺', '圻', '坵', '坼', '垢', '垽', '塹', '壍', '娎',
            '岳', '岴', '嶃', '嶄', '廝', '循', '忻', '悊', '惞', '慙', '慚', '所', '折', '拆',
            '掀', '撕', '斤', '斥', '斦', '斧', '斫', '斬', '断', '斮', '斯', '新', '斲', '斳',
            '斴', '斷', '旂', '昕', '晢', '晰', '晳', '暫', '析', '柝', '栃', '梹', '楯', '槧',
            '欣', '歽', '沂', '泝', '派', '浙', '浜', '淅', '漸', '澌', '澵', '炘', '狾', '皙',
            '盾', '砺', '磛', '礩', '祈', '簛', '脈', '芹', '茊', '蔪', '薪', '蘄', '虗', '蚚',
            '蚯', '蚸', '蛎', '蜇', '蜥', '蟖', '訢', '訴', '誓', '質', '跅', '踅', '蹔', '躓',
            '近', '逝', '遁', '邱', '釿', '鋲', '鏨', '鐁', '鑕', '靳', '頎', '駈', '鬂', '鬭',
            '齗', '齭',
        ],
    },
    Membership {
        radical: '比',
        strokes: 4,
        kanji: &[
            '仳', '偕', '儳', '儷', '劖', '吡', '喈', '坒', '堦', '塵', '妣', '媲', '孋', '屁',
            '崑', '巉', '庇', '彲', '悂', '批', '揩', '摝', '攈', '攙', '攟', '攦', '昆', '曬',
            '枇', '棍', '楷', '樚', '欃', '欐', '比', '毖', '毘', '毚', '沘', '混', '湝', '漉',
            '灑', '焜', '狴', '玭', '琨', '琵', '皆', '砒', '磇', '秕', '稭', '箆', '箟', '篦',
            '簏', '籭', '粃', '紕', '緄', '纔', '纚', '臕', '芘', '菎', '蓖', '薼', '藨', '蚍',
            '螕', '諧', '讒', '豼', '貔', '躧', '輥', '轆', '邐', '鄜', '酈', '釃', '錕', '鍇',
            '鎞', '鏖', '鑣', '鑱', '陛', '階', '餛', '饞', '驪', '魮', '鯤', '鵾', '鸝', '鹿',
            '麀', '麁', '麂', '麃', '麄', '麅', '麇', '麈', '麋', '麌', '麎', '麏', '麑', '麒',
            '麓', '麕', '麖', '麗', '麘', '麛', '麝', '麞', '麟', '麤',
        ],
    },
    Membership {
        radical: '欠',
        strokes: 4,
        kanji: &[
            '佽', '俽', '劂', '厥', '吹', '咨', '嗽', '坎', '姿', '崁', '嵌', '嶔', '廞', '忺',
            '恣', '惞', '慾', '憠', '懿', '掀', '撅', '撳', '杴', '栨', '樕', '橛', '欠', '次',
            '欣', '欤', '欧', '欨', '欫', '欬', '欯', '欲', '欵', '欶', '欷', '欸', '欹', '欺',
            '欻', '欽', '款', '欿', '歃', '歆', '歇', '歉', '歊', '歌', '歍', '歎', '歐', '歒',
            '歓', '歔', '歖', '歘', '歙', '歛', '歝', '歟', '歠', '歡', '漱', '炊', '獗', '瓷',
            '盗', '盜', '砍', '篏', '簌', '粢', '缼', '羡', '羨', '芡', '茨', '蔌', '蕨', '蠍',
            '諮', '資', '赥', '趑', '趦', '蹶', '軟', '遬', '鏉', '闕', '預', '飮', '飲', '餈',
            '鱖', '龡',
        ],
    },
    Membership {
        radical: '殳',
        strokes: 4,
        kanji: &[
            '匓', '墢', '墼', '壂', '媻', '幋', '廏', '廢', '彀', '役', '愨', '慇', '投', '搬',
            '摋', '撃', '擊', '椴', '榖', '槃', '殳', '殴', '段', '殷', '殸', '殹', '殺', '殻',
            '殼', '殽', '殾', '殿', '毀', '毃', '毄', '毅', '毆', '毉', '没', '潑', '澱', '煅',
            '燬', '疫', '瘢', '癜', '發', '盤', '瞖', '磐', '磤', '磬', '祋', '穀', '糓', '緞',
            '縠', '繄', '繋', '繫', '罄', '羖', '翳', '聲', '股', '臀', '臋', '般', '芟', '葮',
            '蔎', '蕟', '蘙', '螌', '蟿', '蠮', '襏', '觳', '設', '謦', '譭', '豛', '轂', '酘',
            '醫', '醱', '鍛', '鎩', '鏧', '鏺', '鑿', '鞶', '馨', '驋', '骰', '鷇', '鷖',
        ],
    },
    Membership {
        radical: '氏',
        strokes: 4,
        kanji: &[
            '低', '儕', '冺', '劑', '厎', '呧', '嚌', '坻', '奃', '姄', '婚', '岷', '岻', '帋',
            '底', '弤', '彽', '忯', '怟', '惛', '惽', '愍', '扺', '抵', '抿', '擠', '敃', '昏',
            '昬', '暋', '柢', '桰', '棔', '氏', '氐', '民', '氒', '氓', '泜', '泯', '涽', '湣',
            '濟', '牴', '珉', '眠', '睧', '砥', '祇', '祗', '秖', '秪', '穧', '紙', '緍', '緡',
            '纃', '罠', '羝', '胝', '膐', '臍', '舐', '芪', '苠', '茋', '薺', '虀', '蚳', '蟁',
            '蠐', '衹', '袛', '觗', '觝', '詆', '赿', '躋', '邸', '銽', '閽', '阺', '隮', '霢',
            '霽', '韲', '骶', '鯳', '鴟', '齊', '齋', '齎', '齏',
        ],
    },
    Membership {
        radical: '牛',
        strokes: 4,
        kanji: &[
            '件', '侏', '侔', '制', '剷', '劺', '吽', '嚳', '墀', '嶰', '廨', '恈', '惣', '懈',
            '掣', '朱', '株', '桙', '樨', '檞', '殊', '洙', '淛', '澔', '澥', '牛', '牜', '牝',
            '牞', '牟', '牠', '牡', '牢', '牣', '牧', '牨', '物', '牫', '牮', '牯', '牱', '牲',
            '牴', '牷', '牸', '特', '牻', '牼', '牽', '牾', '牿', '犁', '犂', '犄', '犇', '犉',
            '犍', '犎', '犒', '犓', '犖', '犛', '犠', '犢', '犧', '犨', '猘', '獬', '珠', '眸',
            '瞬', '穉', '窂', '舜', '茱', '薢', '蛑', '蛛', '蟹', '蠏', '製', '觕', '解', '誅',
            '迭', '遲', '邂', '鈝', '鉾', '銖', '鯯', '鴾', '麰',
        ],
    },
    Membership {
        radical: '⺹',
        strokes: 4,
        kanji: &[
            '佬', '侾', '偖', '儲', '咾', '哮', '嗜', '堵', '墸', '奢', '奲', '姥', '孝', '宯',
            '屠', '帾', '庨', '廜', '拷', '搘', '撦', '教', '暑', '曙', '栲', '栳', '楮', '櫧',
            '殾', '渚', '漖', '潴', '瀦', '烤', '煮', '猪', '瘏', '睹', '硣', '箸', '緒', '署',
            '翥', '老', '考', '耄', '者', '耆', '耇', '耈', '耊', '耋', '荖', '著', '蓍', '蕏',
            '薯', '藷', '蛯', '螧', '褚', '覩', '誟', '諸', '豬', '賭', '赭', '踷', '躇', '都',
            '酵', '銠', '鍺', '鐯', '闍', '陼', '鬐', '鮱', '鯺', '鰭', '鱪', '鱰',
        ],
    },
    Membership {
        radical: '勿',
        strokes: 4,
        kanji: &[
            '偒', '偬', '傷', '刎', '剔', '勿', '匆', '匫', '吻', '囫', '圽', '埸', '場', '塲',
            '忽', '怱', '惕', '惚', '惣', '愓', '愡', '慯', '掦', '揔', '揚', '昒', '易', '昜',
            '晹', '暘', '暢', '楊', '楤', '歾', '殤', '沕', '淴', '湯', '煬', '燙', '牎', '物',
            '犂', '瑒', '畼', '痬', '瘍', '睗', '碭', '禓', '笏', '緆', '緫', '聦', '脗', '腸',
            '膓', '舓', '芴', '葱', '蕩', '虝', '蜴', '蝪', '裼', '觴', '賜', '踢', '逷', '逿',
            '錫', '鍚', '鍯', '陽', '颺', '餳', '鬄', '鬺', '鯣', '鰑', '鶍', '黎',
        ],
    },
    Membership {
        radical: '⺭',
        strokes: 4,
        kanji: &[
            '杯', '榊', '礻', '礼', '礽', '社', '礿', '祀', '祁', '祄', '祅', '祆', '祇', '祈',
            '祉', '祊', '祋', '祏', '祐', '祑', '祓', '祔', '祕', '祖', '祗', '祚', '祛', '祜',
            '祝', '神', '祠', '祢', '祥', '祧', '祩', '祫', '祲', '祷', '祹', '祺', '祻', '祼',
            '祾', '祿', '禄', '禅', '禊', '禋', '禌', '禍', '禎', '福', '禑', '禓', '禔', '禕',
            '禖', '禘', '禛', '禝', '禡', '禧', '禨', '禩', '禪', '禫', '禮', '禯', '禰', '禱',
            '禳', '禴', '簶', '視', '鎺', '鰰',
        ],
    },
    Membership {
        radical: '爿',
        strokes: 4,
        kanji: &[
            '乖', '乘', '冀', '剩', '北', '匨', '嚥', '埀', '墏', '壮', '壯', '奘', '奨', '奫',
            '奬', '妝', '娤', '婣', '寐', '寝', '寢', '寤', '寱', '将', '將', '嶈', '弉', '彇',
            '戕', '斲', '槳', '漿', '潚', '焋', '燕', '爿', '牀', '牁', '牂', '牃', '牅', '牆',
            '状', '獎', '窹', '糚', '繡', '肅', '背', '臙', '荘', '莊', '蒋', '蔣', '藏', '螿',
            '蠨', '装', '裝', '讌', '蹡', '醤', '醬', '銺', '鏘', '鏽', '驌', '驥', '鱐', '鷫',
            '鼎', '鼏', '鼐', '鼑', '鼒',
        ],
    },
    Membership {
        radical: '戸',
        strokes: 4,
        kanji: &[
            '偏', '傓', '傖', '僱', '匾', '唳', '啓', '妒', '徧', '悷', '惼', '愴', '戸', '戹',
            '戻', '戽', '房', '所', '扁', '扃', '扆', '扇', '扈', '扉', '捩', '掮', '搶', '撝',
            '斒', '昈', '晵', '枦', '棙', '棨', '椖', '涙', '滄', '滬', '炉', '煽', '牖', '篇',
            '粐', '糄', '綟', '綮', '編', '翩', '肇', '肈', '肩', '舮', '艑', '芦', '萹', '藊',
            '蝙', '褊', '諞', '謆', '蹁', '遍', '鈩', '錑', '鍽', '阸', '雇', '顧', '馿', '騙',
            '騸', '鯿',
        ],
    },
    Membership {
        radical: '犬',
        strokes: 4,
        kanji: &[
            '伏', '倏', '厭', '厴', '吠', '哭', '嗅', '嚈', '囐', '壓', '宊', '嶽', '悷', '憖',
            '懕', '揬', '撚', '擪', '栿', '棙', '橪', '檿', '殠', '洑', '漭', '然', '燃', '犬',
            '犮', '状', '犾', '猋', '猒', '献', '猷', '獃', '獄', '獎', '獒', '獘', '獣', '獸',
            '獻', '瓛', '畎', '糗', '紱', '絥', '繎', '茯', '袱', '讞', '錑', '闃', '靨', '飆',
            '饜', '魘', '鮲', '鶪', '鸑', '默', '黙', '黶', '齅',
        ],
    },
    Membership {
        radical: '歹',
        strokes: 4,
        kanji: &[
            '例', '冽', '列', '劽', '咧', '塟', '夙', '姴', '屍', '歹', '死', '歽', '歾', '歿',
            '殀', '殂', '殃', '殄', '殅', '殆', '殉', '殊', '残', '殍', '殕', '殖', '殗', '殘',
            '殛', '殞', '殟', '殠', '殢', '殣', '殤', '殨', '殩', '殪', '殫', '殬', '殭', '殮',
            '殯', '殰', '殱', '殲', '洌', '烈', '臰', '茢', '薤', '薧', '蛚', '裂', '迾', '餮',
            '髒',
        ],
    },
    Membership {
        radical: '支',
        strokes: 4,
        kanji: &[
            '伎', '傁', '叏', '叓', '叟', '吱', '嘙', '妓', '屐', '岐', '帔', '庋', '庪', '廋',
            '弢', '忮', '技', '搜', '支', '攱', '枝', '柀', '歧', '溲', '瘦', '皷', '皽', '瞍',
            '瞽', '箥', '翅', '肢', '艘', '芰', '蔢', '蚑', '螋', '詖', '豉', '跂', '鈘', '鈹',
            '頍', '髲', '鮍', '鳷', '麬', '鼓', '鼔', '鼕', '鼖', '鼗', '鼙', '鼚', '鼛', '鼟',
        ],
    },
    Membership {
        radical: '巴',
        strokes: 4,
        kanji: &[
            '俋', '吧', '唈', '夿', '岊', '巴', '巵', '廱', '悒', '扈', '把', '挹', '杷', '栬',
            '梔', '浥', '淝', '滬', '灉', '灔', '爬', '爸', '琶', '疤', '癰', '皅', '笆', '簄',
            '紦', '耙', '肥', '脃', '色', '艴', '芭', '葩', '蕝', '蘎', '裛', '豝', '赩', '邑',
            '邕', '郌', '郒', '郶', '鈀', '銫', '鑱', '雝', '靶', '饞', '齆',
        ],
    },
    Membership {
        radical: '手',
        strokes: 4,
        kanji: &[
            '俄', '儀', '劧', '峨', '我', '手', '承', '拏', '拲', '拳', '拿', '挈', '挐', '挙',
            '掌', '掔', '掣', '揅', '搴', '搿', '摩', '摯', '撃', '撑', '擊', '擎', '擘', '擥',
            '擧', '擪', '擵', '攀', '攣', '檥', '欅', '犠', '珴', '癴', '看', '硪', '義', '芼',
            '藦', '蛾', '蟻', '襷', '襻', '誐', '議', '鋨', '餓', '魹',
        ],
    },
    Membership {
        radical: '元',
        strokes: 4,
        kanji: &[
            '元', '兘', '冠', '冦', '刓', '唍', '园', '垸', '完', '寇', '岏', '忨', '抏', '杬',
            '梡', '沅', '玩', '皖', '盶', '睆', '筦', '簆', '籞', '羦', '翫', '脘', '芫', '莞',
            '蒄', '蔲', '蚖', '輐', '酛', '鈨', '鋎', '阮', '院', '頑', '魭', '鯇', '黿', '齋',
        ],
    },
    Membership {
        radical: '父',
        strokes: 4,
        kanji: &[
            '交', '佼', '俲', '傚', '効', '咬', '姣', '恔', '挍', '效', '斧', '校', '洨', '滏',
            '父', '爸', '爹', '爺', '狡', '珓', '皎', '窔', '絞', '纐', '胶', '茭', '虠', '蛟',
            '賋', '跤', '較', '郊', '釜', '鉸', '餃', '駮', '骹', '鮫', '鵁', '齩',
        ],
    },
    Membership {
        radical: '爻',
        strokes: 4,
        kanji: &[
            '嚳', '壐', '嬭', '彌', '攀', '斅', '棥', '樊', '濔', '瀰', '燓', '爻', '爼', '爾',
            '獮', '獼', '璽', '礐', '礟', '礬', '禰', '穪', '薾', '蠒', '蠜', '襻', '覐', '覺',
            '覼', '訤', '邇', '鑈', '镾', '駁', '鱟', '鷞', '鷽', '黌',
        ],
    },
    Membership {
        radical: '文',
        strokes: 4,
        kanji: &[
            '刘', '剤', '吝', '対', '彣', '忞', '悋', '憫', '文', '斈', '斉', '斊', '斌', '斎',
            '斐', '斑', '旻', '汶', '済', '炆', '玟', '紊', '紋', '緕', '芠', '萕', '虔', '蚊',
            '贇', '閔', '閺', '雯', '顏', '馼',
        ],
    },
    Membership {
        radical: '毋',
        strokes: 4,
        kanji: &[
            '侮', '勄', '塰', '姆', '娒', '悔', '慣', '拇', '敏', '晦', '栂', '梅', '毋', '母',
            '毎', '毒', '毓', '海', '珻', '瑇', '痗', '碡', '繁', '纛', '苺', '莓', '蘩', '袰',
            '誨', '貫', '鉧', '鋂', '霉', '鰵',
        ],
    },
    Membership {
        radical: '片',
        strokes: 4,
        kanji: &[
            '奫', '婣', '彇', '沜', '潚', '片', '版', '牋', '牌', '牎', '牏', '牐', '牒', '牓',
            '牕', '牖', '牘', '繡', '肅', '蠨', '鏽', '驌', '魸', '鱐', '鷫', '鼎', '鼏', '鼐',
            '鼑', '鼒',
        ],
    },
    Membership {
        radical: '斗',
        strokes: 4,
        kanji: &[
            '図', '嵙', '戽', '抖', '斗', '斘', '料', '斛', '斜', '斝', '斟', '斠', '斡', '斣',
            '枓', '槲', '槹', '櫆', '科', '紏', '萪', '蚪', '蝌', '酙', '鈄', '鬦', '魁',
        ],
    },
    Membership {
        radical: '五',
        strokes: 4,
        kanji: &[
            '五', '伍', '俉', '吾', '唔', '圄', '娪', '寤', '忢', '悟', '捂', '敔', '晤', '梧',
            '浯', '牾', '珸', '窹', '絚', '緪', '衙', '語', '鋙', '鼯', '齬',
        ],
    },
    Membership {
        radical: '屯',
        strokes: 4,
        kanji: &[
            '吨', '噸', '囤', '屯', '忳', '扽', '旾', '杶', '沌', '炖', '瓲', '盹', '窀', '純',
            '肫', '芚', '蒓', '豘', '迍', '邨', '鈍', '頓', '飩', '魨',
        ],
    },
    Membership {
        radical: '井',
        strokes: 4,
        kanji: &[
            '丼', '井', '儺', '刱', '囲', '寒', '巷', '恭', '攤', '暴', '曩', '港', '爆', '畊',
            '異', '穽', '糞', '翼', '耕', '襄', '驤',
        ],
    },
    Membership {
        radical: '无',
        strokes: 4,
        kanji: &[
            '僭', '嘅', '噆', '墍', '妋', '廐', '悞', '摡', '无', '旡', '曁', '漑', '潛', '灊',
            '炁', '簪', '蔇', '蠶', '譖', '鐕', '鬵',
        ],
    },
    Membership {
        radical: '尤',
        strokes: 4,
        kanji: &[
            '僦', '厖', '尤', '尨', '就', '嵆', '巘', '庬', '牻', '犹', '疣', '稽', '肬', '蚘',
            '諬', '蹴', '鑙', '魷', '鷲',
        ],
    },
    Membership {
        radical: '毛',
        strokes: 4,
        kanji: &[
            '娓', '尾', '旄', '梶', '橇', '毛', '毟', '毫', '毬', '毯', '毳', '氈', '瓱', '竓',
            '粍', '耄', '耗', '髦', '麾',
        ],
    },
    Membership {
        radical: '气',
        strokes: 4,
        kanji: &[
            '愾', '气', '気', '氙', '氛', '氟', '氣', '氤', '氦', '氧', '氨', '氬', '氮', '氳',
            '汽', '滊', '餼',
        ],
    },
    Membership {
        radical: '田',
        strokes: 5,
        kanji: &[
            '亀', '伷', '伸', '佃', '侽', '便', '俜', '俾', '倮', '偎', '偪', '偲', '偶', '傀',
            '傅', '傳', '僤', '僧', '僵', '儡', '儣', '兤', '兾', '冀', '冑', '冨', '凍', '副',
            '剿', '劃', '劓', '勇', '勦', '勰', '勱', '勴', '勵', '匐', '匣', '匰', '卑', '単',
            '博', '厲', '厴', '叀', '呷', '呻', '哽', '唵', '喁', '喂', '喟', '單', '嗶', '嘼',
            '嘽', '噃', '噌', '嚊', '嚏', '嚔', '嚕', '嚝', '嚧', '囀', '囅', '囌', '囎', '團',
            '坤', '堛', '堺', '塁', '塊', '墖', '増', '墠', '墦', '壘', '壙', '壚', '夤', '夥',
            '奮', '奲', '妯', '娉', '娚', '婐', '婢', '媿', '嫂', '嫐', '嬋', '嬲', '嬶', '嬸',
            '宙', '寅', '富', '寓', '實', '審', '専', '專', '届', '層', '岫', '岬', '峺', '崽',
            '嵎', '嵬', '嶓', '巃', '巍', '巣', '幅', '幡', '庵', '庽', '庿', '廆', '廣', '廬',
            '弾', '彈', '彊', '彍', '彙', '思', '恵', '惈', '愊', '愚', '愢', '愧', '愽', '慉',
            '慮', '慱', '憎', '憚', '懥', '懬', '懭', '懯', '戦', '戰', '戴', '抻', '押', '抽',
            '挿', '捜', '描', '搏', '搐', '摜', '摶', '撣', '播', '擂', '擄', '擋', '擤', '擴',
            '擻', '攄', '敒', '敷', '旙', '旛', '暢', '曂', '曠', '曨', '更', '曽', '東', '果',
            '柙', '柚', '栧', '梗', '棟', '棵', '椳', '楅', '榊', '榑', '榴', '槐', '槫', '樌',
            '樏', '樔', '横', '樿', '橊', '橎', '橿', '檑', '櫆', '櫐', '櫑', '櫓', '櫔', '櫖',
            '櫨', '欂', '欄', '殫', '殭', '毌', '毘', '氎', '油', '沺', '浬', '淄', '淠', '渭',
            '湢', '湧', '湽', '溜', '溥', '溭', '溿', '滀', '滝', '漁', '演', '漯', '潓', '潘',
            '潢', '潬', '澑', '濞', '濾', '瀇', '瀋', '瀘', '瀷', '瀾', '煉', '煨', '熏', '熿',
            '燀', '燔', '燻', '爈', '爐', '牌', '狎', '猓', '猥', '猫', '猬', '獣', '獷', '獸',
            '獹', '瑠', '瑰', '璅', '璜', '璠', '璢', '璫', '瓐', '甎', '甑', '甥', '甦', '田',
            '由', '甲', '申', '甶', '男', '甸', '甹', '町', '画', '甼', '甽', '甾', '甿', '畀',
            '畄', '畆', '畇', '畈', '畉', '畊', '畋', '界', '畍', '畎', '畏', '畐', '畑', '畒',
            '畔', '畗', '留', '畚', '畛', '畜', '畝', '畞', '畟', '畠', '畡', '畢', '畤', '略',
            '畦', '畧', '畩', '番', '畫', '畭', '畯', '異', '畱', '畳', '畴', '當', '畷', '畸',
            '畹', '畺', '畻', '畼', '畽', '畾', '畿', '疁', '疂', '疅', '疆', '疇', '疉', '疊',
            '疐', '痹', '痺', '瘣', '瘤', '瘰', '癀', '癅', '癉', '癘', '癬', '皤', '盧', '睤',
            '睥', '瞄', '瞚', '矑', '砷', '硬', '碑', '碨', '磈', '磚', '磺', '磻', '礌', '礑',
            '礦', '礧', '礪', '神', '祼', '禅', '福', '禑', '禝', '禩', '禪', '禺', '秞', '稗',
            '稞', '稫', '稷', '稸', '穂', '穌', '穐', '穭', '窠', '窼', '竃', '竜', '笛', '筪',
            '箪', '篳', '簧', '簹', '簿', '籀', '籒', '籓', '籕', '籚', '粳', '粿', '糞', '糲',
            '紬', '累', '細', '紳', '綶', '緇', '緢', '緦', '緭', '練', '縄', '縛', '縯', '縲',
            '繅', '繙', '繟', '繮', '纊', '纍', '纑', '纝', '罍', '罏', '羀', '翈', '翻', '翼',
            '耦', '聭', '胃', '胄', '胛', '脾', '腗', '腮', '腷', '膊', '膚', '膰', '臚', '臝',
            '舅', '舳', '艣', '艪', '艫', '苗', '菑', '菓', '萬', '葍', '葘', '葸', '蒐', '蓄',
            '蓴', '蔂', '蔔', '蕃', '蕾', '薄', '薊', '薑', '藕', '藘', '藟', '藩', '蘄', '蘅',
            '蘆', '蘇', '蘒', '蘓', '蘚', '蘶', '蘽', '虆', '虜', '蚰', '蜔', '蜾', '蝉', '蝟',
            '蝠', '蝿', '螺', '螾', '蟠', '蟷', '蠆', '蠣', '衡', '袖', '裨', '裸', '裹', '褁',
            '褏', '褝', '襌', '襠', '襣', '觶', '課', '諌', '諰', '謂', '謖', '譂', '譒', '讄',
            '讅', '貓', '賻', '贈', '踝', '踴', '蹕', '蹯', '躉', '躔', '軃', '軸', '輜', '輠',
            '輺', '輻', '轉', '轓', '轤', '迪', '逼', '遇', '遛', '遦', '邁', '鄐', '鄱', '鄲',
            '鄺', '醜', '釉', '鈾', '鈿', '鉀', '鉮', '錙', '錨', '錬', '鍶', '鍿', '鎦', '鏁',
            '鏆', '鏍', '鐂', '鐄', '鐇', '鐳', '鐺', '鑛', '鑢', '鑪', '閘', '闡', '陳', '陴',
            '隅', '隈', '隗', '隟', '雷', '電', '霤', '靁', '鞞', '鞭', '鞸', '韁', '韠', '頔',
            '顆', '顋', '顒', '顰', '顱', '颸', '飅', '飜', '餜', '餵', '餽', '餾', '饆', '騁',
            '騨', '騮', '騾', '驑', '驢', '驥', '髀', '髁', '髃', '髆', '髗', '鬮', '鬼', '鬽',
            '魁', '魂', '魃', '魄', '魅', '魈', '魋', '魌', '魍', '魎', '魏', '魑', '魔', '魕',
            '魖', '魗', '魘', '魚', '魛', '魞', '魡', '魣', '魥', '魦', '魨', '魪', '魫', '魬',
            '魭', '魮', '魯', '魳', '魴', '魵', '魷', '魸', '魹', '魿', '鮀', '鮃', '鮄', '鮅',
            '鮆', '鮇', '鮉', '鮊', '鮋', '鮍', '鮎', '鮏', '鮐', '鮑', '鮒', '鮓', '鮔', '鮖',
            '鮗', '鮚', '鮝', '鮞', '鮟', '鮠', '鮦', '鮧', '鮨', '鮩', '鮪', '鮫', '鮬', '鮭',
            '鮮', '鮰', '鮱', '鮲', '鮴', '鮷', '鮸', '鮹', '鮻', '鮼', '鮾', '鮿', '鯀', '鯁',
            '鯆', '鯇', '鯈', '鯉', '鯊', '鯎', '鯏', '鯐', '鯑', '鯒', '鯔', '鯖', '鯗', '鯘',
            '鯛', '鯝', '鯟', '鯡', '鯢', '鯣', '鯤', '鯥', '鯧', '鯨', '鯪', '鯫', '鯯', '鯰',
            '鯱', '鯲', '鯳', '鯵', '鯷', '鯸', '鯹', '鯺', '鯽', '鯿', '鰀', '鰂', '鰄', '鰆',
            '鰈', '鰉', '鰊', '鰋', '鰌', '鰍', '鰏', '鰐', '鰑', '鰒', '鰓', '鰔', '鰕', '鰖',
            '鰘', '鰙', '鰚', '鰛', '鰜', '鰞', '鰡', '鰢', '鰣', '鰤', '鰥', '鰦', '鰧', '鰨',
            '鰩', '鰪', '鰭', '鰮', '鰯', '鰰', '鰱', '鰲', '鰵', '鰶', '鰷', '鰹', '鰺', '鰻',
            '鰽', '鰾', '鱁', '鱃', '鱄', '鱅', '鱆', '鱇', '鱈', '鱉', '鱊', '鱎', '鱏', '鱐',
            '鱒', '鱓', '鱔', '鱖', '鱗', '鱘', '鱚', '鱛', '鱜', '鱝', '鱞', '鱟', '鱠', '鱣',
            '鱧', '鱨', '鱩', '鱪', '鱫', '鱮', '鱰', '鱲', '鱵', '鱶', '鱷', '鱸', '鱻', '鴨',
            '鴫', '鵯', '鶇', '鶓', '鶹', '鷠', '鷭', '鸕', '黄', '黆', '黈', '黋', '黌', '黸',
            '鼉', '鼬', '鼺', '鼻', '鼼', '鼽', '鼾', '鼿', '齁', '齃', '齄', '齅', '齆', '齇',
            '齵', '龜', '龝',
        ],
    },
    Membership {
        radical: '目',
        strokes: 5,
        kanji: &[
            '且', '亹', '伹', '俎', '倛', '値', '倶', '偗', '偱', '側', '偵', '傄', '傊', '傎',
            '債', '傾', '僓', '僨', '價', '儐', '償', '儧', '儨', '儬', '儭', '儹', '具', '冒',
            '冝', '則', '劓', '劕', '劗', '助', '勖', '勗', '勛', '勣', '勩', '匱', '厠', '叠',
            '叡', '咀', '咱', '員', '哯', '唄', '嗅', '嗔', '嗩', '嗿', '嘎', '嘖', '嘳', '嘷',
            '噴', '噵', '噸', '嚊', '嚫', '嚬', '嚶', '囂', '囋', '囎', '圓', '圚', '坥', '埧',
            '埴', '塡', '塤', '填', '墳', '壝', '夏', '夐', '夒', '夓', '夔', '奡', '姐', '媚',
            '媜', '媢', '媳', '嬪', '嬰', '嬶', '嬾', '孀', '孾', '宜', '寘', '實', '寱', '寳',
            '寴', '寶', '尵', '屓', '屭', '岨', '峴', '崱', '嵋', '嵿', '嶺', '巎', '巓', '巙',
            '帽', '幀', '幘', '廁', '廂', '廎', '徂', '徝', '循', '怚', '息', '悓', '悳', '惧',
            '想', '惻', '愖', '愪', '愼', '慎', '慣', '慻', '憄', '憒', '憤', '憩', '懶', '懸',
            '懼', '戄', '戇', '戛', '戝', '揁', '揸', '損', '摜', '摣', '擤', '擯', '擷', '攅',
            '攖', '攢', '攫', '敗', '晛', '柤', '査', '梖', '梘', '植', '楂', '楣', '楨', '楯',
            '榎', '榭', '槇', '槓', '槙', '樌', '樝', '樻', '檟', '檱', '檳', '櫃', '櫌', '櫕',
            '櫝', '櫬', '櫻', '欑', '歵', '殂', '殖', '殞', '殠', '殨', '殯', '殰', '毷', '氈',
            '氍', '沮', '泪', '洎', '渞', '渣', '測', '渺', '渻', '湄', '湏', '湘', '湞', '湨',
            '溳', '滇', '漬', '潁', '潰', '澃', '澒', '澦', '濆', '濞', '濬', '濱', '濵', '濺',
            '濽', '瀀', '瀆', '瀕', '瀬', '瀴', '灈', '灝', '煩', '熄', '熕', '熲', '燌', '爼',
            '牘', '犢', '狙', '狽', '獖', '獱', '獺', '玃', '瑁', '瑣', '瑱', '璿', '瓉', '瓊',
            '瓔', '瓚', '甖', '疂', '疊', '疽', '瘜', '癟', '癩', '癪', '癭', '癯', '癲', '皟',
            '皥', '盨', '目', '盰', '盱', '盲', '直', '盶', '相', '盹', '盻', '盼', '盾', '眀',
            '省', '眄', '眆', '眇', '眈', '眉', '眊', '看', '県', '眎', '眒', '眕', '眗', '眙',
            '眚', '眛', '眜', '眞', '真', '眠', '眢', '眤', '眥', '眦', '眨', '眩', '眭', '眮',
            '眯', '眴', '眵', '眶', '眷', '眸', '眹', '眺', '眼', '眽', '着', '睂', '睅', '睆',
            '睇', '睊', '睍', '睎', '睏', '睒', '睖', '睗', '睚', '睛', '睜', '睞', '睟', '睠',
            '睡', '睢', '督', '睤', '睥', '睦', '睧', '睨', '睫', '睬', '睰', '睲', '睳', '睴',
            '睹', '睺', '睽', '睾', '睿', '瞀', '瞄', '瞋', '瞌', '瞍', '瞎', '瞑', '瞔', '瞕',
            '瞖', '瞚', '瞞', '瞟', '瞠', '瞢', '瞥', '瞧', '瞪', '瞬', '瞭', '瞮', '瞯', '瞰',
            '瞱', '瞳', '瞵', '瞶', '瞹', '瞻', '瞼', '瞽', '瞾', '瞿', '矃', '矇', '矉', '矍',
            '矑', '矒', '矕', '矗', '矙', '矚', '砠', '碩', '碵', '碽', '磌', '磒', '磧', '礥',
            '礩', '礵', '祖', '禎', '禛', '租', '稙', '稹', '積', '穎', '窅', '竇', '竩', '筯',
            '算', '箱', '箵', '篔', '篹', '簀', '簒', '簣', '籑', '籟', '籩', '籰', '籲', '粗',
            '糗', '組', '絸', '緗', '緲', '縜', '縝', '縣', '績', '繢', '繽', '纂', '纇', '纈',
            '纉', '續', '纐', '纓', '纘', '纛', '罌', '罝', '置', '翺', '耝', '耡', '耰', '聵',
            '脜', '腯', '膩', '臏', '臗', '臞', '自', '臫', '臬', '臭', '臰', '臱', '臲', '艏',
            '苜', '苴', '莇', '莧', '菹', '萓', '萯', '葅', '葙', '葚', '蒩', '蔶', '蕆', '蕒',
            '蕡', '蕢', '蕷', '薋', '薠', '藚', '藾', '蘋', '蘡', '虁', '虘', '蛆', '蛽', '螅',
            '蠙', '蠼', '衋', '衜', '衟', '衠', '衢', '襀', '襣', '襭', '襰', '見', '覍', '覐',
            '覔', '覕', '覛', '覜', '覟', '覠', '覥', '覰', '覴', '覵', '覶', '覷', '覼', '覿',
            '詛', '誼', '讀', '讃', '讚', '讟', '豶', '貜', '貝', '貞', '負', '財', '貢', '貤',
            '貧', '貨', '販', '貪', '貫', '責', '貭', '貮', '貯', '貰', '貲', '貳', '貴', '貶',
            '買', '貸', '貹', '貺', '費', '貼', '貽', '貿', '賀', '賁', '賂', '賃', '賄', '賅',
            '賆', '資', '賈', '賉', '賊', '賋', '賍', '賎', '賏', '賑', '賓', '賕', '賖', '賙',
            '賚', '賛', '賜', '賝', '賞', '賠', '賡', '賢', '賣', '賤', '賦', '賨', '質', '賬',
            '賭', '賯', '賰', '賲', '賵', '賷', '賸', '賺', '賻', '購', '賽', '賾', '賿', '贁',
            '贃', '贄', '贅', '贇', '贈', '贉', '贊', '贋', '贍', '贏', '贐', '贒', '贓', '贔',
            '贖', '贗', '贛', '赬', '趄', '趲', '跙', '蹎', '蹞', '蹟', '躓', '躩', '輴', '轒',
            '辠', '遁', '遉', '遦', '遺', '邉', '邊', '郥', '郿', '鄖', '鄮', '鄼', '酇', '鉏',
            '鋇', '鋤', '鋧', '鍘', '鍞', '鎖', '鎭', '鎮', '鎴', '鎺', '鏆', '鑌', '鑕', '鑚',
            '鑜', '鑟', '鑽', '钁', '閴', '闃', '闐', '闑', '闚', '闝', '闠', '阻', '隕', '隤',
            '雎', '霜', '霣', '靚', '靧', '靨', '靻', '鞼', '韇', '韻', '頁', '頂', '頃', '項',
            '順', '頇', '須', '頊', '頌', '頍', '頎', '頏', '預', '頑', '頒', '頓', '頔', '頖',
            '頗', '領', '頙', '頚', '頜', '頞', '頠', '頡', '頣', '頤', '頥', '頦', '頫', '頬',
            '頭', '頮', '頯', '頰', '頲', '頳', '頴', '頵', '頷', '頸', '頻', '頼', '頽', '頾',
            '顄', '顆', '顇', '顊', '顋', '題', '額', '顎', '顏', '顑', '顒', '顓', '顔', '顕',
            '顖', '顗', '願', '顙', '顚', '顛', '類', '顢', '顣', '顥', '顦', '顧', '顪', '顫',
            '顬', '顯', '顰', '顱', '顳', '顴', '颶', '饋', '饙', '首', '馗', '馘', '駔', '髕',
            '髖', '鬒', '鬚', '鬢', '鬹', '鰂', '鱝', '鵙', '鶪', '鷆', '鷏', '鸎', '鸚', '鸜',
            '黰', '黷', '鼎', '鼏', '鼐', '鼑', '鼒', '鼻', '鼼', '鼽', '鼾', '鼿', '齁', '齃',
            '齄', '齅', '齆', '齇', '齎', '齟', '龥',
        ],
    },
    Membership {
        radical: '立',
        strokes: 5,
        kanji: &[
            '乵', '位', '倍', '倖', '偐', '偙', '偣', '傍', '傡', '傹', '傽', '僮', '僻', '億',
            '儭', '儱', '剖', '剷', '劈', '勏', '咅', '唼', '商', '啦', '啻', '啼', '喑', '噫',
            '噺', '嚨', '嚫', '圉', '垃', '執', '培', '報', '境', '墇', '壁', '壟', '妾', '婄',
            '嫜', '嫡', '嬖', '孼', '孽', '宰', '寴', '寵', '岦', '嵃', '嵜', '嶂', '巃', '帝',
            '幛', '幟', '幢', '幸', '彦', '彰', '徬', '徸', '意', '愔', '慞', '憧', '憶', '懌',
            '戇', '戠', '拉', '掊', '接', '揥', '搒', '摘', '摯', '撞', '撻', '擇', '擗', '擘',
            '擿', '攏', '攱', '敵', '新', '旁', '旘', '昱', '暗', '暜', '暲', '曈', '曨', '朧',
            '柆', '梓', '棓', '椄', '楴', '榜', '槞', '樀', '樟', '樴', '橦', '檍', '檗', '櫬',
            '櫱', '歆', '歒', '殕', '毅', '泣', '涖', '涪', '渧', '滂', '滓', '滝', '滴', '漳',
            '潼', '澤', '澵', '澼', '瀧', '焙', '煜', '熾', '燵', '牓', '獍', '獐', '獞', '璋',
            '璧', '瓏', '瓣', '瓿', '甓', '産', '瘖', '瘴', '癖', '睾', '瞕', '瞳', '碚', '碲',
            '磅', '礱', '禘', '稺', '穜', '竉', '立', '竌', '竍', '竎', '竏', '竑', '竒', '竓',
            '竕', '站', '竚', '竛', '竜', '竝', '竟', '章', '竡', '竢', '竣', '童', '竦', '竨',
            '竩', '竪', '竫', '竬', '竭', '端', '竰', '竱', '竴', '競', '竸', '笠', '篭', '籠',
            '粒', '糵', '締', '縡', '織', '繹', '罿', '翊', '翌', '翣', '職', '聾', '膀', '臂',
            '臆', '艟', '苙', '莅', '莘', '菨', '菩', '蒂', '蒞', '蒟', '蒡', '蓓', '蔀', '蔐',
            '蕫', '薏', '薛', '薜', '薩', '薪', '蘖', '蘗', '蘢', '螃', '蟄', '蟙', '襞', '襯',
            '襲', '親', '諦', '諳', '諺', '謗', '謫', '識', '譬', '譯', '讁', '讋', '豅', '豙',
            '賠', '贄', '贛', '踣', '蹄', '蹢', '蹱', '躃', '躄', '軄', '辛', '辜', '辝', '辞',
            '辟', '辠', '辡', '辣', '辤', '辥', '辦', '辧', '辨', '辭', '辮', '辯', '逹', '遧',
            '適', '避', '部', '郶', '鄣', '醅', '釋', '鉝', '鋅', '鍗', '鎊', '鏑', '鏟', '鏡',
            '鐘', '鐴', '鐸', '鐿', '鑨', '闇', '闢', '闥', '陪', '障', '隦', '隴', '霎', '霹',
            '靖', '音', '韴', '韵', '韶', '韷', '韸', '韺', '韻', '響', '顔', '颯', '餢', '騂',
            '驛', '髈', '鱆', '鴗', '鶕', '鷙', '鷾', '鸊', '麞', '黯', '龍', '龏', '龐', '龑',
            '龒', '龔', '龕', '龖', '龗',
        ],
    },
    Membership {
        radical: '禾',
        strokes: 5,
        kanji: &[
            '乗', '乘', '俐', '俰', '倭', '偢', '傔', '凜', '利', '剩', '厤', '叙', '和', '唀',
            '唎', '啝', '啾', '嚟', '嚦', '囌', '囷', '壈', '壢', '奏', '委', '季', '峲', '崣',
            '嵆', '嵊', '嵙', '巍', '廩', '徐', '悧', '悸', '愀', '愁', '懍', '捼', '揪', '攈',
            '攊', '攟', '斜', '梨', '棅', '楸', '楿', '榛', '檁', '浰', '涹', '湫', '溱', '澟',
            '犁', '犂', '犧', '琇', '瑧', '瓈', '甃', '痜', '痢', '痿', '癪', '盉', '矮', '磿',
            '禾', '禿', '秀', '私', '秂', '秄', '秇', '秈', '秉', '秊', '秋', '秏', '科', '秒',
            '秔', '秕', '秖', '秘', '秚', '秝', '秞', '租', '秠', '秡', '秢', '秣', '秤', '秥',
            '秦', '秧', '秩', '秪', '秫', '秬', '秭', '称', '秱', '秸', '移', '秼', '稀', '稂',
            '稃', '稇', '稈', '稉', '稊', '程', '稌', '稍', '税', '稑', '稔', '稕', '稗', '稘',
            '稙', '稚', '稛', '稜', '稞', '稟', '稠', '稡', '稧', '稫', '稭', '種', '稯', '稰',
            '稱', '稲', '稴', '稵', '稷', '稸', '稹', '稺', '稻', '稼', '稽', '稾', '稿', '穀',
            '穂', '穃', '穄', '穅', '穆', '穇', '穈', '穉', '穌', '積', '穎', '穏', '穐', '穕',
            '穖', '穗', '穙', '穜', '穝', '穟', '穠', '穡', '穢', '穣', '穥', '穧', '穩', '穪',
            '穫', '穭', '穰', '笑', '箘', '簃', '綉', '緌', '羲', '腇', '臻', '莉', '莠', '菌',
            '萎', '萩', '萪', '蒩', '蓁', '薐', '薭', '藊', '藜', '藳', '藶', '蘇', '蘒', '蘓',
            '蘶', '蜊', '蜏', '蜲', '蝌', '螓', '褎', '誗', '誘', '諉', '諬', '轃', '轣', '透',
            '逶', '邌', '酥', '醔', '銹', '鋓', '鍬', '鑙', '鞦', '頽', '餧', '香', '馛', '馝',
            '馟', '馥', '馦', '馨', '鬁', '魏', '鯏', '鯘', '鰍', '鶖', '麇', '麕', '麘', '黍',
            '黎', '黏', '黐', '黧', '龝', '龢',
        ],
    },
    Membership {
        radical: '⺲',
        strokes: 5,
        kanji: &[
            '儇', '儚', '儜', '儸', '劅', '劚', '匵', '噣', '嚀', '嚼', '囉', '囑', '圛', '圜',
            '堽', '墁', '壊', '壞', '夢', '夣', '嫚', '嬛', '寧', '寰', '屬', '嶧', '幔', '幭',
            '幰', '廰', '廳', '徳', '慢', '憲', '懁', '懌', '懐', '懜', '懷', '擇', '擉', '擐',
            '擥', '擺', '攞', '斁', '斣', '曎', '曙', '曼', '會', '楞', '槾', '檜', '檸', '櫝',
            '櫰', '欏', '欝', '歝', '殬', '殰', '漫', '潨', '澤', '濁', '濘', '瀆', '瀗', '熳',
            '燭', '爝', '爵', '獧', '獨', '獪', '獰', '玀', '環', '瓌', '甍', '瘝', '皭', '眔',
            '眾', '睪', '睾', '瞢', '矒', '矚', '篾', '籜', '籮', '糫', '縵', '繪', '繯', '繹',
            '罒', '罘', '罛', '罜', '罝', '罟', '罠', '罡', '罣', '罤', '罥', '罦', '罧', '罨',
            '罩', '罪', '罫', '罭', '置', '罰', '罱', '署', '罵', '罷', '罸', '罹', '罽', '罾',
            '罿', '羂', '羃', '羅', '羆', '羇', '羈', '翾', '聴', '聹', '聽', '膾', '臅', '蔑',
            '蔓', '蕒', '薈', '薥', '薨', '薯', '藚', '藼', '蘀', '蘰', '蘿', '蜀', '蠉', '蠋',
            '蠛', '蠲', '衊', '褱', '襗', '襡', '襪', '覽', '觸', '詈', '諫', '謾', '譞', '譯',
            '譼', '讟', '買', '賣', '躅', '轘', '遝', '還', '邏', '醳', '釂', '釋', '鏝', '鐲',
            '鐶', '鐸', '鑒', '鑟', '鑼', '钃', '闤', '韇', '韈', '韤', '饅', '饠', '驛', '髑',
            '鬘', '鬟', '鰊', '鰥', '鰻', '鱞', '鱠', '鱰', '鶫', '黷',
        ],
    },
    Membership {
        radical: '白',
        strokes: 5,
        kanji: &[
            '伯', '佰', '偕', '偟', '傆', '儌', '優', '兜', '凮', '凰', '劰', '原', '厡', '厵',
            '咟', '唕', '啤', '喈', '喤', '嘅', '噭', '堦', '堭', '堲', '墍', '奭', '媓', '嫄',
            '嬝', '宿', '岶', '島', '帕', '帛', '幫', '庳', '弼', '徨', '徼', '怕', '惶', '愿',
            '慴', '憂', '戛', '拍', '揩', '摺', '撽', '擽', '擾', '敫', '暤', '暭', '曁', '曏',
            '朇', '柏', '栢', '梍', '棉', '椑', '楷', '楻', '楽', '楾', '槢', '槹', '樂', '檄',
            '檪', '檰', '櫟', '泉', '泊', '洦', '湝', '湟', '湶', '源', '澔', '激', '濼', '灥',
            '煌', '熠', '爍', '狛', '珀', '瑝', '瓸', '畠', '癤', '白', '百', '皀', '皁', '皃',
            '的', '皅', '皆', '皇', '皈', '皋', '皌', '皍', '皎', '皐', '皓', '皕', '皖', '皙',
            '皚', '皛', '皜', '皝', '皟', '皠', '皢', '皣', '皤', '皥', '皦', '皧', '皨', '皪',
            '皭', '碧', '磖', '礫', '稭', '穆', '竅', '竡', '箄', '箔', '篁', '篼', '粕', '粨',
            '粺', '絈', '綿', '線', '緜', '縮', '繳', '習', '翫', '腺', '舶', '艎', '萆', '葩',
            '蓿', '薌', '薭', '藠', '藥', '蜱', '蝗', '螈', '蠁', '袙', '褶', '襫', '覈', '諧',
            '謜', '貊', '貌', '蹜', '躒', '轢', '迫', '遑', '邀', '邈', '郫', '鉑', '錍', '錦',
            '鍇', '鍠', '鏥', '鑠', '陌', '隍', '階', '願', '騵', '魄', '鮊', '鯽', '鰉', '鱜',
            '鼙',
        ],
    },
    Membership {
        radical: '石',
        strokes: 5,
        kanji: &[
            '劯', '喏', '坧', '妬', '宕', '岩', '拓', '斫', '暱', '柘', '槖', '橐', '沰', '石',
            '矴', '矸', '矻', '矼', '砂', '砅', '砆', '砉', '砌', '砍', '砎', '砑', '砒', '研',
            '砕', '砝', '砠', '砡', '砢', '砣', '砥', '砦', '砧', '砭', '砮', '砰', '砲', '破',
            '砵', '砷', '砺', '砿', '硃', '硄', '硅', '硇', '硈', '硌', '硎', '硒', '硜', '硝',
            '硞', '硠', '硡', '硣', '硤', '硨', '硪', '硫', '硬', '确', '硯', '硲', '硴', '硺',
            '硼', '硾', '碁', '碆', '碇', '碊', '碌', '碍', '碎', '碏', '碑', '碓', '碔', '碕',
            '碗', '碘', '碚', '碝', '碞', '碟', '碡', '碣', '碤', '碧', '碨', '碩', '碪', '碬',
            '碭', '碯', '碰', '碱', '碲', '碳', '碵', '確', '碻', '碼', '碽', '碾', '碿', '磁',
            '磅', '磆', '磇', '磈', '磉', '磊', '磋', '磌', '磎', '磐', '磑', '磒', '磓', '磔',
            '磕', '磖', '磚', '磛', '磟', '磠', '磡', '磤', '磦', '磧', '磨', '磪', '磬', '磯',
            '磲', '磳', '磴', '磶', '磷', '磺', '磻', '磽', '磿', '礀', '礁', '礆', '礇', '礌',
            '礎', '礐', '礑', '礒', '礙', '礚', '礜', '礞', '礟', '礠', '礥', '礦', '礧', '礩',
            '礪', '礫', '礬', '礭', '礱', '礴', '礵', '祏', '菪', '蘑', '蠧', '蠹', '跖', '鉐',
            '騞', '驝', '鮖', '鼫',
        ],
    },
    Membership {
        radical: '皿',
        strokes: 5,
        kanji: &[
            '侐', '儖', '儘', '卹', '嗌', '嗑', '嗢', '嚀', '嚧', '塧', '塩', '壒', '壗', '壚',
            '媼', '孟', '寍', '寧', '尶', '廬', '恤', '慍', '懢', '懧', '搤', '搵', '擰', '敟',
            '昷', '楹', '榲', '榼', '橆', '檸', '檻', '櫨', '殟', '氳', '泴', '洫', '温', '湓',
            '溘', '溢', '潨', '濘', '濫', '瀘', '灎', '熅', '燼', '爐', '猛', '獰', '獹', '瓐',
            '瘟', '皿', '盁', '盂', '盃', '盅', '盆', '盈', '盉', '益', '盋', '盌', '盍', '盎',
            '盒', '盔', '盖', '盗', '盙', '盛', '盜', '盞', '盟', '盠', '盡', '監', '盤', '盥',
            '盦', '盧', '盨', '盪', '盬', '瞌', '矃', '矑', '磕', '礚', '笽', '簋', '簠', '籃',
            '籚', '縊', '縕', '繿', '纑', '罏', '聹', '膃', '臚', '艋', '艦', '艫', '葢', '蒕',
            '蓋', '薀', '薴', '藍', '藎', '蘆', '蘊', '蘯', '螠', '蠱', '蠲', '血', '衁', '衂',
            '衃', '衄', '衅', '衆', '衈', '衉', '衊', '衋', '褞', '襤', '諡', '謐', '謚', '豓',
            '豔', '賉', '贐', '轀', '轞', '轤', '醓', '醘', '醞', '醢', '醯', '錳', '鎰', '鑑',
            '鑪', '闔', '隘', '韞', '顱', '饁', '饂', '驢', '髗', '鰛', '鰪', '鰮', '鱸', '鷁',
            '鸕', '鹽', '黸',
        ],
    },
    Membership {
        radical: '⽧',
        strokes: 5,
        kanji: &[
            '嫉', '愱', '疒', '疓', '疔', '疕', '疙', '疚', '疜', '疝', '疢', '疣', '疤', '疥',
            '疫', '疱', '疲', '疳', '疴', '疵', '疸', '疹', '疺', '疼', '疽', '疾', '疿', '痀',
            '痁', '痂', '痃', '痄', '病', '痆', '症', '痊', '痌', '痍', '痎', '痏', '痒', '痔',
            '痕', '痗', '痘', '痙', '痛', '痜', '痞', '痟', '痠', '痡', '痢', '痣', '痤', '痧',
            '痩', '痬', '痮', '痯', '痰', '痱', '痲', '痳', '痴', '痹', '痺', '痼', '痾', '痿',
            '瘀', '瘁', '瘂', '瘃', '瘄', '瘇', '瘈', '瘉', '瘊', '瘋', '瘌', '瘍', '瘏', '瘒',
            '瘓', '瘕', '瘖', '瘙', '瘛', '瘜', '瘝', '瘞', '瘟', '瘠', '瘡', '瘢', '瘣', '瘤',
            '瘥', '瘦', '瘧', '瘩', '瘭', '瘰', '瘲', '瘳', '瘴', '瘵', '瘸', '瘹', '瘺', '瘻',
            '瘼', '癀', '癁', '療', '癃', '癄', '癅', '癆', '癇', '癈', '癉', '癊', '癋', '癌',
            '癒', '癕', '癖', '癘', '癙', '癜', '癟', '癡', '癢', '癤', '癥', '癧', '癨', '癩',
            '癪', '癬', '癭', '癮', '癯', '癰', '癱', '癲', '癴', '臧', '蒺', '贓',
        ],
    },
    Membership {
        radical: '⻂',
        strokes: 5,
        kanji: &[
            '初', '衤', '衩', '衫', '衱', '衲', '衵', '衹', '衻', '衽', '衿', '袀', '袂', '袍',
            '袒', '袖', '袗', '袘', '袙', '袚', '袛', '袜', '袟', '袢', '袨', '袪', '被', '袮',
            '袱', '袴', '袵', '袷', '袺', '袽', '袾', '袿', '裀', '裃', '裄', '裋', '裌', '裍',
            '裎', '裑', '裓', '裕', '裙', '補', '裞', '裡', '裧', '裨', '裯', '裰', '裱', '裲',
            '裷', '裸', '裼', '裾', '褂', '褄', '褆', '複', '褊', '褌', '褍', '褐', '褓', '褕',
            '褖', '褘', '褙', '褚', '褝', '褞', '褠', '褥', '褦', '褨', '褪', '褫', '褲', '褵',
            '褶', '褸', '褹', '褾', '襀', '襁', '襂', '襅', '襆', '襉', '襌', '襍', '襏', '襒',
            '襖', '襗', '襚', '襛', '襜', '襟', '襠', '襡', '襢', '襣', '襤', '襦', '襪', '襫',
            '襭', '襮', '襯', '襰', '襳', '襴', '襵', '襷', '襺', '襻', '襼', '襽',
        ],
    },
    Membership {
        radical: '矢',
        strokes: 5,
        kanji: &[
            '侯', '俟', '倁', '候', '儗', '凝', '勧', '医', '唉', '喉', '嗾', '垁', '埃', '堠',
            '娭', '嫉', '嶷', '彘', '悘', '愱', '懝', '挨', '擬', '族', '昳', '智', '椥', '榘',
            '権', '欵', '欸', '歓', '殹', '毉', '涘', '潅', '猴', '璏', '疑', '疾', '痴', '瘊',
            '癡', '睺', '瞖', '矢', '矣', '矤', '知', '矦', '矧', '矩', '矪', '矬', '短', '矮',
            '矯', '矰', '矱', '礙', '竢', '笶', '篌', '簇', '糇', '緱', '繄', '翳', '聟', '肄',
            '蒺', '蔟', '薙', '薿', '蘙', '蜘', '蠮', '観', '誒', '踟', '迭', '逘', '醫', '鉃',
            '鉄', '鍭', '鏃', '雉', '餱', '騃', '鯸', '鷖', '鷟',
        ],
    },
    Membership {
        radical: '示',
        strokes: 5,
        kanji: &[
            '佘', '余', '俆', '倧', '傺', '僄', '凛', '剽', '勡', '叞', '呩', '噤', '奈', '嫖',
            '孮', '宗', '察', '尉', '崇', '幖', '彯', '徖', '徱', '悆', '悰', '慓', '慰', '捺',
            '摽', '擦', '斎', '柰', '棕', '標', '檫', '款', '涂', '淙', '漂', '漈', '熛', '熨',
            '琮', '瓢', '瘭', '瘵', '眎', '瞟', '磦', '示', '祘', '祟', '票', '祭', '禀', '禁',
            '禜', '禦', '穄', '粽', '綜', '縹', '翲', '膘', '蒜', '蔚', '蔡', '薸', '螱', '螵',
            '褾', '襟', '賨', '踪', '錝', '鏢', '除', '際', '隷', '隸', '霨', '頴', '飃', '飄',
            '騌', '驃', '鬃', '鰶', '鰾', '鶎', '齽', '龒',
        ],
    },
    Membership {
        radical: '甘',
        strokes: 5,
        kanji: &[
            '倛', '其', '凘', '剘', '勘', '卙', '厮', '咁', '啿', '嘶', '坩', '基', '堪', '墈',
            '媒', '尠', '嵌', '廝', '愖', '憇', '戡', '拑', '揕', '撕', '斟', '斯', '旗', '朞',
            '期', '某', '柑', '棊', '棋', '椹', '楳', '欺', '泔', '淇', '湈', '湛', '澌', '煁',
            '煤', '玵', '琪', '甘', '甚', '甜', '甞', '疳', '碁', '碪', '磡', '祺', '禖', '稘',
            '箕', '箝', '篏', '簛', '簱', '簸', '籏', '糂', '紺', '苷', '蘛', '蚶', '蜞', '蟖',
            '謀', '踑', '踸', '邯', '酣', '鉗', '錤', '鍖', '鐁', '騏', '魌', '麒', '黮',
        ],
    },
    Membership {
        radical: '疋',
        strokes: 5,
        kanji: &[
            '丐', '倢', '偦', '儗', '凝', '匙', '嚏', '嚔', '埞', '堤', '壻', '婿', '媞', '定',
            '寔', '尟', '嶷', '従', '徙', '從', '慫', '懝', '懥', '捷', '掟', '提', '擬', '旋',
            '是', '椗', '楚', '樅', '樾', '淀', '湑', '湜', '漩', '琁', '璇', '疋', '疐', '疑',
            '癡', '碇', '礎', '礙', '禔', '稰', '糈', '綻', '緹', '縦', '翨', '聢', '聳', '胥',
            '蔬', '薿', '蛋', '褆', '諚', '諝', '諟', '踶', '蹤', '醍', '醑', '錠', '鍉', '鏇',
            '隄', '靛', '鞮', '韙', '題', '颴', '騠', '鯷', '鶗', '麪',
        ],
    },
    Membership {
        radical: '用',
        strokes: 5,
        kanji: &[
            '佣', '俌', '俑', '備', '傭', '僃', '勈', '匍', '哺', '嚩', '圃', '埇', '埔', '墉',
            '庸', '恿', '悑', '愑', '慂', '慵', '憊', '懯', '捔', '捕', '斠', '晡', '桶', '樋',
            '浦', '涌', '猟', '用', '甪', '甫', '甬', '甯', '痛', '筩', '糒', '脯', '舖', '舗',
            '苚', '葡', '蒲', '蓪', '蛹', '蝋', '補', '誦', '踊', '輔', '逋', '通', '銿', '鋪',
            '鞴', '韛', '餔', '鯆', '鯒', '黼', '鼡',
        ],
    },
    Membership {
        radical: '矛',
        strokes: 5,
        kanji: &[
            '劀', '務', '壄', '妤', '婺', '忬', '愗', '懋', '抒', '揉', '杼', '柔', '楙', '楺',
            '橘', '櫲', '氄', '潏', '澦', '猱', '獝', '璚', '瞀', '矛', '矜', '矞', '矟', '矠',
            '糅', '紓', '繘', '舒', '芧', '茅', '葇', '蕷', '蝥', '蟊', '袤', '譎', '豫', '蹂',
            '輮', '遹', '野', '鍒', '鍪', '鐍', '雺', '霚', '霧', '霱', '鞣', '騖', '髳', '魣',
            '鱊', '鶩', '鷸',
        ],
    },
    Membership {
        radical: '⽱',
        strokes: 5,
        kanji: &[
            '偊', '偶', '勱', '勵', '厲', '喁', '嘱', '寓', '属', '嵎', '愚', '摛', '擒', '檎',
            '櫔', '漓', '灕', '瑀', '璃', '癘', '礪', '禑', '禸', '禹', '禺', '离', '禽', '竊',
            '竬', '籬', '糲', '縭', '耦', '萬', '藕', '蘺', '螭', '蠆', '蠣', '褵', '踽', '躉',
            '辭', '遇', '邁', '鄅', '醨', '隅', '離', '顒', '髃', '魑', '黐', '齲', '齵',
        ],
    },
    Membership {
        radical: '冊',
        strokes: 5,
        kanji: &[
            '侖', '倎', '倫', '偏', '冊', '刪', '匾', '圇', '姍', '崘', '崙', '徧', '惼', '扁',
            '掄', '斒', '柵', '棆', '淪', '瀹', '爚', '猵', '珊', '癟', '禴', '笧', '篇', '籥',
            '籲', '糄', '綸', '編', '翩', '艑', '萹', '藊', '蝙', '褊', '論', '諞', '跚', '蹁',
            '輪', '遍', '錀', '鍽', '鑰', '騙', '鯿', '鸙', '龠', '龡', '龢', '龣', '龥',
        ],
    },
    Membership {
        radical: '穴',
        strokes: 5,
        kanji: &[
            '倥', '啌', '坹', '容', '悾', '控', '搾', '椌', '榕', '溶', '熔', '穃', '穴', '究',
            '穹', '空', '穽', '穿', '突', '窃', '窄', '窈', '窒', '窓', '窕', '窖', '窗', '窘',
            '窟', '窩', '窪', '窮', '窯', '窰', '窶', '窺', '窿', '竃', '竄', '竅', '竇', '竈',
            '竊', '箜', '腔', '膣', '蓉', '邃', '邊', '鎔', '鴪',
        ],
    },
    Membership {
        radical: '生',
        strokes: 5,
        kanji: &[
            '夝', '姓', '嶐', '徃', '性', '惺', '旌', '星', '暒', '殅', '泩', '滻', '煋', '牲',
            '狌', '猩', '瑆', '生', '甠', '甡', '産', '甤', '甥', '甦', '甧', '癃', '眚', '睲',
            '窿', '笙', '篂', '腥', '蕤', '薩', '貹', '醒', '鉎', '鏟', '隆', '霳', '鮏', '鯹',
            '鼪',
        ],
    },
    Membership {
        radical: '玄',
        strokes: 5,
        kanji: &[
            '侅', '呟', '奒', '姟', '弦', '慉', '搐', '摔', '昡', '欬', '氦', '泫', '滀', '炫',
            '玄', '玅', '玆', '率', '玹', '畜', '畡', '痃', '痎', '眩', '絃', '胘', '胲', '舷',
            '荄', '蓄', '蚿', '蟀', '衒', '袨', '詃', '賅', '鄐', '鉉', '閡', '陔', '頦',
        ],
    },
    Membership {
        radical: '世',
        strokes: 5,
        kanji: &[
            '世', '伳', '勩', '呭', '喋', '堞', '媟', '屜', '屧', '幉', '弽', '惵', '揲', '枻',
            '枼', '楪', '泄', '渫', '煠', '牃', '牒', '碟', '笹', '紲', '緤', '葉', '蝶', '詍',
            '諜', '貰', '跇', '蹀', '迣', '鍱', '鞢', '韘', '鰈',
        ],
    },
    Membership {
        radical: '母',
        strokes: 5,
        kanji: &[
            '侮', '勄', '塰', '姆', '娒', '悔', '慣', '拇', '敏', '晦', '栂', '梅', '毋', '母',
            '毎', '毒', '毓', '海', '珻', '瑇', '痗', '碡', '繁', '纛', '苺', '莓', '蘩', '袰',
            '誨', '貫', '鉧', '鋂', '霉', '鰵',
        ],
    },
    Membership {
        radical: '癶',
        strokes: 5,
        kanji: &[
            '僜', '凳', '噔', '墢', '墱', '嬁', '察', '嶝', '廃', '廢', '戣', '揆', '撥', '擦',
            '暌', '橙', '櫈', '溌', '澄', '燈', '癈', '癶', '癸', '発', '登', '發', '磴', '祭',
            '葵', '蔡', '證', '醗', '鐙', '際',
        ],
    },
    Membership {
        radical: '牙',
        strokes: 5,
        kanji: &[
            '冴', '厩', '呀', '嘅', '墍', '姊', '岈', '慨', '捓', '撐', '既', '柹', '概', '橕',
            '牙', '牚', '琊', '砑', '穿', '竆', '笫', '芽', '蚜', '訝', '谺', '迓', '邪', '鋣',
            '雅', '鴉', '齖',
        ],
    },
    Membership {
        radical: '皮',
        strokes: 5,
        kanji: &[
            '坡', '婆', '彼', '披', '波', '玻', '疲', '皮', '皰', '皴', '皷', '皸', '皹', '皺',
            '破', '碆', '簸', '菠', '被', '跛', '陂', '鞁', '頗',
        ],
    },
    Membership {
        radical: '瓦',
        strokes: 5,
        kanji: &[
            '瓦', '瓧', '瓩', '瓮', '瓰', '瓱', '瓲', '瓶', '瓷', '瓸', '甃', '甄', '甅', '甌',
            '甍', '甎', '甑', '甓', '甕',
        ],
    },
    Membership {
        radical: '巨',
        strokes: 5,
        kanji: &['巨', '拒', '渠', '炬', '矩', '秬', '苣', '距', '鉅'],
    },
    Membership {
        radical: '虫',
        strokes: 6,
        kanji: &[
            '偊', '偑', '僓', '儙', '剸', '劅', '劚', '勥', '嗤', '嘳', '噣', '囑', '圚', '壝',
            '媸', '嫥', '專', '尵', '屬', '嵹', '庽', '強', '惠', '慅', '慱', '憒', '憓', '掻',
            '搔', '摶', '擉', '斣', '楓', '槫', '樻', '櫁', '殨', '渢', '滍', '潓', '濁', '燭',
            '独', '獨', '瑀', '甎', '瘋', '瘙', '矚', '磚', '禹', '穗', '竬', '竱', '糔', '縳',
            '繐', '繢', '繦', '繭', '繾', '聵', '膞', '臅', '蓴', '蔃', '蕙', '蕢', '薥', '虫',
            '虬', '虯', '虱', '虵', '虶', '虷', '虹', '虺', '虻', '蚈', '蚊', '蚋', '蚌', '蚍',
            '蚑', '蚓', '蚕', '蚖', '蚘', '蚚', '蚜', '蚡', '蚣', '蚤', '蚦', '蚧', '蚨', '蚩',
            '蚪', '蚫', '蚭', '蚯', '蚰', '蚱', '蚳', '蚴', '蚵', '蚶', '蚷', '蚸', '蚹', '蚿',
            '蛀', '蛁', '蛃', '蛄', '蛅', '蛆', '蛇', '蛉', '蛋', '蛍', '蛎', '蛑', '蛒', '蛔',
            '蛕', '蛗', '蛙', '蛚', '蛛', '蛜', '蛞', '蛟', '蛠', '蛣', '蛤', '蛥', '蛧', '蛩',
            '蛬', '蛭', '蛮', '蛯', '蛸', '蛹', '蛺', '蛻', '蛼', '蛽', '蛾', '蜀', '蜂', '蜃',
            '蜄', '蜅', '蜆', '蜇', '蜈', '蜉', '蜊', '蜋', '蜍', '蜎', '蜏', '蜐', '蜑', '蜒',
            '蜓', '蜔', '蜘', '蜙', '蜚', '蜜', '蜞', '蜟', '蜡', '蜣', '蜥', '蜨', '蜩', '蜮',
            '蜯', '蜱', '蜲', '蜴', '蜷', '蜹', '蜺', '蜻', '蜼', '蜽', '蜾', '蜿', '蝀', '蝃',
            '蝅', '蝉', '蝋', '蝌', '蝍', '蝎', '蝓', '蝕', '蝗', '蝘', '蝙', '蝝', '蝟', '蝠',
            '蝡', '蝣', '蝤', '蝥', '蝦', '蝨', '蝪', '蝮', '蝯', '蝱', '蝲', '蝴', '蝶', '蝸',
            '蝻', '蝿', '螂', '螃', '螄', '螅', '螆', '螇', '螈', '螉', '螋', '螌', '融', '螐',
            '螓', '螕', '螗', '螘', '螙', '螞', '螟', '螠', '螢', '螣', '螧', '螫', '螬', '螭',
            '螮', '螯', '螱', '螳', '螵', '螺', '螻', '螽', '螾', '螿', '蟀', '蟁', '蟄', '蟆',
            '蟇', '蟈', '蟉', '蟊', '蟋', '蟎', '蟐', '蟒', '蟕', '蟖', '蟙', '蟚', '蟜', '蟟',
            '蟠', '蟢', '蟣', '蟤', '蟪', '蟫', '蟭', '蟯', '蟱', '蟲', '蟳', '蟶', '蟷', '蟸',
            '蟹', '蟺', '蟻', '蟾', '蟿', '蠁', '蠃', '蠅', '蠆', '蠉', '蠊', '蠋', '蠍', '蠎',
            '蠏', '蠐', '蠑', '蠒', '蠓', '蠔', '蠕', '蠖', '蠘', '蠙', '蠚', '蠛', '蠜', '蠞',
            '蠟', '蠡', '蠢', '蠣', '蠧', '蠨', '蠭', '蠮', '蠰', '蠱', '蠲', '蠵', '蠶', '蠹',
            '蠺', '蠻', '蠼', '襁', '襡', '襺', '触', '觸', '諷', '譓', '踽', '躅', '轉', '鄅',
            '鉵', '鏄', '鏸', '鏹', '鐲', '钃', '閩', '闠', '隤', '雖', '靧', '鞼', '風', '颪',
            '颫', '颭', '颮', '颯', '颰', '颱', '颴', '颶', '颷', '颸', '颺', '颻', '颿', '飂',
            '飃', '飄', '飅', '飆', '飈', '飌', '騒', '騷', '髑', '鱄', '齲',
        ],
    },
    Membership {
        radical: '糸',
        strokes: 6,
        kanji: &[
            '乿', '係', '傃', '儸', '勬', '卛', '喲', '嗉', '噄', '嚩', '囉', '圝', '塐', '孌',
            '孫', '孿', '巒', '彎', '彝', '徽', '愫', '懸', '戀', '攞', '攣', '曫', '榡', '樏',
            '檰', '櫞', '欏', '欒', '漯', '潔', '濰', '瀠', '灣', '灤', '猻', '玀', '瘰', '癴',
            '矕', '籘', '籮', '糸', '糺', '系', '糾', '紀', '紂', '紃', '約', '紅', '紆', '紇',
            '紈', '紉', '紊', '紋', '納', '紏', '紐', '紑', '紒', '紓', '純', '紕', '紖', '紗',
            '紘', '紙', '級', '紛', '紜', '紝', '紞', '素', '紡', '索', '紣', '紦', '紪', '紫',
            '紬', '紭', '紮', '累', '細', '紱', '紲', '紳', '紵', '紹', '紺', '紼', '紽', '紾',
            '紿', '絀', '絁', '終', '絃', '組', '絅', '絆', '絇', '絈', '絋', '経', '絍', '絎',
            '絏', '結', '絑', '絓', '絖', '絗', '絙', '絚', '絛', '絜', '絝', '絞', '絡', '絢',
            '絣', '絥', '給', '絧', '絨', '絪', '絮', '絰', '統', '絲', '絳', '絵', '絶', '絸',
            '絹', '絺', '絻', '絽', '絿', '綁', '綂', '綃', '綅', '綆', '綈', '綉', '綋', '綌',
            '綍', '綏', '綑', '經', '綖', '綗', '継', '続', '綛', '綜', '綝', '綞', '綟', '綢',
            '綣', '綦', '綧', '綪', '綫', '綬', '維', '綮', '綯', '綰', '綱', '網', '綳', '綴',
            '綵', '綶', '綷', '綸', '綹', '綺', '綻', '綽', '綾', '綿', '緂', '緃', '緄', '緅',
            '緆', '緇', '緊', '緋', '緌', '緍', '緎', '総', '緑', '緒', '緕', '緗', '緘', '緙',
            '線', '緜', '緝', '緞', '締', '緡', '緢', '緤', '緥', '緦', '編', '緩', '緪', '緫',
            '緬', '緭', '緯', '緱', '緲', '練', '緵', '緶', '緹', '緺', '緻', '縀', '縁', '縄',
            '縅', '縈', '縉', '縊', '縋', '縐', '縑', '縒', '縕', '縗', '縛', '縜', '縝', '縞',
            '縟', '縠', '縡', '縢', '縣', '縦', '縧', '縨', '縫', '縬', '縭', '縮', '縯', '縱',
            '縲', '縳', '縵', '縶', '縷', '縹', '縺', '縻', '總', '績', '縿', '繁', '繃', '繄',
            '繅', '繆', '繇', '繊', '繋', '繍', '繎', '繐', '繒', '織', '繕', '繖', '繘', '繙',
            '繚', '繝', '繞', '繟', '繡', '繢', '繥', '繦', '繧', '繩', '繪', '繫', '繭', '繮',
            '繯', '繰', '繳', '繸', '繹', '繻', '繼', '繽', '繾', '繿', '纁', '纂', '纃', '纆',
            '纇', '纈', '纉', '纊', '續', '纍', '纎', '纏', '纐', '纑', '纒', '纓', '纔', '纕',
            '纖', '纘', '纚', '纛', '纜', '纝', '纞', '羂', '羅', '膆', '臠', '葒', '葤', '葯',
            '蒓', '蓀', '蔂', '蕝', '蕠', '蘊', '蘩', '蘰', '蘿', '虆', '螺', '蠻', '衆', '襺',
            '變', '轡', '辮', '遜', '邎', '邏', '醿', '銯', '鎍', '鏍', '鑼', '鑾', '饠', '騾',
            '鯀', '鷥', '鸞',
        ],
    },
    Membership {
        radical: '竹',
        strokes: 6,
        kanji: &[
            '噬', '撘', '擌', '擶', '檱', '櫛', '櫤', '澨', '癤', '竹', '竺', '竻', '竽', '竾',
            '竿', '笂', '笄', '笆', '笇', '笈', '笊', '笋', '笏', '笑', '笔', '笘', '笙', '笛',
            '笞', '笟', '笠', '笣', '笥', '符', '笧', '笨', '笩', '笪', '笫', '第', '笭', '笮',
            '笯', '笰', '笱', '笳', '笴', '笵', '笶', '笹', '笽', '笿', '筀', '筁', '筅', '筆',
            '筇', '筈', '等', '筋', '筌', '筍', '筎', '筏', '筐', '筑', '筒', '答', '筕', '策',
            '筝', '筠', '筤', '筥', '筦', '筧', '筩', '筪', '筬', '筭', '筮', '筯', '筰', '筱',
            '筲', '筳', '筴', '筵', '筷', '筺', '箄', '箆', '箇', '箉', '箋', '箍', '箎', '箏',
            '箐', '箑', '箒', '箔', '箕', '箖', '算', '箘', '箙', '箚', '箛', '箜', '箝', '箞',
            '箟', '箠', '管', '箥', '箪', '箬', '箭', '箯', '箰', '箱', '箲', '箴', '箵', '箶',
            '箸', '箺', '箻', '箼', '箽', '節', '篁', '篂', '範', '篅', '篆', '篇', '篈', '築',
            '篊', '篋', '篌', '篏', '篔', '篖', '篗', '篙', '篚', '篛', '篝', '篠', '篤', '篥',
            '篦', '篨', '篩', '篪', '篭', '篲', '篳', '篴', '篵', '篶', '篷', '篸', '篹', '篺',
            '篼', '篾', '簀', '簁', '簂', '簃', '簆', '簇', '簉', '簋', '簌', '簍', '簎', '簏',
            '簑', '簒', '簓', '簔', '簗', '簙', '簛', '簟', '簠', '簡', '簣', '簥', '簦', '簧',
            '簨', '簪', '簫', '簬', '簱', '簳', '簴', '簶', '簷', '簸', '簹', '簺', '簽', '簾',
            '簿', '籀', '籃', '籆', '籊', '籌', '籍', '籏', '籐', '籑', '籒', '籓', '籔', '籕',
            '籖', '籘', '籙', '籚', '籛', '籜', '籞', '籟', '籠', '籡', '籣', '籤', '籥', '籧',
            '籩', '籬', '籭', '籮', '籰', '籲', '纂', '蠞', '鱵',
        ],
    },
    Membership {
        radical: '米',
        strokes: 6,
        kanji: &[
            '侎', '僯', '匊', '咪', '嘯', '噃', '噛', '噢', '囓', '墦', '墺', '奥', '奧', '娄',
            '婅', '嬸', '宩', '宷', '審', '屎', '屡', '嶓', '嶙', '嶴', '幡', '彛', '彜', '彝',
            '悉', '愾', '憐', '憟', '懊', '掬', '撛', '播', '敉', '数', '料', '断', '斴', '旙',
            '旛', '来', '椈', '楼', '橉', '橎', '歯', '殩', '毱', '氣', '渊', '滊', '潘', '潾',
            '澚', '澯', '澳', '瀋', '燐', '燔', '燠', '燦', '璘', '璠', '璨', '番', '皤', '眯',
            '瞵', '磷', '磻', '礇', '竊', '籓', '籔', '米', '籵', '籹', '籼', '籽', '籾', '粁',
            '粂', '粃', '粆', '粇', '粉', '粋', '粍', '粏', '粐', '粒', '粔', '粕', '粗', '粘',
            '粛', '粞', '粟', '粠', '粡', '粢', '粤', '粥', '粦', '粧', '粨', '粫', '粭', '粮',
            '粰', '粱', '粲', '粳', '粶', '粷', '粹', '粺', '粻', '粼', '粽', '精', '粿', '糀',
            '糂', '糄', '糅', '糇', '糈', '糉', '糊', '糍', '糎', '糏', '糒', '糓', '糔', '糕',
            '糖', '糗', '糘', '糙', '糚', '糜', '糝', '糞', '糟', '糠', '糢', '糦', '糧', '糩',
            '糫', '糯', '糲', '糴', '糵', '糶', '継', '繙', '纇', '翻', '膰', '莱', '菊', '蒾',
            '蕃', '蕭', '薁', '薮', '藩', '蟋', '蟠', '襖', '諊', '謎', '譒', '讅', '蹯', '轓',
            '轔', '迷', '遴', '鄰', '鄱', '釆', '釈', '釉', '釋', '銤', '鏻', '鐇', '隣', '隩',
            '鞠', '類', '飜', '餼', '驎', '鬻', '鱗', '鷭', '麋', '麟', '麴', '麹', '齒', '齔',
            '齟', '齠', '齡', '齢', '齣', '齦', '齧', '齪', '齬', '齲', '齶', '齷',
        ],
    },
    Membership {
        radical: '衣',
        strokes: 6,
        kanji: &[
            '依', '侲', '俵', '偎', '儂', '儇', '儴', '勷', '哀', '唇', '喂', '喪', '嚢', '嚷',
            '囅', '囊', '園', '圜', '壊', '壌', '壞', '壤', '娠', '嬛', '嬝', '嬢', '孃', '宸',
            '寰', '展', '憹', '懁', '懐', '懷', '扆', '振', '擐', '攘', '攮', '敐', '晨', '曟',
            '曩', '椳', '榱', '槈', '櫰', '溽', '滾', '漘', '濃', '瀼', '煨', '猥', '猿', '獧',
            '環', '瓌', '瓤', '畏', '畩', '碨', '碾', '禯', '禳', '穠', '穣', '穰', '簑', '簔',
            '糫', '縗', '縟', '繯', '纕', '翾', '耨', '脣', '脤', '膂', '膿', '莀', '蓐', '蓑',
            '蕽', '薅', '薗', '蘘', '蜃', '蜄', '蠉', '蠰', '衣', '表', '衰', '衷', '衾', '袁',
            '袈', '袋', '袞', '袠', '袤', '袰', '裁', '裂', '装', '裊', '裏', '裒', '裔', '裘',
            '裛', '裝', '裟', '裱', '裳', '裴', '裵', '裹', '製', '褁', '褎', '褏', '褒', '褜',
            '褥', '褧', '褰', '褱', '褺', '褻', '襃', '襄', '襛', '襞', '襲', '譞', '譲', '讓',
            '賑', '蹍', '輾', '轅', '轘', '辰', '辱', '農', '遠', '還', '醲', '醸', '釀', '銥',
            '鋠', '錶', '鎒', '鐶', '鑲', '闤', '隈', '震', '餵', '饟', '驟', '驤', '鬟', '鱞',
            '麎',
        ],
    },
    Membership {
        radical: '耳',
        strokes: 6,
        kanji: &[
            '倻', '儼', '冣', '刵', '厳', '取', '叢', '咡', '嘬', '噉', '嚴', '囁', '埾', '娵',
            '娶', '巌', '巖', '廰', '廳', '弭', '恥', '憨', '懾', '戢', '掫', '揖', '揶', '摂',
            '撮', '擑', '攝', '敢', '斊', '曮', '最', '椰', '楫', '樶', '樷', '橄', '檉', '檝',
            '欇', '欉', '毦', '洱', '湒', '濈', '灄', '爺', '玁', '珥', '瞰', '矙', '穝', '緅',
            '緝', '耳', '耴', '耵', '耶', '耷', '耹', '耺', '耻', '耼', '耽', '耾', '耿', '聀',
            '聄', '聆', '聊', '聒', '聖', '聘', '聚', '聞', '聟', '聠', '聡', '聢', '聤', '聦',
            '聨', '聭', '聯', '聰', '聱', '聲', '聳', '聴', '聵', '聶', '職', '聹', '聽', '聾',
            '茸', '葺', '蕞', '蕺', '藂', '蟶', '衈', '褧', '襵', '誀', '諏', '諿', '趣', '躡',
            '輒', '輙', '輯', '郰', '鄹', '釅', '銸', '鎁', '鑷', '闞', '陬', '顳', '餌', '駬',
            '驟', '鬫', '鮿', '鯫', '鵈', '麛', '齱',
        ],
    },
    Membership {
        radical: '臼',
        strokes: 6,
        kanji: &[
            '倪', '傁', '兒', '冩', '叟', '唲', '啗', '嚳', '堄', '夓', '學', '寫', '嶼', '帠',
            '庾', '廋', '惂', '惥', '慆', '憃', '掐', '揑', '插', '搜', '搯', '摏', '擧', '攛',
            '攪', '桕', '楰', '樁', '欿', '歃', '歟', '毀', '淊', '滔', '潟', '瀉', '焰', '燄',
            '燬', '爓', '爨', '牐', '猊', '獵', '瑫', '瘦', '癙', '盥', '睨', '瞍', '磶', '稻',
            '窞', '竄', '腴', '膄', '臘', '臼', '臽', '臾', '臿', '舀', '舁', '舂', '舃', '舅',
            '與', '興', '舉', '舊', '萏', '萸', '藇', '蜺', '螋', '裒', '覺', '諂', '諛', '謟',
            '譭', '譽', '貎', '蹈', '輗', '輡', '輿', '轁', '釁', '鍤', '鑞', '鑿', '閻', '陷',
            '隉', '霓', '鞱', '韜', '餡', '饀', '鬣', '鬩', '鯢', '鶃', '鷽', '麑', '黌', '鼠',
            '鼢', '鼦', '鼪', '鼫', '鼬', '鼯', '鼱', '鼲', '鼴', '鼷', '鼹', '鼺', '齨', '齯',
        ],
    },
    Membership {
        radical: '羽',
        strokes: 6,
        kanji: &[
            '傓', '傟', '僇', '剹', '勜', '勠', '嘐', '噏', '塌', '塕', '嫪', '嬥', '寥', '嵡',
            '嵺', '廖', '廫', '慴', '憀', '戮', '扇', '挧', '搨', '摎', '摺', '栩', '榻', '槢',
            '樛', '歙', '毣', '溻', '滃', '漻', '潝', '瀚', '瀷', '煽', '熠', '珝', '璆', '璻',
            '疁', '瘳', '磖', '磟', '籊', '繆', '羽', '羿', '翀', '翁', '翃', '翅', '翆', '翈',
            '翊', '翌', '翎', '翏', '習', '翔', '翕', '翛', '翟', '翠', '翡', '翣', '翥', '翦',
            '翨', '翩', '翫', '翬', '翮', '翯', '翰', '翲', '翳', '翹', '翺', '翻', '翼', '翽',
            '翾', '翿', '膠', '臎', '蓊', '蓼', '藋', '蘙', '螉', '蟉', '蠮', '褶', '詡', '謆',
            '謬', '譾', '賿', '趐', '趯', '蹋', '蹹', '躢', '轇', '遢', '醪', '鏐', '鑃', '闒',
            '闟', '飂', '騸', '髎', '鰨', '鶲', '鷚', '鸐',
        ],
    },
    Membership {
        radical: '羊',
        strokes: 6,
        kanji: &[
            '佯', '傞', '僐', '僕', '儀', '劷', '叢', '咩', '善', '嗟', '噠', '垟', '墡', '姜',
            '對', '嵯', '嵳', '嶫', '嶬', '差', '幞', '庠', '徉', '恙', '懟', '搓', '撲', '撻',
            '曦', '業', '槎', '様', '樣', '樸', '氧', '洋', '漾', '濮', '瀁', '烊', '牂', '犠',
            '犧', '瑳', '璞', '痒', '癢', '癬', '盖', '着', '磋', '礒', '祥', '窯', '縒', '繕',
            '羊', '羌', '羍', '美', '羏', '羑', '羔', '羖', '羗', '羚', '羜', '羝', '羞', '羡',
            '羢', '羣', '群', '羦', '羨', '義', '羪', '羭', '羮', '羯', '羲', '羴', '羶', '羸',
            '羹', '羼', '翔', '膳', '艖', '艤', '薘', '蘚', '蜣', '蟻', '褨', '觧', '詳', '議',
            '譱', '蹉', '蹼', '躂', '躾', '遅', '達', '鄯', '鄴', '鎈', '鐽', '闥', '韃', '養',
            '饈', '饍', '鮮', '鱃', '鱔', '鱶', '鹺',
        ],
    },
    Membership {
        radical: '虍',
        strokes: 6,
        kanji: &[
            '俿', '劇', '勴', '嗁', '嘑', '嘘', '噱', '嚧', '嚱', '囐', '墟', '壚', '巇', '巘',
            '廬', '彪', '慮', '戯', '戲', '摣', '擄', '據', '攄', '樝', '櫖', '櫨', '歔', '滮',
            '滹', '瀘', '爈', '爐', '猇', '獹', '獻', '琥', '璩', '瓐', '瓛', '甗', '瘧', '盧',
            '矑', '箎', '篪', '簴', '籚', '籧', '纑', '罅', '罏', '膚', '臚', '艣', '艫', '藘',
            '蘆', '蘧', '虍', '虎', '虐', '虒', '虓', '虔', '處', '虖', '虗', '虘', '虙', '虚',
            '虜', '虝', '虞', '號', '虠', '虡', '虢', '虣', '虤', '虧', '虩', '褫', '覰', '覷',
            '諕', '謔', '謼', '譃', '讞', '豦', '蹏', '轤', '遞', '遽', '醵', '鐻', '鑢', '鑪',
            '顱', '饕', '驢', '髗', '鬳', '魖', '鯱', '鱸', '鷉', '鸕', '黸', '齇',
        ],
    },
    Membership {
        radical: '西',
        strokes: 6,
        kanji: &[
            '価', '偠', '僄', '僊', '僲', '價', '凓', '剽', '勡', '哂', '喓', '噂', '垔', '堙',
            '嫖', '幖', '廼', '弻', '彯', '徱', '慄', '慓', '憟', '拪', '摽', '晒', '栖', '栗',
            '標', '樮', '檟', '洒', '湮', '溧', '漂', '潭', '煙', '熛', '瑮', '瓢', '甄', '瘭',
            '瞟', '硒', '磦', '票', '禋', '禫', '篥', '簟', '粞', '粟', '縹', '翲', '腰', '膘',
            '茜', '葽', '蕈', '薸', '薽', '螵', '蟫', '褾', '襾', '西', '要', '覃', '覆', '覇',
            '覈', '覉', '覊', '譚', '賈', '贉', '跴', '躚', '迺', '遷', '鄄', '醰', '鏢', '鐔',
            '闉', '陻', '韆', '飃', '飄', '驃', '驔', '鰾', '鱏',
        ],
    },
    Membership {
        radical: '艮',
        strokes: 6,
        kanji: &[
            '佷', '俍', '匓', '即', '卿', '厩', '喞', '嚮', '嚼', '垠', '埌', '墾', '娘', '廊',
            '廏', '廐', '很', '恨', '悢', '慨', '懇', '懩', '攁', '既', '曁', '朖', '朗', '根',
            '桹', '概', '榔', '櫛', '欝', '浪', '漑', '烺', '爵', '狠', '狼', '琅', '瑯', '痕',
            '眼', '硠', '稂', '筤', '節', '簋', '籑', '粮', '羪', '腿', '艆', '艮', '良', '艱',
            '茛', '莨', '蜋', '螂', '褪', '誏', '豤', '貇', '跟', '踉', '退', '郎', '郷', '銀',
            '鋃', '閬', '限', '響', '飡', '飧', '飼', '餈', '餌', '饔', '饗', '饜', '鱶', '齦',
        ],
    },
    Membership {
        radical: '自',
        strokes: 6,
        kanji: &[
            '偱', '優', '劓', '厦', '咱', '嗄', '嗅', '嘎', '嘷', '噵', '嚊', '夏', '夒', '夓',
            '夔', '奡', '媳', '嬶', '寡', '寱', '導', '巎', '巙', '廈', '息', '憂', '憩', '戛',
            '戞', '擤', '擾', '榎', '櫌', '殠', '洎', '渞', '濞', '瀀', '熄', '瘜', '癟', '皥',
            '籩', '糗', '翺', '耰', '脜', '自', '臫', '臬', '臭', '臰', '臱', '臲', '艏', '虁',
            '螅', '衋', '衜', '衟', '襣', '辠', '道', '邉', '邊', '鎴', '闑', '首', '馗', '馘',
            '鼻', '鼼', '鼽', '鼾', '鼿', '齁', '齃', '齄', '齅', '齆', '齇',
        ],
    },
    Membership {
        radical: '舟',
        strokes: 6,
        kanji: &[
            '坍', '媻', '幋', '彤', '搬', '槃', '瘢', '盤', '矪', '磐', '舟', '舡', '舢', '舨',
            '舩', '航', '舫', '般', '舮', '舲', '舳', '舴', '舵', '舶', '舷', '舸', '船', '舺',
            '艀', '艃', '艄', '艅', '艆', '艇', '艋', '艎', '艏', '艑', '艖', '艘', '艙', '艚',
            '艜', '艝', '艟', '艠', '艢', '艣', '艤', '艦', '艧', '艨', '艪', '艫', '艭', '螌',
            '輈', '鞶', '鵃',
        ],
    },
    Membership {
        radical: '而',
        strokes: 6,
        kanji: &[
            '儒', '喘', '嚅', '圌', '堧', '壖', '嬬', '孺', '恧', '惴', '愞', '懦', '揣', '擩',
            '栭', '檽', '洏', '湍', '濡', '煗', '燸', '猯', '瑞', '碝', '端', '篅', '粫', '糯',
            '繻', '而', '耍', '耎', '耏', '耐', '耑', '胹', '腨', '臑', '薷', '蝡', '蠕', '褍',
            '襦', '貒', '踹', '輀', '輭', '轜', '遄', '鍴', '陾', '需', '顓', '顬', '髵', '鮞',
            '鴯',
        ],
    },
    Membership {
        radical: '聿',
        strokes: 6,
        kanji: &[
            '侓', '健', '傭', '冿', '劃', '嘯', '圕', '壗', '嵂', '庸', '建', '律', '徤', '慵',
            '揵', '旔', '晝', '書', '楗', '津', '滽', '燼', '牅', '犍', '珒', '畫', '盡', '筆',
            '箻', '簫', '聿', '肁', '肄', '肅', '肆', '肇', '肈', '腱', '茟', '葎', '葏', '蕭',
            '衋', '鄘', '銉', '鍵', '鏞', '鞬', '鱅',
        ],
    },
    Membership {
        radical: '缶',
        strokes: 6,
        kanji: &[
            '傜', '匋', '媱', '寚', '寶', '徭', '掏', '掣', '搖', '旆', '暚', '淘', '猺', '瑤',
            '瑶', '祹', '窑', '窰', '綯', '繇', '缶', '缸', '缺', '缻', '缼', '缽', '缾', '缿',
            '罃', '罄', '罅', '罇', '罌', '罍', '罎', '罏', '罐', '萄', '謠', '遙', '陶', '颻',
            '鬱', '鰩', '鷂',
        ],
    },
    Membership {
        radical: '至',
        strokes: 6,
        kanji: &[
            '倒', '偓', '到', '厔', '咥', '喔', '垤', '姪', '室', '屋', '幄', '庢', '挃', '握',
            '擡', '晊', '桎', '椡', '榁', '檯', '渥', '窒', '絰', '緻', '耊', '耋', '腟', '膣',
            '至', '致', '臵', '臶', '臸', '臹', '臺', '臻', '荎', '薹', '蛭', '輊', '郅', '銍',
            '鰘', '鵄', '齷',
        ],
    },
    Membership {
        radical: '行',
        strokes: 6,
        kanji: &[
            '哘', '垳', '愆', '桁', '珩', '筕', '絎', '荇', '行', '衍', '衎', '衑', '衒', '術',
            '衕', '衖', '街', '衘', '衙', '衚', '衛', '衜', '衝', '衞', '衟', '衠', '衡', '衢',
            '裄', '讏', '躛', '銜', '鴴', '鵆',
        ],
    },
    Membership {
        radical: '舌',
        strokes: 6,
        kanji: &[
            '乱', '佸', '刮', '恬', '憇', '憩', '括', '栝', '活', '湉', '濶', '甜', '筈', '聒',
            '舌', '舍', '舏', '舐', '舒', '舓', '舔', '舖', '舙', '舚', '蛞', '話', '辞', '适',
            '銛', '闊', '餂', '髺', '鴰',
        ],
    },
    Membership {
        radical: '耒',
        strokes: 6,
        kanji: &[
            '棅', '業', '籍', '耒', '耓', '耔', '耕', '耖', '耗', '耘', '耙', '耜', '耝', '耞',
            '耟', '耠', '耡', '耤', '耦', '耨', '耬', '耮', '耰', '藉', '藕', '誄',
        ],
    },
    Membership {
        radical: '瓜',
        strokes: 6,
        kanji: &[
            '呱', '孤', '寙', '弧', '柧', '泒', '狐', '瓜', '瓞', '瓟', '瓠', '瓢', '瓣', '瓤',
            '窊', '窳', '笟', '箛', '罛', '胍', '苽', '菰', '蓏', '觚', '軱',
        ],
    },
    Membership {
        radical: '血',
        strokes: 6,
        kanji: &[
            '侐', '卹', '恤', '洫', '血', '衁', '衂', '衃', '衄', '衅', '衆', '衈', '衉', '衊',
            '衋', '賉',
        ],
    },
    Membership {
        radical: '色',
        strokes: 6,
        kanji: &[
            '栬', '灔', '絶', '脃', '色', '艴', '艶', '艷', '蕝', '赩', '銫', '鑱', '饞',
        ],
    },
    Membership {
        radical: '肉',
        strokes: 6,
        kanji: &['哊', '瘸', '肉', '胔', '胾', '腐', '膐', '臋', '臠', '臡'],
    },
    Membership {
        radical: '貝',
        strokes: 7,
        kanji: &[
            '側', '偵', '傊', '債', '傾', '僓', '僨', '價', '儐', '償', '儧', '儨', '儬', '儹',
            '則', '劕', '劗', '勛', '勣', '勩', '匱', '匵', '厠', '員', '唄', '嗩', '嗿', '嘖',
            '嘳', '噴', '噸', '嚬', '嚶', '囂', '囋', '囎', '圓', '圚', '埧', '塡', '塤', '墳',
            '壝', '夒', '夓', '媜', '嬪', '嬰', '嬾', '孾', '寘', '實', '寳', '寶', '尵', '屓',
            '屭', '崱', '嵿', '嶺', '巎', '巓', '幀', '幘', '廁', '廎', '惻', '愪', '慣', '憒',
            '憤', '懶', '戇', '戝', '揁', '損', '摜', '擯', '擷', '攅', '攢', '敗', '梖', '楨',
            '槇', '槓', '樌', '樻', '檟', '檱', '檳', '櫃', '櫕', '櫝', '櫻', '欑', '歵', '殞',
            '殨', '殯', '殰', '測', '湏', '湞', '溳', '漬', '潁', '潰', '澃', '澒', '澦', '濆',
            '濱', '濵', '濺', '濽', '瀆', '瀕', '瀬', '瀴', '灝', '煩', '熕', '熲', '燌', '牘',
            '犢', '狽', '獖', '獱', '獺', '瑣', '瓉', '瓔', '瓚', '甖', '癩', '癪', '癭', '癲',
            '皟', '盨', '瞔', '瞶', '矉', '碩', '碵', '碽', '磌', '磒', '磧', '礥', '礩', '禎',
            '禛', '稹', '積', '穎', '竇', '篔', '簀', '簣', '籟', '籲', '縜', '縝', '績', '繢',
            '繽', '纇', '纈', '纉', '續', '纐', '纓', '纘', '罌', '聵', '膩', '臏', '萯', '蔶',
            '蕆', '蕒', '蕡', '蕢', '蕷', '薋', '薠', '藚', '藾', '蘋', '蘡', '蛽', '蠙', '衠',
            '襀', '襭', '襰', '覿', '讀', '讃', '讚', '讟', '豶', '貝', '貞', '負', '財', '貢',
            '貤', '貧', '貨', '販', '貪', '貫', '責', '貭', '貮', '貯', '貰', '貲', '貳', '貴',
            '貶', '買', '貸', '貹', '貺', '費', '貼', '貽', '貿', '賀', '賁', '賂', '賃', '賄',
            '賅', '賆', '資', '賈', '賉', '賊', '賋', '賍', '賎', '賏', '賑', '賓', '賕', '賖',
            '賙', '賚', '賛', '賜', '賝', '賞', '賠', '賡', '賢', '賣', '賤', '賦', '賨', '質',
            '賬', '賭', '賯', '賰', '賲', '賵', '賷', '賸', '賺', '賻', '購', '賽', '賾', '賿',
            '贁', '贃', '贄', '贅', '贇', '贈', '贉', '贊', '贋', '贍', '贏', '贐', '贒', '贓',
            '贔', '贖', '贗', '贛', '赬', '趲', '蹎', '蹞', '蹟', '躓', '轒', '遉', '遦', '遺',
            '郥', '鄖', '鄮', '鄼', '酇', '鋇', '鍘', '鍞', '鎖', '鏆', '鑌', '鑕', '鑚', '鑜',
            '鑟', '鑽', '閴', '闐', '闝', '闠', '隕', '隤', '霣', '靧', '鞼', '韇', '韻', '頁',
            '頂', '頃', '項', '順', '頇', '須', '頊', '頌', '頍', '頎', '頏', '預', '頑', '頒',
            '頓', '頔', '頖', '頗', '領', '頙', '頚', '頜', '頞', '頠', '頡', '頣', '頤', '頥',
            '頦', '頫', '頬', '頭', '頮', '頯', '頰', '頲', '頳', '頴', '頵', '頷', '頸', '頻',
            '頼', '頽', '頾', '顄', '顆', '顇', '顊', '顋', '題', '額', '顎', '顏', '顑', '顒',
            '顓', '顔', '顕', '顖', '顗', '願', '顙', '顚', '顛', '類', '顢', '顣', '顥', '顦',
            '顧', '顪', '顫', '顬', '顯', '顰', '顱', '顳', '顴', '饋', '饙', '髕', '鬒', '鬚',
            '鬢', '鰂', '鱝', '鵙', '鸎', '鸚', '黰', '黷', '齎', '龥',
        ],
    },
    Membership {
        radical: '言',
        strokes: 7,
        kanji: &[
            '信', '傠', '儋', '儲', '卛', '唁', '噡', '圁', '圝', '孌', '孿', '嶽', '巒', '幨',
            '彎', '悥', '憺', '戀', '揈', '擔', '攣', '曫', '檐', '櫧', '欒', '渹', '滸', '澹',
            '灣', '灤', '燮', '狺', '獄', '癴', '瞻', '矕', '簷', '纞', '罰', '罸', '膽', '臠',
            '舚', '蔎', '薝', '藷', '藹', '蘐', '蟾', '蠻', '襜', '言', '訂', '訃', '訄', '訅',
            '訇', '計', '訊', '訌', '討', '訏', '訐', '訑', '訒', '訓', '訔', '訕', '訖', '託',
            '記', '訛', '訝', '訞', '訟', '訠', '訢', '訣', '訤', '訥', '訦', '訪', '訫', '訬',
            '設', '訯', '許', '訳', '訴', '訵', '訶', '訷', '診', '註', '証', '訽', '訾', '詀',
            '詁', '詃', '詅', '詆', '詇', '詈', '詉', '詍', '詎', '詐', '詑', '詒', '詓', '詔',
            '評', '詖', '詗', '詘', '詛', '詜', '詝', '詞', '詠', '詡', '詢', '詣', '詥', '試',
            '詧', '詩', '詫', '詬', '詭', '詮', '詰', '話', '該', '詳', '詵', '詶', '詷', '詹',
            '詺', '詻', '詼', '詾', '詿', '誀', '誂', '誃', '誄', '誅', '誆', '誇', '誉', '誋',
            '誌', '認', '誏', '誐', '誑', '誒', '誓', '誕', '誖', '誗', '誘', '誙', '誚', '語',
            '誟', '誠', '誡', '誣', '誤', '誥', '誦', '誧', '誨', '誩', '説', '読', '誮', '誯',
            '誰', '課', '誳', '誶', '誷', '誹', '誻', '誼', '誾', '調', '諂', '諃', '諄', '諆',
            '談', '諈', '諉', '諊', '請', '諌', '諍', '諏', '諑', '諒', '諓', '諔', '諕', '論',
            '諗', '諚', '諛', '諜', '諝', '諞', '諟', '諠', '諡', '諢', '諤', '諦', '諧', '諫',
            '諬', '諭', '諮', '諰', '諱', '諳', '諴', '諵', '諶', '諷', '諸', '諺', '諼', '諾',
            '諿', '謀', '謁', '謂', '謄', '謅', '謆', '謇', '謊', '謋', '謌', '謎', '謐', '謑',
            '謔', '謖', '謗', '謙', '謚', '講', '謜', '謝', '謞', '謟', '謠', '謡', '謦', '謨',
            '謫', '謬', '謭', '謰', '謳', '謷', '謹', '謼', '謾', '譁', '譂', '譃', '譄', '譅',
            '譆', '譈', '證', '譌', '譍', '譎', '譏', '譒', '譓', '譔', '譖', '識', '譙', '譚',
            '譛', '譜', '譞', '譟', '譣', '警', '譫', '譬', '譭', '譯', '議', '譱', '譲', '譴',
            '譶', '護', '譸', '譹', '譼', '譽', '譾', '讀', '讁', '讃', '讄', '讅', '變', '讋',
            '讌', '讍', '讎', '讏', '讐', '讒', '讓', '讔', '讕', '讖', '讙', '讚', '讜', '讞',
            '讟', '贍', '躞', '輷', '辯', '這', '邎', '鍧', '鑾', '霅', '靄', '鞫', '鸑', '鸞',
            '黵',
        ],
    },
    Membership {
        radical: '車',
        strokes: 7,
        kanji: &[
            '俥', '偅', '僌', '儎', '匭', '厙', '喗', '嗹', '囀', '埵', '堹', '塹', '塼', '墼',
            '壍', '壎', '尰', '嶃', '嶄', '庫', '惲', '慙', '慚', '懂', '揮', '撃', '擊', '斬',
            '暈', '暉', '暫', '曛', '楎', '槧', '檋', '毄', '渾', '漣', '漸', '煇', '琿', '璉',
            '畽', '瘇', '瘒', '皸', '皹', '睴', '硨', '磛', '箽', '範', '縺', '繋', '繫', '翬',
            '葷', '蓮', '蔪', '蛼', '蟿', '褌', '褲', '諢', '謰', '蹔', '車', '軋', '軌', '軍',
            '軏', '軑', '軒', '軔', '軛', '軜', '軟', '転', '軣', '軨', '軫', '軭', '軮', '軰',
            '軱', '軷', '軸', '軹', '軺', '軻', '軼', '軽', '軾', '輀', '輂', '較', '輅', '輇',
            '輈', '載', '輊', '輌', '輏', '輐', '輒', '輓', '輔', '輕', '輖', '輗', '輘', '輙',
            '輛', '輜', '輝', '輞', '輟', '輠', '輡', '輣', '輥', '輦', '輧', '輨', '輩', '輪',
            '輬', '輭', '輮', '輯', '輳', '輴', '輵', '輶', '輷', '輸', '輹', '輺', '輻', '輾',
            '輿', '轀', '轁', '轂', '轃', '轄', '轅', '轆', '轇', '轉', '轌', '轍', '轎', '轏',
            '轑', '轒', '轓', '轔', '轕', '轗', '轘', '轜', '轝', '轞', '轟', '轡', '轢', '轣',
            '轤', '轥', '連', '運', '鄆', '錷', '鍕', '鏈', '鏨', '陣', '韗', '餫', '鰱', '鶤',
            '鼲', '齳',
        ],
    },
    Membership {
        radical: '足',
        strokes: 7,
        kanji: &[
            '促', '捉', '攓', '浞', '潞', '珿', '璐', '簬', '蕗', '虂', '足', '趵', '趷', '趹',
            '趺', '趻', '趼', '趾', '跀', '跂', '跅', '跆', '跇', '跈', '跊', '跋', '跌', '跎',
            '跏', '跑', '跔', '跕', '跖', '跗', '跙', '跚', '跛', '距', '跟', '跡', '跣', '跤',
            '跥', '跧', '跨', '跪', '跫', '跬', '路', '跰', '跱', '跲', '跳', '跴', '践', '跼',
            '跽', '跿', '踁', '踄', '踅', '踆', '踈', '踉', '踊', '踋', '踏', '踐', '踑', '踔',
            '踖', '踝', '踞', '踟', '踠', '踡', '踢', '踣', '踦', '踧', '踪', '踰', '踱', '踳',
            '踴', '踵', '踶', '踷', '踸', '踹', '踽', '蹀', '蹁', '蹂', '蹄', '蹇', '蹈', '蹉',
            '蹊', '蹋', '蹌', '蹍', '蹎', '蹏', '蹐', '蹔', '蹕', '蹙', '蹛', '蹜', '蹝', '蹞',
            '蹟', '蹠', '蹡', '蹢', '蹣', '蹤', '蹩', '蹬', '蹭', '蹯', '蹰', '蹱', '蹲', '蹴',
            '蹶', '蹹', '蹺', '蹻', '蹼', '躁', '躂', '躃', '躄', '躅', '躇', '躉', '躊', '躋',
            '躍', '躐', '躑', '躒', '躓', '躔', '躕', '躙', '躚', '躛', '躝', '躞', '躡', '躢',
            '躧', '躩', '躪', '鋜', '露', '鷺', '齪',
        ],
    },
    Membership {
        radical: '豆',
        strokes: 7,
        kanji: &[
            '僖', '僜', '凒', '凱', '凳', '剅', '剴', '厨', '喜', '嘻', '噎', '噔', '嚭', '嚱',
            '囍', '囏', '塏', '墱', '壹', '嬁', '嬉', '尌', '嶝', '巇', '幮', '廚', '彭', '愷',
            '憘', '憙', '懿', '戲', '暟', '暿', '曀', '梪', '榿', '樹', '橙', '橱', '橲', '櫈',
            '櫉', '歖', '殪', '澄', '澍', '澎', '澧', '灃', '灎', '灔', '熹', '熺', '燈', '獃',
            '璒', '痘', '登', '皚', '皷', '瞪', '瞽', '短', '磑', '磴', '禧', '禮', '簦', '糦',
            '繥', '脰', '膨', '艠', '艶', '艷', '荳', '螘', '蟚', '蟢', '裋', '覬', '覴', '譆',
            '證', '豆', '豇', '豈', '豉', '豊', '豋', '豌', '豎', '豏', '豐', '豑', '豓', '豔',
            '蹬', '蹰', '躕', '軆', '逗', '鄧', '鄷', '醴', '鋀', '鎧', '鐙', '鐡', '闓', '闘',
            '闦', '隑', '隥', '靊', '頭', '顗', '餖', '饎', '饐', '體', '鬪', '鱚', '鱧', '鷧',
            '鼓', '鼔', '鼕', '鼖', '鼗', '鼙', '鼚', '鼛', '鼟',
        ],
    },
    Membership {
        radical: '酉',
        strokes: 7,
        kanji: &[
            '僔', '墫', '奠', '尊', '嶟', '撙', '擲', '梄', '楢', '槱', '樽', '歠', '猶', '猷',
            '盦', '竴', '罇', '蓜', '蕕', '蘸', '蝤', '蹲', '躑', '輏', '輶', '逎', '遒', '遵',
            '鄭', '酉', '酊', '酋', '酌', '配', '酎', '酏', '酒', '酓', '酔', '酖', '酗', '酘',
            '酙', '酚', '酛', '酡', '酢', '酣', '酤', '酥', '酧', '酩', '酪', '酬', '酭', '酲',
            '酳', '酴', '酵', '酷', '酸', '酹', '酺', '酻', '醁', '醂', '醃', '醅', '醆', '醇',
            '醉', '醊', '醋', '醍', '醎', '醐', '醑', '醒', '醓', '醔', '醕', '醗', '醘', '醜',
            '醞', '醡', '醢', '醤', '醦', '醨', '醪', '醫', '醬', '醭', '醮', '醯', '醰', '醱',
            '醲', '醳', '醴', '醵', '醶', '醸', '醺', '醻', '醼', '醽', '醿', '釀', '釁', '釂',
            '釃', '釅', '鐏', '鰌', '鱒',
        ],
    },
    Membership {
        radical: '豕',
        strokes: 7,
        kanji: &[
            '傢', '像', '冡', '冢', '劇', '勨', '啄', '喙', '噱', '圂', '堟', '塚', '墜', '壕',
            '嫁', '家', '幪', '彖', '慁', '懞', '掾', '據', '曚', '朦', '椓', '椽', '橡', '檬',
            '櫞', '櫲', '毅', '涿', '溷', '潒', '濛', '濠', '瀦', '燧', '燹', '琢', '瑑', '璩',
            '璲', '甤', '瘃', '盠', '矇', '硺', '礞', '稼', '穟', '篆', '篴', '籧', '糘', '縁',
            '繸', '艨', '蒙', '蕤', '蘧', '蝝', '蟸', '蠓', '蠔', '蠡', '褖', '襚', '諑', '譹',
            '豕', '豗', '豘', '豙', '豚', '豛', '豝', '象', '豢', '豣', '豤', '豦', '豨', '豩',
            '豪', '豫', '豬', '豭', '豳', '豵', '豶', '逐', '遂', '遯', '遽', '邃', '醵', '鎵',
            '鐻', '隊', '隧', '饛', '鱁',
        ],
    },
    Membership {
        radical: '里',
        strokes: 7,
        kanji: &[
            '俚', '僮', '儵', '儻', '動', '厘', '哩', '嗶', '嘿', '埋', '墅', '墨', '壥', '娌',
            '幢', '廛', '徸', '悝', '憧', '戃', '撞', '攩', '曈', '梩', '榸', '橦', '浬', '滭',
            '潼', '濹', '瀍', '熚', '狸', '獞', '理', '瓼', '甅', '瞳', '種', '穜', '童', '竰',
            '糎', '糧', '纆', '纏', '纒', '罿', '腫', '艃', '艟', '董', '蕫', '薶', '衝', '裏',
            '裡', '襅', '讜', '貍', '踵', '蹱', '躔', '鄽', '里', '重', '野', '量', '釐', '鋰',
            '鍾', '鐘', '霾', '鯉', '黒', '黔', '黕', '默', '黙', '黛', '黜', '黝', '點', '黟',
            '黠', '黤', '黥', '黧', '黨', '黬', '黭', '黮', '黯', '黰', '黱', '黲', '黴', '黵',
            '黶', '黷', '黸',
        ],
    },
    Membership {
        radical: '辛',
        strokes: 7,
        kanji: &[
            '乵', '倖', '僻', '劈', '噺', '圉', '執', '報', '壁', '嬖', '孼', '孽', '宰', '幸',
            '懌', '摯', '撻', '擇', '擗', '擘', '新', '梓', '檗', '櫱', '滓', '澤', '澼', '璧',
            '瓣', '甓', '癖', '睾', '稺', '糵', '縡', '繹', '臂', '莘', '薛', '薜', '薪', '蘖',
            '蘗', '蟄', '襞', '親', '譬', '譯', '贄', '躃', '躄', '辛', '辜', '辝', '辞', '辟',
            '辠', '辡', '辣', '辤', '辥', '辦', '辧', '辨', '辭', '辮', '辯', '逹', '避', '釋',
            '鋅', '鐴', '鐸', '闢', '闥', '隦', '霹', '騂', '驛', '鷙', '鸊',
        ],
    },
    Membership {
        radical: '見',
        strokes: 7,
        kanji: &[
            '俔', '儭', '哯', '嚫', '夔', '寛', '峴', '悓', '撹', '攪', '攬', '晛', '梘', '槻',
            '櫬', '欖', '欟', '現', '睍', '硯', '窺', '筧', '絸', '纜', '臗', '莧', '虁', '蜆',
            '襯', '見', '覍', '規', '覐', '覓', '覔', '覕', '視', '覗', '覘', '覚', '覛', '覜',
            '覟', '覠', '覡', '覥', '覦', '覧', '覩', '親', '覬', '覯', '覰', '覲', '観', '覴',
            '覵', '覶', '覷', '覺', '覼', '覽', '覿', '觀', '鋧', '闚', '靚', '靦', '髖', '鬹',
        ],
    },
    Membership {
        radical: '臣',
        strokes: 7,
        kanji: &[
            '儖', '凞', '嚚', '堅', '姫', '媐', '孯', '宦', '尶', '巸', '弫', '弬', '慳', '懢',
            '挋', '掔', '擥', '攬', '朢', '榘', '樫', '檻', '欖', '濫', '煕', '熈', '監', '盬',
            '礥', '竪', '籃', '緊', '繿', '纜', '腎', '臓', '臟', '臣', '臤', '臥', '臧', '臨',
            '艦', '茝', '茞', '蔵', '藍', '藏', '襤', '覧', '覽', '譼', '豎', '賢', '賾', '贒',
            '贓', '轞', '鋻', '鍳', '鏗', '鑑', '鑒', '頣', '頤', '頥', '鰹', '鹽',
        ],
    },
    Membership {
        radical: '角',
        strokes: 7,
        kanji: &[
            '嘴', '埆', '嶰', '廨', '懈', '斛', '桷', '槲', '檞', '澥', '獬', '确', '葪', '薢',
            '蟕', '蟹', '蠏', '角', '觔', '觕', '觖', '觗', '觘', '觚', '觜', '觝', '解', '觥',
            '触', '觧', '觩', '觫', '觭', '觱', '觳', '觴', '觶', '觸', '觹', '觽', '觿', '邂',
            '鵤',
        ],
    },
    Membership {
        radical: '走',
        strokes: 7,
        kanji: &[
            '倢', '啑', '婕', '寁', '徒', '徢', '睫', '箑', '縱', '蜨', '走', '赱', '赳', '赴',
            '起', '赿', '趁', '趂', '超', '趈', '越', '趍', '趐', '趑', '趕', '趙', '趞', '趟',
            '趠', '趣', '趦', '趨', '趫', '趬', '趯', '趲', '跿', '陡', '鯐',
        ],
    },
    Membership {
        radical: '辰',
        strokes: 7,
        kanji: &[
            '侲', '儂', '唇', '娠', '宸', '憹', '振', '敐', '晨', '曟', '槈', '溽', '漘', '濃',
            '禯', '穠', '縟', '耨', '脣', '脤', '膿', '莀', '蓐', '蕽', '薅', '蜃', '蜄', '褥',
            '襛', '賑', '辰', '辱', '農', '醲', '鋠', '鎒', '震', '麎',
        ],
    },
    Membership {
        radical: '舛',
        strokes: 7,
        kanji: &[
            '傑', '僢', '僯', '僲', '儛', '嶙', '憐', '搩', '撛', '斴', '曻', '桀', '桝', '椉',
            '橉', '潾', '燐', '璘', '瞬', '瞵', '磔', '磷', '粦', '粼', '舛', '舜', '舞', '蕣',
            '謋', '轔', '遴', '鄰', '鏻', '隣', '驎', '鱗', '麟',
        ],
    },
    Membership {
        radical: '谷',
        strokes: 7,
        kanji: &[
            '俗', '傛', '卻', '壑', '壡', '嫆', '容', '峪', '愹', '慾', '榕', '欲', '浴', '溶',
            '熔', '瑢', '硲', '穃', '綌', '蓉', '裕', '谷', '谸', '谹', '谺', '谽', '谾', '谿',
            '豁', '豅', '逧', '郤', '鎔',
        ],
    },
    Membership {
        radical: '釆',
        strokes: 7,
        kanji: &[
            '墺', '奧', '審', '幡', '悉', '懊', '播', '旙', '旛', '潘', '澳', '瀋', '燔', '燠',
            '番', '礇', '竊', '粤', '繙', '翻', '膰', '蕃', '藩', '蟋', '蟠', '襖', '釆', '釈',
            '釉', '釋', '鐇', '飜', '鷭',
        ],
    },
    Membership {
        radical: '豸',
        strokes: 7,
        kanji: &[
            '墾', '懇', '薶', '藐', '豸', '豹', '豺', '豻', '豼', '豾', '貂', '貅', '貆', '貇',
            '貉', '貊', '貋', '貌', '貍', '貎', '貐', '貒', '貓', '貔', '貘', '貙', '貛', '貜',
            '邈', '霾',
        ],
    },
    Membership {
        radical: '身',
        strokes: 7,
        kanji: &[
            '匑', '射', '窮', '藭', '裑', '謝', '身', '躬', '躭', '躮', '躯', '躰', '躱', '躳',
            '躵', '躺', '躻', '躾', '軀', '軁', '軃', '軄', '軅', '軆', '軇', '軈', '鵢', '麝',
        ],
    },
    Membership {
        radical: '赤',
        strokes: 7,
        kanji: &[
            '嚇', '奕', '弯', '焃', '爀', '繊', '螫', '赤', '赥', '赦', '赧', '赩', '赫', '赬',
            '赭', '赮', '趄', '跡', '迹', '郝', '頳',
        ],
    },
    Membership {
        radical: '麦',
        strokes: 7,
        kanji: &['麦', '麸', '麹', '麺'],
    },
    Membership {
        radical: '金',
        strokes: 8,
        kanji: &[
            '劉', '嚠', '崟', '嶔', '廞', '捦', '撳', '欽', '淦', '瀏', '瘹', '籙', '籛', '金',
            '釓', '釔', '釖', '釗', '釘', '釙', '釚', '釛', '釜', '針', '釞', '釟', '釡', '釣',
            '釤', '釥', '釦', '釧', '釩', '釪', '釬', '釭', '釮', '釯', '釰', '釱', '釵', '釶',
            '釷', '釹', '釻', '釼', '釽', '釿', '鈀', '鈁', '鈄', '鈅', '鈆', '鈇', '鈉', '鈊',
            '鈌', '鈍', '鈎', '鈐', '鈑', '鈒', '鈓', '鈔', '鈕', '鈖', '鈘', '鈜', '鈝', '鈞',
            '鈣', '鈤', '鈥', '鈦', '鈨', '鈩', '鈬', '鈮', '鈯', '鈰', '鈳', '鈴', '鈵', '鈶',
            '鈷', '鈸', '鈹', '鈺', '鈼', '鈾', '鈿', '鉀', '鉂', '鉃', '鉄', '鉅', '鉆', '鉇',
            '鉈', '鉉', '鉊', '鉋', '鉍', '鉎', '鉏', '鉐', '鉑', '鉗', '鉘', '鉙', '鉚', '鉛',
            '鉜', '鉝', '鉞', '鉠', '鉡', '鉢', '鉤', '鉥', '鉦', '鉧', '鉨', '鉩', '鉮', '鉯',
            '鉰', '鉱', '鉵', '鉶', '鉷', '鉸', '鉹', '鉻', '鉼', '鉽', '鉾', '鉿', '銀', '銃',
            '銅', '銈', '銉', '銊', '銍', '銎', '銑', '銒', '銓', '銕', '銖', '銗', '銘', '銙',
            '銚', '銛', '銜', '銟', '銠', '銤', '銥', '銧', '銨', '銫', '銭', '銯', '銲', '銶',
            '銷', '銸', '銹', '銺', '銻', '銼', '銽', '銿', '鋀', '鋁', '鋂', '鋃', '鋅', '鋆',
            '鋇', '鋈', '鋋', '鋌', '鋍', '鋎', '鋏', '鋐', '鋒', '鋓', '鋕', '鋗', '鋘', '鋙',
            '鋜', '鋝', '鋟', '鋠', '鋡', '鋣', '鋤', '鋥', '鋧', '鋨', '鋩', '鋪', '鋬', '鋭',
            '鋮', '鋰', '鋲', '鋳', '鋸', '鋹', '鋺', '鋻', '鋼', '鋿', '錀', '錂', '錆', '錈',
            '錍', '錏', '錐', '錑', '錔', '錕', '錘', '錙', '錚', '錜', '錝', '錞', '錟', '錠',
            '錡', '錢', '錣', '錤', '錥', '錦', '錧', '錨', '錩', '錪', '錫', '錬', '錮', '錯',
            '録', '錳', '錴', '錵', '錶', '錷', '錺', '錻', '鍄', '鍇', '鍈', '鍉', '鍋', '鍍',
            '鍐', '鍑', '鍒', '鍔', '鍕', '鍖', '鍗', '鍘', '鍚', '鍛', '鍜', '鍞', '鍠', '鍤',
            '鍥', '鍧', '鍩', '鍪', '鍬', '鍭', '鍮', '鍯', '鍰', '鍱', '鍳', '鍴', '鍵', '鍶',
            '鍺', '鍼', '鍽', '鍾', '鍿', '鎀', '鎁', '鎂', '鎈', '鎊', '鎋', '鎌', '鎍', '鎏',
            '鎒', '鎔', '鎕', '鎖', '鎗', '鎘', '鎚', '鎛', '鎞', '鎡', '鎣', '鎤', '鎦', '鎧',
            '鎨', '鎩', '鎫', '鎬', '鎭', '鎮', '鎰', '鎴', '鎵', '鎶', '鎹', '鎺', '鏁', '鏃',
            '鏄', '鏅', '鏆', '鏇', '鏈', '鏉', '鏊', '鏋', '鏌', '鏍', '鏐', '鏑', '鏓', '鏖',
            '鏗', '鏘', '鏙', '鏜', '鏝', '鏞', '鏟', '鏡', '鏢', '鏤', '鏥', '鏦', '鏧', '鏨',
            '鏷', '鏸', '鏹', '鏺', '鏻', '鏽', '鐁', '鐂', '鐃', '鐄', '鐇', '鐈', '鐉', '鐍',
            '鐎', '鐏', '鐐', '鐓', '鐔', '鐕', '鐖', '鐗', '鐘', '鐙', '鐚', '鐟', '鐡', '鐫',
            '鐮', '鐯', '鐱', '鐲', '鐳', '鐴', '鐵', '鐶', '鐸', '鐺', '鐻', '鐽', '鐿', '鑁',
            '鑃', '鑄', '鑅', '鑈', '鑊', '鑌', '鑑', '鑒', '鑓', '鑕', '鑙', '鑚', '鑛', '鑜',
            '鑞', '鑟', '鑠', '鑡', '鑢', '鑣', '鑨', '鑪', '鑫', '鑭', '鑮', '鑯', '鑰', '鑱',
            '鑲', '鑵', '鑷', '鑼', '鑽', '鑾', '鑿', '钁', '钃', '钄', '靎',
        ],
    },
    Membership {
        radical: '隹',
        strokes: 8,
        kanji: &[
            '催', '僱', '儁', '儸', '儺', '准', '凖', '勧', '勸', '匯', '售', '唯', '噍', '嚄',
            '嚾', '囃', '囉', '堆', '墔', '壅', '奞', '奪', '奮', '嫶', '嬥', '寉', '寯', '崔',
            '嵟', '嶊', '嶕', '嶲', '帷', '廱', '彠', '惟', '憔', '應', '懏', '懼', '懽', '戁',
            '戄', '截', '戳', '推', '搉', '携', '摧', '撨', '擁', '擕', '擢', '擭', '攉', '攜',
            '攞', '攤', '攫', '暹', '曜', '椎', '榫', '榷', '槯', '権', '樵', '檇', '檴', '櫂',
            '欆', '權', '欏', '欟', '歓', '歡', '氍', '淮', '準', '漼', '潅', '潗', '濩', '濯',
            '濰', '灈', '灉', '灌', '灕', '灘', '焦', '燋', '燿', '爟', '犨', '獲', '玀', '玃',
            '璀', '璡', '瓘', '甕', '癄', '癕', '癨', '癯', '癰', '癱', '皠', '睢', '瞧', '瞿',
            '矍', '矱', '碓', '確', '磪', '礁', '礭', '稚', '穕', '穫', '篗', '籆', '籊', '籬',
            '籮', '籰', '糴', '糶', '維', '罐', '罹', '羅', '翟', '耀', '膲', '膺', '臃', '臛',
            '臞', '臡', '舊', '艧', '艭', '萑', '蒦', '蓷', '蕉', '蕹', '薙', '藋', '藺', '藿',
            '蘸', '蘺', '蘿', '虧', '蜼', '蟭', '蠖', '蠘', '蠵', '蠼', '衢', '襍', '観', '觀',
            '觹', '觽', '觿', '誰', '譍', '譙', '護', '讎', '讐', '讙', '貛', '貜', '贋', '趯',
            '躍', '躙', '躩', '躪', '軅', '軈', '轥', '進', '邏', '醮', '錐', '鎨', '鏙', '鐎',
            '鐫', '鑃', '鑊', '鑵', '鑼', '钁', '陮', '隹', '隺', '隻', '隼', '雀', '雁', '雄',
            '雅', '集', '雇', '雉', '雊', '雋', '雌', '雍', '雎', '雑', '雒', '雕', '雖', '雘',
            '雙', '雚', '雛', '雜', '雝', '雞', '雟', '離', '難', '霍', '靃', '靏', '韄', '顦',
            '顧', '顴', '飌', '饔', '饠', '騅', '驩', '魋', '鵻', '鶴', '鷕', '鷦', '鷹', '鸐',
            '鸖', '鸛', '鸜',
        ],
    },
    Membership {
        radical: '門',
        strokes: 8,
        kanji: &[
            '們', '僩', '問', '墹', '嫺', '嫻', '悶', '憪', '憫', '捫', '擱', '攔', '斕', '椚',
            '櫚', '欄', '欗', '潤', '澖', '澗', '濶', '瀾', '熌', '燗', '燜', '爓', '爛', '爤',
            '瓓', '癇', '瞯', '矙', '礀', '簡', '籣', '繝', '聞', '蕑', '藺', '蘭', '襉', '襴',
            '襽', '覵', '誾', '讕', '躙', '躝', '躢', '躪', '轥', '鐗', '鑭', '钄', '門', '閂',
            '閃', '閄', '閇', '閈', '閉', '閊', '開', '閌', '閍', '閎', '閏', '閑', '間', '閔',
            '閖', '閘', '閙', '閝', '閞', '閟', '閠', '閡', '関', '閣', '閤', '閥', '閦', '閧',
            '閨', '閩', '閫', '閬', '閭', '閲', '閴', '閶', '閹', '閺', '閻', '閼', '閽', '閾',
            '閿', '闃', '闆', '闇', '闈', '闉', '闊', '闋', '闌', '闍', '闐', '闑', '闒', '闓',
            '闔', '闕', '闖', '闘', '闙', '闚', '關', '闝', '闞', '闟', '闠', '闡', '闢', '闤',
            '闥', '闦', '韊', '鬜', '鷳', '鷴',
        ],
    },
    Membership {
        radical: '雨',
        strokes: 8,
        kanji: &[
            '儒', '嚅', '壖', '壜', '壩', '嫮', '嬬', '孀', '孁', '孺', '屚', '懦', '摴', '擂',
            '擩', '攉', '曇', '樗', '樰', '橒', '檑', '檽', '櫺', '欛', '欞', '漏', '澐', '澪',
            '濡', '灞', '燸', '瘺', '癨', '礌', '礭', '礵', '糯', '繧', '繻', '罎', '膤', '臑',
            '臛', '艝', '蕓', '蕾', '薷', '藿', '蘎', '虂', '蠕', '襦', '轌', '轜', '鄠', '酃',
            '醽', '鐳', '雨', '雩', '雪', '雫', '雯', '雰', '雱', '雲', '零', '雷', '雹', '雺',
            '電', '需', '霂', '霃', '霄', '霅', '霆', '震', '霈', '霉', '霊', '霍', '霎', '霏',
            '霑', '霓', '霖', '霙', '霚', '霛', '霜', '霝', '霞', '霡', '霢', '霣', '霤', '霧',
            '霨', '霪', '霰', '霱', '露', '霳', '霸', '霹', '霽', '霾', '靁', '靂', '靃', '靄',
            '靆', '靈', '靉', '靊', '靎', '靏', '顬', '鱈', '鱩', '鸖', '龗',
        ],
    },
    Membership {
        radical: '長',
        strokes: 8,
        kanji: &[
            '倀', '套', '帳', '張', '悵', '棖', '漲', '痮', '粻', '肆', '脹', '萇', '蕻', '賬',
            '鋹', '長', '韔', '餦', '髟', '髠', '髢', '髣', '髤', '髥', '髦', '髧', '髩', '髪',
            '髫', '髬', '髭', '髮', '髯', '髱', '髲', '髳', '髴', '髵', '髷', '髹', '髺', '髻',
            '髽', '髿', '鬀', '鬁', '鬂', '鬃', '鬄', '鬅', '鬆', '鬈', '鬉', '鬋', '鬌', '鬍',
            '鬎', '鬐', '鬒', '鬖', '鬘', '鬙', '鬚', '鬛', '鬜', '鬟', '鬠', '鬢', '鬣', '鼚',
        ],
    },
    Membership {
        radical: '非',
        strokes: 8,
        kanji: &[
            '俳', '剕', '劘', '匪', '啡', '徘', '悱', '悲', '扉', '排', '斐', '暃', '棐', '棑',
            '榧', '櫼', '渄', '瀣', '猅', '琲', '痱', '篚', '緋', '罪', '翡', '腓', '菲', '蕜',
            '蘼', '虀', '蜚', '裴', '裵', '襳', '誹', '輩', '鑯', '霏', '非', '靠', '靡', '韯',
            '韱', '騑', '鯡',
        ],
    },
    Membership {
        radical: '青',
        strokes: 8,
        kanji: &[
            '倩', '儬', '圊', '婧', '情', '晴', '棈', '清', '瀞', '猜', '睛', '箐', '精', '綪',
            '菁', '蒨', '蔳', '蜻', '請', '錆', '青', '靕', '靖', '靗', '靘', '静', '靚', '靛',
            '靜', '鯖', '鼱',
        ],
    },
    Membership {
        radical: '免',
        strokes: 8,
        kanji: &[
            '俛', '儳', '免', '兔', '冕', '冤', '凂', '劖', '勉', '堍', '娩', '寃', '悗', '挽',
            '攙', '晩', '梚', '欃', '毚', '浼', '絻', '莬', '輓', '逸', '鮸',
        ],
    },
    Membership {
        radical: '隶',
        strokes: 8,
        kanji: &[
            '嘯', '埭', '康', '慷', '捸', '曃', '棣', '碌', '祿', '禄', '穅', '簫', '粛', '糠',
            '緑', '繍', '逮', '録', '隶', '隷', '隸', '靆', '鱇',
        ],
    },
    Membership {
        radical: '奄',
        strokes: 8,
        kanji: &[
            '俺', '剦', '唵', '奄', '奙', '崦', '掩', '晻', '殗', '淹', '罨', '腌', '菴', '醃',
            '閹', '黤',
        ],
    },
    Membership {
        radical: '岡',
        strokes: 8,
        kanji: &['剛', '堈', '岡', '崗', '棡', '綱', '鋼'],
    },
    Membership {
        radical: '斉',
        strokes: 8,
        kanji: &['剤', '斉', '斎', '済', '緕'],
    },
    Membership {
        radical: '頁',
        strokes: 9,
        kanji: &[
            '傾', '噸', '嚬', '囂', '夒', '夓', '嬾', '寘', '嵿', '嶺', '巎', '巓', '廎', '懶',
            '擷', '湏', '潁', '澃', '澒', '澦', '瀕', '瀬', '灝', '煩', '熲', '獺', '癩', '癲',
            '盨', '碩', '穎', '籟', '籲', '纇', '纈', '纐', '蕷', '薠', '藾', '蘋', '襭', '蹞',
            '頁', '頂', '頃', '項', '順', '頇', '須', '頊', '頌', '頍', '頎', '頏', '預', '頑',
            '頒', '頓', '頔', '頖', '頗', '領', '頙', '頚', '頜', '頞', '頠', '頡', '頣', '頤',
            '頥', '頦', '頫', '頬', '頭', '頮', '頯', '頰', '頲', '頳', '頴', '頵', '頷', '頸',
            '頻', '頼', '頽', '頾', '顄', '顆', '顇', '顊', '顋', '題', '額', '顎', '顏', '顑',
            '顒', '顓', '顔', '顕', '顖', '顗', '願', '顙', '顚', '顛', '類', '顢', '顣', '顥',
            '顦', '顧', '顪', '顫', '顬', '顯', '顰', '顱', '顳', '顴', '鬚', '龥',
        ],
    },
    Membership {
        radical: '革',
        strokes: 9,
        kanji: &[
            '勒', '厪', '囏', '墐', '壩', '廑', '慬', '戁', '斳', '暵', '欛', '殣', '漌', '灞',
            '熯', '癱', '緙', '羇', '羈', '臡', '覇', '覉', '覊', '鄞', '霸', '革', '靪', '靫',
            '靭', '靮', '靱', '靳', '靴', '靶', '靷', '靸', '靹', '靺', '靻', '靼', '靽', '靿',
            '鞀', '鞁', '鞄', '鞅', '鞆', '鞉', '鞋', '鞍', '鞏', '鞐', '鞕', '鞖', '鞗', '鞘',
            '鞙', '鞚', '鞜', '鞞', '鞟', '鞠', '鞢', '鞣', '鞦', '鞨', '鞫', '鞬', '鞭', '鞮',
            '鞱', '鞲', '鞳', '鞴', '鞵', '鞶', '鞸', '鞹', '鞺', '鞼', '鞾', '鞿', '韁', '韃',
            '韄', '韅', '韆', '韇', '韈', '韉', '韊',
        ],
    },
    Membership {
        radical: '音',
        strokes: 9,
        kanji: &[
            '偣', '傹', '傽', '億', '喑', '噫', '境', '嫜', '嶂', '幟', '彰', '意', '憶', '暗',
            '樟', '檍', '歆', '漳', '熾', '獍', '獐', '璋', '瘖', '瘴', '瞕', '竟', '章', '竸',
            '織', '職', '臆', '諳', '識', '軄', '鄣', '鏡', '鐿', '闇', '障', '音', '韴', '韵',
            '韶', '韷', '韸', '韺', '韻', '響', '鱆', '鷾', '麞', '黯',
        ],
    },
    Membership {
        radical: '食',
        strokes: 9,
        kanji: &[
            '喰', '瀁', '癢', '蝕', '食', '飢', '飩', '飫', '飭', '飮', '飯', '飲', '飴', '飼',
            '飽', '飾', '餃', '餅', '餉', '養', '餌', '餐', '餒', '餓', '餔', '餘', '餝', '餞',
            '餠', '餡', '餤', '館', '餬', '餮', '餽', '餾', '饂', '饅', '饉', '饋', '饌', '饐',
            '饑', '饒', '饕', '饗', '鱶',
        ],
    },
    Membership {
        radical: '風',
        strokes: 9,
        kanji: &[
            '偑', '嵐', '楓', '渢', '瘋', '繭', '諷', '風', '颪', '颫', '颭', '颮', '颯', '颰',
            '颱', '颴', '颶', '颷', '颸', '颺', '颻', '颿', '飂', '飃', '飄', '飅', '飆', '飈',
            '飌',
        ],
    },
    Membership {
        radical: '品',
        strokes: 9,
        kanji: &[
            '傴', '區', '品', '嘔', '噪', '奩', '嫗', '嵒', '嶇', '懆', '操', '樞', '歐', '毆',
            '澡', '燥', '甌', '癌', '繰', '臨', '蕚', '藻', '謳', '譟', '躁', '驅', '髞',
        ],
    },
    Membership {
        radical: '韭',
        strokes: 9,
        kanji: &[
            '孅', '懴', '懺', '殱', '殲', '籖', '籤', '纎', '纖', '薤', '讖', '韭', '韮', '韲',
            '齏',
        ],
    },
    Membership {
        radical: '面',
        strokes: 9,
        kanji: &[
            '偭', '勔', '愐', '湎', '緬', '面', '靤', '靦', '靧', '靨', '麵', '麺',
        ],
    },
    Membership {
        radical: '首',
        strokes: 9,
        kanji: &[
            '噵', '夔', '導', '巙', '渞', '艏', '虁', '衜', '道', '首', '馗', '馘',
        ],
    },
    Membership {
        radical: '香',
        strokes: 9,
        kanji: &['楿', '香', '馥', '馨'],
    },
    Membership {
        radical: '飛',
        strokes: 9,
        kanji: &['飛', '飜'],
    },
    Membership {
        radical: '馬',
        strokes: 10,
        kanji: &[
            '儯', '凴', '嗎', '媽', '慿', '憑', '瑪', '碼', '礟', '禡', '篤', '罵', '羈', '螞',
            '覊', '闖', '隲', '颿', '馬', '馭', '馮', '馰', '馱', '馲', '馳', '馴', '馵', '馹',
            '馺', '馼', '馽', '馿', '駁', '駃', '駄', '駅', '駆', '駈', '駉', '駐', '駑', '駒',
            '駓', '駔', '駕', '駘', '駙', '駚', '駛', '駜', '駝', '駞', '駟', '駢', '駧', '駪',
            '駫', '駬', '駭', '駮', '駰', '駱', '駲', '駴', '駵', '駸', '駹', '駻', '駽', '駾',
            '駿', '騁', '騂', '騃', '騄', '騅', '騋', '騌', '騎', '騏', '騐', '騑', '騒', '験',
            '騖', '騙', '騞', '騠', '騢', '騣', '騤', '騧', '騨', '騫', '騭', '騮', '騰', '騳',
            '騵', '騶', '騷', '騸', '騾', '驀', '驁', '驂', '驃', '驄', '驅', '驇', '驊', '驋',
            '驌', '驍', '驎', '驑', '驔', '驕', '驖', '驗', '驚', '驛', '驝', '驟', '驢', '驤',
            '驥', '驩', '驪', '驫', '鰢',
        ],
    },
    Membership {
        radical: '髟',
        strokes: 10,
        kanji: &[
            '髟', '髠', '髢', '髣', '髤', '髥', '髦', '髧', '髩', '髪', '髫', '髬', '髭', '髮',
            '髯', '髱', '髲', '髳', '髴', '髵', '髷', '髹', '髺', '髻', '髽', '髿', '鬀', '鬁',
            '鬂', '鬃', '鬄', '鬅', '鬆', '鬈', '鬉', '鬋', '鬌', '鬍', '鬎', '鬐', '鬒', '鬖',
            '鬘', '鬙', '鬚', '鬛', '鬜', '鬟', '鬠', '鬢', '鬣',
        ],
    },
    Membership {
        radical: '骨',
        strokes: 10,
        kanji: &[
            '嗗', '搰', '榾', '滑', '猾', '磆', '蓇', '骨', '骪', '骬', '骭', '骮', '骯', '骰',
            '骲', '骴', '骵', '骶', '骸', '骹', '骻', '骼', '骾', '骿', '髀', '髁', '髃', '髄',
            '髆', '髈', '髎', '髏', '髐', '髑', '髒', '髓', '體', '髕', '髖', '髗', '鶻',
        ],
    },
    Membership {
        radical: '鬼',
        strokes: 10,
        kanji: &[
            '傀', '塊', '媿', '嵬', '巍', '廆', '愧', '槐', '櫆', '瑰', '瘣', '磈', '聭', '莵',
            '蒐', '蘶', '醜', '隗', '餽', '鬼', '鬽', '魁', '魂', '魃', '魄', '魅', '魈', '魋',
            '魌', '魍', '魎', '魏', '魑', '魔', '魕', '魖', '魗', '魘',
        ],
    },
    Membership {
        radical: '韋',
        strokes: 10,
        kanji: &[
            '偉', '圍', '幃', '徫', '愇', '暐', '湋', '煒', '瑋', '禕', '緯', '葦', '衛', '褘',
            '諱', '違', '闈', '韋', '韌', '韍', '韎', '韐', '韑', '韓', '韔', '韗', '韘', '韙',
            '韛', '韜', '韝', '韞', '韠', '韡', '韤',
        ],
    },
    Membership {
        radical: '高',
        strokes: 10,
        kanji: &[
            '傐', '嗃', '嚆', '塙', '嵩', '嵪', '搞', '敲', '暠', '槁', '歊', '毃', '滈', '熇',
            '犒', '皜', '碻', '稾', '稿', '篙', '縞', '翯', '膏', '蒿', '藁', '藳', '謞', '鄗',
            '鎬', '高', '髛', '髜', '髞', '鶮',
        ],
    },
    Membership {
        radical: '鬲',
        strokes: 10,
        kanji: &[
            '囐', '巘', '槅', '灊', '獻', '瓛', '甗', '翮', '膈', '融', '讞', '鎘', '隔', '鬲',
            '鬳', '鬴', '鬵', '鬷', '鬹', '鬺', '鬻', '鷊',
        ],
    },
    Membership {
        radical: '竜',
        strokes: 10,
        kanji: &[
            '嚨', '巃', '攏', '曨', '槞', '滝', '礱', '竉', '竜', '篭', '讋', '豅', '鑨', '龏',
            '龐', '龑', '龒', '龔', '龖', '龗',
        ],
    },
    Membership {
        radical: '鬥',
        strokes: 10,
        kanji: &['鬥', '鬧', '鬨', '鬩', '鬪', '鬮'],
    },
    Membership {
        radical: '鬯',
        strokes: 10,
        kanji: &['鬯', '鬱'],
    },
    Membership {
        radical: '魚',
        strokes: 11,
        kanji: &[
            '嚕', '囌', '櫓', '漁', '癬', '穌', '穭', '艪', '薊', '蘇', '蘓', '蘚', '魚', '魛',
            '魞', '魡', '魣', '魥', '魦', '魨', '魪', '魫', '魬', '魭', '魮', '魯', '魳', '魴',
            '魵', '魷', '魸', '魹', '魿', '鮀', '鮃', '鮄', '鮅', '鮆', '鮇', '鮉', '鮊', '鮋',
            '鮍', '鮎', '鮏', '鮐', '鮑', '鮒', '鮓', '鮔', '鮖', '鮗', '鮚', '鮝', '鮞', '鮟',
            '鮠', '鮦', '鮧', '鮨', '鮩', '鮪', '鮫', '鮬', '鮭', '鮮', '鮰', '鮱', '鮲', '鮴',
            '鮷', '鮸', '鮹', '鮻', '鮼', '鮾', '鮿', '鯀', '鯁', '鯆', '鯇', '鯈', '鯉', '鯊',
            '鯎', '鯏', '鯐', '鯑', '鯒', '鯔', '鯖', '鯗', '鯘', '鯛', '鯝', '鯟', '鯡', '鯢',
            '鯣', '鯤', '鯥', '鯧', '鯨', '鯪', '鯫', '鯯', '鯰', '鯱', '鯲', '鯳', '鯵', '鯷',
            '鯸', '鯹', '鯺', '鯽', '鯿', '鰀', '鰂', '鰄', '鰆', '鰈', '鰉', '鰊', '鰋', '鰌',
            '鰍', '鰏', '鰐', '鰑', '鰒', '鰓', '鰔', '鰕', '鰖', '鰘', '鰙', '鰚', '鰛', '鰜',
            '鰞', '鰡', '鰢', '鰣', '鰤', '鰥', '鰦', '鰧', '鰨', '鰩', '鰪', '鰭', '鰮', '鰯',
            '鰰', '鰱', '鰲', '鰵', '鰶', '鰷', '鰹', '鰺', '鰻', '鰽', '鰾', '鱁', '鱃', '鱄',
            '鱅', '鱆', '鱇', '鱈', '鱉', '鱊', '鱎', '鱏', '鱐', '鱒', '鱓', '鱔', '鱖', '鱗',
            '鱘', '鱚', '鱛', '鱜', '鱝', '鱞', '鱟', '鱠', '鱣', '鱧', '鱨', '鱩', '鱪', '鱫',
            '鱮', '鱰', '鱲', '鱵', '鱶', '鱷', '鱸', '鱻', '鷠',
        ],
    },
    Membership {
        radical: '鳥',
        strokes: 11,
        kanji: &[
            '嗚', '塢', '嫣', '嬝', '島', '嶋', '嶌', '搗', '梟', '槝', '樢', '歍', '烏', '瑦',
            '窵', '篶', '舃', '蔦', '螐', '裊', '贗', '鄔', '鄥', '隖', '隝', '靎', '靏', '鰞',
            '鳥', '鳦', '鳧', '鳩', '鳫', '鳬', '鳰', '鳲', '鳳', '鳴', '鳶', '鳷', '鳹', '鴂',
            '鴃', '鴆', '鴇', '鴈', '鴉', '鴋', '鴎', '鴑', '鴒', '鴕', '鴗', '鴘', '鴛', '鴜',
            '鴝', '鴞', '鴟', '鴣', '鴦', '鴨', '鴪', '鴫', '鴬', '鴯', '鴰', '鴲', '鴳', '鴴',
            '鴺', '鴻', '鴼', '鴽', '鴾', '鴿', '鵁', '鵂', '鵃', '鵄', '鵅', '鵆', '鵇', '鵈',
            '鵊', '鵐', '鵑', '鵓', '鵔', '鵙', '鵜', '鵝', '鵞', '鵟', '鵠', '鵡', '鵢', '鵣',
            '鵤', '鵥', '鵩', '鵪', '鵫', '鵬', '鵯', '鵰', '鵲', '鵶', '鵷', '鵺', '鵻', '鵼',
            '鵾', '鶃', '鶄', '鶆', '鶇', '鶉', '鶊', '鶍', '鶎', '鶏', '鶒', '鶓', '鶕', '鶖',
            '鶗', '鶘', '鶚', '鶡', '鶤', '鶩', '鶪', '鶫', '鶬', '鶮', '鶯', '鶱', '鶲', '鶴',
            '鶵', '鶸', '鶹', '鶺', '鶻', '鶼', '鶿', '鷁', '鷂', '鷃', '鷄', '鷆', '鷇', '鷉',
            '鷊', '鷏', '鷓', '鷔', '鷕', '鷖', '鷗', '鷙', '鷚', '鷞', '鷟', '鷠', '鷥', '鷦',
            '鷧', '鷩', '鷫', '鷭', '鷮', '鷯', '鷰', '鷲', '鷳', '鷴', '鷸', '鷹', '鷺', '鷽',
            '鷾', '鸂', '鸇', '鸊', '鸎', '鸐', '鸑', '鸒', '鸕', '鸖', '鸙', '鸚', '鸛', '鸜',
            '鸝', '鸞',
        ],
    },
    Membership {
        radical: '鹿',
        strokes: 11,
        kanji: &[
            '儷', '塵', '孋', '彲', '摝', '攈', '攟', '攦', '曬', '樚', '欐', '漉', '灑', '簏',
            '籭', '纚', '臕', '薼', '藨', '躧', '轆', '邐', '鄜', '酈', '釃', '鏖', '鑣', '驪',
            '鸝', '鹿', '麀', '麁', '麂', '麃', '麄', '麅', '麇', '麈', '麋', '麌', '麎', '麏',
            '麑', '麒', '麓', '麕', '麖', '麗', '麘', '麛', '麝', '麞', '麟', '麤',
        ],
    },
    Membership {
        radical: '黒',
        strokes: 11,
        kanji: &[
            '儵', '儻', '嘿', '墨', '壥', '戃', '攩', '濹', '纆', '纒', '讜', '黒', '黔', '黕',
            '默', '黙', '黛', '黜', '黝', '點', '黟', '黠', '黤', '黥', '黧', '黨', '黬', '黭',
            '黮', '黯', '黰', '黱', '黲', '黴', '黵', '黶', '黷', '黸',
        ],
    },
    Membership {
        radical: '黄',
        strokes: 11,
        kanji: &[
            '儣', '兤', '嚝', '壙', '廣', '懬', '懭', '搆', '擴', '曠', '横', '潢', '瀇', '熿',
            '獷', '璜', '癀', '磺', '礦', '簧', '纊', '鄺', '鐄', '鑛', '黄', '黆', '黈', '黋',
            '黌',
        ],
    },
    Membership {
        radical: '麻',
        strokes: 11,
        kanji: &[
            '嘛', '懡', '摩', '擵', '暦', '歴', '磨', '穈', '糜', '縻', '蔴', '藦', '蘑', '蘼',
            '醿', '靡', '魔', '麻', '麼', '麾', '麿',
        ],
    },
    Membership {
        radical: '啇',
        strokes: 11,
        kanji: &[
            '嫡', '摘', '擿', '敵', '樀', '歒', '滴', '蔐', '謫', '讁', '適', '鏑',
        ],
    },
    Membership {
        radical: '亀',
        strokes: 11,
        kanji: &['亀', '穐', '竃', '縄', '蘒', '蝿', '鬮', '龜', '龝'],
    },
    Membership {
        radical: '鹵',
        strokes: 11,
        kanji: &['滷', '磠', '鹵', '鹸', '鹹', '鹺', '鹻', '鹼', '鹽'],
    },
    Membership {
        radical: '歯',
        strokes: 12,
        kanji: &[
            '噛', '囓', '歯', '齒', '齓', '齔', '齕', '齖', '齗', '齘', '齚', '齝', '齞', '齟',
            '齠', '齡', '齢', '齣', '齦', '齧', '齨', '齩', '齪', '齬', '齮', '齯', '齰', '齱',
            '齲', '齳', '齵', '齶', '齷', '齺', '齽',
        ],
    },
    Membership {
        radical: '無',
        strokes: 12,
        kanji: &[
            '儛', '嘸', '墲', '嫵', '廡', '憮', '撫', '橅', '無', '璑', '甒', '膴', '舞', '蕪',
            '蟱',
        ],
    },
    Membership {
        radical: '黍',
        strokes: 12,
        kanji: &['藜', '黍', '黎', '黏', '黐'],
    },
    Membership {
        radical: '黹',
        strokes: 12,
        kanji: &['黹', '黻', '黼'],
    },
    Membership {
        radical: '鼠',
        strokes: 13,
        kanji: &[
            '攛', '獵', '癙', '竄', '臘', '鑞', '鬣', '鼠', '鼢', '鼦', '鼪', '鼫', '鼬', '鼯',
            '鼱', '鼲', '鼴', '鼷', '鼹', '鼺',
        ],
    },
    Membership {
        radical: '黽',
        strokes: 13,
        kanji: &[
            '僶', '澠', '竈', '繩', '蠅', '黽', '黿', '鼂', '鼃', '鼇', '鼈', '鼉',
        ],
    },
    Membership {
        radical: '鼓',
        strokes: 13,
        kanji: &[
            '皷', '瞽', '鼓', '鼔', '鼕', '鼖', '鼗', '鼙', '鼚', '鼛', '鼟',
        ],
    },
    Membership {
        radical: '鼎',
        strokes: 13,
        kanji: &['鼎', '鼏', '鼐', '鼑', '鼒'],
    },
    Membership {
        radical: '齊',
        strokes: 14,
        kanji: &[
            '儕', '劑', '嚌', '擠', '濟', '穧', '纃', '臍', '薺', '蠐', '躋', '隮', '霽', '韲',
            '齊', '齋', '齎', '齏',
        ],
    },
    Membership {
        radical: '鼻',
        strokes: 14,
        kanji: &[
            '劓', '嚊', '嬶', '擤', '濞', '襣', '鼻', '鼼', '鼽', '鼾', '鼿', '齁', '齃', '齄',
            '齅', '齆', '齇',
        ],
    },
    Membership {
        radical: '龠',
        strokes: 17,
        kanji: &[
            '瀹', '爚', '禴', '籥', '籲', '鑰', '鸙', '龠', '龡', '龢', '龣', '龥',
        ],
    },
];
