use super::Decomposition;

/// The list of radical decompositions from the `kradfile`
pub const DECOMPOSITIONS: &[Decomposition] = &[
    Decomposition {
        kanji: '亜',
        radicals: &['｜', '一', '口'],
    },
    Decomposition {
        kanji: '唖',
        radicals: &['｜', '一', '口'],
    },
    Decomposition {
        kanji: '娃',
        radicals: &['女', '土'],
    },
    Decomposition {
        kanji: '阿',
        radicals: &['一', '口', '亅', '⻖'],
    },
    Decomposition {
        kanji: '哀',
        radicals: &['衣', '口', '亠'],
    },
    Decomposition {
        kanji: '愛',
        radicals: &['心', '爪', '冖', '夂'],
    },
    Decomposition {
        kanji: '挨',
        radicals: &['矢', '厶', '扌', '𠂉'],
    },
    Decomposition {
        kanji: '姶',
        radicals: &['一', '口', '女', '𠆢'],
    },
    Decomposition {
        kanji: '逢',
        radicals: &['｜', '⻌', '二', '夂'],
    },
    Decomposition {
        kanji: '葵',
        radicals: &['人', '大', '二', '癶', '⺾', 'ノ'],
    },
    Decomposition {
        kanji: '茜',
        radicals: &['西', '⺾'],
    },
    Decomposition {
        kanji: '穐',
        radicals: &['禾', '亀', '乙', '勹', '田'],
    },
    Decomposition {
        kanji: '悪',
        radicals: &['｜', '一', '口', '心'],
    },
    Decomposition {
        kanji: '握',
        radicals: &['至', '土', '厶', '尸', '扌'],
    },
    Decomposition {
        kanji: '渥',
        radicals: &['至', '⺡', '土', '厶', '尸'],
    },
    Decomposition {
        kanji: '旭',
        radicals: &['日', '九'],
    },
    Decomposition {
        kanji: '葦',
        radicals: &['口', '⺾', '韋'],
    },
    Decomposition {
        kanji: '芦',
        radicals: &['戸', '⺾', '一', '尸'],
    },
    Decomposition {
        kanji: '鯵',
        radicals: &['魚', '大', '田', '厶', '彡', '⺣'],
    },
    Decomposition {
        kanji: '梓',
        radicals: &['十', '辛', '木', '立'],
    },
    Decomposition {
        kanji: '圧',
        radicals: &['土', '厂'],
    },
    Decomposition {
        kanji: '斡',
        radicals: &['十', '斗', '日', '𠆢'],
    },
    Decomposition {
        kanji: '扱',
        radicals: &['扌', '及'],
    },
    Decomposition {
        kanji: '宛',
        radicals: &['夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '姐',
        radicals: &['女', '目'],
    },
    Decomposition {
        kanji: '虻',
        radicals: &['虫', '亡', '亠'],
    },
    Decomposition {
        kanji: '飴',
        radicals: &['口', '食', '厶'],
    },
    Decomposition {
        kanji: '絢',
        radicals: &['糸', '幺', '小', '日', '勹'],
    },
    Decomposition {
        kanji: '綾',
        radicals: &['糸', '幺', '小', '土', '儿', '夂'],
    },
    Decomposition {
        kanji: '鮎',
        radicals: &['魚', '口', '田', '卜', '⺣'],
    },
    Decomposition {
        kanji: '或',
        radicals: &['口', '戈', '一'],
    },
    Decomposition {
        kanji: '粟',
        radicals: &['西', '米'],
    },
    Decomposition {
        kanji: '袷',
        radicals: &['口', '⻂', '𠆢', '一'],
    },
    Decomposition {
        kanji: '安',
        radicals: &['女', '宀'],
    },
    Decomposition {
        kanji: '庵',
        radicals: &['田', '广', '大'],
    },
    Decomposition {
        kanji: '按',
        radicals: &['女', '宀', '扌'],
    },
    Decomposition {
        kanji: '暗',
        radicals: &['音', '日', '立'],
    },
    Decomposition {
        kanji: '案',
        radicals: &['女', '木', '宀'],
    },
    Decomposition {
        kanji: '闇',
        radicals: &['音', '日', '門', '立'],
    },
    Decomposition {
        kanji: '鞍',
        radicals: &['女', '宀', '革'],
    },
    Decomposition {
        kanji: '杏',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '以',
        radicals: &['｜', '人', '丶'],
    },
    Decomposition {
        kanji: '伊',
        radicals: &['｜', 'ヨ', '⺅'],
    },
    Decomposition {
        kanji: '位',
        radicals: &['⺅', '立'],
    },
    Decomposition {
        kanji: '依',
        radicals: &['衣', '⺅', '亠'],
    },
    Decomposition {
        kanji: '偉',
        radicals: &['⺅', '口', '韋'],
    },
    Decomposition {
        kanji: '囲',
        radicals: &['囗', '井'],
    },
    Decomposition {
        kanji: '夷',
        radicals: &['ノ', '一', '弓', '大'],
    },
    Decomposition {
        kanji: '委',
        radicals: &['禾', '女'],
    },
    Decomposition {
        kanji: '威',
        radicals: &['ノ', '女', '戈', '厂'],
    },
    Decomposition {
        kanji: '尉',
        radicals: &['示', '二', '小', '寸', '尸'],
    },
    Decomposition {
        kanji: '惟',
        radicals: &['⺖', '隹'],
    },
    Decomposition {
        kanji: '意',
        radicals: &['音', '心', '日', '立'],
    },
    Decomposition {
        kanji: '慰',
        radicals: &['示', '二', '小', '心', '寸', '尸'],
    },
    Decomposition {
        kanji: '易',
        radicals: &['日', '勿', '勹', 'ノ'],
    },
    Decomposition {
        kanji: '椅',
        radicals: &['口', '大', '木', '一', '亅'],
    },
    Decomposition {
        kanji: '為',
        radicals: &['ノ', '⺣', 'ユ', '丶', '丷', '勹'],
    },
    Decomposition {
        kanji: '畏',
        radicals: &['衣', '一', '田'],
    },
    Decomposition {
        kanji: '異',
        radicals: &['一', '田', 'ハ', '井'],
    },
    Decomposition {
        kanji: '移',
        radicals: &['禾', '夕'],
    },
    Decomposition {
        kanji: '維',
        radicals: &['糸', '幺', '小', '隹'],
    },
    Decomposition {
        kanji: '緯',
        radicals: &['口', '糸', '幺', '小', '韋'],
    },
    Decomposition {
        kanji: '胃',
        radicals: &['月', '田'],
    },
    Decomposition {
        kanji: '萎',
        radicals: &['禾', '女', '⺾'],
    },
    Decomposition {
        kanji: '衣',
        radicals: &['衣', '亠'],
    },
    Decomposition {
        kanji: '謂',
        radicals: &['月', '言', '田'],
    },
    Decomposition {
        kanji: '違',
        radicals: &['口', '⻌', '韋'],
    },
    Decomposition {
        kanji: '遺',
        radicals: &['一', '貝', '目', 'ハ', '⻌', '口', '｜'],
    },
    Decomposition {
        kanji: '医',
        radicals: &['矢', '匚', '𠂉'],
    },
    Decomposition {
        kanji: '井',
        radicals: &['｜', 'ノ', '一', '二', '井'],
    },
    Decomposition {
        kanji: '亥',
        radicals: &['人', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '域',
        radicals: &['口', '土', '戈'],
    },
    Decomposition {
        kanji: '育',
        radicals: &['月', '亠', '厶'],
    },
    Decomposition {
        kanji: '郁',
        radicals: &['ノ', '一', '月', '⻏'],
    },
    Decomposition {
        kanji: '磯',
        radicals: &['ノ', '口', '石', '戈', '幺', '丶'],
    },
    Decomposition {
        kanji: '一',
        radicals: &['一'],
    },
    Decomposition {
        kanji: '壱',
        radicals: &['士', '冖', '匕'],
    },
    Decomposition {
        kanji: '溢',
        radicals: &['皿', '⺡', '⺌', 'ハ', '丷'],
    },
    Decomposition {
        kanji: '逸',
        radicals: &['ノ', '⻌', '免', '儿', '勹'],
    },
    Decomposition {
        kanji: '稲',
        radicals: &['｜', '禾', '爪', '日'],
    },
    Decomposition {
        kanji: '茨',
        radicals: &['欠', '冫', '⺾'],
    },
    Decomposition {
        kanji: '芋',
        radicals: &['一', '⺾', '干'],
    },
    Decomposition {
        kanji: '鰯',
        radicals: &['弓', '魚', '田', '冫', '⺣'],
    },
    Decomposition {
        kanji: '允',
        radicals: &['厶', '儿'],
    },
    Decomposition {
        kanji: '印',
        radicals: &['｜', '卩'],
    },
    Decomposition {
        kanji: '咽',
        radicals: &['口', '大', '囗'],
    },
    Decomposition {
        kanji: '員',
        radicals: &['貝', '目', 'ハ', '口'],
    },
    Decomposition {
        kanji: '因',
        radicals: &['大', '囗'],
    },
    Decomposition {
        kanji: '姻',
        radicals: &['女', '大', '囗'],
    },
    Decomposition {
        kanji: '引',
        radicals: &['｜', '弓'],
    },
    Decomposition {
        kanji: '飲',
        radicals: &['欠', '食'],
    },
    Decomposition {
        kanji: '淫',
        radicals: &['ノ', '士', '⺡', '爪', '王'],
    },
    Decomposition {
        kanji: '胤',
        radicals: &['月', '儿', '幺'],
    },
    Decomposition {
        kanji: '蔭',
        radicals: &['二', '𠆢', '厶', '⺾', '⻖', '一'],
    },
    Decomposition {
        kanji: '院',
        radicals: &['二', '儿', '宀', '⻖', '元'],
    },
    Decomposition {
        kanji: '陰',
        radicals: &['二', '𠆢', '厶', '⻖', '一'],
    },
    Decomposition {
        kanji: '隠',
        radicals: &['ノ', 'ヨ', '⺌', '心', '⻖'],
    },
    Decomposition {
        kanji: '韻',
        radicals: &['音', '貝', '目', 'ハ', '口', '日', '立'],
    },
    Decomposition {
        kanji: '吋',
        radicals: &['口', '寸'],
    },
    Decomposition {
        kanji: '右',
        radicals: &['ノ', '一', '口'],
    },
    Decomposition {
        kanji: '宇',
        radicals: &['干', '亅', '宀'],
    },
    Decomposition {
        kanji: '烏',
        radicals: &['鳥', '⺣'],
    },
    Decomposition {
        kanji: '羽',
        radicals: &['羽', '冫'],
    },
    Decomposition {
        kanji: '迂',
        radicals: &['干', '⻌', '二', '亅'],
    },
    Decomposition {
        kanji: '雨',
        radicals: &['雨'],
    },
    Decomposition {
        kanji: '卯',
        radicals: &['卩'],
    },
    Decomposition {
        kanji: '鵜',
        radicals: &['｜', 'ノ', '弓', '鳥', '丷', '⺣'],
    },
    Decomposition {
        kanji: '窺',
        radicals: &['見', 'ハ', '宀', '一', '大', '穴', '二', '儿'],
    },
    Decomposition {
        kanji: '丑',
        radicals: &['｜', 'ノ', '一'],
    },
    Decomposition {
        kanji: '碓',
        radicals: &['口', '石', '隹'],
    },
    Decomposition {
        kanji: '臼',
        radicals: &['臼'],
    },
    Decomposition {
        kanji: '渦',
        radicals: &['｜', '口', '⺡', '冂'],
    },
    Decomposition {
        kanji: '嘘',
        radicals: &['口', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '唄',
        radicals: &['貝', '目', 'ハ', '口'],
    },
    Decomposition {
        kanji: '欝',
        radicals: &['艮', '寸', '⺲', '木'],
    },
    Decomposition {
        kanji: '蔚',
        radicals: &['示', '二', '小', '寸', '尸', '⺾'],
    },
    Decomposition {
        kanji: '鰻',
        radicals: &['魚', '田', '日', '⺲', '又', '⺣'],
    },
    Decomposition {
        kanji: '姥',
        radicals: &['女', '⺹', '匕'],
    },
    Decomposition {
        kanji: '厩',
        radicals: &['牙', '艮', '儿', '厂'],
    },
    Decomposition {
        kanji: '浦',
        radicals: &['十', '⺡', '用', '丶'],
    },
    Decomposition {
        kanji: '瓜',
        radicals: &['瓜', '厶'],
    },
    Decomposition {
        kanji: '閏',
        radicals: &['王', '門'],
    },
    Decomposition {
        kanji: '噂',
        radicals: &['口', '寸', '西', '丷'],
    },
    Decomposition {
        kanji: '云',
        radicals: &['一', '二', '厶'],
    },
    Decomposition {
        kanji: '運',
        radicals: &['⻌', '車', '冖'],
    },
    Decomposition {
        kanji: '雲',
        radicals: &['一', '雨', '二', '厶'],
    },
    Decomposition {
        kanji: '荏',
        radicals: &['⺅', '士', '⺾'],
    },
    Decomposition {
        kanji: '餌',
        radicals: &['艮', '耳', '食'],
    },
    Decomposition {
        kanji: '叡',
        radicals: &['ハ', '卜', '又', '目', '冖'],
    },
    Decomposition {
        kanji: '営',
        radicals: &['口', '⺌', '冖', 'ノ'],
    },
    Decomposition {
        kanji: '嬰',
        radicals: &['貝', '目', 'ハ', '女'],
    },
    Decomposition {
        kanji: '影',
        radicals: &['口', '小', '日', '亠', '彡'],
    },
    Decomposition {
        kanji: '映',
        radicals: &['ノ', '日', '大', '冖'],
    },
    Decomposition {
        kanji: '曳',
        radicals: &['乙', '日'],
    },
    Decomposition {
        kanji: '栄',
        radicals: &['⺌', '木', '冖'],
    },
    Decomposition {
        kanji: '永',
        radicals: &['水', '丶'],
    },
    Decomposition {
        kanji: '泳',
        radicals: &['⺡', '水', '丶'],
    },
    Decomposition {
        kanji: '洩',
        radicals: &['ノ', '乙', '⺡', '日'],
    },
    Decomposition {
        kanji: '瑛',
        radicals: &['ノ', '王', '⺾', '大', '冖'],
    },
    Decomposition {
        kanji: '盈',
        radicals: &['ノ', '一', '皿', '又'],
    },
    Decomposition {
        kanji: '穎',
        radicals: &['禾', '貝', '目', 'ハ', '頁', '匕'],
    },
    Decomposition {
        kanji: '頴',
        radicals: &['貝', '目', 'ハ', '示', '二', '小', '頁', '匕'],
    },
    Decomposition {
        kanji: '英',
        radicals: &['ノ', '⺾', '大', '冖'],
    },
    Decomposition {
        kanji: '衛',
        radicals: &['口', '行', '彳', '韋'],
    },
    Decomposition {
        kanji: '詠',
        radicals: &['言', '水', '丶'],
    },
    Decomposition {
        kanji: '鋭',
        radicals: &['金', '口', '丷', '𠆢', '儿'],
    },
    Decomposition {
        kanji: '液',
        radicals: &['⺅', '⺡', '亠', '攵', '夕', '𠂉'],
    },
    Decomposition {
        kanji: '疫',
        radicals: &['殳', '⽧', '几', '又'],
    },
    Decomposition {
        kanji: '益',
        radicals: &['一', '皿', 'ハ', '丷'],
    },
    Decomposition {
        kanji: '駅',
        radicals: &['馬', '尸', '⺣', '丶'],
    },
    Decomposition {
        kanji: '悦',
        radicals: &['口', '丷', '⺖', '儿'],
    },
    Decomposition {
        kanji: '謁',
        radicals: &['言', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '越',
        radicals: &['走', '土', '戈'],
    },
    Decomposition {
        kanji: '閲',
        radicals: &['口', '丷', '門', '儿'],
    },
    Decomposition {
        kanji: '榎',
        radicals: &['一', '自', '木', '目', '夂'],
    },
    Decomposition {
        kanji: '厭',
        radicals: &['月', '犬', '日', '厂'],
    },
    Decomposition {
        kanji: '円',
        radicals: &['冂', '亠', '一', '｜'],
    },
    Decomposition {
        kanji: '園',
        radicals: &['衣', '口', '土', '囗'],
    },
    Decomposition {
        kanji: '堰',
        radicals: &['女', '土', '日', '匚'],
    },
    Decomposition {
        kanji: '奄',
        radicals: &['乙', '大', '日', '奄'],
    },
    Decomposition {
        kanji: '宴',
        radicals: &['女', '日', '宀'],
    },
    Decomposition {
        kanji: '延',
        radicals: &['一', '止', '廴'],
    },
    Decomposition {
        kanji: '怨',
        radicals: &['心', '夕', '卩'],
    },
    Decomposition {
        kanji: '掩',
        radicals: &['乙', '大', '日', '扌', '奄'],
    },
    Decomposition {
        kanji: '援',
        radicals: &['ノ', '一', '爪', '又', '扌'],
    },
    Decomposition {
        kanji: '沿',
        radicals: &['口', '⺡', 'ハ'],
    },
    Decomposition {
        kanji: '演',
        radicals: &['⺡', '田', 'ハ', '宀', '一'],
    },
    Decomposition {
        kanji: '炎',
        radicals: &['火'],
    },
    Decomposition {
        kanji: '焔',
        radicals: &['｜', '火', '日', '勹'],
    },
    Decomposition {
        kanji: '煙',
        radicals: &['火', '西', '土'],
    },
    Decomposition {
        kanji: '燕',
        radicals: &['口', '匕', '⺣', '爿', '⺾'],
    },
    Decomposition {
        kanji: '猿',
        radicals: &['衣', '口', '土', '⺨'],
    },
    Decomposition {
        kanji: '縁',
        radicals: &['ヨ', '糸', '幺', '小', '豕'],
    },
    Decomposition {
        kanji: '艶',
        radicals: &['｜', '口', '色', '豆', '日', '丷', '勹'],
    },
    Decomposition {
        kanji: '苑',
        radicals: &['夕', '卩', '⺾'],
    },
    Decomposition {
        kanji: '薗',
        radicals: &['衣', '口', '土', '囗', '⺾'],
    },
    Decomposition {
        kanji: '遠',
        radicals: &['衣', '口', '⻌', '土'],
    },
    Decomposition {
        kanji: '鉛',
        radicals: &['金', '口', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '鴛',
        radicals: &['鳥', '夕', '卩', '⺣'],
    },
    Decomposition {
        kanji: '塩',
        radicals: &['口', '皿', '土', 'ノ', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '於',
        radicals: &['方', '𠆢'],
    },
    Decomposition {
        kanji: '汚',
        radicals: &['一', '⺡', '勹', '二'],
    },
    Decomposition {
        kanji: '甥',
        radicals: &['生', '田', '力'],
    },
    Decomposition {
        kanji: '凹',
        radicals: &['凵'],
    },
    Decomposition {
        kanji: '央',
        radicals: &['ノ', '一', '大', '冖'],
    },
    Decomposition {
        kanji: '奥',
        radicals: &['大', '米', '冂'],
    },
    Decomposition {
        kanji: '往',
        radicals: &['王', '丶', '彳'],
    },
    Decomposition {
        kanji: '応',
        radicals: &['心', '广'],
    },
    Decomposition {
        kanji: '押',
        radicals: &['｜', '日', '扌', '田'],
    },
    Decomposition {
        kanji: '旺',
        radicals: &['王', '日'],
    },
    Decomposition {
        kanji: '横',
        radicals: &['｜', '黄', '田', '二', '日', 'ハ', '木', '廾'],
    },
    Decomposition {
        kanji: '欧',
        radicals: &['欠', '匚', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '殴',
        radicals: &['ノ', '丶', '匚', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '王',
        radicals: &['王'],
    },
    Decomposition {
        kanji: '翁',
        radicals: &['羽', 'ハ', '冫', '厶'],
    },
    Decomposition {
        kanji: '襖',
        radicals: &['⻂', '大', '米', '冂', '釆'],
    },
    Decomposition {
        kanji: '鴬',
        radicals: &['⺌', '鳥', '冖', '⺣'],
    },
    Decomposition {
        kanji: '鴎',
        radicals: &['鳥', '匚', '⺣', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '黄',
        radicals: &['黄', '田', 'ハ'],
    },
    Decomposition {
        kanji: '岡',
        radicals: &['丷', '冂', '一', '山', '岡'],
    },
    Decomposition {
        kanji: '沖',
        radicals: &['｜', '⺡', '口'],
    },
    Decomposition {
        kanji: '荻',
        radicals: &['火', '⺨', '⺾'],
    },
    Decomposition {
        kanji: '億',
        radicals: &['音', '⺅', '心', '日', '立'],
    },
    Decomposition {
        kanji: '屋',
        radicals: &['至', '土', '厶', '尸'],
    },
    Decomposition {
        kanji: '憶',
        radicals: &['音', '心', '日', '⺖', '立'],
    },
    Decomposition {
        kanji: '臆',
        radicals: &['音', '月', '心', '日', '立'],
    },
    Decomposition {
        kanji: '桶',
        radicals: &['木', '用', 'マ'],
    },
    Decomposition {
        kanji: '牡',
        radicals: &['牛', '土'],
    },
    Decomposition {
        kanji: '乙',
        radicals: &['乙'],
    },
    Decomposition {
        kanji: '俺',
        radicals: &['乙', '⺅', '大', '奄'],
    },
    Decomposition {
        kanji: '卸',
        radicals: &['ノ', '止', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '恩',
        radicals: &['心', '大', '囗'],
    },
    Decomposition {
        kanji: '温',
        radicals: &['皿', '⺡', '日'],
    },
    Decomposition {
        kanji: '穏',
        radicals: &['ヨ', '禾', '心', '爪'],
    },
    Decomposition {
        kanji: '音',
        radicals: &['音', '日', '立'],
    },
    Decomposition {
        kanji: '下',
        radicals: &['｜', '一', '卜'],
    },
    Decomposition {
        kanji: '化',
        radicals: &['⺅', '匕'],
    },
    Decomposition {
        kanji: '仮',
        radicals: &['⺅', '又', '厂'],
    },
    Decomposition {
        kanji: '何',
        radicals: &['⺅', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '伽',
        radicals: &['⺅', '口', '力'],
    },
    Decomposition {
        kanji: '価',
        radicals: &['⺅', '西'],
    },
    Decomposition {
        kanji: '佳',
        radicals: &['⺅', '土'],
    },
    Decomposition {
        kanji: '加',
        radicals: &['口', '力'],
    },
    Decomposition {
        kanji: '可',
        radicals: &['一', '口', '亅'],
    },
    Decomposition {
        kanji: '嘉',
        radicals: &['口', '士', '力'],
    },
    Decomposition {
        kanji: '夏',
        radicals: &['一', '自', '夂', '目'],
    },
    Decomposition {
        kanji: '嫁',
        radicals: &['女', '宀', '豕'],
    },
    Decomposition {
        kanji: '家',
        radicals: &['宀', '豕'],
    },
    Decomposition {
        kanji: '寡',
        radicals: &['一', '自', '刀', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '科',
        radicals: &['禾', '斗'],
    },
    Decomposition {
        kanji: '暇',
        radicals: &['日', '又'],
    },
    Decomposition {
        kanji: '果',
        radicals: &['｜', '田', '木'],
    },
    Decomposition {
        kanji: '架',
        radicals: &['口', '木', '力'],
    },
    Decomposition {
        kanji: '歌',
        radicals: &['一', '欠', '口', '亅'],
    },
    Decomposition {
        kanji: '河',
        radicals: &['口', '⺡', '亅', '一'],
    },
    Decomposition {
        kanji: '火',
        radicals: &['火'],
    },
    Decomposition {
        kanji: '珂',
        radicals: &['王', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '禍',
        radicals: &['口', '⺭', '冂'],
    },
    Decomposition {
        kanji: '禾',
        radicals: &['禾', '木', 'ノ'],
    },
    Decomposition {
        kanji: '稼',
        radicals: &['禾', '宀', '豕'],
    },
    Decomposition {
        kanji: '箇',
        radicals: &['口', '十', '竹', '囗', '𠂉'],
    },
    Decomposition {
        kanji: '花',
        radicals: &['⺅', '匕', '⺾'],
    },
    Decomposition {
        kanji: '苛',
        radicals: &['一', '口', '亅', '⺾'],
    },
    Decomposition {
        kanji: '茄',
        radicals: &['口', '力', '⺾'],
    },
    Decomposition {
        kanji: '荷',
        radicals: &['⺅', '口', '亅', '⺾', '一'],
    },
    Decomposition {
        kanji: '華',
        radicals: &['｜', '一', '⺾'],
    },
    Decomposition {
        kanji: '菓',
        radicals: &['田', '木', '⺾'],
    },
    Decomposition {
        kanji: '蝦',
        radicals: &['虫', '又', '口'],
    },
    Decomposition {
        kanji: '課',
        radicals: &['言', '田', '木'],
    },
    Decomposition {
        kanji: '嘩',
        radicals: &['一', '口', '⺾', '｜'],
    },
    Decomposition {
        kanji: '貨',
        radicals: &['⺅', '貝', '目', 'ハ', '匕'],
    },
    Decomposition {
        kanji: '迦',
        radicals: &['口', '⻌', '力'],
    },
    Decomposition {
        kanji: '過',
        radicals: &['口', '⻌', '冂'],
    },
    Decomposition {
        kanji: '霞',
        radicals: &['雨', '又'],
    },
    Decomposition {
        kanji: '蚊',
        radicals: &['虫', '文'],
    },
    Decomposition {
        kanji: '俄',
        radicals: &['⺅', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '峨',
        radicals: &['山', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '我',
        radicals: &['亅', '戈', '手'],
    },
    Decomposition {
        kanji: '牙',
        radicals: &['牙'],
    },
    Decomposition {
        kanji: '画',
        radicals: &['一', '田', '凵'],
    },
    Decomposition {
        kanji: '臥',
        radicals: &['臣', '人'],
    },
    Decomposition {
        kanji: '芽',
        radicals: &['牙', '⺾'],
    },
    Decomposition {
        kanji: '蛾',
        radicals: &['虫', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '賀',
        radicals: &['貝', '目', 'ハ', '口', '力'],
    },
    Decomposition {
        kanji: '雅',
        radicals: &['牙', '隹'],
    },
    Decomposition {
        kanji: '餓',
        radicals: &['食', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '駕',
        radicals: &['口', '馬', '力', '⺣'],
    },
    Decomposition {
        kanji: '介',
        radicals: &['ハ', '𠆢'],
    },
    Decomposition {
        kanji: '会',
        radicals: &['二', '𠆢', '厶'],
    },
    Decomposition {
        kanji: '解',
        radicals: &['角', '牛', '刀'],
    },
    Decomposition {
        kanji: '回',
        radicals: &['口', '囗'],
    },
    Decomposition {
        kanji: '塊',
        radicals: &['鬼', '田', '土', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '壊',
        radicals: &['衣', '十', '土', '⺲', '亠'],
    },
    Decomposition {
        kanji: '廻',
        radicals: &['口', '囗', '廴'],
    },
    Decomposition {
        kanji: '快',
        radicals: &['人', '大', '二', '⺖', 'ユ'],
    },
    Decomposition {
        kanji: '怪',
        radicals: &['土', '⺖', '又'],
    },
    Decomposition {
        kanji: '悔',
        radicals: &['母', '⺖', '毋', 'ノ', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '恢',
        radicals: &['火', '厂', '⺖'],
    },
    Decomposition {
        kanji: '懐',
        radicals: &['衣', '十', '⺲', '⺖', '亠'],
    },
    Decomposition {
        kanji: '戒',
        radicals: &['廾', '戈'],
    },
    Decomposition {
        kanji: '拐',
        radicals: &['口', '刀', '扌'],
    },
    Decomposition {
        kanji: '改',
        radicals: &['已', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '魁',
        radicals: &['鬼', '田', '斗', '儿', '厶', '匕'],
    },
    Decomposition {
        kanji: '晦',
        radicals: &['日', '母', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '械',
        radicals: &['木', '廾', '戈'],
    },
    Decomposition {
        kanji: '海',
        radicals: &['⺡', '母', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '灰',
        radicals: &['火', '厂'],
    },
    Decomposition {
        kanji: '界',
        radicals: &['田', '𠆢', '儿'],
    },
    Decomposition {
        kanji: '皆',
        radicals: &['白', '比'],
    },
    Decomposition {
        kanji: '絵',
        radicals: &['糸', '幺', '小', '二', '𠆢', '厶'],
    },
    Decomposition {
        kanji: '芥',
        radicals: &['𠆢', '⺾', '儿'],
    },
    Decomposition {
        kanji: '蟹',
        radicals: &['角', '牛', '虫', '刀'],
    },
    Decomposition {
        kanji: '開',
        radicals: &['一', '門', '廾', '二', 'ノ'],
    },
    Decomposition {
        kanji: '階',
        radicals: &['白', '比', '⻖'],
    },
    Decomposition {
        kanji: '貝',
        radicals: &['貝', '目', 'ハ'],
    },
    Decomposition {
        kanji: '凱',
        radicals: &['口', '山', '豆', '丷', '几'],
    },
    Decomposition {
        kanji: '劾',
        radicals: &['人', '力', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '外',
        radicals: &['卜', '夕'],
    },
    Decomposition {
        kanji: '咳',
        radicals: &['口', '人', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '害',
        radicals: &['口', '土', '亠', '宀', '二'],
    },
    Decomposition {
        kanji: '崖',
        radicals: &['山', '土', '厂'],
    },
    Decomposition {
        kanji: '慨',
        radicals: &['牙', '艮', '⺖'],
    },
    Decomposition {
        kanji: '概',
        radicals: &['牙', '艮', '木'],
    },
    Decomposition {
        kanji: '涯',
        radicals: &['⺡', '土', '厂'],
    },
    Decomposition {
        kanji: '碍',
        radicals: &['口', '寸', '石', '日', '一'],
    },
    Decomposition {
        kanji: '蓋',
        radicals: &['皿', '土', '厶', '⺾'],
    },
    Decomposition {
        kanji: '街',
        radicals: &['行', '土', '彳'],
    },
    Decomposition {
        kanji: '該',
        radicals: &['言', '人', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '鎧',
        radicals: &['金', '口', '山', '豆', '丷'],
    },
    Decomposition {
        kanji: '骸',
        radicals: &['月', '骨', '人', '亠', '冂', '冖', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '浬',
        radicals: &['⺡', '里', '田', '土'],
    },
    Decomposition {
        kanji: '馨',
        radicals: &['禾', '香', '士', '日', '又', '几', '殳', '尸'],
    },
    Decomposition {
        kanji: '蛙',
        radicals: &['虫', '土'],
    },
    Decomposition {
        kanji: '垣',
        radicals: &['一', '土', '日'],
    },
    Decomposition {
        kanji: '柿',
        radicals: &['｜', '巾', '木', '亠', '冂'],
    },
    Decomposition {
        kanji: '蛎',
        radicals: &['斤', '虫', '厂'],
    },
    Decomposition {
        kanji: '鈎',
        radicals: &['金', '勹', '厶'],
    },
    Decomposition {
        kanji: '劃',
        radicals: &['一', '⺉', '田', '聿'],
    },
    Decomposition {
        kanji: '嚇',
        radicals: &['口', '赤', '土'],
    },
    Decomposition {
        kanji: '各',
        radicals: &['口', '夂', '攵'],
    },
    Decomposition {
        kanji: '廓',
        radicals: &['口', '子', '⻏', '亅', '亠', '广'],
    },
    Decomposition {
        kanji: '拡',
        radicals: &['厶', '广', '扌'],
    },
    Decomposition {
        kanji: '撹',
        radicals: &['見', '⺌', '冖', '扌'],
    },
    Decomposition {
        kanji: '格',
        radicals: &['口', '木', '夂'],
    },
    Decomposition {
        kanji: '核',
        radicals: &['人', '木', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '殻',
        radicals: &['士', '冖', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '獲',
        radicals: &['⺨', '又', '⺾', '隹'],
    },
    Decomposition {
        kanji: '確',
        radicals: &['口', '石', '宀', '隹'],
    },
    Decomposition {
        kanji: '穫',
        radicals: &['禾', '又', '⺾', '隹'],
    },
    Decomposition {
        kanji: '覚',
        radicals: &['見', '⺌', '冖'],
    },
    Decomposition {
        kanji: '角',
        radicals: &['角', '勹', '月', '｜'],
    },
    Decomposition {
        kanji: '赫',
        radicals: &['赤', '土'],
    },
    Decomposition {
        kanji: '較',
        radicals: &['車', '父', '亠'],
    },
    Decomposition {
        kanji: '郭',
        radicals: &['口', '⻏', '亅', '亠', '子'],
    },
    Decomposition {
        kanji: '閣',
        radicals: &['口', '門', '夂'],
    },
    Decomposition {
        kanji: '隔',
        radicals: &['一', '口', '儿', '冂', '⻖', '鬲'],
    },
    Decomposition {
        kanji: '革',
        radicals: &['革', '廾', '口', '十'],
    },
    Decomposition {
        kanji: '学',
        radicals: &['子', '⺌', '冖'],
    },
    Decomposition {
        kanji: '岳',
        radicals: &['山', '斤', '一'],
    },
    Decomposition {
        kanji: '楽',
        radicals: &['白', '木', '冫'],
    },
    Decomposition {
        kanji: '額',
        radicals: &['貝', '目', 'ハ', '口', '頁', '夂', '宀'],
    },
    Decomposition {
        kanji: '顎',
        radicals: &['貝', '目', 'ハ', '口', '頁', '二', '勹'],
    },
    Decomposition {
        kanji: '掛',
        radicals: &['土', '卜', '扌'],
    },
    Decomposition {
        kanji: '笠',
        radicals: &['竹', '立', '𠂉'],
    },
    Decomposition {
        kanji: '樫',
        radicals: &['臣', '土', '又', '木'],
    },
    Decomposition {
        kanji: '橿',
        radicals: &['一', '田', '木'],
    },
    Decomposition {
        kanji: '梶',
        radicals: &['毛', '木', '尸'],
    },
    Decomposition {
        kanji: '鰍',
        radicals: &['火', '禾', '魚', '田', '⺣'],
    },
    Decomposition {
        kanji: '潟',
        radicals: &['臼', '⺡', '勹', '⺣'],
    },
    Decomposition {
        kanji: '割',
        radicals: &['⺉', '口', '土', '宀', '亠', '二'],
    },
    Decomposition {
        kanji: '喝',
        radicals: &['口', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '恰',
        radicals: &['口', '⺖', '𠆢', '一'],
    },
    Decomposition {
        kanji: '括',
        radicals: &['ノ', '口', '十', '舌', '扌'],
    },
    Decomposition {
        kanji: '活',
        radicals: &['ノ', '口', '十', '⺡', '舌'],
    },
    Decomposition {
        kanji: '渇',
        radicals: &['⺡', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '滑',
        radicals: &['月', '骨', '⺡', '冂', '冖'],
    },
    Decomposition {
        kanji: '葛',
        radicals: &['日', '勹', '匕', '⺾'],
    },
    Decomposition {
        kanji: '褐',
        radicals: &['⻂', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '轄',
        radicals: &['口', '車', '土', '亠', '宀', '二'],
    },
    Decomposition {
        kanji: '且',
        radicals: &['一', '目'],
    },
    Decomposition {
        kanji: '鰹',
        radicals: &['魚', '臣', '田', '土', '又', '⺣'],
    },
    Decomposition {
        kanji: '叶',
        radicals: &['口', '十'],
    },
    Decomposition {
        kanji: '椛',
        radicals: &['⺅', '木', '匕', '⺾'],
    },
    Decomposition {
        kanji: '樺',
        radicals: &['｜', '一', '木', '⺾'],
    },
    Decomposition {
        kanji: '鞄',
        radicals: &['革', '勹', '已'],
    },
    Decomposition {
        kanji: '株',
        radicals: &['牛', '木'],
    },
    Decomposition {
        kanji: '兜',
        radicals: &['白', '儿'],
    },
    Decomposition {
        kanji: '竃',
        radicals: &['亀', '穴', '土', '宀', '儿', '乙', '勹', '田'],
    },
    Decomposition {
        kanji: '蒲',
        radicals: &['⺡', '用', '丶', '⺾', '十'],
    },
    Decomposition {
        kanji: '釜',
        radicals: &['一', '干', '丷', '父', '王', '丶', 'ノ', '金'],
    },
    Decomposition {
        kanji: '鎌',
        radicals: &['金', '王', '丶', 'ノ', 'ヨ', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '噛',
        radicals: &['口', '止', '歯', '米'],
    },
    Decomposition {
        kanji: '鴨',
        radicals: &['｜', '鳥', '日', '⺣', '田'],
    },
    Decomposition {
        kanji: '栢',
        radicals: &['一', '白', '木'],
    },
    Decomposition {
        kanji: '茅',
        radicals: &['矛', '⺾'],
    },
    Decomposition {
        kanji: '萱',
        radicals: &['一', '日', '宀', '⺾'],
    },
    Decomposition {
        kanji: '粥',
        radicals: &['弓', '米'],
    },
    Decomposition {
        kanji: '刈',
        radicals: &['⺉'],
    },
    Decomposition {
        kanji: '苅',
        radicals: &['⺉', '⺾'],
    },
    Decomposition {
        kanji: '瓦',
        radicals: &['瓦', '一'],
    },
    Decomposition {
        kanji: '乾',
        radicals: &['乙', '十', '日', 'ノ', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '侃',
        radicals: &['⺅', '口', '川'],
    },
    Decomposition {
        kanji: '冠',
        radicals: &['寸', '儿', '冖', '元'],
    },
    Decomposition {
        kanji: '寒',
        radicals: &['一', 'ハ', '宀', '丶', '井'],
    },
    Decomposition {
        kanji: '刊',
        radicals: &['⺉', '干'],
    },
    Decomposition {
        kanji: '勘',
        radicals: &['力', '匚', '甘', '儿'],
    },
    Decomposition {
        kanji: '勧',
        radicals: &['ノ', '力', '隹', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '巻',
        radicals: &['大', '二', '丷', '已'],
    },
    Decomposition {
        kanji: '喚',
        radicals: &['口', '大', '儿', '冂', '勹'],
    },
    Decomposition {
        kanji: '堪',
        radicals: &['土', '儿', '匚', '甘'],
    },
    Decomposition {
        kanji: '姦',
        radicals: &['女'],
    },
    Decomposition {
        kanji: '完',
        radicals: &['二', '儿', '宀', '元'],
    },
    Decomposition {
        kanji: '官',
        radicals: &['口', '宀', '｜'],
    },
    Decomposition {
        kanji: '寛',
        radicals: &['見', '宀', '⺾'],
    },
    Decomposition {
        kanji: '干',
        radicals: &['干', '十', '一'],
    },
    Decomposition {
        kanji: '幹',
        radicals: &['干', '十', '日', '𠆢'],
    },
    Decomposition {
        kanji: '患',
        radicals: &['｜', '口', '心'],
    },
    Decomposition {
        kanji: '感',
        radicals: &['ノ', '口', '心', '戈'],
    },
    Decomposition {
        kanji: '慣',
        radicals: &['貝', '目', 'ハ', '母', '⺖', '毋'],
    },
    Decomposition {
        kanji: '憾',
        radicals: &['ノ', '口', '心', '⺖', '戈'],
    },
    Decomposition {
        kanji: '換',
        radicals: &['大', '儿', '冂', '勹', '扌'],
    },
    Decomposition {
        kanji: '敢',
        radicals: &['耳', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '柑',
        radicals: &['日', '木', '甘'],
    },
    Decomposition {
        kanji: '桓',
        radicals: &['一', '日', '木'],
    },
    Decomposition {
        kanji: '棺',
        radicals: &['口', '木', '宀', '｜'],
    },
    Decomposition {
        kanji: '款',
        radicals: &['欠', '士', '示', '二', '小'],
    },
    Decomposition {
        kanji: '歓',
        radicals: &['欠', '隹', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '汗',
        radicals: &['干', '⺡'],
    },
    Decomposition {
        kanji: '漢',
        radicals: &['⺡', '⺾', '口', '一', '大', '二'],
    },
    Decomposition {
        kanji: '澗',
        radicals: &['⺡', '日', '門'],
    },
    Decomposition {
        kanji: '潅',
        radicals: &['⺡', '隹', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '環',
        radicals: &['衣', '王', '口', '⺲', '一'],
    },
    Decomposition {
        kanji: '甘',
        radicals: &['甘'],
    },
    Decomposition {
        kanji: '監',
        radicals: &['皿', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '看',
        radicals: &['ノ', '一', '手', '二', '目'],
    },
    Decomposition {
        kanji: '竿',
        radicals: &['干', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '管',
        radicals: &['口', '竹', '宀', '｜', '𠂉'],
    },
    Decomposition {
        kanji: '簡',
        radicals: &['竹', '日', '門', '𠂉'],
    },
    Decomposition {
        kanji: '緩',
        radicals: &['糸', '幺', '小', '爪', '一', 'ノ', '又'],
    },
    Decomposition {
        kanji: '缶',
        radicals: &['缶', '凵', '山'],
    },
    Decomposition {
        kanji: '翰',
        radicals: &['羽', '十', '日', '𠆢', '冫'],
    },
    Decomposition {
        kanji: '肝',
        radicals: &['干', '月'],
    },
    Decomposition {
        kanji: '艦',
        radicals: &['皿', '舟', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '莞',
        radicals: &['二', '儿', '宀', '⺾', '元'],
    },
    Decomposition {
        kanji: '観',
        radicals: &['見', '隹', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '諌',
        radicals: &['｜', '言', '日', '木', '田'],
    },
    Decomposition {
        kanji: '貫',
        radicals: &['貝', '目', 'ハ', '母', '毋'],
    },
    Decomposition {
        kanji: '還',
        radicals: &['衣', '口', '⻌', '⺲', '一'],
    },
    Decomposition {
        kanji: '鑑',
        radicals: &['金', '皿', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '間',
        radicals: &['日', '門'],
    },
    Decomposition {
        kanji: '閑',
        radicals: &['木', '門'],
    },
    Decomposition {
        kanji: '関',
        radicals: &['人', '大', '二', 'ハ', '門', '丷', '一'],
    },
    Decomposition {
        kanji: '陥',
        radicals: &['｜', '日', '勹', '⻖'],
    },
    Decomposition {
        kanji: '韓',
        radicals: &['十', '日', '韋', '口'],
    },
    Decomposition {
        kanji: '館',
        radicals: &['口', '食', '宀', '｜'],
    },
    Decomposition {
        kanji: '舘',
        radicals: &['干', '口', '𠆢', '宀', '｜'],
    },
    Decomposition {
        kanji: '丸',
        radicals: &['九', '丶'],
    },
    Decomposition {
        kanji: '含',
        radicals: &['口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '岸',
        radicals: &['干', '山', '厂'],
    },
    Decomposition {
        kanji: '巌',
        radicals: &['山', '耳', '⺌', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '玩',
        radicals: &['王', '儿', '二', '元'],
    },
    Decomposition {
        kanji: '癌',
        radicals: &['口', '山', '⽧', '品'],
    },
    Decomposition {
        kanji: '眼',
        radicals: &['艮', '目'],
    },
    Decomposition {
        kanji: '岩',
        radicals: &['口', '山', '石'],
    },
    Decomposition {
        kanji: '翫',
        radicals: &['羽', '白', '儿', '冫', '元'],
    },
    Decomposition {
        kanji: '贋',
        radicals: &['⺅', '貝', '目', 'ハ', '厂', '隹'],
    },
    Decomposition {
        kanji: '雁',
        radicals: &['⺅', '厂', '隹'],
    },
    Decomposition {
        kanji: '頑',
        radicals: &['貝', '目', 'ハ', '頁', '儿', '二', '元'],
    },
    Decomposition {
        kanji: '顔',
        radicals: &['貝', '目', 'ハ', '頁', '立', '亠', '厂', '彡'],
    },
    Decomposition {
        kanji: '願',
        radicals: &['貝', '目', 'ハ', '小', '白', '頁', '厂'],
    },
    Decomposition {
        kanji: '企',
        radicals: &['止', '𠆢'],
    },
    Decomposition {
        kanji: '伎',
        radicals: &['⺅', '支', '又', '十'],
    },
    Decomposition {
        kanji: '危',
        radicals: &['勹', '厂', '卩'],
    },
    Decomposition {
        kanji: '喜',
        radicals: &['口', '士', '豆', '丷'],
    },
    Decomposition {
        kanji: '器',
        radicals: &['口', '大'],
    },
    Decomposition {
        kanji: '基',
        radicals: &['一', '甘', '土', 'ハ'],
    },
    Decomposition {
        kanji: '奇',
        radicals: &['一', '口', '大', '亅'],
    },
    Decomposition {
        kanji: '嬉',
        radicals: &['口', '士', '女', '豆', '丷'],
    },
    Decomposition {
        kanji: '寄',
        radicals: &['一', '口', '大', '亅', '宀'],
    },
    Decomposition {
        kanji: '岐',
        radicals: &['山', '支', '又', '十'],
    },
    Decomposition {
        kanji: '希',
        radicals: &['ノ', '一', '巾'],
    },
    Decomposition {
        kanji: '幾',
        radicals: &['ノ', '幺', '戈', '丶'],
    },
    Decomposition {
        kanji: '忌',
        radicals: &['心', '已'],
    },
    Decomposition {
        kanji: '揮',
        radicals: &['車', '冖', '扌'],
    },
    Decomposition {
        kanji: '机',
        radicals: &['木', '几'],
    },
    Decomposition {
        kanji: '旗',
        radicals: &['甘', 'ハ', '方', '𠂉'],
    },
    Decomposition {
        kanji: '既',
        radicals: &['牙', '艮'],
    },
    Decomposition {
        kanji: '期',
        radicals: &['甘', '月', 'ハ'],
    },
    Decomposition {
        kanji: '棋',
        radicals: &['甘', 'ハ', '木'],
    },
    Decomposition {
        kanji: '棄',
        radicals: &['一', '木', '亠', '凵', '厶'],
    },
    Decomposition {
        kanji: '機',
        radicals: &['ノ', '木', '丶', '幺', '戈'],
    },
    Decomposition {
        kanji: '帰',
        radicals: &['ヨ', '⺉', '巾', '冖'],
    },
    Decomposition {
        kanji: '毅',
        radicals: &['立', '亠', '殳', '豕', '几', '又'],
    },
    Decomposition {
        kanji: '気',
        radicals: &['气', '丶', 'ノ', '𠂉'],
    },
    Decomposition {
        kanji: '汽',
        radicals: &['⺡', '气', '𠂉'],
    },
    Decomposition {
        kanji: '畿',
        radicals: &['田', '幺', '戈', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '祈',
        radicals: &['斤', '⺭'],
    },
    Decomposition {
        kanji: '季',
        radicals: &['禾', '子'],
    },
    Decomposition {
        kanji: '稀',
        radicals: &['ノ', '一', '禾', '巾', '丶'],
    },
    Decomposition {
        kanji: '紀',
        radicals: &['糸', '幺', '小', '已'],
    },
    Decomposition {
        kanji: '徽',
        radicals: &['山', '糸', '幺', '小', '攵', '彳'],
    },
    Decomposition {
        kanji: '規',
        radicals: &['見', '土', '人', '二', '大'],
    },
    Decomposition {
        kanji: '記',
        radicals: &['言', '已'],
    },
    Decomposition {
        kanji: '貴',
        radicals: &['｜', '一', '貝', '目', 'ハ', '口'],
    },
    Decomposition {
        kanji: '起',
        radicals: &['走', '土', '已'],
    },
    Decomposition {
        kanji: '軌',
        radicals: &['車', '九'],
    },
    Decomposition {
        kanji: '輝',
        radicals: &['車', '⺌', '儿', '冖', '一'],
    },
    Decomposition {
        kanji: '飢',
        radicals: &['食', '几'],
    },
    Decomposition {
        kanji: '騎',
        radicals: &['口', '大', '馬', '亅', '一', '⺣'],
    },
    Decomposition {
        kanji: '鬼',
        radicals: &['鬼', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '亀',
        radicals: &['亀', '田', '勹', '乙'],
    },
    Decomposition {
        kanji: '偽',
        radicals: &['⺅', '丶', '⺣', 'ユ', 'ノ', '丷', '勹'],
    },
    Decomposition {
        kanji: '儀',
        radicals: &['一', '王', '⺅', '丷', '羊', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '妓',
        radicals: &['支', '女', '又', '十'],
    },
    Decomposition {
        kanji: '宜',
        radicals: &['一', '目', '宀'],
    },
    Decomposition {
        kanji: '戯',
        radicals: &['卜', '匕', '厂', '戈', '虍'],
    },
    Decomposition {
        kanji: '技',
        radicals: &['支', '扌', '又', '十'],
    },
    Decomposition {
        kanji: '擬',
        radicals: &['疋', '矢', '匕', '扌', 'マ', '𠂉'],
    },
    Decomposition {
        kanji: '欺',
        radicals: &['甘', '欠', 'ハ'],
    },
    Decomposition {
        kanji: '犠',
        radicals: &['一', '王', '牛', '丷', '羊', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '疑',
        radicals: &['疋', '矢', '匕', 'マ', '𠂉'],
    },
    Decomposition {
        kanji: '祇',
        radicals: &['氏', '⺭'],
    },
    Decomposition {
        kanji: '義',
        radicals: &['一', '王', '丷', '羊', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '蟻',
        radicals: &['一', '王', '虫', '丷', '羊', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '誼',
        radicals: &['一', '言', '目', '宀'],
    },
    Decomposition {
        kanji: '議',
        radicals: &['一', '王', '言', '丷', '羊', '亅', '戈', '手'],
    },
    Decomposition {
        kanji: '掬',
        radicals: &['米', '勹', '扌'],
    },
    Decomposition {
        kanji: '菊',
        radicals: &['米', '勹', '⺾'],
    },
    Decomposition {
        kanji: '鞠',
        radicals: &['革', '米', '勹'],
    },
    Decomposition {
        kanji: '吉',
        radicals: &['口', '士'],
    },
    Decomposition {
        kanji: '吃',
        radicals: &['乙', '口', '𠂉', '𠂉'],
    },
    Decomposition {
        kanji: '喫',
        radicals: &['口', '大', '土', '刀', '亠', '二'],
    },
    Decomposition {
        kanji: '桔',
        radicals: &['口', '士', '木'],
    },
    Decomposition {
        kanji: '橘',
        radicals: &['口', '矛', '木', '儿', '冂'],
    },
    Decomposition {
        kanji: '詰',
        radicals: &['言', '口', '士'],
    },
    Decomposition {
        kanji: '砧',
        radicals: &['口', '石', '卜'],
    },
    Decomposition {
        kanji: '杵',
        radicals: &['ノ', '干', '木', '十', '𠂉'],
    },
    Decomposition {
        kanji: '黍',
        radicals: &['禾', '黍', '水'],
    },
    Decomposition {
        kanji: '却',
        radicals: &['土', '卩', '厶'],
    },
    Decomposition {
        kanji: '客',
        radicals: &['口', '夂', '宀'],
    },
    Decomposition {
        kanji: '脚',
        radicals: &['月', '土', '卩', '厶'],
    },
    Decomposition {
        kanji: '虐',
        radicals: &['卜', '匕', '匚', '厂', '虍'],
    },
    Decomposition {
        kanji: '逆',
        radicals: &['⻌', '丷', '屮'],
    },
    Decomposition {
        kanji: '丘',
        radicals: &['一', '斤'],
    },
    Decomposition {
        kanji: '久',
        radicals: &['ノ', '入', '久'],
    },
    Decomposition {
        kanji: '仇',
        radicals: &['⺅', '九'],
    },
    Decomposition {
        kanji: '休',
        radicals: &['⺅', '木'],
    },
    Decomposition {
        kanji: '及',
        radicals: &['丶', '及', '乃', 'ノ'],
    },
    Decomposition {
        kanji: '吸',
        radicals: &['ノ', '口', '及'],
    },
    Decomposition {
        kanji: '宮',
        radicals: &['口', '宀', 'ノ'],
    },
    Decomposition {
        kanji: '弓',
        radicals: &['弓'],
    },
    Decomposition {
        kanji: '急',
        radicals: &['ヨ', '心', '勹'],
    },
    Decomposition {
        kanji: '救',
        radicals: &['水', '丶', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '朽',
        radicals: &['一', '木', '勹'],
    },
    Decomposition {
        kanji: '求',
        radicals: &['一', '水', '丶'],
    },
    Decomposition {
        kanji: '汲',
        radicals: &['ノ', '⺡', '及'],
    },
    Decomposition {
        kanji: '泣',
        radicals: &['⺡', '立'],
    },
    Decomposition {
        kanji: '灸',
        radicals: &['久', '火'],
    },
    Decomposition {
        kanji: '球',
        radicals: &['王', '水', '丶'],
    },
    Decomposition {
        kanji: '究',
        radicals: &['穴', '九', '儿', '宀'],
    },
    Decomposition {
        kanji: '窮',
        radicals: &['弓', '穴', '身', '儿', '宀'],
    },
    Decomposition {
        kanji: '笈',
        radicals: &['ノ', '竹', '及', '𠂉'],
    },
    Decomposition {
        kanji: '級',
        radicals: &['ノ', '糸', '幺', '小', '及'],
    },
    Decomposition {
        kanji: '糾',
        radicals: &['｜', '糸', '幺', '小', '十'],
    },
    Decomposition {
        kanji: '給',
        radicals: &['口', '糸', '幺', '小', '𠆢', '一'],
    },
    Decomposition {
        kanji: '旧',
        radicals: &['｜', '日'],
    },
    Decomposition {
        kanji: '牛',
        radicals: &['牛'],
    },
    Decomposition {
        kanji: '去',
        radicals: &['土', '厶'],
    },
    Decomposition {
        kanji: '居',
        radicals: &['口', '十', '尸'],
    },
    Decomposition {
        kanji: '巨',
        radicals: &['匚', '巨'],
    },
    Decomposition {
        kanji: '拒',
        radicals: &['匚', '扌', '巨'],
    },
    Decomposition {
        kanji: '拠',
        radicals: &['几', '夂', '扌'],
    },
    Decomposition {
        kanji: '挙',
        radicals: &['手', '⺌', 'ハ'],
    },
    Decomposition {
        kanji: '渠',
        radicals: &['⺡', '木', '匚', '巨'],
    },
    Decomposition {
        kanji: '虚',
        radicals: &['一', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '許',
        radicals: &['ノ', '干', '言', '十', '𠂉'],
    },
    Decomposition {
        kanji: '距',
        radicals: &['口', '足', '匚', '巨', '止'],
    },
    Decomposition {
        kanji: '鋸',
        radicals: &['金', '口', '十', '尸'],
    },
    Decomposition {
        kanji: '漁',
        radicals: &['魚', '⺡', '田', '⺣'],
    },
    Decomposition {
        kanji: '禦',
        radicals: &['止', '示', '二', '小', '卩', '彳', '𠂉'],
    },
    Decomposition {
        kanji: '魚',
        radicals: &['魚', '田', '⺣'],
    },
    Decomposition {
        kanji: '亨',
        radicals: &['口', '亠', '一', '亅'],
    },
    Decomposition {
        kanji: '享',
        radicals: &['口', '子', '亠'],
    },
    Decomposition {
        kanji: '京',
        radicals: &['口', '小', '亠'],
    },
    Decomposition {
        kanji: '供',
        radicals: &['｜', '一', '⺅', '二', 'ハ'],
    },
    Decomposition {
        kanji: '侠',
        radicals: &['⺅', '人', '大', '二', '丷', '亠'],
    },
    Decomposition {
        kanji: '僑',
        radicals: &['ノ', '⺅', '口', '冂', '大'],
    },
    Decomposition {
        kanji: '兇',
        radicals: &['儿', '凵', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '競',
        radicals: &['口', '立', '儿'],
    },
    Decomposition {
        kanji: '共',
        radicals: &['ハ', '｜', '一', '二'],
    },
    Decomposition {
        kanji: '凶',
        radicals: &['凵', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '協',
        radicals: &['十', '力'],
    },
    Decomposition {
        kanji: '匡',
        radicals: &['王', '匚'],
    },
    Decomposition {
        kanji: '卿',
        radicals: &['艮', '卩'],
    },
    Decomposition {
        kanji: '叫',
        radicals: &['｜', '口', '十'],
    },
    Decomposition {
        kanji: '喬',
        radicals: &['ノ', '口', '冂', '大'],
    },
    Decomposition {
        kanji: '境',
        radicals: &['音', '土', '日', '立', '儿'],
    },
    Decomposition {
        kanji: '峡',
        radicals: &['山', '人', '大', '二', '丷', '亠'],
    },
    Decomposition {
        kanji: '強',
        radicals: &['弓', '虫', '厶'],
    },
    Decomposition {
        kanji: '彊',
        radicals: &['一', '弓', '田'],
    },
    Decomposition {
        kanji: '怯',
        radicals: &['土', '⺖', '厶'],
    },
    Decomposition {
        kanji: '恐',
        radicals: &['工', '心', '丶', '几'],
    },
    Decomposition {
        kanji: '恭',
        radicals: &['心', 'ハ', '井'],
    },
    Decomposition {
        kanji: '挟',
        radicals: &['人', '大', '二', '丷', '丶', '亠', '扌'],
    },
    Decomposition {
        kanji: '教',
        radicals: &['子', '⺹', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '橋',
        radicals: &['ノ', '口', '木', '冂'],
    },
    Decomposition {
        kanji: '況',
        radicals: &['口', '⺡', '儿'],
    },
    Decomposition {
        kanji: '狂',
        radicals: &['王', '⺨'],
    },
    Decomposition {
        kanji: '狭',
        radicals: &['人', '大', '二', '丷', '⺨', '丶', '亠'],
    },
    Decomposition {
        kanji: '矯',
        radicals: &['ノ', '口', '矢', '冂', '大', '𠂉'],
    },
    Decomposition {
        kanji: '胸',
        radicals: &['月', '凵', '勹', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '脅',
        radicals: &['月', '力'],
    },
    Decomposition {
        kanji: '興',
        radicals: &['臼', '口', 'ハ', '冂', '一'],
    },
    Decomposition {
        kanji: '蕎',
        radicals: &['ノ', '口', '冂', '⺾', '大'],
    },
    Decomposition {
        kanji: '郷',
        radicals: &['艮', '⻏', '幺'],
    },
    Decomposition {
        kanji: '鏡',
        radicals: &['音', '金', '日', '立', '儿'],
    },
    Decomposition {
        kanji: '響',
        radicals: &['音', '艮', '日', '⻏', '立', '幺'],
    },
    Decomposition {
        kanji: '饗',
        radicals: &['艮', '食', '⻏', '幺'],
    },
    Decomposition {
        kanji: '驚',
        radicals: &['口', '馬', '勹', '夂', '⺾', '攵', '⺣', '𠂉'],
    },
    Decomposition {
        kanji: '仰',
        radicals: &['⺅', '卩'],
    },
    Decomposition {
        kanji: '凝',
        radicals: &['矢', '冫', '匕', 'マ', '疋', '𠂉'],
    },
    Decomposition {
        kanji: '尭',
        radicals: &['十', '儿', '廾', '一'],
    },
    Decomposition {
        kanji: '暁',
        radicals: &['十', '日', '儿', '廾'],
    },
    Decomposition {
        kanji: '業',
        radicals: &['｜', '一', '王', '丷', '木', '羊', '耒'],
    },
    Decomposition {
        kanji: '局',
        radicals: &['口', '尸'],
    },
    Decomposition {
        kanji: '曲',
        radicals: &['｜', '日'],
    },
    Decomposition {
        kanji: '極',
        radicals: &['口', '又', '木', '一'],
    },
    Decomposition {
        kanji: '玉',
        radicals: &['王', '丶'],
    },
    Decomposition {
        kanji: '桐',
        radicals: &['口', '木', '冂', '一'],
    },
    Decomposition {
        kanji: '粁',
        radicals: &['干', '米', '十'],
    },
    Decomposition {
        kanji: '僅',
        radicals: &['⺅', '土', '⺾', '口', '二', '一'],
    },
    Decomposition {
        kanji: '勤',
        radicals: &['土', '力', '⺾', '口', '二', '一'],
    },
    Decomposition {
        kanji: '均',
        radicals: &['土', '冫', '勹', '二'],
    },
    Decomposition {
        kanji: '巾',
        radicals: &['巾', '冂', '｜'],
    },
    Decomposition {
        kanji: '錦',
        radicals: &['巾', '金', '白'],
    },
    Decomposition {
        kanji: '斤',
        radicals: &['斤'],
    },
    Decomposition {
        kanji: '欣',
        radicals: &['斤', '欠'],
    },
    Decomposition {
        kanji: '欽',
        radicals: &['金', '欠'],
    },
    Decomposition {
        kanji: '琴',
        radicals: &['王', '𠆢', '一'],
    },
    Decomposition {
        kanji: '禁',
        radicals: &['示', '二', '小', '木'],
    },
    Decomposition {
        kanji: '禽',
        radicals: &['𠆢', '亠', '冂', '凵', '厶', '⽱', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '筋',
        radicals: &['月', '竹', '力', '𠂉'],
    },
    Decomposition {
        kanji: '緊',
        radicals: &['糸', '幺', '小', '臣', '又'],
    },
    Decomposition {
        kanji: '芹',
        radicals: &['斤', '⺾'],
    },
    Decomposition {
        kanji: '菌',
        radicals: &['禾', '囗', '⺾'],
    },
    Decomposition {
        kanji: '衿',
        radicals: &['⻂', '𠆢', '一'],
    },
    Decomposition {
        kanji: '襟',
        radicals: &['示', '二', '小', '⻂', '木'],
    },
    Decomposition {
        kanji: '謹',
        radicals: &['言', '土', '⺾', '口', '口', '二'],
    },
    Decomposition {
        kanji: '近',
        radicals: &['斤', '⻌'],
    },
    Decomposition {
        kanji: '金',
        radicals: &['金', '王', 'ハ', '𠆢', '丷'],
    },
    Decomposition {
        kanji: '吟',
        radicals: &['口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '銀',
        radicals: &['金', '艮'],
    },
    Decomposition {
        kanji: '九',
        radicals: &['九'],
    },
    Decomposition {
        kanji: '倶',
        radicals: &['⺅', 'ハ', '目', '一'],
    },
    Decomposition {
        kanji: '句',
        radicals: &['口', '勹'],
    },
    Decomposition {
        kanji: '区',
        radicals: &['匚', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '狗',
        radicals: &['口', '⺨', '勹'],
    },
    Decomposition {
        kanji: '玖',
        radicals: &['久', '王'],
    },
    Decomposition {
        kanji: '矩',
        radicals: &['矢', '巨', '𠂉'],
    },
    Decomposition {
        kanji: '苦',
        radicals: &['口', '十', '⺾'],
    },
    Decomposition {
        kanji: '躯',
        radicals: &['身', '匚', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '駆',
        radicals: &['馬', '匚', '丶', 'ノ', '⺣', '⺣'],
    },
    Decomposition {
        kanji: '駈',
        radicals: &['斤', '馬', '⺣', '一'],
    },
    Decomposition {
        kanji: '駒',
        radicals: &['口', '馬', '勹', '⺣'],
    },
    Decomposition {
        kanji: '具',
        radicals: &['一', 'ハ', '目'],
    },
    Decomposition {
        kanji: '愚',
        radicals: &['心', '田', '冂', '厶', '⽱'],
    },
    Decomposition {
        kanji: '虞',
        radicals: &['口', 'ハ', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '喰',
        radicals: &['口', '食'],
    },
    Decomposition {
        kanji: '空',
        radicals: &['穴', '工', '儿', '宀'],
    },
    Decomposition {
        kanji: '偶',
        radicals: &['⺅', '田', '冂', '厶', '⽱'],
    },
    Decomposition {
        kanji: '寓',
        radicals: &['田', '冂', '厶', '宀', '⽱'],
    },
    Decomposition {
        kanji: '遇',
        radicals: &['⻌', '田', '冂', '厶', '⽱'],
    },
    Decomposition {
        kanji: '隅',
        radicals: &['田', '日', '冂', '厶', '⽱', '⻖'],
    },
    Decomposition {
        kanji: '串',
        radicals: &['｜', '口'],
    },
    Decomposition {
        kanji: '櫛',
        radicals: &['艮', '竹', '木', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '釧',
        radicals: &['金', '川'],
    },
    Decomposition {
        kanji: '屑',
        radicals: &['月', '⺌', '尸'],
    },
    Decomposition {
        kanji: '屈',
        radicals: &['｜', '山', '尸'],
    },
    Decomposition {
        kanji: '掘',
        radicals: &['｜', '山', '尸', '扌'],
    },
    Decomposition {
        kanji: '窟',
        radicals: &['｜', '穴', '山', '儿', '宀', '尸'],
    },
    Decomposition {
        kanji: '沓',
        radicals: &['水', '日'],
    },
    Decomposition {
        kanji: '靴',
        radicals: &['⺅', '革', '匕'],
    },
    Decomposition {
        kanji: '轡',
        radicals: &['口', '糸', '幺', '小', '車'],
    },
    Decomposition {
        kanji: '窪',
        radicals: &['穴', '⺡', '土', '儿', '宀'],
    },
    Decomposition {
        kanji: '熊',
        radicals: &['月', '匕', '厶', '⺣'],
    },
    Decomposition {
        kanji: '隈',
        radicals: &['衣', '田', '⻖'],
    },
    Decomposition {
        kanji: '粂',
        radicals: &['久', '米'],
    },
    Decomposition {
        kanji: '栗',
        radicals: &['西', '木'],
    },
    Decomposition {
        kanji: '繰',
        radicals: &['口', '糸', '幺', '小', '木', '品'],
    },
    Decomposition {
        kanji: '桑',
        radicals: &['又', '木'],
    },
    Decomposition {
        kanji: '鍬',
        radicals: &['火', '禾', '金'],
    },
    Decomposition {
        kanji: '勲',
        radicals: &['｜', '力', '⺣', '日', '一', 'ノ'],
    },
    Decomposition {
        kanji: '君',
        radicals: &['一', '口', 'ノ', 'ヨ'],
    },
    Decomposition {
        kanji: '薫',
        radicals: &['｜', '⺣', '⺾', '日', 'ノ', '一'],
    },
    Decomposition {
        kanji: '訓',
        radicals: &['言', '川'],
    },
    Decomposition {
        kanji: '群',
        radicals: &['一', '王', '口', '丷', '羊', 'ノ', 'ヨ'],
    },
    Decomposition {
        kanji: '軍',
        radicals: &['車', '冖'],
    },
    Decomposition {
        kanji: '郡',
        radicals: &['一', '口', '⻏', 'ノ', 'ヨ'],
    },
    Decomposition {
        kanji: '卦',
        radicals: &['土', '卜'],
    },
    Decomposition {
        kanji: '袈',
        radicals: &['衣', '口', '力', '亠'],
    },
    Decomposition {
        kanji: '祁',
        radicals: &['⻏', '⺭'],
    },
    Decomposition {
        kanji: '係',
        radicals: &['ノ', '⺅', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '傾',
        radicals: &['⺅', '貝', '目', 'ハ', '頁', '匕'],
    },
    Decomposition {
        kanji: '刑',
        radicals: &['⺉', '廾', 'ノ', '二', '一'],
    },
    Decomposition {
        kanji: '兄',
        radicals: &['口', '儿'],
    },
    Decomposition {
        kanji: '啓',
        radicals: &['戸', '口', '攵', '一', '尸', '𠂉'],
    },
    Decomposition {
        kanji: '圭',
        radicals: &['土'],
    },
    Decomposition {
        kanji: '珪',
        radicals: &['王', '土'],
    },
    Decomposition {
        kanji: '型',
        radicals: &['⺉', '土', '廾', 'ノ', '二', '一'],
    },
    Decomposition {
        kanji: '契',
        radicals: &['大', '土', '刀', '亠', '二'],
    },
    Decomposition {
        kanji: '形',
        radicals: &['廾', '彡', 'ノ', '二', '一'],
    },
    Decomposition {
        kanji: '径',
        radicals: &['土', '又', '彳'],
    },
    Decomposition {
        kanji: '恵',
        radicals: &['一', '心', '田'],
    },
    Decomposition {
        kanji: '慶',
        radicals: &['心', '冖', '夂', '广'],
    },
    Decomposition {
        kanji: '慧',
        radicals: &['ヨ', '心', '｜', '一'],
    },
    Decomposition {
        kanji: '憩',
        radicals: &['口', '自', '心', '舌', '目'],
    },
    Decomposition {
        kanji: '掲',
        radicals: &['日', '勹', '匕', '扌'],
    },
    Decomposition {
        kanji: '携',
        radicals: &['ノ', '扌', '隹', '乃'],
    },
    Decomposition {
        kanji: '敬',
        radicals: &['口', '勹', '攵', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '景',
        radicals: &['口', '小', '日', '亠'],
    },
    Decomposition {
        kanji: '桂',
        radicals: &['土', '木'],
    },
    Decomposition {
        kanji: '渓',
        radicals: &['⺡', '人', '爪', '土', '二', '大'],
    },
    Decomposition {
        kanji: '畦',
        radicals: &['田', '土'],
    },
    Decomposition {
        kanji: '稽',
        radicals: &['禾', '日', '匕', '尤'],
    },
    Decomposition {
        kanji: '系',
        radicals: &['ノ', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '経',
        radicals: &['糸', '幺', '小', '土', '又'],
    },
    Decomposition {
        kanji: '継',
        radicals: &['｜', '糸', '幺', '小', '米'],
    },
    Decomposition {
        kanji: '繋',
        radicals: &['糸', '幺', '小', '車', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '罫',
        radicals: &['土', '⺲', '卜'],
    },
    Decomposition {
        kanji: '茎',
        radicals: &['土', '又', '⺾'],
    },
    Decomposition {
        kanji: '荊',
        radicals: &['⺉', '廾', '⺾', 'ノ', '二', '一'],
    },
    Decomposition {
        kanji: '蛍',
        radicals: &['⺌', '虫', '冖'],
    },
    Decomposition {
        kanji: '計',
        radicals: &['言', '十'],
    },
    Decomposition {
        kanji: '詣',
        radicals: &['言', '日', '匕'],
    },
    Decomposition {
        kanji: '警',
        radicals: &['言', '口', '勹', '夂', '⺾', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '軽',
        radicals: &['車', '土', '又'],
    },
    Decomposition {
        kanji: '頚',
        radicals: &['貝', '目', 'ハ', '土', '頁', '又'],
    },
    Decomposition {
        kanji: '鶏',
        radicals: &['人', '爪', '土', '大', '鳥', '⺣', '二'],
    },
    Decomposition {
        kanji: '芸',
        radicals: &['二', '厶', '⺾'],
    },
    Decomposition {
        kanji: '迎',
        radicals: &['⻌', '卩'],
    },
    Decomposition {
        kanji: '鯨',
        radicals: &['魚', '口', '小', '田', '亠', '⺣'],
    },
    Decomposition {
        kanji: '劇',
        radicals: &['⺉', '卜', '匕', '厂', '虍', '豕'],
    },
    Decomposition {
        kanji: '戟',
        radicals: &['十', '日', '戈'],
    },
    Decomposition {
        kanji: '撃',
        radicals: &['車', '手', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '激',
        radicals: &['⺡', '白', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '隙',
        radicals: &['小', '日', '⻖'],
    },
    Decomposition {
        kanji: '桁',
        radicals: &['行', '木', '彳'],
    },
    Decomposition {
        kanji: '傑',
        radicals: &['⺅', '舛', '木', '夕'],
    },
    Decomposition {
        kanji: '欠',
        radicals: &['欠', '勹', '人'],
    },
    Decomposition {
        kanji: '決',
        radicals: &['⺡', '人', '大', '二', 'ユ'],
    },
    Decomposition {
        kanji: '潔',
        radicals: &['糸', '幺', '小', '⺡', '土', '刀', '亠', '二'],
    },
    Decomposition {
        kanji: '穴',
        radicals: &['穴', 'ハ', '宀', '儿'],
    },
    Decomposition {
        kanji: '結',
        radicals: &['口', '士', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '血',
        radicals: &['血', '皿'],
    },
    Decomposition {
        kanji: '訣',
        radicals: &['言', '人', '大', '二', 'ユ'],
    },
    Decomposition {
        kanji: '月',
        radicals: &['月'],
    },
    Decomposition {
        kanji: '件',
        radicals: &['⺅', '牛'],
    },
    Decomposition {
        kanji: '倹',
        radicals: &['⺅', '口', '人', '𠆢', '一'],
    },
    Decomposition {
        kanji: '倦',
        radicals: &['⺅', '已', '大', '二', '丷', '卩', 'ハ'],
    },
    Decomposition {
        kanji: '健',
        radicals: &['⺅', '廴', '聿'],
    },
    Decomposition {
        kanji: '兼',
        radicals: &['｜', 'ヨ', '一', 'ハ', '丷'],
    },
    Decomposition {
        kanji: '券',
        radicals: &['一', '人', '大', '刀', '二', '丷'],
    },
    Decomposition {
        kanji: '剣',
        radicals: &['⺉', '口', '人', '𠆢'],
    },
    Decomposition {
        kanji: '喧',
        radicals: &['一', '口', '日', '宀'],
    },
    Decomposition {
        kanji: '圏',
        radicals: &['一', '人', '大', '二', '丷', '囗', '已'],
    },
    Decomposition {
        kanji: '堅',
        radicals: &['臣', '土', '又'],
    },
    Decomposition {
        kanji: '嫌',
        radicals: &['｜', 'ヨ', '女', 'ハ', '丷'],
    },
    Decomposition {
        kanji: '建',
        radicals: &['廴', '聿'],
    },
    Decomposition {
        kanji: '憲',
        radicals: &['心', '土', '⺲', '亠', '宀', '二'],
    },
    Decomposition {
        kanji: '懸',
        radicals: &['ノ', '糸', '幺', '小', '心', '目'],
    },
    Decomposition {
        kanji: '拳',
        radicals: &['一', '手', '丷', '大', '二'],
    },
    Decomposition {
        kanji: '捲',
        radicals: &['一', '丷', '已', '扌', '大', '二'],
    },
    Decomposition {
        kanji: '検',
        radicals: &['口', '人', '木', '𠆢'],
    },
    Decomposition {
        kanji: '権',
        radicals: &['矢', '木', '隹', '𠂉'],
    },
    Decomposition {
        kanji: '牽',
        radicals: &['亠', '冖', '厶', '牛'],
    },
    Decomposition {
        kanji: '犬',
        radicals: &['犬', '大', '丶'],
    },
    Decomposition {
        kanji: '献',
        radicals: &['干', '犬', '十', '丷', '冂'],
    },
    Decomposition {
        kanji: '研',
        radicals: &['｜', '口', '石', '亅', '廾', 'ノ', '二', '一'],
    },
    Decomposition {
        kanji: '硯',
        radicals: &['見', '口', '石'],
    },
    Decomposition {
        kanji: '絹',
        radicals: &['月', '口', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '県',
        radicals: &['小', '目'],
    },
    Decomposition {
        kanji: '肩',
        radicals: &['月', '戸', '一', '尸'],
    },
    Decomposition {
        kanji: '見',
        radicals: &['見', '目', '儿'],
    },
    Decomposition {
        kanji: '謙',
        radicals: &['｜', 'ヨ', '言', 'ハ', '丷'],
    },
    Decomposition {
        kanji: '賢',
        radicals: &['貝', '目', 'ハ', '臣', '又'],
    },
    Decomposition {
        kanji: '軒',
        radicals: &['干', '車'],
    },
    Decomposition {
        kanji: '遣',
        radicals: &['｜', '一', '口', '⻌'],
    },
    Decomposition {
        kanji: '鍵',
        radicals: &['金', '廴', '聿'],
    },
    Decomposition {
        kanji: '険',
        radicals: &['口', '人', '𠆢', '⻖'],
    },
    Decomposition {
        kanji: '顕',
        radicals: &['貝', '目', 'ハ', '日', '頁'],
    },
    Decomposition {
        kanji: '験',
        radicals: &['口', '人', '馬', '𠆢', '⺣'],
    },
    Decomposition {
        kanji: '鹸',
        radicals: &['口', '十', '人', '𠆢', '囗', '鹵'],
    },
    Decomposition {
        kanji: '元',
        radicals: &['二', '儿', '元'],
    },
    Decomposition {
        kanji: '原',
        radicals: &['小', '白', '厂'],
    },
    Decomposition {
        kanji: '厳',
        radicals: &['耳', '⺌', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '幻',
        radicals: &['幺'],
    },
    Decomposition {
        kanji: '弦',
        radicals: &['弓', '玄', '亠', '幺'],
    },
    Decomposition {
        kanji: '減',
        radicals: &['口', '⺡', '亅', '戈'],
    },
    Decomposition {
        kanji: '源',
        radicals: &['⺡', '小', '白', '厂'],
    },
    Decomposition {
        kanji: '玄',
        radicals: &['玄', '亠', '幺'],
    },
    Decomposition {
        kanji: '現',
        radicals: &['王', '見'],
    },
    Decomposition {
        kanji: '絃',
        radicals: &['玄', '糸', '幺', '小', '亠'],
    },
    Decomposition {
        kanji: '舷',
        radicals: &['玄', '舟', '亠', '幺'],
    },
    Decomposition {
        kanji: '言',
        radicals: &['言'],
    },
    Decomposition {
        kanji: '諺',
        radicals: &['言', '丷', '立', '亅', '亠', '彡'],
    },
    Decomposition {
        kanji: '限',
        radicals: &['艮', '⻖'],
    },
    Decomposition {
        kanji: '乎',
        radicals: &['ノ', '一', '丷', '亅'],
    },
    Decomposition {
        kanji: '個',
        radicals: &['⺅', '口', '十', '囗'],
    },
    Decomposition {
        kanji: '古',
        radicals: &['口', '十'],
    },
    Decomposition {
        kanji: '呼',
        radicals: &['ノ', '口', '丷', '亅'],
    },
    Decomposition {
        kanji: '固',
        radicals: &['口', '十', '囗'],
    },
    Decomposition {
        kanji: '姑',
        radicals: &['口', '十', '女'],
    },
    Decomposition {
        kanji: '孤',
        radicals: &['瓜', '子'],
    },
    Decomposition {
        kanji: '己',
        radicals: &['已'],
    },
    Decomposition {
        kanji: '庫',
        radicals: &['車', '广'],
    },
    Decomposition {
        kanji: '弧',
        radicals: &['瓜', '弓'],
    },
    Decomposition {
        kanji: '戸',
        radicals: &['戸', '一', '尸'],
    },
    Decomposition {
        kanji: '故',
        radicals: &['口', '十', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '枯',
        radicals: &['口', '十', '木'],
    },
    Decomposition {
        kanji: '湖',
        radicals: &['月', '口', '十', '⺡'],
    },
    Decomposition {
        kanji: '狐',
        radicals: &['瓜', '⺨'],
    },
    Decomposition {
        kanji: '糊',
        radicals: &['月', '口', '十', '米'],
    },
    Decomposition {
        kanji: '袴',
        radicals: &['⻂', '大', '二', '勹'],
    },
    Decomposition {
        kanji: '股',
        radicals: &['月', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '胡',
        radicals: &['月', '口', '十'],
    },
    Decomposition {
        kanji: '菰',
        radicals: &['瓜', '子', '⺾'],
    },
    Decomposition {
        kanji: '虎',
        radicals: &['卜', '儿', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '誇',
        radicals: &['言', '大', '二', '勹'],
    },
    Decomposition {
        kanji: '跨',
        radicals: &['口', '足', '大', '二', '勹', '止'],
    },
    Decomposition {
        kanji: '鈷',
        radicals: &['金', '口', '十'],
    },
    Decomposition {
        kanji: '雇',
        radicals: &['戸', '隹', '一', '尸'],
    },
    Decomposition {
        kanji: '顧',
        radicals: &['貝', '目', 'ハ', '戸', '頁', '隹', '一', '尸'],
    },
    Decomposition {
        kanji: '鼓',
        radicals: &['口', '士', '支', '豆', '丷', '又', '十', '鼓'],
    },
    Decomposition {
        kanji: '五',
        radicals: &['五'],
    },
    Decomposition {
        kanji: '互',
        radicals: &['ヨ', '一', '彑'],
    },
    Decomposition {
        kanji: '伍',
        radicals: &['⺅', '五'],
    },
    Decomposition {
        kanji: '午',
        radicals: &['ノ', '干', '十', '𠂉'],
    },
    Decomposition {
        kanji: '呉',
        radicals: &['口', 'ハ'],
    },
    Decomposition {
        kanji: '吾',
        radicals: &['口', '五'],
    },
    Decomposition {
        kanji: '娯',
        radicals: &['口', '女', 'ハ'],
    },
    Decomposition {
        kanji: '後',
        radicals: &['夂', '幺', '彳'],
    },
    Decomposition {
        kanji: '御',
        radicals: &['ノ', '止', '卩', '彳', '𠂉'],
    },
    Decomposition {
        kanji: '悟',
        radicals: &['口', '⺖', '五'],
    },
    Decomposition {
        kanji: '梧',
        radicals: &['口', '木', '五'],
    },
    Decomposition {
        kanji: '檎',
        radicals: &['木', '𠆢', '亠', '冂', '厶', '⽱'],
    },
    Decomposition {
        kanji: '瑚',
        radicals: &['王', '月', '口', '十'],
    },
    Decomposition {
        kanji: '碁',
        radicals: &['一', '口', '石', 'ハ', '甘'],
    },
    Decomposition {
        kanji: '語',
        radicals: &['言', '口', '五'],
    },
    Decomposition {
        kanji: '誤',
        radicals: &['言', '口', 'ハ'],
    },
    Decomposition {
        kanji: '護',
        radicals: &['言', '又', '⺾', '隹'],
    },
    Decomposition {
        kanji: '醐',
        radicals: &['月', '口', '十', '酉'],
    },
    Decomposition {
        kanji: '乞',
        radicals: &['ノ', '一', '乙', '人', '𠂉'],
    },
    Decomposition {
        kanji: '鯉',
        radicals: &['魚', '田', '里', '⺣'],
    },
    Decomposition {
        kanji: '交',
        radicals: &['父', '亠'],
    },
    Decomposition {
        kanji: '佼',
        radicals: &['⺅', '父', '亠'],
    },
    Decomposition {
        kanji: '侯',
        radicals: &['⺅', '矢', 'ユ', '𠂉'],
    },
    Decomposition {
        kanji: '候',
        radicals: &['｜', '⺅', '矢', 'ユ', '𠂉'],
    },
    Decomposition {
        kanji: '倖',
        radicals: &['⺅', '十', '辛', '立', '亠'],
    },
    Decomposition {
        kanji: '光',
        radicals: &['一', '⺌', '儿'],
    },
    Decomposition {
        kanji: '公',
        radicals: &['ハ', '厶'],
    },
    Decomposition {
        kanji: '功',
        radicals: &['工', '力'],
    },
    Decomposition {
        kanji: '効',
        radicals: &['父', '力', '亠'],
    },
    Decomposition {
        kanji: '勾',
        radicals: &['勹', '厶'],
    },
    Decomposition {
        kanji: '厚',
        radicals: &['子', '日', '厂'],
    },
    Decomposition {
        kanji: '口',
        radicals: &['囗', '口'],
    },
    Decomposition {
        kanji: '向',
        radicals: &['口', '冂'],
    },
    Decomposition {
        kanji: '后',
        radicals: &['ノ', '一', '斤', '口', '亅', '厂'],
    },
    Decomposition {
        kanji: '喉',
        radicals: &['⺅', '口', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '坑',
        radicals: &['土', '亠', '几'],
    },
    Decomposition {
        kanji: '垢',
        radicals: &['ノ', '斤', '口', '土', '亅', '厂'],
    },
    Decomposition {
        kanji: '好',
        radicals: &['子', '女'],
    },
    Decomposition {
        kanji: '孔',
        radicals: &['乙', '子'],
    },
    Decomposition {
        kanji: '孝',
        radicals: &['子', '⺹'],
    },
    Decomposition {
        kanji: '宏',
        radicals: &['ノ', '一', '厶', '宀'],
    },
    Decomposition {
        kanji: '工',
        radicals: &['工'],
    },
    Decomposition {
        kanji: '巧',
        radicals: &['工', '一', '勹'],
    },
    Decomposition {
        kanji: '巷',
        radicals: &['ハ', '已', '井'],
    },
    Decomposition {
        kanji: '幸',
        radicals: &['十', '辛', '立', '亠'],
    },
    Decomposition {
        kanji: '広',
        radicals: &['厶', '广'],
    },
    Decomposition {
        kanji: '庚',
        radicals: &['人', '广', 'ヨ'],
    },
    Decomposition {
        kanji: '康',
        radicals: &['ヨ', '水', '广', '隶'],
    },
    Decomposition {
        kanji: '弘',
        radicals: &['弓', '厶'],
    },
    Decomposition {
        kanji: '恒',
        radicals: &['一', '日', '⺖'],
    },
    Decomposition {
        kanji: '慌',
        radicals: &['川', '⺖', '⺾', '亡'],
    },
    Decomposition {
        kanji: '抗',
        radicals: &['亠', '几', '扌'],
    },
    Decomposition {
        kanji: '拘',
        radicals: &['口', '勹', '扌'],
    },
    Decomposition {
        kanji: '控',
        radicals: &['穴', '工', '儿', '宀', '扌'],
    },
    Decomposition {
        kanji: '攻',
        radicals: &['工', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '昂',
        radicals: &['日', '卩'],
    },
    Decomposition {
        kanji: '晃',
        radicals: &['一', '⺌', '日', '儿'],
    },
    Decomposition {
        kanji: '更',
        radicals: &['ノ', '一', '日', '田'],
    },
    Decomposition {
        kanji: '杭',
        radicals: &['木', '亠', '几'],
    },
    Decomposition {
        kanji: '校',
        radicals: &['父', '木', '亠'],
    },
    Decomposition {
        kanji: '梗',
        radicals: &['ノ', '一', '日', '木', '田'],
    },
    Decomposition {
        kanji: '構',
        radicals: &['木', '冂', '一', '十'],
    },
    Decomposition {
        kanji: '江',
        radicals: &['工', '⺡'],
    },
    Decomposition {
        kanji: '洪',
        radicals: &['｜', '一', '⺡', '二', 'ハ'],
    },
    Decomposition {
        kanji: '浩',
        radicals: &['ノ', '口', '⺡', '土'],
    },
    Decomposition {
        kanji: '港',
        radicals: &['⺡', 'ハ', '已', '井'],
    },
    Decomposition {
        kanji: '溝',
        radicals: &['⺡', '冂', '一', '十', '｜'],
    },
    Decomposition {
        kanji: '甲',
        radicals: &['｜', '日', '田'],
    },
    Decomposition {
        kanji: '皇',
        radicals: &['王', '白'],
    },
    Decomposition {
        kanji: '硬',
        radicals: &['ノ', '一', '口', '石', '日', '田'],
    },
    Decomposition {
        kanji: '稿',
        radicals: &['禾', '口', '高', '亠', '冂'],
    },
    Decomposition {
        kanji: '糠',
        radicals: &['ヨ', '水', '米', '广', '隶'],
    },
    Decomposition {
        kanji: '紅',
        radicals: &['工', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '紘',
        radicals: &['ノ', '一', '糸', '幺', '小', '厶'],
    },
    Decomposition {
        kanji: '絞',
        radicals: &['糸', '幺', '小', '父', '亠'],
    },
    Decomposition {
        kanji: '綱',
        radicals: &['糸', '幺', '小', '丷', '冂', '山', '一', '岡'],
    },
    Decomposition {
        kanji: '耕',
        radicals: &['｜', '土', 'ハ', '木', '亅', '耒', '井', 'ノ'],
    },
    Decomposition {
        kanji: '考',
        radicals: &['⺹', '勹'],
    },
    Decomposition {
        kanji: '肯',
        radicals: &['月', '止'],
    },
    Decomposition {
        kanji: '肱',
        radicals: &['ノ', '一', '月', '厶'],
    },
    Decomposition {
        kanji: '腔',
        radicals: &['穴', '月', '工', '儿', '宀'],
    },
    Decomposition {
        kanji: '膏',
        radicals: &['月', '口', '亠', '冖', '高'],
    },
    Decomposition {
        kanji: '航',
        radicals: &['舟', '亠', '几'],
    },
    Decomposition {
        kanji: '荒',
        radicals: &['川', '⺾', '亡'],
    },
    Decomposition {
        kanji: '行',
        radicals: &['行', '彳'],
    },
    Decomposition {
        kanji: '衡',
        radicals: &['行', '大', '田', '彳', '勹'],
    },
    Decomposition {
        kanji: '講',
        radicals: &['言', '冂', '一', '十'],
    },
    Decomposition {
        kanji: '貢',
        radicals: &['貝', '目', 'ハ', '工'],
    },
    Decomposition {
        kanji: '購',
        radicals: &['｜', '一', '貝', '目', 'ハ', '冂', '十'],
    },
    Decomposition {
        kanji: '郊',
        radicals: &['父', '⻏', '亠'],
    },
    Decomposition {
        kanji: '酵',
        radicals: &['子', '酉', '⺹'],
    },
    Decomposition {
        kanji: '鉱',
        radicals: &['金', '厶', '广'],
    },
    Decomposition {
        kanji: '砿',
        radicals: &['口', '石', '厶', '广'],
    },
    Decomposition {
        kanji: '鋼',
        radicals: &['金', '丷', '冂', '山', '岡'],
    },
    Decomposition {
        kanji: '閤',
        radicals: &['口', '門', '𠆢', '一'],
    },
    Decomposition {
        kanji: '降',
        radicals: &['夂', '⻖', '十'],
    },
    Decomposition {
        kanji: '項',
        radicals: &['貝', '目', 'ハ', '工', '頁'],
    },
    Decomposition {
        kanji: '香',
        radicals: &['禾', '香', '日'],
    },
    Decomposition {
        kanji: '高',
        radicals: &['口', '高', '亠', '冂'],
    },
    Decomposition {
        kanji: '鴻',
        radicals: &['工', '⺡', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '剛',
        radicals: &['⺉', '丷', '冂', '岡', '山'],
    },
    Decomposition {
        kanji: '劫',
        radicals: &['土', '力', '厶'],
    },
    Decomposition {
        kanji: '号',
        radicals: &['一', '口', '勹'],
    },
    Decomposition {
        kanji: '合',
        radicals: &['口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '壕',
        radicals: &['口', '土', '亠', '冖', '豕'],
    },
    Decomposition {
        kanji: '拷',
        radicals: &['⺹', '扌'],
    },
    Decomposition {
        kanji: '濠',
        radicals: &['口', '⺡', '亠', '冖', '豕'],
    },
    Decomposition {
        kanji: '豪',
        radicals: &['口', '亠', '冖', '豕'],
    },
    Decomposition {
        kanji: '轟',
        radicals: &['車'],
    },
    Decomposition {
        kanji: '麹',
        radicals: &['土', '麦', '米', '亠', '勹', '夂', '二'],
    },
    Decomposition {
        kanji: '克',
        radicals: &['口', '十', '儿'],
    },
    Decomposition {
        kanji: '刻',
        radicals: &['⺉', '亠', '人', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '告',
        radicals: &['ノ', '口', '土'],
    },
    Decomposition {
        kanji: '国',
        radicals: &['王', '囗', '丶'],
    },
    Decomposition {
        kanji: '穀',
        radicals: &['禾', '士', '冖', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '酷',
        radicals: &['ノ', '口', '土', '酉'],
    },
    Decomposition {
        kanji: '鵠',
        radicals: &['ノ', '口', '鳥', '土', '⺣'],
    },
    Decomposition {
        kanji: '黒',
        radicals: &['黒', '里', '⺣'],
    },
    Decomposition {
        kanji: '獄',
        radicals: &['言', '⺨', '犬'],
    },
    Decomposition {
        kanji: '漉',
        radicals: &['鹿', '⺡', '比', '广'],
    },
    Decomposition {
        kanji: '腰',
        radicals: &['月', '女', '西'],
    },
    Decomposition {
        kanji: '甑',
        radicals: &['瓦', '田', '日', '丷'],
    },
    Decomposition {
        kanji: '忽',
        radicals: &['勿', '心', '勹', 'ノ'],
    },
    Decomposition {
        kanji: '惚',
        radicals: &['心', '⺖', '勿', '勿'],
    },
    Decomposition {
        kanji: '骨',
        radicals: &['月', '冖', '冂', '骨'],
    },
    Decomposition {
        kanji: '狛',
        radicals: &['白', '⺨'],
    },
    Decomposition {
        kanji: '込',
        radicals: &['⻌', '入'],
    },
    Decomposition {
        kanji: '此',
        radicals: &['止', '匕'],
    },
    Decomposition {
        kanji: '頃',
        radicals: &['貝', '目', 'ハ', '頁', '匕'],
    },
    Decomposition {
        kanji: '今',
        radicals: &['𠆢', '一'],
    },
    Decomposition {
        kanji: '困',
        radicals: &['木', '囗'],
    },
    Decomposition {
        kanji: '坤',
        radicals: &['｜', '土', '日', '田'],
    },
    Decomposition {
        kanji: '墾',
        radicals: &['艮', '爪', '土', '⺨', '豸'],
    },
    Decomposition {
        kanji: '婚',
        radicals: &['氏', '女', '日'],
    },
    Decomposition {
        kanji: '恨',
        radicals: &['艮', '⺖'],
    },
    Decomposition {
        kanji: '懇',
        radicals: &['艮', '心', '爪', '⺨', '豸'],
    },
    Decomposition {
        kanji: '昏',
        radicals: &['氏', '日'],
    },
    Decomposition {
        kanji: '昆',
        radicals: &['日', '比'],
    },
    Decomposition {
        kanji: '根',
        radicals: &['艮', '木'],
    },
    Decomposition {
        kanji: '梱',
        radicals: &['木', '囗'],
    },
    Decomposition {
        kanji: '混',
        radicals: &['⺡', '日', '比'],
    },
    Decomposition {
        kanji: '痕',
        radicals: &['艮', '⽧'],
    },
    Decomposition {
        kanji: '紺',
        radicals: &['甘', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '艮',
        radicals: &['艮'],
    },
    Decomposition {
        kanji: '魂',
        radicals: &['鬼', '田', '二', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '些',
        radicals: &['止', '二', '匕'],
    },
    Decomposition {
        kanji: '佐',
        radicals: &['ノ', '一', '⺅', '工'],
    },
    Decomposition {
        kanji: '叉',
        radicals: &['又', '丶'],
    },
    Decomposition {
        kanji: '唆',
        radicals: &['口', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '嵯',
        radicals: &['ノ', '王', '工', '山', '丷', '羊'],
    },
    Decomposition {
        kanji: '左',
        radicals: &['ノ', '一', '工'],
    },
    Decomposition {
        kanji: '差',
        radicals: &['ノ', '王', '工', '丷', '羊'],
    },
    Decomposition {
        kanji: '査',
        radicals: &['一', '木', '目'],
    },
    Decomposition {
        kanji: '沙',
        radicals: &['ノ', '⺡', '小'],
    },
    Decomposition {
        kanji: '瑳',
        radicals: &['ノ', '王', '工', '丷', '羊'],
    },
    Decomposition {
        kanji: '砂',
        radicals: &['ノ', '口', '小', '石'],
    },
    Decomposition {
        kanji: '詐',
        radicals: &['｜', 'ノ', '言'],
    },
    Decomposition {
        kanji: '鎖',
        radicals: &['貝', '目', 'ハ', '金', '⺌'],
    },
    Decomposition {
        kanji: '裟',
        radicals: &['ノ', '衣', '⺡', '小', '亠'],
    },
    Decomposition {
        kanji: '坐',
        radicals: &['｜', '土', '人'],
    },
    Decomposition {
        kanji: '座',
        radicals: &['｜', '土', '人', '广'],
    },
    Decomposition {
        kanji: '挫',
        radicals: &['｜', '土', '人', '扌'],
    },
    Decomposition {
        kanji: '債',
        radicals: &['⺅', '貝', '目', 'ハ', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '催',
        radicals: &['⺅', '山', '隹'],
    },
    Decomposition {
        kanji: '再',
        radicals: &['｜', '一', '冂', '王'],
    },
    Decomposition {
        kanji: '最',
        radicals: &['一', '耳', '日', '又'],
    },
    Decomposition {
        kanji: '哉',
        radicals: &['口', '土', '戈'],
    },
    Decomposition {
        kanji: '塞',
        radicals: &['一', '土', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '妻',
        radicals: &['｜', 'ヨ', '一', '女'],
    },
    Decomposition {
        kanji: '宰',
        radicals: &['十', '辛', '立', '宀'],
    },
    Decomposition {
        kanji: '彩',
        radicals: &['爪', '木', '彡'],
    },
    Decomposition {
        kanji: '才',
        radicals: &['ノ', '一', '亅'],
    },
    Decomposition {
        kanji: '採',
        radicals: &['爪', '木', '扌'],
    },
    Decomposition {
        kanji: '栽',
        radicals: &['土', '木', '戈'],
    },
    Decomposition {
        kanji: '歳',
        radicals: &['ノ', '止', '小', '戈'],
    },
    Decomposition {
        kanji: '済',
        radicals: &['｜', 'ノ', '⺡', '文', '廾', '斉'],
    },
    Decomposition {
        kanji: '災',
        radicals: &['火', '巛'],
    },
    Decomposition {
        kanji: '采',
        radicals: &['爪', '木'],
    },
    Decomposition {
        kanji: '犀',
        radicals: &['尸', '｜', '二', '十', 'ノ', '一'],
    },
    Decomposition {
        kanji: '砕',
        radicals: &['ノ', '口', '十', '石', '九'],
    },
    Decomposition {
        kanji: '砦',
        radicals: &['口', '止', '石', '匕'],
    },
    Decomposition {
        kanji: '祭',
        radicals: &['示', '二', '小', '𠆢', '癶'],
    },
    Decomposition {
        kanji: '斎',
        radicals: &['｜', 'ノ', '文', '廾', '斉', '示', '二', '小'],
    },
    Decomposition {
        kanji: '細',
        radicals: &['糸', '幺', '小', '田'],
    },
    Decomposition {
        kanji: '菜',
        radicals: &['爪', '木', '⺾'],
    },
    Decomposition {
        kanji: '裁',
        radicals: &['土', '亠', '厶', '戈', '衣'],
    },
    Decomposition {
        kanji: '載',
        radicals: &['車', '土', '戈'],
    },
    Decomposition {
        kanji: '際',
        radicals: &['ノ', '示', '二', '小', '癶', '⻖'],
    },
    Decomposition {
        kanji: '剤',
        radicals: &['｜', 'ノ', '⺉', '文', '廾', '斉'],
    },
    Decomposition {
        kanji: '在',
        radicals: &['｜', 'ノ', '一', '土'],
    },
    Decomposition {
        kanji: '材',
        radicals: &['ノ', '一', '木', '亅'],
    },
    Decomposition {
        kanji: '罪',
        radicals: &['⺲', '非'],
    },
    Decomposition {
        kanji: '財',
        radicals: &['ノ', '一', '貝', '目', 'ハ', '亅'],
    },
    Decomposition {
        kanji: '冴',
        radicals: &['牙', '冫'],
    },
    Decomposition {
        kanji: '坂',
        radicals: &['土', '又', '厂'],
    },
    Decomposition {
        kanji: '阪',
        radicals: &['又', '厂', '⻖'],
    },
    Decomposition {
        kanji: '堺',
        radicals: &['田', '土', 'ハ', '儿'],
    },
    Decomposition {
        kanji: '榊',
        radicals: &['｜', '日', '木', '⺭', '田'],
    },
    Decomposition {
        kanji: '肴',
        radicals: &['ノ', '一', '月', '丶'],
    },
    Decomposition {
        kanji: '咲',
        radicals: &['口', '人', '大', '二', '丷', '一'],
    },
    Decomposition {
        kanji: '崎',
        radicals: &['口', '山', '大', '｜', '一'],
    },
    Decomposition {
        kanji: '埼',
        radicals: &['口', '大', '土', '｜', '一'],
    },
    Decomposition {
        kanji: '碕',
        radicals: &['口', '石', '大', '｜', '一'],
    },
    Decomposition {
        kanji: '鷺',
        radicals: &['口', '足', '鳥', '夂', '⺣', '止'],
    },
    Decomposition {
        kanji: '作',
        radicals: &['｜', 'ノ', '⺅', '一', '𠂉'],
    },
    Decomposition {
        kanji: '削',
        radicals: &['⺉', '月', '⺌'],
    },
    Decomposition {
        kanji: '咋',
        radicals: &['｜', 'ノ', '口'],
    },
    Decomposition {
        kanji: '搾',
        radicals: &['｜', 'ノ', '穴', '儿', '宀', '扌'],
    },
    Decomposition {
        kanji: '昨',
        radicals: &['｜', 'ノ', '日'],
    },
    Decomposition {
        kanji: '朔',
        radicals: &['月', '丷', '屮'],
    },
    Decomposition {
        kanji: '柵',
        radicals: &['｜', '一', '木', '亅', '冂', '冊', '廾'],
    },
    Decomposition {
        kanji: '窄',
        radicals: &['｜', 'ノ', '穴', '儿', '宀'],
    },
    Decomposition {
        kanji: '策',
        radicals: &['｜', '巾', '竹', 'ハ', '木', '亅', '冂', '𠂉'],
    },
    Decomposition {
        kanji: '索',
        radicals: &['糸', '幺', '小', '十', '冖'],
    },
    Decomposition {
        kanji: '錯',
        radicals: &['金', '日', '廾', '二'],
    },
    Decomposition {
        kanji: '桜',
        radicals: &['女', '⺌', '木'],
    },
    Decomposition {
        kanji: '鮭',
        radicals: &['魚', '田', '土', '⺣'],
    },
    Decomposition {
        kanji: '笹',
        radicals: &['世', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '匙',
        radicals: &['日', '匕', '疋'],
    },
    Decomposition {
        kanji: '冊',
        radicals: &['｜', '一', '亅', '冂', '廾', '冊'],
    },
    Decomposition {
        kanji: '刷',
        radicals: &['⺉', '巾', '尸'],
    },
    Decomposition {
        kanji: '察',
        radicals: &['ノ', '示', '二', '小', '宀', '癶'],
    },
    Decomposition {
        kanji: '拶',
        radicals: &['巛', '夕', '扌'],
    },
    Decomposition {
        kanji: '撮',
        radicals: &['耳', '日', '又', '扌'],
    },
    Decomposition {
        kanji: '擦',
        radicals: &['ノ', '示', '二', '小', '宀', '扌', '癶'],
    },
    Decomposition {
        kanji: '札',
        radicals: &['乙', '木'],
    },
    Decomposition {
        kanji: '殺',
        radicals: &['木', '殳', 'ノ', '丶', '几', '又'],
    },
    Decomposition {
        kanji: '薩',
        radicals: &['ノ', '生', '丷', '立', '亠', '厂', '⺾', '⻖'],
    },
    Decomposition {
        kanji: '雑',
        radicals: &['木', '隹', '九'],
    },
    Decomposition {
        kanji: '皐',
        radicals: &['十', '白', '二'],
    },
    Decomposition {
        kanji: '鯖',
        radicals: &['魚', '月', '青', '田', '土', '二', '亠', '⺣'],
    },
    Decomposition {
        kanji: '捌',
        radicals: &['⺉', '口', '力', '扌', '勹'],
    },
    Decomposition {
        kanji: '錆',
        radicals: &['金', '月', '青', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '鮫',
        radicals: &['魚', '田', '父', '亠', '⺣'],
    },
    Decomposition {
        kanji: '皿',
        radicals: &['皿'],
    },
    Decomposition {
        kanji: '晒',
        radicals: &['西', '日'],
    },
    Decomposition {
        kanji: '三',
        radicals: &['一', '二'],
    },
    Decomposition {
        kanji: '傘',
        radicals: &['十', '人', '𠆢'],
    },
    Decomposition {
        kanji: '参',
        radicals: &['一', '厶', '彡'],
    },
    Decomposition {
        kanji: '山',
        radicals: &['山'],
    },
    Decomposition {
        kanji: '惨',
        radicals: &['一', '⺖', '厶', '彡'],
    },
    Decomposition {
        kanji: '撒',
        radicals: &['｜', '月', '夂', '扌', '攵', '廾', '二', '𠂉'],
    },
    Decomposition {
        kanji: '散',
        radicals: &['月', '攵', '廾', '二', '𠂉'],
    },
    Decomposition {
        kanji: '桟',
        radicals: &['木', '戈', '二'],
    },
    Decomposition {
        kanji: '燦',
        radicals: &['火', '米', '又', '夕'],
    },
    Decomposition {
        kanji: '珊',
        radicals: &['｜', '一', '王', '亅', '冂', '冊', '廾'],
    },
    Decomposition {
        kanji: '産',
        radicals: &['ノ', '生', '丷', '立', '亠', '厂'],
    },
    Decomposition {
        kanji: '算',
        radicals: &['竹', '目', '廾', '𠂉'],
    },
    Decomposition {
        kanji: '纂',
        radicals: &['糸', '幺', '小', '竹', '目', '𠂉'],
    },
    Decomposition {
        kanji: '蚕',
        radicals: &['一', '大', '虫', '二'],
    },
    Decomposition {
        kanji: '讃',
        radicals: &['貝', '目', 'ハ', '言', '人', '大', '二', '亠'],
    },
    Decomposition {
        kanji: '賛',
        radicals: &['貝', '目', 'ハ', '人', '大', '二', '亠'],
    },
    Decomposition {
        kanji: '酸',
        radicals: &['酉', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '餐',
        radicals: &['食', '又', '夕'],
    },
    Decomposition {
        kanji: '斬',
        radicals: &['斤', '車'],
    },
    Decomposition {
        kanji: '暫',
        radicals: &['斤', '車', '日'],
    },
    Decomposition {
        kanji: '残',
        radicals: &['歹', '戈', '二'],
    },
    Decomposition {
        kanji: '仕',
        radicals: &['⺅', '士'],
    },
    Decomposition {
        kanji: '仔',
        radicals: &['⺅', '子'],
    },
    Decomposition {
        kanji: '伺',
        radicals: &['⺅', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '使',
        radicals: &['ノ', '一', '⺅', '口'],
    },
    Decomposition {
        kanji: '刺',
        radicals: &['⺉', '巾', 'ハ', '木', '亅', '冂'],
    },
    Decomposition {
        kanji: '司',
        radicals: &['一', '口', '亅'],
    },
    Decomposition {
        kanji: '史',
        radicals: &['ノ', '口'],
    },
    Decomposition {
        kanji: '嗣',
        radicals: &['｜', '一', '口', '亅', '冂'],
    },
    Decomposition {
        kanji: '四',
        radicals: &['儿', '囗'],
    },
    Decomposition {
        kanji: '士',
        radicals: &['士'],
    },
    Decomposition {
        kanji: '始',
        radicals: &['口', '女', '厶'],
    },
    Decomposition {
        kanji: '姉',
        radicals: &['巾', '女', '亠'],
    },
    Decomposition {
        kanji: '姿',
        radicals: &['欠', '女', '冫'],
    },
    Decomposition {
        kanji: '子',
        radicals: &['子'],
    },
    Decomposition {
        kanji: '屍',
        radicals: &['一', '夕', '匕', '尸', '歹'],
    },
    Decomposition {
        kanji: '市',
        radicals: &['巾', '亠'],
    },
    Decomposition {
        kanji: '師',
        radicals: &['｜', '一', '巾', '口'],
    },
    Decomposition {
        kanji: '志',
        radicals: &['士', '心'],
    },
    Decomposition {
        kanji: '思',
        radicals: &['心', '田'],
    },
    Decomposition {
        kanji: '指',
        radicals: &['日', '匕', '扌'],
    },
    Decomposition {
        kanji: '支',
        radicals: &['支', '十', '又'],
    },
    Decomposition {
        kanji: '孜',
        radicals: &['子', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '斯',
        radicals: &['甘', '斤', 'ハ'],
    },
    Decomposition {
        kanji: '施',
        radicals: &['ノ', '方', '一', '也', '𠂉'],
    },
    Decomposition {
        kanji: '旨',
        radicals: &['日', '匕'],
    },
    Decomposition {
        kanji: '枝',
        radicals: &['支', '木', '十', '又'],
    },
    Decomposition {
        kanji: '止',
        radicals: &['止'],
    },
    Decomposition {
        kanji: '死',
        radicals: &['一', '夕', '匕', '歹'],
    },
    Decomposition {
        kanji: '氏',
        radicals: &['氏'],
    },
    Decomposition {
        kanji: '獅',
        radicals: &['｜', '巾', '口', '⺨'],
    },
    Decomposition {
        kanji: '祉',
        radicals: &['止', '⺭'],
    },
    Decomposition {
        kanji: '私',
        radicals: &['禾', '厶'],
    },
    Decomposition {
        kanji: '糸',
        radicals: &['糸', '幺', '小'],
    },
    Decomposition {
        kanji: '紙',
        radicals: &['氏', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '紫',
        radicals: &['止', '糸', '幺', '小', '匕'],
    },
    Decomposition {
        kanji: '肢',
        radicals: &['月', '支', '十', '又'],
    },
    Decomposition {
        kanji: '脂',
        radicals: &['月', '日', '匕'],
    },
    Decomposition {
        kanji: '至',
        radicals: &['一', '至', '土', '厶'],
    },
    Decomposition {
        kanji: '視',
        radicals: &['見', '⺭'],
    },
    Decomposition {
        kanji: '詞',
        radicals: &['言', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '詩',
        radicals: &['言', '寸', '土'],
    },
    Decomposition {
        kanji: '試',
        radicals: &['言', '工', '弋'],
    },
    Decomposition {
        kanji: '誌',
        radicals: &['言', '士', '心'],
    },
    Decomposition {
        kanji: '諮',
        radicals: &['欠', '言', '口', '冫'],
    },
    Decomposition {
        kanji: '資',
        radicals: &['貝', '目', 'ハ', '欠', '冫'],
    },
    Decomposition {
        kanji: '賜',
        radicals: &['勿', '貝', '目', 'ハ', '日', '勿'],
    },
    Decomposition {
        kanji: '雌',
        radicals: &['止', '匕', '隹'],
    },
    Decomposition {
        kanji: '飼',
        radicals: &['口', '艮', '亅', '𠆢', '食'],
    },
    Decomposition {
        kanji: '歯',
        radicals: &['止', '歯', '米', '凵'],
    },
    Decomposition {
        kanji: '事',
        radicals: &['一', '口', '亅', 'ヨ'],
    },
    Decomposition {
        kanji: '似',
        radicals: &['⺅', '人', '丶'],
    },
    Decomposition {
        kanji: '侍',
        radicals: &['⺅', '寸', '土'],
    },
    Decomposition {
        kanji: '児',
        radicals: &['｜', '日', '儿'],
    },
    Decomposition {
        kanji: '字',
        radicals: &['子', '宀'],
    },
    Decomposition {
        kanji: '寺',
        radicals: &['寸', '土'],
    },
    Decomposition {
        kanji: '慈',
        radicals: &['一', '心', '丷', '幺'],
    },
    Decomposition {
        kanji: '持',
        radicals: &['寸', '土', '扌'],
    },
    Decomposition {
        kanji: '時',
        radicals: &['寸', '土', '日'],
    },
    Decomposition {
        kanji: '次',
        radicals: &['欠', '冫'],
    },
    Decomposition {
        kanji: '滋',
        radicals: &['一', '⺡', '丷', '幺'],
    },
    Decomposition {
        kanji: '治',
        radicals: &['口', '⺡', '厶'],
    },
    Decomposition {
        kanji: '爾',
        radicals: &['｜', '一', 'ハ', '冂', '爻'],
    },
    Decomposition {
        kanji: '璽',
        radicals: &['｜', '一', '王', 'ハ', '冂', '爻'],
    },
    Decomposition {
        kanji: '痔',
        radicals: &['寸', '土', '⽧'],
    },
    Decomposition {
        kanji: '磁',
        radicals: &['一', '口', '石', '丷', '幺'],
    },
    Decomposition {
        kanji: '示',
        radicals: &['示', '二', '小'],
    },
    Decomposition {
        kanji: '而',
        radicals: &['而'],
    },
    Decomposition {
        kanji: '耳',
        radicals: &['耳'],
    },
    Decomposition {
        kanji: '自',
        radicals: &['自', '目'],
    },
    Decomposition {
        kanji: '蒔',
        radicals: &['寸', '土', '日', '⺾'],
    },
    Decomposition {
        kanji: '辞',
        radicals: &['口', '十', '辛', '舌', '立'],
    },
    Decomposition {
        kanji: '汐',
        radicals: &['⺡', '夕'],
    },
    Decomposition {
        kanji: '鹿',
        radicals: &['鹿', '比', '广'],
    },
    Decomposition {
        kanji: '式',
        radicals: &['工', '弋'],
    },
    Decomposition {
        kanji: '識',
        radicals: &['音', '言', '日', '立', '戈'],
    },
    Decomposition {
        kanji: '鴫',
        radicals: &['鳥', '田', '⺣'],
    },
    Decomposition {
        kanji: '竺',
        radicals: &['竹', '二', '𠂉'],
    },
    Decomposition {
        kanji: '軸',
        radicals: &['｜', '車', '日', '田'],
    },
    Decomposition {
        kanji: '宍',
        radicals: &['ハ', '亠', '宀'],
    },
    Decomposition {
        kanji: '雫',
        radicals: &['雨', '丶', '一', '｜'],
    },
    Decomposition {
        kanji: '七',
        radicals: &['乙', '匕', 'ノ'],
    },
    Decomposition {
        kanji: '叱',
        radicals: &['口', '匕'],
    },
    Decomposition {
        kanji: '執',
        radicals: &['ノ', '九', '十', '辛', '土', '立', '丶', '亠'],
    },
    Decomposition {
        kanji: '失',
        radicals: &['ノ', '人', '二', '大'],
    },
    Decomposition {
        kanji: '嫉',
        radicals: &['女', '矢', '⽧', '𠂉'],
    },
    Decomposition {
        kanji: '室',
        radicals: &['至', '土', '厶', '宀'],
    },
    Decomposition {
        kanji: '悉',
        radicals: &['ノ', '心', '釆', '米'],
    },
    Decomposition {
        kanji: '湿',
        radicals: &['｜', '⺡', '日'],
    },
    Decomposition {
        kanji: '漆',
        radicals: &['⺡', '水', '木', '𠆢'],
    },
    Decomposition {
        kanji: '疾',
        radicals: &['矢', '⽧', '𠂉'],
    },
    Decomposition {
        kanji: '質',
        radicals: &['貝', '目', 'ハ', '斤'],
    },
    Decomposition {
        kanji: '実',
        radicals: &['士', '大', '宀'],
    },
    Decomposition {
        kanji: '蔀',
        radicals: &['口', '⻏', '立', '⺾'],
    },
    Decomposition {
        kanji: '篠',
        radicals: &['｜', '⺅', '竹', '木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '偲',
        radicals: &['⺅', '心', '田'],
    },
    Decomposition {
        kanji: '柴',
        radicals: &['止', '木', '匕'],
    },
    Decomposition {
        kanji: '芝',
        radicals: &['亠', '⺾'],
    },
    Decomposition {
        kanji: '屡',
        radicals: &['女', '米', '尸'],
    },
    Decomposition {
        kanji: '蕊',
        radicals: &['心', '⺾'],
    },
    Decomposition {
        kanji: '縞',
        radicals: &['口', '高', '糸', '幺', '小', '亠', '冂'],
    },
    Decomposition {
        kanji: '舎',
        radicals: &['口', '土', '𠆢'],
    },
    Decomposition {
        kanji: '写',
        radicals: &['一', '冖', '勹'],
    },
    Decomposition {
        kanji: '射',
        radicals: &['身', '寸'],
    },
    Decomposition {
        kanji: '捨',
        radicals: &['口', '土', '𠆢', '扌'],
    },
    Decomposition {
        kanji: '赦',
        radicals: &['赤', '土', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '斜',
        radicals: &['禾', '斗', '𠆢', '一'],
    },
    Decomposition {
        kanji: '煮',
        radicals: &['日', '⺹', '⺣'],
    },
    Decomposition {
        kanji: '社',
        radicals: &['土', '⺭'],
    },
    Decomposition {
        kanji: '紗',
        radicals: &['ノ', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '者',
        radicals: &['日', '⺹'],
    },
    Decomposition {
        kanji: '謝',
        radicals: &['言', '身', '寸'],
    },
    Decomposition {
        kanji: '車',
        radicals: &['車'],
    },
    Decomposition {
        kanji: '遮',
        radicals: &['一', '⻌', '广', '⺣'],
    },
    Decomposition {
        kanji: '蛇',
        radicals: &['虫', '匕', '宀'],
    },
    Decomposition {
        kanji: '邪',
        radicals: &['牙', '⻏'],
    },
    Decomposition {
        kanji: '借',
        radicals: &['⺅', '日', '廾', '二'],
    },
    Decomposition {
        kanji: '勺',
        radicals: &['丶', '勹'],
    },
    Decomposition {
        kanji: '尺',
        radicals: &['尸', '丶'],
    },
    Decomposition {
        kanji: '杓',
        radicals: &['木', '丶', '勹'],
    },
    Decomposition {
        kanji: '灼',
        radicals: &['火', '丶', '勹'],
    },
    Decomposition {
        kanji: '爵',
        radicals: &['艮', '寸', '爪', '⺲'],
    },
    Decomposition {
        kanji: '酌',
        radicals: &['酉', '丶', '勹'],
    },
    Decomposition {
        kanji: '釈',
        radicals: &['釆', '米', '尸', '丶'],
    },
    Decomposition {
        kanji: '錫',
        radicals: &['金', '日', '勿', '勿'],
    },
    Decomposition {
        kanji: '若',
        radicals: &['ノ', '一', '口', '⺾'],
    },
    Decomposition {
        kanji: '寂',
        radicals: &['小', '卜', '又', '宀'],
    },
    Decomposition {
        kanji: '弱',
        radicals: &['弓', '冫'],
    },
    Decomposition {
        kanji: '惹',
        radicals: &['ノ', '一', '口', '心', '⺾'],
    },
    Decomposition {
        kanji: '主',
        radicals: &['王', '丶'],
    },
    Decomposition {
        kanji: '取',
        radicals: &['耳', '又'],
    },
    Decomposition {
        kanji: '守',
        radicals: &['寸', '宀'],
    },
    Decomposition {
        kanji: '手',
        radicals: &['手'],
    },
    Decomposition {
        kanji: '朱',
        radicals: &['｜', 'ノ', '牛', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '殊',
        radicals: &['｜', 'ノ', '牛', '二', 'ハ', '木', '歹'],
    },
    Decomposition {
        kanji: '狩',
        radicals: &['寸', '⺨', '宀'],
    },
    Decomposition {
        kanji: '珠',
        radicals: &['｜', 'ノ', '王', '牛', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '種',
        radicals: &['｜', '禾', '日', '里', 'ノ'],
    },
    Decomposition {
        kanji: '腫',
        radicals: &['｜', '月', '日', '里', 'ノ'],
    },
    Decomposition {
        kanji: '趣',
        radicals: &['耳', '走', '土', '又'],
    },
    Decomposition {
        kanji: '酒',
        radicals: &['⺡', '酉'],
    },
    Decomposition {
        kanji: '首',
        radicals: &['自', '首', '丷', '目'],
    },
    Decomposition {
        kanji: '儒',
        radicals: &['雨', '⺅', '而'],
    },
    Decomposition {
        kanji: '受',
        radicals: &['爪', '又', '冖'],
    },
    Decomposition {
        kanji: '呪',
        radicals: &['口', '儿'],
    },
    Decomposition {
        kanji: '寿',
        radicals: &['ノ', '一', '寸', '二'],
    },
    Decomposition {
        kanji: '授',
        radicals: &['爪', '又', '冖', '扌'],
    },
    Decomposition {
        kanji: '樹',
        radicals: &['口', '寸', '土', '豆', '丷', '木'],
    },
    Decomposition {
        kanji: '綬',
        radicals: &['糸', '幺', '小', '爪', '又', '冖'],
    },
    Decomposition {
        kanji: '需',
        radicals: &['雨', '而'],
    },
    Decomposition {
        kanji: '囚',
        radicals: &['人', '囗'],
    },
    Decomposition {
        kanji: '収',
        radicals: &['｜', '又'],
    },
    Decomposition {
        kanji: '周',
        radicals: &['口', '土', '冂'],
    },
    Decomposition {
        kanji: '宗',
        radicals: &['示', '二', '小', '宀'],
    },
    Decomposition {
        kanji: '就',
        radicals: &['口', '小', '丶', '亠', '尤', '尢'],
    },
    Decomposition {
        kanji: '州',
        radicals: &['｜', '川', '丶'],
    },
    Decomposition {
        kanji: '修',
        radicals: &['｜', '⺅', '彡', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '愁',
        radicals: &['火', '禾', '心'],
    },
    Decomposition {
        kanji: '拾',
        radicals: &['口', '𠆢', '扌', '一'],
    },
    Decomposition {
        kanji: '洲',
        radicals: &['｜', '⺡', '川', '丶'],
    },
    Decomposition {
        kanji: '秀',
        radicals: &['乃', '禾', 'ノ'],
    },
    Decomposition {
        kanji: '秋',
        radicals: &['火', '禾'],
    },
    Decomposition {
        kanji: '終',
        radicals: &['糸', '幺', '小', '夂'],
    },
    Decomposition {
        kanji: '繍',
        radicals: &['｜', 'ノ', 'ヨ', '糸', '幺', '小', '水', '隶'],
    },
    Decomposition {
        kanji: '習',
        radicals: &['羽', '白', '冫'],
    },
    Decomposition {
        kanji: '臭',
        radicals: &['自', '大', '目'],
    },
    Decomposition {
        kanji: '舟',
        radicals: &['舟'],
    },
    Decomposition {
        kanji: '蒐',
        radicals: &['鬼', '田', '儿', '匕', '⺾', '厶'],
    },
    Decomposition {
        kanji: '衆',
        radicals: &['血', '皿', '糸'],
    },
    Decomposition {
        kanji: '襲',
        radicals: &['衣', '月', '立', '亠'],
    },
    Decomposition {
        kanji: '讐',
        radicals: &['言', '隹'],
    },
    Decomposition {
        kanji: '蹴',
        radicals: &['ノ', '乙', '口', '小', '足', '丶', '亠', '尤', '尢', '止'],
    },
    Decomposition {
        kanji: '輯',
        radicals: &['口', '耳', '車'],
    },
    Decomposition {
        kanji: '週',
        radicals: &['口', '⻌', '土', '冂'],
    },
    Decomposition {
        kanji: '酋',
        radicals: &['酉', '丷'],
    },
    Decomposition {
        kanji: '酬',
        radicals: &['｜', '川', '酉', '丶'],
    },
    Decomposition {
        kanji: '集',
        radicals: &['木', '隹'],
    },
    Decomposition {
        kanji: '醜',
        radicals: &['鬼', '田', '酉', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '什',
        radicals: &['⺅', '十'],
    },
    Decomposition {
        kanji: '住',
        radicals: &['王', '⺅', '丶'],
    },
    Decomposition {
        kanji: '充',
        radicals: &['亠', '儿', '厶'],
    },
    Decomposition {
        kanji: '十',
        radicals: &['十'],
    },
    Decomposition {
        kanji: '従',
        radicals: &['丷', '疋', '彳'],
    },
    Decomposition {
        kanji: '戎',
        radicals: &['戈'],
    },
    Decomposition {
        kanji: '柔',
        radicals: &['矛', '木', 'マ'],
    },
    Decomposition {
        kanji: '汁',
        radicals: &['十', '⺡'],
    },
    Decomposition {
        kanji: '渋',
        radicals: &['止', '⺡', '冫'],
    },
    Decomposition {
        kanji: '獣',
        radicals: &['犬', '口', '⺌', '田'],
    },
    Decomposition {
        kanji: '縦',
        radicals: &['糸', '幺', '小', '丷', '疋', '彳'],
    },
    Decomposition {
        kanji: '重',
        radicals: &['｜', 'ノ', '一', '日', '里'],
    },
    Decomposition {
        kanji: '銃',
        radicals: &['金', '亠', '儿', '厶'],
    },
    Decomposition {
        kanji: '叔',
        radicals: &['小', '卜', '又'],
    },
    Decomposition {
        kanji: '夙',
        radicals: &['几', '歹'],
    },
    Decomposition {
        kanji: '宿',
        radicals: &['⺅', '白', '宀'],
    },
    Decomposition {
        kanji: '淑',
        radicals: &['⺡', '小', '卜', '又'],
    },
    Decomposition {
        kanji: '祝',
        radicals: &['口', '⺭', '儿'],
    },
    Decomposition {
        kanji: '縮',
        radicals: &['⺅', '糸', '幺', '小', '白', '宀'],
    },
    Decomposition {
        kanji: '粛',
        radicals: &['｜', 'ノ', 'ヨ', '米', '隶'],
    },
    Decomposition {
        kanji: '塾',
        radicals: &['丶', '九', '口', '子', '土', '亠'],
    },
    Decomposition {
        kanji: '熟',
        radicals: &['丶', '九', '口', '子', '亠', '⺣'],
    },
    Decomposition {
        kanji: '出',
        radicals: &['｜', '山'],
    },
    Decomposition {
        kanji: '術',
        radicals: &['行', '十', '丶', '彳', '木'],
    },
    Decomposition {
        kanji: '述',
        radicals: &['⻌', '十', '丶', '木'],
    },
    Decomposition {
        kanji: '俊',
        radicals: &['⺅', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '峻',
        radicals: &['山', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '春',
        radicals: &['一', '二', '日', '人', '大'],
    },
    Decomposition {
        kanji: '瞬',
        radicals: &['牛', '舛', '爪', '目', '夕', '冖'],
    },
    Decomposition {
        kanji: '竣',
        radicals: &['立', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '舜',
        radicals: &['牛', '舛', '爪', '夕', '冖'],
    },
    Decomposition {
        kanji: '駿',
        radicals: &['馬', '儿', '厶', '夂', '⺣'],
    },
    Decomposition {
        kanji: '准',
        radicals: &['冫', '隹'],
    },
    Decomposition {
        kanji: '循',
        radicals: &['斤', '十', '目', '厂', '彳'],
    },
    Decomposition {
        kanji: '旬',
        radicals: &['日', '勹'],
    },
    Decomposition {
        kanji: '楯',
        radicals: &['斤', '十', '木', '目', '厂'],
    },
    Decomposition {
        kanji: '殉',
        radicals: &['日', '勹', '歹'],
    },
    Decomposition {
        kanji: '淳',
        radicals: &['口', '子', '⺡', '亠'],
    },
    Decomposition {
        kanji: '準',
        radicals: &['十', '⺡', '隹'],
    },
    Decomposition {
        kanji: '潤',
        radicals: &['王', '⺡', '門'],
    },
    Decomposition {
        kanji: '盾',
        radicals: &['斤', '十', '目', '厂'],
    },
    Decomposition {
        kanji: '純',
        radicals: &['糸', '幺', '小', '屯'],
    },
    Decomposition {
        kanji: '巡',
        radicals: &['⻌', '巛'],
    },
    Decomposition {
        kanji: '遵',
        radicals: &['⻌', '寸', '酉', '丷'],
    },
    Decomposition {
        kanji: '醇',
        radicals: &['口', '子', '酉', '亠'],
    },
    Decomposition {
        kanji: '順',
        radicals: &['貝', '目', 'ハ', '川', '頁'],
    },
    Decomposition {
        kanji: '処',
        radicals: &['几', '夂', '攵'],
    },
    Decomposition {
        kanji: '初',
        radicals: &['⻂', '刀'],
    },
    Decomposition {
        kanji: '所',
        radicals: &['斤', '戸', '一', '尸'],
    },
    Decomposition {
        kanji: '暑',
        radicals: &['日', '⺹'],
    },
    Decomposition {
        kanji: '曙',
        radicals: &['日', '⺲', '⺹'],
    },
    Decomposition {
        kanji: '渚',
        radicals: &['⺡', '日', '⺹'],
    },
    Decomposition {
        kanji: '庶',
        radicals: &['广', '⺣'],
    },
    Decomposition {
        kanji: '緒',
        radicals: &['糸', '幺', '小', '日', '⺹'],
    },
    Decomposition {
        kanji: '署',
        radicals: &['日', '⺲', '⺹'],
    },
    Decomposition {
        kanji: '書',
        radicals: &['日', '聿'],
    },
    Decomposition {
        kanji: '薯',
        radicals: &['日', '⺲', '⺹', '⺾'],
    },
    Decomposition {
        kanji: '藷',
        radicals: &['言', '日', '⺹', '⺾'],
    },
    Decomposition {
        kanji: '諸',
        radicals: &['言', '日', '⺹'],
    },
    Decomposition {
        kanji: '助',
        radicals: &['目', '力'],
    },
    Decomposition {
        kanji: '叙',
        radicals: &['禾', '又', '𠆢', '一'],
    },
    Decomposition {
        kanji: '女',
        radicals: &['女'],
    },
    Decomposition {
        kanji: '序',
        radicals: &['子', '广', '亅', 'マ', '一'],
    },
    Decomposition {
        kanji: '徐',
        radicals: &['禾', '𠆢', '彳', '一'],
    },
    Decomposition {
        kanji: '恕',
        radicals: &['口', '女', '心'],
    },
    Decomposition {
        kanji: '鋤',
        radicals: &['金', '目', '力'],
    },
    Decomposition {
        kanji: '除',
        radicals: &['示', '𠆢', '⻖', '一'],
    },
    Decomposition {
        kanji: '傷',
        radicals: &['ノ', '⺅', '日', '勿', '一', '人', '勹', '𠂉'],
    },
    Decomposition {
        kanji: '償',
        radicals: &['⺅', '貝', '目', 'ハ', '口', '⺌', '冖'],
    },
    Decomposition {
        kanji: '勝',
        radicals: &['月', '人', '大', '二', '丷', '力'],
    },
    Decomposition {
        kanji: '匠',
        radicals: &['斤', '匚'],
    },
    Decomposition {
        kanji: '升',
        radicals: &['ノ', '廾', '十'],
    },
    Decomposition {
        kanji: '召',
        radicals: &['口', '刀'],
    },
    Decomposition {
        kanji: '哨',
        radicals: &['月', '口', '⺌'],
    },
    Decomposition {
        kanji: '商',
        radicals: &['口', '丷', '立', '亠', '儿', '冂'],
    },
    Decomposition {
        kanji: '唱',
        radicals: &['口', '日'],
    },
    Decomposition {
        kanji: '嘗',
        radicals: &['口', '⺌', '日', '冖', '匕'],
    },
    Decomposition {
        kanji: '奨',
        radicals: &['寸', '大', '爪', '爿'],
    },
    Decomposition {
        kanji: '妾',
        radicals: &['女', '立'],
    },
    Decomposition {
        kanji: '娼',
        radicals: &['女', '日'],
    },
    Decomposition {
        kanji: '宵',
        radicals: &['月', '⺌', '宀'],
    },
    Decomposition {
        kanji: '将',
        radicals: &['寸', '爪', '爿'],
    },
    Decomposition {
        kanji: '小',
        radicals: &['小'],
    },
    Decomposition {
        kanji: '少',
        radicals: &['ノ', '小'],
    },
    Decomposition {
        kanji: '尚',
        radicals: &['口', '⺌', '冂'],
    },
    Decomposition {
        kanji: '庄',
        radicals: &['土', '广'],
    },
    Decomposition {
        kanji: '床',
        radicals: &['木', '广'],
    },
    Decomposition {
        kanji: '廠',
        radicals: &['口', '⺌', '冂', '广', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '彰',
        radicals: &['音', '十', '日', '立', '彡'],
    },
    Decomposition {
        kanji: '承',
        radicals: &['ノ', '二', '亅', '手'],
    },
    Decomposition {
        kanji: '抄',
        radicals: &['ノ', '小', '扌'],
    },
    Decomposition {
        kanji: '招',
        radicals: &['口', '刀', '扌'],
    },
    Decomposition {
        kanji: '掌',
        radicals: &['口', '手', '⺌', '冖'],
    },
    Decomposition {
        kanji: '捷',
        radicals: &['疋', '扌', 'ヨ'],
    },
    Decomposition {
        kanji: '昇',
        radicals: &['ノ', '日', '廾', '十'],
    },
    Decomposition {
        kanji: '昌',
        radicals: &['日'],
    },
    Decomposition {
        kanji: '昭',
        radicals: &['口', '刀', '日'],
    },
    Decomposition {
        kanji: '晶',
        radicals: &['日'],
    },
    Decomposition {
        kanji: '松',
        radicals: &['ハ', '木', '厶'],
    },
    Decomposition {
        kanji: '梢',
        radicals: &['月', '⺌', '木'],
    },
    Decomposition {
        kanji: '樟',
        radicals: &['音', '十', '日', '木', '立'],
    },
    Decomposition {
        kanji: '樵',
        radicals: &['木', '⺣', '隹'],
    },
    Decomposition {
        kanji: '沼',
        radicals: &['口', '⺡', '刀'],
    },
    Decomposition {
        kanji: '消',
        radicals: &['月', '⺡', '⺌'],
    },
    Decomposition {
        kanji: '渉',
        radicals: &['ノ', '止', '⺡', '小'],
    },
    Decomposition {
        kanji: '湘',
        radicals: &['⺡', '木', '目'],
    },
    Decomposition {
        kanji: '焼',
        radicals: &['火', '十', '儿'],
    },
    Decomposition {
        kanji: '焦',
        radicals: &['⺣', '隹'],
    },
    Decomposition {
        kanji: '照',
        radicals: &['口', '刀', '日', '⺣'],
    },
    Decomposition {
        kanji: '症',
        radicals: &['一', '止', '⽧'],
    },
    Decomposition {
        kanji: '省',
        radicals: &['ノ', '小', '目'],
    },
    Decomposition {
        kanji: '硝',
        radicals: &['月', '口', '⺌', '石'],
    },
    Decomposition {
        kanji: '礁',
        radicals: &['口', '石', '⺣', '隹'],
    },
    Decomposition {
        kanji: '祥',
        radicals: &['王', '丷', '羊', '⺭'],
    },
    Decomposition {
        kanji: '称',
        radicals: &['ノ', '禾', '小', '一', '𠂉'],
    },
    Decomposition {
        kanji: '章',
        radicals: &['音', '十', '日', '立'],
    },
    Decomposition {
        kanji: '笑',
        radicals: &['禾', '竹', '大', '𠂉'],
    },
    Decomposition {
        kanji: '粧',
        radicals: &['土', '米', '广'],
    },
    Decomposition {
        kanji: '紹',
        radicals: &['口', '糸', '幺', '小', '刀'],
    },
    Decomposition {
        kanji: '肖',
        radicals: &['月', '⺌'],
    },
    Decomposition {
        kanji: '菖',
        radicals: &['日', '⺾'],
    },
    Decomposition {
        kanji: '蒋',
        radicals: &['寸', '爪', '爿', '⺾'],
    },
    Decomposition {
        kanji: '蕉',
        radicals: &['⺣', '⺾', '隹'],
    },
    Decomposition {
        kanji: '衝',
        radicals: &['｜', '行', '日', '彳', '里', 'ノ'],
    },
    Decomposition {
        kanji: '裳',
        radicals: &['衣', '口', '⺌', '冖', '亠'],
    },
    Decomposition {
        kanji: '訟',
        radicals: &['言', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '証',
        radicals: &['一', '言', '止'],
    },
    Decomposition {
        kanji: '詔',
        radicals: &['言', '口', '刀'],
    },
    Decomposition {
        kanji: '詳',
        radicals: &['王', '言', '丷', '羊'],
    },
    Decomposition {
        kanji: '象',
        radicals: &['勹', '豕', '口', '一'],
    },
    Decomposition {
        kanji: '賞',
        radicals: &['貝', '目', 'ハ', '口', '⺌', '冖'],
    },
    Decomposition {
        kanji: '醤',
        radicals: &['寸', '爪', '酉', '爿'],
    },
    Decomposition {
        kanji: '鉦',
        radicals: &['一', '金', '止'],
    },
    Decomposition {
        kanji: '鍾',
        radicals: &['｜', '金', '日', '里', 'ノ'],
    },
    Decomposition {
        kanji: '鐘',
        radicals: &['金', '里', '立'],
    },
    Decomposition {
        kanji: '障',
        radicals: &['音', '十', '日', '立', '⻖'],
    },
    Decomposition {
        kanji: '鞘',
        radicals: &['革', '月', '⺌'],
    },
    Decomposition {
        kanji: '上',
        radicals: &['一', '卜'],
    },
    Decomposition {
        kanji: '丈',
        radicals: &['ノ', '一', '丶'],
    },
    Decomposition {
        kanji: '丞',
        radicals: &['ノ', '一', '亅'],
    },
    Decomposition {
        kanji: '乗',
        radicals: &['｜', 'ノ', '一', '禾', 'ハ'],
    },
    Decomposition {
        kanji: '冗',
        radicals: &['冖', '几'],
    },
    Decomposition {
        kanji: '剰',
        radicals: &['｜', 'ノ', '一', '⺉'],
    },
    Decomposition {
        kanji: '城',
        radicals: &['ノ', '土', '戈'],
    },
    Decomposition {
        kanji: '場',
        radicals: &['土', '日', '勿', '一', '勿'],
    },
    Decomposition {
        kanji: '壌',
        radicals: &['衣', '土', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '嬢',
        radicals: &['衣', '女', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '常',
        radicals: &['巾', '口', '⺌', '冖'],
    },
    Decomposition {
        kanji: '情',
        radicals: &['月', '青', '土', '二', '⺖', '亠'],
    },
    Decomposition {
        kanji: '擾',
        radicals: &['一', '心', '白', '冖', '夂', '扌', '自'],
    },
    Decomposition {
        kanji: '条',
        radicals: &['木', '夂', '攵'],
    },
    Decomposition {
        kanji: '杖',
        radicals: &['ノ', '一', '木'],
    },
    Decomposition {
        kanji: '浄',
        radicals: &['⺡', '亅', '勹', 'ヨ'],
    },
    Decomposition {
        kanji: '状',
        radicals: &['犬', '爿'],
    },
    Decomposition {
        kanji: '畳',
        radicals: &['一', '田', '冖'],
    },
    Decomposition {
        kanji: '穣',
        radicals: &['衣', '禾', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '蒸',
        radicals: &['ノ', '一', '亅', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '譲',
        radicals: &['衣', '言', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '醸',
        radicals: &['衣', '酉', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '錠',
        radicals: &['金', '疋', '宀'],
    },
    Decomposition {
        kanji: '嘱',
        radicals: &['口', '尸', '⽱'],
    },
    Decomposition {
        kanji: '埴',
        radicals: &['十', '土', '目'],
    },
    Decomposition {
        kanji: '飾',
        radicals: &['ノ', '巾', '食', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '拭',
        radicals: &['工', '弋', '扌'],
    },
    Decomposition {
        kanji: '植',
        radicals: &['十', '木', '目'],
    },
    Decomposition {
        kanji: '殖',
        radicals: &['十', '目', '歹'],
    },
    Decomposition {
        kanji: '燭',
        radicals: &['火', '虫', '⺲', '勹'],
    },
    Decomposition {
        kanji: '織',
        radicals: &['音', '糸', '幺', '小', '日', '立', '戈'],
    },
    Decomposition {
        kanji: '職',
        radicals: &['音', '耳', '日', '立', '戈'],
    },
    Decomposition {
        kanji: '色',
        radicals: &['色', '巴', '勹'],
    },
    Decomposition {
        kanji: '触',
        radicals: &['角', '虫'],
    },
    Decomposition {
        kanji: '食',
        radicals: &['食'],
    },
    Decomposition {
        kanji: '蝕',
        radicals: &['食', '虫'],
    },
    Decomposition {
        kanji: '辱',
        radicals: &['衣', '寸', '辰', '厂'],
    },
    Decomposition {
        kanji: '尻',
        radicals: &['九', '尸'],
    },
    Decomposition {
        kanji: '伸',
        radicals: &['｜', '⺅', '日', '田'],
    },
    Decomposition {
        kanji: '信',
        radicals: &['⺅', '言'],
    },
    Decomposition {
        kanji: '侵',
        radicals: &['ヨ', '⺅', '又', '冖'],
    },
    Decomposition {
        kanji: '唇',
        radicals: &['衣', '口', '辰', '厂'],
    },
    Decomposition {
        kanji: '娠',
        radicals: &['衣', '女', '辰', '厂'],
    },
    Decomposition {
        kanji: '寝',
        radicals: &['ヨ', '又', '冖', '宀', '爿'],
    },
    Decomposition {
        kanji: '審',
        radicals: &['田', '釆', '米', '宀'],
    },
    Decomposition {
        kanji: '心',
        radicals: &['心'],
    },
    Decomposition {
        kanji: '慎',
        radicals: &['一', '十', 'ハ', '⺖', '目'],
    },
    Decomposition {
        kanji: '振',
        radicals: &['衣', '辰', '厂', '扌'],
    },
    Decomposition {
        kanji: '新',
        radicals: &['斤', '辛', '丷', '木', '立', '亠'],
    },
    Decomposition {
        kanji: '晋',
        radicals: &['一', '日'],
    },
    Decomposition {
        kanji: '森',
        radicals: &['木'],
    },
    Decomposition {
        kanji: '榛',
        radicals: &['一', '禾', '人', '二', '木'],
    },
    Decomposition {
        kanji: '浸',
        radicals: &['ヨ', '⺡', '又', '冖'],
    },
    Decomposition {
        kanji: '深',
        radicals: &['⺡', '木', '儿', '冖'],
    },
    Decomposition {
        kanji: '申',
        radicals: &['｜', '日', '田'],
    },
    Decomposition {
        kanji: '疹',
        radicals: &['𠆢', '彡', '⽧'],
    },
    Decomposition {
        kanji: '真',
        radicals: &['一', '十', 'ハ', '目'],
    },
    Decomposition {
        kanji: '神',
        radicals: &['｜', '日', '⺭', '田'],
    },
    Decomposition {
        kanji: '秦',
        radicals: &['一', '禾', '二', '人', '大'],
    },
    Decomposition {
        kanji: '紳',
        radicals: &['｜', '糸', '幺', '小', '日', '田'],
    },
    Decomposition {
        kanji: '臣',
        radicals: &['臣', '匚'],
    },
    Decomposition {
        kanji: '芯',
        radicals: &['心', '⺾'],
    },
    Decomposition {
        kanji: '薪',
        radicals: &['斤', '辛', '丷', '木', '立', '⺾', '亠'],
    },
    Decomposition {
        kanji: '親',
        radicals: &['見', '辛', '丷', '木', '立', '亠'],
    },
    Decomposition {
        kanji: '診',
        radicals: &['言', '𠆢', '彡'],
    },
    Decomposition {
        kanji: '身',
        radicals: &['身'],
    },
    Decomposition {
        kanji: '辛',
        radicals: &['十', '辛', '立'],
    },
    Decomposition {
        kanji: '進',
        radicals: &['⻌', '隹'],
    },
    Decomposition {
        kanji: '針',
        radicals: &['金', '十'],
    },
    Decomposition {
        kanji: '震',
        radicals: &['衣', '雨', '辰', '厂'],
    },
    Decomposition {
        kanji: '人',
        radicals: &['人'],
    },
    Decomposition {
        kanji: '仁',
        radicals: &['⺅', '二'],
    },
    Decomposition {
        kanji: '刃',
        radicals: &['刀', '丶'],
    },
    Decomposition {
        kanji: '塵',
        radicals: &['鹿', '土', '比', '广'],
    },
    Decomposition {
        kanji: '壬',
        radicals: &['ノ', '士'],
    },
    Decomposition {
        kanji: '尋',
        radicals: &['ヨ', '口', '工', '寸'],
    },
    Decomposition {
        kanji: '甚',
        radicals: &['一', '甘', '儿'],
    },
    Decomposition {
        kanji: '尽',
        radicals: &['尸', '丶'],
    },
    Decomposition {
        kanji: '腎',
        radicals: &['月', '臣', '又'],
    },
    Decomposition {
        kanji: '訊',
        radicals: &['ノ', '言', '几'],
    },
    Decomposition {
        kanji: '迅',
        radicals: &['⻌', '十', '乙'],
    },
    Decomposition {
        kanji: '陣',
        radicals: &['車', '⻖'],
    },
    Decomposition {
        kanji: '靭',
        radicals: &['革', '刀', '丶'],
    },
    Decomposition {
        kanji: '笥',
        radicals: &['一', '口', '竹', '亅', '𠂉'],
    },
    Decomposition {
        kanji: '諏',
        radicals: &['言', '耳', '又'],
    },
    Decomposition {
        kanji: '須',
        radicals: &['貝', '目', 'ハ', '頁', '彡'],
    },
    Decomposition {
        kanji: '酢',
        radicals: &['｜', 'ノ', '酉'],
    },
    Decomposition {
        kanji: '図',
        radicals: &['斗', '囗'],
    },
    Decomposition {
        kanji: '厨',
        radicals: &['口', '寸', '豆', '丷', '厂'],
    },
    Decomposition {
        kanji: '逗',
        radicals: &['口', '⻌', '豆', '丷'],
    },
    Decomposition {
        kanji: '吹',
        radicals: &['欠', '口'],
    },
    Decomposition {
        kanji: '垂',
        radicals: &['｜', 'ノ', '一'],
    },
    Decomposition {
        kanji: '帥',
        radicals: &['｜', '巾', '口'],
    },
    Decomposition {
        kanji: '推',
        radicals: &['扌', '隹'],
    },
    Decomposition {
        kanji: '水',
        radicals: &['水'],
    },
    Decomposition {
        kanji: '炊',
        radicals: &['火', '欠'],
    },
    Decomposition {
        kanji: '睡',
        radicals: &['｜', 'ノ', '一', '目'],
    },
    Decomposition {
        kanji: '粋',
        radicals: &['九', '十', '米'],
    },
    Decomposition {
        kanji: '翠',
        radicals: &['羽', '十', '人', '亠', '冫'],
    },
    Decomposition {
        kanji: '衰',
        radicals: &['衣', '一', '亠'],
    },
    Decomposition {
        kanji: '遂',
        radicals: &['⻌', '丷', '豕'],
    },
    Decomposition {
        kanji: '酔',
        radicals: &['九', '十', '酉'],
    },
    Decomposition {
        kanji: '錐',
        radicals: &['金', '隹'],
    },
    Decomposition {
        kanji: '錘',
        radicals: &['｜', 'ノ', '一', '金'],
    },
    Decomposition {
        kanji: '随',
        radicals: &['ノ', '一', '月', '⻌', '⻖'],
    },
    Decomposition {
        kanji: '瑞',
        radicals: &['王', '山', '而'],
    },
    Decomposition {
        kanji: '髄',
        radicals: &['ノ', '一', '月', '⻌', '冖', '骨'],
    },
    Decomposition {
        kanji: '崇',
        radicals: &['山', '示', '二', '小', '宀'],
    },
    Decomposition {
        kanji: '嵩',
        radicals: &['口', '高', '山', '亠', '冂'],
    },
    Decomposition {
        kanji: '数',
        radicals: &['女', '米', '攵', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '枢',
        radicals: &['木', '匚'],
    },
    Decomposition {
        kanji: '趨',
        radicals: &['走', '土', '勹', '屮'],
    },
    Decomposition {
        kanji: '雛',
        radicals: &['勹', '屮', '隹'],
    },
    Decomposition {
        kanji: '据',
        radicals: &['口', '十', '尸', '扌'],
    },
    Decomposition {
        kanji: '杉',
        radicals: &['木', '彡'],
    },
    Decomposition {
        kanji: '椙',
        radicals: &['日', '木'],
    },
    Decomposition {
        kanji: '菅',
        radicals: &['｜', '口', '宀', '⺾'],
    },
    Decomposition {
        kanji: '頗',
        radicals: &['貝', '目', 'ハ', '皮', '頁', '又'],
    },
    Decomposition {
        kanji: '雀',
        radicals: &['ノ', '小', '隹'],
    },
    Decomposition {
        kanji: '裾',
        radicals: &['口', '十', '⻂', '尸'],
    },
    Decomposition {
        kanji: '澄',
        radicals: &['口', '⺡', '豆', '丷', '癶'],
    },
    Decomposition {
        kanji: '摺',
        radicals: &['羽', '白', '冫', '扌'],
    },
    Decomposition {
        kanji: '寸',
        radicals: &['寸'],
    },
    Decomposition {
        kanji: '世',
        radicals: &['｜', '一', '世'],
    },
    Decomposition {
        kanji: '瀬',
        radicals: &['｜', '貝', '目', 'ハ', '⺡', '頁', '木', '口'],
    },
    Decomposition {
        kanji: '畝',
        radicals: &['田', '亠', '久'],
    },
    Decomposition {
        kanji: '是',
        radicals: &['日', '疋'],
    },
    Decomposition {
        kanji: '凄',
        radicals: &['女', '冫', 'ヨ', '十'],
    },
    Decomposition {
        kanji: '制',
        radicals: &['ノ', '⺉', '牛', '巾', '二'],
    },
    Decomposition {
        kanji: '勢',
        radicals: &['土', '力', '丶', '儿', '九'],
    },
    Decomposition {
        kanji: '姓',
        radicals: &['女', '生'],
    },
    Decomposition {
        kanji: '征',
        radicals: &['一', '止', '彳'],
    },
    Decomposition {
        kanji: '性',
        radicals: &['生', '⺖'],
    },
    Decomposition {
        kanji: '成',
        radicals: &['ノ', '戈'],
    },
    Decomposition {
        kanji: '政',
        radicals: &['一', '止', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '整',
        radicals: &['｜', '一', '口', '止', '木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '星',
        radicals: &['生', '日'],
    },
    Decomposition {
        kanji: '晴',
        radicals: &['月', '青', '土', '二', '日', '亠'],
    },
    Decomposition {
        kanji: '棲',
        radicals: &['女', '木', 'ヨ', '十'],
    },
    Decomposition {
        kanji: '栖',
        radicals: &['西', '木'],
    },
    Decomposition {
        kanji: '正',
        radicals: &['一', '止'],
    },
    Decomposition {
        kanji: '清',
        radicals: &['月', '⺡', '青', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '牲',
        radicals: &['牛', '生'],
    },
    Decomposition {
        kanji: '生',
        radicals: &['生'],
    },
    Decomposition {
        kanji: '盛',
        radicals: &['ノ', '皿', '戈'],
    },
    Decomposition {
        kanji: '精',
        radicals: &['月', '青', '土', '二', '米', '亠'],
    },
    Decomposition {
        kanji: '聖',
        radicals: &['王', '口', '耳'],
    },
    Decomposition {
        kanji: '声',
        radicals: &['士', '尸'],
    },
    Decomposition {
        kanji: '製',
        radicals: &['衣', '⺉', '牛', '巾', '亠'],
    },
    Decomposition {
        kanji: '西',
        radicals: &['西'],
    },
    Decomposition {
        kanji: '誠',
        radicals: &['ノ', '言', '戈'],
    },
    Decomposition {
        kanji: '誓',
        radicals: &['斤', '言', '扌'],
    },
    Decomposition {
        kanji: '請',
        radicals: &['月', '言', '青', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '逝',
        radicals: &['斤', '⻌', '扌'],
    },
    Decomposition {
        kanji: '醒',
        radicals: &['生', '酉', '日'],
    },
    Decomposition {
        kanji: '青',
        radicals: &['月', '青', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '静',
        radicals: &['月', '青', '土', '亅', '亠', '勹', 'ヨ', '二'],
    },
    Decomposition {
        kanji: '斉',
        radicals: &['｜', 'ノ', '文', '廾', '斉'],
    },
    Decomposition {
        kanji: '税',
        radicals: &['禾', '口', '丷', '儿'],
    },
    Decomposition {
        kanji: '脆',
        radicals: &['月', '厂', '勹', '卩'],
    },
    Decomposition {
        kanji: '隻',
        radicals: &['又', '隹'],
    },
    Decomposition {
        kanji: '席',
        radicals: &['巾', '广', '一', '凵'],
    },
    Decomposition {
        kanji: '惜',
        radicals: &['｜', '一', '二', '日', '⺖'],
    },
    Decomposition {
        kanji: '戚',
        radicals: &['ノ', '小', '卜', '戈'],
    },
    Decomposition {
        kanji: '斥',
        radicals: &['斤', '丶'],
    },
    Decomposition {
        kanji: '昔',
        radicals: &['｜', '一', '二', '日'],
    },
    Decomposition {
        kanji: '析',
        radicals: &['斤', '木'],
    },
    Decomposition {
        kanji: '石',
        radicals: &['口', '石'],
    },
    Decomposition {
        kanji: '積',
        radicals: &['禾', '貝', '目', 'ハ', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '籍',
        radicals: &[
            '｜', '一', '竹', '土', '日', 'ハ', '木', '亠', '耒', '二', 'ノ', '𠂉',
        ],
    },
    Decomposition {
        kanji: '績',
        radicals: &['貝', '目', 'ハ', '糸', '幺', '小', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '脊',
        radicals: &['月', '二', '人'],
    },
    Decomposition {
        kanji: '責',
        radicals: &['貝', '目', 'ハ', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '赤',
        radicals: &['赤', '土'],
    },
    Decomposition {
        kanji: '跡',
        radicals: &['口', '止', '赤', '足', '亠'],
    },
    Decomposition {
        kanji: '蹟',
        radicals: &['貝', '目', 'ハ', '口', '足', '土', '亠', '止', '二'],
    },
    Decomposition {
        kanji: '碩',
        radicals: &['貝', '目', 'ハ', '口', '石', '頁'],
    },
    Decomposition {
        kanji: '切',
        radicals: &['刀', '匕'],
    },
    Decomposition {
        kanji: '拙',
        radicals: &['｜', '山', '扌'],
    },
    Decomposition {
        kanji: '接',
        radicals: &['女', '立', '扌'],
    },
    Decomposition {
        kanji: '摂',
        radicals: &['耳', '冫', '扌'],
    },
    Decomposition {
        kanji: '折',
        radicals: &['斤', '扌'],
    },
    Decomposition {
        kanji: '設',
        radicals: &['言', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '窃',
        radicals: &['穴', '刀', '儿', '匕', '宀'],
    },
    Decomposition {
        kanji: '節',
        radicals: &['艮', '竹', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '説',
        radicals: &['言', '口', '丷', '儿'],
    },
    Decomposition {
        kanji: '雪',
        radicals: &['ヨ', '雨'],
    },
    Decomposition {
        kanji: '絶',
        radicals: &['糸', '幺', '小', '色'],
    },
    Decomposition {
        kanji: '舌',
        radicals: &['口', '舌'],
    },
    Decomposition {
        kanji: '蝉',
        radicals: &['十', '⺌', '虫', '田'],
    },
    Decomposition {
        kanji: '仙',
        radicals: &['⺅', '山'],
    },
    Decomposition {
        kanji: '先',
        radicals: &['ノ', '土', '儿'],
    },
    Decomposition {
        kanji: '千',
        radicals: &['ノ', '十'],
    },
    Decomposition {
        kanji: '占',
        radicals: &['口', '卜'],
    },
    Decomposition {
        kanji: '宣',
        radicals: &['一', '日', '宀'],
    },
    Decomposition {
        kanji: '専',
        radicals: &['十', '寸', '田'],
    },
    Decomposition {
        kanji: '尖',
        radicals: &['小', '大'],
    },
    Decomposition {
        kanji: '川',
        radicals: &['川'],
    },
    Decomposition {
        kanji: '戦',
        radicals: &['十', '⺌', '田', '戈'],
    },
    Decomposition {
        kanji: '扇',
        radicals: &['羽', '戸', '冫', '一', '尸'],
    },
    Decomposition {
        kanji: '撰',
        radicals: &['｜', '二', 'ハ', '已', '扌'],
    },
    Decomposition {
        kanji: '栓',
        radicals: &['王', '木', '𠆢'],
    },
    Decomposition {
        kanji: '栴',
        radicals: &['ノ', '木', '冂', '𠂉'],
    },
    Decomposition {
        kanji: '泉',
        radicals: &['水', '白'],
    },
    Decomposition {
        kanji: '浅',
        radicals: &['⺡', '戈', '二'],
    },
    Decomposition {
        kanji: '洗',
        radicals: &['ノ', '⺡', '土', '儿'],
    },
    Decomposition {
        kanji: '染',
        radicals: &['九', '⺡', '木'],
    },
    Decomposition {
        kanji: '潜',
        radicals: &['⺡', '日', '二', '大'],
    },
    Decomposition {
        kanji: '煎',
        radicals: &['一', '⺉', '月', '丷', '⺣'],
    },
    Decomposition {
        kanji: '煽',
        radicals: &['羽', '火', '戸', '冫', '一', '尸'],
    },
    Decomposition {
        kanji: '旋',
        radicals: &['疋', '方', '𠂉'],
    },
    Decomposition {
        kanji: '穿',
        radicals: &['牙', '穴', '儿', '宀'],
    },
    Decomposition {
        kanji: '箭',
        radicals: &['一', '⺉', '月', '竹', '丷', '𠂉'],
    },
    Decomposition {
        kanji: '線',
        radicals: &['糸', '幺', '小', '水', '白'],
    },
    Decomposition {
        kanji: '繊',
        radicals: &['糸', '幺', '小', '土', '戈', '赤'],
    },
    Decomposition {
        kanji: '羨',
        radicals: &['王', '欠', '⺡', '丷', '羊'],
    },
    Decomposition {
        kanji: '腺',
        radicals: &['月', '水', '白'],
    },
    Decomposition {
        kanji: '舛',
        radicals: &['舛', '夕'],
    },
    Decomposition {
        kanji: '船',
        radicals: &['口', '舟', 'ハ'],
    },
    Decomposition {
        kanji: '薦',
        radicals: &['广', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '詮',
        radicals: &['王', '言', '𠆢', 'ハ'],
    },
    Decomposition {
        kanji: '賎',
        radicals: &['貝', '目', 'ハ', '戈', '二'],
    },
    Decomposition {
        kanji: '践',
        radicals: &['口', '足', '戈', '二', '止'],
    },
    Decomposition {
        kanji: '選',
        radicals: &['｜', '⻌', '二', 'ハ', '已'],
    },
    Decomposition {
        kanji: '遷',
        radicals: &['⻌', '西', '大', '已'],
    },
    Decomposition {
        kanji: '銭',
        radicals: &['金', '戈', '二'],
    },
    Decomposition {
        kanji: '銑',
        radicals: &['ノ', '金', '土', '儿'],
    },
    Decomposition {
        kanji: '閃',
        radicals: &['人', '門'],
    },
    Decomposition {
        kanji: '鮮',
        radicals: &['王', '魚', '田', '丷', '羊', '⺣'],
    },
    Decomposition {
        kanji: '前',
        radicals: &['一', '⺉', '月', '丷'],
    },
    Decomposition {
        kanji: '善',
        radicals: &['王', '口', '丷', '羊'],
    },
    Decomposition {
        kanji: '漸',
        radicals: &['斤', '車', '⺡'],
    },
    Decomposition {
        kanji: '然',
        radicals: &['犬', '夕', '⺣'],
    },
    Decomposition {
        kanji: '全',
        radicals: &['王', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '禅',
        radicals: &['十', '⺌', '田', '⺭'],
    },
    Decomposition {
        kanji: '繕',
        radicals: &['王', '口', '糸', '幺', '小', '丷', '羊'],
    },
    Decomposition {
        kanji: '膳',
        radicals: &['王', '月', '口', '丷', '羊'],
    },
    Decomposition {
        kanji: '糎',
        radicals: &['米', '里', '厂'],
    },
    Decomposition {
        kanji: '噌',
        radicals: &['口', '田', '日', '丷'],
    },
    Decomposition {
        kanji: '塑',
        radicals: &['月', '土', '丷', '屮'],
    },
    Decomposition {
        kanji: '岨',
        radicals: &['一', '山', '目'],
    },
    Decomposition {
        kanji: '措',
        radicals: &['｜', '一', '二', '日', '扌'],
    },
    Decomposition {
        kanji: '曾',
        radicals: &['日', 'ハ'],
    },
    Decomposition {
        kanji: '曽',
        radicals: &['田', '日', '丷'],
    },
    Decomposition {
        kanji: '楚',
        radicals: &['疋', '木'],
    },
    Decomposition {
        kanji: '狙',
        radicals: &['一', '⺨', '目'],
    },
    Decomposition {
        kanji: '疏',
        radicals: &['止', '川', '亠', '厶'],
    },
    Decomposition {
        kanji: '疎',
        radicals: &['｜', '一', '口', '止', '木'],
    },
    Decomposition {
        kanji: '礎',
        radicals: &['口', '石', '疋', '木'],
    },
    Decomposition {
        kanji: '祖',
        radicals: &['一', '目', '⺭'],
    },
    Decomposition {
        kanji: '租',
        radicals: &['一', '禾', '目'],
    },
    Decomposition {
        kanji: '粗',
        radicals: &['一', '米', '目'],
    },
    Decomposition {
        kanji: '素',
        radicals: &['糸', '幺', '小', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '組',
        radicals: &['一', '糸', '幺', '小', '目'],
    },
    Decomposition {
        kanji: '蘇',
        radicals: &['禾', '魚', '田', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '訴',
        radicals: &['斤', '言', '丶'],
    },
    Decomposition {
        kanji: '阻',
        radicals: &['一', '目', '⻖'],
    },
    Decomposition {
        kanji: '遡',
        radicals: &['月', '⻌', '丷', '屮'],
    },
    Decomposition {
        kanji: '鼠',
        radicals: &['臼', '鼠'],
    },
    Decomposition {
        kanji: '僧',
        radicals: &['⺅', '田', '日', '丷'],
    },
    Decomposition {
        kanji: '創',
        radicals: &['⺉', '口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '双',
        radicals: &['又', '丶'],
    },
    Decomposition {
        kanji: '叢',
        radicals: &['王', '耳', '丷', '又', '羊'],
    },
    Decomposition {
        kanji: '倉',
        radicals: &['ノ', '口', '𠆢', '尸', '一'],
    },
    Decomposition {
        kanji: '喪',
        radicals: &['｜', '衣', '一', '口', '亠'],
    },
    Decomposition {
        kanji: '壮',
        radicals: &['士', '爿'],
    },
    Decomposition {
        kanji: '奏',
        radicals: &['一', '禾', '大', '二', '人'],
    },
    Decomposition {
        kanji: '爽',
        radicals: &['一', '人', '亠'],
    },
    Decomposition {
        kanji: '宋',
        radicals: &['木', '宀'],
    },
    Decomposition {
        kanji: '層',
        radicals: &['田', '日', '丷', '尸'],
    },
    Decomposition {
        kanji: '匝',
        radicals: &['巾', '匚'],
    },
    Decomposition {
        kanji: '惣',
        radicals: &['牛', '心', '勿', '勿'],
    },
    Decomposition {
        kanji: '想',
        radicals: &['心', '木', '目'],
    },
    Decomposition {
        kanji: '捜',
        radicals: &['｜', '日', '又', '扌', '田'],
    },
    Decomposition {
        kanji: '掃',
        radicals: &['ヨ', '巾', '冖', '扌'],
    },
    Decomposition {
        kanji: '挿',
        radicals: &['｜', 'ノ', '十', '日', '扌', '田'],
    },
    Decomposition {
        kanji: '掻',
        radicals: &['虫', '又', '扌'],
    },
    Decomposition {
        kanji: '操',
        radicals: &['口', '木', '扌', '品'],
    },
    Decomposition {
        kanji: '早',
        radicals: &['十', '日'],
    },
    Decomposition {
        kanji: '曹',
        radicals: &['｜', '一', '日'],
    },
    Decomposition {
        kanji: '巣',
        radicals: &['⺌', '田', '木'],
    },
    Decomposition {
        kanji: '槍',
        radicals: &['口', '木', '𠆢', '一'],
    },
    Decomposition {
        kanji: '槽',
        radicals: &['｜', '一', '日', '木'],
    },
    Decomposition {
        kanji: '漕',
        radicals: &['｜', '一', '⺡', '日'],
    },
    Decomposition {
        kanji: '燥',
        radicals: &['火', '口', '木', '品'],
    },
    Decomposition {
        kanji: '争',
        radicals: &['ヨ', '一', '亅', '勹'],
    },
    Decomposition {
        kanji: '痩',
        radicals: &['又', '⽧'],
    },
    Decomposition {
        kanji: '相',
        radicals: &['木', '目'],
    },
    Decomposition {
        kanji: '窓',
        radicals: &['穴', '心', '儿', '厶', '宀'],
    },
    Decomposition {
        kanji: '糟',
        radicals: &['｜', '一', '日', '米'],
    },
    Decomposition {
        kanji: '総',
        radicals: &['糸', '幺', '小', '心', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '綜',
        radicals: &['糸', '幺', '小', '示', '二', '宀'],
    },
    Decomposition {
        kanji: '聡',
        radicals: &['耳', '心', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '草',
        radicals: &['十', '日', '⺾'],
    },
    Decomposition {
        kanji: '荘',
        radicals: &['士', '爿', '⺾'],
    },
    Decomposition {
        kanji: '葬',
        radicals: &['一', '夕', '匕', '廾', '⺾'],
    },
    Decomposition {
        kanji: '蒼',
        radicals: &['ノ', '口', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '藻',
        radicals: &['口', '⺡', '木', '⺾', '品'],
    },
    Decomposition {
        kanji: '装',
        radicals: &['衣', '士', '爿', '亠'],
    },
    Decomposition {
        kanji: '走',
        radicals: &['走', '土'],
    },
    Decomposition {
        kanji: '送',
        radicals: &['⻌', '丷', '大', '一', '二'],
    },
    Decomposition {
        kanji: '遭',
        radicals: &['｜', '一', '⻌', '日'],
    },
    Decomposition {
        kanji: '鎗',
        radicals: &['ノ', '金', '口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '霜',
        radicals: &['雨', '木', '目'],
    },
    Decomposition {
        kanji: '騒',
        radicals: &['虫', '馬', '又', '⺣'],
    },
    Decomposition {
        kanji: '像',
        radicals: &['⺅', '勹', '豕', '口', '一'],
    },
    Decomposition {
        kanji: '増',
        radicals: &['田', '土', '日', '丷'],
    },
    Decomposition {
        kanji: '憎',
        radicals: &['田', '日', '丷', '⺖'],
    },
    Decomposition {
        kanji: '臓',
        radicals: &['ノ', '月', '臣', '戈', '⺾', '厂'],
    },
    Decomposition {
        kanji: '蔵',
        radicals: &['ノ', '臣', '戈', '⺾', '厂'],
    },
    Decomposition {
        kanji: '贈',
        radicals: &['貝', '目', 'ハ', '田', '日', '丷'],
    },
    Decomposition {
        kanji: '造',
        radicals: &['ノ', '口', '⻌', '土'],
    },
    Decomposition {
        kanji: '促',
        radicals: &['⺅', '口', '足', '止'],
    },
    Decomposition {
        kanji: '側',
        radicals: &['⺅', '貝', '目', 'ハ', '⺉'],
    },
    Decomposition {
        kanji: '則',
        radicals: &['貝', '目', 'ハ', '⺉'],
    },
    Decomposition {
        kanji: '即',
        radicals: &['艮', '卩'],
    },
    Decomposition {
        kanji: '息',
        radicals: &['自', '心', '目'],
    },
    Decomposition {
        kanji: '捉',
        radicals: &['口', '足', '扌', '止'],
    },
    Decomposition {
        kanji: '束',
        radicals: &['｜', '一', '口', 'ハ', '木'],
    },
    Decomposition {
        kanji: '測',
        radicals: &['貝', '目', 'ハ', '⺉', '⺡'],
    },
    Decomposition {
        kanji: '足',
        radicals: &['口', '足', '止'],
    },
    Decomposition {
        kanji: '速',
        radicals: &['｜', '一', '口', '⻌', 'ハ', '木'],
    },
    Decomposition {
        kanji: '俗',
        radicals: &['⺅', '口', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '属',
        radicals: &['ノ', '尸', '⽱'],
    },
    Decomposition {
        kanji: '賊',
        radicals: &['貝', '目', 'ハ', '十', '戈'],
    },
    Decomposition {
        kanji: '族',
        radicals: &['方', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '続',
        radicals: &['士', '糸', '幺', '小', '儿', '冖'],
    },
    Decomposition {
        kanji: '卒',
        radicals: &['十', '人', '亠'],
    },
    Decomposition {
        kanji: '袖',
        radicals: &['｜', '一', '⻂', '田'],
    },
    Decomposition {
        kanji: '其',
        radicals: &['一', '甘', 'ハ'],
    },
    Decomposition {
        kanji: '揃',
        radicals: &['一', '⺉', '月', '丷', '扌'],
    },
    Decomposition {
        kanji: '存',
        radicals: &['｜', 'ノ', '一', '子'],
    },
    Decomposition {
        kanji: '孫',
        radicals: &['ノ', '子', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '尊',
        radicals: &['寸', '酉', '丷'],
    },
    Decomposition {
        kanji: '損',
        radicals: &['貝', '目', 'ハ', '口', '扌'],
    },
    Decomposition {
        kanji: '村',
        radicals: &['寸', '木'],
    },
    Decomposition {
        kanji: '遜',
        radicals: &['ノ', '⻌', '子', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '他',
        radicals: &['⺅', '也'],
    },
    Decomposition {
        kanji: '多',
        radicals: &['夕'],
    },
    Decomposition {
        kanji: '太',
        radicals: &['大', '丶'],
    },
    Decomposition {
        kanji: '汰',
        radicals: &['⺡', '大', '丶'],
    },
    Decomposition {
        kanji: '詑',
        radicals: &['言', '匕', '宀'],
    },
    Decomposition {
        kanji: '唾',
        radicals: &['｜', 'ノ', '一', '口'],
    },
    Decomposition {
        kanji: '堕',
        radicals: &['ノ', '一', '月', '土', '⻖'],
    },
    Decomposition {
        kanji: '妥',
        radicals: &['女', '爪'],
    },
    Decomposition {
        kanji: '惰',
        radicals: &['ノ', '一', '月', '工', '⺖'],
    },
    Decomposition {
        kanji: '打',
        radicals: &['亅', '扌'],
    },
    Decomposition {
        kanji: '柁',
        radicals: &['木', '匕', '宀'],
    },
    Decomposition {
        kanji: '舵',
        radicals: &['舟', '匕', '宀'],
    },
    Decomposition {
        kanji: '楕',
        radicals: &['ノ', '一', '月', '工', '木'],
    },
    Decomposition {
        kanji: '陀',
        radicals: &['匕', '宀', '⻖'],
    },
    Decomposition {
        kanji: '駄',
        radicals: &['大', '馬', '丶', '⺣'],
    },
    Decomposition {
        kanji: '騨',
        radicals: &['十', '⺌', '田', '馬', '⺣'],
    },
    Decomposition {
        kanji: '体',
        radicals: &['木', '一', '⺅'],
    },
    Decomposition {
        kanji: '堆',
        radicals: &['土', '隹'],
    },
    Decomposition {
        kanji: '対',
        radicals: &['寸', '文'],
    },
    Decomposition {
        kanji: '耐',
        radicals: &['而', '寸'],
    },
    Decomposition {
        kanji: '岱',
        radicals: &['⺅', '山', '弋'],
    },
    Decomposition {
        kanji: '帯',
        radicals: &['｜', '一', '巾', '冖'],
    },
    Decomposition {
        kanji: '待',
        radicals: &['寸', '土', '彳'],
    },
    Decomposition {
        kanji: '怠',
        radicals: &['口', '心', '厶'],
    },
    Decomposition {
        kanji: '態',
        radicals: &['月', '心', '匕', '厶'],
    },
    Decomposition {
        kanji: '戴',
        radicals: &['｜', '一', '田', '土', '二', 'ハ', '戈'],
    },
    Decomposition {
        kanji: '替',
        radicals: &['人', '大', '二', '日', '亠'],
    },
    Decomposition {
        kanji: '泰',
        radicals: &['｜', '一', '水', '二', '人', '大'],
    },
    Decomposition {
        kanji: '滞',
        radicals: &['巾', '⺡', '冖'],
    },
    Decomposition {
        kanji: '胎',
        radicals: &['月', '口', '厶'],
    },
    Decomposition {
        kanji: '腿',
        radicals: &['月', '⻌', '艮'],
    },
    Decomposition {
        kanji: '苔',
        radicals: &['口', '厶', '⺾'],
    },
    Decomposition {
        kanji: '袋',
        radicals: &['衣', '⺅', '弋', '亠'],
    },
    Decomposition {
        kanji: '貸',
        radicals: &['⺅', '貝', '目', 'ハ', '弋'],
    },
    Decomposition {
        kanji: '退',
        radicals: &['⻌', '艮'],
    },
    Decomposition {
        kanji: '逮',
        radicals: &['ヨ', '⻌', '水', '隶'],
    },
    Decomposition {
        kanji: '隊',
        radicals: &['丷', '豕', '⻖'],
    },
    Decomposition {
        kanji: '黛',
        radicals: &['⺅', '黒', '里', '弋', '⺣'],
    },
    Decomposition {
        kanji: '鯛',
        radicals: &['魚', '口', '田', '土', '冂', '⺣'],
    },
    Decomposition {
        kanji: '代',
        radicals: &['⺅', '弋'],
    },
    Decomposition {
        kanji: '台',
        radicals: &['口', '厶'],
    },
    Decomposition {
        kanji: '大',
        radicals: &['大'],
    },
    Decomposition {
        kanji: '第',
        radicals: &['弓', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '醍',
        radicals: &['酉', '日', '疋'],
    },
    Decomposition {
        kanji: '題',
        radicals: &['貝', '目', 'ハ', '日', '疋', '頁'],
    },
    Decomposition {
        kanji: '鷹',
        radicals: &['⺅', '鳥', '广', '⺣', '隹'],
    },
    Decomposition {
        kanji: '滝',
        radicals: &['⺡', '田', '立', '竜'],
    },
    Decomposition {
        kanji: '瀧',
        radicals: &['月', '⺡', '立'],
    },
    Decomposition {
        kanji: '卓',
        radicals: &['十', '日', '卜'],
    },
    Decomposition {
        kanji: '啄',
        radicals: &['口', '豕'],
    },
    Decomposition {
        kanji: '宅',
        radicals: &['ノ', '一', '乙', '宀'],
    },
    Decomposition {
        kanji: '托',
        radicals: &['ノ', '一', '乙', '扌'],
    },
    Decomposition {
        kanji: '択',
        radicals: &['尸', '扌', '丶'],
    },
    Decomposition {
        kanji: '拓',
        radicals: &['口', '石', '扌'],
    },
    Decomposition {
        kanji: '沢',
        radicals: &['⺡', '尸', '丶'],
    },
    Decomposition {
        kanji: '濯',
        radicals: &['ヨ', '⺡', '隹'],
    },
    Decomposition {
        kanji: '琢',
        radicals: &['王', '豕'],
    },
    Decomposition {
        kanji: '託',
        radicals: &['ノ', '一', '乙', '言'],
    },
    Decomposition {
        kanji: '鐸',
        radicals: &['金', '十', '辛', '⺲', '立', '亠'],
    },
    Decomposition {
        kanji: '濁',
        radicals: &['⺡', '虫', '⺲', '勹'],
    },
    Decomposition {
        kanji: '諾',
        radicals: &['ノ', '一', '言', '口', '⺾'],
    },
    Decomposition {
        kanji: '茸',
        radicals: &['耳', '⺾'],
    },
    Decomposition {
        kanji: '凧',
        radicals: &['｜', '巾', '冂', '几'],
    },
    Decomposition {
        kanji: '蛸',
        radicals: &['月', '⺌', '虫'],
    },
    Decomposition {
        kanji: '只',
        radicals: &['口', 'ハ'],
    },
    Decomposition {
        kanji: '叩',
        radicals: &['口', '卩'],
    },
    Decomposition {
        kanji: '但',
        radicals: &['一', '⺅', '日'],
    },
    Decomposition {
        kanji: '達',
        radicals: &['王', '⻌', '土', '丷', '羊'],
    },
    Decomposition {
        kanji: '辰',
        radicals: &['衣', '辰', '厂'],
    },
    Decomposition {
        kanji: '奪',
        radicals: &['寸', '大', '隹'],
    },
    Decomposition {
        kanji: '脱',
        radicals: &['月', '口', '丷', '儿'],
    },
    Decomposition {
        kanji: '巽',
        radicals: &['｜', '一', '二', 'ハ', '已'],
    },
    Decomposition {
        kanji: '竪',
        radicals: &['臣', '又', '立'],
    },
    Decomposition {
        kanji: '辿',
        radicals: &['⻌', '山'],
    },
    Decomposition {
        kanji: '棚',
        radicals: &['月', '木'],
    },
    Decomposition {
        kanji: '谷',
        radicals: &['口', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '狸',
        radicals: &['⺨', '里'],
    },
    Decomposition {
        kanji: '鱈',
        radicals: &['ヨ', '雨', '魚', '田', '⺣'],
    },
    Decomposition {
        kanji: '樽',
        radicals: &['寸', '酉', '丷', '木'],
    },
    Decomposition {
        kanji: '誰',
        radicals: &['言', '隹'],
    },
    Decomposition {
        kanji: '丹',
        radicals: &['ノ', '一', '丶', '亅'],
    },
    Decomposition {
        kanji: '単',
        radicals: &['十', '⺌', '田'],
    },
    Decomposition {
        kanji: '嘆',
        radicals: &['ノ', '一', '口', '⺾', '二', '大'],
    },
    Decomposition {
        kanji: '坦',
        radicals: &['一', '土', '日'],
    },
    Decomposition {
        kanji: '担',
        radicals: &['一', '日', '扌'],
    },
    Decomposition {
        kanji: '探',
        radicals: &['木', '儿', '冖', '扌'],
    },
    Decomposition {
        kanji: '旦',
        radicals: &['一', '日'],
    },
    Decomposition {
        kanji: '歎',
        radicals: &['大', '一', '欠', '⺾', '口', '二'],
    },
    Decomposition {
        kanji: '淡',
        radicals: &['火', '⺡'],
    },
    Decomposition {
        kanji: '湛',
        radicals: &['｜', '一', '甘', '⺡', '儿', '匚'],
    },
    Decomposition {
        kanji: '炭',
        radicals: &['火', '山', '厂'],
    },
    Decomposition {
        kanji: '短',
        radicals: &['口', '豆', '丷', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '端',
        radicals: &['山', '而', '立'],
    },
    Decomposition {
        kanji: '箪',
        radicals: &['十', '⺌', '竹', '田', '𠂉'],
    },
    Decomposition {
        kanji: '綻',
        radicals: &['糸', '幺', '小', '疋', '宀'],
    },
    Decomposition {
        kanji: '耽',
        radicals: &['耳', '尢', '冖'],
    },
    Decomposition {
        kanji: '胆',
        radicals: &['一', '月', '日'],
    },
    Decomposition {
        kanji: '蛋',
        radicals: &['虫', '疋'],
    },
    Decomposition {
        kanji: '誕',
        radicals: &['ノ', '言', '止', '廴'],
    },
    Decomposition {
        kanji: '鍛',
        radicals: &['金', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '団',
        radicals: &['寸', '囗'],
    },
    Decomposition {
        kanji: '壇',
        radicals: &['一', '口', '土', '日', '亠', '囗'],
    },
    Decomposition {
        kanji: '弾',
        radicals: &['弓', '十', '⺌', '田'],
    },
    Decomposition {
        kanji: '断',
        radicals: &['斤', '米', '｜', '一'],
    },
    Decomposition {
        kanji: '暖',
        radicals: &['ノ', '一', '爪', '日', '又'],
    },
    Decomposition {
        kanji: '檀',
        radicals: &['一', '口', '日', '木', '亠'],
    },
    Decomposition {
        kanji: '段',
        radicals: &['｜', '殳', '几', '又', 'ノ', '一'],
    },
    Decomposition {
        kanji: '男',
        radicals: &['田', '力'],
    },
    Decomposition {
        kanji: '談',
        radicals: &['火', '言'],
    },
    Decomposition {
        kanji: '値',
        radicals: &['⺅', '十', '目', '｜', '一'],
    },
    Decomposition {
        kanji: '知',
        radicals: &['口', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '地',
        radicals: &['土', '也'],
    },
    Decomposition {
        kanji: '弛',
        radicals: &['弓', '也'],
    },
    Decomposition {
        kanji: '恥',
        radicals: &['耳', '心'],
    },
    Decomposition {
        kanji: '智',
        radicals: &['口', '日', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '池',
        radicals: &['⺡', '也'],
    },
    Decomposition {
        kanji: '痴',
        radicals: &['口', '矢', '⽧', '𠂉'],
    },
    Decomposition {
        kanji: '稚',
        radicals: &['禾', '隹'],
    },
    Decomposition {
        kanji: '置',
        radicals: &['十', '⺲', '目', '一', '｜'],
    },
    Decomposition {
        kanji: '致',
        radicals: &['至', '土', '厶', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '蜘',
        radicals: &['口', '虫', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '遅',
        radicals: &['王', '⻌', '丷', '羊', '尸'],
    },
    Decomposition {
        kanji: '馳',
        radicals: &['馬', '也', '⺣'],
    },
    Decomposition {
        kanji: '築',
        radicals: &['工', '竹', '木', '丶', '几'],
    },
    Decomposition {
        kanji: '畜',
        radicals: &['玄', '田', '亠', '幺'],
    },
    Decomposition {
        kanji: '竹',
        radicals: &['竹', '𠂉'],
    },
    Decomposition {
        kanji: '筑',
        radicals: &['工', '竹', '丶', '几', '𠂉'],
    },
    Decomposition {
        kanji: '蓄',
        radicals: &['玄', '田', '亠', '幺', '⺾'],
    },
    Decomposition {
        kanji: '逐',
        radicals: &['⻌', '豕'],
    },
    Decomposition {
        kanji: '秩',
        radicals: &['ノ', '禾', '人', '土', '大'],
    },
    Decomposition {
        kanji: '窒',
        radicals: &['一', '穴', '至', '土', '儿', '厶', '宀'],
    },
    Decomposition {
        kanji: '茶',
        radicals: &['𠆢', '⺾', '木'],
    },
    Decomposition {
        kanji: '嫡',
        radicals: &['口', '十', '女', '丷', '立', '亠', '冂', '啇'],
    },
    Decomposition {
        kanji: '着',
        radicals: &['ノ', '王', '丷', '目', '羊'],
    },
    Decomposition {
        kanji: '中',
        radicals: &['｜', '口'],
    },
    Decomposition {
        kanji: '仲',
        radicals: &['｜', '⺅', '口'],
    },
    Decomposition {
        kanji: '宙',
        radicals: &['｜', '日', '宀', '田'],
    },
    Decomposition {
        kanji: '忠',
        radicals: &['｜', '口', '心'],
    },
    Decomposition {
        kanji: '抽',
        radicals: &['｜', '日', '扌', '田'],
    },
    Decomposition {
        kanji: '昼',
        radicals: &['一', '日', '尸', '丶'],
    },
    Decomposition {
        kanji: '柱',
        radicals: &['王', '木', '丶'],
    },
    Decomposition {
        kanji: '注',
        radicals: &['王', '⺡', '丶'],
    },
    Decomposition {
        kanji: '虫',
        radicals: &['虫'],
    },
    Decomposition {
        kanji: '衷',
        radicals: &['衣', '十', '口'],
    },
    Decomposition {
        kanji: '註',
        radicals: &['王', '言', '丶'],
    },
    Decomposition {
        kanji: '酎',
        radicals: &['寸', '酉'],
    },
    Decomposition {
        kanji: '鋳',
        radicals: &['ノ', '亠', '土', '金', '寸'],
    },
    Decomposition {
        kanji: '駐',
        radicals: &['王', '馬', '丶', '⺣'],
    },
    Decomposition {
        kanji: '樗',
        radicals: &['雨', '木', '二', '勹'],
    },
    Decomposition {
        kanji: '瀦',
        radicals: &['⺡', '日', '⺹', '豕'],
    },
    Decomposition {
        kanji: '猪',
        radicals: &['日', '⺨', '⺹'],
    },
    Decomposition {
        kanji: '苧',
        radicals: &['一', '亅', '宀', '⺾'],
    },
    Decomposition {
        kanji: '著',
        radicals: &['日', '⺹', '⺾'],
    },
    Decomposition {
        kanji: '貯',
        radicals: &['一', '貝', '目', 'ハ', '亅', '宀'],
    },
    Decomposition {
        kanji: '丁',
        radicals: &['一', '亅'],
    },
    Decomposition {
        kanji: '兆',
        radicals: &['儿', '冫'],
    },
    Decomposition {
        kanji: '凋',
        radicals: &['口', '土', '冂', '冫'],
    },
    Decomposition {
        kanji: '喋',
        radicals: &['口', '木', '世'],
    },
    Decomposition {
        kanji: '寵',
        radicals: &['月', '立', '宀'],
    },
    Decomposition {
        kanji: '帖',
        radicals: &['巾', '口', '卜'],
    },
    Decomposition {
        kanji: '帳',
        radicals: &['巾', '長'],
    },
    Decomposition {
        kanji: '庁',
        radicals: &['一', '亅', '广'],
    },
    Decomposition {
        kanji: '弔',
        radicals: &['｜', '弓'],
    },
    Decomposition {
        kanji: '張',
        radicals: &['弓', '長'],
    },
    Decomposition {
        kanji: '彫',
        radicals: &['口', '土', '冂', '彡'],
    },
    Decomposition {
        kanji: '徴',
        radicals: &['王', '山', '彳', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '懲',
        radicals: &['王', '山', '心', '彳', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '挑',
        radicals: &['儿', '冫', '扌'],
    },
    Decomposition {
        kanji: '暢',
        radicals: &['｜', '一', '日', '勿', '田', '勿'],
    },
    Decomposition {
        kanji: '朝',
        radicals: &['月', '十', '日'],
    },
    Decomposition {
        kanji: '潮',
        radicals: &['月', '十', '⺡', '日'],
    },
    Decomposition {
        kanji: '牒',
        radicals: &['片', '木', '世'],
    },
    Decomposition {
        kanji: '町',
        radicals: &['一', '田', '亅'],
    },
    Decomposition {
        kanji: '眺',
        radicals: &['目', '儿', '冫'],
    },
    Decomposition {
        kanji: '聴',
        radicals: &['耳', '十', '心', '⺲'],
    },
    Decomposition {
        kanji: '脹',
        radicals: &['月', '長'],
    },
    Decomposition {
        kanji: '腸',
        radicals: &['一', '月', '日', '勿', '勿'],
    },
    Decomposition {
        kanji: '蝶',
        radicals: &['虫', '木', '世'],
    },
    Decomposition {
        kanji: '調',
        radicals: &['言', '口', '土', '冂'],
    },
    Decomposition {
        kanji: '諜',
        radicals: &['言', '木', '世'],
    },
    Decomposition {
        kanji: '超',
        radicals: &['口', '走', '土', '刀'],
    },
    Decomposition {
        kanji: '跳',
        radicals: &['口', '足', '儿', '冫', '止'],
    },
    Decomposition {
        kanji: '銚',
        radicals: &['金', '儿', '冫'],
    },
    Decomposition {
        kanji: '長',
        radicals: &['長'],
    },
    Decomposition {
        kanji: '頂',
        radicals: &['一', '貝', '目', 'ハ', '頁', '亅'],
    },
    Decomposition {
        kanji: '鳥',
        radicals: &['鳥', '⺣'],
    },
    Decomposition {
        kanji: '勅',
        radicals: &['｜', '一', '口', '木', '力'],
    },
    Decomposition {
        kanji: '捗',
        radicals: &['ノ', '止', '小', '扌'],
    },
    Decomposition {
        kanji: '直',
        radicals: &['十', '目', '｜', '一'],
    },
    Decomposition {
        kanji: '朕',
        radicals: &['月', '人', '大', '一', '丷'],
    },
    Decomposition {
        kanji: '沈',
        radicals: &['⺡', '尢', '冖'],
    },
    Decomposition {
        kanji: '珍',
        radicals: &['王', '𠆢', '彡'],
    },
    Decomposition {
        kanji: '賃',
        radicals: &['王', '⺅', '貝', '目', 'ハ'],
    },
    Decomposition {
        kanji: '鎮',
        radicals: &['金', '十', '丷', '目', '一', 'ハ'],
    },
    Decomposition {
        kanji: '陳',
        radicals: &['｜', '一', '田', '日', '木', '⻖'],
    },
    Decomposition {
        kanji: '津',
        radicals: &['⺡', '聿'],
    },
    Decomposition {
        kanji: '墜',
        radicals: &['土', '丷', '豕', '⻖'],
    },
    Decomposition {
        kanji: '椎',
        radicals: &['木', '隹'],
    },
    Decomposition {
        kanji: '槌',
        radicals: &['｜', '口', '⻌', '木'],
    },
    Decomposition {
        kanji: '追',
        radicals: &['｜', '口', '⻌'],
    },
    Decomposition {
        kanji: '鎚',
        radicals: &['｜', '金', '口', '⻌'],
    },
    Decomposition {
        kanji: '痛',
        radicals: &['用', '⽧', 'マ'],
    },
    Decomposition {
        kanji: '通',
        radicals: &['⻌', '用', 'マ'],
    },
    Decomposition {
        kanji: '塚',
        radicals: &['土', '冖', '豕'],
    },
    Decomposition {
        kanji: '栂',
        radicals: &['母', '木', '毋'],
    },
    Decomposition {
        kanji: '掴',
        radicals: &['王', '囗', '扌', '丶'],
    },
    Decomposition {
        kanji: '槻',
        radicals: &['見', '人', '大', '木', '一', '二'],
    },
    Decomposition {
        kanji: '佃',
        radicals: &['⺅', '田'],
    },
    Decomposition {
        kanji: '漬',
        radicals: &['貝', '目', 'ハ', '⺡', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '柘',
        radicals: &['口', '石', '木'],
    },
    Decomposition {
        kanji: '辻',
        radicals: &['⻌', '十'],
    },
    Decomposition {
        kanji: '蔦',
        radicals: &['鳥', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '綴',
        radicals: &['糸', '幺', '小', '又'],
    },
    Decomposition {
        kanji: '鍔',
        radicals: &['金', '口', '二', '勹'],
    },
    Decomposition {
        kanji: '椿',
        radicals: &['一', '二', '日', '木', '人', '大'],
    },
    Decomposition {
        kanji: '潰',
        radicals: &['貝', '目', 'ハ', '⺡', '十', '口', '｜', '一'],
    },
    Decomposition {
        kanji: '坪',
        radicals: &['干', '土', '丷'],
    },
    Decomposition {
        kanji: '壷',
        radicals: &['｜', '一', '口', '士', '冖'],
    },
    Decomposition {
        kanji: '嬬',
        radicals: &['雨', '而', '女'],
    },
    Decomposition {
        kanji: '紬',
        radicals: &['｜', '糸', '幺', '小', '日', '田'],
    },
    Decomposition {
        kanji: '爪',
        radicals: &['爪'],
    },
    Decomposition {
        kanji: '吊',
        radicals: &['巾', '口'],
    },
    Decomposition {
        kanji: '釣',
        radicals: &['金', '丶', '勹'],
    },
    Decomposition {
        kanji: '鶴',
        radicals: &['鳥', '⺣', '隹', '宀', '冖'],
    },
    Decomposition {
        kanji: '亭',
        radicals: &['口', '亅', '亠', '冖'],
    },
    Decomposition {
        kanji: '低',
        radicals: &['⺅', '氏', '一'],
    },
    Decomposition {
        kanji: '停',
        radicals: &['⺅', '口', '亅', '亠', '冖', '一'],
    },
    Decomposition {
        kanji: '偵',
        radicals: &['⺅', '貝', '目', 'ハ', '卜'],
    },
    Decomposition {
        kanji: '剃',
        radicals: &['｜', 'ノ', '⺉', '弓', '丷'],
    },
    Decomposition {
        kanji: '貞',
        radicals: &['貝', '目', 'ハ', '卜'],
    },
    Decomposition {
        kanji: '呈',
        radicals: &['王', '口'],
    },
    Decomposition {
        kanji: '堤',
        radicals: &['土', '日', '疋'],
    },
    Decomposition {
        kanji: '定',
        radicals: &['疋', '宀'],
    },
    Decomposition {
        kanji: '帝',
        radicals: &['巾', '丷', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '底',
        radicals: &['氏', '广'],
    },
    Decomposition {
        kanji: '庭',
        radicals: &['王', '广', '廴'],
    },
    Decomposition {
        kanji: '廷',
        radicals: &['王', '廴', '士'],
    },
    Decomposition {
        kanji: '弟',
        radicals: &['｜', 'ノ', '弓', '丷'],
    },
    Decomposition {
        kanji: '悌',
        radicals: &['｜', 'ノ', '弓', '丷', '⺖'],
    },
    Decomposition {
        kanji: '抵',
        radicals: &['氏', '扌'],
    },
    Decomposition {
        kanji: '挺',
        radicals: &['王', '廴', '扌'],
    },
    Decomposition {
        kanji: '提',
        radicals: &['日', '疋', '扌'],
    },
    Decomposition {
        kanji: '梯',
        radicals: &['｜', 'ノ', '弓', '丷', '木'],
    },
    Decomposition {
        kanji: '汀',
        radicals: &['一', '⺡', '亅'],
    },
    Decomposition {
        kanji: '碇',
        radicals: &['口', '石', '疋', '宀'],
    },
    Decomposition {
        kanji: '禎',
        radicals: &['貝', '目', 'ハ', '卜', '⺭'],
    },
    Decomposition {
        kanji: '程',
        radicals: &['王', '禾', '口'],
    },
    Decomposition {
        kanji: '締',
        radicals: &['巾', '糸', '幺', '小', '丷', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '艇',
        radicals: &['王', '舟', '廴'],
    },
    Decomposition {
        kanji: '訂',
        radicals: &['一', '言', '亅'],
    },
    Decomposition {
        kanji: '諦',
        radicals: &['巾', '言', '丷', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '蹄',
        radicals: &['巾', '口', '足', '丷', '立', '亠', '冖', '止'],
    },
    Decomposition {
        kanji: '逓',
        radicals: &['巾', '⻌', '厂', '二', '｜'],
    },
    Decomposition {
        kanji: '邸',
        radicals: &['氏', '⻏'],
    },
    Decomposition {
        kanji: '鄭',
        radicals: &['大', '酉', '丷', '⻏'],
    },
    Decomposition {
        kanji: '釘',
        radicals: &['一', '金', '亅'],
    },
    Decomposition {
        kanji: '鼎',
        radicals: &['｜', '一', '鼎', '片', '目', '爿'],
    },
    Decomposition {
        kanji: '泥',
        radicals: &['⺡', '匕', '尸'],
    },
    Decomposition {
        kanji: '摘',
        radicals: &['口', '十', '丷', '立', '亠', '冂', '扌', '啇'],
    },
    Decomposition {
        kanji: '擢',
        radicals: &['ヨ', '扌', '隹'],
    },
    Decomposition {
        kanji: '敵',
        radicals: &['口', '十', '丷', '立', '亠', '冂', '攵', '啇', '𠂉'],
    },
    Decomposition {
        kanji: '滴',
        radicals: &['口', '十', '⺡', '丷', '立', '亠', '冂', '啇'],
    },
    Decomposition {
        kanji: '的',
        radicals: &['白', '丶', '勹'],
    },
    Decomposition {
        kanji: '笛',
        radicals: &['｜', '竹', '日', '田', '𠂉'],
    },
    Decomposition {
        kanji: '適',
        radicals: &['口', '⻌', '十', '丷', '立', '亠', '冂', '啇'],
    },
    Decomposition {
        kanji: '鏑',
        radicals: &['金', '口', '十', '丷', '立', '亠', '冂', '啇'],
    },
    Decomposition {
        kanji: '溺',
        radicals: &['弓', '⺡', '冫'],
    },
    Decomposition {
        kanji: '哲',
        radicals: &['斤', '口', '扌'],
    },
    Decomposition {
        kanji: '徹',
        radicals: &['月', '亠', '厶', '彳', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '撤',
        radicals: &['月', '亠', '厶', '扌', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '轍',
        radicals: &['月', '車', '亠', '厶', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '迭',
        radicals: &['｜', 'ノ', '一', '牛', '⻌', '矢', '大', '二', '𠂉'],
    },
    Decomposition {
        kanji: '鉄',
        radicals: &['ノ', '金', '二', '矢', '大', '𠂉'],
    },
    Decomposition {
        kanji: '典',
        radicals: &['｜', '一', '日', 'ハ'],
    },
    Decomposition {
        kanji: '填',
        radicals: &['十', '土', 'ハ', '目'],
    },
    Decomposition {
        kanji: '天',
        radicals: &['一', '大', '二'],
    },
    Decomposition {
        kanji: '展',
        radicals: &['｜', '衣', '一', '二', '尸'],
    },
    Decomposition {
        kanji: '店',
        radicals: &['口', '卜', '广'],
    },
    Decomposition {
        kanji: '添',
        radicals: &['ノ', '⺡', '心', '大', '一', '二'],
    },
    Decomposition {
        kanji: '纏',
        radicals: &['糸', '幺', '小', '土', '里', '儿', '广'],
    },
    Decomposition {
        kanji: '甜',
        radicals: &['甘', '口', '舌'],
    },
    Decomposition {
        kanji: '貼',
        radicals: &['貝', '目', 'ハ', '口', '卜'],
    },
    Decomposition {
        kanji: '転',
        radicals: &['車', '二', '厶'],
    },
    Decomposition {
        kanji: '顛',
        radicals: &['貝', '十', 'ハ', '頁', '目'],
    },
    Decomposition {
        kanji: '点',
        radicals: &['口', '卜', '⺣'],
    },
    Decomposition {
        kanji: '伝',
        radicals: &['⺅', '二', '厶'],
    },
    Decomposition {
        kanji: '殿',
        radicals: &['｜', '一', '二', 'ハ', '尸', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '澱',
        radicals: &['｜', '一', '⺡', '二', 'ハ', '尸', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '田',
        radicals: &['田'],
    },
    Decomposition {
        kanji: '電',
        radicals: &['雨', '田', '乙'],
    },
    Decomposition {
        kanji: '兎',
        radicals: &['ノ', '丶', '儿', '口', '｜'],
    },
    Decomposition {
        kanji: '吐',
        radicals: &['口', '土'],
    },
    Decomposition {
        kanji: '堵',
        radicals: &['土', '日', '⺹'],
    },
    Decomposition {
        kanji: '塗',
        radicals: &['⺡', '土', 'ハ', '𠆢', '亅', '木', '一'],
    },
    Decomposition {
        kanji: '妬',
        radicals: &['口', '女', '石'],
    },
    Decomposition {
        kanji: '屠',
        radicals: &['日', '⺹', '尸'],
    },
    Decomposition {
        kanji: '徒',
        radicals: &['走', '土', '彳'],
    },
    Decomposition {
        kanji: '斗',
        radicals: &['斗'],
    },
    Decomposition {
        kanji: '杜',
        radicals: &['土', '木'],
    },
    Decomposition {
        kanji: '渡',
        radicals: &['⺡', '又', '广'],
    },
    Decomposition {
        kanji: '登',
        radicals: &['口', '豆', '丷', '癶'],
    },
    Decomposition {
        kanji: '菟',
        radicals: &['丶', '儿', '⺾', '勹', '口', '｜'],
    },
    Decomposition {
        kanji: '賭',
        radicals: &['貝', '目', 'ハ', '日', '⺹'],
    },
    Decomposition {
        kanji: '途',
        radicals: &['⻌', 'ハ', '𠆢', '亅', '木', '一'],
    },
    Decomposition {
        kanji: '都',
        radicals: &['日', '⻏', '⺹'],
    },
    Decomposition {
        kanji: '鍍',
        radicals: &['金', '又', '广'],
    },
    Decomposition {
        kanji: '砥',
        radicals: &['口', '氏', '石'],
    },
    Decomposition {
        kanji: '砺',
        radicals: &['一', '斤', '口', '石', '厂'],
    },
    Decomposition {
        kanji: '努',
        radicals: &['女', '又', '力'],
    },
    Decomposition {
        kanji: '度',
        radicals: &['又', '广', '一', '凵'],
    },
    Decomposition {
        kanji: '土',
        radicals: &['土'],
    },
    Decomposition {
        kanji: '奴',
        radicals: &['女', '又'],
    },
    Decomposition {
        kanji: '怒',
        radicals: &['女', '心', '又'],
    },
    Decomposition {
        kanji: '倒',
        radicals: &['⺅', '⺉', '至', '土', '厶'],
    },
    Decomposition {
        kanji: '党',
        radicals: &['口', '⺌', '儿', '冖'],
    },
    Decomposition {
        kanji: '冬',
        radicals: &['夂', '丶', '攵'],
    },
    Decomposition {
        kanji: '凍',
        radicals: &['｜', '一', '日', '木', '冫', '田'],
    },
    Decomposition {
        kanji: '刀',
        radicals: &['刀'],
    },
    Decomposition {
        kanji: '唐',
        radicals: &['｜', 'ヨ', '一', '口', '广'],
    },
    Decomposition {
        kanji: '塔',
        radicals: &['口', '土', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '塘',
        radicals: &['｜', 'ヨ', '一', '口', '土', '广'],
    },
    Decomposition {
        kanji: '套',
        radicals: &['大', '長', '厶'],
    },
    Decomposition {
        kanji: '宕',
        radicals: &['口', '石', '宀'],
    },
    Decomposition {
        kanji: '島',
        radicals: &['山', '鳥', '白'],
    },
    Decomposition {
        kanji: '嶋',
        radicals: &['山', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '悼',
        radicals: &['十', '日', '⺖', '卜'],
    },
    Decomposition {
        kanji: '投',
        radicals: &['扌', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '搭',
        radicals: &['口', '𠆢', '扌', '⺾', '一'],
    },
    Decomposition {
        kanji: '東',
        radicals: &['｜', '一', '日', '木', '田'],
    },
    Decomposition {
        kanji: '桃',
        radicals: &['木', '儿', '冫'],
    },
    Decomposition {
        kanji: '梼',
        radicals: &['ノ', '寸', '木', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '棟',
        radicals: &['｜', '一', '日', '木', '田'],
    },
    Decomposition {
        kanji: '盗',
        radicals: &['欠', '皿', '冫'],
    },
    Decomposition {
        kanji: '淘',
        radicals: &['缶', '⺡', '凵', '勹'],
    },
    Decomposition {
        kanji: '湯',
        radicals: &['｜', '一', '⺡', '日', '勿', '勿'],
    },
    Decomposition {
        kanji: '涛',
        radicals: &['ノ', '⺡', '寸', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '灯',
        radicals: &['一', '火', '亅'],
    },
    Decomposition {
        kanji: '燈',
        radicals: &['口', '豆', '丷', '癶', '火'],
    },
    Decomposition {
        kanji: '当',
        radicals: &['ヨ', '⺌'],
    },
    Decomposition {
        kanji: '痘',
        radicals: &['口', '豆', '丷', '⽧'],
    },
    Decomposition {
        kanji: '祷',
        radicals: &['ノ', '寸', '⺭', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '等',
        radicals: &['寸', '竹', '土', '𠂉'],
    },
    Decomposition {
        kanji: '答',
        radicals: &['口', '竹', '𠆢', '一', '𠂉'],
    },
    Decomposition {
        kanji: '筒',
        radicals: &['口', '竹', '冂', '𠂉', '一'],
    },
    Decomposition {
        kanji: '糖',
        radicals: &['口', '米', '广'],
    },
    Decomposition {
        kanji: '統',
        radicals: &['糸', '幺', '小', '亠', '儿', '厶'],
    },
    Decomposition {
        kanji: '到',
        radicals: &['⺉', '至', '土', '厶'],
    },
    Decomposition {
        kanji: '董',
        radicals: &['｜', '一', '日', '⺾', '里', 'ノ'],
    },
    Decomposition {
        kanji: '蕩',
        radicals: &['｜', '一', '⺡', '日', '⺾', '勿', '勿'],
    },
    Decomposition {
        kanji: '藤',
        radicals: &['｜', '一', '月', '水', '⺾', '二', '大'],
    },
    Decomposition {
        kanji: '討',
        radicals: &['言', '寸'],
    },
    Decomposition {
        kanji: '謄',
        radicals: &['｜', '一', '月', '言', '二', '大'],
    },
    Decomposition {
        kanji: '豆',
        radicals: &['口', '豆', '丷'],
    },
    Decomposition {
        kanji: '踏',
        radicals: &['口', '水', '足', '日', '止'],
    },
    Decomposition {
        kanji: '逃',
        radicals: &['⻌', '儿', '冫'],
    },
    Decomposition {
        kanji: '透',
        radicals: &['ノ', '禾', '⻌', '乃'],
    },
    Decomposition {
        kanji: '鐙',
        radicals: &['金', '口', '豆', '丷', '癶'],
    },
    Decomposition {
        kanji: '陶',
        radicals: &['缶', '勹', '⻖'],
    },
    Decomposition {
        kanji: '頭',
        radicals: &['貝', '目', 'ハ', '口', '豆', '丷', '頁'],
    },
    Decomposition {
        kanji: '騰',
        radicals: &['月', '馬', '丷', '一', '人', '大', '二', '⺣'],
    },
    Decomposition {
        kanji: '闘',
        radicals: &['口', '寸', '豆', '丷', '門'],
    },
    Decomposition {
        kanji: '働',
        radicals: &['｜', '一', '⺅', '力', '日', 'ノ'],
    },
    Decomposition {
        kanji: '動',
        radicals: &['｜', '一', '日', '力', '里', 'ノ'],
    },
    Decomposition {
        kanji: '同',
        radicals: &['口', '冂', '一'],
    },
    Decomposition {
        kanji: '堂',
        radicals: &['口', '⺌', '土', '冖'],
    },
    Decomposition {
        kanji: '導',
        radicals: &['⻌', '自', '寸', '丷', '首'],
    },
    Decomposition {
        kanji: '憧',
        radicals: &['⺖', '里', '立'],
    },
    Decomposition {
        kanji: '撞',
        radicals: &['里', '立', '扌'],
    },
    Decomposition {
        kanji: '洞',
        radicals: &['口', '⺡', '冂', '一'],
    },
    Decomposition {
        kanji: '瞳',
        radicals: &['目', '里', '立'],
    },
    Decomposition {
        kanji: '童',
        radicals: &['里', '立'],
    },
    Decomposition {
        kanji: '胴',
        radicals: &['月', '口', '冂', '一'],
    },
    Decomposition {
        kanji: '萄',
        radicals: &['缶', '勹', '⺾'],
    },
    Decomposition {
        kanji: '道',
        radicals: &['⻌', '自', '丷', '首'],
    },
    Decomposition {
        kanji: '銅',
        radicals: &['金', '口', '冂', '一'],
    },
    Decomposition {
        kanji: '峠',
        radicals: &['｜', '一', '山', '卜'],
    },
    Decomposition {
        kanji: '鴇',
        radicals: &['十', '鳥', '匕', '⺣'],
    },
    Decomposition {
        kanji: '匿',
        radicals: &['ノ', '口', '匚', '⺾'],
    },
    Decomposition {
        kanji: '得',
        radicals: &['寸', '日', '彳', '一'],
    },
    Decomposition {
        kanji: '徳',
        radicals: &['十', '心', '⺲', '彳'],
    },
    Decomposition {
        kanji: '涜',
        radicals: &['士', '⺡', '儿', '冖'],
    },
    Decomposition {
        kanji: '特',
        radicals: &['牛', '寸', '土'],
    },
    Decomposition {
        kanji: '督',
        radicals: &['小', '卜', '又', '目'],
    },
    Decomposition {
        kanji: '禿',
        radicals: &['禾', '儿'],
    },
    Decomposition {
        kanji: '篤',
        radicals: &['竹', '⺣', '馬', '𠂉'],
    },
    Decomposition {
        kanji: '毒',
        radicals: &['土', '母', '亠', '毋', '二'],
    },
    Decomposition {
        kanji: '独',
        radicals: &['虫', '⺨'],
    },
    Decomposition {
        kanji: '読',
        radicals: &['言', '士', '儿', '冖'],
    },
    Decomposition {
        kanji: '栃',
        radicals: &['斤', '木', '厂'],
    },
    Decomposition {
        kanji: '橡',
        radicals: &['木', '豕', '勹', '口', '｜'],
    },
    Decomposition {
        kanji: '凸',
        radicals: &['｜', '一', '冂', '凵'],
    },
    Decomposition {
        kanji: '突',
        radicals: &['穴', '大', '儿', '宀'],
    },
    Decomposition {
        kanji: '椴',
        radicals: &['木', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '届',
        radicals: &['｜', '日', '尸', '田'],
    },
    Decomposition {
        kanji: '鳶',
        radicals: &['鳥', '弋', '⺣'],
    },
    Decomposition {
        kanji: '苫',
        radicals: &['口', '卜', '⺾'],
    },
    Decomposition {
        kanji: '寅',
        radicals: &['田', 'ハ', '宀', '一'],
    },
    Decomposition {
        kanji: '酉',
        radicals: &['酉'],
    },
    Decomposition {
        kanji: '瀞',
        radicals: &['月', '⺡', '青', '土', '亅', '亠', 'ヨ', '二'],
    },
    Decomposition {
        kanji: '噸',
        radicals: &['貝', '目', 'ハ', '口', '頁', '屯'],
    },
    Decomposition {
        kanji: '屯',
        radicals: &['ノ', '乙', '凵', '屯'],
    },
    Decomposition {
        kanji: '惇',
        radicals: &['口', '子', '⺖', '亠'],
    },
    Decomposition {
        kanji: '敦',
        radicals: &['口', '子', '亠', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '沌',
        radicals: &['⺡', '屯'],
    },
    Decomposition {
        kanji: '豚',
        radicals: &['月', '豕'],
    },
    Decomposition {
        kanji: '遁',
        radicals: &['斤', '⻌', '十', '目', '厂'],
    },
    Decomposition {
        kanji: '頓',
        radicals: &['貝', '目', 'ハ', '頁', '屯'],
    },
    Decomposition {
        kanji: '呑',
        radicals: &['ノ', '口', '大'],
    },
    Decomposition {
        kanji: '曇',
        radicals: &['雨', '二', '日', '厶'],
    },
    Decomposition {
        kanji: '鈍',
        radicals: &['金', '屯'],
    },
    Decomposition {
        kanji: '奈',
        radicals: &['示', '二', '小', '大'],
    },
    Decomposition {
        kanji: '那',
        radicals: &['刀', '⻏', '二'],
    },
    Decomposition {
        kanji: '内',
        radicals: &['人', '冂'],
    },
    Decomposition {
        kanji: '乍',
        radicals: &['｜', 'ノ', '一', '𠂉'],
    },
    Decomposition {
        kanji: '凪',
        radicals: &['止', '几'],
    },
    Decomposition {
        kanji: '薙',
        radicals: &['矢', '⺾', '隹', '𠂉'],
    },
    Decomposition {
        kanji: '謎',
        radicals: &['言', '⻌', '米'],
    },
    Decomposition {
        kanji: '灘',
        radicals: &['⺡', '大', '口', '⺾', '隹', '亠', '二'],
    },
    Decomposition {
        kanji: '捺',
        radicals: &['示', '二', '小', '大', '扌'],
    },
    Decomposition {
        kanji: '鍋',
        radicals: &['金', '口', '冂'],
    },
    Decomposition {
        kanji: '楢',
        radicals: &['酉', '丷', '木'],
    },
    Decomposition {
        kanji: '馴',
        radicals: &['川', '⺣', '馬', '⺣'],
    },
    Decomposition {
        kanji: '縄',
        radicals: &['亀', '糸', '幺', '小', '田', '乙', '勹'],
    },
    Decomposition {
        kanji: '畷',
        radicals: &['田', '又'],
    },
    Decomposition {
        kanji: '南',
        radicals: &['干', '十', '丷', '冂'],
    },
    Decomposition {
        kanji: '楠',
        radicals: &['干', '十', '丷', '木', '冂'],
    },
    Decomposition {
        kanji: '軟',
        radicals: &['欠', '車'],
    },
    Decomposition {
        kanji: '難',
        radicals: &['⺾', '隹', '大', '口', '亠', '二'],
    },
    Decomposition {
        kanji: '汝',
        radicals: &['⺡', '女'],
    },
    Decomposition {
        kanji: '二',
        radicals: &['二'],
    },
    Decomposition {
        kanji: '尼',
        radicals: &['匕', '尸'],
    },
    Decomposition {
        kanji: '弐',
        radicals: &['一', '弋', '二'],
    },
    Decomposition {
        kanji: '迩',
        radicals: &['ノ', '⻌', '小', '𠂉'],
    },
    Decomposition {
        kanji: '匂',
        radicals: &['勹', '匕'],
    },
    Decomposition {
        kanji: '賑',
        radicals: &['貝', '目', 'ハ', '辰', '衣'],
    },
    Decomposition {
        kanji: '肉',
        radicals: &['肉', '冂', '人'],
    },
    Decomposition {
        kanji: '虹',
        radicals: &['工', '虫'],
    },
    Decomposition {
        kanji: '廿',
        radicals: &['｜', '一', '凵'],
    },
    Decomposition {
        kanji: '日',
        radicals: &['日'],
    },
    Decomposition {
        kanji: '乳',
        radicals: &['乙', '子', '爪'],
    },
    Decomposition {
        kanji: '入',
        radicals: &['入'],
    },
    Decomposition {
        kanji: '如',
        radicals: &['口', '女'],
    },
    Decomposition {
        kanji: '尿',
        radicals: &['水', '尸'],
    },
    Decomposition {
        kanji: '韮',
        radicals: &['韭', '⺾'],
    },
    Decomposition {
        kanji: '任',
        radicals: &['ノ', '王', '⺅', '士'],
    },
    Decomposition {
        kanji: '妊',
        radicals: &['ノ', '王', '士', '女'],
    },
    Decomposition {
        kanji: '忍',
        radicals: &['心', '刀', '丶'],
    },
    Decomposition {
        kanji: '認',
        radicals: &['言', '心', '刀', '丶'],
    },
    Decomposition {
        kanji: '濡',
        radicals: &['雨', '而', '⺡'],
    },
    Decomposition {
        kanji: '禰',
        radicals: &['｜', '一', '⺭', '冂', '爻'],
    },
    Decomposition {
        kanji: '祢',
        radicals: &['ノ', '小', '⺭'],
    },
    Decomposition {
        kanji: '寧',
        radicals: &['一', '心', '⺲', '亅', '宀', '皿'],
    },
    Decomposition {
        kanji: '葱',
        radicals: &['勿', '心', '丶', '⺾', '勿'],
    },
    Decomposition {
        kanji: '猫',
        radicals: &['田', '⺨', '⺾'],
    },
    Decomposition {
        kanji: '熱',
        radicals: &['土', '九', '丶', '儿', '⺣'],
    },
    Decomposition {
        kanji: '年',
        radicals: &['ノ', '一', '干', '𠂉'],
    },
    Decomposition {
        kanji: '念',
        radicals: &['｜', '一', '心', '𠆢'],
    },
    Decomposition {
        kanji: '捻',
        radicals: &['｜', '一', '心', '𠆢', '扌'],
    },
    Decomposition {
        kanji: '撚',
        radicals: &['犬', '夕', '扌', '⺣'],
    },
    Decomposition {
        kanji: '燃',
        radicals: &['火', '犬', '夕', '⺣'],
    },
    Decomposition {
        kanji: '粘',
        radicals: &['口', '米', '卜'],
    },
    Decomposition {
        kanji: '乃',
        radicals: &['｜', 'ノ', '一', '乃'],
    },
    Decomposition {
        kanji: '廼',
        radicals: &['西', '廴'],
    },
    Decomposition {
        kanji: '之',
        radicals: &['乙', '丶', '亠', '廴'],
    },
    Decomposition {
        kanji: '埜',
        radicals: &['土', '木'],
    },
    Decomposition {
        kanji: '嚢',
        radicals: &['｜', '衣', '一', '口', 'ハ', '亠', '冖'],
    },
    Decomposition {
        kanji: '悩',
        radicals: &['⺌', '⺖', '凵'],
    },
    Decomposition {
        kanji: '濃',
        radicals: &['｜', '衣', '一', '⺡', '辰', '日', '厂'],
    },
    Decomposition {
        kanji: '納',
        radicals: &['糸', '幺', '小', '人', '冂'],
    },
    Decomposition {
        kanji: '能',
        radicals: &['月', '匕', '厶'],
    },
    Decomposition {
        kanji: '脳',
        radicals: &['月', '⺌', '凵'],
    },
    Decomposition {
        kanji: '膿',
        radicals: &['｜', '衣', '一', '月', '辰', '日', '厂'],
    },
    Decomposition {
        kanji: '農',
        radicals: &['｜', '衣', '一', '辰', '日', '厂'],
    },
    Decomposition {
        kanji: '覗',
        radicals: &['見', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '蚤',
        radicals: &['虫', '又'],
    },
    Decomposition {
        kanji: '巴',
        radicals: &['乙', '已', '巴'],
    },
    Decomposition {
        kanji: '把',
        radicals: &['巴', '扌'],
    },
    Decomposition {
        kanji: '播',
        radicals: &['田', '釆', '米', '扌'],
    },
    Decomposition {
        kanji: '覇',
        radicals: &['革', '月', '西'],
    },
    Decomposition {
        kanji: '杷',
        radicals: &['木', '巴'],
    },
    Decomposition {
        kanji: '波',
        radicals: &['⺡', '皮', '又'],
    },
    Decomposition {
        kanji: '派',
        radicals: &['斤', '⺡', '厂'],
    },
    Decomposition {
        kanji: '琶',
        radicals: &['王', '巴'],
    },
    Decomposition {
        kanji: '破',
        radicals: &['口', '石', '皮', '又'],
    },
    Decomposition {
        kanji: '婆',
        radicals: &['⺡', '女', '皮', '又'],
    },
    Decomposition {
        kanji: '罵',
        radicals: &['馬', '⺲', '⺣'],
    },
    Decomposition {
        kanji: '芭',
        radicals: &['巴', '⺾'],
    },
    Decomposition {
        kanji: '馬',
        radicals: &['馬', '⺣'],
    },
    Decomposition {
        kanji: '俳',
        radicals: &['⺅', '非'],
    },
    Decomposition {
        kanji: '廃',
        radicals: &['一', '儿', '广', '癶'],
    },
    Decomposition {
        kanji: '拝',
        radicals: &['｜', '一', '干', '扌'],
    },
    Decomposition {
        kanji: '排',
        radicals: &['非', '扌'],
    },
    Decomposition {
        kanji: '敗',
        radicals: &['貝', '目', 'ハ', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '杯',
        radicals: &['｜', 'ノ', '一', '木', '⺭'],
    },
    Decomposition {
        kanji: '盃',
        radicals: &['ノ', '一', '皿'],
    },
    Decomposition {
        kanji: '牌',
        radicals: &['十', '田', '片'],
    },
    Decomposition {
        kanji: '背',
        radicals: &['月', '匕', '爿'],
    },
    Decomposition {
        kanji: '肺',
        radicals: &['巾', '月', '亠'],
    },
    Decomposition {
        kanji: '輩',
        radicals: &['車', '非'],
    },
    Decomposition {
        kanji: '配',
        radicals: &['酉', '已'],
    },
    Decomposition {
        kanji: '倍',
        radicals: &['⺅', '口', '立'],
    },
    Decomposition {
        kanji: '培',
        radicals: &['口', '土', '立'],
    },
    Decomposition {
        kanji: '媒',
        radicals: &['甘', '女', '木'],
    },
    Decomposition {
        kanji: '梅',
        radicals: &['母', '木', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '楳',
        radicals: &['甘', '木'],
    },
    Decomposition {
        kanji: '煤',
        radicals: &['火', '甘', '木'],
    },
    Decomposition {
        kanji: '狽',
        radicals: &['貝', '目', 'ハ', '⺨'],
    },
    Decomposition {
        kanji: '買',
        radicals: &['貝', '目', 'ハ', '⺲'],
    },
    Decomposition {
        kanji: '売',
        radicals: &['士', '儿', '冖'],
    },
    Decomposition {
        kanji: '賠',
        radicals: &['貝', '目', 'ハ', '口', '立'],
    },
    Decomposition {
        kanji: '陪',
        radicals: &['口', '立', '⻖'],
    },
    Decomposition {
        kanji: '這',
        radicals: &['言', '⻌'],
    },
    Decomposition {
        kanji: '蝿',
        radicals: &['亀', '虫', '田', '乙', '勹'],
    },
    Decomposition {
        kanji: '秤',
        radicals: &['禾', '干', '丷'],
    },
    Decomposition {
        kanji: '矧',
        radicals: &['｜', '弓', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '萩',
        radicals: &['火', '禾', '⺾'],
    },
    Decomposition {
        kanji: '伯',
        radicals: &['⺅', '白'],
    },
    Decomposition {
        kanji: '剥',
        radicals: &['ヨ', '⺉', '水'],
    },
    Decomposition {
        kanji: '博',
        radicals: &['十', '寸', '田', '丶'],
    },
    Decomposition {
        kanji: '拍',
        radicals: &['白', '扌'],
    },
    Decomposition {
        kanji: '柏',
        radicals: &['白', '木'],
    },
    Decomposition {
        kanji: '泊',
        radicals: &['⺡', '白'],
    },
    Decomposition {
        kanji: '白',
        radicals: &['白'],
    },
    Decomposition {
        kanji: '箔',
        radicals: &['⺡', '竹', '白', '𠂉'],
    },
    Decomposition {
        kanji: '粕',
        radicals: &['白', '米'],
    },
    Decomposition {
        kanji: '舶',
        radicals: &['舟', '白'],
    },
    Decomposition {
        kanji: '薄',
        radicals: &['十', '⺡', '寸', '田', '丶', '⺾'],
    },
    Decomposition {
        kanji: '迫',
        radicals: &['⻌', '白'],
    },
    Decomposition {
        kanji: '曝',
        radicals: &['｜', '一', '水', '日', 'ハ'],
    },
    Decomposition {
        kanji: '漠',
        radicals: &['⺡', '大', '日', '⺾'],
    },
    Decomposition {
        kanji: '爆',
        radicals: &['｜', '一', '火', '水', '日', 'ハ', '井'],
    },
    Decomposition {
        kanji: '縛',
        radicals: &['糸', '幺', '小', '十', '寸', '田', '丶'],
    },
    Decomposition {
        kanji: '莫',
        radicals: &['大', '日', '⺾'],
    },
    Decomposition {
        kanji: '駁',
        radicals: &['馬', '爻', '⺣'],
    },
    Decomposition {
        kanji: '麦',
        radicals: &['麦', '夂', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '函',
        radicals: &['一', '水', '凵'],
    },
    Decomposition {
        kanji: '箱',
        radicals: &['竹', '木', '目', '𠂉'],
    },
    Decomposition {
        kanji: '硲',
        radicals: &['口', '石', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '箸',
        radicals: &['竹', '日', '⺹', '𠂉'],
    },
    Decomposition {
        kanji: '肇',
        radicals: &['戸', '攵', '聿', '一', '尸', '𠂉'],
    },
    Decomposition {
        kanji: '筈',
        radicals: &['口', '舌', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '櫨',
        radicals: &['皿', '田', '卜', '木', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '幡',
        radicals: &['巾', '田', '釆', '米'],
    },
    Decomposition {
        kanji: '肌',
        radicals: &['月', '几'],
    },
    Decomposition {
        kanji: '畑',
        radicals: &['火', '田'],
    },
    Decomposition {
        kanji: '畠',
        radicals: &['田', '白'],
    },
    Decomposition {
        kanji: '八',
        radicals: &['ハ'],
    },
    Decomposition {
        kanji: '鉢',
        radicals: &['一', '金', '木'],
    },
    Decomposition {
        kanji: '溌',
        radicals: &['二', '⺡', '儿', '癶'],
    },
    Decomposition {
        kanji: '発',
        radicals: &['二', '儿', '癶'],
    },
    Decomposition {
        kanji: '醗',
        radicals: &['二', '酉', '儿', '癶'],
    },
    Decomposition {
        kanji: '髪',
        radicals: &['夂', '一', '長', '彡', '髟'],
    },
    Decomposition {
        kanji: '伐',
        radicals: &['⺅', '戈'],
    },
    Decomposition {
        kanji: '罰',
        radicals: &['⺉', '言', '⺲'],
    },
    Decomposition {
        kanji: '抜',
        radicals: &['夂', '亠', '扌', '又'],
    },
    Decomposition {
        kanji: '筏',
        radicals: &['⺅', '竹', '戈', '𠂉'],
    },
    Decomposition {
        kanji: '閥',
        radicals: &['⺅', '門', '戈'],
    },
    Decomposition {
        kanji: '鳩',
        radicals: &['九', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '噺',
        radicals: &['斤', '口', '辛', '丷', '木', '立', '亠'],
    },
    Decomposition {
        kanji: '塙',
        radicals: &['口', '高', '土', '亠', '冂'],
    },
    Decomposition {
        kanji: '蛤',
        radicals: &['口', '虫', '𠆢', '一'],
    },
    Decomposition {
        kanji: '隼',
        radicals: &['十', '隹'],
    },
    Decomposition {
        kanji: '伴',
        radicals: &['｜', '⺅', '二', '丷', '十'],
    },
    Decomposition {
        kanji: '判',
        radicals: &['｜', '⺉', '二', '丷', '十'],
    },
    Decomposition {
        kanji: '半',
        radicals: &['｜', '二', '丷', '十'],
    },
    Decomposition {
        kanji: '反',
        radicals: &['又', '厂'],
    },
    Decomposition {
        kanji: '叛',
        radicals: &['丷', '又', '厂'],
    },
    Decomposition {
        kanji: '帆',
        radicals: &['巾', '丶', '几'],
    },
    Decomposition {
        kanji: '搬',
        radicals: &['舟', '扌', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '斑',
        radicals: &['王', '文'],
    },
    Decomposition {
        kanji: '板',
        radicals: &['又', '木', '厂'],
    },
    Decomposition {
        kanji: '氾',
        radicals: &['乙', '⺡', '卩'],
    },
    Decomposition {
        kanji: '汎',
        radicals: &['⺡', '丶', '几'],
    },
    Decomposition {
        kanji: '版',
        radicals: &['片', '又', '厂'],
    },
    Decomposition {
        kanji: '犯',
        radicals: &['乙', '⺨', '卩'],
    },
    Decomposition {
        kanji: '班',
        radicals: &['王', '⺉'],
    },
    Decomposition {
        kanji: '畔',
        radicals: &['｜', '田', '二', '丷', '十'],
    },
    Decomposition {
        kanji: '繁',
        radicals: &['糸', '幺', '小', '母', '攵', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '般',
        radicals: &['舟', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '藩',
        radicals: &['⺡', '田', '釆', '米', '⺾'],
    },
    Decomposition {
        kanji: '販',
        radicals: &['貝', '目', 'ハ', '又', '厂'],
    },
    Decomposition {
        kanji: '範',
        radicals: &['乙', '車', '竹', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '釆',
        radicals: &['釆', '米'],
    },
    Decomposition {
        kanji: '煩',
        radicals: &['火', '貝', '目', 'ハ', '頁'],
    },
    Decomposition {
        kanji: '頒',
        radicals: &['貝', '目', '刀', 'ハ', '頁'],
    },
    Decomposition {
        kanji: '飯',
        radicals: &['食', '又', '厂'],
    },
    Decomposition {
        kanji: '挽',
        radicals: &['｜', '一', '免', '儿', '扌', '勹'],
    },
    Decomposition {
        kanji: '晩',
        radicals: &['免', '日', '儿', '勹'],
    },
    Decomposition {
        kanji: '番',
        radicals: &['田', '釆', '米'],
    },
    Decomposition {
        kanji: '盤',
        radicals: &['皿', '舟', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '磐',
        radicals: &['口', '舟', '石', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '蕃',
        radicals: &['田', '釆', '米', '⺾'],
    },
    Decomposition {
        kanji: '蛮',
        radicals: &['虫', '亠'],
    },
    Decomposition {
        kanji: '匪',
        radicals: &['非', '匚'],
    },
    Decomposition {
        kanji: '卑',
        radicals: &['十', '田'],
    },
    Decomposition {
        kanji: '否',
        radicals: &['ノ', '一', '口', '｜', '丶'],
    },
    Decomposition {
        kanji: '妃',
        radicals: &['女', '已'],
    },
    Decomposition {
        kanji: '庇',
        radicals: &['比', '广'],
    },
    Decomposition {
        kanji: '彼',
        radicals: &['皮', '又', '彳'],
    },
    Decomposition {
        kanji: '悲',
        radicals: &['心', '非'],
    },
    Decomposition {
        kanji: '扉',
        radicals: &['戸', '非', '一', '尸'],
    },
    Decomposition {
        kanji: '批',
        radicals: &['比', '扌'],
    },
    Decomposition {
        kanji: '披',
        radicals: &['皮', '又', '扌'],
    },
    Decomposition {
        kanji: '斐',
        radicals: &['非', '文'],
    },
    Decomposition {
        kanji: '比',
        radicals: &['比'],
    },
    Decomposition {
        kanji: '泌',
        radicals: &['ノ', '⺡', '心', '丶'],
    },
    Decomposition {
        kanji: '疲',
        radicals: &['皮', '又', '⽧'],
    },
    Decomposition {
        kanji: '皮',
        radicals: &['皮', '又'],
    },
    Decomposition {
        kanji: '碑',
        radicals: &['口', '十', '石', '田'],
    },
    Decomposition {
        kanji: '秘',
        radicals: &['ノ', '禾', '心', '丶'],
    },
    Decomposition {
        kanji: '緋',
        radicals: &['糸', '幺', '小', '非'],
    },
    Decomposition {
        kanji: '罷',
        radicals: &['月', '⺲', '匕', '厶'],
    },
    Decomposition {
        kanji: '肥',
        radicals: &['月', '巴'],
    },
    Decomposition {
        kanji: '被',
        radicals: &['⻂', '皮', '又'],
    },
    Decomposition {
        kanji: '誹',
        radicals: &['言', '非'],
    },
    Decomposition {
        kanji: '費',
        radicals: &['｜', '貝', '目', 'ハ', '弓'],
    },
    Decomposition {
        kanji: '避',
        radicals: &['口', '⻌', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '非',
        radicals: &['非'],
    },
    Decomposition {
        kanji: '飛',
        radicals: &['飛'],
    },
    Decomposition {
        kanji: '樋',
        radicals: &['⻌', '木', '用', 'マ'],
    },
    Decomposition {
        kanji: '簸',
        radicals: &['甘', '竹', '皮', '又', '𠂉'],
    },
    Decomposition {
        kanji: '備',
        radicals: &['⺅', '用', '厂', '⺾'],
    },
    Decomposition {
        kanji: '尾',
        radicals: &['毛', '尸'],
    },
    Decomposition {
        kanji: '微',
        radicals: &['山', '彳', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '枇',
        radicals: &['比', '木'],
    },
    Decomposition {
        kanji: '毘',
        radicals: &['田', '比'],
    },
    Decomposition {
        kanji: '琵',
        radicals: &['王', '比'],
    },
    Decomposition {
        kanji: '眉',
        radicals: &['目', '尸', '｜'],
    },
    Decomposition {
        kanji: '美',
        radicals: &['王', '大', '丷', '羊'],
    },
    Decomposition {
        kanji: '鼻',
        radicals: &['自', '田', '廾', '鼻', '目'],
    },
    Decomposition {
        kanji: '柊',
        radicals: &['木', '夂', '丶'],
    },
    Decomposition {
        kanji: '稗',
        radicals: &['禾', '十', '田'],
    },
    Decomposition {
        kanji: '匹',
        radicals: &['儿', '匚'],
    },
    Decomposition {
        kanji: '疋',
        radicals: &['疋'],
    },
    Decomposition {
        kanji: '髭',
        radicals: &['止', '長', '匕', '彡', '髟'],
    },
    Decomposition {
        kanji: '彦',
        radicals: &['丷', '立', '亠', '厂', '彡'],
    },
    Decomposition {
        kanji: '膝',
        radicals: &['月', '水', '木', '𠆢'],
    },
    Decomposition {
        kanji: '菱',
        radicals: &['土', '儿', '夂', '⺾'],
    },
    Decomposition {
        kanji: '肘',
        radicals: &['月', '寸'],
    },
    Decomposition {
        kanji: '弼',
        radicals: &['弓', '白', 'ノ'],
    },
    Decomposition {
        kanji: '必',
        radicals: &['ノ', '心'],
    },
    Decomposition {
        kanji: '畢',
        radicals: &['｜', '一', '田'],
    },
    Decomposition {
        kanji: '筆',
        radicals: &['竹', '聿', '𠂉'],
    },
    Decomposition {
        kanji: '逼',
        radicals: &['口', '⻌', '田', '一'],
    },
    Decomposition {
        kanji: '桧',
        radicals: &['二', '木', '𠆢', '厶'],
    },
    Decomposition {
        kanji: '姫',
        radicals: &['女', '臣'],
    },
    Decomposition {
        kanji: '媛',
        radicals: &['ノ', '女', '爪', '又'],
    },
    Decomposition {
        kanji: '紐',
        radicals: &['｜', '一', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '百',
        radicals: &['一', '白'],
    },
    Decomposition {
        kanji: '謬',
        radicals: &['羽', '言', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '俵',
        radicals: &['衣', '⺅', '士', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '彪',
        radicals: &['卜', '儿', '匕', '厂', '彡', '虍'],
    },
    Decomposition {
        kanji: '標',
        radicals: &['示', '二', '小', '西', '木'],
    },
    Decomposition {
        kanji: '氷',
        radicals: &['水', '丶'],
    },
    Decomposition {
        kanji: '漂',
        radicals: &['示', '二', '小', '⺡', '西'],
    },
    Decomposition {
        kanji: '瓢',
        radicals: &['瓜', '示', '二', '小', '西'],
    },
    Decomposition {
        kanji: '票',
        radicals: &['示', '二', '小', '西'],
    },
    Decomposition {
        kanji: '表',
        radicals: &['衣', '士', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '評',
        radicals: &['｜', '一', '言', '二', '丷'],
    },
    Decomposition {
        kanji: '豹',
        radicals: &['丶', '勹', '豸'],
    },
    Decomposition {
        kanji: '廟',
        radicals: &['月', '十', '日', '广'],
    },
    Decomposition {
        kanji: '描',
        radicals: &['田', '扌', '⺾'],
    },
    Decomposition {
        kanji: '病',
        radicals: &['一', '人', '冂', '⽧'],
    },
    Decomposition {
        kanji: '秒',
        radicals: &['ノ', '禾', '小'],
    },
    Decomposition {
        kanji: '苗',
        radicals: &['田', '⺾'],
    },
    Decomposition {
        kanji: '錨',
        radicals: &['金', '田', '⺾'],
    },
    Decomposition {
        kanji: '鋲',
        radicals: &['斤', '金', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '蒜',
        radicals: &['示', '二', '小', '⺾'],
    },
    Decomposition {
        kanji: '蛭',
        radicals: &['至', '虫', '土', '厶', '一'],
    },
    Decomposition {
        kanji: '鰭',
        radicals: &['魚', '田', '日', '⺹', '⺣', '匕'],
    },
    Decomposition {
        kanji: '品',
        radicals: &['口', '品'],
    },
    Decomposition {
        kanji: '彬',
        radicals: &['木', '彡'],
    },
    Decomposition {
        kanji: '斌',
        radicals: &['止', '文', '弋'],
    },
    Decomposition {
        kanji: '浜',
        radicals: &['斤', '⺡', 'ハ', '一'],
    },
    Decomposition {
        kanji: '瀕',
        radicals: &['ノ', '貝', '目', 'ハ', '止', '⺡', '小', '頁'],
    },
    Decomposition {
        kanji: '貧',
        radicals: &['貝', '目', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '賓',
        radicals: &['ノ', '貝', '目', 'ハ', '小', '宀', '一'],
    },
    Decomposition {
        kanji: '頻',
        radicals: &['ノ', '貝', '目', 'ハ', '止', '小', '頁'],
    },
    Decomposition {
        kanji: '敏',
        radicals: &['母', '攵', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '瓶',
        radicals: &['瓦', '丷', '二', '一', 'ノ'],
    },
    Decomposition {
        kanji: '不',
        radicals: &['｜', 'ノ', '一', '丶'],
    },
    Decomposition {
        kanji: '付',
        radicals: &['⺅', '寸'],
    },
    Decomposition {
        kanji: '埠',
        radicals: &['｜', '口', '十', '土', '⻖'],
    },
    Decomposition {
        kanji: '夫',
        radicals: &['人', '二', '大'],
    },
    Decomposition {
        kanji: '婦',
        radicals: &['ヨ', '巾', '女', '冖'],
    },
    Decomposition {
        kanji: '富',
        radicals: &['口', '田', '宀', '一'],
    },
    Decomposition {
        kanji: '冨',
        radicals: &['口', '田', '冖', '一'],
    },
    Decomposition {
        kanji: '布',
        radicals: &['ノ', '一', '巾'],
    },
    Decomposition {
        kanji: '府',
        radicals: &['⺅', '寸', '广'],
    },
    Decomposition {
        kanji: '怖',
        radicals: &['ノ', '一', '巾', '⺖'],
    },
    Decomposition {
        kanji: '扶',
        radicals: &['人', '二', '扌', '大'],
    },
    Decomposition {
        kanji: '敷',
        radicals: &['十', '田', '方', '丶', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '斧',
        radicals: &['斤', '父'],
    },
    Decomposition {
        kanji: '普',
        radicals: &['｜', '一', '二', '日', '丷'],
    },
    Decomposition {
        kanji: '浮',
        radicals: &['子', '⺡', '爪'],
    },
    Decomposition {
        kanji: '父',
        radicals: &['父'],
    },
    Decomposition {
        kanji: '符',
        radicals: &['⺅', '寸', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '腐',
        radicals: &['⺅', '寸', '肉', '广'],
    },
    Decomposition {
        kanji: '膚',
        radicals: &['月', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '芙',
        radicals: &['人', '二', '⺾', '大'],
    },
    Decomposition {
        kanji: '譜',
        radicals: &['｜', '一', '言', '二', '日', '丷'],
    },
    Decomposition {
        kanji: '負',
        radicals: &['貝', '目', 'ハ', '勹'],
    },
    Decomposition {
        kanji: '賦',
        radicals: &['貝', '目', 'ハ', '止', '弋'],
    },
    Decomposition {
        kanji: '赴',
        radicals: &['走', '土', '卜'],
    },
    Decomposition {
        kanji: '阜',
        radicals: &['⻖', '十', '口', '｜'],
    },
    Decomposition {
        kanji: '附',
        radicals: &['⺅', '寸', '⻖'],
    },
    Decomposition {
        kanji: '侮',
        radicals: &['⺅', '母', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '撫',
        radicals: &['｜', 'ノ', '一', '扌', '⺣', '無', '𠂉'],
    },
    Decomposition {
        kanji: '武',
        radicals: &['止', '弋'],
    },
    Decomposition {
        kanji: '舞',
        radicals: &['｜', 'ノ', '一', '舛', '二', '夕', '無', '𠂉'],
    },
    Decomposition {
        kanji: '葡',
        radicals: &['十', '用', '勹', '⺾', '丶'],
    },
    Decomposition {
        kanji: '蕪',
        radicals: &['｜', 'ノ', '一', '⺣', '⺾', '無', '𠂉'],
    },
    Decomposition {
        kanji: '部',
        radicals: &['口', '⻏', '立'],
    },
    Decomposition {
        kanji: '封',
        radicals: &['寸', '土'],
    },
    Decomposition {
        kanji: '楓',
        radicals: &['風', '木', '几', '虫', 'ノ'],
    },
    Decomposition {
        kanji: '風',
        radicals: &['風', '几', '虫', 'ノ'],
    },
    Decomposition {
        kanji: '葺',
        radicals: &['口', '耳', '⺾'],
    },
    Decomposition {
        kanji: '蕗',
        radicals: &['口', '足', '夂', '⺾', '止'],
    },
    Decomposition {
        kanji: '伏',
        radicals: &['⺅', '犬'],
    },
    Decomposition {
        kanji: '副',
        radicals: &['一', '⺉', '口', '田'],
    },
    Decomposition {
        kanji: '復',
        radicals: &['日', '夂', '彳', 'ノ', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '幅',
        radicals: &['一', '巾', '口', '田'],
    },
    Decomposition {
        kanji: '服',
        radicals: &['月', '又', '卩'],
    },
    Decomposition {
        kanji: '福',
        radicals: &['一', '口', '田', '⺭'],
    },
    Decomposition {
        kanji: '腹',
        radicals: &['月', '日', '夂', 'ノ', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '複',
        radicals: &['⻂', '日', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '覆',
        radicals: &['西', '日', '夂', '彳', '𠂉'],
    },
    Decomposition {
        kanji: '淵',
        radicals: &['｜', '一', '⺡'],
    },
    Decomposition {
        kanji: '弗',
        radicals: &['｜', 'ノ', '弓'],
    },
    Decomposition {
        kanji: '払',
        radicals: &['厶', '扌'],
    },
    Decomposition {
        kanji: '沸',
        radicals: &['｜', 'ノ', '弓', '⺡'],
    },
    Decomposition {
        kanji: '仏',
        radicals: &['⺅', '厶'],
    },
    Decomposition {
        kanji: '物',
        radicals: &['勿', '牛', '勹', 'ノ'],
    },
    Decomposition {
        kanji: '鮒',
        radicals: &['⺅', '魚', '寸', '田', '⺣'],
    },
    Decomposition {
        kanji: '分',
        radicals: &['刀', 'ハ'],
    },
    Decomposition {
        kanji: '吻',
        radicals: &['勿', '口', '勹', 'ノ'],
    },
    Decomposition {
        kanji: '噴',
        radicals: &['貝', '目', 'ハ', '口', '十', '⺾'],
    },
    Decomposition {
        kanji: '墳',
        radicals: &['貝', '目', 'ハ', '十', '土', '⺾'],
    },
    Decomposition {
        kanji: '憤',
        radicals: &['貝', '目', 'ハ', '十', '⺖', '⺾'],
    },
    Decomposition {
        kanji: '扮',
        radicals: &['刀', 'ハ', '扌'],
    },
    Decomposition {
        kanji: '焚',
        radicals: &['火', '木'],
    },
    Decomposition {
        kanji: '奮',
        radicals: &['大', '田', '隹'],
    },
    Decomposition {
        kanji: '粉',
        radicals: &['刀', '丷', '米', 'ハ'],
    },
    Decomposition {
        kanji: '糞',
        radicals: &['｜', '一', '田', '二', '丷', '米', '井'],
    },
    Decomposition {
        kanji: '紛',
        radicals: &['糸', '幺', '小', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '雰',
        radicals: &['雨', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '文',
        radicals: &['文'],
    },
    Decomposition {
        kanji: '聞',
        radicals: &['耳', '門'],
    },
    Decomposition {
        kanji: '丙',
        radicals: &['一', '人', '冂'],
    },
    Decomposition {
        kanji: '併',
        radicals: &['｜', 'ノ', '一', '⺅', '二', '丷', '廾'],
    },
    Decomposition {
        kanji: '兵',
        radicals: &['一', '斤', 'ハ'],
    },
    Decomposition {
        kanji: '塀',
        radicals: &['｜', 'ノ', '一', '土', '二', 'ハ', '尸', '廾'],
    },
    Decomposition {
        kanji: '幣',
        radicals: &['巾', '丷', '冂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '平',
        radicals: &['干', '丷'],
    },
    Decomposition {
        kanji: '弊',
        radicals: &['｜', '巾', '⺌', '丷', '冂', '廾', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '柄',
        radicals: &['一', '人', '木', '冂'],
    },
    Decomposition {
        kanji: '並',
        radicals: &['｜', '一', '二', '丷'],
    },
    Decomposition {
        kanji: '蔽',
        radicals: &['｜', '巾', '⺌', '丷', '冂', '攵', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '閉',
        radicals: &['ノ', '一', '門', '亅'],
    },
    Decomposition {
        kanji: '陛',
        radicals: &['土', '比', '⻖'],
    },
    Decomposition {
        kanji: '米',
        radicals: &['米'],
    },
    Decomposition {
        kanji: '頁',
        radicals: &['貝', '目', 'ハ', '頁'],
    },
    Decomposition {
        kanji: '僻',
        radicals: &['⺅', '口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '壁',
        radicals: &['口', '十', '辛', '土', '立', '尸'],
    },
    Decomposition {
        kanji: '癖',
        radicals: &['口', '十', '辛', '立', '尸', '⽧'],
    },
    Decomposition {
        kanji: '碧',
        radicals: &['王', '口', '石', '白'],
    },
    Decomposition {
        kanji: '別',
        radicals: &['⺉', '口', '力', '勹'],
    },
    Decomposition {
        kanji: '瞥',
        radicals: &['｜', '巾', '⺌', '丷', '目', '冂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '蔑',
        radicals: &['ノ', '⺲', '戈', '⺾'],
    },
    Decomposition {
        kanji: '箆',
        radicals: &['竹', '比', '冂', '𠂉'],
    },
    Decomposition {
        kanji: '偏',
        radicals: &['｜', '一', '⺅', '戸', '冂', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '変',
        radicals: &['亠', '夂'],
    },
    Decomposition {
        kanji: '片',
        radicals: &['片'],
    },
    Decomposition {
        kanji: '篇',
        radicals: &['｜', '一', '戸', '竹', '冂', '冊', '尸', '廾', '𠂉'],
    },
    Decomposition {
        kanji: '編',
        radicals: &['｜', '一', '戸', '糸', '幺', '小', '冂', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '辺',
        radicals: &['⻌', '刀'],
    },
    Decomposition {
        kanji: '返',
        radicals: &['⻌', '又', '厂'],
    },
    Decomposition {
        kanji: '遍',
        radicals: &['｜', '一', '戸', '⻌', '冂', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '便',
        radicals: &['｜', 'ノ', '一', '⺅', '日', '田'],
    },
    Decomposition {
        kanji: '勉',
        radicals: &['力', '免', '儿', '勹'],
    },
    Decomposition {
        kanji: '娩',
        radicals: &['女', '免', '儿', '勹'],
    },
    Decomposition {
        kanji: '弁',
        radicals: &['厶', '廾'],
    },
    Decomposition {
        kanji: '鞭',
        radicals: &['ノ', '一', '⺅', '革', '日', '田'],
    },
    Decomposition {
        kanji: '保',
        radicals: &['⺅', '口', '木'],
    },
    Decomposition {
        kanji: '舗',
        radicals: &['口', '十', '土', '用', '𠆢', '丶'],
    },
    Decomposition {
        kanji: '鋪',
        radicals: &['金', '十', '用', '丶'],
    },
    Decomposition {
        kanji: '圃',
        radicals: &['十', '用', '丶', '囗'],
    },
    Decomposition {
        kanji: '捕',
        radicals: &['十', '用', '丶', '扌'],
    },
    Decomposition {
        kanji: '歩',
        radicals: &['ノ', '止', '小'],
    },
    Decomposition {
        kanji: '甫',
        radicals: &['十', '用', '丶'],
    },
    Decomposition {
        kanji: '補',
        radicals: &['十', '⻂', '用', '丶'],
    },
    Decomposition {
        kanji: '輔',
        radicals: &['車', '十', '用', '丶'],
    },
    Decomposition {
        kanji: '穂',
        radicals: &['禾', '十', '心', '田'],
    },
    Decomposition {
        kanji: '募',
        radicals: &['大', '日', '力', '⺾'],
    },
    Decomposition {
        kanji: '墓',
        radicals: &['大', '土', '日', '⺾'],
    },
    Decomposition {
        kanji: '慕',
        radicals: &['心', '大', '日', '⺾'],
    },
    Decomposition {
        kanji: '戊',
        radicals: &['ノ', '戈'],
    },
    Decomposition {
        kanji: '暮',
        radicals: &['大', '日', '⺾'],
    },
    Decomposition {
        kanji: '母',
        radicals: &['母', '毋'],
    },
    Decomposition {
        kanji: '簿',
        radicals: &['十', '⺡', '寸', '竹', '田', '丶', '𠂉'],
    },
    Decomposition {
        kanji: '菩',
        radicals: &['口', '立', '⺾'],
    },
    Decomposition {
        kanji: '倣',
        radicals: &['⺅', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '俸',
        radicals: &['｜', '一', '⺅', '人', '大', '二'],
    },
    Decomposition {
        kanji: '包',
        radicals: &['勹', '已'],
    },
    Decomposition {
        kanji: '呆',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '報',
        radicals: &['十', '辛', '土', '又', '立', '亠', '卩'],
    },
    Decomposition {
        kanji: '奉',
        radicals: &['｜', '一', '人', '大', '二'],
    },
    Decomposition {
        kanji: '宝',
        radicals: &['王', '宀', '丶'],
    },
    Decomposition {
        kanji: '峰',
        radicals: &['｜', '一', '山', '夂'],
    },
    Decomposition {
        kanji: '峯',
        radicals: &['｜', '一', '山', '夂'],
    },
    Decomposition {
        kanji: '崩',
        radicals: &['月', '山'],
    },
    Decomposition {
        kanji: '庖',
        radicals: &['勹', '已', '广'],
    },
    Decomposition {
        kanji: '抱',
        radicals: &['勹', '已', '扌'],
    },
    Decomposition {
        kanji: '捧',
        radicals: &['｜', '一', '人', '大', '二', '扌'],
    },
    Decomposition {
        kanji: '放',
        radicals: &['方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '方',
        radicals: &['方'],
    },
    Decomposition {
        kanji: '朋',
        radicals: &['月'],
    },
    Decomposition {
        kanji: '法',
        radicals: &['⺡', '土', '厶'],
    },
    Decomposition {
        kanji: '泡',
        radicals: &['⺡', '勹', '已'],
    },
    Decomposition {
        kanji: '烹',
        radicals: &['口', '亅', '亠', '⺣'],
    },
    Decomposition {
        kanji: '砲',
        radicals: &['口', '石', '勹', '已'],
    },
    Decomposition {
        kanji: '縫',
        radicals: &['｜', '一', '⻌', '糸', '幺', '小', '夂'],
    },
    Decomposition {
        kanji: '胞',
        radicals: &['月', '勹', '已'],
    },
    Decomposition {
        kanji: '芳',
        radicals: &['方', '⺾'],
    },
    Decomposition {
        kanji: '萌',
        radicals: &['月', '日', '⺾'],
    },
    Decomposition {
        kanji: '蓬',
        radicals: &['｜', '一', '⻌', '夂', '⺾'],
    },
    Decomposition {
        kanji: '蜂',
        radicals: &['｜', '一', '虫', '夂'],
    },
    Decomposition {
        kanji: '褒',
        radicals: &['衣', '⺅', '口', '小', '亠'],
    },
    Decomposition {
        kanji: '訪',
        radicals: &['言', '方'],
    },
    Decomposition {
        kanji: '豊',
        radicals: &['｜', '一', '口', '豆', '日', '丷'],
    },
    Decomposition {
        kanji: '邦',
        radicals: &['ノ', '二', '⻏'],
    },
    Decomposition {
        kanji: '鋒',
        radicals: &['｜', '一', '金', '夂'],
    },
    Decomposition {
        kanji: '飽',
        radicals: &['食', '勹', '已'],
    },
    Decomposition {
        kanji: '鳳',
        radicals: &['鳥', '几', '⺣'],
    },
    Decomposition {
        kanji: '鵬',
        radicals: &['月', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '乏',
        radicals: &['ノ', '乙', '丶', '亠', '廴'],
    },
    Decomposition {
        kanji: '亡',
        radicals: &['亡', '亠'],
    },
    Decomposition {
        kanji: '傍',
        radicals: &['⺅', '丷', '方', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '剖',
        radicals: &['⺉', '口', '立'],
    },
    Decomposition {
        kanji: '坊',
        radicals: &['土', '方'],
    },
    Decomposition {
        kanji: '妨',
        radicals: &['女', '方'],
    },
    Decomposition {
        kanji: '帽',
        radicals: &['巾', '日', '目'],
    },
    Decomposition {
        kanji: '忘',
        radicals: &['心', '亡', '亠'],
    },
    Decomposition {
        kanji: '忙',
        radicals: &['亡', '⺖', '亠'],
    },
    Decomposition {
        kanji: '房',
        radicals: &['戸', '方', '一', '尸'],
    },
    Decomposition {
        kanji: '暴',
        radicals: &['｜', '一', '水', '二', '日', 'ハ', '井'],
    },
    Decomposition {
        kanji: '望',
        radicals: &['王', '亡', '月'],
    },
    Decomposition {
        kanji: '某',
        radicals: &['甘', '木'],
    },
    Decomposition {
        kanji: '棒',
        radicals: &['｜', '一', '人', '木', '二', '大'],
    },
    Decomposition {
        kanji: '冒',
        radicals: &['日', '目'],
    },
    Decomposition {
        kanji: '紡',
        radicals: &['糸', '幺', '小', '方'],
    },
    Decomposition {
        kanji: '肪',
        radicals: &['月', '方'],
    },
    Decomposition {
        kanji: '膨',
        radicals: &['月', '口', '十', '土', '豆', '丷', '彡'],
    },
    Decomposition {
        kanji: '謀',
        radicals: &['甘', '言', '木'],
    },
    Decomposition {
        kanji: '貌',
        radicals: &['白', '儿', '豸'],
    },
    Decomposition {
        kanji: '貿',
        radicals: &['貝', '目', 'ハ', '刀', '厶'],
    },
    Decomposition {
        kanji: '鉾',
        radicals: &['牛', '金', '厶'],
    },
    Decomposition {
        kanji: '防',
        radicals: &['方', '⻖'],
    },
    Decomposition {
        kanji: '吠',
        radicals: &['犬', '口'],
    },
    Decomposition {
        kanji: '頬',
        radicals: &['貝', '目', 'ハ', '人', '頁', '二', '丷', '大'],
    },
    Decomposition {
        kanji: '北',
        radicals: &['匕', '爿'],
    },
    Decomposition {
        kanji: '僕',
        radicals: &['王', '⺅', '丷', '羊', '大', '二'],
    },
    Decomposition {
        kanji: '卜',
        radicals: &['卜'],
    },
    Decomposition {
        kanji: '墨',
        radicals: &['黒', '土', '里', '⺣'],
    },
    Decomposition {
        kanji: '撲',
        radicals: &['王', '人', '丷', '羊', '扌', '二', '大'],
    },
    Decomposition {
        kanji: '朴',
        radicals: &['卜', '木'],
    },
    Decomposition {
        kanji: '牧',
        radicals: &['牛', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '睦',
        radicals: &['土', '目', '儿'],
    },
    Decomposition {
        kanji: '穆',
        radicals: &['禾', '小', '白', '彡'],
    },
    Decomposition {
        kanji: '釦',
        radicals: &['金', '口'],
    },
    Decomposition {
        kanji: '勃',
        radicals: &['子', '十', '力', '冖'],
    },
    Decomposition {
        kanji: '没',
        radicals: &['⺡', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '殆',
        radicals: &['口', '厶', '歹'],
    },
    Decomposition {
        kanji: '堀',
        radicals: &['｜', '山', '土', '尸'],
    },
    Decomposition {
        kanji: '幌',
        radicals: &['巾', '⺌', '日', '儿'],
    },
    Decomposition {
        kanji: '奔',
        radicals: &['ノ', '一', '十', '大', '廾'],
    },
    Decomposition {
        kanji: '本',
        radicals: &['一', '木'],
    },
    Decomposition {
        kanji: '翻',
        radicals: &['羽', '田', '釆', '米', '冫'],
    },
    Decomposition {
        kanji: '凡',
        radicals: &['丶', '几'],
    },
    Decomposition {
        kanji: '盆',
        radicals: &['皿', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '摩',
        radicals: &['手', '木', '广', '麻'],
    },
    Decomposition {
        kanji: '磨',
        radicals: &['口', '石', '木', '广', '麻'],
    },
    Decomposition {
        kanji: '魔',
        radicals: &['鬼', '田', '木', '儿', '匕', '广', '麻', '厶'],
    },
    Decomposition {
        kanji: '麻',
        radicals: &['木', '广', '麻'],
    },
    Decomposition {
        kanji: '埋',
        radicals: &['土', '里'],
    },
    Decomposition {
        kanji: '妹',
        radicals: &['｜', '女', '二', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '昧',
        radicals: &['｜', '二', '日', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '枚',
        radicals: &['木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '毎',
        radicals: &['母', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '哩',
        radicals: &['口', '里'],
    },
    Decomposition {
        kanji: '槙',
        radicals: &['十', 'ハ', '木', '目'],
    },
    Decomposition {
        kanji: '幕',
        radicals: &['巾', '大', '日', '⺾'],
    },
    Decomposition {
        kanji: '膜',
        radicals: &['月', '大', '日', '⺾'],
    },
    Decomposition {
        kanji: '枕',
        radicals: &['ノ', '乙', '木', '冖', '尢'],
    },
    Decomposition {
        kanji: '鮪',
        radicals: &['ノ', '一', '魚', '月', '田', '⺣'],
    },
    Decomposition {
        kanji: '柾',
        radicals: &['一', '止', '木'],
    },
    Decomposition {
        kanji: '鱒',
        radicals: &['魚', '寸', '田', '酉', '丷', '⺣'],
    },
    Decomposition {
        kanji: '桝',
        radicals: &['舛', '木', '夕'],
    },
    Decomposition {
        kanji: '亦',
        radicals: &['ノ', 'ハ', '亅', '亠'],
    },
    Decomposition {
        kanji: '俣',
        radicals: &['⺅', '口', '大', '二', '一'],
    },
    Decomposition {
        kanji: '又',
        radicals: &['又'],
    },
    Decomposition {
        kanji: '抹',
        radicals: &['｜', '一', 'ハ', '木', '亠', '扌'],
    },
    Decomposition {
        kanji: '末',
        radicals: &['｜', '一', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '沫',
        radicals: &['｜', '⺡', '二', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '迄',
        radicals: &['乙', '⻌', '𠂉'],
    },
    Decomposition {
        kanji: '侭',
        radicals: &['⺅', '尸', '丶'],
    },
    Decomposition {
        kanji: '繭',
        radicals: &['糸', '幺', '小', '虫', '風', '冂', '⺾'],
    },
    Decomposition {
        kanji: '麿',
        radicals: &['口', '木', '广', '麻', 'ノ'],
    },
    Decomposition {
        kanji: '万',
        radicals: &['｜', 'ノ', '一'],
    },
    Decomposition {
        kanji: '慢',
        radicals: &['日', '⺲', '⺖', '又'],
    },
    Decomposition {
        kanji: '満',
        radicals: &['｜', '一', '⺡', '二', '冂', '山', '⺾'],
    },
    Decomposition {
        kanji: '漫',
        radicals: &['⺡', '日', '⺲', '又'],
    },
    Decomposition {
        kanji: '蔓',
        radicals: &['日', '⺲', '又', '⺾'],
    },
    Decomposition {
        kanji: '味',
        radicals: &['｜', '口', '二', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '未',
        radicals: &['｜', '二', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '魅',
        radicals: &['｜', '鬼', '田', '二', 'ハ', '木', '亠', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '巳',
        radicals: &['已'],
    },
    Decomposition {
        kanji: '箕',
        radicals: &['甘', '竹', 'ハ', '𠂉'],
    },
    Decomposition {
        kanji: '岬',
        radicals: &['｜', '山', '日', '田'],
    },
    Decomposition {
        kanji: '密',
        radicals: &['ノ', '山', '心', '丶', '宀'],
    },
    Decomposition {
        kanji: '蜜',
        radicals: &['ノ', '心', '虫', '丶', '宀'],
    },
    Decomposition {
        kanji: '湊',
        radicals: &['一', '⺡', '大', '二', '人'],
    },
    Decomposition {
        kanji: '蓑',
        radicals: &['衣', '一', '亠', '⺾'],
    },
    Decomposition {
        kanji: '稔',
        radicals: &['禾', '心', '𠆢', '一'],
    },
    Decomposition {
        kanji: '脈',
        radicals: &['斤', '月', '厂'],
    },
    Decomposition {
        kanji: '妙',
        radicals: &['ノ', '女', '小'],
    },
    Decomposition {
        kanji: '粍',
        radicals: &['米', '毛'],
    },
    Decomposition {
        kanji: '民',
        radicals: &['口', '氏', '尸'],
    },
    Decomposition {
        kanji: '眠',
        radicals: &['口', '氏', '目', '尸'],
    },
    Decomposition {
        kanji: '務',
        radicals: &['矛', '力', '攵'],
    },
    Decomposition {
        kanji: '夢',
        radicals: &['⺲', '夕', '冖', '⺾'],
    },
    Decomposition {
        kanji: '無',
        radicals: &['｜', 'ノ', '一', '⺣', '無', '𠂉'],
    },
    Decomposition {
        kanji: '牟',
        radicals: &['牛', '厶'],
    },
    Decomposition {
        kanji: '矛',
        radicals: &['矛', 'マ'],
    },
    Decomposition {
        kanji: '霧',
        radicals: &['雨', '矛', '力', '攵'],
    },
    Decomposition {
        kanji: '鵡',
        radicals: &['止', '鳥', '弋', '戈', '⺣'],
    },
    Decomposition {
        kanji: '椋',
        radicals: &['口', '小', '木', '亠'],
    },
    Decomposition {
        kanji: '婿',
        radicals: &['月', '女', '疋'],
    },
    Decomposition {
        kanji: '娘',
        radicals: &['艮', '女'],
    },
    Decomposition {
        kanji: '冥',
        radicals: &['日', 'ハ', '亠', '冖'],
    },
    Decomposition {
        kanji: '名',
        radicals: &['口', '夕'],
    },
    Decomposition {
        kanji: '命',
        radicals: &['口', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '明',
        radicals: &['月', '日'],
    },
    Decomposition {
        kanji: '盟',
        radicals: &['月', '皿', '日'],
    },
    Decomposition {
        kanji: '迷',
        radicals: &['⻌', '米'],
    },
    Decomposition {
        kanji: '銘',
        radicals: &['金', '口', '夕'],
    },
    Decomposition {
        kanji: '鳴',
        radicals: &['口', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '姪',
        radicals: &['至', '女', '土', '厶'],
    },
    Decomposition {
        kanji: '牝',
        radicals: &['牛', '匕'],
    },
    Decomposition {
        kanji: '滅',
        radicals: &['ノ', '火', '⺡', '戈'],
    },
    Decomposition {
        kanji: '免',
        radicals: &['｜', '一', '勹', '口', '儿', '免'],
    },
    Decomposition {
        kanji: '棉',
        radicals: &['巾', '白', '木'],
    },
    Decomposition {
        kanji: '綿',
        radicals: &['巾', '糸', '幺', '小', '白'],
    },
    Decomposition {
        kanji: '緬',
        radicals: &['糸', '幺', '小', '面'],
    },
    Decomposition {
        kanji: '面',
        radicals: &['面'],
    },
    Decomposition {
        kanji: '麺',
        radicals: &['麦', '面', '夂', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '摸',
        radicals: &['大', '日', '扌', '⺾'],
    },
    Decomposition {
        kanji: '模',
        radicals: &['大', '日', '木', '⺾'],
    },
    Decomposition {
        kanji: '茂',
        radicals: &['ノ', '戈', '⺾'],
    },
    Decomposition {
        kanji: '妄',
        radicals: &['亡', '女', '亠'],
    },
    Decomposition {
        kanji: '孟',
        radicals: &['皿', '子'],
    },
    Decomposition {
        kanji: '毛',
        radicals: &['毛'],
    },
    Decomposition {
        kanji: '猛',
        radicals: &['皿', '子', '⺨'],
    },
    Decomposition {
        kanji: '盲',
        radicals: &['亡', '目', '亠'],
    },
    Decomposition {
        kanji: '網',
        radicals: &['亡', '糸', '幺', '小', '丷', '冂'],
    },
    Decomposition {
        kanji: '耗',
        radicals: &['｜', '士', 'ハ', '毛', '木', '耒', 'ノ'],
    },
    Decomposition {
        kanji: '蒙',
        radicals: &['冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '儲',
        radicals: &['⺅', '言', '日', '⺹'],
    },
    Decomposition {
        kanji: '木',
        radicals: &['木'],
    },
    Decomposition {
        kanji: '黙',
        radicals: &['犬', '里', '⺣', '黒'],
    },
    Decomposition {
        kanji: '目',
        radicals: &['目'],
    },
    Decomposition {
        kanji: '杢',
        radicals: &['工', '木'],
    },
    Decomposition {
        kanji: '勿',
        radicals: &['ノ', '勹', '勿'],
    },
    Decomposition {
        kanji: '餅',
        radicals: &['｜', 'ノ', '一', '食', '二', '丷', '廾'],
    },
    Decomposition {
        kanji: '尤',
        radicals: &['丶', '尢', '尤'],
    },
    Decomposition {
        kanji: '戻',
        radicals: &['戸', '大', '一', '尸'],
    },
    Decomposition {
        kanji: '籾',
        radicals: &['刀', '米', '丶'],
    },
    Decomposition {
        kanji: '貰',
        radicals: &['貝', '目', 'ハ', '世'],
    },
    Decomposition {
        kanji: '問',
        radicals: &['口', '門'],
    },
    Decomposition {
        kanji: '悶',
        radicals: &['心', '門'],
    },
    Decomposition {
        kanji: '紋',
        radicals: &['糸', '幺', '小', '文'],
    },
    Decomposition {
        kanji: '門',
        radicals: &['門'],
    },
    Decomposition {
        kanji: '匁',
        radicals: &['ノ', '勹', '丶'],
    },
    Decomposition {
        kanji: '也',
        radicals: &['｜', '乙', '匕', '也'],
    },
    Decomposition {
        kanji: '冶',
        radicals: &['口', '冫', '厶'],
    },
    Decomposition {
        kanji: '夜',
        radicals: &['⺅', '夕', '亠'],
    },
    Decomposition {
        kanji: '爺',
        radicals: &['耳', '父', '⻏'],
    },
    Decomposition {
        kanji: '耶',
        radicals: &['耳', '⻏'],
    },
    Decomposition {
        kanji: '野',
        radicals: &['矛', '里', '亅'],
    },
    Decomposition {
        kanji: '弥',
        radicals: &['ノ', '弓', '亅', '小', '𠂉'],
    },
    Decomposition {
        kanji: '矢',
        radicals: &['ノ', '大', '一', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '厄',
        radicals: &['卩', '厂'],
    },
    Decomposition {
        kanji: '役',
        radicals: &['彳', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '約',
        radicals: &['糸', '幺', '小', '丶', '勹'],
    },
    Decomposition {
        kanji: '薬',
        radicals: &['日', '木', '冫', '⺾'],
    },
    Decomposition {
        kanji: '訳',
        radicals: &['言', '尸', '丶'],
    },
    Decomposition {
        kanji: '躍',
        radicals: &['ヨ', '口', '足', '隹', '止'],
    },
    Decomposition {
        kanji: '靖',
        radicals: &['月', '青', '土', '二', '立', '亠'],
    },
    Decomposition {
        kanji: '柳',
        radicals: &['木', '卩'],
    },
    Decomposition {
        kanji: '薮',
        radicals: &['女', '米', '夂', '⺾', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '鑓',
        radicals: &['｜', '一', '金', '口', '⻌'],
    },
    Decomposition {
        kanji: '愉',
        radicals: &['⺉', '月', '⺖', '𠆢', '一'],
    },
    Decomposition {
        kanji: '愈',
        radicals: &['⺉', '月', '心', '𠆢', '一'],
    },
    Decomposition {
        kanji: '油',
        radicals: &['｜', '⺡', '日', '田'],
    },
    Decomposition {
        kanji: '癒',
        radicals: &['⺉', '月', '心', '𠆢', '⽧'],
    },
    Decomposition {
        kanji: '諭',
        radicals: &['⺉', '月', '言', '𠆢', '一'],
    },
    Decomposition {
        kanji: '輸',
        radicals: &['⺉', '月', '車', '𠆢', '一'],
    },
    Decomposition {
        kanji: '唯',
        radicals: &['口', '隹'],
    },
    Decomposition {
        kanji: '佑',
        radicals: &['ノ', '一', '⺅', '口'],
    },
    Decomposition {
        kanji: '優',
        radicals: &['一', '⺅', '心', '白', '冖', '夂', '自'],
    },
    Decomposition {
        kanji: '勇',
        radicals: &['田', '力', 'マ'],
    },
    Decomposition {
        kanji: '友',
        radicals: &['ノ', '一', '又'],
    },
    Decomposition {
        kanji: '宥',
        radicals: &['ノ', '一', '月', '宀'],
    },
    Decomposition {
        kanji: '幽',
        radicals: &['｜', '凵', '幺'],
    },
    Decomposition {
        kanji: '悠',
        radicals: &['｜', '⺅', '心', '夂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '憂',
        radicals: &['一', '自', '心', '冖', '夂', '白'],
    },
    Decomposition {
        kanji: '揖',
        radicals: &['口', '耳', '扌'],
    },
    Decomposition {
        kanji: '有',
        radicals: &['ノ', '一', '月'],
    },
    Decomposition {
        kanji: '柚',
        radicals: &['｜', '日', '木', '田'],
    },
    Decomposition {
        kanji: '湧',
        radicals: &['⺡', '田', '力', 'マ'],
    },
    Decomposition {
        kanji: '涌',
        radicals: &['⺡', '用', 'マ'],
    },
    Decomposition {
        kanji: '猶',
        radicals: &['酉', '丷', '⺨'],
    },
    Decomposition {
        kanji: '猷',
        radicals: &['丷', '酉', '犬'],
    },
    Decomposition {
        kanji: '由',
        radicals: &['｜', '日', '田'],
    },
    Decomposition {
        kanji: '祐',
        radicals: &['ノ', '一', '口', '⺭'],
    },
    Decomposition {
        kanji: '裕',
        radicals: &['口', '⻂', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '誘',
        radicals: &['乃', '禾', '言', 'ノ'],
    },
    Decomposition {
        kanji: '遊',
        radicals: &['⻌', '子', '方', '𠂉'],
    },
    Decomposition {
        kanji: '邑',
        radicals: &['口', '巴'],
    },
    Decomposition {
        kanji: '郵',
        radicals: &['｜', 'ノ', '一', '⻏'],
    },
    Decomposition {
        kanji: '雄',
        radicals: &['ノ', '一', '厶', '隹'],
    },
    Decomposition {
        kanji: '融',
        radicals: &['口', '虫', '儿', '冂', '鬲'],
    },
    Decomposition {
        kanji: '夕',
        radicals: &['夕'],
    },
    Decomposition {
        kanji: '予',
        radicals: &['マ', '一', '亅'],
    },
    Decomposition {
        kanji: '余',
        radicals: &['一', '二', 'ハ', '𠆢', '亅', '示', '小'],
    },
    Decomposition {
        kanji: '与',
        radicals: &['勹', '一', '卜'],
    },
    Decomposition {
        kanji: '誉',
        radicals: &['一', '言', '⺌', '丷'],
    },
    Decomposition {
        kanji: '輿',
        radicals: &['臼', '車', 'ハ'],
    },
    Decomposition {
        kanji: '預',
        radicals: &['貝', '目', 'ハ', '欠', 'マ', '一', '亅', '頁'],
    },
    Decomposition {
        kanji: '傭',
        radicals: &['ヨ', '⺅', '用', '广', '聿'],
    },
    Decomposition {
        kanji: '幼',
        radicals: &['力', '幺'],
    },
    Decomposition {
        kanji: '妖',
        radicals: &['ノ', '女', '大'],
    },
    Decomposition {
        kanji: '容',
        radicals: &['穴', '口', '谷', 'ハ', '𠆢', '宀'],
    },
    Decomposition {
        kanji: '庸',
        radicals: &['ヨ', '用', '广', '聿'],
    },
    Decomposition {
        kanji: '揚',
        radicals: &['一', '日', '扌', '勿', '勿'],
    },
    Decomposition {
        kanji: '揺',
        radicals: &['干', '爪', '凵', '扌'],
    },
    Decomposition {
        kanji: '擁',
        radicals: &['亠', '扌', '隹', '幺'],
    },
    Decomposition {
        kanji: '曜',
        radicals: &['ヨ', '日', '隹'],
    },
    Decomposition {
        kanji: '楊',
        radicals: &['一', '日', '木', '勿', '勿'],
    },
    Decomposition {
        kanji: '様',
        radicals: &['王', '水', '丷', '木', '羊'],
    },
    Decomposition {
        kanji: '洋',
        radicals: &['王', '⺡', '丷', '羊'],
    },
    Decomposition {
        kanji: '溶',
        radicals: &['穴', '口', '⺡', '谷', 'ハ', '𠆢', '宀'],
    },
    Decomposition {
        kanji: '熔',
        radicals: &['火', '穴', '口', '谷', 'ハ', '𠆢', '宀'],
    },
    Decomposition {
        kanji: '用',
        radicals: &['用'],
    },
    Decomposition {
        kanji: '窯',
        radicals: &['王', '穴', '丷', '羊', '儿', '宀', '⺣'],
    },
    Decomposition {
        kanji: '羊',
        radicals: &['王', '丷', '羊'],
    },
    Decomposition {
        kanji: '耀',
        radicals: &['ヨ', '⺌', '儿', '隹'],
    },
    Decomposition {
        kanji: '葉',
        radicals: &['木', '世', '⺾'],
    },
    Decomposition {
        kanji: '蓉',
        radicals: &['穴', '口', '谷', 'ハ', '𠆢', '宀', '⺾'],
    },
    Decomposition {
        kanji: '要',
        radicals: &['女', '西'],
    },
    Decomposition {
        kanji: '謡',
        radicals: &['干', '言', '爪', '凵'],
    },
    Decomposition {
        kanji: '踊',
        radicals: &['口', '足', '用', 'マ', '止'],
    },
    Decomposition {
        kanji: '遥',
        radicals: &['干', '⻌', '爪', '凵'],
    },
    Decomposition {
        kanji: '陽',
        radicals: &['一', '日', '勿', '⻖', '勿'],
    },
    Decomposition {
        kanji: '養',
        radicals: &['王', '食', '丷', '羊'],
    },
    Decomposition {
        kanji: '慾',
        radicals: &['欠', '口', '心', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '抑',
        radicals: &['卩', '扌'],
    },
    Decomposition {
        kanji: '欲',
        radicals: &['欠', '口', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '沃',
        radicals: &['ノ', '⺡', '大'],
    },
    Decomposition {
        kanji: '浴',
        radicals: &['口', '⺡', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '翌',
        radicals: &['羽', '立', '冫'],
    },
    Decomposition {
        kanji: '翼',
        radicals: &['｜', '一', '羽', '田', '二', 'ハ', '冫', '井'],
    },
    Decomposition {
        kanji: '淀',
        radicals: &['⺡', '疋', '宀'],
    },
    Decomposition {
        kanji: '羅',
        radicals: &['糸', '幺', '小', '⺲', '隹'],
    },
    Decomposition {
        kanji: '螺',
        radicals: &['糸', '幺', '小', '虫', '田'],
    },
    Decomposition {
        kanji: '裸',
        radicals: &['⻂', '田', '木'],
    },
    Decomposition {
        kanji: '来',
        radicals: &['｜', '二', '米', '亠', '木'],
    },
    Decomposition {
        kanji: '莱',
        radicals: &['｜', '二', '米', '亠', '⺾', '木'],
    },
    Decomposition {
        kanji: '頼',
        radicals: &['｜', '貝', '目', '口', 'ハ', '頁', '木'],
    },
    Decomposition {
        kanji: '雷',
        radicals: &['雨', '田'],
    },
    Decomposition {
        kanji: '洛',
        radicals: &['口', '⺡', '夂'],
    },
    Decomposition {
        kanji: '絡',
        radicals: &['口', '糸', '幺', '小', '夂'],
    },
    Decomposition {
        kanji: '落',
        radicals: &['口', '⺡', '夂', '⺾'],
    },
    Decomposition {
        kanji: '酪',
        radicals: &['口', '酉', '夂'],
    },
    Decomposition {
        kanji: '乱',
        radicals: &['乙', '口', '舌'],
    },
    Decomposition {
        kanji: '卵',
        radicals: &['ノ', '卜', '丶', '卩'],
    },
    Decomposition {
        kanji: '嵐',
        radicals: &['山', '風'],
    },
    Decomposition {
        kanji: '欄',
        radicals: &['｜', '一', '日', '木', '門', '田'],
    },
    Decomposition {
        kanji: '濫',
        radicals: &['ノ', '皿', '⺡', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '藍',
        radicals: &['ノ', '皿', '臣', '二', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '蘭',
        radicals: &['｜', '一', '日', '木', '門', '⺾'],
    },
    Decomposition {
        kanji: '覧',
        radicals: &['ノ', '見', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '利',
        radicals: &['禾', '⺉'],
    },
    Decomposition {
        kanji: '吏',
        radicals: &['ノ', '一', '口', '丶'],
    },
    Decomposition {
        kanji: '履',
        radicals: &['日', '夂', '尸', '彳', '𠂉'],
    },
    Decomposition {
        kanji: '李',
        radicals: &['子', '木'],
    },
    Decomposition {
        kanji: '梨',
        radicals: &['禾', '⺉', '木'],
    },
    Decomposition {
        kanji: '理',
        radicals: &['王', '里'],
    },
    Decomposition {
        kanji: '璃',
        radicals: &['王', '亠', '凵', '⽱'],
    },
    Decomposition {
        kanji: '痢',
        radicals: &['禾', '⺉', '⽧'],
    },
    Decomposition {
        kanji: '裏',
        radicals: &['衣', '里', '亠'],
    },
    Decomposition {
        kanji: '裡',
        radicals: &['⻂', '里'],
    },
    Decomposition {
        kanji: '里',
        radicals: &['里'],
    },
    Decomposition {
        kanji: '離',
        radicals: &['亠', '凵', '⽱', '隹'],
    },
    Decomposition {
        kanji: '陸',
        radicals: &['土', '儿', '⻖'],
    },
    Decomposition {
        kanji: '律',
        radicals: &['彳', '聿'],
    },
    Decomposition {
        kanji: '率',
        radicals: &['玄', '十', '亠', '冫', '幺'],
    },
    Decomposition {
        kanji: '立',
        radicals: &['立'],
    },
    Decomposition {
        kanji: '葎',
        radicals: &['彳', '聿', '⺾'],
    },
    Decomposition {
        kanji: '掠',
        radicals: &['口', '小', '亠', '扌'],
    },
    Decomposition {
        kanji: '略',
        radicals: &['口', '田', '夂'],
    },
    Decomposition {
        kanji: '劉',
        radicals: &['⺉', '金', '厶'],
    },
    Decomposition {
        kanji: '流',
        radicals: &['⺡', '川', '亠', '厶'],
    },
    Decomposition {
        kanji: '溜',
        radicals: &['⺡', '刀', '厶', '田'],
    },
    Decomposition {
        kanji: '琉',
        radicals: &['王', '川', '亠', '厶'],
    },
    Decomposition {
        kanji: '留',
        radicals: &['田', '刀', '厶'],
    },
    Decomposition {
        kanji: '硫',
        radicals: &['口', '石', '川', '亠', '厶'],
    },
    Decomposition {
        kanji: '粒',
        radicals: &['米', '立'],
    },
    Decomposition {
        kanji: '隆',
        radicals: &['生', '夂', '⻖'],
    },
    Decomposition {
        kanji: '竜',
        radicals: &['立', '竜', '田', '乙'],
    },
    Decomposition {
        kanji: '龍',
        radicals: &['月', '立'],
    },
    Decomposition {
        kanji: '侶',
        radicals: &['⺅', '口', 'ノ'],
    },
    Decomposition {
        kanji: '慮',
        radicals: &['心', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '旅',
        radicals: &['ノ', '方', '𠂉'],
    },
    Decomposition {
        kanji: '虜',
        radicals: &['田', '卜', '力', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '了',
        radicals: &['一', '亅'],
    },
    Decomposition {
        kanji: '亮',
        radicals: &['口', '亠', '儿', '冖'],
    },
    Decomposition {
        kanji: '僚',
        radicals: &['⺅', '小', '日', '大'],
    },
    Decomposition {
        kanji: '両',
        radicals: &['｜', '一', '冂', '山'],
    },
    Decomposition {
        kanji: '凌',
        radicals: &['土', '儿', '冫', '夂'],
    },
    Decomposition {
        kanji: '寮',
        radicals: &['小', '日', '丷', '大', '宀'],
    },
    Decomposition {
        kanji: '料',
        radicals: &['斗', '米'],
    },
    Decomposition {
        kanji: '梁',
        radicals: &['⺡', '刀', '木', '丶'],
    },
    Decomposition {
        kanji: '涼',
        radicals: &['口', '⺡', '小', '亠'],
    },
    Decomposition {
        kanji: '猟',
        radicals: &['⺌', '⺨', '用', '几'],
    },
    Decomposition {
        kanji: '療',
        radicals: &['小', '日', '丷', '大', '⽧'],
    },
    Decomposition {
        kanji: '瞭',
        radicals: &['小', '日', '丷', '目', '大'],
    },
    Decomposition {
        kanji: '稜',
        radicals: &['禾', '土', '儿', '夂'],
    },
    Decomposition {
        kanji: '糧',
        radicals: &['一', '日', '米', '里'],
    },
    Decomposition {
        kanji: '良',
        radicals: &['艮'],
    },
    Decomposition {
        kanji: '諒',
        radicals: &['言', '口', '小', '亠'],
    },
    Decomposition {
        kanji: '遼',
        radicals: &['⻌', '小', '日', '丷', '大'],
    },
    Decomposition {
        kanji: '量',
        radicals: &['一', '日', '里'],
    },
    Decomposition {
        kanji: '陵',
        radicals: &['土', '儿', '夂', '⻖'],
    },
    Decomposition {
        kanji: '領',
        radicals: &['貝', '目', 'ハ', '頁', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '力',
        radicals: &['力'],
    },
    Decomposition {
        kanji: '緑',
        radicals: &['ヨ', '糸', '幺', '小', '水', '隶'],
    },
    Decomposition {
        kanji: '倫',
        radicals: &['｜', '一', '⺅', '𠆢', '亅', '冊', '廾'],
    },
    Decomposition {
        kanji: '厘',
        radicals: &['里', '厂'],
    },
    Decomposition {
        kanji: '林',
        radicals: &['木'],
    },
    Decomposition {
        kanji: '淋',
        radicals: &['⺡', '木'],
    },
    Decomposition {
        kanji: '燐',
        radicals: &['火', '舛', '米', '夕'],
    },
    Decomposition {
        kanji: '琳',
        radicals: &['王', '木'],
    },
    Decomposition {
        kanji: '臨',
        radicals: &['ノ', '口', '臣', '品', '一', '人', '𠂉'],
    },
    Decomposition {
        kanji: '輪',
        radicals: &['｜', '一', '車', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '隣',
        radicals: &['舛', '米', '夕', '⻖'],
    },
    Decomposition {
        kanji: '鱗',
        radicals: &['魚', '舛', '田', '米', '夕', '⺣'],
    },
    Decomposition {
        kanji: '麟',
        radicals: &['鹿', '舛', '比', '米', '夕', '广'],
    },
    Decomposition {
        kanji: '瑠',
        radicals: &['王', '田', '刀', '厶'],
    },
    Decomposition {
        kanji: '塁',
        radicals: &['田', '土', '冫'],
    },
    Decomposition {
        kanji: '涙',
        radicals: &['戸', '⺡', '大', '一', '尸'],
    },
    Decomposition {
        kanji: '累',
        radicals: &['糸', '幺', '小', '田'],
    },
    Decomposition {
        kanji: '類',
        radicals: &['貝', '目', 'ハ', '大', '米', '頁'],
    },
    Decomposition {
        kanji: '令',
        radicals: &['𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '伶',
        radicals: &['𠆢', '卩', '一', '⺅'],
    },
    Decomposition {
        kanji: '例',
        radicals: &['⺅', '⺉', '歹'],
    },
    Decomposition {
        kanji: '冷',
        radicals: &['𠆢', '冫', '卩', '一'],
    },
    Decomposition {
        kanji: '励',
        radicals: &['斤', '力', '厂'],
    },
    Decomposition {
        kanji: '嶺',
        radicals: &['貝', '目', 'ハ', '山', '頁', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '怜',
        radicals: &['⺖', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '玲',
        radicals: &['王', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '礼',
        radicals: &['乙', '⺭'],
    },
    Decomposition {
        kanji: '苓',
        radicals: &['𠆢', '卩', '⺾', '一'],
    },
    Decomposition {
        kanji: '鈴',
        radicals: &['金', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '隷',
        radicals: &['ヨ', '士', '小', '水', '二', '隶', '示'],
    },
    Decomposition {
        kanji: '零',
        radicals: &['雨', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '霊',
        radicals: &['｜', '一', '雨', '二'],
    },
    Decomposition {
        kanji: '麗',
        radicals: &['一', '鹿', '比', '冂', '广'],
    },
    Decomposition {
        kanji: '齢',
        radicals: &['止', '歯', '米', '𠆢', '凵', '卩', '一'],
    },
    Decomposition {
        kanji: '暦',
        radicals: &['日', '麻', '木', '厂', '广'],
    },
    Decomposition {
        kanji: '歴',
        radicals: &['止', '麻', '木', '厂', '广'],
    },
    Decomposition {
        kanji: '列',
        radicals: &['⺉', '歹'],
    },
    Decomposition {
        kanji: '劣',
        radicals: &['ノ', '小', '力'],
    },
    Decomposition {
        kanji: '烈',
        radicals: &['⺉', '⺣', '歹'],
    },
    Decomposition {
        kanji: '裂',
        radicals: &['衣', '⺉', '歹', '亠'],
    },
    Decomposition {
        kanji: '廉',
        radicals: &['｜', 'ヨ', 'ハ', '广', '丷'],
    },
    Decomposition {
        kanji: '恋',
        radicals: &['心', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '憐',
        radicals: &['舛', '米', '⺖', '夕'],
    },
    Decomposition {
        kanji: '漣',
        radicals: &['⻌', '車', '⺡'],
    },
    Decomposition {
        kanji: '煉',
        radicals: &['｜', '一', '火', '日', 'ハ', '木', '田'],
    },
    Decomposition {
        kanji: '簾',
        radicals: &['｜', 'ヨ', '竹', 'ハ', '广', '𠂉'],
    },
    Decomposition {
        kanji: '練',
        radicals: &['｜', '糸', '幺', '小', '日', 'ハ', '木', '田'],
    },
    Decomposition {
        kanji: '聯',
        radicals: &['耳', '幺'],
    },
    Decomposition {
        kanji: '蓮',
        radicals: &['⻌', '車', '⺾'],
    },
    Decomposition {
        kanji: '連',
        radicals: &['⻌', '車'],
    },
    Decomposition {
        kanji: '錬',
        radicals: &['｜', '一', '金', '日', '木', '田', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '呂',
        radicals: &['口', 'ノ'],
    },
    Decomposition {
        kanji: '魯',
        radicals: &['魚', '田', '日', '⺣'],
    },
    Decomposition {
        kanji: '櫓',
        radicals: &['魚', '田', '日', '木', '⺣'],
    },
    Decomposition {
        kanji: '炉',
        radicals: &['火', '戸', '一', '尸'],
    },
    Decomposition {
        kanji: '賂',
        radicals: &['貝', '目', 'ハ', '口', '夂'],
    },
    Decomposition {
        kanji: '路',
        radicals: &['口', '足', '夂', '止'],
    },
    Decomposition {
        kanji: '露',
        radicals: &['雨', '口', '足', '夂', '止'],
    },
    Decomposition {
        kanji: '労',
        radicals: &['⺌', '力', '冖'],
    },
    Decomposition {
        kanji: '婁',
        radicals: &['｜', '一', '口', '女'],
    },
    Decomposition {
        kanji: '廊',
        radicals: &['艮', '⻏', '广'],
    },
    Decomposition {
        kanji: '弄',
        radicals: &['王', '廾'],
    },
    Decomposition {
        kanji: '朗',
        radicals: &['月', '艮'],
    },
    Decomposition {
        kanji: '楼',
        radicals: &['女', '米', '木'],
    },
    Decomposition {
        kanji: '榔',
        radicals: &['艮', '⻏', '木'],
    },
    Decomposition {
        kanji: '浪',
        radicals: &['艮', '⺡'],
    },
    Decomposition {
        kanji: '漏',
        radicals: &['雨', '⺡', '尸'],
    },
    Decomposition {
        kanji: '牢',
        radicals: &['牛', '宀'],
    },
    Decomposition {
        kanji: '狼',
        radicals: &['艮', '⺨'],
    },
    Decomposition {
        kanji: '篭',
        radicals: &['竹', '立', '竜', '𠂉'],
    },
    Decomposition {
        kanji: '老',
        radicals: &['⺹', '匕'],
    },
    Decomposition {
        kanji: '聾',
        radicals: &['月', '耳', '立'],
    },
    Decomposition {
        kanji: '蝋',
        radicals: &['｜', '一', '⺌', '虫', '用', '几'],
    },
    Decomposition {
        kanji: '郎',
        radicals: &['艮', '⻏'],
    },
    Decomposition {
        kanji: '六',
        radicals: &['ハ', '亠'],
    },
    Decomposition {
        kanji: '麓',
        radicals: &['鹿', '比', '木', '广'],
    },
    Decomposition {
        kanji: '禄',
        radicals: &['ヨ', '水', '⺭', '隶'],
    },
    Decomposition {
        kanji: '肋',
        radicals: &['月', '力'],
    },
    Decomposition {
        kanji: '録',
        radicals: &['ヨ', '金', '水', '隶'],
    },
    Decomposition {
        kanji: '論',
        radicals: &['｜', '一', '言', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '倭',
        radicals: &['⺅', '禾', '女'],
    },
    Decomposition {
        kanji: '和',
        radicals: &['禾', '口'],
    },
    Decomposition {
        kanji: '話',
        radicals: &['言', '口', '舌'],
    },
    Decomposition {
        kanji: '歪',
        radicals: &['｜', 'ノ', '一', '止', '丶'],
    },
    Decomposition {
        kanji: '賄',
        radicals: &['ノ', '一', '貝', '目', 'ハ', '月'],
    },
    Decomposition {
        kanji: '脇',
        radicals: &['月', '力'],
    },
    Decomposition {
        kanji: '惑',
        radicals: &['口', '心', '戈'],
    },
    Decomposition {
        kanji: '枠',
        radicals: &['九', '十', '木'],
    },
    Decomposition {
        kanji: '鷲',
        radicals: &['口', '小', '鳥', '丶', '亠', '尤', '⺣', '尢'],
    },
    Decomposition {
        kanji: '亙',
        radicals: &['ノ', '一', '二', '丶'],
    },
    Decomposition {
        kanji: '亘',
        radicals: &['一', '二', '日'],
    },
    Decomposition {
        kanji: '鰐',
        radicals: &['魚', '口', '田', '二', '⺣', '勹'],
    },
    Decomposition {
        kanji: '詫',
        radicals: &['ノ', '乙', '言', '宀'],
    },
    Decomposition {
        kanji: '藁',
        radicals: &['口', '高', '木', '亠', '冂', '⺾'],
    },
    Decomposition {
        kanji: '蕨',
        radicals: &['欠', '丷', '厂', '屮', '⺾'],
    },
    Decomposition {
        kanji: '椀',
        radicals: &['木', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '湾',
        radicals: &['弓', '⺡', '亠'],
    },
    Decomposition {
        kanji: '碗',
        radicals: &['口', '石', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '腕',
        radicals: &['月', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '弌',
        radicals: &['一', '弋'],
    },
    Decomposition {
        kanji: '丐',
        radicals: &['一', '弓', '止', '疋'],
    },
    Decomposition {
        kanji: '丕',
        radicals: &['｜', 'ノ', '一', '丶'],
    },
    Decomposition {
        kanji: '个',
        radicals: &['｜', '𠆢'],
    },
    Decomposition {
        kanji: '丱',
        radicals: &['｜', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '丶',
        radicals: &['丶'],
    },
    Decomposition {
        kanji: '丼',
        radicals: &['｜', 'ノ', '二', '丶', '廾', '井'],
    },
    Decomposition {
        kanji: '丿',
        radicals: &['ノ'],
    },
    Decomposition {
        kanji: '乂',
        radicals: &['ノ', '丶'],
    },
    Decomposition {
        kanji: '乖',
        radicals: &['ノ', '十', '匕', '爿'],
    },
    Decomposition {
        kanji: '乘',
        radicals: &['ノ', '十', 'ハ', '匕', '爿', '禾'],
    },
    Decomposition {
        kanji: '亂',
        radicals: &['乙', '爪', '冂', '厶'],
    },
    Decomposition {
        kanji: '亅',
        radicals: &['亅'],
    },
    Decomposition {
        kanji: '豫',
        radicals: &['勹', '口', '｜', '矛', '亅', '豕', 'マ'],
    },
    Decomposition {
        kanji: '亊',
        radicals: &['ヨ', '一', '丷', '亅'],
    },
    Decomposition {
        kanji: '舒',
        radicals: &['干', '口', '舌', '矛', '𠆢', '亅', 'マ'],
    },
    Decomposition {
        kanji: '弍',
        radicals: &['二', '弋'],
    },
    Decomposition {
        kanji: '于',
        radicals: &['二', '亅'],
    },
    Decomposition {
        kanji: '亞',
        radicals: &['一', '二'],
    },
    Decomposition {
        kanji: '亟',
        radicals: &['口', '二', '又'],
    },
    Decomposition {
        kanji: '亠',
        radicals: &['亠'],
    },
    Decomposition {
        kanji: '亢',
        radicals: &['亠', '几'],
    },
    Decomposition {
        kanji: '亰',
        radicals: &['小', '日', '亠'],
    },
    Decomposition {
        kanji: '亳',
        radicals: &['ノ', '一', '乙', '口', '亠', '冖'],
    },
    Decomposition {
        kanji: '亶',
        radicals: &['一', '口', '日', '亠', '囗'],
    },
    Decomposition {
        kanji: '从',
        radicals: &['人'],
    },
    Decomposition {
        kanji: '仍',
        radicals: &['ノ', '⺅', '乃'],
    },
    Decomposition {
        kanji: '仄',
        radicals: &['人', '厂'],
    },
    Decomposition {
        kanji: '仆',
        radicals: &['⺅', '卜'],
    },
    Decomposition {
        kanji: '仂',
        radicals: &['⺅', '力'],
    },
    Decomposition {
        kanji: '仗',
        radicals: &['ノ', '⺅', '一', '丶'],
    },
    Decomposition {
        kanji: '仞',
        radicals: &['⺅', '刀', '丶'],
    },
    Decomposition {
        kanji: '仭',
        radicals: &['⺅', '刀', '丶'],
    },
    Decomposition {
        kanji: '仟',
        radicals: &['ノ', '⺅', '十'],
    },
    Decomposition {
        kanji: '价',
        radicals: &['儿', '⺅', '𠆢'],
    },
    Decomposition {
        kanji: '伉',
        radicals: &['⺅', '亠', '几'],
    },
    Decomposition {
        kanji: '佚',
        radicals: &['ノ', '⺅', '人', '大', '二'],
    },
    Decomposition {
        kanji: '估',
        radicals: &['⺅', '口', '十'],
    },
    Decomposition {
        kanji: '佛',
        radicals: &['｜', 'ノ', '⺅', '弓'],
    },
    Decomposition {
        kanji: '佝',
        radicals: &['⺅', '口', '勹'],
    },
    Decomposition {
        kanji: '佗',
        radicals: &['⺅', '匕', '宀'],
    },
    Decomposition {
        kanji: '佇',
        radicals: &['⺅', '亅', '宀', '一'],
    },
    Decomposition {
        kanji: '佶',
        radicals: &['⺅', '口', '士'],
    },
    Decomposition {
        kanji: '侈',
        radicals: &['⺅', '夕'],
    },
    Decomposition {
        kanji: '侏',
        radicals: &['ノ', '⺅', '牛', 'ハ', '木'],
    },
    Decomposition {
        kanji: '侘',
        radicals: &['ノ', '乙', '⺅', '宀'],
    },
    Decomposition {
        kanji: '佻',
        radicals: &['⺅', '儿', '冫'],
    },
    Decomposition {
        kanji: '佩',
        radicals: &['⺅', '巾', '几', '一'],
    },
    Decomposition {
        kanji: '佰',
        radicals: &['⺅', '白', '一'],
    },
    Decomposition {
        kanji: '侑',
        radicals: &['ノ', '一', '⺅', '月'],
    },
    Decomposition {
        kanji: '佯',
        radicals: &['王', '⺅', '丷', '羊'],
    },
    Decomposition {
        kanji: '來',
        radicals: &['｜', '一', '十', '人', 'ハ', '木'],
    },
    Decomposition {
        kanji: '侖',
        radicals: &['𠆢', '冂', '廾', '冊', '廾', '一'],
    },
    Decomposition {
        kanji: '儘',
        radicals: &['ヨ', '⺅', '皿', '⺣'],
    },
    Decomposition {
        kanji: '俔',
        radicals: &['⺅', '見'],
    },
    Decomposition {
        kanji: '俟',
        radicals: &['⺅', '矢', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '俎',
        radicals: &['人', '目'],
    },
    Decomposition {
        kanji: '俘',
        radicals: &['⺅', '子', '爪'],
    },
    Decomposition {
        kanji: '俛',
        radicals: &['⺅', '免', '儿', '勹'],
    },
    Decomposition {
        kanji: '俑',
        radicals: &['⺅', '用', 'マ'],
    },
    Decomposition {
        kanji: '俚',
        radicals: &['⺅', '里'],
    },
    Decomposition {
        kanji: '俐',
        radicals: &['⺅', '禾', '⺉'],
    },
    Decomposition {
        kanji: '俤',
        radicals: &['｜', 'ノ', '⺅', '弓', '丷'],
    },
    Decomposition {
        kanji: '俥',
        radicals: &['⺅', '車'],
    },
    Decomposition {
        kanji: '倚',
        radicals: &['⺅', '口', '大', '亅', '一'],
    },
    Decomposition {
        kanji: '倨',
        radicals: &['⺅', '口', '十', '尸'],
    },
    Decomposition {
        kanji: '倔',
        radicals: &['｜', '⺅', '山', '尸'],
    },
    Decomposition {
        kanji: '倪',
        radicals: &['臼', '⺅', '儿'],
    },
    Decomposition {
        kanji: '倥',
        radicals: &['⺅', '穴', '工', '儿', '宀'],
    },
    Decomposition {
        kanji: '倅',
        radicals: &['⺅', '十', '人', '亠'],
    },
    Decomposition {
        kanji: '伜',
        radicals: &['九', '⺅', '十'],
    },
    Decomposition {
        kanji: '俶',
        radicals: &['⺅', '小', '卜', '又'],
    },
    Decomposition {
        kanji: '倡',
        radicals: &['⺅', '日'],
    },
    Decomposition {
        kanji: '倩',
        radicals: &['⺅', '月', '青', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '倬',
        radicals: &['⺅', '十', '日', '卜', '曰'],
    },
    Decomposition {
        kanji: '俾',
        radicals: &['⺅', '十', '田', 'ノ'],
    },
    Decomposition {
        kanji: '俯',
        radicals: &['⺅', '寸', '广'],
    },
    Decomposition {
        kanji: '們',
        radicals: &['⺅', '門'],
    },
    Decomposition {
        kanji: '倆',
        radicals: &['｜', '⺅', '人', '冂'],
    },
    Decomposition {
        kanji: '偃',
        radicals: &['⺅', '女', '日', '匚'],
    },
    Decomposition {
        kanji: '假',
        radicals: &['｜', '⺅', '又'],
    },
    Decomposition {
        kanji: '會',
        radicals: &['日', '⺲', '𠆢', '一'],
    },
    Decomposition {
        kanji: '偕',
        radicals: &['⺅', '白', '比'],
    },
    Decomposition {
        kanji: '偐',
        radicals: &['⺅', '丷', '立', '亠', '厂', '彡'],
    },
    Decomposition {
        kanji: '偈',
        radicals: &['⺅', '日', '勹', '匕', '人', '一', '｜'],
    },
    Decomposition {
        kanji: '做',
        radicals: &['⺅', '口', '十', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '偖',
        radicals: &['⺅', '日', '⺹'],
    },
    Decomposition {
        kanji: '偬',
        radicals: &['丶', '⺅', '心', '勿', '勿'],
    },
    Decomposition {
        kanji: '偸',
        radicals: &['⺅', '⺉', '月', '𠆢', '一'],
    },
    Decomposition {
        kanji: '傀',
        radicals: &['⺅', '鬼', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '傚',
        radicals: &['⺅', '父', '亠', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '傅',
        radicals: &['⺅', '寸', '田', '丶'],
    },
    Decomposition {
        kanji: '傴',
        radicals: &['⺅', '口', '匚', '品'],
    },
    Decomposition {
        kanji: '傲',
        radicals: &['⺅', '土', '方', '攵', '亠', '二', '𠂉'],
    },
    Decomposition {
        kanji: '僉',
        radicals: &['口', '人', '𠆢', '一'],
    },
    Decomposition {
        kanji: '僊',
        radicals: &['⺅', '西', '大', '已'],
    },
    Decomposition {
        kanji: '傳',
        radicals: &['⺅', '寸', '田', '厶', '十'],
    },
    Decomposition {
        kanji: '僂',
        radicals: &['⺅', '十', '女'],
    },
    Decomposition {
        kanji: '僖',
        radicals: &['⺅', '口', '士', '十', '豆', '丷'],
    },
    Decomposition {
        kanji: '僞',
        radicals: &['⺅', '爪', '⺣'],
    },
    Decomposition {
        kanji: '僥',
        radicals: &['⺅', '土', '儿'],
    },
    Decomposition {
        kanji: '僭',
        radicals: &['⺅', '日', '亠', '无'],
    },
    Decomposition {
        kanji: '僣',
        radicals: &['⺅', '日', '二', '大'],
    },
    Decomposition {
        kanji: '僮',
        radicals: &['⺅', '里', '立'],
    },
    Decomposition {
        kanji: '價',
        radicals: &['⺅', '貝', '目', 'ハ', '西'],
    },
    Decomposition {
        kanji: '僵',
        radicals: &['一', '⺅', '田', '二'],
    },
    Decomposition {
        kanji: '儉',
        radicals: &['⺅', '口', '人', '𠆢', '一'],
    },
    Decomposition {
        kanji: '儁',
        radicals: &['⺅', '隹'],
    },
    Decomposition {
        kanji: '儂',
        radicals: &['｜', '⺅', '辰', '日', '衣'],
    },
    Decomposition {
        kanji: '儖',
        radicals: &['⺅', '皿', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '儕',
        radicals: &['⺅', '刀', '亠', '齊', '氏', '廾'],
    },
    Decomposition {
        kanji: '儔',
        radicals: &['⺅', '口', '工', '士', '寸'],
    },
    Decomposition {
        kanji: '儚',
        radicals: &['⺅', '⺲', '夕', '冖', '⺾'],
    },
    Decomposition {
        kanji: '儡',
        radicals: &['⺅', '田'],
    },
    Decomposition {
        kanji: '儺',
        radicals: &['⺅', '⺾', '隹', '二', '大', '井'],
    },
    Decomposition {
        kanji: '儷',
        radicals: &['⺅', '鹿', '比', '冂', '广'],
    },
    Decomposition {
        kanji: '儼',
        radicals: &['⺅', '口', '耳', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '儻',
        radicals: &['⺅', '口', '黒', '⺌', '里', '冖', '⺣'],
    },
    Decomposition {
        kanji: '儿',
        radicals: &['儿'],
    },
    Decomposition {
        kanji: '兀',
        radicals: &['一', '儿'],
    },
    Decomposition {
        kanji: '兒',
        radicals: &['臼', '儿'],
    },
    Decomposition {
        kanji: '兌',
        radicals: &['口', '丷', '儿'],
    },
    Decomposition {
        kanji: '兔',
        radicals: &['免', '丶', '儿', '勹'],
    },
    Decomposition {
        kanji: '兢',
        radicals: &['口', '十', '儿'],
    },
    Decomposition {
        kanji: '竸',
        radicals: &['音', '日', '立', '儿'],
    },
    Decomposition {
        kanji: '兩',
        radicals: &['｜', '一', '入', '冂'],
    },
    Decomposition {
        kanji: '兪',
        radicals: &['月', '入', '𠆢', '一'],
    },
    Decomposition {
        kanji: '兮',
        radicals: &['弓', 'ハ'],
    },
    Decomposition {
        kanji: '冀',
        radicals: &['田', '二', 'ハ', '匕', '爿'],
    },
    Decomposition {
        kanji: '冂',
        radicals: &['冂'],
    },
    Decomposition {
        kanji: '囘',
        radicals: &['冂', '已'],
    },
    Decomposition {
        kanji: '册',
        radicals: &['一', '冂'],
    },
    Decomposition {
        kanji: '冉',
        radicals: &['｜', '一', '冂', '十'],
    },
    Decomposition {
        kanji: '冏',
        radicals: &['口', '儿', '冂'],
    },
    Decomposition {
        kanji: '冑',
        radicals: &['月', '田', '二', '冂'],
    },
    Decomposition {
        kanji: '冓',
        radicals: &['｜', '一', '冂', '二', '十'],
    },
    Decomposition {
        kanji: '冕',
        radicals: &['月', '免', '二', '儿', '冂', '勹'],
    },
    Decomposition {
        kanji: '冖',
        radicals: &['冖'],
    },
    Decomposition {
        kanji: '冤',
        radicals: &['免', '丶', '冖', '儿', '勹'],
    },
    Decomposition {
        kanji: '冦',
        radicals: &['元', '卜', '又', '儿', '冖'],
    },
    Decomposition {
        kanji: '冢',
        radicals: &['冖', '豕', '丶'],
    },
    Decomposition {
        kanji: '冩',
        radicals: &['臼', '冖', '勹', '⺣'],
    },
    Decomposition {
        kanji: '冪',
        radicals: &['巾', '大', '日', '冖', '⺾'],
    },
    Decomposition {
        kanji: '冫',
        radicals: &['冫'],
    },
    Decomposition {
        kanji: '决',
        radicals: &['ノ', '人', '冫', 'ユ', '大'],
    },
    Decomposition {
        kanji: '冱',
        radicals: &['一', '二', '冫', '彑'],
    },
    Decomposition {
        kanji: '冲',
        radicals: &['｜', '口', '冫'],
    },
    Decomposition {
        kanji: '冰',
        radicals: &['水', '冫'],
    },
    Decomposition {
        kanji: '况',
        radicals: &['口', '儿', '冫'],
    },
    Decomposition {
        kanji: '冽',
        radicals: &['⺉', '冫', '歹'],
    },
    Decomposition {
        kanji: '凅',
        radicals: &['口', '十', '冫', '囗'],
    },
    Decomposition {
        kanji: '凉',
        radicals: &['口', '小', '亠', '冫'],
    },
    Decomposition {
        kanji: '凛',
        radicals: &['口', '示', '二', '小', '亠', '冫', '囗'],
    },
    Decomposition {
        kanji: '几',
        radicals: &['几'],
    },
    Decomposition {
        kanji: '處',
        radicals: &['卜', '几', '匕', '厂', '夂', '虍'],
    },
    Decomposition {
        kanji: '凩',
        radicals: &['木', '几'],
    },
    Decomposition {
        kanji: '凭',
        radicals: &['ノ', '⺅', '士', '几'],
    },
    Decomposition {
        kanji: '凰',
        radicals: &['王', '白', '几'],
    },
    Decomposition {
        kanji: '凵',
        radicals: &['凵'],
    },
    Decomposition {
        kanji: '凾',
        radicals: &['口', '又', '凵'],
    },
    Decomposition {
        kanji: '刄',
        radicals: &['刀'],
    },
    Decomposition {
        kanji: '刋',
        radicals: &['ノ', '⺉', '十'],
    },
    Decomposition {
        kanji: '刔',
        radicals: &['⺉', '人', 'ユ', '大'],
    },
    Decomposition {
        kanji: '刎',
        radicals: &['⺉', '勿', '勹', 'ノ'],
    },
    Decomposition {
        kanji: '刧',
        radicals: &['土', '刀', '厶'],
    },
    Decomposition {
        kanji: '刪',
        radicals: &['⺉', '冊', '冂', '廾'],
    },
    Decomposition {
        kanji: '刮',
        radicals: &['⺉', '口', '舌'],
    },
    Decomposition {
        kanji: '刳',
        radicals: &['⺉', '大', '二', '勹'],
    },
    Decomposition {
        kanji: '刹',
        radicals: &['⺉', '木', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '剏',
        radicals: &['｜', 'ノ', '刀', '二', '丷', '廾', '一'],
    },
    Decomposition {
        kanji: '剄',
        radicals: &['⺉', '工', '巛', '一'],
    },
    Decomposition {
        kanji: '剋',
        radicals: &['⺉', '口', '十', '儿'],
    },
    Decomposition {
        kanji: '剌',
        radicals: &['｜', '⺉', '口', 'ハ', '木'],
    },
    Decomposition {
        kanji: '剞',
        radicals: &['⺉', '口', '大', '亅', '一'],
    },
    Decomposition {
        kanji: '剔',
        radicals: &['⺉', '日', '勿', '勿'],
    },
    Decomposition {
        kanji: '剪',
        radicals: &['一', '⺉', '月', '丷', '刀'],
    },
    Decomposition {
        kanji: '剴',
        radicals: &['⺉', '口', '山', '豆', '丷'],
    },
    Decomposition {
        kanji: '剩',
        radicals: &['｜', '⺉', '匕', '爿', '禾'],
    },
    Decomposition {
        kanji: '剳',
        radicals: &['⺉', '口', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '剿',
        radicals: &['⺉', '⺌', '田', '木', '巛'],
    },
    Decomposition {
        kanji: '剽',
        radicals: &['⺉', '示', '二', '小', '西'],
    },
    Decomposition {
        kanji: '劍',
        radicals: &['⺉', '口', '人', '𠆢', '一'],
    },
    Decomposition {
        kanji: '劔',
        radicals: &['口', '人', '刀', '𠆢', '丶', '一'],
    },
    Decomposition {
        kanji: '劒',
        radicals: &['口', '人', '𠆢', '丶', '刀', '一'],
    },
    Decomposition {
        kanji: '剱',
        radicals: &['口', '人', '刀', '𠆢', '丶'],
    },
    Decomposition {
        kanji: '劈',
        radicals: &['口', '十', '辛', '刀', '立', '尸'],
    },
    Decomposition {
        kanji: '劑',
        radicals: &['⺉', '亠', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '辨',
        radicals: &['ノ', '十', '辛', '立'],
    },
    Decomposition {
        kanji: '辧',
        radicals: &['十', '辛', '刀', '立'],
    },
    Decomposition {
        kanji: '劬',
        radicals: &['口', '力', '勹'],
    },
    Decomposition {
        kanji: '劭',
        radicals: &['口', '刀', '力'],
    },
    Decomposition {
        kanji: '劼',
        radicals: &['口', '士', '力'],
    },
    Decomposition {
        kanji: '劵',
        radicals: &['人', '大', '二', 'ハ', '力'],
    },
    Decomposition {
        kanji: '勁',
        radicals: &['工', '巛', '力'],
    },
    Decomposition {
        kanji: '勍',
        radicals: &['口', '小', '力', '亠'],
    },
    Decomposition {
        kanji: '勗',
        radicals: &['日', '目', '力'],
    },
    Decomposition {
        kanji: '勞',
        radicals: &['火', '力', '冖'],
    },
    Decomposition {
        kanji: '勣',
        radicals: &['貝', '目', 'ハ', '土', '力', '亠', '二'],
    },
    Decomposition {
        kanji: '勦',
        radicals: &['⺌', '田', '木', '力', '巛'],
    },
    Decomposition {
        kanji: '飭',
        radicals: &['食', '力', '𠂉'],
    },
    Decomposition {
        kanji: '勠',
        radicals: &['羽', '力', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '勳',
        radicals: &['｜', '力', '⺣'],
    },
    Decomposition {
        kanji: '勵',
        radicals: &['田', '力', '厂', '⽱'],
    },
    Decomposition {
        kanji: '勸',
        radicals: &['口', '十', '力', '⺾', '隹'],
    },
    Decomposition {
        kanji: '勹',
        radicals: &['勹'],
    },
    Decomposition {
        kanji: '匆',
        radicals: &['丶', '勿', '勹', 'ノ'],
    },
    Decomposition {
        kanji: '匈',
        radicals: &['凵', '勹'],
    },
    Decomposition {
        kanji: '甸',
        radicals: &['田', '勹'],
    },
    Decomposition {
        kanji: '匍',
        radicals: &['十', '用', '丶', '勹'],
    },
    Decomposition {
        kanji: '匐',
        radicals: &['一', '口', '田', '勹'],
    },
    Decomposition {
        kanji: '匏',
        radicals: &['大', '二', '勹', '已'],
    },
    Decomposition {
        kanji: '匕',
        radicals: &['匕'],
    },
    Decomposition {
        kanji: '匚',
        radicals: &['匚'],
    },
    Decomposition {
        kanji: '匣',
        radicals: &['｜', '田', '匚'],
    },
    Decomposition {
        kanji: '匯',
        radicals: &['⺡', '匚', '隹'],
    },
    Decomposition {
        kanji: '匱',
        radicals: &['貝', '目', 'ハ', '匚', '口', '亠', '｜', '一', '口'],
    },
    Decomposition {
        kanji: '匳',
        radicals: &['口', '人', '𠆢', '匚', '一'],
    },
    Decomposition {
        kanji: '匸',
        radicals: &['匚'],
    },
    Decomposition {
        kanji: '區',
        radicals: &['口', '匚', '品'],
    },
    Decomposition {
        kanji: '卆',
        radicals: &['九', '十'],
    },
    Decomposition {
        kanji: '卅',
        radicals: &['｜', 'ノ', '一', '十', '川'],
    },
    Decomposition {
        kanji: '丗',
        radicals: &['｜', '山', '十'],
    },
    Decomposition {
        kanji: '卉',
        radicals: &['十', '廾'],
    },
    Decomposition {
        kanji: '卍',
        radicals: &['｜', '一', '十'],
    },
    Decomposition {
        kanji: '凖',
        radicals: &['十', '冫', '隹'],
    },
    Decomposition {
        kanji: '卞',
        radicals: &['卜', '亠'],
    },
    Decomposition {
        kanji: '卩',
        radicals: &['卩'],
    },
    Decomposition {
        kanji: '卮',
        radicals: &['卩', '厂'],
    },
    Decomposition {
        kanji: '夘',
        radicals: &['夕', '卩'],
    },
    Decomposition {
        kanji: '卻',
        radicals: &['口', 'ハ', '卩', '谷'],
    },
    Decomposition {
        kanji: '卷',
        radicals: &['人', '大', '二', 'ハ', '卩', '丷'],
    },
    Decomposition {
        kanji: '厂',
        radicals: &['厂'],
    },
    Decomposition {
        kanji: '厖',
        radicals: &['丶', '厂', '尤', '彡', '尢'],
    },
    Decomposition {
        kanji: '厠',
        radicals: &['貝', '目', 'ハ', '⺉', '厂'],
    },
    Decomposition {
        kanji: '厦',
        radicals: &['一', '自', '厂', '夂'],
    },
    Decomposition {
        kanji: '厥',
        radicals: &['欠', '丷', '厂', '屮'],
    },
    Decomposition {
        kanji: '厮',
        radicals: &['甘', '斤', 'ハ', '厂'],
    },
    Decomposition {
        kanji: '厰',
        radicals: &['口', '⺌', '冂', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '厶',
        radicals: &['厶'],
    },
    Decomposition {
        kanji: '參',
        radicals: &['𠆢', '厶', '彡'],
    },
    Decomposition {
        kanji: '簒',
        radicals: &['大', '竹', '目', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '雙',
        radicals: &['又', '隹'],
    },
    Decomposition {
        kanji: '叟',
        radicals: &['臼', '支', '又', '十'],
    },
    Decomposition {
        kanji: '曼',
        radicals: &['日', '⺲', '又'],
    },
    Decomposition {
        kanji: '燮',
        radicals: &['火', '言', '又'],
    },
    Decomposition {
        kanji: '叮',
        radicals: &['口', '亅', '一'],
    },
    Decomposition {
        kanji: '叨',
        radicals: &['口', '刀'],
    },
    Decomposition {
        kanji: '叭',
        radicals: &['口', 'ハ'],
    },
    Decomposition {
        kanji: '叺',
        radicals: &['口', '入'],
    },
    Decomposition {
        kanji: '吁',
        radicals: &['口', '二', '亅'],
    },
    Decomposition {
        kanji: '吽',
        radicals: &['｜', '牛', '口', '二'],
    },
    Decomposition {
        kanji: '呀',
        radicals: &['牙', '口'],
    },
    Decomposition {
        kanji: '听',
        radicals: &['斤', '口'],
    },
    Decomposition {
        kanji: '吭',
        radicals: &['口', '亠', '几'],
    },
    Decomposition {
        kanji: '吼',
        radicals: &['乙', '口', '子'],
    },
    Decomposition {
        kanji: '吮',
        radicals: &['口', '儿', '厶'],
    },
    Decomposition {
        kanji: '吶',
        radicals: &['口', '人', '冂'],
    },
    Decomposition {
        kanji: '吩',
        radicals: &['口', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '吝',
        radicals: &['口', '文'],
    },
    Decomposition {
        kanji: '呎',
        radicals: &['口', '尸', '丶'],
    },
    Decomposition {
        kanji: '咏',
        radicals: &['ノ', '口', '水', '丶'],
    },
    Decomposition {
        kanji: '呵',
        radicals: &['口', '亅'],
    },
    Decomposition {
        kanji: '咎',
        radicals: &['口', '人', '夂'],
    },
    Decomposition {
        kanji: '呟',
        radicals: &['玄', '口', '亠', '幺'],
    },
    Decomposition {
        kanji: '呱',
        radicals: &['瓜', '口'],
    },
    Decomposition {
        kanji: '呷',
        radicals: &['｜', '口', '田'],
    },
    Decomposition {
        kanji: '呰',
        radicals: &['口', '止', '匕'],
    },
    Decomposition {
        kanji: '咒',
        radicals: &['口', '几'],
    },
    Decomposition {
        kanji: '呻',
        radicals: &['｜', '口', '田'],
    },
    Decomposition {
        kanji: '咀',
        radicals: &['一', '口', '目'],
    },
    Decomposition {
        kanji: '呶',
        radicals: &['口', '女', '又'],
    },
    Decomposition {
        kanji: '咄',
        radicals: &['｜', '口', '山'],
    },
    Decomposition {
        kanji: '咐',
        radicals: &['⺅', '口', '寸'],
    },
    Decomposition {
        kanji: '咆',
        radicals: &['口', '勹', '已'],
    },
    Decomposition {
        kanji: '哇',
        radicals: &['口', '土'],
    },
    Decomposition {
        kanji: '咢',
        radicals: &['口', '二', '勹'],
    },
    Decomposition {
        kanji: '咸',
        radicals: &['ノ', '口', '戈'],
    },
    Decomposition {
        kanji: '咥',
        radicals: &['口', '至', '土', '厶'],
    },
    Decomposition {
        kanji: '咬',
        radicals: &['口', '父', '亠'],
    },
    Decomposition {
        kanji: '哄',
        radicals: &['｜', '一', '口', '二', 'ハ'],
    },
    Decomposition {
        kanji: '哈',
        radicals: &['口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '咨',
        radicals: &['欠', '口', '冫'],
    },
    Decomposition {
        kanji: '咫',
        radicals: &['口', 'ハ', '尸', '丶'],
    },
    Decomposition {
        kanji: '哂',
        radicals: &['口', '西'],
    },
    Decomposition {
        kanji: '咤',
        radicals: &['ノ', '乙', '口', '宀'],
    },
    Decomposition {
        kanji: '咾',
        radicals: &['口', '⺹', '匕'],
    },
    Decomposition {
        kanji: '咼',
        radicals: &['口', '冂'],
    },
    Decomposition {
        kanji: '哘',
        radicals: &['口', '行', '彳'],
    },
    Decomposition {
        kanji: '哥',
        radicals: &['一', '口', '亅'],
    },
    Decomposition {
        kanji: '哦',
        radicals: &['口', '亅', '戈'],
    },
    Decomposition {
        kanji: '唏',
        radicals: &['ノ', '一', '巾', '口'],
    },
    Decomposition {
        kanji: '唔',
        radicals: &['口', '五'],
    },
    Decomposition {
        kanji: '哽',
        radicals: &['ノ', '口', '田', '一'],
    },
    Decomposition {
        kanji: '哮',
        radicals: &['口', '子', '⺹'],
    },
    Decomposition {
        kanji: '哭',
        radicals: &['犬', '口'],
    },
    Decomposition {
        kanji: '哺',
        radicals: &['口', '十', '用', '丶'],
    },
    Decomposition {
        kanji: '哢',
        radicals: &['王', '口', '廾'],
    },
    Decomposition {
        kanji: '唹',
        radicals: &['口', '方', '𠆢', '冫'],
    },
    Decomposition {
        kanji: '啀',
        radicals: &['口', '土', '厂'],
    },
    Decomposition {
        kanji: '啣',
        radicals: &['口', '止', '凵', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '啌',
        radicals: &['穴', '口', '工', '儿', '宀'],
    },
    Decomposition {
        kanji: '售',
        radicals: &['口', '隹'],
    },
    Decomposition {
        kanji: '啜',
        radicals: &['口', '又'],
    },
    Decomposition {
        kanji: '啅',
        radicals: &['口', '十', '日', '卜'],
    },
    Decomposition {
        kanji: '啖',
        radicals: &['火', '口'],
    },
    Decomposition {
        kanji: '啗',
        radicals: &['臼', '口', '勹'],
    },
    Decomposition {
        kanji: '唸',
        radicals: &['口', '心', '𠆢', '一'],
    },
    Decomposition {
        kanji: '唳',
        radicals: &['戸', '口', '大', '一', '尸'],
    },
    Decomposition {
        kanji: '啝',
        radicals: &['禾', '口'],
    },
    Decomposition {
        kanji: '喙',
        radicals: &['ヨ', '口', '豕'],
    },
    Decomposition {
        kanji: '喀',
        radicals: &['口', '夂', '宀'],
    },
    Decomposition {
        kanji: '咯',
        radicals: &['口', '夂'],
    },
    Decomposition {
        kanji: '喊',
        radicals: &['ノ', '口', '戈'],
    },
    Decomposition {
        kanji: '喟',
        radicals: &['月', '口', '田'],
    },
    Decomposition {
        kanji: '啻',
        radicals: &['巾', '口', '丷', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '啾',
        radicals: &['火', '禾', '口'],
    },
    Decomposition {
        kanji: '喘',
        radicals: &['｜', '一', '口', '山', '而', '冂'],
    },
    Decomposition {
        kanji: '喞',
        radicals: &['口', '艮', '卩'],
    },
    Decomposition {
        kanji: '單',
        radicals: &['口', '十', '田'],
    },
    Decomposition {
        kanji: '啼',
        radicals: &['巾', '口', '丷', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '喃',
        radicals: &['干', '口', '十', '丷', '冂'],
    },
    Decomposition {
        kanji: '喩',
        radicals: &['⺉', '月', '口', '𠆢', '一'],
    },
    Decomposition {
        kanji: '喇',
        radicals: &['｜', '⺉', '口', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '喨',
        radicals: &['口', '亠', '儿', '冖'],
    },
    Decomposition {
        kanji: '嗚',
        radicals: &['口', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '嗅',
        radicals: &['口', '自', '大', '目', '犬'],
    },
    Decomposition {
        kanji: '嗟',
        radicals: &['ノ', '王', '口', '工', '丷', '羊'],
    },
    Decomposition {
        kanji: '嗄',
        radicals: &['一', '口', '自', '夂'],
    },
    Decomposition {
        kanji: '嗜',
        radicals: &['口', '日', '⺹', '匕'],
    },
    Decomposition {
        kanji: '嗤',
        radicals: &['口', '山', '虫'],
    },
    Decomposition {
        kanji: '嗔',
        radicals: &['口', '十', 'ハ', '目'],
    },
    Decomposition {
        kanji: '嘔',
        radicals: &['口', '匚', '品'],
    },
    Decomposition {
        kanji: '嗷',
        radicals: &['口', '土', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '嘖',
        radicals: &['貝', '目', 'ハ', '口', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '嗾',
        radicals: &['口', '方', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '嗽',
        radicals: &['｜', '欠', '口', 'ハ', '木'],
    },
    Decomposition {
        kanji: '嘛',
        radicals: &['口', '麻', '木', '广'],
    },
    Decomposition {
        kanji: '嗹',
        radicals: &['口', '⻌', '車'],
    },
    Decomposition {
        kanji: '噎',
        radicals: &['口', '士', '豆', '丷', '冖'],
    },
    Decomposition {
        kanji: '噐',
        radicals: &['口', '工'],
    },
    Decomposition {
        kanji: '營',
        radicals: &['火', '口', '冖', 'ノ'],
    },
    Decomposition {
        kanji: '嘴',
        radicals: &['角', '口', '止', '匕'],
    },
    Decomposition {
        kanji: '嘶',
        radicals: &['甘', '斤', '口', 'ハ'],
    },
    Decomposition {
        kanji: '嘲',
        radicals: &['月', '口', '十', '日'],
    },
    Decomposition {
        kanji: '嘸',
        radicals: &['｜', 'ノ', '一', '口', '⺣', '無', '𠂉'],
    },
    Decomposition {
        kanji: '噫',
        radicals: &['音', '口', '心', '日', '立'],
    },
    Decomposition {
        kanji: '噤',
        radicals: &['口', '示', '二', '小', '木'],
    },
    Decomposition {
        kanji: '嘯',
        radicals: &['｜', 'ノ', 'ヨ', '口', '水', '米', '隶', '聿'],
    },
    Decomposition {
        kanji: '噬',
        radicals: &['口', '工', '人', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '噪',
        radicals: &['口', '木', '品'],
    },
    Decomposition {
        kanji: '嚆',
        radicals: &['口', '高', '亠', '冂', '⺾'],
    },
    Decomposition {
        kanji: '嚀',
        radicals: &['口', '心', '⺲', '宀', '皿'],
    },
    Decomposition {
        kanji: '嚊',
        radicals: &['口', '自', '田', '廾', '鼻', '目'],
    },
    Decomposition {
        kanji: '嚠',
        radicals: &['⺉', '金', '口', '厶', '刀'],
    },
    Decomposition {
        kanji: '嚔',
        radicals: &['口', '十', '田', '冖', '疋'],
    },
    Decomposition {
        kanji: '嚏',
        radicals: &['口', '十', '田', '疋', '冖'],
    },
    Decomposition {
        kanji: '嚥',
        radicals: &['一', '口', '凵', '匕', '⺣', '爿'],
    },
    Decomposition {
        kanji: '嚮',
        radicals: &['口', '艮', '⻏', '冂', '幺'],
    },
    Decomposition {
        kanji: '嚶',
        radicals: &['貝', '目', 'ハ', '口', '女'],
    },
    Decomposition {
        kanji: '嚴',
        radicals: &['口', '耳', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '囂',
        radicals: &['一', '口', 'ハ', '頁', '貝', '目'],
    },
    Decomposition {
        kanji: '嚼',
        radicals: &['口', '艮', '寸', '爪', '⺲'],
    },
    Decomposition {
        kanji: '囁',
        radicals: &['口', '耳'],
    },
    Decomposition {
        kanji: '囃',
        radicals: &['口', '人', '木', '亠', '隹'],
    },
    Decomposition {
        kanji: '囀',
        radicals: &['口', '車', '十', '寸', '田', '厶'],
    },
    Decomposition {
        kanji: '囈',
        radicals: &['九', '口', '土', '二', '丶', '儿', '厶', '⺾'],
    },
    Decomposition {
        kanji: '囎',
        radicals: &['貝', '目', '口', '田', '日', 'ハ', '丷'],
    },
    Decomposition {
        kanji: '囑',
        radicals: &['口', '虫', '⺲', '勹', '尸'],
    },
    Decomposition {
        kanji: '囓',
        radicals: &['口', '止', '歯', '土', '刀', '米', '亠', '凵', '二'],
    },
    Decomposition {
        kanji: '囗',
        radicals: &['囗', '口'],
    },
    Decomposition {
        kanji: '囮',
        radicals: &['⺅', '匕', '囗'],
    },
    Decomposition {
        kanji: '囹',
        radicals: &['刀', '𠆢', '囗', '一'],
    },
    Decomposition {
        kanji: '圀',
        radicals: &['方', '儿', '囗'],
    },
    Decomposition {
        kanji: '囿',
        radicals: &['ノ', '一', '月', '囗'],
    },
    Decomposition {
        kanji: '圄',
        radicals: &['口', '囗', '五'],
    },
    Decomposition {
        kanji: '圉',
        radicals: &['干', '十', '辛', '土', '立', '亠', '囗'],
    },
    Decomposition {
        kanji: '圈',
        radicals: &['人', '大', '二', '丷', '卩', '囗'],
    },
    Decomposition {
        kanji: '國',
        radicals: &['口', '囗', '戈'],
    },
    Decomposition {
        kanji: '圍',
        radicals: &['口', '囗', '韋'],
    },
    Decomposition {
        kanji: '圓',
        radicals: &['貝', '目', 'ハ', '口', '囗'],
    },
    Decomposition {
        kanji: '團',
        radicals: &['十', '寸', '厶', '囗', '田'],
    },
    Decomposition {
        kanji: '圖',
        radicals: &['口', '囗'],
    },
    Decomposition {
        kanji: '嗇',
        radicals: &['口', '人', '土', '囗'],
    },
    Decomposition {
        kanji: '圜',
        radicals: &['衣', '一', '口', '⺲', '囗'],
    },
    Decomposition {
        kanji: '圦',
        radicals: &['土', '入'],
    },
    Decomposition {
        kanji: '圷',
        radicals: &['土', '卜', '一'],
    },
    Decomposition {
        kanji: '圸',
        radicals: &['山', '土'],
    },
    Decomposition {
        kanji: '坎',
        radicals: &['欠', '土'],
    },
    Decomposition {
        kanji: '圻',
        radicals: &['斤', '土'],
    },
    Decomposition {
        kanji: '址',
        radicals: &['止', '土'],
    },
    Decomposition {
        kanji: '坏',
        radicals: &['｜', 'ノ', '一', '土', '丶'],
    },
    Decomposition {
        kanji: '坩',
        radicals: &['甘', '土'],
    },
    Decomposition {
        kanji: '埀',
        radicals: &['ノ', '土', '匕', '爿'],
    },
    Decomposition {
        kanji: '垈',
        radicals: &['⺅', '土', '弋'],
    },
    Decomposition {
        kanji: '坡',
        radicals: &['土', '皮', '又'],
    },
    Decomposition {
        kanji: '坿',
        radicals: &['⺅', '寸', '土'],
    },
    Decomposition {
        kanji: '垉',
        radicals: &['土', '勹', '已'],
    },
    Decomposition {
        kanji: '垓',
        radicals: &['人', '土', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '垠',
        radicals: &['艮', '土'],
    },
    Decomposition {
        kanji: '垳',
        radicals: &['行', '土', '彳'],
    },
    Decomposition {
        kanji: '垤',
        radicals: &['至', '土', '厶'],
    },
    Decomposition {
        kanji: '垪',
        radicals: &['｜', 'ノ', '土', '二', '丷', '廾', '一'],
    },
    Decomposition {
        kanji: '垰',
        radicals: &['土', '卜'],
    },
    Decomposition {
        kanji: '埃',
        radicals: &['土', '矢', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '埆',
        radicals: &['角', '土'],
    },
    Decomposition {
        kanji: '埔',
        radicals: &['十', '土', '用', '丶'],
    },
    Decomposition {
        kanji: '埒',
        radicals: &['寸', '爪', '土'],
    },
    Decomposition {
        kanji: '埓',
        radicals: &['ノ', '寸', '土'],
    },
    Decomposition {
        kanji: '堊',
        radicals: &['一', '土', '二'],
    },
    Decomposition {
        kanji: '埖',
        radicals: &['⺅', '土', '匕', '⺾'],
    },
    Decomposition {
        kanji: '埣',
        radicals: &['十', '人', '土', '亠'],
    },
    Decomposition {
        kanji: '堋',
        radicals: &['月', '土'],
    },
    Decomposition {
        kanji: '堙',
        radicals: &['｜', '一', '西', '土'],
    },
    Decomposition {
        kanji: '堝',
        radicals: &['口', '土', '冂'],
    },
    Decomposition {
        kanji: '塲',
        radicals: &['土', '日', '勿', '一', '𠂉'],
    },
    Decomposition {
        kanji: '堡',
        radicals: &['⺅', '口', '土', '木'],
    },
    Decomposition {
        kanji: '塢',
        radicals: &['鳥', '土', '⺣'],
    },
    Decomposition {
        kanji: '塋',
        radicals: &['火', '土', '冖'],
    },
    Decomposition {
        kanji: '塰',
        radicals: &['⺡', '土', '母', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '毀',
        radicals: &['臼', '土', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '塒',
        radicals: &['寸', '土', '日'],
    },
    Decomposition {
        kanji: '堽',
        radicals: &['止', '土', '⺲'],
    },
    Decomposition {
        kanji: '塹',
        radicals: &['斤', '車', '土'],
    },
    Decomposition {
        kanji: '墅',
        radicals: &['土', '里', 'マ'],
    },
    Decomposition {
        kanji: '墹',
        radicals: &['土', '日', '門'],
    },
    Decomposition {
        kanji: '墟',
        radicals: &['｜', '一', '土', '丷', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '墫',
        radicals: &['寸', '土', '酉', '丷'],
    },
    Decomposition {
        kanji: '墺',
        radicals: &['大', '土', '米', '冂', '釆'],
    },
    Decomposition {
        kanji: '壞',
        radicals: &['衣', '土', '⺲', '亠'],
    },
    Decomposition {
        kanji: '墻',
        radicals: &['口', '人', '土', '囗'],
    },
    Decomposition {
        kanji: '墸',
        radicals: &['土', '日', '⺹', '⺾'],
    },
    Decomposition {
        kanji: '墮',
        radicals: &['月', '工', '土', '⻖'],
    },
    Decomposition {
        kanji: '壅',
        radicals: &['土', '亠', '隹', '幺'],
    },
    Decomposition {
        kanji: '壓',
        radicals: &['月', '犬', '土', '日', '厂'],
    },
    Decomposition {
        kanji: '壑',
        radicals: &['口', '土', 'ハ', '卜', '又', '𠆢', '冖', '谷'],
    },
    Decomposition {
        kanji: '壗',
        radicals: &['ヨ', '皿', '土', '⺣', '聿'],
    },
    Decomposition {
        kanji: '壙',
        radicals: &['｜', '一', '黄', '田', '土', '二', 'ハ', '广'],
    },
    Decomposition {
        kanji: '壘',
        radicals: &['田', '土'],
    },
    Decomposition {
        kanji: '壥',
        radicals: &['黒', '土', '里', '厂', '⺣'],
    },
    Decomposition {
        kanji: '壜',
        radicals: &['雨', '土', '二', '日', '厶'],
    },
    Decomposition {
        kanji: '壤',
        radicals: &['｜', '衣', '一', '口', '土', '亠', '二'],
    },
    Decomposition {
        kanji: '壟',
        radicals: &['月', '土', '立'],
    },
    Decomposition {
        kanji: '壯',
        radicals: &['士', '爿'],
    },
    Decomposition {
        kanji: '壺',
        radicals: &['一', '士', '冖'],
    },
    Decomposition {
        kanji: '壹',
        radicals: &['口', '士', '豆', '丷', '冖'],
    },
    Decomposition {
        kanji: '壻',
        radicals: &['月', '土', '疋'],
    },
    Decomposition {
        kanji: '壼',
        radicals: &['一', '士', '二', '冖'],
    },
    Decomposition {
        kanji: '壽',
        radicals: &['一', '口', '工', '士', '寸'],
    },
    Decomposition {
        kanji: '夂',
        radicals: &['夂', '攵'],
    },
    Decomposition {
        kanji: '夊',
        radicals: &['夂'],
    },
    Decomposition {
        kanji: '夐',
        radicals: &['目', '冂', '夂', '勹', '人'],
    },
    Decomposition {
        kanji: '夛',
        radicals: &['ヨ', '夕'],
    },
    Decomposition {
        kanji: '梦',
        radicals: &['木', '夕'],
    },
    Decomposition {
        kanji: '夥',
        radicals: &['田', '木', '夕'],
    },
    Decomposition {
        kanji: '夬',
        radicals: &['人', '大', '二', 'ユ'],
    },
    Decomposition {
        kanji: '夭',
        radicals: &['ノ', '大'],
    },
    Decomposition {
        kanji: '夲',
        radicals: &['十', '大'],
    },
    Decomposition {
        kanji: '夸',
        radicals: &['大', '二', '勹'],
    },
    Decomposition {
        kanji: '夾',
        radicals: &['人', '大'],
    },
    Decomposition {
        kanji: '竒',
        radicals: &['一', '口', '丷', '立', '亅', '亠'],
    },
    Decomposition {
        kanji: '奕',
        radicals: &['赤', '大', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '奐',
        radicals: &['大', '儿', '冂', '勹'],
    },
    Decomposition {
        kanji: '奎',
        radicals: &['大', '土'],
    },
    Decomposition {
        kanji: '奚',
        radicals: &['大', '爪', '幺'],
    },
    Decomposition {
        kanji: '奘',
        radicals: &['士', '大', '爿'],
    },
    Decomposition {
        kanji: '奢',
        radicals: &['大', '日', '⺹'],
    },
    Decomposition {
        kanji: '奠',
        radicals: &['大', '酉', '丷'],
    },
    Decomposition {
        kanji: '奧',
        radicals: &['大', '米', '冂', '釆'],
    },
    Decomposition {
        kanji: '奬',
        radicals: &['寸', '大', '爿', '夕'],
    },
    Decomposition {
        kanji: '奩',
        radicals: &['口', '大', '匚', '品'],
    },
    Decomposition {
        kanji: '奸',
        radicals: &['干', '女'],
    },
    Decomposition {
        kanji: '妁',
        radicals: &['女', '丶', '勹'],
    },
    Decomposition {
        kanji: '妝',
        radicals: &['女', '爿'],
    },
    Decomposition {
        kanji: '佞',
        radicals: &['⺅', '女', '二'],
    },
    Decomposition {
        kanji: '侫',
        radicals: &['亡', '⺅', '女'],
    },
    Decomposition {
        kanji: '妣',
        radicals: &['女', '比'],
    },
    Decomposition {
        kanji: '妲',
        radicals: &['女', '日', '一'],
    },
    Decomposition {
        kanji: '姆',
        radicals: &['女', '母', '毋'],
    },
    Decomposition {
        kanji: '姨',
        radicals: &['弓', '女', '人', '大'],
    },
    Decomposition {
        kanji: '姜',
        radicals: &['王', '女', '丷', '羊'],
    },
    Decomposition {
        kanji: '妍',
        radicals: &['｜', 'ノ', '一', '女', '二', '廾'],
    },
    Decomposition {
        kanji: '姙',
        radicals: &['ノ', '⺅', '士', '女'],
    },
    Decomposition {
        kanji: '姚',
        radicals: &['女', '儿', '冫'],
    },
    Decomposition {
        kanji: '娥',
        radicals: &['女', '亅', '戈'],
    },
    Decomposition {
        kanji: '娟',
        radicals: &['月', '口', '女'],
    },
    Decomposition {
        kanji: '娑',
        radicals: &['ノ', '⺡', '女', '小'],
    },
    Decomposition {
        kanji: '娜',
        radicals: &['女', '刀', '⻏', '二'],
    },
    Decomposition {
        kanji: '娉',
        radicals: &['｜', '女', '田', '一', '勹'],
    },
    Decomposition {
        kanji: '娚',
        radicals: &['女', '田', '力'],
    },
    Decomposition {
        kanji: '婀',
        radicals: &['口', '女', '亅', '⻖', '一'],
    },
    Decomposition {
        kanji: '婬',
        radicals: &['ノ', '士', '女', '爪'],
    },
    Decomposition {
        kanji: '婉',
        radicals: &['女', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '娵',
        radicals: &['耳', '女', '又'],
    },
    Decomposition {
        kanji: '娶',
        radicals: &['耳', '女', '又'],
    },
    Decomposition {
        kanji: '婢',
        radicals: &['十', '女', '田'],
    },
    Decomposition {
        kanji: '婪',
        radicals: &['女', '木'],
    },
    Decomposition {
        kanji: '媚',
        radicals: &['女', '目', '尸', '｜'],
    },
    Decomposition {
        kanji: '媼',
        radicals: &['皿', '女', '日'],
    },
    Decomposition {
        kanji: '媾',
        radicals: &['｜', '一', '女', '二', '冂', '十'],
    },
    Decomposition {
        kanji: '嫋',
        radicals: &['弓', '女', '冫'],
    },
    Decomposition {
        kanji: '嫂',
        radicals: &['｜', '女', '田', '又'],
    },
    Decomposition {
        kanji: '媽',
        radicals: &['女', '馬', '⺣'],
    },
    Decomposition {
        kanji: '嫣',
        radicals: &['一', '止', '女', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '嫗',
        radicals: &['口', '女', '匚', '品'],
    },
    Decomposition {
        kanji: '嫦',
        radicals: &['巾', '口', '女', '⺌'],
    },
    Decomposition {
        kanji: '嫩',
        radicals: &['｜', '口', '女', 'ハ', '木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '嫖',
        radicals: &['示', '二', '小', '女', '西'],
    },
    Decomposition {
        kanji: '嫺',
        radicals: &['女', '日', '門'],
    },
    Decomposition {
        kanji: '嫻',
        radicals: &['女', '木', '門'],
    },
    Decomposition {
        kanji: '嬌',
        radicals: &['ノ', '口', '女', '大', '冂'],
    },
    Decomposition {
        kanji: '嬋',
        radicals: &['｜', '口', '十', '女', '田'],
    },
    Decomposition {
        kanji: '嬖',
        radicals: &['口', '十', '女', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '嬲',
        radicals: &['女', '田', '力'],
    },
    Decomposition {
        kanji: '嫐',
        radicals: &['女', '田', '力'],
    },
    Decomposition {
        kanji: '嬪',
        radicals: &['ノ', '貝', '目', 'ハ', '女', '小', '宀'],
    },
    Decomposition {
        kanji: '嬶',
        radicals: &['自', '女', '田', '鼻', '目', '廾'],
    },
    Decomposition {
        kanji: '嬾',
        radicals: &['｜', '貝', '目', '口', '女', 'ハ', '頁', '木'],
    },
    Decomposition {
        kanji: '孃',
        radicals: &['｜', '衣', '一', '口', '女', '亠'],
    },
    Decomposition {
        kanji: '孅',
        radicals: &['女', '人', '戈', '韭'],
    },
    Decomposition {
        kanji: '孀',
        radicals: &['雨', '女', '木', '目'],
    },
    Decomposition {
        kanji: '孑',
        radicals: &['子'],
    },
    Decomposition {
        kanji: '孕',
        radicals: &['乃', '子', 'ノ'],
    },
    Decomposition {
        kanji: '孚',
        radicals: &['子', '爪'],
    },
    Decomposition {
        kanji: '孛',
        radicals: &['士', '子', '十', '冖'],
    },
    Decomposition {
        kanji: '孥',
        radicals: &['子', '女', '又'],
    },
    Decomposition {
        kanji: '孩',
        radicals: &['子', '亠', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '孰',
        radicals: &['九', '口', '子', '丶', '亠'],
    },
    Decomposition {
        kanji: '孳',
        radicals: &['一', '子', '丷', '幺'],
    },
    Decomposition {
        kanji: '孵',
        radicals: &['子', '爪', '丶', '卩'],
    },
    Decomposition {
        kanji: '學',
        radicals: &['臼', '子', '冖'],
    },
    Decomposition {
        kanji: '斈',
        radicals: &['子', '文'],
    },
    Decomposition {
        kanji: '孺',
        radicals: &['｜', '一', '雨', '子', '而', '冂'],
    },
    Decomposition {
        kanji: '宀',
        radicals: &['宀'],
    },
    Decomposition {
        kanji: '它',
        radicals: &['匕', '宀'],
    },
    Decomposition {
        kanji: '宦',
        radicals: &['臣', '宀'],
    },
    Decomposition {
        kanji: '宸',
        radicals: &['衣', '辰', '厂', '宀'],
    },
    Decomposition {
        kanji: '寃',
        radicals: &['免', '丶', '儿', '宀', '勹'],
    },
    Decomposition {
        kanji: '寇',
        radicals: &['二', '卜', '又', '儿', '宀', '元'],
    },
    Decomposition {
        kanji: '寉',
        radicals: &['宀', '隹'],
    },
    Decomposition {
        kanji: '寔',
        radicals: &['日', '疋', '宀'],
    },
    Decomposition {
        kanji: '寐',
        radicals: &['二', 'ハ', '亅', '宀', '爿'],
    },
    Decomposition {
        kanji: '寤',
        radicals: &['口', '宀', '爿', '五'],
    },
    Decomposition {
        kanji: '實',
        radicals: &['一', '貝', '目', 'ハ', '田', '宀'],
    },
    Decomposition {
        kanji: '寢',
        radicals: &['ヨ', '又', '冖', '宀', '爿'],
    },
    Decomposition {
        kanji: '寞',
        radicals: &['大', '日', '宀', '⺾'],
    },
    Decomposition {
        kanji: '寥',
        radicals: &['羽', '𠆢', '冫', '宀', '彡'],
    },
    Decomposition {
        kanji: '寫',
        radicals: &['臼', '勹', '宀', '⺣'],
    },
    Decomposition {
        kanji: '寰',
        radicals: &['衣', '一', '口', '⺲', '宀'],
    },
    Decomposition {
        kanji: '寶',
        radicals: &['王', '貝', '目', 'ハ', '缶', '凵', '宀'],
    },
    Decomposition {
        kanji: '寳',
        radicals: &['王', '貝', '目', 'ハ', '小', '宀', '𠂉'],
    },
    Decomposition {
        kanji: '尅',
        radicals: &['口', '十', '寸', '儿'],
    },
    Decomposition {
        kanji: '將',
        radicals: &['寸', '夕', '爿'],
    },
    Decomposition {
        kanji: '專',
        radicals: &['一', '十', '寸', '虫', '田', '厶'],
    },
    Decomposition {
        kanji: '對',
        radicals: &['王', '寸', '丷', '羊'],
    },
    Decomposition {
        kanji: '尓',
        radicals: &['ノ', '小', '𠂉'],
    },
    Decomposition {
        kanji: '尠',
        radicals: &['ノ', '甘', '小', '儿', '匚'],
    },
    Decomposition {
        kanji: '尢',
        radicals: &['尢'],
    },
    Decomposition {
        kanji: '尨',
        radicals: &['丶', '尤', '彡', '尢'],
    },
    Decomposition {
        kanji: '尸',
        radicals: &['尸'],
    },
    Decomposition {
        kanji: '尹',
        radicals: &['ノ', 'ヨ', '一'],
    },
    Decomposition {
        kanji: '屁',
        radicals: &['比', '尸'],
    },
    Decomposition {
        kanji: '屆',
        radicals: &['士', '土', '凵', '尸'],
    },
    Decomposition {
        kanji: '屎',
        radicals: &['米', '尸'],
    },
    Decomposition {
        kanji: '屓',
        radicals: &['貝', '目', 'ハ', '尸'],
    },
    Decomposition {
        kanji: '屐',
        radicals: &['支', '尸', '彳', '又', '十'],
    },
    Decomposition {
        kanji: '屏',
        radicals: &['｜', 'ノ', '二', '丷', '尸', '廾', '一'],
    },
    Decomposition {
        kanji: '孱',
        radicals: &['子', '尸'],
    },
    Decomposition {
        kanji: '屬',
        radicals: &['虫', '⺲', '勹', '尸'],
    },
    Decomposition {
        kanji: '屮',
        radicals: &['屮'],
    },
    Decomposition {
        kanji: '乢',
        radicals: &['乙', '山'],
    },
    Decomposition {
        kanji: '屶',
        radicals: &['山', '刀'],
    },
    Decomposition {
        kanji: '屹',
        radicals: &['ノ', '乙', '山', '𠂉'],
    },
    Decomposition {
        kanji: '岌',
        radicals: &['及', '山'],
    },
    Decomposition {
        kanji: '岑',
        radicals: &['山', '𠆢', '一'],
    },
    Decomposition {
        kanji: '岔',
        radicals: &['山', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '妛',
        radicals: &['一', '山', '女'],
    },
    Decomposition {
        kanji: '岫',
        radicals: &['｜', '山', '田'],
    },
    Decomposition {
        kanji: '岻',
        radicals: &['山', '氏', '一'],
    },
    Decomposition {
        kanji: '岶',
        radicals: &['山', '白'],
    },
    Decomposition {
        kanji: '岼',
        radicals: &['｜', '干', '山', '二', 'ハ'],
    },
    Decomposition {
        kanji: '岷',
        radicals: &['口', '山', '氏', '尸'],
    },
    Decomposition {
        kanji: '峅',
        radicals: &['山', '厶', '廾'],
    },
    Decomposition {
        kanji: '岾',
        radicals: &['口', '山', '卜'],
    },
    Decomposition {
        kanji: '峇',
        radicals: &['口', '山', '𠆢', '一'],
    },
    Decomposition {
        kanji: '峙',
        radicals: &['山', '寸', '土'],
    },
    Decomposition {
        kanji: '峩',
        radicals: &['山', '亅', '戈'],
    },
    Decomposition {
        kanji: '峽',
        radicals: &['山', '人', '大'],
    },
    Decomposition {
        kanji: '峺',
        radicals: &['ノ', '一', '山', '田'],
    },
    Decomposition {
        kanji: '峭',
        radicals: &['月', '山', '⺌'],
    },
    Decomposition {
        kanji: '嶌',
        radicals: &['山', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '峪',
        radicals: &['口', '山', 'ハ', '𠆢', '谷'],
    },
    Decomposition {
        kanji: '崋',
        radicals: &['｜', '一', '山'],
    },
    Decomposition {
        kanji: '崕',
        radicals: &['山', '土', '厂'],
    },
    Decomposition {
        kanji: '崗',
        radicals: &['山', '丷', '冂', '凵', '岡'],
    },
    Decomposition {
        kanji: '嵜',
        radicals: &['一', '口', '山', '丷', '立', '亅', '亠', '大'],
    },
    Decomposition {
        kanji: '崟',
        radicals: &['金', '山'],
    },
    Decomposition {
        kanji: '崛',
        radicals: &['｜', '山', '尸'],
    },
    Decomposition {
        kanji: '崑',
        radicals: &['山', '日', '比'],
    },
    Decomposition {
        kanji: '崔',
        radicals: &['山', '隹'],
    },
    Decomposition {
        kanji: '崢',
        radicals: &['ヨ', '山', '爪', '亅', '尸'],
    },
    Decomposition {
        kanji: '崚',
        radicals: &['山', '土', '儿', '夂'],
    },
    Decomposition {
        kanji: '崙',
        radicals: &['｜', '一', '山', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '崘',
        radicals: &['｜', '一', '山', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '嵌',
        radicals: &['甘', '欠', '山'],
    },
    Decomposition {
        kanji: '嵒',
        radicals: &['口', '山', '品'],
    },
    Decomposition {
        kanji: '嵎',
        radicals: &['山', '田', '⽱'],
    },
    Decomposition {
        kanji: '嵋',
        radicals: &['山', '目', '尸', '｜'],
    },
    Decomposition {
        kanji: '嵬',
        radicals: &['鬼', '山', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '嵳',
        radicals: &['王', '工', '山', '丷', '羊'],
    },
    Decomposition {
        kanji: '嵶',
        radicals: &['弓', '山', '冫'],
    },
    Decomposition {
        kanji: '嶇',
        radicals: &['口', '山', '匚', '品'],
    },
    Decomposition {
        kanji: '嶄',
        radicals: &['斤', '山', '車'],
    },
    Decomposition {
        kanji: '嶂',
        radicals: &['音', '山', '十', '日', '立', '曰'],
    },
    Decomposition {
        kanji: '嶢',
        radicals: &['山', '土', '儿'],
    },
    Decomposition {
        kanji: '嶝',
        radicals: &['口', '山', '豆', '丷', '癶'],
    },
    Decomposition {
        kanji: '嶬',
        radicals: &['王', '山', '丷', '羊', '亅', '戈'],
    },
    Decomposition {
        kanji: '嶮',
        radicals: &['口', '山', '人', '𠆢', '一'],
    },
    Decomposition {
        kanji: '嶽',
        radicals: &['犬', '言', '山'],
    },
    Decomposition {
        kanji: '嶐',
        radicals: &['山', '生', '夂', '⻖'],
    },
    Decomposition {
        kanji: '嶷',
        radicals: &['山', '疋', '矢', '匕', '𠂉'],
    },
    Decomposition {
        kanji: '嶼',
        radicals: &['臼', '山', 'ハ'],
    },
    Decomposition {
        kanji: '巉',
        radicals: &['山', '比', '丶', '儿', '勹', '口'],
    },
    Decomposition {
        kanji: '巍',
        radicals: &['禾', '鬼', '山', '女', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '巓',
        radicals: &['貝', '山', '十', 'ハ', '頁', '目'],
    },
    Decomposition {
        kanji: '巒',
        radicals: &['言', '山', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '巖',
        radicals: &['口', '山', '耳', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '巛',
        radicals: &['巛'],
    },
    Decomposition {
        kanji: '巫',
        radicals: &['工', '人'],
    },
    Decomposition {
        kanji: '已',
        radicals: &['已'],
    },
    Decomposition {
        kanji: '巵',
        radicals: &['一', '厂', '巴'],
    },
    Decomposition {
        kanji: '帋',
        radicals: &['巾', '氏'],
    },
    Decomposition {
        kanji: '帚',
        radicals: &['ヨ', '巾', '冖'],
    },
    Decomposition {
        kanji: '帙',
        radicals: &['ノ', '巾', '人', '大', '二'],
    },
    Decomposition {
        kanji: '帑',
        radicals: &['巾', '女', '又'],
    },
    Decomposition {
        kanji: '帛',
        radicals: &['巾', '白'],
    },
    Decomposition {
        kanji: '帶',
        radicals: &['一', '巾', '儿', '冖', '凵'],
    },
    Decomposition {
        kanji: '帷',
        radicals: &['巾', '隹'],
    },
    Decomposition {
        kanji: '幄',
        radicals: &['巾', '至', '土', '厶', '尸'],
    },
    Decomposition {
        kanji: '幃',
        radicals: &['巾', '韋', '口'],
    },
    Decomposition {
        kanji: '幀',
        radicals: &['貝', '目', 'ハ', '巾', '卜'],
    },
    Decomposition {
        kanji: '幎',
        radicals: &['巾', '日', 'ハ', '亠', '冖'],
    },
    Decomposition {
        kanji: '幗',
        radicals: &['巾', '口', '囗', '戈'],
    },
    Decomposition {
        kanji: '幔',
        radicals: &['巾', '日', '⺲', '又'],
    },
    Decomposition {
        kanji: '幟',
        radicals: &['音', '巾', '日', '立', '戈'],
    },
    Decomposition {
        kanji: '幢',
        radicals: &['巾', '里', '立'],
    },
    Decomposition {
        kanji: '幤',
        radicals: &['巾', '口', '⺌', '冂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '幇',
        radicals: &['巾', '寸', '土'],
    },
    Decomposition {
        kanji: '幵',
        radicals: &['干'],
    },
    Decomposition {
        kanji: '并',
        radicals: &['ノ', '干', '二', '丷', '一'],
    },
    Decomposition {
        kanji: '幺',
        radicals: &['幺'],
    },
    Decomposition {
        kanji: '麼',
        radicals: &['木', '幺', '广', '麻'],
    },
    Decomposition {
        kanji: '广',
        radicals: &['广'],
    },
    Decomposition {
        kanji: '庠',
        radicals: &['王', '丷', '羊', '广'],
    },
    Decomposition {
        kanji: '廁',
        radicals: &['貝', '目', 'ハ', '⺉', '广'],
    },
    Decomposition {
        kanji: '廂',
        radicals: &['木', '目', '广'],
    },
    Decomposition {
        kanji: '廈',
        radicals: &['一', '自', '夂', '广'],
    },
    Decomposition {
        kanji: '廐',
        radicals: &['艮', '广', '无'],
    },
    Decomposition {
        kanji: '廏',
        radicals: &['艮', '广', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '廖',
        radicals: &['羽', '𠆢', '冫', '广', '彡'],
    },
    Decomposition {
        kanji: '廣',
        radicals: &['黄', '田', 'ハ', '广'],
    },
    Decomposition {
        kanji: '廝',
        radicals: &['甘', '斤', 'ハ', '广'],
    },
    Decomposition {
        kanji: '廚',
        radicals: &['口', '士', '寸', '豆', '丷', '广'],
    },
    Decomposition {
        kanji: '廛',
        radicals: &['土', '里', '儿', '广'],
    },
    Decomposition {
        kanji: '廢',
        radicals: &['弓', '广', '殳', '癶', '几', '又'],
    },
    Decomposition {
        kanji: '廡',
        radicals: &['｜', '一', '广', '⺣', '無', 'ノ', '𠂉'],
    },
    Decomposition {
        kanji: '廨',
        radicals: &['角', '牛', '刀', '广'],
    },
    Decomposition {
        kanji: '廩',
        radicals: &['禾', '口', '亠', '囗', '广'],
    },
    Decomposition {
        kanji: '廬',
        radicals: &['皿', '田', '卜', '匕', '厂', '广', '虍'],
    },
    Decomposition {
        kanji: '廱',
        radicals: &['口', '巛', '巴', '广', '隹'],
    },
    Decomposition {
        kanji: '廳',
        radicals: &['一', '王', '耳', '十', '心', '⺲', '广'],
    },
    Decomposition {
        kanji: '廰',
        radicals: &['耳', '十', '心', '⺲', '广'],
    },
    Decomposition {
        kanji: '廴',
        radicals: &['廴'],
    },
    Decomposition {
        kanji: '廸',
        radicals: &['｜', '日', '廴'],
    },
    Decomposition {
        kanji: '廾',
        radicals: &['廾'],
    },
    Decomposition {
        kanji: '弃',
        radicals: &['亠', '厶', '廾'],
    },
    Decomposition {
        kanji: '弉',
        radicals: &['士', '廾', '爿'],
    },
    Decomposition {
        kanji: '彝',
        radicals: &['ヨ', '糸', '幺', '小', '米', '廾', '彑'],
    },
    Decomposition {
        kanji: '彜',
        radicals: &['ヨ', '刀', '丷', '米', '廾', '彑'],
    },
    Decomposition {
        kanji: '弋',
        radicals: &['弋'],
    },
    Decomposition {
        kanji: '弑',
        radicals: &['工', '木', '弋'],
    },
    Decomposition {
        kanji: '弖',
        radicals: &['一', '弓'],
    },
    Decomposition {
        kanji: '弩',
        radicals: &['弓', '女', '又'],
    },
    Decomposition {
        kanji: '弭',
        radicals: &['弓', '耳'],
    },
    Decomposition {
        kanji: '弸',
        radicals: &['弓', '月'],
    },
    Decomposition {
        kanji: '彁',
        radicals: &['弓', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '彈',
        radicals: &['｜', '弓', '口', '十', '田'],
    },
    Decomposition {
        kanji: '彌',
        radicals: &['｜', '一', '弓', 'ハ', '冂', '爻'],
    },
    Decomposition {
        kanji: '彎',
        radicals: &['弓', '言', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '弯',
        radicals: &['弓', '赤', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '彑',
        radicals: &['ヨ', '彑'],
    },
    Decomposition {
        kanji: '彖',
        radicals: &['彑', '豕'],
    },
    Decomposition {
        kanji: '彗',
        radicals: &['ヨ', '二', '亠', '土'],
    },
    Decomposition {
        kanji: '彙',
        radicals: &['ヨ', '田', '木', '冖', '彑'],
    },
    Decomposition {
        kanji: '彡',
        radicals: &['彡'],
    },
    Decomposition {
        kanji: '彭',
        radicals: &['口', '土', '豆', '丷', '彡'],
    },
    Decomposition {
        kanji: '彳',
        radicals: &['彳'],
    },
    Decomposition {
        kanji: '彷',
        radicals: &['方', '彳'],
    },
    Decomposition {
        kanji: '徃',
        radicals: &['生', '彳'],
    },
    Decomposition {
        kanji: '徂',
        radicals: &['目', '彳'],
    },
    Decomposition {
        kanji: '彿',
        radicals: &['｜', 'ノ', '弓', '彳'],
    },
    Decomposition {
        kanji: '徊',
        radicals: &['口', '囗', '彳'],
    },
    Decomposition {
        kanji: '很',
        radicals: &['艮', '彳'],
    },
    Decomposition {
        kanji: '徑',
        radicals: &['一', '工', '巛', '彳'],
    },
    Decomposition {
        kanji: '徇',
        radicals: &['日', '勹', '彳'],
    },
    Decomposition {
        kanji: '從',
        radicals: &['人', '疋', '彳'],
    },
    Decomposition {
        kanji: '徙',
        radicals: &['止', '疋', '彳'],
    },
    Decomposition {
        kanji: '徘',
        radicals: &['非', '彳'],
    },
    Decomposition {
        kanji: '徠',
        radicals: &['｜', '人', 'ハ', '木', '彳'],
    },
    Decomposition {
        kanji: '徨',
        radicals: &['王', '白', '彳'],
    },
    Decomposition {
        kanji: '徭',
        radicals: &['缶', '夕', '凵', '彳'],
    },
    Decomposition {
        kanji: '徼',
        radicals: &['白', '方', '夂', '彳'],
    },
    Decomposition {
        kanji: '忖',
        radicals: &['寸', '⺖'],
    },
    Decomposition {
        kanji: '忻',
        radicals: &['斤', '⺖'],
    },
    Decomposition {
        kanji: '忤',
        radicals: &['ノ', '干', '⺖', '十', '𠂉'],
    },
    Decomposition {
        kanji: '忸',
        radicals: &['｜', '一', '⺖'],
    },
    Decomposition {
        kanji: '忱',
        radicals: &['⺖', '儿', '冖', '尢'],
    },
    Decomposition {
        kanji: '忝',
        radicals: &['ノ', '心', '大', '一', '二'],
    },
    Decomposition {
        kanji: '悳',
        radicals: &['十', '心', '目'],
    },
    Decomposition {
        kanji: '忿',
        radicals: &['心', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '怡',
        radicals: &['口', '⺖', '厶'],
    },
    Decomposition {
        kanji: '恠',
        radicals: &['ノ', '一', '土', '⺖'],
    },
    Decomposition {
        kanji: '怙',
        radicals: &['口', '十', '⺖'],
    },
    Decomposition {
        kanji: '怐',
        radicals: &['口', '⺖', '勹'],
    },
    Decomposition {
        kanji: '怩',
        radicals: &['⺖', '匕', '尸'],
    },
    Decomposition {
        kanji: '怎',
        radicals: &['｜', 'ノ', '一', '心', '𠂉'],
    },
    Decomposition {
        kanji: '怱',
        radicals: &['ノ', '心', '丶', '勿', '勹'],
    },
    Decomposition {
        kanji: '怛',
        radicals: &['日', '⺖', '一'],
    },
    Decomposition {
        kanji: '怕',
        radicals: &['白', '⺖'],
    },
    Decomposition {
        kanji: '怫',
        radicals: &['｜', 'ノ', '弓', '⺖'],
    },
    Decomposition {
        kanji: '怦',
        radicals: &['干', 'ハ', '⺖'],
    },
    Decomposition {
        kanji: '怏',
        radicals: &['人', '大', '⺖', '冂', '冖'],
    },
    Decomposition {
        kanji: '怺',
        radicals: &['水', '⺖', '丶'],
    },
    Decomposition {
        kanji: '恚',
        radicals: &['心', '土'],
    },
    Decomposition {
        kanji: '恁',
        radicals: &['ノ', '⺅', '士', '心'],
    },
    Decomposition {
        kanji: '恪',
        radicals: &['口', '⺖', '夂'],
    },
    Decomposition {
        kanji: '恷',
        radicals: &['⺅', '心', '木'],
    },
    Decomposition {
        kanji: '恟',
        radicals: &['⺖', '凵', '勹'],
    },
    Decomposition {
        kanji: '恊',
        radicals: &['⺖', '力'],
    },
    Decomposition {
        kanji: '恆',
        radicals: &['｜', '一', '⺖', '彑'],
    },
    Decomposition {
        kanji: '恍',
        radicals: &['⺌', '⺖', '儿'],
    },
    Decomposition {
        kanji: '恣',
        radicals: &['欠', '心', '冫'],
    },
    Decomposition {
        kanji: '恃',
        radicals: &['寸', '土', '⺖'],
    },
    Decomposition {
        kanji: '恤',
        radicals: &['血', '皿', '⺖'],
    },
    Decomposition {
        kanji: '恂',
        radicals: &['日', '⺖', '勹'],
    },
    Decomposition {
        kanji: '恬',
        radicals: &['口', '舌', '⺖'],
    },
    Decomposition {
        kanji: '恫',
        radicals: &['口', '⺖', '冂', '一'],
    },
    Decomposition {
        kanji: '恙',
        radicals: &['王', '心', '丷', '羊'],
    },
    Decomposition {
        kanji: '悁',
        radicals: &['月', '口', '⺖'],
    },
    Decomposition {
        kanji: '悍',
        radicals: &['干', '日', '⺖'],
    },
    Decomposition {
        kanji: '惧',
        radicals: &['ハ', '⺖', '目'],
    },
    Decomposition {
        kanji: '悃',
        radicals: &['⺖', '木', '囗'],
    },
    Decomposition {
        kanji: '悚',
        radicals: &['｜', '口', 'ハ', '⺖', '木'],
    },
    Decomposition {
        kanji: '悄',
        radicals: &['月', '⺌', '⺖'],
    },
    Decomposition {
        kanji: '悛',
        radicals: &['⺖', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '悖',
        radicals: &['子', '十', '⺖', '冖'],
    },
    Decomposition {
        kanji: '悗',
        radicals: &['免', '⺖', '儿', '勹'],
    },
    Decomposition {
        kanji: '悒',
        radicals: &['口', '⺖', '巴', '邑'],
    },
    Decomposition {
        kanji: '悧',
        radicals: &['禾', '⺉', '⺖'],
    },
    Decomposition {
        kanji: '悋',
        radicals: &['口', '文', '⺖'],
    },
    Decomposition {
        kanji: '惡',
        radicals: &['一', '心', '二'],
    },
    Decomposition {
        kanji: '悸',
        radicals: &['禾', '子', '⺖'],
    },
    Decomposition {
        kanji: '惠',
        radicals: &['｜', '一', '心', '虫', '日', '厶'],
    },
    Decomposition {
        kanji: '惓',
        radicals: &['大', '二', '丷', '⺖', '已'],
    },
    Decomposition {
        kanji: '悴',
        radicals: &['十', '人', '⺖', '亠'],
    },
    Decomposition {
        kanji: '忰',
        radicals: &['九', '十', '⺖'],
    },
    Decomposition {
        kanji: '悽',
        radicals: &['ヨ', '女', '⺖'],
    },
    Decomposition {
        kanji: '惆',
        radicals: &['口', '土', '⺖', '冂'],
    },
    Decomposition {
        kanji: '悵',
        radicals: &['長', '⺖'],
    },
    Decomposition {
        kanji: '惘',
        radicals: &['工', '丷', '⺖', '冂'],
    },
    Decomposition {
        kanji: '慍',
        radicals: &['皿', '日', '⺖'],
    },
    Decomposition {
        kanji: '愕',
        radicals: &['口', '二', '⺖', '勹'],
    },
    Decomposition {
        kanji: '愆',
        radicals: &['行', '⺡', '心', '彳'],
    },
    Decomposition {
        kanji: '惶',
        radicals: &['王', '白', '⺖'],
    },
    Decomposition {
        kanji: '惷',
        radicals: &['心', '大', '二', '日'],
    },
    Decomposition {
        kanji: '愀',
        radicals: &['火', '禾', '⺖'],
    },
    Decomposition {
        kanji: '惴',
        radicals: &['山', '而', '⺖'],
    },
    Decomposition {
        kanji: '惺',
        radicals: &['生', '日', '⺖'],
    },
    Decomposition {
        kanji: '愃',
        radicals: &['二', '日', '⺖', '宀', '一'],
    },
    Decomposition {
        kanji: '愡',
        radicals: &['ノ', '心', '⺖', '丶', '勿', '勹'],
    },
    Decomposition {
        kanji: '惻',
        radicals: &['貝', '目', 'ハ', '⺉', '⺖'],
    },
    Decomposition {
        kanji: '惱',
        radicals: &['巛', '⺖', '囗'],
    },
    Decomposition {
        kanji: '愍',
        radicals: &['口', '氏', '心', '攵', '尸', '𠂉'],
    },
    Decomposition {
        kanji: '愎',
        radicals: &['日', '⺖', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '慇',
        radicals: &['心', '日', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '愾',
        radicals: &['米', '⺖', '气', '𠂉'],
    },
    Decomposition {
        kanji: '愨',
        radicals: &['士', '心', '冖', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '愧',
        radicals: &['鬼', '田', '⺖', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '慊',
        radicals: &['｜', 'ヨ', '丷', '⺖'],
    },
    Decomposition {
        kanji: '愿',
        radicals: &['小', '心', '白', '厂'],
    },
    Decomposition {
        kanji: '愼',
        radicals: &['ハ', '⺖', '目', '匕'],
    },
    Decomposition {
        kanji: '愬',
        radicals: &['月', '心', '丷', '屮'],
    },
    Decomposition {
        kanji: '愴',
        radicals: &['戸', '口', '人', '⺖', '一', '尸'],
    },
    Decomposition {
        kanji: '愽',
        radicals: &['十', '寸', '田', '⺖', '丶'],
    },
    Decomposition {
        kanji: '慂',
        radicals: &['⺡', '心', '用', 'マ'],
    },
    Decomposition {
        kanji: '慄',
        radicals: &['西', '⺖', '木'],
    },
    Decomposition {
        kanji: '慳',
        radicals: &['臣', '土', '⺖', '又'],
    },
    Decomposition {
        kanji: '慷',
        radicals: &['ヨ', '水', '⺖', '广', '隶'],
    },
    Decomposition {
        kanji: '慘',
        radicals: &['⺖', '𠆢', '厶', '彡'],
    },
    Decomposition {
        kanji: '慙',
        radicals: &['斤', '車', '心'],
    },
    Decomposition {
        kanji: '慚',
        radicals: &['斤', '車', '⺖'],
    },
    Decomposition {
        kanji: '慫',
        radicals: &['心', '丷', '疋', '彳'],
    },
    Decomposition {
        kanji: '慴',
        radicals: &['羽', '白', '⺖', '冫'],
    },
    Decomposition {
        kanji: '慯',
        radicals: &['ノ', '一', '日', '⺖', '勹', '勿', '𠂉'],
    },
    Decomposition {
        kanji: '慥',
        radicals: &['口', '⻌', '土', '⺖'],
    },
    Decomposition {
        kanji: '慱',
        radicals: &['十', '寸', '虫', '田', '⺖', '亠', '厶'],
    },
    Decomposition {
        kanji: '慟',
        radicals: &['｜', 'ノ', '日', '⺖', '力'],
    },
    Decomposition {
        kanji: '慝',
        radicals: &['ノ', '一', '口', '心', '厂', '⺾', '匚'],
    },
    Decomposition {
        kanji: '慓',
        radicals: &['示', '二', '小', '西', '⺖'],
    },
    Decomposition {
        kanji: '慵',
        radicals: &['ヨ', '⺖', '用', '冂', '广', '聿'],
    },
    Decomposition {
        kanji: '憙',
        radicals: &['一', '口', '士', '心', '豆', 'ハ'],
    },
    Decomposition {
        kanji: '憖',
        radicals: &['｜', '犬', '心', '人', 'ハ', '木'],
    },
    Decomposition {
        kanji: '憇',
        radicals: &['甘', '口', '心', '舌'],
    },
    Decomposition {
        kanji: '憬',
        radicals: &['口', '小', '日', '⺖', '亠'],
    },
    Decomposition {
        kanji: '憔',
        radicals: &['⺖', '⺣', '隹'],
    },
    Decomposition {
        kanji: '憚',
        radicals: &['｜', '口', '十', '田', '⺖'],
    },
    Decomposition {
        kanji: '憊',
        radicals: &['⺅', '心', '用', '厂', '⺾'],
    },
    Decomposition {
        kanji: '憑',
        radicals: &['心', '馬', '冫', '⺣'],
    },
    Decomposition {
        kanji: '憫',
        radicals: &['文', '⺖', '門'],
    },
    Decomposition {
        kanji: '憮',
        radicals: &['⺖', '⺣', '無', '一', '｜', 'ノ', '𠂉'],
    },
    Decomposition {
        kanji: '懌',
        radicals: &['十', '辛', '土', '⺲', '⺖', '立', '亠'],
    },
    Decomposition {
        kanji: '懊',
        radicals: &['大', '米', '⺖', '冂', '釆'],
    },
    Decomposition {
        kanji: '應',
        radicals: &['⺅', '心', '广', '隹'],
    },
    Decomposition {
        kanji: '懷',
        radicals: &['衣', '⺲', '⺖', '亠'],
    },
    Decomposition {
        kanji: '懈',
        radicals: &['角', '牛', '刀', '⺖'],
    },
    Decomposition {
        kanji: '懃',
        radicals: &['心', '力', '⺾', '土', '口', '二'],
    },
    Decomposition {
        kanji: '懆',
        radicals: &['口', '⺖', '木', '品'],
    },
    Decomposition {
        kanji: '憺',
        radicals: &['言', '⺖', '儿', '厂', '勹'],
    },
    Decomposition {
        kanji: '懋',
        radicals: &['心', '矛', '木', 'マ'],
    },
    Decomposition {
        kanji: '罹',
        radicals: &['⺲', '⺖', '隹'],
    },
    Decomposition {
        kanji: '懍',
        radicals: &['禾', '口', '⺖', '亠', '囗'],
    },
    Decomposition {
        kanji: '懦',
        radicals: &['雨', '而', '⺖'],
    },
    Decomposition {
        kanji: '懣',
        radicals: &['｜', '一', '⺡', '心', '入', '冂', '凵'],
    },
    Decomposition {
        kanji: '懶',
        radicals: &['｜', '貝', '目', '口', 'ハ', '頁', '⺖', '木'],
    },
    Decomposition {
        kanji: '懺',
        radicals: &['人', '⺖', '戈', '韭'],
    },
    Decomposition {
        kanji: '懴',
        radicals: &['土', '⺖', '戈', '韭'],
    },
    Decomposition {
        kanji: '懿',
        radicals: &['欠', '口', '士', '心', '豆', '丷', '冖', '冫'],
    },
    Decomposition {
        kanji: '懽',
        radicals: &['口', '十', '⺖', '⺾', '隹'],
    },
    Decomposition {
        kanji: '懼',
        radicals: &['⺖', '目', '隹'],
    },
    Decomposition {
        kanji: '懾',
        radicals: &['耳', '⺖'],
    },
    Decomposition {
        kanji: '戀',
        radicals: &['言', '糸', '幺', '小', '心'],
    },
    Decomposition {
        kanji: '戈',
        radicals: &['戈'],
    },
    Decomposition {
        kanji: '戉',
        radicals: &['戈'],
    },
    Decomposition {
        kanji: '戍',
        radicals: &['ノ', '丶', '戈', '厂'],
    },
    Decomposition {
        kanji: '戌',
        radicals: &['ノ', '戈', '丶', '厂'],
    },
    Decomposition {
        kanji: '戔',
        radicals: &['戈'],
    },
    Decomposition {
        kanji: '戛',
        radicals: &['一', '自', '戈', '白', '目'],
    },
    Decomposition {
        kanji: '戞',
        radicals: &['一', '自', '冖', '戈'],
    },
    Decomposition {
        kanji: '戡',
        radicals: &['甘', '儿', '匚', '戈'],
    },
    Decomposition {
        kanji: '截',
        radicals: &['土', '戈', '隹'],
    },
    Decomposition {
        kanji: '戮',
        radicals: &['羽', '𠆢', '冫', '彡', '戈'],
    },
    Decomposition {
        kanji: '戰',
        radicals: &['｜', '口', '十', '田', '戈'],
    },
    Decomposition {
        kanji: '戲',
        radicals: &['口', '豆', '丷', '卜', '匕', '厂', '戈', '虍'],
    },
    Decomposition {
        kanji: '戳',
        radicals: &['ヨ', '戈', '隹'],
    },
    Decomposition {
        kanji: '扁',
        radicals: &['｜', '一', '戸', '冂', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '扎',
        radicals: &['乙', '扌'],
    },
    Decomposition {
        kanji: '扞',
        radicals: &['干', '扌'],
    },
    Decomposition {
        kanji: '扣',
        radicals: &['口', '扌'],
    },
    Decomposition {
        kanji: '扛',
        radicals: &['工', '扌'],
    },
    Decomposition {
        kanji: '扠',
        radicals: &['又', '丶', '扌'],
    },
    Decomposition {
        kanji: '扨',
        radicals: &['刀', '扌', '丶'],
    },
    Decomposition {
        kanji: '扼',
        radicals: &['卩', '厂', '扌'],
    },
    Decomposition {
        kanji: '抂',
        radicals: &['王', '扌'],
    },
    Decomposition {
        kanji: '抉',
        radicals: &['人', '大', '二', '扌', 'ユ'],
    },
    Decomposition {
        kanji: '找',
        radicals: &['戈', '扌'],
    },
    Decomposition {
        kanji: '抒',
        radicals: &['矛', '亅', '扌', 'マ'],
    },
    Decomposition {
        kanji: '抓',
        radicals: &['爪', '扌'],
    },
    Decomposition {
        kanji: '抖',
        radicals: &['斗', '扌'],
    },
    Decomposition {
        kanji: '拔',
        radicals: &['ノ', '一', '丶', '扌'],
    },
    Decomposition {
        kanji: '抃',
        radicals: &['卜', '亠', '扌'],
    },
    Decomposition {
        kanji: '抔',
        radicals: &['｜', 'ノ', '一', '丶', '扌'],
    },
    Decomposition {
        kanji: '拗',
        radicals: &['力', '幺', '扌'],
    },
    Decomposition {
        kanji: '拑',
        radicals: &['甘', '扌'],
    },
    Decomposition {
        kanji: '抻',
        radicals: &['｜', '日', '扌', '田'],
    },
    Decomposition {
        kanji: '拏',
        radicals: &['手', '女', '又'],
    },
    Decomposition {
        kanji: '拿',
        radicals: &['口', '手', '𠆢', '一'],
    },
    Decomposition {
        kanji: '拆',
        radicals: &['斤', '丶', '扌'],
    },
    Decomposition {
        kanji: '擔',
        radicals: &['言', '儿', '厂', '扌', '勹'],
    },
    Decomposition {
        kanji: '拈',
        radicals: &['口', '卜', '扌'],
    },
    Decomposition {
        kanji: '拜',
        radicals: &['ノ', '干', '扌'],
    },
    Decomposition {
        kanji: '拌',
        radicals: &['｜', '干', '二', 'ハ', '扌', '十'],
    },
    Decomposition {
        kanji: '拊',
        radicals: &['⺅', '寸', '扌'],
    },
    Decomposition {
        kanji: '拂',
        radicals: &['｜', 'ノ', '弓', '扌'],
    },
    Decomposition {
        kanji: '拇',
        radicals: &['母', '扌', '毋'],
    },
    Decomposition {
        kanji: '抛',
        radicals: &['ノ', '九', '扌', '力'],
    },
    Decomposition {
        kanji: '拉',
        radicals: &['立', '扌'],
    },
    Decomposition {
        kanji: '挌',
        radicals: &['口', '夂', '扌'],
    },
    Decomposition {
        kanji: '拮',
        radicals: &['口', '士', '扌'],
    },
    Decomposition {
        kanji: '拱',
        radicals: &['｜', '一', '二', 'ハ', '扌'],
    },
    Decomposition {
        kanji: '挧',
        radicals: &['羽', '冫', '扌'],
    },
    Decomposition {
        kanji: '挂',
        radicals: &['土', '扌'],
    },
    Decomposition {
        kanji: '挈',
        radicals: &['手', '土', '刀'],
    },
    Decomposition {
        kanji: '拯',
        radicals: &['水', '扌'],
    },
    Decomposition {
        kanji: '拵',
        radicals: &['ノ', '一', '子', '扌'],
    },
    Decomposition {
        kanji: '捐',
        radicals: &['月', '口', '扌'],
    },
    Decomposition {
        kanji: '挾',
        radicals: &['人', '大', '扌'],
    },
    Decomposition {
        kanji: '捍',
        radicals: &['干', '日', '扌'],
    },
    Decomposition {
        kanji: '搜',
        radicals: &['｜', '臼', '支', '又', '扌', '十'],
    },
    Decomposition {
        kanji: '捏',
        radicals: &['土', '日', '扌'],
    },
    Decomposition {
        kanji: '掖',
        radicals: &['⺅', '丶', '亠', '夂', '扌', '夕'],
    },
    Decomposition {
        kanji: '掎',
        radicals: &['口', '大', '亅', '扌', '一'],
    },
    Decomposition {
        kanji: '掀',
        radicals: &['斤', '欠', '扌'],
    },
    Decomposition {
        kanji: '掫',
        radicals: &['耳', '又', '扌'],
    },
    Decomposition {
        kanji: '捶',
        radicals: &['｜', 'ノ', '二', '扌'],
    },
    Decomposition {
        kanji: '掣',
        radicals: &['⺉', '缶', '牛', '巾', '手', '凵'],
    },
    Decomposition {
        kanji: '掏',
        radicals: &['缶', '凵', '勹', '扌'],
    },
    Decomposition {
        kanji: '掉',
        radicals: &['十', '日', '卜', '扌', '曰'],
    },
    Decomposition {
        kanji: '掟',
        radicals: &['疋', '宀', '扌'],
    },
    Decomposition {
        kanji: '掵',
        radicals: &['口', '𠆢', '卩', '扌', '一'],
    },
    Decomposition {
        kanji: '捫',
        radicals: &['門', '扌'],
    },
    Decomposition {
        kanji: '捩',
        radicals: &['戸', '大', '扌', '一', '尸'],
    },
    Decomposition {
        kanji: '掾',
        radicals: &['ヨ', '扌', '豕'],
    },
    Decomposition {
        kanji: '揩',
        radicals: &['白', '比', '扌'],
    },
    Decomposition {
        kanji: '揀',
        radicals: &['｜', '日', 'ハ', '木', '扌'],
    },
    Decomposition {
        kanji: '揆',
        radicals: &['人', '大', '二', '扌', '癶'],
    },
    Decomposition {
        kanji: '揣',
        radicals: &['山', '而', '扌'],
    },
    Decomposition {
        kanji: '揉',
        radicals: &['矛', '木', '扌', 'マ'],
    },
    Decomposition {
        kanji: '插',
        radicals: &['ノ', '臼', '十', '扌'],
    },
    Decomposition {
        kanji: '揶',
        radicals: &['耳', '⻏', '扌'],
    },
    Decomposition {
        kanji: '揄',
        radicals: &['⺉', '月', '𠆢', '扌', '一'],
    },
    Decomposition {
        kanji: '搖',
        radicals: &['缶', '夕', '凵', '扌'],
    },
    Decomposition {
        kanji: '搴',
        radicals: &['｜', '一', '手', '二', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '搆',
        radicals: &['｜', '一', '黄', '冂', '扌', '十'],
    },
    Decomposition {
        kanji: '搓',
        radicals: &['王', '工', '丷', '羊', '扌'],
    },
    Decomposition {
        kanji: '搦',
        radicals: &['弓', '冫', '扌'],
    },
    Decomposition {
        kanji: '搶',
        radicals: &['戸', '口', '𠆢', '扌', '一', '尸'],
    },
    Decomposition {
        kanji: '攝',
        radicals: &['耳', '扌'],
    },
    Decomposition {
        kanji: '搗',
        radicals: &['山', '鳥', '扌'],
    },
    Decomposition {
        kanji: '搨',
        radicals: &['羽', '日', '冫', '扌'],
    },
    Decomposition {
        kanji: '搏',
        radicals: &['十', '寸', '田', '丶', '扌'],
    },
    Decomposition {
        kanji: '摧',
        radicals: &['山', '扌', '隹'],
    },
    Decomposition {
        kanji: '摯',
        radicals: &['ノ', '九', '手', '十', '辛', '立', '丶'],
    },
    Decomposition {
        kanji: '摶',
        radicals: &['十', '寸', '虫', '田', '厶', '扌'],
    },
    Decomposition {
        kanji: '摎',
        radicals: &['羽', '𠆢', '冫', '彡', '扌'],
    },
    Decomposition {
        kanji: '攪',
        radicals: &['臼', '見', '扌'],
    },
    Decomposition {
        kanji: '撕',
        radicals: &['甘', '斤', 'ハ', '扌'],
    },
    Decomposition {
        kanji: '撓',
        radicals: &['土', '儿', '扌'],
    },
    Decomposition {
        kanji: '撥',
        radicals: &['二', '儿', '扌', '癶'],
    },
    Decomposition {
        kanji: '撩',
        radicals: &['小', '人', '大', '日', '丷', '亠', '扌'],
    },
    Decomposition {
        kanji: '撈',
        radicals: &['火', '力', '冖', '扌'],
    },
    Decomposition {
        kanji: '撼',
        radicals: &['ノ', '口', '心', '戈', '扌'],
    },
    Decomposition {
        kanji: '據',
        radicals: &['卜', '匕', '厂', '扌', '虍', '豕'],
    },
    Decomposition {
        kanji: '擒',
        radicals: &['𠆢', '亠', '凵', '扌', '⽱'],
    },
    Decomposition {
        kanji: '擅',
        radicals: &['口', '日', '亠', '囗', '扌', '一'],
    },
    Decomposition {
        kanji: '擇',
        radicals: &['十', '辛', '土', '⺲', '立', '亠', '扌'],
    },
    Decomposition {
        kanji: '撻',
        radicals: &['王', '⻌', '十', '辛', '土', '羊', '立', '亠', '扌'],
    },
    Decomposition {
        kanji: '擘',
        radicals: &['口', '手', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '擂',
        radicals: &['雨', '田', '扌'],
    },
    Decomposition {
        kanji: '擱',
        radicals: &['口', '門', '夂', '扌'],
    },
    Decomposition {
        kanji: '擧',
        radicals: &['臼', '手', 'ハ'],
    },
    Decomposition {
        kanji: '舉',
        radicals: &['｜', '一', '臼', '二', 'ハ'],
    },
    Decomposition {
        kanji: '擠',
        radicals: &['亠', '扌', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '擡',
        radicals: &['口', '士', '至', '土', '冖', '厶', '扌'],
    },
    Decomposition {
        kanji: '抬',
        radicals: &['口', '厶', '扌'],
    },
    Decomposition {
        kanji: '擣',
        radicals: &['口', '工', '士', '寸', '扌'],
    },
    Decomposition {
        kanji: '擯',
        radicals: &['ノ', '貝', '目', 'ハ', '小', '宀', '扌'],
    },
    Decomposition {
        kanji: '攬',
        radicals: &['見', '臣', '扌', '𠂉'],
    },
    Decomposition {
        kanji: '擶',
        radicals: &['⺉', '月', '竹', '丷', '扌'],
    },
    Decomposition {
        kanji: '擴',
        radicals: &['黄', '田', 'ハ', '广', '扌'],
    },
    Decomposition {
        kanji: '擲',
        radicals: &['大', '酉', '丷', '⻏', '扌'],
    },
    Decomposition {
        kanji: '擺',
        radicals: &['月', '⺲', '匕', '厶', '扌'],
    },
    Decomposition {
        kanji: '攀',
        radicals: &['一', '手', '大', 'ハ', '木', '爻'],
    },
    Decomposition {
        kanji: '擽',
        radicals: &['白', '木', '冫', '扌', '幺'],
    },
    Decomposition {
        kanji: '攘',
        radicals: &['衣', '二', 'ハ', '亠', '扌', '口'],
    },
    Decomposition {
        kanji: '攜',
        radicals: &['口', '山', '儿', '冂', '扌', '隹'],
    },
    Decomposition {
        kanji: '攅',
        radicals: &['貝', '目', 'ハ', '人', '大', '土', '亠', '扌', '二'],
    },
    Decomposition {
        kanji: '攤',
        radicals: &['二', '扌', '⺾', '隹', '井'],
    },
    Decomposition {
        kanji: '攣',
        radicals: &['言', '糸', '幺', '小', '手'],
    },
    Decomposition {
        kanji: '攫',
        radicals: &['又', '目', '扌', '隹'],
    },
    Decomposition {
        kanji: '攴',
        radicals: &['攵'],
    },
    Decomposition {
        kanji: '攵',
        radicals: &['攵', '𠂉'],
    },
    Decomposition {
        kanji: '攷',
        radicals: &['攵', '𠂉'],
    },
    Decomposition {
        kanji: '收',
        radicals: &['｜', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '攸',
        radicals: &['｜', 'ノ', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '畋',
        radicals: &['田', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '效',
        radicals: &['父', '亠', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '敖',
        radicals: &['土', '方', '攵', '亠', '二', '𠂉'],
    },
    Decomposition {
        kanji: '敕',
        radicals: &['｜', '口', 'ハ', '木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '敍',
        radicals: &['干', '小', '𠆢', '攵', '一'],
    },
    Decomposition {
        kanji: '敘',
        radicals: &['干', '小', '𠆢', '攵', '一', '𠂉'],
    },
    Decomposition {
        kanji: '敞',
        radicals: &['口', '⺌', '冂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '敝',
        radicals: &['｜', '巾', '⺌', '丷', '冂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '敲',
        radicals: &['口', '高', '亠', '冂', '攵'],
    },
    Decomposition {
        kanji: '數',
        radicals: &['｜', '一', '口', '女', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '斂',
        radicals: &['口', '人', '𠆢', '攵', '一', '𠂉'],
    },
    Decomposition {
        kanji: '斃',
        radicals: &['巾', '小', '⺌', '丷', '夕', '冂', '匕', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '變',
        radicals: &['言', '糸', '幺', '小', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '斛',
        radicals: &['角', '斗'],
    },
    Decomposition {
        kanji: '斟',
        radicals: &['甘', '斗', '儿', '匚'],
    },
    Decomposition {
        kanji: '斫',
        radicals: &['ノ', '斤', '口', '石'],
    },
    Decomposition {
        kanji: '斷',
        radicals: &['｜', '斤', '幺'],
    },
    Decomposition {
        kanji: '旃',
        radicals: &['方', '冂', '𠂉'],
    },
    Decomposition {
        kanji: '旆',
        radicals: &['干', '缶', '巾', '方', '凵', '𠂉'],
    },
    Decomposition {
        kanji: '旁',
        radicals: &['丷', '方', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '旄',
        radicals: &['方', '毛', '𠂉'],
    },
    Decomposition {
        kanji: '旌',
        radicals: &['生', '方', '𠂉'],
    },
    Decomposition {
        kanji: '旒',
        radicals: &['川', '方', '亠', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '旛',
        radicals: &['田', '釆', '米', '方', '𠂉'],
    },
    Decomposition {
        kanji: '旙',
        radicals: &['田', '釆', '米', '方'],
    },
    Decomposition {
        kanji: '无',
        radicals: &['无'],
    },
    Decomposition {
        kanji: '旡',
        radicals: &['无'],
    },
    Decomposition {
        kanji: '旱',
        radicals: &['干', '日'],
    },
    Decomposition {
        kanji: '杲',
        radicals: &['日', '木'],
    },
    Decomposition {
        kanji: '昊',
        radicals: &['一', '大', '日', '二'],
    },
    Decomposition {
        kanji: '昃',
        radicals: &['人', '日', '厂'],
    },
    Decomposition {
        kanji: '旻',
        radicals: &['日', '文'],
    },
    Decomposition {
        kanji: '杳',
        radicals: &['日', '木'],
    },
    Decomposition {
        kanji: '昵',
        radicals: &['日', '匕', '尸'],
    },
    Decomposition {
        kanji: '昶',
        radicals: &['水', '日', '丶'],
    },
    Decomposition {
        kanji: '昴',
        radicals: &['日', '卩'],
    },
    Decomposition {
        kanji: '昜',
        radicals: &['ノ', '一', '日', '勿', '勹'],
    },
    Decomposition {
        kanji: '晏',
        radicals: &['女', '日', '宀'],
    },
    Decomposition {
        kanji: '晄',
        radicals: &['⺌', '日', '儿'],
    },
    Decomposition {
        kanji: '晉',
        radicals: &['一', '二', '日', '厶'],
    },
    Decomposition {
        kanji: '晁',
        radicals: &['日', '儿', '冫'],
    },
    Decomposition {
        kanji: '晞',
        radicals: &['ノ', '一', '巾', '日'],
    },
    Decomposition {
        kanji: '晝',
        radicals: &['一', '日', '聿'],
    },
    Decomposition {
        kanji: '晤',
        radicals: &['口', '日', '五'],
    },
    Decomposition {
        kanji: '晧',
        radicals: &['ノ', '口', '土', '日'],
    },
    Decomposition {
        kanji: '晨',
        radicals: &['辰', '日', '衣'],
    },
    Decomposition {
        kanji: '晟',
        radicals: &['ノ', '日', '戈'],
    },
    Decomposition {
        kanji: '晢',
        radicals: &['斤', '日', '扌'],
    },
    Decomposition {
        kanji: '晰',
        radicals: &['斤', '日', '木'],
    },
    Decomposition {
        kanji: '暃',
        radicals: &['日', '非'],
    },
    Decomposition {
        kanji: '暈',
        radicals: &['車', '日', '冖'],
    },
    Decomposition {
        kanji: '暎',
        radicals: &['人', '大', '日', '冂', '⺾', '冖'],
    },
    Decomposition {
        kanji: '暉',
        radicals: &['車', '日', '冖'],
    },
    Decomposition {
        kanji: '暄',
        radicals: &['一', '二', '日', '宀'],
    },
    Decomposition {
        kanji: '暘',
        radicals: &['ノ', '一', '日', '勹', '勿'],
    },
    Decomposition {
        kanji: '暝',
        radicals: &['日', 'ハ', '亠', '冖'],
    },
    Decomposition {
        kanji: '曁',
        radicals: &['一', '艮', '日', '无', '匕', '白'],
    },
    Decomposition {
        kanji: '暹',
        radicals: &['⻌', '日', '隹'],
    },
    Decomposition {
        kanji: '曉',
        radicals: &['土', '日', '儿'],
    },
    Decomposition {
        kanji: '暾',
        radicals: &['口', '子', '日', '亠', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '暼',
        radicals: &['巾', '小', '⺌', '日', '丷', '冂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '曄',
        radicals: &['｜', '一', '二', '日', '⺾'],
    },
    Decomposition {
        kanji: '暸',
        radicals: &['小', '大', '日', '丷', '亠'],
    },
    Decomposition {
        kanji: '曖',
        radicals: &['心', '爪', '日', '冖', '夂'],
    },
    Decomposition {
        kanji: '曚',
        radicals: &['日', '冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '曠',
        radicals: &['黄', '田', '日', 'ハ', '广'],
    },
    Decomposition {
        kanji: '昿',
        radicals: &['日', '厶', '广'],
    },
    Decomposition {
        kanji: '曦',
        radicals: &['王', '日', '丷', '羊', '亅', '戈'],
    },
    Decomposition {
        kanji: '曩',
        radicals: &['｜', '衣', '一', '日', 'ハ', '亠', '井'],
    },
    Decomposition {
        kanji: '曰',
        radicals: &['曰'],
    },
    Decomposition {
        kanji: '曵',
        radicals: &['弋', '曰'],
    },
    Decomposition {
        kanji: '曷',
        radicals: &['日', '勹', '匕', '曰'],
    },
    Decomposition {
        kanji: '朏',
        radicals: &['｜', '月', '山'],
    },
    Decomposition {
        kanji: '朖',
        radicals: &['月', '艮'],
    },
    Decomposition {
        kanji: '朞',
        radicals: &['一', '甘', '月', 'ハ'],
    },
    Decomposition {
        kanji: '朦',
        radicals: &['月', '冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '朧',
        radicals: &['月', '立'],
    },
    Decomposition {
        kanji: '霸',
        radicals: &['雨', '革', '月'],
    },
    Decomposition {
        kanji: '朮',
        radicals: &['｜', '一', '木', '丶', '儿'],
    },
    Decomposition {
        kanji: '朿',
        radicals: &['｜', '一', 'ハ', '木', '冂'],
    },
    Decomposition {
        kanji: '朶',
        radicals: &['ノ', '木', '乃'],
    },
    Decomposition {
        kanji: '杁',
        radicals: &['入', '木'],
    },
    Decomposition {
        kanji: '朸',
        radicals: &['木', '力'],
    },
    Decomposition {
        kanji: '朷',
        radicals: &['刀', '木'],
    },
    Decomposition {
        kanji: '杆',
        radicals: &['干', '木'],
    },
    Decomposition {
        kanji: '杞',
        radicals: &['木', '已'],
    },
    Decomposition {
        kanji: '杠',
        radicals: &['工', '木'],
    },
    Decomposition {
        kanji: '杙',
        radicals: &['木', '弋'],
    },
    Decomposition {
        kanji: '杣',
        radicals: &['山', '木'],
    },
    Decomposition {
        kanji: '杤',
        radicals: &['ノ', '一', '木'],
    },
    Decomposition {
        kanji: '枉',
        radicals: &['王', '木'],
    },
    Decomposition {
        kanji: '杰',
        radicals: &['木', '⺣'],
    },
    Decomposition {
        kanji: '枩',
        radicals: &['ハ', '木', '厶'],
    },
    Decomposition {
        kanji: '杼',
        radicals: &['矛', '木', '亅'],
    },
    Decomposition {
        kanji: '杪',
        radicals: &['ノ', '小', '木'],
    },
    Decomposition {
        kanji: '枌',
        radicals: &['刀', 'ハ', '木'],
    },
    Decomposition {
        kanji: '枋',
        radicals: &['方', '木'],
    },
    Decomposition {
        kanji: '枦',
        radicals: &['戸', '木', '一', '尸'],
    },
    Decomposition {
        kanji: '枡',
        radicals: &['ノ', '木', '廾'],
    },
    Decomposition {
        kanji: '枅',
        radicals: &['木', '廾', '二', '一', 'ノ'],
    },
    Decomposition {
        kanji: '枷',
        radicals: &['口', '木', '力'],
    },
    Decomposition {
        kanji: '柯',
        radicals: &['口', '木', '亅', '一'],
    },
    Decomposition {
        kanji: '枴',
        radicals: &['口', '刀', '木'],
    },
    Decomposition {
        kanji: '柬',
        radicals: &['巾', '丷', '木', '亠'],
    },
    Decomposition {
        kanji: '枳',
        radicals: &['口', 'ハ', '木'],
    },
    Decomposition {
        kanji: '柩',
        radicals: &['入', '木', '匚', '久'],
    },
    Decomposition {
        kanji: '枸',
        radicals: &['口', '木', '勹'],
    },
    Decomposition {
        kanji: '柤',
        radicals: &['木', '目'],
    },
    Decomposition {
        kanji: '柞',
        radicals: &['｜', 'ノ', '木'],
    },
    Decomposition {
        kanji: '柝',
        radicals: &['斤', '木', '丶'],
    },
    Decomposition {
        kanji: '柢',
        radicals: &['氏', '木'],
    },
    Decomposition {
        kanji: '柮',
        radicals: &['｜', '山', '木'],
    },
    Decomposition {
        kanji: '枹',
        radicals: &['木', '勹', '已'],
    },
    Decomposition {
        kanji: '柎',
        radicals: &['⺅', '寸', '木'],
    },
    Decomposition {
        kanji: '柆',
        radicals: &['木', '立'],
    },
    Decomposition {
        kanji: '柧',
        radicals: &['瓜', '木'],
    },
    Decomposition {
        kanji: '檜',
        radicals: &['日', '⺲', '木', '𠆢', '一'],
    },
    Decomposition {
        kanji: '栞',
        radicals: &['干', '木'],
    },
    Decomposition {
        kanji: '框',
        radicals: &['王', '木', '匚'],
    },
    Decomposition {
        kanji: '栩',
        radicals: &['羽', '木', '冫'],
    },
    Decomposition {
        kanji: '桀',
        radicals: &['舛', '木', '夕'],
    },
    Decomposition {
        kanji: '桍',
        radicals: &['大', '二', '木', '勹'],
    },
    Decomposition {
        kanji: '栲',
        radicals: &['木', '⺹', '勹'],
    },
    Decomposition {
        kanji: '桎',
        radicals: &['至', '土', '木', '厶', '一'],
    },
    Decomposition {
        kanji: '梳',
        radicals: &['川', '木', '亠', '厶'],
    },
    Decomposition {
        kanji: '栫',
        radicals: &['ノ', '一', '子', '木'],
    },
    Decomposition {
        kanji: '桙',
        radicals: &['牛', '木', '厶'],
    },
    Decomposition {
        kanji: '档',
        radicals: &['ヨ', '⺌', '木'],
    },
    Decomposition {
        kanji: '桷',
        radicals: &['角', '木'],
    },
    Decomposition {
        kanji: '桿',
        radicals: &['干', '日', '木'],
    },
    Decomposition {
        kanji: '梟',
        radicals: &['鳥', '木'],
    },
    Decomposition {
        kanji: '梏',
        radicals: &['ノ', '口', '土', '木'],
    },
    Decomposition {
        kanji: '梭',
        radicals: &['木', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '梔',
        radicals: &['木', '厂', '巴'],
    },
    Decomposition {
        kanji: '條',
        radicals: &['⺅', '木', '攵', '𠂉', '｜'],
    },
    Decomposition {
        kanji: '梛',
        radicals: &['刀', '⻏', '木', '二'],
    },
    Decomposition {
        kanji: '梃',
        radicals: &['王', '木', '廴'],
    },
    Decomposition {
        kanji: '檮',
        radicals: &['口', '工', '士', '寸', '木'],
    },
    Decomposition {
        kanji: '梹',
        radicals: &['斤', 'ハ', '木', '一'],
    },
    Decomposition {
        kanji: '桴',
        radicals: &['子', '爪', '木'],
    },
    Decomposition {
        kanji: '梵',
        radicals: &['木', '丶', '几'],
    },
    Decomposition {
        kanji: '梠',
        radicals: &['口', '木', 'ノ'],
    },
    Decomposition {
        kanji: '梺',
        radicals: &['一', '卜', '木'],
    },
    Decomposition {
        kanji: '椏',
        radicals: &['一', '二', '木'],
    },
    Decomposition {
        kanji: '梍',
        radicals: &['乙', '白', '木', '匕'],
    },
    Decomposition {
        kanji: '桾',
        radicals: &['ヨ', '口', '木', '尸'],
    },
    Decomposition {
        kanji: '椁',
        radicals: &['口', '子', '木', '亠'],
    },
    Decomposition {
        kanji: '棊',
        radicals: &['一', '甘', 'ハ', '木'],
    },
    Decomposition {
        kanji: '椈',
        radicals: &['米', '木', '勹'],
    },
    Decomposition {
        kanji: '棘',
        radicals: &['｜', '巾', 'ハ', '木', '亠', '冂'],
    },
    Decomposition {
        kanji: '椢',
        radicals: &['王', '木', '囗'],
    },
    Decomposition {
        kanji: '椦',
        radicals: &['大', '二', '丷', '木', '力'],
    },
    Decomposition {
        kanji: '棡',
        radicals: &['丷', '木', '冂', '凵', '山', '岡'],
    },
    Decomposition {
        kanji: '椌',
        radicals: &['穴', '工', '木', '儿'],
    },
    Decomposition {
        kanji: '棍',
        radicals: &['日', '比', '木'],
    },
    Decomposition {
        kanji: '棔',
        radicals: &['氏', '日', '木'],
    },
    Decomposition {
        kanji: '棧',
        radicals: &['木', '戈'],
    },
    Decomposition {
        kanji: '棕',
        radicals: &['示', '二', '小', '木', '宀'],
    },
    Decomposition {
        kanji: '椶',
        radicals: &['木', '儿', '凵', '夂'],
    },
    Decomposition {
        kanji: '椒',
        radicals: &['小', '卜', '又', '木'],
    },
    Decomposition {
        kanji: '椄',
        radicals: &['女', '木', '立'],
    },
    Decomposition {
        kanji: '棗',
        radicals: &['｜', '一', '巾', 'ハ', '木', '亠', '冂'],
    },
    Decomposition {
        kanji: '棣',
        radicals: &['ヨ', '水', '木', '隶'],
    },
    Decomposition {
        kanji: '椥',
        radicals: &['口', '木', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '棹',
        radicals: &['十', '日', '卜', '木'],
    },
    Decomposition {
        kanji: '棠',
        radicals: &['口', '⺌', '木', '冖'],
    },
    Decomposition {
        kanji: '棯',
        radicals: &['心', '木', '𠆢', '一'],
    },
    Decomposition {
        kanji: '椨',
        radicals: &['⺅', '寸', '木', '广'],
    },
    Decomposition {
        kanji: '椪',
        radicals: &['｜', '一', '丷', '木'],
    },
    Decomposition {
        kanji: '椚',
        radicals: &['木', '門'],
    },
    Decomposition {
        kanji: '椣',
        radicals: &['｜', '一', '日', 'ハ', '木'],
    },
    Decomposition {
        kanji: '椡',
        radicals: &['⺉', '至', '土', '木', '厶'],
    },
    Decomposition {
        kanji: '棆',
        radicals: &['｜', '一', '木', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '楹',
        radicals: &['ノ', '皿', '又', '木', '乃'],
    },
    Decomposition {
        kanji: '楷',
        radicals: &['白', '比', '木'],
    },
    Decomposition {
        kanji: '楜',
        radicals: &['月', '口', '十', '木'],
    },
    Decomposition {
        kanji: '楸',
        radicals: &['火', '禾', '木'],
    },
    Decomposition {
        kanji: '楫',
        radicals: &['口', '耳', '木'],
    },
    Decomposition {
        kanji: '楔',
        radicals: &['大', '土', '刀', '木', '亠', '二'],
    },
    Decomposition {
        kanji: '楾',
        radicals: &['水', '白', '木'],
    },
    Decomposition {
        kanji: '楮',
        radicals: &['日', '木', '⺹'],
    },
    Decomposition {
        kanji: '椹',
        radicals: &['甘', '木', '儿', '匚'],
    },
    Decomposition {
        kanji: '楴',
        radicals: &['巾', '丷', '木', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '椽',
        radicals: &['ヨ', '木', '豕'],
    },
    Decomposition {
        kanji: '楙',
        radicals: &['矛', '木'],
    },
    Decomposition {
        kanji: '椰',
        radicals: &['耳', '⻏', '木'],
    },
    Decomposition {
        kanji: '楡',
        radicals: &['⺉', '月', '木', '𠆢', '一'],
    },
    Decomposition {
        kanji: '楞',
        radicals: &['⺲', '方', '木'],
    },
    Decomposition {
        kanji: '楝',
        radicals: &['巾', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '榁',
        radicals: &['至', '土', '木', '厶', '宀'],
    },
    Decomposition {
        kanji: '楪',
        radicals: &['木', '世'],
    },
    Decomposition {
        kanji: '榲',
        radicals: &['皿', '日', '木'],
    },
    Decomposition {
        kanji: '榮',
        radicals: &['火', '木', '冖'],
    },
    Decomposition {
        kanji: '槐',
        radicals: &['鬼', '田', '木', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '榿',
        radicals: &['口', '山', '豆', '丷', '木'],
    },
    Decomposition {
        kanji: '槁',
        radicals: &['口', '高', '木', '亠', '冂'],
    },
    Decomposition {
        kanji: '槓',
        radicals: &['貝', '目', 'ハ', '工', '木'],
    },
    Decomposition {
        kanji: '榾',
        radicals: &['月', '口', '木', '冖', '骨'],
    },
    Decomposition {
        kanji: '槎',
        radicals: &['ノ', '王', '工', '丷', '木', '羊'],
    },
    Decomposition {
        kanji: '寨',
        radicals: &['｜', '一', 'ハ', '木', '宀'],
    },
    Decomposition {
        kanji: '槊',
        radicals: &['月', '丷', '木', '屮'],
    },
    Decomposition {
        kanji: '槝',
        radicals: &['山', '鳥', '木'],
    },
    Decomposition {
        kanji: '榻',
        radicals: &['羽', '日', '木', '冫'],
    },
    Decomposition {
        kanji: '槃',
        radicals: &['舟', '木', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '榧',
        radicals: &['非', '木', '匚'],
    },
    Decomposition {
        kanji: '樮',
        radicals: &['火', '西', '木'],
    },
    Decomposition {
        kanji: '榑',
        radicals: &['十', '寸', '田', '木', '丶'],
    },
    Decomposition {
        kanji: '榠',
        radicals: &['日', 'ハ', '木', '亠', '冖'],
    },
    Decomposition {
        kanji: '榜',
        radicals: &['丷', '方', '木', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '榕',
        radicals: &['穴', '口', 'ハ', '木', '𠆢', '宀', '谷'],
    },
    Decomposition {
        kanji: '榴',
        radicals: &['田', '刀', '木', '厶'],
    },
    Decomposition {
        kanji: '槞',
        radicals: &['木', '立', '竜'],
    },
    Decomposition {
        kanji: '槨',
        radicals: &['口', '子', '⻏', '木', '亠'],
    },
    Decomposition {
        kanji: '樂',
        radicals: &['白', '木', '幺'],
    },
    Decomposition {
        kanji: '樛',
        radicals: &['羽', '木', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '槿',
        radicals: &['土', '二', '木', '⺾', '口'],
    },
    Decomposition {
        kanji: '權',
        radicals: &['口', '十', '木', '⺾', '隹'],
    },
    Decomposition {
        kanji: '槹',
        radicals: &['十', '斗', '白', '木'],
    },
    Decomposition {
        kanji: '槲',
        radicals: &['角', '斗', '木'],
    },
    Decomposition {
        kanji: '槧',
        radicals: &['斤', '車', '木'],
    },
    Decomposition {
        kanji: '樅',
        radicals: &['丷', '疋', '木', '彳'],
    },
    Decomposition {
        kanji: '榱',
        radicals: &['衣', '木', '亠'],
    },
    Decomposition {
        kanji: '樞',
        radicals: &['口', '木', '匚', '品'],
    },
    Decomposition {
        kanji: '槭',
        radicals: &['小', '卜', '木', '戈'],
    },
    Decomposition {
        kanji: '樔',
        radicals: &['⺌', '田', '木', '巛'],
    },
    Decomposition {
        kanji: '槫',
        radicals: &['十', '寸', '虫', '田', '木', '厶'],
    },
    Decomposition {
        kanji: '樊',
        radicals: &['木', '大', '爻'],
    },
    Decomposition {
        kanji: '樒',
        radicals: &['ノ', '山', '心', '木', '丶', '宀'],
    },
    Decomposition {
        kanji: '櫁',
        radicals: &['ノ', '心', '虫', '木', '丶', '宀'],
    },
    Decomposition {
        kanji: '樣',
        radicals: &['王', '水', '丷', '木', '羊', '丶'],
    },
    Decomposition {
        kanji: '樓',
        radicals: &['｜', '一', '口', '女', '木'],
    },
    Decomposition {
        kanji: '橄',
        radicals: &['耳', '木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '樌',
        radicals: &['貝', '目', 'ハ', '田', '木'],
    },
    Decomposition {
        kanji: '橲',
        radicals: &['口', '士', '十', '豆', '丷', '木'],
    },
    Decomposition {
        kanji: '樶',
        radicals: &['耳', '日', '又', '木'],
    },
    Decomposition {
        kanji: '橸',
        radicals: &['日', '木'],
    },
    Decomposition {
        kanji: '橇',
        radicals: &['毛', '木'],
    },
    Decomposition {
        kanji: '橢',
        radicals: &['ノ', '一', '月', '工', '木', '⻖'],
    },
    Decomposition {
        kanji: '橙',
        radicals: &['口', '豆', '丷', '木', '癶'],
    },
    Decomposition {
        kanji: '橦',
        radicals: &['木', '里', '立'],
    },
    Decomposition {
        kanji: '橈',
        radicals: &['土', '木', '儿'],
    },
    Decomposition {
        kanji: '樸',
        radicals: &['二', '丷', '木', '羊'],
    },
    Decomposition {
        kanji: '樢',
        radicals: &['鳥', '木', '⺣'],
    },
    Decomposition {
        kanji: '檐',
        radicals: &['言', '木', '儿', '厂'],
    },
    Decomposition {
        kanji: '檍',
        radicals: &['音', '心', '日', '木', '立'],
    },
    Decomposition {
        kanji: '檠',
        radicals: &['口', '木', '勹', '攵', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '檄',
        radicals: &['白', '方', '木', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '檢',
        radicals: &['口', '人', '木', '𠆢', '一'],
    },
    Decomposition {
        kanji: '檣',
        radicals: &['口', '人', '土', '木', '囗'],
    },
    Decomposition {
        kanji: '檗',
        radicals: &['口', '十', '辛', '木', '立', '尸'],
    },
    Decomposition {
        kanji: '蘗',
        radicals: &['口', '十', '辛', '木', '立', '尸', '⺾'],
    },
    Decomposition {
        kanji: '檻',
        radicals: &['皿', '臣', '二', '木', '𠂉'],
    },
    Decomposition {
        kanji: '櫃',
        radicals: &['一', '貝', '目', 'ハ', '木', '匚', '｜', '口'],
    },
    Decomposition {
        kanji: '櫂',
        radicals: &['ヨ', '木', '隹'],
    },
    Decomposition {
        kanji: '檸',
        radicals: &['一', '心', '⺲', '木', '亅', '宀', '皿'],
    },
    Decomposition {
        kanji: '檳',
        radicals: &['ノ', '貝', '目', 'ハ', '小', '木', '宀'],
    },
    Decomposition {
        kanji: '檬',
        radicals: &['木', '冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '櫞',
        radicals: &['ヨ', '糸', '幺', '小', '木', '豕'],
    },
    Decomposition {
        kanji: '櫑',
        radicals: &['田', '木'],
    },
    Decomposition {
        kanji: '櫟',
        radicals: &['白', '木', '幺'],
    },
    Decomposition {
        kanji: '檪',
        radicals: &['白', '木', '冫'],
    },
    Decomposition {
        kanji: '櫚',
        radicals: &['口', '木', '門', 'ノ'],
    },
    Decomposition {
        kanji: '櫪',
        radicals: &['止', '木', '厂'],
    },
    Decomposition {
        kanji: '櫻',
        radicals: &['貝', '目', 'ハ', '女', '木'],
    },
    Decomposition {
        kanji: '欅',
        radicals: &['⺌', 'ハ', '木', '手'],
    },
    Decomposition {
        kanji: '蘖',
        radicals: &['口', '十', '辛', '木', '立', '⺾', '｜'],
    },
    Decomposition {
        kanji: '櫺',
        radicals: &['雨', '口', '木'],
    },
    Decomposition {
        kanji: '欒',
        radicals: &['言', '糸', '幺', '小', '木'],
    },
    Decomposition {
        kanji: '欖',
        radicals: &['見', '臣', '二', '木', '𠂉'],
    },
    Decomposition {
        kanji: '鬱',
        radicals: &['缶', '木', '冖', '凵', '匕', '彡', '鬯'],
    },
    Decomposition {
        kanji: '欟',
        radicals: &['見', '口', '十', '木', '⺾', '隹'],
    },
    Decomposition {
        kanji: '欸',
        radicals: &['欠', '矢', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '欷',
        radicals: &['ノ', '一', '巾', '欠'],
    },
    Decomposition {
        kanji: '盜',
        radicals: &['欠', '皿', '⺡'],
    },
    Decomposition {
        kanji: '欹',
        radicals: &['欠', '口', '大', '亅', '一'],
    },
    Decomposition {
        kanji: '飮',
        radicals: &['｜', '欠', '𠆢', '食'],
    },
    Decomposition {
        kanji: '歇',
        radicals: &['欠', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '歃',
        radicals: &['ノ', '臼', '欠', '十'],
    },
    Decomposition {
        kanji: '歉',
        radicals: &['｜', 'ヨ', '欠', '丷'],
    },
    Decomposition {
        kanji: '歐',
        radicals: &['欠', '口', '匚', '品'],
    },
    Decomposition {
        kanji: '歙',
        radicals: &['羽', '欠', '口', '𠆢', '冫'],
    },
    Decomposition {
        kanji: '歔',
        radicals: &['欠', '丷', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '歛',
        radicals: &['欠', '口', '人', '𠆢', '一'],
    },
    Decomposition {
        kanji: '歟',
        radicals: &['一', '臼', '欠', 'ハ'],
    },
    Decomposition {
        kanji: '歡',
        radicals: &['欠', '口', '十', '⺾', '隹'],
    },
    Decomposition {
        kanji: '歸',
        radicals: &['ヨ', '巾', '口', '止', '冖', '｜'],
    },
    Decomposition {
        kanji: '歹',
        radicals: &['歹'],
    },
    Decomposition {
        kanji: '歿',
        radicals: &['又', '歹', '勹'],
    },
    Decomposition {
        kanji: '殀',
        radicals: &['ノ', '大', '歹'],
    },
    Decomposition {
        kanji: '殄',
        radicals: &['𠆢', '彡', '歹'],
    },
    Decomposition {
        kanji: '殃',
        radicals: &['人', '大', '冂', '歹', '冖'],
    },
    Decomposition {
        kanji: '殍',
        radicals: &['子', '爪', '歹'],
    },
    Decomposition {
        kanji: '殘',
        radicals: &['戈', '歹'],
    },
    Decomposition {
        kanji: '殕',
        radicals: &['口', '立', '歹'],
    },
    Decomposition {
        kanji: '殞',
        radicals: &['貝', '目', 'ハ', '口', '歹'],
    },
    Decomposition {
        kanji: '殤',
        radicals: &['ノ', '一', '日', '勿', '歹', '勹', '𠂉'],
    },
    Decomposition {
        kanji: '殪',
        radicals: &['口', '士', '豆', '丷', '冖', '歹'],
    },
    Decomposition {
        kanji: '殫',
        radicals: &['口', '十', '田', '歹'],
    },
    Decomposition {
        kanji: '殯',
        radicals: &['ノ', '貝', '目', 'ハ', '小', '宀', '歹'],
    },
    Decomposition {
        kanji: '殲',
        radicals: &['人', '戈', '歹', '韭'],
    },
    Decomposition {
        kanji: '殱',
        radicals: &['土', '戈', '歹', '韭'],
    },
    Decomposition {
        kanji: '殳',
        radicals: &['殳', '几', '又'],
    },
    Decomposition {
        kanji: '殷',
        radicals: &['厂', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '殼',
        radicals: &['土', '儿', '冖', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '毆',
        radicals: &['口', '匚', '殳', '品', '几', '又'],
    },
    Decomposition {
        kanji: '毋',
        radicals: &['母', '毋'],
    },
    Decomposition {
        kanji: '毓',
        radicals: &['川', '母', '亠', '厶', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '毟',
        radicals: &['ノ', '小', '毛'],
    },
    Decomposition {
        kanji: '毬',
        radicals: &['水', '毛', '丶', '亠'],
    },
    Decomposition {
        kanji: '毫',
        radicals: &['口', '毛', '亠', '冖'],
    },
    Decomposition {
        kanji: '毳',
        radicals: &['毛'],
    },
    Decomposition {
        kanji: '毯',
        radicals: &['火', '毛'],
    },
    Decomposition {
        kanji: '麾',
        radicals: &['毛', '木', '广', '麻'],
    },
    Decomposition {
        kanji: '氈',
        radicals: &['口', '毛', '目', '亠', '囗', '日', '一'],
    },
    Decomposition {
        kanji: '氓',
        radicals: &['亡', '口', '氏', '尸'],
    },
    Decomposition {
        kanji: '气',
        radicals: &['气', '𠂉'],
    },
    Decomposition {
        kanji: '氛',
        radicals: &['刀', 'ハ', '气', '𠂉'],
    },
    Decomposition {
        kanji: '氤',
        radicals: &['大', '囗', '气', '𠂉'],
    },
    Decomposition {
        kanji: '氣',
        radicals: &['米', '气', '𠂉'],
    },
    Decomposition {
        kanji: '汞',
        radicals: &['工', '水'],
    },
    Decomposition {
        kanji: '汕',
        radicals: &['山', '⺡'],
    },
    Decomposition {
        kanji: '汢',
        radicals: &['⺡', '土'],
    },
    Decomposition {
        kanji: '汪',
        radicals: &['王', '⺡'],
    },
    Decomposition {
        kanji: '沂',
        radicals: &['斤', '⺡'],
    },
    Decomposition {
        kanji: '沍',
        radicals: &['ヨ', '一', '⺡', '彑'],
    },
    Decomposition {
        kanji: '沚',
        radicals: &['止', '⺡'],
    },
    Decomposition {
        kanji: '沁',
        radicals: &['⺡', '心'],
    },
    Decomposition {
        kanji: '沛',
        radicals: &['巾', '⺡', '亠'],
    },
    Decomposition {
        kanji: '汾',
        radicals: &['⺡', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '汨',
        radicals: &['⺡', '日'],
    },
    Decomposition {
        kanji: '汳',
        radicals: &['⺡', '又', '厂'],
    },
    Decomposition {
        kanji: '沒',
        radicals: &['⺡', '又', '力'],
    },
    Decomposition {
        kanji: '沐',
        radicals: &['⺡', '木'],
    },
    Decomposition {
        kanji: '泄',
        radicals: &['⺡', '世'],
    },
    Decomposition {
        kanji: '泱',
        radicals: &['⺡', '人', '大', '冂', '冖'],
    },
    Decomposition {
        kanji: '泓',
        radicals: &['弓', '⺡', '厶'],
    },
    Decomposition {
        kanji: '沽',
        radicals: &['口', '十', '⺡'],
    },
    Decomposition {
        kanji: '泗',
        radicals: &['⺡', '儿', '囗'],
    },
    Decomposition {
        kanji: '泅',
        radicals: &['⺡', '人', '囗'],
    },
    Decomposition {
        kanji: '泝',
        radicals: &['斤', '⺡', '丶'],
    },
    Decomposition {
        kanji: '沮',
        radicals: &['⺡', '目'],
    },
    Decomposition {
        kanji: '沱',
        radicals: &['⺡', '匕', '宀'],
    },
    Decomposition {
        kanji: '沾',
        radicals: &['口', '⺡', '卜'],
    },
    Decomposition {
        kanji: '沺',
        radicals: &['⺡', '田'],
    },
    Decomposition {
        kanji: '泛',
        radicals: &['ノ', '乙', '⺡', '亠'],
    },
    Decomposition {
        kanji: '泯',
        radicals: &['口', '氏', '⺡', '尸'],
    },
    Decomposition {
        kanji: '泙',
        radicals: &['干', '⺡', 'ハ'],
    },
    Decomposition {
        kanji: '泪',
        radicals: &['⺡', '目'],
    },
    Decomposition {
        kanji: '洟',
        radicals: &['弓', '⺡', '人', '大'],
    },
    Decomposition {
        kanji: '衍',
        radicals: &['行', '⺡', '彳'],
    },
    Decomposition {
        kanji: '洶',
        radicals: &['⺡', '凵', '勹'],
    },
    Decomposition {
        kanji: '洫',
        radicals: &['血', '皿', '⺡'],
    },
    Decomposition {
        kanji: '洽',
        radicals: &['口', '⺡', '𠆢', '一'],
    },
    Decomposition {
        kanji: '洸',
        radicals: &['⺡', '⺌', '儿'],
    },
    Decomposition {
        kanji: '洙',
        radicals: &['｜', 'ノ', '牛', '⺡', '土', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '洵',
        radicals: &['⺡', '日', '勹'],
    },
    Decomposition {
        kanji: '洳',
        radicals: &['口', '⺡', '女'],
    },
    Decomposition {
        kanji: '洒',
        radicals: &['⺡', '西'],
    },
    Decomposition {
        kanji: '洌',
        radicals: &['⺉', '⺡', '歹'],
    },
    Decomposition {
        kanji: '浣',
        radicals: &['⺡', '二', '儿', '宀'],
    },
    Decomposition {
        kanji: '涓',
        radicals: &['月', '口', '⺡'],
    },
    Decomposition {
        kanji: '浤',
        radicals: &['ノ', '一', '⺡', '厶', '宀'],
    },
    Decomposition {
        kanji: '浚',
        radicals: &['⺡', 'ハ', '厶', '夂'],
    },
    Decomposition {
        kanji: '浹',
        radicals: &['⺡', '人', '大'],
    },
    Decomposition {
        kanji: '浙',
        radicals: &['斤', '⺡', '扌'],
    },
    Decomposition {
        kanji: '涎',
        radicals: &['ノ', '止', '⺡', '廴'],
    },
    Decomposition {
        kanji: '涕',
        radicals: &['｜', 'ノ', '弓', '⺡', '丷'],
    },
    Decomposition {
        kanji: '濤',
        radicals: &['口', '工', '士', '⺡', '寸'],
    },
    Decomposition {
        kanji: '涅',
        radicals: &['⺡', '土', '日'],
    },
    Decomposition {
        kanji: '淹',
        radicals: &['乙', '⺡', '大', '日', '奄'],
    },
    Decomposition {
        kanji: '渕',
        radicals: &['⺉', '⺡', '人', '大', '二', '丷'],
    },
    Decomposition {
        kanji: '渊',
        radicals: &['｜', 'ノ', '⺡', '米'],
    },
    Decomposition {
        kanji: '涵',
        radicals: &['一', '⺡', '水', '凵'],
    },
    Decomposition {
        kanji: '淇',
        radicals: &['甘', '⺡', 'ハ'],
    },
    Decomposition {
        kanji: '淦',
        radicals: &['金', '⺡'],
    },
    Decomposition {
        kanji: '涸',
        radicals: &['口', '十', '⺡', '囗'],
    },
    Decomposition {
        kanji: '淆',
        radicals: &['ノ', '一', '月', '⺡'],
    },
    Decomposition {
        kanji: '淬',
        radicals: &['十', '⺡', '人', '亠'],
    },
    Decomposition {
        kanji: '淞',
        radicals: &['⺡', 'ハ', '木', '厶'],
    },
    Decomposition {
        kanji: '淌',
        radicals: &['口', '⺡', '⺌', '冂'],
    },
    Decomposition {
        kanji: '淨',
        radicals: &['ヨ', '⺡', '爪', '亅'],
    },
    Decomposition {
        kanji: '淒',
        radicals: &['｜', 'ヨ', '一', '⺡', '女'],
    },
    Decomposition {
        kanji: '淅',
        radicals: &['斤', '⺡', '木'],
    },
    Decomposition {
        kanji: '淺',
        radicals: &['⺡', '戈'],
    },
    Decomposition {
        kanji: '淙',
        radicals: &['示', '二', '小', '⺡', '宀'],
    },
    Decomposition {
        kanji: '淤',
        radicals: &['⺡', '方', '𠆢', '冫'],
    },
    Decomposition {
        kanji: '淕',
        radicals: &['⺡', '土', '儿'],
    },
    Decomposition {
        kanji: '淪',
        radicals: &['｜', '一', '⺡', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '淮',
        radicals: &['⺡', '隹'],
    },
    Decomposition {
        kanji: '渭',
        radicals: &['月', '⺡', '田'],
    },
    Decomposition {
        kanji: '湮',
        radicals: &['⺡', '西', '土'],
    },
    Decomposition {
        kanji: '渮',
        radicals: &['口', '⺡', '亅', '⺾'],
    },
    Decomposition {
        kanji: '渙',
        radicals: &['⺡', '大', '儿', '冂'],
    },
    Decomposition {
        kanji: '湲',
        radicals: &['ノ', '一', '⺡', '爪', '二', '又'],
    },
    Decomposition {
        kanji: '湟',
        radicals: &['王', '⺡', '白'],
    },
    Decomposition {
        kanji: '渾',
        radicals: &['車', '⺡', '冖'],
    },
    Decomposition {
        kanji: '渣',
        radicals: &['⺡', '木', '目'],
    },
    Decomposition {
        kanji: '湫',
        radicals: &['火', '禾', '⺡'],
    },
    Decomposition {
        kanji: '渫',
        radicals: &['⺡', '木', '世'],
    },
    Decomposition {
        kanji: '湶',
        radicals: &['⺡', '水', '白'],
    },
    Decomposition {
        kanji: '湍',
        radicals: &['山', '而', '⺡'],
    },
    Decomposition {
        kanji: '渟',
        radicals: &['口', '⺡', '亅', '亠', '冖'],
    },
    Decomposition {
        kanji: '湃',
        radicals: &['干', '⺡', '扌'],
    },
    Decomposition {
        kanji: '渺',
        radicals: &['ノ', '⺡', '小', '目'],
    },
    Decomposition {
        kanji: '湎',
        radicals: &['一', '⺡', '面', '囗'],
    },
    Decomposition {
        kanji: '渤',
        radicals: &['子', '十', '⺡', '力', '冖'],
    },
    Decomposition {
        kanji: '滿',
        radicals: &['一', '⺡', '人', '入', '冂', '凵'],
    },
    Decomposition {
        kanji: '渝',
        radicals: &['⺉', '月', '⺡', '𠆢', '一'],
    },
    Decomposition {
        kanji: '游',
        radicals: &['子', '⺡', '方', '𠂉'],
    },
    Decomposition {
        kanji: '溂',
        radicals: &['｜', '⺉', '口', '⺡', 'ハ', '木'],
    },
    Decomposition {
        kanji: '溪',
        radicals: &['⺡', '大', '爪', '幺'],
    },
    Decomposition {
        kanji: '溘',
        radicals: &['皿', '⺡', '土', '厶'],
    },
    Decomposition {
        kanji: '滉',
        radicals: &['⺡', '⺌', '日', '儿'],
    },
    Decomposition {
        kanji: '溷',
        radicals: &['⺡', '囗', '豕'],
    },
    Decomposition {
        kanji: '滓',
        radicals: &['十', '⺡', '辛', '立', '宀'],
    },
    Decomposition {
        kanji: '溽',
        radicals: &['⺡', '寸', '辰', '衣'],
    },
    Decomposition {
        kanji: '溯',
        radicals: &['月', '⺡', '丷', '屮'],
    },
    Decomposition {
        kanji: '滄',
        radicals: &['戸', '口', '⺡', '𠆢', '一', '尸'],
    },
    Decomposition {
        kanji: '溲',
        radicals: &['支', '⺡', '日', '又', '十'],
    },
    Decomposition {
        kanji: '滔',
        radicals: &['臼', '⺡', '爪'],
    },
    Decomposition {
        kanji: '滕',
        radicals: &['月', '人', '水', '大', '二', '丷'],
    },
    Decomposition {
        kanji: '溏',
        radicals: &['｜', 'ヨ', '口', '⺡', '广'],
    },
    Decomposition {
        kanji: '溥',
        radicals: &['十', '⺡', '寸', '田', '丶'],
    },
    Decomposition {
        kanji: '滂',
        radicals: &['⺡', '丷', '方', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '溟',
        radicals: &['⺡', '日', 'ハ', '亠', '冖'],
    },
    Decomposition {
        kanji: '潁',
        radicals: &['貝', '目', 'ハ', '水', '頁', '匕'],
    },
    Decomposition {
        kanji: '漑',
        radicals: &['艮', '⺡', '无'],
    },
    Decomposition {
        kanji: '灌',
        radicals: &['口', '十', '⺡', '⺾', '隹'],
    },
    Decomposition {
        kanji: '滬',
        radicals: &['戸', '口', '⺡', '巴', '一', '尸'],
    },
    Decomposition {
        kanji: '滸',
        radicals: &['干', '言', '⺡', '𠂉'],
    },
    Decomposition {
        kanji: '滾',
        radicals: &['衣', '口', '⺡', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '漿',
        radicals: &['水', '寸', '夕', '爿'],
    },
    Decomposition {
        kanji: '滲',
        radicals: &['⺡', '大', '厶', '彡'],
    },
    Decomposition {
        kanji: '漱',
        radicals: &['欠', '口', '⺡', '木'],
    },
    Decomposition {
        kanji: '滯',
        radicals: &['一', '巾', '⺡', '儿', '冖', '凵'],
    },
    Decomposition {
        kanji: '漲',
        radicals: &['弓', '⺡', '長'],
    },
    Decomposition {
        kanji: '滌',
        radicals: &['⺅', '⺡', '木', '攵', '𠂉', '｜'],
    },
    Decomposition {
        kanji: '漾',
        radicals: &['王', '⺡', '水', '丷', '羊', '丶'],
    },
    Decomposition {
        kanji: '漓',
        radicals: &['⺡', '亠', '凵', '⽱'],
    },
    Decomposition {
        kanji: '滷',
        radicals: &['十', '⺡', '卜', '囗', '鹵'],
    },
    Decomposition {
        kanji: '澆',
        radicals: &['⺡', '土', '儿'],
    },
    Decomposition {
        kanji: '潺',
        radicals: &['子', '⺡', '尸'],
    },
    Decomposition {
        kanji: '潸',
        radicals: &['月', '⺡', '木'],
    },
    Decomposition {
        kanji: '澁',
        radicals: &['止', '⺡'],
    },
    Decomposition {
        kanji: '澀',
        radicals: &['止', '⺡', '刀', '丶'],
    },
    Decomposition {
        kanji: '潯',
        radicals: &['ヨ', '口', '工', '⺡', '寸'],
    },
    Decomposition {
        kanji: '潛',
        radicals: &['⺡', '日', '无'],
    },
    Decomposition {
        kanji: '濳',
        radicals: &['⺡', '土', '日', '儿'],
    },
    Decomposition {
        kanji: '潭',
        radicals: &['十', '⺡', '西', '日', '曰'],
    },
    Decomposition {
        kanji: '澂',
        radicals: &['王', '山', '⺡', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '潼',
        radicals: &['⺡', '里', '立'],
    },
    Decomposition {
        kanji: '潘',
        radicals: &['⺡', '田', '釆', '米'],
    },
    Decomposition {
        kanji: '澎',
        radicals: &['口', '十', '⺡', '土', '豆', '丷', '彡'],
    },
    Decomposition {
        kanji: '澑',
        radicals: &['｜', '一', '⺡', '田'],
    },
    Decomposition {
        kanji: '濂',
        radicals: &['｜', 'ヨ', '⺡', 'ハ', '广'],
    },
    Decomposition {
        kanji: '潦',
        radicals: &['⺡', '小', '大', '日', '丷', '亠'],
    },
    Decomposition {
        kanji: '澳',
        radicals: &['⺡', '大', '米', '冂', '釆'],
    },
    Decomposition {
        kanji: '澣',
        radicals: &['干', '十', '⺡', '日', '𠆢'],
    },
    Decomposition {
        kanji: '澡',
        radicals: &['口', '⺡', '木', '品'],
    },
    Decomposition {
        kanji: '澤',
        radicals: &['十', '⺡', '辛', '土', '⺲', '立', '亠'],
    },
    Decomposition {
        kanji: '澹',
        radicals: &['言', '⺡', '儿', '厂'],
    },
    Decomposition {
        kanji: '濆',
        radicals: &['貝', '目', 'ハ', '十', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '澪',
        radicals: &['雨', '⺡', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '濟',
        radicals: &['⺡', '亠', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '濕',
        radicals: &['⺡', '日', '幺', '⺣'],
    },
    Decomposition {
        kanji: '濬',
        radicals: &['⺡', 'ハ', '卜', '目', '𠆢', '冖'],
    },
    Decomposition {
        kanji: '濔',
        radicals: &['｜', '一', '⺡', 'ハ', '冂', '爻'],
    },
    Decomposition {
        kanji: '濘',
        radicals: &['⺡', '心', '⺲', '亅', '宀', '皿'],
    },
    Decomposition {
        kanji: '濱',
        radicals: &['ノ', '貝', '目', 'ハ', '⺡', '小', '宀'],
    },
    Decomposition {
        kanji: '濮',
        radicals: &['王', '⺅', '⺡', '大', '丷', '羊'],
    },
    Decomposition {
        kanji: '濛',
        radicals: &['⺡', '冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '瀉',
        radicals: &['臼', '⺡', '勹', '宀', '⺣'],
    },
    Decomposition {
        kanji: '瀋',
        radicals: &['⺡', '田', '釆', '米', '宀'],
    },
    Decomposition {
        kanji: '濺',
        radicals: &['貝', '目', 'ハ', '⺡', '戈'],
    },
    Decomposition {
        kanji: '瀑',
        radicals: &['｜', '一', '⺡', '水', '二', '日', 'ハ'],
    },
    Decomposition {
        kanji: '瀁',
        radicals: &['王', '⺡', '食', '丷', '羊'],
    },
    Decomposition {
        kanji: '瀏',
        radicals: &['⺉', '金', '⺡'],
    },
    Decomposition {
        kanji: '濾',
        radicals: &['⺡', '田', '心', '厂', '卜'],
    },
    Decomposition {
        kanji: '瀛',
        radicals: &['亡', '月', '口', '⺡', '女', '丶', '几'],
    },
    Decomposition {
        kanji: '瀚',
        radicals: &['羽', '十', '⺡', '日', '𠆢', '冫'],
    },
    Decomposition {
        kanji: '潴',
        radicals: &['⺡', '日', '⺨', '⺹'],
    },
    Decomposition {
        kanji: '瀝',
        radicals: &['止', '⺡', '木', '厂'],
    },
    Decomposition {
        kanji: '瀘',
        radicals: &['皿', '⺡', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '瀟',
        radicals: &['｜', 'ノ', 'ヨ', '⺡', '水', '⺾'],
    },
    Decomposition {
        kanji: '瀰',
        radicals: &['｜', '一', '弓', '⺡', 'ハ', '冂', '爻'],
    },
    Decomposition {
        kanji: '瀾',
        radicals: &['｜', '⺡', '田', '日', '木', '門'],
    },
    Decomposition {
        kanji: '瀲',
        radicals: &['口', '⺡', '人', '𠆢', '攵', '一', '𠂉'],
    },
    Decomposition {
        kanji: '灑',
        radicals: &['鹿', '⺡', '比', '冂', '广'],
    },
    Decomposition {
        kanji: '灣',
        radicals: &['弓', '言', '糸', '幺', '小', '⺡'],
    },
    Decomposition {
        kanji: '炙',
        radicals: &['火', '夕', '丶'],
    },
    Decomposition {
        kanji: '炒',
        radicals: &['ノ', '火', '小'],
    },
    Decomposition {
        kanji: '炯',
        radicals: &['火', '口', '冂'],
    },
    Decomposition {
        kanji: '烱',
        radicals: &['火', '口', '儿', '冂'],
    },
    Decomposition {
        kanji: '炬',
        radicals: &['火', '匚', '巨'],
    },
    Decomposition {
        kanji: '炸',
        radicals: &['｜', 'ノ', '火'],
    },
    Decomposition {
        kanji: '炳',
        radicals: &['一', '火', '人', '冂'],
    },
    Decomposition {
        kanji: '炮',
        radicals: &['火', '勹', '已'],
    },
    Decomposition {
        kanji: '烟',
        radicals: &['火', '大', '囗'],
    },
    Decomposition {
        kanji: '烋',
        radicals: &['⺅', '木', '⺣'],
    },
    Decomposition {
        kanji: '烝',
        radicals: &['一', '水', '亅', '⺣'],
    },
    Decomposition {
        kanji: '烙',
        radicals: &['火', '口', '夂'],
    },
    Decomposition {
        kanji: '焉',
        radicals: &['一', '止', '⺣'],
    },
    Decomposition {
        kanji: '烽',
        radicals: &['｜', '火', '二', '夂'],
    },
    Decomposition {
        kanji: '焜',
        radicals: &['火', '日', '比'],
    },
    Decomposition {
        kanji: '焙',
        radicals: &['火', '口', '立'],
    },
    Decomposition {
        kanji: '煥',
        radicals: &['火', '大', '儿', '冂'],
    },
    Decomposition {
        kanji: '煕',
        radicals: &['臣', '匚', '已', '⺣'],
    },
    Decomposition {
        kanji: '熈',
        radicals: &['ノ', '臣', '卩', '已', '⺣'],
    },
    Decomposition {
        kanji: '煦',
        radicals: &['口', '日', '勹', '⺣'],
    },
    Decomposition {
        kanji: '煢',
        radicals: &['乙', '火', '十', '冖'],
    },
    Decomposition {
        kanji: '煌',
        radicals: &['王', '火', '白'],
    },
    Decomposition {
        kanji: '煖',
        radicals: &['ノ', '一', '火', '爪', '又'],
    },
    Decomposition {
        kanji: '煬',
        radicals: &['ノ', '火', '日', '勿', '一', '勹'],
    },
    Decomposition {
        kanji: '熏',
        radicals: &['｜', 'ノ', '田', '日', '⺣'],
    },
    Decomposition {
        kanji: '燻',
        radicals: &['｜', 'ノ', '火', '田', '日'],
    },
    Decomposition {
        kanji: '熄',
        radicals: &['火', '自', '心', '目'],
    },
    Decomposition {
        kanji: '熕',
        radicals: &['火', '貝', '目', 'ハ', '工'],
    },
    Decomposition {
        kanji: '熨',
        radicals: &['火', '示', '二', '小', '寸', '尸'],
    },
    Decomposition {
        kanji: '熬',
        radicals: &['土', '方', '攵', '⺣', '𠂉'],
    },
    Decomposition {
        kanji: '燗',
        radicals: &['火', '月', '門'],
    },
    Decomposition {
        kanji: '熹',
        radicals: &['口', '士', '十', '豆', '丷', '⺣'],
    },
    Decomposition {
        kanji: '熾',
        radicals: &['音', '火', '日', '立', '戈'],
    },
    Decomposition {
        kanji: '燒',
        radicals: &['火', '土', '儿'],
    },
    Decomposition {
        kanji: '燉',
        radicals: &['火', '口', '子', '亠', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '燔',
        radicals: &['火', '田', '釆', '米'],
    },
    Decomposition {
        kanji: '燎',
        radicals: &['火', '小', '大', '日', '丷', '亠'],
    },
    Decomposition {
        kanji: '燠',
        radicals: &['火', '大', '米', '冂', '釆'],
    },
    Decomposition {
        kanji: '燬',
        radicals: &['臼', '王', '火', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '燧',
        radicals: &['火', '⻌', '丷', '豕'],
    },
    Decomposition {
        kanji: '燵',
        radicals: &['火', '⻌', '土', '丷', '立', '亠', '二'],
    },
    Decomposition {
        kanji: '燼',
        radicals: &['｜', 'ヨ', '火', '皿', '⺣', '聿'],
    },
    Decomposition {
        kanji: '燹',
        radicals: &['火', '豕'],
    },
    Decomposition {
        kanji: '燿',
        radicals: &['ヨ', '火', '隹'],
    },
    Decomposition {
        kanji: '爍',
        radicals: &['火', '白', '木', '冫'],
    },
    Decomposition {
        kanji: '爐',
        radicals: &['火', '皿', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '爛',
        radicals: &['｜', '火', '日', 'ハ', '木', '門'],
    },
    Decomposition {
        kanji: '爨',
        radicals: &['火', '口', 'ハ', '木', '冂', '冖', '一', '大', '口', '臼'],
    },
    Decomposition {
        kanji: '爭',
        radicals: &['ヨ', '爪', '亅'],
    },
    Decomposition {
        kanji: '爬',
        radicals: &['爪', '已', '巴'],
    },
    Decomposition {
        kanji: '爰',
        radicals: &['ノ', '一', '爪', '又'],
    },
    Decomposition {
        kanji: '爲',
        radicals: &['爪', '尸', '⺣'],
    },
    Decomposition {
        kanji: '爻',
        radicals: &['爻'],
    },
    Decomposition {
        kanji: '爼',
        radicals: &['目', '爻'],
    },
    Decomposition {
        kanji: '爿',
        radicals: &['爿'],
    },
    Decomposition {
        kanji: '牀',
        radicals: &['木', '爿'],
    },
    Decomposition {
        kanji: '牆',
        radicals: &['口', '人', '土', '囗', '爿'],
    },
    Decomposition {
        kanji: '牋',
        radicals: &['片', '戈'],
    },
    Decomposition {
        kanji: '牘',
        radicals: &['貝', '目', 'ハ', '士', '片', '儿', '囗'],
    },
    Decomposition {
        kanji: '牴',
        radicals: &['牛', '氏'],
    },
    Decomposition {
        kanji: '牾',
        radicals: &['牛', '口', '五'],
    },
    Decomposition {
        kanji: '犂',
        radicals: &['ノ', '禾', '牛', '勿'],
    },
    Decomposition {
        kanji: '犁',
        radicals: &['禾', '⺉', '牛'],
    },
    Decomposition {
        kanji: '犇',
        radicals: &['牛'],
    },
    Decomposition {
        kanji: '犒',
        radicals: &['牛', '口', '高', '亠', '冂'],
    },
    Decomposition {
        kanji: '犖',
        radicals: &['火', '牛', '冖'],
    },
    Decomposition {
        kanji: '犢',
        radicals: &['貝', '目', 'ハ', '牛', '士', '儿', '囗'],
    },
    Decomposition {
        kanji: '犧',
        radicals: &['王', '禾', '牛', '丷', '羊', '戈'],
    },
    Decomposition {
        kanji: '犹',
        radicals: &['⺨', '丶', '尤', '尢'],
    },
    Decomposition {
        kanji: '犲',
        radicals: &['ノ', '一', '⺨', '亅'],
    },
    Decomposition {
        kanji: '狃',
        radicals: &['｜', '一', '⺨'],
    },
    Decomposition {
        kanji: '狆',
        radicals: &['｜', '口', '⺨'],
    },
    Decomposition {
        kanji: '狄',
        radicals: &['火', '⺨'],
    },
    Decomposition {
        kanji: '狎',
        radicals: &['｜', '日', '⺨', '田'],
    },
    Decomposition {
        kanji: '狒',
        radicals: &['｜', 'ノ', '弓', '⺨'],
    },
    Decomposition {
        kanji: '狢',
        radicals: &['口', '⺨', '夂'],
    },
    Decomposition {
        kanji: '狠',
        radicals: &['艮', '⺨'],
    },
    Decomposition {
        kanji: '狡',
        radicals: &['⺨', '父', '亠'],
    },
    Decomposition {
        kanji: '狹',
        radicals: &['人', '大', '⺨'],
    },
    Decomposition {
        kanji: '狷',
        radicals: &['月', '口', '⺨'],
    },
    Decomposition {
        kanji: '倏',
        radicals: &['⺅', '犬', '夂', '攵', '｜'],
    },
    Decomposition {
        kanji: '猗',
        radicals: &['口', '大', '⺨', '亅', '一'],
    },
    Decomposition {
        kanji: '猊',
        radicals: &['臼', '⺨', '儿'],
    },
    Decomposition {
        kanji: '猜',
        radicals: &['月', '青', '土', '二', '⺨', '亠'],
    },
    Decomposition {
        kanji: '猖',
        radicals: &['日', '⺨'],
    },
    Decomposition {
        kanji: '猝',
        radicals: &['十', '人', '⺨', '亠'],
    },
    Decomposition {
        kanji: '猴',
        radicals: &['⺅', '⺨', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '猯',
        radicals: &['山', '而', '⺨'],
    },
    Decomposition {
        kanji: '猩',
        radicals: &['生', '日', '⺨'],
    },
    Decomposition {
        kanji: '猥',
        radicals: &['衣', '田', '⺨'],
    },
    Decomposition {
        kanji: '猾',
        radicals: &['月', '骨', '⺨', '冂', '冖'],
    },
    Decomposition {
        kanji: '獎',
        radicals: &['犬', '寸', '夕', '爿'],
    },
    Decomposition {
        kanji: '獏',
        radicals: &['大', '日', '⺨', '⺾'],
    },
    Decomposition {
        kanji: '默',
        radicals: &['犬', '里', '⺣', '黒'],
    },
    Decomposition {
        kanji: '獗',
        radicals: &['欠', '丷', '⺨', '厂', '屮'],
    },
    Decomposition {
        kanji: '獪',
        radicals: &['日', '⺲', '⺨', '𠆢', '一'],
    },
    Decomposition {
        kanji: '獨',
        radicals: &['虫', '⺲', '⺨', '勹'],
    },
    Decomposition {
        kanji: '獰',
        radicals: &['心', '⺲', '⺨', '亅', '宀', '皿'],
    },
    Decomposition {
        kanji: '獸',
        radicals: &['一', '犬', '口', '田'],
    },
    Decomposition {
        kanji: '獵',
        radicals: &['臼', '乙', '口', '巛', '鼠', '⺨'],
    },
    Decomposition {
        kanji: '獻',
        radicals: &['犬', '口', '卜', '儿', '冂', '匕', '厂', '虍', '鬲'],
    },
    Decomposition {
        kanji: '獺',
        radicals: &['貝', '目', 'ハ', '口', '⺨', '頁', '木'],
    },
    Decomposition {
        kanji: '珈',
        radicals: &['王', '口', '力'],
    },
    Decomposition {
        kanji: '玳',
        radicals: &['王', '⺅', '弋'],
    },
    Decomposition {
        kanji: '珎',
        radicals: &['王', '小', '𠂉'],
    },
    Decomposition {
        kanji: '玻',
        radicals: &['王', '皮', '又'],
    },
    Decomposition {
        kanji: '珀',
        radicals: &['王', '白'],
    },
    Decomposition {
        kanji: '珥',
        radicals: &['王', '耳'],
    },
    Decomposition {
        kanji: '珮',
        radicals: &['王', '巾', '几'],
    },
    Decomposition {
        kanji: '珞',
        radicals: &['王', '口', '夂'],
    },
    Decomposition {
        kanji: '璢',
        radicals: &['｜', '一', '王', '田'],
    },
    Decomposition {
        kanji: '琅',
        radicals: &['王', '艮'],
    },
    Decomposition {
        kanji: '瑯',
        radicals: &['王', '艮', '⻏'],
    },
    Decomposition {
        kanji: '琥',
        radicals: &['王', '卜', '儿', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '珸',
        radicals: &['王', '口', '五'],
    },
    Decomposition {
        kanji: '琲',
        radicals: &['王', '非'],
    },
    Decomposition {
        kanji: '琺',
        radicals: &['王', '⺡', '土', '厶'],
    },
    Decomposition {
        kanji: '瑕',
        radicals: &['｜', '王', '又'],
    },
    Decomposition {
        kanji: '琿',
        radicals: &['王', '車', '冖'],
    },
    Decomposition {
        kanji: '瑟',
        radicals: &['ノ', '王', '心', '丶'],
    },
    Decomposition {
        kanji: '瑙',
        radicals: &['王', '巛', '囗'],
    },
    Decomposition {
        kanji: '瑁',
        radicals: &['王', '目', '冂'],
    },
    Decomposition {
        kanji: '瑜',
        radicals: &['王', '⺉', '月', '𠆢', '一'],
    },
    Decomposition {
        kanji: '瑩',
        radicals: &['王', '火', '冖'],
    },
    Decomposition {
        kanji: '瑰',
        radicals: &['王', '鬼', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '瑣',
        radicals: &['王', '貝', '目', 'ハ', '⺌'],
    },
    Decomposition {
        kanji: '瑪',
        radicals: &['王', '馬', '⺣'],
    },
    Decomposition {
        kanji: '瑶',
        radicals: &['王', '缶', '爪', '凵'],
    },
    Decomposition {
        kanji: '瑾',
        radicals: &['｜', '一', '王', '口', '⺾', '土', '二'],
    },
    Decomposition {
        kanji: '璋',
        radicals: &['王', '音', '十', '日', '立', '曰'],
    },
    Decomposition {
        kanji: '璞',
        radicals: &['王', '人', '丷', '羊', '二', '大'],
    },
    Decomposition {
        kanji: '璧',
        radicals: &['王', '口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '瓊',
        radicals: &['王', '目', '冂', '夂'],
    },
    Decomposition {
        kanji: '瓏',
        radicals: &['王', '月', '立'],
    },
    Decomposition {
        kanji: '瓔',
        radicals: &['王', '貝', '目', 'ハ', '女'],
    },
    Decomposition {
        kanji: '珱',
        radicals: &['王', '女', '⺌'],
    },
    Decomposition {
        kanji: '瓠',
        radicals: &['瓜', '大'],
    },
    Decomposition {
        kanji: '瓣',
        radicals: &['瓜', '十', '辛', '立'],
    },
    Decomposition {
        kanji: '瓧',
        radicals: &['瓦', '十'],
    },
    Decomposition {
        kanji: '瓩',
        radicals: &['ノ', '瓦', '十'],
    },
    Decomposition {
        kanji: '瓮',
        radicals: &['瓦', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '瓲',
        radicals: &['瓦', '屯'],
    },
    Decomposition {
        kanji: '瓰',
        radicals: &['瓦', '刀', 'ハ'],
    },
    Decomposition {
        kanji: '瓱',
        radicals: &['瓦', '毛'],
    },
    Decomposition {
        kanji: '瓸',
        radicals: &['一', '瓦', '白', '日'],
    },
    Decomposition {
        kanji: '瓷',
        radicals: &['瓦', '欠', '冫'],
    },
    Decomposition {
        kanji: '甄',
        radicals: &['瓦', '西', '土'],
    },
    Decomposition {
        kanji: '甃',
        radicals: &['火', '禾', '瓦'],
    },
    Decomposition {
        kanji: '甅',
        radicals: &['瓦', '里', '厂'],
    },
    Decomposition {
        kanji: '甌',
        radicals: &['瓦', '口', '匚', '品'],
    },
    Decomposition {
        kanji: '甎',
        radicals: &['瓦', '十', '寸', '虫', '田', '亠'],
    },
    Decomposition {
        kanji: '甍',
        radicals: &['瓦', '⺲', '冖', '⺾'],
    },
    Decomposition {
        kanji: '甕',
        radicals: &['瓦', '亠', '幺', '隹'],
    },
    Decomposition {
        kanji: '甓',
        radicals: &['瓦', '口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '甞',
        radicals: &['甘', '口', '⺌', '冖'],
    },
    Decomposition {
        kanji: '甦',
        radicals: &['一', '生', '日', '田', 'ノ'],
    },
    Decomposition {
        kanji: '甬',
        radicals: &['用'],
    },
    Decomposition {
        kanji: '甼',
        radicals: &['一', '田', '亅'],
    },
    Decomposition {
        kanji: '畄',
        radicals: &['⺌', '田'],
    },
    Decomposition {
        kanji: '畍',
        radicals: &['｜', 'ノ', '田', '𠆢'],
    },
    Decomposition {
        kanji: '畊',
        radicals: &['｜', 'ノ', '田', '二', '井'],
    },
    Decomposition {
        kanji: '畉',
        radicals: &['人', '田', '二', '大'],
    },
    Decomposition {
        kanji: '畛',
        radicals: &['田', '𠆢', '彡'],
    },
    Decomposition {
        kanji: '畆',
        radicals: &['田', '亠', '厶'],
    },
    Decomposition {
        kanji: '畚',
        radicals: &['大', '田', '厶'],
    },
    Decomposition {
        kanji: '畩',
        radicals: &['衣', '田', '亠'],
    },
    Decomposition {
        kanji: '畤',
        radicals: &['寸', '田', '土'],
    },
    Decomposition {
        kanji: '畧',
        radicals: &['口', '田', '夂'],
    },
    Decomposition {
        kanji: '畫',
        radicals: &['一', '田', '聿'],
    },
    Decomposition {
        kanji: '畭',
        radicals: &['工', '小', '田', '𠆢', '一'],
    },
    Decomposition {
        kanji: '畸',
        radicals: &['口', '大', '田', '亅', '一'],
    },
    Decomposition {
        kanji: '當',
        radicals: &['口', '⺌', '田', '冖'],
    },
    Decomposition {
        kanji: '疆',
        radicals: &['一', '弓', '田', '土'],
    },
    Decomposition {
        kanji: '疇',
        radicals: &['口', '工', '士', '寸', '田'],
    },
    Decomposition {
        kanji: '畴',
        radicals: &['ノ', '一', '寸', '田', '二'],
    },
    Decomposition {
        kanji: '疊',
        radicals: &['田', '目', '冖'],
    },
    Decomposition {
        kanji: '疉',
        radicals: &['ヨ', '田', '宀'],
    },
    Decomposition {
        kanji: '疂',
        radicals: &['田', '目', '冖', '冫'],
    },
    Decomposition {
        kanji: '疔',
        radicals: &['一', '亅', '⽧'],
    },
    Decomposition {
        kanji: '疚',
        radicals: &['ノ', '入', '⽧', '久'],
    },
    Decomposition {
        kanji: '疝',
        radicals: &['山', '⽧'],
    },
    Decomposition {
        kanji: '疥',
        radicals: &['｜', 'ノ', '𠆢', '⽧'],
    },
    Decomposition {
        kanji: '疣',
        radicals: &['丶', '尤', '⽧', '尢'],
    },
    Decomposition {
        kanji: '痂',
        radicals: &['口', '力', '⽧'],
    },
    Decomposition {
        kanji: '疳',
        radicals: &['甘', '⽧'],
    },
    Decomposition {
        kanji: '痃',
        radicals: &['亠', '幺', '⽧', '玄'],
    },
    Decomposition {
        kanji: '疵',
        radicals: &['止', '匕', '⽧'],
    },
    Decomposition {
        kanji: '疽',
        radicals: &['目', '⽧'],
    },
    Decomposition {
        kanji: '疸',
        radicals: &['一', '日', '⽧'],
    },
    Decomposition {
        kanji: '疼',
        radicals: &['冫', '夂', '⽧', '丶'],
    },
    Decomposition {
        kanji: '疱',
        radicals: &['勹', '已', '⽧'],
    },
    Decomposition {
        kanji: '痍',
        radicals: &['弓', '人', '大', '⽧'],
    },
    Decomposition {
        kanji: '痊',
        radicals: &['王', '𠆢', '⽧'],
    },
    Decomposition {
        kanji: '痒',
        radicals: &['王', '丷', '羊', '⽧'],
    },
    Decomposition {
        kanji: '痙',
        radicals: &['工', '巛', '⽧'],
    },
    Decomposition {
        kanji: '痣',
        radicals: &['士', '心', '⽧'],
    },
    Decomposition {
        kanji: '痞',
        radicals: &['｜', 'ノ', '一', '口', '丶', '⽧'],
    },
    Decomposition {
        kanji: '痾',
        radicals: &['口', '亅', '⽧', '⻖', '一'],
    },
    Decomposition {
        kanji: '痿',
        radicals: &['禾', '女', '⽧'],
    },
    Decomposition {
        kanji: '痼',
        radicals: &['口', '十', '囗', '⽧'],
    },
    Decomposition {
        kanji: '瘁',
        radicals: &['十', '人', '亠', '⽧'],
    },
    Decomposition {
        kanji: '痰',
        radicals: &['火', '⽧'],
    },
    Decomposition {
        kanji: '痺',
        radicals: &['十', '田', '⽧'],
    },
    Decomposition {
        kanji: '痲',
        radicals: &['十', '木', '儿', '⽧'],
    },
    Decomposition {
        kanji: '痳',
        radicals: &['木', '⽧'],
    },
    Decomposition {
        kanji: '瘋',
        radicals: &['風', '⽧', '虫', '几'],
    },
    Decomposition {
        kanji: '瘍',
        radicals: &['ノ', '一', '日', '勹', '⽧', '勿'],
    },
    Decomposition {
        kanji: '瘉',
        radicals: &['⺉', '月', '𠆢', '⽧', '一'],
    },
    Decomposition {
        kanji: '瘟',
        radicals: &['皿', '日', '⽧'],
    },
    Decomposition {
        kanji: '瘧',
        radicals: &['卜', '匕', '厂', '⽧', '虍'],
    },
    Decomposition {
        kanji: '瘠',
        radicals: &['月', '⽧', '人', '二'],
    },
    Decomposition {
        kanji: '瘡',
        radicals: &['口', '𠆢', '尸', '⽧', '一'],
    },
    Decomposition {
        kanji: '瘢',
        radicals: &['舟', '殳', '⽧', '几', '又'],
    },
    Decomposition {
        kanji: '瘤',
        radicals: &['田', '刀', '厶', '⽧'],
    },
    Decomposition {
        kanji: '瘴',
        radicals: &['音', '十', '日', '立', '曰', '⽧'],
    },
    Decomposition {
        kanji: '瘰',
        radicals: &['糸', '幺', '小', '田', '⽧'],
    },
    Decomposition {
        kanji: '瘻',
        radicals: &['｜', '一', '口', '女', '⽧'],
    },
    Decomposition {
        kanji: '癇',
        radicals: &['日', '門', '⽧'],
    },
    Decomposition {
        kanji: '癈',
        radicals: &['二', '儿', '⽧', '癶'],
    },
    Decomposition {
        kanji: '癆',
        radicals: &['火', '力', '冖', '⽧'],
    },
    Decomposition {
        kanji: '癜',
        radicals: &['ハ', '尸', '殳', '⽧', '几', '又'],
    },
    Decomposition {
        kanji: '癘',
        radicals: &['田', '⽧', '⽱', '⺾'],
    },
    Decomposition {
        kanji: '癡',
        radicals: &['疋', '矢', '匕', '⽧', '𠂉'],
    },
    Decomposition {
        kanji: '癢',
        radicals: &['王', '食', '丷', '羊', '⽧'],
    },
    Decomposition {
        kanji: '癨',
        radicals: &['雨', '⽧', '隹'],
    },
    Decomposition {
        kanji: '癩',
        radicals: &['貝', '目', 'ハ', '口', '頁', '木', '⽧'],
    },
    Decomposition {
        kanji: '癪',
        radicals: &['禾', '貝', '目', 'ハ', '土', '二', '亠', '⽧'],
    },
    Decomposition {
        kanji: '癧',
        radicals: &['止', '木', '厂', '⽧'],
    },
    Decomposition {
        kanji: '癬',
        radicals: &['王', '丷', '羊', '⽧', '魚', '田', '⺣'],
    },
    Decomposition {
        kanji: '癰',
        radicals: &['口', '巛', '巴', '⽧', '隹'],
    },
    Decomposition {
        kanji: '癲',
        radicals: &['貝', '十', 'ハ', '頁', '目', '⽧'],
    },
    Decomposition {
        kanji: '癶',
        radicals: &['癶'],
    },
    Decomposition {
        kanji: '癸',
        radicals: &['大', '二', '癶', '一'],
    },
    Decomposition {
        kanji: '發',
        radicals: &['弓', '殳', '癶', '几', '又'],
    },
    Decomposition {
        kanji: '皀',
        radicals: &['白', '匕'],
    },
    Decomposition {
        kanji: '皃',
        radicals: &['白', '儿'],
    },
    Decomposition {
        kanji: '皈',
        radicals: &['白', '又', '厂'],
    },
    Decomposition {
        kanji: '皋',
        radicals: &['十', '大', '白'],
    },
    Decomposition {
        kanji: '皎',
        radicals: &['白', '父', '亠'],
    },
    Decomposition {
        kanji: '皖',
        radicals: &['二', '白', '儿', '宀', '元'],
    },
    Decomposition {
        kanji: '皓',
        radicals: &['ノ', '口', '土', '白'],
    },
    Decomposition {
        kanji: '皙',
        radicals: &['斤', '白', '木'],
    },
    Decomposition {
        kanji: '皚',
        radicals: &['口', '山', '豆', '白', '丷'],
    },
    Decomposition {
        kanji: '皰',
        radicals: &['皮', '又', '勹', '已'],
    },
    Decomposition {
        kanji: '皴',
        radicals: &['皮', '又', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '皸',
        radicals: &['車', '皮', '又', '冖'],
    },
    Decomposition {
        kanji: '皹',
        radicals: &['車', '皮', '又', '冖'],
    },
    Decomposition {
        kanji: '皺',
        radicals: &['皮', '又', '勹', '屮'],
    },
    Decomposition {
        kanji: '盂',
        radicals: &['皿', '二', '亅'],
    },
    Decomposition {
        kanji: '盍',
        radicals: &['皿', '土', '厶'],
    },
    Decomposition {
        kanji: '盖',
        radicals: &['王', '皿', '丷', '羊'],
    },
    Decomposition {
        kanji: '盒',
        radicals: &['口', '皿', '𠆢', '一'],
    },
    Decomposition {
        kanji: '盞',
        radicals: &['皿', '戈'],
    },
    Decomposition {
        kanji: '盡',
        radicals: &['ヨ', '皿', '聿'],
    },
    Decomposition {
        kanji: '盥',
        radicals: &['臼', '皿', '水'],
    },
    Decomposition {
        kanji: '盧',
        radicals: &['皿', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '盪',
        radicals: &['ノ', '皿', '⺡', '日', '勹', '一'],
    },
    Decomposition {
        kanji: '蘯',
        radicals: &['ノ', '皿', '⺡', '日', '勹', '⺾', '一'],
    },
    Decomposition {
        kanji: '盻',
        radicals: &['ハ', '目', '一', '勹'],
    },
    Decomposition {
        kanji: '眈',
        radicals: &['目', '尢', '冖'],
    },
    Decomposition {
        kanji: '眇',
        radicals: &['ノ', '小', '目'],
    },
    Decomposition {
        kanji: '眄',
        radicals: &['目', '一', '山', '亅'],
    },
    Decomposition {
        kanji: '眩',
        radicals: &['玄', '目', '亠', '幺'],
    },
    Decomposition {
        kanji: '眤',
        radicals: &['目', '匕', '尸'],
    },
    Decomposition {
        kanji: '眞',
        radicals: &['ハ', '目', '匕'],
    },
    Decomposition {
        kanji: '眥',
        radicals: &['止', '目', '匕'],
    },
    Decomposition {
        kanji: '眦',
        radicals: &['止', '目', '匕'],
    },
    Decomposition {
        kanji: '眛',
        radicals: &['｜', '二', 'ハ', '木', '目'],
    },
    Decomposition {
        kanji: '眷',
        radicals: &['人', '大', '二', '丷', '目'],
    },
    Decomposition {
        kanji: '眸',
        radicals: &['牛', '目', '厶'],
    },
    Decomposition {
        kanji: '睇',
        radicals: &['｜', 'ノ', '弓', '丷', '目'],
    },
    Decomposition {
        kanji: '睚',
        radicals: &['土', '目', '厂'],
    },
    Decomposition {
        kanji: '睨',
        radicals: &['臼', '目', '儿'],
    },
    Decomposition {
        kanji: '睫',
        radicals: &['｜', 'ヨ', '走', '土', '目'],
    },
    Decomposition {
        kanji: '睛',
        radicals: &['月', '青', '土', '二', '目', '亠'],
    },
    Decomposition {
        kanji: '睥',
        radicals: &['十', '田', '目'],
    },
    Decomposition {
        kanji: '睿',
        radicals: &['ハ', '卜', '目', '𠆢', '冖'],
    },
    Decomposition {
        kanji: '睾',
        radicals: &['十', '辛', '土', '⺲', '目', '立', '亠'],
    },
    Decomposition {
        kanji: '睹',
        radicals: &['日', '目', '⺹'],
    },
    Decomposition {
        kanji: '瞎',
        radicals: &['口', '土', '二', '目', '亠', '宀'],
    },
    Decomposition {
        kanji: '瞋',
        radicals: &['十', 'ハ', '目'],
    },
    Decomposition {
        kanji: '瞑',
        radicals: &['日', 'ハ', '目', '亠', '冖'],
    },
    Decomposition {
        kanji: '瞠',
        radicals: &['口', '⺌', '土', '目', '冖'],
    },
    Decomposition {
        kanji: '瞞',
        radicals: &['｜', '一', '入', '目', '冂', '凵'],
    },
    Decomposition {
        kanji: '瞰',
        radicals: &['耳', '目', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '瞶',
        radicals: &['｜', '一', '貝', 'ハ', '口', '目'],
    },
    Decomposition {
        kanji: '瞹',
        radicals: &['心', '爪', '目', '冖', '夂'],
    },
    Decomposition {
        kanji: '瞿',
        radicals: &['目', '隹'],
    },
    Decomposition {
        kanji: '瞼',
        radicals: &['口', '人', '目', '𠆢', '一'],
    },
    Decomposition {
        kanji: '瞽',
        radicals: &['口', '士', '支', '十', '豆', '丷', '目', '又', '鼓'],
    },
    Decomposition {
        kanji: '瞻',
        radicals: &['言', '目', '儿', '厂', '勹'],
    },
    Decomposition {
        kanji: '矇',
        radicals: &['目', '冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '矍',
        radicals: &['又', '目', '隹'],
    },
    Decomposition {
        kanji: '矗',
        radicals: &['十', '目', '｜', '一'],
    },
    Decomposition {
        kanji: '矚',
        radicals: &['虫', '⺲', '目', '勹', '尸'],
    },
    Decomposition {
        kanji: '矜',
        radicals: &['矛', '𠆢', 'マ', '一'],
    },
    Decomposition {
        kanji: '矣',
        radicals: &['矢', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '矮',
        radicals: &['禾', '女', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '矼',
        radicals: &['口', '工', '石'],
    },
    Decomposition {
        kanji: '砌',
        radicals: &['口', '石', '刀', '匕'],
    },
    Decomposition {
        kanji: '砒',
        radicals: &['口', '石', '比'],
    },
    Decomposition {
        kanji: '礦',
        radicals: &['黄', '口', '石', '田', 'ハ', '广'],
    },
    Decomposition {
        kanji: '砠',
        radicals: &['口', '石', '目'],
    },
    Decomposition {
        kanji: '礪',
        radicals: &['口', '石', '田', '厂', '⽱', '⺾'],
    },
    Decomposition {
        kanji: '硅',
        radicals: &['口', '石', '土'],
    },
    Decomposition {
        kanji: '碎',
        radicals: &['口', '十', '人', '石', '亠'],
    },
    Decomposition {
        kanji: '硴',
        radicals: &['⺅', '口', '石', '匕', '⺾'],
    },
    Decomposition {
        kanji: '碆',
        radicals: &['口', '⺡', '石', '皮', '又'],
    },
    Decomposition {
        kanji: '硼',
        radicals: &['月', '口', '石'],
    },
    Decomposition {
        kanji: '碚',
        radicals: &['口', '石', '立'],
    },
    Decomposition {
        kanji: '碌',
        radicals: &['ヨ', '口', '水', '石', '隶'],
    },
    Decomposition {
        kanji: '碣',
        radicals: &['口', '石', '日', '勹', '匕', '人', '一', '｜'],
    },
    Decomposition {
        kanji: '碵',
        radicals: &['貝', '目', 'ハ', '口', '石', '卜'],
    },
    Decomposition {
        kanji: '碪',
        radicals: &['甘', '口', '石', '儿', '匚'],
    },
    Decomposition {
        kanji: '碯',
        radicals: &['口', '石', '巛', '囗'],
    },
    Decomposition {
        kanji: '磑',
        radicals: &['口', '山', '石', '豆', '丷'],
    },
    Decomposition {
        kanji: '磆',
        radicals: &['月', '口', '骨', '石', '冂', '冖'],
    },
    Decomposition {
        kanji: '磋',
        radicals: &['王', '口', '工', '石', '丷', '羊'],
    },
    Decomposition {
        kanji: '磔',
        radicals: &['口', '石', '舛', '木', '夕'],
    },
    Decomposition {
        kanji: '碾',
        radicals: &['衣', '口', '石', '二', '尸'],
    },
    Decomposition {
        kanji: '碼',
        radicals: &['口', '石', '馬', '⺣'],
    },
    Decomposition {
        kanji: '磅',
        radicals: &['口', '石', '丷', '方', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '磊',
        radicals: &['口', '石'],
    },
    Decomposition {
        kanji: '磬',
        radicals: &['口', '士', '石', '殳', '尸', '几', '又'],
    },
    Decomposition {
        kanji: '磧',
        radicals: &['貝', '目', 'ハ', '口', '石', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '磚',
        radicals: &['口', '十', '寸', '石', '虫', '田', '亠', '厶'],
    },
    Decomposition {
        kanji: '磽',
        radicals: &['口', '石', '土', '儿'],
    },
    Decomposition {
        kanji: '磴',
        radicals: &['口', '石', '豆', '丷', '癶'],
    },
    Decomposition {
        kanji: '礇',
        radicals: &['口', '石', '大', '米', '冂', '釆'],
    },
    Decomposition {
        kanji: '礒',
        radicals: &['王', '口', '石', '丷', '羊', '亅', '戈'],
    },
    Decomposition {
        kanji: '礑',
        radicals: &['口', '⺌', '石', '田', '冖'],
    },
    Decomposition {
        kanji: '礙',
        radicals: &['口', '石', '疋', '矢', '匕', 'マ', '𠂉'],
    },
    Decomposition {
        kanji: '礬',
        radicals: &['口', '石', '大', '木', '爻'],
    },
    Decomposition {
        kanji: '礫',
        radicals: &['口', '石', '白', '木', '冫'],
    },
    Decomposition {
        kanji: '祀',
        radicals: &['⺭', '已'],
    },
    Decomposition {
        kanji: '祠',
        radicals: &['口', '⺭', '亅', '一'],
    },
    Decomposition {
        kanji: '祗',
        radicals: &['氏', '⺭', '一'],
    },
    Decomposition {
        kanji: '祟',
        radicals: &['｜', '山', '示', '二', '小'],
    },
    Decomposition {
        kanji: '祚',
        radicals: &['｜', 'ノ', '⺭'],
    },
    Decomposition {
        kanji: '祕',
        radicals: &['ノ', '心', '⺭', '丶'],
    },
    Decomposition {
        kanji: '祓',
        radicals: &['ノ', '一', '⺭', '丶'],
    },
    Decomposition {
        kanji: '祺',
        radicals: &['甘', 'ハ', '⺭'],
    },
    Decomposition {
        kanji: '祿',
        radicals: &['水', '⺭', '隶', '彑'],
    },
    Decomposition {
        kanji: '禊',
        radicals: &['大', '土', '⺭', '亠', '刀', '二'],
    },
    Decomposition {
        kanji: '禝',
        radicals: &['田', '⺭', '儿', '夂'],
    },
    Decomposition {
        kanji: '禧',
        radicals: &['口', '士', '十', '豆', '丷', '⺭'],
    },
    Decomposition {
        kanji: '齋',
        radicals: &['小', '齊', '元', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '禪',
        radicals: &['｜', '一', '口', '田', '日', '⺭'],
    },
    Decomposition {
        kanji: '禮',
        radicals: &['｜', '一', '口', '豆', '日', '丷', '⺭'],
    },
    Decomposition {
        kanji: '禳',
        radicals: &['｜', '衣', '一', 'ハ', '⺭', '亠', '口'],
    },
    Decomposition {
        kanji: '禹',
        radicals: &['ノ', '虫', '⽱', '冂'],
    },
    Decomposition {
        kanji: '禺',
        radicals: &['田', '日', '⽱', '冂'],
    },
    Decomposition {
        kanji: '秉',
        radicals: &['｜', 'ノ', 'ヨ', '一', '禾', 'ハ'],
    },
    Decomposition {
        kanji: '秕',
        radicals: &['禾', '比'],
    },
    Decomposition {
        kanji: '秧',
        radicals: &['禾', '人', '大', '冂', '冖'],
    },
    Decomposition {
        kanji: '秬',
        radicals: &['禾', '巨'],
    },
    Decomposition {
        kanji: '秡',
        radicals: &['ノ', '一', '禾', '丶'],
    },
    Decomposition {
        kanji: '秣',
        radicals: &['｜', '一', '禾', 'ハ', '木', '亠'],
    },
    Decomposition {
        kanji: '稈',
        radicals: &['禾', '干', '日'],
    },
    Decomposition {
        kanji: '稍',
        radicals: &['禾', '月', '⺌'],
    },
    Decomposition {
        kanji: '稘',
        radicals: &['禾', '甘', 'ハ'],
    },
    Decomposition {
        kanji: '稙',
        radicals: &['禾', '十', '目'],
    },
    Decomposition {
        kanji: '稠',
        radicals: &['禾', '口', '土', '冂'],
    },
    Decomposition {
        kanji: '稟',
        radicals: &['禾', '口', '亠', '囗'],
    },
    Decomposition {
        kanji: '禀',
        radicals: &['口', '示', '二', '小', '亠', '囗'],
    },
    Decomposition {
        kanji: '稱',
        radicals: &['｜', '一', '禾', '爪', '冂', '十'],
    },
    Decomposition {
        kanji: '稻',
        radicals: &['臼', '禾', '爪'],
    },
    Decomposition {
        kanji: '稾',
        radicals: &['禾', '口', '高', '亠', '冂'],
    },
    Decomposition {
        kanji: '稷',
        radicals: &['禾', '田', '儿', '夂'],
    },
    Decomposition {
        kanji: '穃',
        radicals: &['禾', '穴', '口', 'ハ', '𠆢', '宀', '谷'],
    },
    Decomposition {
        kanji: '穗',
        radicals: &['禾', '心', '虫', '日'],
    },
    Decomposition {
        kanji: '穉',
        radicals: &['禾', '牛', '尸'],
    },
    Decomposition {
        kanji: '穡',
        radicals: &['禾', '口', '人', '土', '囗'],
    },
    Decomposition {
        kanji: '穢',
        radicals: &['ノ', '禾', '止', '小', '戈'],
    },
    Decomposition {
        kanji: '穩',
        radicals: &['ヨ', '禾', '工', '心', '爪'],
    },
    Decomposition {
        kanji: '龝',
        radicals: &['禾', '亀', '乙', '勹', '田'],
    },
    Decomposition {
        kanji: '穰',
        radicals: &['｜', '衣', '一', '禾', '口', '亠'],
    },
    Decomposition {
        kanji: '穹',
        radicals: &['弓', '穴', '儿', '宀'],
    },
    Decomposition {
        kanji: '穽',
        radicals: &['｜', 'ノ', '穴', '二', '儿', '宀', '井'],
    },
    Decomposition {
        kanji: '窈',
        radicals: &['穴', '力', '儿', '宀', '幺'],
    },
    Decomposition {
        kanji: '窗',
        radicals: &['穴', '儿', '囗', '宀', '夕'],
    },
    Decomposition {
        kanji: '窕',
        radicals: &['穴', '儿', '冫', '宀'],
    },
    Decomposition {
        kanji: '窘',
        radicals: &['ノ', 'ヨ', '一', '穴', '口', '儿', '宀'],
    },
    Decomposition {
        kanji: '窖',
        radicals: &['ノ', '穴', '口', '土', '儿', '宀'],
    },
    Decomposition {
        kanji: '窩',
        radicals: &['穴', '口', '入', '冂', '宀'],
    },
    Decomposition {
        kanji: '竈',
        radicals: &['穴', '土', '儿', '宀', '黽'],
    },
    Decomposition {
        kanji: '窰',
        radicals: &['缶', '穴', '夕', '儿', '凵', '宀'],
    },
    Decomposition {
        kanji: '窶',
        radicals: &['｜', '一', '穴', '口', '女', '儿', '宀'],
    },
    Decomposition {
        kanji: '竅',
        radicals: &['穴', '白', '方', '儿', '宀', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '竄',
        radicals: &['臼', '穴', '鼠', '儿', '宀'],
    },
    Decomposition {
        kanji: '窿',
        radicals: &['穴', '生', '儿', '夂', '宀', '⻖'],
    },
    Decomposition {
        kanji: '邃',
        radicals: &['穴', '⻌', '丷', '儿', '宀', '豕'],
    },
    Decomposition {
        kanji: '竇',
        radicals: &['貝', '目', 'ハ', '穴', '士', '儿', '冂', '宀'],
    },
    Decomposition {
        kanji: '竊',
        radicals: &['穴', '釆', '米', '卜', '儿', '冂', '厶', '宀', '⽱'],
    },
    Decomposition {
        kanji: '竍',
        radicals: &['十', '立'],
    },
    Decomposition {
        kanji: '竏',
        radicals: &['ノ', '十', '立'],
    },
    Decomposition {
        kanji: '竕',
        radicals: &['刀', '丷', '立'],
    },
    Decomposition {
        kanji: '竓',
        radicals: &['毛', '立'],
    },
    Decomposition {
        kanji: '站',
        radicals: &['口', '卜', '立'],
    },
    Decomposition {
        kanji: '竚',
        radicals: &['立', '亅', '宀'],
    },
    Decomposition {
        kanji: '竝',
        radicals: &['立'],
    },
    Decomposition {
        kanji: '竡',
        radicals: &['一', '白', '立'],
    },
    Decomposition {
        kanji: '竢',
        radicals: &['矢', '立', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '竦',
        radicals: &['｜', '口', '丷', '木', '立'],
    },
    Decomposition {
        kanji: '竭',
        radicals: &['日', '立', '勹', '匕'],
    },
    Decomposition {
        kanji: '竰',
        radicals: &['里', '立', '厂'],
    },
    Decomposition {
        kanji: '笂',
        radicals: &['九', '竹', '丶', '𠂉'],
    },
    Decomposition {
        kanji: '笏',
        radicals: &['ノ', '竹', '勹', '勿', '𠂉'],
    },
    Decomposition {
        kanji: '笊',
        radicals: &['竹', '爪', '𠂉'],
    },
    Decomposition {
        kanji: '笆',
        radicals: &['竹', '巴', '𠂉'],
    },
    Decomposition {
        kanji: '笳',
        radicals: &['口', '竹', '力', '𠂉'],
    },
    Decomposition {
        kanji: '笘',
        radicals: &['口', '竹', '卜', '𠂉'],
    },
    Decomposition {
        kanji: '笙',
        radicals: &['生', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '笞',
        radicals: &['口', '竹', '厶', '𠂉'],
    },
    Decomposition {
        kanji: '笵',
        radicals: &['⺡', '竹', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '笨',
        radicals: &['一', '竹', '木', '𠂉'],
    },
    Decomposition {
        kanji: '笶',
        radicals: &['竹', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '筐',
        radicals: &['王', '竹', '匚', '𠂉'],
    },
    Decomposition {
        kanji: '筺',
        radicals: &['王', '竹', '匚', '丶', '𠂉'],
    },
    Decomposition {
        kanji: '笄',
        radicals: &['｜', 'ノ', '竹', '二', '廾', '一', '𠂉'],
    },
    Decomposition {
        kanji: '筍',
        radicals: &['竹', '日', '勹', '𠂉'],
    },
    Decomposition {
        kanji: '笋',
        radicals: &['ノ', 'ヨ', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '筌',
        radicals: &['王', '竹', '𠆢', '𠂉'],
    },
    Decomposition {
        kanji: '筅',
        radicals: &['竹', '土', '儿', '𠂉'],
    },
    Decomposition {
        kanji: '筵',
        radicals: &['止', '竹', '廴', 'ノ', '𠂉'],
    },
    Decomposition {
        kanji: '筥',
        radicals: &['口', '竹', 'ノ', '𠂉'],
    },
    Decomposition {
        kanji: '筴',
        radicals: &['人', '大', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '筧',
        radicals: &['見', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '筰',
        radicals: &['｜', 'ノ', '⺅', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '筱',
        radicals: &['⺅', '竹', '攵', '｜', '𠂉'],
    },
    Decomposition {
        kanji: '筬',
        radicals: &['ノ', '竹', '戈', '𠂉'],
    },
    Decomposition {
        kanji: '筮',
        radicals: &['工', '人', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '箝',
        radicals: &['甘', '竹', '扌', '𠂉'],
    },
    Decomposition {
        kanji: '箘',
        radicals: &['禾', '竹', '囗', '𠂉'],
    },
    Decomposition {
        kanji: '箟',
        radicals: &['竹', '日', '比', '𠂉'],
    },
    Decomposition {
        kanji: '箍',
        radicals: &['巾', '竹', '匚', '扌', '𠂉'],
    },
    Decomposition {
        kanji: '箜',
        radicals: &['穴', '工', '竹', '儿', '宀', '𠂉'],
    },
    Decomposition {
        kanji: '箚',
        radicals: &['⺉', '口', '竹', '𠆢', '一', '𠂉'],
    },
    Decomposition {
        kanji: '箋',
        radicals: &['竹', '戈', '𠂉'],
    },
    Decomposition {
        kanji: '箒',
        radicals: &['ヨ', '巾', '竹', '冖', '𠂉'],
    },
    Decomposition {
        kanji: '箏',
        radicals: &['ヨ', '竹', '爪', '亅', '𠂉'],
    },
    Decomposition {
        kanji: '筝',
        radicals: &['ヨ', '竹', '亅', '勹', '𠂉'],
    },
    Decomposition {
        kanji: '箙',
        radicals: &['月', '竹', '又', '卩', '𠂉'],
    },
    Decomposition {
        kanji: '篋',
        radicals: &['人', '大', '竹', '匚', '𠂉'],
    },
    Decomposition {
        kanji: '篁',
        radicals: &['王', '竹', '白', '𠂉'],
    },
    Decomposition {
        kanji: '篌',
        radicals: &['⺅', '竹', '矢', 'ユ', '𠂉'],
    },
    Decomposition {
        kanji: '篏',
        radicals: &['甘', '欠', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '箴',
        radicals: &['ノ', '口', '竹', '戈', '𠂉'],
    },
    Decomposition {
        kanji: '篆',
        radicals: &['彑', '竹', '豕', '𠂉'],
    },
    Decomposition {
        kanji: '篝',
        radicals: &['｜', '一', '竹', '二', '冂', '十', '𠂉'],
    },
    Decomposition {
        kanji: '篩',
        radicals: &['巾', '口', '竹', '｜', '𠂉'],
    },
    Decomposition {
        kanji: '簑',
        radicals: &['衣', '一', '竹', '亠', '口', '𠂉'],
    },
    Decomposition {
        kanji: '簔',
        radicals: &['衣', '一', '竹', '亠', '口', '𠂉'],
    },
    Decomposition {
        kanji: '篦',
        radicals: &['竹', '比', '囗', '𠂉'],
    },
    Decomposition {
        kanji: '篥',
        radicals: &['西', '竹', '木', '𠂉'],
    },
    Decomposition {
        kanji: '籠',
        radicals: &['月', '竹', '立', '𠂉'],
    },
    Decomposition {
        kanji: '簀',
        radicals: &['貝', '目', 'ハ', '竹', '土', '二', '亠', '𠂉'],
    },
    Decomposition {
        kanji: '簇',
        radicals: &['竹', '方', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '簓',
        radicals: &['口', '十', '竹', '冂', '彡', '𠂉'],
    },
    Decomposition {
        kanji: '篳',
        radicals: &['｜', '一', '竹', '田', '日', '𠂉'],
    },
    Decomposition {
        kanji: '篷',
        radicals: &['⻌', '竹', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '簗',
        radicals: &['⺡', '竹', '刀', '木', '丶', '𠂉'],
    },
    Decomposition {
        kanji: '簍',
        radicals: &['｜', '一', '口', '女', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '篶',
        radicals: &['一', '止', '竹', '鳥', '⺣', '𠂉'],
    },
    Decomposition {
        kanji: '簣',
        radicals: &['｜', '一', '貝', '目', 'ハ', '口', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '簧',
        radicals: &['黄', '竹', '田', 'ハ', '𠂉'],
    },
    Decomposition {
        kanji: '簪',
        radicals: &['竹', '日', '无', '𠂉'],
    },
    Decomposition {
        kanji: '簟',
        radicals: &['十', '西', '竹', '日', '曰', '𠂉'],
    },
    Decomposition {
        kanji: '簷',
        radicals: &['言', '竹', '儿', '厂', '𠂉'],
    },
    Decomposition {
        kanji: '簫',
        radicals: &['｜', 'ノ', 'ヨ', '水', '竹', '隶', '聿', '𠂉'],
    },
    Decomposition {
        kanji: '簽',
        radicals: &['口', '人', '竹', '𠆢', '一', '𠂉'],
    },
    Decomposition {
        kanji: '籌',
        radicals: &['口', '工', '士', '寸', '竹', '𠂉'],
    },
    Decomposition {
        kanji: '籃',
        radicals: &['皿', '臣', '竹', '二', '𠂉'],
    },
    Decomposition {
        kanji: '籔',
        radicals: &['女', '竹', '米', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '籏',
        radicals: &['甘', '竹', 'ハ', '方', '𠂉'],
    },
    Decomposition {
        kanji: '籀',
        radicals: &['竹', '田', '刀', '厶', '扌', '𠂉'],
    },
    Decomposition {
        kanji: '籐',
        radicals: &['月', '人', '水', '大', '竹', '二', '丷', '𠂉'],
    },
    Decomposition {
        kanji: '籘',
        radicals: &['月', '糸', '幺', '小', '人', '大', '竹', '二', '丷', '𠂉'],
    },
    Decomposition {
        kanji: '籟',
        radicals: &['｜', '貝', '目', '口', '竹', 'ハ', '頁', '木', '𠂉'],
    },
    Decomposition {
        kanji: '籤',
        radicals: &['竹', '戈', '韭', '人', '𠂉'],
    },
    Decomposition {
        kanji: '籖',
        radicals: &['竹', '土', '戈', '韭', '𠂉'],
    },
    Decomposition {
        kanji: '籥',
        radicals: &['｜', '一', '口', '竹', '𠆢', '冊', '龠', '廾', '𠂉'],
    },
    Decomposition {
        kanji: '籬',
        radicals: &['竹', '亠', '凵', '⽱', '隹', '𠂉'],
    },
    Decomposition {
        kanji: '籵',
        radicals: &['十', '米'],
    },
    Decomposition {
        kanji: '粃',
        radicals: &['比', '米'],
    },
    Decomposition {
        kanji: '粐',
        radicals: &['戸', '米', '一', '尸'],
    },
    Decomposition {
        kanji: '粤',
        radicals: &['一', '米', '囗', '勹', '釆'],
    },
    Decomposition {
        kanji: '粭',
        radicals: &['口', '米', '𠆢', '一'],
    },
    Decomposition {
        kanji: '粢',
        radicals: &['欠', '米', '冫'],
    },
    Decomposition {
        kanji: '粫',
        radicals: &['而', '米'],
    },
    Decomposition {
        kanji: '粡',
        radicals: &['口', '米', '冂', '一'],
    },
    Decomposition {
        kanji: '粨',
        radicals: &['米', '一', '白'],
    },
    Decomposition {
        kanji: '粳',
        radicals: &['ノ', '米', '一', '田'],
    },
    Decomposition {
        kanji: '粲',
        radicals: &['米', '卜', '又', '夕'],
    },
    Decomposition {
        kanji: '粱',
        radicals: &['⺡', '刀', '丷', '米'],
    },
    Decomposition {
        kanji: '粮',
        radicals: &['艮', '米'],
    },
    Decomposition {
        kanji: '粹',
        radicals: &['十', '人', '米', '亠'],
    },
    Decomposition {
        kanji: '粽',
        radicals: &['示', '二', '小', '米', '宀'],
    },
    Decomposition {
        kanji: '糀',
        radicals: &['⺅', '米', '匕', '⺾'],
    },
    Decomposition {
        kanji: '糅',
        radicals: &['米', '矛', '木', 'マ'],
    },
    Decomposition {
        kanji: '糂',
        radicals: &['甘', '米', '儿', '匚'],
    },
    Decomposition {
        kanji: '糘',
        radicals: &['米', '宀', '豕'],
    },
    Decomposition {
        kanji: '糒',
        radicals: &['米', '用', '厂', '⺾'],
    },
    Decomposition {
        kanji: '糜',
        radicals: &['米', '木', '广', '麻'],
    },
    Decomposition {
        kanji: '糢',
        radicals: &['大', '日', '米', '⺾'],
    },
    Decomposition {
        kanji: '鬻',
        radicals: &['一', '弓', '口', '米', '儿', '冂', '鬲'],
    },
    Decomposition {
        kanji: '糯',
        radicals: &['雨', '而', '米'],
    },
    Decomposition {
        kanji: '糲',
        radicals: &['田', '米', '厂', '⽱', '⺾'],
    },
    Decomposition {
        kanji: '糴',
        radicals: &['ヨ', '入', '米', '隹'],
    },
    Decomposition {
        kanji: '糶',
        radicals: &['｜', 'ヨ', '山', '米', '隹'],
    },
    Decomposition {
        kanji: '糺',
        radicals: &['乙', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '紆',
        radicals: &['糸', '幺', '小', '二', '亅'],
    },
    Decomposition {
        kanji: '紂',
        radicals: &['糸', '幺', '小', '寸'],
    },
    Decomposition {
        kanji: '紜',
        radicals: &['糸', '幺', '小', '二', '厶'],
    },
    Decomposition {
        kanji: '紕',
        radicals: &['糸', '幺', '小', '比'],
    },
    Decomposition {
        kanji: '紊',
        radicals: &['糸', '幺', '小', '文'],
    },
    Decomposition {
        kanji: '絅',
        radicals: &['口', '糸', '幺', '小', '冂'],
    },
    Decomposition {
        kanji: '絋',
        radicals: &['糸', '幺', '小', '厶', '广'],
    },
    Decomposition {
        kanji: '紮',
        radicals: &['乙', '糸', '幺', '小', '木'],
    },
    Decomposition {
        kanji: '紲',
        radicals: &['糸', '幺', '小', '世'],
    },
    Decomposition {
        kanji: '紿',
        radicals: &['口', '糸', '幺', '小', '厶'],
    },
    Decomposition {
        kanji: '紵',
        radicals: &['糸', '幺', '小', '亅', '宀'],
    },
    Decomposition {
        kanji: '絆',
        radicals: &['｜', '糸', '幺', '小', '二', '丷', '十'],
    },
    Decomposition {
        kanji: '絳',
        radicals: &['糸', '幺', '小', '二', '夂'],
    },
    Decomposition {
        kanji: '絖',
        radicals: &['糸', '幺', '小', '⺌', '儿'],
    },
    Decomposition {
        kanji: '絎',
        radicals: &['行', '糸', '幺', '小', '彳'],
    },
    Decomposition {
        kanji: '絲',
        radicals: &['糸', '幺', '小'],
    },
    Decomposition {
        kanji: '絨',
        radicals: &['ノ', '一', '糸', '幺', '小', '戈'],
    },
    Decomposition {
        kanji: '絮',
        radicals: &['口', '糸', '幺', '小', '女'],
    },
    Decomposition {
        kanji: '絏',
        radicals: &['ノ', '糸', '幺', '小', '日'],
    },
    Decomposition {
        kanji: '絣',
        radicals: &['｜', 'ノ', '糸', '幺', '小', '二', '丷', '廾', '一'],
    },
    Decomposition {
        kanji: '經',
        radicals: &['工', '糸', '幺', '小', '巛'],
    },
    Decomposition {
        kanji: '綉',
        radicals: &['乃', '禾', '糸', '幺', '小', 'ノ'],
    },
    Decomposition {
        kanji: '絛',
        radicals: &['⺅', '糸', '幺', '小', '夂', '攵', '𠂉', '｜'],
    },
    Decomposition {
        kanji: '綏',
        radicals: &['糸', '幺', '小', '女', '爪'],
    },
    Decomposition {
        kanji: '絽',
        radicals: &['口', '糸', '幺', '小', 'ノ'],
    },
    Decomposition {
        kanji: '綛',
        radicals: &['丶', '糸', '幺', '小', '心', '刀'],
    },
    Decomposition {
        kanji: '綺',
        radicals: &['口', '糸', '幺', '小', '大', '亅', '一'],
    },
    Decomposition {
        kanji: '綮',
        radicals: &['戸', '糸', '幺', '小', '攵', '一', '尸', '𠂉'],
    },
    Decomposition {
        kanji: '綣',
        radicals: &['糸', '幺', '小', '人', '大', '二', '丷', '已'],
    },
    Decomposition {
        kanji: '綵',
        radicals: &['糸', '幺', '小', '爪', '木'],
    },
    Decomposition {
        kanji: '緇',
        radicals: &['糸', '幺', '小', '巛', '田'],
    },
    Decomposition {
        kanji: '綽',
        radicals: &['糸', '幺', '小', '十', '日', '卜'],
    },
    Decomposition {
        kanji: '綫',
        radicals: &['糸', '幺', '小', '戈'],
    },
    Decomposition {
        kanji: '總',
        radicals: &['糸', '幺', '小', '心', '囗', '夂'],
    },
    Decomposition {
        kanji: '綢',
        radicals: &['口', '糸', '幺', '小', '土', '冂'],
    },
    Decomposition {
        kanji: '綯',
        radicals: &['缶', '糸', '幺', '小', '凵', '勹'],
    },
    Decomposition {
        kanji: '緜',
        radicals: &['ノ', '巾', '糸', '幺', '小', '白'],
    },
    Decomposition {
        kanji: '綸',
        radicals: &['｜', '一', '糸', '幺', '小', '𠆢', '冊', '廾'],
    },
    Decomposition {
        kanji: '綟',
        radicals: &['戸', '糸', '幺', '小', '大', '一', '尸'],
    },
    Decomposition {
        kanji: '綰',
        radicals: &['｜', '口', '糸', '幺', '小', '宀'],
    },
    Decomposition {
        kanji: '緘',
        radicals: &['ノ', '口', '糸', '幺', '小', '戈'],
    },
    Decomposition {
        kanji: '緝',
        radicals: &['口', '糸', '幺', '小', '耳'],
    },
    Decomposition {
        kanji: '緤',
        radicals: &['糸', '幺', '小', '木', '世'],
    },
    Decomposition {
        kanji: '緞',
        radicals: &['｜', '糸', '幺', '小', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '緻',
        radicals: &['糸', '幺', '小', '至', '土', '厶', '攵', '一', '𠂉'],
    },
    Decomposition {
        kanji: '緲',
        radicals: &['ノ', '糸', '幺', '小', '目'],
    },
    Decomposition {
        kanji: '緡',
        radicals: &['口', '氏', '糸', '幺', '小', '日', '尸'],
    },
    Decomposition {
        kanji: '縅',
        radicals: &['ノ', '糸', '幺', '小', '女', '戈'],
    },
    Decomposition {
        kanji: '縊',
        radicals: &['皿', '糸', '幺', '小', '丷'],
    },
    Decomposition {
        kanji: '縣',
        radicals: &['糸', '幺', '小', '目', '一', '｜'],
    },
    Decomposition {
        kanji: '縡',
        radicals: &['糸', '幺', '小', '十', '辛', '立', '宀'],
    },
    Decomposition {
        kanji: '縒',
        radicals: &['王', '工', '糸', '幺', '小', '丷', '羊'],
    },
    Decomposition {
        kanji: '縱',
        radicals: &['⺅', '糸', '幺', '小', '人', '走', '土', '彳'],
    },
    Decomposition {
        kanji: '縟',
        radicals: &['糸', '幺', '小', '寸', '辰', '衣'],
    },
    Decomposition {
        kanji: '縉',
        radicals: &['一', '糸', '幺', '小', '二', '日', '厶'],
    },
    Decomposition {
        kanji: '縋',
        radicals: &['｜', '口', '⻌', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '縢',
        radicals: &['月', '糸', '幺', '小', '人', '大', '二', '丷'],
    },
    Decomposition {
        kanji: '繆',
        radicals: &['羽', '糸', '幺', '小', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '繦',
        radicals: &['弓', '糸', '幺', '小', '虫', '厶'],
    },
    Decomposition {
        kanji: '縻',
        radicals: &['糸', '幺', '小', '木', '广', '麻'],
    },
    Decomposition {
        kanji: '縵',
        radicals: &['糸', '幺', '小', '日', '⺲', '又'],
    },
    Decomposition {
        kanji: '縹',
        radicals: &['糸', '幺', '小', '示', '二', '西'],
    },
    Decomposition {
        kanji: '繃',
        radicals: &['月', '山', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '縷',
        radicals: &['｜', '一', '口', '糸', '幺', '小', '女'],
    },
    Decomposition {
        kanji: '縲',
        radicals: &['糸', '幺', '小', '田'],
    },
    Decomposition {
        kanji: '縺',
        radicals: &['⻌', '糸', '幺', '小', '車'],
    },
    Decomposition {
        kanji: '繧',
        radicals: &['雨', '糸', '幺', '小', '二', '厶'],
    },
    Decomposition {
        kanji: '繝',
        radicals: &['糸', '幺', '小', '日', '門'],
    },
    Decomposition {
        kanji: '繖',
        radicals: &['｜', '一', '月', '糸', '幺', '小', '二', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '繞',
        radicals: &['糸', '幺', '小', '土', '儿'],
    },
    Decomposition {
        kanji: '繙',
        radicals: &['糸', '幺', '小', '田', '釆', '米'],
    },
    Decomposition {
        kanji: '繚',
        radicals: &['糸', '幺', '小', '大', '日', '丷', '亠'],
    },
    Decomposition {
        kanji: '繹',
        radicals: &['糸', '幺', '小', '十', '辛', '土', '⺲', '立', '亠'],
    },
    Decomposition {
        kanji: '繪',
        radicals: &['糸', '幺', '小', '日', '⺲', '𠆢', '一'],
    },
    Decomposition {
        kanji: '繩',
        radicals: &['糸', '幺', '小', '黽'],
    },
    Decomposition {
        kanji: '繼',
        radicals: &['｜', '糸', '幺', '小', '匚'],
    },
    Decomposition {
        kanji: '繻',
        radicals: &['雨', '糸', '幺', '小', '而'],
    },
    Decomposition {
        kanji: '纃',
        radicals: &['糸', '幺', '小', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '緕',
        radicals: &['糸', '幺', '小', '斉', '文'],
    },
    Decomposition {
        kanji: '繽',
        radicals: &['ノ', '貝', '目', 'ハ', '糸', '幺', '小', '宀'],
    },
    Decomposition {
        kanji: '辮',
        radicals: &['糸', '幺', '小', '十', '辛', '立'],
    },
    Decomposition {
        kanji: '繿',
        radicals: &['皿', '糸', '幺', '小', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '纈',
        radicals: &['貝', '目', 'ハ', '口', '士', '糸', '幺', '小', '頁'],
    },
    Decomposition {
        kanji: '纉',
        radicals: &['貝', '目', 'ハ', '糸', '幺', '小', '人', '大', '二', '亠'],
    },
    Decomposition {
        kanji: '續',
        radicals: &['貝', '目', 'ハ', '士', '糸', '幺', '小', '儿', '囗'],
    },
    Decomposition {
        kanji: '纒',
        radicals: &['黒', '糸', '幺', '小', '土', '里', '厂', '⺣'],
    },
    Decomposition {
        kanji: '纐',
        radicals: &['貝', '目', 'ハ', '糸', '幺', '小', '父', '頁', '亠'],
    },
    Decomposition {
        kanji: '纓',
        radicals: &['貝', '目', 'ハ', '糸', '幺', '小', '女'],
    },
    Decomposition {
        kanji: '纔',
        radicals: &['糸', '幺', '小', '比', '儿', '勹'],
    },
    Decomposition {
        kanji: '纖',
        radicals: &['糸', '幺', '小', '人', '戈', '韭'],
    },
    Decomposition {
        kanji: '纎',
        radicals: &['糸', '幺', '小', '土', '戈', '韭'],
    },
    Decomposition {
        kanji: '纛',
        radicals: &['糸', '幺', '小', '土', '二', '母', '目', '亠', '毋'],
    },
    Decomposition {
        kanji: '纜',
        radicals: &['見', '糸', '幺', '小', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '缸',
        radicals: &['缶', '工', '凵'],
    },
    Decomposition {
        kanji: '缺',
        radicals: &['ノ', '缶', '人', '大', '二', '凵', 'ユ'],
    },
    Decomposition {
        kanji: '罅',
        radicals: &['缶', '二', '丷', '卜', '亅', '凵', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '罌',
        radicals: &['貝', '目', 'ハ', '缶', '凵'],
    },
    Decomposition {
        kanji: '罍',
        radicals: &['缶', '田', '凵'],
    },
    Decomposition {
        kanji: '罎',
        radicals: &['雨', '缶', '二', '日', '凵', '厶'],
    },
    Decomposition {
        kanji: '罐',
        radicals: &['缶', '口', '凵', '⺾', '隹'],
    },
    Decomposition {
        kanji: '网',
        radicals: &['ノ', '丶', '冂'],
    },
    Decomposition {
        kanji: '罕',
        radicals: &['干', '儿', '冖'],
    },
    Decomposition {
        kanji: '罔',
        radicals: &['亡', '一', '丷', '冂', '亠'],
    },
    Decomposition {
        kanji: '罘',
        radicals: &['｜', 'ノ', '一', '⺲', '丶'],
    },
    Decomposition {
        kanji: '罟',
        radicals: &['口', '士', '⺲'],
    },
    Decomposition {
        kanji: '罠',
        radicals: &['口', '氏', '⺲', '尸'],
    },
    Decomposition {
        kanji: '罨',
        radicals: &['乙', '大', '日', '⺲', '奄'],
    },
    Decomposition {
        kanji: '罩',
        radicals: &['十', '日', '⺲', '卜'],
    },
    Decomposition {
        kanji: '罧',
        radicals: &['⺲', '木'],
    },
    Decomposition {
        kanji: '罸',
        radicals: &['言', '寸', '⺲'],
    },
    Decomposition {
        kanji: '羂',
        radicals: &['月', '口', '糸', '幺', '小', '⺲'],
    },
    Decomposition {
        kanji: '羆',
        radicals: &['月', '⺲', '厶', '匕', '⺣'],
    },
    Decomposition {
        kanji: '羃',
        radicals: &['巾', '大', '日', '⺲', '⺾'],
    },
    Decomposition {
        kanji: '羈',
        radicals: &['革', '馬', '⺲', '⺣'],
    },
    Decomposition {
        kanji: '羇',
        radicals: &['革', '口', '大', '⺲', '亅', '凵'],
    },
    Decomposition {
        kanji: '羌',
        radicals: &['王', '丷', '羊', '儿'],
    },
    Decomposition {
        kanji: '羔',
        radicals: &['王', '丷', '羊', '⺣'],
    },
    Decomposition {
        kanji: '羞',
        radicals: &['ノ', 'ヨ', '王', '丷', '羊'],
    },
    Decomposition {
        kanji: '羝',
        radicals: &['王', '氏', '丷', '羊'],
    },
    Decomposition {
        kanji: '羚',
        radicals: &['王', '丷', '羊', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '羣',
        radicals: &['ノ', 'ヨ', '王', '口', '丷', '羊'],
    },
    Decomposition {
        kanji: '羯',
        radicals: &['王', '日', '丷', '羊', '勹', '匕'],
    },
    Decomposition {
        kanji: '羲',
        radicals: &['王', '禾', '丷', '羊', '戈'],
    },
    Decomposition {
        kanji: '羹',
        radicals: &['王', '大', '丷', '羊', '⺣'],
    },
    Decomposition {
        kanji: '羮',
        radicals: &['王', '人', '大', '丷', '羊', '⺣', '二'],
    },
    Decomposition {
        kanji: '羶',
        radicals: &['王', '口', '日', '丷', '羊', '亠', '囗', '一'],
    },
    Decomposition {
        kanji: '羸',
        radicals: &['王', '亡', '月', '口', '丷', '羊', '丶', '几'],
    },
    Decomposition {
        kanji: '譱',
        radicals: &['王', '言', '丷', '羊'],
    },
    Decomposition {
        kanji: '翅',
        radicals: &['羽', '支', '冫', '又', '十'],
    },
    Decomposition {
        kanji: '翆',
        radicals: &['羽', '九', '十', '冫'],
    },
    Decomposition {
        kanji: '翊',
        radicals: &['羽', '立', '冫'],
    },
    Decomposition {
        kanji: '翕',
        radicals: &['羽', '口', '𠆢', '冫', '一'],
    },
    Decomposition {
        kanji: '翔',
        radicals: &['羽', '丷', '羊', '冫'],
    },
    Decomposition {
        kanji: '翡',
        radicals: &['羽', '非', '冫'],
    },
    Decomposition {
        kanji: '翦',
        radicals: &['一', '羽', '⺉', '月', '丷', '冫'],
    },
    Decomposition {
        kanji: '翩',
        radicals: &['｜', '一', '羽', '戸', '冊', '冫', '尸', '廾'],
    },
    Decomposition {
        kanji: '翳',
        radicals: &['羽', '矢', '冫', '匚', '殳', '几', '又', '𠂉'],
    },
    Decomposition {
        kanji: '翹',
        radicals: &['羽', '土', '儿', '冫'],
    },
    Decomposition {
        kanji: '飜',
        radicals: &['田', '釆', '飛', '米'],
    },
    Decomposition {
        kanji: '耆',
        radicals: &['日', '⺹', '匕'],
    },
    Decomposition {
        kanji: '耄',
        radicals: &['毛', '⺹', '匕'],
    },
    Decomposition {
        kanji: '耋',
        radicals: &['至', '土', '⺹', '厶', '匕'],
    },
    Decomposition {
        kanji: '耒',
        radicals: &['｜', '木', '耒', 'ノ', 'ハ'],
    },
    Decomposition {
        kanji: '耘',
        radicals: &['｜', '二', 'ハ', '木', '厶', '耒', 'ノ'],
    },
    Decomposition {
        kanji: '耙',
        radicals: &['｜', 'ハ', '木', '巴', '耒', 'ノ'],
    },
    Decomposition {
        kanji: '耜',
        radicals: &['｜', '口', '木', '耒', 'ノ', 'ハ'],
    },
    Decomposition {
        kanji: '耡',
        radicals: &['｜', 'ハ', '木', '目', '力', '耒', 'ノ'],
    },
    Decomposition {
        kanji: '耨',
        radicals: &['｜', '寸', '辰', 'ハ', '木', '耒', 'ノ', '衣'],
    },
    Decomposition {
        kanji: '耿',
        radicals: &['火', '耳'],
    },
    Decomposition {
        kanji: '耻',
        radicals: &['止', '耳'],
    },
    Decomposition {
        kanji: '聊',
        radicals: &['耳', '卩'],
    },
    Decomposition {
        kanji: '聆',
        radicals: &['耳', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '聒',
        radicals: &['口', '耳', '舌'],
    },
    Decomposition {
        kanji: '聘',
        radicals: &['｜', '耳', '日', '一', '勹'],
    },
    Decomposition {
        kanji: '聚',
        radicals: &['耳', '又', '冫'],
    },
    Decomposition {
        kanji: '聟',
        radicals: &['口', '耳', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '聢',
        radicals: &['耳', '疋', '宀'],
    },
    Decomposition {
        kanji: '聨',
        radicals: &['耳', '幺', '廾'],
    },
    Decomposition {
        kanji: '聳',
        radicals: &['耳', '丷', '疋', '彳', '人'],
    },
    Decomposition {
        kanji: '聲',
        radicals: &['士', '耳', '尸', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '聰',
        radicals: &['耳', '心', '囗', '夂'],
    },
    Decomposition {
        kanji: '聶',
        radicals: &['耳'],
    },
    Decomposition {
        kanji: '聹',
        radicals: &['耳', '心', '⺲', '亅', '宀', '皿'],
    },
    Decomposition {
        kanji: '聽',
        radicals: &['王', '耳', '十', '心', '⺲'],
    },
    Decomposition {
        kanji: '聿',
        radicals: &['聿'],
    },
    Decomposition {
        kanji: '肄',
        radicals: &['矢', '匕', '聿', '𠂉'],
    },
    Decomposition {
        kanji: '肆',
        radicals: &['長', '厶', '聿'],
    },
    Decomposition {
        kanji: '肅',
        radicals: &['ヨ', '片', '爿', '聿'],
    },
    Decomposition {
        kanji: '肛',
        radicals: &['工', '月'],
    },
    Decomposition {
        kanji: '肓',
        radicals: &['亡', '月', '亠'],
    },
    Decomposition {
        kanji: '肚',
        radicals: &['土', '月'],
    },
    Decomposition {
        kanji: '肭',
        radicals: &['人', '月', '冂'],
    },
    Decomposition {
        kanji: '冐',
        radicals: &['月', '二', '冂'],
    },
    Decomposition {
        kanji: '肬',
        radicals: &['月', '丶', '尤', '尢'],
    },
    Decomposition {
        kanji: '胛',
        radicals: &['｜', '月', '日', '田'],
    },
    Decomposition {
        kanji: '胥',
        radicals: &['月', '疋'],
    },
    Decomposition {
        kanji: '胙',
        radicals: &['｜', 'ノ', '月'],
    },
    Decomposition {
        kanji: '胝',
        radicals: &['月', '氏'],
    },
    Decomposition {
        kanji: '胄',
        radicals: &['｜', '月', '日', '田'],
    },
    Decomposition {
        kanji: '胚',
        radicals: &['｜', 'ノ', '一', '月', '丶'],
    },
    Decomposition {
        kanji: '胖',
        radicals: &['｜', '二', '月', '丷', '十'],
    },
    Decomposition {
        kanji: '脉',
        radicals: &['月', '水', '丶'],
    },
    Decomposition {
        kanji: '胯',
        radicals: &['月', '大', '二', '勹'],
    },
    Decomposition {
        kanji: '胱',
        radicals: &['月', '⺌', '儿'],
    },
    Decomposition {
        kanji: '脛',
        radicals: &['月', '工', '巛'],
    },
    Decomposition {
        kanji: '脩',
        radicals: &['⺅', '月', '攵', '𠂉', '｜'],
    },
    Decomposition {
        kanji: '脣',
        radicals: &['月', '辰', '衣'],
    },
    Decomposition {
        kanji: '脯',
        radicals: &['｜', '十', '月', '用', '丶'],
    },
    Decomposition {
        kanji: '腋',
        radicals: &['⺅', '月', '夕', '亠'],
    },
    Decomposition {
        kanji: '隋',
        radicals: &['ノ', '一', '月', '工', '⻖'],
    },
    Decomposition {
        kanji: '腆',
        radicals: &['｜', '一', '月', '日', 'ハ', '冂'],
    },
    Decomposition {
        kanji: '脾',
        radicals: &['月', '十', '田', 'ノ'],
    },
    Decomposition {
        kanji: '腓',
        radicals: &['月', '非'],
    },
    Decomposition {
        kanji: '腑',
        radicals: &['⺅', '月', '寸', '广'],
    },
    Decomposition {
        kanji: '胼',
        radicals: &['｜', 'ノ', '月', '二', '丷', '廾', '一'],
    },
    Decomposition {
        kanji: '腱',
        radicals: &['月', '廴', '聿'],
    },
    Decomposition {
        kanji: '腮',
        radicals: &['月', '心', '田'],
    },
    Decomposition {
        kanji: '腥',
        radicals: &['月', '生', '日'],
    },
    Decomposition {
        kanji: '腦',
        radicals: &['巛', '月', '囗'],
    },
    Decomposition {
        kanji: '腴',
        radicals: &['月', '人', '日', '臼'],
    },
    Decomposition {
        kanji: '膃',
        radicals: &['月', '皿', '日'],
    },
    Decomposition {
        kanji: '膈',
        radicals: &['口', '月', '儿', '冂', '鬲'],
    },
    Decomposition {
        kanji: '膊',
        radicals: &['十', '寸', '田', '月', '日', '丶'],
    },
    Decomposition {
        kanji: '膀',
        radicals: &['月', '丷', '方', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '膂',
        radicals: &['衣', '月', '方', '亠', '𠂉'],
    },
    Decomposition {
        kanji: '膠',
        radicals: &['羽', '月', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '膕',
        radicals: &['口', '月', '囗', '戈'],
    },
    Decomposition {
        kanji: '膤',
        radicals: &['ヨ', '雨', '月'],
    },
    Decomposition {
        kanji: '膣',
        radicals: &['穴', '至', '土', '月', '儿', '厶', '宀'],
    },
    Decomposition {
        kanji: '腟',
        radicals: &['至', '土', '月', '厶', '宀'],
    },
    Decomposition {
        kanji: '膓',
        radicals: &['ノ', '月', '日', '勿', '一', '𠂉'],
    },
    Decomposition {
        kanji: '膩',
        radicals: &['貝', '目', 'ハ', '二', '月', '弋'],
    },
    Decomposition {
        kanji: '膰',
        radicals: &['田', '月', '釆', '米'],
    },
    Decomposition {
        kanji: '膵',
        radicals: &['十', '人', '月', '亠', '⺾'],
    },
    Decomposition {
        kanji: '膾',
        radicals: &['月', '日', '⺲', '𠆢', '一'],
    },
    Decomposition {
        kanji: '膸',
        radicals: &['ノ', '一', '月', '工', '⻌'],
    },
    Decomposition {
        kanji: '膽',
        radicals: &['言', '月', '儿', '厂', '勹'],
    },
    Decomposition {
        kanji: '臀',
        radicals: &['月', 'ハ', '尸', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '臂',
        radicals: &['月', '口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '膺',
        radicals: &['⺅', '月', '广', '隹'],
    },
    Decomposition {
        kanji: '臉',
        radicals: &['口', '人', '月', '𠆢', '一'],
    },
    Decomposition {
        kanji: '臍',
        radicals: &['月', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '臑',
        radicals: &['雨', '而', '月'],
    },
    Decomposition {
        kanji: '臙',
        radicals: &['口', '月', '凵', '匕', '⺣', '爿'],
    },
    Decomposition {
        kanji: '臘',
        radicals: &['臼', '巛', '鼠', '月', '囗'],
    },
    Decomposition {
        kanji: '臈',
        radicals: &['月', '日', '勹', '匕', '⺾'],
    },
    Decomposition {
        kanji: '臚',
        radicals: &['皿', '田', '月', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '臟',
        radicals: &['ノ', '臣', '月', '戈', '⺾'],
    },
    Decomposition {
        kanji: '臠',
        radicals: &['言', '糸', '幺', '小', '肉'],
    },
    Decomposition {
        kanji: '臧',
        radicals: &['ノ', '臣', '冫', '戈', '⽧'],
    },
    Decomposition {
        kanji: '臺',
        radicals: &['口', '士', '至', '土', '冖', '厶'],
    },
    Decomposition {
        kanji: '臻',
        radicals: &['ノ', '禾', '至', '大', '土', '二', '厶'],
    },
    Decomposition {
        kanji: '臾',
        radicals: &['臼', '人'],
    },
    Decomposition {
        kanji: '舁',
        radicals: &['臼', '廾'],
    },
    Decomposition {
        kanji: '舂',
        radicals: &['ノ', '臼', '大', '二'],
    },
    Decomposition {
        kanji: '舅',
        radicals: &['臼', '田', '力'],
    },
    Decomposition {
        kanji: '與',
        radicals: &['一', '臼', 'ハ'],
    },
    Decomposition {
        kanji: '舊',
        radicals: &['臼', '⺾', '隹'],
    },
    Decomposition {
        kanji: '舍',
        radicals: &['口', '舌', '𠆢'],
    },
    Decomposition {
        kanji: '舐',
        radicals: &['口', '氏', '舌'],
    },
    Decomposition {
        kanji: '舖',
        radicals: &['口', '十', '舌', '用', '𠆢', '丶'],
    },
    Decomposition {
        kanji: '舩',
        radicals: &['舟', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '舫',
        radicals: &['舟', '方'],
    },
    Decomposition {
        kanji: '舸',
        radicals: &['口', '舟', '亅'],
    },
    Decomposition {
        kanji: '舳',
        radicals: &['｜', '舟', '日', '田'],
    },
    Decomposition {
        kanji: '艀',
        radicals: &['子', '舟', '爪'],
    },
    Decomposition {
        kanji: '艙',
        radicals: &['口', '舟', '𠆢', '尸', '一'],
    },
    Decomposition {
        kanji: '艘',
        radicals: &['支', '舟', '日', '又'],
    },
    Decomposition {
        kanji: '艝',
        radicals: &['ヨ', '雨', '舟'],
    },
    Decomposition {
        kanji: '艚',
        radicals: &['｜', '一', '舟', '日'],
    },
    Decomposition {
        kanji: '艟',
        radicals: &['舟', '里', '立'],
    },
    Decomposition {
        kanji: '艤',
        radicals: &['王', '舟', '丷', '羊', '亅', '戈'],
    },
    Decomposition {
        kanji: '艢',
        radicals: &['口', '舟', '人', '土', '囗'],
    },
    Decomposition {
        kanji: '艨',
        radicals: &['舟', '冖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '艪',
        radicals: &['魚', '舟', '田', '日', '⺣'],
    },
    Decomposition {
        kanji: '艫',
        radicals: &['皿', '舟', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '舮',
        radicals: &['戸', '舟', '一', '尸'],
    },
    Decomposition {
        kanji: '艱',
        radicals: &['艮', '人', '大', '二', '⺾'],
    },
    Decomposition {
        kanji: '艷',
        radicals: &['口', '山', '色', '豆', '丷', '凵'],
    },
    Decomposition {
        kanji: '艸',
        radicals: &['⺾', '屮'],
    },
    Decomposition {
        kanji: '艾',
        radicals: &['ノ', '⺾'],
    },
    Decomposition {
        kanji: '芍',
        radicals: &['丶', '勹', '⺾'],
    },
    Decomposition {
        kanji: '芒',
        radicals: &['亡', '⺾', '亠'],
    },
    Decomposition {
        kanji: '芫',
        radicals: &['二', '儿', '⺾', '元'],
    },
    Decomposition {
        kanji: '芟',
        radicals: &['殳', '⺾', '几', '又'],
    },
    Decomposition {
        kanji: '芻',
        radicals: &['勹', '屮', '⺾'],
    },
    Decomposition {
        kanji: '芬',
        radicals: &['刀', 'ハ', '⺾'],
    },
    Decomposition {
        kanji: '苡',
        radicals: &['｜', '人', '⺾'],
    },
    Decomposition {
        kanji: '苣',
        radicals: &['巨', '⺾'],
    },
    Decomposition {
        kanji: '苟',
        radicals: &['口', '勹', '⺾'],
    },
    Decomposition {
        kanji: '苒',
        radicals: &['｜', '一', '冂', '⺾', '十'],
    },
    Decomposition {
        kanji: '苴',
        radicals: &['一', '目', '⺾'],
    },
    Decomposition {
        kanji: '苳',
        radicals: &['丶', '夂', '⺾'],
    },
    Decomposition {
        kanji: '苺',
        radicals: &['母', '⺾', '毋'],
    },
    Decomposition {
        kanji: '莓',
        radicals: &['一', '母', '⺾', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '范',
        radicals: &['⺡', '卩', '⺾'],
    },
    Decomposition {
        kanji: '苻',
        radicals: &['⺅', '寸', '⺾'],
    },
    Decomposition {
        kanji: '苹',
        radicals: &['干', 'ハ', '⺾'],
    },
    Decomposition {
        kanji: '苞',
        radicals: &['勹', '已', '⺾'],
    },
    Decomposition {
        kanji: '茆',
        radicals: &['ノ', '卩', '⺾'],
    },
    Decomposition {
        kanji: '苜',
        radicals: &['目', '⺾'],
    },
    Decomposition {
        kanji: '茉',
        radicals: &['｜', '一', 'ハ', '木', '亠', '⺾'],
    },
    Decomposition {
        kanji: '苙',
        radicals: &['立', '⺾'],
    },
    Decomposition {
        kanji: '茵',
        radicals: &['大', '囗', '⺾'],
    },
    Decomposition {
        kanji: '茴',
        radicals: &['口', '囗', '⺾'],
    },
    Decomposition {
        kanji: '茖',
        radicals: &['口', '夂', '⺾'],
    },
    Decomposition {
        kanji: '茲',
        radicals: &['幺', '⺾'],
    },
    Decomposition {
        kanji: '茱',
        radicals: &['｜', 'ノ', '牛', '二', 'ハ', '木', '亠', '⺾'],
    },
    Decomposition {
        kanji: '荀',
        radicals: &['日', '勹', '⺾'],
    },
    Decomposition {
        kanji: '茹',
        radicals: &['口', '女', '⺾'],
    },
    Decomposition {
        kanji: '荐',
        radicals: &['ノ', '一', '子', '⺾'],
    },
    Decomposition {
        kanji: '荅',
        radicals: &['口', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '茯',
        radicals: &['⺅', '犬', '⺾'],
    },
    Decomposition {
        kanji: '茫',
        radicals: &['亡', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '茗',
        radicals: &['口', '夕', '⺾'],
    },
    Decomposition {
        kanji: '茘',
        radicals: &['刀', '⺾'],
    },
    Decomposition {
        kanji: '莅',
        radicals: &['⺅', '立', '⺾'],
    },
    Decomposition {
        kanji: '莚',
        radicals: &['ノ', '止', '廴', '⺾'],
    },
    Decomposition {
        kanji: '莪',
        radicals: &['亅', '戈', '⺾'],
    },
    Decomposition {
        kanji: '莟',
        radicals: &['口', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '莢',
        radicals: &['人', '大', '⺾'],
    },
    Decomposition {
        kanji: '莖',
        radicals: &['一', '工', '巛', '⺾'],
    },
    Decomposition {
        kanji: '茣',
        radicals: &['一', '口', 'ハ', '⺾'],
    },
    Decomposition {
        kanji: '莎',
        radicals: &['ノ', '⺡', '小', '⺾'],
    },
    Decomposition {
        kanji: '莇',
        radicals: &['目', '力', '⺾'],
    },
    Decomposition {
        kanji: '莊',
        radicals: &['士', '爿', '⺾'],
    },
    Decomposition {
        kanji: '荼',
        radicals: &['小', '二', 'ハ', '𠆢', '亅', '⺾', '一'],
    },
    Decomposition {
        kanji: '莵',
        radicals: &['鬼', '儿', '匕', '⺾'],
    },
    Decomposition {
        kanji: '荳',
        radicals: &['口', '豆', '丷', '⺾'],
    },
    Decomposition {
        kanji: '荵',
        radicals: &['心', '刀', '丶', '⺾'],
    },
    Decomposition {
        kanji: '莠',
        radicals: &['ノ', '禾', '⺾'],
    },
    Decomposition {
        kanji: '莉',
        radicals: &['禾', '⺉', '⺾'],
    },
    Decomposition {
        kanji: '莨',
        radicals: &['艮', '⺾'],
    },
    Decomposition {
        kanji: '菴',
        radicals: &['乙', '大', '日', '⺾', '奄'],
    },
    Decomposition {
        kanji: '萓',
        radicals: &['一', '目', '宀', '⺾'],
    },
    Decomposition {
        kanji: '菫',
        radicals: &['｜', '一', '口', '土', '二', '⺾'],
    },
    Decomposition {
        kanji: '菎',
        radicals: &['日', '比', '⺾'],
    },
    Decomposition {
        kanji: '菽',
        radicals: &['小', '卜', '又', '⺾'],
    },
    Decomposition {
        kanji: '萃',
        radicals: &['十', '人', '亠', '⺾'],
    },
    Decomposition {
        kanji: '菘',
        radicals: &['ハ', '木', '厶', '⺾'],
    },
    Decomposition {
        kanji: '萋',
        radicals: &['｜', 'ヨ', '女', '⺾'],
    },
    Decomposition {
        kanji: '菁',
        radicals: &['月', '青', '土', '二', '亠', '⺾'],
    },
    Decomposition {
        kanji: '菷',
        radicals: &['ヨ', '巾', '冖', '⺾'],
    },
    Decomposition {
        kanji: '萇',
        radicals: &['長', '⺾'],
    },
    Decomposition {
        kanji: '菠',
        radicals: &['⺡', '皮', '又', '⺾'],
    },
    Decomposition {
        kanji: '菲',
        radicals: &['非', '⺾'],
    },
    Decomposition {
        kanji: '萍',
        radicals: &['干', '⺡', '丷', '⺾'],
    },
    Decomposition {
        kanji: '萢',
        radicals: &['⺡', '勹', '已', '⺾'],
    },
    Decomposition {
        kanji: '萠',
        radicals: &['月', '⺾'],
    },
    Decomposition {
        kanji: '莽',
        radicals: &['大', '廾', '⺾'],
    },
    Decomposition {
        kanji: '萸',
        radicals: &['人', '日', '⺾', '臼'],
    },
    Decomposition {
        kanji: '蔆',
        radicals: &['⺡', '土', '儿', '夂', '⺾'],
    },
    Decomposition {
        kanji: '菻',
        radicals: &['木', '⺾'],
    },
    Decomposition {
        kanji: '葭',
        radicals: &['｜', '又', '⺾'],
    },
    Decomposition {
        kanji: '萪',
        radicals: &['禾', '斗', '⺾'],
    },
    Decomposition {
        kanji: '萼',
        radicals: &['口', '二', '⺾', '勹'],
    },
    Decomposition {
        kanji: '蕚',
        radicals: &['口', '二', '⺾', '勹', '品'],
    },
    Decomposition {
        kanji: '蒄',
        radicals: &['寸', '二', '儿', '冖', '⺾', '元'],
    },
    Decomposition {
        kanji: '葷',
        radicals: &['車', '冖', '⺾'],
    },
    Decomposition {
        kanji: '葫',
        radicals: &['月', '口', '十', '⺾'],
    },
    Decomposition {
        kanji: '蒭',
        radicals: &['勹', '屮', '⺾'],
    },
    Decomposition {
        kanji: '葮',
        radicals: &['｜', '殳', '⺾', '几', '又'],
    },
    Decomposition {
        kanji: '蒂',
        radicals: &['巾', '丷', '立', '亠', '冖', '⺾'],
    },
    Decomposition {
        kanji: '葩',
        radicals: &['白', '巴', '⺾'],
    },
    Decomposition {
        kanji: '葆',
        radicals: &['⺅', '口', '木', '⺾'],
    },
    Decomposition {
        kanji: '萬',
        radicals: &['田', '日', '冂', '⽱', '⺾'],
    },
    Decomposition {
        kanji: '葯',
        radicals: &['糸', '幺', '小', '丶', '勹', '⺾'],
    },
    Decomposition {
        kanji: '葹',
        radicals: &['也', '方', '匕', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '萵',
        radicals: &['口', '冂', '⺾'],
    },
    Decomposition {
        kanji: '蓊',
        radicals: &['羽', 'ハ', '冫', '厶', '⺾'],
    },
    Decomposition {
        kanji: '葢',
        radicals: &['皿', '大', '丶', '⺾'],
    },
    Decomposition {
        kanji: '蒹',
        radicals: &['｜', 'ヨ', '一', '丷', '⺾'],
    },
    Decomposition {
        kanji: '蒿',
        radicals: &['口', '高', '亠', '冂', '⺾'],
    },
    Decomposition {
        kanji: '蒟',
        radicals: &['口', '立', '勹', '⺾'],
    },
    Decomposition {
        kanji: '蓙',
        radicals: &['人', '土', '广', '⺾'],
    },
    Decomposition {
        kanji: '蓍',
        radicals: &['日', '⺹', '⺾', '匕'],
    },
    Decomposition {
        kanji: '蒻',
        radicals: &['弓', '冫', '⺾'],
    },
    Decomposition {
        kanji: '蓚',
        radicals: &['⺅', '彡', '攵', '⺾', '𠂉', '｜'],
    },
    Decomposition {
        kanji: '蓐',
        radicals: &['寸', '辰', '⺾', '衣'],
    },
    Decomposition {
        kanji: '蓁',
        radicals: &['禾', '大', '二', '⺾'],
    },
    Decomposition {
        kanji: '蓆',
        radicals: &['一', '巾', '凵', '广', '⺾'],
    },
    Decomposition {
        kanji: '蓖',
        radicals: &['比', '囗', '⺾', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '蒡',
        radicals: &['丷', '方', '立', '亠', '冖', '⺾'],
    },
    Decomposition {
        kanji: '蔡',
        radicals: &['示', '二', '小', '癶', '⺾'],
    },
    Decomposition {
        kanji: '蓿',
        radicals: &['⺅', '白', '宀', '⺾'],
    },
    Decomposition {
        kanji: '蓴',
        radicals: &['一', '寸', '虫', '日', '⺾', '十', '田'],
    },
    Decomposition {
        kanji: '蔗',
        radicals: &['一', '凵', '广', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '蔘',
        radicals: &['大', '厶', '彡', '⺾'],
    },
    Decomposition {
        kanji: '蔬',
        radicals: &['止', '川', '亠', '厶', '⺾', '疋'],
    },
    Decomposition {
        kanji: '蔟',
        radicals: &['方', '矢', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '蔕',
        radicals: &['一', '巾', '儿', '冖', '凵', '⺾'],
    },
    Decomposition {
        kanji: '蔔',
        radicals: &['口', '田', '勹', '⺾'],
    },
    Decomposition {
        kanji: '蓼',
        radicals: &['羽', '𠆢', '冫', '彡', '⺾'],
    },
    Decomposition {
        kanji: '蕀',
        radicals: &['｜', 'ハ', '木', '冂', '⺾'],
    },
    Decomposition {
        kanji: '蕣',
        radicals: &['舛', '爪', '夕', '冖', '⺾'],
    },
    Decomposition {
        kanji: '蕘',
        radicals: &['一', '土', '儿', '⺾'],
    },
    Decomposition {
        kanji: '蕈',
        radicals: &['十', '西', '日', '曰', '⺾'],
    },
    Decomposition {
        kanji: '蕁',
        radicals: &['ヨ', '口', '工', '寸', '⺾'],
    },
    Decomposition {
        kanji: '蘂',
        radicals: &['心', '木', '⺾'],
    },
    Decomposition {
        kanji: '蕋',
        radicals: &['止', '⺾'],
    },
    Decomposition {
        kanji: '蕕',
        radicals: &['酉', '丷', '⺨', '⺾'],
    },
    Decomposition {
        kanji: '薀',
        radicals: &['皿', '⺡', '口', '人', '⺾'],
    },
    Decomposition {
        kanji: '薤',
        radicals: &['歹', '⺾', '韭'],
    },
    Decomposition {
        kanji: '薈',
        radicals: &['日', '⺲', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '薑',
        radicals: &['一', '田', '二', '⺾'],
    },
    Decomposition {
        kanji: '薊',
        radicals: &['⺉', '魚', '田', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '薨',
        radicals: &['⺲', '夕', '冖', '匕', '⺾'],
    },
    Decomposition {
        kanji: '蕭',
        radicals: &['｜', 'ノ', 'ヨ', '米', '⺾', '聿'],
    },
    Decomposition {
        kanji: '薔',
        radicals: &['口', '人', '土', '囗', '⺾'],
    },
    Decomposition {
        kanji: '薛',
        radicals: &['｜', '口', '十', '辛', '立', '⺾'],
    },
    Decomposition {
        kanji: '藪',
        radicals: &['｜', '一', '口', '女', '攵', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '薇',
        radicals: &['山', '几', '彳', '攵', '⺾', '𠂉'],
    },
    Decomposition {
        kanji: '薜',
        radicals: &['口', '十', '辛', '立', '尸', '⺾'],
    },
    Decomposition {
        kanji: '蕷',
        radicals: &['貝', '目', 'ハ', '頁', '矛', '亅', '⺾'],
    },
    Decomposition {
        kanji: '蕾',
        radicals: &['雨', '田', '⺾'],
    },
    Decomposition {
        kanji: '薐',
        radicals: &['禾', '土', '儿', '夂', '⺾'],
    },
    Decomposition {
        kanji: '藉',
        radicals: &['｜', '一', '二', '日', 'ハ', '木', '耒', '⺾', 'ノ'],
    },
    Decomposition {
        kanji: '薺',
        radicals: &['亠', '⺾', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '藏',
        radicals: &['ノ', '臣', '戈', '爿', '⺾'],
    },
    Decomposition {
        kanji: '薹',
        radicals: &['口', '士', '至', '土', '冖', '厶', '⺾'],
    },
    Decomposition {
        kanji: '藐',
        radicals: &['日', '儿', '⺾', '豸'],
    },
    Decomposition {
        kanji: '藕',
        radicals: &['｜', '田', '日', 'ハ', '木', '⽱', '耒', '⺾', 'ノ'],
    },
    Decomposition {
        kanji: '藝',
        radicals: &['九', '土', '二', '丶', '儿', '厶', '⺾'],
    },
    Decomposition {
        kanji: '藥',
        radicals: &['白', '木', '幺', '⺾'],
    },
    Decomposition {
        kanji: '藜',
        radicals: &['禾', '水', '𠆢', '勹', '⺾', '黍'],
    },
    Decomposition {
        kanji: '藹',
        radicals: &['言', '日', '勹', '匕', '⺾'],
    },
    Decomposition {
        kanji: '蘊',
        radicals: &['皿', '糸', '幺', '小', '日', '⺾'],
    },
    Decomposition {
        kanji: '蘓',
        radicals: &['禾', '魚', '田', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '蘋',
        radicals: &['ノ', '貝', '目', 'ハ', '止', '小', '頁', '⺾'],
    },
    Decomposition {
        kanji: '藾',
        radicals: &['｜', '貝', '目', '口', 'ハ', '頁', '木', '⺾'],
    },
    Decomposition {
        kanji: '藺',
        radicals: &['門', '⺾', '隹'],
    },
    Decomposition {
        kanji: '蘆',
        radicals: &['皿', '田', '卜', '匕', '厂', '⺾', '虍'],
    },
    Decomposition {
        kanji: '蘢',
        radicals: &['月', '立', '⺾'],
    },
    Decomposition {
        kanji: '蘚',
        radicals: &['王', '魚', '田', '丷', '羊', '⺣', '⺾'],
    },
    Decomposition {
        kanji: '蘰',
        radicals: &['糸', '幺', '小', '日', '⺲', '又', '⺾'],
    },
    Decomposition {
        kanji: '蘿',
        radicals: &['糸', '幺', '小', '⺲', '⺾', '隹'],
    },
    Decomposition {
        kanji: '虍',
        radicals: &['卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '乕',
        radicals: &['｜', 'ノ', '一', '巾', '厂'],
    },
    Decomposition {
        kanji: '虔',
        radicals: &['文', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '號',
        radicals: &['口', '卜', '儿', '匕', '厂', '虍', '一', '勹'],
    },
    Decomposition {
        kanji: '虧',
        radicals: &['二', '卜', '匕', '厂', '虍', '隹', '勹'],
    },
    Decomposition {
        kanji: '虱',
        radicals: &['ノ', '一', '乙', '虫'],
    },
    Decomposition {
        kanji: '蚓',
        radicals: &['｜', '弓', '虫'],
    },
    Decomposition {
        kanji: '蚣',
        radicals: &['虫', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '蚩',
        radicals: &['一', '山', '虫', '屮'],
    },
    Decomposition {
        kanji: '蚪',
        radicals: &['虫', '斗'],
    },
    Decomposition {
        kanji: '蚋',
        radicals: &['人', '虫', '冂'],
    },
    Decomposition {
        kanji: '蚌',
        radicals: &['｜', '一', '虫', '二'],
    },
    Decomposition {
        kanji: '蚶',
        radicals: &['甘', '虫'],
    },
    Decomposition {
        kanji: '蚯',
        radicals: &['斤', '虫', '一'],
    },
    Decomposition {
        kanji: '蛄',
        radicals: &['口', '十', '虫'],
    },
    Decomposition {
        kanji: '蛆',
        radicals: &['虫', '目'],
    },
    Decomposition {
        kanji: '蚰',
        radicals: &['｜', '虫', '日', '田'],
    },
    Decomposition {
        kanji: '蛉',
        radicals: &['虫', '𠆢', '卩', '一'],
    },
    Decomposition {
        kanji: '蠣',
        radicals: &['虫', '田', '厂', '⽱', '⺾'],
    },
    Decomposition {
        kanji: '蚫',
        radicals: &['虫', '勹', '已'],
    },
    Decomposition {
        kanji: '蛔',
        radicals: &['口', '虫', '囗'],
    },
    Decomposition {
        kanji: '蛞',
        radicals: &['口', '舌', '虫'],
    },
    Decomposition {
        kanji: '蛩',
        radicals: &['工', '虫', '丶', '几'],
    },
    Decomposition {
        kanji: '蛬',
        radicals: &['｜', '一', '虫', '二', 'ハ'],
    },
    Decomposition {
        kanji: '蛟',
        radicals: &['虫', '父', '亠'],
    },
    Decomposition {
        kanji: '蛛',
        radicals: &['｜', 'ノ', '牛', '虫', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '蛯',
        radicals: &['虫', '⺹', '匕'],
    },
    Decomposition {
        kanji: '蜒',
        radicals: &['ノ', '止', '虫', '廴'],
    },
    Decomposition {
        kanji: '蜆',
        radicals: &['見', '虫'],
    },
    Decomposition {
        kanji: '蜈',
        radicals: &['口', '虫', 'ハ'],
    },
    Decomposition {
        kanji: '蜀',
        radicals: &['虫', '⺲', '勹'],
    },
    Decomposition {
        kanji: '蜃',
        radicals: &['辰', '虫', '衣'],
    },
    Decomposition {
        kanji: '蛻',
        radicals: &['口', '虫', '丷', '儿'],
    },
    Decomposition {
        kanji: '蜑',
        radicals: &['ノ', '止', '虫', '廴'],
    },
    Decomposition {
        kanji: '蜉',
        radicals: &['子', '虫', '爪'],
    },
    Decomposition {
        kanji: '蜍',
        radicals: &['小', '虫', '二', '𠆢', '亅', '一'],
    },
    Decomposition {
        kanji: '蛹',
        radicals: &['虫', '用', 'マ'],
    },
    Decomposition {
        kanji: '蜊',
        radicals: &['禾', '⺉', '虫'],
    },
    Decomposition {
        kanji: '蜴',
        radicals: &['ノ', '虫', '日', '勿', '勹'],
    },
    Decomposition {
        kanji: '蜿',
        radicals: &['虫', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '蜷',
        radicals: &['人', '大', '虫', '二', '丷', '已'],
    },
    Decomposition {
        kanji: '蜻',
        radicals: &['月', '青', '虫', '土', '二', '亠'],
    },
    Decomposition {
        kanji: '蜥',
        radicals: &['斤', '虫', '木'],
    },
    Decomposition {
        kanji: '蜩',
        radicals: &['口', '虫', '土', '冂'],
    },
    Decomposition {
        kanji: '蜚',
        radicals: &['虫', '非'],
    },
    Decomposition {
        kanji: '蝠',
        radicals: &['口', '虫', '田'],
    },
    Decomposition {
        kanji: '蝟',
        radicals: &['月', '虫', '田'],
    },
    Decomposition {
        kanji: '蝸',
        radicals: &['口', '虫', '冂'],
    },
    Decomposition {
        kanji: '蝌',
        radicals: &['禾', '虫', '斗'],
    },
    Decomposition {
        kanji: '蝎',
        radicals: &['虫', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '蝴',
        radicals: &['月', '口', '十', '虫'],
    },
    Decomposition {
        kanji: '蝗',
        radicals: &['王', '虫', '白'],
    },
    Decomposition {
        kanji: '蝨',
        radicals: &['ノ', '一', '乙', '虫'],
    },
    Decomposition {
        kanji: '蝮',
        radicals: &['虫', '日', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '蝙',
        radicals: &['｜', '一', '戸', '虫', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '蝓',
        radicals: &['⺉', '月', '虫', '𠆢', '一'],
    },
    Decomposition {
        kanji: '蝣',
        radicals: &['子', '虫', '方', '𠂉'],
    },
    Decomposition {
        kanji: '蝪',
        radicals: &['ノ', '虫', '日', '勿', '一', '勹'],
    },
    Decomposition {
        kanji: '蠅',
        radicals: &['虫', '黽'],
    },
    Decomposition {
        kanji: '螢',
        radicals: &['火', '虫', '冖'],
    },
    Decomposition {
        kanji: '螟',
        radicals: &['虫', '日', 'ハ', '亠', '冖'],
    },
    Decomposition {
        kanji: '螂',
        radicals: &['艮', '虫', '⻏'],
    },
    Decomposition {
        kanji: '螯',
        radicals: &['虫', '土', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '蟋',
        radicals: &['心', '虫', '釆', '米'],
    },
    Decomposition {
        kanji: '螽',
        radicals: &['虫', '丶', '夂'],
    },
    Decomposition {
        kanji: '蟀',
        radicals: &['十', '虫', '亠', '冫', '幺', '玄'],
    },
    Decomposition {
        kanji: '蟐',
        radicals: &['巾', '口', '⺌', '虫', '冖'],
    },
    Decomposition {
        kanji: '雖',
        radicals: &['口', '虫', '隹'],
    },
    Decomposition {
        kanji: '螫',
        radicals: &['赤', '虫', '土', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '蟄',
        radicals: &['九', '十', '辛', '虫', '立', '丶', '亠'],
    },
    Decomposition {
        kanji: '螳',
        radicals: &['口', '⺌', '虫', '土', '冖'],
    },
    Decomposition {
        kanji: '蟇',
        radicals: &['大', '虫', '日', '⺾'],
    },
    Decomposition {
        kanji: '蟆',
        radicals: &['大', '虫', '日', '⺾'],
    },
    Decomposition {
        kanji: '螻',
        radicals: &['｜', '一', '口', '女', '虫'],
    },
    Decomposition {
        kanji: '蟯',
        radicals: &['虫', '土', '儿'],
    },
    Decomposition {
        kanji: '蟲',
        radicals: &['虫'],
    },
    Decomposition {
        kanji: '蟠',
        radicals: &['虫', '田', '釆', '米'],
    },
    Decomposition {
        kanji: '蠏',
        radicals: &['角', '牛', '虫', '刀'],
    },
    Decomposition {
        kanji: '蠍',
        radicals: &['欠', '虫', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '蟾',
        radicals: &['言', '虫', '儿', '厂'],
    },
    Decomposition {
        kanji: '蟶',
        radicals: &['王', '口', '耳', '虫'],
    },
    Decomposition {
        kanji: '蟷',
        radicals: &['口', '⺌', '虫', '田', '冖'],
    },
    Decomposition {
        kanji: '蠎',
        radicals: &['十', '大', '虫', '廾', '⺾'],
    },
    Decomposition {
        kanji: '蟒',
        radicals: &['大', '虫', '廾', '⺾'],
    },
    Decomposition {
        kanji: '蠑',
        radicals: &['火', '虫', '木', '冖'],
    },
    Decomposition {
        kanji: '蠖',
        radicals: &['虫', '又', '⺾', '隹'],
    },
    Decomposition {
        kanji: '蠕',
        radicals: &['雨', '而', '虫'],
    },
    Decomposition {
        kanji: '蠢',
        radicals: &['大', '虫', '二', '日'],
    },
    Decomposition {
        kanji: '蠡',
        radicals: &['彑', '虫', '豕'],
    },
    Decomposition {
        kanji: '蠱',
        radicals: &['皿', '虫'],
    },
    Decomposition {
        kanji: '蠶',
        radicals: &['虫', '日', '无'],
    },
    Decomposition {
        kanji: '蠹',
        radicals: &['｜', '一', '口', '石', '虫', '冖'],
    },
    Decomposition {
        kanji: '蠧',
        radicals: &['口', '士', '石', '虫', '冖'],
    },
    Decomposition {
        kanji: '蠻',
        radicals: &['言', '糸', '幺', '小', '虫'],
    },
    Decomposition {
        kanji: '衄',
        radicals: &['｜', '一', '血', '皿'],
    },
    Decomposition {
        kanji: '衂',
        radicals: &['血', '皿', '刀', '丶'],
    },
    Decomposition {
        kanji: '衒',
        radicals: &['行', '亠', '幺', '彳', '玄'],
    },
    Decomposition {
        kanji: '衙',
        radicals: &['一', '口', '行', '彳', '五', '｜'],
    },
    Decomposition {
        kanji: '衞',
        radicals: &['巾', '口', '行', '彳'],
    },
    Decomposition {
        kanji: '衢',
        radicals: &['行', '目', '彳', '隹'],
    },
    Decomposition {
        kanji: '衫',
        radicals: &['⻂', '彡'],
    },
    Decomposition {
        kanji: '袁',
        radicals: &['衣', '口', '土'],
    },
    Decomposition {
        kanji: '衾',
        radicals: &['衣', '𠆢', '亠', '一'],
    },
    Decomposition {
        kanji: '袞',
        radicals: &['衣', '口', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '衵',
        radicals: &['⻂', '日'],
    },
    Decomposition {
        kanji: '衽',
        radicals: &['王', '⻂', '士'],
    },
    Decomposition {
        kanji: '袵',
        radicals: &['王', '⺅', '⻂'],
    },
    Decomposition {
        kanji: '衲',
        radicals: &['⻂', '人', '冂'],
    },
    Decomposition {
        kanji: '袂',
        radicals: &['⻂', '人', '大', '二', 'ユ'],
    },
    Decomposition {
        kanji: '袗',
        radicals: &['⻂', '𠆢', '彡'],
    },
    Decomposition {
        kanji: '袒',
        radicals: &['⻂', '日', '一'],
    },
    Decomposition {
        kanji: '袮',
        radicals: &['ノ', '⻂', '小', '𠂉'],
    },
    Decomposition {
        kanji: '袙',
        radicals: &['⻂', '白'],
    },
    Decomposition {
        kanji: '袢',
        radicals: &['｜', '⻂', '二', '丷', '十'],
    },
    Decomposition {
        kanji: '袍',
        radicals: &['⻂', '勹', '已'],
    },
    Decomposition {
        kanji: '袤',
        radicals: &['衣', '矛', '亠'],
    },
    Decomposition {
        kanji: '袰',
        radicals: &['衣', '母', '毋', '亠'],
    },
    Decomposition {
        kanji: '袿',
        radicals: &['⻂', '土'],
    },
    Decomposition {
        kanji: '袱',
        radicals: &['⺅', '犬', '⻂'],
    },
    Decomposition {
        kanji: '裃',
        radicals: &['⻂', '卜'],
    },
    Decomposition {
        kanji: '裄',
        radicals: &['行', '⻂', '彳'],
    },
    Decomposition {
        kanji: '裔',
        radicals: &['衣', '口', '儿', '冂', '亠'],
    },
    Decomposition {
        kanji: '裘',
        radicals: &['衣', '水', '丶', '亠'],
    },
    Decomposition {
        kanji: '裙',
        radicals: &['ノ', 'ヨ', '口', '⻂', '尸'],
    },
    Decomposition {
        kanji: '裝',
        radicals: &['衣', '士', '爿', '亠'],
    },
    Decomposition {
        kanji: '裹',
        radicals: &['衣', '田', 'ハ', '亠', '木'],
    },
    Decomposition {
        kanji: '褂',
        radicals: &['⻂', '土', '卜'],
    },
    Decomposition {
        kanji: '裼',
        radicals: &['ノ', '⻂', '日', '勿', '勹'],
    },
    Decomposition {
        kanji: '裴',
        radicals: &['衣', '非', '亠'],
    },
    Decomposition {
        kanji: '裨',
        radicals: &['十', '⻂', '田'],
    },
    Decomposition {
        kanji: '裲',
        radicals: &['｜', '一', '⻂', '入', '冂'],
    },
    Decomposition {
        kanji: '褄',
        radicals: &['｜', 'ヨ', '一', '⻂', '女'],
    },
    Decomposition {
        kanji: '褌',
        radicals: &['車', '⻂', '冖'],
    },
    Decomposition {
        kanji: '褊',
        radicals: &['｜', '一', '戸', '⻂', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '褓',
        radicals: &['⺅', '口', '⻂', '木'],
    },
    Decomposition {
        kanji: '襃',
        radicals: &['衣', '口', '木', '亠'],
    },
    Decomposition {
        kanji: '褞',
        radicals: &['皿', '⻂', '日'],
    },
    Decomposition {
        kanji: '褥',
        radicals: &['⻂', '寸', '辰', '衣'],
    },
    Decomposition {
        kanji: '褪',
        radicals: &['⻌', '艮', '⻂'],
    },
    Decomposition {
        kanji: '褫',
        radicals: &['⻂', '卜', '儿', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '襁',
        radicals: &['弓', '⻂', '虫', '厶'],
    },
    Decomposition {
        kanji: '襄',
        radicals: &['｜', '衣', '一', 'ハ', '亠', '井'],
    },
    Decomposition {
        kanji: '褻',
        radicals: &['衣', '九', '土', '丶', '亠'],
    },
    Decomposition {
        kanji: '褶',
        radicals: &['羽', '⻂', '白', '冫'],
    },
    Decomposition {
        kanji: '褸',
        radicals: &['｜', '一', '口', '⻂', '女'],
    },
    Decomposition {
        kanji: '襌',
        radicals: &['口', '十', '⻂', '田'],
    },
    Decomposition {
        kanji: '褝',
        radicals: &['十', '⻂', '⺌', '田'],
    },
    Decomposition {
        kanji: '襠',
        radicals: &['口', '⻂', '⺌', '田', '冖'],
    },
    Decomposition {
        kanji: '襞',
        radicals: &['衣', '口', '十', '辛', '立', '尸', '亠'],
    },
    Decomposition {
        kanji: '襦',
        radicals: &['雨', '而', '⻂'],
    },
    Decomposition {
        kanji: '襤',
        radicals: &['皿', '⻂', '臣', '二', '𠂉'],
    },
    Decomposition {
        kanji: '襭',
        radicals: &['貝', '目', 'ハ', '口', '⻂', '土', '頁'],
    },
    Decomposition {
        kanji: '襪',
        radicals: &['ノ', '⻂', '⺲', '戈', '⺾'],
    },
    Decomposition {
        kanji: '襯',
        radicals: &['見', '⻂', '木', '立'],
    },
    Decomposition {
        kanji: '襴',
        radicals: &['⻂', '日', '木', '門'],
    },
    Decomposition {
        kanji: '襷',
        radicals: &['手', '⻂', '⺌', '丷'],
    },
    Decomposition {
        kanji: '襾',
        radicals: &['西'],
    },
    Decomposition {
        kanji: '覃',
        radicals: &['十', '西', '日'],
    },
    Decomposition {
        kanji: '覈',
        radicals: &['西', '白', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '覊',
        radicals: &['革', '西', '馬', '⺣'],
    },
    Decomposition {
        kanji: '覓',
        radicals: &['見', '爪'],
    },
    Decomposition {
        kanji: '覘',
        radicals: &['見', '口', '卜'],
    },
    Decomposition {
        kanji: '覡',
        radicals: &['見', '工', '人'],
    },
    Decomposition {
        kanji: '覩',
        radicals: &['見', '日', '⺹', '十'],
    },
    Decomposition {
        kanji: '覦',
        radicals: &['⺉', '月', '見', '𠆢', '一'],
    },
    Decomposition {
        kanji: '覬',
        radicals: &['見', '口', '山', '豆', '丷'],
    },
    Decomposition {
        kanji: '覯',
        radicals: &['｜', '一', '見', '冂'],
    },
    Decomposition {
        kanji: '覲',
        radicals: &['見', '土', '⺾', '口', '二'],
    },
    Decomposition {
        kanji: '覺',
        radicals: &['臼', '見', '冖', '爻'],
    },
    Decomposition {
        kanji: '覽',
        radicals: &['見', '臣', '⺲', '𠂉'],
    },
    Decomposition {
        kanji: '覿',
        radicals: &['貝', '目', 'ハ', '見', '士', '儿', '囗'],
    },
    Decomposition {
        kanji: '觀',
        radicals: &['見', '口', '十', '⺾', '隹'],
    },
    Decomposition {
        kanji: '觚',
        radicals: &['瓜', '角'],
    },
    Decomposition {
        kanji: '觜',
        radicals: &['角', '止', '匕'],
    },
    Decomposition {
        kanji: '觝',
        radicals: &['角', '氏'],
    },
    Decomposition {
        kanji: '觧',
        radicals: &['王', '角', '丷', '羊'],
    },
    Decomposition {
        kanji: '觴',
        radicals: &['ノ', '角', '日', '勿', '一', '勹', '𠂉'],
    },
    Decomposition {
        kanji: '觸',
        radicals: &['角', '虫', '⺲', '勹'],
    },
    Decomposition {
        kanji: '訃',
        radicals: &['言', '卜'],
    },
    Decomposition {
        kanji: '訖',
        radicals: &['乙', '言', '𠂉'],
    },
    Decomposition {
        kanji: '訐',
        radicals: &['干', '言'],
    },
    Decomposition {
        kanji: '訌',
        radicals: &['言', '工'],
    },
    Decomposition {
        kanji: '訛',
        radicals: &['⺅', '言', '匕'],
    },
    Decomposition {
        kanji: '訝',
        radicals: &['牙', '言'],
    },
    Decomposition {
        kanji: '訥',
        radicals: &['言', '人', '冂'],
    },
    Decomposition {
        kanji: '訶',
        radicals: &['言', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '詁',
        radicals: &['言', '口', '十'],
    },
    Decomposition {
        kanji: '詛',
        radicals: &['言', '目'],
    },
    Decomposition {
        kanji: '詒',
        radicals: &['言', '口', '厶'],
    },
    Decomposition {
        kanji: '詆',
        radicals: &['言', '氏'],
    },
    Decomposition {
        kanji: '詈',
        radicals: &['言', '⺲'],
    },
    Decomposition {
        kanji: '詼',
        radicals: &['火', '言', '厂'],
    },
    Decomposition {
        kanji: '詭',
        radicals: &['言', '卩', '厂', '勹'],
    },
    Decomposition {
        kanji: '詬',
        radicals: &['言', '口', '厂'],
    },
    Decomposition {
        kanji: '詢',
        radicals: &['言', '日', '勹'],
    },
    Decomposition {
        kanji: '誅',
        radicals: &['｜', 'ノ', '牛', '言', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '誂',
        radicals: &['言', '儿', '冫'],
    },
    Decomposition {
        kanji: '誄',
        radicals: &['｜', '言', '木', '耒', 'ハ', 'ノ'],
    },
    Decomposition {
        kanji: '誨',
        radicals: &['言', '母', '毋', '𠂉'],
    },
    Decomposition {
        kanji: '誡',
        radicals: &['言', '廾', '戈'],
    },
    Decomposition {
        kanji: '誑',
        radicals: &['王', '言', '⺨'],
    },
    Decomposition {
        kanji: '誥',
        radicals: &['ノ', '言', '口', '土'],
    },
    Decomposition {
        kanji: '誦',
        radicals: &['言', '用'],
    },
    Decomposition {
        kanji: '誚',
        radicals: &['月', '言', '⺌'],
    },
    Decomposition {
        kanji: '誣',
        radicals: &['言', '工', '人'],
    },
    Decomposition {
        kanji: '諄',
        radicals: &['言', '子', '亠', '口'],
    },
    Decomposition {
        kanji: '諍',
        radicals: &['ヨ', '言', '爪', '亅'],
    },
    Decomposition {
        kanji: '諂',
        radicals: &['臼', '言'],
    },
    Decomposition {
        kanji: '諚',
        radicals: &['言', '疋', '宀'],
    },
    Decomposition {
        kanji: '諫',
        radicals: &['｜', '言', '口', '⺲', 'ハ', '木'],
    },
    Decomposition {
        kanji: '諳',
        radicals: &['音', '言', '日', '立'],
    },
    Decomposition {
        kanji: '諧',
        radicals: &['言', '白', '比'],
    },
    Decomposition {
        kanji: '諤',
        radicals: &['言', '口', '二', '勹'],
    },
    Decomposition {
        kanji: '諱',
        radicals: &['言', '口', '韋'],
    },
    Decomposition {
        kanji: '謔',
        radicals: &['言', '卜', '匕', '匚', '厂', '虍'],
    },
    Decomposition {
        kanji: '諠',
        radicals: &['言', '二', '日', '宀', '一'],
    },
    Decomposition {
        kanji: '諢',
        radicals: &['言', '車', '冖'],
    },
    Decomposition {
        kanji: '諷',
        radicals: &['言', '虫', '風', '几'],
    },
    Decomposition {
        kanji: '諞',
        radicals: &['｜', '一', '言', '戸', '冊', '尸', '廾'],
    },
    Decomposition {
        kanji: '諛',
        radicals: &['言', '人', '日', '臼'],
    },
    Decomposition {
        kanji: '謌',
        radicals: &['言', '口', '亅', '一'],
    },
    Decomposition {
        kanji: '謇',
        radicals: &['｜', '一', '言', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '謚',
        radicals: &['言', '皿', '丷'],
    },
    Decomposition {
        kanji: '諡',
        radicals: &['言', '皿', 'ハ', '一', '勹'],
    },
    Decomposition {
        kanji: '謖',
        radicals: &['言', '田', '儿', '夂'],
    },
    Decomposition {
        kanji: '謐',
        radicals: &['ノ', '言', '皿', '心', '丶'],
    },
    Decomposition {
        kanji: '謗',
        radicals: &['言', '丷', '方', '立', '亠', '冖'],
    },
    Decomposition {
        kanji: '謠',
        radicals: &['缶', '言', '夕', '凵'],
    },
    Decomposition {
        kanji: '謳',
        radicals: &['言', '口', '匚', '品'],
    },
    Decomposition {
        kanji: '鞫',
        radicals: &['革', '言', '勹'],
    },
    Decomposition {
        kanji: '謦',
        radicals: &['言', '士', '尸', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '謫',
        radicals: &['言', '口', '十', '丷', '立', '亠', '冂', '啇'],
    },
    Decomposition {
        kanji: '謾',
        radicals: &['言', '日', '⺲', '又'],
    },
    Decomposition {
        kanji: '謨',
        radicals: &['言', '大', '日', '⺾'],
    },
    Decomposition {
        kanji: '譁',
        radicals: &['｜', '一', '言', '⺾'],
    },
    Decomposition {
        kanji: '譌',
        radicals: &['ノ', '言', '爪', '⺣'],
    },
    Decomposition {
        kanji: '譏',
        radicals: &['言', '丶', '幺', '戈', 'ノ'],
    },
    Decomposition {
        kanji: '譎',
        radicals: &['言', '口', '矛', '儿', '冂'],
    },
    Decomposition {
        kanji: '證',
        radicals: &['言', '口', '豆', '丷', '癶'],
    },
    Decomposition {
        kanji: '譖',
        radicals: &['言', '日', '无'],
    },
    Decomposition {
        kanji: '譛',
        radicals: &['言', '人', '大', '二', '日'],
    },
    Decomposition {
        kanji: '譚',
        radicals: &['言', '十', '西', '日', '曰'],
    },
    Decomposition {
        kanji: '譫',
        radicals: &['言', '儿', '厂', '勹'],
    },
    Decomposition {
        kanji: '譟',
        radicals: &['言', '口', '木', '品'],
    },
    Decomposition {
        kanji: '譬',
        radicals: &['言', '口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '譯',
        radicals: &['言', '十', '辛', '土', '⺲', '立', '亠'],
    },
    Decomposition {
        kanji: '譴',
        radicals: &['｜', '一', '言', '口', '⻌'],
    },
    Decomposition {
        kanji: '譽',
        radicals: &['臼', '言', 'ハ'],
    },
    Decomposition {
        kanji: '讀',
        radicals: &['貝', '目', 'ハ', '言', '士', '儿', '囗'],
    },
    Decomposition {
        kanji: '讌',
        radicals: &['一', '言', '口', '凵', '匕', '⺣', '爿'],
    },
    Decomposition {
        kanji: '讎',
        radicals: &['言', '隹'],
    },
    Decomposition {
        kanji: '讒',
        radicals: &['言', '口', '比', '儿', '勹'],
    },
    Decomposition {
        kanji: '讓',
        radicals: &['｜', '衣', '一', '言', '口', '亠'],
    },
    Decomposition {
        kanji: '讖',
        radicals: &['言', '人', '戈', '韭'],
    },
    Decomposition {
        kanji: '讙',
        radicals: &['言', '口', '十', '⺾', '隹'],
    },
    Decomposition {
        kanji: '讚',
        radicals: &['ノ', '言', '土', '儿', '貝', '目', 'ハ'],
    },
    Decomposition {
        kanji: '谺',
        radicals: &['牙', '口', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '豁',
        radicals: &['口', '谷', '土', 'ハ', '𠆢', '亠', '宀', '二'],
    },
    Decomposition {
        kanji: '谿',
        radicals: &['口', '大', '谷', '爪', '丷', '𠆢', '幺'],
    },
    Decomposition {
        kanji: '豈',
        radicals: &['口', '山', '豆', '丷'],
    },
    Decomposition {
        kanji: '豌',
        radicals: &['口', '豆', '丷', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '豎',
        radicals: &['口', '臣', '豆', '丷', '又'],
    },
    Decomposition {
        kanji: '豐',
        radicals: &['口', '山', '豆', '丷', '凵'],
    },
    Decomposition {
        kanji: '豕',
        radicals: &['豕'],
    },
    Decomposition {
        kanji: '豢',
        radicals: &['人', '大', '二', '丷', '豕'],
    },
    Decomposition {
        kanji: '豬',
        radicals: &['日', '⺹', '豕'],
    },
    Decomposition {
        kanji: '豸',
        radicals: &['豸'],
    },
    Decomposition {
        kanji: '豺',
        radicals: &['ノ', '一', '亅', '豸'],
    },
    Decomposition {
        kanji: '貂',
        radicals: &['口', '刀', '豸'],
    },
    Decomposition {
        kanji: '貉',
        radicals: &['口', '夂', '豸'],
    },
    Decomposition {
        kanji: '貅',
        radicals: &['⺅', '木', '豸'],
    },
    Decomposition {
        kanji: '貊',
        radicals: &['白', '豸'],
    },
    Decomposition {
        kanji: '貍',
        radicals: &['里', '豸'],
    },
    Decomposition {
        kanji: '貎',
        radicals: &['臼', '儿', '豸'],
    },
    Decomposition {
        kanji: '貔',
        radicals: &['比', '囗', '豸'],
    },
    Decomposition {
        kanji: '豼',
        radicals: &['比', '豸'],
    },
    Decomposition {
        kanji: '貘',
        radicals: &['大', '日', '⺾', '豸'],
    },
    Decomposition {
        kanji: '戝',
        radicals: &['貝', '目', 'ハ', '戈'],
    },
    Decomposition {
        kanji: '貭',
        radicals: &['貝', '目', 'ハ', '十', '厂'],
    },
    Decomposition {
        kanji: '貪',
        radicals: &['貝', '目', 'ハ', '𠆢', '一'],
    },
    Decomposition {
        kanji: '貽',
        radicals: &['貝', '目', 'ハ', '口', '厶'],
    },
    Decomposition {
        kanji: '貲',
        radicals: &['貝', '目', 'ハ', '止', '匕'],
    },
    Decomposition {
        kanji: '貳',
        radicals: &['貝', '目', 'ハ', '二', '弋'],
    },
    Decomposition {
        kanji: '貮',
        radicals: &['貝', '目', 'ハ', '弋'],
    },
    Decomposition {
        kanji: '貶',
        radicals: &['ノ', '乙', '貝', '目', 'ハ', '亠'],
    },
    Decomposition {
        kanji: '賈',
        radicals: &['貝', '目', 'ハ', '西'],
    },
    Decomposition {
        kanji: '賁',
        radicals: &['貝', '目', 'ハ', '十', '⺾'],
    },
    Decomposition {
        kanji: '賤',
        radicals: &['貝', '目', 'ハ', '戈'],
    },
    Decomposition {
        kanji: '賣',
        radicals: &['貝', '目', 'ハ', '士', '⺲'],
    },
    Decomposition {
        kanji: '賚',
        radicals: &['一', '貝', '目', '人', 'ハ', '木'],
    },
    Decomposition {
        kanji: '賽',
        radicals: &['｜', '一', '貝', '目', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '賺',
        radicals: &['｜', 'ヨ', '貝', '目', 'ハ'],
    },
    Decomposition {
        kanji: '賻',
        radicals: &['貝', '目', 'ハ', '十', '寸', '田', '丶'],
    },
    Decomposition {
        kanji: '贄',
        radicals: &['九', '貝', '目', 'ハ', '十', '辛', '立', '丶', '亠'],
    },
    Decomposition {
        kanji: '贅',
        radicals: &['貝', '目', 'ハ', '土', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '贊',
        radicals: &['ノ', '貝', '目', 'ハ', '土', '儿'],
    },
    Decomposition {
        kanji: '贇',
        radicals: &['貝', '目', 'ハ', '止', '文', '戈'],
    },
    Decomposition {
        kanji: '贏',
        radicals: &['亡', '貝', '目', 'ハ', '月', '口'],
    },
    Decomposition {
        kanji: '贍',
        radicals: &['貝', '目', 'ハ', '言', '儿', '厂'],
    },
    Decomposition {
        kanji: '贐',
        radicals: &['｜', 'ヨ', '貝', '目', 'ハ', '皿', '⺣'],
    },
    Decomposition {
        kanji: '齎',
        radicals: &['貝', '目', 'ハ', '亠', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '贓',
        radicals: &['ノ', '貝', '目', 'ハ', '臣', '冫', '戈', '⽧'],
    },
    Decomposition {
        kanji: '賍',
        radicals: &['貝', '目', 'ハ', '土', '广'],
    },
    Decomposition {
        kanji: '贔',
        radicals: &['貝', '目', 'ハ'],
    },
    Decomposition {
        kanji: '贖',
        radicals: &['貝', '目', 'ハ', '士', '儿', '囗'],
    },
    Decomposition {
        kanji: '赧',
        radicals: &['｜', '口', '赤', '土', '又'],
    },
    Decomposition {
        kanji: '赭',
        radicals: &['赤', '土', '日', '⺹'],
    },
    Decomposition {
        kanji: '赱',
        radicals: &['走', '土'],
    },
    Decomposition {
        kanji: '赳',
        radicals: &['｜', '走', '土'],
    },
    Decomposition {
        kanji: '趁',
        radicals: &['走', '土', '𠆢', '彡'],
    },
    Decomposition {
        kanji: '趙',
        radicals: &['月', '⺌', '走', '土'],
    },
    Decomposition {
        kanji: '跂',
        radicals: &['口', '支', '足', '又', '十', '止'],
    },
    Decomposition {
        kanji: '趾',
        radicals: &['口', '止', '足'],
    },
    Decomposition {
        kanji: '趺',
        radicals: &['口', '人', '足', '二', '大', '止'],
    },
    Decomposition {
        kanji: '跏',
        radicals: &['口', '足', '力', '止'],
    },
    Decomposition {
        kanji: '跚',
        radicals: &['｜', '一', '口', '足', '冊', '冂', '止', '廾'],
    },
    Decomposition {
        kanji: '跖',
        radicals: &['口', '石', '足', '止'],
    },
    Decomposition {
        kanji: '跌',
        radicals: &['ノ', '口', '人', '足', '大', '土', '二', '止'],
    },
    Decomposition {
        kanji: '跛',
        radicals: &['口', '足', '皮', '又', '止'],
    },
    Decomposition {
        kanji: '跋',
        radicals: &['ノ', '一', '口', '足', '丶', '止'],
    },
    Decomposition {
        kanji: '跪',
        radicals: &['口', '足', '卩', '厂', '勹', '止'],
    },
    Decomposition {
        kanji: '跫',
        radicals: &['口', '工', '足', '丶', '几', '止'],
    },
    Decomposition {
        kanji: '跟',
        radicals: &['口', '艮', '足', '止'],
    },
    Decomposition {
        kanji: '跣',
        radicals: &['ノ', '口', '足', '土', '儿', '止'],
    },
    Decomposition {
        kanji: '跼',
        radicals: &['口', '足', '尸', '止'],
    },
    Decomposition {
        kanji: '踈',
        radicals: &['｜', '口', '足', 'ハ', '木', '止'],
    },
    Decomposition {
        kanji: '踉',
        radicals: &['口', '艮', '足', '止'],
    },
    Decomposition {
        kanji: '跿',
        radicals: &['口', '走', '足', '土', '止'],
    },
    Decomposition {
        kanji: '踝',
        radicals: &['口', '足', '田', '木', '止'],
    },
    Decomposition {
        kanji: '踞',
        radicals: &['口', '十', '足', '尸', '止'],
    },
    Decomposition {
        kanji: '踐',
        radicals: &['口', '足', '戈', '止'],
    },
    Decomposition {
        kanji: '踟',
        radicals: &['口', '足', '矢', '止', '𠂉'],
    },
    Decomposition {
        kanji: '蹂',
        radicals: &['口', '足', '矛', '木', 'マ', '止'],
    },
    Decomposition {
        kanji: '踵',
        radicals: &['｜', 'ノ', '口', '足', '日', '里', '止'],
    },
    Decomposition {
        kanji: '踰',
        radicals: &['⺉', '月', '口', '足', '𠆢', '止', '一'],
    },
    Decomposition {
        kanji: '踴',
        radicals: &['口', '足', '田', '力', 'マ', '止'],
    },
    Decomposition {
        kanji: '蹊',
        radicals: &['口', '足', '大', '爪', '幺', '止'],
    },
    Decomposition {
        kanji: '蹇',
        radicals: &['｜', '一', '口', '足', 'ハ', '宀', '止'],
    },
    Decomposition {
        kanji: '蹉',
        radicals: &['王', '口', '工', '足', '丷', '羊', '止'],
    },
    Decomposition {
        kanji: '蹌',
        radicals: &['口', '足', '𠆢', '尸', '止', '一'],
    },
    Decomposition {
        kanji: '蹐',
        radicals: &['月', '口', '人', '足', '止', '二'],
    },
    Decomposition {
        kanji: '蹈',
        radicals: &['臼', '口', '足', '爪', '止'],
    },
    Decomposition {
        kanji: '蹙',
        radicals: &['ノ', '口', '小', '足', '卜', '戈', '止'],
    },
    Decomposition {
        kanji: '蹤',
        radicals: &['口', '足', '丷', '疋', '彳', '止'],
    },
    Decomposition {
        kanji: '蹠',
        radicals: &['一', '口', '足', '凵', '广', '⺣', '止'],
    },
    Decomposition {
        kanji: '踪',
        radicals: &['口', '示', '二', '小', '足', '宀', '止'],
    },
    Decomposition {
        kanji: '蹣',
        radicals: &['一', '口', '足', '入', '冂', '凵', '止'],
    },
    Decomposition {
        kanji: '蹕',
        radicals: &['｜', '一', '口', '足', '田', '止'],
    },
    Decomposition {
        kanji: '蹶',
        radicals: &['欠', '口', '足', '丷', '厂', '屮', '止'],
    },
    Decomposition {
        kanji: '蹲',
        radicals: &['口', '寸', '足', '酉', '丷', '止'],
    },
    Decomposition {
        kanji: '蹼',
        radicals: &['王', '口', '人', '足', '丷', '羊', '止', '二', '大'],
    },
    Decomposition {
        kanji: '躁',
        radicals: &['口', '足', '木', '品', '止'],
    },
    Decomposition {
        kanji: '躇',
        radicals: &['口', '足', '日', '⺹', '⺾', '止'],
    },
    Decomposition {
        kanji: '躅',
        radicals: &['口', '足', '虫', '⺲', '勹', '止'],
    },
    Decomposition {
        kanji: '躄',
        radicals: &['口', '十', '辛', '足', '立', '尸', '止'],
    },
    Decomposition {
        kanji: '躋',
        radicals: &['口', '足', '亠', '齊', '刀', '氏', '廾', '止'],
    },
    Decomposition {
        kanji: '躊',
        radicals: &['口', '工', '士', '寸', '足', '止'],
    },
    Decomposition {
        kanji: '躓',
        radicals: &['貝', '目', 'ハ', '斤', '口', '足', '止'],
    },
    Decomposition {
        kanji: '躑',
        radicals: &['口', '足', '大', '酉', '丷', '⻏', '止'],
    },
    Decomposition {
        kanji: '躔',
        radicals: &['口', '足', '田', '土', '儿', '广', '止', '里'],
    },
    Decomposition {
        kanji: '躙',
        radicals: &['口', '足', '門', '隹', '止'],
    },
    Decomposition {
        kanji: '躪',
        radicals: &['口', '足', '門', '⺾', '隹', '止'],
    },
    Decomposition {
        kanji: '躡',
        radicals: &['口', '耳', '足', '止'],
    },
    Decomposition {
        kanji: '躬',
        radicals: &['弓', '身'],
    },
    Decomposition {
        kanji: '躰',
        radicals: &['｜', '身', '木'],
    },
    Decomposition {
        kanji: '軆',
        radicals: &['｜', '一', '口', '身', '豆', '日', '丷'],
    },
    Decomposition {
        kanji: '躱',
        radicals: &['ノ', '身', '木', '乃'],
    },
    Decomposition {
        kanji: '躾',
        radicals: &['王', '身', '大', '丷', '羊'],
    },
    Decomposition {
        kanji: '軅',
        radicals: &['⺅', '身', '厂', '隹'],
    },
    Decomposition {
        kanji: '軈',
        radicals: &['⺅', '心', '身', '广', '隹'],
    },
    Decomposition {
        kanji: '軋',
        radicals: &['乙', '車'],
    },
    Decomposition {
        kanji: '軛',
        radicals: &['車', '卩', '厂'],
    },
    Decomposition {
        kanji: '軣',
        radicals: &['車', '冫'],
    },
    Decomposition {
        kanji: '軼',
        radicals: &['ノ', '車', '人', '大', '土', '二'],
    },
    Decomposition {
        kanji: '軻',
        radicals: &['口', '車', '亅'],
    },
    Decomposition {
        kanji: '軫',
        radicals: &['車', '𠆢', '彡'],
    },
    Decomposition {
        kanji: '軾',
        radicals: &['工', '車', '戈', '弋'],
    },
    Decomposition {
        kanji: '輊',
        radicals: &['至', '車', '土', '厶', '一'],
    },
    Decomposition {
        kanji: '輅',
        radicals: &['口', '車', '夂'],
    },
    Decomposition {
        kanji: '輕',
        radicals: &['工', '車', '巛'],
    },
    Decomposition {
        kanji: '輒',
        radicals: &['乙', '耳', '車'],
    },
    Decomposition {
        kanji: '輙',
        radicals: &['耳', '車', '又'],
    },
    Decomposition {
        kanji: '輓',
        radicals: &['車', '免', '儿', '勹'],
    },
    Decomposition {
        kanji: '輜',
        radicals: &['車', '巛', '田'],
    },
    Decomposition {
        kanji: '輟',
        radicals: &['車', '又'],
    },
    Decomposition {
        kanji: '輛',
        radicals: &['｜', '車', '入', '冂'],
    },
    Decomposition {
        kanji: '輌',
        radicals: &['｜', '一', '車', '冂', '山'],
    },
    Decomposition {
        kanji: '輦',
        radicals: &['⺅', '車', '人', '大', '二'],
    },
    Decomposition {
        kanji: '輳',
        radicals: &['一', '車', '人', '大', '二'],
    },
    Decomposition {
        kanji: '輻',
        radicals: &['口', '車', '田'],
    },
    Decomposition {
        kanji: '輹',
        radicals: &['車', '日', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '轅',
        radicals: &['口', '車', '土', '衣'],
    },
    Decomposition {
        kanji: '轂',
        radicals: &['士', '車', '冖', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '輾',
        radicals: &['｜', '衣', '車', '二', '尸'],
    },
    Decomposition {
        kanji: '轌',
        radicals: &['ヨ', '雨', '車'],
    },
    Decomposition {
        kanji: '轉',
        radicals: &['車', '十', '寸', '虫', '田', '厶'],
    },
    Decomposition {
        kanji: '轆',
        radicals: &['鹿', '車', '比', '广'],
    },
    Decomposition {
        kanji: '轎',
        radicals: &['ノ', '口', '車', '大', '冂'],
    },
    Decomposition {
        kanji: '轗',
        radicals: &['ノ', '口', '車', '心', '戈'],
    },
    Decomposition {
        kanji: '轜',
        radicals: &['雨', '而', '車'],
    },
    Decomposition {
        kanji: '轢',
        radicals: &['車', '白', '木', '冫'],
    },
    Decomposition {
        kanji: '轣',
        radicals: &['止', '車', '木', '厂', '禾'],
    },
    Decomposition {
        kanji: '轤',
        radicals: &['皿', '車', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '辜',
        radicals: &['口', '十', '辛', '立'],
    },
    Decomposition {
        kanji: '辟',
        radicals: &['口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '辣',
        radicals: &['｜', '口', '十', '辛', '木', '立'],
    },
    Decomposition {
        kanji: '辭',
        radicals: &['十', '辛', '爪', '又', '立', '冂', '⽱'],
    },
    Decomposition {
        kanji: '辯',
        radicals: &['言', '十', '辛', '立'],
    },
    Decomposition {
        kanji: '辷',
        radicals: &['一', '⻌'],
    },
    Decomposition {
        kanji: '迚',
        radicals: &['｜', '口', '⻌'],
    },
    Decomposition {
        kanji: '迥',
        radicals: &['口', '⻌', '冂'],
    },
    Decomposition {
        kanji: '迢',
        radicals: &['口', '⻌', '刀'],
    },
    Decomposition {
        kanji: '迪',
        radicals: &['｜', '⻌', '日', '田'],
    },
    Decomposition {
        kanji: '迯',
        radicals: &['⻌', '卜', '夕'],
    },
    Decomposition {
        kanji: '邇',
        radicals: &['｜', '一', '⻌', 'ハ', '冂', '爻'],
    },
    Decomposition {
        kanji: '迴',
        radicals: &['口', '⻌', '囗'],
    },
    Decomposition {
        kanji: '逅',
        radicals: &['口', '⻌', '厂'],
    },
    Decomposition {
        kanji: '迹',
        radicals: &['⻌', '赤', 'ハ', '亅', '亠'],
    },
    Decomposition {
        kanji: '迺',
        radicals: &['⻌', '西'],
    },
    Decomposition {
        kanji: '逑',
        radicals: &['⻌', '水', '丶', '亠'],
    },
    Decomposition {
        kanji: '逕',
        radicals: &['一', '工', '⻌', '巛'],
    },
    Decomposition {
        kanji: '逡',
        radicals: &['⻌', '儿', '厶', '夂'],
    },
    Decomposition {
        kanji: '逍',
        radicals: &['月', '⻌', '⺌'],
    },
    Decomposition {
        kanji: '逞',
        radicals: &['王', '口', '⻌'],
    },
    Decomposition {
        kanji: '逖',
        radicals: &['火', '⻌', '⺨'],
    },
    Decomposition {
        kanji: '逋',
        radicals: &['⻌', '十', '用', '丶'],
    },
    Decomposition {
        kanji: '逧',
        radicals: &['口', '⻌', '谷', 'ハ', '𠆢'],
    },
    Decomposition {
        kanji: '逶',
        radicals: &['禾', '⻌', '女'],
    },
    Decomposition {
        kanji: '逵',
        radicals: &['⻌', '土', '儿'],
    },
    Decomposition {
        kanji: '逹',
        radicals: &['⻌', '十', '辛', '立', '亠'],
    },
    Decomposition {
        kanji: '迸',
        radicals: &['｜', 'ノ', '⻌', '二', '丷', '廾', '一'],
    },
    Decomposition {
        kanji: '遏',
        radicals: &['⻌', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '遐',
        radicals: &['｜', '口', '⻌', '又'],
    },
    Decomposition {
        kanji: '遑',
        radicals: &['王', '⻌', '白'],
    },
    Decomposition {
        kanji: '遒',
        radicals: &['⻌', '酉', '丷'],
    },
    Decomposition {
        kanji: '逎',
        radicals: &['⻌', '酉'],
    },
    Decomposition {
        kanji: '遉',
        radicals: &['貝', '目', 'ハ', '⻌', '卜'],
    },
    Decomposition {
        kanji: '逾',
        radicals: &['⺉', '月', '⻌', '𠆢', '一'],
    },
    Decomposition {
        kanji: '遖',
        radicals: &['干', '⻌', '十', '丷', '冂'],
    },
    Decomposition {
        kanji: '遘',
        radicals: &['｜', '一', '⻌', '冂'],
    },
    Decomposition {
        kanji: '遞',
        radicals: &['⻌', '卜', '儿', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '遨',
        radicals: &['⻌', '土', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '遯',
        radicals: &['⻌', '月', '豕'],
    },
    Decomposition {
        kanji: '遶',
        radicals: &['⻌', '土', '儿'],
    },
    Decomposition {
        kanji: '隨',
        radicals: &['ノ', '一', '月', '工', '⻖', '⻌'],
    },
    Decomposition {
        kanji: '遲',
        radicals: &['牛', '⻌', '水', '尸'],
    },
    Decomposition {
        kanji: '邂',
        radicals: &['角', '牛', '⻌', '刀'],
    },
    Decomposition {
        kanji: '遽',
        radicals: &['⻌', '卜', '匕', '厂', '虍', '豕'],
    },
    Decomposition {
        kanji: '邁',
        radicals: &['⻌', '田', '⽱', '⺾'],
    },
    Decomposition {
        kanji: '邀',
        radicals: &['⻌', '白', '方', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '邊',
        radicals: &['穴', '⻌', '自', '方', '儿', '宀', '目'],
    },
    Decomposition {
        kanji: '邉',
        radicals: &['口', '⻌', '自', 'ハ', '冖', '目', '儿'],
    },
    Decomposition {
        kanji: '邏',
        radicals: &['⻌', '糸', '幺', '小', '⺲', '隹'],
    },
    Decomposition {
        kanji: '邨',
        radicals: &['屯', '⻏'],
    },
    Decomposition {
        kanji: '邯',
        radicals: &['甘', '⻏'],
    },
    Decomposition {
        kanji: '邱',
        radicals: &['斤', '⻏', '一'],
    },
    Decomposition {
        kanji: '邵',
        radicals: &['口', '刀', '⻏'],
    },
    Decomposition {
        kanji: '郢',
        radicals: &['王', '口', '⻏'],
    },
    Decomposition {
        kanji: '郤',
        radicals: &['口', '谷', 'ハ', '⻏', '𠆢'],
    },
    Decomposition {
        kanji: '扈',
        radicals: &['戸', '⻏', '口', '巴', '一', '尸'],
    },
    Decomposition {
        kanji: '郛',
        radicals: &['子', '爪', '⻏'],
    },
    Decomposition {
        kanji: '鄂',
        radicals: &['口', '二', '⻏'],
    },
    Decomposition {
        kanji: '鄒',
        radicals: &['⻏', '勹', '屮', '⺾'],
    },
    Decomposition {
        kanji: '鄙',
        radicals: &['口', '⻏', '囗'],
    },
    Decomposition {
        kanji: '鄲',
        radicals: &['｜', '口', '十', '田', '⻏'],
    },
    Decomposition {
        kanji: '鄰',
        radicals: &['舛', '米', '⻏', '夕'],
    },
    Decomposition {
        kanji: '酊',
        radicals: &['酉', '亅', '一'],
    },
    Decomposition {
        kanji: '酖',
        radicals: &['酉', '尢', '冖'],
    },
    Decomposition {
        kanji: '酘',
        radicals: &['酉', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '酣',
        radicals: &['甘', '酉'],
    },
    Decomposition {
        kanji: '酥',
        radicals: &['禾', '酉'],
    },
    Decomposition {
        kanji: '酩',
        radicals: &['口', '酉', '夕'],
    },
    Decomposition {
        kanji: '酳',
        radicals: &['月', '酉', '幺'],
    },
    Decomposition {
        kanji: '酲',
        radicals: &['王', '口', '酉'],
    },
    Decomposition {
        kanji: '醋',
        radicals: &['｜', '一', '酉', '二', '日'],
    },
    Decomposition {
        kanji: '醉',
        radicals: &['十', '人', '酉', '亠'],
    },
    Decomposition {
        kanji: '醂',
        radicals: &['酉', '木'],
    },
    Decomposition {
        kanji: '醢',
        radicals: &['ノ', '一', '口', '皿', '酉'],
    },
    Decomposition {
        kanji: '醫',
        radicals: &['酉', '矢', '匚', '殳', '几', '又', '𠂉'],
    },
    Decomposition {
        kanji: '醯',
        radicals: &['皿', '川', '酉', '亠', '厶'],
    },
    Decomposition {
        kanji: '醪',
        radicals: &['羽', '酉', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '醵',
        radicals: &['酉', '卜', '匕', '厂', '虍', '豕'],
    },
    Decomposition {
        kanji: '醴',
        radicals: &['｜', '一', '口', '豆', '酉', '日', '丷'],
    },
    Decomposition {
        kanji: '醺',
        radicals: &['｜', 'ノ', '酉', '⺣'],
    },
    Decomposition {
        kanji: '釀',
        radicals: &['｜', '衣', '一', '口', '酉', '亠'],
    },
    Decomposition {
        kanji: '釁',
        radicals: &['臼', '刀', '酉', 'ハ', '冂'],
    },
    Decomposition {
        kanji: '釉',
        radicals: &['｜', '日', '釆', '米', '田'],
    },
    Decomposition {
        kanji: '釋',
        radicals: &['十', '辛', '⺲', '釆', '米', '立', '亠'],
    },
    Decomposition {
        kanji: '釐',
        radicals: &['｜', '二', 'ハ', '木', '里', '厂', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '釖',
        radicals: &['金', '刀'],
    },
    Decomposition {
        kanji: '釟',
        radicals: &['金', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '釡',
        radicals: &['金', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '釛',
        radicals: &['金', '力'],
    },
    Decomposition {
        kanji: '釼',
        radicals: &['金', '刀', '丶'],
    },
    Decomposition {
        kanji: '釵',
        radicals: &['金', '又', '丶'],
    },
    Decomposition {
        kanji: '釶',
        radicals: &['也', '金', '匕'],
    },
    Decomposition {
        kanji: '鈞',
        radicals: &['金', '冫', '勹'],
    },
    Decomposition {
        kanji: '釿',
        radicals: &['斤', '金'],
    },
    Decomposition {
        kanji: '鈔',
        radicals: &['ノ', '金', '小'],
    },
    Decomposition {
        kanji: '鈬',
        radicals: &['金', '尸', '丶'],
    },
    Decomposition {
        kanji: '鈕',
        radicals: &['｜', '一', '金'],
    },
    Decomposition {
        kanji: '鈑',
        radicals: &['金', '又', '厂'],
    },
    Decomposition {
        kanji: '鉞',
        radicals: &['｜', '金', '戈'],
    },
    Decomposition {
        kanji: '鉗',
        radicals: &['甘', '金'],
    },
    Decomposition {
        kanji: '鉅',
        radicals: &['金', '巨'],
    },
    Decomposition {
        kanji: '鉉',
        radicals: &['金', '玄', '亠', '幺'],
    },
    Decomposition {
        kanji: '鉤',
        radicals: &['金', '口', '勹'],
    },
    Decomposition {
        kanji: '鉈',
        radicals: &['金', '匕', '宀'],
    },
    Decomposition {
        kanji: '銕',
        radicals: &['弓', '金', '人', '大'],
    },
    Decomposition {
        kanji: '鈿',
        radicals: &['金', '田'],
    },
    Decomposition {
        kanji: '鉋',
        radicals: &['金', '勹', '已'],
    },
    Decomposition {
        kanji: '鉐',
        radicals: &['金', '口', '石'],
    },
    Decomposition {
        kanji: '銜',
        radicals: &['金', '行', '彳'],
    },
    Decomposition {
        kanji: '銖',
        radicals: &['｜', 'ノ', '牛', '金', '二', '丷', '木', 'ハ'],
    },
    Decomposition {
        kanji: '銓',
        radicals: &['王', '金', '𠆢'],
    },
    Decomposition {
        kanji: '銛',
        radicals: &['金', '口', '舌'],
    },
    Decomposition {
        kanji: '鉚',
        radicals: &['ノ', '金', '卩'],
    },
    Decomposition {
        kanji: '鋏',
        radicals: &['金', '人', '大', '𠆢'],
    },
    Decomposition {
        kanji: '銹',
        radicals: &['ノ', '禾', '金', '乃'],
    },
    Decomposition {
        kanji: '銷',
        radicals: &['金', '月', '⺌'],
    },
    Decomposition {
        kanji: '鋩',
        radicals: &['亡', '金', '⺾'],
    },
    Decomposition {
        kanji: '錏',
        radicals: &['｜', '一', '金', '二'],
    },
    Decomposition {
        kanji: '鋺',
        radicals: &['金', '夕', '卩', '宀'],
    },
    Decomposition {
        kanji: '鍄',
        radicals: &['金', '口', '小', '亠'],
    },
    Decomposition {
        kanji: '錮',
        radicals: &['金', '口', '十', '囗'],
    },
    Decomposition {
        kanji: '錙',
        radicals: &['金', '巛', '田'],
    },
    Decomposition {
        kanji: '錢',
        radicals: &['金', '戈'],
    },
    Decomposition {
        kanji: '錚',
        radicals: &['ヨ', '金', '爪', '亅'],
    },
    Decomposition {
        kanji: '錣',
        radicals: &['金', '又'],
    },
    Decomposition {
        kanji: '錺',
        radicals: &['金', '方', '⺾'],
    },
    Decomposition {
        kanji: '錵',
        radicals: &['⺅', '金', '𠆢', '匕', '⺾'],
    },
    Decomposition {
        kanji: '錻',
        radicals: &['金', '止', '戈'],
    },
    Decomposition {
        kanji: '鍜',
        radicals: &['｜', '金', '又'],
    },
    Decomposition {
        kanji: '鍠',
        radicals: &['王', '金', '白'],
    },
    Decomposition {
        kanji: '鍼',
        radicals: &['ノ', '金', '口', '戈'],
    },
    Decomposition {
        kanji: '鍮',
        radicals: &['⺉', '金', '月', '𠆢', '一'],
    },
    Decomposition {
        kanji: '鍖',
        radicals: &['甘', '金', '儿', '匚'],
    },
    Decomposition {
        kanji: '鎰',
        radicals: &['金', '皿', '丷', 'ハ'],
    },
    Decomposition {
        kanji: '鎬',
        radicals: &['金', '口', '高', '亠', '冂'],
    },
    Decomposition {
        kanji: '鎭',
        radicals: &['金', '丷', '目', '匕', '一', '｜', 'ハ'],
    },
    Decomposition {
        kanji: '鎔',
        radicals: &['金', '穴', '口', '谷', '丷', '𠆢', '宀', 'ハ'],
    },
    Decomposition {
        kanji: '鎹',
        radicals: &['金', '⻌', '人', '大', '二', 'ハ'],
    },
    Decomposition {
        kanji: '鏖',
        radicals: &['金', '鹿', '比', '广'],
    },
    Decomposition {
        kanji: '鏗',
        radicals: &['金', '臣', '土', '又'],
    },
    Decomposition {
        kanji: '鏨',
        radicals: &['斤', '金', '車'],
    },
    Decomposition {
        kanji: '鏥',
        radicals: &['⺅', '金', '白', '𠆢', '宀'],
    },
    Decomposition {
        kanji: '鏘',
        radicals: &['金', '寸', '夕', '爿'],
    },
    Decomposition {
        kanji: '鏃',
        radicals: &['金', '方', '矢', '𠂉'],
    },
    Decomposition {
        kanji: '鏝',
        radicals: &['金', '日', '⺲', '又'],
    },
    Decomposition {
        kanji: '鏐',
        radicals: &['羽', '金', '𠆢', '冫', '彡'],
    },
    Decomposition {
        kanji: '鏈',
        radicals: &['金', '⻌', '車'],
    },
    Decomposition {
        kanji: '鏤',
        radicals: &['｜', '一', '金', '口', '女'],
    },
    Decomposition {
        kanji: '鐚',
        radicals: &['金', '心', '二'],
    },
    Decomposition {
        kanji: '鐔',
        radicals: &['金', '十', '西', '日', '曰'],
    },
    Decomposition {
        kanji: '鐓',
        radicals: &['金', '子', '亠', '囗', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '鐃',
        radicals: &['金', '土', '儿'],
    },
    Decomposition {
        kanji: '鐇',
        radicals: &['金', '田', '釆', '米'],
    },
    Decomposition {
        kanji: '鐐',
        radicals: &['金', '小', '大', '日', '丷', '亠', 'ハ'],
    },
    Decomposition {
        kanji: '鐶',
        radicals: &['衣', '金', '口', '⺲'],
    },
    Decomposition {
        kanji: '鐫',
        radicals: &['金', '隹'],
    },
    Decomposition {
        kanji: '鐵',
        radicals: &['王', '金', '口', '土', '戈'],
    },
    Decomposition {
        kanji: '鐡',
        radicals: &['金', '口', '土', '豆', '丷', '戈'],
    },
    Decomposition {
        kanji: '鐺',
        radicals: &['金', '口', '⺌', '田', '冖'],
    },
    Decomposition {
        kanji: '鑁',
        radicals: &['金', '儿', '凵', '夂'],
    },
    Decomposition {
        kanji: '鑒',
        radicals: &['金', '臣', '二', '⺲', '𠂉'],
    },
    Decomposition {
        kanji: '鑄',
        radicals: &['金', '口', '工', '士', '寸'],
    },
    Decomposition {
        kanji: '鑛',
        radicals: &['黄', '金', '田', 'ハ', '广'],
    },
    Decomposition {
        kanji: '鑠',
        radicals: &['金', '白', '木', '冫'],
    },
    Decomposition {
        kanji: '鑢',
        radicals: &['金', '心', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '鑞',
        radicals: &['臼', '金', '巛', '鼠', '囗'],
    },
    Decomposition {
        kanji: '鑪',
        radicals: &['金', '皿', '田', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '鈩',
        radicals: &['金', '戸', '一', '尸'],
    },
    Decomposition {
        kanji: '鑰',
        radicals: &['｜', '一', '金', '口', '𠆢', '冂', '冊', '龠', '廾'],
    },
    Decomposition {
        kanji: '鑵',
        radicals: &['金', '口', '十', '⺾', '隹'],
    },
    Decomposition {
        kanji: '鑷',
        radicals: &['金', '耳'],
    },
    Decomposition {
        kanji: '鑽',
        radicals: &['ノ', '貝', '目', 'ハ', '金', '土', '儿'],
    },
    Decomposition {
        kanji: '鑚',
        radicals: &['貝', '目', 'ハ', '金', '人', '大', '二', '儿'],
    },
    Decomposition {
        kanji: '鑼',
        radicals: &['金', '糸', '幺', '小', '⺲', '隹'],
    },
    Decomposition {
        kanji: '鑾',
        radicals: &['金', '言', '糸', '幺', '小'],
    },
    Decomposition {
        kanji: '钁',
        radicals: &['金', '又', '目', '隹'],
    },
    Decomposition {
        kanji: '鑿',
        radicals: &['臼', '干', '金', '丷', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '閂',
        radicals: &['一', '門'],
    },
    Decomposition {
        kanji: '閇',
        radicals: &['卜', '門'],
    },
    Decomposition {
        kanji: '閊',
        radicals: &['山', '門'],
    },
    Decomposition {
        kanji: '閔',
        radicals: &['文', '門'],
    },
    Decomposition {
        kanji: '閖',
        radicals: &['水', '門'],
    },
    Decomposition {
        kanji: '閘',
        radicals: &['｜', '日', '門', '田'],
    },
    Decomposition {
        kanji: '閙',
        radicals: &['巾', '門', '亠'],
    },
    Decomposition {
        kanji: '閠',
        radicals: &['王', '門', '丶'],
    },
    Decomposition {
        kanji: '閨',
        radicals: &['土', '門'],
    },
    Decomposition {
        kanji: '閧',
        radicals: &['｜', '一', '二', 'ハ', '門'],
    },
    Decomposition {
        kanji: '閭',
        radicals: &['口', '門', 'ノ'],
    },
    Decomposition {
        kanji: '閼',
        radicals: &['方', '門', '𠆢', '冫'],
    },
    Decomposition {
        kanji: '閻',
        radicals: &['臼', '門', '勹'],
    },
    Decomposition {
        kanji: '閹',
        radicals: &['乙', '大', '日', '門', '奄'],
    },
    Decomposition {
        kanji: '閾',
        radicals: &['口', '門', '戈'],
    },
    Decomposition {
        kanji: '闊',
        radicals: &['口', '⺡', '舌', '門'],
    },
    Decomposition {
        kanji: '濶',
        radicals: &['口', '⺡', '舌', '門'],
    },
    Decomposition {
        kanji: '闃',
        radicals: &['犬', '目', '門'],
    },
    Decomposition {
        kanji: '闍',
        radicals: &['日', '門', '⺹'],
    },
    Decomposition {
        kanji: '闌',
        radicals: &['｜', '日', 'ハ', '木', '門'],
    },
    Decomposition {
        kanji: '闕',
        radicals: &['欠', '丷', '門', '屮'],
    },
    Decomposition {
        kanji: '闔',
        radicals: &['皿', '土', '門', '厶'],
    },
    Decomposition {
        kanji: '闖',
        radicals: &['馬', '門', '⺣'],
    },
    Decomposition {
        kanji: '關',
        radicals: &['門', '幺'],
    },
    Decomposition {
        kanji: '闡',
        radicals: &['口', '十', '田', '門'],
    },
    Decomposition {
        kanji: '闥',
        radicals: &['王', '⻌', '十', '辛', '土', '門', '羊', '立', '亠', '二'],
    },
    Decomposition {
        kanji: '闢',
        radicals: &['口', '十', '辛', '門', '立', '尸'],
    },
    Decomposition {
        kanji: '阡',
        radicals: &['ノ', '十', '⻖'],
    },
    Decomposition {
        kanji: '阨',
        radicals: &['卩', '厂', '⻖'],
    },
    Decomposition {
        kanji: '阮',
        radicals: &['二', '儿', '⻖', '元'],
    },
    Decomposition {
        kanji: '阯',
        radicals: &['止', '⻖'],
    },
    Decomposition {
        kanji: '陂',
        radicals: &['皮', '又', '⻖'],
    },
    Decomposition {
        kanji: '陌',
        radicals: &['白', '⻖'],
    },
    Decomposition {
        kanji: '陏',
        radicals: &['ノ', '一', '月', '⻖'],
    },
    Decomposition {
        kanji: '陋',
        radicals: &['人', '冂', '⻖'],
    },
    Decomposition {
        kanji: '陷',
        radicals: &['臼', '⻖', '勹'],
    },
    Decomposition {
        kanji: '陜',
        radicals: &['人', '大', '⻖'],
    },
    Decomposition {
        kanji: '陞',
        radicals: &['土', '廾', '⻖', 'ノ'],
    },
    Decomposition {
        kanji: '陝',
        radicals: &['人', '大', '入', '⻖'],
    },
    Decomposition {
        kanji: '陟',
        radicals: &['ノ', '止', '小', '⻖'],
    },
    Decomposition {
        kanji: '陦',
        radicals: &['ノ', '寸', '二', '⻖', '土'],
    },
    Decomposition {
        kanji: '陲',
        radicals: &['｜', 'ノ', '一', '⻖'],
    },
    Decomposition {
        kanji: '陬',
        radicals: &['耳', '又', '⻖'],
    },
    Decomposition {
        kanji: '隍',
        radicals: &['王', '白', '⻖'],
    },
    Decomposition {
        kanji: '隘',
        radicals: &['皿', '丷', '⻖'],
    },
    Decomposition {
        kanji: '隕',
        radicals: &['貝', '目', 'ハ', '口', '⻖'],
    },
    Decomposition {
        kanji: '隗',
        radicals: &['鬼', '田', '儿', '匕', '⻖', '厶'],
    },
    Decomposition {
        kanji: '險',
        radicals: &['口', '人', '𠆢', '⻖', '一'],
    },
    Decomposition {
        kanji: '隧',
        radicals: &['⻌', '丷', '豕', '⻖'],
    },
    Decomposition {
        kanji: '隱',
        radicals: &['ヨ', '工', '心', '爪', '⻖'],
    },
    Decomposition {
        kanji: '隲',
        radicals: &['ノ', '小', '馬', '⻖', '⺣'],
    },
    Decomposition {
        kanji: '隰',
        radicals: &['日', '幺', '⺣', '⻖'],
    },
    Decomposition {
        kanji: '隴',
        radicals: &['月', '立', '⻖'],
    },
    Decomposition {
        kanji: '隶',
        radicals: &['ヨ', '水', '隶'],
    },
    Decomposition {
        kanji: '隸',
        radicals: &['ヨ', '示', '二', '小', '水', '木', '亅', '隶'],
    },
    Decomposition {
        kanji: '隹',
        radicals: &['隹'],
    },
    Decomposition {
        kanji: '雎',
        radicals: &['目', '隹'],
    },
    Decomposition {
        kanji: '雋',
        radicals: &['亅', '冂', '凵', '隹'],
    },
    Decomposition {
        kanji: '雉',
        radicals: &['矢', '隹', '𠂉'],
    },
    Decomposition {
        kanji: '雍',
        radicals: &['亠', '幺', '隹'],
    },
    Decomposition {
        kanji: '襍',
        radicals: &['⻂', '木', '隹'],
    },
    Decomposition {
        kanji: '雜',
        radicals: &['人', '木', '亠', '隹'],
    },
    Decomposition {
        kanji: '霍',
        radicals: &['雨', '隹'],
    },
    Decomposition {
        kanji: '雕',
        radicals: &['口', '士', '冂', '隹'],
    },
    Decomposition {
        kanji: '雹',
        radicals: &['雨', '勹', '已'],
    },
    Decomposition {
        kanji: '霄',
        radicals: &['雨', '月', '⺌'],
    },
    Decomposition {
        kanji: '霆',
        radicals: &['雨', '王', '廴'],
    },
    Decomposition {
        kanji: '霈',
        radicals: &['雨', '巾', '⺡', '亠'],
    },
    Decomposition {
        kanji: '霓',
        radicals: &['雨', '臼', '儿'],
    },
    Decomposition {
        kanji: '霎',
        radicals: &['雨', '女', '立'],
    },
    Decomposition {
        kanji: '霑',
        radicals: &['雨', '口', '⺡', '卜'],
    },
    Decomposition {
        kanji: '霏',
        radicals: &['雨', '非'],
    },
    Decomposition {
        kanji: '霖',
        radicals: &['雨', '木'],
    },
    Decomposition {
        kanji: '霙',
        radicals: &['雨', '大', '冂', '⺾', '冖'],
    },
    Decomposition {
        kanji: '霤',
        radicals: &['雨', '田', '刀', '厶'],
    },
    Decomposition {
        kanji: '霪',
        radicals: &['雨', '王', '⺡', '爪'],
    },
    Decomposition {
        kanji: '霰',
        radicals: &['｜', '一', '雨', '月', '二', '攵', '𠂉'],
    },
    Decomposition {
        kanji: '霹',
        radicals: &['雨', '口', '十', '辛', '立', '尸'],
    },
    Decomposition {
        kanji: '霽',
        radicals: &['雨', '亠', '齊', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '霾',
        radicals: &['雨', '里', '豸'],
    },
    Decomposition {
        kanji: '靄',
        radicals: &['雨', '言', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '靆',
        radicals: &['ヨ', '雨', '⻌', '水', '二', '厶', '隶'],
    },
    Decomposition {
        kanji: '靈',
        radicals: &['雨', '口', '工', '人'],
    },
    Decomposition {
        kanji: '靂',
        radicals: &['雨', '止', '木', '厂'],
    },
    Decomposition {
        kanji: '靉',
        radicals: &['雨', '心', '爪', '二', '冖', '厶', '夂'],
    },
    Decomposition {
        kanji: '靜',
        radicals: &['ノ', 'ヨ', '月', '⺌', '青', '爪', '土', '二', '亅', '亠'],
    },
    Decomposition {
        kanji: '靠',
        radicals: &['ノ', '口', '土', '非'],
    },
    Decomposition {
        kanji: '靤',
        radicals: &['面', '勹', '已'],
    },
    Decomposition {
        kanji: '靦',
        radicals: &['見', '面'],
    },
    Decomposition {
        kanji: '靨',
        radicals: &['犬', '日', '面', '目', '厂'],
    },
    Decomposition {
        kanji: '勒',
        radicals: &['革', '力'],
    },
    Decomposition {
        kanji: '靫',
        radicals: &['革', '又', '丶'],
    },
    Decomposition {
        kanji: '靱',
        radicals: &['革', '刀'],
    },
    Decomposition {
        kanji: '靹',
        radicals: &['革', '人', '冂'],
    },
    Decomposition {
        kanji: '鞅',
        radicals: &['革', '口', '人', '大', '冂', '凵', '冖'],
    },
    Decomposition {
        kanji: '靼',
        radicals: &['革', '日', '一'],
    },
    Decomposition {
        kanji: '鞁',
        radicals: &['革', '皮', '又'],
    },
    Decomposition {
        kanji: '靺',
        radicals: &['｜', '革', '口', 'ハ', '木', '亠', '凵'],
    },
    Decomposition {
        kanji: '鞆',
        radicals: &['革', '人', '冂'],
    },
    Decomposition {
        kanji: '鞋',
        radicals: &['革', '土'],
    },
    Decomposition {
        kanji: '鞏',
        radicals: &['革', '工', '丶', '几'],
    },
    Decomposition {
        kanji: '鞐',
        radicals: &['革', '卜'],
    },
    Decomposition {
        kanji: '鞜',
        radicals: &['革', '水', '日'],
    },
    Decomposition {
        kanji: '鞨',
        radicals: &['革', '日', '勹', '匕'],
    },
    Decomposition {
        kanji: '鞦',
        radicals: &['火', '禾', '革'],
    },
    Decomposition {
        kanji: '鞣',
        radicals: &['｜', '革', '口', '矛', '木', '凵', 'マ'],
    },
    Decomposition {
        kanji: '鞳',
        radicals: &['革', '口', '𠆢', '⺾', '一'],
    },
    Decomposition {
        kanji: '鞴',
        radicals: &['革', '用', '厂', '⺾'],
    },
    Decomposition {
        kanji: '韃',
        radicals: &['王', '革', '⻌', '土', '丷', '羊'],
    },
    Decomposition {
        kanji: '韆',
        radicals: &['革', '⻌', '西', 'ハ', '已'],
    },
    Decomposition {
        kanji: '韈',
        radicals: &['ノ', '革', '⺲', '戈', '⺾'],
    },
    Decomposition {
        kanji: '韋',
        radicals: &['韋', '口'],
    },
    Decomposition {
        kanji: '韜',
        radicals: &['臼', '爪', '韋', '口'],
    },
    Decomposition {
        kanji: '韭',
        radicals: &['韭'],
    },
    Decomposition {
        kanji: '齏',
        radicals: &['亠', '齊', '韭', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '韲',
        radicals: &['亠', '齊', '韭', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '竟',
        radicals: &['音', '日', '立', '儿'],
    },
    Decomposition {
        kanji: '韶',
        radicals: &['音', '口', '刀', '日', '立'],
    },
    Decomposition {
        kanji: '韵',
        radicals: &['音', '日', '立', '冫', '勹'],
    },
    Decomposition {
        kanji: '頏',
        radicals: &['貝', '目', 'ハ', '頁', '亠', '儿'],
    },
    Decomposition {
        kanji: '頌',
        radicals: &['貝', '目', 'ハ', '頁', '厶'],
    },
    Decomposition {
        kanji: '頸',
        radicals: &['貝', '目', 'ハ', '工', '巛', '頁'],
    },
    Decomposition {
        kanji: '頤',
        radicals: &['貝', '目', 'ハ', '臣', '頁', '匚'],
    },
    Decomposition {
        kanji: '頡',
        radicals: &['貝', '目', 'ハ', '口', '士', '頁'],
    },
    Decomposition {
        kanji: '頷',
        radicals: &['貝', '目', 'ハ', '口', '頁', '𠆢', '一'],
    },
    Decomposition {
        kanji: '頽',
        radicals: &['禾', '貝', '目', 'ハ', '頁', '几'],
    },
    Decomposition {
        kanji: '顆',
        radicals: &['｜', '貝', '目', 'ハ', '田', '日', '頁', '木'],
    },
    Decomposition {
        kanji: '顏',
        radicals: &['貝', '目', 'ハ', '文', '頁', '厂', '彡'],
    },
    Decomposition {
        kanji: '顋',
        radicals: &['貝', '目', 'ハ', '心', '田', '頁'],
    },
    Decomposition {
        kanji: '顫',
        radicals: &['貝', '目', 'ハ', '口', '日', '頁', '亠', '囗', '一'],
    },
    Decomposition {
        kanji: '顯',
        radicals: &['貝', '目', 'ハ', '日', '頁', '幺', '⺣'],
    },
    Decomposition {
        kanji: '顰',
        radicals: &['ノ', '貝', '目', 'ハ', '止', '十', '小', '田', '頁'],
    },
    Decomposition {
        kanji: '顱',
        radicals: &['貝', '目', 'ハ', '皿', '田', '頁', '卜', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '顴',
        radicals: &['貝', '目', 'ハ', '口', '十', '頁', '⺾', '隹'],
    },
    Decomposition {
        kanji: '顳',
        radicals: &['貝', '目', 'ハ', '耳', '頁'],
    },
    Decomposition {
        kanji: '颪',
        radicals: &['風', '卜', '虫', '几', '一'],
    },
    Decomposition {
        kanji: '颯',
        radicals: &['風', '立', '虫', '几'],
    },
    Decomposition {
        kanji: '颱',
        radicals: &['口', '風', '厶', '虫', '几'],
    },
    Decomposition {
        kanji: '颶',
        radicals: &['ハ', '風', '目', '虫', '几'],
    },
    Decomposition {
        kanji: '飄',
        radicals: &['示', '二', '小', '西', '風', '虫', '几'],
    },
    Decomposition {
        kanji: '飃',
        radicals: &['示', '二', '小', '西', '風', '虫', '几'],
    },
    Decomposition {
        kanji: '飆',
        radicals: &['犬', '風', '虫', '几'],
    },
    Decomposition {
        kanji: '飩',
        radicals: &['食', '屯'],
    },
    Decomposition {
        kanji: '飫',
        radicals: &['ノ', '食', '大'],
    },
    Decomposition {
        kanji: '餃',
        radicals: &['食', '父', '亠'],
    },
    Decomposition {
        kanji: '餉',
        radicals: &['口', '食', '冂'],
    },
    Decomposition {
        kanji: '餒',
        radicals: &['女', '食', '爪'],
    },
    Decomposition {
        kanji: '餔',
        radicals: &['十', '食', '用', '丶'],
    },
    Decomposition {
        kanji: '餘',
        radicals: &['干', '食', '二', 'ハ', '𠆢', '亅', '一'],
    },
    Decomposition {
        kanji: '餡',
        radicals: &['臼', '食'],
    },
    Decomposition {
        kanji: '餝',
        radicals: &['食', '方', '⺾'],
    },
    Decomposition {
        kanji: '餞',
        radicals: &['食', '戈'],
    },
    Decomposition {
        kanji: '餤',
        radicals: &['火', '食'],
    },
    Decomposition {
        kanji: '餠',
        radicals: &['｜', '干', '食'],
    },
    Decomposition {
        kanji: '餬',
        radicals: &['口', '十', '食', '月'],
    },
    Decomposition {
        kanji: '餮',
        radicals: &['食', '𠆢', '彡', '歹'],
    },
    Decomposition {
        kanji: '餽',
        radicals: &['鬼', '食', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '餾',
        radicals: &['食', '田', '卩', '厶', '刀'],
    },
    Decomposition {
        kanji: '饂',
        radicals: &['皿', '食', '日'],
    },
    Decomposition {
        kanji: '饉',
        radicals: &['｜', '一', '食', '二', '⺾', '土', '口'],
    },
    Decomposition {
        kanji: '饅',
        radicals: &['食', '日', '⺲', '又'],
    },
    Decomposition {
        kanji: '饐',
        radicals: &['口', '士', '食', '豆', '丷', '冖'],
    },
    Decomposition {
        kanji: '饋',
        radicals: &['｜', '一', '貝', '目', 'ハ', '口', '食'],
    },
    Decomposition {
        kanji: '饑',
        radicals: &['食', '丶', '幺', '戈', 'ノ'],
    },
    Decomposition {
        kanji: '饒',
        radicals: &['食', '土', '儿'],
    },
    Decomposition {
        kanji: '饌',
        radicals: &['｜', '食', '二', 'ハ', '已'],
    },
    Decomposition {
        kanji: '饕',
        radicals: &['口', '食', '卜', '儿', '匕', '厂', '虍'],
    },
    Decomposition {
        kanji: '馗',
        radicals: &['九', '自', '首', '丷', '目'],
    },
    Decomposition {
        kanji: '馘',
        radicals: &['口', '自', '首', '丷', '目', '戈'],
    },
    Decomposition {
        kanji: '馥',
        radicals: &['禾', '香', '日', '夂', '𠂉'],
    },
    Decomposition {
        kanji: '馭',
        radicals: &['馬', '又', '⺣'],
    },
    Decomposition {
        kanji: '馮',
        radicals: &['馬', '冫', '⺣'],
    },
    Decomposition {
        kanji: '馼',
        radicals: &['馬', '文', '⺣'],
    },
    Decomposition {
        kanji: '駟',
        radicals: &['馬', '儿', '囗', '⺣'],
    },
    Decomposition {
        kanji: '駛',
        radicals: &['ノ', '口', '馬', '⺣'],
    },
    Decomposition {
        kanji: '駝',
        radicals: &['馬', '匕', '宀', '⺣'],
    },
    Decomposition {
        kanji: '駘',
        radicals: &['口', '馬', '厶', '⺣'],
    },
    Decomposition {
        kanji: '駑',
        radicals: &['女', '馬', '又', '⺣'],
    },
    Decomposition {
        kanji: '駭',
        radicals: &['人', '馬', '亠', '⺣', 'ノ', '丶'],
    },
    Decomposition {
        kanji: '駮',
        radicals: &['馬', '父', '亠', '⺣'],
    },
    Decomposition {
        kanji: '駱',
        radicals: &['口', '馬', '夂', '⺣'],
    },
    Decomposition {
        kanji: '駲',
        radicals: &['｜', 'ノ', '川', '馬', '丶', '⺣'],
    },
    Decomposition {
        kanji: '駻',
        radicals: &['干', '日', '馬', '⺣'],
    },
    Decomposition {
        kanji: '駸',
        radicals: &['ヨ', '馬', '又', '冖', '⺣'],
    },
    Decomposition {
        kanji: '騁',
        radicals: &['｜', '日', '馬', '一', '勹', '田', '⺣'],
    },
    Decomposition {
        kanji: '騏',
        radicals: &['甘', '馬', 'ハ', '⺣'],
    },
    Decomposition {
        kanji: '騅',
        radicals: &['馬', '隹', '⺣'],
    },
    Decomposition {
        kanji: '駢',
        radicals: &['｜', 'ノ', '二', '馬', '丷', '廾', '⺣', '一'],
    },
    Decomposition {
        kanji: '騙',
        radicals: &['｜', '一', '戸', '馬', '冂', '冊', '尸', '⺣', '廾'],
    },
    Decomposition {
        kanji: '騫',
        radicals: &['｜', '一', '馬', 'ハ', '宀', '⺣'],
    },
    Decomposition {
        kanji: '騷',
        radicals: &['虫', '馬', '又', '丶', '⺣'],
    },
    Decomposition {
        kanji: '驅',
        radicals: &['口', '馬', '匚', '品', '⺣'],
    },
    Decomposition {
        kanji: '驂',
        radicals: &['大', '馬', '厶', '彡', '⺣', '𠆢'],
    },
    Decomposition {
        kanji: '驀',
        radicals: &['大', '日', '馬', '⺾', '⺣'],
    },
    Decomposition {
        kanji: '驃',
        radicals: &['示', '二', '小', '西', '馬', '⺣'],
    },
    Decomposition {
        kanji: '騾',
        radicals: &['糸', '幺', '小', '田', '馬', '⺣'],
    },
    Decomposition {
        kanji: '驕',
        radicals: &['ノ', '口', '大', '馬', '冂', '⺣'],
    },
    Decomposition {
        kanji: '驍',
        radicals: &['土', '馬', '儿', '⺣'],
    },
    Decomposition {
        kanji: '驛',
        radicals: &['十', '辛', '馬', '⺲', '立', '亠', '⺣'],
    },
    Decomposition {
        kanji: '驗',
        radicals: &['口', '人', '馬', '𠆢', '⺣', '一'],
    },
    Decomposition {
        kanji: '驟',
        radicals: &['衣', '耳', '馬', '又', '⺣'],
    },
    Decomposition {
        kanji: '驢',
        radicals: &['皿', '田', '馬', '卜', '匕', '厂', '虍', '⺣'],
    },
    Decomposition {
        kanji: '驥',
        radicals: &['｜', '田', '二', '馬', 'ハ', '匕', '爿', '⺣'],
    },
    Decomposition {
        kanji: '驤',
        radicals: &['｜', '衣', '二', '馬', 'ハ', '亠', '⺣', '井'],
    },
    Decomposition {
        kanji: '驩',
        radicals: &['口', '十', '馬', '⺾', '隹', '⺣'],
    },
    Decomposition {
        kanji: '驫',
        radicals: &['馬', '⺣'],
    },
    Decomposition {
        kanji: '驪',
        radicals: &['鹿', '馬', '比', '亠', '冂', '广', '⺣'],
    },
    Decomposition {
        kanji: '骭',
        radicals: &['干', '月', '骨', '冂', '冖'],
    },
    Decomposition {
        kanji: '骰',
        radicals: &['月', '骨', '冂', '冖', '殳', '几', '又'],
    },
    Decomposition {
        kanji: '骼',
        radicals: &['月', '口', '骨', '冂', '冖', '夂'],
    },
    Decomposition {
        kanji: '髀',
        radicals: &['月', '骨', '十', '田', '冂', '冖'],
    },
    Decomposition {
        kanji: '髏',
        radicals: &['｜', '一', '月', '口', '骨', '女', '冂', '冖'],
    },
    Decomposition {
        kanji: '髑',
        radicals: &['月', '骨', '虫', '⺲', '冂', '冖', '勹'],
    },
    Decomposition {
        kanji: '髓',
        radicals: &['ノ', '一', '月', '工', '骨', '⻌', '冂', '冖'],
    },
    Decomposition {
        kanji: '體',
        radicals: &['｜', '月', '口', '骨', '豆', '日', '丷', '冂', '冖'],
    },
    Decomposition {
        kanji: '髞',
        radicals: &['口', '高', '木', '亠', '冂', '品'],
    },
    Decomposition {
        kanji: '髟',
        radicals: &['長', '彡', '髟'],
    },
    Decomposition {
        kanji: '髢',
        radicals: &['也', '長', '匕', '彡', '髟'],
    },
    Decomposition {
        kanji: '髣',
        radicals: &['長', '方', '彡', '髟'],
    },
    Decomposition {
        kanji: '髦',
        radicals: &['長', '毛', '彡', '髟'],
    },
    Decomposition {
        kanji: '髯',
        radicals: &['｜', '一', '長', '冂', '厶', '彡', '髟', '十'],
    },
    Decomposition {
        kanji: '髫',
        radicals: &['口', '長', '刀', '彡', '髟'],
    },
    Decomposition {
        kanji: '髮',
        radicals: &['長', '彡', '攵', '髟', '又'],
    },
    Decomposition {
        kanji: '髴',
        radicals: &['｜', 'ノ', '弓', '長', '彡', '髟'],
    },
    Decomposition {
        kanji: '髱',
        radicals: &['長', '勹', '已', '彡', '髟'],
    },
    Decomposition {
        kanji: '髷',
        radicals: &['｜', '長', '日', '厶', '彡', '髟'],
    },
    Decomposition {
        kanji: '髻',
        radicals: &['口', '士', '長', '彡', '髟'],
    },
    Decomposition {
        kanji: '鬆',
        radicals: &['長', 'ハ', '木', '厶', '彡', '髟'],
    },
    Decomposition {
        kanji: '鬘',
        radicals: &['長', '日', '⺲', '又', '彡', '髟'],
    },
    Decomposition {
        kanji: '鬚',
        radicals: &['貝', '目', 'ハ', '長', '頁', '彡', '髟'],
    },
    Decomposition {
        kanji: '鬟',
        radicals: &['衣', '一', '口', '長', '⺲', '彡', '髟'],
    },
    Decomposition {
        kanji: '鬢',
        radicals: &['ノ', '貝', '目', 'ハ', '小', '長', '宀', '彡', '髟'],
    },
    Decomposition {
        kanji: '鬣',
        radicals: &['臼', '鼠', '長', '囗', '彡', '髟', '巛'],
    },
    Decomposition {
        kanji: '鬥',
        radicals: &['鬥'],
    },
    Decomposition {
        kanji: '鬧',
        radicals: &['巾', '亠', '鬥'],
    },
    Decomposition {
        kanji: '鬨',
        radicals: &['｜', '二', 'ハ', '亅', '鬥'],
    },
    Decomposition {
        kanji: '鬩',
        radicals: &['臼', '儿', '鬥'],
    },
    Decomposition {
        kanji: '鬪',
        radicals: &['口', '寸', '豆', '丷', '鬥'],
    },
    Decomposition {
        kanji: '鬮',
        radicals: &['亀', '鬥', '乙', '勹', '田'],
    },
    Decomposition {
        kanji: '鬯',
        radicals: &['凵', '匕', '鬯'],
    },
    Decomposition {
        kanji: '鬲',
        radicals: &['口', '儿', '冂', '鬲'],
    },
    Decomposition {
        kanji: '魄',
        radicals: &['鬼', '田', '白', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '魃',
        radicals: &['鬼', '田', '丶', '儿', '匕', '攵', '厶'],
    },
    Decomposition {
        kanji: '魏',
        radicals: &['禾', '鬼', '女', '田', '儿', '匕', '厶'],
    },
    Decomposition {
        kanji: '魍',
        radicals: &['亡', '鬼', '田', '丷', '儿', '冂', '匕', '厶'],
    },
    Decomposition {
        kanji: '魎',
        radicals: &['｜', '鬼', '田', '入', '儿', '冂', '厶', '匕'],
    },
    Decomposition {
        kanji: '魑',
        radicals: &['鬼', '田', '亠', '儿', '凵', '匕', '⽱', '厶'],
    },
    Decomposition {
        kanji: '魘',
        radicals: &['鬼', '月', '犬', '田', '日', '儿', '匕', '厂', '厶'],
    },
    Decomposition {
        kanji: '魴',
        radicals: &['魚', '田', '方', '⺣'],
    },
    Decomposition {
        kanji: '鮓',
        radicals: &['｜', 'ノ', '魚', '田', '⺣'],
    },
    Decomposition {
        kanji: '鮃',
        radicals: &['干', '魚', '田', '丷', '⺣'],
    },
    Decomposition {
        kanji: '鮑',
        radicals: &['魚', '田', '勹', '已', '⺣'],
    },
    Decomposition {
        kanji: '鮖',
        radicals: &['魚', '口', '石', '田', '⺣'],
    },
    Decomposition {
        kanji: '鮗',
        radicals: &['魚', '田', '冫', '夂', '⺣'],
    },
    Decomposition {
        kanji: '鮟',
        radicals: &['魚', '女', '田', '宀', '⺣'],
    },
    Decomposition {
        kanji: '鮠',
        radicals: &['魚', '田', '卩', '厂', '⺣'],
    },
    Decomposition {
        kanji: '鮨',
        radicals: &['魚', '田', '日', '匕', '⺣'],
    },
    Decomposition {
        kanji: '鮴',
        radicals: &['⺅', '魚', '田', '木', '⺣'],
    },
    Decomposition {
        kanji: '鯀',
        radicals: &['ノ', '魚', '糸', '幺', '小', '田', '⺣'],
    },
    Decomposition {
        kanji: '鯊',
        radicals: &['ノ', '魚', '⺡', '小', '田', '⺣'],
    },
    Decomposition {
        kanji: '鮹',
        radicals: &['魚', '月', '⺌', '田', '⺣'],
    },
    Decomposition {
        kanji: '鯆',
        radicals: &['魚', '十', '田', '用', '丶', '⺣'],
    },
    Decomposition {
        kanji: '鯏',
        radicals: &['禾', '⺉', '魚', '田', '⺣'],
    },
    Decomposition {
        kanji: '鯑',
        radicals: &['ノ', '一', '魚', '巾', '田', '⺣'],
    },
    Decomposition {
        kanji: '鯒',
        radicals: &['魚', '田', '用', '⺣'],
    },
    Decomposition {
        kanji: '鯣',
        radicals: &['ノ', '魚', '田', '日', '勹', '⺣', '勿'],
    },
    Decomposition {
        kanji: '鯢',
        radicals: &['臼', '魚', '田', '儿', '⺣'],
    },
    Decomposition {
        kanji: '鯤',
        radicals: &['魚', '田', '日', '比', '⺣'],
    },
    Decomposition {
        kanji: '鯔',
        radicals: &['魚', '巛', '田', '⺣'],
    },
    Decomposition {
        kanji: '鯡',
        radicals: &['魚', '田', '非', '⺣'],
    },
    Decomposition {
        kanji: '鰺',
        radicals: &['魚', '田', '𠆢', '厶', '彡', '⺣'],
    },
    Decomposition {
        kanji: '鯲',
        radicals: &['魚', '田', '方', '𠆢', '冫', '⺣'],
    },
    Decomposition {
        kanji: '鯱',
        radicals: &['魚', '田', '卜', '儿', '匕', '厂', '⺣', '虍'],
    },
    Decomposition {
        kanji: '鯰',
        radicals: &['魚', '心', '田', '𠆢', '⺣', '一'],
    },
    Decomposition {
        kanji: '鰕',
        radicals: &['｜', '魚', '口', '田', '又', '⺣'],
    },
    Decomposition {
        kanji: '鰔',
        radicals: &['ノ', '魚', '口', '田', '戈', '⺣'],
    },
    Decomposition {
        kanji: '鰉',
        radicals: &['王', '魚', '田', '白', '⺣'],
    },
    Decomposition {
        kanji: '鰓',
        radicals: &['魚', '心', '田', '⺣'],
    },
    Decomposition {
        kanji: '鰌',
        radicals: &['魚', '田', '酉', 'ハ', '⺣'],
    },
    Decomposition {
        kanji: '鰆',
        radicals: &['魚', '人', '大', '田', '二', '日', '⺣'],
    },
    Decomposition {
        kanji: '鰈',
        radicals: &['魚', '田', '木', '世', '⺣'],
    },
    Decomposition {
        kanji: '鰒',
        radicals: &['魚', '田', '日', '夂', '⺣', '𠂉'],
    },
    Decomposition {
        kanji: '鰊',
        radicals: &['｜', '魚', '口', '田', '⺲', '丷', '木', '⺣'],
    },
    Decomposition {
        kanji: '鰄',
        radicals: &['ノ', '魚', '女', '田', '戈', '⺣'],
    },
    Decomposition {
        kanji: '鰮',
        radicals: &['魚', '皿', '人', '田', '囗', '⺣'],
    },
    Decomposition {
        kanji: '鰛',
        radicals: &['魚', '皿', '田', '日', '⺣'],
    },
    Decomposition {
        kanji: '鰥',
        radicals: &['｜', '魚', '田', '⺲', '冫', '⺣'],
    },
    Decomposition {
        kanji: '鰤',
        radicals: &['｜', '魚', '巾', '口', '田', '冂', '⺣'],
    },
    Decomposition {
        kanji: '鰡',
        radicals: &['魚', '田', '刀', '厶', '⺣'],
    },
    Decomposition {
        kanji: '鰰',
        radicals: &['｜', '魚', '田', '⺭', '⺣'],
    },
    Decomposition {
        kanji: '鱇',
        radicals: &['ヨ', '魚', '水', '田', '广', '⺣', '隶'],
    },
    Decomposition {
        kanji: '鰲',
        radicals: &['魚', '田', '土', '方', '攵', '⺣', '亠', '二', '𠂉'],
    },
    Decomposition {
        kanji: '鱆',
        radicals: &['音', '魚', '十', '田', '日', '立', '⺣'],
    },
    Decomposition {
        kanji: '鰾',
        radicals: &['魚', '示', '二', '小', '西', '田', '⺣'],
    },
    Decomposition {
        kanji: '鱚',
        radicals: &['魚', '口', '士', '十', '田', '豆', '丷', '⺣'],
    },
    Decomposition {
        kanji: '鱠',
        radicals: &['魚', '田', '日', '⺲', '𠆢', '⺣', '一'],
    },
    Decomposition {
        kanji: '鱧',
        radicals: &['｜', '魚', '田', '豆', '日', '⺣'],
    },
    Decomposition {
        kanji: '鱶',
        radicals: &['王', '魚', '艮', '食', '田', '丷', '羊', '⺣'],
    },
    Decomposition {
        kanji: '鱸',
        radicals: &['魚', '皿', '田', '卜', '匕', '厂', '⺣', '虍'],
    },
    Decomposition {
        kanji: '鳧',
        radicals: &['鳥', '几', '⺣'],
    },
    Decomposition {
        kanji: '鳬',
        radicals: &['鳥', '几'],
    },
    Decomposition {
        kanji: '鳰',
        radicals: &['鳥', '入', '⺣'],
    },
    Decomposition {
        kanji: '鴉',
        radicals: &['牙', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鴈',
        radicals: &['⺅', '鳥', '厂', '⺣'],
    },
    Decomposition {
        kanji: '鳫',
        radicals: &['鳥', '厂', '⺣'],
    },
    Decomposition {
        kanji: '鴃',
        radicals: &['人', '大', '鳥', '二', '⺣', 'ユ'],
    },
    Decomposition {
        kanji: '鴆',
        radicals: &['鳥', '尢', '⺣', '冖'],
    },
    Decomposition {
        kanji: '鴪',
        radicals: &['穴', '鳥', 'ハ', '宀', '⺣', '儿'],
    },
    Decomposition {
        kanji: '鴦',
        radicals: &['大', '鳥', '⺣', '冖'],
    },
    Decomposition {
        kanji: '鶯',
        radicals: &['火', '鳥', '冖', '⺣'],
    },
    Decomposition {
        kanji: '鴣',
        radicals: &['口', '十', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鴟',
        radicals: &['氏', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鵄',
        radicals: &['至', '鳥', '土', '厶', '⺣'],
    },
    Decomposition {
        kanji: '鴕',
        radicals: &['鳥', '匕', '宀', '⺣'],
    },
    Decomposition {
        kanji: '鴒',
        radicals: &['鳥', '𠆢', '卩', '⺣', '一'],
    },
    Decomposition {
        kanji: '鵁',
        radicals: &['鳥', '父', '亠', '⺣'],
    },
    Decomposition {
        kanji: '鴿',
        radicals: &['口', '鳥', '𠆢', '⺣', '一'],
    },
    Decomposition {
        kanji: '鴾',
        radicals: &['牛', '鳥', '厶', '⺣'],
    },
    Decomposition {
        kanji: '鵆',
        radicals: &['行', '鳥', '彳', '⺣'],
    },
    Decomposition {
        kanji: '鵈',
        radicals: &['耳', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鵝',
        radicals: &['鳥', '亅', '戈', '⺣'],
    },
    Decomposition {
        kanji: '鵞',
        radicals: &['鳥', '亅', '戈', '⺣'],
    },
    Decomposition {
        kanji: '鵤',
        radicals: &['角', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鵑',
        radicals: &['月', '口', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鵐',
        radicals: &['工', '人', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鵙',
        radicals: &['貝', '目', 'ハ', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鵲',
        radicals: &['｜', '一', '鳥', '日', '⺣'],
    },
    Decomposition {
        kanji: '鶉',
        radicals: &['口', '子', '鳥', '亠', '⺣'],
    },
    Decomposition {
        kanji: '鶇',
        radicals: &['｜', '鳥', '日', 'ハ', '木', '⺣', '田'],
    },
    Decomposition {
        kanji: '鶫',
        radicals: &['｜', '口', '鳥', '⺲', '丷', '木', '⺣'],
    },
    Decomposition {
        kanji: '鵯',
        radicals: &['十', '鳥', '田', '⺣'],
    },
    Decomposition {
        kanji: '鵺',
        radicals: &['鳥', '夕', '亠', '⺣', '⺅', '夕'],
    },
    Decomposition {
        kanji: '鶚',
        radicals: &['口', '鳥', '二', '⺣', '勹'],
    },
    Decomposition {
        kanji: '鶤',
        radicals: &['車', '鳥', '冖', '⺣'],
    },
    Decomposition {
        kanji: '鶩',
        radicals: &['鳥', '矛', '攵', '⺣', '𠂉'],
    },
    Decomposition {
        kanji: '鶲',
        radicals: &['羽', '鳥', 'ハ', '冫', '厶', '⺣'],
    },
    Decomposition {
        kanji: '鷄',
        radicals: &['大', '鳥', '爪', '幺', '⺣'],
    },
    Decomposition {
        kanji: '鷁',
        radicals: &['皿', '鳥', '丷', '⺣'],
    },
    Decomposition {
        kanji: '鶻',
        radicals: &['月', '骨', '鳥', '冂', '冖', '⺣'],
    },
    Decomposition {
        kanji: '鶸',
        radicals: &['弓', '鳥', '冫', '⺣'],
    },
    Decomposition {
        kanji: '鶺',
        radicals: &['月', '人', '鳥', '⺣', '二'],
    },
    Decomposition {
        kanji: '鷆',
        radicals: &['鳥', 'ハ', '目', '匕', '⺣'],
    },
    Decomposition {
        kanji: '鷏',
        radicals: &['十', '鳥', 'ハ', '目', '⺣'],
    },
    Decomposition {
        kanji: '鷂',
        radicals: &['缶', '鳥', '夕', '凵', '⺣'],
    },
    Decomposition {
        kanji: '鷙',
        radicals: &['九', '十', '辛', '鳥', '立', '丶', '亠', '⺣'],
    },
    Decomposition {
        kanji: '鷓',
        radicals: &['一', '鳥', '凵', '广', '⺣'],
    },
    Decomposition {
        kanji: '鷸',
        radicals: &['口', '鳥', '矛', '儿', '冂', '⺣'],
    },
    Decomposition {
        kanji: '鷦',
        radicals: &['鳥', '⺣', '隹'],
    },
    Decomposition {
        kanji: '鷭',
        radicals: &['鳥', '田', '釆', '米', '⺣'],
    },
    Decomposition {
        kanji: '鷯',
        radicals: &['小', '鳥', '日', '丷', '大', '亠', '⺣'],
    },
    Decomposition {
        kanji: '鷽',
        radicals: &['臼', '鳥', '冖', '⺣', '爻'],
    },
    Decomposition {
        kanji: '鸚',
        radicals: &['貝', '目', 'ハ', '女', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鸛',
        radicals: &['口', '鳥', '⺣', '⺾', '隹'],
    },
    Decomposition {
        kanji: '鸞',
        radicals: &['言', '糸', '幺', '小', '鳥', '⺣'],
    },
    Decomposition {
        kanji: '鹵',
        radicals: &['十', '囗', '鹵'],
    },
    Decomposition {
        kanji: '鹹',
        radicals: &['ノ', '口', '卜', '囗', '戈', '鹵', '十'],
    },
    Decomposition {
        kanji: '鹽',
        radicals: &['皿', '十', '臣', '囗', '鹵', '𠂉'],
    },
    Decomposition {
        kanji: '麁',
        radicals: &['鹿', '比', '广', '勹'],
    },
    Decomposition {
        kanji: '麈',
        radicals: &['王', '鹿', '比', '丶', '广'],
    },
    Decomposition {
        kanji: '麋',
        radicals: &['鹿', '比', '米', '广'],
    },
    Decomposition {
        kanji: '麌',
        radicals: &['口', '鹿', 'ハ', '比', '广', '大'],
    },
    Decomposition {
        kanji: '麒',
        radicals: &['甘', '鹿', 'ハ', '比', '广'],
    },
    Decomposition {
        kanji: '麕',
        radicals: &['禾', '鹿', '比', '囗', '广'],
    },
    Decomposition {
        kanji: '麑',
        radicals: &['臼', '鹿', '比', '儿', '广'],
    },
    Decomposition {
        kanji: '麝',
        radicals: &['鹿', '身', '寸', '比', '广'],
    },
    Decomposition {
        kanji: '麥',
        radicals: &['人', '十', '夂'],
    },
    Decomposition {
        kanji: '麩',
        radicals: &['人', '二', '十', '夂', '大'],
    },
    Decomposition {
        kanji: '麸',
        radicals: &['人', '土', '二', '麦', '亠', '夂', '大'],
    },
    Decomposition {
        kanji: '麪',
        radicals: &['止', '人', '十', '疋', '夂'],
    },
    Decomposition {
        kanji: '麭',
        radicals: &['人', '十', '勹', '夂', '已'],
    },
    Decomposition {
        kanji: '靡',
        radicals: &['非', '麻', '木', '广'],
    },
    Decomposition {
        kanji: '黌',
        radicals: &['臼', '黄', '田', 'ハ', '冖', '爻'],
    },
    Decomposition {
        kanji: '黎',
        radicals: &['黍', '勿', '禾', '水'],
    },
    Decomposition {
        kanji: '黏',
        radicals: &['黍', '口', '卜', '禾', '水'],
    },
    Decomposition {
        kanji: '黐',
        radicals: &['黍', '亠', '凵', '⽱', '禾', '水'],
    },
    Decomposition {
        kanji: '黔',
        radicals: &['黒', '里', '𠆢', '⺣', '一'],
    },
    Decomposition {
        kanji: '黜',
        radicals: &['｜', '黒', '山', '里', '⺣'],
    },
    Decomposition {
        kanji: '點',
        radicals: &['口', '黒', '卜', '里', '⺣'],
    },
    Decomposition {
        kanji: '黝',
        radicals: &['黒', '里', '力', '幺', '⺣'],
    },
    Decomposition {
        kanji: '黠',
        radicals: &['口', '黒', '士', '里', '⺣'],
    },
    Decomposition {
        kanji: '黥',
        radicals: &['口', '黒', '小', '里', '亠', '⺣'],
    },
    Decomposition {
        kanji: '黨',
        radicals: &['口', '黒', '⺌', '里', '冖', '⺣'],
    },
    Decomposition {
        kanji: '黯',
        radicals: &['音', '黒', '日', '里', '立', '⺣'],
    },
    Decomposition {
        kanji: '黴',
        radicals: &['黒', '山', '里', '彳', '攵', '⺣', '𠂉'],
    },
    Decomposition {
        kanji: '黶',
        radicals: &['犬', '黒', '日', '里', '厂', '⺣'],
    },
    Decomposition {
        kanji: '黷',
        radicals: &['貝', '目', 'ハ', '黒', '士', '里', '儿', '囗', '⺣', '⺲'],
    },
    Decomposition {
        kanji: '黹',
        radicals: &['ハ', '冂', '黹', '丷'],
    },
    Decomposition {
        kanji: '黻',
        radicals: &['ハ', '丶', '冂', '黹', '丷', 'ノ', '一'],
    },
    Decomposition {
        kanji: '黼',
        radicals: &['十', 'ハ', '用', '丶', '冂', '黹', '丷'],
    },
    Decomposition {
        kanji: '黽',
        radicals: &['黽'],
    },
    Decomposition {
        kanji: '鼇',
        radicals: &['土', '方', '攵', '黽', '亠', '二', '𠂉'],
    },
    Decomposition {
        kanji: '鼈',
        radicals: &['小', '⺌', '冂', '攵', '黽', '𠂉'],
    },
    Decomposition {
        kanji: '皷',
        radicals: &['鼓', '口', '士', '丷', '皮', '十', '又', '支', '豆'],
    },
    Decomposition {
        kanji: '鼕',
        radicals: &[
            '鼓', '口', '士', '支', 'ハ', '冫', '夂', '又', '十', '豆', '丶',
        ],
    },
    Decomposition {
        kanji: '鼡',
        radicals: &['用', '⺌'],
    },
    Decomposition {
        kanji: '鼬',
        radicals: &['｜', '臼', '鼠', '日', '田'],
    },
    Decomposition {
        kanji: '鼾',
        radicals: &['干', '自', '田', '鼻', '目', '廾'],
    },
    Decomposition {
        kanji: '齊',
        radicals: &['齊', '亠', '刀', '氏', '廾'],
    },
    Decomposition {
        kanji: '齒',
        radicals: &['止', '歯', '人', '凵', '米'],
    },
    Decomposition {
        kanji: '齔',
        radicals: &['止', '歯', '米', '凵', '匕'],
    },
    Decomposition {
        kanji: '齣',
        radicals: &['口', '止', '歯', '米', '凵', '勹'],
    },
    Decomposition {
        kanji: '齟',
        radicals: &['止', '歯', '米', '目', '凵'],
    },
    Decomposition {
        kanji: '齠',
        radicals: &['口', '止', '歯', '刀', '米', '凵'],
    },
    Decomposition {
        kanji: '齡',
        radicals: &['止', '歯', '人', '𠆢', '凵', '卩', '米', '一'],
    },
    Decomposition {
        kanji: '齦',
        radicals: &['艮', '止', '歯', '米', '凵'],
    },
    Decomposition {
        kanji: '齧',
        radicals: &['止', '歯', '土', '刀', '米', '亠', '凵', '二'],
    },
    Decomposition {
        kanji: '齬',
        radicals: &['口', '止', '歯', '米', '凵', '五'],
    },
    Decomposition {
        kanji: '齪',
        radicals: &['口', '止', '歯', '足', '米', '凵'],
    },
    Decomposition {
        kanji: '齷',
        radicals: &['止', '至', '歯', '土', '米', '凵', '厶', '尸'],
    },
    Decomposition {
        kanji: '齲',
        radicals: &['ノ', '止', '歯', '虫', '米', '冂', '凵', '⽱'],
    },
    Decomposition {
        kanji: '齶',
        radicals: &['口', '止', '歯', '二', '米', '凵', '勹'],
    },
    Decomposition {
        kanji: '龕',
        radicals: &['月', '口', '立', '𠆢', '一'],
    },
    Decomposition {
        kanji: '龜',
        radicals: &['亀', '乙', '勹', '田'],
    },
    Decomposition {
        kanji: '龠',
        radicals: &['一', '口', '𠆢', '龠', '冊', '廾'],
    },
    Decomposition {
        kanji: '堯',
        radicals: &['土', '儿', '一'],
    },
    Decomposition {
        kanji: '槇',
        radicals: &['木', '貝', '目', 'ハ', '｜', '一'],
    },
    Decomposition {
        kanji: '遙',
        radicals: &['⻌', '夕', '丶', '缶'],
    },
    Decomposition {
        kanji: '瑤',
        radicals: &['王', '夕', '丶', '缶'],
    },
    Decomposition {
        kanji: '凜',
        radicals: &['冫', '亠', '禾', '口'],
    },
    Decomposition {
        kanji: '熙',
        radicals: &['⺣', '已', '匚', '口'],
    },
    Decomposition {
        kanji: '丂',
        radicals: &['一', '勹'],
    },
    Decomposition {
        kanji: '丄',
        radicals: &['一', '｜'],
    },
    Decomposition {
        kanji: '丅',
        radicals: &['一', '｜'],
    },
    Decomposition {
        kanji: '丌',
        radicals: &['一', '｜', 'ノ'],
    },
    Decomposition {
        kanji: '丒',
        radicals: &['一', '丶', 'ノ', '勹'],
    },
    Decomposition {
        kanji: '丟',
        radicals: &['厶', '王'],
    },
    Decomposition {
        kanji: '丣',
        radicals: &['一', '｜', 'ノ', '口'],
    },
    Decomposition {
        kanji: '两',
        radicals: &['一', '人', '冂'],
    },
    Decomposition {
        kanji: '丨',
        radicals: &['｜'],
    },
    Decomposition {
        kanji: '丫',
        radicals: &['｜', '丶', 'ノ', '丷'],
    },
    Decomposition {
        kanji: '丮',
        radicals: &['｜', '二'],
    },
    Decomposition {
        kanji: '丯',
        radicals: &['｜', '彡'],
    },
    Decomposition {
        kanji: '丰',
        radicals: &['一', '｜', '二'],
    },
    Decomposition {
        kanji: '丵',
        radicals: &['一', '丶', 'ノ', '丷', '十', '干'],
    },
    Decomposition {
        kanji: '乀',
        radicals: &['丶'],
    },
    Decomposition {
        kanji: '乁',
        radicals: &['一', '丶'],
    },
    Decomposition {
        kanji: '乄',
        radicals: &['丶', 'ノ'],
    },
    Decomposition {
        kanji: '乇',
        radicals: &['一', 'ノ', '乙'],
    },
    Decomposition {
        kanji: '乑',
        radicals: &['｜', '丶', 'ノ'],
    },
    Decomposition {
        kanji: '乚',
        radicals: &['乙'],
    },
    Decomposition {
        kanji: '乜',
        radicals: &['乙', '匕'],
    },
    Decomposition {
        kanji: '乣',
        radicals: &['乙', '幺'],
    },
    Decomposition {
        kanji: '乨',
        radicals: &['乙', '厶', '口'],
    },
    Decomposition {
        kanji: '乩',
        radicals: &['乙', '卜', '口'],
    },
    Decomposition {
        kanji: '乴',
        radicals: &['一', 'ノ', '乙', '亅', '斤'],
    },
    Decomposition {
        kanji: '乵',
        radicals: &['乙', '十', '立', '辛'],
    },
    Decomposition {
        kanji: '乹',
        radicals: &['乙', '十', '日'],
    },
    Decomposition {
        kanji: '乿',
        radicals: &['乙', '小', '幺', '爪', '糸'],
    },
    Decomposition {
        kanji: '亍',
        radicals: &['亅', '二'],
    },
    Decomposition {
        kanji: '亖',
        radicals: &['二'],
    },
    Decomposition {
        kanji: '亗',
        radicals: &['二', '山'],
    },
    Decomposition {
        kanji: '亝',
        radicals: &['二', '厶'],
    },
    Decomposition {
        kanji: '亯',
        radicals: &['一', '丶', '亠', '口', '日', '曰'],
    },
    Decomposition {
        kanji: '亹',
        radicals: &['一', '｜', 'ノ', '亠', '冂', '冖', '口', 'ヨ', '目'],
    },
    Decomposition {
        kanji: '仃',
        radicals: &['一', '亅', '⺅'],
    },
    Decomposition {
        kanji: '仐',
        radicals: &['𠆢', '十'],
    },
    Decomposition {
        kanji: '仚',
        radicals: &['𠆢', '山'],
    },
    Decomposition {
        kanji: '仛',
        radicals: &['一', 'ノ', '乙', '⺅'],
    },
    Decomposition {
        kanji: '仠',
        radicals: &['一', '⺅', '十', '干'],
    },
    Decomposition {
        kanji: '仡',
        radicals: &['一', 'ノ', '乙', '⺅'],
    },
    Decomposition {
        kanji: '仢',
        radicals: &['丶', '⺅', '勹'],
    },
    Decomposition {
        kanji: '仨',
        radicals: &['一', '二', '⺅'],
    },
    Decomposition {
        kanji: '仯',
        radicals: &['ノ', '⺅', '小'],
    },
    Decomposition {
        kanji: '仱',
        radicals: &['一', '丶', '⺅', '𠆢'],
    },
    Decomposition {
        kanji: '仳',
        radicals: &['⺅', '匕', '比'],
    },
    Decomposition {
        kanji: '仵',
        radicals: &['一', 'ノ', '⺅', '十', '干'],
    },
    Decomposition {
        kanji: '份',
        radicals: &['⺅', 'ハ', '刀'],
    },
    Decomposition {
        kanji: '仾',
        radicals: &['一', '⺅', 'ヨ', '彑'],
    },
    Decomposition {
        kanji: '仿',
        radicals: &['一', '丶', 'ノ', '⺅', '方'],
    },
    Decomposition {
        kanji: '伀',
        radicals: &['⺅', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '伂',
        radicals: &['一', '｜', '⺅', '冂', '巾'],
    },
    Decomposition {
        kanji: '伃',
        radicals: &['一', '亅', '⺅', 'マ'],
    },
    Decomposition {
        kanji: '伈',
        radicals: &['⺅', '心'],
    },
    Decomposition {
        kanji: '伋',
        radicals: &['丶', '⺅', '又', '乃', '及'],
    },
    Decomposition {
        kanji: '伌',
        radicals: &['⺅', '卩', '厂'],
    },
    Decomposition {
        kanji: '伒',
        radicals: &['⺅', '斤'],
    },
    Decomposition {
        kanji: '伕',
        radicals: &['一', '二', '人', '⺅', '大'],
    },
    Decomposition {
        kanji: '伖',
        radicals: &['一', 'ノ', '⺅', '又'],
    },
    Decomposition {
        kanji: '众',
        radicals: &['人', '𠆢'],
    },
    Decomposition {
        kanji: '伙',
        radicals: &['⺅', '火'],
    },
    Decomposition {
        kanji: '伮',
        radicals: &['⺅', '又', '女'],
    },
    Decomposition {
        kanji: '伱',
        radicals: &['⺅', '𠆢', '小'],
    },
    Decomposition {
        kanji: '你',
        radicals: &['一', 'ノ', '⺅', '小'],
    },
    Decomposition {
        kanji: '伳',
        radicals: &['一', '｜', '⺅', '十', '世'],
    },
    Decomposition {
        kanji: '伵',
        radicals: &['⺅', 'ハ', '口'],
    },
    Decomposition {
        kanji: '伷',
        radicals: &['｜', '⺅', '日', '田'],
    },
    Decomposition {
        kanji: '伹',
        radicals: &['一', '⺅', '目'],
    },
    Decomposition {
        kanji: '伻',
        radicals: &['一', '⺅', 'ハ', '十', '干'],
    },
    Decomposition {
        kanji: '伾',
        radicals: &['一', '｜', '丶', 'ノ', '⺅'],
    },
    Decomposition {
        kanji: '佀',
        radicals: &['｜', '⺅', '口'],
    },
    Decomposition {
        kanji: '佂',
        radicals: &['一', '⺅', '止'],
    },
    Decomposition {
        kanji: '佈',
        radicals: &['一', '｜', 'ノ', '⺅', '冂', '巾'],
    },
    Decomposition {
        kanji: '佉',
        radicals: &['⺅', '厶', '土'],
    },
    Decomposition {
        kanji: '佋',
        radicals: &['⺅', '刀', '口'],
    },
    Decomposition {
        kanji: '佌',
        radicals: &['⺅', '匕', '止'],
    },
    Decomposition {
        kanji: '佒',
        radicals: &['⺅', '大'],
    },
    Decomposition {
        kanji: '佔',
        radicals: &['⺅', '卜', '口'],
    },
    Decomposition {
        kanji: '佖',
        radicals: &['ノ', '⺅', '心'],
    },
    Decomposition {
        kanji: '佘',
        radicals: &['二', '𠆢', '小', '示'],
    },
    Decomposition {
        kanji: '佟',
        radicals: &['丶', '⺅', '夂'],
    },
    Decomposition {
        kanji: '佣',
        radicals: &['一', '｜', '⺅', '用'],
    },
    Decomposition {
        kanji: '佪',
        radicals: &['⺅', '口', '囗'],
    },
    Decomposition {
        kanji: '佬',
        radicals: &['ノ', '⺅', '匕', '土', '⺹'],
    },
    Decomposition {
        kanji: '佮',
        radicals: &['一', '⺅', '𠆢', '口'],
    },
    Decomposition {
        kanji: '佱',
        radicals: &['一', '𠆢', '止'],
    },
    Decomposition {
        kanji: '佷',
        radicals: &['⺅', '艮'],
    },
    Decomposition {
        kanji: '佸',
        radicals: &['⺅', '口', '舌'],
    },
    Decomposition {
        kanji: '佹',
        radicals: &['⺅', '勹', '卩', '厂'],
    },
    Decomposition {
        kanji: '佺',
        radicals: &['⺅', '𠆢', '王'],
    },
    Decomposition {
        kanji: '佽',
        radicals: &['一', '人', '⺅', '勹', '欠'],
    },
    Decomposition {
        kanji: '佾',
        radicals: &['⺅', 'ハ', '月'],
    },
    Decomposition {
        kanji: '侁',
        radicals: &['一', 'ノ', '⺅', '儿', '十', '土'],
    },
    Decomposition {
        kanji: '侂',
        radicals: &['ノ', '⺅', '匕', '广'],
    },
    Decomposition {
        kanji: '侄',
        radicals: &['一', '⺅', '厶', '土'],
    },
    Decomposition {
        kanji: '侅',
        radicals: &['ノ', '亠', '人', '⺅', '幺', '玄'],
    },
    Decomposition {
        kanji: '侉',
        radicals: &['一', '二', '⺅', '勹', '大'],
    },
    Decomposition {
        kanji: '侊',
        radicals: &['一', '⺅', '儿', '⺌'],
    },
    Decomposition {
        kanji: '侌',
        radicals: &['一', '丶', '𠆢', '厶', 'ユ'],
    },
    Decomposition {
        kanji: '侎',
        radicals: &['⺅', '米'],
    },
    Decomposition {
        kanji: '侐',
        radicals: &['⺅', '皿', '血'],
    },
    Decomposition {
        kanji: '侒',
        radicals: &['⺅', '女', '宀'],
    },
    Decomposition {
        kanji: '侓',
        radicals: &['｜', '二', '⺅', 'ヨ', '聿'],
    },
    Decomposition {
        kanji: '侔',
        radicals: &['⺅', '厶', '牛'],
    },
    Decomposition {
        kanji: '侗',
        radicals: &['一', '⺅', '冂', '口'],
    },
    Decomposition {
        kanji: '侙',
        radicals: &['⺅', '工', '弋'],
    },
    Decomposition {
        kanji: '侚',
        radicals: &['⺅', '勹', '日'],
    },
    Decomposition {
        kanji: '侞',
        radicals: &['⺅', '口', '女'],
    },
    Decomposition {
        kanji: '侟',
        radicals: &['一', '｜', 'ノ', '⺅', '子'],
    },
    Decomposition {
        kanji: '侲',
        radicals: &['⺅', '厂', '衣', '辰'],
    },
    Decomposition {
        kanji: '侷',
        radicals: &['⺅', '勹', '口', '尸'],
    },
    Decomposition {
        kanji: '侹',
        radicals: &['⺅', '廴', '王'],
    },
    Decomposition {
        kanji: '侻',
        radicals: &['⺅', '儿', '丷', '口'],
    },
    Decomposition {
        kanji: '侼',
        radicals: &['一', '⺅', '冖', '十', '子'],
    },
    Decomposition {
        kanji: '侽',
        radicals: &['⺅', '力', '田'],
    },
    Decomposition {
        kanji: '侾',
        radicals: &['ノ', '⺅', '土', '子', '⺹'],
    },
    Decomposition {
        kanji: '俀',
        radicals: &['⺅', '女', '爪'],
    },
    Decomposition {
        kanji: '俁',
        radicals: &['一', '丶', 'ノ', '⺅', '口', '大'],
    },
    Decomposition {
        kanji: '俅',
        radicals: &['一', '丶', '⺅', '水'],
    },
    Decomposition {
        kanji: '俆',
        radicals: &['亅', '二', '⺅', '𠆢', 'ハ', '小', '示'],
    },
    Decomposition {
        kanji: '俈',
        radicals: &['ノ', '⺅', '口', '土'],
    },
    Decomposition {
        kanji: '俉',
        radicals: &['一', '二', '⺅', '口', '五'],
    },
    Decomposition {
        kanji: '俋',
        radicals: &['乙', '⺅', '口', '已', '⻏', '巴'],
    },
    Decomposition {
        kanji: '俌',
        radicals: &['一', '｜', '丶', '二', '⺅', '十', '用'],
    },
    Decomposition {
        kanji: '俍',
        radicals: &['丶', '⺅', '艮'],
    },
    Decomposition {
        kanji: '俏',
        radicals: &['⺅', '小', '⺌', '月'],
    },
    Decomposition {
        kanji: '俒',
        radicals: &['一', '⺅', '儿', '宀'],
    },
    Decomposition {
        kanji: '俜',
        radicals: &['一', '｜', '⺅', '勹', '十', '口', '田'],
    },
    Decomposition {
        kanji: '俠',
        radicals: &['人', '⺅', '大'],
    },
    Decomposition {
        kanji: '俢',
        radicals: &['⺅', '夂', '彡'],
    },
    Decomposition {
        kanji: '俰',
        radicals: &['ノ', '⺅', '口', '木', '禾'],
    },
    Decomposition {
        kanji: '俲',
        radicals: &['亠', '⺅', '力', '父'],
    },
    Decomposition {
        kanji: '俼',
        radicals: &['亠', '⺅', '厶', '月'],
    },
    Decomposition {
        kanji: '俽',
        radicals: &['人', '⺅', '勹', '斤', '欠'],
    },
    Decomposition {
        kanji: '俿',
        radicals: &['⺅', '儿', '几', '匕', '卜', '厂', '虍'],
    },
    Decomposition {
        kanji: '倀',
        radicals: &['⺅', '長'],
    },
    Decomposition {
        kanji: '倁',
        radicals: &['一', 'ノ', '⺅', '口', '大', '矢'],
    },
    Decomposition {
        kanji: '倄',
        radicals: &['一', '丶', 'ノ', '⺅', '月'],
    },
    Decomposition {
        kanji: '倇',
        radicals: &['⺅', '卩', '夕', '宀'],
    },
    Decomposition {
        kanji: '倊',
        radicals: &['⺅', 'ハ', '厶', '心'],
    },
    Decomposition {
        kanji: '倌',
        radicals: &['｜', '⺅', '口', '宀'],
    },
    Decomposition {
        kanji: '倎',
        radicals: &['一', '｜', '⺅', 'ハ', '冂', '日', '冊', '廾'],
    },
    Decomposition {
        kanji: '倐',
        radicals: &['｜', '⺅', '夂', '火'],
    },
    Decomposition {
        kanji: '倓',
        radicals: &['⺅', '火'],
    },
    Decomposition {
        kanji: '倗',
        radicals: &['⺅', '月'],
    },
    Decomposition {
        kanji: '倘',
        radicals: &['⺅', '冂', '口', '小', '⺌'],
    },
    Decomposition {
        kanji: '倛',
        radicals: &['一', '｜', '⺅', 'ハ', '甘', '目'],
    },
    Decomposition {
        kanji: '倜',
        radicals: &['｜', '二', '⺅', '冂', '口', '土'],
    },
    Decomposition {
        kanji: '倝',
        radicals: &['人', '十', '日', '曰'],
    },
    Decomposition {
        kanji: '倞',
        radicals: &['亠', '⺅', '口', '小'],
    },
    Decomposition {
        kanji: '倢',
        radicals: &['一', '｜', '⺅', '土', 'ヨ', '疋', '走'],
    },
    Decomposition {
        kanji: '倧',
        radicals: &['二', '⺅', '宀', '小', '示'],
    },
    Decomposition {
        kanji: '倮',
        radicals: &['⺅', '木', '田'],
    },
    Decomposition {
        kanji: '倰',
        radicals: &['⺅', 'ハ', '土', '夂'],
    },
    Decomposition {
        kanji: '倲',
        radicals: &['一', '⺅', '口', '日', '木'],
    },
    Decomposition {
        kanji: '倳',
        radicals: &['一', '亅', '⺅', '口', 'ヨ'],
    },
    Decomposition {
        kanji: '倵',
        radicals: &['一', '丶', '⺅', '弋', '止'],
    },
    Decomposition {
        kanji: '偀',
        radicals: &['⺅', '大', '⺾'],
    },
    Decomposition {
        kanji: '偁',
        radicals: &['一', '｜', '二', '⺅', '冂', '月', '爪'],
    },
    Decomposition {
        kanji: '偂',
        radicals: &['一', '丶', '⺅', '丷', '冂', '⺉', '月'],
    },
    Decomposition {
        kanji: '偅',
        radicals: &['一', 'ノ', '⺅', '車'],
    },
    Decomposition {
        kanji: '偆',
        radicals: &['一', '二', '⺅', '大', '日'],
    },
    Decomposition {
        kanji: '偊',
        radicals: &['ノ', '⺅', '冂', '厶', '口', '⽱', '虫'],
    },
    Decomposition {
        kanji: '偌',
        radicals: &['一', 'ノ', '⺅', '口', '⺾'],
    },
    Decomposition {
        kanji: '偎',
        radicals: &['⺅', '田', '衣'],
    },
    Decomposition {
        kanji: '偑',
        radicals: &['ノ', '⺅', '冂', '虫', '風'],
    },
    Decomposition {
        kanji: '偒',
        radicals: &['一', 'ノ', '⺅', '勹', '日', '曰', '勿'],
    },
    Decomposition {
        kanji: '偓',
        radicals: &['一', '⺅', '厶', '土', '尸', '至'],
    },
    Decomposition {
        kanji: '偗',
        radicals: &['ノ', '⺅', '小', '目'],
    },
    Decomposition {
        kanji: '偙',
        radicals: &['一', '｜', '丶', '⺅', '丷', '冂', '冖', '巾', '立'],
    },
    Decomposition {
        kanji: '偟',
        radicals: &['⺅', '日', '王', '白'],
    },
    Decomposition {
        kanji: '偠',
        radicals: &['⺅', '女', '西'],
    },
    Decomposition {
        kanji: '偢',
        radicals: &['ノ', '⺅', '木', '火', '禾'],
    },
    Decomposition {
        kanji: '偣',
        radicals: &['⺅', '日', '立', '音'],
    },
    Decomposition {
        kanji: '偦',
        radicals: &['⺅', '月', '疋'],
    },
    Decomposition {
        kanji: '偧',
        radicals: &['⺅', '夕', '大'],
    },
    Decomposition {
        kanji: '偪',
        radicals: &['一', '⺅', '口', '田'],
    },
    Decomposition {
        kanji: '偭',
        radicals: &['⺅', '面'],
    },
    Decomposition {
        kanji: '偰',
        radicals: &['一', '｜', '二', '⺅', '刀', '大', '彡'],
    },
    Decomposition {
        kanji: '偱',
        radicals: &['一', '⺅', '十', '厂', '斤', '目', '自'],
    },
    Decomposition {
        kanji: '倻',
        radicals: &['⺅', '⻏', '耳'],
    },
    Decomposition {
        kanji: '傁',
        radicals: &['｜', 'ノ', '⺅', '十', '又', 'ヨ', '支', '臼'],
    },
    Decomposition {
        kanji: '傃',
        radicals: &['一', '二', '⺅', '土', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '傄',
        radicals: &['丶', 'ノ', '⺅', '大', '目'],
    },
    Decomposition {
        kanji: '傆',
        radicals: &['⺅', '厂', '小', '日', '白'],
    },
    Decomposition {
        kanji: '傊',
        radicals: &['⺅', 'ハ', '口', '目', '貝'],
    },
    Decomposition {
        kanji: '傎',
        radicals: &['⺅', 'ハ', '匕', '十', '目'],
    },
    Decomposition {
        kanji: '傏',
        radicals: &['｜', '⺅', '口', '广', 'ヨ'],
    },
    Decomposition {
        kanji: '傐',
        radicals: &['亠', '⺅', '冂', '口', '高'],
    },
    Decomposition {
        kanji: '傒',
        radicals: &['⺅', '大', '幺', '爪'],
    },
    Decomposition {
        kanji: '傓',
        radicals: &['一', 'ノ', '⺅', '冫', '厂', '尸', '戸', '羽'],
    },
    Decomposition {
        kanji: '傔',
        radicals: &['一', 'ノ', '⺅', 'ヨ', '木', '禾'],
    },
    Decomposition {
        kanji: '傖',
        radicals: &['一', '丶', '⺅', '𠆢', '口', '尸', '戸', '日'],
    },
    Decomposition {
        kanji: '傛',
        radicals: &['⺅', '𠆢', 'ハ', '口', '宀', '谷'],
    },
    Decomposition {
        kanji: '傜',
        radicals: &['丶', '⺅', '凵', '夕', '山', '爪', '缶'],
    },
    Decomposition {
        kanji: '傞',
        radicals: &['一', 'ノ', '二', '⺅', '丷', '工', '王', '羊'],
    },
    Decomposition {
        kanji: '傟',
        radicals: &['⺅', 'ハ', '冫', '厶', '羽'],
    },
    Decomposition {
        kanji: '傠',
        radicals: &['⺅', '寸', '言'],
    },
    Decomposition {
        kanji: '傡',
        radicals: &['⺅', '立'],
    },
    Decomposition {
        kanji: '傢',
        radicals: &['⺅', '宀', '豕'],
    },
    Decomposition {
        kanji: '傪',
        radicals: &['⺅', '𠆢', '厶', '彡'],
    },
    Decomposition {
        kanji: '傯',
        radicals: &['丶', 'ノ', '⺅', '勹', '口', '囗', '夂', '心'],
    },
    Decomposition {
        kanji: '傰',
        radicals: &['⺅', '山', '月'],
    },
    Decomposition {
        kanji: '傹',
        radicals: &['⺅', '儿', '日', '曰', '立', '音'],
    },
    Decomposition {
        kanji: '傺',
        radicals: &['丶', '二', '⺅', '𠆢', '夕', '小', '示'],
    },
    Decomposition {
        kanji: '傽',
        radicals: &['⺅', '十', '日', '曰', '立', '音'],
    },
    Decomposition {
        kanji: '僀',
        radicals: &['一', '｜', '乙', '⺅', '冂', '冖', '十', '巾', '廾'],
    },
    Decomposition {
        kanji: '僃',
        radicals: &['⺅', '勹', '⺾', '用'],
    },
    Decomposition {
        kanji: '僄',
        radicals: &['二', '⺅', '小', '示', '西'],
    },
    Decomposition {
        kanji: '僇',
        radicals: &['⺅', '𠆢', '冫', '彡', '羽'],
    },
    Decomposition {
        kanji: '僌',
        radicals: &['⺅', '攵', '車'],
    },
    Decomposition {
        kanji: '僎',
        radicals: &['｜', '二', '⺅', 'ハ', '已'],
    },
    Decomposition {
        kanji: '僐',
        radicals: &['一', '｜', '⺅', '丷', '口', '王', '羊'],
    },
    Decomposition {
        kanji: '僓',
        radicals: &['一', '｜', '⺅', 'ハ', '口', '土', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '僔',
        radicals: &['一', '⺅', '儿', 'ハ', '丷', '寸', '酉'],
    },
    Decomposition {
        kanji: '僘',
        radicals: &['⺅', '冂', '口', '小', '⺌', '攵'],
    },
    Decomposition {
        kanji: '僜',
        radicals: &['一', '⺅', '丷', '口', '癶', '豆'],
    },
    Decomposition {
        kanji: '僝',
        radicals: &['⺅', '子', '尸'],
    },
    Decomposition {
        kanji: '僟',
        radicals: &['人', '⺅', '幺', '戈'],
    },
    Decomposition {
        kanji: '僢',
        radicals: &['｜', '⺅', '冖', '夕', '爪', '舛'],
    },
    Decomposition {
        kanji: '僤',
        radicals: &['⺅', '十', '口', '日', '田'],
    },
    Decomposition {
        kanji: '僦',
        radicals: &['丶', '亠', '⺅', '口', '小', '尢', '尤'],
    },
    Decomposition {
        kanji: '僨',
        radicals: &['⺅', 'ハ', '十', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '僩',
        radicals: &['⺅', '月', '門'],
    },
    Decomposition {
        kanji: '僯',
        radicals: &['⺅', '夕', '米', '舛'],
    },
    Decomposition {
        kanji: '僱',
        radicals: &['一', '丶', '⺅', '尸', '戸', '隹'],
    },
    Decomposition {
        kanji: '僶',
        radicals: &['⺅', '黽'],
    },
    Decomposition {
        kanji: '僺',
        radicals: &['⺅', '口', '木'],
    },
    Decomposition {
        kanji: '僾',
        radicals: &['⺅', '冖', '夂', '心', '爪'],
    },
    Decomposition {
        kanji: '儃',
        radicals: &['一', '亠', '⺅', '口', '囗', '日'],
    },
    Decomposition {
        kanji: '儆',
        radicals: &['⺅', '勹', '口', '⺾', '攵'],
    },
    Decomposition {
        kanji: '儇',
        radicals: &['一', '丶', 'ノ', '⺅', '口', '⺲', '衣'],
    },
    Decomposition {
        kanji: '儈',
        radicals: &['一', '丶', 'ノ', '⺅', '𠆢', '丷', '口', '日'],
    },
    Decomposition {
        kanji: '儋',
        radicals: &['⺅', '儿', 'ハ', '冖', '勹', '厂', '言'],
    },
    Decomposition {
        kanji: '儌',
        radicals: &['⺅', '攵', '方', '日', '白'],
    },
    Decomposition {
        kanji: '儍',
        radicals: &['丶', 'ノ', '⺅', '儿', 'ハ', '凵', '夂'],
    },
    Decomposition {
        kanji: '儎',
        radicals: &['⺅', '十', '土', '戈', '車'],
    },
    Decomposition {
        kanji: '僲',
        radicals: &['⺅', '夕', '西', '舛'],
    },
    Decomposition {
        kanji: '儐',
        radicals: &['一', '｜', 'ノ', 'ハ', '宀', '目', '貝'],
    },
    Decomposition {
        kanji: '儗',
        radicals: &['一', 'ノ', '⺅', '匕', 'マ', '大', '疋', '矢'],
    },
    Decomposition {
        kanji: '儙',
        radicals: &['一', '｜', '⺅', '⻌', '口', '虫'],
    },
    Decomposition {
        kanji: '儛',
        radicals: &['一', '｜', 'ノ', '⺅', '夕', '舛', '無'],
    },
    Decomposition {
        kanji: '儜',
        radicals: &['一', '亅', '⺅', '宀', '心', '⺲'],
    },
    Decomposition {
        kanji: '儝',
        radicals: &['⺅', '冖', '木', '火'],
    },
    Decomposition {
        kanji: '儞',
        radicals: &['一', '｜', '丶', 'ノ', '⺅', 'ハ', '冂'],
    },
    Decomposition {
        kanji: '儣',
        radicals: &['｜', '二', '⺅', 'ハ', '广', '日', '田', '黄'],
    },
    Decomposition {
        kanji: '儧',
        radicals: &['一', '⺅', 'ハ', '大', '目', '貝'],
    },
    Decomposition {
        kanji: '儨',
        radicals: &['⺅', 'ハ', '斤', '目', '貝'],
    },
    Decomposition {
        kanji: '儬',
        radicals: &['二', '亠', '⺅', 'ハ', '土', '月', '目', '貝', '青'],
    },
    Decomposition {
        kanji: '儭',
        radicals: &['一', '⺅', '儿', '小', '目', '立', '見'],
    },
    Decomposition {
        kanji: '儯',
        radicals: &['一', '⺅', '丷', '大', '馬'],
    },
    Decomposition {
        kanji: '儱',
        radicals: &['一', '乙', '⺅', '月', '立'],
    },
    Decomposition {
        kanji: '儳',
        radicals: &[
            '一', '｜', '丶', 'ノ', '乙', '⺅', '儿', '冖', '勹', '匕', '口', '比', '免',
        ],
    },
    Decomposition {
        kanji: '儴',
        radicals: &['一', '｜', '丶', '二', '亠', '⺅', '口', '衣'],
    },
    Decomposition {
        kanji: '儵',
        radicals: &['｜', '⺅', '丷', '夂', '攵', '⺣', '里', '黒'],
    },
    Decomposition {
        kanji: '儸',
        radicals: &['⺅', '小', '幺', '⺲', '糸', '隹'],
    },
    Decomposition {
        kanji: '儹',
        radicals: &['ノ', '⺅', '儿', 'ハ', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '兂',
        radicals: &['一', 'ノ', '乙', '二', '尢'],
    },
    Decomposition {
        kanji: '兊',
        radicals: &['儿', 'ハ', '厶'],
    },
    Decomposition {
        kanji: '兏',
        radicals: &['一', '儿', '卜', '厂'],
    },
    Decomposition {
        kanji: '兓',
        radicals: &['一', '尢'],
    },
    Decomposition {
        kanji: '兕',
        radicals: &['一', '｜', '儿'],
    },
    Decomposition {
        kanji: '兗',
        radicals: &['亠', '儿', 'ハ', '口'],
    },
    Decomposition {
        kanji: '兘',
        radicals: &['二', '儿', '厶', '口', '元'],
    },
    Decomposition {
        kanji: '兟',
        radicals: &['ノ', '儿', '土'],
    },
    Decomposition {
        kanji: '兤',
        radicals: &[
            '一', '｜', '二', '亠', '儿', 'ハ', '⺌', '广', '日', '田', '黄',
        ],
    },
    Decomposition {
        kanji: '兦',
        radicals: &['乙', '人'],
    },
    Decomposition {
        kanji: '兾',
        radicals: &['｜', '二', 'ハ', '丷', '田'],
    },
    Decomposition {
        kanji: '冃',
        radicals: &['二', '冂'],
    },
    Decomposition {
        kanji: '冄',
        radicals: &['二', '冂'],
    },
    Decomposition {
        kanji: '冋',
        radicals: &['冂', '口'],
    },
    Decomposition {
        kanji: '冎',
        radicals: &['冂', '口', '囗'],
    },
    Decomposition {
        kanji: '冘',
        radicals: &['ノ', '乙', '冖', '尢'],
    },
    Decomposition {
        kanji: '冝',
        radicals: &['一', '冖', '目'],
    },
    Decomposition {
        kanji: '冡',
        radicals: &['一', '冖', '豕'],
    },
    Decomposition {
        kanji: '冣',
        radicals: &['冖', '又', '耳'],
    },
    Decomposition {
        kanji: '冭',
        radicals: &['一', '丶', 'ノ', '大'],
    },
    Decomposition {
        kanji: '冸',
        radicals: &['｜', '二', 'ハ', '丷', '冫', '小'],
    },
    Decomposition {
        kanji: '冺',
        radicals: &['一', '冫', '尸', '氏'],
    },
    Decomposition {
        kanji: '冼',
        radicals: &['ノ', '儿', '冫', '土'],
    },
    Decomposition {
        kanji: '冾',
        radicals: &['一', '𠆢', '冫', '口'],
    },
    Decomposition {
        kanji: '冿',
        radicals: &['｜', '二', '冫', 'ヨ', '聿'],
    },
    Decomposition {
        kanji: '凂',
        radicals: &['一', '｜', 'ノ', '乙', '儿', '冫', '勹', '口', '免'],
    },
    Decomposition {
        kanji: '凈',
        radicals: &['亅', '冫', 'ヨ', '爪'],
    },
    Decomposition {
        kanji: '减',
        radicals: &['一', 'ノ', '冫', '厂', '口', '戈'],
    },
    Decomposition {
        kanji: '凑',
        radicals: &['一', '丶', 'ノ', '二', '冫', '大'],
    },
    Decomposition {
        kanji: '凒',
        radicals: &['丷', '冫', '口', '山', '豆'],
    },
    Decomposition {
        kanji: '凓',
        radicals: &['冫', '木', '西'],
    },
    Decomposition {
        kanji: '凕',
        radicals: &['亠', 'ハ', '冖', '冫', '日', '曰'],
    },
    Decomposition {
        kanji: '凘',
        radicals: &['一', 'ハ', '冫', '斤', '甘'],
    },
    Decomposition {
        kanji: '凞',
        radicals: &['ノ', '冫', '匚', '已', '⺣', '臣'],
    },
    Decomposition {
        kanji: '凢',
        radicals: &['ノ', '乙', '几', '广'],
    },
    Decomposition {
        kanji: '凥',
        radicals: &['几', '尸'],
    },
    Decomposition {
        kanji: '凮',
        radicals: &['一', 'ノ', '几', '日', '白'],
    },
    Decomposition {
        kanji: '凲',
        radicals: &['｜', 'ハ', '丷', '几', 'ヨ'],
    },
    Decomposition {
        kanji: '凳',
        radicals: &['一', '𠆢', '丷', '几', '口', '癶', '豆'],
    },
    Decomposition {
        kanji: '凴',
        radicals: &['冫', '几', '馬'],
    },
    Decomposition {
        kanji: '凷',
        radicals: &['凵', '土'],
    },
    Decomposition {
        kanji: '刁',
        radicals: &['一', '亅'],
    },
    Decomposition {
        kanji: '刂',
        radicals: &['⺉'],
    },
    Decomposition {
        kanji: '刅',
        radicals: &['丶', 'ノ', 'ハ', '刀'],
    },
    Decomposition {
        kanji: '划',
        radicals: &['⺉', '戈'],
    },
    Decomposition {
        kanji: '刓',
        radicals: &['二', '儿', '⺉', '元'],
    },
    Decomposition {
        kanji: '刕',
        radicals: &['刀'],
    },
    Decomposition {
        kanji: '刖',
        radicals: &['⺉', '月'],
    },
    Decomposition {
        kanji: '刘',
        radicals: &['⺉', '文'],
    },
    Decomposition {
        kanji: '刢',
        radicals: &['丶', '𠆢', '⺉', 'マ'],
    },
    Decomposition {
        kanji: '刨',
        radicals: &['⺉', '勹', '已'],
    },
    Decomposition {
        kanji: '刱',
        radicals: &['一', '｜', '丶', 'ノ', '二', 'ハ', '刀', '井'],
    },
    Decomposition {
        kanji: '刲',
        radicals: &['⺉', '土'],
    },
    Decomposition {
        kanji: '刵',
        radicals: &['⺉', '耳'],
    },
    Decomposition {
        kanji: '刼',
        radicals: &['一', '丶', 'ノ', '𠆢', '刀', '厶'],
    },
    Decomposition {
        kanji: '剅',
        radicals: &['一', '丷', '⺉', '口', '豆'],
    },
    Decomposition {
        kanji: '剉',
        radicals: &['人', '⺉', '土'],
    },
    Decomposition {
        kanji: '剕',
        radicals: &['⺉', '非'],
    },
    Decomposition {
        kanji: '剗',
        radicals: &['⺉', '戈'],
    },
    Decomposition {
        kanji: '剘',
        radicals: &['一', '｜', '二', 'ハ', '⺉', '甘'],
    },
    Decomposition {
        kanji: '剚',
        radicals: &['一', '亅', '⺉', '口'],
    },
    Decomposition {
        kanji: '剜',
        radicals: &['⺉', '卩', '夕', '宀'],
    },
    Decomposition {
        kanji: '剟',
        radicals: &['⺉', '又'],
    },
    Decomposition {
        kanji: '剠',
        radicals: &['亠', '⺉', '口', '小'],
    },
    Decomposition {
        kanji: '剡',
        radicals: &['⺉', '火'],
    },
    Decomposition {
        kanji: '剦',
        radicals: &['乙', '⺉', '大', '日', '奄'],
    },
    Decomposition {
        kanji: '剮',
        radicals: &['冂', '⺉', '口', '囗'],
    },
    Decomposition {
        kanji: '剷',
        radicals: &['一', '丶', 'ノ', '亠', '⺉', '厂', '土', '牛', '立'],
    },
    Decomposition {
        kanji: '剸',
        radicals: &['一', '⺉', '厶', '寸', '日', '虫'],
    },
    Decomposition {
        kanji: '剹',
        radicals: &['𠆢', '冫', '⺉', '彡', '羽'],
    },
    Decomposition {
        kanji: '劀',
        radicals: &['ハ', '冂', '⺉', 'マ', '口', '矛'],
    },
    Decomposition {
        kanji: '劂',
        radicals: &['一', '人', '丷', '⺉', '勹', '厂', '屮', '欠'],
    },
    Decomposition {
        kanji: '劅',
        radicals: &['⺉', '勹', '⺲', '虫'],
    },
    Decomposition {
        kanji: '劊',
        radicals: &['一', '｜', '丶', 'ノ', '𠆢', '丷', '⺉', '口', '日'],
    },
    Decomposition {
        kanji: '劌',
        radicals: &['一', 'ノ', '亅', '⺉', '厂', '戈', '止'],
    },
    Decomposition {
        kanji: '劓',
        radicals: &['一', '｜', 'ノ', '⺉', '廾', '田', '目', '自', '鼻'],
    },
    Decomposition {
        kanji: '劕',
        radicals: &['ハ', '⺉', '斤', '目', '貝'],
    },
    Decomposition {
        kanji: '劖',
        radicals: &[
            '一', '｜', 'ノ', '乙', '儿', '⺉', '勹', '匕', '口', '比', '免',
        ],
    },
    Decomposition {
        kanji: '劗',
        radicals: &['ノ', '儿', 'ハ', '⺉', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '劘',
        radicals: &['一', '｜', 'ノ', '儿', '⺉', '十', '广', '木', '非'],
    },
    Decomposition {
        kanji: '劚',
        radicals: &['｜', '丶', 'ノ', '⺉', '勹', '尸', '水', '⺲', '虫'],
    },
    Decomposition {
        kanji: '劜',
        radicals: &['乙', '力'],
    },
    Decomposition {
        kanji: '劤',
        radicals: &['力', '斤'],
    },
    Decomposition {
        kanji: '劥',
        radicals: &['一', '丶', '亠', '几', '力'],
    },
    Decomposition {
        kanji: '劦',
        radicals: &['力'],
    },
    Decomposition {
        kanji: '劧',
        radicals: &['力', '手'],
    },
    Decomposition {
        kanji: '劯',
        radicals: &['力', '口', '石'],
    },
    Decomposition {
        kanji: '劰',
        radicals: &['力', '日', '白'],
    },
    Decomposition {
        kanji: '劶',
        radicals: &['一', '力', '厂', '口'],
    },
    Decomposition {
        kanji: '劷',
        radicals: &['一', 'ノ', '二', '丷', '力', '王', '羊'],
    },
    Decomposition {
        kanji: '劸',
        radicals: &['力', '土'],
    },
    Decomposition {
        kanji: '劺',
        radicals: &['力', '厶', '牛'],
    },
    Decomposition {
        kanji: '劻',
        radicals: &['力', '匚', '王'],
    },
    Decomposition {
        kanji: '劽',
        radicals: &['⺉', '力', '歹'],
    },
    Decomposition {
        kanji: '勀',
        radicals: &['ノ', '儿', '力', '十', '口'],
    },
    Decomposition {
        kanji: '勄',
        radicals: &['一', 'ノ', '力', '毋', '母'],
    },
    Decomposition {
        kanji: '勆',
        radicals: &['丶', '力', '厶', '日', '曰'],
    },
    Decomposition {
        kanji: '勈',
        radicals: &['力', 'マ', '用'],
    },
    Decomposition {
        kanji: '勌',
        radicals: &['一', '二', 'ハ', '力', '卩', '大'],
    },
    Decomposition {
        kanji: '勏',
        radicals: &['力', '口', '立'],
    },
    Decomposition {
        kanji: '勑',
        radicals: &['人', '力', '木'],
    },
    Decomposition {
        kanji: '勔',
        radicals: &['力', '面'],
    },
    Decomposition {
        kanji: '勖',
        radicals: &['二', '冂', '力', '目'],
    },
    Decomposition {
        kanji: '勛',
        radicals: &['ハ', '力', '口', '目', '貝'],
    },
    Decomposition {
        kanji: '勜',
        radicals: &['ハ', '冫', '力', '厶', '羽'],
    },
    Decomposition {
        kanji: '勡',
        radicals: &['二', '力', '小', '示', '西'],
    },
    Decomposition {
        kanji: '勥',
        radicals: &['力', '口', '弓', '虫'],
    },
    Decomposition {
        kanji: '勨',
        radicals: &['ノ', '力', '勹', '口', '豕'],
    },
    Decomposition {
        kanji: '勩',
        radicals: &['一', '｜', 'ハ', '力', '目', '世', '貝'],
    },
    Decomposition {
        kanji: '勪',
        radicals: &['一', '丶', 'ノ', '冂', '力', '口', '大'],
    },
    Decomposition {
        kanji: '勬',
        radicals: &['一', '丷', '力', '大', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '勰',
        radicals: &['力', '心', '田'],
    },
    Decomposition {
        kanji: '勱',
        radicals: &['冂', '力', '厶', '⺾', '田', '⽱'],
    },
    Decomposition {
        kanji: '勴',
        radicals: &['力', '匕', '卜', '厂', '心', '田', '虍'],
    },
    Decomposition {
        kanji: '勶',
        radicals: &['一', '丶', '亠', '力', '厶', '彳', '攵', '月'],
    },
    Decomposition {
        kanji: '勷',
        radicals: &['一', '｜', '二', '亠', '力', '口', '衣'],
    },
    Decomposition {
        kanji: '匀',
        radicals: &['一', '丶', '勹'],
    },
    Decomposition {
        kanji: '匃',
        radicals: &['人', '勹'],
    },
    Decomposition {
        kanji: '匊',
        radicals: &['勹', '米'],
    },
    Decomposition {
        kanji: '匋',
        radicals: &['凵', '勹', '山', '缶'],
    },
    Decomposition {
        kanji: '匌',
        radicals: &['一', '𠆢', '勹', '口'],
    },
    Decomposition {
        kanji: '匑',
        radicals: &['勹', '弓', '身'],
    },
    Decomposition {
        kanji: '匓',
        radicals: &['几', '勹', '厶', '又', '日', '殳', '艮'],
    },
    Decomposition {
        kanji: '匘',
        radicals: &['丶', 'ノ', '匕', '口', '巛'],
    },
    Decomposition {
        kanji: '匛',
        radicals: &['丶', '勹', '匚', '夂'],
    },
    Decomposition {
        kanji: '匜',
        radicals: &['｜', '乙', '匕', '匚', '也'],
    },
    Decomposition {
        kanji: '匞',
        radicals: &['匚', '工'],
    },
    Decomposition {
        kanji: '匟',
        radicals: &['亠', '几', '匚'],
    },
    Decomposition {
        kanji: '匥',
        radicals: &['匚', '厶', '廾'],
    },
    Decomposition {
        kanji: '匧',
        radicals: &['人', '匚', '大'],
    },
    Decomposition {
        kanji: '匨',
        radicals: &['匚', '士', '爿'],
    },
    Decomposition {
        kanji: '匩',
        radicals: &['匚', '屮', '山', '王'],
    },
    Decomposition {
        kanji: '匫',
        radicals: &['ノ', '勹', '匚', '日', '曰', '勿'],
    },
    Decomposition {
        kanji: '匬',
        radicals: &['一', '𠆢', '⺉', '匚', '月'],
    },
    Decomposition {
        kanji: '匭',
        radicals: &['匚', '九', '車'],
    },
    Decomposition {
        kanji: '匰',
        radicals: &['匚', '十', '口', '日', '田'],
    },
    Decomposition {
        kanji: '匲',
        radicals: &['一', '丶', 'ノ', '匚', '口', '大'],
    },
    Decomposition {
        kanji: '匵',
        radicals: &['儿', 'ハ', '匚', '口', '士', '⺲', '貝'],
    },
    Decomposition {
        kanji: '匼',
        radicals: &['一', '𠆢', '匚', '口'],
    },
    Decomposition {
        kanji: '匽',
        radicals: &['匚', '女', '日'],
    },
    Decomposition {
        kanji: '匾',
        radicals: &[
            '一', '｜', '丶', 'ノ', '亅', '冂', '匚', '尸', '戸', '冊', '廾',
        ],
    },
    Decomposition {
        kanji: '卂',
        radicals: &['乙', '十'],
    },
    Decomposition {
        kanji: '卌',
        radicals: &['一', '｜'],
    },
    Decomposition {
        kanji: '卋',
        radicals: &['一', '｜', '凵', '十'],
    },
    Decomposition {
        kanji: '卙',
        radicals: &['一', '｜', 'ハ', '匚', '十', '甘'],
    },
    Decomposition {
        kanji: '卛',
        radicals: &['丶', 'ノ', '十', '幺', '糸', '言'],
    },
    Decomposition {
        kanji: '卡',
        radicals: &['一', '卜', '土'],
    },
    Decomposition {
        kanji: '卣',
        radicals: &['一', '卜', '口'],
    },
    Decomposition {
        kanji: '卥',
        radicals: &['丶', 'ノ', '卜', '口', '夕'],
    },
    Decomposition {
        kanji: '卬',
        radicals: &['卩', '厂'],
    },
    Decomposition {
        kanji: '卭',
        radicals: &['卩', '工'],
    },
    Decomposition {
        kanji: '卲',
        radicals: &['刀', '卩', '口'],
    },
    Decomposition {
        kanji: '卹',
        radicals: &['卩', '皿', '血'],
    },
    Decomposition {
        kanji: '卾',
        radicals: &['二', '勹', '卩', '口'],
    },
    Decomposition {
        kanji: '厃',
        radicals: &['勹', '厂'],
    },
    Decomposition {
        kanji: '厇',
        radicals: &['一', 'ノ', '乙', '厂'],
    },
    Decomposition {
        kanji: '厈',
        radicals: &['一', '十', '厂', '干'],
    },
    Decomposition {
        kanji: '厎',
        radicals: &['丶', '厂', '氏'],
    },
    Decomposition {
        kanji: '厓',
        radicals: &['厂', '土'],
    },
    Decomposition {
        kanji: '厔',
        radicals: &['一', '厂', '厶', '土', '至'],
    },
    Decomposition {
        kanji: '厙',
        radicals: &['厂', '車'],
    },
    Decomposition {
        kanji: '厝',
        radicals: &['｜', '二', '厂', '日'],
    },
    Decomposition {
        kanji: '厡',
        radicals: &['厂', '日', '水', '白'],
    },
    Decomposition {
        kanji: '厤',
        radicals: &['ノ', '厂', '木', '禾'],
    },
    Decomposition {
        kanji: '厪',
        radicals: &['二', '十', '厂', '口', '廾', '革'],
    },
    Decomposition {
        kanji: '厫',
        radicals: &['厂', '土', '士', '攵', '方'],
    },
    Decomposition {
        kanji: '厯',
        radicals: &['厂', '心', '木'],
    },
    Decomposition {
        kanji: '厲',
        radicals: &['冂', '厂', '厶', '⺾', '田', '⽱'],
    },
    Decomposition {
        kanji: '厴',
        radicals: &['｜', '丶', '大', '日', '月', '犬', '田'],
    },
    Decomposition {
        kanji: '厵',
        radicals: &['厂', '小', '日', '白'],
    },
    Decomposition {
        kanji: '厷',
        radicals: &['一', 'ノ', '厶'],
    },
    Decomposition {
        kanji: '厸',
        radicals: &['厶'],
    },
    Decomposition {
        kanji: '厺',
        radicals: &['厶', '大'],
    },
    Decomposition {
        kanji: '厽',
        radicals: &['厶'],
    },
    Decomposition {
        kanji: '叀',
        radicals: &['一', '｜', '十', '厶', '日', '田'],
    },
    Decomposition {
        kanji: '叅',
        radicals: &['丶', 'ノ', '亅', '𠆢', '厶', '⺣'],
    },
    Decomposition {
        kanji: '叏',
        radicals: &['｜', '十', '又', 'ユ', '支'],
    },
    Decomposition {
        kanji: '叒',
        radicals: &['又'],
    },
    Decomposition {
        kanji: '叓',
        radicals: &['｜', '十', '又', '口', '支'],
    },
    Decomposition {
        kanji: '叕',
        radicals: &['丶', 'ノ', '又'],
    },
    Decomposition {
        kanji: '叚',
        radicals: &['一', '｜', '二', '又', '口'],
    },
    Decomposition {
        kanji: '叝',
        radicals: &['卩', '厶', '又', '土'],
    },
    Decomposition {
        kanji: '叞',
        radicals: &['二', '又', '小', '尸', '示'],
    },
    Decomposition {
        kanji: '叠',
        radicals: &['一', '冖', '又', '宀', '目'],
    },
    Decomposition {
        kanji: '另',
        radicals: &['力', '口'],
    },
    Decomposition {
        kanji: '叧',
        radicals: &['刀', '口'],
    },
    Decomposition {
        kanji: '叵',
        radicals: &['匚', '口'],
    },
    Decomposition {
        kanji: '吂',
        radicals: &['一', '丶', '亠', '匚', '口'],
    },
    Decomposition {
        kanji: '吓',
        radicals: &['一', '卜', '口'],
    },
    Decomposition {
        kanji: '吚',
        radicals: &['ノ', '口', 'ヨ'],
    },
    Decomposition {
        kanji: '吡',
        radicals: &['匕', '口', '比'],
    },
    Decomposition {
        kanji: '吧',
        radicals: &['乙', '口', '已', '巴'],
    },
    Decomposition {
        kanji: '吨',
        radicals: &['ノ', '乙', '凵', '口', '屯'],
    },
    Decomposition {
        kanji: '吪',
        radicals: &['ノ', '乙', '⺅', '匕', '口'],
    },
    Decomposition {
        kanji: '启',
        radicals: &['丶', '口', '尸'],
    },
    Decomposition {
        kanji: '吱',
        radicals: &['十', '又', '口', '支'],
    },
    Decomposition {
        kanji: '吴',
        radicals: &['一', '口', '大'],
    },
    Decomposition {
        kanji: '吵',
        radicals: &['ノ', '口', '小'],
    },
    Decomposition {
        kanji: '呃',
        radicals: &['卩', '厂', '口'],
    },
    Decomposition {
        kanji: '呄',
        radicals: &['十', '乃', '口'],
    },
    Decomposition {
        kanji: '呇',
        radicals: &['口', '水'],
    },
    Decomposition {
        kanji: '呍',
        radicals: &['二', '厶', '口'],
    },
    Decomposition {
        kanji: '呏',
        radicals: &['ノ', '口', '廾'],
    },
    Decomposition {
        kanji: '呞',
        radicals: &['一', '亅', '口'],
    },
    Decomposition {
        kanji: '呢',
        radicals: &['匕', '口', '尸'],
    },
    Decomposition {
        kanji: '呤',
        radicals: &['丶', '𠆢', 'マ', '口'],
    },
    Decomposition {
        kanji: '呦',
        radicals: &['力', '口', '幺'],
    },
    Decomposition {
        kanji: '呧',
        radicals: &['丶', '口', '氏'],
    },
    Decomposition {
        kanji: '呩',
        radicals: &['二', '口', '小', '示'],
    },
    Decomposition {
        kanji: '呫',
        radicals: &['卜', '口'],
    },
    Decomposition {
        kanji: '呭',
        radicals: &['一', '｜', '口', '世'],
    },
    Decomposition {
        kanji: '呮',
        radicals: &['ハ', '口'],
    },
    Decomposition {
        kanji: '呴',
        radicals: &['勹', '口'],
    },
    Decomposition {
        kanji: '呿',
        radicals: &['厶', '口', '土'],
    },
    Decomposition {
        kanji: '咁',
        radicals: &['口', '甘'],
    },
    Decomposition {
        kanji: '咃',
        radicals: &['｜', '乙', '⺅', '匕', '口', '也'],
    },
    Decomposition {
        kanji: '咅',
        radicals: &['口', '立'],
    },
    Decomposition {
        kanji: '咈',
        radicals: &['｜', 'ノ', '口', '廾', '弓'],
    },
    Decomposition {
        kanji: '咉',
        radicals: &['口', '大'],
    },
    Decomposition {
        kanji: '咍',
        radicals: &['厶', '口'],
    },
    Decomposition {
        kanji: '咑',
        radicals: &['一', '亅', '口', '扌'],
    },
    Decomposition {
        kanji: '咕',
        radicals: &['十', '口'],
    },
    Decomposition {
        kanji: '咖',
        radicals: &['力', '口'],
    },
    Decomposition {
        kanji: '咜',
        radicals: &['匕', '口', '宀'],
    },
    Decomposition {
        kanji: '咟',
        radicals: &['一', '口', '日', '白'],
    },
    Decomposition {
        kanji: '咡',
        radicals: &['口', '耳'],
    },
    Decomposition {
        kanji: '咦',
        radicals: &['口', '大', '弓'],
    },
    Decomposition {
        kanji: '咧',
        radicals: &['⺉', '口', '歹'],
    },
    Decomposition {
        kanji: '咩',
        radicals: &['丷', '口', '王', '羊'],
    },
    Decomposition {
        kanji: '咪',
        radicals: &['口', '米'],
    },
    Decomposition {
        kanji: '咭',
        radicals: &['口', '士'],
    },
    Decomposition {
        kanji: '咮',
        radicals: &['一', 'ノ', '口', '木'],
    },
    Decomposition {
        kanji: '咱',
        radicals: &['口', '目', '自'],
    },
    Decomposition {
        kanji: '咷',
        radicals: &['丶', 'ノ', '儿', '冫', '口'],
    },
    Decomposition {
        kanji: '咹',
        radicals: &['口', '女', '宀'],
    },
    Decomposition {
        kanji: '咺',
        radicals: &['一', '口', '日'],
    },
    Decomposition {
        kanji: '咻',
        radicals: &['⺅', '口', '木'],
    },
    Decomposition {
        kanji: '咿',
        radicals: &['ノ', '⺅', '口', 'ヨ'],
    },
    Decomposition {
        kanji: '哆',
        radicals: &['口', '夕'],
    },
    Decomposition {
        kanji: '哊',
        radicals: &['一', 'ノ', '口', '月', '肉'],
    },
    Decomposition {
        kanji: '响',
        radicals: &['ノ', '冂', '口'],
    },
    Decomposition {
        kanji: '哎',
        radicals: &['丶', 'ノ', '口', '⺾'],
    },
    Decomposition {
        kanji: '哠',
        radicals: &['ノ', '口', '土'],
    },
    Decomposition {
        kanji: '哪',
        radicals: &['二', '刀', '口', '⻏'],
    },
    Decomposition {
        kanji: '哬',
        radicals: &['一', '亅', '⺅', '口'],
    },
    Decomposition {
        kanji: '哯',
        radicals: &['儿', '口', '目', '見'],
    },
    Decomposition {
        kanji: '哶',
        radicals: &['一', '｜', '二', '十', '卜', '口', '干'],
    },
    Decomposition {
        kanji: '哼',
        radicals: &['一', '亅', '亠', '口'],
    },
    Decomposition {
        kanji: '哾',
        radicals: &['儿', '丷', '口'],
    },
    Decomposition {
        kanji: '哿',
        radicals: &['一', '亅', '力', '口'],
    },
    Decomposition {
        kanji: '唀',
        radicals: &['ノ', '乃', '口', '木', '禾'],
    },
    Decomposition {
        kanji: '唁',
        radicals: &['口', '言'],
    },
    Decomposition {
        kanji: '唅',
        radicals: &['一', '丶', '𠆢', '口'],
    },
    Decomposition {
        kanji: '唈',
        radicals: &['乙', '口', '已', '⻏', '巴'],
    },
    Decomposition {
        kanji: '唉',
        radicals: &['一', 'ノ', '厶', '口', '大', '矢'],
    },
    Decomposition {
        kanji: '唌',
        radicals: &['ノ', '口', '廴', '止'],
    },
    Decomposition {
        kanji: '唍',
        radicals: &['二', '儿', '口', '宀', '元'],
    },
    Decomposition {
        kanji: '唎',
        radicals: &['ノ', '⺉', '口', '木', '禾'],
    },
    Decomposition {
        kanji: '唕',
        radicals: &['十', '口', '日', '白'],
    },
    Decomposition {
        kanji: '唪',
        radicals: &['一', '｜', '丶', 'ノ', '二', '口', '大'],
    },
    Decomposition {
        kanji: '唫',
        radicals: &['一', '𠆢', '丷', '十', '口', '土', '干'],
    },
    Decomposition {
        kanji: '唲',
        radicals: &['儿', '口', '臼'],
    },
    Decomposition {
        kanji: '唵',
        radicals: &['乙', '口', '大', '日', '田', '奄'],
    },
    Decomposition {
        kanji: '唶',
        radicals: &['｜', '二', '口', '日'],
    },
    Decomposition {
        kanji: '唻',
        radicals: &['人', '口', '木'],
    },
    Decomposition {
        kanji: '唼',
        radicals: &['口', '女', '立'],
    },
    Decomposition {
        kanji: '唽',
        radicals: &['口', '斤', '木'],
    },
    Decomposition {
        kanji: '啁',
        radicals: &['｜', '二', '冂', '口', '土'],
    },
    Decomposition {
        kanji: '啇',
        radicals: &['亠', '丷', '冂', '十', '口'],
    },
    Decomposition {
        kanji: '啉',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '啊',
        radicals: &['一', '亅', '口', '⻏', '⻖'],
    },
    Decomposition {
        kanji: '啍',
        radicals: &['亠', '口', '子'],
    },
    Decomposition {
        kanji: '啐',
        radicals: &['亠', '人', '十', '口'],
    },
    Decomposition {
        kanji: '啑',
        radicals: &['口', '土', 'ヨ', '走'],
    },
    Decomposition {
        kanji: '啘',
        radicals: &['卩', '口', '夕', '宀'],
    },
    Decomposition {
        kanji: '啚',
        radicals: &['十', '口', '囗'],
    },
    Decomposition {
        kanji: '啛',
        radicals: &['一', '｜', '十', '口', '女', 'ヨ'],
    },
    Decomposition {
        kanji: '啞',
        radicals: &['一', '｜', '口'],
    },
    Decomposition {
        kanji: '啠',
        radicals: &['口', '斤'],
    },
    Decomposition {
        kanji: '啡',
        radicals: &['口', '非'],
    },
    Decomposition {
        kanji: '啤',
        radicals: &['ノ', '十', '口', '日', '白'],
    },
    Decomposition {
        kanji: '啦',
        radicals: &['口', '扌', '立'],
    },
    Decomposition {
        kanji: '啿',
        radicals: &['一', '｜', 'ハ', '匚', '口', '甘'],
    },
    Decomposition {
        kanji: '喁',
        radicals: &['冂', '厶', '口', '田', '⽱'],
    },
    Decomposition {
        kanji: '喂',
        radicals: &['一', '口', '田', '衣'],
    },
    Decomposition {
        kanji: '喆',
        radicals: &['口', '士'],
    },
    Decomposition {
        kanji: '喈',
        radicals: &['匕', '口', '日', '比', '白'],
    },
    Decomposition {
        kanji: '喎',
        radicals: &['｜', '冂', '口'],
    },
    Decomposition {
        kanji: '喏',
        radicals: &['口', '⺾', '石'],
    },
    Decomposition {
        kanji: '喑',
        radicals: &['口', '日', '立', '音'],
    },
    Decomposition {
        kanji: '喒',
        radicals: &['卜', '口', '夂', '日'],
    },
    Decomposition {
        kanji: '喓',
        radicals: &['口', '女', '西'],
    },
    Decomposition {
        kanji: '喔',
        radicals: &['一', '厶', '口', '土', '尸', '至'],
    },
    Decomposition {
        kanji: '喗',
        radicals: &['冖', '口', '車'],
    },
    Decomposition {
        kanji: '喣',
        radicals: &['勹', '口', '⺣'],
    },
    Decomposition {
        kanji: '喤',
        radicals: &['口', '日', '王', '白'],
    },
    Decomposition {
        kanji: '喭',
        radicals: &['丶', 'ノ', '亠', '厂', '口', '彡'],
    },
    Decomposition {
        kanji: '喲',
        radicals: &['一', '丶', '勹', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '喿',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '嗁',
        radicals: &['几', '匕', '卜', '厂', '口', '虍'],
    },
    Decomposition {
        kanji: '嗃',
        radicals: &['亠', '冂', '口', '高'],
    },
    Decomposition {
        kanji: '嗆',
        radicals: &['一', '丶', 'ノ', '𠆢', '口', '尸', '日'],
    },
    Decomposition {
        kanji: '嗉',
        radicals: &['一', '｜', '二', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '嗋',
        radicals: &['力', '口', '月'],
    },
    Decomposition {
        kanji: '嗌',
        radicals: &['一', 'ハ', '丷', '口', '皿'],
    },
    Decomposition {
        kanji: '嗎',
        radicals: &['口', '馬'],
    },
    Decomposition {
        kanji: '嗑',
        radicals: &['厶', '口', '土', '皿'],
    },
    Decomposition {
        kanji: '嗒',
        radicals: &['一', '𠆢', '口', '⺾'],
    },
    Decomposition {
        kanji: '嗓',
        radicals: &['又', '口', '木'],
    },
    Decomposition {
        kanji: '嗗',
        radicals: &['冂', '冖', '口', '月', '骨'],
    },
    Decomposition {
        kanji: '嗘',
        radicals: &['口', '大', '幺', '爪'],
    },
    Decomposition {
        kanji: '嗛',
        radicals: &['一', '｜', '丶', 'ノ', '口', 'ヨ'],
    },
    Decomposition {
        kanji: '嗞',
        radicals: &['一', '丷', '口', '幺'],
    },
    Decomposition {
        kanji: '嗢',
        radicals: &['人', '口', '日', '皿'],
    },
    Decomposition {
        kanji: '嗩',
        radicals: &['ハ', '口', '小', '⺌', '目', '貝'],
    },
    Decomposition {
        kanji: '嗶',
        radicals: &['一', '｜', '口', '田', '里'],
    },
    Decomposition {
        kanji: '嗿',
        radicals: &['丶', '𠆢', 'ハ', '口', '目', '貝'],
    },
    Decomposition {
        kanji: '嘅',
        radicals: &['乙', '匕', '厶', '口', '无', '日', '白', '牙'],
    },
    Decomposition {
        kanji: '嘈',
        radicals: &['一', '｜', '口', '日'],
    },
    Decomposition {
        kanji: '嘊',
        radicals: &['厂', '口', '土', '山'],
    },
    Decomposition {
        kanji: '嘍',
        radicals: &['一', '｜', '口', '女', '日'],
    },
    Decomposition {
        kanji: '嘎',
        radicals: &['一', '口', '戈', '目', '自'],
    },
    Decomposition {
        kanji: '嘏',
        radicals: &['二', '十', '又', '口', '尸'],
    },
    Decomposition {
        kanji: '嘐',
        radicals: &['𠆢', '冫', '口', '彡', '羽'],
    },
    Decomposition {
        kanji: '嘑',
        radicals: &['一', 'ノ', '亅', '丷', '匕', '卜', '厂', '口', '虍'],
    },
    Decomposition {
        kanji: '嘒',
        radicals: &['一', '｜', '二', '口', 'ヨ'],
    },
    Decomposition {
        kanji: '嘙',
        radicals: &['冫', '十', '厂', '又', '口', '女', '⺡', '支'],
    },
    Decomposition {
        kanji: '嘬',
        radicals: &['又', '口', '日', '耳'],
    },
    Decomposition {
        kanji: '嘰',
        radicals: &['人', '口', '幺', '戈'],
    },
    Decomposition {
        kanji: '嘳',
        radicals: &['一', '｜', 'ハ', '口', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '嘵',
        radicals: &['一', '儿', '口', '土'],
    },
    Decomposition {
        kanji: '嘷',
        radicals: &['二', '冫', '十', '口', '目', '自'],
    },
    Decomposition {
        kanji: '嘹',
        radicals: &['丶', 'ノ', '口', '大', '小', '日'],
    },
    Decomposition {
        kanji: '嘻',
        radicals: &['一', '丷', '十', '口', '士', '豆'],
    },
    Decomposition {
        kanji: '嘼',
        radicals: &['一', '口', '田'],
    },
    Decomposition {
        kanji: '嘽',
        radicals: &['一', '｜', '十', '口', '日', '田'],
    },
    Decomposition {
        kanji: '嘿',
        radicals: &['｜', '二', '丷', '口', '⺣', '里', '黒'],
    },
    Decomposition {
        kanji: '噀',
        radicals: &['｜', '二', 'ハ', '口', '已'],
    },
    Decomposition {
        kanji: '噁',
        radicals: &['一', '｜', '二', '口', '心'],
    },
    Decomposition {
        kanji: '噃',
        radicals: &['ノ', '口', '田', '米'],
    },
    Decomposition {
        kanji: '噄',
        radicals: &['一', '｜', '二', '刀', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '噆',
        radicals: &['口', '无', '日', '曰'],
    },
    Decomposition {
        kanji: '噉',
        radicals: &['一', '｜', '口', '攵', '耳'],
    },
    Decomposition {
        kanji: '噋',
        radicals: &['亠', '口', '子', '攵'],
    },
    Decomposition {
        kanji: '噍',
        radicals: &['口', '⺣', '隹'],
    },
    Decomposition {
        kanji: '噏',
        radicals: &['一', '𠆢', '冫', '口', '羽'],
    },
    Decomposition {
        kanji: '噔',
        radicals: &['一', '丷', '口', '癶', '豆'],
    },
    Decomposition {
        kanji: '噞',
        radicals: &['一', '人', '𠆢', '口'],
    },
    Decomposition {
        kanji: '噠',
        radicals: &['丷', '⻌', '口', '土', '王', '羊'],
    },
    Decomposition {
        kanji: '噡',
        radicals: &['ハ', '勹', '厂', '口', '言'],
    },
    Decomposition {
        kanji: '噢',
        radicals: &['ノ', '冂', '口', '大', '米'],
    },
    Decomposition {
        kanji: '噣',
        radicals: &['勹', '口', '⺲', '虫'],
    },
    Decomposition {
        kanji: '噦',
        radicals: &['一', '｜', 'ノ', '厂', '口', '戈', '止'],
    },
    Decomposition {
        kanji: '噩',
        radicals: &['口', '王'],
    },
    Decomposition {
        kanji: '噭',
        radicals: &['口', '攵', '方', '日', '白'],
    },
    Decomposition {
        kanji: '噯',
        radicals: &['冖', '口', '夂', '心', '爪'],
    },
    Decomposition {
        kanji: '噱',
        radicals: &['匕', '卜', '厂', '口', '虍', '豕'],
    },
    Decomposition {
        kanji: '噲',
        radicals: &['一', '｜', '𠆢', '丷', '口', '日'],
    },
    Decomposition {
        kanji: '噵',
        radicals: &['丷', '⻌', '口', '目', '自', '首'],
    },
    Decomposition {
        kanji: '嚄',
        radicals: &['又', '口', '⺾', '隹'],
    },
    Decomposition {
        kanji: '嚅',
        radicals: &['一', '｜', '冖', '口', '而', '雨'],
    },
    Decomposition {
        kanji: '嚈',
        radicals: &['丶', '厂', '口', '大', '日', '月', '犬'],
    },
    Decomposition {
        kanji: '嚋',
        radicals: &['一', '口', '士', '寸', '工'],
    },
    Decomposition {
        kanji: '嚌',
        radicals: &['一', '亠', '刀', '口', '廾', '氏', '齊'],
    },
    Decomposition {
        kanji: '嚕',
        radicals: &['口', '日', '⺣', '田', '魚'],
    },
    Decomposition {
        kanji: '嚙',
        radicals: &['一', '人', '凵', '口', '止'],
    },
    Decomposition {
        kanji: '嚚',
        radicals: &['匚', '口', '臣'],
    },
    Decomposition {
        kanji: '嚝',
        radicals: &['一', '｜', '二', 'ハ', '口', '广', '日', '田', '黄'],
    },
    Decomposition {
        kanji: '嚞',
        radicals: &['口', '士'],
    },
    Decomposition {
        kanji: '嚟',
        radicals: &['ノ', '𠆢', '勹', '口', '木', '水', '禾'],
    },
    Decomposition {
        kanji: '嚦',
        radicals: &['ノ', '厂', '口', '木', '止', '禾'],
    },
    Decomposition {
        kanji: '嚧',
        radicals: &['匕', '卜', '厂', '口', '田', '皿', '虍'],
    },
    Decomposition {
        kanji: '嚨',
        radicals: &['一', '乙', '口', '月', '立', '竜'],
    },
    Decomposition {
        kanji: '嚩',
        radicals: &['一', '｜', '丶', '十', '口', '寸', '小', '幺', '用', '糸'],
    },
    Decomposition {
        kanji: '嚫',
        radicals: &['一', '儿', '口', '小', '目', '立', '見'],
    },
    Decomposition {
        kanji: '嚬',
        radicals: &['ノ', '亅', 'ハ', '口', '小', '止', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '嚭',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '十', '口', '士', '豆'],
    },
    Decomposition {
        kanji: '嚱',
        radicals: &['丷', '匕', '卜', '厂', '口', '戈', '虍', '豆'],
    },
    Decomposition {
        kanji: '嚳',
        radicals: &['一', '｜', 'ノ', '冖', '口', '土', 'ヨ', '爻', '牛', '臼'],
    },
    Decomposition {
        kanji: '嚷',
        radicals: &['一', '｜', '二', '亠', '口', '衣'],
    },
    Decomposition {
        kanji: '嚾',
        radicals: &['口', '⺾', '隹'],
    },
    Decomposition {
        kanji: '囅',
        radicals: &['｜', '二', '十', '口', '尸', '日', '田', '衣'],
    },
    Decomposition {
        kanji: '囉',
        radicals: &['丶', 'ノ', '口', '小', '幺', '⺲', '糸', '隹'],
    },
    Decomposition {
        kanji: '囊',
        radicals: &['一', '｜', '二', '冖', '十', '口', '衣'],
    },
    Decomposition {
        kanji: '囋',
        radicals: &['ノ', '儿', 'ハ', '口', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '囏',
        radicals: &['一', '｜', '二', '丷', '十', '口', '士', '大', '豆', '革'],
    },
    Decomposition {
        kanji: '囐',
        radicals: &[
            '丶', '儿', '冂', '匕', '卜', '厂', '口', '大', '犬', '虍', '鬲',
        ],
    },
    Decomposition {
        kanji: '囌',
        radicals: &['ノ', '口', '⺾', '木', '⺣', '田', '禾', '魚'],
    },
    Decomposition {
        kanji: '囍',
        radicals: &['一', '丶', 'ノ', '丷', '十', '口', '士', '豆'],
    },
    Decomposition {
        kanji: '囙',
        radicals: &['一', '囗'],
    },
    Decomposition {
        kanji: '囜',
        radicals: &['厶', '囗'],
    },
    Decomposition {
        kanji: '囝',
        radicals: &['囗', '子'],
    },
    Decomposition {
        kanji: '囟',
        radicals: &['丶', 'ノ', '囗'],
    },
    Decomposition {
        kanji: '囡',
        radicals: &['囗', '女'],
    },
    Decomposition {
        kanji: '囤',
        radicals: &['ノ', '乙', '凵', '囗', '屯'],
    },
    Decomposition {
        kanji: '囥',
        radicals: &['一', '丶', '亠', '几', '囗'],
    },
    Decomposition {
        kanji: '囦',
        radicals: &['囗', '水'],
    },
    Decomposition {
        kanji: '囧',
        radicals: &['ハ', '口', '囗'],
    },
    Decomposition {
        kanji: '囨',
        radicals: &['一', '｜', 'ノ', '囗'],
    },
    Decomposition {
        kanji: '囱',
        radicals: &['丶', 'ノ', '囗', '夂'],
    },
    Decomposition {
        kanji: '囫',
        radicals: &['ノ', '勹', '囗', '勿'],
    },
    Decomposition {
        kanji: '园',
        radicals: &['二', '儿', '囗', '元'],
    },
    Decomposition {
        kanji: '囶',
        radicals: &['ハ', '囗', '土'],
    },
    Decomposition {
        kanji: '囷',
        radicals: &['ノ', '囗', '木', '禾'],
    },
    Decomposition {
        kanji: '圁',
        radicals: &['囗', '言'],
    },
    Decomposition {
        kanji: '圂',
        radicals: &['囗', '豕'],
    },
    Decomposition {
        kanji: '圇',
        radicals: &['一', '｜', '亅', '𠆢', '冂', '囗', '冊', '廾'],
    },
    Decomposition {
        kanji: '圊',
        radicals: &['一', '｜', '二', '亠', '冂', '囗', '土', '月', '青'],
    },
    Decomposition {
        kanji: '圌',
        radicals: &['囗', '山', '而'],
    },
    Decomposition {
        kanji: '圑',
        radicals: &['一', '｜', '丶', '二', '冂', '囗', '寸', '巾'],
    },
    Decomposition {
        kanji: '圕',
        radicals: &['｜', '二', '囗', 'ヨ', '日', '聿'],
    },
    Decomposition {
        kanji: '圚',
        radicals: &['一', '｜', 'ハ', '口', '囗', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '圛',
        radicals: &['一', '｜', '丷', '十', '土', '干', '⺲'],
    },
    Decomposition {
        kanji: '圝',
        radicals: &['囗', '小', '幺', '糸', '言'],
    },
    Decomposition {
        kanji: '圠',
        radicals: &['乙', '土'],
    },
    Decomposition {
        kanji: '圢',
        radicals: &['一', '亅', '土'],
    },
    Decomposition {
        kanji: '圣',
        radicals: &['又', '土'],
    },
    Decomposition {
        kanji: '圤',
        radicals: &['卜', '土'],
    },
    Decomposition {
        kanji: '圥',
        radicals: &['儿', '土'],
    },
    Decomposition {
        kanji: '圩',
        radicals: &['亅', '二', '土'],
    },
    Decomposition {
        kanji: '圪',
        radicals: &['一', 'ノ', '乙', '土'],
    },
    Decomposition {
        kanji: '圬',
        radicals: &['二', '勹', '土'],
    },
    Decomposition {
        kanji: '圮',
        radicals: &['土', '已'],
    },
    Decomposition {
        kanji: '圯',
        radicals: &['土', '已'],
    },
    Decomposition {
        kanji: '圳',
        radicals: &['土', '川'],
    },
    Decomposition {
        kanji: '圴',
        radicals: &['一', '丶', '勹', '土'],
    },
    Decomposition {
        kanji: '圽',
        radicals: &['ノ', '勹', '土', '勿'],
    },
    Decomposition {
        kanji: '圾',
        radicals: &['丶', '又', '乃', '土', '及'],
    },
    Decomposition {
        kanji: '圿',
        radicals: &['｜', 'ノ', '𠆢', '土'],
    },
    Decomposition {
        kanji: '坅',
        radicals: &['一', '丶', '𠆢', '土'],
    },
    Decomposition {
        kanji: '坆',
        radicals: &['土', '攵'],
    },
    Decomposition {
        kanji: '坌',
        radicals: &['ハ', '刀', '土'],
    },
    Decomposition {
        kanji: '坍',
        radicals: &['一', '丶', '冂', '土', '舟'],
    },
    Decomposition {
        kanji: '坒',
        radicals: &['匕', '土', '比'],
    },
    Decomposition {
        kanji: '坢',
        radicals: &['｜', '二', '丷', '土'],
    },
    Decomposition {
        kanji: '坥',
        radicals: &['一', '土', '目'],
    },
    Decomposition {
        kanji: '坧',
        radicals: &['一', 'ノ', '口', '土', '石'],
    },
    Decomposition {
        kanji: '坨',
        radicals: &['匕', '土', '宀'],
    },
    Decomposition {
        kanji: '坫',
        radicals: &['卜', '口', '土'],
    },
    Decomposition {
        kanji: '坭',
        radicals: &['匕', '土', '尸'],
    },
    Decomposition {
        kanji: '坮',
        radicals: &['厶', '口', '土'],
    },
    Decomposition {
        kanji: '坯',
        radicals: &['一', '｜', '丶', 'ノ', '土'],
    },
    Decomposition {
        kanji: '坰',
        radicals: &['冂', '口', '土'],
    },
    Decomposition {
        kanji: '坱',
        radicals: &['土', '大'],
    },
    Decomposition {
        kanji: '坳',
        radicals: &['力', '土', '幺'],
    },
    Decomposition {
        kanji: '坴',
        radicals: &['儿', 'ハ', '土'],
    },
    Decomposition {
        kanji: '坵',
        radicals: &['一', '土', '斤'],
    },
    Decomposition {
        kanji: '坷',
        radicals: &['一', '亅', '口', '土'],
    },
    Decomposition {
        kanji: '坹',
        radicals: &['ハ', '土', '宀', '穴'],
    },
    Decomposition {
        kanji: '坺',
        radicals: &['又', '土', '弋'],
    },
    Decomposition {
        kanji: '坻',
        radicals: &['一', '丶', '土', '氏'],
    },
    Decomposition {
        kanji: '坼',
        radicals: &['丶', '土', '斤'],
    },
    Decomposition {
        kanji: '坾',
        radicals: &['一', '亅', '土', '宀'],
    },
    Decomposition {
        kanji: '垁',
        radicals: &['一', 'ノ', '土', '大', '矢'],
    },
    Decomposition {
        kanji: '垃',
        radicals: &['土', '立'],
    },
    Decomposition {
        kanji: '垌',
        radicals: &['一', '冂', '口', '土'],
    },
    Decomposition {
        kanji: '垔',
        radicals: &['土', '西'],
    },
    Decomposition {
        kanji: '垗',
        radicals: &['丶', 'ノ', '儿', 'ハ', '冫', '土'],
    },
    Decomposition {
        kanji: '垙',
        radicals: &['一', '儿', '土', '⺌'],
    },
    Decomposition {
        kanji: '垚',
        radicals: &['土'],
    },
    Decomposition {
        kanji: '垜',
        radicals: &['乃', '土', '木'],
    },
    Decomposition {
        kanji: '垝',
        radicals: &['ノ', '勹', '卩', '厂', '土'],
    },
    Decomposition {
        kanji: '垞',
        radicals: &['一', 'ノ', '乙', '匕', '土', '宀'],
    },
    Decomposition {
        kanji: '垟',
        radicals: &['丷', '土', '王', '羊'],
    },
    Decomposition {
        kanji: '垡',
        radicals: &['丶', '乙', '⺅', '土', '戈'],
    },
    Decomposition {
        kanji: '垕',
        radicals: &['一', 'ノ', '厂', '口', '土'],
    },
    Decomposition {
        kanji: '垧',
        radicals: &['ノ', '冂', '口', '土'],
    },
    Decomposition {
        kanji: '垨',
        radicals: &['土', '宀', '寸'],
    },
    Decomposition {
        kanji: '垩',
        radicals: &['｜', '丶', 'ノ', '二', '丷', '土'],
    },
    Decomposition {
        kanji: '垬',
        radicals: &['｜', '二', 'ハ', '土'],
    },
    Decomposition {
        kanji: '垸',
        radicals: &['一', '二', '儿', '土', '宀', '元'],
    },
    Decomposition {
        kanji: '垽',
        radicals: &['土', '⺡', '斤'],
    },
    Decomposition {
        kanji: '埇',
        radicals: &['マ', '土', '用'],
    },
    Decomposition {
        kanji: '埈',
        radicals: &['儿', '厶', '土', '夂'],
    },
    Decomposition {
        kanji: '埌',
        radicals: &['丶', '土', '艮'],
    },
    Decomposition {
        kanji: '埏',
        radicals: &['ノ', '土', '廴', '止'],
    },
    Decomposition {
        kanji: '埕',
        radicals: &['｜', 'ノ', '二', '口', '土', '王'],
    },
    Decomposition {
        kanji: '埝',
        radicals: &['丶', '𠆢', '土', '心'],
    },
    Decomposition {
        kanji: '埞',
        radicals: &['土', '宀', '疋'],
    },
    Decomposition {
        kanji: '埤',
        radicals: &['ノ', '十', '土', '日'],
    },
    Decomposition {
        kanji: '埦',
        radicals: &['卩', '土', '夕', '宀'],
    },
    Decomposition {
        kanji: '埧',
        radicals: &['一', 'ハ', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '埩',
        radicals: &['亅', '勹', '土', 'ヨ'],
    },
    Decomposition {
        kanji: '埭',
        radicals: &['土', 'ヨ', '水', '隶'],
    },
    Decomposition {
        kanji: '埰',
        radicals: &['土', '木', '爪'],
    },
    Decomposition {
        kanji: '埵',
        radicals: &['一', 'ノ', '土', '車'],
    },
    Decomposition {
        kanji: '埶',
        radicals: &['丶', '儿', 'ハ', '九', '土'],
    },
    Decomposition {
        kanji: '埸',
        radicals: &['ノ', '勹', '土', '日', '勿'],
    },
    Decomposition {
        kanji: '埽',
        radicals: &['｜', '冂', '冖', '土', '巾', 'ヨ'],
    },
    Decomposition {
        kanji: '埾',
        radicals: &['又', '土', '耳'],
    },
    Decomposition {
        kanji: '埿',
        radicals: &['匕', '土', '尸', '⺡'],
    },
    Decomposition {
        kanji: '堃',
        radicals: &['土', '方'],
    },
    Decomposition {
        kanji: '堄',
        radicals: &['儿', '土', '臼'],
    },
    Decomposition {
        kanji: '堈',
        radicals: &['一', '丷', '冂', '土', '山', '岡'],
    },
    Decomposition {
        kanji: '堉',
        radicals: &['亠', '厶', '土', '月'],
    },
    Decomposition {
        kanji: '埡',
        radicals: &['一', '｜', '土'],
    },
    Decomposition {
        kanji: '堌',
        radicals: &['十', '口', '囗', '土'],
    },
    Decomposition {
        kanji: '堍',
        radicals: &['一', '｜', '丶', 'ノ', '乙', '儿', '勹', '口', '土', '免'],
    },
    Decomposition {
        kanji: '堛',
        radicals: &['一', '口', '土', '田'],
    },
    Decomposition {
        kanji: '堞',
        radicals: &['一', '｜', '土', '木', '世'],
    },
    Decomposition {
        kanji: '堟',
        radicals: &['土', 'ヨ', '彑', '豕'],
    },
    Decomposition {
        kanji: '堠',
        radicals: &['一', 'ノ', '⺅', 'ユ', '土', '大', '矢'],
    },
    Decomposition {
        kanji: '堦',
        radicals: &['匕', '土', '日', '比', '白'],
    },
    Decomposition {
        kanji: '堧',
        radicals: &['土', '大', '而'],
    },
    Decomposition {
        kanji: '堭',
        radicals: &['土', '日', '王', '白'],
    },
    Decomposition {
        kanji: '堲',
        radicals: &['匕', '卩', '厶', '土', '日', '白'],
    },
    Decomposition {
        kanji: '堹',
        radicals: &['一', '｜', 'ノ', '土', '日', '車'],
    },
    Decomposition {
        kanji: '堿',
        radicals: &['一', 'ノ', '厂', '口', '土', '戈'],
    },
    Decomposition {
        kanji: '塉',
        radicals: &['丶', 'ノ', '二', '人', '冫', '土', '月'],
    },
    Decomposition {
        kanji: '塌',
        radicals: &['ノ', '亅', '冫', '土', '日', '羽'],
    },
    Decomposition {
        kanji: '塍',
        radicals: &['一', '丶', 'ハ', '丷', '冂', '土', '大', '月'],
    },
    Decomposition {
        kanji: '塏',
        radicals: &['丷', '口', '土', '山', '豆'],
    },
    Decomposition {
        kanji: '塐',
        radicals: &['一', '｜', '二', '土', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '塕',
        radicals: &['𠆢', 'ハ', '冫', '厶', '土', '羽'],
    },
    Decomposition {
        kanji: '塟',
        radicals: &['一', '匕', '土', '夕', '⺾', '歹'],
    },
    Decomposition {
        kanji: '塡',
        radicals: &['ハ', '匕', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '塤',
        radicals: &['ハ', '口', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '塧',
        radicals: &['一', 'ハ', '丷', '土', '皿'],
    },
    Decomposition {
        kanji: '塨',
        radicals: &['｜', '丶', 'ノ', '亅', '二', '土', '⺣'],
    },
    Decomposition {
        kanji: '塸',
        radicals: &['匚', '口', '土'],
    },
    Decomposition {
        kanji: '塼',
        radicals: &['丶', '厶', '土', '寸', '日', '車'],
    },
    Decomposition {
        kanji: '塿',
        radicals: &['｜', '口', '土', '女', '日'],
    },
    Decomposition {
        kanji: '墀',
        radicals: &['｜', '丶', 'ノ', '二', '冫', '土', '尸', '牛'],
    },
    Decomposition {
        kanji: '墁',
        radicals: &['二', '冂', '又', '土', '日', '⺲'],
    },
    Decomposition {
        kanji: '墇',
        radicals: &['十', '土', '日', '曰', '立'],
    },
    Decomposition {
        kanji: '墈',
        radicals: &['一', '｜', '二', 'ハ', '力', '匚', '土', '甘'],
    },
    Decomposition {
        kanji: '墉',
        radicals: &['｜', '土', '广', 'ヨ', '月', '用'],
    },
    Decomposition {
        kanji: '墊',
        radicals: &['一', '丶', '丷', '十', '九', '土'],
    },
    Decomposition {
        kanji: '墌',
        radicals: &['一', '｜', '土', '广', '⺣'],
    },
    Decomposition {
        kanji: '墍',
        radicals: &['乙', '匕', '土', '无', '日', '白', '牙'],
    },
    Decomposition {
        kanji: '墏',
        radicals: &['丶', '土', '夕', '寸', '爿'],
    },
    Decomposition {
        kanji: '墐',
        radicals: &['二', '十', '口', '土', '革'],
    },
    Decomposition {
        kanji: '墔',
        radicals: &['土', '山', '隹'],
    },
    Decomposition {
        kanji: '墖',
        radicals: &['一', '𠆢', '口', '土', '田'],
    },
    Decomposition {
        kanji: '墝',
        radicals: &['一', '儿', '土'],
    },
    Decomposition {
        kanji: '墠',
        radicals: &['一', '｜', '十', '口', '土', '日', '田'],
    },
    Decomposition {
        kanji: '墡',
        radicals: &['一', '丷', '口', '土', '王', '羊'],
    },
    Decomposition {
        kanji: '墢',
        radicals: &['几', '又', '土', '弓', '殳', '癶'],
    },
    Decomposition {
        kanji: '墦',
        radicals: &['ノ', '土', '田', '米'],
    },
    Decomposition {
        kanji: '墩',
        radicals: &['亠', '口', '土', '子', '攵'],
    },
    Decomposition {
        kanji: '墱',
        radicals: &['丷', '口', '土', '癶', '豆'],
    },
    Decomposition {
        kanji: '墲',
        radicals: &['一', '｜', 'ノ', '土', '⺣', '無'],
    },
    Decomposition {
        kanji: '壄',
        radicals: &['マ', '土', '木', '矛'],
    },
    Decomposition {
        kanji: '墼',
        radicals: &['几', '凵', '又', '土', '山', '殳', '車'],
    },
    Decomposition {
        kanji: '壂',
        radicals: &['｜', '二', 'ハ', '几', '又', '土', '尸', '殳'],
    },
    Decomposition {
        kanji: '壈',
        radicals: &['ノ', '亠', '口', '囗', '土', '木', '禾'],
    },
    Decomposition {
        kanji: '壍',
        radicals: &['土', '⺡', '斤', '車'],
    },
    Decomposition {
        kanji: '壎',
        radicals: &['一', '｜', 'ノ', '二', '丷', '口', '土', '⺣', '車'],
    },
    Decomposition {
        kanji: '壐',
        radicals: &['一', '｜', '丶', 'ノ', 'ハ', '冂', '土', '巾', '爻'],
    },
    Decomposition {
        kanji: '壒',
        radicals: &['厶', '土', '⺾', '皿'],
    },
    Decomposition {
        kanji: '壔',
        radicals: &['一', '口', '土', '士', '寸', '工'],
    },
    Decomposition {
        kanji: '壖',
        radicals: &['一', '｜', '冖', '土', '而', '雨'],
    },
    Decomposition {
        kanji: '壚',
        radicals: &['匕', '卜', '厂', '土', '田', '皿', '虍'],
    },
    Decomposition {
        kanji: '壝',
        radicals: &['ハ', '土', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '壡',
        radicals: &['一', '𠆢', 'ハ', '冖', '卜', '又', '口', '土', '谷'],
    },
    Decomposition {
        kanji: '壢',
        radicals: &['ノ', '厂', '土', '木', '止', '禾'],
    },
    Decomposition {
        kanji: '壩',
        radicals: &[
            '一', '｜', '二', '冖', '十', '口', '土', '廾', '月', '雨', '革',
        ],
    },
    Decomposition {
        kanji: '壳',
        radicals: &['一', '冖', '几', '士'],
    },
    Decomposition {
        kanji: '夅',
        radicals: &['｜', '二', '土', '夂'],
    },
    Decomposition {
        kanji: '夆',
        radicals: &['一', '｜', '二', '夂'],
    },
    Decomposition {
        kanji: '夋',
        radicals: &['儿', 'ハ', '厶', '夂'],
    },
    Decomposition {
        kanji: '夌',
        radicals: &['儿', 'ハ', '土', '夂'],
    },
    Decomposition {
        kanji: '夒',
        radicals: &['一', 'ハ', '夂', '已', '止', '目', '自', '貝', '頁'],
    },
    Decomposition {
        kanji: '夓',
        radicals: &['一', 'ハ', '夂', 'ヨ', '目', '自', '臼', '貝', '頁'],
    },
    Decomposition {
        kanji: '夔',
        radicals: &[
            '一', '儿', 'ハ', '丷', '夂', '已', '止', '目', '自', '見', '首',
        ],
    },
    Decomposition {
        kanji: '虁',
        radicals: &[
            '一', '｜', '儿', 'ハ', '丷', '卜', '夂', '已', '⺾', '止', '目', '自', '見', '首',
        ],
    },
    Decomposition {
        kanji: '夝',
        radicals: &['夕', '生'],
    },
    Decomposition {
        kanji: '夡',
        radicals: &['口', '士', '夕'],
    },
    Decomposition {
        kanji: '夣',
        radicals: &['亠', '冖', '厶', '夕', '⺲'],
    },
    Decomposition {
        kanji: '夤',
        radicals: &['一', '｜', 'ハ', '夕', '宀', '田'],
    },
    Decomposition {
        kanji: '夨',
        radicals: &['大'],
    },
    Decomposition {
        kanji: '夯',
        radicals: &['力', '大'],
    },
    Decomposition {
        kanji: '夰',
        radicals: &['｜', 'ノ', '大'],
    },
    Decomposition {
        kanji: '夳',
        radicals: &['二', '大'],
    },
    Decomposition {
        kanji: '夵',
        radicals: &['大', '小'],
    },
    Decomposition {
        kanji: '夶',
        radicals: &['大'],
    },
    Decomposition {
        kanji: '夿',
        radicals: &['乙', '大', '已', '巴'],
    },
    Decomposition {
        kanji: '奃',
        radicals: &['丶', '大', '氏'],
    },
    Decomposition {
        kanji: '奆',
        radicals: &['匚', '口', '大'],
    },
    Decomposition {
        kanji: '奒',
        radicals: &['亠', '大', '幺', '玄'],
    },
    Decomposition {
        kanji: '奓',
        radicals: &['夕', '大'],
    },
    Decomposition {
        kanji: '奙',
        radicals: &['乙', '厶', '大', '日', '奄'],
    },
    Decomposition {
        kanji: '奛',
        radicals: &['大', '日', '月'],
    },
    Decomposition {
        kanji: '奝',
        radicals: &['｜', '二', '冂', '口', '土', '大'],
    },
    Decomposition {
        kanji: '奞',
        radicals: &['大', '隹'],
    },
    Decomposition {
        kanji: '奟',
        radicals: &['丶', '冂', '大', '月'],
    },
    Decomposition {
        kanji: '奡',
        radicals: &['一', '｜', 'ノ', '大', '目', '自'],
    },
    Decomposition {
        kanji: '奣',
        radicals: &['一', '大', '日', '月'],
    },
    Decomposition {
        kanji: '奫',
        radicals: &['一', '大', '⺡', '爿', '片'],
    },
    Decomposition {
        kanji: '奭',
        radicals: &['一', '大', '日', '白'],
    },
    Decomposition {
        kanji: '奯',
        radicals: &['一', '｜', 'ノ', '厂', '大', '戈', '止'],
    },
    Decomposition {
        kanji: '奲',
        radicals: &['ノ', '十', '口', '土', '大', '⺹', '日', '田'],
    },
    Decomposition {
        kanji: '奵',
        radicals: &['一', '亅', '女'],
    },
    Decomposition {
        kanji: '奶',
        radicals: &['乃', '女'],
    },
    Decomposition {
        kanji: '她',
        radicals: &['｜', '乙', '匕', '女', '也'],
    },
    Decomposition {
        kanji: '奻',
        radicals: &['女'],
    },
    Decomposition {
        kanji: '奼',
        radicals: &['一', 'ノ', '乙', '匕', '女'],
    },
    Decomposition {
        kanji: '妋',
        radicals: &['一', 'ノ', '二', '大', '女', '无'],
    },
    Decomposition {
        kanji: '妌',
        radicals: &['一', '二', '女', '廾'],
    },
    Decomposition {
        kanji: '妎',
        radicals: &['｜', 'ノ', '𠆢', '女'],
    },
    Decomposition {
        kanji: '妒',
        radicals: &['一', '丶', 'ノ', '女', '尸', '戸'],
    },
    Decomposition {
        kanji: '妕',
        radicals: &['｜', '口', '女'],
    },
    Decomposition {
        kanji: '妗',
        radicals: &['一', '丶', '𠆢', '女'],
    },
    Decomposition {
        kanji: '妟',
        radicals: &['女', '日'],
    },
    Decomposition {
        kanji: '妤',
        radicals: &['一', '亅', 'マ', '女', '矛'],
    },
    Decomposition {
        kanji: '妧',
        radicals: &['二', '儿', '女'],
    },
    Decomposition {
        kanji: '妭',
        radicals: &['又', '女', '弋'],
    },
    Decomposition {
        kanji: '妮',
        radicals: &['匕', '女', '尸'],
    },
    Decomposition {
        kanji: '妯',
        radicals: &['｜', '女', '日', '田'],
    },
    Decomposition {
        kanji: '妰',
        radicals: &['一', '｜', 'ノ', '二', '女'],
    },
    Decomposition {
        kanji: '妳',
        radicals: &['一', 'ノ', '亅', 'ハ', '勹', '女', '小'],
    },
    Decomposition {
        kanji: '妷',
        radicals: &['一', 'ノ', '大', '女'],
    },
    Decomposition {
        kanji: '妺',
        radicals: &['一', '女', '木'],
    },
    Decomposition {
        kanji: '妼',
        radicals: &['ノ', '女', '心'],
    },
    Decomposition {
        kanji: '姁',
        radicals: &['勹', '口', '女'],
    },
    Decomposition {
        kanji: '姃',
        radicals: &['一', '女', '止'],
    },
    Decomposition {
        kanji: '姄',
        radicals: &['女', '尸', '氏'],
    },
    Decomposition {
        kanji: '姈',
        radicals: &['一', '｜', '丶', '亅', '𠆢', 'マ', '女'],
    },
    Decomposition {
        kanji: '姊',
        radicals: &['｜', 'ノ', '亅', '女', '牙'],
    },
    Decomposition {
        kanji: '姍',
        radicals: &['一', '｜', '亅', '冂', '女', '冊', '廾'],
    },
    Decomposition {
        kanji: '姒',
        radicals: &['丶', 'ノ', '女'],
    },
    Decomposition {
        kanji: '姝',
        radicals: &['一', 'ノ', '木'],
    },
    Decomposition {
        kanji: '姞',
        radicals: &['口', '士', '女'],
    },
    Decomposition {
        kanji: '姟',
        radicals: &['亠', '女', '幺', '玄'],
    },
    Decomposition {
        kanji: '姣',
        radicals: &['亠', '女', '父'],
    },
    Decomposition {
        kanji: '姤',
        radicals: &['一', 'ノ', '口', '女'],
    },
    Decomposition {
        kanji: '姧',
        radicals: &['一', '十', '女', '干'],
    },
    Decomposition {
        kanji: '姮',
        radicals: &['一', '女', '日'],
    },
    Decomposition {
        kanji: '姯',
        radicals: &['一', '儿', '女', '⺌'],
    },
    Decomposition {
        kanji: '姱',
        radicals: &['二', '勹', '大', '女'],
    },
    Decomposition {
        kanji: '姲',
        radicals: &['女', '宀'],
    },
    Decomposition {
        kanji: '姴',
        radicals: &['⺉', '女', '歹'],
    },
    Decomposition {
        kanji: '姷',
        radicals: &['一', 'ノ', '女', '月'],
    },
    Decomposition {
        kanji: '娀',
        radicals: &['一', 'ノ', '女', '戈'],
    },
    Decomposition {
        kanji: '娄',
        radicals: &['女', '米'],
    },
    Decomposition {
        kanji: '娌',
        radicals: &['女', '里'],
    },
    Decomposition {
        kanji: '娍',
        radicals: &['ノ', '亅', '厂', '女', '戈'],
    },
    Decomposition {
        kanji: '娎',
        radicals: &['女', '扌', '斤'],
    },
    Decomposition {
        kanji: '娒',
        radicals: &['一', 'ノ', '女', '毋', '母'],
    },
    Decomposition {
        kanji: '娓',
        radicals: &['女', '尸', '毛'],
    },
    Decomposition {
        kanji: '娞',
        radicals: &['女', '爪'],
    },
    Decomposition {
        kanji: '娣',
        radicals: &['｜', 'ノ', '丷', '女', '弓'],
    },
    Decomposition {
        kanji: '娤',
        radicals: &['士', '女', '爿'],
    },
    Decomposition {
        kanji: '娧',
        radicals: &['儿', 'ハ', '丷', '口', '女'],
    },
    Decomposition {
        kanji: '娨',
        radicals: &['一', '十', '女', '干', '日'],
    },
    Decomposition {
        kanji: '娪',
        radicals: &['一', '二', '口', '女', '五'],
    },
    Decomposition {
        kanji: '娭',
        radicals: &['一', 'ノ', '厶', '大', '女', '矢'],
    },
    Decomposition {
        kanji: '娰',
        radicals: &['丶', 'ノ', '⺅', '女'],
    },
    Decomposition {
        kanji: '婄',
        radicals: &['口', '女', '立'],
    },
    Decomposition {
        kanji: '婅',
        radicals: &['勹', '女', '米'],
    },
    Decomposition {
        kanji: '婇',
        radicals: &['女', '木', '爪'],
    },
    Decomposition {
        kanji: '婈',
        radicals: &['ハ', '土', '夂', '女'],
    },
    Decomposition {
        kanji: '婌',
        radicals: &['一', '卜', '又', '女', '小'],
    },
    Decomposition {
        kanji: '婐',
        radicals: &['女', '日', '木', '田'],
    },
    Decomposition {
        kanji: '婕',
        radicals: &['土', '女', 'ヨ', '走'],
    },
    Decomposition {
        kanji: '婞',
        radicals: &['一', '丷', '十', '土', '女', '干'],
    },
    Decomposition {
        kanji: '婣',
        radicals: &['女', '爿', '片'],
    },
    Decomposition {
        kanji: '婥',
        radicals: &['十', '卜', '女', '日'],
    },
    Decomposition {
        kanji: '婧',
        radicals: &['二', '亠', '土', '女', '月', '青'],
    },
    Decomposition {
        kanji: '婭',
        radicals: &['一', '｜', '女'],
    },
    Decomposition {
        kanji: '婷',
        radicals: &['一', '亅', '亠', '冖', '口', '女'],
    },
    Decomposition {
        kanji: '婺',
        radicals: &['マ', '女', '攵', '矛'],
    },
    Decomposition {
        kanji: '婻',
        radicals: &['一', '丷', '冂', '十', '女', '干'],
    },
    Decomposition {
        kanji: '婾',
        radicals: &['一', '丶', 'ノ', '人', '冂', '女', '月'],
    },
    Decomposition {
        kanji: '媋',
        radicals: &['一', '二', '大', '女', '日'],
    },
    Decomposition {
        kanji: '媐',
        radicals: &['匚', '女', '已', '臣'],
    },
    Decomposition {
        kanji: '媓',
        radicals: &['女', '日', '王', '白'],
    },
    Decomposition {
        kanji: '媖',
        radicals: &['大', '女', '⺾'],
    },
    Decomposition {
        kanji: '媙',
        radicals: &['一', 'ノ', '厂', '女', '戈'],
    },
    Decomposition {
        kanji: '媜',
        radicals: &['ハ', '卜', '女', '目', '貝'],
    },
    Decomposition {
        kanji: '媞',
        radicals: &['女', '日', '疋'],
    },
    Decomposition {
        kanji: '媟',
        radicals: &['一', '｜', '女', '木', '世'],
    },
    Decomposition {
        kanji: '媠',
        radicals: &['一', 'ノ', '女', '工', '月'],
    },
    Decomposition {
        kanji: '媢',
        radicals: &['二', '冂', '女', '目'],
    },
    Decomposition {
        kanji: '媧',
        radicals: &['冂', '口', '女'],
    },
    Decomposition {
        kanji: '媬',
        radicals: &['⺅', '口', '女', '木'],
    },
    Decomposition {
        kanji: '媱',
        radicals: &['丶', '凵', '夕', '女', '山', '爪', '缶'],
    },
    Decomposition {
        kanji: '媲',
        radicals: &['丶', 'ノ', '匕', '口', '女', '比'],
    },
    Decomposition {
        kanji: '媳',
        radicals: &['女', '心', '目', '自'],
    },
    Decomposition {
        kanji: '媵',
        radicals: &['一', '丶', 'ハ', '丷', '冂', '大', '女', '月'],
    },
    Decomposition {
        kanji: '媸',
        radicals: &['一', '女', '屮', '山', '虫'],
    },
    Decomposition {
        kanji: '媺',
        radicals: &['一', '儿', '几', '女', '山', '攵'],
    },
    Decomposition {
        kanji: '媻',
        radicals: &['一', '｜', '丶', '冂', '几', '又', '女', '殳', '舟'],
    },
    Decomposition {
        kanji: '媿',
        radicals: &['儿', '匕', '厶', '女', '田', '鬼'],
    },
    Decomposition {
        kanji: '嫄',
        radicals: &['厂', '女', '小', '日', '白'],
    },
    Decomposition {
        kanji: '嫆',
        radicals: &['𠆢', 'ハ', '口', '女', '宀', '谷'],
    },
    Decomposition {
        kanji: '嫈',
        radicals: &['冖', '女', '火'],
    },
    Decomposition {
        kanji: '嫏',
        radicals: &['丶', '厶', '女', '⻏', '日'],
    },
    Decomposition {
        kanji: '嫚',
        radicals: &['又', '女', '日', '⺲'],
    },
    Decomposition {
        kanji: '嫜',
        radicals: &['十', '女', '日', '立', '音'],
    },
    Decomposition {
        kanji: '嫠',
        radicals: &['一', '厂', '女', '攵', '木'],
    },
    Decomposition {
        kanji: '嫥',
        radicals: &['一', '｜', '十', '厶', '女', '寸', '日', '虫'],
    },
    Decomposition {
        kanji: '嫪',
        radicals: &['ノ', '𠆢', '冫', '女', '彡', '羽'],
    },
    Decomposition {
        kanji: '嫮',
        radicals: &['一', '｜', '二', '冂', '勹', '女', '雨'],
    },
    Decomposition {
        kanji: '嫵',
        radicals: &['一', '｜', 'ノ', '女', '⺣', '無'],
    },
    Decomposition {
        kanji: '嫶',
        radicals: &['女', '⺣', '隹'],
    },
    Decomposition {
        kanji: '嫽',
        radicals: &['丶', 'ノ', '大', '女', '小', '日', '曰'],
    },
    Decomposition {
        kanji: '嬀',
        radicals: &['ノ', '亅', '女', '⺣', '爪'],
    },
    Decomposition {
        kanji: '嬁',
        radicals: &['丷', '口', '女', '癶', '豆'],
    },
    Decomposition {
        kanji: '嬈',
        radicals: &['一', '儿', '土', '女'],
    },
    Decomposition {
        kanji: '嬗',
        radicals: &['一', '亠', '口', '囗', '女', '日'],
    },
    Decomposition {
        kanji: '嬴',
        radicals: &['一', '丶', '亠', '几', '口', '女', '亡', '月'],
    },
    Decomposition {
        kanji: '嬙',
        radicals: &['人', '口', '囗', '土', '女'],
    },
    Decomposition {
        kanji: '嬛',
        radicals: &['一', '口', '女', '⺲', '衣'],
    },
    Decomposition {
        kanji: '嬝',
        radicals: &['一', '｜', '亅', '亠', '女', '日', '白', '衣', '鳥'],
    },
    Decomposition {
        kanji: '嬡',
        radicals: &['冖', '夂', '女', '心', '爪'],
    },
    Decomposition {
        kanji: '嬥',
        radicals: &['ノ', '冫', '女', '羽', '隹'],
    },
    Decomposition {
        kanji: '嬭',
        radicals: &['一', '｜', 'ハ', '冂', '女', '爻'],
    },
    Decomposition {
        kanji: '嬸',
        radicals: &['ノ', '女', '宀', '田', '米'],
    },
    Decomposition {
        kanji: '孁',
        radicals: &['一', '｜', '二', '冖', '口', '女', '雨'],
    },
    Decomposition {
        kanji: '孋',
        radicals: &['一', '丶', '冂', '匕', '女', '广', '比', '鹿'],
    },
    Decomposition {
        kanji: '孌',
        radicals: &['女', '小', '幺', '糸', '言'],
    },
    Decomposition {
        kanji: '孒',
        radicals: &['一', '亅', '子'],
    },
    Decomposition {
        kanji: '孖',
        radicals: &['子'],
    },
    Decomposition {
        kanji: '孞',
        radicals: &['子', '心'],
    },
    Decomposition {
        kanji: '孨',
        radicals: &['子'],
    },
    Decomposition {
        kanji: '孮',
        radicals: &['二', '子', '宀', '小', '示'],
    },
    Decomposition {
        kanji: '孯',
        radicals: &['匚', '又', '子', '臣'],
    },
    Decomposition {
        kanji: '孼',
        radicals: &['｜', 'ノ', '十', '口', '子', '屮', '立', '辛'],
    },
    Decomposition {
        kanji: '孽',
        radicals: &['｜', 'ノ', '十', '口', '子', '⺾', '立', '辛'],
    },
    Decomposition {
        kanji: '孾',
        radicals: &['ハ', '女', '子', '目', '貝'],
    },
    Decomposition {
        kanji: '孿',
        radicals: &['子', '小', '幺', '糸', '言'],
    },
    Decomposition {
        kanji: '宁',
        radicals: &['一', '亅', '宀'],
    },
    Decomposition {
        kanji: '宄',
        radicals: &['九', '宀'],
    },
    Decomposition {
        kanji: '宆',
        radicals: &['宀', '弓'],
    },
    Decomposition {
        kanji: '宊',
        radicals: &['丶', '大', '宀', '犬'],
    },
    Decomposition {
        kanji: '宎',
        radicals: &['ノ', '大', '宀'],
    },
    Decomposition {
        kanji: '宐',
        radicals: &['一', '丶', '勹', '宀', 'ヨ', '彑'],
    },
    Decomposition {
        kanji: '宑',
        radicals: &['一', '宀', '廾'],
    },
    Decomposition {
        kanji: '宓',
        radicals: &['ノ', '宀', '心'],
    },
    Decomposition {
        kanji: '宔',
        radicals: &['丶', '宀', '王'],
    },
    Decomposition {
        kanji: '宖',
        radicals: &['厶', '宀', '弓'],
    },
    Decomposition {
        kanji: '宨',
        radicals: &['丶', 'ノ', '儿', '冫', '宀'],
    },
    Decomposition {
        kanji: '宩',
        radicals: &['宀', '米'],
    },
    Decomposition {
        kanji: '宬',
        radicals: &['ノ', '亅', '厂', '宀', '戈'],
    },
    Decomposition {
        kanji: '宭',
        radicals: &['ノ', '口', '宀', 'ヨ'],
    },
    Decomposition {
        kanji: '宯',
        radicals: &['ノ', '土', '子', '宀', '⺹'],
    },
    Decomposition {
        kanji: '宱',
        radicals: &['一', '｜', 'ノ', '⺅', '宀'],
    },
    Decomposition {
        kanji: '宲',
        radicals: &['口', '宀', '木'],
    },
    Decomposition {
        kanji: '宷',
        radicals: &['ノ', '宀', '米'],
    },
    Decomposition {
        kanji: '宺',
        radicals: &['｜', '儿', '口', '宀', '川'],
    },
    Decomposition {
        kanji: '宼',
        radicals: &['二', '儿', '女', '宀'],
    },
    Decomposition {
        kanji: '寀',
        radicals: &['宀', '木', '爪'],
    },
    Decomposition {
        kanji: '寁',
        radicals: &['土', '宀', 'ヨ', '走'],
    },
    Decomposition {
        kanji: '寍',
        radicals: &['宀', '心', '皿'],
    },
    Decomposition {
        kanji: '寏',
        radicals: &['ハ', '勹', '口', '大', '宀'],
    },
    Decomposition {
        kanji: '寖',
        radicals: &['冖', '又', '宀', 'ヨ', '⺡'],
    },
    Decomposition {
        kanji: '寗',
        radicals: &['一', '｜', 'ノ', '宀', '心', '月'],
    },
    Decomposition {
        kanji: '寘',
        radicals: &['一', 'ハ', '冂', '匕', '十', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '寙',
        radicals: &['厶', '宀', '瓜'],
    },
    Decomposition {
        kanji: '寚',
        radicals: &['凵', '宀', '山', '王', '缶'],
    },
    Decomposition {
        kanji: '寠',
        radicals: &['一', '｜', '口', '女', '宀', '日'],
    },
    Decomposition {
        kanji: '寯',
        radicals: &['｜', '亅', '宀', '隹'],
    },
    Decomposition {
        kanji: '寱',
        radicals: &['宀', '木', '爿', '目', '自'],
    },
    Decomposition {
        kanji: '寴',
        radicals: &['一', '儿', '宀', '小', '目', '立'],
    },
    Decomposition {
        kanji: '寽',
        radicals: &['寸', '爪'],
    },
    Decomposition {
        kanji: '尌',
        radicals: &['丷', '十', '口', '士', '寸', '豆'],
    },
    Decomposition {
        kanji: '尗',
        radicals: &['一', '卜', '小'],
    },
    Decomposition {
        kanji: '尞',
        radicals: &['丶', 'ノ', '大', '小', '日'],
    },
    Decomposition {
        kanji: '尟',
        radicals: &['一', 'ノ', '小', '日', '止', '疋'],
    },
    Decomposition {
        kanji: '尣',
        radicals: &['儿', 'ハ'],
    },
    Decomposition {
        kanji: '尦',
        radicals: &['丶', '儿', 'ハ', '勹'],
    },
    Decomposition {
        kanji: '尩',
        radicals: &['儿', 'ハ', '王'],
    },
    Decomposition {
        kanji: '尫',
        radicals: &['一', '儿', '王'],
    },
    Decomposition {
        kanji: '尬',
        radicals: &['一', '｜', 'ノ', '乙', '𠆢'],
    },
    Decomposition {
        kanji: '尮',
        radicals: &['一', 'ノ', '乙', '乃', '木'],
    },
    Decomposition {
        kanji: '尰',
        radicals: &['一', '｜', 'ノ', '乙', '二', '日', '車'],
    },
    Decomposition {
        kanji: '尲',
        radicals: &['一', '｜', '丶', 'ノ', '乙', '丷', 'ヨ'],
    },
    Decomposition {
        kanji: '尵',
        radicals: &['一', 'ノ', '乙', 'ハ', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '尶',
        radicals: &['一', '丶', 'ノ', '乙', '匚', '皿', '臣'],
    },
    Decomposition {
        kanji: '屙',
        radicals: &['一', '亅', '口', '尸', '⻖'],
    },
    Decomposition {
        kanji: '屚',
        radicals: &['尸', '雨'],
    },
    Decomposition {
        kanji: '屜',
        radicals: &['一', '｜', '尸', '彳', '世'],
    },
    Decomposition {
        kanji: '屢',
        radicals: &['一', '口', '女', '尸', '日'],
    },
    Decomposition {
        kanji: '屣',
        radicals: &['尸', '彳', '止'],
    },
    Decomposition {
        kanji: '屧',
        radicals: &['一', '｜', '尸', '彳', '木', '世'],
    },
    Decomposition {
        kanji: '屨',
        radicals: &['一', '｜', '口', '女', '尸', '彳', '日'],
    },
    Decomposition {
        kanji: '屩',
        radicals: &['ノ', '冂', '口', '大', '尸', '彳'],
    },
    Decomposition {
        kanji: '屭',
        radicals: &['ハ', '尸', '目', '貝'],
    },
    Decomposition {
        kanji: '屰',
        radicals: &['一', '丷', '屮'],
    },
    Decomposition {
        kanji: '屴',
        radicals: &['力', '山'],
    },
    Decomposition {
        kanji: '屵',
        radicals: &['厂', '山'],
    },
    Decomposition {
        kanji: '屺',
        radicals: &['山', '已'],
    },
    Decomposition {
        kanji: '屻',
        radicals: &['ノ', '刀', '山'],
    },
    Decomposition {
        kanji: '屼',
        radicals: &['一', '儿', '山'],
    },
    Decomposition {
        kanji: '屽',
        radicals: &['一', '十', '山', '干'],
    },
    Decomposition {
        kanji: '岇',
        radicals: &['ノ', '卩', '山'],
    },
    Decomposition {
        kanji: '岈',
        radicals: &['山', '牙'],
    },
    Decomposition {
        kanji: '岊',
        radicals: &['乙', '山', '已', '巴'],
    },
    Decomposition {
        kanji: '岏',
        radicals: &['二', '儿', '山', '元'],
    },
    Decomposition {
        kanji: '岒',
        radicals: &['丶', '人', '山'],
    },
    Decomposition {
        kanji: '岝',
        radicals: &['一', '｜', 'ノ', '二', '山'],
    },
    Decomposition {
        kanji: '岟',
        radicals: &['大', '山'],
    },
    Decomposition {
        kanji: '岠',
        radicals: &['匚', '口', '山'],
    },
    Decomposition {
        kanji: '岢',
        radicals: &['一', '亅', '口', '山'],
    },
    Decomposition {
        kanji: '岣',
        radicals: &['勹', '口', '山'],
    },
    Decomposition {
        kanji: '岦',
        radicals: &['山', '立'],
    },
    Decomposition {
        kanji: '岪',
        radicals: &['山', '廾', '弓'],
    },
    Decomposition {
        kanji: '岲',
        radicals: &['儿', '口', '山'],
    },
    Decomposition {
        kanji: '岴',
        radicals: &['一', '山', '斤'],
    },
    Decomposition {
        kanji: '岵',
        radicals: &['十', '口', '山'],
    },
    Decomposition {
        kanji: '岺',
        radicals: &['一', '｜', '丶', '亅', '人', 'マ', '山'],
    },
    Decomposition {
        kanji: '峉',
        radicals: &['口', '夂', '山'],
    },
    Decomposition {
        kanji: '峋',
        radicals: &['勹', '山', '日'],
    },
    Decomposition {
        kanji: '峒',
        radicals: &['一', '冂', '口', '山'],
    },
    Decomposition {
        kanji: '峝',
        radicals: &['一', '冂', '口', '山'],
    },
    Decomposition {
        kanji: '峗',
        radicals: &['勹', '卩', '厂', '山'],
    },
    Decomposition {
        kanji: '峮',
        radicals: &['ノ', '口', '山', 'ヨ'],
    },
    Decomposition {
        kanji: '峱',
        radicals: &['一', 'ユ', '山', '⺨'],
    },
    Decomposition {
        kanji: '峲',
        radicals: &['ノ', '⺉', '山', '木', '禾'],
    },
    Decomposition {
        kanji: '峴',
        radicals: &['儿', '山', '目', '見'],
    },
    Decomposition {
        kanji: '崁',
        radicals: &['人', '勹', '土', '山', '欠'],
    },
    Decomposition {
        kanji: '崆',
        radicals: &['儿', 'ハ', '宀', '山', '工'],
    },
    Decomposition {
        kanji: '崍',
        radicals: &['人', '大', '山'],
    },
    Decomposition {
        kanji: '崒',
        radicals: &['亠', '人', '十', '山'],
    },
    Decomposition {
        kanji: '崫',
        radicals: &['｜', '凵', '尸', '山'],
    },
    Decomposition {
        kanji: '崣',
        radicals: &['ノ', '女', '山', '木', '禾'],
    },
    Decomposition {
        kanji: '崤',
        radicals: &['一', '丶', 'ノ', '山', '月'],
    },
    Decomposition {
        kanji: '崦',
        radicals: &['乙', '大', '山', '日', '奄'],
    },
    Decomposition {
        kanji: '崧',
        radicals: &['儿', '厶', '山', '木'],
    },
    Decomposition {
        kanji: '崱',
        radicals: &['ハ', '⺉', '山', '目', '貝'],
    },
    Decomposition {
        kanji: '崴',
        radicals: &['一', 'ノ', '厂', '女', '山', '戈'],
    },
    Decomposition {
        kanji: '崹',
        radicals: &['｜', '亠', '丷', '冂', '冖', '山', '巾'],
    },
    Decomposition {
        kanji: '崽',
        radicals: &['山', '心', '田'],
    },
    Decomposition {
        kanji: '崿',
        radicals: &['二', '勹', '口', '山'],
    },
    Decomposition {
        kanji: '嵂',
        radicals: &['｜', '二', '山', 'ヨ', '彳', '聿'],
    },
    Decomposition {
        kanji: '嵃',
        radicals: &['丶', 'ノ', '亠', '厂', '山', '彡', '立'],
    },
    Decomposition {
        kanji: '嵆',
        radicals: &['丶', 'ノ', '尢', '山', '木', '尤', '禾'],
    },
    Decomposition {
        kanji: '嵈',
        radicals: &['ノ', '二', '又', '山', '爪'],
    },
    Decomposition {
        kanji: '嵕',
        radicals: &['丶', 'ノ', 'ハ', '凵', '夂', '山'],
    },
    Decomposition {
        kanji: '嵑',
        radicals: &['一', '人', '勹', '山', '日', '曰'],
    },
    Decomposition {
        kanji: '嵙',
        radicals: &['ノ', '山', '斗', '木', '禾'],
    },
    Decomposition {
        kanji: '嵊',
        radicals: &['一', '｜', 'ノ', '匕', '山', '木', '禾'],
    },
    Decomposition {
        kanji: '嵟',
        radicals: &['厂', '山', '隹'],
    },
    Decomposition {
        kanji: '嵠',
        radicals: &['大', '山', '幺', '爪'],
    },
    Decomposition {
        kanji: '嵡',
        radicals: &['ノ', 'ハ', '冫', '厶', '山', '羽'],
    },
    Decomposition {
        kanji: '嵢',
        radicals: &['丶', 'ノ', '𠆢', '口', '山', '日'],
    },
    Decomposition {
        kanji: '嵤',
        radicals: &['冖', '山', '火'],
    },
    Decomposition {
        kanji: '嵪',
        radicals: &['亠', '冂', '口', '山', '高'],
    },
    Decomposition {
        kanji: '嵭',
        radicals: &['亠', '丷', '冖', '山', '方'],
    },
    Decomposition {
        kanji: '嵰',
        radicals: &['｜', '丶', 'ノ', '丷', '山', 'ヨ'],
    },
    Decomposition {
        kanji: '嵹',
        radicals: &['口', '山', '弓', '虫'],
    },
    Decomposition {
        kanji: '嵺',
        radicals: &['𠆢', '冫', '山', '彡', '羽'],
    },
    Decomposition {
        kanji: '嵾',
        radicals: &['人', '厶', '山', '彡'],
    },
    Decomposition {
        kanji: '嵿',
        radicals: &['一', '亅', 'ハ', '山', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '嶁',
        radicals: &['一', '｜', '口', '女', '山', '日'],
    },
    Decomposition {
        kanji: '嶃',
        radicals: &['山', '斤', '車'],
    },
    Decomposition {
        kanji: '嶈',
        radicals: &['丶', '夕', '寸', '山', '爿'],
    },
    Decomposition {
        kanji: '嶊',
        radicals: &['山', '扌', '隹'],
    },
    Decomposition {
        kanji: '嶒',
        radicals: &['｜', 'ハ', '丷', '口', '山', '日'],
    },
    Decomposition {
        kanji: '嶓',
        radicals: &['ノ', '山', '田', '米'],
    },
    Decomposition {
        kanji: '嶔',
        radicals: &['人', '勹', '山', '欠', '金'],
    },
    Decomposition {
        kanji: '嶕',
        radicals: &['山', '⺣', '隹'],
    },
    Decomposition {
        kanji: '嶙',
        radicals: &['夕', '山', '米', '舛'],
    },
    Decomposition {
        kanji: '嶛',
        radicals: &['丶', 'ノ', '大', '小', '山', '日', '曰'],
    },
    Decomposition {
        kanji: '嶟',
        radicals: &['丷', '寸', '山', '酉'],
    },
    Decomposition {
        kanji: '嶠',
        radicals: &['ノ', '冂', '口', '大', '山'],
    },
    Decomposition {
        kanji: '嶧',
        radicals: &['一', '丷', '十', '土', '山', '干', '⺲'],
    },
    Decomposition {
        kanji: '嶫',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '山', '木', '王', '羊'],
    },
    Decomposition {
        kanji: '嶰',
        radicals: &['｜', '刀', '勹', '山', '月', '牛', '角'],
    },
    Decomposition {
        kanji: '嶴',
        radicals: &['ノ', '冂', '大', '山', '米'],
    },
    Decomposition {
        kanji: '嶸',
        radicals: &['冖', '山', '木', '火'],
    },
    Decomposition {
        kanji: '嶹',
        radicals: &['一', '口', '士', '寸', '山', '工'],
    },
    Decomposition {
        kanji: '巃',
        radicals: &['一', '乙', '山', '月', '田', '立', '竜'],
    },
    Decomposition {
        kanji: '巇',
        radicals: &['丷', '匕', '卜', '厂', '口', '山', '戈', '虍', '豆'],
    },
    Decomposition {
        kanji: '巋',
        radicals: &['｜', 'ノ', '冂', '冖', '口', '山', '巾', 'ヨ', '止'],
    },
    Decomposition {
        kanji: '巐',
        radicals: &['ノ', '亠', '冂', '口', '山', '廾', '日'],
    },
    Decomposition {
        kanji: '巎',
        radicals: &['一', 'ハ', '夂', '山', '已', '止', '目', '自', '貝', '頁'],
    },
    Decomposition {
        kanji: '巘',
        radicals: &[
            '一', '丶', '儿', '冂', '匕', '卜', '厂', '口', '尢', '山', '尤', '虍', '鬲',
        ],
    },
    Decomposition {
        kanji: '巙',
        radicals: &['一', 'ハ', '丷', '夂', '山', '已', '止', '目', '自', '首'],
    },
    Decomposition {
        kanji: '巠',
        radicals: &['一', '巛', '工'],
    },
    Decomposition {
        kanji: '巤',
        radicals: &['丶', 'ノ', '乙', '口', '川', '巛'],
    },
    Decomposition {
        kanji: '巩',
        radicals: &['一', '丶', '乙', '几', '工'],
    },
    Decomposition {
        kanji: '巸',
        radicals: &['｜', '匚', '口', '已', '臣'],
    },
    Decomposition {
        kanji: '巹',
        radicals: &['一', '已', '水'],
    },
    Decomposition {
        kanji: '帀',
        radicals: &['一', '｜', '冂', '巾'],
    },
    Decomposition {
        kanji: '帇',
        radicals: &['｜', '冂', '巾', 'ヨ'],
    },
    Decomposition {
        kanji: '帍',
        radicals: &['｜', '丶', '冂', '尸', '巾'],
    },
    Decomposition {
        kanji: '帒',
        radicals: &['｜', '⺅', '冂', '巾', '弋'],
    },
    Decomposition {
        kanji: '帔',
        radicals: &['｜', 'ノ', '冂', '十', '又', '巾', '支'],
    },
    Decomposition {
        kanji: '帕',
        radicals: &['｜', '冂', '巾', '日', '白'],
    },
    Decomposition {
        kanji: '帘',
        radicals: &['｜', '儿', 'ハ', '冂', '宀', '巾'],
    },
    Decomposition {
        kanji: '帟',
        radicals: &['｜', '丶', 'ノ', '亅', '亠', 'ハ', '冂', '巾'],
    },
    Decomposition {
        kanji: '帠',
        radicals: &['｜', '冂', '巾', 'ヨ', '臼'],
    },
    Decomposition {
        kanji: '帮',
        radicals: &['一', '｜', 'ノ', '二', '冂', '巾', '⻏'],
    },
    Decomposition {
        kanji: '帨',
        radicals: &['｜', '儿', 'ハ', '丷', '冂', '口', '巾'],
    },
    Decomposition {
        kanji: '帲',
        radicals: &['一', '｜', 'ノ', '冂', '十', '巾', '干'],
    },
    Decomposition {
        kanji: '帵',
        radicals: &['｜', '冂', '卩', '夕', '宀', '巾'],
    },
    Decomposition {
        kanji: '帾',
        radicals: &['｜', 'ノ', '冂', '土', '巾', '⺹', '日'],
    },
    Decomposition {
        kanji: '幋',
        radicals: &['一', '｜', '丶', '冂', '几', '又', '巾', '殳', '舟'],
    },
    Decomposition {
        kanji: '幐',
        radicals: &['一', '｜', '丷', '冂', '大', '巾', '月'],
    },
    Decomposition {
        kanji: '幉',
        radicals: &['一', '｜', '冂', '巾', '木', '世'],
    },
    Decomposition {
        kanji: '幑',
        radicals: &['｜', 'ノ', '冂', '山', '巾', '彳', '攵'],
    },
    Decomposition {
        kanji: '幖',
        radicals: &['｜', '二', '冂', '小', '巾', '示', '西'],
    },
    Decomposition {
        kanji: '幘',
        radicals: &['一', '｜', '二', 'ハ', '冂', '土', '巾', '目', '貝'],
    },
    Decomposition {
        kanji: '幛',
        radicals: &['｜', '冂', '十', '巾', '日', '立'],
    },
    Decomposition {
        kanji: '幜',
        radicals: &['｜', '亠', '冂', '口', '小', '巾', '日', '曰'],
    },
    Decomposition {
        kanji: '幞',
        radicals: &[
            '一', '｜', '丶', 'ノ', '二', '丷', '冂', '大', '巾', '王', '羊',
        ],
    },
    Decomposition {
        kanji: '幨',
        radicals: &['｜', '儿', 'ハ', '冂', '勹', '厂', '巾', '言'],
    },
    Decomposition {
        kanji: '幪',
        radicals: &['一', '｜', '冂', '冖', '巾', '⺾', '豕'],
    },
    Decomposition {
        kanji: '幫',
        radicals: &['｜', '冂', '土', '寸', '巾', '日', '白'],
    },
    Decomposition {
        kanji: '幬',
        radicals: &['一', '｜', '冂', '口', '士', '寸', '工', '巾'],
    },
    Decomposition {
        kanji: '幭',
        radicals: &['｜', '人', '冂', '巾', '⺾', '戈', '⺲'],
    },
    Decomposition {
        kanji: '幮',
        radicals: &['｜', '丷', '冂', '十', '口', '士', '寸', '巾', '广', '豆'],
    },
    Decomposition {
        kanji: '幰',
        radicals: &['一', '｜', '二', '冂', '宀', '巾', '心', '⺲'],
    },
    Decomposition {
        kanji: '庀',
        radicals: &['匕', '广'],
    },
    Decomposition {
        kanji: '庋',
        radicals: &['十', '又', '广', '支'],
    },
    Decomposition {
        kanji: '庎',
        radicals: &['｜', 'ノ', '𠆢', '广'],
    },
    Decomposition {
        kanji: '庢',
        radicals: &['一', '厶', '土', '广', '至'],
    },
    Decomposition {
        kanji: '庤',
        radicals: &['土', '寸', '广'],
    },
    Decomposition {
        kanji: '庥',
        radicals: &['⺅', '广', '木'],
    },
    Decomposition {
        kanji: '庨',
        radicals: &['ノ', '土', '子', '广', '⺹'],
    },
    Decomposition {
        kanji: '庪',
        radicals: &['十', '又', '广', '扌', '支'],
    },
    Decomposition {
        kanji: '庬',
        radicals: &['丶', '尢', '广', '彡', '尤'],
    },
    Decomposition {
        kanji: '庱',
        radicals: &['ハ', '土', '夂', '广'],
    },
    Decomposition {
        kanji: '庳',
        radicals: &['ノ', '十', '广', '日', '白'],
    },
    Decomposition {
        kanji: '庽',
        radicals: &['｜', '冂', '厶', '广', '田', '虫'],
    },
    Decomposition {
        kanji: '庾',
        radicals: &['人', '广', '臼'],
    },
    Decomposition {
        kanji: '庿',
        radicals: &['广', '⺾', '田'],
    },
    Decomposition {
        kanji: '廆',
        radicals: &['儿', '匕', '厶', '广', '田', '鬼'],
    },
    Decomposition {
        kanji: '廌',
        radicals: &['一', '｜', '勹', '广', '⺣'],
    },
    Decomposition {
        kanji: '廋',
        radicals: &['十', '又', '广', '支', '臼'],
    },
    Decomposition {
        kanji: '廎',
        radicals: &['ハ', '匕', '卜', '广', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '廑',
        radicals: &['二', '十', '口', '广', '廾', '革'],
    },
    Decomposition {
        kanji: '廒',
        radicals: &['土', '广', '攵', '方'],
    },
    Decomposition {
        kanji: '廔',
        radicals: &['一', '｜', '口', '女', '广', '日'],
    },
    Decomposition {
        kanji: '廕',
        radicals: &['一', '丶', '𠆢', '厶', 'ユ', '广', '⻖'],
    },
    Decomposition {
        kanji: '廜',
        radicals: &['ノ', '土', '尸', '广', '⺹', '日', '曰'],
    },
    Decomposition {
        kanji: '廞',
        radicals: &['人', '勹', '广', '欠', '金'],
    },
    Decomposition {
        kanji: '廥',
        radicals: &['一', '｜', '丶', 'ノ', '𠆢', '丷', '口', '广', '日', '曰'],
    },
    Decomposition {
        kanji: '廫',
        radicals: &['人', '冫', '广', '彡', '月', '羽'],
    },
    Decomposition {
        kanji: '异',
        radicals: &['已', '廾'],
    },
    Decomposition {
        kanji: '弆',
        radicals: &['厶', '土', '廾'],
    },
    Decomposition {
        kanji: '弇',
        radicals: &['一', '𠆢', '口', '廾'],
    },
    Decomposition {
        kanji: '弈',
        radicals: &['丶', 'ノ', '亠', '儿', 'ハ', '廾'],
    },
    Decomposition {
        kanji: '弎',
        radicals: &['一', '二', '弋'],
    },
    Decomposition {
        kanji: '弙',
        radicals: &['亅', '二', '弓'],
    },
    Decomposition {
        kanji: '弜',
        radicals: &['弓'],
    },
    Decomposition {
        kanji: '弝',
        radicals: &['｜', '已', '弓'],
    },
    Decomposition {
        kanji: '弡',
        radicals: &['匚', '口', '弓'],
    },
    Decomposition {
        kanji: '弢',
        radicals: &['又', '屮', '山', '弓', '支'],
    },
    Decomposition {
        kanji: '弣',
        radicals: &['⺅', '寸', '弓'],
    },
    Decomposition {
        kanji: '弤',
        radicals: &['丶', '弓', '氏'],
    },
    Decomposition {
        kanji: '弨',
        radicals: &['刀', '口', '弓'],
    },
    Decomposition {
        kanji: '弫',
        radicals: &['匚', '弓', '臣'],
    },
    Decomposition {
        kanji: '弬',
        radicals: &['匚', '弓', '臣'],
    },
    Decomposition {
        kanji: '弮',
        radicals: &['一', '丷', '大', '弓'],
    },
    Decomposition {
        kanji: '弰',
        radicals: &['⺌', '弓', '月'],
    },
    Decomposition {
        kanji: '弴',
        radicals: &['亠', '口', '子', '弓'],
    },
    Decomposition {
        kanji: '弶',
        radicals: &['亠', '口', '小', '弓'],
    },
    Decomposition {
        kanji: '弻',
        radicals: &['一', '人', '弓', '西'],
    },
    Decomposition {
        kanji: '弽',
        radicals: &['一', '｜', '弓', '木', '世'],
    },
    Decomposition {
        kanji: '弿',
        radicals: &['一', '｜', '二', 'ハ', '宀', '弓'],
    },
    Decomposition {
        kanji: '彀',
        radicals: &['一', '冖', '几', '又', '士', '弓', '殳'],
    },
    Decomposition {
        kanji: '彄',
        radicals: &['匚', '口', '弓'],
    },
    Decomposition {
        kanji: '彅',
        radicals: &['一', '丷', '刀', '⺉', '弓', '月'],
    },
    Decomposition {
        kanji: '彇',
        radicals: &['｜', '弓', 'ヨ', '爿', '片'],
    },
    Decomposition {
        kanji: '彍',
        radicals: &['一', '｜', '二', 'ハ', '宀', '弓', '田'],
    },
    Decomposition {
        kanji: '彐',
        radicals: &['ヨ'],
    },
    Decomposition {
        kanji: '彔',
        radicals: &['ヨ', '彑', '水'],
    },
    Decomposition {
        kanji: '彘',
        radicals: &['一', 'ノ', '匕', '大', 'ヨ', '彑', '矢'],
    },
    Decomposition {
        kanji: '彛',
        radicals: &['ハ', '刀', '廾', 'ヨ', '米'],
    },
    Decomposition {
        kanji: '彠',
        radicals: &['又', '口', '寸', '工', 'ヨ', '⺾', '隹'],
    },
    Decomposition {
        kanji: '彣',
        radicals: &['彡', '文'],
    },
    Decomposition {
        kanji: '彤',
        radicals: &['一', '丶', '冂', '彡', '舟'],
    },
    Decomposition {
        kanji: '彧',
        radicals: &['一', '口', '弋', '彡'],
    },
    Decomposition {
        kanji: '彯',
        radicals: &['二', '小', '彡', '示', '西'],
    },
    Decomposition {
        kanji: '彲',
        radicals: &['一', '丶', '冂', '匕', '广', '彡', '比', '鹿'],
    },
    Decomposition {
        kanji: '彴',
        radicals: &['丶', '勹', '彳'],
    },
    Decomposition {
        kanji: '彵',
        radicals: &['｜', '乙', '匕', '彳', '也'],
    },
    Decomposition {
        kanji: '彸',
        radicals: &['ハ', '厶', '彳'],
    },
    Decomposition {
        kanji: '彺',
        radicals: &['彳', '王'],
    },
    Decomposition {
        kanji: '彽',
        radicals: &['一', '丶', '彳', '氏'],
    },
    Decomposition {
        kanji: '彾',
        radicals: &['一', '｜', '丶', '亅', '𠆢', 'マ', '彳'],
    },
    Decomposition {
        kanji: '徉',
        radicals: &['丷', '彳', '王', '羊'],
    },
    Decomposition {
        kanji: '徍',
        radicals: &['土', '彳'],
    },
    Decomposition {
        kanji: '徏',
        radicals: &['ノ', '亅', '小', '彳', '止'],
    },
    Decomposition {
        kanji: '徖',
        radicals: &['二', '宀', '小', '彳', '示'],
    },
    Decomposition {
        kanji: '徜',
        radicals: &['冂', '口', '小', '⺌', '彳'],
    },
    Decomposition {
        kanji: '徝',
        radicals: &['一', '十', '彳', '目'],
    },
    Decomposition {
        kanji: '徢',
        radicals: &['土', 'ヨ', '彳', '走'],
    },
    Decomposition {
        kanji: '徧',
        radicals: &['一', '｜', '丶', '亅', '冂', '尸', '彳', '戸', '冊', '廾'],
    },
    Decomposition {
        kanji: '徫',
        radicals: &['口', '彳', '韋'],
    },
    Decomposition {
        kanji: '徤',
        radicals: &['｜', '二', '廴', 'ヨ', '彳', '聿'],
    },
    Decomposition {
        kanji: '徬',
        radicals: &['亠', '冖', '彳', '方', '立'],
    },
    Decomposition {
        kanji: '徯',
        radicals: &['大', '幺', '彳', '爪'],
    },
    Decomposition {
        kanji: '徰',
        radicals: &['一', '彳', '止'],
    },
    Decomposition {
        kanji: '徱',
        radicals: &['二', '小', '彳', '示', '西'],
    },
    Decomposition {
        kanji: '徸',
        radicals: &['彳', '立', '里'],
    },
    Decomposition {
        kanji: '忄',
        radicals: &['⺖'],
    },
    Decomposition {
        kanji: '忇',
        radicals: &['力', '⺖'],
    },
    Decomposition {
        kanji: '忈',
        radicals: &['二', '心'],
    },
    Decomposition {
        kanji: '忉',
        radicals: &['刀', '⺖'],
    },
    Decomposition {
        kanji: '忋',
        radicals: &['已', '⺖'],
    },
    Decomposition {
        kanji: '忐',
        radicals: &['一', '卜', '心'],
    },
    Decomposition {
        kanji: '忑',
        radicals: &['一', '卜', '心'],
    },
    Decomposition {
        kanji: '忒',
        radicals: &['弋', '心'],
    },
    Decomposition {
        kanji: '忓',
        radicals: &['一', '十', '干', '⺖'],
    },
    Decomposition {
        kanji: '忔',
        radicals: &['一', 'ノ', '乙', '⺖'],
    },
    Decomposition {
        kanji: '忞',
        radicals: &['心', '文'],
    },
    Decomposition {
        kanji: '忡',
        radicals: &['｜', '口', '⺖'],
    },
    Decomposition {
        kanji: '忢',
        radicals: &['一', '二', '心', '五'],
    },
    Decomposition {
        kanji: '忨',
        radicals: &['二', '儿', '⺖', '元'],
    },
    Decomposition {
        kanji: '忩',
        radicals: &['ハ', '厶', '心'],
    },
    Decomposition {
        kanji: '忪',
        radicals: &['ハ', '厶', '⺖'],
    },
    Decomposition {
        kanji: '忬',
        radicals: &['一', '亅', 'マ', '⺖', '矛'],
    },
    Decomposition {
        kanji: '忭',
        radicals: &['亠', '卜', '⺖'],
    },
    Decomposition {
        kanji: '忮',
        radicals: &['十', '又', '⺖', '支'],
    },
    Decomposition {
        kanji: '忯',
        radicals: &['⺖', '氏'],
    },
    Decomposition {
        kanji: '忲',
        radicals: &['丶', '大', '⺖'],
    },
    Decomposition {
        kanji: '忳',
        radicals: &['一', 'ノ', '乙', '凵', '⺖', '屯'],
    },
    Decomposition {
        kanji: '忶',
        radicals: &['二', '厶', '⺖'],
    },
    Decomposition {
        kanji: '忺',
        radicals: &['人', '勹', '⺖', '欠'],
    },
    Decomposition {
        kanji: '忼',
        radicals: &['亠', '几', '⺖'],
    },
    Decomposition {
        kanji: '怇',
        radicals: &['匚', '口', '⺖'],
    },
    Decomposition {
        kanji: '怊',
        radicals: &['刀', '口', '⺖'],
    },
    Decomposition {
        kanji: '怍',
        radicals: &['一', '｜', 'ノ', '二', '⺖'],
    },
    Decomposition {
        kanji: '怓',
        radicals: &['又', '女', '⺖'],
    },
    Decomposition {
        kanji: '怔',
        radicals: &['一', '⺖', '止'],
    },
    Decomposition {
        kanji: '怗',
        radicals: &['卜', '口', '⺖'],
    },
    Decomposition {
        kanji: '怘',
        radicals: &['十', '口', '心'],
    },
    Decomposition {
        kanji: '怚',
        radicals: &['一', '⺖', '目'],
    },
    Decomposition {
        kanji: '怟',
        radicals: &['丶', '⺖', '氏'],
    },
    Decomposition {
        kanji: '怤',
        radicals: &['⺅', '寸', '心'],
    },
    Decomposition {
        kanji: '怭',
        radicals: &['ノ', '⺖', '心'],
    },
    Decomposition {
        kanji: '怳',
        radicals: &['儿', '口', '⺖'],
    },
    Decomposition {
        kanji: '怵',
        radicals: &['一', '｜', '丶', 'ノ', '乙', '⺖', '木'],
    },
    Decomposition {
        kanji: '恀',
        radicals: &['夕', '⺖'],
    },
    Decomposition {
        kanji: '恇',
        radicals: &['匚', '⺖', '王'],
    },
    Decomposition {
        kanji: '恈',
        radicals: &['厶', '⺖', '牛'],
    },
    Decomposition {
        kanji: '恉',
        radicals: &['匕', '⺖', '日'],
    },
    Decomposition {
        kanji: '恌',
        radicals: &['丶', 'ノ', '儿', '冫', '⺖'],
    },
    Decomposition {
        kanji: '恑',
        radicals: &['勹', '卩', '厂', '⺖'],
    },
    Decomposition {
        kanji: '恔',
        radicals: &['亠', '⺖', '父'],
    },
    Decomposition {
        kanji: '恖',
        radicals: &['丶', 'ノ', '口', '心'],
    },
    Decomposition {
        kanji: '恗',
        radicals: &['二', '勹', '大', '⺖'],
    },
    Decomposition {
        kanji: '恝',
        radicals: &['一', '｜', '二', '刀', '彡', '心'],
    },
    Decomposition {
        kanji: '恡',
        radicals: &['一', '丶', 'ノ', '厶', '⺖'],
    },
    Decomposition {
        kanji: '恧',
        radicals: &['心', '而'],
    },
    Decomposition {
        kanji: '恱',
        radicals: &['儿', 'ハ', '厶', '⺖'],
    },
    Decomposition {
        kanji: '恾',
        radicals: &['亠', '⺖', '⺾', '亡'],
    },
    Decomposition {
        kanji: '恿',
        radicals: &['マ', '心', '用'],
    },
    Decomposition {
        kanji: '悂',
        radicals: &['匕', '土', '⺖', '比'],
    },
    Decomposition {
        kanji: '悆',
        radicals: &['二', '𠆢', '小', '心', '示'],
    },
    Decomposition {
        kanji: '悈',
        radicals: &['廾', '⺖', '戈'],
    },
    Decomposition {
        kanji: '悊',
        radicals: &['扌', '心', '斤'],
    },
    Decomposition {
        kanji: '悎',
        radicals: &['ノ', '口', '土', '⺖'],
    },
    Decomposition {
        kanji: '悑',
        radicals: &['一', '｜', '丶', '二', '冂', '十', '⺖', '月', '用'],
    },
    Decomposition {
        kanji: '悓',
        radicals: &['儿', '⺖', '目', '見'],
    },
    Decomposition {
        kanji: '悕',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '巾', '⺖'],
    },
    Decomposition {
        kanji: '悘',
        radicals: &['一', 'ノ', '匚', '大', '心', '矢'],
    },
    Decomposition {
        kanji: '悝',
        radicals: &['⺖', '里'],
    },
    Decomposition {
        kanji: '悞',
        radicals: &['口', '大', '⺖', '无'],
    },
    Decomposition {
        kanji: '悢',
        radicals: &['丶', '⺖', '艮'],
    },
    Decomposition {
        kanji: '悤',
        radicals: &['ノ', '口', '夂', '心'],
    },
    Decomposition {
        kanji: '悥',
        radicals: &['二', '亠', '口', '心', '言'],
    },
    Decomposition {
        kanji: '您',
        radicals: &['⺅', '冖', '勹', '小', '心'],
    },
    Decomposition {
        kanji: '悰',
        radicals: &['二', '宀', '小', '⺖', '示'],
    },
    Decomposition {
        kanji: '悱',
        radicals: &['⺖', '非'],
    },
    Decomposition {
        kanji: '悷',
        radicals: &['一', '丶', '大', '尸', '⺖', '戸', '犬'],
    },
    Decomposition {
        kanji: '悻',
        radicals: &['一', '丷', '十', '土', '干', '⺖'],
    },
    Decomposition {
        kanji: '悾',
        radicals: &['儿', 'ハ', '宀', '工', '⺖', '穴'],
    },
    Decomposition {
        kanji: '惂',
        radicals: &['勹', '⺖', '臼'],
    },
    Decomposition {
        kanji: '惄',
        radicals: &['又', '土', '小', '心'],
    },
    Decomposition {
        kanji: '惈',
        radicals: &['⺖', '日', '木', '田'],
    },
    Decomposition {
        kanji: '惉',
        radicals: &['卜', '口', '⺡', '心'],
    },
    Decomposition {
        kanji: '惊',
        radicals: &['亠', '口', '小', '⺖'],
    },
    Decomposition {
        kanji: '惋',
        radicals: &['卩', '夕', '宀', '⺖'],
    },
    Decomposition {
        kanji: '惎',
        radicals: &['一', '｜', '二', '心'],
    },
    Decomposition {
        kanji: '惏',
        radicals: &['⺖', '木'],
    },
    Decomposition {
        kanji: '惔',
        radicals: &['⺖', '火'],
    },
    Decomposition {
        kanji: '惕',
        radicals: &['ノ', '勹', '⺖', '日', '勿'],
    },
    Decomposition {
        kanji: '惙',
        radicals: &['又', '⺖'],
    },
    Decomposition {
        kanji: '惛',
        radicals: &['⺖', '日', '氏'],
    },
    Decomposition {
        kanji: '惝',
        radicals: &['冂', '口', '小', '⺌', '⺖'],
    },
    Decomposition {
        kanji: '惞',
        radicals: &['人', '勹', '⺖', '斤', '欠'],
    },
    Decomposition {
        kanji: '惢',
        radicals: &['心'],
    },
    Decomposition {
        kanji: '惥',
        radicals: &['人', '大', '心', '臼'],
    },
    Decomposition {
        kanji: '惲',
        radicals: &['冖', '⺖', '車'],
    },
    Decomposition {
        kanji: '惵',
        radicals: &['一', '｜', '⺖', '木', '世'],
    },
    Decomposition {
        kanji: '惸',
        radicals: &['勹', '子', '⺖', '日'],
    },
    Decomposition {
        kanji: '惼',
        radicals: &['一', '｜', '亅', '冂', '尸', '⺖', '戸', '冊', '廾'],
    },
    Decomposition {
        kanji: '惽',
        radicals: &['一', '乙', '尸', '⺖', '日', '氏'],
    },
    Decomposition {
        kanji: '愂',
        radicals: &['冖', '力', '十', '子', '心'],
    },
    Decomposition {
        kanji: '愇',
        radicals: &['口', '⺖', '韋'],
    },
    Decomposition {
        kanji: '愊',
        radicals: &['一', '口', '⺖', '田'],
    },
    Decomposition {
        kanji: '愌',
        radicals: &['ハ', '冂', '勹', '大', '⺖'],
    },
    Decomposition {
        kanji: '愐',
        radicals: &['⺖', '面'],
    },
    Decomposition {
        kanji: '愑',
        radicals: &['｜', '力', 'マ', '⺖', '月', '用'],
    },
    Decomposition {
        kanji: '愒',
        radicals: &['人', '勹', '⺖', '日'],
    },
    Decomposition {
        kanji: '愓',
        radicals: &['一', 'ノ', '勹', '⺖', '日', '勿'],
    },
    Decomposition {
        kanji: '愔',
        radicals: &['⺖', '日', '立'],
    },
    Decomposition {
        kanji: '愖',
        radicals: &['一', '｜', '儿', 'ハ', '匚', '⺖', '甘', '目'],
    },
    Decomposition {
        kanji: '愗',
        radicals: &['マ', '心', '攵', '矛'],
    },
    Decomposition {
        kanji: '愙',
        radicals: &['口', '夂', '宀', '心'],
    },
    Decomposition {
        kanji: '愜',
        radicals: &['人', '匚', '大', '⺖'],
    },
    Decomposition {
        kanji: '愞',
        radicals: &['大', '⺖', '而'],
    },
    Decomposition {
        kanji: '愢',
        radicals: &['⺖', '心', '田'],
    },
    Decomposition {
        kanji: '愪',
        radicals: &['ハ', '口', '⺖', '目', '貝'],
    },
    Decomposition {
        kanji: '愫',
        radicals: &['一', '｜', '二', '亠', '土', '小', '幺', '⺖', '糸'],
    },
    Decomposition {
        kanji: '愰',
        radicals: &['一', '儿', '⺌', '⺖', '日'],
    },
    Decomposition {
        kanji: '愱',
        radicals: &['一', 'ノ', '大', '⺖', '⽧', '矢'],
    },
    Decomposition {
        kanji: '愵',
        radicals: &['丶', '冫', '弓', '⺖'],
    },
    Decomposition {
        kanji: '愶',
        radicals: &['力', '⺖', '月'],
    },
    Decomposition {
        kanji: '愷',
        radicals: &['丷', '口', '山', '⺖', '豆'],
    },
    Decomposition {
        kanji: '愹',
        radicals: &['𠆢', 'ハ', '口', '宀', '⺖', '谷'],
    },
    Decomposition {
        kanji: '慁',
        radicals: &['口', '心', '豕'],
    },
    Decomposition {
        kanji: '慅',
        radicals: &['丶', '又', '⺖', '虫'],
    },
    Decomposition {
        kanji: '慆',
        radicals: &['⺖', '爪', '臼'],
    },
    Decomposition {
        kanji: '慉',
        radicals: &['亠', '幺', '⺖', '玄', '田'],
    },
    Decomposition {
        kanji: '慞',
        radicals: &['十', '⺖', '日', '立'],
    },
    Decomposition {
        kanji: '慠',
        radicals: &['土', '士', '⺖', '攵', '方'],
    },
    Decomposition {
        kanji: '慬',
        radicals: &['二', '十', '口', '廾', '⺖', '革'],
    },
    Decomposition {
        kanji: '慲',
        radicals: &['一', '｜', '人', '冂', '巾', '⺖'],
    },
    Decomposition {
        kanji: '慸',
        radicals: &['一', '｜', 'ノ', '乙', '冂', '冖', '凵', '巾', '廾', '心'],
    },
    Decomposition {
        kanji: '慻',
        radicals: &['一', 'ハ', '丷', '大', '⺖', '目'],
    },
    Decomposition {
        kanji: '慼',
        radicals: &['一', 'ノ', '卜', '厂', '小', '心', '戈'],
    },
    Decomposition {
        kanji: '慿',
        radicals: &['冫', '廾', '心', '馬'],
    },
    Decomposition {
        kanji: '憀',
        radicals: &['𠆢', '冫', '彡', '⺖', '羽'],
    },
    Decomposition {
        kanji: '憁',
        radicals: &['ノ', '口', '夂', '⺖', '心'],
    },
    Decomposition {
        kanji: '憃',
        radicals: &['一', '二', '大', '心', '臼'],
    },
    Decomposition {
        kanji: '憄',
        radicals: &['十', '彳', '心', '目'],
    },
    Decomposition {
        kanji: '憋',
        radicals: &['｜', 'ハ', '丷', '冂', '巾', '心', '攵'],
    },
    Decomposition {
        kanji: '憍',
        radicals: &['ノ', '冂', '口', '大', '⺖'],
    },
    Decomposition {
        kanji: '憒',
        radicals: &['一', '｜', 'ハ', '口', '⺖', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '憓',
        radicals: &['一', '｜', '厶', '⺖', '心', '日', '虫'],
    },
    Decomposition {
        kanji: '憗',
        radicals: &['人', '心', '攵', '木'],
    },
    Decomposition {
        kanji: '憘',
        radicals: &['丷', '十', '口', '士', '⺖', '豆'],
    },
    Decomposition {
        kanji: '憜',
        radicals: &['一', 'ノ', '工', '⺖', '⻖', '月'],
    },
    Decomposition {
        kanji: '憝',
        radicals: &['亠', '口', '子', '心', '攵'],
    },
    Decomposition {
        kanji: '憟',
        radicals: &['⺖', '米', '西'],
    },
    Decomposition {
        kanji: '憠',
        radicals: &['一', '人', '丷', '勹', '厂', '屮', '心', '欠'],
    },
    Decomposition {
        kanji: '憥',
        radicals: &['冖', '力', '心', '火'],
    },
    Decomposition {
        kanji: '憨',
        radicals: &['一', '｜', 'ユ', '心', '攵', '耳'],
    },
    Decomposition {
        kanji: '憪',
        radicals: &['⺖', '月', '門'],
    },
    Decomposition {
        kanji: '憭',
        radicals: &['丶', 'ノ', '大', '小', '⺖', '日'],
    },
    Decomposition {
        kanji: '憸',
        radicals: &['一', '人', '𠆢', '口', '⺖'],
    },
    Decomposition {
        kanji: '憹',
        radicals: &['｜', '厂', '⺖', '日', '衣', '辰'],
    },
    Decomposition {
        kanji: '憼',
        radicals: &['勹', '口', '⺾', '心', '攵'],
    },
    Decomposition {
        kanji: '懀',
        radicals: &['一', '｜', '𠆢', '丷', '口', '⺖', '日'],
    },
    Decomposition {
        kanji: '懁',
        radicals: &['一', '口', '⺖', '⺲', '衣'],
    },
    Decomposition {
        kanji: '懂',
        radicals: &['一', 'ノ', '⺖', '⺾', '車'],
    },
    Decomposition {
        kanji: '懎',
        radicals: &['人', '口', '囗', '土', '⺖'],
    },
    Decomposition {
        kanji: '懏',
        radicals: &['｜', '亅', '⺖', '隹'],
    },
    Decomposition {
        kanji: '懕',
        radicals: &['丶', '厂', '大', '心', '日', '月', '犬'],
    },
    Decomposition {
        kanji: '懜',
        radicals: &['一', '｜', '冖', '卜', '夕', '⺖', '⺾', '⺲'],
    },
    Decomposition {
        kanji: '懝',
        radicals: &['一', 'ノ', '匕', 'マ', '大', '⺖', '疋', '矢'],
    },
    Decomposition {
        kanji: '懞',
        radicals: &['一', '冖', '⺖', '⺾', '豕'],
    },
    Decomposition {
        kanji: '懟',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '寸', '心', '王', '羊'],
    },
    Decomposition {
        kanji: '懡',
        radicals: &['ノ', '厶', '广', '⺖', '木', '麻'],
    },
    Decomposition {
        kanji: '懢',
        radicals: &['一', '丶', 'ノ', '二', '匚', '⺖', '皿', '臣'],
    },
    Decomposition {
        kanji: '懧',
        radicals: &['一', '亅', '宀', '⺖', '心', '皿'],
    },
    Decomposition {
        kanji: '懩',
        radicals: &['一', '丶', '二', '丷', '大', '⺖', '艮'],
    },
    Decomposition {
        kanji: '懥',
        radicals: &['冖', '十', '厶', '⺖', '止', '田', '疋'],
    },
    Decomposition {
        kanji: '懬',
        radicals: &['ハ', '广', '心', '田', '黄'],
    },
    Decomposition {
        kanji: '懭',
        radicals: &['ハ', '广', '⺖', '田', '黄'],
    },
    Decomposition {
        kanji: '懯',
        radicals: &['一', '｜', '丶', '二', '冂', '心', '攵', '方', '用', '田'],
    },
    Decomposition {
        kanji: '戁',
        radicals: &['十', '口', '大', '廾', '心', '隹', '革'],
    },
    Decomposition {
        kanji: '戃',
        radicals: &['｜', '二', '丷', '冖', '口', '⺌', '⺖', '⺣', '里', '黒'],
    },
    Decomposition {
        kanji: '戄',
        radicals: &['又', '⺖', '目', '隹'],
    },
    Decomposition {
        kanji: '戇',
        radicals: &['ハ', '十', '夂', '工', '心', '日', '目', '立', '貝'],
    },
    Decomposition {
        kanji: '戓',
        radicals: &['口', '戈'],
    },
    Decomposition {
        kanji: '戕',
        radicals: &['戈', '爿'],
    },
    Decomposition {
        kanji: '戜',
        radicals: &['口', '戈', '王'],
    },
    Decomposition {
        kanji: '戠',
        radicals: &['亠', '丷', '戈', '日', '曰', '立'],
    },
    Decomposition {
        kanji: '戢',
        radicals: &['口', '戈', '耳'],
    },
    Decomposition {
        kanji: '戣',
        radicals: &['一', '大', '戈', '癶'],
    },
    Decomposition {
        kanji: '戧',
        radicals: &['丶', 'ノ', '𠆢', '口', '戈', '日'],
    },
    Decomposition {
        kanji: '戩',
        radicals: &['二', '厶', '戈', '日'],
    },
    Decomposition {
        kanji: '戫',
        radicals: &['一', 'ノ', '口', '戈', '月'],
    },
    Decomposition {
        kanji: '戹',
        radicals: &['一', '丶', '乙', '尸', '戸'],
    },
    Decomposition {
        kanji: '戽',
        radicals: &['一', '丶', '尸', '戸', '斗'],
    },
    Decomposition {
        kanji: '扂',
        radicals: &['丶', '卜', '口', '尸'],
    },
    Decomposition {
        kanji: '扃',
        radicals: &['一', '丶', '冂', '口', '尸', '戸'],
    },
    Decomposition {
        kanji: '扄',
        radicals: &['丶', 'ノ', '冂', '口', '尸'],
    },
    Decomposition {
        kanji: '扆',
        radicals: &['一', '丶', '亠', '尸', '戸', '衣'],
    },
    Decomposition {
        kanji: '扌',
        radicals: &['扌'],
    },
    Decomposition {
        kanji: '扐',
        radicals: &['力', '扌'],
    },
    Decomposition {
        kanji: '扑',
        radicals: &['卜', '扌'],
    },
    Decomposition {
        kanji: '扒',
        radicals: &['ハ', '扌'],
    },
    Decomposition {
        kanji: '扔',
        radicals: &['乃', '扌'],
    },
    Decomposition {
        kanji: '扖',
        radicals: &['入', '扌'],
    },
    Decomposition {
        kanji: '扚',
        radicals: &['一', '丶', '勹', '扌'],
    },
    Decomposition {
        kanji: '扜',
        radicals: &['亅', '二', '扌'],
    },
    Decomposition {
        kanji: '扤',
        radicals: &['一', '儿', '扌'],
    },
    Decomposition {
        kanji: '扭',
        radicals: &['｜', 'ヨ', '扌'],
    },
    Decomposition {
        kanji: '扯',
        radicals: &['扌', '止'],
    },
    Decomposition {
        kanji: '扳',
        radicals: &['ノ', '厂', '又', '扌'],
    },
    Decomposition {
        kanji: '扺',
        radicals: &['扌', '氏'],
    },
    Decomposition {
        kanji: '扽',
        radicals: &['ノ', '乙', '凵', '扌', '屯'],
    },
    Decomposition {
        kanji: '抍',
        radicals: &['ノ', '廾', '扌'],
    },
    Decomposition {
        kanji: '抎',
        radicals: &['二', '厶', '扌'],
    },
    Decomposition {
        kanji: '抏',
        radicals: &['二', '儿', '扌', '元'],
    },
    Decomposition {
        kanji: '抐',
        radicals: &['人', '入', '冂', '扌'],
    },
    Decomposition {
        kanji: '抦',
        radicals: &['一', '人', '冂', '扌'],
    },
    Decomposition {
        kanji: '抨',
        radicals: &['一', 'ハ', '丷', '十', '干', '扌'],
    },
    Decomposition {
        kanji: '抳',
        radicals: &['匕', '尸', '扌'],
    },
    Decomposition {
        kanji: '抶',
        radicals: &['一', 'ノ', '大', '扌'],
    },
    Decomposition {
        kanji: '抷',
        radicals: &['一', '｜', '丶', 'ノ', '扌'],
    },
    Decomposition {
        kanji: '抺',
        radicals: &['一', '扌', '木'],
    },
    Decomposition {
        kanji: '抾',
        radicals: &['厶', '土', '扌'],
    },
    Decomposition {
        kanji: '抿',
        radicals: &['一', '乙', '尸', '扌', '氏'],
    },
    Decomposition {
        kanji: '拄',
        radicals: &['丶', '亠', '土', '扌', '王'],
    },
    Decomposition {
        kanji: '拎',
        radicals: &['丶', '𠆢', 'マ', '扌'],
    },
    Decomposition {
        kanji: '拕',
        radicals: &['匕', '宀', '扌'],
    },
    Decomposition {
        kanji: '拖',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '扌', '也'],
    },
    Decomposition {
        kanji: '拚',
        radicals: &['厶', '廾', '扌'],
    },
    Decomposition {
        kanji: '拪',
        radicals: &['扌', '西'],
    },
    Decomposition {
        kanji: '拲',
        radicals: &['｜', 'ノ', '二', '手'],
    },
    Decomposition {
        kanji: '拴',
        radicals: &['𠆢', '扌', '王'],
    },
    Decomposition {
        kanji: '拼',
        radicals: &['一', '丷', '廾', '扌'],
    },
    Decomposition {
        kanji: '拽',
        radicals: &['ノ', '乙', '扌', '日'],
    },
    Decomposition {
        kanji: '挃',
        radicals: &['一', '厶', '土', '扌', '至'],
    },
    Decomposition {
        kanji: '挄',
        radicals: &['一', '儿', '⺌', '扌'],
    },
    Decomposition {
        kanji: '挊',
        radicals: &['一', '卜', '扌'],
    },
    Decomposition {
        kanji: '挋',
        radicals: &['匚', '扌', '臣'],
    },
    Decomposition {
        kanji: '挍',
        radicals: &['亠', '扌', '父'],
    },
    Decomposition {
        kanji: '挐',
        radicals: &['口', '女', '手'],
    },
    Decomposition {
        kanji: '挓',
        radicals: &['一', 'ノ', '乙', '宀', '扌'],
    },
    Decomposition {
        kanji: '挖',
        radicals: &['乙', '儿', 'ハ', '宀', '扌'],
    },
    Decomposition {
        kanji: '挘',
        radicals: &['ノ', '力', '小', '扌'],
    },
    Decomposition {
        kanji: '挩',
        radicals: &['儿', 'ハ', '口', '扌'],
    },
    Decomposition {
        kanji: '挪',
        radicals: &['一', '刀', 'ヨ', '扌', '⻏'],
    },
    Decomposition {
        kanji: '挭',
        radicals: &['一', '丶', 'ノ', '口', '扌', '日'],
    },
    Decomposition {
        kanji: '挵',
        radicals: &['廾', '扌', '王'],
    },
    Decomposition {
        kanji: '挶',
        radicals: &['亅', '口', '尸', '扌'],
    },
    Decomposition {
        kanji: '挹',
        radicals: &['乙', '口', '已', '扌', '⻏', '巴'],
    },
    Decomposition {
        kanji: '挼',
        radicals: &['女', '扌', '爪'],
    },
    Decomposition {
        kanji: '捁',
        radicals: &['｜', 'ノ', '二', '口', '土', '扌'],
    },
    Decomposition {
        kanji: '捂',
        radicals: &['一', '二', '口', '扌', '五'],
    },
    Decomposition {
        kanji: '捃',
        radicals: &['ノ', '口', 'ヨ', '扌'],
    },
    Decomposition {
        kanji: '捄',
        radicals: &['一', '丶', '扌', '水'],
    },
    Decomposition {
        kanji: '捆',
        radicals: &['口', '囗', '扌', '木'],
    },
    Decomposition {
        kanji: '捊',
        radicals: &['子', '扌', '爪'],
    },
    Decomposition {
        kanji: '捋',
        radicals: &['寸', '扌', '爪'],
    },
    Decomposition {
        kanji: '捎',
        radicals: &['小', '⺌', '扌', '月'],
    },
    Decomposition {
        kanji: '捒',
        radicals: &['口', '扌', '木'],
    },
    Decomposition {
        kanji: '捓',
        radicals: &['扌', '⻏', '牙'],
    },
    Decomposition {
        kanji: '捔',
        radicals: &['勹', '扌', '用'],
    },
    Decomposition {
        kanji: '捘',
        radicals: &['ハ', '厶', '夂', '扌'],
    },
    Decomposition {
        kanji: '捛',
        radicals: &['口', '扌'],
    },
    Decomposition {
        kanji: '捥',
        radicals: &['卩', '夕', '宀', '扌'],
    },
    Decomposition {
        kanji: '捦',
        radicals: &['扌', '金'],
    },
    Decomposition {
        kanji: '捬',
        radicals: &['⺅', '寸', '广', '扌'],
    },
    Decomposition {
        kanji: '捭',
        radicals: &['一', 'ノ', '十', '口', '扌', '日'],
    },
    Decomposition {
        kanji: '捱',
        radicals: &['厂', '土', '扌'],
    },
    Decomposition {
        kanji: '捴',
        radicals: &['ハ', '厶', '扌', '心'],
    },
    Decomposition {
        kanji: '捵',
        radicals: &['｜', 'ハ', '扌', '日'],
    },
    Decomposition {
        kanji: '捸',
        radicals: &['ヨ', '扌', '水', '隶'],
    },
    Decomposition {
        kanji: '捼',
        radicals: &['ノ', '女', '扌', '木', '禾'],
    },
    Decomposition {
        kanji: '捽',
        radicals: &['亠', '人', '十', '扌'],
    },
    Decomposition {
        kanji: '捿',
        radicals: &['一', '｜', '女', 'ヨ', '扌'],
    },
    Decomposition {
        kanji: '掂',
        radicals: &['卜', '口', '广', '扌'],
    },
    Decomposition {
        kanji: '掄',
        radicals: &['一', '｜', '亅', '𠆢', '冂', '扌', '冊', '廾'],
    },
    Decomposition {
        kanji: '掇',
        radicals: &['又', '扌'],
    },
    Decomposition {
        kanji: '掊',
        radicals: &['口', '扌', '立'],
    },
    Decomposition {
        kanji: '掐',
        radicals: &['勹', '扌', '臼'],
    },
    Decomposition {
        kanji: '掔',
        radicals: &['匚', '又', '手', '臣'],
    },
    Decomposition {
        kanji: '掕',
        radicals: &['ハ', '土', '夂', '扌'],
    },
    Decomposition {
        kanji: '掙',
        radicals: &['亅', 'ヨ', '扌', '爪'],
    },
    Decomposition {
        kanji: '掚',
        radicals: &['一', '｜', '入', '冂', '扌'],
    },
    Decomposition {
        kanji: '掞',
        radicals: &['扌', '火'],
    },
    Decomposition {
        kanji: '掤',
        radicals: &['扌', '月'],
    },
    Decomposition {
        kanji: '掦',
        radicals: &['ノ', '勹', '扌', '日', '勿'],
    },
    Decomposition {
        kanji: '掭',
        radicals: &['一', '丶', '亅', '大', '扌', '⺣'],
    },
    Decomposition {
        kanji: '掮',
        radicals: &['一', '丶', '尸', '扌', '戸', '月'],
    },
    Decomposition {
        kanji: '掯',
        radicals: &['扌', '月', '止'],
    },
    Decomposition {
        kanji: '掽',
        radicals: &['｜', '丶', 'ノ', '二', '丷', '扌'],
    },
    Decomposition {
        kanji: '揁',
        radicals: &['ハ', '卜', '扌', '目', '貝'],
    },
    Decomposition {
        kanji: '揅',
        radicals: &['一', 'ノ', '口', '廾', '手'],
    },
    Decomposition {
        kanji: '揈',
        radicals: &['勹', '扌', '言'],
    },
    Decomposition {
        kanji: '揎',
        radicals: &['一', '二', '宀', '扌', '日', '曰'],
    },
    Decomposition {
        kanji: '揑',
        radicals: &['工', '扌', '臼'],
    },
    Decomposition {
        kanji: '揓',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '扌', '也', '方'],
    },
    Decomposition {
        kanji: '揔',
        radicals: &['丶', 'ノ', '勹', '扌', '心', '勿'],
    },
    Decomposition {
        kanji: '揕',
        radicals: &['儿', 'ハ', '匚', '扌', '甘'],
    },
    Decomposition {
        kanji: '揜',
        radicals: &['一', '𠆢', '口', '廾', '扌'],
    },
    Decomposition {
        kanji: '揠',
        radicals: &['匚', '女', '扌', '日'],
    },
    Decomposition {
        kanji: '揥',
        radicals: &['｜', '亠', '丷', '冂', '冖', '巾', '扌', '立'],
    },
    Decomposition {
        kanji: '揪',
        radicals: &['ノ', '扌', '木', '火', '禾'],
    },
    Decomposition {
        kanji: '揬',
        radicals: &['丶', '儿', 'ハ', '大', '宀', '扌', '犬'],
    },
    Decomposition {
        kanji: '揲',
        radicals: &['一', '｜', '扌', '木', '世'],
    },
    Decomposition {
        kanji: '揳',
        radicals: &['一', '｜', '二', '刀', '大', '扌'],
    },
    Decomposition {
        kanji: '揵',
        radicals: &['｜', '二', '廴', 'ヨ', '扌', '聿'],
    },
    Decomposition {
        kanji: '揸',
        radicals: &['一', '扌', '日', '木', '目'],
    },
    Decomposition {
        kanji: '揹',
        radicals: &['一', '｜', '匕', '扌', '月'],
    },
    Decomposition {
        kanji: '搉',
        radicals: &['冖', '扌', '隹'],
    },
    Decomposition {
        kanji: '搊',
        radicals: &['勹', '屮', '扌'],
    },
    Decomposition {
        kanji: '搐',
        radicals: &['亠', '幺', '扌', '玄', '田'],
    },
    Decomposition {
        kanji: '搒',
        radicals: &['亠', '丷', '冖', '扌', '方', '立'],
    },
    Decomposition {
        kanji: '搔',
        radicals: &['丶', '又', '扌', '虫'],
    },
    Decomposition {
        kanji: '搘',
        radicals: &['ノ', '匕', '土', '扌', '⺹', '日'],
    },
    Decomposition {
        kanji: '搞',
        radicals: &['亠', '冂', '口', '扌', '高'],
    },
    Decomposition {
        kanji: '搠',
        radicals: &['一', '丷', '屮', '扌', '月'],
    },
    Decomposition {
        kanji: '搢',
        radicals: &['｜', '丶', 'ノ', '二', '厶', '扌', '日'],
    },
    Decomposition {
        kanji: '搤',
        radicals: &['一', '丶', 'ノ', 'ハ', '丷', '扌', '皿'],
    },
    Decomposition {
        kanji: '搥',
        radicals: &['｜', 'ノ', '⻌', '口', '扌'],
    },
    Decomposition {
        kanji: '搩',
        radicals: &['夕', '扌', '木', '舛'],
    },
    Decomposition {
        kanji: '搪',
        radicals: &['｜', '口', '广', 'ヨ', '扌'],
    },
    Decomposition {
        kanji: '搯',
        radicals: &['扌', '爪', '臼'],
    },
    Decomposition {
        kanji: '搰',
        radicals: &['冂', '冖', '扌', '月', '骨'],
    },
    Decomposition {
        kanji: '搵',
        radicals: &['人', '口', '扌', '皿'],
    },
    Decomposition {
        kanji: '搽',
        radicals: &['一', '𠆢', '小', '扌', '⺾', '木'],
    },
    Decomposition {
        kanji: '搿',
        radicals: &['一', '𠆢', '口', '手'],
    },
    Decomposition {
        kanji: '摋',
        radicals: &['一', '丶', 'ノ', '几', '又', '小', '扌', '殳'],
    },
    Decomposition {
        kanji: '摏',
        radicals: &['一', '大', '扌', '臼'],
    },
    Decomposition {
        kanji: '摑',
        radicals: &['口', '囗', '扌', '戈'],
    },
    Decomposition {
        kanji: '摒',
        radicals: &['一', '｜', 'ノ', '丷', '尸', '廾', '扌'],
    },
    Decomposition {
        kanji: '摓',
        radicals: &['一', '｜', '二', '⻌', '夂', '扌'],
    },
    Decomposition {
        kanji: '摔',
        radicals: &['丶', 'ノ', '亠', '冫', '十', '幺', '扌', '玄'],
    },
    Decomposition {
        kanji: '摚',
        radicals: &['冖', '口', '土', '⺌', '扌'],
    },
    Decomposition {
        kanji: '摛',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '厶', '扌', '⽱'],
    },
    Decomposition {
        kanji: '摜',
        radicals: &['一', 'ハ', '扌', '田', '目', '貝'],
    },
    Decomposition {
        kanji: '摝',
        radicals: &['匕', '广', '扌', '比', '鹿'],
    },
    Decomposition {
        kanji: '摟',
        radicals: &['一', '｜', '口', '女', '扌', '日'],
    },
    Decomposition {
        kanji: '摠',
        radicals: &['ノ', '口', '夂', '扌', '心'],
    },
    Decomposition {
        kanji: '摡',
        radicals: &['厶', '扌', '无', '日'],
    },
    Decomposition {
        kanji: '摣',
        radicals: &['一', '匕', '卜', '厂', '扌', '目', '虍'],
    },
    Decomposition {
        kanji: '摭',
        radicals: &['一', '｜', '广', '扌', '⺣'],
    },
    Decomposition {
        kanji: '摳',
        radicals: &['匚', '口', '扌'],
    },
    Decomposition {
        kanji: '摴',
        radicals: &['一', '｜', '二', '冖', '勹', '扌', '雨'],
    },
    Decomposition {
        kanji: '摻',
        radicals: &['𠆢', '厶', '彡', '扌'],
    },
    Decomposition {
        kanji: '摽',
        radicals: &['二', '小', '扌', '示', '西'],
    },
    Decomposition {
        kanji: '撅',
        radicals: &['一', '人', '丷', '勹', '厂', '屮', '扌', '欠'],
    },
    Decomposition {
        kanji: '撇',
        radicals: &['｜', '丶', 'ノ', 'ハ', '丷', '冂', '扌', '攵'],
    },
    Decomposition {
        kanji: '撏',
        radicals: &['口', '寸', '工', 'ヨ', '扌'],
    },
    Decomposition {
        kanji: '撐',
        radicals: &['冖', '口', '⺌', '扌', '牙'],
    },
    Decomposition {
        kanji: '撑',
        radicals: &['冖', '口', '⺌', '扌', '手'],
    },
    Decomposition {
        kanji: '撘',
        radicals: &['一', '𠆢', '口', '扌', '竹'],
    },
    Decomposition {
        kanji: '撙',
        radicals: &['ハ', '丷', '寸', '扌', '酉'],
    },
    Decomposition {
        kanji: '撛',
        radicals: &['夕', '扌', '米', '舛'],
    },
    Decomposition {
        kanji: '撝',
        radicals: &['一', '亅', '尸', '扌', '戸', '⺣', '爪'],
    },
    Decomposition {
        kanji: '撟',
        radicals: &['ノ', '冂', '口', '大', '扌'],
    },
    Decomposition {
        kanji: '撡',
        radicals: &['丶', '亅', '𠆢', '厶', '扌', '⺣'],
    },
    Decomposition {
        kanji: '撣',
        radicals: &['十', '口', '扌', '日', '田'],
    },
    Decomposition {
        kanji: '撦',
        radicals: &['ノ', '土', '大', '扌', '⺹', '日', '曰'],
    },
    Decomposition {
        kanji: '撨',
        radicals: &['扌', '⺣', '隹'],
    },
    Decomposition {
        kanji: '撬',
        radicals: &['ノ', '乙', '二', '扌'],
    },
    Decomposition {
        kanji: '撳',
        radicals: &['人', '勹', '扌', '欠', '金'],
    },
    Decomposition {
        kanji: '撽',
        radicals: &['扌', '攵', '方', '日', '白'],
    },
    Decomposition {
        kanji: '撾',
        radicals: &['冂', '⻌', '口', '囗', '扌'],
    },
    Decomposition {
        kanji: '撿',
        radicals: &['一', '人', '𠆢', '口', '扌'],
    },
    Decomposition {
        kanji: '擄',
        radicals: &['一', '力', '匕', '卜', '厂', '扌', '田', '虍'],
    },
    Decomposition {
        kanji: '擉',
        radicals: &['勹', '扌', '⺲', '虫'],
    },
    Decomposition {
        kanji: '擊',
        radicals: &['几', '凵', '又', '手', '殳', '車'],
    },
    Decomposition {
        kanji: '擋',
        radicals: &['冖', '口', '⺌', '扌', '田'],
    },
    Decomposition {
        kanji: '擌',
        radicals: &['人', '大', '扌', '竹'],
    },
    Decomposition {
        kanji: '擎',
        radicals: &['勹', '口', '⺾', '手', '攵'],
    },
    Decomposition {
        kanji: '擐',
        radicals: &['一', '口', '扌', '⺲', '衣'],
    },
    Decomposition {
        kanji: '擑',
        radicals: &['口', '扌', '戈', '耳'],
    },
    Decomposition {
        kanji: '擕',
        radicals: &['｜', '亅', '扌', '隹'],
    },
    Decomposition {
        kanji: '擗',
        radicals: &['十', '口', '尸', '扌', '立', '辛'],
    },
    Decomposition {
        kanji: '擤',
        radicals: &['廾', '扌', '田', '目', '自', '鼻'],
    },
    Decomposition {
        kanji: '擥',
        radicals: &['一', '丶', 'ノ', '匚', '手', '⺲', '臣'],
    },
    Decomposition {
        kanji: '擩',
        radicals: &['冖', '扌', '而', '雨'],
    },
    Decomposition {
        kanji: '擪',
        radicals: &['丶', '厂', '大', '手', '日', '月', '犬'],
    },
    Decomposition {
        kanji: '擭',
        radicals: &['又', '扌', '⺾', '隹'],
    },
    Decomposition {
        kanji: '擰',
        radicals: &['一', '亅', '宀', '扌', '心', '皿'],
    },
    Decomposition {
        kanji: '擵',
        radicals: &['广', '扌', '手', '木', '麻'],
    },
    Decomposition {
        kanji: '擷',
        radicals: &['ハ', '口', '士', '扌', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '擻',
        radicals: &['一', '｜', '口', '女', '扌', '攵', '日', '田'],
    },
    Decomposition {
        kanji: '擿',
        radicals: &['亠', '丷', '冂', '十', '⻌', '口', '扌', '立', '啇'],
    },
    Decomposition {
        kanji: '攁',
        radicals: &['一', '丶', '二', '丷', '大', '扌', '艮'],
    },
    Decomposition {
        kanji: '攄',
        radicals: &['匕', '卜', '厂', '扌', '心', '田', '虍'],
    },
    Decomposition {
        kanji: '攈',
        radicals: &['ノ', '匕', '广', '扌', '木', '比', '禾', '鹿'],
    },
    Decomposition {
        kanji: '攉',
        radicals: &['一', '｜', '丶', '⺅', '冖', '扌', '隹', '雨'],
    },
    Decomposition {
        kanji: '攊',
        radicals: &['ノ', '厂', '扌', '木', '止', '禾'],
    },
    Decomposition {
        kanji: '攏',
        radicals: &['一', '｜', '乙', '扌', '月', '立', '竜'],
    },
    Decomposition {
        kanji: '攓',
        radicals: &['一', '｜', '二', 'ハ', '口', '宀', '扌', '足'],
    },
    Decomposition {
        kanji: '攔',
        radicals: &['丷', '口', '扌', '木', '門'],
    },
    Decomposition {
        kanji: '攖',
        radicals: &['ハ', '女', '扌', '目'],
    },
    Decomposition {
        kanji: '攙',
        radicals: &['一', '｜', '丶', '儿', '勹', '匕', '口', '扌', '比', '免'],
    },
    Decomposition {
        kanji: '攛',
        radicals: &['儿', 'ハ', '宀', '扌', '臼', '鼠'],
    },
    Decomposition {
        kanji: '攞',
        radicals: &['丶', '小', '幺', '扌', '⺲', '糸', '隹'],
    },
    Decomposition {
        kanji: '攟',
        radicals: &['ノ', '匕', '口', '广', '扌', '木', '比', '禾', '鹿'],
    },
    Decomposition {
        kanji: '攢',
        radicals: &['ノ', '儿', 'ハ', '土', '扌', '目', '貝'],
    },
    Decomposition {
        kanji: '攦',
        radicals: &['一', '丶', '冂', '匕', '广', '扌', '比', '鹿'],
    },
    Decomposition {
        kanji: '攩',
        radicals: &['丷', '冖', '口', '⺌', '扌', '⺣', '里', '黒'],
    },
    Decomposition {
        kanji: '攮',
        radicals: &['一', '｜', '二', '冖', '十', '口', '扌', '衣'],
    },
    Decomposition {
        kanji: '攱',
        radicals: &['十', '又', '支', '立'],
    },
    Decomposition {
        kanji: '攺',
        radicals: &['尸', '攵'],
    },
    Decomposition {
        kanji: '攼',
        radicals: &['一', '十', '干', '攵'],
    },
    Decomposition {
        kanji: '攽',
        radicals: &['ハ', '刀', '攵'],
    },
    Decomposition {
        kanji: '敃',
        radicals: &['一', '乙', '尸', '攵', '氏'],
    },
    Decomposition {
        kanji: '敇',
        radicals: &['冂', '攵', '木'],
    },
    Decomposition {
        kanji: '敉',
        radicals: &['攵', '米'],
    },
    Decomposition {
        kanji: '敐',
        radicals: &['亠', '厂', '攵', '衣', '辰'],
    },
    Decomposition {
        kanji: '敒',
        radicals: &['｜', '⺅', '攵', '日', '田'],
    },
    Decomposition {
        kanji: '敔',
        radicals: &['一', '二', '口', '攵', '五'],
    },
    Decomposition {
        kanji: '敟',
        radicals: &['一', '｜', '攵', '皿'],
    },
    Decomposition {
        kanji: '敠',
        radicals: &['卜', '又'],
    },
    Decomposition {
        kanji: '敧',
        radicals: &['亅', '卜', '又', '口', '大'],
    },
    Decomposition {
        kanji: '敫',
        radicals: &['攵', '方', '日', '白'],
    },
    Decomposition {
        kanji: '敺',
        radicals: &['匚', '卜', '又', '口'],
    },
    Decomposition {
        kanji: '敽',
        radicals: &['ノ', '冂', '又', '口', '大'],
    },
    Decomposition {
        kanji: '斁',
        radicals: &['一', '丷', '十', '土', '干', '攵', '⺲'],
    },
    Decomposition {
        kanji: '斅',
        radicals: &['一', '｜', '冖', '卜', '又', '子', 'ヨ', '爻'],
    },
    Decomposition {
        kanji: '斊',
        radicals: &['文', '耳'],
    },
    Decomposition {
        kanji: '斒',
        radicals: &['一', '｜', '丶', 'ノ', '亅', '冂', '尸', '戸', '冊', '廾'],
    },
    Decomposition {
        kanji: '斕',
        radicals: &['丶', 'ノ', '丷', '口', '木', '門'],
    },
    Decomposition {
        kanji: '斘',
        radicals: &['夕', '斗'],
    },
    Decomposition {
        kanji: '斝',
        radicals: &['冖', '口', '斗'],
    },
    Decomposition {
        kanji: '斠',
        radicals: &['一', '｜', '二', '斗', '月', '用'],
    },
    Decomposition {
        kanji: '斣',
        radicals: &['勹', '斗', '⺲', '虫'],
    },
    Decomposition {
        kanji: '斦',
        radicals: &['斤'],
    },
    Decomposition {
        kanji: '斮',
        radicals: &['｜', '二', '斤', '日', '曰'],
    },
    Decomposition {
        kanji: '斲',
        radicals: &['一', '｜', 'ノ', '口', '斤', '爿'],
    },
    Decomposition {
        kanji: '斳',
        radicals: &['二', '十', '口', '廾', '斤', '革'],
    },
    Decomposition {
        kanji: '斴',
        radicals: &['夕', '斤', '米', '舛'],
    },
    Decomposition {
        kanji: '斿',
        radicals: &['一', 'ノ', '亅', '方'],
    },
    Decomposition {
        kanji: '旂',
        radicals: &['一', 'ノ', '斤', '方'],
    },
    Decomposition {
        kanji: '旈',
        radicals: &['｜', 'ノ', '乙', '亠', '厶', '川', '方'],
    },
    Decomposition {
        kanji: '旉',
        radicals: &['一', '｜', '丶', '十', '方', '日'],
    },
    Decomposition {
        kanji: '旎',
        radicals: &['一', 'ノ', '匕', '尸', '方'],
    },
    Decomposition {
        kanji: '旐',
        radicals: &['一', '丶', 'ノ', '儿', '冫', '方'],
    },
    Decomposition {
        kanji: '旔',
        radicals: &['｜', '二', '廴', 'ヨ', '方', '聿'],
    },
    Decomposition {
        kanji: '旖',
        radicals: &['一', 'ノ', '亅', '口', '大', '方'],
    },
    Decomposition {
        kanji: '旘',
        radicals: &['亠', '丷', '戈', '方', '日', '立'],
    },
    Decomposition {
        kanji: '旟',
        radicals: &['一', '｜', 'ノ', 'ハ', 'ヨ', '方'],
    },
    Decomposition {
        kanji: '旰',
        radicals: &['一', '十', '干', '日'],
    },
    Decomposition {
        kanji: '旲',
        radicals: &['大', '日'],
    },
    Decomposition {
        kanji: '旴',
        radicals: &['一', '亅', '二', '十', '干', '日'],
    },
    Decomposition {
        kanji: '旵',
        radicals: &['山', '日', '曰'],
    },
    Decomposition {
        kanji: '旹',
        radicals: &['｜', '亠', '山', '日'],
    },
    Decomposition {
        kanji: '旾',
        radicals: &['ノ', '乙', '凵', '日', '曰', '屯'],
    },
    Decomposition {
        kanji: '旿',
        radicals: &['一', 'ノ', '十', '干', '日', '曰'],
    },
    Decomposition {
        kanji: '昀',
        radicals: &['一', '丶', '二', '勹', '日'],
    },
    Decomposition {
        kanji: '昄',
        radicals: &['ノ', '厂', '又', '日'],
    },
    Decomposition {
        kanji: '昈',
        radicals: &['一', '丶', '尸', '戸', '日'],
    },
    Decomposition {
        kanji: '昉',
        radicals: &['方', '日'],
    },
    Decomposition {
        kanji: '昍',
        radicals: &['日', '曰'],
    },
    Decomposition {
        kanji: '昑',
        radicals: &['丶', '𠆢', '日'],
    },
    Decomposition {
        kanji: '昒',
        radicals: &['ノ', '勹', '日', '曰', '勿'],
    },
    Decomposition {
        kanji: '昕',
        radicals: &['斤', '日'],
    },
    Decomposition {
        kanji: '昖',
        radicals: &['ハ', '厶', '日', '曰'],
    },
    Decomposition {
        kanji: '昝',
        radicals: &['卜', '夂', '日', '曰'],
    },
    Decomposition {
        kanji: '昞',
        radicals: &['一', '人', '冂', '日'],
    },
    Decomposition {
        kanji: '昡',
        radicals: &['亠', '幺', '日', '玄'],
    },
    Decomposition {
        kanji: '昢',
        radicals: &['｜', '凵', '山', '日'],
    },
    Decomposition {
        kanji: '昣',
        radicals: &['𠆢', '彡', '日', '曰'],
    },
    Decomposition {
        kanji: '昤',
        radicals: &['一', '｜', '丶', '亅', '𠆢', 'マ', '日'],
    },
    Decomposition {
        kanji: '昦',
        radicals: &['｜', 'ノ', '大', '日', '曰'],
    },
    Decomposition {
        kanji: '昩',
        radicals: &['一', '日', '曰', '木'],
    },
    Decomposition {
        kanji: '昪',
        radicals: &['厶', '廾', '日'],
    },
    Decomposition {
        kanji: '昫',
        radicals: &['勹', '口', '日'],
    },
    Decomposition {
        kanji: '昬',
        radicals: &['一', '尸', '日', '氏'],
    },
    Decomposition {
        kanji: '昮',
        radicals: &['力', '工', '日'],
    },
    Decomposition {
        kanji: '昰',
        radicals: &['一', '日', '止'],
    },
    Decomposition {
        kanji: '昱',
        radicals: &['日', '立'],
    },
    Decomposition {
        kanji: '昳',
        radicals: &['一', 'ノ', '大', '日', '矢'],
    },
    Decomposition {
        kanji: '昹',
        radicals: &['丶', '日', '曰', '水'],
    },
    Decomposition {
        kanji: '昷',
        radicals: &['日', '曰', '皿'],
    },
    Decomposition {
        kanji: '晀',
        radicals: &['丶', 'ノ', '儿', '冫', '日', '曰'],
    },
    Decomposition {
        kanji: '晅',
        radicals: &['一', '日'],
    },
    Decomposition {
        kanji: '晆',
        radicals: &['土', '日', '曰'],
    },
    Decomposition {
        kanji: '晊',
        radicals: &['一', '厶', '土', '日', '曰', '至'],
    },
    Decomposition {
        kanji: '晌',
        radicals: &['ノ', '冂', '口', '日'],
    },
    Decomposition {
        kanji: '晑',
        radicals: &['ノ', '冂', '口', '日'],
    },
    Decomposition {
        kanji: '晎',
        radicals: &['｜', '二', 'ハ', '日'],
    },
    Decomposition {
        kanji: '晗',
        radicals: &['一', '丶', '𠆢', '口', '日'],
    },
    Decomposition {
        kanji: '晘',
        radicals: &['一', '十', '干', '日', '曰'],
    },
    Decomposition {
        kanji: '晙',
        radicals: &['儿', 'ハ', '厶', '夂'],
    },
    Decomposition {
        kanji: '晛',
        radicals: &['儿', '日', '目', '見'],
    },
    Decomposition {
        kanji: '晜',
        radicals: &['｜', 'ノ', '丷', '弓', '日'],
    },
    Decomposition {
        kanji: '晠',
        radicals: &['ノ', '亅', '厂', '戈', '日'],
    },
    Decomposition {
        kanji: '晡',
        radicals: &['一', '｜', '丶', '十', '日', '月', '用'],
    },
    Decomposition {
        kanji: '曻',
        radicals: &['夕', '日', '舛'],
    },
    Decomposition {
        kanji: '晪',
        radicals: &['一', '｜', 'ハ', '日'],
    },
    Decomposition {
        kanji: '晫',
        radicals: &['十', '卜', '日'],
    },
    Decomposition {
        kanji: '晬',
        radicals: &['亠', '人', '十', '日'],
    },
    Decomposition {
        kanji: '晾',
        radicals: &['亠', '口', '小', '日'],
    },
    Decomposition {
        kanji: '晳',
        radicals: &['斤', '日', '木'],
    },
    Decomposition {
        kanji: '晵',
        radicals: &['丶', '尸', '戸', '攵', '日', '曰'],
    },
    Decomposition {
        kanji: '晿',
        radicals: &['日', '曰'],
    },
    Decomposition {
        kanji: '晷',
        radicals: &['人', '卜', '口', '夂', '日'],
    },
    Decomposition {
        kanji: '晸',
        radicals: &['一', '攵', '日', '止'],
    },
    Decomposition {
        kanji: '晹',
        radicals: &['ノ', '勹', '日', '曰', '勿'],
    },
    Decomposition {
        kanji: '晻',
        radicals: &['乙', '大', '日', '奄'],
    },
    Decomposition {
        kanji: '暀',
        radicals: &['丶', '亠', '土', '彳', '日', '王'],
    },
    Decomposition {
        kanji: '晼',
        radicals: &['卩', '夕', '宀', '日', '曰'],
    },
    Decomposition {
        kanji: '暋',
        radicals: &['一', '尸', '攵', '日', '氏'],
    },
    Decomposition {
        kanji: '暌',
        radicals: &['一', '大', '日', '癶'],
    },
    Decomposition {
        kanji: '暍',
        radicals: &['人', '勹', '日'],
    },
    Decomposition {
        kanji: '暐',
        radicals: &['口', '日', '韋'],
    },
    Decomposition {
        kanji: '暒',
        radicals: &['日', '生'],
    },
    Decomposition {
        kanji: '暙',
        radicals: &['一', '二', '大', '日'],
    },
    Decomposition {
        kanji: '暚',
        radicals: &['凵', '山', '日', '曰', '爪', '缶'],
    },
    Decomposition {
        kanji: '暛',
        radicals: &['一', 'ノ', '二', '丷', '工', '日', '曰'],
    },
    Decomposition {
        kanji: '暜',
        radicals: &['日', '曰', '立'],
    },
    Decomposition {
        kanji: '暟',
        radicals: &['丷', '口', '山', '日', '曰', '豆'],
    },
    Decomposition {
        kanji: '暠',
        radicals: &['亠', '冂', '口', '日', '高'],
    },
    Decomposition {
        kanji: '暤',
        radicals: &['十', '大', '日', '白'],
    },
    Decomposition {
        kanji: '暭',
        radicals: &['丶', 'ノ', '二', '冫', '十', '日', '白'],
    },
    Decomposition {
        kanji: '暱',
        radicals: &['匚', '口', '⺾', '日', '石'],
    },
    Decomposition {
        kanji: '暲',
        radicals: &['十', '日', '立'],
    },
    Decomposition {
        kanji: '暵',
        radicals: &['十', '口', '大', '廾', '日', '革'],
    },
    Decomposition {
        kanji: '暻',
        radicals: &['亠', '口', '小', '日'],
    },
    Decomposition {
        kanji: '暿',
        radicals: &['一', '丷', '十', '口', '士', '日', '豆'],
    },
    Decomposition {
        kanji: '曀',
        radicals: &['丷', '冖', '口', '士', '日', '豆'],
    },
    Decomposition {
        kanji: '曂',
        radicals: &['｜', '二', 'ハ', '日', '曰', '田'],
    },
    Decomposition {
        kanji: '曃',
        radicals: &['⻌', 'ヨ', '日', '曰', '水', '隶'],
    },
    Decomposition {
        kanji: '曈',
        radicals: &['日', '立', '里'],
    },
    Decomposition {
        kanji: '曌',
        radicals: &['ハ', '宀', '工', '日', '曰', '月'],
    },
    Decomposition {
        kanji: '曎',
        radicals: &['一', '丷', '十', '土', '干', '日', '曰', '⺲'],
    },
    Decomposition {
        kanji: '曏',
        radicals: &['丶', '匕', '厶', '幺', '⻏', '日', '白'],
    },
    Decomposition {
        kanji: '曔',
        radicals: &['勹', '口', '⺾', '攵', '日', '曰'],
    },
    Decomposition {
        kanji: '曛',
        radicals: &['一', 'ノ', '丷', '日', '⺣', '車'],
    },
    Decomposition {
        kanji: '曟',
        radicals: &['亠', '厂', '日', '衣', '辰'],
    },
    Decomposition {
        kanji: '曨',
        radicals: &['一', '｜', '乙', '日', '月', '田', '立', '竜'],
    },
    Decomposition {
        kanji: '曫',
        radicals: &['丶', 'ノ', '小', '幺', '日', '曰', '糸', '言'],
    },
    Decomposition {
        kanji: '曬',
        radicals: &['一', '丶', '冂', '匕', '广', '日', '比', '鹿'],
    },
    Decomposition {
        kanji: '曮',
        radicals: &['厂', 'ユ', '口', '攵', '日', '曰', '耳'],
    },
    Decomposition {
        kanji: '曺',
        radicals: &['十', '日'],
    },
    Decomposition {
        kanji: '朅',
        radicals: &['人', '勹', '厶', '土', '日'],
    },
    Decomposition {
        kanji: '朇',
        radicals: &['｜', 'ノ', '𠆢', '丷', '十', '口', '日', '曰', '白'],
    },
    Decomposition {
        kanji: '朎',
        radicals: &['一', '｜', '丶', '亅', '𠆢', '厶', '月'],
    },
    Decomposition {
        kanji: '朓',
        radicals: &['丶', 'ノ', '儿', '冫', '月'],
    },
    Decomposition {
        kanji: '朙',
        radicals: &['儿', 'ハ', '冂', '口', '囗', '月'],
    },
    Decomposition {
        kanji: '朜',
        radicals: &['亠', '口', '子', '月'],
    },
    Decomposition {
        kanji: '朠',
        radicals: &['大', '⺾', '月'],
    },
    Decomposition {
        kanji: '朢',
        radicals: &['匚', '月', '王', '臣'],
    },
    Decomposition {
        kanji: '朳',
        radicals: &['ハ', '木'],
    },
    Decomposition {
        kanji: '朾',
        radicals: &['一', '亅', '木'],
    },
    Decomposition {
        kanji: '杅',
        radicals: &['亅', '二', '木'],
    },
    Decomposition {
        kanji: '杇',
        radicals: &['二', '勹', '木'],
    },
    Decomposition {
        kanji: '杈',
        radicals: &['丶', '又', '木'],
    },
    Decomposition {
        kanji: '杌',
        radicals: &['一', '儿', '木'],
    },
    Decomposition {
        kanji: '杔',
        radicals: &['一', 'ノ', '乙', '木'],
    },
    Decomposition {
        kanji: '杕',
        radicals: &['大', '木'],
    },
    Decomposition {
        kanji: '杝',
        radicals: &['｜', '乙', '匕', '也', '木'],
    },
    Decomposition {
        kanji: '杦',
        radicals: &['夂', '木'],
    },
    Decomposition {
        kanji: '杬',
        radicals: &['二', '儿', '木', '元'],
    },
    Decomposition {
        kanji: '杮',
        radicals: &['一', '｜', '冂', '巾', '木'],
    },
    Decomposition {
        kanji: '杴',
        radicals: &['人', '勹', '木', '欠'],
    },
    Decomposition {
        kanji: '杶',
        radicals: &['ノ', '乙', '凵', '木', '屯'],
    },
    Decomposition {
        kanji: '杻',
        radicals: &['｜', 'ヨ', '木'],
    },
    Decomposition {
        kanji: '极',
        radicals: &['丶', '乃', '及', '木'],
    },
    Decomposition {
        kanji: '构',
        radicals: &['勹', '厶', '木'],
    },
    Decomposition {
        kanji: '枎',
        radicals: &['一', '大', '木'],
    },
    Decomposition {
        kanji: '枏',
        radicals: &['二', '冂', '月', '木'],
    },
    Decomposition {
        kanji: '枑',
        radicals: &['一', 'ヨ', '彑', '木'],
    },
    Decomposition {
        kanji: '枓',
        radicals: &['斗', '木'],
    },
    Decomposition {
        kanji: '枖',
        radicals: &['ノ', '大', '木'],
    },
    Decomposition {
        kanji: '枘',
        radicals: &['人', '入', '冂', '木'],
    },
    Decomposition {
        kanji: '枙',
        radicals: &['卩', '厂', '木'],
    },
    Decomposition {
        kanji: '枛',
        radicals: &['木', '爪'],
    },
    Decomposition {
        kanji: '枰',
        radicals: &['一', '丶', 'ノ', 'ハ', '丷', '十', '干', '木'],
    },
    Decomposition {
        kanji: '枱',
        radicals: &['厶', '口', '木'],
    },
    Decomposition {
        kanji: '枲',
        radicals: &['厶', '口', '木'],
    },
    Decomposition {
        kanji: '枵',
        radicals: &['一', '勹', '口', '木'],
    },
    Decomposition {
        kanji: '枻',
        radicals: &['一', '｜', '木', '世'],
    },
    Decomposition {
        kanji: '枼',
        radicals: &['一', '｜', '木', '世'],
    },
    Decomposition {
        kanji: '枽',
        radicals: &['一', '凵', '十', '木'],
    },
    Decomposition {
        kanji: '柹',
        radicals: &['木', '牙'],
    },
    Decomposition {
        kanji: '柀',
        radicals: &['｜', 'ノ', '十', '厂', '又', '支', '木'],
    },
    Decomposition {
        kanji: '柂',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '也', '木'],
    },
    Decomposition {
        kanji: '柃',
        radicals: &['一', '丶', '亅', '𠆢', 'マ', '木'],
    },
    Decomposition {
        kanji: '柅',
        radicals: &['匕', '尸', '木'],
    },
    Decomposition {
        kanji: '柈',
        radicals: &['一', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '柉',
        radicals: &['丶', 'ノ', '乙', '木'],
    },
    Decomposition {
        kanji: '柒',
        radicals: &['一', '乙', '匕', '⺡', '木'],
    },
    Decomposition {
        kanji: '柗',
        radicals: &['ハ', '口', '木'],
    },
    Decomposition {
        kanji: '柙',
        radicals: &['｜', '日', '木', '田'],
    },
    Decomposition {
        kanji: '柜',
        radicals: &['匚', '口', '木'],
    },
    Decomposition {
        kanji: '柡',
        radicals: &['二', '木', '水'],
    },
    Decomposition {
        kanji: '柦',
        radicals: &['一', '日', '曰', '木'],
    },
    Decomposition {
        kanji: '柰',
        radicals: &['二', '小', '木', '示'],
    },
    Decomposition {
        kanji: '柲',
        radicals: &['ノ', '心', '木'],
    },
    Decomposition {
        kanji: '柶',
        radicals: &['儿', '口', '木'],
    },
    Decomposition {
        kanji: '柷',
        radicals: &['儿', '口', '木'],
    },
    Decomposition {
        kanji: '桒',
        radicals: &['十', '⺾', '木'],
    },
    Decomposition {
        kanji: '栔',
        radicals: &['一', '｜', '二', '刀', '木'],
    },
    Decomposition {
        kanji: '栙',
        radicals: &['｜', '二', '夂', '木'],
    },
    Decomposition {
        kanji: '栝',
        radicals: &['口', '木', '舌'],
    },
    Decomposition {
        kanji: '栟',
        radicals: &['一', '丷', '廾', '木'],
    },
    Decomposition {
        kanji: '栨',
        radicals: &['一', '人', '冫', '勹', '木', '欠'],
    },
    Decomposition {
        kanji: '栧',
        radicals: &['ノ', '乙', '日', '木', '田'],
    },
    Decomposition {
        kanji: '栬',
        radicals: &['乙', '勹', '已', '木', '巴', '色'],
    },
    Decomposition {
        kanji: '栭',
        radicals: &['木', '而'],
    },
    Decomposition {
        kanji: '栯',
        radicals: &['一', 'ノ', '月', '木'],
    },
    Decomposition {
        kanji: '栰',
        radicals: &['⺅', '戈', '木'],
    },
    Decomposition {
        kanji: '栱',
        radicals: &['｜', '二', 'ハ', '木'],
    },
    Decomposition {
        kanji: '栳',
        radicals: &['ノ', '匕', '土', '⺹', '木'],
    },
    Decomposition {
        kanji: '栻',
        radicals: &['工', '弋', '木'],
    },
    Decomposition {
        kanji: '栿',
        radicals: &['丶', '⺅', '大', '木', '犬'],
    },
    Decomposition {
        kanji: '桄',
        radicals: &['一', '儿', '⺌', '木'],
    },
    Decomposition {
        kanji: '桅',
        radicals: &['勹', '卩', '厂', '木'],
    },
    Decomposition {
        kanji: '桊',
        radicals: &['一', '丶', 'ノ', '丷', '大', '木'],
    },
    Decomposition {
        kanji: '桌',
        radicals: &['卜', '日', '木'],
    },
    Decomposition {
        kanji: '桕',
        radicals: &['木', '臼'],
    },
    Decomposition {
        kanji: '桗',
        radicals: &['乃', '木'],
    },
    Decomposition {
        kanji: '桘',
        radicals: &['｜', 'ノ', '口', '木'],
    },
    Decomposition {
        kanji: '桛',
        radicals: &['一', '卜', '木'],
    },
    Decomposition {
        kanji: '桫',
        radicals: &['ノ', '小', '⺡', '木'],
    },
    Decomposition {
        kanji: '桮',
        radicals: &['一', '｜', '丶', 'ノ', '口', '木'],
    },
    Decomposition {
        kanji: '桯',
        radicals: &['口', '木', '王'],
    },
    Decomposition {
        kanji: '桰',
        radicals: &['口', '木', '氏'],
    },
    Decomposition {
        kanji: '桱',
        radicals: &['一', '巛', '工', '木'],
    },
    Decomposition {
        kanji: '桲',
        radicals: &['冖', '十', '子', '木'],
    },
    Decomposition {
        kanji: '桵',
        radicals: &['女', '木', '爪'],
    },
    Decomposition {
        kanji: '桹',
        radicals: &['丶', '木', '艮'],
    },
    Decomposition {
        kanji: '桺',
        radicals: &['一', '｜', '廾', '木'],
    },
    Decomposition {
        kanji: '桻',
        radicals: &['一', '｜', '二', '夂', '木'],
    },
    Decomposition {
        kanji: '桼',
        radicals: &['𠆢', '木', '水'],
    },
    Decomposition {
        kanji: '梂',
        radicals: &['一', '丶', '木', '水'],
    },
    Decomposition {
        kanji: '梄',
        radicals: &['木', '酉'],
    },
    Decomposition {
        kanji: '梆',
        radicals: &['一', 'ノ', '⻏', '木'],
    },
    Decomposition {
        kanji: '梈',
        radicals: &['一', '亅', '亠', '口', '木'],
    },
    Decomposition {
        kanji: '梖',
        radicals: &['ハ', '木', '目', '貝'],
    },
    Decomposition {
        kanji: '梘',
        radicals: &['儿', '木', '目', '見'],
    },
    Decomposition {
        kanji: '梚',
        radicals: &['一', '｜', '儿', '勹', '口', '木', '免'],
    },
    Decomposition {
        kanji: '梜',
        radicals: &['人', '大', '木'],
    },
    Decomposition {
        kanji: '梡',
        radicals: &['二', '儿', '宀', '木', '元'],
    },
    Decomposition {
        kanji: '梣',
        radicals: &['一', '丶', '𠆢', '山', '木'],
    },
    Decomposition {
        kanji: '梥',
        radicals: &['ハ', '厶', '宀', '木'],
    },
    Decomposition {
        kanji: '梩',
        radicals: &['木', '里'],
    },
    Decomposition {
        kanji: '梪',
        radicals: &['丷', '口', '木', '豆'],
    },
    Decomposition {
        kanji: '梮',
        radicals: &['亅', '口', '尸', '木'],
    },
    Decomposition {
        kanji: '梲',
        radicals: &['儿', 'ハ', '口', '木'],
    },
    Decomposition {
        kanji: '梻',
        radicals: &['⺅', '廾', '弓', '木'],
    },
    Decomposition {
        kanji: '棅',
        radicals: &['ノ', 'ヨ', '木', '禾', '耒'],
    },
    Decomposition {
        kanji: '棈',
        radicals: &['二', '亠', '土', '月', '木', '青'],
    },
    Decomposition {
        kanji: '棌',
        radicals: &['木', '爪'],
    },
    Decomposition {
        kanji: '棏',
        radicals: &['一', '寸', '日', '木'],
    },
    Decomposition {
        kanji: '棐',
        radicals: &['木', '非'],
    },
    Decomposition {
        kanji: '棑',
        radicals: &['木', '非'],
    },
    Decomposition {
        kanji: '棓',
        radicals: &['口', '木', '立'],
    },
    Decomposition {
        kanji: '棖',
        radicals: &['木', '長'],
    },
    Decomposition {
        kanji: '棙',
        radicals: &['一', '丶', '大', '尸', '戸', '木', '犬'],
    },
    Decomposition {
        kanji: '棜',
        radicals: &['丶', '𠆢', '方', '木'],
    },
    Decomposition {
        kanji: '棝',
        radicals: &['十', '口', '囗', '木'],
    },
    Decomposition {
        kanji: '棥',
        radicals: &['木', '爻'],
    },
    Decomposition {
        kanji: '棨',
        radicals: &['一', '尸', '戸', '攵', '木'],
    },
    Decomposition {
        kanji: '棪',
        radicals: &['木', '火'],
    },
    Decomposition {
        kanji: '棫',
        radicals: &['一', '口', '戈', '木'],
    },
    Decomposition {
        kanji: '棬',
        radicals: &['一', 'ハ', '丷', '卩', '大', '木'],
    },
    Decomposition {
        kanji: '棭',
        radicals: &['丶', '亠', '⺅', '夂', '木'],
    },
    Decomposition {
        kanji: '棰',
        radicals: &['一', '｜', 'ノ', '二', '日', '木'],
    },
    Decomposition {
        kanji: '棱',
        radicals: &['儿', 'ハ', '土', '夂', '木'],
    },
    Decomposition {
        kanji: '棵',
        radicals: &['木', '田'],
    },
    Decomposition {
        kanji: '棶',
        radicals: &['人', '木'],
    },
    Decomposition {
        kanji: '棻',
        radicals: &['ハ', '刀', '⺾', '木'],
    },
    Decomposition {
        kanji: '棼',
        radicals: &['ハ', '刀', '木'],
    },
    Decomposition {
        kanji: '棽',
        radicals: &['丶', '𠆢', '木'],
    },
    Decomposition {
        kanji: '椆',
        radicals: &['冂', '口', '土', '木'],
    },
    Decomposition {
        kanji: '椉',
        radicals: &['亠', '夕', '木', '舛'],
    },
    Decomposition {
        kanji: '椊',
        radicals: &['亠', '人', '十', '木'],
    },
    Decomposition {
        kanji: '椐',
        radicals: &['十', '口', '尸', '木'],
    },
    Decomposition {
        kanji: '椑',
        radicals: &['ノ', '十', '日', '木', '白'],
    },
    Decomposition {
        kanji: '椓',
        radicals: &['丶', '木', '豕'],
    },
    Decomposition {
        kanji: '椖',
        radicals: &['一', '丶', '尸', '戸', '方', '木'],
    },
    Decomposition {
        kanji: '椗',
        radicals: &['宀', '木', '疋'],
    },
    Decomposition {
        kanji: '椱',
        radicals: &['一', 'ノ', '夂', '日', '曰', '木'],
    },
    Decomposition {
        kanji: '椳',
        radicals: &['木', '田', '衣'],
    },
    Decomposition {
        kanji: '椵',
        radicals: &['一', '｜', '又', '木'],
    },
    Decomposition {
        kanji: '椸',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '也', '方', '木'],
    },
    Decomposition {
        kanji: '椻',
        radicals: &['匚', '女', '日', '木'],
    },
    Decomposition {
        kanji: '楂',
        radicals: &['一', '日', '木', '目'],
    },
    Decomposition {
        kanji: '楅',
        radicals: &['一', '口', '木', '田'],
    },
    Decomposition {
        kanji: '楉',
        radicals: &['一', 'ノ', '口', '⺾', '木'],
    },
    Decomposition {
        kanji: '楎',
        radicals: &['冖', '木', '車'],
    },
    Decomposition {
        kanji: '楗',
        radicals: &['｜', '二', '廴', 'ヨ', '木', '聿'],
    },
    Decomposition {
        kanji: '楛',
        radicals: &['十', '口', '⺾', '木'],
    },
    Decomposition {
        kanji: '楣',
        radicals: &['｜', '尸', '木', '目'],
    },
    Decomposition {
        kanji: '楤',
        radicals: &['丶', 'ノ', '勹', '心', '木', '勿'],
    },
    Decomposition {
        kanji: '楥',
        radicals: &['ノ', '二', '又', '木', '爪'],
    },
    Decomposition {
        kanji: '楦',
        radicals: &['一', '宀', '日', '曰', '木'],
    },
    Decomposition {
        kanji: '楨',
        radicals: &['ハ', '卜', '木', '目', '貝'],
    },
    Decomposition {
        kanji: '楩',
        radicals: &['一', '丶', 'ノ', '⺅', '日', '木'],
    },
    Decomposition {
        kanji: '楬',
        radicals: &['人', '勹', '日', '木'],
    },
    Decomposition {
        kanji: '楰',
        radicals: &['人', '大', '木', '臼'],
    },
    Decomposition {
        kanji: '楱',
        radicals: &['一', '二', '大', '木'],
    },
    Decomposition {
        kanji: '楲',
        radicals: &['一', 'ノ', '厂', '女', '戈', '木'],
    },
    Decomposition {
        kanji: '楺',
        radicals: &['マ', '木', '矛'],
    },
    Decomposition {
        kanji: '楻',
        radicals: &['日', '木', '王', '白'],
    },
    Decomposition {
        kanji: '楿',
        radicals: &['ノ', '日', '木', '禾', '香'],
    },
    Decomposition {
        kanji: '榀',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '榍',
        radicals: &['⺌', '尸', '月', '木'],
    },
    Decomposition {
        kanji: '榒',
        radicals: &['丶', '冫', '弓', '木'],
    },
    Decomposition {
        kanji: '榖',
        radicals: &['一', '冖', '几', '又', '士', '木', '殳'],
    },
    Decomposition {
        kanji: '榘',
        radicals: &['一', 'ノ', '匚', '大', '木', '矢', '臣'],
    },
    Decomposition {
        kanji: '榡',
        radicals: &['一', '｜', '二', '小', '幺', '木', '糸'],
    },
    Decomposition {
        kanji: '榥',
        radicals: &['一', '儿', '⺌', '日', '木'],
    },
    Decomposition {
        kanji: '榦',
        radicals: &['𠆢', '十', '口', '日', '木'],
    },
    Decomposition {
        kanji: '榨',
        radicals: &['一', '｜', 'ノ', '儿', 'ハ', '宀', '木'],
    },
    Decomposition {
        kanji: '榫',
        radicals: &['十', '木', '隹'],
    },
    Decomposition {
        kanji: '榭',
        radicals: &['ノ', '寸', '木', '目'],
    },
    Decomposition {
        kanji: '榯',
        radicals: &['土', '寸', '日', '木'],
    },
    Decomposition {
        kanji: '榷',
        radicals: &['冖', '木', '隹'],
    },
    Decomposition {
        kanji: '榸',
        radicals: &['土', '木', '里'],
    },
    Decomposition {
        kanji: '榺',
        radicals: &['一', 'ハ', '丷', '大', '月', '木'],
    },
    Decomposition {
        kanji: '榼',
        radicals: &['厶', '土', '木', '皿'],
    },
    Decomposition {
        kanji: '槅',
        radicals: &['儿', '冂', '口', '木', '鬲'],
    },
    Decomposition {
        kanji: '槈',
        radicals: &['厂', '寸', '木', '衣', '辰'],
    },
    Decomposition {
        kanji: '槑',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '槖',
        radicals: &['冖', '口', '士', '木', '石'],
    },
    Decomposition {
        kanji: '槗',
        radicals: &['一', 'ノ', '冂', '口', '木'],
    },
    Decomposition {
        kanji: '槢',
        radicals: &['ノ', '冫', '日', '木', '白', '羽'],
    },
    Decomposition {
        kanji: '槥',
        radicals: &['一', '｜', 'ヨ', '木'],
    },
    Decomposition {
        kanji: '槮',
        radicals: &['𠆢', '厶', '彡', '木'],
    },
    Decomposition {
        kanji: '槯',
        radicals: &['山', '木', '隹'],
    },
    Decomposition {
        kanji: '槱',
        radicals: &['木', '⺣', '酉'],
    },
    Decomposition {
        kanji: '槳',
        radicals: &['丶', '夕', '寸', '木', '爿'],
    },
    Decomposition {
        kanji: '槵',
        radicals: &['｜', '口', '心', '木'],
    },
    Decomposition {
        kanji: '槾',
        radicals: &['又', '日', '木', '⺲'],
    },
    Decomposition {
        kanji: '樀',
        radicals: &['亠', '丷', '冂', '十', '口', '木', '立', '啇'],
    },
    Decomposition {
        kanji: '樁',
        radicals: &['一', '丶', 'ノ', '二', '大', '木', '臼'],
    },
    Decomposition {
        kanji: '樃',
        radicals: &['丶', '厶', '日', '月', '木'],
    },
    Decomposition {
        kanji: '樏',
        radicals: &['小', '幺', '木', '田', '糸'],
    },
    Decomposition {
        kanji: '樑',
        radicals: &['丶', 'ノ', '刀', '⺡', '木'],
    },
    Decomposition {
        kanji: '樕',
        radicals: &['人', '勹', '口', '木', '欠'],
    },
    Decomposition {
        kanji: '樚',
        radicals: &['匕', '广', '木', '比', '鹿'],
    },
    Decomposition {
        kanji: '樝',
        radicals: &['一', '匕', '卜', '厂', '木', '目', '虍'],
    },
    Decomposition {
        kanji: '樠',
        radicals: &['一', '｜', '入', '冂', '凵', '木'],
    },
    Decomposition {
        kanji: '樤',
        radicals: &['一', '｜', '⺅', '夂', '小', '木'],
    },
    Decomposition {
        kanji: '樨',
        radicals: &['｜', '丶', 'ノ', '冫', '尸', '木', '牛'],
    },
    Decomposition {
        kanji: '樰',
        radicals: &['二', '冖', 'ヨ', '木', '雨'],
    },
    Decomposition {
        kanji: '樲',
        radicals: &['二', '弋', '木'],
    },
    Decomposition {
        kanji: '樴',
        radicals: &['亠', '丷', '戈', '日', '木', '立'],
    },
    Decomposition {
        kanji: '樷',
        radicals: &['又', '木', '耳'],
    },
    Decomposition {
        kanji: '樻',
        radicals: &['一', '｜', 'ハ', '口', '木', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '樾',
        radicals: &['一', '｜', '十', '土', '戈', '木', '止', '疋'],
    },
    Decomposition {
        kanji: '樿',
        radicals: &['十', '口', '日', '木', '田'],
    },
    Decomposition {
        kanji: '橅',
        radicals: &['一', '｜', 'ノ', '木', '⺣', '無'],
    },
    Decomposition {
        kanji: '橆',
        radicals: &['一', 'ノ', '木', '皿'],
    },
    Decomposition {
        kanji: '橉',
        radicals: &['夕', '木', '米', '舛'],
    },
    Decomposition {
        kanji: '橊',
        radicals: &['一', '｜', '木', '田'],
    },
    Decomposition {
        kanji: '橎',
        radicals: &['ノ', '木', '田', '米'],
    },
    Decomposition {
        kanji: '橐',
        radicals: &['一', '冖', '口', '木', '石'],
    },
    Decomposition {
        kanji: '橑',
        radicals: &['丶', 'ノ', '大', '小', '日', '木'],
    },
    Decomposition {
        kanji: '橒',
        radicals: &['一', '｜', '二', '冖', '厶', '木', '雨'],
    },
    Decomposition {
        kanji: '橕',
        radicals: &['冖', '口', '⺌', '木', '牙'],
    },
    Decomposition {
        kanji: '橖',
        radicals: &['冖', '口', '⺌', '木'],
    },
    Decomposition {
        kanji: '橛',
        radicals: &['一', '人', '丷', '勹', '厂', '屮', '木', '欠'],
    },
    Decomposition {
        kanji: '橤',
        radicals: &['心', '木'],
    },
    Decomposition {
        kanji: '橧',
        radicals: &['｜', '丷', '口', '日', '木'],
    },
    Decomposition {
        kanji: '橪',
        radicals: &['丶', '夕', '大', '木', '⺣', '犬'],
    },
    Decomposition {
        kanji: '橱',
        radicals: &['丷', '厂', '口', '寸', '木', '豆'],
    },
    Decomposition {
        kanji: '橳',
        radicals: &['一', 'ハ', '丷', '力', '大', '月', '木'],
    },
    Decomposition {
        kanji: '橾',
        radicals: &['口', '木'],
    },
    Decomposition {
        kanji: '檁',
        radicals: &['ノ', '亠', '口', '囗', '木', '禾'],
    },
    Decomposition {
        kanji: '檃',
        radicals: &['工', 'ヨ', '⻖', '木', '爪'],
    },
    Decomposition {
        kanji: '檆',
        radicals: &['卜', '口', '木', '火'],
    },
    Decomposition {
        kanji: '檇',
        radicals: &['｜', '亅', '木', '隹'],
    },
    Decomposition {
        kanji: '檉',
        radicals: &['口', '木', '王', '耳'],
    },
    Decomposition {
        kanji: '檋',
        radicals: &['｜', '丶', 'ノ', '二', '木', '車'],
    },
    Decomposition {
        kanji: '檑',
        radicals: &['一', '｜', '二', '冖', '木', '田', '雨'],
    },
    Decomposition {
        kanji: '檛',
        radicals: &['冂', '⻌', '口', '木'],
    },
    Decomposition {
        kanji: '檝',
        radicals: &['口', '戈', '木', '耳'],
    },
    Decomposition {
        kanji: '檞',
        radicals: &['｜', '刀', '勹', '月', '木', '牛', '角'],
    },
    Decomposition {
        kanji: '檟',
        radicals: &['ハ', '木', '目', '西', '貝'],
    },
    Decomposition {
        kanji: '檥',
        radicals: &['丷', '戈', '手', '木', '王'],
    },
    Decomposition {
        kanji: '檫',
        radicals: &['丶', '二', '夕', '宀', '小', '木', '示'],
    },
    Decomposition {
        kanji: '檯',
        radicals: &['一', '冖', '厶', '口', '土', '士', '木', '至'],
    },
    Decomposition {
        kanji: '檰',
        radicals: &['｜', '冂', '小', '巾', '幺', '日', '木', '白', '糸'],
    },
    Decomposition {
        kanji: '檱',
        radicals: &['｜', '二', 'ハ', '木', '目', '竹', '貝'],
    },
    Decomposition {
        kanji: '檴',
        radicals: &['又', '⺾', '木', '隹'],
    },
    Decomposition {
        kanji: '檽',
        radicals: &['一', '｜', '二', '冖', '木', '而', '雨'],
    },
    Decomposition {
        kanji: '檾',
        radicals: &['冖', '木', '火'],
    },
    Decomposition {
        kanji: '檿',
        radicals: &['丶', '厂', '大', '日', '月', '木', '犬'],
    },
    Decomposition {
        kanji: '櫆',
        radicals: &['儿', '匕', '厶', '斗', '木', '田', '鬼'],
    },
    Decomposition {
        kanji: '櫉',
        radicals: &['丷', '十', '厂', '口', '士', '寸', '木', '豆'],
    },
    Decomposition {
        kanji: '櫈',
        radicals: &['丷', '几', '口', '木', '癶', '豆'],
    },
    Decomposition {
        kanji: '櫌',
        radicals: &['一', '冖', '夂', '心', '木', '目', '自'],
    },
    Decomposition {
        kanji: '櫐',
        radicals: &['木', '田'],
    },
    Decomposition {
        kanji: '櫔',
        radicals: &['｜', '冂', '厂', '厶', '⺾', '日', '木', '田', '⽱'],
    },
    Decomposition {
        kanji: '櫕',
        radicals: &['一', 'ハ', '木', '目', '貝'],
    },
    Decomposition {
        kanji: '櫖',
        radicals: &['匕', '卜', '厂', '心', '木', '田', '虍'],
    },
    Decomposition {
        kanji: '櫜',
        radicals: &['一', '｜', '冖', '卜', '口', '夂', '木'],
    },
    Decomposition {
        kanji: '櫝',
        radicals: &['儿', 'ハ', '口', '士', '木', '目', '⺲', '貝'],
    },
    Decomposition {
        kanji: '櫤',
        radicals: &['一', '丶', '丷', '冂', '⺉', '月', '木', '竹'],
    },
    Decomposition {
        kanji: '櫧',
        radicals: &['ノ', '土', '⺹', '日', '木', '言'],
    },
    Decomposition {
        kanji: '櫬',
        radicals: &['一', '儿', '小', '木', '目', '立', '見'],
    },
    Decomposition {
        kanji: '櫰',
        radicals: &['｜', '丶', 'ノ', '亠', '冫', '木', '⺲', '衣'],
    },
    Decomposition {
        kanji: '櫱',
        radicals: &['｜', 'ノ', '十', '口', '屮', '木', '立', '辛'],
    },
    Decomposition {
        kanji: '櫲',
        radicals: &['ノ', '亅', '勹', 'マ', '口', '木', '矛', '豕'],
    },
    Decomposition {
        kanji: '櫼',
        radicals: &['一', '人', '戈', '木', '非'],
    },
    Decomposition {
        kanji: '櫽',
        radicals: &['工', 'ヨ', '⻖', '心', '木', '爪'],
    },
    Decomposition {
        kanji: '欂',
        radicals: &['丶', '十', '寸', '⺡', '⺾', '日', '木', '田'],
    },
    Decomposition {
        kanji: '欃',
        radicals: &['一', '｜', '丶', '儿', '勹', '匕', '口', '木', '比', '免'],
    },
    Decomposition {
        kanji: '欆',
        radicals: &['又', '木', '隹'],
    },
    Decomposition {
        kanji: '欇',
        radicals: &['木', '耳'],
    },
    Decomposition {
        kanji: '欉',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '又', '木', '王', '耳'],
    },
    Decomposition {
        kanji: '欏',
        radicals: &['小', '幺', '木', '⺲', '糸', '隹'],
    },
    Decomposition {
        kanji: '欐',
        radicals: &['一', '丶', '冂', '匕', '广', '木', '比', '鹿'],
    },
    Decomposition {
        kanji: '欑',
        radicals: &['ノ', '儿', 'ハ', '土', '木', '目', '貝'],
    },
    Decomposition {
        kanji: '欗',
        radicals: &['丷', '口', '⺾', '木', '門'],
    },
    Decomposition {
        kanji: '欛',
        radicals: &[
            '一', '｜', '二', '冖', '十', '口', '廾', '月', '木', '雨', '革',
        ],
    },
    Decomposition {
        kanji: '欞',
        radicals: &['一', '｜', '二', '人', '冖', '口', '工', '雨'],
    },
    Decomposition {
        kanji: '欤',
        radicals: &['一', '亅', '人', '勹', '卜', '欠'],
    },
    Decomposition {
        kanji: '欨',
        radicals: &['人', '勹', '口', '欠'],
    },
    Decomposition {
        kanji: '欫',
        radicals: &['ノ', '二', '人', '勹', '欠', '止'],
    },
    Decomposition {
        kanji: '欬',
        radicals: &['ノ', '亠', '人', '勹', '幺', '欠', '玄'],
    },
    Decomposition {
        kanji: '欯',
        radicals: &['人', '勹', '口', '士', '欠'],
    },
    Decomposition {
        kanji: '欵',
        radicals: &['一', 'ノ', '人', '勹', '匕', '大', '欠', '矢'],
    },
    Decomposition {
        kanji: '欶',
        radicals: &['人', '勹', '口', '木', '欠'],
    },
    Decomposition {
        kanji: '欻',
        radicals: &['人', '勹', '欠', '火'],
    },
    Decomposition {
        kanji: '欿',
        radicals: &['人', '勹', '欠', '臼'],
    },
    Decomposition {
        kanji: '歆',
        radicals: &['人', '勹', '日', '欠', '立', '音'],
    },
    Decomposition {
        kanji: '歊',
        radicals: &['亠', '人', '冂', '勹', '口', '欠', '高'],
    },
    Decomposition {
        kanji: '歍',
        radicals: &['人', '勹', '欠', '⺣', '鳥'],
    },
    Decomposition {
        kanji: '歒',
        radicals: &['亠', '人', '丷', '冂', '勹', '十', '口', '欠', '立', '啇'],
    },
    Decomposition {
        kanji: '歖',
        radicals: &['一', '人', '丷', '勹', '十', '口', '士', '欠', '豆'],
    },
    Decomposition {
        kanji: '歘',
        radicals: &['人', '勹', '欠', '火'],
    },
    Decomposition {
        kanji: '歝',
        radicals: &['一', '人', '丷', '勹', '十', '土', '干', '欠', '⺲'],
    },
    Decomposition {
        kanji: '歠',
        radicals: &['人', '勹', '又', '欠', '酉'],
    },
    Decomposition {
        kanji: '歧',
        radicals: &['十', '又', '支', '止'],
    },
    Decomposition {
        kanji: '歫',
        radicals: &['匚', '口', '止'],
    },
    Decomposition {
        kanji: '歮',
        radicals: &['止'],
    },
    Decomposition {
        kanji: '歰',
        radicals: &['ノ', '刀', '止'],
    },
    Decomposition {
        kanji: '歵',
        radicals: &['一', '｜', '二', 'ハ', '止', '目', '貝'],
    },
    Decomposition {
        kanji: '歽',
        radicals: &['斤', '歹'],
    },
    Decomposition {
        kanji: '歾',
        radicals: &['ノ', '勹', '歹', '勿'],
    },
    Decomposition {
        kanji: '殂',
        radicals: &['一', '歹', '目'],
    },
    Decomposition {
        kanji: '殅',
        radicals: &['歹', '生'],
    },
    Decomposition {
        kanji: '殗',
        radicals: &['乙', '大', '日', '歹', '奄'],
    },
    Decomposition {
        kanji: '殛',
        radicals: &['一', '亅', '又', '口', '歹'],
    },
    Decomposition {
        kanji: '殟',
        radicals: &['日', '曰', '歹', '皿'],
    },
    Decomposition {
        kanji: '殠',
        radicals: &['丶', '大', '歹', '犬', '目', '自'],
    },
    Decomposition {
        kanji: '殢',
        radicals: &['一', '｜', 'ノ', '乙', '冂', '冖', '巾', '廾', '歹'],
    },
    Decomposition {
        kanji: '殣',
        radicals: &['二', '十', '口', '廾', '歹', '革'],
    },
    Decomposition {
        kanji: '殨',
        radicals: &['一', '｜', 'ハ', '口', '歹', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '殩',
        radicals: &['卜', '又', '夕', '歹', '米'],
    },
    Decomposition {
        kanji: '殬',
        radicals: &['一', '丷', '十', '土', '干', '歹', '⺲'],
    },
    Decomposition {
        kanji: '殭',
        radicals: &['一', '歹', '田'],
    },
    Decomposition {
        kanji: '殮',
        radicals: &['一', '人', '𠆢', '口', '歹'],
    },
    Decomposition {
        kanji: '殰',
        radicals: &['儿', 'ハ', '口', '士', '歹', '目', '⺲', '貝'],
    },
    Decomposition {
        kanji: '殸',
        radicals: &['｜', '几', '又', '士', '尸', '殳'],
    },
    Decomposition {
        kanji: '殹',
        radicals: &['一', 'ノ', '几', '匚', '又', '大', '殳', '矢'],
    },
    Decomposition {
        kanji: '殽',
        radicals: &['一', '丶', 'ノ', '几', '又', '月', '殳'],
    },
    Decomposition {
        kanji: '殾',
        radicals: &['丶', 'ノ', '几', '又', '土', '⺹', '日', '殳'],
    },
    Decomposition {
        kanji: '毃',
        radicals: &['亠', '冂', '几', '又', '口', '殳', '高'],
    },
    Decomposition {
        kanji: '毄',
        radicals: &['几', '又', '口', '殳', '車'],
    },
    Decomposition {
        kanji: '毉',
        radicals: &['一', 'ノ', '人', '几', '匚', '又', '大', '工', '殳', '矢'],
    },
    Decomposition {
        kanji: '毌',
        radicals: &['一', '日', '田'],
    },
    Decomposition {
        kanji: '毖',
        radicals: &['ノ', '匕', '心', '比'],
    },
    Decomposition {
        kanji: '毚',
        radicals: &['一', '｜', '儿', '勹', '匕', '口', '比', '免'],
    },
    Decomposition {
        kanji: '毡',
        radicals: &['ノ', '乙', '二', '卜', '口'],
    },
    Decomposition {
        kanji: '毣',
        radicals: &['ノ', '乙', '二', '冫', '羽'],
    },
    Decomposition {
        kanji: '毦',
        radicals: &['ノ', '乙', '二', '耳'],
    },
    Decomposition {
        kanji: '毧',
        radicals: &['一', 'ノ', '乙', '二', '戈'],
    },
    Decomposition {
        kanji: '毮',
        radicals: &['ノ', '乙', '二', '小', '扌'],
    },
    Decomposition {
        kanji: '毱',
        radicals: &['ノ', '乙', '二', '勹', '米'],
    },
    Decomposition {
        kanji: '毷',
        radicals: &['ノ', '乙', '二', '冂', '目'],
    },
    Decomposition {
        kanji: '毹',
        radicals: &['一', 'ノ', '乙', '二', '𠆢', '⺉', '月'],
    },
    Decomposition {
        kanji: '毿',
        radicals: &['ノ', '乙', '二', '𠆢', '厶', '彡'],
    },
    Decomposition {
        kanji: '氂',
        radicals: &['一', 'ノ', '乙', '二', '厂', '攵', '木'],
    },
    Decomposition {
        kanji: '氄',
        radicals: &['ノ', '乙', '二', '儿', 'ハ', '冂', 'マ', '口', '矛'],
    },
    Decomposition {
        kanji: '氅',
        radicals: &['ノ', '乙', '二', '冂', '口', '⺌', '攵'],
    },
    Decomposition {
        kanji: '氉',
        radicals: &['ノ', '乙', '二', '口', '木'],
    },
    Decomposition {
        kanji: '氍',
        radicals: &['ノ', '乙', '二', '目', '隹'],
    },
    Decomposition {
        kanji: '氎',
        radicals: &['ノ', '乙', '二', '夕', '宀', '田'],
    },
    Decomposition {
        kanji: '氐',
        radicals: &['一', '丶', '氏'],
    },
    Decomposition {
        kanji: '氒',
        radicals: &['ノ', '十', '氏'],
    },
    Decomposition {
        kanji: '氙',
        radicals: &['山', '气'],
    },
    Decomposition {
        kanji: '氟',
        radicals: &['廾', '弓', '气'],
    },
    Decomposition {
        kanji: '氦',
        radicals: &['ノ', '亠', '幺', '气', '玄'],
    },
    Decomposition {
        kanji: '氧',
        radicals: &['丷', '气', '王', '羊'],
    },
    Decomposition {
        kanji: '氨',
        radicals: &['女', '宀', '气'],
    },
    Decomposition {
        kanji: '氬',
        radicals: &['｜', '二', '气'],
    },
    Decomposition {
        kanji: '氮',
        radicals: &['气', '火'],
    },
    Decomposition {
        kanji: '氳',
        radicals: &['人', '口', '气', '皿'],
    },
    Decomposition {
        kanji: '氵',
        radicals: &['⺡'],
    },
    Decomposition {
        kanji: '氶',
        radicals: &['一', '水'],
    },
    Decomposition {
        kanji: '氺',
        radicals: &['水'],
    },
    Decomposition {
        kanji: '氻',
        radicals: &['力', '⺡'],
    },
    Decomposition {
        kanji: '氿',
        radicals: &['九', '⺡'],
    },
    Decomposition {
        kanji: '汊',
        radicals: &['丶', '又', '⺡'],
    },
    Decomposition {
        kanji: '汋',
        radicals: &['丶', '勹', '⺡'],
    },
    Decomposition {
        kanji: '汍',
        radicals: &['丶', '九', '⺡'],
    },
    Decomposition {
        kanji: '汏',
        radicals: &['大', '⺡'],
    },
    Decomposition {
        kanji: '汒',
        radicals: &['亠', '⺡', '亡'],
    },
    Decomposition {
        kanji: '汔',
        radicals: &['一', 'ノ', '乙', '⺡'],
    },
    Decomposition {
        kanji: '汙',
        radicals: &['亅', '二', '⺡'],
    },
    Decomposition {
        kanji: '汛',
        radicals: &['一', 'ノ', '乙', '十', '⺡'],
    },
    Decomposition {
        kanji: '汜',
        radicals: &['已', '⺡'],
    },
    Decomposition {
        kanji: '汫',
        radicals: &['一', '｜', 'ノ', '二', '廾', '⺡'],
    },
    Decomposition {
        kanji: '汭',
        radicals: &['人', '入', '冂', '⺡'],
    },
    Decomposition {
        kanji: '汯',
        radicals: &['一', 'ノ', '厶', '⺡'],
    },
    Decomposition {
        kanji: '汴',
        radicals: &['一', '丶', '亠', '卜', '⺡'],
    },
    Decomposition {
        kanji: '汶',
        radicals: &['⺡', '文'],
    },
    Decomposition {
        kanji: '汸',
        radicals: &['⺡', '方'],
    },
    Decomposition {
        kanji: '汹',
        radicals: &['丶', 'ノ', '凵', '⺡'],
    },
    Decomposition {
        kanji: '汻',
        radicals: &['一', 'ノ', '十', '干', '⺡'],
    },
    Decomposition {
        kanji: '沅',
        radicals: &['二', '儿', '⺡', '元'],
    },
    Decomposition {
        kanji: '沆',
        radicals: &['亠', '几', '⺡'],
    },
    Decomposition {
        kanji: '沇',
        radicals: &['儿', '厶', '⺡'],
    },
    Decomposition {
        kanji: '沉',
        radicals: &['冖', '几', '⺡'],
    },
    Decomposition {
        kanji: '沔',
        radicals: &['一', '｜', '亅', '⺡'],
    },
    Decomposition {
        kanji: '沕',
        radicals: &['ノ', '勹', '⺡', '勿'],
    },
    Decomposition {
        kanji: '沗',
        radicals: &['一', '大', '水'],
    },
    Decomposition {
        kanji: '沘',
        radicals: &['匕', '⺡', '比'],
    },
    Decomposition {
        kanji: '沜',
        radicals: &['⺡', '片'],
    },
    Decomposition {
        kanji: '沟',
        radicals: &['勹', '厶', '⺡'],
    },
    Decomposition {
        kanji: '沰',
        radicals: &['口', '⺡', '石'],
    },
    Decomposition {
        kanji: '沲',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '⺡', '也'],
    },
    Decomposition {
        kanji: '沴',
        radicals: &['𠆢', '彡', '⺡'],
    },
    Decomposition {
        kanji: '泂',
        radicals: &['冂', '口', '⺡'],
    },
    Decomposition {
        kanji: '泆',
        radicals: &['一', 'ノ', '大', '⺡'],
    },
    Decomposition {
        kanji: '泍',
        radicals: &['一', '⺡', '木'],
    },
    Decomposition {
        kanji: '泏',
        radicals: &['｜', '凵', '山', '⺡'],
    },
    Decomposition {
        kanji: '泐',
        radicals: &['力', '⺡', '⻖'],
    },
    Decomposition {
        kanji: '泑',
        radicals: &['力', '幺', '⺡'],
    },
    Decomposition {
        kanji: '泒',
        radicals: &['厶', '⺡', '瓜'],
    },
    Decomposition {
        kanji: '泔',
        radicals: &['⺡', '甘'],
    },
    Decomposition {
        kanji: '泖',
        radicals: &['ノ', '卩', '⺡'],
    },
    Decomposition {
        kanji: '泚',
        radicals: &['匕', '⺡', '止'],
    },
    Decomposition {
        kanji: '泜',
        radicals: &['一', '丶', '⺡', '氏'],
    },
    Decomposition {
        kanji: '泠',
        radicals: &['｜', '丶', '亅', '𠆢', 'マ', '⺡'],
    },
    Decomposition {
        kanji: '泧',
        radicals: &['｜', '⺡', '戈'],
    },
    Decomposition {
        kanji: '泩',
        radicals: &['⺡', '生'],
    },
    Decomposition {
        kanji: '泫',
        radicals: &['亠', '幺', '⺡', '玄'],
    },
    Decomposition {
        kanji: '泬',
        radicals: &['ハ', '宀', '⺡'],
    },
    Decomposition {
        kanji: '泮',
        radicals: &['｜', '二', 'ハ', '丷', '⺡'],
    },
    Decomposition {
        kanji: '泲',
        radicals: &['ノ', '亅', '⺡'],
    },
    Decomposition {
        kanji: '泴',
        radicals: &['水', '皿'],
    },
    Decomposition {
        kanji: '洄',
        radicals: &['口', '囗', '⺡'],
    },
    Decomposition {
        kanji: '洇',
        radicals: &['口', '大', '⺡'],
    },
    Decomposition {
        kanji: '洊',
        radicals: &['一', '｜', 'ノ', '子', '⺡'],
    },
    Decomposition {
        kanji: '洎',
        radicals: &['⺡', '目', '自'],
    },
    Decomposition {
        kanji: '洏',
        radicals: &['⺡', '而'],
    },
    Decomposition {
        kanji: '洑',
        radicals: &['丶', '⺅', '大', '⺡', '犬'],
    },
    Decomposition {
        kanji: '洓',
        radicals: &['冂', '⺡', '木'],
    },
    Decomposition {
        kanji: '洚',
        radicals: &['｜', '夂', '⺡'],
    },
    Decomposition {
        kanji: '洦',
        radicals: &['一', '⺡', '日', '白'],
    },
    Decomposition {
        kanji: '洧',
        radicals: &['一', 'ノ', '⺡', '月'],
    },
    Decomposition {
        kanji: '洨',
        radicals: &['亠', '⺡', '父'],
    },
    Decomposition {
        kanji: '汧',
        radicals: &['一', '｜', 'ノ', '廾', '⺡'],
    },
    Decomposition {
        kanji: '洮',
        radicals: &['丶', 'ノ', '儿', '冫', '⺡'],
    },
    Decomposition {
        kanji: '洯',
        radicals: &['一', '｜', '二', '刀', '彡', '水'],
    },
    Decomposition {
        kanji: '洱',
        radicals: &['⺡', '耳'],
    },
    Decomposition {
        kanji: '洹',
        radicals: &['一', '⺡', '日'],
    },
    Decomposition {
        kanji: '洼',
        radicals: &['土', '⺡'],
    },
    Decomposition {
        kanji: '洿',
        radicals: &['二', '勹', '大', '⺡'],
    },
    Decomposition {
        kanji: '浗',
        radicals: &['一', '丶', '⺡', '水'],
    },
    Decomposition {
        kanji: '浞',
        radicals: &['口', '⺡', '足'],
    },
    Decomposition {
        kanji: '浟',
        radicals: &['｜', '⺅', '⺡', '攵'],
    },
    Decomposition {
        kanji: '浡',
        radicals: &['冖', '十', '子', '⺡'],
    },
    Decomposition {
        kanji: '浥',
        radicals: &['乙', '口', '已', '⺡', '⻏', '巴'],
    },
    Decomposition {
        kanji: '浧',
        radicals: &['口', '⺡', '王'],
    },
    Decomposition {
        kanji: '浯',
        radicals: &['一', '二', '口', '⺡', '五'],
    },
    Decomposition {
        kanji: '浰',
        radicals: &['ノ', '⺉', '⺡', '木', '禾'],
    },
    Decomposition {
        kanji: '浼',
        radicals: &['一', '｜', '儿', '勹', '口', '⺡', '免'],
    },
    Decomposition {
        kanji: '涂',
        radicals: &['二', '𠆢', '小', '⺡', '示'],
    },
    Decomposition {
        kanji: '涇',
        radicals: &['一', '巛', '工', '⺡'],
    },
    Decomposition {
        kanji: '涑',
        radicals: &['口', '⺡', '木'],
    },
    Decomposition {
        kanji: '涒',
        radicals: &['ノ', '口', 'ヨ', '⺡'],
    },
    Decomposition {
        kanji: '涔',
        radicals: &['一', '丶', '𠆢', '山', '⺡'],
    },
    Decomposition {
        kanji: '涖',
        radicals: &['⺅', '⺡', '立'],
    },
    Decomposition {
        kanji: '涗',
        radicals: &['儿', 'ハ', '口', '⺡'],
    },
    Decomposition {
        kanji: '涘',
        radicals: &['一', 'ノ', '厶', '大', '⺡', '矢'],
    },
    Decomposition {
        kanji: '涪',
        radicals: &['口', '⺡', '立'],
    },
    Decomposition {
        kanji: '涬',
        radicals: &['一', '丷', '十', '土', '干', '⺡'],
    },
    Decomposition {
        kanji: '涴',
        radicals: &['卩', '夕', '宀', '⺡'],
    },
    Decomposition {
        kanji: '涷',
        radicals: &['⺡', '日', '木'],
    },
    Decomposition {
        kanji: '涹',
        radicals: &['ノ', '女', '⺡', '木', '禾'],
    },
    Decomposition {
        kanji: '涽',
        radicals: &['⺡', '日', '曰', '氏'],
    },
    Decomposition {
        kanji: '涿',
        radicals: &['丶', '⺡', '豕'],
    },
    Decomposition {
        kanji: '淄',
        radicals: &['巛', '⺡', '田'],
    },
    Decomposition {
        kanji: '淈',
        radicals: &['｜', '凵', '尸', '山', '⺡'],
    },
    Decomposition {
        kanji: '淊',
        radicals: &['勹', '⺡', '臼'],
    },
    Decomposition {
        kanji: '淎',
        radicals: &['一', '｜', '二', '大', '⺡'],
    },
    Decomposition {
        kanji: '淏',
        radicals: &['一', '大', '⺡', '日'],
    },
    Decomposition {
        kanji: '淖',
        radicals: &['十', '卜', '⺡', '日'],
    },
    Decomposition {
        kanji: '淛',
        radicals: &['｜', '冂', '⺉', '巾', '⺡', '牛'],
    },
    Decomposition {
        kanji: '淝',
        radicals: &['乙', '已', '⺡', '月', '巴'],
    },
    Decomposition {
        kanji: '淟',
        radicals: &['一', '｜', 'ハ', '⺡', '日'],
    },
    Decomposition {
        kanji: '淠',
        radicals: &['一', '｜', 'ノ', '廾', '⺡', '田'],
    },
    Decomposition {
        kanji: '淢',
        radicals: &['一', '口', '⺡', '戈'],
    },
    Decomposition {
        kanji: '淥',
        radicals: &['ヨ', '彑', '⺡', '水'],
    },
    Decomposition {
        kanji: '淩',
        radicals: &['儿', 'ハ', '土', '夂', '⺡'],
    },
    Decomposition {
        kanji: '淯',
        radicals: &['亠', '厶', '⺡', '月'],
    },
    Decomposition {
        kanji: '淰',
        radicals: &['一', '丶', '𠆢', '⺡', '心'],
    },
    Decomposition {
        kanji: '淴',
        radicals: &['ノ', '勹', '⺡', '心', '勿'],
    },
    Decomposition {
        kanji: '淶',
        radicals: &['人', '⺡', '木'],
    },
    Decomposition {
        kanji: '淼',
        radicals: &['水'],
    },
    Decomposition {
        kanji: '渀',
        radicals: &['十', '大', '廾', '⺡'],
    },
    Decomposition {
        kanji: '渄',
        radicals: &['⺡', '非'],
    },
    Decomposition {
        kanji: '渞',
        radicals: &['丷', '⺡', '目', '自', '首'],
    },
    Decomposition {
        kanji: '渢',
        radicals: &['ノ', '冂', '⺡', '虫', '風'],
    },
    Decomposition {
        kanji: '渧',
        radicals: &['｜', '亠', '丷', '冂', '冖', '巾', '⺡', '立'],
    },
    Decomposition {
        kanji: '渲',
        radicals: &['一', '宀', '⺡', '日'],
    },
    Decomposition {
        kanji: '渶',
        radicals: &['口', '大', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '渹',
        radicals: &['勹', '⺡', '言'],
    },
    Decomposition {
        kanji: '渻',
        radicals: &['ノ', '小', '⺡', '目'],
    },
    Decomposition {
        kanji: '渼',
        radicals: &['丷', '大', '⺡', '王'],
    },
    Decomposition {
        kanji: '湄',
        radicals: &['｜', '尸', '⺡', '目'],
    },
    Decomposition {
        kanji: '湅',
        radicals: &['丷', '口', '⺡', '木'],
    },
    Decomposition {
        kanji: '湈',
        radicals: &['⺡', '木', '甘'],
    },
    Decomposition {
        kanji: '湉',
        radicals: &['口', '⺖', '⺡', '舌'],
    },
    Decomposition {
        kanji: '湋',
        radicals: &['口', '⺡', '韋'],
    },
    Decomposition {
        kanji: '湏',
        radicals: &['ハ', '⺡', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '湑',
        radicals: &['⺡', '月', '疋'],
    },
    Decomposition {
        kanji: '湒',
        radicals: &['口', '⺡', '耳'],
    },
    Decomposition {
        kanji: '湓',
        radicals: &['ハ', '刀', '⺡', '皿'],
    },
    Decomposition {
        kanji: '湔',
        radicals: &['一', '丷', '⺉', '⺡', '月'],
    },
    Decomposition {
        kanji: '湗',
        radicals: &['土', '寸', '⺡'],
    },
    Decomposition {
        kanji: '湜',
        radicals: &['⺡', '日', '疋'],
    },
    Decomposition {
        kanji: '湝',
        radicals: &['匕', '⺡', '日', '比', '白'],
    },
    Decomposition {
        kanji: '湞',
        radicals: &['ハ', '卜', '⺡', '目', '貝'],
    },
    Decomposition {
        kanji: '湢',
        radicals: &['一', '口', '⺡', '田'],
    },
    Decomposition {
        kanji: '湣',
        radicals: &['尸', '⺡', '日', '氏'],
    },
    Decomposition {
        kanji: '湨',
        radicals: &['⺡', '木', '目'],
    },
    Decomposition {
        kanji: '湳',
        radicals: &['一', '丷', '冂', '十', '干', '⺡'],
    },
    Decomposition {
        kanji: '湻',
        radicals: &['亠', '口', '⺡', '日'],
    },
    Decomposition {
        kanji: '湽',
        radicals: &['一', '巛', '⺡', '田'],
    },
    Decomposition {
        kanji: '溍',
        radicals: &['｜', '二', '⺡', '日', '曰'],
    },
    Decomposition {
        kanji: '溓',
        radicals: &['一', '｜', '丶', 'ノ', '丷', 'ヨ', '⺡'],
    },
    Decomposition {
        kanji: '溙',
        radicals: &['一', '二', '大', '⺡', '水'],
    },
    Decomposition {
        kanji: '溠',
        radicals: &['一', 'ノ', '二', '丷', '工', '⺡'],
    },
    Decomposition {
        kanji: '溧',
        radicals: &['⺡', '木', '西'],
    },
    Decomposition {
        kanji: '溭',
        radicals: &['ハ', '夂', '⺡', '田'],
    },
    Decomposition {
        kanji: '溮',
        radicals: &['一', '｜', 'ノ', '冂', '口', '巾', '⺡'],
    },
    Decomposition {
        kanji: '溱',
        radicals: &['一', 'ノ', '二', '大', '⺡', '木', '禾'],
    },
    Decomposition {
        kanji: '溳',
        radicals: &['ハ', '口', '⺡', '目', '貝'],
    },
    Decomposition {
        kanji: '溻',
        radicals: &['丶', '冫', '⺡', '日', '曰', '羽'],
    },
    Decomposition {
        kanji: '溿',
        radicals: &['｜', '二', 'ハ', '丷', '⺡', '田'],
    },
    Decomposition {
        kanji: '滀',
        radicals: &['亠', '幺', '⺡', '玄', '田'],
    },
    Decomposition {
        kanji: '滁',
        radicals: &['一', '𠆢', '小', '⺡', '⻖'],
    },
    Decomposition {
        kanji: '滃',
        radicals: &['丶', 'ノ', 'ハ', '冫', '厶', '⺡', '羽'],
    },
    Decomposition {
        kanji: '滇',
        radicals: &['一', 'ハ', '匕', '十', '⺡', '目'],
    },
    Decomposition {
        kanji: '滈',
        radicals: &['亠', '冂', '口', '⺡', '高'],
    },
    Decomposition {
        kanji: '滊',
        radicals: &['⺡', '气', '米'],
    },
    Decomposition {
        kanji: '滍',
        radicals: &['一', '｜', '凵', '⺡', '虫'],
    },
    Decomposition {
        kanji: '滎',
        radicals: &['冖', '水', '火'],
    },
    Decomposition {
        kanji: '滏',
        radicals: &['丷', '⺡', '父', '王'],
    },
    Decomposition {
        kanji: '滫',
        radicals: &['｜', '⺅', '夂', '⺡', '攵', '月'],
    },
    Decomposition {
        kanji: '滭',
        radicals: &['｜', '二', '十', '口', '⺡', '⺾', '里'],
    },
    Decomposition {
        kanji: '滮',
        radicals: &['几', '匕', '卜', '厂', '彡', '⺡', '虍'],
    },
    Decomposition {
        kanji: '滹',
        radicals: &['一', '丶', 'ノ', '亅', '丷', '匕', '卜', '厂', '⺡', '虍'],
    },
    Decomposition {
        kanji: '滻',
        radicals: &['丶', 'ノ', '亠', '丷', '厂', '⺡', '生'],
    },
    Decomposition {
        kanji: '滽',
        radicals: &['｜', '二', '冂', '广', 'ヨ', '⺡', '聿'],
    },
    Decomposition {
        kanji: '漄',
        radicals: &['厂', '土', '山', '⺡'],
    },
    Decomposition {
        kanji: '漈',
        radicals: &['丶', '二', '夕', '小', '⺡', '示'],
    },
    Decomposition {
        kanji: '漊',
        radicals: &['一', '｜', '口', '女', '⺡', '日'],
    },
    Decomposition {
        kanji: '漌',
        radicals: &['二', '十', '口', '廾', '⺡', '革'],
    },
    Decomposition {
        kanji: '漍',
        radicals: &['一', '口', '囗', '⺡', '戈'],
    },
    Decomposition {
        kanji: '漖',
        radicals: &['ノ', '土', '子', '⺡', '⺹', '攵'],
    },
    Decomposition {
        kanji: '漘',
        radicals: &['亠', '厂', '⺡', '月', '衣', '辰'],
    },
    Decomposition {
        kanji: '漚',
        radicals: &['匚', '口', '⺡'],
    },
    Decomposition {
        kanji: '漛',
        radicals: &['一', '丶', 'ノ', '丷', '大', '⺡', '水'],
    },
    Decomposition {
        kanji: '漦',
        radicals: &['一', '厂', '攵', '木', '水'],
    },
    Decomposition {
        kanji: '漩',
        radicals: &['一', 'ノ', '⺡', '方', '疋'],
    },
    Decomposition {
        kanji: '漪',
        radicals: &['亅', '口', '大', '⺡', '⺨'],
    },
    Decomposition {
        kanji: '漯',
        radicals: &['小', '幺', '⺡', '田', '糸'],
    },
    Decomposition {
        kanji: '漰',
        radicals: &['丶', '冂', '山', '⺡', '月'],
    },
    Decomposition {
        kanji: '漳',
        radicals: &['十', '⺡', '日', '立', '音'],
    },
    Decomposition {
        kanji: '漶',
        radicals: &['｜', '口', '⺡', '心'],
    },
    Decomposition {
        kanji: '漻',
        radicals: &['𠆢', '冫', '彡', '⺡', '羽'],
    },
    Decomposition {
        kanji: '漼',
        radicals: &['山', '⺡', '隹'],
    },
    Decomposition {
        kanji: '漭',
        radicals: &['丶', '大', '廾', '⺡', '⺾', '犬'],
    },
    Decomposition {
        kanji: '潏',
        radicals: &['ハ', '冂', 'マ', '口', '⺡', '矛'],
    },
    Decomposition {
        kanji: '潑',
        radicals: &['丶', 'ノ', '几', '又', '弓', '⺡', '殳'],
    },
    Decomposition {
        kanji: '潒',
        radicals: &['｜', 'ノ', '勹', '口', '⺡', '豕'],
    },
    Decomposition {
        kanji: '潓',
        radicals: &['一', '十', '厶', '⺡', '心', '日', '田', '虫'],
    },
    Decomposition {
        kanji: '潗',
        radicals: &['⺡', '木', '隹'],
    },
    Decomposition {
        kanji: '潙',
        radicals: &['ノ', '亅', '⺡', '⺣', '爪'],
    },
    Decomposition {
        kanji: '潚',
        radicals: &['｜', 'ヨ', '⺡', '爿', '片'],
    },
    Decomposition {
        kanji: '潝',
        radicals: &['一', '𠆢', '冫', '口', '⺡', '羽'],
    },
    Decomposition {
        kanji: '潞',
        radicals: &['口', '夂', '⺡', '止', '足'],
    },
    Decomposition {
        kanji: '潡',
        radicals: &['亠', '口', '子', '⺡', '攵'],
    },
    Decomposition {
        kanji: '潢',
        radicals: &['ハ', '⺡', '田', '黄'],
    },
    Decomposition {
        kanji: '潨',
        radicals: &['｜', '丶', 'ノ', '⺡', '皿', '⺲'],
    },
    Decomposition {
        kanji: '潬',
        radicals: &['十', '口', '⺡', '日', '田'],
    },
    Decomposition {
        kanji: '潽',
        radicals: &['｜', '二', '丷', '⺡', '日'],
    },
    Decomposition {
        kanji: '潾',
        radicals: &['夕', '⺡', '米', '舛'],
    },
    Decomposition {
        kanji: '澃',
        radicals: &['ハ', '彡', '水', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '澇',
        radicals: &['冖', '力', '⺡', '火'],
    },
    Decomposition {
        kanji: '澈',
        radicals: &['亠', '厶', '⺡', '攵', '月'],
    },
    Decomposition {
        kanji: '澋',
        radicals: &['亠', '口', '小', '⺡', '日'],
    },
    Decomposition {
        kanji: '澌',
        radicals: &['｜', '二', 'ハ', '⺡', '斤', '甘'],
    },
    Decomposition {
        kanji: '澍',
        radicals: &['一', '丷', '十', '口', '士', '寸', '⺡', '豆'],
    },
    Decomposition {
        kanji: '澐',
        radicals: &['一', '｜', '二', '冖', '厶', '⺡', '雨'],
    },
    Decomposition {
        kanji: '澒',
        radicals: &['ハ', '工', '⺡', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '澓',
        radicals: &['一', 'ノ', '夂', '彳', '⺡', '日', '曰'],
    },
    Decomposition {
        kanji: '澔',
        radicals: &['｜', 'ノ', '二', '口', '土', '⺡', '日', '牛', '白'],
    },
    Decomposition {
        kanji: '澖',
        radicals: &['⺡', '木', '門'],
    },
    Decomposition {
        kanji: '澚',
        radicals: &['一', 'ノ', '冂', '勹', '⺡', '米'],
    },
    Decomposition {
        kanji: '澟',
        radicals: &['ノ', '亠', '口', '囗', '⺡', '木', '禾'],
    },
    Decomposition {
        kanji: '澠',
        radicals: &['⺡', '黽'],
    },
    Decomposition {
        kanji: '澥',
        radicals: &['｜', '刀', '勹', '⺡', '月', '牛', '角'],
    },
    Decomposition {
        kanji: '澦',
        radicals: &['一', '亅', 'ハ', 'マ', '⺡', '目', '矛', '貝', '頁'],
    },
    Decomposition {
        kanji: '澧',
        radicals: &['｜', '丷', '口', '⺡', '日', '豆'],
    },
    Decomposition {
        kanji: '澨',
        radicals: &['人', '工', '⺡', '竹'],
    },
    Decomposition {
        kanji: '澮',
        radicals: &['一', '｜', '𠆢', '丷', '口', '⺡', '日'],
    },
    Decomposition {
        kanji: '澯',
        radicals: &['卜', '又', '夕', '⺡', '米'],
    },
    Decomposition {
        kanji: '澰',
        radicals: &['一', '人', '𠆢', '口', '⺡'],
    },
    Decomposition {
        kanji: '澵',
        radicals: &['一', '小', '⺡', '斤', '木', '立'],
    },
    Decomposition {
        kanji: '澶',
        radicals: &['一', '亠', '口', '囗', '⺡', '日'],
    },
    Decomposition {
        kanji: '澼',
        radicals: &['十', '口', '尸', '⺡', '立', '辛'],
    },
    Decomposition {
        kanji: '濅',
        radicals: &['｜', '冂', '冖', '又', '宀', '巾', 'ヨ', '⺡'],
    },
    Decomposition {
        kanji: '濇',
        radicals: &['人', '口', '囗', '土', '⺡'],
    },
    Decomposition {
        kanji: '濈',
        radicals: &['口', '⺡', '戈', '耳'],
    },
    Decomposition {
        kanji: '濊',
        radicals: &['ノ', '厂', '小', '⺡', '戈', '止'],
    },
    Decomposition {
        kanji: '濚',
        radicals: &['冖', '⺡', '木', '火'],
    },
    Decomposition {
        kanji: '濞',
        radicals: &['廾', '⺡', '田', '目', '自', '鼻'],
    },
    Decomposition {
        kanji: '濨',
        radicals: &['一', '丷', '幺', '⺡', '心'],
    },
    Decomposition {
        kanji: '濩',
        radicals: &['又', '⺡', '⺾', '隹'],
    },
    Decomposition {
        kanji: '濰',
        radicals: &['小', '幺', '⺡', '糸', '隹'],
    },
    Decomposition {
        kanji: '濵',
        radicals: &['｜', 'ハ', '宀', '尸', '⺡', '目', '貝'],
    },
    Decomposition {
        kanji: '濹',
        radicals: &['｜', '二', '丷', '口', '土', '⺡', '⺣', '里', '黒'],
    },
    Decomposition {
        kanji: '濼',
        radicals: &['幺', '⺡', '日', '木', '白'],
    },
    Decomposition {
        kanji: '濽',
        radicals: &['一', 'ハ', '大', '⺡', '目', '貝'],
    },
    Decomposition {
        kanji: '瀀',
        radicals: &['一', '冖', '夂', '⺡', '心', '目', '自'],
    },
    Decomposition {
        kanji: '瀅',
        radicals: &['丶', '冖', '⺡', '火', '王'],
    },
    Decomposition {
        kanji: '瀆',
        radicals: &['儿', 'ハ', '口', '士', '⺡', '目', '⺲', '貝'],
    },
    Decomposition {
        kanji: '瀇',
        radicals: &['ハ', '广', '⺡', '田', '黄'],
    },
    Decomposition {
        kanji: '瀍',
        radicals: &['儿', 'ハ', '土', '广', '⺡', '里'],
    },
    Decomposition {
        kanji: '瀗',
        radicals: &['一', '｜', '二', '宀', '⺡', '心', '⺲'],
    },
    Decomposition {
        kanji: '瀠',
        radicals: &['冖', '小', '幺', '⺡', '水', '糸'],
    },
    Decomposition {
        kanji: '瀣',
        radicals: &['一', '卜', '又', '夕', '⺡', '非'],
    },
    Decomposition {
        kanji: '瀯',
        radicals: &['冖', '口', '⺡', '火'],
    },
    Decomposition {
        kanji: '瀴',
        radicals: &['ハ', '女', '⺡', '目', '貝'],
    },
    Decomposition {
        kanji: '瀷',
        radicals: &['｜', '二', 'ハ', '冫', '⺡', '田', '羽'],
    },
    Decomposition {
        kanji: '瀹',
        radicals: &['一', '｜', '亅', '𠆢', '冂', '口', '⺡', '冊', '龠', '廾'],
    },
    Decomposition {
        kanji: '瀼',
        radicals: &['一', '｜', '二', '亠', '口', '⺡', '衣'],
    },
    Decomposition {
        kanji: '灃',
        radicals: &['一', '｜', '丷', '口', '山', '⺡', '豆'],
    },
    Decomposition {
        kanji: '灄',
        radicals: &['⺡', '耳'],
    },
    Decomposition {
        kanji: '灈',
        radicals: &['⺡', '目', '隹'],
    },
    Decomposition {
        kanji: '灉',
        radicals: &['乙', '口', '巛', '已', '⺡', '⻏', '巴', '隹'],
    },
    Decomposition {
        kanji: '灊',
        radicals: &['一', '｜', '儿', '丷', '冂', '口', '⺡', '无', '鬲'],
    },
    Decomposition {
        kanji: '灋',
        radicals: &['一', '｜', '亅', '厶', '土', '广', '⺡', '⺣'],
    },
    Decomposition {
        kanji: '灔',
        radicals: &[
            '｜', '乙', '丷', '勹', '口', '已', '⺡', '日', '巴', '色', '豆',
        ],
    },
    Decomposition {
        kanji: '灕',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '厶', '⺡', '⽱', '隹'],
    },
    Decomposition {
        kanji: '灝',
        radicals: &['亠', 'ハ', '口', '小', '⺡', '日', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '灞',
        radicals: &[
            '一', '｜', '二', '冖', '十', '口', '廾', '⺡', '月', '雨', '革',
        ],
    },
    Decomposition {
        kanji: '灎',
        radicals: &['｜', '丷', '厶', '口', '土', '⺡', '日', '皿', '豆'],
    },
    Decomposition {
        kanji: '灤',
        radicals: &['小', '幺', '⺡', '木', '糸', '言'],
    },
    Decomposition {
        kanji: '灥',
        radicals: &['日', '水', '白'],
    },
    Decomposition {
        kanji: '灬',
        radicals: &['⺣'],
    },
    Decomposition {
        kanji: '灮',
        radicals: &['儿', '火'],
    },
    Decomposition {
        kanji: '灵',
        radicals: &['ヨ', '火'],
    },
    Decomposition {
        kanji: '灶',
        radicals: &['土', '火'],
    },
    Decomposition {
        kanji: '灾',
        radicals: &['宀', '火'],
    },
    Decomposition {
        kanji: '炁',
        radicals: &['无', '⺣'],
    },
    Decomposition {
        kanji: '炅',
        radicals: &['日', '火'],
    },
    Decomposition {
        kanji: '炆',
        radicals: &['文', '火'],
    },
    Decomposition {
        kanji: '炔',
        radicals: &['人', 'ユ', '火'],
    },
    Decomposition {
        kanji: '炕',
        radicals: &['亠', '几', '火'],
    },
    Decomposition {
        kanji: '炖',
        radicals: &['ノ', '乙', '凵', '火', '屯'],
    },
    Decomposition {
        kanji: '炗',
        radicals: &['一', '凵', '火'],
    },
    Decomposition {
        kanji: '炘',
        radicals: &['斤', '火'],
    },
    Decomposition {
        kanji: '炛',
        radicals: &['ノ', '乙', '⺅', '匕', '火'],
    },
    Decomposition {
        kanji: '炤',
        radicals: &['刀', '口', '火'],
    },
    Decomposition {
        kanji: '炫',
        radicals: &['亠', '幺', '火', '玄'],
    },
    Decomposition {
        kanji: '炰',
        radicals: &['勹', '已', '⺣'],
    },
    Decomposition {
        kanji: '炱',
        radicals: &['厶', '口', '火'],
    },
    Decomposition {
        kanji: '炴',
        radicals: &['口', '大', '火'],
    },
    Decomposition {
        kanji: '炷',
        radicals: &['丶', '亠', '土', '火', '王'],
    },
    Decomposition {
        kanji: '烊',
        radicals: &['丷', '火', '王', '羊'],
    },
    Decomposition {
        kanji: '烑',
        radicals: &['丶', 'ノ', '儿', '冫', '火'],
    },
    Decomposition {
        kanji: '烓',
        radicals: &['土', '火'],
    },
    Decomposition {
        kanji: '烔',
        radicals: &['一', '冂', '口', '火'],
    },
    Decomposition {
        kanji: '烕',
        radicals: &['一', 'ノ', '厂', '戈', '火'],
    },
    Decomposition {
        kanji: '烖',
        radicals: &['土', '戈', '火'],
    },
    Decomposition {
        kanji: '烘',
        radicals: &['｜', '二', 'ハ', '火'],
    },
    Decomposition {
        kanji: '烜',
        radicals: &['一', '日', '火'],
    },
    Decomposition {
        kanji: '烤',
        radicals: &['一', 'ノ', '勹', '土', '⺹', '火'],
    },
    Decomposition {
        kanji: '烺',
        radicals: &['丶', '火', '艮'],
    },
    Decomposition {
        kanji: '焃',
        radicals: &['土', '火', '赤'],
    },
    Decomposition {
        kanji: '焄',
        radicals: &['ノ', '口', 'ヨ', '⺣'],
    },
    Decomposition {
        kanji: '焅',
        radicals: &['ノ', '口', '土', '火'],
    },
    Decomposition {
        kanji: '焆',
        radicals: &['口', '月', '火'],
    },
    Decomposition {
        kanji: '焇',
        radicals: &['小', '⺌', '月', '火'],
    },
    Decomposition {
        kanji: '焋',
        radicals: &['士', '火', '爿'],
    },
    Decomposition {
        kanji: '焌',
        radicals: &['儿', 'ハ', '厶', '夂', '火'],
    },
    Decomposition {
        kanji: '焏',
        radicals: &['一', '亅', '又', '口', '⺣'],
    },
    Decomposition {
        kanji: '焞',
        radicals: &['亠', '口', '子', '火'],
    },
    Decomposition {
        kanji: '焠',
        radicals: &['亠', '人', '十', '火'],
    },
    Decomposition {
        kanji: '焫',
        radicals: &['人', '入', '冂', '⺾', '火'],
    },
    Decomposition {
        kanji: '焭',
        radicals: &['冖', '几', '火'],
    },
    Decomposition {
        kanji: '焯',
        radicals: &['十', '卜', '日', '火'],
    },
    Decomposition {
        kanji: '焰',
        radicals: &['勹', '火', '臼'],
    },
    Decomposition {
        kanji: '焱',
        radicals: &['火'],
    },
    Decomposition {
        kanji: '焸',
        radicals: &['日', '曰', '火'],
    },
    Decomposition {
        kanji: '煁',
        radicals: &['一', '｜', 'ハ', '匚', '火', '甘'],
    },
    Decomposition {
        kanji: '煅',
        radicals: &['一', '｜', 'ノ', '几', '又', '殳', '火'],
    },
    Decomposition {
        kanji: '煆',
        radicals: &['一', '｜', '又', '火'],
    },
    Decomposition {
        kanji: '煇',
        radicals: &['冖', '火', '車'],
    },
    Decomposition {
        kanji: '煊',
        radicals: &['一', '宀', '日', '火'],
    },
    Decomposition {
        kanji: '煋',
        radicals: &['日', '曰', '火', '生'],
    },
    Decomposition {
        kanji: '煐',
        radicals: &['口', '大', '⺾', '火'],
    },
    Decomposition {
        kanji: '煒',
        radicals: &['口', '火', '韋'],
    },
    Decomposition {
        kanji: '煗',
        radicals: &['大', '火', '而'],
    },
    Decomposition {
        kanji: '煚',
        radicals: &['一', '匚', '日', '曰', '火'],
    },
    Decomposition {
        kanji: '煜',
        radicals: &['日', '火', '立'],
    },
    Decomposition {
        kanji: '煞',
        radicals: &['勹', 'ヨ', '攵', '⺣'],
    },
    Decomposition {
        kanji: '煠',
        radicals: &['一', '｜', '木', '火', '世'],
    },
    Decomposition {
        kanji: '煨',
        radicals: &['火', '田', '衣'],
    },
    Decomposition {
        kanji: '煹',
        radicals: &['一', '｜', '二', '月', '火'],
    },
    Decomposition {
        kanji: '熀',
        radicals: &['一', '儿', '⺌', '日', '火'],
    },
    Decomposition {
        kanji: '熅',
        radicals: &['人', '口', '火', '皿'],
    },
    Decomposition {
        kanji: '熇',
        radicals: &['亠', '冂', '口', '火', '高'],
    },
    Decomposition {
        kanji: '熌',
        radicals: &['人', '火', '門'],
    },
    Decomposition {
        kanji: '熒',
        radicals: &['冖', '火'],
    },
    Decomposition {
        kanji: '熚',
        radicals: &['一', '｜', '凵', '口', '火', '里'],
    },
    Decomposition {
        kanji: '熛',
        radicals: &['二', '小', '火', '示', '西'],
    },
    Decomposition {
        kanji: '熠',
        radicals: &['冫', '日', '火', '白', '羽'],
    },
    Decomposition {
        kanji: '熢',
        radicals: &['一', '｜', '二', '⻌', '夂', '火'],
    },
    Decomposition {
        kanji: '熯',
        radicals: &['一', '丶', 'ノ', '十', '口', '大', '廾', '火', '革'],
    },
    Decomposition {
        kanji: '熰',
        radicals: &['匚', '口', '火'],
    },
    Decomposition {
        kanji: '熲',
        radicals: &['ハ', '匕', '火', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '熳',
        radicals: &['又', '日', '火', '⺲'],
    },
    Decomposition {
        kanji: '熺',
        radicals: &['一', '丷', '十', '口', '士', '火', '豆'],
    },
    Decomposition {
        kanji: '熿',
        radicals: &['ハ', '火', '田', '黄'],
    },
    Decomposition {
        kanji: '燀',
        radicals: &['十', '口', '日', '火', '田'],
    },
    Decomposition {
        kanji: '燁',
        radicals: &['一', '｜', '⺾', '火'],
    },
    Decomposition {
        kanji: '燄',
        radicals: &['勹', '火', '臼'],
    },
    Decomposition {
        kanji: '燋',
        radicals: &['火', '⺣', '隹'],
    },
    Decomposition {
        kanji: '燌',
        radicals: &['ハ', '十', '⺾', '火', '目', '貝'],
    },
    Decomposition {
        kanji: '燓',
        radicals: &['木', '火', '爻'],
    },
    Decomposition {
        kanji: '燖',
        radicals: &['口', '寸', '工', 'ヨ', '火'],
    },
    Decomposition {
        kanji: '燙',
        radicals: &['一', 'ノ', '勹', '⺡', '日', '火', '勿'],
    },
    Decomposition {
        kanji: '燚',
        radicals: &['火'],
    },
    Decomposition {
        kanji: '燜',
        radicals: &['心', '火', '門'],
    },
    Decomposition {
        kanji: '燸',
        radicals: &['一', '｜', '二', '冖', '火', '而', '雨'],
    },
    Decomposition {
        kanji: '燾',
        radicals: &['一', '口', '士', '寸', '工', '⺣'],
    },
    Decomposition {
        kanji: '爀',
        radicals: &['土', '火', '赤'],
    },
    Decomposition {
        kanji: '爇',
        radicals: &['丶', '儿', 'ハ', '九', '土', '⺾', '⺣'],
    },
    Decomposition {
        kanji: '爈',
        radicals: &['匕', '卜', '厂', '心', '火', '田', '虍'],
    },
    Decomposition {
        kanji: '爉',
        radicals: &['丶', 'ノ', '乙', '口', '川', '巛', '火'],
    },
    Decomposition {
        kanji: '爓',
        radicals: &['勹', '火', '臼', '門'],
    },
    Decomposition {
        kanji: '爗',
        radicals: &['一', '｜', '二', '⺾', '日', '火'],
    },
    Decomposition {
        kanji: '爚',
        radicals: &['一', '｜', '亅', '𠆢', '冂', '口', '火', '冊', '龠', '廾'],
    },
    Decomposition {
        kanji: '爝',
        radicals: &['一', '厶', '寸', '日', '火', '爪', '⺲'],
    },
    Decomposition {
        kanji: '爟',
        radicals: &['一', '｜', '卜', '口', '⺾', '火', '隹'],
    },
    Decomposition {
        kanji: '爤',
        radicals: &['丷', '口', '⺾', '木', '火', '門'],
    },
    Decomposition {
        kanji: '爫',
        radicals: &['爪'],
    },
    Decomposition {
        kanji: '爯',
        radicals: &['一', '｜', '冂', '十', '月', '爪'],
    },
    Decomposition {
        kanji: '爴',
        radicals: &['一', '口', '囗', '戈', '爪'],
    },
    Decomposition {
        kanji: '爸',
        radicals: &['乙', '已', '父', '巴'],
    },
    Decomposition {
        kanji: '爹',
        radicals: &['夕', '父'],
    },
    Decomposition {
        kanji: '牁',
        radicals: &['一', '亅', '口', '爿'],
    },
    Decomposition {
        kanji: '牂',
        radicals: &['丷', '爿', '王', '羊'],
    },
    Decomposition {
        kanji: '牃',
        radicals: &['一', '｜', '木', '爿', '世'],
    },
    Decomposition {
        kanji: '牅',
        radicals: &['｜', '二', '冂', '广', 'ヨ', '爿', '聿'],
    },
    Decomposition {
        kanji: '牎',
        radicals: &['丶', 'ノ', '勹', '心', '片', '勿'],
    },
    Decomposition {
        kanji: '牏',
        radicals: &['一', '丶', 'ノ', '𠆢', '冂', '⺉', '月', '片'],
    },
    Decomposition {
        kanji: '牐',
        radicals: &['ノ', '十', '片', '臼'],
    },
    Decomposition {
        kanji: '牓',
        radicals: &['亠', '丷', '冖', '方', '片', '立'],
    },
    Decomposition {
        kanji: '牕',
        radicals: &['ノ', '口', '囗', '夂', '心', '片'],
    },
    Decomposition {
        kanji: '牖',
        radicals: &['一', '丶', '十', '尸', '戸', '月', '片'],
    },
    Decomposition {
        kanji: '牚',
        radicals: &['冖', '口', '⺌', '牙'],
    },
    Decomposition {
        kanji: '牜',
        radicals: &['牛'],
    },
    Decomposition {
        kanji: '牞',
        radicals: &['力', '牛'],
    },
    Decomposition {
        kanji: '牠',
        radicals: &['｜', '乙', '匕', '也', '牛'],
    },
    Decomposition {
        kanji: '牣',
        radicals: &['ノ', '刀', '牛'],
    },
    Decomposition {
        kanji: '牨',
        radicals: &['亠', '几', '牛'],
    },
    Decomposition {
        kanji: '牫',
        radicals: &['戈', '牛'],
    },
    Decomposition {
        kanji: '牮',
        radicals: &['⺅', '戈', '牛'],
    },
    Decomposition {
        kanji: '牯',
        radicals: &['十', '口', '牛'],
    },
    Decomposition {
        kanji: '牱',
        radicals: &['一', '亅', '口', '牛'],
    },
    Decomposition {
        kanji: '牷',
        radicals: &['𠆢', '牛', '王'],
    },
    Decomposition {
        kanji: '牸',
        radicals: &['子', '宀', '牛'],
    },
    Decomposition {
        kanji: '牻',
        radicals: &['丶', '尢', '彡', '牛', '尤'],
    },
    Decomposition {
        kanji: '牼',
        radicals: &['一', '巛', '工', '牛'],
    },
    Decomposition {
        kanji: '牿',
        radicals: &['ノ', '口', '土', '牛'],
    },
    Decomposition {
        kanji: '犄',
        radicals: &['一', '亅', '口', '大', '牛'],
    },
    Decomposition {
        kanji: '犉',
        radicals: &['亠', '口', '子', '牛'],
    },
    Decomposition {
        kanji: '犍',
        radicals: &['｜', '二', '廴', 'ヨ', '牛', '聿'],
    },
    Decomposition {
        kanji: '犎',
        radicals: &['土', '寸', '牛'],
    },
    Decomposition {
        kanji: '犓',
        radicals: &['勹', '屮', '牛'],
    },
    Decomposition {
        kanji: '犛',
        radicals: &['一', '厂', '攵', '木', '牛'],
    },
    Decomposition {
        kanji: '犨',
        radicals: &['牛', '隹'],
    },
    Decomposition {
        kanji: '犭',
        radicals: &['⺨'],
    },
    Decomposition {
        kanji: '犮',
        radicals: &['丶', 'ノ', '又', '大', '弋', '犬'],
    },
    Decomposition {
        kanji: '犱',
        radicals: &['丶', '九', '⺨'],
    },
    Decomposition {
        kanji: '犴',
        radicals: &['一', '十', '干', '⺨'],
    },
    Decomposition {
        kanji: '犾',
        radicals: &['丶', '大', '⺨', '犬'],
    },
    Decomposition {
        kanji: '狁',
        radicals: &['儿', '厶', '⺨'],
    },
    Decomposition {
        kanji: '狇',
        radicals: &['⺨', '木'],
    },
    Decomposition {
        kanji: '狉',
        radicals: &['一', '｜', '丶', 'ノ', '⺨'],
    },
    Decomposition {
        kanji: '狌',
        radicals: &['⺨', '生'],
    },
    Decomposition {
        kanji: '狕',
        radicals: &['力', '幺', '⺨'],
    },
    Decomposition {
        kanji: '狖',
        radicals: &['ハ', '宀', '⺨'],
    },
    Decomposition {
        kanji: '狘',
        radicals: &['⺨', '戈'],
    },
    Decomposition {
        kanji: '狟',
        radicals: &['一', '⺨', '日', '曰'],
    },
    Decomposition {
        kanji: '狥',
        radicals: &['勹', '⺨', '日'],
    },
    Decomposition {
        kanji: '狳',
        radicals: &['一', '丶', 'ノ', '亅', '二', '𠆢', '小', '⺨'],
    },
    Decomposition {
        kanji: '狴',
        radicals: &['匕', '土', '⺨', '比'],
    },
    Decomposition {
        kanji: '狺',
        radicals: &['⺨', '言'],
    },
    Decomposition {
        kanji: '狻',
        radicals: &['儿', 'ハ', '厶', '夂', '⺨'],
    },
    Decomposition {
        kanji: '狾',
        radicals: &['扌', '⺨', '斤'],
    },
    Decomposition {
        kanji: '猂',
        radicals: &['一', '十', '干', '⺨', '日'],
    },
    Decomposition {
        kanji: '猄',
        radicals: &['亠', '口', '小', '⺨'],
    },
    Decomposition {
        kanji: '猅',
        radicals: &['⺨', '非'],
    },
    Decomposition {
        kanji: '猇',
        radicals: &['儿', '几', '匕', '卜', '厂', '⺨', '虍'],
    },
    Decomposition {
        kanji: '猋',
        radicals: &['丶', '大', '犬'],
    },
    Decomposition {
        kanji: '猍',
        radicals: &['人', '⺨', '木'],
    },
    Decomposition {
        kanji: '猒',
        radicals: &['丶', '大', '日', '月', '犬'],
    },
    Decomposition {
        kanji: '猓',
        radicals: &['一', '｜', '口', '⺨', '木', '田'],
    },
    Decomposition {
        kanji: '猘',
        radicals: &['一', '｜', 'ノ', '冂', '⺉', '巾', '⺨', '牛'],
    },
    Decomposition {
        kanji: '猙',
        radicals: &['亅', 'ヨ', '⺨', '爪'],
    },
    Decomposition {
        kanji: '猞',
        radicals: &['一', '𠆢', '十', '口', '干', '⺨'],
    },
    Decomposition {
        kanji: '猢',
        radicals: &['十', '口', '⺨', '月'],
    },
    Decomposition {
        kanji: '猤',
        radicals: &['一', '丶', 'ノ', '大', '⺨'],
    },
    Decomposition {
        kanji: '猧',
        radicals: &['冂', '口', '⺨'],
    },
    Decomposition {
        kanji: '猨',
        radicals: &['ノ', '二', '又', '⺨', '爪'],
    },
    Decomposition {
        kanji: '猬',
        radicals: &['⺨', '月', '田'],
    },
    Decomposition {
        kanji: '猱',
        radicals: &['マ', '⺨', '木', '矛'],
    },
    Decomposition {
        kanji: '猲',
        radicals: &['人', '勹', '⺨', '日', '曰'],
    },
    Decomposition {
        kanji: '猵',
        radicals: &['一', '｜', '丶', '亅', '冂', '尸', '⺨', '冊', '廾'],
    },
    Decomposition {
        kanji: '猺',
        radicals: &['丶', '凵', '夕', '山', '⺨', '爪', '缶'],
    },
    Decomposition {
        kanji: '猻',
        radicals: &['子', '小', '幺', '⺨', '糸'],
    },
    Decomposition {
        kanji: '猽',
        radicals: &['亠', 'ハ', '冖', '⺨', '日'],
    },
    Decomposition {
        kanji: '獃',
        radicals: &['丶', '丷', '口', '大', '山', '犬', '豆'],
    },
    Decomposition {
        kanji: '獍',
        radicals: &['儿', '⺨', '日', '立', '音'],
    },
    Decomposition {
        kanji: '獐',
        radicals: &['十', '⺨', '日', '立', '音'],
    },
    Decomposition {
        kanji: '獒',
        radicals: &['丶', '土', '士', '大', '攵', '方', '犬'],
    },
    Decomposition {
        kanji: '獖',
        radicals: &['ハ', '十', '⺨', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '獘',
        radicals: &['｜', '丶', 'ハ', '丷', '冂', '大', '攵', '犬'],
    },
    Decomposition {
        kanji: '獝',
        radicals: &['ハ', '冂', 'マ', '口', '⺨', '矛'],
    },
    Decomposition {
        kanji: '獞',
        radicals: &['⺨', '立', '里'],
    },
    Decomposition {
        kanji: '獟',
        radicals: &['一', '儿', '土', '⺨'],
    },
    Decomposition {
        kanji: '獠',
        radicals: &['丶', 'ノ', '大', '小', '⺨', '日', '曰'],
    },
    Decomposition {
        kanji: '獦',
        radicals: &['人', '勹', '⺨', '⺾', '日'],
    },
    Decomposition {
        kanji: '獧',
        radicals: &['一', '口', '⺨', '⺲', '衣'],
    },
    Decomposition {
        kanji: '獩',
        radicals: &['一', 'ノ', '厂', '小', '⺨', '戈', '止'],
    },
    Decomposition {
        kanji: '獫',
        radicals: &['一', '人', '𠆢', '口', '⺨'],
    },
    Decomposition {
        kanji: '獬',
        radicals: &['｜', '刀', '勹', '⺨', '月', '牛', '角'],
    },
    Decomposition {
        kanji: '獮',
        radicals: &['一', '｜', 'ハ', '冂', '⺨', '爻'],
    },
    Decomposition {
        kanji: '獯',
        radicals: &['一', '｜', 'ノ', '二', '丷', '⺨', '⺣'],
    },
    Decomposition {
        kanji: '獱',
        radicals: &['一', '｜', 'ノ', 'ハ', '宀', '⺨', '目', '貝'],
    },
    Decomposition {
        kanji: '獷',
        radicals: &['ハ', '广', '⺨', '田', '黄'],
    },
    Decomposition {
        kanji: '獹',
        radicals: &['匕', '卜', '厂', '⺨', '田', '皿', '虍'],
    },
    Decomposition {
        kanji: '獼',
        radicals: &['一', '｜', 'ハ', '冂', '弓', '⺨', '爻'],
    },
    Decomposition {
        kanji: '玀',
        radicals: &['小', '幺', '⺨', '⺲', '糸', '隹'],
    },
    Decomposition {
        kanji: '玁',
        radicals: &['一', '｜', '厂', '口', '⺨', '攵', '耳'],
    },
    Decomposition {
        kanji: '玃',
        radicals: &['又', '⺨', '目', '隹'],
    },
    Decomposition {
        kanji: '玅',
        radicals: &['ノ', '亠', '小', '幺', '玄'],
    },
    Decomposition {
        kanji: '玆',
        radicals: &['亠', '幺', '玄'],
    },
    Decomposition {
        kanji: '玎',
        radicals: &['一', '亅', '王'],
    },
    Decomposition {
        kanji: '玐',
        radicals: &['ハ', '王'],
    },
    Decomposition {
        kanji: '玓',
        radicals: &['丶', '勹', '王'],
    },
    Decomposition {
        kanji: '玕',
        radicals: &['一', '十', '干', '王'],
    },
    Decomposition {
        kanji: '玗',
        radicals: &['亅', '二', '王'],
    },
    Decomposition {
        kanji: '玘',
        radicals: &['已', '王'],
    },
    Decomposition {
        kanji: '玜',
        radicals: &['ハ', '厶', '王'],
    },
    Decomposition {
        kanji: '玞',
        radicals: &['一', '大', '王'],
    },
    Decomposition {
        kanji: '玟',
        radicals: &['文', '王'],
    },
    Decomposition {
        kanji: '玠',
        radicals: &['｜', 'ノ', '𠆢', '王'],
    },
    Decomposition {
        kanji: '玢',
        radicals: &['ハ', '刀', '王'],
    },
    Decomposition {
        kanji: '玥',
        radicals: &['月', '王'],
    },
    Decomposition {
        kanji: '玦',
        radicals: &['人', 'ユ', '王'],
    },
    Decomposition {
        kanji: '玪',
        radicals: &['丶', '𠆢', '王'],
    },
    Decomposition {
        kanji: '玫',
        radicals: &['攵', '王'],
    },
    Decomposition {
        kanji: '玭',
        radicals: &['匕', '比', '王'],
    },
    Decomposition {
        kanji: '玵',
        radicals: &['王', '甘'],
    },
    Decomposition {
        kanji: '玷',
        radicals: &['卜', '口', '王'],
    },
    Decomposition {
        kanji: '玹',
        radicals: &['亠', '幺', '王', '玄'],
    },
    Decomposition {
        kanji: '玼',
        radicals: &['匕', '止', '王'],
    },
    Decomposition {
        kanji: '玽',
        radicals: &['勹', '口', '王'],
    },
    Decomposition {
        kanji: '玿',
        radicals: &['刀', '口', '王'],
    },
    Decomposition {
        kanji: '珅',
        radicals: &['｜', '日', '王'],
    },
    Decomposition {
        kanji: '珆',
        radicals: &['厶', '口', '王'],
    },
    Decomposition {
        kanji: '珉',
        radicals: &['尸', '氏', '王'],
    },
    Decomposition {
        kanji: '珋',
        radicals: &['｜', 'ノ', '卩', '王'],
    },
    Decomposition {
        kanji: '珌',
        radicals: &['ノ', '心', '王'],
    },
    Decomposition {
        kanji: '珏',
        radicals: &['丶', '王'],
    },
    Decomposition {
        kanji: '珒',
        radicals: &['｜', '二', 'ヨ', '王', '聿'],
    },
    Decomposition {
        kanji: '珓',
        radicals: &['亠', '父', '王'],
    },
    Decomposition {
        kanji: '珖',
        radicals: &['一', '儿', '⺌', '王'],
    },
    Decomposition {
        kanji: '珙',
        radicals: &['｜', '二', 'ハ', '王'],
    },
    Decomposition {
        kanji: '珝',
        radicals: &['冫', '王', '羽'],
    },
    Decomposition {
        kanji: '珡',
        radicals: &['𠆢', '王'],
    },
    Decomposition {
        kanji: '珣',
        radicals: &['勹', '日', '王'],
    },
    Decomposition {
        kanji: '珦',
        radicals: &['ノ', '冂', '口', '王'],
    },
    Decomposition {
        kanji: '珧',
        radicals: &['丶', 'ノ', '儿', '冫', '王'],
    },
    Decomposition {
        kanji: '珩',
        radicals: &['彳', '王', '行'],
    },
    Decomposition {
        kanji: '珴',
        radicals: &['戈', '手', '王'],
    },
    Decomposition {
        kanji: '珵',
        radicals: &['ノ', '口', '土', '王'],
    },
    Decomposition {
        kanji: '珷',
        radicals: &['一', '弋', '止', '王'],
    },
    Decomposition {
        kanji: '珹',
        radicals: &['ノ', '亅', '厂', '戈', '王'],
    },
    Decomposition {
        kanji: '珺',
        radicals: &['ノ', '口', 'ヨ', '王'],
    },
    Decomposition {
        kanji: '珻',
        radicals: &['一', 'ノ', '王', '毋', '母'],
    },
    Decomposition {
        kanji: '珽',
        radicals: &['ノ', '土', '士', '廴', '王'],
    },
    Decomposition {
        kanji: '珿',
        radicals: &['口', '王', '足'],
    },
    Decomposition {
        kanji: '琀',
        radicals: &['丶', '𠆢', '口', '王'],
    },
    Decomposition {
        kanji: '琁',
        radicals: &['一', 'ノ', '王', '疋'],
    },
    Decomposition {
        kanji: '琄',
        radicals: &['口', '月', '王'],
    },
    Decomposition {
        kanji: '琇',
        radicals: &['ノ', '乃', '木', '王', '禾'],
    },
    Decomposition {
        kanji: '琊',
        radicals: &['⻏', '王', '牙'],
    },
    Decomposition {
        kanji: '琑',
        radicals: &['⺌', '月', '王'],
    },
    Decomposition {
        kanji: '琚',
        radicals: &['十', '口', '尸', '王'],
    },
    Decomposition {
        kanji: '琛',
        radicals: &['儿', 'ハ', '冖', '木', '王'],
    },
    Decomposition {
        kanji: '琤',
        radicals: &['亅', '勹', 'ヨ', '爪', '王'],
    },
    Decomposition {
        kanji: '琦',
        radicals: &['一', '亅', '口', '大', '王'],
    },
    Decomposition {
        kanji: '琨',
        radicals: &['匕', '日', '比', '王'],
    },
    Decomposition {
        kanji: '琩',
        radicals: &['日', '王'],
    },
    Decomposition {
        kanji: '琪',
        radicals: &['｜', '二', 'ハ', '王', '甘'],
    },
    Decomposition {
        kanji: '琫',
        radicals: &['一', '｜', '二', '大'],
    },
    Decomposition {
        kanji: '琬',
        radicals: &['卩', '夕', '宀', '王'],
    },
    Decomposition {
        kanji: '琭',
        radicals: &['ヨ', '水', '王'],
    },
    Decomposition {
        kanji: '琮',
        radicals: &['二', '宀', '小', '王', '示'],
    },
    Decomposition {
        kanji: '琯',
        radicals: &['｜', '口', '宀', '王'],
    },
    Decomposition {
        kanji: '琰',
        radicals: &['火', '王'],
    },
    Decomposition {
        kanji: '琱',
        radicals: &['冂', '口', '土', '王'],
    },
    Decomposition {
        kanji: '琹',
        radicals: &['木', '王'],
    },
    Decomposition {
        kanji: '瑀',
        radicals: &['ノ', '冂', '厶', '王', '⽱', '虫'],
    },
    Decomposition {
        kanji: '瑃',
        radicals: &['一', '二', '大', '日', '王'],
    },
    Decomposition {
        kanji: '瑄',
        radicals: &['一', '宀', '日', '王'],
    },
    Decomposition {
        kanji: '瑆',
        radicals: &['日', '王', '生'],
    },
    Decomposition {
        kanji: '瑇',
        radicals: &['一', '｜', '二', '王', '毋', '母'],
    },
    Decomposition {
        kanji: '瑋',
        radicals: &['口', '王', '韋'],
    },
    Decomposition {
        kanji: '瑍',
        radicals: &['儿', 'ハ', '冂', '勹', '大', '王'],
    },
    Decomposition {
        kanji: '瑑',
        radicals: &['ヨ', '彑', '王', '豕'],
    },
    Decomposition {
        kanji: '瑒',
        radicals: &['一', 'ノ', '勹', '日', '王', '勿'],
    },
    Decomposition {
        kanji: '瑗',
        radicals: &['ノ', '二', '又', '爪', '王'],
    },
    Decomposition {
        kanji: '瑝',
        radicals: &['日', '王', '白'],
    },
    Decomposition {
        kanji: '瑢',
        radicals: &['𠆢', 'ハ', '口', '宀', '王', '谷'],
    },
    Decomposition {
        kanji: '瑦',
        radicals: &['⺣', '王', '鳥'],
    },
    Decomposition {
        kanji: '瑧',
        radicals: &['一', 'ノ', '二', '大', '木', '王', '禾'],
    },
    Decomposition {
        kanji: '瑨',
        radicals: &['｜', '丶', 'ノ', '二', '日', '曰', '王'],
    },
    Decomposition {
        kanji: '瑫',
        radicals: &['爪', '王', '臼'],
    },
    Decomposition {
        kanji: '瑭',
        radicals: &['｜', '口', '广', 'ヨ', '王'],
    },
    Decomposition {
        kanji: '瑮',
        radicals: &['木', '王', '西'],
    },
    Decomposition {
        kanji: '瑱',
        radicals: &['一', 'ハ', '匕', '十', '王', '目'],
    },
    Decomposition {
        kanji: '瑲',
        radicals: &['一', '丶', '𠆢', '口', '尸', '王'],
    },
    Decomposition {
        kanji: '璀',
        radicals: &['山', '王', '隹'],
    },
    Decomposition {
        kanji: '璁',
        radicals: &['ノ', '口', '夂', '心', '王'],
    },
    Decomposition {
        kanji: '璅',
        radicals: &['巛', '木', '王', '田'],
    },
    Decomposition {
        kanji: '璆',
        radicals: &['𠆢', '冫', '彡', '王', '羽'],
    },
    Decomposition {
        kanji: '璇',
        radicals: &['一', 'ノ', '方', '王', '疋'],
    },
    Decomposition {
        kanji: '璉',
        radicals: &['⻌', '王', '車'],
    },
    Decomposition {
        kanji: '璏',
        radicals: &['一', 'ノ', '匕', '大', 'ヨ', '彑', '王', '矢'],
    },
    Decomposition {
        kanji: '璐',
        radicals: &['口', '夂', '止', '王', '足'],
    },
    Decomposition {
        kanji: '璑',
        radicals: &['一', '｜', 'ノ', '⺣', '王', '無'],
    },
    Decomposition {
        kanji: '璒',
        radicals: &['丶', 'ノ', 'ハ', '丷', '口', '王', '豆'],
    },
    Decomposition {
        kanji: '璘',
        radicals: &['夕', '王', '米', '舛'],
    },
    Decomposition {
        kanji: '璙',
        radicals: &['丶', 'ノ', '大', '小', '日', '王'],
    },
    Decomposition {
        kanji: '璚',
        radicals: &['ハ', '冂', 'マ', '口', '王', '矛'],
    },
    Decomposition {
        kanji: '璜',
        radicals: &['ハ', '王', '田', '黄'],
    },
    Decomposition {
        kanji: '璟',
        radicals: &['亠', '口', '小', '日', '王'],
    },
    Decomposition {
        kanji: '璠',
        radicals: &['ノ', '王', '田', '米'],
    },
    Decomposition {
        kanji: '璡',
        radicals: &['⻌', '王', '隹'],
    },
    Decomposition {
        kanji: '璣',
        radicals: &['人', '幺', '戈', '王'],
    },
    Decomposition {
        kanji: '璦',
        radicals: &['冖', '夂', '心', '爪', '王'],
    },
    Decomposition {
        kanji: '璨',
        radicals: &['卜', '又', '夕', '王', '米'],
    },
    Decomposition {
        kanji: '璩',
        radicals: &['匕', '卜', '厂', '王', '虍', '豕'],
    },
    Decomposition {
        kanji: '璪',
        radicals: &['口', '木', '王'],
    },
    Decomposition {
        kanji: '璫',
        radicals: &['冖', '口', '⺌', '王', '田'],
    },
    Decomposition {
        kanji: '璮',
        radicals: &['一', '亠', '口', '囗', '日', '曰', '王'],
    },
    Decomposition {
        kanji: '璯',
        radicals: &['一', '｜', '𠆢', '丷', '口', '日', '王'],
    },
    Decomposition {
        kanji: '璱',
        radicals: &['ノ', '心', '王'],
    },
    Decomposition {
        kanji: '璲',
        radicals: &['丷', '⻌', '王', '豕'],
    },
    Decomposition {
        kanji: '璵',
        radicals: &['一', '｜', 'ハ', '王'],
    },
    Decomposition {
        kanji: '璹',
        radicals: &['一', '口', '士', '寸', '工', '王'],
    },
    Decomposition {
        kanji: '璻',
        radicals: &['ノ', '亠', '人', '冫', '十', '王', '羽'],
    },
    Decomposition {
        kanji: '璿',
        radicals: &['一', '𠆢', 'ハ', '冖', '卜', '王', '目'],
    },
    Decomposition {
        kanji: '瓈',
        radicals: &['ノ', '𠆢', '勹', '木', '水', '王', '禾'],
    },
    Decomposition {
        kanji: '瓉',
        radicals: &['一', 'ハ', '大', '王', '目', '貝'],
    },
    Decomposition {
        kanji: '瓌',
        radicals: &['一', '｜', '丶', 'ノ', '亠', '冫', '王', '⺲', '衣'],
    },
    Decomposition {
        kanji: '瓐',
        radicals: &['匕', '卜', '厂', '王', '田', '皿', '虍'],
    },
    Decomposition {
        kanji: '瓓',
        radicals: &['丷', '口', '木', '王', '門'],
    },
    Decomposition {
        kanji: '瓘',
        radicals: &['口', '⺾', '王', '隹'],
    },
    Decomposition {
        kanji: '瓚',
        radicals: &['ノ', '儿', 'ハ', '土', '王', '目', '貝'],
    },
    Decomposition {
        kanji: '瓛',
        radicals: &[
            '丶', '儿', '冂', '匕', '卜', '厂', '口', '大', '犬', '王', '虍', '鬲',
        ],
    },
    Decomposition {
        kanji: '瓞',
        radicals: &['一', '丶', 'ノ', '二', '厶', '大', '瓜'],
    },
    Decomposition {
        kanji: '瓟',
        radicals: &['勹', '厶', '已', '瓜'],
    },
    Decomposition {
        kanji: '瓤',
        radicals: &['一', '｜', '二', '亠', '厶', '口', '瓜', '衣'],
    },
    Decomposition {
        kanji: '瓨',
        radicals: &['一', '丶', '乙', '工'],
    },
    Decomposition {
        kanji: '瓪',
        radicals: &['一', '丶', 'ノ', '乙', '又'],
    },
    Decomposition {
        kanji: '瓫',
        radicals: &['一', '丶', '乙', 'ハ', '刀'],
    },
    Decomposition {
        kanji: '瓯',
        radicals: &['一', '丶', 'ノ', '乙', '匚'],
    },
    Decomposition {
        kanji: '瓴',
        radicals: &['一', '｜', '丶', '乙', '亅', '𠆢', 'マ'],
    },
    Decomposition {
        kanji: '瓺',
        radicals: &['一', '｜', '丶', '乙', '厶'],
    },
    Decomposition {
        kanji: '瓻',
        radicals: &['一', '｜', '丶', 'ノ', '乙', '冂', '巾'],
    },
    Decomposition {
        kanji: '瓼',
        radicals: &['一', '丶', '乙', '里'],
    },
    Decomposition {
        kanji: '瓿',
        radicals: &['一', '丶', '乙', '口', '立'],
    },
    Decomposition {
        kanji: '甆',
        radicals: &['一', '丶', '乙', '丷', '幺'],
    },
    Decomposition {
        kanji: '甒',
        radicals: &['一', '｜', '丶', 'ノ', '乙', '⺣', '無'],
    },
    Decomposition {
        kanji: '甖',
        radicals: &['一', '丶', '乙', 'ハ', '目', '貝'],
    },
    Decomposition {
        kanji: '甗',
        radicals: &[
            '一', '丶', '乙', '儿', '冂', '匕', '卜', '厂', '口', '虍', '鬲',
        ],
    },
    Decomposition {
        kanji: '甠',
        radicals: &['日', '生'],
    },
    Decomposition {
        kanji: '甡',
        radicals: &['生'],
    },
    Decomposition {
        kanji: '甤',
        radicals: &['生', '豕'],
    },
    Decomposition {
        kanji: '甧',
        radicals: &['月', '生'],
    },
    Decomposition {
        kanji: '甩',
        radicals: &['乙', '二', '冂', '月'],
    },
    Decomposition {
        kanji: '甪',
        radicals: &['ノ', '用'],
    },
    Decomposition {
        kanji: '甯',
        radicals: &['宀', '心', '用'],
    },
    Decomposition {
        kanji: '甶',
        radicals: &['ノ', '田'],
    },
    Decomposition {
        kanji: '甹',
        radicals: &['一', '｜', '勹', '日', '田'],
    },
    Decomposition {
        kanji: '甽',
        radicals: &['川', '田'],
    },
    Decomposition {
        kanji: '甾',
        radicals: &['巛', '田'],
    },
    Decomposition {
        kanji: '甿',
        radicals: &['亠', '亡', '田'],
    },
    Decomposition {
        kanji: '畀',
        radicals: &['廾', '田'],
    },
    Decomposition {
        kanji: '畃',
        radicals: &['｜', '丶', '勹', '日'],
    },
    Decomposition {
        kanji: '畇',
        radicals: &['一', '丶', '勹', '田'],
    },
    Decomposition {
        kanji: '畈',
        radicals: &['ノ', '厂', '又', '田'],
    },
    Decomposition {
        kanji: '畎',
        radicals: &['丶', '大', '犬', '田'],
    },
    Decomposition {
        kanji: '畐',
        radicals: &['一', '口', '田'],
    },
    Decomposition {
        kanji: '畒',
        radicals: &['亠', '人', '田'],
    },
    Decomposition {
        kanji: '畗',
        radicals: &['亠', '口', '田'],
    },
    Decomposition {
        kanji: '畞',
        radicals: &['十', '夂', '田'],
    },
    Decomposition {
        kanji: '畟',
        radicals: &['ハ', '夂', '田'],
    },
    Decomposition {
        kanji: '畡',
        radicals: &['ノ', '亠', '幺', '玄', '田'],
    },
    Decomposition {
        kanji: '畯',
        radicals: &['儿', 'ハ', '厶', '夂', '田'],
    },
    Decomposition {
        kanji: '畱',
        radicals: &['一', '｜', '田'],
    },
    Decomposition {
        kanji: '畹',
        radicals: &['卩', '夕', '宀', '田'],
    },
    Decomposition {
        kanji: '畺',
        radicals: &['一', '田'],
    },
    Decomposition {
        kanji: '畻',
        radicals: &['一', '丷', '土', '大', '田'],
    },
    Decomposition {
        kanji: '畼',
        radicals: &['一', 'ノ', '勹', '日', '曰', '勿', '田'],
    },
    Decomposition {
        kanji: '畽',
        radicals: &['一', 'ノ', '田', '車'],
    },
    Decomposition {
        kanji: '畾',
        radicals: &['田'],
    },
    Decomposition {
        kanji: '疁',
        radicals: &['𠆢', '冫', '彡', '田', '羽'],
    },
    Decomposition {
        kanji: '疅',
        radicals: &['一', '田'],
    },
    Decomposition {
        kanji: '疐',
        radicals: &['冖', '十', '田', '疋'],
    },
    Decomposition {
        kanji: '疒',
        radicals: &['⽧'],
    },
    Decomposition {
        kanji: '疓',
        radicals: &['乃', '⽧'],
    },
    Decomposition {
        kanji: '疕',
        radicals: &['匕', '⽧'],
    },
    Decomposition {
        kanji: '疙',
        radicals: &['一', 'ノ', '乙', '⽧'],
    },
    Decomposition {
        kanji: '疜',
        radicals: &['一', '卜', '⽧'],
    },
    Decomposition {
        kanji: '疢',
        radicals: &['火', '⽧'],
    },
    Decomposition {
        kanji: '疤',
        radicals: &['乙', '已', '巴', '⽧'],
    },
    Decomposition {
        kanji: '疴',
        radicals: &['一', '亅', '口', '⽧'],
    },
    Decomposition {
        kanji: '疺',
        radicals: &['丶', 'ノ', '乙', '⽧'],
    },
    Decomposition {
        kanji: '疿',
        radicals: &['廾', '弓', '⽧'],
    },
    Decomposition {
        kanji: '痀',
        radicals: &['勹', '口', '⽧'],
    },
    Decomposition {
        kanji: '痁',
        radicals: &['卜', '口', '⽧'],
    },
    Decomposition {
        kanji: '痄',
        radicals: &['一', '｜', 'ノ', '⽧'],
    },
    Decomposition {
        kanji: '痆',
        radicals: &['匕', '尸', '⽧'],
    },
    Decomposition {
        kanji: '痌',
        radicals: &['一', '冂', '口', '⽧'],
    },
    Decomposition {
        kanji: '痎',
        radicals: &['ノ', '亠', '幺', '玄', '⽧'],
    },
    Decomposition {
        kanji: '痏',
        radicals: &['一', 'ノ', '月', '⽧'],
    },
    Decomposition {
        kanji: '痗',
        radicals: &['一', 'ノ', '毋', '⽧', '母'],
    },
    Decomposition {
        kanji: '痜',
        radicals: &['ノ', '几', '木', '⽧', '禾'],
    },
    Decomposition {
        kanji: '痟',
        radicals: &['小', '⺌', '月', '⽧'],
    },
    Decomposition {
        kanji: '痠',
        radicals: &['儿', 'ハ', '厶', '夂', '⽧'],
    },
    Decomposition {
        kanji: '痡',
        radicals: &['一', '｜', '丶', '月', '⽧'],
    },
    Decomposition {
        kanji: '痤',
        radicals: &['人', '土', '⽧'],
    },
    Decomposition {
        kanji: '痧',
        radicals: &['ノ', '小', '⺡', '⽧'],
    },
    Decomposition {
        kanji: '痬',
        radicals: &['ノ', '勹', '日', '勿', '⽧'],
    },
    Decomposition {
        kanji: '痮',
        radicals: &['⽧', '長'],
    },
    Decomposition {
        kanji: '痯',
        radicals: &['｜', '口', '宀', '⽧'],
    },
    Decomposition {
        kanji: '痱',
        radicals: &['⽧', '非'],
    },
    Decomposition {
        kanji: '痹',
        radicals: &['廾', '田', '⽧'],
    },
    Decomposition {
        kanji: '瘀',
        radicals: &['丶', '𠆢', '方', '⽧'],
    },
    Decomposition {
        kanji: '瘂',
        radicals: &['一', '｜', '⽧'],
    },
    Decomposition {
        kanji: '瘃',
        radicals: &['丶', '⽧', '豕'],
    },
    Decomposition {
        kanji: '瘄',
        radicals: &['｜', '二', '日', '⽧'],
    },
    Decomposition {
        kanji: '瘇',
        radicals: &['一', 'ノ', '⽧', '車'],
    },
    Decomposition {
        kanji: '瘈',
        radicals: &['一', '｜', '刀', '大', '⽧'],
    },
    Decomposition {
        kanji: '瘊',
        radicals: &['一', 'ノ', '⺅', 'ユ', '大', '⽧', '矢'],
    },
    Decomposition {
        kanji: '瘌',
        radicals: &['⺉', '口', '木', '⽧'],
    },
    Decomposition {
        kanji: '瘏',
        radicals: &['ノ', '土', '⺹', '日', '⽧'],
    },
    Decomposition {
        kanji: '瘒',
        radicals: &['冖', '⽧', '車'],
    },
    Decomposition {
        kanji: '瘓',
        radicals: &['儿', 'ハ', '冂', '勹', '大', '⽧'],
    },
    Decomposition {
        kanji: '瘕',
        radicals: &['一', '｜', '又', '口', '⽧'],
    },
    Decomposition {
        kanji: '瘖',
        radicals: &['日', '⽧', '立', '音'],
    },
    Decomposition {
        kanji: '瘙',
        radicals: &['丶', '又', '⽧', '虫'],
    },
    Decomposition {
        kanji: '瘛',
        radicals: &['一', '｜', '刀', '彡', '心', '⽧'],
    },
    Decomposition {
        kanji: '瘜',
        radicals: &['心', '⽧', '目', '自'],
    },
    Decomposition {
        kanji: '瘝',
        radicals: &['｜', '丶', 'ノ', '⽧', '⺲'],
    },
    Decomposition {
        kanji: '瘞',
        radicals: &['人', '土', '大', '⽧'],
    },
    Decomposition {
        kanji: '瘣',
        radicals: &['儿', '匕', '厶', '田', '⽧', '鬼'],
    },
    Decomposition {
        kanji: '瘥',
        radicals: &['一', 'ノ', '二', '丷', '工', '王', '⽧'],
    },
    Decomposition {
        kanji: '瘦',
        radicals: &['十', '又', '支', '⽧', '臼'],
    },
    Decomposition {
        kanji: '瘩',
        radicals: &['一', '𠆢', '口', '⺾', '⽧'],
    },
    Decomposition {
        kanji: '瘭',
        radicals: &['二', '小', '⽧', '示', '西'],
    },
    Decomposition {
        kanji: '瘲',
        radicals: &['人', '彳', '止', '⽧'],
    },
    Decomposition {
        kanji: '瘳',
        radicals: &['ノ', '𠆢', '冫', '彡', '⽧', '羽'],
    },
    Decomposition {
        kanji: '瘵',
        radicals: &['丶', '二', '夕', '小', '⽧', '示'],
    },
    Decomposition {
        kanji: '瘸',
        radicals: &['入', '冂', '力', '口', '⽧', '肉'],
    },
    Decomposition {
        kanji: '瘹',
        radicals: &['丶', '勹', '⽧', '金'],
    },
    Decomposition {
        kanji: '瘺',
        radicals: &['尸', '⽧', '雨'],
    },
    Decomposition {
        kanji: '瘼',
        radicals: &['大', '⺾', '日', '⽧'],
    },
    Decomposition {
        kanji: '癊',
        radicals: &['一', '丶', '𠆢', '厶', 'ユ', '⻖', '⽧'],
    },
    Decomposition {
        kanji: '癀',
        radicals: &['ハ', '田', '⽧', '黄'],
    },
    Decomposition {
        kanji: '癁',
        radicals: &['一', 'ノ', '夂', '彳', '日', '⽧'],
    },
    Decomposition {
        kanji: '癃',
        radicals: &['一', '夂', '⻖', '生', '⽧'],
    },
    Decomposition {
        kanji: '癄',
        radicals: &['⺣', '⽧', '隹'],
    },
    Decomposition {
        kanji: '癅',
        radicals: &['一', '｜', '田', '⽧'],
    },
    Decomposition {
        kanji: '癉',
        radicals: &['十', '口', '日', '田', '⽧'],
    },
    Decomposition {
        kanji: '癋',
        radicals: &['一', '｜', '二', '心', '⽧'],
    },
    Decomposition {
        kanji: '癕',
        radicals: &['亠', '幺', '⽧', '隹'],
    },
    Decomposition {
        kanji: '癙',
        radicals: &['⽧', '臼', '鼠'],
    },
    Decomposition {
        kanji: '癟',
        radicals: &['一', '｜', '亅', '𠆢', '冂', '⽧', '目', '冊', '自', '廾'],
    },
    Decomposition {
        kanji: '癤',
        radicals: &['匕', '卩', '厶', '日', '⽧', '白', '竹'],
    },
    Decomposition {
        kanji: '癥',
        radicals: &['一', '山', '彳', '攵', '王', '⽧'],
    },
    Decomposition {
        kanji: '癭',
        radicals: &['ハ', '女', '⽧', '目', '貝'],
    },
    Decomposition {
        kanji: '癮',
        radicals: &['工', 'ヨ', '⻖', '心', '爪', '⽧'],
    },
    Decomposition {
        kanji: '癯',
        radicals: &['⽧', '目', '隹'],
    },
    Decomposition {
        kanji: '癱',
        radicals: &['丶', 'ノ', '二', '十', '口', '大', '廾', '⽧', '隹', '革'],
    },
    Decomposition {
        kanji: '癴',
        radicals: &['小', '幺', '手', '⽧', '糸', '言'],
    },
    Decomposition {
        kanji: '皁',
        radicals: &['十', '日', '白'],
    },
    Decomposition {
        kanji: '皅',
        radicals: &['乙', '已', '日', '巴', '白'],
    },
    Decomposition {
        kanji: '皌',
        radicals: &['一', '日', '木', '白'],
    },
    Decomposition {
        kanji: '皍',
        radicals: &['匕', '卩', '日', '白'],
    },
    Decomposition {
        kanji: '皕',
        radicals: &['一', '日', '白'],
    },
    Decomposition {
        kanji: '皛',
        radicals: &['日', '白'],
    },
    Decomposition {
        kanji: '皜',
        radicals: &['亠', '冂', '口', '日', '白', '高'],
    },
    Decomposition {
        kanji: '皝',
        radicals: &['一', '儿', '⺌', '日', '王', '白'],
    },
    Decomposition {
        kanji: '皟',
        radicals: &['一', '｜', '二', 'ハ', '日', '白', '目', '貝'],
    },
    Decomposition {
        kanji: '皠',
        radicals: &['山', '日', '白', '隹'],
    },
    Decomposition {
        kanji: '皢',
        radicals: &['一', '儿', '土', '日', '白'],
    },
    Decomposition {
        kanji: '皣',
        radicals: &['一', '｜', '二', '⺾', '日', '白'],
    },
    Decomposition {
        kanji: '皤',
        radicals: &['ノ', '日', '田', '白', '米'],
    },
    Decomposition {
        kanji: '皥',
        radicals: &['｜', '丶', 'ノ', '二', '冫', '日', '白', '目', '自'],
    },
    Decomposition {
        kanji: '皦',
        radicals: &['攵', '方', '日', '白'],
    },
    Decomposition {
        kanji: '皧',
        radicals: &['冖', '夂', '心', '日', '爪', '白'],
    },
    Decomposition {
        kanji: '皨',
        radicals: &['土', '日', '白'],
    },
    Decomposition {
        kanji: '皪',
        radicals: &['幺', '日', '木', '白'],
    },
    Decomposition {
        kanji: '皭',
        radicals: &['一', '厶', '寸', '日', '爪', '白', '⺲'],
    },
    Decomposition {
        kanji: '皽',
        radicals: &['一', 'ノ', '亠', '十', '又', '口', '囗', '支', '日'],
    },
    Decomposition {
        kanji: '盁',
        radicals: &['乃', '皿'],
    },
    Decomposition {
        kanji: '盅',
        radicals: &['｜', '口', '皿'],
    },
    Decomposition {
        kanji: '盉',
        radicals: &['ノ', '木', '皿', '禾'],
    },
    Decomposition {
        kanji: '盋',
        radicals: &['又', '弋', '皿'],
    },
    Decomposition {
        kanji: '盌',
        radicals: &['卩', '夕', '皿'],
    },
    Decomposition {
        kanji: '盎',
        radicals: &['口', '大', '皿'],
    },
    Decomposition {
        kanji: '盔',
        radicals: &['一', 'ノ', '火', '皿'],
    },
    Decomposition {
        kanji: '盙',
        radicals: &['丶', '十', '月', '皿'],
    },
    Decomposition {
        kanji: '盠',
        radicals: &['ヨ', '彑', '皿', '豕'],
    },
    Decomposition {
        kanji: '盦',
        radicals: &['一', '丶', '𠆢', '皿', '酉'],
    },
    Decomposition {
        kanji: '盨',
        radicals: &['ハ', '彡', '皿', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '盬',
        radicals: &['一', 'ノ', '匚', '十', '口', '干', '皿', '臣'],
    },
    Decomposition {
        kanji: '盰',
        radicals: &['一', '十', '干', '目'],
    },
    Decomposition {
        kanji: '盱',
        radicals: &['亅', '二', '目'],
    },
    Decomposition {
        kanji: '盶',
        radicals: &['二', '儿', '元', '目'],
    },
    Decomposition {
        kanji: '盹',
        radicals: &['ノ', '乙', '凵', '屯', '目'],
    },
    Decomposition {
        kanji: '盼',
        radicals: &['ハ', '刀', '目'],
    },
    Decomposition {
        kanji: '眀',
        radicals: &['月', '目'],
    },
    Decomposition {
        kanji: '眆',
        radicals: &['方', '目'],
    },
    Decomposition {
        kanji: '眊',
        radicals: &['一', 'ノ', '乙', '目'],
    },
    Decomposition {
        kanji: '眎',
        radicals: &['二', '小', '目', '示'],
    },
    Decomposition {
        kanji: '眒',
        radicals: &['｜', '日', '目'],
    },
    Decomposition {
        kanji: '眔',
        radicals: &['｜', '丶', 'ノ', '⺲'],
    },
    Decomposition {
        kanji: '眕',
        radicals: &['𠆢', '彡', '目'],
    },
    Decomposition {
        kanji: '眗',
        radicals: &['勹', '口', '目'],
    },
    Decomposition {
        kanji: '眙',
        radicals: &['厶', '口', '目'],
    },
    Decomposition {
        kanji: '眚',
        radicals: &['生', '目'],
    },
    Decomposition {
        kanji: '眜',
        radicals: &['一', '木', '目'],
    },
    Decomposition {
        kanji: '眢',
        radicals: &['卩', '夕', '目'],
    },
    Decomposition {
        kanji: '眨',
        radicals: &['丶', 'ノ', '乙', '目'],
    },
    Decomposition {
        kanji: '眭',
        radicals: &['土', '目'],
    },
    Decomposition {
        kanji: '眮',
        radicals: &['一', '冂', '口', '目'],
    },
    Decomposition {
        kanji: '眯',
        radicals: &['目', '米'],
    },
    Decomposition {
        kanji: '眴',
        radicals: &['勹', '日', '目'],
    },
    Decomposition {
        kanji: '眵',
        radicals: &['夕', '目'],
    },
    Decomposition {
        kanji: '眶',
        radicals: &['匚', '王', '目'],
    },
    Decomposition {
        kanji: '眹',
        radicals: &['一', 'ハ', '丷', '大', '目'],
    },
    Decomposition {
        kanji: '眽',
        radicals: &['丶', 'ノ', '目'],
    },
    Decomposition {
        kanji: '眾',
        radicals: &['｜', 'ノ', '人', '⺅', '⺲'],
    },
    Decomposition {
        kanji: '睂',
        radicals: &['｜', '𠆢', '厂', '目'],
    },
    Decomposition {
        kanji: '睅',
        radicals: &['一', '十', '干', '日', '目'],
    },
    Decomposition {
        kanji: '睆',
        radicals: &['二', '儿', '宀', '元', '目'],
    },
    Decomposition {
        kanji: '睊',
        radicals: &['口', '月', '目'],
    },
    Decomposition {
        kanji: '睍',
        radicals: &['儿', '目', '見'],
    },
    Decomposition {
        kanji: '睎',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '巾', '目'],
    },
    Decomposition {
        kanji: '睏',
        radicals: &['囗', '木', '目'],
    },
    Decomposition {
        kanji: '睒',
        radicals: &['火', '目'],
    },
    Decomposition {
        kanji: '睖',
        radicals: &['ハ', '土', '夂', '目'],
    },
    Decomposition {
        kanji: '睗',
        radicals: &['ノ', '勹', '日', '曰', '勿', '目'],
    },
    Decomposition {
        kanji: '睜',
        radicals: &['亅', 'ヨ', '爪', '目'],
    },
    Decomposition {
        kanji: '睞',
        radicals: &['人', '木', '目'],
    },
    Decomposition {
        kanji: '睟',
        radicals: &['亠', '人', '十', '目'],
    },
    Decomposition {
        kanji: '睠',
        radicals: &['一', '丶', 'ノ', 'ハ', '丷', '卩', '大', '目'],
    },
    Decomposition {
        kanji: '睢',
        radicals: &['目', '隹'],
    },
    Decomposition {
        kanji: '睤',
        radicals: &['廾', '田', '目'],
    },
    Decomposition {
        kanji: '睧',
        radicals: &['日', '氏', '目'],
    },
    Decomposition {
        kanji: '睪',
        radicals: &['一', '丷', '十', '土', '干', '⺲'],
    },
    Decomposition {
        kanji: '睬',
        radicals: &['木', '爪', '目'],
    },
    Decomposition {
        kanji: '睰',
        radicals: &['一', 'ノ', '口', '⺾', '目'],
    },
    Decomposition {
        kanji: '睲',
        radicals: &['日', '生', '目'],
    },
    Decomposition {
        kanji: '睳',
        radicals: &['土', '大', '目'],
    },
    Decomposition {
        kanji: '睴',
        radicals: &['冖', '目', '車'],
    },
    Decomposition {
        kanji: '睺',
        radicals: &['一', 'ノ', '⺅', 'ユ', '大', '目', '矢'],
    },
    Decomposition {
        kanji: '睽',
        radicals: &['一', '丶', 'ノ', '大', '目'],
    },
    Decomposition {
        kanji: '瞀',
        radicals: &['マ', '攵', '目', '矛'],
    },
    Decomposition {
        kanji: '瞄',
        radicals: &['⺾', '田', '目'],
    },
    Decomposition {
        kanji: '瞌',
        radicals: &['厶', '土', '皿', '目'],
    },
    Decomposition {
        kanji: '瞍',
        radicals: &['十', '又', '支', '目', '臼'],
    },
    Decomposition {
        kanji: '瞔',
        radicals: &['一', '｜', '二', 'ハ', '目', '貝'],
    },
    Decomposition {
        kanji: '瞕',
        radicals: &['十', '日', '目', '立', '音'],
    },
    Decomposition {
        kanji: '瞖',
        radicals: &['一', 'ノ', '几', '匚', '又', '大', '殳', '目', '矢'],
    },
    Decomposition {
        kanji: '瞚',
        radicals: &['一', '｜', 'ハ', '宀', '日', '田', '目'],
    },
    Decomposition {
        kanji: '瞟',
        radicals: &['二', '小', '目', '示', '西'],
    },
    Decomposition {
        kanji: '瞢',
        radicals: &['冖', '⺾', '目', '⺲'],
    },
    Decomposition {
        kanji: '瞧',
        radicals: &['⺣', '目', '隹'],
    },
    Decomposition {
        kanji: '瞪',
        radicals: &['丶', 'ノ', '丷', '口', '目', '豆'],
    },
    Decomposition {
        kanji: '瞮',
        radicals: &['亠', '厶', '攵', '月', '目'],
    },
    Decomposition {
        kanji: '瞯',
        radicals: &['月', '目', '門'],
    },
    Decomposition {
        kanji: '瞱',
        radicals: &['｜', '二', '⺾', '目'],
    },
    Decomposition {
        kanji: '瞵',
        radicals: &['夕', '目', '米', '舛'],
    },
    Decomposition {
        kanji: '瞾',
        radicals: &['儿', 'ハ', '宀', '工', '目'],
    },
    Decomposition {
        kanji: '矃',
        radicals: &['一', '亅', '宀', '心', '皿', '目'],
    },
    Decomposition {
        kanji: '矉',
        radicals: &['一', '｜', 'ノ', 'ハ', '宀', '目', '貝'],
    },
    Decomposition {
        kanji: '矑',
        radicals: &['匕', '卜', '厂', '田', '皿', '目', '虍'],
    },
    Decomposition {
        kanji: '矒',
        radicals: &['冖', '⺾', '目', '⺲'],
    },
    Decomposition {
        kanji: '矕',
        radicals: &['小', '幺', '目', '糸', '言'],
    },
    Decomposition {
        kanji: '矙',
        radicals: &['ユ', '攵', '目', '耳', '門'],
    },
    Decomposition {
        kanji: '矞',
        radicals: &['儿', 'ハ', '冂', 'マ', '口', '矛'],
    },
    Decomposition {
        kanji: '矟',
        radicals: &['マ', '⺌', '月', '矛'],
    },
    Decomposition {
        kanji: '矠',
        radicals: &['｜', '二', 'マ', '日', '矛'],
    },
    Decomposition {
        kanji: '矤',
        radicals: &['一', 'ノ', '大', '弓', '矢'],
    },
    Decomposition {
        kanji: '矦',
        radicals: &['一', 'ノ', '勹', '厂', '大', '矢'],
    },
    Decomposition {
        kanji: '矪',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '大', '矢', '舟'],
    },
    Decomposition {
        kanji: '矬',
        radicals: &['一', 'ノ', '人', '土', '大', '矢'],
    },
    Decomposition {
        kanji: '矰',
        radicals: &['一', '｜', 'ノ', 'ハ', '丷', '口', '大', '日', '矢'],
    },
    Decomposition {
        kanji: '矱',
        radicals: &['一', 'ノ', '又', '大', '⺾', '矢', '隹'],
    },
    Decomposition {
        kanji: '矴',
        radicals: &['一', '亅', '口', '石'],
    },
    Decomposition {
        kanji: '矸',
        radicals: &['一', '十', '口', '干', '石'],
    },
    Decomposition {
        kanji: '矻',
        radicals: &['一', 'ノ', '乙', '口', '石'],
    },
    Decomposition {
        kanji: '砅',
        radicals: &['口', '水', '石'],
    },
    Decomposition {
        kanji: '砆',
        radicals: &['一', '口', '大', '石'],
    },
    Decomposition {
        kanji: '砉',
        radicals: &['一', '｜', '二', '口', '彡', '石'],
    },
    Decomposition {
        kanji: '砍',
        radicals: &['人', '勹', '口', '欠', '石'],
    },
    Decomposition {
        kanji: '砎',
        radicals: &['｜', 'ノ', '𠆢', '口', '石'],
    },
    Decomposition {
        kanji: '砑',
        radicals: &['口', '石', '牙'],
    },
    Decomposition {
        kanji: '砝',
        radicals: &['厶', '口', '土', '石'],
    },
    Decomposition {
        kanji: '砡',
        radicals: &['丶', '口', '王', '石'],
    },
    Decomposition {
        kanji: '砢',
        radicals: &['一', '亅', '口', '石'],
    },
    Decomposition {
        kanji: '砣',
        radicals: &['匕', '口', '宀', '石'],
    },
    Decomposition {
        kanji: '砭',
        radicals: &['｜', '丶', 'ノ', '乙', '口', '石'],
    },
    Decomposition {
        kanji: '砮',
        radicals: &['又', '口', '女', '石'],
    },
    Decomposition {
        kanji: '砰',
        radicals: &['一', 'ハ', '丷', '十', '口', '干', '石'],
    },
    Decomposition {
        kanji: '砵',
        radicals: &['一', '口', '木', '石'],
    },
    Decomposition {
        kanji: '砷',
        radicals: &['｜', '口', '日', '田', '石'],
    },
    Decomposition {
        kanji: '硃',
        radicals: &['一', 'ノ', '口', '木', '石'],
    },
    Decomposition {
        kanji: '硄',
        radicals: &['一', '儿', '口', '⺌', '石'],
    },
    Decomposition {
        kanji: '硇',
        radicals: &['丶', 'ノ', '口', '囗', '石'],
    },
    Decomposition {
        kanji: '硈',
        radicals: &['口', '士', '石'],
    },
    Decomposition {
        kanji: '硌',
        radicals: &['口', '夂', '石'],
    },
    Decomposition {
        kanji: '硎',
        radicals: &['一', '⺉', '口', '廾', '石'],
    },
    Decomposition {
        kanji: '硒',
        radicals: &['口', '石', '西'],
    },
    Decomposition {
        kanji: '硜',
        radicals: &['一', '口', '巛', '工', '石'],
    },
    Decomposition {
        kanji: '硞',
        radicals: &['口', '土', '石'],
    },
    Decomposition {
        kanji: '硠',
        radicals: &['丶', '口', '石', '艮'],
    },
    Decomposition {
        kanji: '硡',
        radicals: &['一', 'ノ', '厶', '口', '宀', '石'],
    },
    Decomposition {
        kanji: '硣',
        radicals: &['ノ', '口', '土', '子', '⺹', '石'],
    },
    Decomposition {
        kanji: '硤',
        radicals: &['人', '口', '大', '石'],
    },
    Decomposition {
        kanji: '硨',
        radicals: &['口', '石', '車'],
    },
    Decomposition {
        kanji: '硪',
        radicals: &['口', '戈', '手', '石'],
    },
    Decomposition {
        kanji: '确',
        radicals: &['｜', '勹', '口', '月', '石', '角'],
    },
    Decomposition {
        kanji: '硺',
        radicals: &['丶', '口', '石', '豕'],
    },
    Decomposition {
        kanji: '硾',
        radicals: &['一', '｜', 'ノ', '二', '口', '石'],
    },
    Decomposition {
        kanji: '碊',
        radicals: &['口', '戈', '石'],
    },
    Decomposition {
        kanji: '碏',
        radicals: &['｜', '二', '口', '日', '曰', '石'],
    },
    Decomposition {
        kanji: '碔',
        radicals: &['一', '口', '弋', '止', '石'],
    },
    Decomposition {
        kanji: '碘',
        radicals: &['一', '｜', 'ハ', '口', '日', '石'],
    },
    Decomposition {
        kanji: '碡',
        radicals: &['一', '｜', '二', '口', '毋', '石', '母'],
    },
    Decomposition {
        kanji: '碝',
        radicals: &['口', '大', '石', '而'],
    },
    Decomposition {
        kanji: '碞',
        radicals: &['口', '石'],
    },
    Decomposition {
        kanji: '碟',
        radicals: &['一', '｜', '口', '木', '石', '世'],
    },
    Decomposition {
        kanji: '碤',
        radicals: &['口', '大', '⺾', '石'],
    },
    Decomposition {
        kanji: '碨',
        radicals: &['口', '田', '石', '衣'],
    },
    Decomposition {
        kanji: '碬',
        radicals: &['一', '｜', '又', '口', '石'],
    },
    Decomposition {
        kanji: '碭',
        radicals: &['一', 'ノ', '勹', '口', '日', '勿', '石'],
    },
    Decomposition {
        kanji: '碰',
        radicals: &['｜', '丶', 'ノ', '二', '丷', '口', '石'],
    },
    Decomposition {
        kanji: '碱',
        radicals: &['一', 'ノ', '厂', '口', '戈', '石'],
    },
    Decomposition {
        kanji: '碲',
        radicals: &['｜', '亠', '丷', '冂', '冖', '口', '巾', '石', '立'],
    },
    Decomposition {
        kanji: '碳',
        radicals: &['一', 'ノ', '口', '山', '火', '石'],
    },
    Decomposition {
        kanji: '碻',
        radicals: &['亠', '冂', '口', '石', '高'],
    },
    Decomposition {
        kanji: '碽',
        radicals: &['ハ', '口', '工', '目', '石', '貝'],
    },
    Decomposition {
        kanji: '碿',
        radicals: &['口', '⺌', '尸', '月', '石'],
    },
    Decomposition {
        kanji: '磇',
        radicals: &['丶', 'ノ', '匕', '口', '囗', '比', '石'],
    },
    Decomposition {
        kanji: '磈',
        radicals: &['儿', '匕', '厶', '口', '田', '石', '鬼'],
    },
    Decomposition {
        kanji: '磉',
        radicals: &['又', '口', '木', '石'],
    },
    Decomposition {
        kanji: '磌',
        radicals: &['一', 'ハ', '匕', '十', '口', '目', '石', '貝'],
    },
    Decomposition {
        kanji: '磎',
        radicals: &['口', '大', '幺', '爪', '石'],
    },
    Decomposition {
        kanji: '磒',
        radicals: &['ハ', '口', '目', '石', '貝'],
    },
    Decomposition {
        kanji: '磓',
        radicals: &['｜', 'ノ', '⻌', '口', '石'],
    },
    Decomposition {
        kanji: '磕',
        radicals: &['厶', '口', '土', '皿', '石'],
    },
    Decomposition {
        kanji: '磖',
        radicals: &['冫', '口', '日', '白', '石', '羽'],
    },
    Decomposition {
        kanji: '磤',
        radicals: &['ノ', '亅', '几', '又', '口', 'ヨ', '殳', '石'],
    },
    Decomposition {
        kanji: '磛',
        radicals: &['口', '斤', '石', '車'],
    },
    Decomposition {
        kanji: '磟',
        radicals: &['𠆢', '冫', '口', '彡', '石', '羽'],
    },
    Decomposition {
        kanji: '磠',
        radicals: &['丶', 'ノ', '十', '卜', '口', '囗', '石', '鹵'],
    },
    Decomposition {
        kanji: '磡',
        radicals: &['一', '｜', '儿', 'ハ', '力', '匚', '口', '甘', '石'],
    },
    Decomposition {
        kanji: '磦',
        radicals: &['二', '口', '小', '石', '示', '西'],
    },
    Decomposition {
        kanji: '磪',
        radicals: &['口', '山', '石', '隹'],
    },
    Decomposition {
        kanji: '磲',
        radicals: &['匚', '口', '⺡', '木', '石'],
    },
    Decomposition {
        kanji: '磳',
        radicals: &['｜', '丷', '口', '日', '曰', '石'],
    },
    Decomposition {
        kanji: '礀',
        radicals: &['口', '月', '石', '門'],
    },
    Decomposition {
        kanji: '磶',
        radicals: &['勹', '口', '⺣', '石', '臼'],
    },
    Decomposition {
        kanji: '磷',
        radicals: &['口', '夕', '石', '米', '舛'],
    },
    Decomposition {
        kanji: '磺',
        radicals: &['ハ', '口', '田', '石', '黄'],
    },
    Decomposition {
        kanji: '磻',
        radicals: &['ノ', '口', '田', '石', '米'],
    },
    Decomposition {
        kanji: '磿',
        radicals: &['ノ', '厂', '口', '木', '石', '禾'],
    },
    Decomposition {
        kanji: '礆',
        radicals: &['一', '人', '𠆢', '口', '石'],
    },
    Decomposition {
        kanji: '礌',
        radicals: &['二', '冖', '口', '田', '石', '雨'],
    },
    Decomposition {
        kanji: '礐',
        radicals: &['一', '｜', 'ノ', '冖', '口', '爻', '石'],
    },
    Decomposition {
        kanji: '礚',
        radicals: &['厶', '口', '土', '⺾', '皿', '石'],
    },
    Decomposition {
        kanji: '礜',
        radicals: &['一', '｜', 'ノ', '口', '大', '石'],
    },
    Decomposition {
        kanji: '礞',
        radicals: &['一', '冖', '口', '⺾', '石', '豕'],
    },
    Decomposition {
        kanji: '礟',
        radicals: &['口', '爻', '石', '馬'],
    },
    Decomposition {
        kanji: '礠',
        radicals: &['一', '丷', '口', '幺', '心', '石'],
    },
    Decomposition {
        kanji: '礥',
        radicals: &['ハ', '匚', '又', '口', '目', '石', '臣', '貝'],
    },
    Decomposition {
        kanji: '礧',
        radicals: &['口', '田', '石'],
    },
    Decomposition {
        kanji: '礩',
        radicals: &['ハ', '口', '斤', '目', '石', '貝'],
    },
    Decomposition {
        kanji: '礭',
        radicals: &['二', '冖', '口', '石', '隹', '雨'],
    },
    Decomposition {
        kanji: '礱',
        radicals: &['一', '乙', '口', '月', '石', '立', '竜'],
    },
    Decomposition {
        kanji: '礴',
        radicals: &['丶', '十', '口', '寸', '⺡', '⺾', '月', '石'],
    },
    Decomposition {
        kanji: '礵',
        radicals: &['二', '冖', '口', '木', '目', '石', '雨'],
    },
    Decomposition {
        kanji: '礻',
        radicals: &['⺭'],
    },
    Decomposition {
        kanji: '礽',
        radicals: &['乃', '⺭'],
    },
    Decomposition {
        kanji: '礿',
        radicals: &['一', '丶', '勹', '⺭'],
    },
    Decomposition {
        kanji: '祄',
        radicals: &['｜', 'ノ', '𠆢', '⺭'],
    },
    Decomposition {
        kanji: '祅',
        radicals: &['｜', 'ノ', '二', '大', '⺭'],
    },
    Decomposition {
        kanji: '祆',
        radicals: &['一', '｜', 'ノ', '二', '大', '⺭'],
    },
    Decomposition {
        kanji: '祊',
        radicals: &['｜', 'ノ', '二', '方', '⺭'],
    },
    Decomposition {
        kanji: '祋',
        radicals: &['几', '又', '殳', '⺭'],
    },
    Decomposition {
        kanji: '祏',
        radicals: &['口', '⺭', '石'],
    },
    Decomposition {
        kanji: '祑',
        radicals: &['一', 'ノ', '大', '⺭'],
    },
    Decomposition {
        kanji: '祔',
        radicals: &['｜', 'ノ', '二', '⺅', '寸', '⺭'],
    },
    Decomposition {
        kanji: '祘',
        radicals: &['二', '小', '示'],
    },
    Decomposition {
        kanji: '祛',
        radicals: &['｜', 'ノ', '二', '厶', '土', '⺭'],
    },
    Decomposition {
        kanji: '祜',
        radicals: &['｜', 'ノ', '二', '十', '口', '⺭'],
    },
    Decomposition {
        kanji: '祧',
        radicals: &['｜', '丶', 'ノ', '二', '儿', '冫', '⺭'],
    },
    Decomposition {
        kanji: '祩',
        radicals: &['一', 'ノ', '木', '⺭'],
    },
    Decomposition {
        kanji: '祫',
        radicals: &['一', '｜', 'ノ', '二', '𠆢', '口', '⺭'],
    },
    Decomposition {
        kanji: '祲',
        radicals: &['｜', 'ノ', '二', '冖', '又', 'ヨ', '⺭'],
    },
    Decomposition {
        kanji: '祹',
        radicals: &['｜', 'ノ', '二', '凵', '勹', '山', '⺭', '缶'],
    },
    Decomposition {
        kanji: '祻',
        radicals: &['十', '口', '囗', '⺭'],
    },
    Decomposition {
        kanji: '祼',
        radicals: &['｜', 'ノ', '二', '日', '木', '⺭', '田'],
    },
    Decomposition {
        kanji: '祾',
        radicals: &['ハ', '土', '夂', '⺭'],
    },
    Decomposition {
        kanji: '禋',
        radicals: &['｜', 'ノ', '二', '土', '⺭', '西'],
    },
    Decomposition {
        kanji: '禌',
        radicals: &['一', '丷', '幺', '⺭'],
    },
    Decomposition {
        kanji: '禑',
        radicals: &['冂', '厶', '⺭', '田', '⽱'],
    },
    Decomposition {
        kanji: '禓',
        radicals: &['一', 'ノ', '勹', '日', '⺭', '勿'],
    },
    Decomposition {
        kanji: '禔',
        radicals: &['｜', 'ノ', '二', '日', '⺭', '疋'],
    },
    Decomposition {
        kanji: '禕',
        radicals: &['｜', 'ノ', '二', '口', '⺭', '韋'],
    },
    Decomposition {
        kanji: '禖',
        radicals: &['｜', 'ノ', '二', '木', '⺭', '甘'],
    },
    Decomposition {
        kanji: '禘',
        radicals: &['｜', 'ノ', '二', '亠', '丷', '冂', '冖', '巾', '⺭', '立'],
    },
    Decomposition {
        kanji: '禛',
        radicals: &['一', '｜', 'ノ', '二', 'ハ', '匕', '十', '⺭', '目', '貝'],
    },
    Decomposition {
        kanji: '禜',
        radicals: &['二', '冖', '小', '火', '示'],
    },
    Decomposition {
        kanji: '禡',
        radicals: &['｜', 'ノ', '二', '⺭', '馬'],
    },
    Decomposition {
        kanji: '禨',
        radicals: &['人', '幺', '戈', '⺭'],
    },
    Decomposition {
        kanji: '禩',
        radicals: &['｜', 'ノ', '二', 'ハ', '⺭', '田'],
    },
    Decomposition {
        kanji: '禫',
        radicals: &['一', '｜', 'ノ', '二', '冂', '十', '日', '⺭', '西'],
    },
    Decomposition {
        kanji: '禯',
        radicals: &['｜', '厂', '日', '⺭', '衣', '辰'],
    },
    Decomposition {
        kanji: '禱',
        radicals: &['一', '｜', 'ノ', '二', '口', '士', '寸', '工', '⺭'],
    },
    Decomposition {
        kanji: '禴',
        radicals: &[
            '一', '｜', 'ノ', '亅', '二', '𠆢', '冂', '口', '⺭', '冊', '龠', '廾',
        ],
    },
    Decomposition {
        kanji: '禸',
        radicals: &['冂', '厶', '⽱'],
    },
    Decomposition {
        kanji: '离',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '十', '厶', '⽱'],
    },
    Decomposition {
        kanji: '秂',
        radicals: &['ノ', '人', '木', '禾'],
    },
    Decomposition {
        kanji: '秄',
        radicals: &['ノ', '子', '木', '禾'],
    },
    Decomposition {
        kanji: '秇',
        radicals: &['丶', 'ノ', '九', '木', '禾'],
    },
    Decomposition {
        kanji: '秈',
        radicals: &['ノ', '山', '木', '禾'],
    },
    Decomposition {
        kanji: '秊',
        radicals: &['ノ', '十', '木', '禾'],
    },
    Decomposition {
        kanji: '秏',
        radicals: &['ノ', '乙', '二', '木', '禾'],
    },
    Decomposition {
        kanji: '秔',
        radicals: &['ノ', '亠', '几', '木', '禾'],
    },
    Decomposition {
        kanji: '秖',
        radicals: &['ノ', '木', '氏', '禾'],
    },
    Decomposition {
        kanji: '秚',
        radicals: &['｜', '丶', 'ノ', '二', 'ハ', '丷', '木', '禾'],
    },
    Decomposition {
        kanji: '秝',
        radicals: &['ノ', '木', '禾'],
    },
    Decomposition {
        kanji: '秞',
        radicals: &['｜', 'ノ', '日', '木', '田', '禾'],
    },
    Decomposition {
        kanji: '秠',
        radicals: &['一', '｜', '丶', 'ノ', '二', '木', '禾'],
    },
    Decomposition {
        kanji: '秢',
        radicals: &['丶', 'ノ', '𠆢', 'マ', '木', '禾'],
    },
    Decomposition {
        kanji: '秥',
        radicals: &['ノ', '卜', '口', '木', '禾'],
    },
    Decomposition {
        kanji: '秪',
        radicals: &['一', '丶', 'ノ', '木', '氏', '禾'],
    },
    Decomposition {
        kanji: '秫',
        radicals: &['一', '｜', '丶', 'ノ', '乙', '木', '禾'],
    },
    Decomposition {
        kanji: '秭',
        radicals: &['｜', 'ノ', '亅', '木', '禾'],
    },
    Decomposition {
        kanji: '秱',
        radicals: &['一', 'ノ', '冂', '口', '木', '禾'],
    },
    Decomposition {
        kanji: '秸',
        radicals: &['ノ', '口', '士', '木', '禾'],
    },
    Decomposition {
        kanji: '秼',
        radicals: &['一', 'ノ', '木', '禾'],
    },
    Decomposition {
        kanji: '稂',
        radicals: &['丶', 'ノ', '木', '禾', '艮'],
    },
    Decomposition {
        kanji: '稃',
        radicals: &['ノ', '子', '木', '爪', '禾'],
    },
    Decomposition {
        kanji: '稇',
        radicals: &['ノ', '囗', '木', '禾'],
    },
    Decomposition {
        kanji: '稉',
        radicals: &['一', '丶', 'ノ', '日', '木', '禾'],
    },
    Decomposition {
        kanji: '稊',
        radicals: &['｜', 'ノ', '丷', '弓', '木', '禾'],
    },
    Decomposition {
        kanji: '稌',
        radicals: &['一', 'ノ', '𠆢', '小', '木', '禾'],
    },
    Decomposition {
        kanji: '稑',
        radicals: &['ノ', '儿', 'ハ', '土', '木', '禾'],
    },
    Decomposition {
        kanji: '稕',
        radicals: &['ノ', '亠', '口', '子', '木', '禾'],
    },
    Decomposition {
        kanji: '稛',
        radicals: &['ノ', '囗', '木', '禾'],
    },
    Decomposition {
        kanji: '稞',
        radicals: &['ノ', '日', '木', '田', '禾'],
    },
    Decomposition {
        kanji: '稡',
        radicals: &['ノ', '亠', '人', '十', '木', '禾'],
    },
    Decomposition {
        kanji: '稧',
        radicals: &['一', '｜', 'ノ', '刀', '大', '木', '禾'],
    },
    Decomposition {
        kanji: '稫',
        radicals: &['一', 'ノ', '口', '木', '田', '禾'],
    },
    Decomposition {
        kanji: '稭',
        radicals: &['ノ', '匕', '日', '木', '比', '白', '禾'],
    },
    Decomposition {
        kanji: '稯',
        radicals: &['丶', 'ノ', 'ハ', '凵', '十', '夂', '木', '禾'],
    },
    Decomposition {
        kanji: '稰',
        radicals: &['ノ', '月', '木', '疋', '禾'],
    },
    Decomposition {
        kanji: '稴',
        radicals: &['一', '｜', '丶', 'ノ', 'ヨ', '木', '禾'],
    },
    Decomposition {
        kanji: '稵',
        radicals: &['一', 'ノ', '丷', '幺', '木', '禾'],
    },
    Decomposition {
        kanji: '稸',
        radicals: &['ノ', '亠', '幺', '木', '田', '禾'],
    },
    Decomposition {
        kanji: '稹',
        radicals: &['一', 'ノ', 'ハ', '匕', '十', '木', '目', '禾', '貝'],
    },
    Decomposition {
        kanji: '稺',
        radicals: &['ノ', '十', '尸', '木', '禾', '立', '辛'],
    },
    Decomposition {
        kanji: '穄',
        radicals: &['丶', 'ノ', '二', '夕', '小', '木', '示', '禾'],
    },
    Decomposition {
        kanji: '穅',
        radicals: &['ノ', '广', 'ヨ', '木', '水', '禾', '隶'],
    },
    Decomposition {
        kanji: '穇',
        radicals: &['ノ', '𠆢', '厶', '彡', '木', '禾'],
    },
    Decomposition {
        kanji: '穈',
        radicals: &['ノ', '广', '木', '禾', '麻'],
    },
    Decomposition {
        kanji: '穌',
        radicals: &['ノ', '木', '⺣', '田', '禾', '魚'],
    },
    Decomposition {
        kanji: '穕',
        radicals: &['ノ', '木', '禾', '隹'],
    },
    Decomposition {
        kanji: '穖',
        radicals: &['ノ', '人', '幺', '戈', '木', '禾'],
    },
    Decomposition {
        kanji: '穙',
        radicals: &['一', '｜', '丶', 'ノ', '二', '丷', '大', '木', '禾'],
    },
    Decomposition {
        kanji: '穜',
        radicals: &['ノ', '木', '禾', '立', '里'],
    },
    Decomposition {
        kanji: '穝',
        radicals: &['ノ', '又', '日', '木', '禾', '耳'],
    },
    Decomposition {
        kanji: '穟',
        radicals: &['ノ', 'ハ', '丷', '⻌', '木', '禾', '豕'],
    },
    Decomposition {
        kanji: '穠',
        radicals: &['｜', 'ノ', '亠', '厂', '日', '木', '禾', '衣', '辰'],
    },
    Decomposition {
        kanji: '穥',
        radicals: &['一', '｜', 'ノ', '亠', 'ハ', '木', '禾'],
    },
    Decomposition {
        kanji: '穧',
        radicals: &['ノ', '亠', '刀', '木', '氏', '禾', '齊'],
    },
    Decomposition {
        kanji: '穪',
        radicals: &['一', '｜', 'ノ', 'ハ', '冂', '木', '爻', '禾'],
    },
    Decomposition {
        kanji: '穭',
        radicals: &['ノ', '日', '木', '⺣', '田', '禾', '魚'],
    },
    Decomposition {
        kanji: '穵',
        radicals: &['乙', '儿', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '穸',
        radicals: &['儿', 'ハ', '夕', '宀'],
    },
    Decomposition {
        kanji: '穾',
        radicals: &['ノ', 'ハ', '大', '宀'],
    },
    Decomposition {
        kanji: '窀',
        radicals: &['ノ', '乙', '儿', 'ハ', '凵', '宀', '屯'],
    },
    Decomposition {
        kanji: '窂',
        radicals: &['儿', 'ハ', '宀', '牛'],
    },
    Decomposition {
        kanji: '窅',
        radicals: &['儿', 'ハ', '宀', '目'],
    },
    Decomposition {
        kanji: '窆',
        radicals: &['丶', 'ノ', '乙', '儿', 'ハ', '宀'],
    },
    Decomposition {
        kanji: '窊',
        radicals: &['儿', 'ハ', '厶', '宀', '瓜'],
    },
    Decomposition {
        kanji: '窋',
        radicals: &['｜', 'ハ', '凵', '宀'],
    },
    Decomposition {
        kanji: '窐',
        radicals: &['儿', 'ハ', '土', '宀'],
    },
    Decomposition {
        kanji: '窑',
        radicals: &['ハ', '凵', '宀', '山', '缶'],
    },
    Decomposition {
        kanji: '窔',
        radicals: &['亠', '儿', 'ハ', '宀', '父'],
    },
    Decomposition {
        kanji: '窞',
        radicals: &['ハ', '勹', '宀', '臼'],
    },
    Decomposition {
        kanji: '窠',
        radicals: &['儿', 'ハ', '宀', '日', '木', '田'],
    },
    Decomposition {
        kanji: '窣',
        radicals: &['亠', '人', '儿', 'ハ', '十', '宀'],
    },
    Decomposition {
        kanji: '窬',
        radicals: &['一', '丶', '𠆢', '儿', 'ハ', '冂', '⺉', '宀', '月'],
    },
    Decomposition {
        kanji: '窳',
        radicals: &['儿', 'ハ', '厶', '宀', '瓜'],
    },
    Decomposition {
        kanji: '窵',
        radicals: &['儿', 'ハ', '宀', '⺣', '鳥'],
    },
    Decomposition {
        kanji: '窹',
        radicals: &['一', '二', '儿', 'ハ', '口', '宀', '爿', '五'],
    },
    Decomposition {
        kanji: '窻',
        radicals: &['ノ', '儿', 'ハ', '口', '夂', '宀', '心'],
    },
    Decomposition {
        kanji: '窼',
        radicals: &['儿', 'ハ', '宀', '巛', '日', '木', '田'],
    },
    Decomposition {
        kanji: '竆',
        radicals: &['一', 'ノ', '儿', 'ハ', '口', '宀', '牙'],
    },
    Decomposition {
        kanji: '竉',
        radicals: &['乙', 'ハ', '宀', '月', '立', '竜'],
    },
    Decomposition {
        kanji: '竌',
        radicals: &['几', '立'],
    },
    Decomposition {
        kanji: '竎',
        radicals: &['廾', '立'],
    },
    Decomposition {
        kanji: '竑',
        radicals: &['一', 'ノ', '厶', '立'],
    },
    Decomposition {
        kanji: '竛',
        radicals: &['丶', '𠆢', 'マ', '立'],
    },
    Decomposition {
        kanji: '竨',
        radicals: &['十', '卜', '日', '立'],
    },
    Decomposition {
        kanji: '竩',
        radicals: &['一', '宀', '目', '立'],
    },
    Decomposition {
        kanji: '竫',
        radicals: &['亅', '勹', 'ヨ', '爪', '立'],
    },
    Decomposition {
        kanji: '竬',
        radicals: &['ノ', '冂', '厶', '口', '⽱', '立', '虫'],
    },
    Decomposition {
        kanji: '竱',
        radicals: &['一', '厶', '寸', '日', '立', '虫'],
    },
    Decomposition {
        kanji: '竴',
        radicals: &['ハ', '丷', '寸', '立', '酉'],
    },
    Decomposition {
        kanji: '竻',
        radicals: &['力', '竹'],
    },
    Decomposition {
        kanji: '竽',
        radicals: &['亅', '二', '竹'],
    },
    Decomposition {
        kanji: '竾',
        radicals: &['｜', '乙', '匕', '也', '竹'],
    },
    Decomposition {
        kanji: '笇',
        radicals: &['亠', '卜', '竹'],
    },
    Decomposition {
        kanji: '笔',
        radicals: &['一', 'ノ', '乙', '竹'],
    },
    Decomposition {
        kanji: '笟',
        radicals: &['厶', '瓜', '竹'],
    },
    Decomposition {
        kanji: '笣',
        radicals: &['勹', '已', '竹'],
    },
    Decomposition {
        kanji: '笧',
        radicals: &['一', '｜', '亅', '冂', '冊', '竹', '廾'],
    },
    Decomposition {
        kanji: '笩',
        radicals: &['⺅', '弋', '竹'],
    },
    Decomposition {
        kanji: '笪',
        radicals: &['一', '日', '竹'],
    },
    Decomposition {
        kanji: '笫',
        radicals: &['亅', '牙', '竹'],
    },
    Decomposition {
        kanji: '笭',
        radicals: &['一', '｜', '丶', '亅', '𠆢', 'マ', '竹'],
    },
    Decomposition {
        kanji: '笮',
        radicals: &['一', '｜', 'ノ', '竹'],
    },
    Decomposition {
        kanji: '笯',
        radicals: &['又', '女', '竹'],
    },
    Decomposition {
        kanji: '笰',
        radicals: &['廾', '弓', '竹'],
    },
    Decomposition {
        kanji: '笱',
        radicals: &['勹', '口', '竹'],
    },
    Decomposition {
        kanji: '笴',
        radicals: &['一', '亅', '口', '竹'],
    },
    Decomposition {
        kanji: '笽',
        radicals: &['皿', '竹'],
    },
    Decomposition {
        kanji: '笿',
        radicals: &['口', '夂', '竹'],
    },
    Decomposition {
        kanji: '筀',
        radicals: &['土', '竹'],
    },
    Decomposition {
        kanji: '筁',
        radicals: &['｜', '日', '竹'],
    },
    Decomposition {
        kanji: '筇',
        radicals: &['工', '⻏', '竹'],
    },
    Decomposition {
        kanji: '筎',
        radicals: &['口', '女', '竹'],
    },
    Decomposition {
        kanji: '筕',
        radicals: &['彳', '竹', '行'],
    },
    Decomposition {
        kanji: '筠',
        radicals: &['一', '丶', '勹', '土', '竹'],
    },
    Decomposition {
        kanji: '筤',
        radicals: &['丶', '竹', '艮'],
    },
    Decomposition {
        kanji: '筦',
        radicals: &['二', '儿', '宀', '元', '竹'],
    },
    Decomposition {
        kanji: '筩',
        radicals: &['マ', '用', '竹'],
    },
    Decomposition {
        kanji: '筪',
        radicals: &['｜', '匚', '日', '田', '竹'],
    },
    Decomposition {
        kanji: '筭',
        radicals: &['一', '｜', '二', '廾', '竹'],
    },
    Decomposition {
        kanji: '筯',
        radicals: &['力', '目', '竹'],
    },
    Decomposition {
        kanji: '筲',
        radicals: &['小', '⺌', '月', '竹'],
    },
    Decomposition {
        kanji: '筳',
        radicals: &['ノ', '土', '士', '廴', '王', '竹'],
    },
    Decomposition {
        kanji: '筷',
        radicals: &['人', 'ユ', '⺖', '竹'],
    },
    Decomposition {
        kanji: '箄',
        radicals: &['ノ', '十', '日', '白', '竹'],
    },
    Decomposition {
        kanji: '箉',
        radicals: &['力', '口', '扌', '竹'],
    },
    Decomposition {
        kanji: '箎',
        radicals: &['几', '匕', '卜', '厂', '竹', '虍'],
    },
    Decomposition {
        kanji: '箐',
        radicals: &['一', '｜', '二', '亠', '冂', '土', '月', '竹', '青'],
    },
    Decomposition {
        kanji: '箑',
        radicals: &['土', 'ヨ', '竹', '走'],
    },
    Decomposition {
        kanji: '箖',
        radicals: &['木', '竹'],
    },
    Decomposition {
        kanji: '箛',
        radicals: &['厶', '子', '瓜', '竹'],
    },
    Decomposition {
        kanji: '箞',
        radicals: &['一', '丶', 'ノ', '乙', '亅', 'ハ', '丷', '大', '竹'],
    },
    Decomposition {
        kanji: '箠',
        radicals: &['一', '｜', 'ノ', '二', '竹'],
    },
    Decomposition {
        kanji: '箥',
        radicals: &['ノ', '十', '厂', '又', '⺡', '支', '竹'],
    },
    Decomposition {
        kanji: '箬',
        radicals: &['一', 'ノ', '口', '⺾', '竹'],
    },
    Decomposition {
        kanji: '箯',
        radicals: &['一', '丶', 'ノ', '⺅', '日', '竹'],
    },
    Decomposition {
        kanji: '箰',
        radicals: &['勹', '子', '日', '竹'],
    },
    Decomposition {
        kanji: '箲',
        radicals: &['ノ', '儿', '土', '⺡', '竹'],
    },
    Decomposition {
        kanji: '箵',
        radicals: &['ノ', '小', '目', '竹'],
    },
    Decomposition {
        kanji: '箶',
        radicals: &['十', '口', '月', '竹'],
    },
    Decomposition {
        kanji: '箺',
        radicals: &['一', '丶', 'ノ', '二', '大', '日', '曰', '竹'],
    },
    Decomposition {
        kanji: '箻',
        radicals: &['｜', '二', 'ヨ', '彳', '竹', '聿'],
    },
    Decomposition {
        kanji: '箼',
        radicals: &['一', '厶', '土', '尸', '竹'],
    },
    Decomposition {
        kanji: '箽',
        radicals: &['一', 'ノ', '竹', '車'],
    },
    Decomposition {
        kanji: '篂',
        radicals: &['日', '曰', '生', '竹'],
    },
    Decomposition {
        kanji: '篅',
        radicals: &['山', '竹', '而'],
    },
    Decomposition {
        kanji: '篈',
        radicals: &['土', '寸', '竹'],
    },
    Decomposition {
        kanji: '篊',
        radicals: &['｜', '二', 'ハ', '⺡', '竹'],
    },
    Decomposition {
        kanji: '篔',
        radicals: &['ハ', '口', '目', '竹', '貝'],
    },
    Decomposition {
        kanji: '篖',
        radicals: &['｜', '口', '广', 'ヨ', '竹'],
    },
    Decomposition {
        kanji: '篗',
        radicals: &['又', '竹', '隹'],
    },
    Decomposition {
        kanji: '篙',
        radicals: &['亠', '冂', '口', '竹', '高'],
    },
    Decomposition {
        kanji: '篚',
        radicals: &['匚', '竹', '非'],
    },
    Decomposition {
        kanji: '篛',
        radicals: &['冫', '弓', '竹'],
    },
    Decomposition {
        kanji: '篨',
        radicals: &['二', '𠆢', '小', '⻖', '竹'],
    },
    Decomposition {
        kanji: '篪',
        radicals: &['儿', '几', '匕', '卜', '厂', '竹', '虍'],
    },
    Decomposition {
        kanji: '篲',
        radicals: &['一', '｜', '二', 'ヨ', '竹'],
    },
    Decomposition {
        kanji: '篴',
        radicals: &['⻌', '竹', '豕'],
    },
    Decomposition {
        kanji: '篵',
        radicals: &['人', '彳', '止', '竹'],
    },
    Decomposition {
        kanji: '篸',
        radicals: &['𠆢', '厶', '彡', '竹'],
    },
    Decomposition {
        kanji: '篹',
        radicals: &['乙', '亅', '大', '目', '竹'],
    },
    Decomposition {
        kanji: '篺',
        radicals: &['ノ', '十', '扌', '日', '竹'],
    },
    Decomposition {
        kanji: '篼',
        radicals: &['一', 'ノ', '儿', '日', '白', '竹'],
    },
    Decomposition {
        kanji: '篾',
        radicals: &['丶', 'ノ', '厂', '戈', '⺲', '竹'],
    },
    Decomposition {
        kanji: '簁',
        radicals: &['彳', '止', '竹'],
    },
    Decomposition {
        kanji: '簂',
        radicals: &['一', '口', '囗', '戈', '竹'],
    },
    Decomposition {
        kanji: '簃',
        radicals: &['ノ', '夕', '木', '禾', '竹'],
    },
    Decomposition {
        kanji: '簄',
        radicals: &['丶', '乙', '口', '尸', '已', '⻏', '巴'],
    },
    Decomposition {
        kanji: '簆',
        radicals: &['二', '儿', '卜', '又', '宀', '元', '竹'],
    },
    Decomposition {
        kanji: '簉',
        radicals: &['｜', 'ノ', '二', '⻌', '口', '土', '竹'],
    },
    Decomposition {
        kanji: '簋',
        radicals: &['皿', '竹', '艮'],
    },
    Decomposition {
        kanji: '簌',
        radicals: &['人', '勹', '口', '木', '欠', '竹'],
    },
    Decomposition {
        kanji: '簎',
        radicals: &['｜', '二', '扌', '日', '竹'],
    },
    Decomposition {
        kanji: '簏',
        radicals: &['匕', '广', '比', '竹', '鹿'],
    },
    Decomposition {
        kanji: '簙',
        radicals: &['丶', '十', '寸', '月', '竹'],
    },
    Decomposition {
        kanji: '簛',
        radicals: &['二', 'ハ', '斤', '甘', '竹'],
    },
    Decomposition {
        kanji: '簠',
        radicals: &['丶', '十', '日', '月', '皿', '竹'],
    },
    Decomposition {
        kanji: '簥',
        radicals: &['ノ', '冂', '口', '大', '竹'],
    },
    Decomposition {
        kanji: '簦',
        radicals: &['丶', 'ノ', '丷', '口', '竹', '豆'],
    },
    Decomposition {
        kanji: '簨',
        radicals: &['｜', '二', 'ハ', '已', '竹'],
    },
    Decomposition {
        kanji: '簬',
        radicals: &['口', '夂', '竹', '足'],
    },
    Decomposition {
        kanji: '簱',
        radicals: &['｜', '二', 'ハ', '方', '甘', '竹'],
    },
    Decomposition {
        kanji: '簳',
        radicals: &['一', '𠆢', '十', '干', '日', '竹'],
    },
    Decomposition {
        kanji: '簴',
        radicals: &['一', '｜', '丶', 'ノ', 'ハ', '匕', '卜', '厂', '竹', '虍'],
    },
    Decomposition {
        kanji: '簶',
        radicals: &['｜', 'ノ', '二', 'ヨ', '水', '⺭', '竹'],
    },
    Decomposition {
        kanji: '簹',
        radicals: &['冖', '口', '⺌', '田', '竹'],
    },
    Decomposition {
        kanji: '簺',
        radicals: &['一', '｜', '丶', 'ノ', '二', '冖', '土', '竹'],
    },
    Decomposition {
        kanji: '籆',
        radicals: &['又', '⺾', '竹', '隹'],
    },
    Decomposition {
        kanji: '籊',
        radicals: &['冫', '竹', '羽', '隹'],
    },
    Decomposition {
        kanji: '籕',
        radicals: &['ノ', '刀', '厶', '木', '田', '竹'],
    },
    Decomposition {
        kanji: '籑',
        radicals: &['一', '丶', '大', '目', '竹', '艮'],
    },
    Decomposition {
        kanji: '籒',
        radicals: &['一', '｜', '扌', '田', '竹'],
    },
    Decomposition {
        kanji: '籓',
        radicals: &['ノ', '⺡', '田', '竹', '米'],
    },
    Decomposition {
        kanji: '籙',
        radicals: &['ヨ', '彑', '水', '竹', '金'],
    },
    Decomposition {
        kanji: '籚',
        radicals: &['匕', '卜', '厂', '田', '皿', '竹', '虍'],
    },
    Decomposition {
        kanji: '籛',
        radicals: &['戈', '竹', '金'],
    },
    Decomposition {
        kanji: '籜',
        radicals: &['一', '丷', '十', '土', '干', '扌', '⺲', '竹'],
    },
    Decomposition {
        kanji: '籝',
        radicals: &['一', '丶', '亠', '几', '口', '女', '亡', '月'],
    },
    Decomposition {
        kanji: '籞',
        radicals: &['ノ', '二', '儿', '卩', '彳', '止', '元', '竹'],
    },
    Decomposition {
        kanji: '籡',
        radicals: &['一', '人', '𠆢', '口', '扌', '竹'],
    },
    Decomposition {
        kanji: '籣',
        radicals: &['丷', '口', '木', '竹', '門'],
    },
    Decomposition {
        kanji: '籧',
        radicals: &['匕', '卜', '厂', '⻌', '竹', '虍', '豕'],
    },
    Decomposition {
        kanji: '籩',
        radicals: &['儿', 'ハ', '⻌', '宀', '方', '目', '竹', '自'],
    },
    Decomposition {
        kanji: '籭',
        radicals: &['一', '丶', '冂', '匕', '广', '比', '竹', '鹿'],
    },
    Decomposition {
        kanji: '籮',
        radicals: &['小', '幺', '⺲', '竹', '糸', '隹'],
    },
    Decomposition {
        kanji: '籰',
        radicals: &['又', '目', '竹', '隹'],
    },
    Decomposition {
        kanji: '籲',
        radicals: &[
            '一', '｜', '亅', '𠆢', 'ハ', '冂', '口', '目', '冊', '竹', '貝', '頁', '龠', '廾',
        ],
    },
    Decomposition {
        kanji: '籹',
        radicals: &['女', '米'],
    },
    Decomposition {
        kanji: '籼',
        radicals: &['山', '米'],
    },
    Decomposition {
        kanji: '籽',
        radicals: &['子', '米'],
    },
    Decomposition {
        kanji: '粆',
        radicals: &['ノ', '小', '米'],
    },
    Decomposition {
        kanji: '粇',
        radicals: &['亠', '几', '米'],
    },
    Decomposition {
        kanji: '粏',
        radicals: &['丶', '大', '米'],
    },
    Decomposition {
        kanji: '粔',
        radicals: &['匚', '口', '米'],
    },
    Decomposition {
        kanji: '粞',
        radicals: &['米', '西'],
    },
    Decomposition {
        kanji: '粠',
        radicals: &['｜', '二', 'ハ', '米'],
    },
    Decomposition {
        kanji: '粦',
        radicals: &['夕', '米', '舛'],
    },
    Decomposition {
        kanji: '粰',
        radicals: &['子', '爪', '米'],
    },
    Decomposition {
        kanji: '粶',
        radicals: &['ヨ', '彑', '水', '米'],
    },
    Decomposition {
        kanji: '粷',
        radicals: &['勹', '米'],
    },
    Decomposition {
        kanji: '粺',
        radicals: &['ノ', '十', '日', '白', '米'],
    },
    Decomposition {
        kanji: '粻',
        radicals: &['米', '長'],
    },
    Decomposition {
        kanji: '粼',
        radicals: &['夕', '米', '舛'],
    },
    Decomposition {
        kanji: '粿',
        radicals: &['日', '木', '田', '米'],
    },
    Decomposition {
        kanji: '糄',
        radicals: &['一', '｜', '亅', '冂', '尸', '戸', '冊', '米', '廾'],
    },
    Decomposition {
        kanji: '糇',
        radicals: &['一', 'ノ', '⺅', 'ユ', '大', '矢', '米'],
    },
    Decomposition {
        kanji: '糈',
        radicals: &['月', '疋', '米'],
    },
    Decomposition {
        kanji: '糉',
        radicals: &['丶', 'ノ', '儿', 'ハ', '凵', '夂', '米'],
    },
    Decomposition {
        kanji: '糍',
        radicals: &['一', '丷', '幺', '米'],
    },
    Decomposition {
        kanji: '糏',
        radicals: &['⺌', '尸', '月', '米'],
    },
    Decomposition {
        kanji: '糓',
        radicals: &['一', '冖', '几', '又', '士', '殳', '米'],
    },
    Decomposition {
        kanji: '糔',
        radicals: &['丶', '又', '米', '虫'],
    },
    Decomposition {
        kanji: '糕',
        radicals: &['丷', '⺣', '王', '米'],
    },
    Decomposition {
        kanji: '糗',
        radicals: &['丶', '大', '犬', '目', '米', '自'],
    },
    Decomposition {
        kanji: '糙',
        radicals: &['｜', 'ノ', '二', '⻌', '口', '土', '米'],
    },
    Decomposition {
        kanji: '糚',
        radicals: &['士', '⺾', '爿', '米'],
    },
    Decomposition {
        kanji: '糝',
        radicals: &['𠆢', '厶', '彡', '米'],
    },
    Decomposition {
        kanji: '糦',
        radicals: &['一', '丷', '十', '口', '士', '米', '豆'],
    },
    Decomposition {
        kanji: '糩',
        radicals: &['一', '｜', '𠆢', '丷', '口', '日', '米'],
    },
    Decomposition {
        kanji: '糫',
        radicals: &['一', '口', '⺲', '米', '衣'],
    },
    Decomposition {
        kanji: '糵',
        radicals: &['｜', 'ノ', '十', '口', '⺾', '立', '米', '辛'],
    },
    Decomposition {
        kanji: '紃',
        radicals: &['小', '川', '幺', '糸'],
    },
    Decomposition {
        kanji: '紇',
        radicals: &['一', 'ノ', '乙', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紈',
        radicals: &['丶', '九', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紉',
        radicals: &['ノ', '刀', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紏',
        radicals: &['小', '幺', '斗', '糸'],
    },
    Decomposition {
        kanji: '紑',
        radicals: &['一', '｜', '丶', 'ノ', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紒',
        radicals: &['｜', 'ノ', '𠆢', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紓',
        radicals: &['マ', '小', '幺', '矛', '糸'],
    },
    Decomposition {
        kanji: '紖',
        radicals: &['｜', '小', '幺', '弓', '糸'],
    },
    Decomposition {
        kanji: '紝',
        radicals: &['ノ', '士', '小', '幺', '王', '糸'],
    },
    Decomposition {
        kanji: '紞',
        radicals: &['ノ', '乙', '冖', '小', '尢', '幺', '糸'],
    },
    Decomposition {
        kanji: '紣',
        radicals: &['十', '九', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紦',
        radicals: &['乙', '小', '已', '幺', '巴', '糸'],
    },
    Decomposition {
        kanji: '紪',
        radicals: &['匕', '小', '幺', '止', '糸'],
    },
    Decomposition {
        kanji: '紭',
        radicals: &['厶', '小', '幺', '弓', '糸'],
    },
    Decomposition {
        kanji: '紱',
        radicals: &['丶', 'ノ', '又', '大', '小', '幺', '弋', '犬', '糸'],
    },
    Decomposition {
        kanji: '紼',
        radicals: &['小', '幺', '廾', '弓', '糸'],
    },
    Decomposition {
        kanji: '紽',
        radicals: &['匕', '宀', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '紾',
        radicals: &['𠆢', '小', '幺', '彡', '糸'],
    },
    Decomposition {
        kanji: '絀',
        radicals: &['｜', '凵', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絁',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '小', '幺', '也', '糸'],
    },
    Decomposition {
        kanji: '絇',
        radicals: &['勹', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絈',
        radicals: &['小', '幺', '日', '白', '糸'],
    },
    Decomposition {
        kanji: '絍',
        radicals: &['ノ', '⺅', '士', '小', '幺', '王', '糸'],
    },
    Decomposition {
        kanji: '絑',
        radicals: &['一', 'ノ', '小', '幺', '木', '糸'],
    },
    Decomposition {
        kanji: '絓',
        radicals: &['土', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絗',
        radicals: &['口', '囗', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絙',
        radicals: &['一', '小', '幺', '日', '糸'],
    },
    Decomposition {
        kanji: '絚',
        radicals: &['一', '丶', '二', '小', '幺', '五', '糸'],
    },
    Decomposition {
        kanji: '絜',
        radicals: &['一', '｜', '二', '刀', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絝',
        radicals: &['二', '勹', '大', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絥',
        radicals: &['丶', '⺅', '大', '小', '幺', '犬', '糸'],
    },
    Decomposition {
        kanji: '絧',
        radicals: &['一', '冂', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絪',
        radicals: &['囗', '大', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '絰',
        radicals: &['一', '厶', '土', '小', '幺', '糸', '至'],
    },
    Decomposition {
        kanji: '絸',
        radicals: &['儿', '小', '幺', '目', '糸', '見'],
    },
    Decomposition {
        kanji: '絺',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '小', '巾', '幺', '糸'],
    },
    Decomposition {
        kanji: '絻',
        radicals: &[
            '一', '｜', 'ノ', '乙', '儿', '勹', '口', '小', '幺', '糸', '免',
        ],
    },
    Decomposition {
        kanji: '絿',
        radicals: &['一', '丶', '小', '幺', '水', '糸'],
    },
    Decomposition {
        kanji: '綁',
        radicals: &['一', 'ノ', '小', '幺', '⻏', '糸'],
    },
    Decomposition {
        kanji: '綂',
        radicals: &['亠', '儿', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綃',
        radicals: &['小', '⺌', '幺', '月', '糸'],
    },
    Decomposition {
        kanji: '綅',
        radicals: &['冖', '又', '小', '幺', 'ヨ', '糸'],
    },
    Decomposition {
        kanji: '綆',
        radicals: &['一', '丶', 'ノ', '小', '幺', '日', '糸'],
    },
    Decomposition {
        kanji: '綈',
        radicals: &['｜', 'ノ', '丷', '小', '幺', '弓', '糸'],
    },
    Decomposition {
        kanji: '綋',
        radicals: &['一', 'ノ', '厶', '宀', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綌',
        radicals: &['𠆢', 'ハ', '口', '小', '幺', '糸', '谷'],
    },
    Decomposition {
        kanji: '綍',
        radicals: &['冖', '十', '子', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綑',
        radicals: &['囗', '小', '幺', '木', '糸'],
    },
    Decomposition {
        kanji: '綖',
        radicals: &['ノ', '小', '幺', '廴', '止', '糸'],
    },
    Decomposition {
        kanji: '綗',
        radicals: &['儿', 'ハ', '冂', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綝',
        radicals: &['小', '幺', '木', '糸'],
    },
    Decomposition {
        kanji: '綞',
        radicals: &['一', '｜', 'ノ', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綦',
        radicals: &['｜', '丶', 'ノ', '二', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綧',
        radicals: &['亠', '口', '子', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綪',
        radicals: &['二', '亠', '土', '小', '幺', '月', '糸', '青'],
    },
    Decomposition {
        kanji: '綳',
        radicals: &['小', '幺', '月', '糸'],
    },
    Decomposition {
        kanji: '綶',
        radicals: &['小', '幺', '日', '木', '田', '糸'],
    },
    Decomposition {
        kanji: '綷',
        radicals: &['亠', '人', '十', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '綹',
        radicals: &['卜', '口', '夂', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '緂',
        radicals: &['小', '幺', '火', '糸'],
    },
    Decomposition {
        kanji: '緃',
        radicals: &['人', '小', '幺', '止', '糸'],
    },
    Decomposition {
        kanji: '緄',
        radicals: &['匕', '小', '幺', '日', '曰', '比', '糸'],
    },
    Decomposition {
        kanji: '緅',
        radicals: &['又', '小', '幺', '糸', '耳'],
    },
    Decomposition {
        kanji: '緆',
        radicals: &['ノ', '勹', '小', '幺', '日', '曰', '勿', '糸'],
    },
    Decomposition {
        kanji: '緌',
        radicals: &['ノ', '女', '小', '幺', '木', '禾', '糸'],
    },
    Decomposition {
        kanji: '緍',
        radicals: &['小', '幺', '日', '曰', '氏', '糸'],
    },
    Decomposition {
        kanji: '緎',
        radicals: &['一', '口', '小', '幺', '戈', '糸'],
    },
    Decomposition {
        kanji: '緗',
        radicals: &['小', '幺', '木', '目', '糸'],
    },
    Decomposition {
        kanji: '緙',
        radicals: &['十', '口', '小', '幺', '廾', '糸', '革'],
    },
    Decomposition {
        kanji: '縀',
        radicals: &['一', '｜', '又', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '緢',
        radicals: &['小', '幺', '⺾', '田', '糸'],
    },
    Decomposition {
        kanji: '緥',
        radicals: &['⺅', '口', '小', '幺', '木', '糸'],
    },
    Decomposition {
        kanji: '緦',
        radicals: &['小', '幺', '心', '田', '糸'],
    },
    Decomposition {
        kanji: '緪',
        radicals: &['一', '丶', '二', '小', '幺', '⺖', '五', '糸'],
    },
    Decomposition {
        kanji: '緫',
        radicals: &['丶', 'ノ', '勹', '小', '幺', '心', '勿', '糸'],
    },
    Decomposition {
        kanji: '緭',
        radicals: &['小', '幺', '月', '田', '糸'],
    },
    Decomposition {
        kanji: '緱',
        radicals: &['一', 'ノ', '⺅', 'ユ', '大', '小', '幺', '矢', '糸'],
    },
    Decomposition {
        kanji: '緵',
        radicals: &['丶', 'ノ', '儿', 'ハ', '凵', '夂', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '緶',
        radicals: &['一', '丶', 'ノ', '⺅', '小', '幺', '日', '糸'],
    },
    Decomposition {
        kanji: '緹',
        radicals: &['小', '幺', '日', '疋', '糸'],
    },
    Decomposition {
        kanji: '緺',
        radicals: &['冂', '口', '小', '幺', '糸'],
    },
    Decomposition {
        kanji: '縈',
        radicals: &['冖', '小', '幺', '火', '糸'],
    },
    Decomposition {
        kanji: '縐',
        radicals: &['勹', '小', '屮', '幺', '糸'],
    },
    Decomposition {
        kanji: '縑',
        radicals: &['一', '｜', 'ノ', '丷', '小', '幺', 'ヨ', '糸'],
    },
    Decomposition {
        kanji: '縕',
        radicals: &['人', '口', '小', '幺', '皿', '糸'],
    },
    Decomposition {
        kanji: '縗',
        radicals: &['一', '亠', '口', '小', '幺', '糸', '衣'],
    },
    Decomposition {
        kanji: '縜',
        radicals: &['ハ', '口', '小', '幺', '目', '糸', '貝'],
    },
    Decomposition {
        kanji: '縝',
        radicals: &['一', 'ハ', '匕', '十', '小', '幺', '目', '糸', '貝'],
    },
    Decomposition {
        kanji: '縠',
        radicals: &['一', '冖', '几', '又', '士', '小', '幺', '殳', '糸'],
    },
    Decomposition {
        kanji: '縧',
        radicals: &['一', '｜', '⺅', '夂', '小', '幺', '木', '糸'],
    },
    Decomposition {
        kanji: '縨',
        radicals: &['一', '儿', '小', '⺌', '幺', '日', '糸'],
    },
    Decomposition {
        kanji: '縬',
        radicals: &['一', 'ノ', '卜', '厂', '小', '幺', '戈', '糸'],
    },
    Decomposition {
        kanji: '縭',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '厶', '小', '幺', '⽱', '糸'],
    },
    Decomposition {
        kanji: '縯',
        radicals: &['一', '｜', 'ハ', '宀', '小', '幺', '日', '田', '糸'],
    },
    Decomposition {
        kanji: '縳',
        radicals: &['一', '寸', '小', '幺', '糸', '虫'],
    },
    Decomposition {
        kanji: '縶',
        radicals: &['一', '丶', '丷', '十', '九', '土', '小', '干', '幺', '糸'],
    },
    Decomposition {
        kanji: '縿',
        radicals: &['𠆢', '厶', '小', '幺', '彡', '糸'],
    },
    Decomposition {
        kanji: '繄',
        radicals: &[
            '一', 'ノ', '几', '匚', '又', '大', '小', '幺', '殳', '矢', '糸',
        ],
    },
    Decomposition {
        kanji: '繅',
        radicals: &['小', '巛', '幺', '日', '木', '田', '糸'],
    },
    Decomposition {
        kanji: '繇',
        radicals: &['丶', 'ノ', '凵', '夕', '小', '山', '幺', '爪', '糸', '缶'],
    },
    Decomposition {
        kanji: '繎',
        radicals: &['丶', '夕', '大', '小', '幺', '⺣', '犬', '糸'],
    },
    Decomposition {
        kanji: '繐',
        radicals: &['一', '小', '幺', '心', '糸', '虫'],
    },
    Decomposition {
        kanji: '繒',
        radicals: &['｜', 'ハ', '丷', '口', '小', '幺', '日', '糸'],
    },
    Decomposition {
        kanji: '繘',
        radicals: &['ハ', '冂', 'マ', '口', '小', '幺', '矛', '糸'],
    },
    Decomposition {
        kanji: '繟',
        radicals: &['十', '口', '小', '幺', '日', '田', '糸'],
    },
    Decomposition {
        kanji: '繡',
        radicals: &['｜', '小', '幺', 'ヨ', '爿', '片', '糸'],
    },
    Decomposition {
        kanji: '繢',
        radicals: &['一', '｜', 'ハ', '口', '小', '幺', '目', '糸', '虫', '貝'],
    },
    Decomposition {
        kanji: '繥',
        radicals: &['一', '丷', '十', '口', '士', '小', '幺', '糸', '豆'],
    },
    Decomposition {
        kanji: '繫',
        radicals: &['几', '凵', '又', '小', '幺', '殳', '糸', '車'],
    },
    Decomposition {
        kanji: '繮',
        radicals: &['一', '小', '幺', '田', '糸'],
    },
    Decomposition {
        kanji: '繯',
        radicals: &['一', '口', '小', '幺', '⺲', '糸', '衣'],
    },
    Decomposition {
        kanji: '繳',
        radicals: &['小', '幺', '攵', '方', '日', '白', '糸'],
    },
    Decomposition {
        kanji: '繸',
        radicals: &['ハ', '丷', '⻌', '小', '幺', '糸', '豕'],
    },
    Decomposition {
        kanji: '繾',
        radicals: &['一', '｜', '⻌', '口', '小', '幺', '糸', '虫'],
    },
    Decomposition {
        kanji: '纁',
        radicals: &['一', '｜', 'ノ', '二', '丷', '口', '小', '幺', '⺣', '糸'],
    },
    Decomposition {
        kanji: '纆',
        radicals: &['丷', '口', '土', '小', '幺', '⺣', '糸', '里', '黒'],
    },
    Decomposition {
        kanji: '纇',
        radicals: &['ハ', '小', '幺', '目', '米', '糸', '貝', '頁'],
    },
    Decomposition {
        kanji: '纊',
        radicals: &['ハ', '小', '幺', '广', '田', '糸', '黄'],
    },
    Decomposition {
        kanji: '纍',
        radicals: &['小', '幺', '田', '糸'],
    },
    Decomposition {
        kanji: '纑',
        radicals: &['匕', '卜', '厂', '小', '幺', '田', '皿', '糸', '虍'],
    },
    Decomposition {
        kanji: '纕',
        radicals: &['一', '｜', '二', '亠', '口', '小', '幺', '糸', '衣'],
    },
    Decomposition {
        kanji: '纘',
        radicals: &['ノ', '儿', 'ハ', '土', '小', '幺', '目', '糸', '貝'],
    },
    Decomposition {
        kanji: '纚',
        radicals: &['一', '丶', '冂', '匕', '小', '幺', '广', '比', '糸', '鹿'],
    },
    Decomposition {
        kanji: '纝',
        radicals: &['小', '幺', '田', '糸'],
    },
    Decomposition {
        kanji: '纞',
        radicals: &['小', '幺', '心', '糸', '言'],
    },
    Decomposition {
        kanji: '缼',
        radicals: &['人', '凵', '勹', '山', '欠', '缶'],
    },
    Decomposition {
        kanji: '缻',
        radicals: &['一', '丶', '乙', '凵', '山', '缶'],
    },
    Decomposition {
        kanji: '缽',
        radicals: &['一', '凵', '山', '木', '缶'],
    },
    Decomposition {
        kanji: '缾',
        radicals: &['一', '丷', '凵', '山', '廾', '缶'],
    },
    Decomposition {
        kanji: '缿',
        radicals: &['一', 'ノ', '凵', '口', '山', '缶'],
    },
    Decomposition {
        kanji: '罃',
        radicals: &['冖', '凵', '山', '火', '缶'],
    },
    Decomposition {
        kanji: '罄',
        radicals: &['｜', '几', '凵', '又', '士', '尸', '山', '殳', '缶'],
    },
    Decomposition {
        kanji: '罇',
        radicals: &['ハ', '丷', '凵', '寸', '山', '缶', '酉'],
    },
    Decomposition {
        kanji: '罏',
        radicals: &['凵', '匕', '卜', '厂', '山', '田', '皿', '缶', '虍'],
    },
    Decomposition {
        kanji: '罒',
        radicals: &['⺲'],
    },
    Decomposition {
        kanji: '罓',
        radicals: &['丶', 'ノ', '冂'],
    },
    Decomposition {
        kanji: '罛',
        radicals: &['厶', '瓜', '⺲'],
    },
    Decomposition {
        kanji: '罜',
        radicals: &['丶', '王', '⺲'],
    },
    Decomposition {
        kanji: '罝',
        radicals: &['一', '目', '⺲'],
    },
    Decomposition {
        kanji: '罡',
        radicals: &['一', '止', '⺲'],
    },
    Decomposition {
        kanji: '罣',
        radicals: &['土', '⺲'],
    },
    Decomposition {
        kanji: '罤',
        radicals: &['｜', 'ノ', '丷', '弓', '⺲'],
    },
    Decomposition {
        kanji: '罥',
        radicals: &['口', '月', '⺲'],
    },
    Decomposition {
        kanji: '罦',
        radicals: &['子', '爪', '⺲'],
    },
    Decomposition {
        kanji: '罭',
        radicals: &['一', '口', '戈', '⺲'],
    },
    Decomposition {
        kanji: '罱',
        radicals: &['一', '丷', '冂', '十', '干', '⺲'],
    },
    Decomposition {
        kanji: '罽',
        radicals: &['⺉', '厂', '火', '⺲'],
    },
    Decomposition {
        kanji: '罾',
        radicals: &['一', 'ハ', '丷', '口', '日', '⺲'],
    },
    Decomposition {
        kanji: '罿',
        radicals: &['立', '⺲', '里'],
    },
    Decomposition {
        kanji: '羀',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '田'],
    },
    Decomposition {
        kanji: '羋',
        radicals: &['一', '｜', '二', '卜'],
    },
    Decomposition {
        kanji: '羍',
        radicals: &['丷', '大', '王', '羊'],
    },
    Decomposition {
        kanji: '羏',
        radicals: &['丷', '彡', '王', '羊'],
    },
    Decomposition {
        kanji: '羐',
        radicals: &['一', '｜', '卜', '土', '夂'],
    },
    Decomposition {
        kanji: '羑',
        radicals: &['丷', '夂', '王', '羊'],
    },
    Decomposition {
        kanji: '羖',
        radicals: &['丷', '几', '又', '殳', '王', '羊'],
    },
    Decomposition {
        kanji: '羗',
        radicals: &['乙', '丷', '厶', '王', '羊'],
    },
    Decomposition {
        kanji: '羜',
        radicals: &['一', '亅', '丷', '宀', '王', '羊'],
    },
    Decomposition {
        kanji: '羡',
        radicals: &['人', '丷', '冫', '勹', '欠', '王', '羊'],
    },
    Decomposition {
        kanji: '羢',
        radicals: &['一', 'ノ', '丷', '戈', '王', '羊'],
    },
    Decomposition {
        kanji: '羦',
        radicals: &['二', '儿', '丷', '宀', '王', '元', '羊'],
    },
    Decomposition {
        kanji: '羪',
        radicals: &['丶', '丷', '王', '羊', '艮'],
    },
    Decomposition {
        kanji: '羭',
        radicals: &['一', '𠆢', '丷', '⺉', '月', '王', '羊'],
    },
    Decomposition {
        kanji: '羴',
        radicals: &['丷', '王', '羊'],
    },
    Decomposition {
        kanji: '羼',
        radicals: &['丷', '尸', '王', '羊'],
    },
    Decomposition {
        kanji: '羿',
        radicals: &['ノ', '冫', '廾', '羽'],
    },
    Decomposition {
        kanji: '翀',
        radicals: &['｜', '冫', '口', '羽'],
    },
    Decomposition {
        kanji: '翃',
        radicals: &['一', 'ノ', '冫', '厶', '羽'],
    },
    Decomposition {
        kanji: '翈',
        radicals: &['｜', '冫', '日', '田', '羽'],
    },
    Decomposition {
        kanji: '翎',
        radicals: &['一', '｜', 'ノ', '亅', '𠆢', '冫', '厶', '羽'],
    },
    Decomposition {
        kanji: '翏',
        radicals: &['𠆢', '冫', '彡', '羽'],
    },
    Decomposition {
        kanji: '翛',
        radicals: &['｜', '⺅', '冫', '夂', '羽'],
    },
    Decomposition {
        kanji: '翟',
        radicals: &['ノ', '冫', '羽', '隹'],
    },
    Decomposition {
        kanji: '翣',
        radicals: &['ノ', '冫', '女', '立', '羽'],
    },
    Decomposition {
        kanji: '翥',
        radicals: &['丶', 'ノ', '冫', '土', '⺹', '日', '羽'],
    },
    Decomposition {
        kanji: '翨',
        radicals: &['冫', '日', '曰', '疋', '羽'],
    },
    Decomposition {
        kanji: '翬',
        radicals: &['ノ', '冖', '冫', '羽', '車'],
    },
    Decomposition {
        kanji: '翮',
        radicals: &['ノ', '儿', '冂', '冫', '口', '羽', '鬲'],
    },
    Decomposition {
        kanji: '翯',
        radicals: &['ノ', '亠', '冂', '冫', '口', '羽', '高'],
    },
    Decomposition {
        kanji: '翲',
        radicals: &['ノ', '二', '冫', '小', '示', '羽', '西'],
    },
    Decomposition {
        kanji: '翺',
        radicals: &['丶', 'ノ', '二', '冫', '十', '目', '羽', '自'],
    },
    Decomposition {
        kanji: '翽',
        radicals: &['一', 'ノ', '冫', '厂', '小', '戈', '止', '羽'],
    },
    Decomposition {
        kanji: '翾',
        radicals: &['一', 'ノ', '冫', '口', '⺲', '羽', '衣'],
    },
    Decomposition {
        kanji: '翿',
        radicals: &['一', 'ノ', '冫', '口', '士', '寸', '工', '羽'],
    },
    Decomposition {
        kanji: '耇',
        radicals: &['ノ', '勹', '口', '土', '⺹'],
    },
    Decomposition {
        kanji: '耈',
        radicals: &['ノ', '勹', '匕', '口', '土', '⺹'],
    },
    Decomposition {
        kanji: '耊',
        radicals: &['一', 'ノ', '厶', '土', '⺹', '至'],
    },
    Decomposition {
        kanji: '耍',
        radicals: &['女', '而'],
    },
    Decomposition {
        kanji: '耎',
        radicals: &['大', '而'],
    },
    Decomposition {
        kanji: '耏',
        radicals: &['彡', '而'],
    },
    Decomposition {
        kanji: '耑',
        radicals: &['山', '而'],
    },
    Decomposition {
        kanji: '耓',
        radicals: &['一', 'ノ', '亅', '二', '木', '耒'],
    },
    Decomposition {
        kanji: '耔',
        radicals: &['ノ', '子', '木', '耒'],
    },
    Decomposition {
        kanji: '耖',
        radicals: &['ノ', '小', '木', '耒'],
    },
    Decomposition {
        kanji: '耝',
        radicals: &['一', 'ノ', '二', '木', '目', '耒'],
    },
    Decomposition {
        kanji: '耞',
        radicals: &['ノ', '力', '口', '木', '耒'],
    },
    Decomposition {
        kanji: '耟',
        radicals: &['一', 'ノ', '二', '匚', '口', '木', '耒'],
    },
    Decomposition {
        kanji: '耠',
        radicals: &['一', 'ノ', '𠆢', '口', '木', '耒'],
    },
    Decomposition {
        kanji: '耤',
        radicals: &['｜', 'ノ', '二', '日', '木', '耒'],
    },
    Decomposition {
        kanji: '耦',
        radicals: &['｜', 'ノ', '冂', '厶', '日', '木', '田', '⽱', '耒'],
    },
    Decomposition {
        kanji: '耬',
        radicals: &['ノ', '十', '口', '女', '木', '耒'],
    },
    Decomposition {
        kanji: '耮',
        radicals: &['ノ', '冖', '力', '木', '火', '耒'],
    },
    Decomposition {
        kanji: '耰',
        radicals: &['一', 'ノ', '冖', '夂', '心', '木', '目', '耒', '自'],
    },
    Decomposition {
        kanji: '耴',
        radicals: &['乙', '耳'],
    },
    Decomposition {
        kanji: '耵',
        radicals: &['一', '亅', '耳'],
    },
    Decomposition {
        kanji: '耷',
        radicals: &['大', '耳'],
    },
    Decomposition {
        kanji: '耹',
        radicals: &['一', '丶', '𠆢', '耳'],
    },
    Decomposition {
        kanji: '耺',
        radicals: &['二', '厶', '耳'],
    },
    Decomposition {
        kanji: '耼',
        radicals: &['二', '冂', '月', '耳'],
    },
    Decomposition {
        kanji: '耾',
        radicals: &['一', 'ノ', '厶', '耳'],
    },
    Decomposition {
        kanji: '聀',
        radicals: &['戈', '耳'],
    },
    Decomposition {
        kanji: '聄',
        radicals: &['𠆢', '彡', '耳'],
    },
    Decomposition {
        kanji: '聠',
        radicals: &['一', '丷', '廾', '耳'],
    },
    Decomposition {
        kanji: '聤',
        radicals: &['一', '亅', '亠', '冖', '口', '耳'],
    },
    Decomposition {
        kanji: '聦',
        radicals: &['丶', 'ノ', '勹', '心', '勿', '耳'],
    },
    Decomposition {
        kanji: '聭',
        radicals: &['儿', '匕', '厶', '田', '耳', '鬼'],
    },
    Decomposition {
        kanji: '聱',
        radicals: &['土', '士', '攵', '方', '耳'],
    },
    Decomposition {
        kanji: '聵',
        radicals: &['一', '｜', 'ハ', '口', '目', '耳', '虫', '貝'],
    },
    Decomposition {
        kanji: '肁',
        radicals: &['｜', '丶', '二', '尸', 'ヨ', '聿'],
    },
    Decomposition {
        kanji: '肈',
        radicals: &['一', '｜', '丶', '二', '尸', 'ヨ', '戈', '戸', '聿'],
    },
    Decomposition {
        kanji: '肎',
        radicals: &['冖', '月'],
    },
    Decomposition {
        kanji: '肜',
        radicals: &['彡', '月'],
    },
    Decomposition {
        kanji: '肞',
        radicals: &['丶', 'ノ', '又', '月'],
    },
    Decomposition {
        kanji: '肦',
        radicals: &['ハ', '冂', '冫', '刀', '月'],
    },
    Decomposition {
        kanji: '肧',
        radicals: &['一', '｜', '丶', 'ノ', '月'],
    },
    Decomposition {
        kanji: '肫',
        radicals: &['ノ', '乙', '凵', '月', '屯'],
    },
    Decomposition {
        kanji: '肸',
        radicals: &['ハ', '十', '月'],
    },
    Decomposition {
        kanji: '肹',
        radicals: &['一', 'ハ', '勹', '月'],
    },
    Decomposition {
        kanji: '胈',
        radicals: &['又', '弋', '月'],
    },
    Decomposition {
        kanji: '胍',
        radicals: &['厶', '月', '瓜'],
    },
    Decomposition {
        kanji: '胏',
        radicals: &['｜', 'ノ', '亅', '月'],
    },
    Decomposition {
        kanji: '胒',
        radicals: &['匕', '尸', '月'],
    },
    Decomposition {
        kanji: '胔',
        radicals: &['入', '冂', '匕', '止', '肉'],
    },
    Decomposition {
        kanji: '胕',
        radicals: &['⺅', '寸', '月'],
    },
    Decomposition {
        kanji: '胗',
        radicals: &['𠆢', '彡', '月'],
    },
    Decomposition {
        kanji: '胘',
        radicals: &['亠', '幺', '月', '玄'],
    },
    Decomposition {
        kanji: '胠',
        radicals: &['厶', '土', '月'],
    },
    Decomposition {
        kanji: '胭',
        radicals: &['囗', '大', '月'],
    },
    Decomposition {
        kanji: '胮',
        radicals: &['｜', '二', '夂', '月'],
    },
    Decomposition {
        kanji: '胰',
        radicals: &['大', '弓', '月'],
    },
    Decomposition {
        kanji: '胲',
        radicals: &['ノ', '亠', '幺', '月', '玄'],
    },
    Decomposition {
        kanji: '胳',
        radicals: &['口', '夂', '月'],
    },
    Decomposition {
        kanji: '胶',
        radicals: &['亠', '月', '父'],
    },
    Decomposition {
        kanji: '胹',
        radicals: &['月', '而'],
    },
    Decomposition {
        kanji: '胺',
        radicals: &['女', '宀', '月'],
    },
    Decomposition {
        kanji: '胾',
        radicals: &['入', '冂', '十', '土', '戈', '肉'],
    },
    Decomposition {
        kanji: '脃',
        radicals: &['乙', '刀', '勹', '已', '月', '巴', '色'],
    },
    Decomposition {
        kanji: '脋',
        radicals: &['刀', '月'],
    },
    Decomposition {
        kanji: '脖',
        radicals: &['冖', '十', '子', '月'],
    },
    Decomposition {
        kanji: '脗',
        radicals: &['ノ', '勹', '口', '月', '勿'],
    },
    Decomposition {
        kanji: '脘',
        radicals: &['二', '儿', '宀', '月', '元'],
    },
    Decomposition {
        kanji: '脜',
        radicals: &['一', '月', '目', '自'],
    },
    Decomposition {
        kanji: '脞',
        radicals: &['人', '土', '月'],
    },
    Decomposition {
        kanji: '脠',
        radicals: &['ノ', '廴', '月', '止'],
    },
    Decomposition {
        kanji: '脤',
        radicals: &['亠', '厂', '月', '衣', '辰'],
    },
    Decomposition {
        kanji: '脧',
        radicals: &['ハ', '冂', '冫', '厶', '夂', '月'],
    },
    Decomposition {
        kanji: '脬',
        radicals: &['子', '月', '爪'],
    },
    Decomposition {
        kanji: '脰',
        radicals: &['丷', '口', '月', '豆'],
    },
    Decomposition {
        kanji: '脵',
        radicals: &['一', '口', '大', '月'],
    },
    Decomposition {
        kanji: '脺',
        radicals: &['亠', '人', '十', '月'],
    },
    Decomposition {
        kanji: '脼',
        radicals: &['一', '｜', '入', '冂', '月'],
    },
    Decomposition {
        kanji: '腅',
        radicals: &['月', '火'],
    },
    Decomposition {
        kanji: '腇',
        radicals: &['ノ', '女', '月', '木', '禾'],
    },
    Decomposition {
        kanji: '腊',
        radicals: &['｜', '二', '日', '月'],
    },
    Decomposition {
        kanji: '腌',
        radicals: &['乙', '大', '日', '月', '奄'],
    },
    Decomposition {
        kanji: '腒',
        radicals: &['十', '口', '尸', '月'],
    },
    Decomposition {
        kanji: '腗',
        radicals: &['｜', '廾', '日', '月', '田'],
    },
    Decomposition {
        kanji: '腠',
        radicals: &['一', 'ノ', '大', '月'],
    },
    Decomposition {
        kanji: '腡',
        radicals: &['冂', '口', '月'],
    },
    Decomposition {
        kanji: '腧',
        radicals: &['一', '𠆢', '⺉', '月'],
    },
    Decomposition {
        kanji: '腨',
        radicals: &['山', '月', '而'],
    },
    Decomposition {
        kanji: '腩',
        radicals: &['一', '丷', '冂', '十', '干', '月'],
    },
    Decomposition {
        kanji: '腭',
        radicals: &['二', '勹', '口', '月'],
    },
    Decomposition {
        kanji: '腯',
        radicals: &['ノ', '十', '厂', '月', '目'],
    },
    Decomposition {
        kanji: '腷',
        radicals: &['一', '口', '月', '田'],
    },
    Decomposition {
        kanji: '膁',
        radicals: &['一', '｜', '丶', 'ノ', '丷', 'ヨ', '月'],
    },
    Decomposition {
        kanji: '膐',
        radicals: &['一', 'ノ', '入', '冂', '方', '氏', '肉'],
    },
    Decomposition {
        kanji: '膄',
        radicals: &['｜', '又', '月', '臼'],
    },
    Decomposition {
        kanji: '膅',
        radicals: &['｜', '口', '广', 'ヨ', '月'],
    },
    Decomposition {
        kanji: '膆',
        radicals: &['一', '｜', '二', '小', '幺', '月', '糸'],
    },
    Decomposition {
        kanji: '膋',
        radicals: &['冖', '月', '火'],
    },
    Decomposition {
        kanji: '膎',
        radicals: &['大', '幺', '月', '爪'],
    },
    Decomposition {
        kanji: '膖',
        radicals: &['一', '｜', '二', '⻌', '夂', '月'],
    },
    Decomposition {
        kanji: '膘',
        radicals: &['二', '小', '月', '示', '西'],
    },
    Decomposition {
        kanji: '膛',
        radicals: &['冖', '口', '土', '⺌', '月'],
    },
    Decomposition {
        kanji: '膞',
        radicals: &['一', '十', '厶', '寸', '日', '月', '虫'],
    },
    Decomposition {
        kanji: '膢',
        radicals: &['十', '口', '女', '月'],
    },
    Decomposition {
        kanji: '膮',
        radicals: &['一', '儿', '土', '月'],
    },
    Decomposition {
        kanji: '膲',
        radicals: &['月', '⺣', '隹'],
    },
    Decomposition {
        kanji: '膴',
        radicals: &['一', '｜', 'ノ', '月', '⺣', '無'],
    },
    Decomposition {
        kanji: '膻',
        radicals: &['一', '亠', '口', '囗', '日', '月'],
    },
    Decomposition {
        kanji: '臋',
        radicals: &['｜', '二', '入', 'ハ', '冂', '几', '又', '尸', '殳', '肉'],
    },
    Decomposition {
        kanji: '臃',
        radicals: &['亠', '幺', '月', '隹'],
    },
    Decomposition {
        kanji: '臅',
        radicals: &['勹', '月', '⺲', '虫'],
    },
    Decomposition {
        kanji: '臊',
        radicals: &['口', '月', '木'],
    },
    Decomposition {
        kanji: '臎',
        radicals: &['亠', '人', '冫', '十', '月', '羽'],
    },
    Decomposition {
        kanji: '臏',
        radicals: &['一', '｜', 'ノ', 'ハ', '宀', '月', '目', '貝'],
    },
    Decomposition {
        kanji: '臕',
        radicals: &['匕', '广', '月', '比', '⺣', '鹿'],
    },
    Decomposition {
        kanji: '臗',
        radicals: &['丶', '儿', '宀', '⺾', '月', '目', '見'],
    },
    Decomposition {
        kanji: '臛',
        radicals: &['二', '冖', '月', '隹', '雨'],
    },
    Decomposition {
        kanji: '臝',
        radicals: &['一', '丶', '亠', '几', '口', '亡', '月', '木', '田'],
    },
    Decomposition {
        kanji: '臞',
        radicals: &['月', '目', '隹'],
    },
    Decomposition {
        kanji: '臡',
        radicals: &['入', '冂', '十', '口', '大', '廾', '肉', '隹', '革'],
    },
    Decomposition {
        kanji: '臤',
        radicals: &['匚', '又', '臣'],
    },
    Decomposition {
        kanji: '臫',
        radicals: &['乙', '目', '自'],
    },
    Decomposition {
        kanji: '臬',
        radicals: &['木', '目', '自'],
    },
    Decomposition {
        kanji: '臰',
        radicals: &['一', '匕', '夕', '歹', '目', '自'],
    },
    Decomposition {
        kanji: '臱',
        radicals: &['丷', '宀', '方', '目', '自'],
    },
    Decomposition {
        kanji: '臲',
        radicals: &['勹', '卩', '厂', '木', '目', '自'],
    },
    Decomposition {
        kanji: '臵',
        radicals: &['一', '厶', '口', '土', '夂', '至'],
    },
    Decomposition {
        kanji: '臶',
        radicals: &['一', '｜', 'ノ', '厶', '土', '子', '至'],
    },
    Decomposition {
        kanji: '臸',
        radicals: &['一', '厶', '土', '至'],
    },
    Decomposition {
        kanji: '臹',
        radicals: &['一', 'ノ', '亅', '厂', '厶', '土', '戈', '至'],
    },
    Decomposition {
        kanji: '臽',
        radicals: &['勹', '臼'],
    },
    Decomposition {
        kanji: '臿',
        radicals: &['一', 'ノ', '十', '干', '臼'],
    },
    Decomposition {
        kanji: '舀',
        radicals: &['爪', '臼'],
    },
    Decomposition {
        kanji: '舃',
        radicals: &['⺣', '臼', '鳥'],
    },
    Decomposition {
        kanji: '舏',
        radicals: &['｜', '口', '舌'],
    },
    Decomposition {
        kanji: '舓',
        radicals: &['ノ', '勹', '口', '日', '勿', '舌'],
    },
    Decomposition {
        kanji: '舔',
        radicals: &['一', '口', '大', '⺣', '舌'],
    },
    Decomposition {
        kanji: '舙',
        radicals: &['口', '舌'],
    },
    Decomposition {
        kanji: '舚',
        radicals: &['儿', 'ハ', '勹', '厂', '口', '舌', '言'],
    },
    Decomposition {
        kanji: '舝',
        radicals: &['｜', '二', '冖', '厶', 'ユ', '巛'],
    },
    Decomposition {
        kanji: '舡',
        radicals: &['一', '｜', '丶', '冂', '工', '舟'],
    },
    Decomposition {
        kanji: '舢',
        radicals: &['一', '｜', '丶', '冂', '山', '舟'],
    },
    Decomposition {
        kanji: '舨',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '又', '舟'],
    },
    Decomposition {
        kanji: '舲',
        radicals: &['一', '｜', '丶', '亅', '人', '冂', 'マ', '舟'],
    },
    Decomposition {
        kanji: '舴',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '舟'],
    },
    Decomposition {
        kanji: '舺',
        radicals: &['一', '｜', '丶', '冂', '日', '舟'],
    },
    Decomposition {
        kanji: '艃',
        radicals: &['一', '｜', '丶', '冂', '舟', '里'],
    },
    Decomposition {
        kanji: '艄',
        radicals: &['一', '｜', '丶', '冂', '⺌', '月', '舟'],
    },
    Decomposition {
        kanji: '艅',
        radicals: &['一', '｜', '丶', '𠆢', '冂', '小', '舟'],
    },
    Decomposition {
        kanji: '艆',
        radicals: &['一', '｜', '丶', '冂', '舟', '艮'],
    },
    Decomposition {
        kanji: '艋',
        radicals: &['一', '｜', '丶', '冂', '子', '皿', '舟'],
    },
    Decomposition {
        kanji: '艎',
        radicals: &['一', '｜', '丶', '冂', '日', '王', '白', '舟'],
    },
    Decomposition {
        kanji: '艏',
        radicals: &['一', '｜', '丶', '丷', '冂', '目', '自', '舟', '首'],
    },
    Decomposition {
        kanji: '艑',
        radicals: &['一', '｜', '丶', '亅', '冂', '尸', '戸', '冊', '舟', '廾'],
    },
    Decomposition {
        kanji: '艖',
        radicals: &['一', '｜', '丶', '丷', '冂', '工', '王', '羊', '舟'],
    },
    Decomposition {
        kanji: '艜',
        radicals: &['一', '｜', '丶', '乙', '冂', '冖', '巾', '廾', '舟'],
    },
    Decomposition {
        kanji: '艠',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '冂', '口', '舟', '豆'],
    },
    Decomposition {
        kanji: '艣',
        radicals: &[
            '一', '｜', '丶', '冂', '力', '匕', '卜', '厂', '田', '舟', '虍',
        ],
    },
    Decomposition {
        kanji: '艧',
        radicals: &['一', '｜', '丶', '冂', '又', '⺾', '舟', '隹'],
    },
    Decomposition {
        kanji: '艭',
        radicals: &['一', '｜', '丶', '冂', '又', '舟', '隹'],
    },
    Decomposition {
        kanji: '艴',
        radicals: &['乙', '勹', '已', '廾', '弓', '巴', '色'],
    },
    Decomposition {
        kanji: '艻',
        radicals: &['力', '⺾'],
    },
    Decomposition {
        kanji: '艽',
        radicals: &['九', '⺾'],
    },
    Decomposition {
        kanji: '艿',
        radicals: &['乃', '⺾'],
    },
    Decomposition {
        kanji: '芀',
        radicals: &['刀', '⺾'],
    },
    Decomposition {
        kanji: '芁',
        radicals: &['几', '⺾'],
    },
    Decomposition {
        kanji: '芃',
        radicals: &['丶', '几', '⺾'],
    },
    Decomposition {
        kanji: '芄',
        radicals: &['丶', '九', '⺾'],
    },
    Decomposition {
        kanji: '芇',
        radicals: &['｜', '冂', '巾', '⺾'],
    },
    Decomposition {
        kanji: '芉',
        radicals: &['一', '十', '干', '⺾'],
    },
    Decomposition {
        kanji: '芊',
        radicals: &['一', 'ノ', '十', '干', '⺾'],
    },
    Decomposition {
        kanji: '芎',
        radicals: &['弓', '⺾'],
    },
    Decomposition {
        kanji: '芑',
        radicals: &['已', '⺾'],
    },
    Decomposition {
        kanji: '芔',
        radicals: &['屮', '⺾'],
    },
    Decomposition {
        kanji: '芖',
        radicals: &['大', '⺾'],
    },
    Decomposition {
        kanji: '芘',
        radicals: &['匕', '⺾', '比'],
    },
    Decomposition {
        kanji: '芚',
        radicals: &['ノ', '乙', '凵', '⺾', '屯'],
    },
    Decomposition {
        kanji: '芛',
        radicals: &['ノ', 'ヨ', '⺾'],
    },
    Decomposition {
        kanji: '芠',
        radicals: &['⺾', '文'],
    },
    Decomposition {
        kanji: '芡',
        radicals: &['人', '勹', '⺾', '欠'],
    },
    Decomposition {
        kanji: '芣',
        radicals: &['一', '｜', '丶', 'ノ', '⺾'],
    },
    Decomposition {
        kanji: '芤',
        radicals: &['乙', '子', '⺾'],
    },
    Decomposition {
        kanji: '芧',
        radicals: &['マ', '⺾', '矛'],
    },
    Decomposition {
        kanji: '芨',
        radicals: &['丶', 'ノ', '又', '乃', '⺾', '及'],
    },
    Decomposition {
        kanji: '芩',
        radicals: &['一', '丶', '𠆢', '⺾'],
    },
    Decomposition {
        kanji: '芪',
        radicals: &['⺾', '氏'],
    },
    Decomposition {
        kanji: '芮',
        radicals: &['人', '入', '冂', '⺾'],
    },
    Decomposition {
        kanji: '芰',
        radicals: &['十', '又', '⺾', '支'],
    },
    Decomposition {
        kanji: '芲',
        radicals: &['ノ', '乙', '𠆢', '匕', '⺾'],
    },
    Decomposition {
        kanji: '芴',
        radicals: &['ノ', '勹', '⺾', '勿'],
    },
    Decomposition {
        kanji: '芷',
        radicals: &['⺾', '止'],
    },
    Decomposition {
        kanji: '芺',
        radicals: &['丶', '大', '⺾'],
    },
    Decomposition {
        kanji: '芼',
        radicals: &['一', 'ノ', '乙', '二', '⺾', '手'],
    },
    Decomposition {
        kanji: '芾',
        radicals: &['一', '｜', '亠', '冂', '十', '巾', '⺾'],
    },
    Decomposition {
        kanji: '芿',
        radicals: &['⺅', '乃', '⺾'],
    },
    Decomposition {
        kanji: '苆',
        radicals: &['一', '乙', '刀', '匕', '⺾'],
    },
    Decomposition {
        kanji: '苐',
        radicals: &['｜', 'ノ', '弓', '⺾'],
    },
    Decomposition {
        kanji: '苕',
        radicals: &['刀', '口', '⺾'],
    },
    Decomposition {
        kanji: '苚',
        radicals: &['｜', '二', '冂', '⺾', '用'],
    },
    Decomposition {
        kanji: '苠',
        radicals: &['尸', '⺾', '氏'],
    },
    Decomposition {
        kanji: '苢',
        radicals: &['｜', '口', '⺾'],
    },
    Decomposition {
        kanji: '苤',
        radicals: &['｜', '丶', 'ノ', '二', '⺾'],
    },
    Decomposition {
        kanji: '苨',
        radicals: &['匕', '尸', '⺾'],
    },
    Decomposition {
        kanji: '苪',
        radicals: &['一', '人', '冂', '⺾'],
    },
    Decomposition {
        kanji: '苭',
        radicals: &['力', '幺', '⺾'],
    },
    Decomposition {
        kanji: '苯',
        radicals: &['一', '⺾', '木'],
    },
    Decomposition {
        kanji: '苶',
        radicals: &['𠆢', '小', '⺾'],
    },
    Decomposition {
        kanji: '苷',
        radicals: &['⺾', '甘'],
    },
    Decomposition {
        kanji: '苽',
        radicals: &['厶', '⺾', '瓜'],
    },
    Decomposition {
        kanji: '苾',
        radicals: &['ノ', '⺾', '心'],
    },
    Decomposition {
        kanji: '茀',
        radicals: &['廾', '弓', '⺾'],
    },
    Decomposition {
        kanji: '茁',
        radicals: &['｜', '凵', '⺾'],
    },
    Decomposition {
        kanji: '茇',
        radicals: &['丶', 'ノ', '又', '弋', '⺾'],
    },
    Decomposition {
        kanji: '茈',
        radicals: &['匕', '⺾', '止'],
    },
    Decomposition {
        kanji: '茊',
        radicals: &['一', '⺾', '斤'],
    },
    Decomposition {
        kanji: '茋',
        radicals: &['丶', '⺾', '氏'],
    },
    Decomposition {
        kanji: '荔',
        radicals: &['力', '⺾'],
    },
    Decomposition {
        kanji: '茛',
        radicals: &['⺾', '艮'],
    },
    Decomposition {
        kanji: '茝',
        radicals: &['匚', '⺾', '臣'],
    },
    Decomposition {
        kanji: '茞',
        radicals: &['匚', '⺾', '臣'],
    },
    Decomposition {
        kanji: '茟',
        radicals: &['｜', '二', 'ヨ', '⺾', '聿'],
    },
    Decomposition {
        kanji: '茡',
        radicals: &['子', '宀', '⺾'],
    },
    Decomposition {
        kanji: '茢',
        radicals: &['⺉', '⺾', '歹'],
    },
    Decomposition {
        kanji: '茬',
        radicals: &['一', '｜', 'ノ', '土', '⺾'],
    },
    Decomposition {
        kanji: '茭',
        radicals: &['亠', '⺾', '父'],
    },
    Decomposition {
        kanji: '茮',
        radicals: &['一', '卜', '小', '⺾'],
    },
    Decomposition {
        kanji: '茰',
        radicals: &['丶', 'ノ', '⺾', '日'],
    },
    Decomposition {
        kanji: '茳',
        radicals: &['工', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '茷',
        radicals: &['⺅', '⺾', '戈'],
    },
    Decomposition {
        kanji: '茺',
        radicals: &['亠', '儿', '厶', '⺾'],
    },
    Decomposition {
        kanji: '茼',
        radicals: &['一', '冂', '口', '⺾'],
    },
    Decomposition {
        kanji: '茽',
        radicals: &['｜', '⺅', '口', '⺾'],
    },
    Decomposition {
        kanji: '荂',
        radicals: &['二', '勹', '大', '⺾'],
    },
    Decomposition {
        kanji: '荃',
        radicals: &['𠆢', '⺾', '王'],
    },
    Decomposition {
        kanji: '荄',
        radicals: &['ノ', '亠', '幺', '⺾', '玄'],
    },
    Decomposition {
        kanji: '荇',
        radicals: &['彳', '⺾', '行'],
    },
    Decomposition {
        kanji: '荍',
        radicals: &['｜', '⺾', '攵'],
    },
    Decomposition {
        kanji: '荎',
        radicals: &['一', '厶', '土', '⺾', '至'],
    },
    Decomposition {
        kanji: '荑',
        radicals: &['大', '弓', '⺾'],
    },
    Decomposition {
        kanji: '荕',
        radicals: &['力', '⺾', '月'],
    },
    Decomposition {
        kanji: '荖',
        radicals: &['ノ', '匕', '土', '⺾', '⺹'],
    },
    Decomposition {
        kanji: '荗',
        radicals: &['丶', 'ノ', '厂', '⺾', '戈'],
    },
    Decomposition {
        kanji: '荰',
        radicals: &['土', '⺾', '木'],
    },
    Decomposition {
        kanji: '荸',
        radicals: &['冖', '十', '子', '⺾'],
    },
    Decomposition {
        kanji: '荽',
        radicals: &['女', '⺾', '爪'],
    },
    Decomposition {
        kanji: '荿',
        radicals: &['ノ', '亅', '厂', '⺾', '戈'],
    },
    Decomposition {
        kanji: '莀',
        radicals: &['亠', '厂', '⺾', '衣', '辰'],
    },
    Decomposition {
        kanji: '莂',
        radicals: &['⺉', '力', '口', '⺾'],
    },
    Decomposition {
        kanji: '莄',
        radicals: &['一', '丶', 'ノ', '⺾', '日'],
    },
    Decomposition {
        kanji: '莆',
        radicals: &['丶', '十', '⺾', '月'],
    },
    Decomposition {
        kanji: '莍',
        radicals: &['一', '丶', '⺾', '水'],
    },
    Decomposition {
        kanji: '莒',
        radicals: &['ノ', '口', '⺾'],
    },
    Decomposition {
        kanji: '莔',
        radicals: &['儿', 'ハ', '口', '囗', '⺾'],
    },
    Decomposition {
        kanji: '莕',
        radicals: &['口', '⺾', '木'],
    },
    Decomposition {
        kanji: '莘',
        radicals: &['十', '⺾', '立', '辛'],
    },
    Decomposition {
        kanji: '莙',
        radicals: &['ノ', '口', 'ヨ', '⺾'],
    },
    Decomposition {
        kanji: '莛',
        radicals: &['ノ', '土', '士', '廴', '⺾', '王'],
    },
    Decomposition {
        kanji: '莜',
        radicals: &['｜', '⺅', '⺾', '攵'],
    },
    Decomposition {
        kanji: '莝',
        radicals: &['人', '土', '⺾'],
    },
    Decomposition {
        kanji: '莦',
        radicals: &['⺌', '⺾', '月'],
    },
    Decomposition {
        kanji: '莧',
        radicals: &['儿', '⺾', '目', '見'],
    },
    Decomposition {
        kanji: '莩',
        radicals: &['子', '⺾', '爪'],
    },
    Decomposition {
        kanji: '莬',
        radicals: &['一', '｜', '儿', '勹', '口', '⺾', '免'],
    },
    Decomposition {
        kanji: '莾',
        radicals: &['十', '大', '廾', '⺾'],
    },
    Decomposition {
        kanji: '莿',
        radicals: &['冂', '⺉', '⺾', '木'],
    },
    Decomposition {
        kanji: '菀',
        radicals: &['卩', '夕', '宀', '⺾'],
    },
    Decomposition {
        kanji: '菇',
        radicals: &['十', '口', '女', '⺾'],
    },
    Decomposition {
        kanji: '菉',
        radicals: &['ヨ', '彑', '⺾', '水'],
    },
    Decomposition {
        kanji: '菏',
        radicals: &['一', '亅', '口', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '菐',
        radicals: &['一', '｜', '丶', 'ノ', '二', '丷', '大'],
    },
    Decomposition {
        kanji: '菑',
        radicals: &['巛', '⺾', '田'],
    },
    Decomposition {
        kanji: '菔',
        radicals: &['卩', '又', '⺾', '月'],
    },
    Decomposition {
        kanji: '菝',
        radicals: &['丶', 'ノ', '又', '弋', '扌', '⺾'],
    },
    Decomposition {
        kanji: '荓',
        radicals: &['一', '丷', '廾', '⺾'],
    },
    Decomposition {
        kanji: '菨',
        radicals: &['女', '⺾', '立'],
    },
    Decomposition {
        kanji: '菪',
        radicals: &['口', '宀', '⺾', '石'],
    },
    Decomposition {
        kanji: '菶',
        radicals: &['一', '｜', '二', '大', '⺾'],
    },
    Decomposition {
        kanji: '菸',
        radicals: &['丶', '𠆢', '⺾', '方'],
    },
    Decomposition {
        kanji: '菹',
        radicals: &['一', '⺡', '⺾', '目'],
    },
    Decomposition {
        kanji: '菼',
        radicals: &['⺾', '火'],
    },
    Decomposition {
        kanji: '萁',
        radicals: &['｜', '二', 'ハ', '⺾'],
    },
    Decomposition {
        kanji: '萆',
        radicals: &['ノ', '十', '⺾', '日', '白'],
    },
    Decomposition {
        kanji: '萊',
        radicals: &['人', '⺾', '木'],
    },
    Decomposition {
        kanji: '萏',
        radicals: &['勹', '⺾', '臼'],
    },
    Decomposition {
        kanji: '萑',
        radicals: &['⺾', '隹'],
    },
    Decomposition {
        kanji: '萕',
        radicals: &['廾', '⺾', '文'],
    },
    Decomposition {
        kanji: '萙',
        radicals: &['ノ', '乙', '冖', '尢', '⺾', '木'],
    },
    Decomposition {
        kanji: '莭',
        radicals: &['卩', '厶', '⺾', '日'],
    },
    Decomposition {
        kanji: '萯',
        radicals: &['ハ', '勹', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '萹',
        radicals: &['一', '｜', '丶', '亅', '冂', '尸', '⺾', '戸', '冊', '廾'],
    },
    Decomposition {
        kanji: '葅',
        radicals: &['一', '人', '⺾', '目'],
    },
    Decomposition {
        kanji: '葇',
        radicals: &['マ', '⺾', '木', '矛'],
    },
    Decomposition {
        kanji: '葈',
        radicals: &['厶', '口', '⺾', '木'],
    },
    Decomposition {
        kanji: '葊',
        radicals: &['一', '𠆢', '口', '廾', '⺾'],
    },
    Decomposition {
        kanji: '葍',
        radicals: &['一', '口', '⺾', '田'],
    },
    Decomposition {
        kanji: '葏',
        radicals: &['｜', '二', 'ヨ', '⺡', '⺾', '聿'],
    },
    Decomposition {
        kanji: '葑',
        radicals: &['土', '寸', '⺾'],
    },
    Decomposition {
        kanji: '葒',
        radicals: &['小', '工', '幺', '⺾', '糸'],
    },
    Decomposition {
        kanji: '葖',
        radicals: &['ハ', '大', '宀', '⺾'],
    },
    Decomposition {
        kanji: '葘',
        radicals: &['一', '巛', '⺾', '田'],
    },
    Decomposition {
        kanji: '葙',
        radicals: &['⺾', '木', '目'],
    },
    Decomposition {
        kanji: '葚',
        radicals: &['一', '儿', 'ハ', '匚', '⺾', '目'],
    },
    Decomposition {
        kanji: '葜',
        radicals: &['一', '｜', '二', '刀', '大', '⺾'],
    },
    Decomposition {
        kanji: '葠',
        radicals: &['⺅', '冖', '又', 'ヨ', '⺾'],
    },
    Decomposition {
        kanji: '葤',
        radicals: &['寸', '小', '幺', '⺾', '糸'],
    },
    Decomposition {
        kanji: '葥',
        radicals: &['一', '丷', '⺉', '⺾', '月'],
    },
    Decomposition {
        kanji: '葧',
        radicals: &['冖', '力', '十', '子', '⺾'],
    },
    Decomposition {
        kanji: '葪',
        radicals: &['｜', '⺉', '勹', '⺾', '月', '角'],
    },
    Decomposition {
        kanji: '葰',
        radicals: &['⺅', '儿', 'ハ', '厶', '夂', '⺾'],
    },
    Decomposition {
        kanji: '葳',
        radicals: &['一', 'ノ', '厂', '女', '⺾', '戈'],
    },
    Decomposition {
        kanji: '葴',
        radicals: &['一', 'ノ', '厂', '口', '⺾', '戈'],
    },
    Decomposition {
        kanji: '葶',
        radicals: &['一', '亅', '亠', '冖', '口', '⺾'],
    },
    Decomposition {
        kanji: '葸',
        radicals: &['⺾', '心', '田'],
    },
    Decomposition {
        kanji: '葼',
        radicals: &['丶', 'ノ', '儿', 'ハ', '凵', '夂', '⺾'],
    },
    Decomposition {
        kanji: '葽',
        radicals: &['女', '⺾', '西'],
    },
    Decomposition {
        kanji: '蒁',
        radicals: &['丶', '⻌', '⺾', '木'],
    },
    Decomposition {
        kanji: '蒅',
        radicals: &['九', '⺡', '⺾', '木'],
    },
    Decomposition {
        kanji: '蒒',
        radicals: &['一', '｜', 'ノ', '冂', '口', '巾', '⺾'],
    },
    Decomposition {
        kanji: '蒓',
        radicals: &['ノ', '乙', '凵', '小', '幺', '⺾', '屯', '糸'],
    },
    Decomposition {
        kanji: '蒕',
        radicals: &['人', '口', '⺾', '皿'],
    },
    Decomposition {
        kanji: '蒞',
        radicals: &['⺅', '⺡', '⺾', '立'],
    },
    Decomposition {
        kanji: '蒦',
        radicals: &['又', '⺾', '隹'],
    },
    Decomposition {
        kanji: '蒨',
        radicals: &['二', '亠', '⺅', '土', '⺾', '月', '青'],
    },
    Decomposition {
        kanji: '蒩',
        radicals: &['一', 'ノ', '⺾', '木', '目', '禾'],
    },
    Decomposition {
        kanji: '蒪',
        radicals: &['一', '｜', '丶', '二', '冂', '十', '寸', '⺾', '日'],
    },
    Decomposition {
        kanji: '蒯',
        radicals: &['丶', '冂', '⺉', '⺾', '月'],
    },
    Decomposition {
        kanji: '蒱',
        radicals: &['丶', '十', '扌', '⺾', '月'],
    },
    Decomposition {
        kanji: '蒴',
        radicals: &['一', '丷', '屮', '⺾', '月'],
    },
    Decomposition {
        kanji: '蒺',
        radicals: &['一', 'ノ', '大', '⺾', '⽧', '矢'],
    },
    Decomposition {
        kanji: '蒽',
        radicals: &['囗', '大', '⺾', '心'],
    },
    Decomposition {
        kanji: '蒾',
        radicals: &['⻌', '⺾', '米'],
    },
    Decomposition {
        kanji: '蓀',
        radicals: &['ノ', '子', '小', '幺', '⺾', '糸'],
    },
    Decomposition {
        kanji: '蓂',
        radicals: &['亠', 'ハ', '冖', '⺾', '日'],
    },
    Decomposition {
        kanji: '蓇',
        radicals: &['冂', '冖', '⺾', '月', '骨'],
    },
    Decomposition {
        kanji: '蓈',
        radicals: &['丶', '厶', '⺾', '⻏', '日'],
    },
    Decomposition {
        kanji: '蓌',
        radicals: &['人', '土', '夂', '⺾'],
    },
    Decomposition {
        kanji: '蓏',
        radicals: &['厶', '⺾', '瓜'],
    },
    Decomposition {
        kanji: '蓓',
        radicals: &['⺅', '口', '⺾', '立'],
    },
    Decomposition {
        kanji: '蓜',
        radicals: &['已', '⺾', '酉'],
    },
    Decomposition {
        kanji: '蓧',
        radicals: &['一', '｜', '⺅', '夂', '小', '⺾', '木'],
    },
    Decomposition {
        kanji: '蓪',
        radicals: &['マ', '⻌', '⺾', '用'],
    },
    Decomposition {
        kanji: '蓯',
        radicals: &['人', '彳', '⺾', '止'],
    },
    Decomposition {
        kanji: '蓰',
        radicals: &['彳', '⺾', '止'],
    },
    Decomposition {
        kanji: '蓱',
        radicals: &['一', 'ノ', '丷', '十', '干', '廾', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '蓲',
        radicals: &['匚', '口', '⺾'],
    },
    Decomposition {
        kanji: '蓷',
        radicals: &['扌', '⺾', '隹'],
    },
    Decomposition {
        kanji: '蔲',
        radicals: &['二', '儿', '宀', '⺾', '攵', '元'],
    },
    Decomposition {
        kanji: '蓺',
        radicals: &['丶', '儿', 'ハ', '九', '土', '⺾'],
    },
    Decomposition {
        kanji: '蓻',
        radicals: &['一', '丶', '丷', '十', '九', '土', '干', '⺾'],
    },
    Decomposition {
        kanji: '蓽',
        radicals: &['一', '｜', '二', '⺾', '日'],
    },
    Decomposition {
        kanji: '蔂',
        radicals: &['小', '幺', '⺾', '田', '糸'],
    },
    Decomposition {
        kanji: '蔃',
        radicals: &['口', '弓', '⺾', '虫'],
    },
    Decomposition {
        kanji: '蔇',
        radicals: &['厶', '⺾', '无', '日', '曰'],
    },
    Decomposition {
        kanji: '蔌',
        radicals: &['人', '勹', '口', '⺾', '木', '欠'],
    },
    Decomposition {
        kanji: '蔎',
        radicals: &['几', '又', '⺾', '殳', '言'],
    },
    Decomposition {
        kanji: '蔐',
        radicals: &['亠', '丷', '冂', '十', '口', '⺾', '立', '啇'],
    },
    Decomposition {
        kanji: '蔜',
        radicals: &['士', '⺾', '攵', '方'],
    },
    Decomposition {
        kanji: '蔞',
        radicals: &['十', '口', '女', '⺾'],
    },
    Decomposition {
        kanji: '蔢',
        radicals: &['ノ', '十', '厂', '又', '女', '⺡', '⺾', '支'],
    },
    Decomposition {
        kanji: '蔣',
        radicals: &['丶', '夕', '寸', '⺾', '爿'],
    },
    Decomposition {
        kanji: '蔤',
        radicals: &['ノ', '宀', '山', '⺾', '心'],
    },
    Decomposition {
        kanji: '蔥',
        radicals: &['ノ', '口', '夂', '⺾', '心'],
    },
    Decomposition {
        kanji: '蔧',
        radicals: &['一', '｜', '二', 'ヨ', '⺾'],
    },
    Decomposition {
        kanji: '蔪',
        radicals: &['⺾', '斤', '車'],
    },
    Decomposition {
        kanji: '蔫',
        radicals: &['一', '亅', '勹', '⺾', '止', '⺣'],
    },
    Decomposition {
        kanji: '蔯',
        radicals: &['⺾', '⻖', '日', '木'],
    },
    Decomposition {
        kanji: '蔳',
        radicals: &['二', '亠', '土', '⺡', '⺾', '月', '青'],
    },
    Decomposition {
        kanji: '蔴',
        radicals: &['广', '⺾', '木', '麻'],
    },
    Decomposition {
        kanji: '蔶',
        radicals: &['一', '｜', '二', 'ハ', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '蔿',
        radicals: &['乃', '⺾', '⺣', '爪'],
    },
    Decomposition {
        kanji: '蕆',
        radicals: &['ノ', 'ハ', '厂', '⺾', '戈', '目', '貝'],
    },
    Decomposition {
        kanji: '蕏',
        radicals: &['ノ', '土', '⺨', '⺾', '⺹', '日'],
    },
    Decomposition {
        kanji: '蕐',
        radicals: &['一', '｜', '二', '人', '⺾'],
    },
    Decomposition {
        kanji: '蕑',
        radicals: &['⺾', '月', '門'],
    },
    Decomposition {
        kanji: '蕒',
        radicals: &['ハ', '⺾', '目', '⺲', '貝'],
    },
    Decomposition {
        kanji: '蕓',
        radicals: &['二', '冖', '厶', '⺾', '雨'],
    },
    Decomposition {
        kanji: '蕖',
        radicals: &['匚', '口', '⺡', '⺾', '木'],
    },
    Decomposition {
        kanji: '蕙',
        radicals: &['十', '⺾', '心', '虫'],
    },
    Decomposition {
        kanji: '蕜',
        radicals: &['⺾', '心', '非'],
    },
    Decomposition {
        kanji: '蕝',
        radicals: &['乙', '勹', '小', '已', '幺', '⺾', '巴', '糸', '色'],
    },
    Decomposition {
        kanji: '蕞',
        radicals: &['又', '⺾', '日', '耳'],
    },
    Decomposition {
        kanji: '蕟',
        radicals: &['丶', 'ノ', '几', '又', '弓', '⺾', '殳'],
    },
    Decomposition {
        kanji: '蕠',
        radicals: &['口', '女', '小', '幺', '⺾', '糸'],
    },
    Decomposition {
        kanji: '蕡',
        radicals: &['ハ', '十', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '蕢',
        radicals: &['一', '｜', 'ハ', '口', '⺾', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '蕤',
        radicals: &['⺾', '生', '豕'],
    },
    Decomposition {
        kanji: '蕫',
        radicals: &['⺾', '立', '里'],
    },
    Decomposition {
        kanji: '蕯',
        radicals: &['｜', 'ノ', '二', '夂', '⺾', '⻖'],
    },
    Decomposition {
        kanji: '蕹',
        radicals: &['亠', '幺', '⺾', '隹'],
    },
    Decomposition {
        kanji: '蕺',
        radicals: &['口', '⺾', '戈', '耳'],
    },
    Decomposition {
        kanji: '蕻',
        radicals: &['｜', '二', 'ハ', '⺾', '長'],
    },
    Decomposition {
        kanji: '蕽',
        radicals: &['｜', '厂', '⺾', '日', '衣', '辰'],
    },
    Decomposition {
        kanji: '蕿',
        radicals: &['ノ', '二', '又', '⺾', '火', '爪'],
    },
    Decomposition {
        kanji: '薁',
        radicals: &['ノ', '冂', '大', '⺾', '米'],
    },
    Decomposition {
        kanji: '薅',
        radicals: &['厂', '女', '寸', '⺾', '衣', '辰'],
    },
    Decomposition {
        kanji: '薆',
        radicals: &['冖', '夂', '⺾', '心', '爪'],
    },
    Decomposition {
        kanji: '薉',
        radicals: &['一', 'ノ', '厂', '小', '⺾', '戈', '止'],
    },
    Decomposition {
        kanji: '薋',
        radicals: &['𠆢', 'ハ', '冖', '冫', '勹', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '薌',
        radicals: &['匕', '厶', '幺', '⺾', '⻏', '日', '白'],
    },
    Decomposition {
        kanji: '薏',
        radicals: &['⺾', '心', '日', '立'],
    },
    Decomposition {
        kanji: '薓',
        radicals: &['｜', '冂', '冖', '又', '巾', 'ヨ', '⺡', '⺾'],
    },
    Decomposition {
        kanji: '薘',
        radicals: &['丷', '⻌', '土', '⺾', '王', '羊'],
    },
    Decomposition {
        kanji: '薝',
        radicals: &['儿', 'ハ', '勹', '厂', '⺾', '言'],
    },
    Decomposition {
        kanji: '薟',
        radicals: &['一', '人', '𠆢', '口', '⺾'],
    },
    Decomposition {
        kanji: '薠',
        radicals: &['ハ', '⺾', '火', '目', '貝', '頁'],
    },
    Decomposition {
        kanji: '薢',
        radicals: &['｜', '刀', '勹', '⺾', '月', '牛', '角'],
    },
    Decomposition {
        kanji: '薥',
        radicals: &['勹', '⺾', '⺲', '虫'],
    },
    Decomposition {
        kanji: '薧',
        radicals: &['一', '亠', '冖', '匕', '口', '夕', '⺾', '歹'],
    },
    Decomposition {
        kanji: '薴',
        radicals: &['一', '亅', '宀', '⺾', '心', '皿'],
    },
    Decomposition {
        kanji: '薶',
        radicals: &['⺾', '豸', '里'],
    },
    Decomposition {
        kanji: '薷',
        radicals: &['二', '冖', '⺾', '而', '雨'],
    },
    Decomposition {
        kanji: '薸',
        radicals: &['二', '小', '⺡', '⺾', '示', '西'],
    },
    Decomposition {
        kanji: '薼',
        radicals: &['匕', '土', '广', '⺾', '比', '鹿'],
    },
    Decomposition {
        kanji: '薽',
        radicals: &['一', '丶', '乙', '二', '土', '⺾', '西'],
    },
    Decomposition {
        kanji: '薾',
        radicals: &['一', '｜', '冂', '⺾', '爻'],
    },
    Decomposition {
        kanji: '薿',
        radicals: &['一', 'ノ', '匕', 'マ', '大', '⺾', '疋', '矢'],
    },
    Decomposition {
        kanji: '藂',
        radicals: &['｜', '丶', 'ノ', '又', '⺾', '耳'],
    },
    Decomposition {
        kanji: '藇',
        radicals: &['一', '｜', '亠', 'ハ', '⺾', '臼'],
    },
    Decomposition {
        kanji: '藊',
        radicals: &[
            '一', '｜', '丶', 'ノ', '亅', '冂', '尸', '⺾', '戸', '木', '禾', '冊', '廾',
        ],
    },
    Decomposition {
        kanji: '藋',
        radicals: &['ノ', '冫', '⺾', '羽', '隹'],
    },
    Decomposition {
        kanji: '藎',
        radicals: &['一', '｜', 'ヨ', '⺾', '⺣', '皿'],
    },
    Decomposition {
        kanji: '薭',
        radicals: &['ノ', '十', '⺾', '日', '木', '白', '禾'],
    },
    Decomposition {
        kanji: '藘',
        radicals: &['匕', '卜', '厂', '⺾', '心', '田', '虍'],
    },
    Decomposition {
        kanji: '藚',
        radicals: &['ハ', '士', '⺾', '目', '⺲', '貝'],
    },
    Decomposition {
        kanji: '藟',
        radicals: &['⺾', '田'],
    },
    Decomposition {
        kanji: '藠',
        radicals: &['⺾', '日', '白'],
    },
    Decomposition {
        kanji: '藦',
        radicals: &['广', '⺾', '手', '木', '麻'],
    },
    Decomposition {
        kanji: '藨',
        radicals: &['匕', '广', '⺾', '比', '⺣', '鹿'],
    },
    Decomposition {
        kanji: '藭',
        radicals: &['儿', 'ハ', '宀', '弓', '⺾', '身'],
    },
    Decomposition {
        kanji: '藳',
        radicals: &['ノ', '亠', '冂', '口', '⺾', '木', '禾', '高'],
    },
    Decomposition {
        kanji: '藶',
        radicals: &['ノ', '厂', '⺾', '木', '止', '禾'],
    },
    Decomposition {
        kanji: '藼',
        radicals: &['一', '｜', '二', '宀', '⺾', '心', '⺲'],
    },
    Decomposition {
        kanji: '藿',
        radicals: &['二', '冖', '⺾', '隹', '雨'],
    },
    Decomposition {
        kanji: '蘀',
        radicals: &['一', '丷', '十', '土', '干', '扌', '⺾', '⺲'],
    },
    Decomposition {
        kanji: '蘄',
        radicals: &['十', '口', '⺾', '斤', '日', '田'],
    },
    Decomposition {
        kanji: '蘅',
        radicals: &['亅', '二', '勹', '大', '彳', '⺾', '田'],
    },
    Decomposition {
        kanji: '蘍',
        radicals: &['一', '｜', 'ノ', '丷', '力', '口', '⺾', '⺣'],
    },
    Decomposition {
        kanji: '蘎',
        radicals: &['乙', '二', '冖', '已', '⺾', '月', '巴', '雨'],
    },
    Decomposition {
        kanji: '蘐',
        radicals: &['ノ', '二', '又', '⺾', '爪', '言'],
    },
    Decomposition {
        kanji: '蘑',
        radicals: &['口', '广', '⺾', '木', '石', '麻'],
    },
    Decomposition {
        kanji: '蘒',
        radicals: &['ノ', '乙', '勹', '⺾', '木', '田', '禾', '亀'],
    },
    Decomposition {
        kanji: '蘘',
        radicals: &['一', '｜', '二', '亠', '口', '⺾', '衣'],
    },
    Decomposition {
        kanji: '蘙',
        radicals: &[
            '一', 'ノ', '冫', '几', '匚', '又', '大', '⺾', '殳', '矢', '羽',
        ],
    },
    Decomposition {
        kanji: '蘛',
        radicals: &['一', '｜', '亠', 'ハ', '匚', '厶', '⺾', '月', '甘'],
    },
    Decomposition {
        kanji: '蘞',
        radicals: &['一', '人', '𠆢', '口', '⺾', '攵'],
    },
    Decomposition {
        kanji: '蘡',
        radicals: &['ハ', '女', '⺾', '目', '貝'],
    },
    Decomposition {
        kanji: '蘧',
        radicals: &['匕', '卜', '厂', '⻌', '⺾', '虍', '豕'],
    },
    Decomposition {
        kanji: '蘩',
        radicals: &['一', 'ノ', '小', '幺', '⺾', '攵', '毋', '母', '糸'],
    },
    Decomposition {
        kanji: '蘶',
        radicals: &['ノ', '儿', '匕', '厶', '女', '⺾', '木', '田', '禾', '鬼'],
    },
    Decomposition {
        kanji: '蘸',
        radicals: &['⺾', '⺣', '酉', '隹'],
    },
    Decomposition {
        kanji: '蘺',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '厶', '⺾', '⽱', '隹'],
    },
    Decomposition {
        kanji: '蘼',
        radicals: &['广', '⺾', '木', '非', '麻'],
    },
    Decomposition {
        kanji: '蘽',
        radicals: &['⺾', '木', '田'],
    },
    Decomposition {
        kanji: '虀',
        radicals: &['一', '｜', '亠', '丷', '刀', '⺾', '氏', '非'],
    },
    Decomposition {
        kanji: '虂',
        radicals: &['二', '冖', '口', '夂', '⺾', '足', '雨'],
    },
    Decomposition {
        kanji: '虆',
        radicals: &['小', '幺', '⺾', '田', '糸'],
    },
    Decomposition {
        kanji: '虒',
        radicals: &['儿', '几', '匕', '卜', '厂', '虍'],
    },
    Decomposition {
        kanji: '虓',
        radicals: &['儿', '几', '匕', '卜', '厂', '九', '虍'],
    },
    Decomposition {
        kanji: '虖',
        radicals: &['一', 'ノ', '亅', '丷', '匕', '卜', '厂', '虍'],
    },
    Decomposition {
        kanji: '虗',
        radicals: &['一', '匕', '卜', '厂', '斤', '虍'],
    },
    Decomposition {
        kanji: '虘',
        radicals: &['一', '匕', '卜', '厂', '目', '虍'],
    },
    Decomposition {
        kanji: '虙',
        radicals: &['ノ', '匕', '卜', '厂', '心', '虍'],
    },
    Decomposition {
        kanji: '虝',
        radicals: &['ノ', '几', '勹', '匕', '卜', '厂', '勿', '虍'],
    },
    Decomposition {
        kanji: '虠',
        radicals: &['亠', '几', '匕', '卜', '厂', '父', '虍'],
    },
    Decomposition {
        kanji: '虡',
        radicals: &['一', '｜', '丶', 'ノ', 'ハ', '匕', '卜', '厂', '虍'],
    },
    Decomposition {
        kanji: '虢',
        radicals: &['儿', '几', '匕', '卜', '厂', '寸', '爪', '虍'],
    },
    Decomposition {
        kanji: '虣',
        radicals: &['一', '儿', '几', '匕', '卜', '厂', '弋', '止', '虍'],
    },
    Decomposition {
        kanji: '虤',
        radicals: &['几', '匕', '卜', '厂', '虍'],
    },
    Decomposition {
        kanji: '虩',
        radicals: &['几', '匕', '卜', '厂', '小', '⺌', '日', '虍'],
    },
    Decomposition {
        kanji: '虬',
        radicals: &['乙', '虫'],
    },
    Decomposition {
        kanji: '虯',
        radicals: &['｜', '虫'],
    },
    Decomposition {
        kanji: '虵',
        radicals: &['｜', '乙', '匕', '也', '虫'],
    },
    Decomposition {
        kanji: '虶',
        radicals: &['亅', '二', '虫'],
    },
    Decomposition {
        kanji: '虷',
        radicals: &['一', '十', '干', '虫'],
    },
    Decomposition {
        kanji: '虺',
        radicals: &['一', '儿', '虫'],
    },
    Decomposition {
        kanji: '蚍',
        radicals: &['匕', '比', '虫'],
    },
    Decomposition {
        kanji: '蚑',
        radicals: &['十', '又', '支', '虫'],
    },
    Decomposition {
        kanji: '蚖',
        radicals: &['二', '儿', '元', '虫'],
    },
    Decomposition {
        kanji: '蚘',
        radicals: &['丶', '尢', '尤', '虫'],
    },
    Decomposition {
        kanji: '蚚',
        radicals: &['斤', '虫'],
    },
    Decomposition {
        kanji: '蚜',
        radicals: &['牙', '虫'],
    },
    Decomposition {
        kanji: '蚡',
        radicals: &['ハ', '刀', '虫'],
    },
    Decomposition {
        kanji: '蚦',
        radicals: &['二', '冂', '月', '虫'],
    },
    Decomposition {
        kanji: '蚧',
        radicals: &['｜', 'ノ', '𠆢', '虫'],
    },
    Decomposition {
        kanji: '蚨',
        radicals: &['一', '大', '虫'],
    },
    Decomposition {
        kanji: '蚭',
        radicals: &['匕', '尸', '虫'],
    },
    Decomposition {
        kanji: '蚱',
        radicals: &['一', '｜', 'ノ', '虫'],
    },
    Decomposition {
        kanji: '蚳',
        radicals: &['一', '丶', '氏', '虫'],
    },
    Decomposition {
        kanji: '蚴',
        radicals: &['力', '幺', '虫'],
    },
    Decomposition {
        kanji: '蚵',
        radicals: &['一', '亅', '口', '虫'],
    },
    Decomposition {
        kanji: '蚷',
        radicals: &['匚', '口', '虫'],
    },
    Decomposition {
        kanji: '蚸',
        radicals: &['丶', '斤', '虫'],
    },
    Decomposition {
        kanji: '蚹',
        radicals: &['⺅', '寸', '虫'],
    },
    Decomposition {
        kanji: '蚿',
        radicals: &['亠', '幺', '玄', '虫'],
    },
    Decomposition {
        kanji: '蛀',
        radicals: &['丶', '王', '虫'],
    },
    Decomposition {
        kanji: '蛁',
        radicals: &['刀', '口', '虫'],
    },
    Decomposition {
        kanji: '蛃',
        radicals: &['一', '人', '冂', '虫'],
    },
    Decomposition {
        kanji: '蛅',
        radicals: &['卜', '口', '虫'],
    },
    Decomposition {
        kanji: '蛑',
        radicals: &['厶', '牛', '虫'],
    },
    Decomposition {
        kanji: '蛒',
        radicals: &['口', '夂', '虫'],
    },
    Decomposition {
        kanji: '蛕',
        radicals: &['一', 'ノ', '月', '虫'],
    },
    Decomposition {
        kanji: '蛗',
        radicals: &['｜', 'ノ', '口', '虫'],
    },
    Decomposition {
        kanji: '蛚',
        radicals: &['⺉', '歹', '虫'],
    },
    Decomposition {
        kanji: '蛜',
        radicals: &['ノ', '⺅', 'ヨ', '虫'],
    },
    Decomposition {
        kanji: '蛠',
        radicals: &['力', '虫'],
    },
    Decomposition {
        kanji: '蛣',
        radicals: &['口', '士', '虫'],
    },
    Decomposition {
        kanji: '蛥',
        radicals: &['夕', '虫'],
    },
    Decomposition {
        kanji: '蛧',
        radicals: &['丶', 'ノ', '冂', '虫'],
    },
    Decomposition {
        kanji: '蚈',
        radicals: &['一', '廾', '虫'],
    },
    Decomposition {
        kanji: '蛺',
        radicals: &['人', '大', '虫'],
    },
    Decomposition {
        kanji: '蛼',
        radicals: &['虫', '車'],
    },
    Decomposition {
        kanji: '蛽',
        radicals: &['ハ', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '蜄',
        radicals: &['厂', '虫', '衣', '辰'],
    },
    Decomposition {
        kanji: '蜅',
        radicals: &['丶', '十', '月', '虫'],
    },
    Decomposition {
        kanji: '蜇',
        radicals: &['扌', '斤', '虫'],
    },
    Decomposition {
        kanji: '蜋',
        radicals: &['丶', '艮', '虫'],
    },
    Decomposition {
        kanji: '蜎',
        radicals: &['口', '月', '虫'],
    },
    Decomposition {
        kanji: '蜏',
        radicals: &['ノ', '乃', '木', '禾', '虫'],
    },
    Decomposition {
        kanji: '蜐',
        radicals: &['力', '厶', '土', '虫'],
    },
    Decomposition {
        kanji: '蜓',
        radicals: &['ノ', '土', '士', '廴', '王', '虫'],
    },
    Decomposition {
        kanji: '蜔',
        radicals: &['勹', '田', '虫'],
    },
    Decomposition {
        kanji: '蜙',
        radicals: &['ハ', '厶', '木', '虫'],
    },
    Decomposition {
        kanji: '蜞',
        radicals: &['｜', '二', 'ハ', '甘', '虫'],
    },
    Decomposition {
        kanji: '蜟',
        radicals: &['亠', '厶', '月', '虫'],
    },
    Decomposition {
        kanji: '蜡',
        radicals: &['｜', '二', '日', '虫'],
    },
    Decomposition {
        kanji: '蜣',
        radicals: &['乙', '儿', '丷', '王', '羊', '虫'],
    },
    Decomposition {
        kanji: '蜨',
        radicals: &['土', 'ヨ', '虫', '走'],
    },
    Decomposition {
        kanji: '蜮',
        radicals: &['一', '口', '戈', '虫'],
    },
    Decomposition {
        kanji: '蜯',
        radicals: &['一', '｜', '二', '大', '虫'],
    },
    Decomposition {
        kanji: '蜱',
        radicals: &['ノ', '十', '日', '白', '虫'],
    },
    Decomposition {
        kanji: '蜲',
        radicals: &['ノ', '女', '木', '禾', '虫'],
    },
    Decomposition {
        kanji: '蜹',
        radicals: &['人', '入', '冂', '⺾', '虫'],
    },
    Decomposition {
        kanji: '蜺',
        radicals: &['儿', '臼', '虫'],
    },
    Decomposition {
        kanji: '蜼',
        radicals: &['虫', '隹'],
    },
    Decomposition {
        kanji: '蜽',
        radicals: &['一', '｜', '入', '冂', '虫'],
    },
    Decomposition {
        kanji: '蜾',
        radicals: &['日', '木', '田', '虫'],
    },
    Decomposition {
        kanji: '蝀',
        radicals: &['日', '木', '虫'],
    },
    Decomposition {
        kanji: '蝃',
        radicals: &['又', '虫'],
    },
    Decomposition {
        kanji: '蝅',
        radicals: &['一', '大', '虫'],
    },
    Decomposition {
        kanji: '蝍',
        radicals: &['卩', '厶', '日', '虫'],
    },
    Decomposition {
        kanji: '蝘',
        radicals: &['匚', '女', '日', '虫'],
    },
    Decomposition {
        kanji: '蝝',
        radicals: &['ヨ', '彑', '虫', '豕'],
    },
    Decomposition {
        kanji: '蝡',
        radicals: &['大', '而', '虫'],
    },
    Decomposition {
        kanji: '蝤',
        radicals: &['ハ', '丷', '虫', '酉'],
    },
    Decomposition {
        kanji: '蝥',
        radicals: &['マ', '攵', '矛', '虫'],
    },
    Decomposition {
        kanji: '蝯',
        radicals: &['ノ', '二', '又', '爪', '虫'],
    },
    Decomposition {
        kanji: '蝱',
        radicals: &['亠', '亡', '虫'],
    },
    Decomposition {
        kanji: '蝲',
        radicals: &['⺉', '口', '木', '虫'],
    },
    Decomposition {
        kanji: '蝻',
        radicals: &['一', '丷', '冂', '十', '干', '虫'],
    },
    Decomposition {
        kanji: '螃',
        radicals: &['亠', '丷', '冖', '方', '立', '虫'],
    },
    Decomposition {
        kanji: '螄',
        radicals: &['一', '｜', 'ノ', '冂', '口', '巾', '虫'],
    },
    Decomposition {
        kanji: '螅',
        radicals: &['心', '目', '自', '虫'],
    },
    Decomposition {
        kanji: '螆',
        radicals: &['一', '丷', '幺', '虫'],
    },
    Decomposition {
        kanji: '螇',
        radicals: &['大', '幺', '爪', '虫'],
    },
    Decomposition {
        kanji: '螈',
        radicals: &['厂', '小', '日', '白', '虫'],
    },
    Decomposition {
        kanji: '螉',
        radicals: &['ノ', 'ハ', '冫', '厶', '羽', '虫'],
    },
    Decomposition {
        kanji: '螋',
        radicals: &['｜', '十', '又', '支', '臼', '虫'],
    },
    Decomposition {
        kanji: '螌',
        radicals: &['一', '｜', '丶', '冂', '几', '又', '殳', '舟', '虫'],
    },
    Decomposition {
        kanji: '螐',
        radicals: &['⺣', '虫', '鳥'],
    },
    Decomposition {
        kanji: '螓',
        radicals: &['一', 'ノ', '二', '大', '木', '禾', '虫'],
    },
    Decomposition {
        kanji: '螕',
        radicals: &['丶', 'ノ', '匕', '口', '比', '虫'],
    },
    Decomposition {
        kanji: '螗',
        radicals: &['｜', '口', '广', 'ヨ', '虫'],
    },
    Decomposition {
        kanji: '螘',
        radicals: &['丷', '口', '山', '虫', '豆'],
    },
    Decomposition {
        kanji: '螙',
        radicals: &['木', '虫'],
    },
    Decomposition {
        kanji: '螞',
        radicals: &['虫', '馬'],
    },
    Decomposition {
        kanji: '螠',
        radicals: &['一', 'ハ', '丷', '皿', '虫'],
    },
    Decomposition {
        kanji: '螣',
        radicals: &['一', '丶', 'ハ', '丷', '冂', '大', '月', '虫'],
    },
    Decomposition {
        kanji: '螧',
        radicals: &['ノ', '匕', '土', '⺹', '日', '虫'],
    },
    Decomposition {
        kanji: '螬',
        radicals: &['一', '｜', '日', '虫'],
    },
    Decomposition {
        kanji: '螭',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '厶', '⽱', '虫'],
    },
    Decomposition {
        kanji: '螮',
        radicals: &['一', '｜', 'ノ', '乙', '冂', '冖', '巾', '廾', '虫'],
    },
    Decomposition {
        kanji: '螱',
        radicals: &['二', '寸', '小', '尸', '示', '虫'],
    },
    Decomposition {
        kanji: '螵',
        radicals: &['二', '小', '示', '虫', '西'],
    },
    Decomposition {
        kanji: '螾',
        radicals: &['一', '｜', 'ハ', '宀', '日', '田', '虫'],
    },
    Decomposition {
        kanji: '螿',
        radicals: &['丶', '夕', '寸', '爿', '虫'],
    },
    Decomposition {
        kanji: '蟁',
        radicals: &['尸', '氏', '虫'],
    },
    Decomposition {
        kanji: '蟈',
        radicals: &['一', '口', '囗', '戈', '虫'],
    },
    Decomposition {
        kanji: '蟉',
        radicals: &['ノ', '𠆢', '冫', '彡', '羽', '虫'],
    },
    Decomposition {
        kanji: '蟊',
        radicals: &['マ', '矛', '虫'],
    },
    Decomposition {
        kanji: '蟎',
        radicals: &['一', '｜', '入', '冂', '凵', '虫'],
    },
    Decomposition {
        kanji: '蟕',
        radicals: &['｜', '勹', '匕', '月', '止', '虫', '角'],
    },
    Decomposition {
        kanji: '蟖',
        radicals: &['｜', '二', 'ハ', '斤', '甘', '虫'],
    },
    Decomposition {
        kanji: '蟙',
        radicals: &['戈', '日', '曰', '立', '虫'],
    },
    Decomposition {
        kanji: '蟚',
        radicals: &['一', '丷', '十', '口', '士', '彡', '虫', '豆'],
    },
    Decomposition {
        kanji: '蟜',
        radicals: &['ノ', '冂', '口', '大', '虫'],
    },
    Decomposition {
        kanji: '蟟',
        radicals: &['丶', 'ノ', '大', '小', '日', '虫'],
    },
    Decomposition {
        kanji: '蟢',
        radicals: &['一', '丷', '十', '口', '士', '虫', '豆'],
    },
    Decomposition {
        kanji: '蟣',
        radicals: &['人', '幺', '戈', '虫'],
    },
    Decomposition {
        kanji: '蟤',
        radicals: &['｜', '二', '已', '虫'],
    },
    Decomposition {
        kanji: '蟪',
        radicals: &['一', '十', '厶', '心', '日', '虫'],
    },
    Decomposition {
        kanji: '蟫',
        radicals: &['十', '日', '虫', '西'],
    },
    Decomposition {
        kanji: '蟭',
        radicals: &['⺣', '虫', '隹'],
    },
    Decomposition {
        kanji: '蟱',
        radicals: &['一', '｜', 'ノ', '⺣', '虫', '無'],
    },
    Decomposition {
        kanji: '蟳',
        radicals: &['口', '寸', '工', 'ヨ', '虫'],
    },
    Decomposition {
        kanji: '蟸',
        radicals: &['虫', '豕'],
    },
    Decomposition {
        kanji: '蟺',
        radicals: &['一', '亠', '口', '囗', '日', '曰', '虫'],
    },
    Decomposition {
        kanji: '蟿',
        radicals: &['几', '凵', '又', '殳', '虫', '車'],
    },
    Decomposition {
        kanji: '蠁',
        radicals: &['厶', '幺', '⻏', '日', '白', '虫'],
    },
    Decomposition {
        kanji: '蠃',
        radicals: &['丶', 'ノ', '乙', '亠', '几', '口', '亡', '月', '虫'],
    },
    Decomposition {
        kanji: '蠆',
        radicals: &['冂', '厶', '⺾', '日', '田', '⽱', '虫'],
    },
    Decomposition {
        kanji: '蠉',
        radicals: &['一', '口', '⺲', '虫', '衣'],
    },
    Decomposition {
        kanji: '蠊',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '广', 'ヨ', '虫'],
    },
    Decomposition {
        kanji: '蠋',
        radicals: &['勹', '⺲', '虫'],
    },
    Decomposition {
        kanji: '蠐',
        radicals: &['亠', '刀', '氏', '虫', '齊'],
    },
    Decomposition {
        kanji: '蠙',
        radicals: &['一', 'ハ', '宀', '小', '目', '虫', '貝'],
    },
    Decomposition {
        kanji: '蠒',
        radicals: &['一', '｜', 'ハ', '冂', '爻', '虫'],
    },
    Decomposition {
        kanji: '蠓',
        radicals: &['一', '冖', '⺾', '虫', '豕'],
    },
    Decomposition {
        kanji: '蠔',
        radicals: &['亠', '冖', '口', '虫', '豕'],
    },
    Decomposition {
        kanji: '蠘',
        radicals: &['土', '戈', '虫', '隹'],
    },
    Decomposition {
        kanji: '蠚',
        radicals: &['一', 'ノ', '口', '⺾', '虫'],
    },
    Decomposition {
        kanji: '蠛',
        radicals: &['丶', 'ノ', '厂', '⺾', '戈', '⺲', '虫'],
    },
    Decomposition {
        kanji: '蠜',
        radicals: &['大', '木', '爻', '虫'],
    },
    Decomposition {
        kanji: '蠞',
        radicals: &['卩', '厶', '日', '曰', '竹', '虫'],
    },
    Decomposition {
        kanji: '蠟',
        radicals: &['丶', 'ノ', '口', '川', '巛', '虫'],
    },
    Decomposition {
        kanji: '蠨',
        radicals: &['｜', 'ヨ', '⺾', '爿', '片', '虫'],
    },
    Decomposition {
        kanji: '蠭',
        radicals: &['一', '｜', '二', '⻌', '夂', '虫'],
    },
    Decomposition {
        kanji: '蠮',
        radicals: &[
            '一', 'ノ', '冫', '几', '匚', '又', '大', '殳', '矢', '羽', '虫',
        ],
    },
    Decomposition {
        kanji: '蠰',
        radicals: &['一', '｜', '二', '亠', '口', '虫', '衣'],
    },
    Decomposition {
        kanji: '蠲',
        radicals: &['一', 'ハ', '丷', '勹', '皿', '⺲', '虫'],
    },
    Decomposition {
        kanji: '蠵',
        radicals: &['ハ', '冂', '口', '山', '虫', '隹'],
    },
    Decomposition {
        kanji: '蠺',
        radicals: &['一', '大', '日', '虫'],
    },
    Decomposition {
        kanji: '蠼',
        radicals: &['又', '目', '虫', '隹'],
    },
    Decomposition {
        kanji: '衁',
        radicals: &['亠', '亡', '皿', '血'],
    },
    Decomposition {
        kanji: '衃',
        radicals: &['一', '｜', '丶', 'ノ', '皿', '血'],
    },
    Decomposition {
        kanji: '衅',
        radicals: &['｜', '二', 'ハ', '丷', '皿', '血'],
    },
    Decomposition {
        kanji: '衈',
        radicals: &['皿', '耳', '血'],
    },
    Decomposition {
        kanji: '衉',
        radicals: &['口', '夂', '皿', '血'],
    },
    Decomposition {
        kanji: '衊',
        radicals: &['丶', 'ノ', '厂', '⺾', '戈', '皿', '⺲', '血'],
    },
    Decomposition {
        kanji: '衋',
        radicals: &['一', '｜', '二', 'ヨ', '皿', '目', '聿', '自', '血'],
    },
    Decomposition {
        kanji: '衎',
        radicals: &['一', '十', '干', '彳', '行'],
    },
    Decomposition {
        kanji: '衑',
        radicals: &['丶', '人', 'マ', '彳', '行'],
    },
    Decomposition {
        kanji: '衕',
        radicals: &['一', '冂', '口', '彳', '行'],
    },
    Decomposition {
        kanji: '衖',
        radicals: &['｜', '二', 'ハ', '彳', '行'],
    },
    Decomposition {
        kanji: '衘',
        radicals: &['一', 'ノ', '十', '干', '彳', '止', '行'],
    },
    Decomposition {
        kanji: '衚',
        radicals: &['十', '口', '彳', '月', '行'],
    },
    Decomposition {
        kanji: '衜',
        radicals: &['丷', '彳', '目', '自', '行', '首'],
    },
    Decomposition {
        kanji: '衟',
        radicals: &['一', '巛', '彳', '目', '自', '行'],
    },
    Decomposition {
        kanji: '衠',
        radicals: &['一', 'ハ', '十', '彳', '目', '行', '貝'],
    },
    Decomposition {
        kanji: '衤',
        radicals: &['⻂'],
    },
    Decomposition {
        kanji: '衩',
        radicals: &['丶', '又', '⻂'],
    },
    Decomposition {
        kanji: '衱',
        radicals: &['丶', '乃', '及', '⻂'],
    },
    Decomposition {
        kanji: '衹',
        radicals: &['氏', '⻂'],
    },
    Decomposition {
        kanji: '衻',
        radicals: &['二', '冂', '月', '⻂'],
    },
    Decomposition {
        kanji: '袀',
        radicals: &['冫', '勹', '⻂'],
    },
    Decomposition {
        kanji: '袘',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '也', '⻂'],
    },
    Decomposition {
        kanji: '袚',
        radicals: &['丶', 'ノ', '又', '弋', '⻂'],
    },
    Decomposition {
        kanji: '袛',
        radicals: &['一', '丶', '氏', '⻂'],
    },
    Decomposition {
        kanji: '袜',
        radicals: &['一', '木', '⻂'],
    },
    Decomposition {
        kanji: '袟',
        radicals: &['一', 'ノ', '大', '⻂'],
    },
    Decomposition {
        kanji: '袠',
        radicals: &['一', 'ノ', '亠', '大', '衣'],
    },
    Decomposition {
        kanji: '袨',
        radicals: &['亠', '幺', '玄', '⻂'],
    },
    Decomposition {
        kanji: '袪',
        radicals: &['厶', '土', '⻂'],
    },
    Decomposition {
        kanji: '袺',
        radicals: &['口', '士', '⻂'],
    },
    Decomposition {
        kanji: '袽',
        radicals: &['口', '女', '⻂'],
    },
    Decomposition {
        kanji: '袾',
        radicals: &['一', 'ノ', '木', '⻂'],
    },
    Decomposition {
        kanji: '裀',
        radicals: &['囗', '大', '⻂'],
    },
    Decomposition {
        kanji: '裊',
        radicals: &['亠', '⺣', '衣', '鳥'],
    },
    Decomposition {
        kanji: '裋',
        radicals: &['丷', '口', '⻂', '豆'],
    },
    Decomposition {
        kanji: '裌',
        radicals: &['人', '大', '⻂'],
    },
    Decomposition {
        kanji: '裍',
        radicals: &['囗', '木', '⻂'],
    },
    Decomposition {
        kanji: '裎',
        radicals: &['ノ', '口', '土', '王', '⻂'],
    },
    Decomposition {
        kanji: '裑',
        radicals: &['⻂', '身'],
    },
    Decomposition {
        kanji: '裒',
        radicals: &['亠', '臼', '衣'],
    },
    Decomposition {
        kanji: '裓',
        radicals: &['廾', '戈', '⻂'],
    },
    Decomposition {
        kanji: '裛',
        radicals: &['乙', '亠', '口', '已', '⻏', '巴', '衣'],
    },
    Decomposition {
        kanji: '裞',
        radicals: &['儿', '丷', '口', '⻂'],
    },
    Decomposition {
        kanji: '裧',
        radicals: &['火', '⻂'],
    },
    Decomposition {
        kanji: '裯',
        radicals: &['｜', '二', '冂', '口', '土', '⻂'],
    },
    Decomposition {
        kanji: '裰',
        radicals: &['又', '⻂'],
    },
    Decomposition {
        kanji: '裱',
        radicals: &['一', '｜', '二', '亠', '土', '⻂', '衣'],
    },
    Decomposition {
        kanji: '裵',
        radicals: &['亠', '衣', '非'],
    },
    Decomposition {
        kanji: '裷',
        radicals: &['一', '丶', 'ノ', '丷', '卩', '大', '已', '⻂'],
    },
    Decomposition {
        kanji: '褁',
        radicals: &['日', '木', '田', '衣'],
    },
    Decomposition {
        kanji: '褆',
        radicals: &['日', '疋', '⻂'],
    },
    Decomposition {
        kanji: '褍',
        radicals: &['山', '⻂', '而'],
    },
    Decomposition {
        kanji: '褎',
        radicals: &['一', '｜', 'ノ', '亠', '木', '禾', '衣'],
    },
    Decomposition {
        kanji: '褏',
        radicals: &['一', '｜', '亠', '日', '田', '衣'],
    },
    Decomposition {
        kanji: '褕',
        radicals: &['一', '𠆢', '⺉', '月', '⻂'],
    },
    Decomposition {
        kanji: '褖',
        radicals: &['ヨ', '彑', '⻂', '豕'],
    },
    Decomposition {
        kanji: '褘',
        radicals: &['口', '⻂', '韋'],
    },
    Decomposition {
        kanji: '褙',
        radicals: &['一', '｜', '匕', '月', '⻂'],
    },
    Decomposition {
        kanji: '褚',
        radicals: &['ノ', '土', '⺹', '日', '⻂'],
    },
    Decomposition {
        kanji: '褜',
        radicals: &['亠', '勹', '已', '月', '衣'],
    },
    Decomposition {
        kanji: '褠',
        radicals: &['一', '｜', '二', '冂', '月', '⻂'],
    },
    Decomposition {
        kanji: '褦',
        radicals: &['匕', '厶', '月', '⻂'],
    },
    Decomposition {
        kanji: '褧',
        radicals: &['亠', '火', '耳', '衣'],
    },
    Decomposition {
        kanji: '褨',
        radicals: &['一', 'ノ', '二', '丷', '工', '王', '⻂', '羊'],
    },
    Decomposition {
        kanji: '褰',
        radicals: &['一', '｜', '丶', 'ノ', '二', '亠', '宀', '衣'],
    },
    Decomposition {
        kanji: '褱',
        radicals: &['亠', '水', '⺲', '衣'],
    },
    Decomposition {
        kanji: '褲',
        radicals: &['广', '⻂', '車'],
    },
    Decomposition {
        kanji: '褵',
        radicals: &['丶', 'ノ', '亠', '冂', '凵', '厶', '⽱', '⻂'],
    },
    Decomposition {
        kanji: '褹',
        radicals: &['丶', '儿', 'ハ', '九', '土', '⻂'],
    },
    Decomposition {
        kanji: '褺',
        radicals: &['一', '丶', '亠', '丷', '十', '九', '土', '干', '衣'],
    },
    Decomposition {
        kanji: '褾',
        radicals: &['二', '小', '示', '⻂', '西'],
    },
    Decomposition {
        kanji: '襀',
        radicals: &['一', '｜', '二', 'ハ', '目', '⻂', '貝'],
    },
    Decomposition {
        kanji: '襂',
        radicals: &['𠆢', '厶', '彡', '⻂'],
    },
    Decomposition {
        kanji: '襅',
        radicals: &['一', '｜', '凵', '⻂', '里'],
    },
    Decomposition {
        kanji: '襆',
        radicals: &['一', '｜', '丶', 'ノ', '二', '丷', '大', '⻂'],
    },
    Decomposition {
        kanji: '襉',
        radicals: &['月', '⻂', '門'],
    },
    Decomposition {
        kanji: '襏',
        radicals: &['丶', 'ノ', 'ハ', '几', '又', '弓', '殳', '⻂'],
    },
    Decomposition {
        kanji: '襒',
        radicals: &['｜', '丶', 'ノ', '丷', '冂', '攵', '⻂'],
    },
    Decomposition {
        kanji: '襗',
        radicals: &['一', '丷', '十', '土', '干', '⻂', '⺲'],
    },
    Decomposition {
        kanji: '襚',
        radicals: &['ハ', '丷', '⻌', '⻂', '豕'],
    },
    Decomposition {
        kanji: '襛',
        radicals: &['｜', '亠', '厂', '日', '⻂', '衣', '辰'],
    },
    Decomposition {
        kanji: '襜',
        radicals: &['儿', 'ハ', '勹', '厂', '⻂', '言'],
    },
    Decomposition {
        kanji: '襡',
        radicals: &['勹', '⻂', '⺲', '虫'],
    },
    Decomposition {
        kanji: '襢',
        radicals: &['一', '亠', '口', '囗', '日', '⻂'],
    },
    Decomposition {
        kanji: '襣',
        radicals: &['廾', '田', '目', '⻂', '自', '鼻'],
    },
    Decomposition {
        kanji: '襫',
        radicals: &['一', '大', '日', '白', '⻂'],
    },
    Decomposition {
        kanji: '襮',
        radicals: &['｜', '丶', 'ノ', '二', '日', '水', '⻂'],
    },
    Decomposition {
        kanji: '襰',
        radicals: &['ハ', '勹', '口', '木', '目', '⻂', '貝'],
    },
    Decomposition {
        kanji: '襳',
        radicals: &['一', '人', '戈', '⻂', '非'],
    },
    Decomposition {
        kanji: '襵',
        radicals: &['⻂', '耳'],
    },
    Decomposition {
        kanji: '襺',
        radicals: &['｜', '冂', '小', '幺', '⺾', '⻂', '糸', '虫'],
    },
    Decomposition {
        kanji: '襻',
        radicals: &['大', '手', '木', '爻', '⻂'],
    },
    Decomposition {
        kanji: '襼',
        radicals: &['丶', '二', '儿', 'ハ', '厶', '九', '土', '⺾', '⻂'],
    },
    Decomposition {
        kanji: '襽',
        radicals: &['丷', '口', '⺾', '木', '⻂', '門'],
    },
    Decomposition {
        kanji: '覉',
        radicals: &['一', '亅', '十', '口', '大', '廾', '西', '革'],
    },
    Decomposition {
        kanji: '覍',
        radicals: &['儿', '小', '目', '見'],
    },
    Decomposition {
        kanji: '覐',
        radicals: &['儿', '爻', '目', '見'],
    },
    Decomposition {
        kanji: '覔',
        radicals: &['一', '｜', '丶', 'ノ', '儿', '目', '見'],
    },
    Decomposition {
        kanji: '覕',
        radicals: &['ノ', '儿', '心', '目', '見'],
    },
    Decomposition {
        kanji: '覛',
        radicals: &['丶', 'ノ', '儿', '厂', '目', '見'],
    },
    Decomposition {
        kanji: '覜',
        radicals: &['丶', 'ノ', '儿', '冫', '目', '見'],
    },
    Decomposition {
        kanji: '覟',
        radicals: &['儿', '士', '心', '目', '見'],
    },
    Decomposition {
        kanji: '覠',
        radicals: &['ノ', '儿', '口', 'ヨ', '目', '見'],
    },
    Decomposition {
        kanji: '覥',
        radicals: &['一', '｜', '儿', 'ハ', '日', '目', '見'],
    },
    Decomposition {
        kanji: '覰',
        radicals: &['儿', '匕', '卜', '厂', '目', '虍', '見'],
    },
    Decomposition {
        kanji: '覴',
        radicals: &['丶', 'ノ', '儿', '丷', '口', '目', '見', '豆'],
    },
    Decomposition {
        kanji: '覵',
        radicals: &['儿', '月', '目', '見', '門'],
    },
    Decomposition {
        kanji: '覶',
        radicals: &['儿', '冂', '厶', '又', 'マ', '爪', '目', '見'],
    },
    Decomposition {
        kanji: '覷',
        radicals: &[
            '一', '｜', '丶', 'ノ', '儿', '匕', '卜', '厂', '目', '虍', '見',
        ],
    },
    Decomposition {
        kanji: '覼',
        radicals: &['一', '｜', '儿', 'ハ', '冂', '爻', '目', '見'],
    },
    Decomposition {
        kanji: '觔',
        radicals: &['｜', '力', '勹', '月', '角'],
    },
    Decomposition {
        kanji: '觕',
        radicals: &['｜', '勹', '月', '牛', '角'],
    },
    Decomposition {
        kanji: '觖',
        radicals: &['｜', '人', '勹', 'ユ', '月', '角'],
    },
    Decomposition {
        kanji: '觗',
        radicals: &['｜', '勹', '月', '氏', '角'],
    },
    Decomposition {
        kanji: '觘',
        radicals: &['｜', 'ノ', '勹', '小', '月', '角'],
    },
    Decomposition {
        kanji: '觥',
        radicals: &['一', '｜', '儿', '勹', '⺌', '月', '角'],
    },
    Decomposition {
        kanji: '觩',
        radicals: &['一', '｜', '丶', '勹', '月', '水', '角'],
    },
    Decomposition {
        kanji: '觫',
        radicals: &['｜', '勹', '口', '月', '木', '角'],
    },
    Decomposition {
        kanji: '觭',
        radicals: &['一', '｜', '亅', '勹', '口', '大', '月', '角'],
    },
    Decomposition {
        kanji: '觱',
        radicals: &['一', '｜', 'ノ', '勹', '厂', '口', '戈', '月', '角'],
    },
    Decomposition {
        kanji: '觳',
        radicals: &['一', '｜', '冖', '几', '勹', '又', '士', '月', '殳', '角'],
    },
    Decomposition {
        kanji: '觶',
        radicals: &['｜', '勹', '十', '口', '日', '月', '田', '角'],
    },
    Decomposition {
        kanji: '觹',
        radicals: &['｜', '亅', '勹', '月', '角', '隹'],
    },
    Decomposition {
        kanji: '觽',
        radicals: &['｜', '亅', '勹', '山', '月', '角', '隹'],
    },
    Decomposition {
        kanji: '觿',
        radicals: &['｜', '儿', 'ハ', '冂', '勹', '口', '山', '月', '角', '隹'],
    },
    Decomposition {
        kanji: '訄',
        radicals: &['九', '言'],
    },
    Decomposition {
        kanji: '訅',
        radicals: &['九', '言'],
    },
    Decomposition {
        kanji: '訇',
        radicals: &['勹', '言'],
    },
    Decomposition {
        kanji: '訏',
        radicals: &['亅', '二', '言'],
    },
    Decomposition {
        kanji: '訑',
        radicals: &['｜', '乙', '匕', '也', '言'],
    },
    Decomposition {
        kanji: '訒',
        radicals: &['ノ', '刀', '言'],
    },
    Decomposition {
        kanji: '訔',
        radicals: &['山', '言'],
    },
    Decomposition {
        kanji: '訕',
        radicals: &['山', '言'],
    },
    Decomposition {
        kanji: '訞',
        radicals: &['ノ', '大', '言'],
    },
    Decomposition {
        kanji: '訠',
        radicals: &['｜', '弓', '言'],
    },
    Decomposition {
        kanji: '訢',
        radicals: &['斤', '言'],
    },
    Decomposition {
        kanji: '訤',
        radicals: &['爻', '言'],
    },
    Decomposition {
        kanji: '訦',
        radicals: &['ノ', '乙', '冖', '尢', '言'],
    },
    Decomposition {
        kanji: '訫',
        radicals: &['心', '言'],
    },
    Decomposition {
        kanji: '訬',
        radicals: &['ノ', '小', '言'],
    },
    Decomposition {
        kanji: '訯',
        radicals: &['丶', '乃', '及', '言'],
    },
    Decomposition {
        kanji: '訵',
        radicals: &['儿', '囗', '言'],
    },
    Decomposition {
        kanji: '訷',
        radicals: &['｜', '日', '言'],
    },
    Decomposition {
        kanji: '訽',
        radicals: &['勹', '口', '言'],
    },
    Decomposition {
        kanji: '訾',
        radicals: &['匕', '止', '言'],
    },
    Decomposition {
        kanji: '詀',
        radicals: &['卜', '口', '言'],
    },
    Decomposition {
        kanji: '詃',
        radicals: &['亠', '幺', '玄', '言'],
    },
    Decomposition {
        kanji: '詅',
        radicals: &['一', '丶', '亅', '𠆢', 'マ', '言'],
    },
    Decomposition {
        kanji: '詇',
        radicals: &['口', '大', '言'],
    },
    Decomposition {
        kanji: '詉',
        radicals: &['又', '女', '言'],
    },
    Decomposition {
        kanji: '詍',
        radicals: &['一', '｜', '世', '言'],
    },
    Decomposition {
        kanji: '詎',
        radicals: &['匚', '口', '言'],
    },
    Decomposition {
        kanji: '詓',
        radicals: &['厶', '土', '言'],
    },
    Decomposition {
        kanji: '詖',
        radicals: &['ノ', '十', '厂', '又', '支', '言'],
    },
    Decomposition {
        kanji: '詗',
        radicals: &['冂', '口', '言'],
    },
    Decomposition {
        kanji: '詘',
        radicals: &['｜', '凵', '言'],
    },
    Decomposition {
        kanji: '詜',
        radicals: &['｜', '凵', '又', '屮', '言'],
    },
    Decomposition {
        kanji: '詝',
        radicals: &['一', '亅', '宀', '言'],
    },
    Decomposition {
        kanji: '詡',
        radicals: &['ノ', '冫', '羽', '言'],
    },
    Decomposition {
        kanji: '詥',
        radicals: &['一', '𠆢', '口', '言'],
    },
    Decomposition {
        kanji: '詧',
        radicals: &['丶', '夕', '言'],
    },
    Decomposition {
        kanji: '詵',
        radicals: &['一', 'ノ', '儿', '土', '言'],
    },
    Decomposition {
        kanji: '詶',
        radicals: &['丶', '川', '言'],
    },
    Decomposition {
        kanji: '詷',
        radicals: &['一', '冂', '口', '言'],
    },
    Decomposition {
        kanji: '詹',
        radicals: &['儿', 'ハ', '勹', '厂', '言'],
    },
    Decomposition {
        kanji: '詺',
        radicals: &['口', '夕', '言'],
    },
    Decomposition {
        kanji: '詻',
        radicals: &['口', '夂', '言'],
    },
    Decomposition {
        kanji: '詾',
        radicals: &['丶', 'ノ', '凵', '勹', '言'],
    },
    Decomposition {
        kanji: '詿',
        radicals: &['土', '言'],
    },
    Decomposition {
        kanji: '誀',
        radicals: &['耳', '言'],
    },
    Decomposition {
        kanji: '誃',
        radicals: &['夕', '言'],
    },
    Decomposition {
        kanji: '誆',
        radicals: &['匚', '王', '言'],
    },
    Decomposition {
        kanji: '誋',
        radicals: &['已', '心', '言'],
    },
    Decomposition {
        kanji: '誏',
        radicals: &['丶', '艮', '言'],
    },
    Decomposition {
        kanji: '誐',
        radicals: &['戈', '手', '言'],
    },
    Decomposition {
        kanji: '誒',
        radicals: &['一', 'ノ', '厶', '大', '矢', '言'],
    },
    Decomposition {
        kanji: '誖',
        radicals: &['冖', '十', '子', '言'],
    },
    Decomposition {
        kanji: '誗',
        radicals: &['ノ', '⺉', '木', '禾', '言'],
    },
    Decomposition {
        kanji: '誙',
        radicals: &['一', '巛', '工', '言'],
    },
    Decomposition {
        kanji: '誟',
        radicals: &['ノ', '土', '子', '⺹', '言'],
    },
    Decomposition {
        kanji: '誧',
        radicals: &['丶', '十', '月', '言'],
    },
    Decomposition {
        kanji: '誩',
        radicals: &['言'],
    },
    Decomposition {
        kanji: '誮',
        radicals: &['ノ', '乙', '⺅', '匕', '⺾', '言'],
    },
    Decomposition {
        kanji: '誯',
        radicals: &['日', '曰', '言'],
    },
    Decomposition {
        kanji: '誳',
        radicals: &['｜', '凵', '尸', '言'],
    },
    Decomposition {
        kanji: '誶',
        radicals: &['亠', '人', '十', '言'],
    },
    Decomposition {
        kanji: '誷',
        radicals: &['一', '亠', '丷', '冂', '亡', '言'],
    },
    Decomposition {
        kanji: '誻',
        radicals: &['日', '曰', '水', '言'],
    },
    Decomposition {
        kanji: '誾',
        radicals: &['言', '門'],
    },
    Decomposition {
        kanji: '諃',
        radicals: &['木', '言'],
    },
    Decomposition {
        kanji: '諆',
        radicals: &['｜', '二', 'ハ', '言'],
    },
    Decomposition {
        kanji: '諈',
        radicals: &['一', '｜', 'ノ', '言'],
    },
    Decomposition {
        kanji: '諉',
        radicals: &['ノ', '女', '木', '禾', '言'],
    },
    Decomposition {
        kanji: '諊',
        radicals: &['勹', '米', '言'],
    },
    Decomposition {
        kanji: '諑',
        radicals: &['丶', '言', '豕'],
    },
    Decomposition {
        kanji: '諓',
        radicals: &['戈', '言'],
    },
    Decomposition {
        kanji: '諔',
        radicals: &['一', '卜', '又', '小', '言'],
    },
    Decomposition {
        kanji: '諕',
        radicals: &['几', '匕', '卜', '厂', '虍', '言'],
    },
    Decomposition {
        kanji: '諗',
        radicals: &['一', '丶', '𠆢', '心', '言'],
    },
    Decomposition {
        kanji: '諝',
        radicals: &['月', '疋', '言'],
    },
    Decomposition {
        kanji: '諟',
        radicals: &['日', '疋', '言'],
    },
    Decomposition {
        kanji: '諬',
        radicals: &['丶', 'ノ', '尢', '木', '尤', '禾', '言'],
    },
    Decomposition {
        kanji: '諰',
        radicals: &['心', '田', '言'],
    },
    Decomposition {
        kanji: '諴',
        radicals: &['一', 'ノ', '厂', '口', '戈', '言'],
    },
    Decomposition {
        kanji: '諵',
        radicals: &['一', '丷', '冂', '十', '干', '言'],
    },
    Decomposition {
        kanji: '諶',
        radicals: &['一', '｜', '儿', 'ハ', '匚', '言'],
    },
    Decomposition {
        kanji: '諼',
        radicals: &['ノ', '二', '又', '爪', '言'],
    },
    Decomposition {
        kanji: '諿',
        radicals: &['口', '耳', '言'],
    },
    Decomposition {
        kanji: '謅',
        radicals: &['勹', '屮', '言'],
    },
    Decomposition {
        kanji: '謆',
        radicals: &['一', '丶', 'ノ', '冫', '尸', '戸', '羽', '言'],
    },
    Decomposition {
        kanji: '謋',
        radicals: &['夕', '木', '言', '舛'],
    },
    Decomposition {
        kanji: '謑',
        radicals: &['大', '幺', '爪', '言'],
    },
    Decomposition {
        kanji: '謜',
        radicals: &['厂', '小', '日', '白', '言'],
    },
    Decomposition {
        kanji: '謞',
        radicals: &['亠', '冂', '口', '言', '高'],
    },
    Decomposition {
        kanji: '謟',
        radicals: &['爪', '臼', '言'],
    },
    Decomposition {
        kanji: '謊',
        radicals: &['｜', 'ノ', '乙', '亠', '川', '⺾', '亡', '言'],
    },
    Decomposition {
        kanji: '謭',
        radicals: &['一', '丷', '刀', '⺉', '月', '言'],
    },
    Decomposition {
        kanji: '謰',
        radicals: &['⻌', '言', '車'],
    },
    Decomposition {
        kanji: '謷',
        radicals: &['土', '士', '攵', '方', '言'],
    },
    Decomposition {
        kanji: '謼',
        radicals: &['一', 'ノ', '亅', '丷', '匕', '卜', '厂', '虍', '言'],
    },
    Decomposition {
        kanji: '譂',
        radicals: &['｜', '口', '日', '田', '言'],
    },
    Decomposition {
        kanji: '譃',
        radicals: &['一', '｜', '丶', 'ノ', '匕', '卜', '厂', '虍', '言'],
    },
    Decomposition {
        kanji: '譄',
        radicals: &['｜', 'ハ', '丷', '口', '日', '言'],
    },
    Decomposition {
        kanji: '譅',
        radicals: &['丶', '刀', '止', '言'],
    },
    Decomposition {
        kanji: '譆',
        radicals: &['一', '丷', '十', '口', '士', '言', '豆'],
    },
    Decomposition {
        kanji: '譈',
        radicals: &['亠', '口', '子', '攵', '言'],
    },
    Decomposition {
        kanji: '譒',
        radicals: &['ノ', '田', '米', '言'],
    },
    Decomposition {
        kanji: '譓',
        radicals: &['一', '心', '虫', '言'],
    },
    Decomposition {
        kanji: '譔',
        radicals: &['｜', '二', 'ハ', '已', '言'],
    },
    Decomposition {
        kanji: '譙',
        radicals: &['⺣', '言', '隹'],
    },
    Decomposition {
        kanji: '譍',
        radicals: &['⺅', '广', '言', '隹'],
    },
    Decomposition {
        kanji: '譞',
        radicals: &['一', '口', '⺲', '衣', '言'],
    },
    Decomposition {
        kanji: '譣',
        radicals: &['一', '人', '𠆢', '口', '言'],
    },
    Decomposition {
        kanji: '譭',
        radicals: &['几', '又', '工', '殳', '臼', '言'],
    },
    Decomposition {
        kanji: '譶',
        radicals: &['言'],
    },
    Decomposition {
        kanji: '譸',
        radicals: &['一', '口', '士', '寸', '工', '言'],
    },
    Decomposition {
        kanji: '譹',
        radicals: &['亠', '冖', '口', '言', '豕'],
    },
    Decomposition {
        kanji: '譼',
        radicals: &['一', '丶', 'ノ', '匚', '⺲', '臣', '言'],
    },
    Decomposition {
        kanji: '譾',
        radicals: &['一', '丶', 'ノ', '丷', '冂', '冫', '⺉', '月', '羽', '言'],
    },
    Decomposition {
        kanji: '讁',
        radicals: &['亠', '丷', '冂', '十', '⻌', '口', '立', '言', '啇'],
    },
    Decomposition {
        kanji: '讄',
        radicals: &['田', '言'],
    },
    Decomposition {
        kanji: '讅',
        radicals: &['ノ', '宀', '田', '米', '言'],
    },
    Decomposition {
        kanji: '讋',
        radicals: &['乙', '月', '立', '言', '竜'],
    },
    Decomposition {
        kanji: '讍',
        radicals: &['口', '王', '言'],
    },
    Decomposition {
        kanji: '讏',
        radicals: &['一', '｜', '冂', 'ユ', '口', '巾', '彳', '行', '言'],
    },
    Decomposition {
        kanji: '讔',
        radicals: &['工', 'ヨ', '⻖', '心', '爪', '言'],
    },
    Decomposition {
        kanji: '讕',
        radicals: &['丷', '口', '木', '言', '門'],
    },
    Decomposition {
        kanji: '讜',
        radicals: &['丷', '冖', '口', '⺌', '⺣', '言', '里', '黒'],
    },
    Decomposition {
        kanji: '讞',
        radicals: &[
            '丶', '儿', '冂', '匕', '卜', '厂', '口', '大', '犬', '虍', '言', '鬲',
        ],
    },
    Decomposition {
        kanji: '讟',
        radicals: &['ハ', '士', '目', '⺲', '言', '貝'],
    },
    Decomposition {
        kanji: '谸',
        radicals: &['一', 'ノ', '𠆢', 'ハ', '口', '谷'],
    },
    Decomposition {
        kanji: '谹',
        radicals: &['一', 'ノ', '𠆢', 'ハ', '厶', '口', '谷'],
    },
    Decomposition {
        kanji: '谽',
        radicals: &['一', '丶', '𠆢', 'ハ', '口', '谷'],
    },
    Decomposition {
        kanji: '谾',
        radicals: &['𠆢', 'ハ', '口', '宀', '工', '谷'],
    },
    Decomposition {
        kanji: '豅',
        radicals: &['乙', '𠆢', 'ハ', '口', '月', '立', '谷', '竜'],
    },
    Decomposition {
        kanji: '豇',
        radicals: &['丷', '口', '工', '豆'],
    },
    Decomposition {
        kanji: '豉',
        radicals: &['丷', '十', '又', '口', '支', '豆'],
    },
    Decomposition {
        kanji: '豋',
        radicals: &['丶', '丷', '口', '夕', '豆'],
    },
    Decomposition {
        kanji: '豏',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '口', 'ヨ', '豆'],
    },
    Decomposition {
        kanji: '豑',
        radicals: &['｜', 'ノ', '丷', '口', '弓', '日', '豆'],
    },
    Decomposition {
        kanji: '豓',
        radicals: &['一', '｜', '丶', '丷', '口', '大', '山', '皿', '豆'],
    },
    Decomposition {
        kanji: '豔',
        radicals: &['一', '｜', '丷', '厶', '口', '土', '山', '皿', '豆'],
    },
    Decomposition {
        kanji: '豗',
        radicals: &['一', '儿', '豕'],
    },
    Decomposition {
        kanji: '豘',
        radicals: &['ノ', '乙', '凵', '屯', '豕'],
    },
    Decomposition {
        kanji: '豛',
        radicals: &['几', '又', '殳', '豕'],
    },
    Decomposition {
        kanji: '豝',
        radicals: &['乙', '已', '巴', '豕'],
    },
    Decomposition {
        kanji: '豙',
        radicals: &['亠', '丷', '立', '豕'],
    },
    Decomposition {
        kanji: '豣',
        radicals: &['一', 'ノ', '二', '十', '干', '豕'],
    },
    Decomposition {
        kanji: '豤',
        radicals: &['艮', '豕'],
    },
    Decomposition {
        kanji: '豦',
        radicals: &['匕', '卜', '厂', '虍', '豕'],
    },
    Decomposition {
        kanji: '豨',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '巾', '豕'],
    },
    Decomposition {
        kanji: '豩',
        radicals: &['豕'],
    },
    Decomposition {
        kanji: '豭',
        radicals: &['一', '｜', '又', '口', '豕'],
    },
    Decomposition {
        kanji: '豳',
        radicals: &['山', '豕'],
    },
    Decomposition {
        kanji: '豵',
        radicals: &['人', '彳', '止', '豕'],
    },
    Decomposition {
        kanji: '豶',
        radicals: &['ハ', '十', '⺾', '目', '豕', '貝'],
    },
    Decomposition {
        kanji: '豻',
        radicals: &['一', '十', '干', '豸'],
    },
    Decomposition {
        kanji: '豾',
        radicals: &['一', '｜', '丶', 'ノ', '豸'],
    },
    Decomposition {
        kanji: '貆',
        radicals: &['一', '日', '豸'],
    },
    Decomposition {
        kanji: '貇',
        radicals: &['艮', '豸'],
    },
    Decomposition {
        kanji: '貋',
        radicals: &['一', '十', '干', '日', '曰', '豸'],
    },
    Decomposition {
        kanji: '貐',
        radicals: &['一', '𠆢', '⺉', '月', '豸'],
    },
    Decomposition {
        kanji: '貒',
        radicals: &['山', '而', '豸'],
    },
    Decomposition {
        kanji: '貓',
        radicals: &['⺾', '田', '豸'],
    },
    Decomposition {
        kanji: '貙',
        radicals: &['匚', '口', '豸'],
    },
    Decomposition {
        kanji: '貛',
        radicals: &['口', '⺾', '豸', '隹'],
    },
    Decomposition {
        kanji: '貜',
        radicals: &['又', '目', '豸', '隹'],
    },
    Decomposition {
        kanji: '貤',
        radicals: &['｜', '乙', 'ハ', '匕', '也', '目', '貝'],
    },
    Decomposition {
        kanji: '貹',
        radicals: &['ハ', '生', '目', '貝'],
    },
    Decomposition {
        kanji: '貺',
        radicals: &['儿', 'ハ', '口', '目', '貝'],
    },
    Decomposition {
        kanji: '賅',
        radicals: &['ノ', '亠', 'ハ', '幺', '玄', '目', '貝'],
    },
    Decomposition {
        kanji: '賆',
        radicals: &['一', 'ハ', '丷', '廾', '目', '貝'],
    },
    Decomposition {
        kanji: '賉',
        radicals: &['ハ', '皿', '目', '血', '貝'],
    },
    Decomposition {
        kanji: '賋',
        radicals: &['亠', 'ハ', '父', '目', '貝'],
    },
    Decomposition {
        kanji: '賏',
        radicals: &['ハ', '目', '貝'],
    },
    Decomposition {
        kanji: '賖',
        radicals: &['二', '𠆢', 'ハ', '小', '目', '貝'],
    },
    Decomposition {
        kanji: '賕',
        radicals: &['一', '丶', 'ハ', '水', '目', '貝'],
    },
    Decomposition {
        kanji: '賙',
        radicals: &['｜', '二', 'ハ', '冂', '口', '土', '目', '貝'],
    },
    Decomposition {
        kanji: '賝',
        radicals: &['ハ', '冖', '木', '目', '貝'],
    },
    Decomposition {
        kanji: '賡',
        radicals: &['丶', 'ノ', 'ハ', '广', 'ヨ', '目', '貝'],
    },
    Decomposition {
        kanji: '賨',
        radicals: &['二', 'ハ', '宀', '小', '目', '示', '貝'],
    },
    Decomposition {
        kanji: '賬',
        radicals: &['ハ', '目', '貝', '長'],
    },
    Decomposition {
        kanji: '賯',
        radicals: &['ハ', '勹', '子', '日', '曰', '目', '貝'],
    },
    Decomposition {
        kanji: '賰',
        radicals: &['一', '二', 'ハ', '大', '日', '目', '貝'],
    },
    Decomposition {
        kanji: '賲',
        radicals: &['⺅', 'ハ', '口', '木', '目', '貝'],
    },
    Decomposition {
        kanji: '賵',
        radicals: &['二', 'ハ', '冂', '目', '貝'],
    },
    Decomposition {
        kanji: '賷',
        radicals: &['ハ', '冖', '十', '口', '目', '貝'],
    },
    Decomposition {
        kanji: '賸',
        radicals: &['一', 'ハ', '丷', '大', '月', '目', '貝'],
    },
    Decomposition {
        kanji: '賾',
        radicals: &['一', '｜', '二', 'ハ', '匚', '目', '臣', '貝'],
    },
    Decomposition {
        kanji: '賿',
        radicals: &['𠆢', 'ハ', '冫', '彡', '目', '羽', '貝'],
    },
    Decomposition {
        kanji: '贁',
        radicals: &['ハ', '攵', '目', '貝'],
    },
    Decomposition {
        kanji: '贃',
        radicals: &['｜', 'ハ', '口', '心', '目', '貝'],
    },
    Decomposition {
        kanji: '贉',
        radicals: &['一', '｜', 'ハ', '凵', '十', '日', '目', '西', '貝'],
    },
    Decomposition {
        kanji: '贒',
        radicals: &['｜', 'ハ', '匚', '口', '心', '目', '臣', '貝'],
    },
    Decomposition {
        kanji: '贗',
        radicals: &['⺅', 'ハ', '厂', '⺣', '目', '貝', '鳥'],
    },
    Decomposition {
        kanji: '贛',
        radicals: &['ハ', '十', '夂', '工', '日', '目', '立', '貝'],
    },
    Decomposition {
        kanji: '赥',
        radicals: &['人', '勹', '土', '欠', '赤'],
    },
    Decomposition {
        kanji: '赩',
        radicals: &['乙', '勹', '土', '已', '巴', '色', '赤'],
    },
    Decomposition {
        kanji: '赬',
        radicals: &['ハ', '卜', '土', '目', '貝', '赤'],
    },
    Decomposition {
        kanji: '赮',
        radicals: &['｜', '又', '口', '土', '赤'],
    },
    Decomposition {
        kanji: '赿',
        radicals: &['土', '氏', '走'],
    },
    Decomposition {
        kanji: '趂',
        radicals: &['勹', '土', '小', '走'],
    },
    Decomposition {
        kanji: '趄',
        radicals: &['土', '目', '赤'],
    },
    Decomposition {
        kanji: '趈',
        radicals: &['卜', '口', '土', '走'],
    },
    Decomposition {
        kanji: '趍',
        radicals: &['土', '夕', '走'],
    },
    Decomposition {
        kanji: '趐',
        radicals: &['冫', '土', '羽', '走'],
    },
    Decomposition {
        kanji: '趑',
        radicals: &['人', '冫', '勹', '土', '欠', '走'],
    },
    Decomposition {
        kanji: '趕',
        radicals: &['一', '十', '土', '干', '日', '走'],
    },
    Decomposition {
        kanji: '趞',
        radicals: &['｜', '二', '土', '日', '曰', '走'],
    },
    Decomposition {
        kanji: '趟',
        radicals: &['冂', '口', '土', '⺌', '走'],
    },
    Decomposition {
        kanji: '趠',
        radicals: &['十', '卜', '土', '日', '曰', '走'],
    },
    Decomposition {
        kanji: '趦',
        radicals: &['人', '冫', '勹', '口', '土', '欠', '走'],
    },
    Decomposition {
        kanji: '趫',
        radicals: &['ノ', '冂', '口', '土', '大', '走'],
    },
    Decomposition {
        kanji: '趬',
        radicals: &['一', '儿', '土', '走'],
    },
    Decomposition {
        kanji: '趯',
        radicals: &['ノ', '冫', '土', '羽', '走', '隹'],
    },
    Decomposition {
        kanji: '趲',
        radicals: &['ノ', '儿', 'ハ', '土', '目', '貝', '走'],
    },
    Decomposition {
        kanji: '趵',
        radicals: &['丶', '勹', '口', '止', '足'],
    },
    Decomposition {
        kanji: '趷',
        radicals: &['一', 'ノ', '乙', '口', '止', '足'],
    },
    Decomposition {
        kanji: '趹',
        radicals: &['人', 'ユ', '口', '止', '足'],
    },
    Decomposition {
        kanji: '趻',
        radicals: &['丶', '𠆢', '口', '止', '足'],
    },
    Decomposition {
        kanji: '跀',
        radicals: &['口', '月', '止', '足'],
    },
    Decomposition {
        kanji: '跅',
        radicals: &['丶', '口', '斤', '止', '足'],
    },
    Decomposition {
        kanji: '跆',
        radicals: &['厶', '口', '止', '足'],
    },
    Decomposition {
        kanji: '跇',
        radicals: &['一', '｜', '口', '止', '世', '足'],
    },
    Decomposition {
        kanji: '跈',
        radicals: &['𠆢', '口', '彡', '止', '足'],
    },
    Decomposition {
        kanji: '跊',
        radicals: &['一', '口', '木', '止', '足'],
    },
    Decomposition {
        kanji: '跎',
        radicals: &['匕', '口', '宀', '止', '足'],
    },
    Decomposition {
        kanji: '跑',
        radicals: &['勹', '口', '已', '止', '足'],
    },
    Decomposition {
        kanji: '跔',
        radicals: &['勹', '口', '止', '足'],
    },
    Decomposition {
        kanji: '跕',
        radicals: &['卜', '口', '止', '足'],
    },
    Decomposition {
        kanji: '跗',
        radicals: &['⺅', '口', '寸', '止', '足'],
    },
    Decomposition {
        kanji: '跙',
        radicals: &['一', '口', '止', '目', '足'],
    },
    Decomposition {
        kanji: '跤',
        radicals: &['亠', '口', '止', '父', '足'],
    },
    Decomposition {
        kanji: '跥',
        radicals: &['乃', '口', '木', '止', '足'],
    },
    Decomposition {
        kanji: '跧',
        radicals: &['𠆢', '口', '止', '王', '足'],
    },
    Decomposition {
        kanji: '跬',
        radicals: &['口', '土', '止', '足'],
    },
    Decomposition {
        kanji: '跰',
        radicals: &['一', '丷', '口', '廾', '止', '足'],
    },
    Decomposition {
        kanji: '趼',
        radicals: &['一', '口', '廾', '止', '足'],
    },
    Decomposition {
        kanji: '跱',
        radicals: &['口', '土', '寸', '止', '足'],
    },
    Decomposition {
        kanji: '跲',
        radicals: &['一', '人', '口', '止', '足'],
    },
    Decomposition {
        kanji: '跴',
        radicals: &['口', '止', '西', '足'],
    },
    Decomposition {
        kanji: '跽',
        radicals: &['口', '已', '心', '止', '足'],
    },
    Decomposition {
        kanji: '踁',
        radicals: &['一', '口', '巛', '工', '止', '足'],
    },
    Decomposition {
        kanji: '踄',
        radicals: &['ノ', '口', '小', '止', '足'],
    },
    Decomposition {
        kanji: '踅',
        radicals: &['口', '扌', '斤', '足'],
    },
    Decomposition {
        kanji: '踆',
        radicals: &['儿', 'ハ', '厶', '口', '夂', '止', '足'],
    },
    Decomposition {
        kanji: '踋',
        radicals: &['卩', '厶', '口', '土', '止', '足'],
    },
    Decomposition {
        kanji: '踑',
        radicals: &['｜', '二', 'ハ', '口', '止', '甘', '足'],
    },
    Decomposition {
        kanji: '踔',
        radicals: &['十', '卜', '口', '日', '止', '足'],
    },
    Decomposition {
        kanji: '踖',
        radicals: &['｜', '二', '口', '日', '止', '足'],
    },
    Decomposition {
        kanji: '踠',
        radicals: &['卩', '口', '夕', '宀', '已', '止', '足'],
    },
    Decomposition {
        kanji: '踡',
        radicals: &['一', 'ハ', '丷', '卩', '口', '大', '已', '止', '足'],
    },
    Decomposition {
        kanji: '踢',
        radicals: &['ノ', '勹', '口', '日', '止', '勿', '足'],
    },
    Decomposition {
        kanji: '踣',
        radicals: &['口', '止', '立', '足'],
    },
    Decomposition {
        kanji: '踦',
        radicals: &['一', '亅', '口', '大', '止', '足'],
    },
    Decomposition {
        kanji: '踧',
        radicals: &['又', '口', '土', '小', '足'],
    },
    Decomposition {
        kanji: '踱',
        radicals: &['一', '凵', '又', '口', '广', '止', '足'],
    },
    Decomposition {
        kanji: '踳',
        radicals: &['一', '二', '口', '大', '日', '止', '足'],
    },
    Decomposition {
        kanji: '踶',
        radicals: &['口', '日', '止', '疋', '足'],
    },
    Decomposition {
        kanji: '踷',
        radicals: &['ノ', '口', '土', '⺹', '日', '曰', '止', '足'],
    },
    Decomposition {
        kanji: '踸',
        radicals: &['一', '｜', 'ハ', '匚', '口', '止', '甘', '足'],
    },
    Decomposition {
        kanji: '踹',
        radicals: &['口', '山', '止', '而', '足'],
    },
    Decomposition {
        kanji: '踽',
        radicals: &['ノ', '冂', '厶', '口', '止', '⽱', '虫', '足'],
    },
    Decomposition {
        kanji: '蹀',
        radicals: &['一', '｜', '口', '木', '止', '世', '足'],
    },
    Decomposition {
        kanji: '蹁',
        radicals: &[
            '一', '｜', '丶', '亅', '冂', '口', '尸', '廾', '戸', '止', '冊', '足',
        ],
    },
    Decomposition {
        kanji: '蹋',
        radicals: &['ノ', '冫', '口', '日', '止', '羽', '足'],
    },
    Decomposition {
        kanji: '蹍',
        radicals: &['｜', '二', '口', '尸', '止', '衣', '足'],
    },
    Decomposition {
        kanji: '蹎',
        radicals: &['ハ', '十', '口', '止', '目', '貝', '足'],
    },
    Decomposition {
        kanji: '蹏',
        radicals: &['ノ', '儿', '几', '匕', '卜', '厂', '口', '止', '虍', '足'],
    },
    Decomposition {
        kanji: '蹔',
        radicals: &['口', '斤', '足', '車'],
    },
    Decomposition {
        kanji: '蹛',
        radicals: &[
            '一', '｜', 'ノ', '乙', '冂', '冖', '口', '巾', '廾', '止', '足',
        ],
    },
    Decomposition {
        kanji: '蹜',
        radicals: &['一', '⺅', '口', '宀', '日', '止', '白', '足'],
    },
    Decomposition {
        kanji: '蹝',
        radicals: &['口', '彳', '止', '足'],
    },
    Decomposition {
        kanji: '蹞',
        radicals: &['ハ', '卜', '口', '止', '目', '貝', '足', '頁'],
    },
    Decomposition {
        kanji: '蹡',
        radicals: &['丶', '口', '夕', '寸', '止', '爿', '足'],
    },
    Decomposition {
        kanji: '蹢',
        radicals: &['亠', '丷', '冂', '十', '口', '止', '立', '足'],
    },
    Decomposition {
        kanji: '蹩',
        radicals: &['｜', 'ハ', '丷', '冂', '口', '巾', '攵', '足'],
    },
    Decomposition {
        kanji: '蹬',
        radicals: &['丶', 'ノ', '丷', '口', '止', '豆', '足'],
    },
    Decomposition {
        kanji: '蹭',
        radicals: &['｜', 'ハ', '丷', '口', '日', '止', '足'],
    },
    Decomposition {
        kanji: '蹯',
        radicals: &['ノ', '口', '止', '田', '米', '足'],
    },
    Decomposition {
        kanji: '蹰',
        radicals: &['丷', '厂', '口', '寸', '止', '豆', '足'],
    },
    Decomposition {
        kanji: '蹱',
        radicals: &['口', '止', '立', '足', '里'],
    },
    Decomposition {
        kanji: '蹹',
        radicals: &['一', '𠆢', '冫', '口', '止', '羽', '足'],
    },
    Decomposition {
        kanji: '蹺',
        radicals: &['一', '儿', '口', '土', '止', '足'],
    },
    Decomposition {
        kanji: '蹻',
        radicals: &['ノ', '冂', '口', '大', '止', '足'],
    },
    Decomposition {
        kanji: '躂',
        radicals: &['丷', '⻌', '口', '土', '止', '王', '羊', '足'],
    },
    Decomposition {
        kanji: '躃',
        radicals: &['十', '口', '尸', '止', '立', '足', '辛'],
    },
    Decomposition {
        kanji: '躉',
        radicals: &['冂', '厶', '口', '⺾', '田', '⽱', '足'],
    },
    Decomposition {
        kanji: '躐',
        radicals: &['丶', 'ノ', '乙', '口', '川', '巛', '止', '足'],
    },
    Decomposition {
        kanji: '躒',
        radicals: &['口', '幺', '日', '木', '止', '白', '足'],
    },
    Decomposition {
        kanji: '躕',
        radicals: &['丷', '十', '口', '士', '寸', '广', '止', '豆', '足'],
    },
    Decomposition {
        kanji: '躚',
        radicals: &['一', '凵', '⻌', '口', '大', '已', '止', '西', '足'],
    },
    Decomposition {
        kanji: '躛',
        radicals: &['一', '｜', '冂', 'ユ', '口', '巾', '彳', '行', '足'],
    },
    Decomposition {
        kanji: '躝',
        radicals: &['丷', '口', '木', '止', '足', '門'],
    },
    Decomposition {
        kanji: '躞',
        radicals: &['又', '口', '止', '火', '言', '足'],
    },
    Decomposition {
        kanji: '躢',
        radicals: &['冫', '口', '日', '曰', '止', '羽', '足', '門'],
    },
    Decomposition {
        kanji: '躧',
        radicals: &['一', '丶', '冂', '匕', '口', '广', '止', '比', '足', '鹿'],
    },
    Decomposition {
        kanji: '躩',
        radicals: &['又', '口', '止', '目', '足', '隹'],
    },
    Decomposition {
        kanji: '躭',
        radicals: &['ノ', '乙', '冖', '尢', '身'],
    },
    Decomposition {
        kanji: '躮',
        radicals: &['ハ', '刀', '身'],
    },
    Decomposition {
        kanji: '躳',
        radicals: &['ノ', '口', '身'],
    },
    Decomposition {
        kanji: '躵',
        radicals: &['ノ', '刀', '心', '身'],
    },
    Decomposition {
        kanji: '躺',
        radicals: &['冂', '口', '⺌', '身'],
    },
    Decomposition {
        kanji: '躻',
        radicals: &['儿', 'ハ', '宀', '工', '身'],
    },
    Decomposition {
        kanji: '軀',
        radicals: &['匚', '口', '身'],
    },
    Decomposition {
        kanji: '軁',
        radicals: &['十', '口', '女', '身'],
    },
    Decomposition {
        kanji: '軃',
        radicals: &['十', '口', '日', '田', '身'],
    },
    Decomposition {
        kanji: '軄',
        radicals: &['戈', '日', '立', '身', '音'],
    },
    Decomposition {
        kanji: '軇',
        radicals: &['一', '口', '士', '寸', '工', '身'],
    },
    Decomposition {
        kanji: '軏',
        radicals: &['一', '儿', '車'],
    },
    Decomposition {
        kanji: '軑',
        radicals: &['大', '車'],
    },
    Decomposition {
        kanji: '軔',
        radicals: &['ノ', '刀', '車'],
    },
    Decomposition {
        kanji: '軜',
        radicals: &['人', '冂', '車'],
    },
    Decomposition {
        kanji: '軨',
        radicals: &['一', '｜', '丶', '亅', '𠆢', 'マ', '車'],
    },
    Decomposition {
        kanji: '軮',
        radicals: &['口', '大', '車'],
    },
    Decomposition {
        kanji: '軰',
        radicals: &['一', '｜', '匕', '車'],
    },
    Decomposition {
        kanji: '軱',
        radicals: &['厶', '瓜', '車'],
    },
    Decomposition {
        kanji: '軷',
        radicals: &['又', '弋', '車'],
    },
    Decomposition {
        kanji: '軹',
        radicals: &['ハ', '口', '車'],
    },
    Decomposition {
        kanji: '軺',
        radicals: &['刀', '口', '車'],
    },
    Decomposition {
        kanji: '軭',
        radicals: &['匚', '王', '車'],
    },
    Decomposition {
        kanji: '輀',
        radicals: &['而', '車'],
    },
    Decomposition {
        kanji: '輂',
        radicals: &['｜', '二', 'ハ', '車'],
    },
    Decomposition {
        kanji: '輇',
        radicals: &['𠆢', '王', '車'],
    },
    Decomposition {
        kanji: '輈',
        radicals: &['一', '｜', '丶', '冂', '舟', '車'],
    },
    Decomposition {
        kanji: '輏',
        radicals: &['車', '酉'],
    },
    Decomposition {
        kanji: '輐',
        radicals: &['二', '儿', '宀', '元', '車'],
    },
    Decomposition {
        kanji: '輖',
        radicals: &['冂', '口', '土', '車'],
    },
    Decomposition {
        kanji: '輗',
        radicals: &['儿', '臼', '車'],
    },
    Decomposition {
        kanji: '輘',
        radicals: &['儿', 'ハ', '土', '夂', '車'],
    },
    Decomposition {
        kanji: '輞',
        radicals: &['一', '亠', '丷', '冂', '亡', '車'],
    },
    Decomposition {
        kanji: '輠',
        radicals: &['木', '田', '車'],
    },
    Decomposition {
        kanji: '輡',
        radicals: &['勹', '臼', '車'],
    },
    Decomposition {
        kanji: '輣',
        radicals: &['月', '車'],
    },
    Decomposition {
        kanji: '輥',
        radicals: &['匕', '日', '比', '車'],
    },
    Decomposition {
        kanji: '輧',
        radicals: &['一', 'ノ', '十', '干', '車'],
    },
    Decomposition {
        kanji: '輨',
        radicals: &['｜', '口', '宀', '車'],
    },
    Decomposition {
        kanji: '輬',
        radicals: &['亠', '口', '小', '車'],
    },
    Decomposition {
        kanji: '輭',
        radicals: &['大', '而', '車'],
    },
    Decomposition {
        kanji: '輮',
        radicals: &['マ', '木', '矛', '車'],
    },
    Decomposition {
        kanji: '輴',
        radicals: &['十', '厂', '目', '車'],
    },
    Decomposition {
        kanji: '輵',
        radicals: &['人', '勹', '日', '車'],
    },
    Decomposition {
        kanji: '輶',
        radicals: &['ハ', '丷', '車', '酉'],
    },
    Decomposition {
        kanji: '輷',
        radicals: &['勹', '言', '車'],
    },
    Decomposition {
        kanji: '輺',
        radicals: &['一', '巛', '田', '車'],
    },
    Decomposition {
        kanji: '轀',
        radicals: &['人', '口', '皿', '車'],
    },
    Decomposition {
        kanji: '轁',
        radicals: &['爪', '臼', '車'],
    },
    Decomposition {
        kanji: '轃',
        radicals: &['一', 'ノ', '二', '大', '木', '禾', '車'],
    },
    Decomposition {
        kanji: '轇',
        radicals: &['ノ', '𠆢', '冫', '彡', '羽', '車'],
    },
    Decomposition {
        kanji: '轏',
        radicals: &['子', '尸', '車'],
    },
    Decomposition {
        kanji: '轑',
        radicals: &['丶', 'ノ', '大', '小', '日', '車'],
    },
    Decomposition {
        kanji: '轒',
        radicals: &['ハ', '十', '⺾', '目', '貝', '車'],
    },
    Decomposition {
        kanji: '轓',
        radicals: &['ノ', '田', '米', '車'],
    },
    Decomposition {
        kanji: '轔',
        radicals: &['夕', '米', '車', '舛'],
    },
    Decomposition {
        kanji: '轕',
        radicals: &['人', '勹', '⺾', '日', '車'],
    },
    Decomposition {
        kanji: '轘',
        radicals: &['一', '口', '⺲', '衣', '車'],
    },
    Decomposition {
        kanji: '轝',
        radicals: &['一', '｜', '亠', 'ハ', 'ヨ', '車'],
    },
    Decomposition {
        kanji: '轞',
        radicals: &['一', '丶', 'ノ', '匚', '皿', '臣', '車'],
    },
    Decomposition {
        kanji: '轥',
        radicals: &['⺾', '車', '門', '隹'],
    },
    Decomposition {
        kanji: '辝',
        radicals: &['十', '厶', '口', '立', '辛'],
    },
    Decomposition {
        kanji: '辠',
        radicals: &['十', '目', '立', '自', '辛'],
    },
    Decomposition {
        kanji: '辡',
        radicals: &['十', '立', '辛'],
    },
    Decomposition {
        kanji: '辤',
        radicals: &['冖', '十', '又', '爪', '立', '辛'],
    },
    Decomposition {
        kanji: '辥',
        radicals: &['｜', 'ノ', '十', '口', '屮', '立', '辛'],
    },
    Decomposition {
        kanji: '辦',
        radicals: &['力', '十', '立', '辛'],
    },
    Decomposition {
        kanji: '辵',
        radicals: &['彡', '止'],
    },
    Decomposition {
        kanji: '辶',
        radicals: &['⻌'],
    },
    Decomposition {
        kanji: '辸',
        radicals: &['乃', '⻌'],
    },
    Decomposition {
        kanji: '达',
        radicals: &['⻌', '大'],
    },
    Decomposition {
        kanji: '迀',
        radicals: &['一', '十', '⻌', '干'],
    },
    Decomposition {
        kanji: '迁',
        radicals: &['ノ', '十', '⻌'],
    },
    Decomposition {
        kanji: '迆',
        radicals: &['｜', '乙', '匕', '⻌', '也'],
    },
    Decomposition {
        kanji: '迊',
        radicals: &['一', '｜', '冂', '⻌', '巾'],
    },
    Decomposition {
        kanji: '迋',
        radicals: &['⻌', '王'],
    },
    Decomposition {
        kanji: '迍',
        radicals: &['ノ', '乙', '凵', '⻌', '屯'],
    },
    Decomposition {
        kanji: '运',
        radicals: &['二', '厶', '⻌'],
    },
    Decomposition {
        kanji: '迒',
        radicals: &['亠', '几', '⻌'],
    },
    Decomposition {
        kanji: '迓',
        radicals: &['⻌', '牙'],
    },
    Decomposition {
        kanji: '迕',
        radicals: &['一', 'ノ', '十', '⻌', '干'],
    },
    Decomposition {
        kanji: '迠',
        radicals: &['卜', '⻌', '口'],
    },
    Decomposition {
        kanji: '迣',
        radicals: &['一', '｜', '⻌', '世'],
    },
    Decomposition {
        kanji: '迤',
        radicals: &['一', '｜', 'ノ', '乙', '匕', '⻌', '也'],
    },
    Decomposition {
        kanji: '迨',
        radicals: &['厶', '⻌', '口'],
    },
    Decomposition {
        kanji: '迮',
        radicals: &['一', '｜', 'ノ', '⻌'],
    },
    Decomposition {
        kanji: '迱',
        radicals: &['匕', '⻌', '宀'],
    },
    Decomposition {
        kanji: '迵',
        radicals: &['一', '冂', '⻌', '口'],
    },
    Decomposition {
        kanji: '迶',
        radicals: &['一', 'ノ', '⻌', '月'],
    },
    Decomposition {
        kanji: '迻',
        radicals: &['⻌', '夕'],
    },
    Decomposition {
        kanji: '迾',
        radicals: &['⺉', '⻌', '歹'],
    },
    Decomposition {
        kanji: '适',
        radicals: &['⻌', '口', '舌'],
    },
    Decomposition {
        kanji: '逄',
        radicals: &['｜', '二', '⻌', '夂'],
    },
    Decomposition {
        kanji: '逈',
        radicals: &['ノ', '冂', '⻌', '口'],
    },
    Decomposition {
        kanji: '逌',
        radicals: &['卜', '⻌', '口'],
    },
    Decomposition {
        kanji: '逘',
        radicals: &['一', 'ノ', '厶', '⻌', '大', '矢'],
    },
    Decomposition {
        kanji: '逛',
        radicals: &['⻌', '⺨', '王'],
    },
    Decomposition {
        kanji: '逨',
        radicals: &['人', '⻌', '木'],
    },
    Decomposition {
        kanji: '逩',
        radicals: &['十', '⻌', '大', '廾'],
    },
    Decomposition {
        kanji: '逯',
        radicals: &['⻌', 'ヨ', '彑', '水'],
    },
    Decomposition {
        kanji: '逪',
        radicals: &['｜', '二', '⻌', '日'],
    },
    Decomposition {
        kanji: '逬',
        radicals: &['一', 'ノ', '十', '⻌', '干'],
    },
    Decomposition {
        kanji: '逭',
        radicals: &['｜', '⻌', '口', '宀'],
    },
    Decomposition {
        kanji: '逳',
        radicals: &['亠', '厶', '⻌', '月'],
    },
    Decomposition {
        kanji: '逴',
        radicals: &['十', '卜', '⻌', '日'],
    },
    Decomposition {
        kanji: '逷',
        radicals: &['ノ', '勹', '⻌', '日', '勿'],
    },
    Decomposition {
        kanji: '逿',
        radicals: &['一', 'ノ', '勹', '⻌', '日', '曰', '勿'],
    },
    Decomposition {
        kanji: '遃',
        radicals: &['丶', 'ノ', '亠', '丷', '厂', '⻌', '彡'],
    },
    Decomposition {
        kanji: '遄',
        radicals: &['⻌', '山', '而'],
    },
    Decomposition {
        kanji: '遌',
        radicals: &['二', '勹', '⻌', '口'],
    },
    Decomposition {
        kanji: '遛',
        radicals: &['刀', '厶', '⻌', '田'],
    },
    Decomposition {
        kanji: '遝',
        radicals: &['｜', '丶', 'ノ', '⻌', '⺲'],
    },
    Decomposition {
        kanji: '遢',
        radicals: &['冫', '⻌', '日', '曰', '羽'],
    },
    Decomposition {
        kanji: '遦',
        radicals: &['ハ', '十', '⻌', '口', '田', '目', '貝'],
    },
    Decomposition {
        kanji: '遧',
        radicals: &['十', '⻌', '日', '立'],
    },
    Decomposition {
        kanji: '遬',
        radicals: &['人', '勹', '⻌', '口', '木', '欠'],
    },
    Decomposition {
        kanji: '遰',
        radicals: &['一', '｜', 'ノ', '乙', '冂', '冖', '⻌', '巾', '廾'],
    },
    Decomposition {
        kanji: '遴',
        radicals: &['⻌', '夕', '米', '舛'],
    },
    Decomposition {
        kanji: '遹',
        radicals: &['儿', 'ハ', '冂', 'マ', '⻌', '口', '矛'],
    },
    Decomposition {
        kanji: '邅',
        radicals: &['一', '亠', '⻌', '口', '日'],
    },
    Decomposition {
        kanji: '邈',
        radicals: &['儿', '⻌', '日', '白', '豸'],
    },
    Decomposition {
        kanji: '邋',
        radicals: &['丶', 'ノ', '乙', '⻌', '口', '川', '巛'],
    },
    Decomposition {
        kanji: '邌',
        radicals: &['ノ', '𠆢', '勹', '⻌', '木', '水', '禾'],
    },
    Decomposition {
        kanji: '邎',
        radicals: &['丶', 'ノ', '⻌', '夕', '小', '幺', '糸', '言'],
    },
    Decomposition {
        kanji: '邐',
        radicals: &['一', '丶', '冂', '匕', '⻌', '广', '比', '鹿'],
    },
    Decomposition {
        kanji: '邕',
        radicals: &['乙', '口', '巛', '已', '⻏', '巴'],
    },
    Decomposition {
        kanji: '邗',
        radicals: &['一', '十', '干', '⻏'],
    },
    Decomposition {
        kanji: '邘',
        radicals: &['亅', '二', '⻏'],
    },
    Decomposition {
        kanji: '邙',
        radicals: &['亠', '⻏', '亡'],
    },
    Decomposition {
        kanji: '邛',
        radicals: &['工', '⻏'],
    },
    Decomposition {
        kanji: '邠',
        radicals: &['ハ', '刀', '⻏'],
    },
    Decomposition {
        kanji: '邡',
        radicals: &['⻏', '方'],
    },
    Decomposition {
        kanji: '邢',
        radicals: &['一', '廾', '⻏'],
    },
    Decomposition {
        kanji: '邥',
        radicals: &['ノ', '乙', '冖', '尢', '⻏'],
    },
    Decomposition {
        kanji: '邰',
        radicals: &['厶', '口', '⻏'],
    },
    Decomposition {
        kanji: '邲',
        radicals: &['ノ', '⻏', '心'],
    },
    Decomposition {
        kanji: '邳',
        radicals: &['一', '｜', '丶', 'ノ', '⻏'],
    },
    Decomposition {
        kanji: '邴',
        radicals: &['一', '人', '冂', '⻏'],
    },
    Decomposition {
        kanji: '邶',
        radicals: &['一', '｜', '匕', '⻏'],
    },
    Decomposition {
        kanji: '邽',
        radicals: &['土', '⻏'],
    },
    Decomposition {
        kanji: '郌',
        radicals: &['乙', '口', '士', '已', '⻏', '巴'],
    },
    Decomposition {
        kanji: '邾',
        radicals: &['一', 'ノ', '⻏', '木'],
    },
    Decomposition {
        kanji: '郃',
        radicals: &['一', '𠆢', '口', '⻏'],
    },
    Decomposition {
        kanji: '郄',
        radicals: &['一', '丶', 'ノ', '厶', '⻏'],
    },
    Decomposition {
        kanji: '郅',
        radicals: &['一', '厶', '土', '⻏', '至'],
    },
    Decomposition {
        kanji: '郇',
        radicals: &['勹', '⻏', '日'],
    },
    Decomposition {
        kanji: '郈',
        radicals: &['一', '厂', '口', '⻏'],
    },
    Decomposition {
        kanji: '郕',
        radicals: &['ノ', '亅', '厂', '⻏', '戈'],
    },
    Decomposition {
        kanji: '郗',
        radicals: &['一', '｜', '丶', 'ノ', '冂', '巾', '⻏'],
    },
    Decomposition {
        kanji: '郘',
        radicals: &['口', '⻏'],
    },
    Decomposition {
        kanji: '郙',
        radicals: &['丶', '十', '⻏', '月'],
    },
    Decomposition {
        kanji: '郜',
        radicals: &['｜', 'ノ', '二', '口', '土', '⻏'],
    },
    Decomposition {
        kanji: '郝',
        radicals: &['土', '⻏', '赤'],
    },
    Decomposition {
        kanji: '郟',
        radicals: &['人', '大', '⻏'],
    },
    Decomposition {
        kanji: '郥',
        radicals: &['ハ', '⻏', '目', '貝'],
    },
    Decomposition {
        kanji: '郒',
        radicals: &['丶', '乙', '厶', '口', '已', '⻏', '日', '曰', '巴'],
    },
    Decomposition {
        kanji: '郶',
        radicals: &['乙', '口', '已', '⻏', '巴', '立'],
    },
    Decomposition {
        kanji: '郫',
        radicals: &['ノ', '十', '⻏', '日', '白'],
    },
    Decomposition {
        kanji: '郯',
        radicals: &['⻏', '火'],
    },
    Decomposition {
        kanji: '郰',
        radicals: &['又', '⻏', '耳'],
    },
    Decomposition {
        kanji: '郴',
        radicals: &['⻏', '木'],
    },
    Decomposition {
        kanji: '郾',
        radicals: &['匚', '女', '⻏', '日'],
    },
    Decomposition {
        kanji: '郿',
        radicals: &['｜', '尸', '⻏', '目'],
    },
    Decomposition {
        kanji: '鄀',
        radicals: &['一', 'ノ', '口', '⺾', '⻏'],
    },
    Decomposition {
        kanji: '鄄',
        radicals: &['土', '⻏', '西'],
    },
    Decomposition {
        kanji: '鄅',
        radicals: &['ノ', '冂', '厶', '口', '⻏', '⽱', '虫'],
    },
    Decomposition {
        kanji: '鄆',
        radicals: &['冖', '⻏', '車'],
    },
    Decomposition {
        kanji: '鄈',
        radicals: &['一', '丶', 'ノ', '大', '⻏'],
    },
    Decomposition {
        kanji: '鄍',
        radicals: &['亠', 'ハ', '冖', '⻏', '日', '曰'],
    },
    Decomposition {
        kanji: '鄐',
        radicals: &['亠', '幺', '⻏', '玄', '田'],
    },
    Decomposition {
        kanji: '鄔',
        radicals: &['⻏', '⺣', '鳥'],
    },
    Decomposition {
        kanji: '鄖',
        radicals: &['ハ', '口', '⻏', '目', '貝'],
    },
    Decomposition {
        kanji: '鄗',
        radicals: &['亠', '冂', '口', '⻏', '高'],
    },
    Decomposition {
        kanji: '鄘',
        radicals: &['｜', '二', '冂', '广', 'ヨ', '⻏', '月', '聿'],
    },
    Decomposition {
        kanji: '鄚',
        radicals: &['大', '⺾', '⻏', '日'],
    },
    Decomposition {
        kanji: '鄜',
        radicals: &['匕', '广', '⻏', '比', '鹿'],
    },
    Decomposition {
        kanji: '鄞',
        radicals: &['二', '十', '口', '廾', '⻏', '革'],
    },
    Decomposition {
        kanji: '鄠',
        radicals: &['二', '冖', '勹', '⻏', '雨'],
    },
    Decomposition {
        kanji: '鄥',
        radicals: &['⻏', '⺣', '鳥'],
    },
    Decomposition {
        kanji: '鄢',
        radicals: &['一', '勹', '⻏', '止', '⺣'],
    },
    Decomposition {
        kanji: '鄣',
        radicals: &['十', '⻏', '日', '立', '音'],
    },
    Decomposition {
        kanji: '鄧',
        radicals: &['丶', 'ノ', '丷', '口', '⻏', '豆'],
    },
    Decomposition {
        kanji: '鄩',
        radicals: &['口', '寸', '工', 'ヨ', '⻏'],
    },
    Decomposition {
        kanji: '鄮',
        radicals: &['ノ', 'ハ', '刀', '厶', '⻏', '目', '貝'],
    },
    Decomposition {
        kanji: '鄯',
        radicals: &['一', '丷', '口', '⻏', '王', '羊'],
    },
    Decomposition {
        kanji: '鄱',
        radicals: &['ノ', '⻏', '田', '米'],
    },
    Decomposition {
        kanji: '鄴',
        radicals: &['一', '｜', '丶', 'ノ', '丷', '⻏', '王', '羊'],
    },
    Decomposition {
        kanji: '鄶',
        radicals: &['一', '｜', '𠆢', '丷', '口', '⻏', '日', '曰'],
    },
    Decomposition {
        kanji: '鄷',
        radicals: &['｜', '丷', '口', '⻏', '日', '豆'],
    },
    Decomposition {
        kanji: '鄹',
        radicals: &['｜', '丶', 'ノ', '又', '⻏', '耳'],
    },
    Decomposition {
        kanji: '鄺',
        radicals: &['ハ', '广', '⻏', '田', '黄'],
    },
    Decomposition {
        kanji: '鄼',
        radicals: &['一', 'ハ', '大', '⻏', '目', '貝'],
    },
    Decomposition {
        kanji: '鄽',
        radicals: &['儿', 'ハ', '土', '广', '⻏', '里'],
    },
    Decomposition {
        kanji: '酃',
        radicals: &['二', '冖', '口', '⻏', '雨'],
    },
    Decomposition {
        kanji: '酇',
        radicals: &['ノ', '儿', 'ハ', '土', '⻏', '目', '貝'],
    },
    Decomposition {
        kanji: '酈',
        radicals: &['一', '丶', '冂', '匕', '广', '⻏', '比', '鹿'],
    },
    Decomposition {
        kanji: '酏',
        radicals: &['｜', '乙', '匕', '也', '酉'],
    },
    Decomposition {
        kanji: '酓',
        radicals: &['丶', '𠆢', '酉'],
    },
    Decomposition {
        kanji: '酗',
        radicals: &['丶', 'ノ', '凵', '酉'],
    },
    Decomposition {
        kanji: '酙',
        radicals: &['斗', '酉'],
    },
    Decomposition {
        kanji: '酚',
        radicals: &['ハ', '刀', '酉'],
    },
    Decomposition {
        kanji: '酛',
        radicals: &['二', '儿', '元', '酉'],
    },
    Decomposition {
        kanji: '酡',
        radicals: &['匕', '宀', '酉'],
    },
    Decomposition {
        kanji: '酤',
        radicals: &['十', '口', '酉'],
    },
    Decomposition {
        kanji: '酧',
        radicals: &['宀', '寸', '酉'],
    },
    Decomposition {
        kanji: '酭',
        radicals: &['一', 'ノ', '月', '酉'],
    },
    Decomposition {
        kanji: '酴',
        radicals: &['二', '𠆢', '小', '酉'],
    },
    Decomposition {
        kanji: '酹',
        radicals: &['寸', '爪', '酉'],
    },
    Decomposition {
        kanji: '酺',
        radicals: &['丶', '十', '月', '酉'],
    },
    Decomposition {
        kanji: '酻',
        radicals: &['子', '爪', '酉'],
    },
    Decomposition {
        kanji: '醁',
        radicals: &['ヨ', '水', '酉'],
    },
    Decomposition {
        kanji: '醃',
        radicals: &['乙', '大', '日', '酉', '奄'],
    },
    Decomposition {
        kanji: '醅',
        radicals: &['口', '立', '酉'],
    },
    Decomposition {
        kanji: '醆',
        radicals: &['戈', '酉'],
    },
    Decomposition {
        kanji: '醊',
        radicals: &['又', '酉'],
    },
    Decomposition {
        kanji: '醎',
        radicals: &['一', 'ノ', '厂', '口', '戈', '酉'],
    },
    Decomposition {
        kanji: '醑',
        radicals: &['月', '疋', '酉'],
    },
    Decompos