pub fn jis212_to_utf8(code: u16) -> Option<char> {
    match code {
        0x2237 => Some('\u{007E}'),
        0x2242 => Some('\u{00A1}'),
        0x2270 => Some('\u{00A4}'),
        0x2243 => Some('\u{00A6}'),
        0x226D => Some('\u{00A9}'),
        0x226C => Some('\u{00AA}'),
        0x226E => Some('\u{00AE}'),
        0x2234 => Some('\u{00AF}'),
        0x2231 => Some('\u{00B8}'),
        0x226B => Some('\u{00BA}'),
        0x2244 => Some('\u{00BF}'),
        0x2A22 => Some('\u{00C0}'),
        0x2A21 => Some('\u{00C1}'),
        0x2A24 => Some('\u{00C2}'),
        0x2A2A => Some('\u{00C3}'),
        0x2A23 => Some('\u{00C4}'),
        0x2A29 => Some('\u{00C5}'),
        0x2921 => Some('\u{00C6}'),
        0x2A2E => Some('\u{00C7}'),
        0x2A32 => Some('\u{00C8}'),
        0x2A31 => Some('\u{00C9}'),
        0x2A34 => Some('\u{00CA}'),
        0x2A33 => Some('\u{00CB}'),
        0x2A40 => Some('\u{00CC}'),
        0x2A3F => Some('\u{00CD}'),
        0x2A42 => Some('\u{00CE}'),
        0x2A41 => Some('\u{00CF}'),
        0x2A50 => Some('\u{00D1}'),
        0x2A52 => Some('\u{00D2}'),
        0x2A51 => Some('\u{00D3}'),
        0x2A54 => Some('\u{00D4}'),
        0x2A58 => Some('\u{00D5}'),
        0x2A53 => Some('\u{00D6}'),
        0x292C => Some('\u{00D8}'),
        0x2A63 => Some('\u{00D9}'),
        0x2A62 => Some('\u{00DA}'),
        0x2A65 => Some('\u{00DB}'),
        0x2A64 => Some('\u{00DC}'),
        0x2A72 => Some('\u{00DD}'),
        0x2930 => Some('\u{00DE}'),
        0x294E => Some('\u{00DF}'),
        0x2B22 => Some('\u{00E0}'),
        0x2B21 => Some('\u{00E1}'),
        0x2B24 => Some('\u{00E2}'),
        0x2B2A => Some('\u{00E3}'),
        0x2B23 => Some('\u{00E4}'),
        0x2B29 => Some('\u{00E5}'),
        0x2941 => Some('\u{00E6}'),
        0x2B2E => Some('\u{00E7}'),
        0x2B32 => Some('\u{00E8}'),
        0x2B31 => Some('\u{00E9}'),
        0x2B34 => Some('\u{00EA}'),
        0x2B33 => Some('\u{00EB}'),
        0x2B40 => Some('\u{00EC}'),
        0x2B3F => Some('\u{00ED}'),
        0x2B42 => Some('\u{00EE}'),
        0x2B41 => Some('\u{00EF}'),
        0x2943 => Some('\u{00F0}'),
        0x2B50 => Some('\u{00F1}'),
        0x2B52 => Some('\u{00F2}'),
        0x2B51 => Some('\u{00F3}'),
        0x2B54 => Some('\u{00F4}'),
        0x2B58 => Some('\u{00F5}'),
        0x2B53 => Some('\u{00F6}'),
        0x294C => Some('\u{00F8}'),
        0x2B63 => Some('\u{00F9}'),
        0x2B62 => Some('\u{00FA}'),
        0x2B65 => Some('\u{00FB}'),
        0x2B64 => Some('\u{00FC}'),
        0x2B72 => Some('\u{00FD}'),
        0x2950 => Some('\u{00FE}'),
        0x2B73 => Some('\u{00FF}'),
        0x2A27 => Some('\u{0100}'),
        0x2B27 => Some('\u{0101}'),
        0x2A25 => Some('\u{0102}'),
        0x2B25 => Some('\u{0103}'),
        0x2A28 => Some('\u{0104}'),
        0x2B28 => Some('\u{0105}'),
        0x2A2B => Some('\u{0106}'),
        0x2B2B => Some('\u{0107}'),
        0x2A2C => Some('\u{0108}'),
        0x2B2C => Some('\u{0109}'),
        0x2A2F => Some('\u{010A}'),
        0x2B2F => Some('\u{010B}'),
        0x2A2D => Some('\u{010C}'),
        0x2B2D => Some('\u{010D}'),
        0x2A30 => Some('\u{010E}'),
        0x2B30 => Some('\u{010F}'),
        0x2922 => Some('\u{0110}'),
        0x2942 => Some('\u{0111}'),
        0x2A37 => Some('\u{0112}'),
        0x2B37 => Some('\u{0113}'),
        0x2A36 => Some('\u{0116}'),
        0x2B36 => Some('\u{0117}'),
        0x2A38 => Some('\u{0118}'),
        0x2B38 => Some('\u{0119}'),
        0x2A35 => Some('\u{011A}'),
        0x2B35 => Some('\u{011B}'),
        0x2A3A => Some('\u{011C}'),
        0x2B3A => Some('\u{011D}'),
        0x2A3B => Some('\u{011E}'),
        0x2B3B => Some('\u{011F}'),
        0x2A3D => Some('\u{0120}'),
        0x2B3D => Some('\u{0121}'),
        0x2A3C => Some('\u{0122}'),
        0x2A3E => Some('\u{0124}'),
        0x2B3E => Some('\u{0125}'),
        0x2924 => Some('\u{0126}'),
        0x2944 => Some('\u{0127}'),
        0x2A47 => Some('\u{0128}'),
        0x2B47 => Some('\u{0129}'),
        0x2A45 => Some('\u{012A}'),
        0x2B45 => Some('\u{012B}'),
        0x2A46 => Some('\u{012E}'),
        0x2B46 => Some('\u{012F}'),
        0x2A44 => Some('\u{0130}'),
        0x2945 => Some('\u{0131}'),
        0x2926 => Some('\u{0132}'),
        0x2946 => Some('\u{0133}'),
        0x2A48 => Some('\u{0134}'),
        0x2B48 => Some('\u{0135}'),
        0x2A49 => Some('\u{0136}'),
        0x2B49 => Some('\u{0137}'),
        0x2947 => Some('\u{0138}'),
        0x2A4A => Some('\u{0139}'),
        0x2B4A => Some('\u{013A}'),
        0x2A4C => Some('\u{013B}'),
        0x2B4C => Some('\u{013C}'),
        0x2A4B => Some('\u{013D}'),
        0x2B4B => Some('\u{013E}'),
        0x2929 => Some('\u{013F}'),
        0x2949 => Some('\u{0140}'),
        0x2928 => Some('\u{0141}'),
        0x2948 => Some('\u{0142}'),
        0x2A4D => Some('\u{0143}'),
        0x2B4D => Some('\u{0144}'),
        0x2A4F => Some('\u{0145}'),
        0x2B4F => Some('\u{0146}'),
        0x2A4E => Some('\u{0147}'),
        0x2B4E => Some('\u{0148}'),
        0x294A => Some('\u{0149}'),
        0x292B => Some('\u{014A}'),
        0x294B => Some('\u{014B}'),
        0x2A57 => Some('\u{014C}'),
        0x2B57 => Some('\u{014D}'),
        0x2A56 => Some('\u{0150}'),
        0x2B56 => Some('\u{0151}'),
        0x292D => Some('\u{0152}'),
        0x294D => Some('\u{0153}'),
        0x2A59 => Some('\u{0154}'),
        0x2B59 => Some('\u{0155}'),
        0x2A5B => Some('\u{0156}'),
        0x2B5B => Some('\u{0157}'),
        0x2A5A => Some('\u{0158}'),
        0x2B5A => Some('\u{0159}'),
        0x2A5C => Some('\u{015A}'),
        0x2B5C => Some('\u{015B}'),
        0x2A5D => Some('\u{015C}'),
        0x2B5D => Some('\u{015D}'),
        0x2A5F => Some('\u{015E}'),
        0x2B5F => Some('\u{015F}'),
        0x2A5E => Some('\u{0160}'),
        0x2B5E => Some('\u{0161}'),
        0x2A61 => Some('\u{0162}'),
        0x2B61 => Some('\u{0163}'),
        0x2A60 => Some('\u{0164}'),
        0x2B60 => Some('\u{0165}'),
        0x292F => Some('\u{0166}'),
        0x294F => Some('\u{0167}'),
        0x2A6C => Some('\u{0168}'),
        0x2B6C => Some('\u{0169}'),
        0x2A69 => Some('\u{016A}'),
        0x2B69 => Some('\u{016B}'),
        0x2A66 => Some('\u{016C}'),
        0x2B66 => Some('\u{016D}'),
        0x2A6B => Some('\u{016E}'),
        0x2B6B => Some('\u{016F}'),
        0x2A68 => Some('\u{0170}'),
        0x2B68 => Some('\u{0171}'),
        0x2A6A => Some('\u{0172}'),
        0x2B6A => Some('\u{0173}'),
        0x2A71 => Some('\u{0174}'),
        0x2B71 => Some('\u{0175}'),
        0x2A74 => Some('\u{0176}'),
        0x2B74 => Some('\u{0177}'),
        0x2A73 => Some('\u{0178}'),
        0x2A75 => Some('\u{0179}'),
        0x2B75 => Some('\u{017A}'),
        0x2A77 => Some('\u{017B}'),
        0x2B77 => Some('\u{017C}'),
        0x2A76 => Some('\u{017D}'),
        0x2B76 => Some('\u{017E}'),
        0x2A26 => Some('\u{01CD}'),
        0x2B26 => Some('\u{01CE}'),
        0x2A43 => Some('\u{01CF}'),
        0x2B43 => Some('\u{01D0}'),
        0x2A55 => Some('\u{01D1}'),
        0x2B55 => Some('\u{01D2}'),
        0x2A67 => Some('\u{01D3}'),
        0x2B67 => Some('\u{01D4}'),
        0x2A70 => Some('\u{01D5}'),
        0x2B70 => Some('\u{01D6}'),
        0x2A6D => Some('\u{01D7}'),
        0x2B6D => Some('\u{01D8}'),
        0x2A6F => Some('\u{01D9}'),
        0x2B6F => Some('\u{01DA}'),
        0x2A6E => Some('\u{01DB}'),
        0x2B6E => Some('\u{01DC}'),
        0x2B39 => Some('\u{01F5}'),
        0x2230 => Some('\u{02C7}'),
        0x222F => Some('\u{02D8}'),
        0x2232 => Some('\u{02D9}'),
        0x2236 => Some('\u{02DA}'),
        0x2235 => Some('\u{02DB}'),
        0x2233 => Some('\u{02DD}'),
        0x2238 => Some('\u{0384}'),
        0x2239 => Some('\u{0385}'),
        0x2661 => Some('\u{0386}'),
        0x2662 => Some('\u{0388}'),
        0x2663 => Some('\u{0389}'),
        0x2664 => Some('\u{038A}'),
        0x2667 => Some('\u{038C}'),
        0x2669 => Some('\u{038E}'),
        0x266C => Some('\u{038F}'),
        0x2676 => Some('\u{0390}'),
        0x2665 => Some('\u{03AA}'),
        0x266A => Some('\u{03AB}'),
        0x2671 => Some('\u{03AC}'),
        0x2672 => Some('\u{03AD}'),
        0x2673 => Some('\u{03AE}'),
        0x2674 => Some('\u{03AF}'),
        0x267B => Some('\u{03B0}'),
        0x2678 => Some('\u{03C2}'),
        0x2675 => Some('\u{03CA}'),
        0x267A => Some('\u{03CB}'),
        0x2677 => Some('\u{03CC}'),
        0x2679 => Some('\u{03CD}'),
        0x267C => Some('\u{03CE}'),
        0x2742 => Some('\u{0402}'),
        0x2743 => Some('\u{0403}'),
        0x2744 => Some('\u{0404}'),
        0x2745 => Some('\u{0405}'),
        0x2746 => Some('\u{0406}'),
        0x2747 => Some('\u{0407}'),
        0x2748 => Some('\u{0408}'),
        0x2749 => Some('\u{0409}'),
        0x274A => Some('\u{040A}'),
        0x274B => Some('\u{040B}'),
        0x274C => Some('\u{040C}'),
        0x274D => Some('\u{040E}'),
        0x274E => Some('\u{040F}'),
        0x2772 => Some('\u{0452}'),
        0x2773 => Some('\u{0453}'),
        0x2774 => Some('\u{0454}'),
        0x2775 => Some('\u{0455}'),
        0x2776 => Some('\u{0456}'),
        0x2777 => Some('\u{0457}'),
        0x2778 => Some('\u{0458}'),
        0x2779 => Some('\u{0459}'),
        0x277A => Some('\u{045A}'),
        0x277B => Some('\u{045B}'),
        0x277C => Some('\u{045C}'),
        0x277D => Some('\u{045E}'),
        0x277E => Some('\u{045F}'),
        0x2271 => Some('\u{2116}'),
        0x226F => Some('\u{2122}'),
        0x3021 => Some('\u{4E02}'),
        0x3022 => Some('\u{4E04}'),
        0x3023 => Some('\u{4E05}'),
        0x3024 => Some('\u{4E0C}'),
        0x3025 => Some('\u{4E12}'),
        0x3026 => Some('\u{4E1F}'),
        0x3027 => Some('\u{4E23}'),
        0x3028 => Some('\u{4E24}'),
        0x3029 => Some('\u{4E28}'),
        0x302A => Some('\u{4E2B}'),
        0x302B => Some('\u{4E2E}'),
        0x302C => Some('\u{4E2F}'),
        0x302D => Some('\u{4E30}'),
        0x302E => Some('\u{4E35}'),
        0x302F => Some('\u{4E40}'),
        0x3030 => Some('\u{4E41}'),
        0x3031 => Some('\u{4E44}'),
        0x3032 => Some('\u{4E47}'),
        0x3033 => Some('\u{4E51}'),
        0x3034 => Some('\u{4E5A}'),
        0x3035 => Some('\u{4E5C}'),
        0x3036 => Some('\u{4E63}'),
        0x3037 => Some('\u{4E68}'),
        0x3038 => Some('\u{4E69}'),
        0x3039 => Some('\u{4E74}'),
        0x303A => Some('\u{4E75}'),
        0x303B => Some('\u{4E79}'),
        0x303C => Some('\u{4E7F}'),
        0x303D => Some('\u{4E8D}'),
        0x303E => Some('\u{4E96}'),
        0x303F => Some('\u{4E97}'),
        0x3040 => Some('\u{4E9D}'),
        0x3041 => Some('\u{4EAF}'),
        0x3042 => Some('\u{4EB9}'),
        0x3043 => Some('\u{4EC3}'),
        0x3044 => Some('\u{4ED0}'),
        0x3045 => Some('\u{4EDA}'),
        0x3046 => Some('\u{4EDB}'),
        0x3047 => Some('\u{4EE0}'),
        0x3048 => Some('\u{4EE1}'),
        0x3049 => Some('\u{4EE2}'),
        0x304A => Some('\u{4EE8}'),
        0x304B => Some('\u{4EEF}'),
        0x304C => Some('\u{4EF1}'),
        0x304D => Some('\u{4EF3}'),
        0x304E => Some('\u{4EF5}'),
        0x304F => Some('\u{4EFD}'),
        0x3050 => Some('\u{4EFE}'),
        0x3051 => Some('\u{4EFF}'),
        0x3052 => Some('\u{4F00}'),
        0x3053 => Some('\u{4F02}'),
        0x3054 => Some('\u{4F03}'),
        0x3055 => Some('\u{4F08}'),
        0x3056 => Some('\u{4F0B}'),
        0x3057 => Some('\u{4F0C}'),
        0x3058 => Some('\u{4F12}'),
        0x3059 => Some('\u{4F15}'),
        0x305A => Some('\u{4F16}'),
        0x305B => Some('\u{4F17}'),
        0x305C => Some('\u{4F19}'),
        0x305D => Some('\u{4F2E}'),
        0x305E => Some('\u{4F31}'),
        0x3060 => Some('\u{4F33}'),
        0x3061 => Some('\u{4F35}'),
        0x3062 => Some('\u{4F37}'),
        0x3063 => Some('\u{4F39}'),
        0x3064 => Some('\u{4F3B}'),
        0x3065 => Some('\u{4F3E}'),
        0x3066 => Some('\u{4F40}'),
        0x3067 => Some('\u{4F42}'),
        0x3068 => Some('\u{4F48}'),
        0x3069 => Some('\u{4F49}'),
        0x306A => Some('\u{4F4B}'),
        0x306B => Some('\u{4F4C}'),
        0x306C => Some('\u{4F52}'),
        0x306D => Some('\u{4F54}'),
        0x306E => Some('\u{4F56}'),
        0x306F => Some('\u{4F58}'),
        0x3070 => Some('\u{4F5F}'),
        0x305F => Some('\u{4F60}'),
        0x3071 => Some('\u{4F63}'),
        0x3072 => Some('\u{4F6A}'),
        0x3073 => Some('\u{4F6C}'),
        0x3074 => Some('\u{4F6E}'),
        0x3075 => Some('\u{4F71}'),
        0x3076 => Some('\u{4F77}'),
        0x3077 => Some('\u{4F78}'),
        0x3078 => Some('\u{4F79}'),
        0x3079 => Some('\u{4F7A}'),
        0x307A => Some('\u{4F7D}'),
        0x307B => Some('\u{4F7E}'),
        0x307C => Some('\u{4F81}'),
        0x307D => Some('\u{4F82}'),
        0x307E => Some('\u{4F84}'),
        0x3121 => Some('\u{4F85}'),
        0x3122 => Some('\u{4F89}'),
        0x3123 => Some('\u{4F8A}'),
        0x3124 => Some('\u{4F8C}'),
        0x3125 => Some('\u{4F8E}'),
        0x3126 => Some('\u{4F90}'),
        0x3127 => Some('\u{4F92}'),
        0x3128 => Some('\u{4F93}'),
        0x3129 => Some('\u{4F94}'),
        0x312A => Some('\u{4F97}'),
        0x312B => Some('\u{4F99}'),
        0x312C => Some('\u{4F9A}'),
        0x312D => Some('\u{4F9E}'),
        0x312E => Some('\u{4F9F}'),
        0x312F => Some('\u{4FB2}'),
        0x3130 => Some('\u{4FB7}'),
        0x3131 => Some('\u{4FB9}'),
        0x3132 => Some('\u{4FBB}'),
        0x3133 => Some('\u{4FBC}'),
        0x3134 => Some('\u{4FBD}'),
        0x3135 => Some('\u{4FBE}'),
        0x3136 => Some('\u{4FC0}'),
        0x3137 => Some('\u{4FC1}'),
        0x3138 => Some('\u{4FC5}'),
        0x3139 => Some('\u{4FC6}'),
        0x313A => Some('\u{4FC8}'),
        0x313B => Some('\u{4FC9}'),
        0x313C => Some('\u{4FCB}'),
        0x313D => Some('\u{4FCC}'),
        0x313E => Some('\u{4FCD}'),
        0x313F => Some('\u{4FCF}'),
        0x3140 => Some('\u{4FD2}'),
        0x3141 => Some('\u{4FDC}'),
        0x3142 => Some('\u{4FE0}'),
        0x3143 => Some('\u{4FE2}'),
        0x3144 => Some('\u{4FF0}'),
        0x3145 => Some('\u{4FF2}'),
        0x3146 => Some('\u{4FFC}'),
        0x3147 => Some('\u{4FFD}'),
        0x3148 => Some('\u{4FFF}'),
        0x3149 => Some('\u{5000}'),
        0x314A => Some('\u{5001}'),
        0x314B => Some('\u{5004}'),
        0x314C => Some('\u{5007}'),
        0x314D => Some('\u{500A}'),
        0x314E => Some('\u{500C}'),
        0x314F => Some('\u{500E}'),
        0x3150 => Some('\u{5010}'),
        0x3151 => Some('\u{5013}'),
        0x3152 => Some('\u{5017}'),
        0x3153 => Some('\u{5018}'),
        0x3154 => Some('\u{501B}'),
        0x3155 => Some('\u{501C}'),
        0x3156 => Some('\u{501D}'),
        0x3157 => Some('\u{501E}'),
        0x3158 => Some('\u{5022}'),
        0x3159 => Some('\u{5027}'),
        0x315A => Some('\u{502E}'),
        0x315B => Some('\u{5030}'),
        0x315C => Some('\u{5032}'),
        0x315D => Some('\u{5033}'),
        0x315E => Some('\u{5035}'),
        0x3176 => Some('\u{503B}'),
        0x315F => Some('\u{5040}'),
        0x3160 => Some('\u{5041}'),
        0x3161 => Some('\u{5042}'),
        0x3162 => Some('\u{5045}'),
        0x3163 => Some('\u{5046}'),
        0x3164 => Some('\u{504A}'),
        0x3165 => Some('\u{504C}'),
        0x3166 => Some('\u{504E}'),
        0x3167 => Some('\u{5051}'),
        0x3168 => Some('\u{5052}'),
        0x3169 => Some('\u{5053}'),
        0x316A => Some('\u{5057}'),
        0x316B => Some('\u{5059}'),
        0x316C => Some('\u{505F}'),
        0x316D => Some('\u{5060}'),
        0x316E => Some('\u{5062}'),
        0x316F => Some('\u{5063}'),
        0x3170 => Some('\u{5066}'),
        0x3171 => Some('\u{5067}'),
        0x3172 => Some('\u{506A}'),
        0x3173 => Some('\u{506D}'),
        0x3174 => Some('\u{5070}'),
        0x3175 => Some('\u{5071}'),
        0x3177 => Some('\u{5081}'),
        0x3178 => Some('\u{5083}'),
        0x3179 => Some('\u{5084}'),
        0x317A => Some('\u{5086}'),
        0x317B => Some('\u{508A}'),
        0x317C => Some('\u{508E}'),
        0x317D => Some('\u{508F}'),
        0x317E => Some('\u{5090}'),
        0x3221 => Some('\u{5092}'),
        0x3222 => Some('\u{5093}'),
        0x3223 => Some('\u{5094}'),
        0x3224 => Some('\u{5096}'),
        0x3225 => Some('\u{509B}'),
        0x3226 => Some('\u{509C}'),
        0x3227 => Some('\u{509E}'),
        0x3228 => Some('\u{509F}'),
        0x3229 => Some('\u{50A0}'),
        0x322A => Some('\u{50A1}'),
        0x322B => Some('\u{50A2}'),
        0x322C => Some('\u{50AA}'),
        0x322D => Some('\u{50AF}'),
        0x322E => Some('\u{50B0}'),
        0x322F => Some('\u{50B9}'),
        0x3230 => Some('\u{50BA}'),
        0x3231 => Some('\u{50BD}'),
        0x3232 => Some('\u{50C0}'),
        0x3233 => Some('\u{50C3}'),
        0x3234 => Some('\u{50C4}'),
        0x3235 => Some('\u{50C7}'),
        0x3236 => Some('\u{50CC}'),
        0x3237 => Some('\u{50CE}'),
        0x3238 => Some('\u{50D0}'),
        0x3239 => Some('\u{50D3}'),
        0x323A => Some('\u{50D4}'),
        0x323B => Some('\u{50D8}'),
        0x323C => Some('\u{50DC}'),
        0x323D => Some('\u{50DD}'),
        0x323E => Some('\u{50DF}'),
        0x323F => Some('\u{50E2}'),
        0x3240 => Some('\u{50E4}'),
        0x3241 => Some('\u{50E6}'),
        0x3242 => Some('\u{50E8}'),
        0x3243 => Some('\u{50E9}'),
        0x3244 => Some('\u{50EF}'),
        0x3245 => Some('\u{50F1}'),
        0x3251 => Some('\u{50F2}'),
        0x3246 => Some('\u{50F6}'),
        0x3247 => Some('\u{50FA}'),
        0x3248 => Some('\u{50FE}'),
        0x3249 => Some('\u{5103}'),
        0x324A => Some('\u{5106}'),
        0x324B => Some('\u{5107}'),
        0x324C => Some('\u{5108}'),
        0x324D => Some('\u{510B}'),
        0x324E => Some('\u{510C}'),
        0x324F => Some('\u{510D}'),
        0x3250 => Some('\u{510E}'),
        0x3252 => Some('\u{5110}'),
        0x3253 => Some('\u{5117}'),
        0x3254 => Some('\u{5119}'),
        0x3255 => Some('\u{511B}'),
        0x3256 => Some('\u{511C}'),
        0x3257 => Some('\u{511D}'),
        0x3258 => Some('\u{511E}'),
        0x3259 => Some('\u{5123}'),
        0x325A => Some('\u{5127}'),
        0x325B => Some('\u{5128}'),
        0x325C => Some('\u{512C}'),
        0x325D => Some('\u{512D}'),
        0x325E => Some('\u{512F}'),
        0x325F => Some('\u{5131}'),
        0x3260 => Some('\u{5133}'),
        0x3261 => Some('\u{5134}'),
        0x3262 => Some('\u{5135}'),
        0x3263 => Some('\u{5138}'),
        0x3264 => Some('\u{5139}'),
        0x3265 => Some('\u{5142}'),
        0x3266 => Some('\u{514A}'),
        0x3267 => Some('\u{514F}'),
        0x3268 => Some('\u{5153}'),
        0x3269 => Some('\u{5155}'),
        0x326A => Some('\u{5157}'),
        0x326B => Some('\u{5158}'),
        0x326C => Some('\u{515F}'),
        0x326D => Some('\u{5164}'),
        0x326E => Some('\u{5166}'),
        0x326F => Some('\u{517E}'),
        0x3270 => Some('\u{5183}'),
        0x3271 => Some('\u{5184}'),
        0x3272 => Some('\u{518B}'),
        0x3273 => Some('\u{518E}'),
        0x3274 => Some('\u{5198}'),
        0x3275 => Some('\u{519D}'),
        0x3276 => Some('\u{51A1}'),
        0x3277 => Some('\u{51A3}'),
        0x3278 => Some('\u{51AD}'),
        0x3279 => Some('\u{51B8}'),
        0x327A => Some('\u{51BA}'),
        0x327B => Some('\u{51BC}'),
        0x327C => Some('\u{51BE}'),
        0x327D => Some('\u{51BF}'),
        0x327E => Some('\u{51C2}'),
        0x3321 => Some('\u{51C8}'),
        0x3322 => Some('\u{51CF}'),
        0x3323 => Some('\u{51D1}'),
        0x3324 => Some('\u{51D2}'),
        0x3325 => Some('\u{51D3}'),
        0x3326 => Some('\u{51D5}'),
        0x3327 => Some('\u{51D8}'),
        0x3328 => Some('\u{51DE}'),
        0x3329 => Some('\u{51E2}'),
        0x332A => Some('\u{51E5}'),
        0x332B => Some('\u{51EE}'),
        0x332C => Some('\u{51F2}'),
        0x332D => Some('\u{51F3}'),
        0x332E => Some('\u{51F4}'),
        0x332F => Some('\u{51F7}'),
        0x3330 => Some('\u{5201}'),
        0x3331 => Some('\u{5202}'),
        0x3332 => Some('\u{5205}'),
        0x3333 => Some('\u{5212}'),
        0x3334 => Some('\u{5213}'),
        0x3335 => Some('\u{5215}'),
        0x3336 => Some('\u{5216}'),
        0x3337 => Some('\u{5218}'),
        0x3338 => Some('\u{5222}'),
        0x3339 => Some('\u{5228}'),
        0x333A => Some('\u{5231}'),
        0x333B => Some('\u{5232}'),
        0x333C => Some('\u{5235}'),
        0x333D => Some('\u{523C}'),
        0x333E => Some('\u{5245}'),
        0x333F => Some('\u{5249}'),
        0x3340 => Some('\u{5255}'),
        0x3341 => Some('\u{5257}'),
        0x3342 => Some('\u{5258}'),
        0x3343 => Some('\u{525A}'),
        0x3344 => Some('\u{525C}'),
        0x3345 => Some('\u{525F}'),
        0x3346 => Some('\u{5260}'),
        0x3347 => Some('\u{5261}'),
        0x3348 => Some('\u{5266}'),
        0x3349 => Some('\u{526E}'),
        0x334A => Some('\u{5277}'),
        0x334B => Some('\u{5278}'),
        0x334C => Some('\u{5279}'),
        0x334D => Some('\u{5280}'),
        0x334E => Some('\u{5282}'),
        0x334F => Some('\u{5285}'),
        0x3350 => Some('\u{528A}'),
        0x3351 => Some('\u{528C}'),
        0x3352 => Some('\u{5293}'),
        0x3353 => Some('\u{5295}'),
        0x3354 => Some('\u{5296}'),
        0x3355 => Some('\u{5297}'),
        0x3356 => Some('\u{5298}'),
        0x3357 => Some('\u{529A}'),
        0x3358 => Some('\u{529C}'),
        0x3359 => Some('\u{52A4}'),
        0x335A => Some('\u{52A5}'),
        0x335B => Some('\u{52A6}'),
        0x335C => Some('\u{52A7}'),
        0x335D => Some('\u{52AF}'),
        0x335E => Some('\u{52B0}'),
        0x335F => Some('\u{52B6}'),
        0x3360 => Some('\u{52B7}'),
        0x3361 => Some('\u{52B8}'),
        0x3362 => Some('\u{52BA}'),
        0x3363 => Some('\u{52BB}'),
        0x3364 => Some('\u{52BD}'),
        0x3365 => Some('\u{52C0}'),
        0x3366 => Some('\u{52C4}'),
        0x3367 => Some('\u{52C6}'),
        0x3368 => Some('\u{52C8}'),
        0x3369 => Some('\u{52CC}'),
        0x336A => Some('\u{52CF}'),
        0x336B => Some('\u{52D1}'),
        0x336C => Some('\u{52D4}'),
        0x336D => Some('\u{52D6}'),
        0x336E => Some('\u{52DB}'),
        0x336F => Some('\u{52DC}'),
        0x3370 => Some('\u{52E1}'),
        0x3371 => Some('\u{52E5}'),
        0x3372 => Some('\u{52E8}'),
        0x3373 => Some('\u{52E9}'),
        0x3374 => Some('\u{52EA}'),
        0x3375 => Some('\u{52EC}'),
        0x3376 => Some('\u{52F0}'),
        0x3377 => Some('\u{52F1}'),
        0x3378 => Some('\u{52F4}'),
        0x3379 => Some('\u{52F6}'),
        0x337A => Some('\u{52F7}'),
        0x337B => Some('\u{5300}'),
        0x337C => Some('\u{5303}'),
        0x337D => Some('\u{530A}'),
        0x337E => Some('\u{530B}'),
        0x3421 => Some('\u{530C}'),
        0x3422 => Some('\u{5311}'),
        0x3423 => Some('\u{5313}'),
        0x3424 => Some('\u{5318}'),
        0x3425 => Some('\u{531B}'),
        0x3426 => Some('\u{531C}'),
        0x3427 => Some('\u{531E}'),
        0x3428 => Some('\u{531F}'),
        0x3429 => Some('\u{5325}'),
        0x342A => Some('\u{5327}'),
        0x342B => Some('\u{5328}'),
        0x342C => Some('\u{5329}'),
        0x342D => Some('\u{532B}'),
        0x342E => Some('\u{532C}'),
        0x342F => Some('\u{532D}'),
        0x3430 => Some('\u{5330}'),
        0x3431 => Some('\u{5332}'),
        0x3432 => Some('\u{5335}'),
        0x3433 => Some('\u{533C}'),
        0x3434 => Some('\u{533D}'),
        0x3435 => Some('\u{533E}'),
        0x3436 => Some('\u{5342}'),
        0x3438 => Some('\u{534B}'),
        0x3437 => Some('\u{534C}'),
        0x3439 => Some('\u{5359}'),
        0x343A => Some('\u{535B}'),
        0x343B => Some('\u{5361}'),
        0x343C => Some('\u{5363}'),
        0x343D => Some('\u{5365}'),
        0x343E => Some('\u{536C}'),
        0x343F => Some('\u{536D}'),
        0x3440 => Some('\u{5372}'),
        0x3441 => Some('\u{5379}'),
        0x3442 => Some('\u{537E}'),
        0x3443 => Some('\u{5383}'),
        0x3444 => Some('\u{5387}'),
        0x3445 => Some('\u{5388}'),
        0x3446 => Some('\u{538E}'),
        0x3447 => Some('\u{5393}'),
        0x3448 => Some('\u{5394}'),
        0x3449 => Some('\u{5399}'),
        0x344A => Some('\u{539D}'),
        0x344B => Some('\u{53A1}'),
        0x344C => Some('\u{53A4}'),
        0x344D => Some('\u{53AA}'),
        0x344E => Some('\u{53AB}'),
        0x344F => Some('\u{53AF}'),
        0x3450 => Some('\u{53B2}'),
        0x3451 => Some('\u{53B4}'),
        0x3452 => Some('\u{53B5}'),
        0x3453 => Some('\u{53B7}'),
        0x3454 => Some('\u{53B8}'),
        0x3455 => Some('\u{53BA}'),
        0x3456 => Some('\u{53BD}'),
        0x3457 => Some('\u{53C0}'),
        0x3458 => Some('\u{53C5}'),
        0x3459 => Some('\u{53CF}'),
        0x345A => Some('\u{53D2}'),
        0x345B => Some('\u{53D3}'),
        0x345C => Some('\u{53D5}'),
        0x345D => Some('\u{53DA}'),
        0x345E => Some('\u{53DD}'),
        0x345F => Some('\u{53DE}'),
        0x3460 => Some('\u{53E0}'),
        0x3461 => Some('\u{53E6}'),
        0x3462 => Some('\u{53E7}'),
        0x3463 => Some('\u{53F5}'),
        0x3464 => Some('\u{5402}'),
        0x3465 => Some('\u{5413}'),
        0x3466 => Some('\u{541A}'),
        0x3467 => Some('\u{5421}'),
        0x3468 => Some('\u{5427}'),
        0x3469 => Some('\u{5428}'),
        0x346A => Some('\u{542A}'),
        0x346B => Some('\u{542F}'),
        0x346C => Some('\u{5431}'),
        0x346D => Some('\u{5434}'),
        0x346E => Some('\u{5435}'),
        0x346F => Some('\u{5443}'),
        0x3470 => Some('\u{5444}'),
        0x3471 => Some('\u{5447}'),
        0x3472 => Some('\u{544D}'),
        0x3473 => Some('\u{544F}'),
        0x3474 => Some('\u{545E}'),
        0x3475 => Some('\u{5462}'),
        0x3476 => Some('\u{5464}'),
        0x3477 => Some('\u{5466}'),
        0x3478 => Some('\u{5467}'),
        0x3479 => Some('\u{5469}'),
        0x347A => Some('\u{546B}'),
        0x347B => Some('\u{546D}'),
        0x347C => Some('\u{546E}'),
        0x347D => Some('\u{5474}'),
        0x347E => Some('\u{547F}'),
        0x3521 => Some('\u{5481}'),
        0x3522 => Some('\u{5483}'),
        0x3523 => Some('\u{5485}'),
        0x3524 => Some('\u{5488}'),
        0x3525 => Some('\u{5489}'),
        0x3526 => Some('\u{548D}'),
        0x3527 => Some('\u{5491}'),
        0x3528 => Some('\u{5495}'),
        0x3529 => Some('\u{5496}'),
        0x352A => Some('\u{549C}'),
        0x352B => Some('\u{549F}'),
        0x352C => Some('\u{54A1}'),
        0x352D => Some('\u{54A6}'),
        0x352E => Some('\u{54A7}'),
        0x352F => Some('\u{54A9}'),
        0x3530 => Some('\u{54AA}'),
        0x3531 => Some('\u{54AD}'),
        0x3532 => Some('\u{54AE}'),
        0x3533 => Some('\u{54B1}'),
        0x3534 => Some('\u{54B7}'),
        0x3535 => Some('\u{54B9}'),
        0x3536 => Some('\u{54BA}'),
        0x3537 => Some('\u{54BB}'),
        0x3538 => Some('\u{54BF}'),
        0x3539 => Some('\u{54C6}'),
        0x353A => Some('\u{54CA}'),
        0x353B => Some('\u{54CD}'),
        0x353C => Some('\u{54CE}'),
        0x353D => Some('\u{54E0}'),
        0x353E => Some('\u{54EA}'),
        0x353F => Some('\u{54EC}'),
        0x3540 => Some('\u{54EF}'),
        0x3541 => Some('\u{54F6}'),
        0x3542 => Some('\u{54FC}'),
        0x3543 => Some('\u{54FE}'),
        0x3544 => Some('\u{54FF}'),
        0x3545 => Some('\u{5500}'),
        0x3546 => Some('\u{5501}'),
        0x3547 => Some('\u{5505}'),
        0x3548 => Some('\u{5508}'),
        0x3549 => Some('\u{5509}'),
        0x354A => Some('\u{550C}'),
        0x354B => Some('\u{550D}'),
        0x354C => Some('\u{550E}'),
        0x354D => Some('\u{5515}'),
        0x354E => Some('\u{552A}'),
        0x354F => Some('\u{552B}'),
        0x3550 => Some('\u{5532}'),
        0x3551 => Some('\u{5535}'),
        0x3552 => Some('\u{5536}'),
        0x3553 => Some('\u{553B}'),
        0x3554 => Some('\u{553C}'),
        0x3555 => Some('\u{553D}'),
        0x3556 => Some('\u{5541}'),
        0x3557 => Some('\u{5547}'),
        0x3558 => Some('\u{5549}'),
        0x3559 => Some('\u{554A}'),
        0x355A => Some('\u{554D}'),
        0x355B => Some('\u{5550}'),
        0x355C => Some('\u{5551}'),
        0x355D => Some('\u{5558}'),
        0x355E => Some('\u{555A}'),
        0x355F => Some('\u{555B}'),
        0x3560 => Some('\u{555E}'),
        0x3561 => Some('\u{5560}'),
        0x3562 => Some('\u{5561}'),
        0x3563 => Some('\u{5564}'),
        0x3564 => Some('\u{5566}'),
        0x3565 => Some('\u{557F}'),
        0x3566 => Some('\u{5581}'),
        0x3567 => Some('\u{5582}'),
        0x3568 => Some('\u{5586}'),
        0x3569 => Some('\u{5588}'),
        0x356A => Some('\u{558E}'),
        0x356B => Some('\u{558F}'),
        0x356C => Some('\u{5591}'),
        0x356D => Some('\u{5592}'),
        0x356E => Some('\u{5593}'),
        0x356F => Some('\u{5594}'),
        0x3570 => Some('\u{5597}'),
        0x3571 => Some('\u{55A3}'),
        0x3572 => Some('\u{55A4}'),
        0x3573 => Some('\u{55AD}'),
        0x3574 => Some('\u{55B2}'),
        0x3575 => Some('\u{55BF}'),
        0x3576 => Some('\u{55C1}'),
        0x3577 => Some('\u{55C3}'),
        0x3578 => Some('\u{55C6}'),
        0x3579 => Some('\u{55C9}'),
        0x357A => Some('\u{55CB}'),
        0x357B => Some('\u{55CC}'),
        0x357C => Some('\u{55CE}'),
        0x357D => Some('\u{55D1}'),
        0x357E => Some('\u{55D2}'),
        0x3621 => Some('\u{55D3}'),
        0x3622 => Some('\u{55D7}'),
        0x3623 => Some('\u{55D8}'),
        0x3624 => Some('\u{55DB}'),
        0x3625 => Some('\u{55DE}'),
        0x3626 => Some('\u{55E2}'),
        0x3627 => Some('\u{55E9}'),
        0x3628 => Some('\u{55F6}'),
        0x3629 => Some('\u{55FF}'),
        0x362A => Some('\u{5605}'),
        0x362B => Some('\u{5608}'),
        0x362C => Some('\u{560A}'),
        0x362D => Some('\u{560D}'),
        0x362E => Some('\u{560E}'),
        0x362F => Some('\u{560F}'),
        0x3630 => Some('\u{5610}'),
        0x3631 => Some('\u{5611}'),
        0x3632 => Some('\u{5612}'),
        0x3633 => Some('\u{5619}'),
        0x3634 => Some('\u{562C}'),
        0x3635 => Some('\u{5630}'),
        0x3636 => Some('\u{5633}'),
        0x3637 => Some('\u{5635}'),
        0x3638 => Some('\u{5637}'),
        0x3639 => Some('\u{5639}'),
        0x363A => Some('\u{563B}'),
        0x363B => Some('\u{563C}'),
        0x363C => Some('\u{563D}'),
        0x363D => Some('\u{563F}'),
        0x363E => Some('\u{5640}'),
        0x363F => Some('\u{5641}'),
        0x3640 => Some('\u{5643}'),
        0x3641 => Some('\u{5644}'),
        0x3642 => Some('\u{5646}'),
        0x3643 => Some('\u{5649}'),
        0x3644 => Some('\u{564B}'),
        0x3645 => Some('\u{564D}'),
        0x3646 => Some('\u{564F}'),
        0x3647 => Some('\u{5654}'),
        0x3648 => Some('\u{565E}'),
        0x3649 => Some('\u{5660}'),
        0x364A => Some('\u{5661}'),
        0x364B => Some('\u{5662}'),
        0x364C => Some('\u{5663}'),
        0x364D => Some('\u{5666}'),
        0x364E => Some('\u{5669}'),
        0x364F => Some('\u{566D}'),
        0x3650 => Some('\u{566F}'),
        0x3651 => Some('\u{5671}'),
        0x3652 => Some('\u{5672}'),
        0x3653 => Some('\u{5675}'),
        0x3654 => Some('\u{5684}'),
        0x3655 => Some('\u{5685}'),
        0x3656 => Some('\u{5688}'),
        0x3657 => Some('\u{568B}'),
        0x3658 => Some('\u{568C}'),
        0x3659 => Some('\u{5695}'),
        0x365A => Some('\u{5699}'),
        0x365B => Some('\u{569A}'),
        0x365C => Some('\u{569D}'),
        0x365D => Some('\u{569E}'),
        0x365E => Some('\u{569F}'),
        0x365F => Some('\u{56A6}'),
        0x3660 => Some('\u{56A7}'),
        0x3661 => Some('\u{56A8}'),
        0x3662 => Some('\u{56A9}'),
        0x3663 => Some('\u{56AB}'),
        0x3664 => Some('\u{56AC}'),
        0x3665 => Some('\u{56AD}'),
        0x3666 => Some('\u{56B1}'),
        0x3667 => Some('\u{56B3}'),
        0x3668 => Some('\u{56B7}'),
        0x3669 => Some('\u{56BE}'),
        0x366A => Some('\u{56C5}'),
        0x366B => Some('\u{56C9}'),
        0x366C => Some('\u{56CA}'),
        0x366D => Some('\u{56CB}'),
        0x3670 => Some('\u{56CC}'),
        0x3671 => Some('\u{56CD}'),
        0x366E => Some('\u{56CF}'),
        0x366F => Some('\u{56D0}'),
        0x3672 => Some('\u{56D9}'),
        0x3673 => Some('\u{56DC}'),
        0x3674 => Some('\u{56DD}'),
        0x3675 => Some('\u{56DF}'),
        0x3676 => Some('\u{56E1}'),
        0x3677 => Some('\u{56E4}'),
        0x3678 => Some('\u{56E5}'),
        0x3679 => Some('\u{56E6}'),
        0x367A => Some('\u{56E7}'),
        0x367B => Some('\u{56E8}'),
        0x367D => Some('\u{56EB}'),
        0x367E => Some('\u{56ED}'),
        0x367C => Some('\u{56F1}'),
        0x3721 => Some('\u{56F6}'),
        0x3722 => Some('\u{56F7}'),
        0x3723 => Some('\u{5701}'),
        0x3724 => Some('\u{5702}'),
        0x3725 => Some('\u{5707}'),
        0x3726 => Some('\u{570A}'),
        0x3727 => Some('\u{570C}'),
        0x3728 => Some('\u{5711}'),
        0x3729 => Some('\u{5715}'),
        0x372A => Some('\u{571A}'),
        0x372B => Some('\u{571B}'),
        0x372C => Some('\u{571D}'),
        0x372D => Some('\u{5720}'),
        0x372E => Some('\u{5722}'),
        0x372F => Some('\u{5723}'),
        0x3730 => Some('\u{5724}'),
        0x3731 => Some('\u{5725}'),
        0x3732 => Some('\u{5729}'),
        0x3733 => Some('\u{572A}'),
        0x3734 => Some('\u{572C}'),
        0x3735 => Some('\u{572E}'),
        0x3736 => Some('\u{572F}'),
        0x3737 => Some('\u{5733}'),
        0x3738 => Some('\u{5734}'),
        0x3739 => Some('\u{573D}'),
        0x373A => Some('\u{573E}'),
        0x373B => Some('\u{573F}'),
        0x373C => Some('\u{5745}'),
        0x373D => Some('\u{5746}'),
        0x373E => Some('\u{574C}'),
        0x373F => Some('\u{574D}'),
        0x3740 => Some('\u{5752}'),
        0x3741 => Some('\u{5762}'),
        0x3742 => Some('\u{5765}'),
        0x3743 => Some('\u{5767}'),
        0x3744 => Some('\u{5768}'),
        0x3745 => Some('\u{576B}'),
        0x3746 => Some('\u{576D}'),
        0x3747 => Some('\u{576E}'),
        0x3748 => Some('\u{576F}'),
        0x3749 => Some('\u{5770}'),
        0x374A => Some('\u{5771}'),
        0x374B => Some('\u{5773}'),
        0x374C => Some('\u{5774}'),
        0x374D => Some('\u{5775}'),
        0x374E => Some('\u{5777}'),
        0x374F => Some('\u{5779}'),
        0x3750 => Some('\u{577A}'),
        0x3751 => Some('\u{577B}'),
        0x3752 => Some('\u{577C}'),
        0x3753 => Some('\u{577E}'),
        0x3754 => Some('\u{5781}'),
        0x3755 => Some('\u{5783}'),
        0x3756 => Some('\u{578C}'),
        0x3757 => Some('\u{5794}'),
        0x3760 => Some('\u{5795}'),
        0x3758 => Some('\u{5797}'),
        0x3759 => Some('\u{5799}'),
        0x375A => Some('\u{579A}'),
        0x375B => Some('\u{579C}'),
        0x375C => Some('\u{579D}'),
        0x375D => Some('\u{579E}'),
        0x375E => Some('\u{579F}'),
        0x375F => Some('\u{57A1}'),
        0x3761 => Some('\u{57A7}'),
        0x3762 => Some('\u{57A8}'),
        0x3763 => Some('\u{57A9}'),
        0x3764 => Some('\u{57AC}'),
        0x3765 => Some('\u{57B8}'),
        0x3766 => Some('\u{57BD}'),
        0x3767 => Some('\u{57C7}'),
        0x3768 => Some('\u{57C8}'),
        0x3769 => Some('\u{57CC}'),
        0x376A => Some('\u{57CF}'),
        0x376B => Some('\u{57D5}'),
        0x376C => Some('\u{57DD}'),
        0x376D => Some('\u{57DE}'),
        0x377E => Some('\u{57E1}'),
        0x376E => Some('\u{57E4}'),
        0x376F => Some('\u{57E6}'),
        0x3770 => Some('\u{57E7}'),
        0x3771 => Some('\u{57E9}'),
        0x3772 => Some('\u{57ED}'),
        0x3773 => Some('\u{57F0}'),
        0x3774 => Some('\u{57F5}'),
        0x3775 => Some('\u{57F6}'),
        0x3776 => Some('\u{57F8}'),
        0x3777 => Some('\u{57FD}'),
        0x3778 => Some('\u{57FE}'),
        0x3779 => Some('\u{57FF}'),
        0x377A => Some('\u{5803}'),
        0x377B => Some('\u{5804}'),
        0x377C => Some('\u{5808}'),
        0x377D => Some('\u{5809}'),
        0x3821 => Some('\u{580C}'),
        0x3822 => Some('\u{580D}'),
        0x3823 => Some('\u{581B}'),
        0x3824 => Some('\u{581E}'),
        0x3825 => Some('\u{581F}'),
        0x3826 => Some('\u{5820}'),
        0x3827 => Some('\u{5826}'),
        0x3828 => Some('\u{5827}'),
        0x3829 => Some('\u{582D}'),
        0x382A => Some('\u{5832}'),
        0x382B => Some('\u{5839}'),
        0x382C => Some('\u{583F}'),
        0x382D => Some('\u{5849}'),
        0x382E => Some('\u{584C}'),
        0x382F => Some('\u{584D}'),
        0x3830 => Some('\u{584F}'),
        0x3831 => Some('\u{5850}'),
        0x3832 => Some('\u{5855}'),
        0x3833 => Some('\u{585F}'),
        0x3834 => Some('\u{5861}'),
        0x3835 => Some('\u{5864}'),
        0x3836 => Some('\u{5867}'),
        0x3837 => Some('\u{5868}'),
        0x3838 => Some('\u{5878}'),
        0x3839 => Some('\u{587C}'),
        0x383A => Some('\u{587F}'),
        0x383B => Some('\u{5880}'),
        0x383C => Some('\u{5881}'),
        0x383D => Some('\u{5887}'),
        0x383E => Some('\u{5888}'),
        0x383F => Some('\u{5889}'),
        0x3840 => Some('\u{588A}'),
        0x3841 => Some('\u{588C}'),
        0x3842 => Some('\u{588D}'),
        0x3843 => Some('\u{588F}'),
        0x3844 => Some('\u{5890}'),
        0x3845 => Some('\u{5894}'),
        0x3846 => Some('\u{5896}'),
        0x3847 => Some('\u{589D}'),
        0x3848 => Some('\u{58A0}'),
        0x3849 => Some('\u{58A1}'),
        0x384A => Some('\u{58A2}'),
        0x384B => Some('\u{58A6}'),
        0x384C => Some('\u{58A9}'),
        0x384D => Some('\u{58B1}'),
        0x384E => Some('\u{58B2}'),
        0x3850 => Some('\u{58BC}'),
        0x3851 => Some('\u{58C2}'),
        0x384F => Some('\u{58C4}'),
        0x3852 => Some('\u{58C8}'),
        0x3853 => Some('\u{58CD}'),
        0x3854 => Some('\u{58CE}'),
        0x3855 => Some('\u{58D0}'),
        0x3856 => Some('\u{58D2}'),
        0x3857 => Some('\u{58D4}'),
        0x3858 => Some('\u{58D6}'),
        0x3859 => Some('\u{58DA}'),
        0x385A => Some('\u{58DD}'),
        0x385B => Some('\u{58E1}'),
        0x385C => Some('\u{58E2}'),
        0x385D => Some('\u{58E9}'),
        0x385E => Some('\u{58F3}'),
        0x385F => Some('\u{5905}'),
        0x3860 => Some('\u{5906}'),
        0x3861 => Some('\u{590B}'),
        0x3862 => Some('\u{590C}'),
        0x3863 => Some('\u{5912}'),
        0x3864 => Some('\u{5913}'),
        0x3865 => Some('\u{5914}'),
        0x3867 => Some('\u{591D}'),
        0x3868 => Some('\u{5921}'),
        0x3869 => Some('\u{5923}'),
        0x386A => Some('\u{5924}'),
        0x386B => Some('\u{5928}'),
        0x386C => Some('\u{592F}'),
        0x386D => Some('\u{5930}'),
        0x386E => Some('\u{5933}'),
        0x386F => Some('\u{5935}'),
        0x3870 => Some('\u{5936}'),
        0x3871 => Some('\u{593F}'),
        0x3872 => Some('\u{5943}'),
        0x3873 => Some('\u{5946}'),
        0x3874 => Some('\u{5952}'),
        0x3875 => Some('\u{5953}'),
        0x3876 => Some('\u{5959}'),
        0x3877 => Some('\u{595B}'),
        0x3878 => Some('\u{595D}'),
        0x3879 => Some('\u{595E}'),
        0x387A => Some('\u{595F}'),
        0x387B => Some('\u{5961}'),
        0x387C => Some('\u{5963}'),
        0x387D => Some('\u{596B}'),
        0x387E => Some('\u{596D}'),
        0x3921 => Some('\u{596F}'),
        0x3922 => Some('\u{5972}'),
        0x3923 => Some('\u{5975}'),
        0x3924 => Some('\u{5976}'),
        0x3925 => Some('\u{5979}'),
        0x3926 => Some('\u{597B}'),
        0x3927 => Some('\u{597C}'),
        0x3928 => Some('\u{598B}'),
        0x3929 => Some('\u{598C}'),
        0x392A => Some('\u{598E}'),
        0x392B => Some('\u{5992}'),
        0x392C => Some('\u{5995}'),
        0x392D => Some('\u{5997}'),
        0x392E => Some('\u{599F}'),
        0x392F => Some('\u{59A4}'),
        0x3930 => Some('\u{59A7}'),
        0x3931 => Some('\u{59AD}'),
        0x3932 => Some('\u{59AE}'),
        0x3933 => Some('\u{59AF}'),
        0x3934 => Some('\u{59B0}'),
        0x3935 => Some('\u{59B3}'),
        0x3936 => Some('\u{59B7}'),
        0x3937 => Some('\u{59BA}'),
        0x3938 => Some('\u{59BC}'),
        0x3939 => Some('\u{59C1}'),
        0x393A => Some('\u{59C3}'),
        0x393B => Some('\u{59C4}'),
        0x393C => Some('\u{59C8}'),
        0x393D => Some('\u{59CA}'),
        0x393E => Some('\u{59CD}'),
        0x393F => Some('\u{59D2}'),
        0x3940 => Some('\u{59DD}'),
        0x3941 => Some('\u{59DE}'),
        0x3942 => Some('\u{59DF}'),
        0x3943 => Some('\u{59E3}'),
        0x3944 => Some('\u{59E4}'),
        0x3945 => Some('\u{59E7}'),
        0x3946 => Some('\u{59EE}'),
        0x3947 => Some('\u{59EF}'),
        0x3948 => Some('\u{59F1}'),
        0x3949 => Some('\u{59F2}'),
        0x394A => Some('\u{59F4}'),
        0x394B => Some('\u{59F7}'),
        0x394C => Some('\u{5A00}'),
        0x394D => Some('\u{5A04}'),
        0x394E => Some('\u{5A0C}'),
        0x394F => Some('\u{5A0D}'),
        0x3950 => Some('\u{5A0E}'),
        0x3951 => Some('\u{5A12}'),
        0x3952 => Some('\u{5A13}'),
        0x3953 => Some('\u{5A1E}'),
        0x3954 => Some('\u{5A23}'),
        0x3955 => Some('\u{5A24}'),
        0x3956 => Some('\u{5A27}'),
        0x3957 => Some('\u{5A28}'),
        0x3958 => Some('\u{5A2A}'),
        0x3959 => Some('\u{5A2D}'),
        0x395A => Some('\u{5A30}'),
        0x395B => Some('\u{5A44}'),
        0x395C => Some('\u{5A45}'),
        0x395D => Some('\u{5A47}'),
        0x395E => Some('\u{5A48}'),
        0x395F => Some('\u{5A4C}'),
        0x3960 => Some('\u{5A50}'),
        0x3961 => Some('\u{5A55}'),
        0x3962 => Some('\u{5A5E}'),
        0x3963 => Some('\u{5A63}'),
        0x3964 => Some('\u{5A65}'),
        0x3965 => Some('\u{5A67}'),
        0x3966 => Some('\u{5A6D}'),
        0x3967 => Some('\u{5A77}'),
        0x3968 => Some('\u{5A7A}'),
        0x3969 => Some('\u{5A7B}'),
        0x396A => Some('\u{5A7E}'),
        0x396B => Some('\u{5A8B}'),
        0x396C => Some('\u{5A90}'),
        0x396D => Some('\u{5A93}'),
        0x396E => Some('\u{5A96}'),
        0x396F => Some('\u{5A99}'),
        0x3970 => Some('\u{5A9C}'),
        0x3971 => Some('\u{5A9E}'),
        0x3972 => Some('\u{5A9F}'),
        0x3973 => Some('\u{5AA0}'),
        0x3974 => Some('\u{5AA2}'),
        0x3975 => Some('\u{5AA7}'),
        0x3976 => Some('\u{5AAC}'),
        0x3977 => Some('\u{5AB1}'),
        0x3978 => Some('\u{5AB2}'),
        0x3979 => Some('\u{5AB3}'),
        0x397A => Some('\u{5AB5}'),
        0x397B => Some('\u{5AB8}'),
        0x397C => Some('\u{5ABA}'),
        0x397D => Some('\u{5ABB}'),
        0x397E => Some('\u{5ABF}'),
        0x3A21 => Some('\u{5AC4}'),
        0x3A22 => Some('\u{5AC6}'),
        0x3A23 => Some('\u{5AC8}'),
        0x3A24 => Some('\u{5ACF}'),
        0x3A25 => Some('\u{5ADA}'),
        0x3A26 => Some('\u{5ADC}'),
        0x3A27 => Some('\u{5AE0}'),
        0x3A28 => Some('\u{5AE5}'),
        0x3A29 => Some('\u{5AEA}'),
        0x3A2A => Some('\u{5AEE}'),
        0x3A2B => Some('\u{5AF5}'),
        0x3A2C => Some('\u{5AF6}'),
        0x3A2D => Some('\u{5AFD}'),
        0x3A2E => Some('\u{5B00}'),
        0x3A2F => Some('\u{5B01}'),
        0x3A30 => Some('\u{5B08}'),
        0x3A31 => Some('\u{5B17}'),
        0x3A33 => Some('\u{5B19}'),
        0x3A34 => Some('\u{5B1B}'),
        0x3A35 => Some('\u{5B1D}'),
        0x3A36 => Some('\u{5B21}'),
        0x3A37 => Some('\u{5B25}'),
        0x3A38 => Some('\u{5B2D}'),
        0x3A32 => Some('\u{5B34}'),
        0x3A39 => Some('\u{5B38}'),
        0x3A3A => Some('\u{5B41}'),
        0x3A3B => Some('\u{5B4B}'),
        0x3A3C => Some('\u{5B4C}'),
        0x3A3D => Some('\u{5B52}'),
        0x3A3E => Some('\u{5B56}'),
        0x3A3F => Some('\u{5B5E}'),
        0x3A40 => Some('\u{5B68}'),
        0x3A41 => Some('\u{5B6E}'),
        0x3A42 => Some('\u{5B6F}'),
        0x3A43 => Some('\u{5B7C}'),
        0x3A44 => Some('\u{5B7D}'),
        0x3A45 => Some('\u{5B7E}'),
        0x3A46 => Some('\u{5B7F}'),
        0x3A47 => Some('\u{5B81}'),
        0x3A48 => Some('\u{5B84}'),
        0x3A49 => Some('\u{5B86}'),
        0x3A4A => Some('\u{5B8A}'),
        0x3A4B => Some('\u{5B8E}'),
        0x3A4C => Some('\u{5B90}'),
        0x3A4D => Some('\u{5B91}'),
        0x3A4E => Some('\u{5B93}'),
        0x3A4F => Some('\u{5B94}'),
        0x3A50 => Some('\u{5B96}'),
        0x3A51 => Some('\u{5BA8}'),
        0x3A52 => Some('\u{5BA9}'),
        0x3A53 => Some('\u{5BAC}'),
        0x3A54 => Some('\u{5BAD}'),
        0x3A55 => Some('\u{5BAF}'),
        0x3A56 => Some('\u{5BB1}'),
        0x3A57 => Some('\u{5BB2}'),
        0x3A58 => Some('\u{5BB7}'),
        0x3A59 => Some('\u{5BBA}'),
        0x3A5A => Some('\u{5BBC}'),
        0x3A5B => Some('\u{5BC0}'),
        0x3A5C => Some('\u{5BC1}'),
        0x3A5D => Some('\u{5BCD}'),
        0x3A5E => Some('\u{5BCF}'),
        0x3A5F => Some('\u{5BD6}'),
        0x3A60 => Some('\u{5BD7}'),
        0x3A61 => Some('\u{5BD8}'),
        0x3A62 => Some('\u{5BD9}'),
        0x3A63 => Some('\u{5BDA}'),
        0x3A64 => Some('\u{5BE0}'),
        0x3A65 => Some('\u{5BEF}'),
        0x3A66 => Some('\u{5BF1}'),
        0x3A67 => Some('\u{5BF4}'),
        0x3A68 => Some('\u{5BFD}'),
        0x3A69 => Some('\u{5C0C}'),
        0x3A6A => Some('\u{5C17}'),
        0x3A6B => Some('\u{5C1E}'),
        0x3A6C => Some('\u{5C1F}'),
        0x3A6D => Some('\u{5C23}'),
        0x3A6E => Some('\u{5C26}'),
        0x3A6F => Some('\u{5C29}'),
        0x3A70 => Some('\u{5C2B}'),
        0x3A71 => Some('\u{5C2C}'),
        0x3A72 => Some('\u{5C2E}'),
        0x3A73 => Some('\u{5C30}'),
        0x3A74 => Some('\u{5C32}'),
        0x3A75 => Some('\u{5C35}'),
        0x3A76 => Some('\u{5C36}'),
        0x3A77 => Some('\u{5C59}'),
        0x3A78 => Some('\u{5C5A}'),
        0x3A79 => Some('\u{5C5C}'),
        0x3A7A => Some('\u{5C62}'),
        0x3A7B => Some('\u{5C63}'),
        0x3A7C => Some('\u{5C67}'),
        0x3A7D => Some('\u{5C68}'),
        0x3A7E => Some('\u{5C69}'),
        0x3B21 => Some('\u{5C6D}'),
        0x3B22 => Some('\u{5C70}'),
        0x3B23 => Some('\u{5C74}'),
        0x3B24 => Some('\u{5C75}'),
        0x3B25 => Some('\u{5C7A}'),
        0x3B26 => Some('\u{5C7B}'),
        0x3B27 => Some('\u{5C7C}'),
        0x3B28 => Some('\u{5C7D}'),
        0x3B29 => Some('\u{5C87}'),
        0x3B2A => Some('\u{5C88}'),
        0x3B2B => Some('\u{5C8A}'),
        0x3B2C => Some('\u{5C8F}'),
        0x3B2D => Some('\u{5C92}'),
        0x3B2E => Some('\u{5C9D}'),
        0x3B2F => Some('\u{5C9F}'),
        0x3B30 => Some('\u{5CA0}'),
        0x3B31 => Some('\u{5CA2}'),
        0x3B32 => Some('\u{5CA3}'),
        0x3B33 => Some('\u{5CA6}'),
        0x3B34 => Some('\u{5CAA}'),
        0x3B35 => Some('\u{5CB2}'),
        0x3B36 => Some('\u{5CB4}'),
        0x3B37 => Some('\u{5CB5}'),
        0x3B38 => Some('\u{5CBA}'),
        0x3B39 => Some('\u{5CC9}'),
        0x3B3A => Some('\u{5CCB}'),
        0x3B3B => Some('\u{5CD2}'),
        0x3B3D => Some('\u{5CD7}'),
        0x3B3C => Some('\u{5CDD}'),
        0x3B3E => Some('\u{5CEE}'),
        0x3B3F => Some('\u{5CF1}'),
        0x3B40 => Some('\u{5CF2}'),
        0x3B41 => Some('\u{5CF4}'),
        0x3B42 => Some('\u{5D01}'),
        0x3B43 => Some('\u{5D06}'),
        0x3B44 => Some('\u{5D0D}'),
        0x3B45 => Some('\u{5D12}'),
        0x3B47 => Some('\u{5D23}'),
        0x3B48 => Some('\u{5D24}'),
        0x3B49 => Some('\u{5D26}'),
        0x3B4A => Some('\u{5D27}'),
        0x3B46 => Some('\u{5D2B}'),
        0x3B4B => Some('\u{5D31}'),
        0x3B4C => Some('\u{5D34}'),
        0x3B4D => Some('\u{5D39}'),
        0x3B4E => Some('\u{5D3D}'),
        0x3B4F => Some('\u{5D3F}'),
        0x3B50 => Some('\u{5D42}'),
        0x3B51 => Some('\u{5D43}'),
        0x3B52 => Some('\u{5D46}'),
        0x3B53 => Some('\u{5D48}'),
        0x3B57 => Some('\u{5D4A}'),
        0x3B55 => Some('\u{5D51}'),
        0x3B54 => Some('\u{5D55}'),
        0x3B56 => Some('\u{5D59}'),
        0x3B58 => Some('\u{5D5F}'),
        0x3B59 => Some('\u{5D60}'),
        0x3B5A => Some('\u{5D61}'),
        0x3B5B => Some('\u{5D62}'),
        0x3B5C => Some('\u{5D64}'),
        0x3B5D => Some('\u{5D6A}'),
        0x3B5E => Some('\u{5D6D}'),
        0x3B5F => Some('\u{5D70}'),
        0x3B60 => Some('\u{5D79}'),
        0x3B61 => Some('\u{5D7A}'),
        0x3B62 => Some('\u{5D7E}'),
        0x3B63 => Some('\u{5D7F}'),
        0x3B64 => Some('\u{5D81}'),
        0x3B65 => Some('\u{5D83}'),
        0x3B66 => Some('\u{5D88}'),
        0x3B67 => Some('\u{5D8A}'),
        0x3B68 => Some('\u{5D92}'),
        0x3B69 => Some('\u{5D93}'),
        0x3B6A => Some('\u{5D94}'),
        0x3B6B => Some('\u{5D95}'),
        0x3B6C => Some('\u{5D99}'),
        0x3B6D => Some('\u{5D9B}'),
        0x3B6E => Some('\u{5D9F}'),
        0x3B6F => Some('\u{5DA0}'),
        0x3B70 => Some('\u{5DA7}'),
        0x3B71 => Some('\u{5DAB}'),
        0x3B72 => Some('\u{5DB0}'),
        0x6674 => Some('\u{5DB2}'),
        0x3B73 => Some('\u{5DB4}'),
        0x3B74 => Some('\u{5DB8}'),
        0x3B75 => Some('\u{5DB9}'),
        0x3B76 => Some('\u{5DC3}'),
        0x3B77 => Some('\u{5DC7}'),
        0x3B78 => Some('\u{5DCB}'),
        0x3B7A => Some('\u{5DCE}'),
        0x3B79 => Some('\u{5DD0}'),
        0x3B7B => Some('\u{5DD8}'),
        0x3B7C => Some('\u{5DD9}'),
        0x3B7D => Some('\u{5DE0}'),
        0x3B7E => Some('\u{5DE4}'),
        0x3C21 => Some('\u{5DE9}'),
        0x3C22 => Some('\u{5DF8}'),
        0x3C23 => Some('\u{5DF9}'),
        0x3C24 => Some('\u{5E00}'),
        0x3C25 => Some('\u{5E07}'),
        0x3C26 => Some('\u{5E0D}'),
        0x3C27 => Some('\u{5E12}'),
        0x3C28 => Some('\u{5E14}'),
        0x3C29 => Some('\u{5E15}'),
        0x3C2A => Some('\u{5E18}'),
        0x3C2B => Some('\u{5E1F}'),
        0x3C2C => Some('\u{5E20}'),
        0x3C2E => Some('\u{5E28}'),
        0x3C2D => Some('\u{5E2E}'),
        0x3C2F => Some('\u{5E32}'),
        0x3C30 => Some('\u{5E35}'),
        0x3C31 => Some('\u{5E3E}'),
        0x3C34 => Some('\u{5E49}'),
        0x3C32 => Some('\u{5E4B}'),
        0x3C33 => Some('\u{5E50}'),
        0x3C35 => Some('\u{5E51}'),
        0x3C36 => Some('\u{5E56}'),
        0x3C37 => Some('\u{5E58}'),
        0x3C38 => Some('\u{5E5B}'),
        0x3C39 => Some('\u{5E5C}'),
        0x3C3A => Some('\u{5E5E}'),
        0x3C3B => Some('\u{5E68}'),
        0x3C3C => Some('\u{5E6A}'),
        0x3C3D => Some('\u{5E6B}'),
        0x3C3E => Some('\u{5E6C}'),
        0x3C3F => Some('\u{5E6D}'),
        0x3C40 => Some('\u{5E6E}'),
        0x3C41 => Some('\u{5E70}'),
        0x3C42 => Some('\u{5E80}'),
        0x3C43 => Some('\u{5E8B}'),
        0x3C44 => Some('\u{5E8E}'),
        0x3C45 => Some('\u{5EA2}'),
        0x3C46 => Some('\u{5EA4}'),
        0x3C47 => Some('\u{5EA5}'),
        0x3C48 => Some('\u{5EA8}'),
        0x3C49 => Some('\u{5EAA}'),
        0x3C4A => Some('\u{5EAC}'),
        0x3C4B => Some('\u{5EB1}'),
        0x3C4C => Some('\u{5EB3}'),
        0x3C4D => Some('\u{5EBD}'),
        0x3C4E => Some('\u{5EBE}'),
        0x3C4F => Some('\u{5EBF}'),
        0x3C50 => Some('\u{5EC6}'),
        0x3C52 => Some('\u{5ECB}'),
        0x3C51 => Some('\u{5ECC}'),
        0x3C53 => Some('\u{5ECE}'),
        0x3C54 => Some('\u{5ED1}'),
        0x3C55 => Some('\u{5ED2}'),
        0x3C56 => Some('\u{5ED4}'),
        0x3C57 => Some('\u{5ED5}'),
        0x3C58 => Some('\u{5EDC}'),
        0x3C59 => Some('\u{5EDE}'),
        0x3C5A => Some('\u{5EE5}'),
        0x3C5B => Some('\u{5EEB}'),
        0x3C5C => Some('\u{5F02}'),
        0x3C5D => Some('\u{5F06}'),
        0x3C5E => Some('\u{5F07}'),
        0x3C5F => Some('\u{5F08}'),
        0x3C60 => Some('\u{5F0E}'),
        0x3C61 => Some('\u{5F19}'),
        0x3C62 => Some('\u{5F1C}'),
        0x3C63 => Some('\u{5F1D}'),
        0x3C64 => Some('\u{5F21}'),
        0x3C65 => Some('\u{5F22}'),
        0x3C66 => Some('\u{5F23}'),
        0x3C67 => Some('\u{5F24}'),
        0x3C68 => Some('\u{5F28}'),
        0x3C69 => Some('\u{5F2B}'),
        0x3C6A => Some('\u{5F2C}'),
        0x3C6B => Some('\u{5F2E}'),
        0x3C6C => Some('\u{5F30}'),
        0x3C6D => Some('\u{5F34}'),
        0x3C6E => Some('\u{5F36}'),
        0x3C6F => Some('\u{5F3B}'),
        0x3C70 => Some('\u{5F3D}'),
        0x3C71 => Some('\u{5F3F}'),
        0x3C72 => Some('\u{5F40}'),
        0x3C73 => Some('\u{5F44}'),
        0x3C74 => Some('\u{5F45}'),
        0x3C75 => Some('\u{5F47}'),
        0x3C76 => Some('\u{5F4D}'),
        0x3C77 => Some('\u{5F50}'),
        0x3C78 => Some('\u{5F54}'),
        0x3C79 => Some('\u{5F58}'),
        0x3C7A => Some('\u{5F5B}'),
        0x3C7B => Some('\u{5F60}'),
        0x3C7C => Some('\u{5F63}'),
        0x3C7D => Some('\u{5F64}'),
        0x3C7E => Some('\u{5F67}'),
        0x3D21 => Some('\u{5F6F}'),
        0x3D22 => Some('\u{5F72}'),
        0x3D23 => Some('\u{5F74}'),
        0x3D24 => Some('\u{5F75}'),
        0x3D25 => Some('\u{5F78}'),
        0x3D26 => Some('\u{5F7A}'),
        0x3D27 => Some('\u{5F7D}'),
        0x3D28 => Some('\u{5F7E}'),
        0x3D29 => Some('\u{5F89}'),
        0x3D2A => Some('\u{5F8D}'),
        0x3D2B => Some('\u{5F8F}'),
        0x3D2C => Some('\u{5F96}'),
        0x3D2D => Some('\u{5F9C}'),
        0x3D2E => Some('\u{5F9D}'),
        0x3D2F => Some('\u{5FA2}'),
        0x3D32 => Some('\u{5FA4}'),
        0x3D30 => Some('\u{5FA7}'),
        0x3D31 => Some('\u{5FAB}'),
        0x3D33 => Some('\u{5FAC}'),
        0x3D34 => Some('\u{5FAF}'),
        0x3D35 => Some('\u{5FB0}'),
        0x3D36 => Some('\u{5FB1}'),
        0x3D37 => Some('\u{5FB8}'),
        0x3D38 => Some('\u{5FC4}'),
        0x3D39 => Some('\u{5FC7}'),
        0x3D3A => Some('\u{5FC8}'),
        0x3D3B => Some('\u{5FC9}'),
        0x3D3C => Some('\u{5FCB}'),
        0x3D3D => Some('\u{5FD0}'),
        0x3D3E => Some('\u{5FD1}'),
        0x3D3F => Some('\u{5FD2}'),
        0x3D40 => Some('\u{5FD3}'),
        0x3D41 => Some('\u{5FD4}'),
        0x3D42 => Some('\u{5FDE}'),
        0x3D43 => Some('\u{5FE1}'),
        0x3D44 => Some('\u{5FE2}'),
        0x3D45 => Some('\u{5FE8}'),
        0x3D46 => Some('\u{5FE9}'),
        0x3D47 => Some('\u{5FEA}'),
        0x3D48 => Some('\u{5FEC}'),
        0x3D49 => Some('\u{5FED}'),
        0x3D4A => Some('\u{5FEE}'),
        0x3D4B => Some('\u{5FEF}'),
        0x3D4C => Some('\u{5FF2}'),
        0x3D4D => Some('\u{5FF3}'),
        0x3D4E => Some('\u{5FF6}'),
        0x3D4F => Some('\u{5FFA}'),
        0x3D50 => Some('\u{5FFC}'),
        0x3D51 => Some('\u{6007}'),
        0x3D52 => Some('\u{600A}'),
        0x3D53 => Some('\u{600D}'),
        0x3D54 => Some('\u{6013}'),
        0x3D55 => Some('\u{6014}'),
        0x3D56 => Some('\u{6017}'),
        0x3D57 => Some('\u{6018}'),
        0x3D58 => Some('\u{601A}'),
        0x3D59 => Some('\u{601F}'),
        0x3D5A => Some('\u{6024}'),
        0x3D5B => Some('\u{602D}'),
        0x3D5C => Some('\u{6033}'),
        0x3D5D => Some('\u{6035}'),
        0x3D5E => Some('\u{6040}'),
        0x3D5F => Some('\u{6047}'),
        0x3D60 => Some('\u{6048}'),
        0x3D61 => Some('\u{6049}'),
        0x3D62 => Some('\u{604C}'),
        0x3D63 => Some('\u{6051}'),
        0x3D64 => Some('\u{6054}'),
        0x3D65 => Some('\u{6056}'),
        0x3D66 => Some('\u{6057}'),
        0x3D67 => Some('\u{605D}'),
        0x3D68 => Some('\u{6061}'),
        0x3D69 => Some('\u{6067}'),
        0x3D6A => Some('\u{6071}'),
        0x3D6B => Some('\u{607E}'),
        0x3D6C => Some('\u{607F}'),
        0x3D6D => Some('\u{6082}'),
        0x3D6E => Some('\u{6086}'),
        0x3D6F => Some('\u{6088}'),
        0x3D70 => Some('\u{608A}'),
        0x3D71 => Some('\u{608E}'),
        0x3D72 => Some('\u{6091}'),
        0x3D73 => Some('\u{6093}'),
        0x3D74 => Some('\u{6095}'),
        0x3D75 => Some('\u{6098}'),
        0x3D76 => Some('\u{609D}'),
        0x3D77 => Some('\u{609E}'),
        0x3D78 => Some('\u{60A2}'),
        0x3D79 => Some('\u{60A4}'),
        0x3D7A => Some('\u{60A5}'),
        0x3D7B => Some('\u{60A8}'),
        0x3D7C => Some('\u{60B0}'),
        0x3D7D => Some('\u{60B1}'),
        0x3D7E => Some('\u{60B7}'),
        0x3E21 => Some('\u{60BB}'),
        0x3E22 => Some('\u{60BE}'),
        0x3E23 => Some('\u{60C2}'),
        0x3E24 => Some('\u{60C4}'),
        0x3E25 => Some('\u{60C8}'),
        0x3E26 => Some('\u{60C9}'),
        0x3E27 => Some('\u{60CA}'),
        0x3E28 => Some('\u{60CB}'),
        0x3E29 => Some('\u{60CE}'),
        0x3E2A => Some('\u{60CF}'),
        0x3E2B => Some('\u{60D4}'),
        0x3E2C => Some('\u{60D5}'),
        0x3E2D => Some('\u{60D9}'),
        0x3E2E => Some('\u{60DB}'),
        0x3E2F => Some('\u{60DD}'),
        0x3E30 => Some('\u{60DE}'),
        0x3E31 => Some('\u{60E2}'),
        0x3E32 => Some('\u{60E5}'),
        0x3E33 => Some('\u{60F2}'),
        0x3E34 => Some('\u{60F5}'),
        0x3E35 => Some('\u{60F8}'),
        0x3E36 => Some('\u{60FC}'),
        0x3E37 => Some('\u{60FD}'),
        0x3E38 => Some('\u{6102}'),
        0x3E39 => Some('\u{6107}'),
        0x3E3A => Some('\u{610A}'),
        0x3E3B => Some('\u{610C}'),
        0x3E3C => Some('\u{6110}'),
        0x3E3D => Some('\u{6111}'),
        0x3E3E => Some('\u{6112}'),
        0x3E3F => Some('\u{6113}'),
        0x3E40 => Some('\u{6114}'),
        0x3E41 => Some('\u{6116}'),
        0x3E42 => Some('\u{6117}'),
        0x3E43 => Some('\u{6119}'),
        0x3E44 => Some('\u{611C}'),
        0x3E45 => Some('\u{611E}'),
        0x3E46 => Some('\u{6122}'),
        0x3E47 => Some('\u{612A}'),
        0x3E48 => Some('\u{612B}'),
        0x3E49 => Some('\u{6130}'),
        0x3E4A => Some('\u{6131}'),
        0x3E4B => Some('\u{6135}'),
        0x3E4C => Some('\u{6136}'),
        0x3E4D => Some('\u{6137}'),
        0x3E4E => Some('\u{6139}'),
        0x3E4F => Some('\u{6141}'),
        0x3E50 => Some('\u{6145}'),
        0x3E51 => Some('\u{6146}'),
        0x3E52 => Some('\u{6149}'),
        0x3E53 => Some('\u{615E}'),
        0x3E54 => Some('\u{6160}'),
        0x3E55 => Some('\u{616C}'),
        0x3E56 => Some('\u{6172}'),
        0x3E57 => Some('\u{6178}'),
        0x3E58 => Some('\u{617B}'),
        0x3E59 => Some('\u{617C}'),
        0x3E5A => Some('\u{617F}'),
        0x3E5B => Some('\u{6180}'),
        0x3E5C => Some('\u{6181}'),
        0x3E5D => Some('\u{6183}'),
        0x3E5E => Some('\u{6184}'),
        0x3E5F => Some('\u{618B}'),
        0x3E60 => Some('\u{618D}'),
        0x3E61 => Some('\u{6192}'),
        0x3E62 => Some('\u{6193}'),
        0x3E63 => Some('\u{6197}'),
        0x3E64 => Some('\u{6198}'),
        0x3E65 => Some('\u{619C}'),
        0x3E66 => Some('\u{619D}'),
        0x3E67 => Some('\u{619F}'),
        0x3E68 => Some('\u{61A0}'),
        0x3E69 => Some('\u{61A5}'),
        0x3E6A => Some('\u{61A8}'),
        0x3E6B => Some('\u{61AA}'),
        0x3E6C => Some('\u{61AD}'),
        0x3E6D => Some('\u{61B8}'),
        0x3E6E => Some('\u{61B9}'),
        0x3E6F => Some('\u{61BC}'),
        0x3E70 => Some('\u{61C0}'),
        0x3E71 => Some('\u{61C1}'),
        0x3E72 => Some('\u{61C2}'),
        0x3E73 => Some('\u{61CE}'),
        0x3E74 => Some('\u{61CF}'),
        0x3E75 => Some('\u{61D5}'),
        0x3E76 => Some('\u{61DC}'),
        0x3E77 => Some('\u{61DD}'),
        0x3E78 => Some('\u{61DE}'),
        0x3E79 => Some('\u{61DF}'),
        0x3E7A => Some('\u{61E1}'),
        0x3E7B => Some('\u{61E2}'),
        0x3E7E => Some('\u{61E5}'),
        0x3E7C => Some('\u{61E7}'),
        0x3E7D => Some('\u{61E9}'),
        0x3F21 => Some('\u{61EC}'),
        0x3F22 => Some('\u{61ED}'),
        0x3F23 => Some('\u{61EF}'),
        0x3F24 => Some('\u{6201}'),
        0x3F25 => Some('\u{6203}'),
        0x3F26 => Some('\u{6204}'),
        0x3F27 => Some('\u{6207}'),
        0x3F28 => Some('\u{6213}'),
        0x3F29 => Some('\u{6215}'),
        0x3F2A => Some('\u{621C}'),
        0x3F2B => Some('\u{6220}'),
        0x3F2C => Some('\u{6222}'),
        0x3F2D => Some('\u{6223}'),
        0x3F2E => Some('\u{6227}'),
        0x3F2F => Some('\u{6229}'),
        0x3F30 => Some('\u{622B}'),
        0x3F31 => Some('\u{6239}'),
        0x3F32 => Some('\u{623D}'),
        0x3F33 => Some('\u{6242}'),
        0x3F34 => Some('\u{6243}'),
        0x3F35 => Some('\u{6244}'),
        0x3F36 => Some('\u{6246}'),
        0x3F37 => Some('\u{624C}'),
        0x3F38 => Some('\u{6250}'),
        0x3F39 => Some('\u{6251}'),
        0x3F3A => Some('\u{6252}'),
        0x3F3B => Some('\u{6254}'),
        0x3F3C => Some('\u{6256}'),
        0x3F3D => Some('\u{625A}'),
        0x3F3E => Some('\u{625C}'),
        0x3F3F => Some('\u{6264}'),
        0x3F40 => Some('\u{626D}'),
        0x3F41 => Some('\u{626F}'),
        0x3F42 => Some('\u{6273}'),
        0x3F43 => Some('\u{627A}'),
        0x3F44 => Some('\u{627D}'),
        0x3F45 => Some('\u{628D}'),
        0x3F46 => Some('\u{628E}'),
        0x3F47 => Some('\u{628F}'),
        0x3F48 => Some('\u{6290}'),
        0x3F49 => Some('\u{62A6}'),
        0x3F4A => Some('\u{62A8}'),
        0x3F4B => Some('\u{62B3}'),
        0x3F4C => Some('\u{62B6}'),
        0x3F4D => Some('\u{62B7}'),
        0x3F4E => Some('\u{62BA}'),
        0x3F4F => Some('\u{62BE}'),
        0x3F50 => Some('\u{62BF}'),
        0x3F51 => Some('\u{62C4}'),
        0x3F52 => Some('\u{62CE}'),
        0x3F53 => Some('\u{62D5}'),
        0x3F54 => Some('\u{62D6}'),
        0x3F55 => Some('\u{62DA}'),
        0x3F56 => Some('\u{62EA}'),
        0x3F57 => Some('\u{62F2}'),
        0x3F58 => Some('\u{62F4}'),
        0x3F59 => Some('\u{62FC}'),
        0x3F5A => Some('\u{62FD}'),
        0x3F5B => Some('\u{6303}'),
        0x3F5C => Some('\u{6304}'),
        0x3F5D => Some('\u{630A}'),
        0x3F5E => Some('\u{630B}'),
        0x3F5F => Some('\u{630D}'),
        0x3F60 => Some('\u{6310}'),
        0x3F61 => Some('\u{6313}'),
        0x3F62 => Some('\u{6316}'),
        0x3F63 => Some('\u{6318}'),
        0x3F64 => Some('\u{6329}'),
        0x3F65 => Some('\u{632A}'),
        0x3F66 => Some('\u{632D}'),
        0x3F67 => Some('\u{6335}'),
        0x3F68 => Some('\u{6336}'),
        0x3F69 => Some('\u{6339}'),
        0x3F6A => Some('\u{633C}'),
        0x3F6B => Some('\u{6341}'),
        0x3F6C => Some('\u{6342}'),
        0x3F6D => Some('\u{6343}'),
        0x3F6E => Some('\u{6344}'),
        0x3F6F => Some('\u{6346}'),
        0x3F70 => Some('\u{634A}'),
        0x3F71 => Some('\u{634B}'),
        0x3F72 => Some('\u{634E}'),
        0x3F73 => Some('\u{6352}'),
        0x3F74 => Some('\u{6353}'),
        0x3F75 => Some('\u{6354}'),
        0x3F76 => Some('\u{6358}'),
        0x3F77 => Some('\u{635B}'),
        0x3F78 => Some('\u{6365}'),
        0x3F79 => Some('\u{6366}'),
        0x3F7A => Some('\u{636C}'),
        0x3F7B => Some('\u{636D}'),
        0x3F7C => Some('\u{6371}'),
        0x3F7D => Some('\u{6374}'),
        0x3F7E => Some('\u{6375}'),
        0x4021 => Some('\u{6378}'),
        0x4022 => Some('\u{637C}'),
        0x4023 => Some('\u{637D}'),
        0x4024 => Some('\u{637F}'),
        0x4025 => Some('\u{6382}'),
        0x4026 => Some('\u{6384}'),
        0x4027 => Some('\u{6387}'),
        0x4028 => Some('\u{638A}'),
        0x4029 => Some('\u{6390}'),
        0x402A => Some('\u{6394}'),
        0x402B => Some('\u{6395}'),
        0x402C => Some('\u{6399}'),
        0x402D => Some('\u{639A}'),
        0x402E => Some('\u{639E}'),
        0x402F => Some('\u{63A4}'),
        0x4030 => Some('\u{63A6}'),
        0x4031 => Some('\u{63AD}'),
        0x4032 => Some('\u{63AE}'),
        0x4033 => Some('\u{63AF}'),
        0x4034 => Some('\u{63BD}'),
        0x4035 => Some('\u{63C1}'),
        0x4036 => Some('\u{63C5}'),
        0x4037 => Some('\u{63C8}'),
        0x4038 => Some('\u{63CE}'),
        0x4039 => Some('\u{63D1}'),
        0x403A => Some('\u{63D3}'),
        0x403B => Some('\u{63D4}'),
        0x403C => Some('\u{63D5}'),
        0x403D => Some('\u{63DC}'),
        0x403E => Some('\u{63E0}'),
        0x403F => Some('\u{63E5}'),
        0x4040 => Some('\u{63EA}'),
        0x4041 => Some('\u{63EC}'),
        0x4042 => Some('\u{63F2}'),
        0x4043 => Some('\u{63F3}'),
        0x4044 => Some('\u{63F5}'),
        0x4045 => Some('\u{63F8}'),
        0x4046 => Some('\u{63F9}'),
        0x4047 => Some('\u{6409}'),
        0x4048 => Some('\u{640A}'),
        0x4049 => Some('\u{6410}'),
        0x404A => Some('\u{6412}'),
        0x404B => Some('\u{6414}'),
        0x404C => Some('\u{6418}'),
        0x404D => Some('\u{641E}'),
        0x404E => Some('\u{6420}'),
        0x404F => Some('\u{6422}'),
        0x4050 => Some('\u{6424}'),
        0x4051 => Some('\u{6425}'),
        0x4052 => Some('\u{6429}'),
        0x4053 => Some('\u{642A}'),
        0x4054 => Some('\u{642F}'),
        0x4055 => Some('\u{6430}'),
        0x4056 => Some('\u{6435}'),
        0x4057 => Some('\u{643D}'),
        0x4058 => Some('\u{643F}'),
        0x4059 => Some('\u{644B}'),
        0x405A => Some('\u{644F}'),
        0x405B => Some('\u{6451}'),
        0x405C => Some('\u{6452}'),
        0x405D => Some('\u{6453}'),
        0x405E => Some('\u{6454}'),
        0x405F => Some('\u{645A}'),
        0x4060 => Some('\u{645B}'),
        0x4061 => Some('\u{645C}'),
        0x4062 => Some('\u{645D}'),
        0x4063 => Some('\u{645F}'),
        0x4064 => Some('\u{6460}'),
        0x4065 => Some('\u{6461}'),
        0x4066 => Some('\u{6463}'),
        0x4067 => Some('\u{646D}'),
        0x4068 => Some('\u{6473}'),
        0x4069 => Some('\u{6474}'),
        0x406A => Some('\u{647B}'),
        0x406B => Some('\u{647D}'),
        0x406C => Some('\u{6485}'),
        0x406D => Some('\u{6487}'),
        0x406E => Some('\u{648F}'),
        0x406F => Some('\u{6490}'),
        0x4070 => Some('\u{6491}'),
        0x4071 => Some('\u{6498}'),
        0x4072 => Some('\u{6499}'),
        0x4073 => Some('\u{649B}'),
        0x4074 => Some('\u{649D}'),
        0x4075 => Some('\u{649F}'),
        0x4076 => Some('\u{64A1}'),
        0x4077 => Some('\u{64A3}'),
        0x4078 => Some('\u{64A6}'),
        0x4079 => Some('\u{64A8}'),
        0x407A => Some('\u{64AC}'),
        0x407B => Some('\u{64B3}'),
        0x407C => Some('\u{64BD}'),
        0x407D => Some('\u{64BE}'),
        0x407E => Some('\u{64BF}'),
        0x4121 => Some('\u{64C4}'),
        0x4122 => Some('\u{64C9}'),
        0x4123 => Some('\u{64CA}'),
        0x4124 => Some('\u{64CB}'),
        0x4125 => Some('\u{64CC}'),
        0x4126 => Some('\u{64CE}'),
        0x4127 => Some('\u{64D0}'),
        0x4128 => Some('\u{64D1}'),
        0x4129 => Some('\u{64D5}'),
        0x412A => Some('\u{64D7}'),
        0x412B => Some('\u{64E4}'),
        0x412C => Some('\u{64E5}'),
        0x412D => Some('\u{64E9}'),
        0x412E => Some('\u{64EA}'),
        0x412F => Some('\u{64ED}'),
        0x4130 => Some('\u{64F0}'),
        0x4131 => Some('\u{64F5}'),
        0x4132 => Some('\u{64F7}'),
        0x4133 => Some('\u{64FB}'),
        0x4134 => Some('\u{64FF}'),
        0x4135 => Some('\u{6501}'),
        0x4136 => Some('\u{6504}'),
        0x4137 => Some('\u{6508}'),
        0x4138 => Some('\u{6509}'),
        0x4139 => Some('\u{650A}'),
        0x413A => Some('\u{650F}'),
        0x413B => Some('\u{6513}'),
        0x413C => Some('\u{6514}'),
        0x413D => Some('\u{6516}'),
        0x413E => Some('\u{6519}'),
        0x413F => Some('\u{651B}'),
        0x4140 => Some('\u{651E}'),
        0x4141 => Some('\u{651F}'),
        0x4142 => Some('\u{6522}'),
        0x4143 => Some('\u{6526}'),
        0x4144 => Some('\u{6529}'),
        0x4145 => Some('\u{652E}'),
        0x4146 => Some('\u{6531}'),
        0x4147 => Some('\u{653A}'),
        0x4148 => Some('\u{653C}'),
        0x4149 => Some('\u{653D}'),
        0x414A => Some('\u{6543}'),
        0x414B => Some('\u{6547}'),
        0x414C => Some('\u{6549}'),
        0x414D => Some('\u{6550}'),
        0x414E => Some('\u{6552}'),
        0x414F => Some('\u{6554}'),
        0x4150 => Some('\u{655F}'),
        0x4151 => Some('\u{6560}'),
        0x4152 => Some('\u{6567}'),
        0x4153 => Some('\u{656B}'),
        0x4154 => Some('\u{657A}'),
        0x4155 => Some('\u{657D}'),
        0x4156 => Some('\u{6581}'),
        0x4157 => Some('\u{6585}'),
        0x4158 => Some('\u{658A}'),
        0x4159 => Some('\u{6592}'),
        0x415A => Some('\u{6595}'),
        0x415B => Some('\u{6598}'),
        0x415C => Some('\u{659D}'),
        0x415D => Some('\u{65A0}'),
        0x415E => Some('\u{65A3}'),
        0x415F => Some('\u{65A6}'),
        0x4160 => Some('\u{65AE}'),
        0x4161 => Some('\u{65B2}'),
        0x4162 => Some('\u{65B3}'),
        0x4163 => Some('\u{65B4}'),
        0x4164 => Some('\u{65BF}'),
        0x4165 => Some('\u{65C2}'),
        0x4166 => Some('\u{65C8}'),
        0x4167 => Some('\u{65C9}'),
        0x4168 => Some('\u{65CE}'),
        0x4169 => Some('\u{65D0}'),
        0x416A => Some('\u{65D4}'),
        0x416B => Some('\u{65D6}'),
        0x416C => Some('\u{65D8}'),
        0x416D => Some('\u{65DF}'),
        0x416E => Some('\u{65F0}'),
        0x416F => Some('\u{65F2}'),
        0x4170 => Some('\u{65F4}'),
        0x4171 => Some('\u{65F5}'),
        0x4172 => Some('\u{65F9}'),
        0x4173 => Some('\u{65FE}'),
        0x4174 => Some('\u{65FF}'),
        0x4175 => Some('\u{6600}'),
        0x4176 => Some('\u{6604}'),
        0x4177 => Some('\u{6608}'),
        0x4178 => Some('\u{6609}'),
        0x4179 => Some('\u{660D}'),
        0x417A => Some('\u{6611}'),
        0x417B => Some('\u{6612}'),
        0x417C => Some('\u{6615}'),
        0x417D => Some('\u{6616}'),
        0x417E => Some('\u{661D}'),
        0x4221 => Some('\u{661E}'),
        0x4222 => Some('\u{6621}'),
        0x4223 => Some('\u{6622}'),
        0x4224 => Some('\u{6623}'),
        0x4225 => Some('\u{6624}'),
        0x4226 => Some('\u{6626}'),
        0x4227 => Some('\u{6629}'),
        0x4228 => Some('\u{662A}'),
        0x4229 => Some('\u{662B}'),
        0x422A => Some('\u{662C}'),
        0x422B => Some('\u{662E}'),
        0x422C => Some('\u{6630}'),
        0x422D => Some('\u{6631}'),
        0x422E => Some('\u{6633}'),
        0x4230 => Some('\u{6637}'),
        0x422F => Some('\u{6639}'),
        0x4231 => Some('\u{6640}'),
        0x4232 => Some('\u{6645}'),
        0x4233 => Some('\u{6646}'),
        0x4234 => Some('\u{664A}'),
        0x4235 => Some('\u{664C}'),
        0x4237 => Some('\u{664E}'),
        0x4236 => Some('\u{6651}'),
        0x4238 => Some('\u{6657}'),
        0x4239 => Some('\u{6658}'),
        0x423A => Some('\u{6659}'),
        0x423B => Some('\u{665B}'),
        0x423C => Some('\u{665C}'),
        0x423D => Some('\u{6660}'),
        0x423E => Some('\u{6661}'),
        0x4240 => Some('\u{666A}'),
        0x4241 => Some('\u{666B}'),
        0x4242 => Some('\u{666C}'),
        0x4244 => Some('\u{6673}'),
        0x4245 => Some('\u{6675}'),
        0x4247 => Some('\u{6677}'),
        0x4248 => Some('\u{6678}'),
        0x4249 => Some('\u{6679}'),
        0x424A => Some('\u{667B}'),
        0x424C => Some('\u{667C}'),
        0x4243 => Some('\u{667E}'),
        0x4246 => Some('\u{667F}'),
        0x424B => Some('\u{6680}'),
        0x424D => Some('\u{668B}'),
        0x424E => Some('\u{668C}'),
        0x424F => Some('\u{668D}'),
        0x4250 => Some('\u{6690}'),
        0x4251 => Some('\u{6692}'),
        0x4252 => Some('\u{6699}'),
        0x4253 => Some('\u{669A}'),
        0x4254 => Some('\u{669B}'),
        0x4255 => Some('\u{669C}'),
        0x4256 => Some('\u{669F}'),
        0x4257 => Some('\u{66A0}'),
        0x4258 => Some('\u{66A4}'),
        0x4259 => Some('\u{66AD}'),
        0x425A => Some('\u{66B1}'),
        0x425B => Some('\u{66B2}'),
        0x425C => Some('\u{66B5}'),
        0x425D => Some('\u{66BB}'),
        0x425E => Some('\u{66BF}'),
        0x425F => Some('\u{66C0}'),
        0x4260 => Some('\u{66C2}'),
        0x4261 => Some('\u{66C3}'),
        0x4262 => Some('\u{66C8}'),
        0x4263 => Some('\u{66CC}'),
        0x4264 => Some('\u{66CE}'),
        0x4265 => Some('\u{66CF}'),
        0x4266 => Some('\u{66D4}'),
        0x4267 => Some('\u{66DB}'),
        0x4268 => Some('\u{66DF}'),
        0x4269 => Some('\u{66E8}'),
        0x426A => Some('\u{66EB}'),
        0x426B => Some('\u{66EC}'),
        0x426C => Some('\u{66EE}'),
        0x426D => Some('\u{66FA}'),
        0x423F => Some('\u{66FB}'),
        0x426E => Some('\u{6705}'),
        0x426F => Some('\u{6707}'),
        0x4270 => Some('\u{670E}'),
        0x4271 => Some('\u{6713}'),
        0x4272 => Some('\u{6719}'),
        0x4273 => Some('\u{671C}'),
        0x4274 => Some('\u{6720}'),
        0x4275 => Some('\u{6722}'),
        0x4276 => Some('\u{6733}'),
        0x4277 => Some('\u{673E}'),
        0x4278 => Some('\u{6745}'),
        0x4279 => Some('\u{6747}'),
        0x427A => Some('\u{6748}'),
        0x427B => Some('\u{674C}'),
        0x427C => Some('\u{6754}'),
        0x427D => Some('\u{6755}'),
        0x427E => Some('\u{675D}'),
        0x4321 => Some('\u{6766}'),
        0x4322 => Some('\u{676C}'),
        0x4323 => Some('\u{676E}'),
        0x4324 => Some('\u{6774}'),
        0x4325 => Some('\u{6776}'),
        0x4326 => Some('\u{677B}'),
        0x4327 => Some('\u{6781}'),
        0x4328 => Some('\u{6784}'),
        0x4329 => Some('\u{678E}'),
        0x432A => Some('\u{678F}'),
        0x432B => Some('\u{6791}'),
        0x432C => Some('\u{6793}'),
        0x432D => Some('\u{6796}'),
        0x432E => Some('\u{6798}'),
        0x432F => Some('\u{6799}'),
        0x4330 => Some('\u{679B}'),
        0x4331 => Some('\u{67B0}'),
        0x4332 => Some('\u{67B1}'),
        0x4333 => Some('\u{67B2}'),
        0x4334 => Some('\u{67B5}'),
        0x4335 => Some('\u{67BB}'),
        0x4336 => Some('\u{67BC}'),
        0x4337 => Some('\u{67BD}'),
        0x4339 => Some('\u{67C0}'),
        0x433A => Some('\u{67C2}'),
        0x433B => Some('\u{67C3}'),
        0x433C => Some('\u{67C5}'),
        0x433D => Some('\u{67C8}'),
        0x433E => Some('\u{67C9}'),
        0x433F => Some('\u{67D2}'),
        0x4340 => Some('\u{67D7}'),
        0x4341 => Some('\u{67D9}'),
        0x4342 => Some('\u{67DC}'),
        0x4343 => Some('\u{67E1}'),
        0x4344 => Some('\u{67E6}'),
        0x4345 => Some('\u{67F0}'),
        0x4346 => Some('\u{67F2}'),
        0x4347 => Some('\u{67F6}'),
        0x4348 => Some('\u{67F7}'),
        0x4338 => Some('\u{67F9}'),
        0x434A => Some('\u{6814}'),
        0x434B => Some('\u{6819}'),
        0x434C => Some('\u{681D}'),
        0x434D => Some('\u{681F}'),
        0x434F => Some('\u{6827}'),
        0x434E => Some('\u{6828}'),
        0x4350 => Some('\u{682C}'),
        0x4351 => Some('\u{682D}'),
        0x4352 => Some('\u{682F}'),
        0x4353 => Some('\u{6830}'),
        0x4354 => Some('\u{6831}'),
        0x4355 => Some('\u{6833}'),
        0x4356 => Some('\u{683B}'),
        0x4357 => Some('\u{683F}'),
        0x4358 => Some('\u{6844}'),
        0x4359 => Some('\u{6845}'),
        0x435A => Some('\u{684A}'),
        0x435B => Some('\u{684C}'),
        0x4349 => Some('\u{6852}'),
        0x435C => Some('\u{6855}'),
        0x435D => Some('\u{6857}'),
        0x435E => Some('\u{6858}'),
        0x435F => Some('\u{685B}'),
        0x4360 => Some('\u{686B}'),
        0x4361 => Some('\u{686E}'),
        0x4362 => Some('\u{686F}'),
        0x4363 => Some('\u{6870}'),
        0x4364 => Some('\u{6871}'),
        0x4365 => Some('\u{6872}'),
        0x4366 => Some('\u{6875}'),
        0x4367 => Some('\u{6879}'),
        0x4368 => Some('\u{687A}'),
        0x4369 => Some('\u{687B}'),
        0x436A => Some('\u{687C}'),
        0x436B => Some('\u{6882}'),
        0x436C => Some('\u{6884}'),
        0x436D => Some('\u{6886}'),
        0x436E => Some('\u{6888}'),
        0x436F => Some('\u{6896}'),
        0x4370 => Some('\u{6898}'),
        0x4371 => Some('\u{689A}'),
        0x4372 => Some('\u{689C}'),
        0x4373 => Some('\u{68A1}'),
        0x4374 => Some('\u{68A3}'),
        0x4375 => Some('\u{68A5}'),
        0x4376 => Some('\u{68A9}'),
        0x4377 => Some('\u{68AA}'),
        0x4378 => Some('\u{68AE}'),
        0x4379 => Some('\u{68B2}'),
        0x437A => Some('\u{68BB}'),
        0x437B => Some('\u{68C5}'),
        0x437C => Some('\u{68C8}'),
        0x437D => Some('\u{68CC}'),
        0x437E => Some('\u{68CF}'),
        0x4421 => Some('\u{68D0}'),
        0x4422 => Some('\u{68D1}'),
        0x4423 => Some('\u{68D3}'),
        0x4424 => Some('\u{68D6}'),
        0x4425 => Some('\u{68D9}'),
        0x4426 => Some('\u{68DC}'),
        0x4427 => Some('\u{68DD}'),
        0x4428 => Some('\u{68E5}'),
        0x4429 => Some('\u{68E8}'),
        0x442A => Some('\u{68EA}'),
        0x442B => Some('\u{68EB}'),
        0x442C => Some('\u{68EC}'),
        0x442D => Some('\u{68ED}'),
        0x442E => Some('\u{68F0}'),
        0x442F => Some('\u{68F1}'),
        0x4430 => Some('\u{68F5}'),
        0x4431 => Some('\u{68F6}'),
        0x4432 => Some('\u{68FB}'),
        0x4433 => Some('\u{68FC}'),
        0x4434 => Some('\u{68FD}'),
        0x4435 => Some('\u{6906}'),
        0x4436 => Some('\u{6909}'),
        0x4437 => Some('\u{690A}'),
        0x4438 => Some('\u{6910}'),
        0x4439 => Some('\u{6911}'),
        0x443A => Some('\u{6913}'),
        0x443B => Some('\u{6916}'),
        0x443C => Some('\u{6917}'),
        0x443D => Some('\u{6931}'),
        0x443E => Some('\u{6933}'),
        0x443F => Some('\u{6935}'),
        0x4440 => Some('\u{6938}'),
        0x4441 => Some('\u{693B}'),
        0x4442 => Some('\u{6942}'),
        0x4443 => Some('\u{6945}'),
        0x4444 => Some('\u{6949}'),
        0x4445 => Some('\u{694E}'),
        0x4446 => Some('\u{6957}'),
        0x4447 => Some('\u{695B}'),
        0x4448 => Some('\u{6963}'),
        0x4449 => Some('\u{6964}'),
        0x444A => Some('\u{6965}'),
        0x444B => Some('\u{6966}'),
        0x444C => Some('\u{6968}'),
        0x444D => Some('\u{6969}'),
        0x444E => Some('\u{696C}'),
        0x444F => Some('\u{6970}'),
        0x4450 => Some('\u{6971}'),
        0x4451 => Some('\u{6972}'),
        0x4452 => Some('\u{697A}'),
        0x4453 => Some('\u{697B}'),
        0x4454 => Some('\u{697F}'),
        0x4455 => Some('\u{6980}'),
        0x4456 => Some('\u{698D}'),
        0x4457 => Some('\u{6992}'),
        0x4458 => Some('\u{6996}'),
        0x4459 => Some('\u{6998}'),
        0x445A => Some('\u{69A1}'),
        0x445B => Some('\u{69A5}'),
        0x445C => Some('\u{69A6}'),
        0x445D => Some('\u{69A8}'),
        0x445E => Some('\u{69AB}'),
        0x445F => Some('\u{69AD}'),
        0x4460 => Some('\u{69AF}'),
        0x4461 => Some('\u{69B7}'),
        0x4462 => Some('\u{69B8}'),
        0x4463 => Some('\u{69BA}'),
        0x4464 => Some('\u{69BC}'),
        0x4465 => Some('\u{69C5}'),
        0x4466 => Some('\u{69C8}'),
        0x4467 => Some('\u{69D1}'),
        0x4468 => Some('\u{69D6}'),
        0x4469 => Some('\u{69D7}'),
        0x446A => Some('\u{69E2}'),
        0x446B => Some('\u{69E5}'),
        0x446C => Some('\u{69EE}'),
        0x446D => Some('\u{69EF}'),
        0x446E => Some('\u{69F1}'),
        0x446F => Some('\u{69F3}'),
        0x4470 => Some('\u{69F5}'),
        0x4471 => Some('\u{69FE}'),
        0x4472 => Some('\u{6A00}'),
        0x4473 => Some('\u{6A01}'),
        0x4474 => Some('\u{6A03}'),
        0x4475 => Some('\u{6A0F}'),
        0x4476 => Some('\u{6A11}'),
        0x4477 => Some('\u{6A15}'),
        0x4478 => Some('\u{6A1A}'),
        0x4479 => Some('\u{6A1D}'),
        0x447A => Some('\u{6A20}'),
        0x447B => Some('\u{6A24}'),
        0x447C => Some('\u{6A28}'),
        0x447D => Some('\u{6A30}'),
        0x447E => Some('\u{6A32}'),
        0x4521 => Some('\u{6A34}'),
        0x4522 => Some('\u{6A37}'),
        0x4523 => Some('\u{6A3B}'),
        0x4524 => Some('\u{6A3E}'),
        0x4525 => Some('\u{6A3F}'),
        0x4526 => Some('\u{6A45}'),
        0x4527 => Some('\u{6A46}'),
        0x4528 => Some('\u{6A49}'),
        0x4529 => Some('\u{6A4A}'),
        0x452A => Some('\u{6A4E}'),
        0x452B => Some('\u{6A50}'),
        0x452C => Some('\u{6A51}'),
        0x452D => Some('\u{6A52}'),
        0x452E => Some('\u{6A55}'),
        0x452F => Some('\u{6A56}'),
        0x4530 => Some('\u{6A5B}'),
        0x4531 => Some('\u{6A64}'),
        0x4532 => Some('\u{6A67}'),
        0x4533 => Some('\u{6A6A}'),
        0x4534 => Some('\u{6A71}'),
        0x4535 => Some('\u{6A73}'),
        0x4536 => Some('\u{6A7E}'),
        0x4537 => Some('\u{6A81}'),
        0x4538 => Some('\u{6A83}'),
        0x4539 => Some('\u{6A86}'),
        0x453A => Some('\u{6A87}'),
        0x453B => Some('\u{6A89}'),
        0x453C => Some('\u{6A8B}'),
        0x453D => Some('\u{6A91}'),
        0x453E => Some('\u{6A9B}'),
        0x453F => Some('\u{6A9D}'),
        0x4540 => Some('\u{6A9E}'),
        0x4541 => Some('\u{6A9F}'),
        0x4542 => Some('\u{6AA5}'),
        0x4543 => Some('\u{6AAB}'),
        0x4544 => Some('\u{6AAF}'),
        0x4545 => Some('\u{6AB0}'),
        0x4546 => Some('\u{6AB1}'),
        0x4547 => Some('\u{6AB4}'),
        0x4548 => Some('\u{6ABD}'),
        0x4549 => Some('\u{6ABE}'),
        0x454A => Some('\u{6ABF}'),
        0x454B => Some('\u{6AC6}'),
        0x454D => Some('\u{6AC8}'),
        0x454C => Some('\u{6AC9}'),
        0x454E => Some('\u{6ACC}'),
        0x454F => Some('\u{6AD0}'),
        0x4550 => Some('\u{6AD4}'),
        0x4551 => Some('\u{6AD5}'),
        0x4552 => Some('\u{6AD6}'),
        0x4553 => Some('\u{6ADC}'),
        0x4554 => Some('\u{6ADD}'),
        0x4555 => Some('\u{6AE4}'),
        0x4556 => Some('\u{6AE7}'),
        0x4557 => Some('\u{6AEC}'),
        0x4558 => Some('\u{6AF0}'),
        0x4559 => Some('\u{6AF1}'),
        0x455A => Some('\u{6AF2}'),
        0x455B => Some('\u{6AFC}'),
        0x455C => Some('\u{6AFD}'),
        0x455D => Some('\u{6B02}'),
        0x455E => Some('\u{6B03}'),
        0x455F => Some('\u{6B06}'),
        0x4560 => Some('\u{6B07}'),
        0x4561 => Some('\u{6B09}'),
        0x4562 => Some('\u{6B0F}'),
        0x4563 => Some('\u{6B10}'),
        0x4564 => Some('\u{6B11}'),
        0x4565 => Some('\u{6B17}'),
        0x4566 => Some('\u{6B1B}'),
        0x4567 => Some('\u{6B1E}'),
        0x4568 => Some('\u{6B24}'),
        0x4569 => Some('\u{6B28}'),
        0x456A => Some('\u{6B2B}'),
        0x456B => Some('\u{6B2C}'),
        0x456C => Some('\u{6B2F}'),
        0x456D => Some('\u{6B35}'),
        0x456E => Some('\u{6B36}'),
        0x456F => Some('\u{6B3B}'),
        0x4570 => Some('\u{6B3F}'),
        0x4571 => Some('\u{6B46}'),
        0x4572 => Some('\u{6B4A}'),
        0x4573 => Some('\u{6B4D}'),
        0x4574 => Some('\u{6B52}'),
        0x4575 => Some('\u{6B56}'),
        0x4576 => Some('\u{6B58}'),
        0x4577 => Some('\u{6B5D}'),
        0x4578 => Some('\u{6B60}'),
        0x4579 => Some('\u{6B67}'),
        0x457A => Some('\u{6B6B}'),
        0x457B => Some('\u{6B6E}'),
        0x457C => Some('\u{6B70}'),
        0x457D => Some('\u{6B75}'),
        0x457E => Some('\u{6B7D}'),
        0x4621 => Some('\u{6B7E}'),
        0x4622 => Some('\u{6B82}'),
        0x4623 => Some('\u{6B85}'),
        0x4624 => Some('\u{6B97}'),
        0x4625 => Some('\u{6B9B}'),
        0x4626 => Some('\u{6B9F}'),
        0x4627 => Some('\u{6BA0}'),
        0x4628 => Some('\u{6BA2}'),
        0x4629 => Some('\u{6BA3}'),
        0x462A => Some('\u{6BA8}'),
        0x462B => Some('\u{6BA9}'),
        0x462C => Some('\u{6BAC}'),
        0x462D => Some('\u{6BAD}'),
        0x462E => Some('\u{6BAE}'),
        0x462F => Some('\u{6BB0}'),
        0x4630 => Some('\u{6BB8}'),
        0x4631 => Some('\u{6BB9}'),
        0x4632 => Some('\u{6BBD}'),
        0x4633 => Some('\u{6BBE}'),
        0x4634 => Some('\u{6BC3}'),
        0x4635 => Some('\u{6BC4}'),
        0x4636 => Some('\u{6BC9}'),
        0x4637 => Some('\u{6BCC}'),
        0x4638 => Some('\u{6BD6}'),
        0x4639 => Some('\u{6BDA}'),
        0x463A => Some('\u{6BE1}'),
        0x463B => Some('\u{6BE3}'),
        0x463C => Some('\u{6BE6}'),
        0x463D => Some('\u{6BE7}'),
        0x463E => Some('\u{6BEE}'),
        0x463F => Some('\u{6BF1}'),
        0x4640 => Some('\u{6BF7}'),
        0x4641 => Some('\u{6BF9}'),
        0x4642 => Some('\u{6BFF}'),
        0x4643 => Some('\u{6C02}'),
        0x4644 => Some('\u{6C04}'),
        0x4645 => Some('\u{6C05}'),
        0x4646 => Some('\u{6C09}'),
        0x4647 => Some('\u{6C0D}'),
        0x4648 => Some('\u{6C0E}'),
        0x4649 => Some('\u{6C10}'),
        0x464A => Some('\u{6C12}'),
        0x464B => Some('\u{6C19}'),
        0x464C => Some('\u{6C1F}'),
        0x464D => Some('\u{6C26}'),
        0x464E => Some('\u{6C27}'),
        0x464F => Some('\u{6C28}'),
        0x4650 => Some('\u{6C2C}'),
        0x4651 => Some('\u{6C2E}'),
        0x4652 => Some('\u{6C33}'),
        0x4653 => Some('\u{6C35}'),
        0x4654 => Some('\u{6C36}'),
        0x4655 => Some('\u{6C3A}'),
        0x4656 => Some('\u{6C3B}'),
        0x4657 => Some('\u{6C3F}'),
        0x4658 => Some('\u{6C4A}'),
        0x4659 => Some('\u{6C4B}'),
        0x465A => Some('\u{6C4D}'),
        0x465B => Some('\u{6C4F}'),
        0x465C => Some('\u{6C52}'),
        0x465D => Some('\u{6C54}'),
        0x465E => Some('\u{6C59}'),
        0x465F => Some('\u{6C5B}'),
        0x4660 => Some('\u{6C5C}'),
        0x4736 => Some('\u{6C67}'),
        0x4661 => Some('\u{6C6B}'),
        0x4662 => Some('\u{6C6D}'),
        0x4663 => Some('\u{6C6F}'),
        0x4664 => Some('\u{6C74}'),
        0x4665 => Some('\u{6C76}'),
        0x4666 => Some('\u{6C78}'),
        0x4667 => Some('\u{6C79}'),
        0x4668 => Some('\u{6C7B}'),
        0x4669 => Some('\u{6C85}'),
        0x466A => Some('\u{6C86}'),
        0x466B => Some('\u{6C87}'),
        0x466C => Some('\u{6C89}'),
        0x466D => Some('\u{6C94}'),
        0x466E => Some('\u{6C95}'),
        0x466F => Some('\u{6C97}'),
        0x4670 => Some('\u{6C98}'),
        0x4671 => Some('\u{6C9C}'),
        0x4672 => Some('\u{6C9F}'),
        0x4673 => Some('\u{6CB0}'),
        0x4674 => Some('\u{6CB2}'),
        0x4675 => Some('\u{6CB4}'),
        0x4676 => Some('\u{6CC2}'),
        0x4677 => Some('\u{6CC6}'),
        0x4678 => Some('\u{6CCD}'),
        0x4679 => Some('\u{6CCF}'),
        0x467A => Some('\u{6CD0}'),
        0x467B => Some('\u{6CD1}'),
        0x467C => Some('\u{6CD2}'),
        0x467D => Some('\u{6CD4}'),
        0x467E => Some('\u{6CD6}'),
        0x4721 => Some('\u{6CDA}'),
        0x4722 => Some('\u{6CDC}'),
        0x4723 => Some('\u{6CE0}'),
        0x4724 => Some('\u{6CE7}'),
        0x4725 => Some('\u{6CE9}'),
        0x4726 => Some('\u{6CEB}'),
        0x4727 => Some('\u{6CEC}'),
        0x4728 => Some('\u{6CEE}'),
        0x4729 => Some('\u{6CF2}'),
        0x472A => Some('\u{6CF4}'),
        0x472B => Some('\u{6D04}'),
        0x472C => Some('\u{6D07}'),
        0x472D => Some('\u{6D0A}'),
        0x472E => Some('\u{6D0E}'),
        0x472F => Some('\u{6D0F}'),
        0x4730 => Some('\u{6D11}'),
        0x4731 => Some('\u{6D13}'),
        0x4732 => Some('\u{6D1A}'),
        0x4733 => Some('\u{6D26}'),
        0x4734 => Some('\u{6D27}'),
        0x4735 => Some('\u{6D28}'),
        0x4737 => Some('\u{6D2E}'),
        0x4738 => Some('\u{6D2F}'),
        0x4739 => Some('\u{6D31}'),
        0x473A => Some('\u{6D39}'),
        0x473B => Some('\u{6D3C}'),
        0x473C => Some('\u{6D3F}'),
        0x473D => Some('\u{6D57}'),
        0x473E => Some('\u{6D5E}'),
        0x473F => Some('\u{6D5F}'),
        0x4740 => Some('\u{6D61}'),
        0x4741 => Some('\u{6D65}'),
        0x4742 => Some('\u{6D67}'),
        0x4743 => Some('\u{6D6F}'),
        0x4744 => Some('\u{6D70}'),
        0x4745 => Some('\u{6D7C}'),
        0x4746 => Some('\u{6D82}'),
        0x4747 => Some('\u{6D87}'),
        0x4748 => Some('\u{6D91}'),
        0x4749 => Some('\u{6D92}'),
        0x474A => Some('\u{6D94}'),
        0x474B => Some('\u{6D96}'),
        0x474C => Some('\u{6D97}'),
        0x474D => Some('\u{6D98}'),
        0x474E => Some('\u{6DAA}'),
        0x474F => Some('\u{6DAC}'),
        0x4750 => Some('\u{6DB4}'),
        0x4751 => Some('\u{6DB7}'),
        0x4752 => Some('\u{6DB9}'),
        0x4753 => Some('\u{6DBD}'),
        0x4754 => Some('\u{6DBF}'),
        0x4755 => Some('\u{6DC4}'),
        0x4756 => Some('\u{6DC8}'),
        0x4757 => Some('\u{6DCA}'),
        0x4758 => Some('\u{6DCE}'),
        0x4759 => Some('\u{6DCF}'),
        0x475A => Some('\u{6DD6}'),
        0x475B => Some('\u{6DDB}'),
        0x475C => Some('\u{6DDD}'),
        0x475D => Some('\u{6DDF}'),
        0x475E => Some('\u{6DE0}'),
        0x475F => Some('\u{6DE2}'),
        0x4760 => Some('\u{6DE5}'),
        0x4761 => Some('\u{6DE9}'),
        0x4762 => Some('\u{6DEF}'),
        0x4763 => Some('\u{6DF0}'),
        0x4764 => Some('\u{6DF4}'),
        0x4765 => Some('\u{6DF6}'),
        0x4766 => Some('\u{6DFC}'),
        0x4767 => Some('\u{6E00}'),
        0x4768 => Some('\u{6E04}'),
        0x4769 => Some('\u{6E1E}'),
        0x476A => Some('\u{6E22}'),
        0x476B => Some('\u{6E27}'),
        0x476C => Some('\u{6E32}'),
        0x476D => Some('\u{6E36}'),
        0x476E => Some('\u{6E39}'),
        0x476F => Some('\u{6E3B}'),
        0x4770 => Some('\u{6E3C}'),
        0x4771 => Some('\u{6E44}'),
        0x4772 => Some('\u{6E45}'),
        0x4773 => Some('\u{6E48}'),
        0x4774 => Some('\u{6E49}'),
        0x4775 => Some('\u{6E4B}'),
        0x4776 => Some('\u{6E4F}'),
        0x4777 => Some('\u{6E51}'),
        0x4778 => Some('\u{6E52}'),
        0x4779 => Some('\u{6E53}'),
        0x477A => Some('\u{6E54}'),
        0x477B => Some('\u{6E57}'),
        0x477C => Some('\u{6E5C}'),
        0x477D => Some('\u{6E5D}'),
        0x477E => Some('\u{6E5E}'),
        0x4821 => Some('\u{6E62}'),
        0x4822 => Some('\u{6E63}'),
        0x4823 => Some('\u{6E68}'),
        0x4824 => Some('\u{6E73}'),
        0x4825 => Some('\u{6E7B}'),
        0x4826 => Some('\u{6E7D}'),
        0x4827 => Some('\u{6E8D}'),
        0x4828 => Some('\u{6E93}'),
        0x4829 => Some('\u{6E99}'),
        0x482A => Some('\u{6EA0}'),
        0x482B => Some('\u{6EA7}'),
        0x482C => Some('\u{6EAD}'),
        0x482D => Some('\u{6EAE}'),
        0x482E => Some('\u{6EB1}'),
        0x482F => Some('\u{6EB3}'),
        0x4830 => Some('\u{6EBB}'),
        0x4831 => Some('\u{6EBF}'),
        0x4832 => Some('\u{6EC0}'),
        0x4833 => Some('\u{6EC1}'),
        0x4834 => Some('\u{6EC3}'),
        0x4835 => Some('\u{6EC7}'),
        0x4836 => Some('\u{6EC8}'),
        0x4837 => Some('\u{6ECA}'),
        0x4838 => Some('\u{6ECD}'),
        0x4839 => Some('\u{6ECE}'),
        0x483A => Some('\u{6ECF}'),
        0x483B => Some('\u{6EEB}'),
        0x483C => Some('\u{6EED}'),
        0x483D => Some('\u{6EEE}'),
        0x483E => Some('\u{6EF9}'),
        0x483F => Some('\u{6EFB}'),
        0x4840 => Some('\u{6EFD}'),
        0x4841 => Some('\u{6F04}'),
        0x4842 => Some('\u{6F08}'),
        0x4843 => Some('\u{6F0A}'),
        0x4844 => Some('\u{6F0C}'),
        0x4845 => Some('\u{6F0D}'),
        0x4846 => Some('\u{6F16}'),
        0x4847 => Some('\u{6F18}'),
        0x4848 => Some('\u{6F1A}'),
        0x4849 => Some('\u{6F1B}'),
        0x484A => Some('\u{6F26}'),
        0x484B => Some('\u{6F29}'),
        0x484C => Some('\u{6F2A}'),
        0x4853 => Some('\u{6F2D}'),
        0x484D => Some('\u{6F2F}'),
        0x484E => Some('\u{6F30}'),
        0x484F => Some('\u{6F33}'),
        0x4850 => Some('\u{6F36}'),
        0x4851 => Some('\u{6F3B}'),
        0x4852 => Some('\u{6F3C}'),
        0x4854 => Some('\u{6F4F}'),
        0x4855 => Some('\u{6F51}'),
        0x4856 => Some('\u{6F52}'),
        0x4857 => Some('\u{6F53}'),
        0x4858 => Some('\u{6F57}'),
        0x4859 => Some('\u{6F59}'),
        0x485A => Some('\u{6F5A}'),
        0x485B => Some('\u{6F5D}'),
        0x485C => Some('\u{6F5E}'),
        0x485D => Some('\u{6F61}'),
        0x485E => Some('\u{6F62}'),
        0x485F => Some('\u{6F68}'),
        0x4860 => Some('\u{6F6C}'),
        0x4861 => Some('\u{6F7D}'),
        0x4862 => Some('\u{6F7E}'),
        0x4863 => Some('\u{6F83}'),
        0x4864 => Some('\u{6F87}'),
        0x4865 => Some('\u{6F88}'),
        0x4866 => Some('\u{6F8B}'),
        0x4867 => Some('\u{6F8C}'),
        0x4868 => Some('\u{6F8D}'),
        0x4869 => Some('\u{6F90}'),
        0x486A => Some('\u{6F92}'),
        0x486B => Some('\u{6F93}'),
        0x486C => Some('\u{6F94}'),
        0x486D => Some('\u{6F96}'),
        0x486E => Some('\u{6F9A}'),
        0x486F => Some('\u{6F9F}'),
        0x4870 => Some('\u{6FA0}'),
        0x4871 => Some('\u{6FA5}'),
        0x4872 => Some('\u{6FA6}'),
        0x4873 => Some('\u{6FA7}'),
        0x4874 => Some('\u{6FA8}'),
        0x4875 => Some('\u{6FAE}'),
        0x4876 => Some('\u{6FAF}'),
        0x4877 => Some('\u{6FB0}'),
        0x4878 => Some('\u{6FB5}'),
        0x4879 => Some('\u{6FB6}'),
        0x487A => Some('\u{6FBC}'),
        0x487B => Some('\u{6FC5}'),
        0x487C => Some('\u{6FC7}'),
        0x487D => Some('\u{6FC8}'),
        0x487E => Some('\u{6FCA}'),
        0x4921 => Some('\u{6FDA}'),
        0x4922 => Some('\u{6FDE}'),
        0x4923 => Some('\u{6FE8}'),
        0x4924 => Some('\u{6FE9}'),
        0x4925 => Some('\u{6FF0}'),
        0x4926 => Some('\u{6FF5}'),
        0x4927 => Some('\u{6FF9}'),
        0x4928 => Some('\u{6FFC}'),
        0x4929 => Some('\u{6FFD}'),
        0x492A => Some('\u{7000}'),
        0x492B => Some('\u{7005}'),
        0x492C => Some('\u{7006}'),
        0x492D => Some('\u{7007}'),
        0x492E => Some('\u{700D}'),
        0x492F => Some('\u{7017}'),
        0x4930 => Some('\u{7020}'),
        0x4931 => Some('\u{7023}'),
        0x4932 => Some('\u{702F}'),
        0x4933 => Some('\u{7034}'),
        0x4934 => Some('\u{7037}'),
        0x4935 => Some('\u{7039}'),
        0x4936 => Some('\u{703C}'),
        0x4937 => Some('\u{7043}'),
        0x4938 => Some('\u{7044}'),
        0x4939 => Some('\u{7048}'),
        0x493A => Some('\u{7049}'),
        0x493B => Some('\u{704A}'),
        0x493C => Some('\u{704B}'),
        0x4941 => Some('\u{704E}'),
        0x493D => Some('\u{7054}'),
        0x493E => Some('\u{7055}'),
        0x493F => Some('\u{705D}'),
        0x4940 => Some('\u{705E}'),
        0x4942 => Some('\u{7064}'),
        0x4943 => Some('\u{7065}'),
        0x4944 => Some('\u{706C}'),
        0x4945 => Some('\u{706E}'),
        0x4946 => Some('\u{7075}'),
        0x4947 => Some('\u{7076}'),
        0x4948 => Some('\u{707E}'),
        0x4949 => Some('\u{7081}'),
        0x494A => Some('\u{7085}'),
        0x494B => Some('\u{7086}'),
        0x494C => Some('\u{7094}'),
        0x494D => Some('\u{7095}'),
        0x494E => Some('\u{7096}'),
        0x494F => Some('\u{7097}'),
        0x4950 => Some('\u{7098}'),
        0x4951 => Some('\u{709B}'),
        0x4952 => Some('\u{70A4}'),
        0x4953 => Some('\u{70AB}'),
        0x4954 => Some('\u{70B0}'),
        0x4955 => Some('\u{70B1}'),
        0x4956 => Some('\u{70B4}'),
        0x4957 => Some('\u{70B7}'),
        0x4958 => Some('\u{70CA}'),
        0x4959 => Some('\u{70D1}'),
        0x495A => Some('\u{70D3}'),
        0x495B => Some('\u{70D4}'),
        0x495C => Some('\u{70D5}'),
        0x495D => Some('\u{70D6}'),
        0x495E => Some('\u{70D8}'),
        0x495F => Some('\u{70DC}'),
        0x4960 => Some('\u{70E4}'),
        0x4961 => Some('\u{70FA}'),
        0x4962 => Some('\u{7103}'),
        0x4963 => Some('\u{7104}'),
        0x4964 => Some('\u{7105}'),
        0x4965 => Some('\u{7106}'),
        0x4966 => Some('\u{7107}'),
        0x4967 => Some('\u{710B}'),
        0x4968 => Some('\u{710C}'),
        0x4969 => Some('\u{710F}'),
        0x496A => Some('\u{711E}'),
        0x496B => Some('\u{7120}'),
        0x496C => Some('\u{712B}'),
        0x496D => Some('\u{712D}'),
        0x496E => Some('\u{712F}'),
        0x496F => Some('\u{7130}'),
        0x4970 => Some('\u{7131}'),
        0x4971 => Some('\u{7138}'),
        0x4972 => Some('\u{7141}'),
        0x4973 => Some('\u{7145}'),
        0x4974 => Some('\u{7146}'),
        0x4975 => Some('\u{7147}'),
        0x4976 => Some('\u{714A}'),
        0x4977 => Some('\u{714B}'),
        0x4978 => Some('\u{7150}'),
        0x4979 => Some('\u{7152}'),
        0x497A => Some('\u{7157}'),
        0x497B => Some('\u{715A}'),
        0x497C => Some('\u{715C}'),
        0x497D => Some('\u{715E}'),
        0x497E => Some('\u{7160}'),
        0x4A21 => Some('\u{7168}'),
        0x4A22 => Some('\u{7179}'),
        0x4A23 => Some('\u{7180}'),
        0x4A24 => Some('\u{7185}'),
        0x4A25 => Some('\u{7187}'),
        0x4A26 => Some('\u{718C}'),
        0x4A27 => Some('\u{7192}'),
        0x4A28 => Some('\u{719A}'),
        0x4A29 => Some('\u{719B}'),
        0x4A2A => Some('\u{71A0}'),
        0x4A2B => Some('\u{71A2}'),
        0x4A2C => Some('\u{71AF}'),
        0x4A2D => Some('\u{71B0}'),
        0x4A2E => Some('\u{71B2}'),
        0x4A2F => Some('\u{71B3}'),
        0x4A30 => Some('\u{71BA}'),
        0x4A31 => Some('\u{71BF}'),
        0x4A32 => Some('\u{71C0}'),
        0x4A33 => Some('\u{71C1}'),
        0x4A34 => Some('\u{71C4}'),
        0x4A35 => Some('\u{71CB}'),
        0x4A36 => Some('\u{71CC}'),
        0x4A37 => Some('\u{71D3}'),
        0x4A38 => Some('\u{71D6}'),
        0x4A39 => Some('\u{71D9}'),
        0x4A3A => Some('\u{71DA}'),
        0x4A3B => Some('\u{71DC}'),
        0x4A3C => Some('\u{71F8}'),
        0x4A3D => Some('\u{71FE}'),
        0x4A3E => Some('\u{7200}'),
        0x4A3F => Some('\u{7207}'),
        0x4A40 => Some('\u{7208}'),
        0x4A41 => Some('\u{7209}'),
        0x4A42 => Some('\u{7213}'),
        0x4A43 => Some('\u{7217}'),
        0x4A44 => Some('\u{721A}'),
        0x4A45 => Some('\u{721D}'),
        0x4A46 => Some('\u{721F}'),
        0x4A47 => Some('\u{7224}'),
        0x4A48 => Some('\u{722B}'),
        0x4A49 => Some('\u{722F}'),
        0x4A4A => Some('\u{7234}'),
        0x4A4B => Some('\u{7238}'),
        0x4A4C => Some('\u{7239}'),
        0x4A4D => Some('\u{7241}'),
        0x4A4E => Some('\u{7242}'),
        0x4A4F => Some('\u{7243}'),
        0x4A50 => Some('\u{7245}'),
        0x4A51 => Some('\u{724E}'),
        0x4A52 => Some('\u{724F}'),
        0x4A53 => Some('\u{7250}'),
        0x4A54 => Some('\u{7253}'),
        0x4A55 => Some('\u{7255}'),
        0x4A56 => Some('\u{7256}'),
        0x4A57 => Some('\u{725A}'),
        0x4A58 => Some('\u{725C}'),
        0x4A59 => Some('\u{725E}'),
        0x4A5A => Some('\u{7260}'),
        0x4A5B => Some('\u{7263}'),
        0x4A5C => Some('\u{7268}'),
        0x4A5D => Some('\u{726B}'),
        0x4A5E => Some('\u{726E}'),
        0x4A5F => Some('\u{726F}'),
        0x4A60 => Some('\u{7271}'),
        0x4A61 => Some('\u{7277}'),
        0x4A62 => Some('\u{7278}'),
        0x4A63 => Some('\u{727B}'),
        0x4A64 => Some('\u{727C}'),
        0x4A65 => Some('\u{727F}'),
        0x4A66 => Some('\u{7284}'),
        0x4A67 => Some('\u{7289}'),
        0x4A68 => Some('\u{728D}'),
        0x4A69 => Some('\u{728E}'),
        0x4A6A => Some('\u{7293}'),
        0x4A6B => Some('\u{729B}'),
        0x4A6C => Some('\u{72A8}'),
        0x4A6D => Some('\u{72AD}'),
        0x4A6E => Some('\u{72AE}'),
        0x4A6F => Some('\u{72B1}'),
        0x4A70 => Some('\u{72B4}'),
        0x4A71 => Some('\u{72BE}'),
        0x4A72 => Some('\u{72C1}'),
        0x4A73 => Some('\u{72C7}'),
        0x4A74 => Some('\u{72C9}'),
        0x4A75 => Some('\u{72CC}'),
        0x4A76 => Some('\u{72D5}'),
        0x4A77 => Some('\u{72D6}'),
        0x4A78 => Some('\u{72D8}'),
        0x4A79 => Some('\u{72DF}'),
        0x4A7A => Some('\u{72E5}'),
        0x4A7B => Some('\u{72F3}'),
        0x4A7C => Some('\u{72F4}'),
        0x4A7D => Some('\u{72FA}'),
        0x4A7E => Some('\u{72FB}'),
        0x4B21 => Some('\u{72FE}'),
        0x4B22 => Some('\u{7302}'),
        0x4B23 => Some('\u{7304}'),
        0x4B24 => Some('\u{7305}'),
        0x4B25 => Some('\u{7307}'),
        0x4B26 => Some('\u{730B}'),
        0x4B27 => Some('\u{730D}'),
        0x4B28 => Some('\u{7312}'),
        0x4B29 => Some('\u{7313}'),
        0x4B2A => Some('\u{7318}'),
        0x4B2B => Some('\u{7319}'),
        0x4B2C => Some('\u{731E}'),
        0x4B2D => Some('\u{7322}'),
        0x4B2E => Some('\u{7324}'),
        0x4B2F => Some('\u{7327}'),
        0x4B30 => Some('\u{7328}'),
        0x4B31 => Some('\u{732C}'),
        0x4B32 => Some('\u{7331}'),
        0x4B33 => Some('\u{7332}'),
        0x4B34 => Some('\u{7335}'),
        0x4B35 => Some('\u{733A}'),
        0x4B36 => Some('\u{733B}'),
        0x4B37 => Some('\u{733D}'),
        0x4B38 => Some('\u{7343}'),
        0x4B39 => Some('\u{734D}'),
        0x4B3A => Some('\u{7350}'),
        0x4B3B => Some('\u{7352}'),
        0x4B3C => Some('\u{7356}'),
        0x4B3D => Some('\u{7358}'),
        0x4B3E => Some('\u{735D}'),
        0x4B3F => Some('\u{735E}'),
        0x4B40 => Some('\u{735F}'),
        0x4B41 => Some('\u{7360}'),
        0x4B42 => Some('\u{7366}'),
        0x4B43 => Some('\u{7367}'),
        0x4B44 => Some('\u{7369}'),
        0x4B45 => Some('\u{736B}'),
        0x4B46 => Some('\u{736C}'),
        0x4B47 => Some('\u{736E}'),
        0x4B48 => Some('\u{736F}'),
        0x4B49 => Some('\u{7371}'),
        0x4B4A => Some('\u{7377}'),
        0x4B4B => Some('\u{7379}'),
        0x4B4C => Some('\u{737C}'),
        0x4B4D => Some('\u{7380}'),
        0x4B4E => Some('\u{7381}'),
        0x4B4F => Some('\u{7383}'),
        0x4B50 => Some('\u{7385}'),
        0x4B51 => Some('\u{7386}'),
        0x4B52 => Some('\u{738E}'),
        0x4B53 => Some('\u{7390}'),
        0x4B54 => Some('\u{7393}'),
        0x4B55 => Some('\u{7395}'),
        0x4B56 => Some('\u{7397}'),
        0x4B57 => Some('\u{7398}'),
        0x4B58 => Some('\u{739C}'),
        0x4B59 => Some('\u{739E}'),
        0x4B5A => Some('\u{739F}'),
        0x4B5B => Some('\u{73A0}'),
        0x4B5C => Some('\u{73A2}'),
        0x4B5D => Some('\u{73A5}'),
        0x4B5E => Some('\u{73A6}'),
        0x4B5F => Some('\u{73AA}'),
        0x4B60 => Some('\u{73AB}'),
        0x4B61 => Some('\u{73AD}'),
        0x4B62 => Some('\u{73B5}'),
        0x4B63 => Some('\u{73B7}'),
        0x4B64 => Some('\u{73B9}'),
        0x4B65 => Some('\u{73BC}'),
        0x4B66 => Some('\u{73BD}'),
        0x4B67 => Some('\u{73BF}'),
        0x4B68 => Some('\u{73C5}'),
        0x4B69 => Some('\u{73C6}'),
        0x4B6A => Some('\u{73C9}'),
        0x4B6B => Some('\u{73CB}'),
        0x4B6C => Some('\u{73CC}'),
        0x4B6D => Some('\u{73CF}'),
        0x4B6E => Some('\u{73D2}'),
        0x4B6F => Some('\u{73D3}'),
        0x4B70 => Some('\u{73D6}'),
        0x4B71 => Some('\u{73D9}'),
        0x4B72 => Some('\u{73DD}'),
        0x4B73 => Some('\u{73E1}'),
        0x4B74 => Some('\u{73E3}'),
        0x4B75 => Some('\u{73E6}'),
        0x4B76 => Some('\u{73E7}'),
        0x4B77 => Some('\u{73E9}'),
        0x4B78 => Some('\u{73F4}'),
        0x4B79 => Some('\u{73F5}'),
        0x4B7A => Some('\u{73F7}'),
        0x4B7B => Some('\u{73F9}'),
        0x4B7C => Some('\u{73FA}'),
        0x4B7D => Some('\u{73FB}'),
        0x4B7E => Some('\u{73FD}'),
        0x4C21 => Some('\u{73FF}'),
        0x4C22 => Some('\u{7400}'),
        0x4C23 => Some('\u{7401}'),
        0x4C24 => Some('\u{7404}'),
        0x4C25 => Some('\u{7407}'),
        0x4C26 => Some('\u{740A}'),
        0x4C27 => Some('\u{7411}'),
        0x4C28 => Some('\u{741A}'),
        0x4C29 => Some('\u{741B}'),
        0x4C2A => Some('\u{7424}'),
        0x4C2B => Some('\u{7426}'),
        0x4C2C => Some('\u{7428}'),
        0x4C2D => Some('\u{7429}'),
        0x4C2E => Some('\u{742A}'),
        0x4C2F => Some('\u{742B}'),
        0x4C30 => Some('\u{742C}'),
        0x4C31 => Some('\u{742D}'),
        0x4C32 => Some('\u{742E}'),
        0x4C33 => Some('\u{742F}'),
        0x4C34 => Some('\u{7430}'),
        0x4C35 => Some('\u{7431}'),
        0x4C36 => Some('\u{7439}'),
        0x4C37 => Some('\u{7440}'),
        0x4C38 => Some('\u{7443}'),
        0x4C39 => Some('\u{7444}'),
        0x4C3A => Some('\u{7446}'),
        0x4C3B => Some('\u{7447}'),
        0x4C3C => Some('\u{744B}'),
        0x4C3D => Some('\u{744D}'),
        0x4C3E => Some('\u{7451}'),
        0x4C3F => Some('\u{7452}'),
        0x4C40 => Some('\u{7457}'),
        0x4C41 => Some('\u{745D}'),
        0x4C42 => Some('\u{7462}'),
        0x4C43 => Some('\u{7466}'),
        0x4C44 => Some('\u{7467}'),
        0x4C45 => Some('\u{7468}'),
        0x4C46 => Some('\u{746B}'),
        0x4C47 => Some('\u{746D}'),
        0x4C48 => Some('\u{746E}'),
        0x4C49 => Some('\u{7471}'),
        0x4C4A => Some('\u{7472}'),
        0x4C4B => Some('\u{7480}'),
        0x4C4C => Some('\u{7481}'),
        0x4C4D => Some('\u{7485}'),
        0x4C4E => Some('\u{7486}'),
        0x4C4F => Some('\u{7487}'),
        0x4C50 => Some('\u{7489}'),
        0x4C51 => Some('\u{748F}'),
        0x4C52 => Some('\u{7490}'),
        0x4C53 => Some('\u{7491}'),
        0x4C54 => Some('\u{7492}'),
        0x4C55 => Some('\u{7498}'),
        0x4C56 => Some('\u{7499}'),
        0x4C57 => Some('\u{749A}'),
        0x4C58 => Some('\u{749C}'),
        0x4C59 => Some('\u{749F}'),
        0x4C5A => Some('\u{74A0}'),
        0x4C5B => Some('\u{74A1}'),
        0x4C5C => Some('\u{74A3}'),
        0x4C5D => Some('\u{74A6}'),
        0x4C5E => Some('\u{74A8}'),
        0x4C5F => Some('\u{74A9}'),
        0x4C60 => Some('\u{74AA}'),
        0x4C61 => Some('\u{74AB}'),
        0x4C62 => Some('\u{74AE}'),
        0x4C63 => Some('\u{74AF}'),
        0x4C64 => Some('\u{74B1}'),
        0x4C65 => Some('\u{74B2}'),
        0x4C66 => Some('\u{74B5}'),
        0x4C67 => Some('\u{74B9}'),
        0x4C68 => Some('\u{74BB}'),
        0x4C69 => Some('\u{74BF}'),
        0x4C6A => Some('\u{74C8}'),
        0x4C6B => Some('\u{74C9}'),
        0x4C6C => Some('\u{74CC}'),
        0x4C6D => Some('\u{74D0}'),
        0x4C6E => Some('\u{74D3}'),
        0x4C6F => Some('\u{74D8}'),
        0x4C70 => Some('\u{74DA}'),
        0x4C71 => Some('\u{74DB}'),
        0x4C72 => Some('\u{74DE}'),
        0x4C73 => Some('\u{74DF}'),
        0x4C74 => Some('\u{74E4}'),
        0x4C75 => Some('\u{74E8}'),
        0x4C76 => Some('\u{74EA}'),
        0x4C77 => Some('\u{74EB}'),
        0x4C78 => Some('\u{74EF}'),
        0x4C79 => Some('\u{74F4}'),
        0x4C7A => Some('\u{74FA}'),
        0x4C7B => Some('\u{74FB}'),
        0x4C7C => Some('\u{74FC}'),
        0x4C7D => Some('\u{74FF}'),
        0x4C7E => Some('\u{7506}'),
        0x4D21 => Some('\u{7512}'),
        0x4D22 => Some('\u{7516}'),
        0x4D23 => Some('\u{7517}'),
        0x4D24 => Some('\u{7520}'),
        0x4D25 => Some('\u{7521}'),
        0x4D26 => Some('\u{7524}'),
        0x4D27 => Some('\u{7527}'),
        0x4D28 => Some('\u{7529}'),
        0x4D29 => Some('\u{752A}'),
        0x4D2A => Some('\u{752F}'),
        0x4D2B => Some('\u{7536}'),
        0x4D2C => Some('\u{7539}'),
        0x4D2D => Some('\u{753D}'),
        0x4D2E => Some('\u{753E}'),
        0x4D2F => Some('\u{753F}'),
        0x4D30 => Some('\u{7540}'),
        0x4D31 => Some('\u{7543}'),
        0x4D32 => Some('\u{7547}'),
        0x4D33 => Some('\u{7548}'),
        0x4D34 => Some('\u{754E}'),
        0x4D35 => Some('\u{7550}'),
        0x4D36 => Some('\u{7552}'),
        0x4D37 => Some('\u{7557}'),
        0x4D38 => Some('\u{755E}'),
        0x4D39 => Some('\u{755F}'),
        0x4D3A => Some('\u{7561}'),
        0x4D3B => Some('\u{756F}'),
        0x4D3C => Some('\u{7571}'),
        0x4D3D => Some('\u{7579}'),
        0x4D3E => Some('\u{757A}'),
        0x4D3F => Some('\u{757B}'),
        0x4D40 => Some('\u{757C}'),
        0x4D41 => Some('\u{757D}'),
        0x4D42 => Some('\u{757E}'),
        0x4D43 => Some('\u{7581}'),
        0x4D44 => Some('\u{7585}'),
        0x4D45 => Some('\u{7590}'),
        0x4D46 => Some('\u{7592}'),
        0x4D47 => Some('\u{7593}'),
        0x4D48 => Some('\u{7595}'),
        0x4D49 => Some('\u{7599}'),
        0x4D4A => Some('\u{759C}'),
        0x4D4B => Some('\u{75A2}'),
        0x4D4C => Some('\u{75A4}'),
        0x4D4D => Some('\u{75B4}'),
        0x4D4E => Some('\u{75BA}'),
        0x4D4F => Some('\u{75BF}'),
        0x4D50 => Some('\u{75C0}'),
        0x4D51 => Some('\u{75C1}'),
        0x4D52 => Some('\u{75C4}'),
        0x4D53 => Some('\u{75C6}'),
        0x4D54 => Some('\u{75CC}'),
        0x4D55 => Some('\u{75CE}'),
        0x4D56 => Some('\u{75CF}'),
        0x4D57 => Some('\u{75D7}'),
        0x4D58 => Some('\u{75DC}'),
        0x4D59 => Some('\u{75DF}'),
        0x4D5A => Some('\u{75E0}'),
        0x4D5B => Some('\u{75E1}'),
        0x4D5C => Some('\u{75E4}'),
        0x4D5D => Some('\u{75E7}'),
        0x4D5E => Some('\u{75EC}'),
        0x4D5F => Some('\u{75EE}'),
        0x4D60 => Some('\u{75EF}'),
        0x4D61 => Some('\u{75F1}'),
        0x4D62 => Some('\u{75F9}'),
        0x4D63 => Some('\u{7600}'),
        0x4D64 => Some('\u{7602}'),
        0x4D65 => Some('\u{7603}'),
        0x4D66 => Some('\u{7604}'),
        0x4D67 => Some('\u{7607}'),
        0x4D68 => Some('\u{7608}'),
        0x4D69 => Some('\u{760A}'),
        0x4D6A => Some('\u{760C}'),
        0x4D6B => Some('\u{760F}'),
        0x4D6C => Some('\u{7612}'),
        0x4D6D => Some('\u{7613}'),
        0x4D6E => Some('\u{7615}'),
        0x4D6F => Some('\u{7616}'),
        0x4D70 => Some('\u{7619}'),
        0x4D71 => Some('\u{761B}'),
        0x4D72 => Some('\u{761C}'),
        0x4D73 => Some('\u{761D}'),
        0x4D74 => Some('\u{761E}'),
        0x4D75 => Some('\u{7623}'),
        0x4D76 => Some('\u{7625}'),
        0x4D77 => Some('\u{7626}'),
        0x4D78 => Some('\u{7629}'),
        0x4D79 => Some('\u{762D}'),
        0x4D7A => Some('\u{7632}'),
        0x4D7B => Some('\u{7633}'),
        0x4D7C => Some('\u{7635}'),
        0x4D7D => Some('\u{7638}'),
        0x4D7E => Some('\u{7639}'),
        0x4E21 => Some('\u{763A}'),
        0x4E22 => Some('\u{763C}'),
        0x4E24 => Some('\u{7640}'),
        0x4E25 => Some('\u{7641}'),
        0x4E26 => Some('\u{7643}'),
        0x4E27 => Some('\u{7644}'),
        0x4E28 => Some('\u{7645}'),
        0x4E29 => Some('\u{7649}'),
        0x4E23 => Some('\u{764A}'),
        0x4E2A => Some('\u{764B}'),
        0x4E2B => Some('\u{7655}'),
        0x4E2C => Some('\u{7659}'),
        0x4E2D => Some('\u{765F}'),
        0x4E2E => Some('\u{7664}'),
        0x4E2F => Some('\u{7665}'),
        0x4E30 => Some('\u{766D}'),
        0x4E31 => Some('\u{766E}'),
        0x4E32 => Some('\u{766F}'),
        0x4E33 => Some('\u{7671}'),
        0x4E34 => Some('\u{7674}'),
        0x4E35 => Some('\u{7681}'),
        0x4E36 => Some('\u{7685}'),
        0x4E37 => Some('\u{768C}'),
        0x4E38 => Some('\u{768D}'),
        0x4E39 => Some('\u{7695}'),
        0x4E3A => Some('\u{769B}'),
        0x4E3B => Some('\u{769C}'),
        0x4E3C => Some('\u{769D}'),
        0x4E3D => Some('\u{769F}'),
        0x4E3E => Some('\u{76A0}'),
        0x4E3F => Some('\u{76A2}'),
        0x4E40 => Some('\u{76A3}'),
        0x4E41 => Some('\u{76A4}'),
        0x4E42 => Some('\u{76A5}'),
        0x4E43 => Some('\u{76A6}'),
        0x4E44 => Some('\u{76A7}'),
        0x4E45 => Some('\u{76A8}'),
        0x4E46 => Some('\u{76AA}'),
        0x4E47 => Some('\u{76AD}'),
        0x4E48 => Some('\u{76BD}'),
        0x4E49 => Some('\u{76C1}'),
        0x4E4A => Some('\u{76C5}'),
        0x4E4B => Some('\u{76C9}'),
        0x4E4C => Some('\u{76CB}'),
        0x4E4D => Some('\u{76CC}'),
        0x4E4E => Some('\u{76CE}'),
        0x4E4F => Some('\u{76D4}'),
        0x4E50 => Some('\u{76D9}'),
        0x4E51 => Some('\u{76E0}'),
        0x4E52 => Some('\u{76E6}'),
        0x4E53 => Some('\u{76E8}'),
        0x4E54 => Some('\u{76EC}'),
        0x4E55 => Some('\u{76F0}'),
        0x4E56 => Some('\u{76F1}'),
        0x4E57 => Some('\u{76F6}'),
        0x4E58 => Some('\u{76F9}'),
        0x4E59 => Some('\u{76FC}'),
        0x4E5A => Some('\u{7700}'),
        0x4E5B => Some('\u{7706}'),
        0x4E5C => Some('\u{770A}'),
        0x4E5D => Some('\u{770E}'),
        0x4E5E => Some('\u{7712}'),
        0x4E5F => Some('\u{7714}'),
        0x4E60 => Some('\u{7715}'),
        0x4E61 => Some('\u{7717}'),
        0x4E62 => Some('\u{7719}'),
        0x4E63 => Some('\u{771A}'),
        0x4E64 => Some('\u{771C}'),
        0x4E65 => Some('\u{7722}'),
        0x4E66 => Some('\u{7728}'),
        0x4E67 => Some('\u{772D}'),
        0x4E68 => Some('\u{772E}'),
        0x4E69 => Some('\u{772F}'),
        0x4E6A => Some('\u{7734}'),
        0x4E6B => Some('\u{7735}'),
        0x4E6C => Some('\u{7736}'),
        0x4E6D => Some('\u{7739}'),
        0x4E6E => Some('\u{773D}'),
        0x4E6F => Some('\u{773E}'),
        0x4E70 => Some('\u{7742}'),
        0x4E71 => Some('\u{7745}'),
        0x4E72 => Some('\u{7746}'),
        0x4E73 => Some('\u{774A}'),
        0x4E74 => Some('\u{774D}'),
        0x4E75 => Some('\u{774E}'),
        0x4E76 => Some('\u{774F}'),
        0x4E77 => Some('\u{7752}'),
        0x4E78 => Some('\u{7756}'),
        0x4E79 => Some('\u{7757}'),
        0x4E7A => Some('\u{775C}'),
        0x4E7B => Some('\u{775E}'),
        0x4E7C => Some('\u{775F}'),
        0x4E7D => Some('\u{7760}'),
        0x4E7E => Some('\u{7762}'),
        0x4F21 => Some('\u{7764}'),
        0x4F22 => Some('\u{7767}'),
        0x4F23 => Some('\u{776A}'),
        0x4F24 => Some('\u{776C}'),
        0x4F25 => Some('\u{7770}'),
        0x4F26 => Some('\u{7772}'),
        0x4F27 => Some('\u{7773}'),
        0x4F28 => Some('\u{7774}'),
        0x4F29 => Some('\u{777A}'),
        0x4F2A => Some('\u{777D}'),
        0x4F2B => Some('\u{7780}'),
        0x4F2C => Some('\u{7784}'),
        0x4F2D => Some('\u{778C}'),
        0x4F2E => Some('\u{778D}'),
        0x4F2F => Some('\u{7794}'),
        0x4F30 => Some('\u{7795}'),
        0x4F31 => Some('\u{7796}'),
        0x4F32 => Some('\u{779A}'),
        0x4F33 => Some('\u{779F}'),
        0x4F34 => Some('\u{77A2}'),
        0x4F35 => Some('\u{77A7}'),
        0x4F36 => Some('\u{77AA}'),
        0x4F37 => Some('\u{77AE}'),
        0x4F38 => Some('\u{77AF}'),
        0x4F39 => Some('\u{77B1}'),
        0x4F3A => Some('\u{77B5}'),
        0x4F3B => Some('\u{77BE}'),
        0x4F3C => Some('\u{77C3}'),
        0x4F3D => Some('\u{77C9}'),
        0x4F3E => Some('\u{77D1}'),
        0x4F3F => Some('\u{77D2}'),
        0x4F40 => Some('\u{77D5}'),
        0x4F41 => Some('\u{77D9}'),
        0x4F42 => Some('\u{77DE}'),
        0x4F43 => Some('\u{77DF}'),
        0x4F44 => Some('\u{77E0}'),
        0x4F45 => Some('\u{77E4}'),
        0x4F46 => Some('\u{77E6}'),
        0x4F47 => Some('\u{77EA}'),
        0x4F48 => Some('\u{77EC}'),
        0x4F49 => Some('\u{77F0}'),
        0x4F4A => Some('\u{77F1}'),
        0x4F4B => Some('\u{77F4}'),
        0x4F4C => Some('\u{77F8}'),
        0x4F4D => Some('\u{77FB}'),
        0x4F4E => Some('\u{7805}'),
        0x4F4F => Some('\u{7806}'),
        0x4F50 => Some('\u{7809}'),
        0x4F51 => Some('\u{780D}'),
        0x4F52 => Some('\u{780E}'),
        0x4F53 => Some('\u{7811}'),
        0x4F54 => Some('\u{781D}'),
        0x4F55 => Some('\u{7821}'),
        0x4F56 => Some('\u{7822}'),
        0x4F57 => Some('\u{7823}'),
        0x4F58 => Some('\u{782D}'),
        0x4F59 => Some('\u{782E}'),
        0x4F5A => Some('\u{7830}'),
        0x4F5B => Some('\u{7835}'),
        0x4F5C => Some('\u{7837}'),
        0x4F5D => Some('\u{7843}'),
        0x4F5E => Some('\u{7844}'),
        0x4F5F => Some('\u{7847}'),
        0x4F60 => Some('\u{7848}'),
        0x4F61 => Some('\u{784C}'),
        0x4F62 => Some('\u{784E}'),
        0x4F63 => Some('\u{7852}'),
        0x4F64 => Some('\u{785C}'),
        0x4F65 => Some('\u{785E}'),
        0x4F66 => Some('\u{7860}'),
        0x4F67 => Some('\u{7861}'),
        0x4F68 => Some('\u{7863}'),
        0x4F69 => Some('\u{7864}'),
        0x4F6A => Some('\u{7868}'),
        0x4F6B => Some('\u{786A}'),
        0x4F6C => Some('\u{786E}'),
        0x4F6D => Some('\u{787A}'),
        0x4F6E => Some('\u{787E}'),
        0x4F6F => Some('\u{788A}'),
        0x4F70 => Some('\u{788F}'),
        0x4F71 => Some('\u{7894}'),
        0x4F72 => Some('\u{7898}'),
        0x4F74 => Some('\u{789D}'),
        0x4F75 => Some('\u{789E}'),
        0x4F76 => Some('\u{789F}'),
        0x4F73 => Some('\u{78A1}'),
        0x4F77 => Some('\u{78A4}'),
        0x4F78 => Some('\u{78A8}'),
        0x4F79 => Some('\u{78AC}'),
        0x4F7A => Some('\u{78AD}'),
        0x4F7B => Some('\u{78B0}'),
        0x4F7C => Some('\u{78B1}'),
        0x4F7D => Some('\u{78B2}'),
        0x4F7E => Some('\u{78B3}'),
        0x5021 => Some('\u{78BB}'),
        0x5022 => Some('\u{78BD}'),
        0x5023 => Some('\u{78BF}'),
        0x5024 => Some('\u{78C7}'),
        0x5025 => Some('\u{78C8}'),
        0x5026 => Some('\u{78C9}'),
        0x5027 => Some('\u{78CC}'),
        0x5028 => Some('\u{78CE}'),
        0x5029 => Some('\u{78D2}'),
        0x502A => Some('\u{78D3}'),
        0x502B => Some('\u{78D5}'),
        0x502C => Some('\u{78D6}'),
        0x502E => Some('\u{78DB}'),
        0x502F => Some('\u{78DF}'),
        0x5030 => Some('\u{78E0}'),
        0x5031 => Some('\u{78E1}'),
        0x502D => Some('\u{78E4}'),
        0x5032 => Some('\u{78E6}'),
        0x5033 => Some('\u{78EA}'),
        0x5034 => Some('\u{78F2}'),
        0x5035 => Some('\u{78F3}'),
        0x5037 => Some('\u{78F6}'),
        0x5038 => Some('\u{78F7}'),
        0x5039 => Some('\u{78FA}'),
        0x503A => Some('\u{78FB}'),
        0x503B => Some('\u{78FF}'),
        0x5036 => Some('\u{7900}'),
        0x503C => Some('\u{7906}'),
        0x503D => Some('\u{790C}'),
        0x503E => Some('\u{7910}'),
        0x503F => Some('\u{791A}'),
        0x5040 => Some('\u{791C}'),
        0x5041 => Some('\u{791E}'),
        0x5042 => Some('\u{791F}'),
        0x5043 => Some('\u{7920}'),
        0x5044 => Some('\u{7925}'),
        0x5045 => Some('\u{7927}'),
        0x5046 => Some('\u{7929}'),
        0x5047 => Some('\u{792D}'),
        0x5048 => Some('\u{7931}'),
        0x5049 => Some('\u{7934}'),
        0x504A => Some('\u{7935}'),
        0x504B => Some('\u{793B}'),
        0x504C => Some('\u{793D}'),
        0x504D => Some('\u{793F}'),
        0x504E => Some('\u{7944}'),
        0x504F => Some('\u{7945}'),
        0x5050 => Some('\u{7946}'),
        0x5051 => Some('\u{794A}'),
        0x5052 => Some('\u{794B}'),
        0x5053 => Some('\u{794F}'),
        0x5054 => Some('\u{7951}'),
        0x5055 => Some('\u{7954}'),
        0x5056 => Some('\u{7958}'),
        0x5057 => Some('\u{795B}'),
        0x5058 => Some('\u{795C}'),
        0x5059 => Some('\u{7967}'),
        0x505A => Some('\u{7969}'),
        0x505B => Some('\u{796B}'),
        0x505C => Some('\u{7972}'),
        0x505D => Some('\u{7979}'),
        0x505E => Some('\u{797B}'),
        0x505F => Some('\u{797C}'),
        0x5060 => Some('\u{797E}'),
        0x5061 => Some('\u{798B}'),
        0x5062 => Some('\u{798C}'),
        0x5063 => Some('\u{7991}'),
        0x5064 => Some('\u{7993}'),
        0x5065 => Some('\u{7994}'),
        0x5066 => Some('\u{7995}'),
        0x5067 => Some('\u{7996}'),
        0x5068 => Some('\u{7998}'),
        0x5069 => Some('\u{799B}'),
        0x506A => Some('\u{799C}'),
        0x506B => Some('\u{79A1}'),
        0x506C => Some('\u{79A8}'),
        0x506D => Some('\u{79A9}'),
        0x506E => Some('\u{79AB}'),
        0x506F => Some('\u{79AF}'),
        0x5070 => Some('\u{79B1}'),
        0x5071 => Some('\u{79B4}'),
        0x5072 => Some('\u{79B8}'),
        0x5073 => Some('\u{79BB}'),
        0x5074 => Some('\u{79C2}'),
        0x5075 => Some('\u{79C4}'),
        0x5076 => Some('\u{79C7}'),
        0x5077 => Some('\u{79C8}'),
        0x5078 => Some('\u{79CA}'),
        0x5079 => Some('\u{79CF}'),
        0x507A => Some('\u{79D4}'),
        0x507B => Some('\u{79D6}'),
        0x507C => Some('\u{79DA}'),
        0x507D => Some('\u{79DD}'),
        0x507E => Some('\u{79DE}'),
        0x5121 => Some('\u{79E0}'),
        0x5122 => Some('\u{79E2}'),
        0x5123 => Some('\u{79E5}'),
        0x5124 => Some('\u{79EA}'),
        0x5125 => Some('\u{79EB}'),
        0x5126 => Some('\u{79ED}'),
        0x5127 => Some('\u{79F1}'),
        0x5128 => Some('\u{79F8}'),
        0x5129 => Some('\u{79FC}'),
        0x512A => Some('\u{7A02}'),
        0x512B => Some('\u{7A03}'),
        0x512C => Some('\u{7A07}'),
        0x512D => Some('\u{7A09}'),
        0x512E => Some('\u{7A0A}'),
        0x512F => Some('\u{7A0C}'),
        0x5130 => Some('\u{7A11}'),
        0x5131 => Some('\u{7A15}'),
        0x5132 => Some('\u{7A1B}'),
        0x5133 => Some('\u{7A1E}'),
        0x5134 => Some('\u{7A21}'),
        0x5135 => Some('\u{7A27}'),
        0x5136 => Some('\u{7A2B}'),
        0x5137 => Some('\u{7A2D}'),
        0x5138 => Some('\u{7A2F}'),
        0x5139 => Some('\u{7A30}'),
        0x513A => Some('\u{7A34}'),
        0x513B => Some('\u{7A35}'),
        0x513C => Some('\u{7A38}'),
        0x513D => Some('\u{7A39}'),
        0x513E => Some('\u{7A3A}'),
        0x513F => Some('\u{7A44}'),
        0x5140 => Some('\u{7A45}'),
        0x5141 => Some('\u{7A47}'),
        0x5142 => Some('\u{7A48}'),
        0x5143 => Some('\u{7A4C}'),
        0x5144 => Some('\u{7A55}'),
        0x5145 => Some('\u{7A56}'),
        0x5146 => Some('\u{7A59}'),
        0x5147 => Some('\u{7A5C}'),
        0x5148 => Some('\u{7A5D}'),
        0x5149 => Some('\u{7A5F}'),
        0x514A => Some('\u{7A60}'),
        0x514B => Some('\u{7A65}'),
        0x514C => Some('\u{7A67}'),
        0x514D => Some('\u{7A6A}'),
        0x514E => Some('\u{7A6D}'),
        0x514F => Some('\u{7A75}'),
        0x5150 => Some('\u{7A78}'),
        0x5151 => Some('\u{7A7E}'),
        0x5152 => Some('\u{7A80}'),
        0x5153 => Some('\u{7A82}'),
        0x5154 => Some('\u{7A85}'),
        0x5155 => Some('\u{7A86}'),
        0x5156 => Some('\u{7A8A}'),
        0x5157 => Some('\u{7A8B}'),
        0x5158 => Some('\u{7A90}'),
        0x5159 => Some('\u{7A91}'),
        0x515A => Some('\u{7A94}'),
        0x515B => Some('\u{7A9E}'),
        0x515C => Some('\u{7AA0}'),
        0x515D => Some('\u{7AA3}'),
        0x515E => Some('\u{7AAC}'),
        0x515F => Some('\u{7AB3}'),
        0x5160 => Some('\u{7AB5}'),
        0x5161 => Some('\u{7AB9}'),
        0x5162 => Some('\u{7ABB}'),
        0x5163 => Some('\u{7ABC}'),
        0x5164 => Some('\u{7AC6}'),
        0x5165 => Some('\u{7AC9}'),
        0x5166 => Some('\u{7ACC}'),
        0x5167 => Some('\u{7ACE}'),
        0x5168 => Some('\u{7AD1}'),
        0x5169 => Some('\u{7ADB}'),
        0x516A => Some('\u{7AE8}'),
        0x516B => Some('\u{7AE9}'),
        0x516C => Some('\u{7AEB}'),
        0x516D => Some('\u{7AEC}'),
        0x516E => Some('\u{7AF1}'),
        0x516F => Some('\u{7AF4}'),
        0x5170 => Some('\u{7AFB}'),
        0x5171 => Some('\u{7AFD}'),
        0x5172 => Some('\u{7AFE}'),
        0x5173 => Some('\u{7B07}'),
        0x5174 => Some('\u{7B14}'),
        0x5175 => Some('\u{7B1F}'),
        0x5176 => Some('\u{7B23}'),
        0x5177 => Some('\u{7B27}'),
        0x5178 => Some('\u{7B29}'),
        0x5179 => Some('\u{7B2A}'),
        0x517A => Some('\u{7B2B}'),
        0x517B => Some('\u{7B2D}'),
        0x517C => Some('\u{7B2E}'),
        0x517D => Some('\u{7B2F}'),
        0x517E => Some('\u{7B30}'),
        0x5221 => Some('\u{7B31}'),
        0x5222 => Some('\u{7B34}'),
        0x5223 => Some('\u{7B3D}'),
        0x5224 => Some('\u{7B3F}'),
        0x5225 => Some('\u{7B40}'),
        0x5226 => Some('\u{7B41}'),
        0x5227 => Some('\u{7B47}'),
        0x5228 => Some('\u{7B4E}'),
        0x5229 => Some('\u{7B55}'),
        0x522A => Some('\u{7B60}'),
        0x522B => Some('\u{7B64}'),
        0x522C => Some('\u{7B66}'),
        0x522D => Some('\u{7B69}'),
        0x522E => Some('\u{7B6A}'),
        0x522F => Some('\u{7B6D}'),
        0x5230 => Some('\u{7B6F}'),
        0x5231 => Some('\u{7B72}'),
        0x5232 => Some('\u{7B73}'),
        0x5233 => Some('\u{7B77}'),
        0x5234 => Some('\u{7B84}'),
        0x5235 => Some('\u{7B89}'),
        0x5236 => Some('\u{7B8E}'),
        0x5237 => Some('\u{7B90}'),
        0x5238 => Some('\u{7B91}'),
        0x5239 => Some('\u{7B96}'),
        0x523A => Some('\u{7B9B}'),
        0x523B => Some('\u{7B9E}'),
        0x523C => Some('\u{7BA0}'),
        0x523D => Some('\u{7BA5}'),
        0x523E => Some('\u{7BAC}'),
        0x523F => Some('\u{7BAF}'),
        0x5240 => Some('\u{7BB0}'),
        0x5241 => Some('\u{7BB2}'),
        0x5242 => Some('\u{7BB5}'),
        0x5243 => Some('\u{7BB6}'),
        0x5244 => Some('\u{7BBA}'),
        0x5245 => Some('\u{7BBB}'),
        0x5246 => Some('\u{7BBC}'),
        0x5247 => Some('\u{7BBD}'),
        0x5248 => Some('\u{7BC2}'),
        0x5249 => Some('\u{7BC5}'),
        0x524A => Some('\u{7BC8}'),
        0x524B => Some('\u{7BCA}'),
        0x524C => Some('\u{7BD4}'),
        0x524D => Some('\u{7BD6}'),
        0x524E => Some('\u{7BD7}'),
        0x524F => Some('\u{7BD9}'),
        0x5250 => Some('\u{7BDA}'),
        0x5251 => Some('\u{7BDB}'),
        0x5252 => Some('\u{7BE8}'),
        0x5253 => Some('\u{7BEA}'),
        0x5254 => Some('\u{7BF2}'),
        0x5255 => Some('\u{7BF4}'),
        0x5256 => Some('\u{7BF5}'),
        0x5257 => Some('\u{7BF8}'),
        0x5258 => Some('\u{7BF9}'),
        0x5259 => Some('\u{7BFA}'),
        0x525A => Some('\u{7BFC}'),
        0x525B => Some('\u{7BFE}'),
        0x525C => Some('\u{7C01}'),
        0x525D => Some('\u{7C02}'),
        0x525E => Some('\u{7C03}'),
        0x525F => Some('\u{7C04}'),
        0x5260 => Some('\u{7C06}'),
        0x5261 => Some('\u{7C09}'),
        0x5262 => Some('\u{7C0B}'),
        0x5263 => Some('\u{7C0C}'),
        0x5264 => Some('\u{7C0E}'),
        0x5265 => Some('\u{7C0F}'),
        0x5266 => Some('\u{7C19}'),
        0x5267 => Some('\u{7C1B}'),
        0x5268 => Some('\u{7C20}'),
        0x5269 => Some('\u{7C25}'),
        0x526A => Some('\u{7C26}'),
        0x526B => Some('\u{7C28}'),
        0x526C => Some('\u{7C2C}'),
        0x526D => Some('\u{7C31}'),
        0x526E => Some('\u{7C33}'),
        0x526F => Some('\u{7C34}'),
        0x5270 => Some('\u{7C36}'),
        0x5271 => Some('\u{7C39}'),
        0x5272 => Some('\u{7C3A}'),
        0x5273 => Some('\u{7C46}'),
        0x5274 => Some('\u{7C4A}'),
        0x5276 => Some('\u{7C51}'),
        0x5277 => Some('\u{7C52}'),
        0x5278 => Some('\u{7C53}'),
        0x5275 => Some('\u{7C55}'),
        0x5279 => Some('\u{7C59}'),
        0x527A => Some('\u{7C5A}'),
        0x527B => Some('\u{7C5B}'),
        0x527C => Some('\u{7C5C}'),
        0x527D => Some('\u{7C5D}'),
        0x527E => Some('\u{7C5E}'),
        0x5321 => Some('\u{7C61}'),
        0x5322 => Some('\u{7C63}'),
        0x5323 => Some('\u{7C67}'),
        0x5324 => Some('\u{7C69}'),
        0x5325 => Some('\u{7C6D}'),
        0x5326 => Some('\u{7C6E}'),
        0x5327 => Some('\u{7C70}'),
        0x5328 => Some('\u{7C72}'),
        0x5329 => Some('\u{7C79}'),
        0x532A => Some('\u{7C7C}'),
        0x532B => Some('\u{7C7D}'),
        0x532C => Some('\u{7C86}'),
        0x532D => Some('\u{7C87}'),
        0x532E => Some('\u{7C8F}'),
        0x532F => Some('\u{7C94}'),
        0x5330 => Some('\u{7C9E}'),
        0x5331 => Some('\u{7CA0}'),
        0x5332 => Some('\u{7CA6}'),
        0x5333 => Some('\u{7CB0}'),
        0x5334 => Some('\u{7CB6}'),
        0x5335 => Some('\u{7CB7}'),
        0x5336 => Some('\u{7CBA}'),
        0x5337 => Some('\u{7CBB}'),
        0x5338 => Some('\u{7CBC}'),
        0x5339 => Some('\u{7CBF}'),
        0x533A => Some('\u{7CC4}'),
        0x533B => Some('\u{7CC7}'),
        0x533C => Some('\u{7CC8}'),
        0x533D => Some('\u{7CC9}'),
        0x533E => Some('\u{7CCD}'),
        0x533F => Some('\u{7CCF}'),
        0x5340 => Some('\u{7CD3}'),
        0x5341 => Some('\u{7CD4}'),
        0x5342 => Some('\u{7CD5}'),
        0x5343 => Some('\u{7CD7}'),
        0x5344 => Some('\u{7CD9}'),
        0x5345 => Some('\u{7CDA}'),
        0x5346 => Some('\u{7CDD}'),
        0x5347 => Some('\u{7CE6}'),
        0x5348 => Some('\u{7CE9}'),
        0x5349 => Some('\u{7CEB}'),
        0x534A => Some('\u{7CF5}'),
        0x534B => Some('\u{7D03}'),
        0x534C => Some('\u{7D07}'),
        0x534D => Some('\u{7D08}'),
        0x534E => Some('\u{7D09}'),
        0x534F => Some('\u{7D0F}'),
        0x5350 => Some('\u{7D11}'),
        0x5351 => Some('\u{7D12}'),
        0x5352 => Some('\u{7D13}'),
        0x5353 => Some('\u{7D16}'),
        0x5354 => Some('\u{7D1D}'),
        0x5355 => Some('\u{7D1E}'),
        0x5356 => Some('\u{7D23}'),
        0x5357 => Some('\u{7D26}'),
        0x5358 => Some('\u{7D2A}'),
        0x5359 => Some('\u{7D2D}'),
        0x535A => Some('\u{7D31}'),
        0x535B => Some('\u{7D3C}'),
        0x535C => Some('\u{7D3D}'),
        0x535D => Some('\u{7D3E}'),
        0x535E => Some('\u{7D40}'),
        0x535F => Some('\u{7D41}'),
        0x5360 => Some('\u{7D47}'),
        0x5361 => Some('\u{7D48}'),
        0x5362 => Some('\u{7D4D}'),
        0x5363 => Some('\u{7D51}'),
        0x5364 => Some('\u{7D53}'),
        0x5365 => Some('\u{7D57}'),
        0x5366 => Some('\u{7D59}'),
        0x5367 => Some('\u{7D5A}'),
        0x5368 => Some('\u{7D5C}'),
        0x5369 => Some('\u{7D5D}'),
        0x536A => Some('\u{7D65}'),
        0x536B => Some('\u{7D67}'),
        0x536C => Some('\u{7D6A}'),
        0x536D => Some('\u{7D70}'),
        0x536E => Some('\u{7D78}'),
        0x536F => Some('\u{7D7A}'),
        0x5370 => Some('\u{7D7B}'),
        0x5371 => Some('\u{7D7F}'),
        0x5372 => Some('\u{7D81}'),
        0x5373 => Some('\u{7D82}'),
        0x5374 => Some('\u{7D83}'),
        0x5375 => Some('\u{7D85}'),
        0x5376 => Some('\u{7D86}'),
        0x5377 => Some('\u{7D88}'),
        0x5378 => Some('\u{7D8B}'),
        0x5379 => Some('\u{7D8C}'),
        0x537A => Some('\u{7D8D}'),
        0x537B => Some('\u{7D91}'),
        0x537C => Some('\u{7D96}'),
        0x537D => Some('\u{7D97}'),
        0x537E => Some('\u{7D9D}'),
        0x5421 => Some('\u{7D9E}'),
        0x5422 => Some('\u{7DA6}'),
        0x5423 => Some('\u{7DA7}'),
        0x5424 => Some('\u{7DAA}'),
        0x5425 => Some('\u{7DB3}'),
        0x5426 => Some('\u{7DB6}'),
        0x5427 => Some('\u{7DB7}'),
        0x5428 => Some('\u{7DB9}'),
        0x5429 => Some('\u{7DC2}'),
        0x542A => Some('\u{7DC3}'),
        0x542B => Some('\u{7DC4}'),
        0x542C => Some('\u{7DC5}'),
        0x542D => Some('\u{7DC6}'),
        0x542E => Some('\u{7DCC}'),
        0x542F => Some('\u{7DCD}'),
        0x5430 => Some('\u{7DCE}'),
        0x5431 => Some('\u{7DD7}'),
        0x5432 => Some('\u{7DD9}'),
        0x5434 => Some('\u{7DE2}'),
        0x5435 => Some('\u{7DE5}'),
        0x5436 => Some('\u{7DE6}'),
        0x5437 => Some('\u{7DEA}'),
        0x5438 => Some('\u{7DEB}'),
        0x5439 => Some('\u{7DED}'),
        0x543A => Some('\u{7DF1}'),
        0x543B => Some('\u{7DF5}'),
        0x543C => Some('\u{7DF6}'),
        0x543D => Some('\u{7DF9}'),
        0x543E => Some('\u{7DFA}'),
        0x5433 => Some('\u{7E00}'),
        0x543F => Some('\u{7E08}'),
        0x5440 => Some('\u{7E10}'),
        0x5441 => Some('\u{7E11}'),
        0x5442 => Some('\u{7E15}'),
        0x5443 => Some('\u{7E17}'),
        0x5444 => Some('\u{7E1C}'),
        0x5445 => Some('\u{7E1D}'),
        0x5446 => Some('\u{7E20}'),
        0x5447 => Some('\u{7E27}'),
        0x5448 => Some('\u{7E28}'),
        0x5449 => Some('\u{7E2C}'),
        0x544A => Some('\u{7E2D}'),
        0x544B => Some('\u{7E2F}'),
        0x544C => Some('\u{7E33}'),
        0x544D => Some('\u{7E36}'),
        0x544E => Some('\u{7E3F}'),
        0x544F => Some('\u{7E44}'),
        0x5450 => Some('\u{7E45}'),
        0x5451 => Some('\u{7E47}'),
        0x5452 => Some('\u{7E4E}'),
        0x5453 => Some('\u{7E50}'),
        0x5454 => Some('\u{7E52}'),
        0x5455 => Some('\u{7E58}'),
        0x5456 => Some('\u{7E5F}'),
        0x5457 => Some('\u{7E61}'),
        0x5458 => Some('\u{7E62}'),
        0x5459 => Some('\u{7E65}'),
        0x545A => Some('\u{7E6B}'),
        0x545B => Some('\u{7E6E}'),
        0x545C => Some('\u{7E6F}'),
        0x545D => Some('\u{7E73}'),
        0x545E => Some('\u{7E78}'),
        0x545F => Some('\u{7E7E}'),
        0x5460 => Some('\u{7E81}'),
        0x5461 => Some('\u{7E86}'),
        0x5462 => Some('\u{7E87}'),
        0x5463 => Some('\u{7E8A}'),
        0x5464 => Some('\u{7E8D}'),
        0x5465 => Some('\u{7E91}'),
        0x5466 => Some('\u{7E95}'),
        0x5467 => Some('\u{7E98}'),
        0x5468 => Some('\u{7E9A}'),
        0x5469 => Some('\u{7E9D}'),
        0x546A => Some('\u{7E9E}'),
        0x546C => Some('\u{7F3B}'),
        0x546B => Some('\u{7F3C}'),
        0x546D => Some('\u{7F3D}'),
        0x546E => Some('\u{7F3E}'),
        0x546F => Some('\u{7F3F}'),
        0x5470 => Some('\u{7F43}'),
        0x5471 => Some('\u{7F44}'),
        0x5472 => Some('\u{7F47}'),
        0x5473 => Some('\u{7F4F}'),
        0x5474 => Some('\u{7F52}'),
        0x5475 => Some('\u{7F53}'),
        0x5476 => Some('\u{7F5B}'),
        0x5477 => Some('\u{7F5C}'),
        0x5478 => Some('\u{7F5D}'),
        0x5479 => Some('\u{7F61}'),
        0x547A => Some('\u{7F63}'),
        0x547B => Some('\u{7F64}'),
        0x547C => Some('\u{7F65}'),
        0x547D => Some('\u{7F66}'),
        0x547E => Some('\u{7F6D}'),
        0x5521 => Some('\u{7F71}'),
        0x5522 => Some('\u{7F7D}'),
        0x5523 => Some('\u{7F7E}'),
        0x5524 => Some('\u{7F7F}'),
        0x5525 => Some('\u{7F80}'),
        0x5526 => Some('\u{7F8B}'),
        0x5527 => Some('\u{7F8D}'),
        0x5528 => Some('\u{7F8F}'),
        0x5529 => Some('\u{7F90}'),
        0x552A => Some('\u{7F91}'),
        0x552B => Some('\u{7F96}'),
        0x552C => Some('\u{7F97}'),
        0x552D => Some('\u{7F9C}'),
        0x552E => Some('\u{7FA1}'),
        0x552F => Some('\u{7FA2}'),
        0x5530 => Some('\u{7FA6}'),
        0x5531 => Some('\u{7FAA}'),
        0x5532 => Some('\u{7FAD}'),
        0x5533 => Some('\u{7FB4}'),
        0x5534 => Some('\u{7FBC}'),
        0x5535 => Some('\u{7FBF}'),
        0x5536 => Some('\u{7FC0}'),
        0x5537 => Some('\u{7FC3}'),
        0x5538 => Some('\u{7FC8}'),
        0x5539 => Some('\u{7FCE}'),
        0x553A => Some('\u{7FCF}'),
        0x553B => Some('\u{7FDB}'),
        0x553C => Some('\u{7FDF}'),
        0x553D => Some('\u{7FE3}'),
        0x553E => Some('\u{7FE5}'),
        0x553F => Some('\u{7FE8}'),
        0x5540 => Some('\u{7FEC}'),
        0x5541 => Some('\u{7FEE}'),
        0x5542 => Some('\u{7FEF}'),
        0x5543 => Some('\u{7FF2}'),
        0x5544 => Some('\u{7FFA}'),
        0x5545 => Some('\u{7FFD}'),
        0x5546 => Some('\u{7FFE}'),
        0x5547 => Some('\u{7FFF}'),
        0x5548 => Some('\u{8007}'),
        0x5549 => Some('\u{8008}'),
        0x554A => Some('\u{800A}'),
        0x554B => Some('\u{800D}'),
        0x554C => Some('\u{800E}'),
        0x554D => Some('\u{800F}'),
        0x554E => Some('\u{8011}'),
        0x554F => Some('\u{8013}'),
        0x5550 => Some('\u{8014}'),
        0x5551 => Some('\u{8016}'),
        0x5552 => Some('\u{801D}'),
        0x5553 => Some('\u{801E}'),
        0x5554 => Some('\u{801F}'),
        0x5555 => Some('\u{8020}'),
        0x5556 => Some('\u{8024}'),
        0x5557 => Some('\u{8026}'),
        0x5558 => Some('\u{802C}'),
        0x5559 => Some('\u{802E}'),
        0x555A => Some('\u{8030}'),
        0x555B => Some('\u{8034}'),
        0x555C => Some('\u{8035}'),
        0x555D => Some('\u{8037}'),
        0x555E => Some('\u{8039}'),
        0x555F => Some('\u{803A}'),
        0x5560 => Some('\u{803C}'),
        0x5561 => Some('\u{803E}'),
        0x5562 => Some('\u{8040}'),
        0x5563 => Some('\u{8044}'),
        0x5564 => Some('\u{8060}'),
        0x5565 => Some('\u{8064}'),
        0x5566 => Some('\u{8066}'),
        0x5567 => Some('\u{806D}'),
        0x5568 => Some('\u{8071}'),
        0x5569 => Some('\u{8075}'),
        0x556A => Some('\u{8081}'),
        0x556B => Some('\u{8088}'),
        0x556C => Some('\u{808E}'),
        0x556D => Some('\u{809C}'),
        0x556E => Some('\u{809E}'),
        0x556F => Some('\u{80A6}'),
        0x5570 => Some('\u{80A7}'),
        0x5571 => Some('\u{80AB}'),
        0x5572 => Some('\u{80B8}'),
        0x5573 => Some('\u{80B9}'),
        0x5574 => Some('\u{80C8}'),
        0x5575 => Some('\u{80CD}'),
        0x5576 => Some('\u{80CF}'),
        0x5577 => Some('\u{80D2}'),
        0x5578 => Some('\u{80D4}'),
        0x5579 => Some('\u{80D5}'),
        0x557A => Some('\u{80D7}'),
        0x557B => Some('\u{80D8}'),
        0x557C => Some('\u{80E0}'),
        0x557D => Some('\u{80ED}'),
        0x557E => Some('\u{80EE}'),
        0x5621 => Some('\u{80F0}'),
        0x5622 => Some('\u{80F2}'),
        0x5623 => Some('\u{80F3}'),
        0x5624 => Some('\u{80F6}'),
        0x5625 => Some('\u{80F9}'),
        0x5626 => Some('\u{80FA}'),
        0x5627 => Some('\u{80FE}'),
        0x5628 => Some('\u{8103}'),
        0x5629 => Some('\u{810B}'),
        0x562A => Some('\u{8116}'),
        0x562B => Some('\u{8117}'),
        0x562C => Some('\u{8118}'),
        0x562D => Some('\u{811C}'),
        0x562E => Some('\u{811E}'),
        0x562F => Some('\u{8120}'),
        0x5630 => Some('\u{8124}'),
        0x5631 => Some('\u{8127}'),
        0x5632 => Some('\u{812C}'),
        0x5633 => Some('\u{8130}'),
        0x5634 => Some('\u{8135}'),
        0x5635 => Some('\u{813A}'),
        0x5636 => Some('\u{813C}'),
        0x5637 => Some('\u{8145}'),
        0x5638 => Some('\u{8147}'),
        0x5639 => Some('\u{814A}'),
        0x563A => Some('\u{814C}'),
        0x563B => Some('\u{8152}'),
        0x563C => Some('\u{8157}'),
        0x563D => Some('\u{8160}'),
        0x563E => Some('\u{8161}'),
        0x563F => Some('\u{8167}'),
        0x5640 => Some('\u{8168}'),
        0x5641 => Some('\u{8169}'),
        0x5642 => Some('\u{816D}'),
        0x5643 => Some('\u{816F}'),
        0x5644 => Some('\u{8177}'),
        0x5645 => Some('\u{8181}'),
        0x5647 => Some('\u{8184}'),
        0x5648 => Some('\u{8185}'),
        0x5649 => Some('\u{8186}'),
        0x564A => Some('\u{818B}'),
        0x564B => Some('\u{818E}'),
        0x5646 => Some('\u{8190}'),
        0x564C => Some('\u{8196}'),
        0x564D => Some('\u{8198}'),
        0x564E => Some('\u{819B}'),
        0x564F => Some('\u{819E}'),
        0x5650 => Some('\u{81A2}'),
        0x5651 => Some('\u{81AE}'),
        0x5652 => Some('\u{81B2}'),
        0x5653 => Some('\u{81B4}'),
        0x5654 => Some('\u{81BB}'),
        0x5656 => Some('\u{81C3}'),
        0x5657 => Some('\u{81C5}'),
        0x5658 => Some('\u{81CA}'),
        0x5655 => Some('\u{81CB}'),
        0x5659 => Some('\u{81CE}'),
        0x565A => Some('\u{81CF}'),
        0x565B => Some('\u{81D5}'),
        0x565C => Some('\u{81D7}'),
        0x565D => Some('\u{81DB}'),
        0x565E => Some('\u{81DD}'),
        0x565F => Some('\u{81DE}'),
        0x5660 => Some('\u{81E1}'),
        0x5661 => Some('\u{81E4}'),
        0x5662 => Some('\u{81EB}'),
        0x5663 => Some('\u{81EC}'),
        0x5664 => Some('\u{81F0}'),
        0x5665 => Some('\u{81F1}'),
        0x5666 => Some('\u{81F2}'),
        0x5667 => Some('\u{81F5}'),
        0x5668 => Some('\u{81F6}'),
        0x5669 => Some('\u{81F8}'),
        0x566A => Some('\u{81F9}'),
        0x566B => Some('\u{81FD}'),
        0x566C => Some('\u{81FF}'),
        0x566D => Some('\u{8200}'),
        0x566E => Some('\u{8203}'),
        0x566F => Some('\u{820F}'),
        0x5670 => Some('\u{8213}'),
        0x5671 => Some('\u{8214}'),
        0x5672 => Some('\u{8219}'),
        0x5673 => Some('\u{821A}'),
        0x5674 => Some('\u{821D}'),
        0x5675 => Some('\u{8221}'),
        0x5676 => Some('\u{8222}'),
        0x5677 => Some('\u{8228}'),
        0x5678 => Some('\u{8232}'),
        0x5679 => Some('\u{8234}'),
        0x567A => Some('\u{823A}'),
        0x567B => Some('\u{8243}'),
        0x567C => Some('\u{8244}'),
        0x567D => Some('\u{8245}'),
        0x567E => Some('\u{8246}'),
        0x5721 => Some('\u{824B}'),
        0x5722 => Some('\u{824E}'),
        0x5723 => Some('\u{824F}'),
        0x5724 => Some('\u{8251}'),
        0x5725 => Some('\u{8256}'),
        0x5726 => Some('\u{825C}'),
        0x5727 => Some('\u{8260}'),
        0x5728 => Some('\u{8263}'),
        0x5729 => Some('\u{8267}'),
        0x572A => Some('\u{826D}'),
        0x572B => Some('\u{8274}'),
        0x572C => Some('\u{827B}'),
        0x572D => Some('\u{827D}'),
        0x572E => Some('\u{827F}'),
        0x572F => Some('\u{8280}'),
        0x5730 => Some('\u{8281}'),
        0x5731 => Some('\u{8283}'),
        0x5732 => Some('\u{8284}'),
        0x5733 => Some('\u{8287}'),
        0x5734 => Some('\u{8289}'),
        0x5735 => Some('\u{828A}'),
        0x5736 => Some('\u{828E}'),
        0x5737 => Some('\u{8291}'),
        0x5738 => Some('\u{8294}'),
        0x5739 => Some('\u{8296}'),
        0x573A => Some('\u{8298}'),
        0x573B => Some('\u{829A}'),
        0x573C => Some('\u{829B}'),
        0x573D => Some('\u{82A0}'),
        0x573E => Some('\u{82A1}'),
        0x573F => Some('\u{82A3}'),
        0x5740 => Some('\u{82A4}'),
        0x5741 => Some('\u{82A7}'),
        0x5742 => Some('\u{82A8}'),
        0x5743 => Some('\u{82A9}'),
        0x5744 => Some('\u{82AA}'),
        0x5745 => Some('\u{82AE}'),
        0x5746 => Some('\u{82B0}'),
        0x5747 => Some('\u{82B2}'),
        0x5748 => Some('\u{82B4}'),
        0x5749 => Some('\u{82B7}'),
        0x574A => Some('\u{82BA}'),
        0x574B => Some('\u{82BC}'),
        0x574C => Some('\u{82BE}'),
        0x574D => Some('\u{82BF}'),
        0x574E => Some('\u{82C6}'),
        0x574F => Some('\u{82D0}'),
        0x5750 => Some('\u{82D5}'),
        0x5751 => Some('\u{82DA}'),
        0x5752 => Some('\u{82E0}'),
        0x5753 => Some('\u{82E2}'),
        0x5754 => Some('\u{82E4}'),
        0x5755 => Some('\u{82E8}'),
        0x5756 => Some('\u{82EA}'),
        0x5757 => Some('\u{82ED}'),
        0x5758 => Some('\u{82EF}'),
        0x5759 => Some('\u{82F6}'),
        0x575A => Some('\u{82F7}'),
        0x575B => Some('\u{82FD}'),
        0x575C => Some('\u{82FE}'),
        0x575D => Some('\u{8300}'),
        0x575E => Some('\u{8301}'),
        0x575F => Some('\u{8307}'),
        0x5760 => Some('\u{8308}'),
        0x5761 => Some('\u{830A}'),
        0x5762 => Some('\u{830B}'),
        0x5764 => Some('\u{831B}'),
        0x5765 => Some('\u{831D}'),
        0x5766 => Some('\u{831E}'),
        0x5767 => Some('\u{831F}'),
        0x5768 => Some('\u{8321}'),
        0x5769 => Some('\u{8322}'),
        0x576A => Some('\u{832C}'),
        0x576B => Some('\u{832D}'),
        0x576C => Some('\u{832E}'),
        0x576D => Some('\u{8330}'),
        0x576E => Some('\u{8333}'),
        0x576F => Some('\u{8337}'),
        0x5770 => Some('\u{833A}'),
        0x5771 => Some('\u{833C}'),
        0x5772 => Some('\u{833D}'),
        0x5773 => Some('\u{8342}'),
        0x5774 => Some('\u{8343}'),
        0x5775 => Some('\u{8344}'),
        0x5776 => Some('\u{8347}'),
        0x5777 => Some('\u{834D}'),
        0x5778 => Some('\u{834E}'),
        0x5779 => Some('\u{8351}'),
        0x583E => Some('\u{8353}'),
        0x5763 => Some('\u{8354}'),
        0x577A => Some('\u{8355}'),
        0x577B => Some('\u{8356}'),
        0x577C => Some('\u{8357}'),
        0x577D => Some('\u{8370}'),
        0x577E => Some('\u{8378}'),
        0x5821 => Some('\u{837D}'),
        0x5822 => Some('\u{837F}'),
        0x5823 => Some('\u{8380}'),
        0x5824 => Some('\u{8382}'),
        0x5825 => Some('\u{8384}'),
        0x5826 => Some('\u{8386}'),
        0x5827 => Some('\u{838D}'),
        0x5828 => Some('\u{8392}'),
        0x5829 => Some('\u{8394}'),
        0x582A => Some('\u{8395}'),
        0x582B => Some('\u{8398}'),
        0x582C => Some('\u{8399}'),
        0x582D => Some('\u{839B}'),
        0x582E => Some('\u{839C}'),
        0x582F => Some('\u{839D}'),
        0x5830 => Some('\u{83A6}'),
        0x5831 => Some('\u{83A7}'),
        0x5832 => Some('\u{83A9}'),
        0x5833 => Some('\u{83AC}'),
        0x584C => Some('\u{83AD}'),
        0x5834 => Some('\u{83BE}'),
        0x5835 => Some('\u{83BF}'),
        0x5836 => Some('\u{83C0}'),
        0x5837 => Some('\u{83C7}'),
        0x5838 => Some('\u{83C9}'),
        0x5839 => Some('\u{83CF}'),
        0x583A => Some('\u{83D0}'),
        0x583B => Some('\u{83D1}'),
        0x583C => Some('\u{83D4}'),
        0x583D => Some('\u{83DD}'),
        0x583F => Some('\u{83E8}'),
        0x5840 => Some('\u{83EA}'),
        0x5841 => Some('\u{83F6}'),
        0x5842 => Some('\u{83F8}'),
        0x5843 => Some('\u{83F9}'),
        0x5844 => Some('\u{83FC}'),
        0x5845 => Some('\u{8401}'),
        0x5846 => Some('\u{8406}'),
        0x5847 => Some('\u{840A}'),
        0x5848 => Some('\u{840F}'),
        0x5849 => Some('\u{8411}'),
        0x584A => Some('\u{8415}'),
        0x584B => Some('\u{8419}'),
        0x584D => Some('\u{842F}'),
        0x584E => Some('\u{8439}'),
        0x584F => Some('\u{8445}'),
        0x5850 => Some('\u{8447}'),
        0x5851 => Some('\u{8448}'),
        0x5852 => Some('\u{844A}'),
        0x5853 => Some('\u{844D}'),
        0x5854 => Some('\u{844F}'),
        0x5855 => Some('\u{8451}'),
        0x5856 => Some('\u{8452}'),
        0x5857 => Some('\u{8456}'),
        0x5858 => Some('\u{8458}'),
        0x5859 => Some('\u{8459}'),
        0x585A => Some('\u{845A}'),
        0x585B => Some('\u{845C}'),
        0x585C => Some('\u{8460}'),
        0x585D => Some('\u{8464}'),
        0x585E => Some('\u{8465}'),
        0x585F => Some('\u{8467}'),
        0x5860 => Some('\u{846A}'),
        0x5861 => Some('\u{8470}'),
        0x5862 => Some('\u{8473}'),
        0x5863 => Some('\u{8474}'),
        0x5864 => Some('\u{8476}'),
        0x5865 => Some('\u{8478}'),
        0x5866 => Some('\u{847C}'),
        0x5867 => Some('\u{847D}'),
        0x5868 => Some('\u{8481}'),
        0x5869 => Some('\u{8485}'),
        0x586A => Some('\u{8492}'),
        0x586B => Some('\u{8493}'),
        0x586C => Some('\u{8495}'),
        0x586D => Some('\u{849E}'),
        0x586E => Some('\u{84A6}'),
        0x586F => Some('\u{84A8}'),
        0x5870 => Some('\u{84A9}'),
        0x5871 => Some('\u{84AA}'),
        0x5872 => Some('\u{84AF}'),
        0x5873 => Some('\u{84B1}'),
        0x5874 => Some('\u{84B4}'),
        0x5875 => Some('\u{84BA}'),
        0x5876 => Some('\u{84BD}'),
        0x5877 => Some('\u{84BE}'),
        0x5878 => Some('\u{84C0}'),
        0x5879 => Some('\u{84C2}'),
        0x587A => Some('\u{84C7}'),
        0x587B => Some('\u{84C8}'),
        0x587C => Some('\u{84CC}'),
        0x587D => Some('\u{84CF}'),
        0x587E => Some('\u{84D3}'),
        0x5921 => Some('\u{84DC}'),
        0x5922 => Some('\u{84E7}'),
        0x5923 => Some('\u{84EA}'),
        0x5924 => Some('\u{84EF}'),
        0x5925 => Some('\u{84F0}'),
        0x5926 => Some('\u{84F1}'),
        0x5927 => Some('\u{84F2}'),
        0x5928 => Some('\u{84F7}'),
        0x592A => Some('\u{84FA}'),
        0x592B => Some('\u{84FB}'),
        0x592C => Some('\u{84FD}'),
        0x592D => Some('\u{8502}'),
        0x592E => Some('\u{8503}'),
        0x592F => Some('\u{8507}'),
        0x5930 => Some('\u{850C}'),
        0x5931 => Some('\u{850E}'),
        0x5932 => Some('\u{8510}'),
        0x5933 => Some('\u{851C}'),
        0x5934 => Some('\u{851E}'),
        0x5935 => Some('\u{8522}'),
        0x5936 => Some('\u{8523}'),
        0x5937 => Some('\u{8524}'),
        0x5938 => Some('\u{8525}'),
        0x5939 => Some('\u{8527}'),
        0x593A => Some('\u{852A}'),
        0x593B => Some('\u{852B}'),
        0x593C => Some('\u{852F}'),
        0x5929 => Some('\u{8532}'),
        0x593D => Some('\u{8533}'),
        0x593E => Some('\u{8534}'),
        0x593F => Some('\u{8536}'),
        0x5940 => Some('\u{853F}'),
        0x5941 => Some('\u{8546}'),
        0x5942 => Some('\u{854F}'),
        0x5943 => Some('\u{8550}'),
        0x5944 => Some('\u{8551}'),
        0x5945 => Some('\u{8552}'),
        0x5946 => Some('\u{8553}'),
        0x5947 => Some('\u{8556}'),
        0x5948 => Some('\u{8559}'),
        0x5949 => Some('\u{855C}'),
        0x594A => Some('\u{855D}'),
        0x594B => Some('\u{855E}'),
        0x594C => Some('\u{855F}'),
        0x594D => Some('\u{8560}'),
        0x594E => Some('\u{8561}'),
        0x594F => Some('\u{8562}'),
        0x5950 => Some('\u{8564}'),
        0x5951 => Some('\u{856B}'),
        0x5952 => Some('\u{856F}'),
        0x5953 => Some('\u{8579}'),
        0x5954 => Some('\u{857A}'),
        0x5955 => Some('\u{857B}'),
        0x5956 => Some('\u{857D}'),
        0x5957 => Some('\u{857F}'),
        0x5958 => Some('\u{8581}'),
        0x5959 => Some('\u{8585}'),
        0x595A => Some('\u{8586}'),
        0x595B => Some('\u{8589}'),
        0x595C => Some('\u{858B}'),
        0x595D => Some('\u{858C}'),
        0x595E => Some('\u{858F}'),
        0x595F => Some('\u{8593}'),
        0x5960 => Some('\u{8598}'),
        0x5961 => Some('\u{859D}'),
        0x5962 => Some('\u{859F}'),
        0x5963 => Some('\u{85A0}'),
        0x5964 => Some('\u{85A2}'),
        0x5965 => Some('\u{85A5}'),
        0x5966 => Some('\u{85A7}'),
        0x5974 => Some('\u{85AD}'),
        0x5967 => Some('\u{85B4}'),
        0x5968 => Some('\u{85B6}'),
        0x5969 => Some('\u{85B7}'),
        0x596A => Some('\u{85B8}'),
        0x596B => Some('\u{85BC}'),
        0x596C => Some('\u{85BD}'),
        0x596D => Some('\u{85BE}'),
        0x596E => Some('\u{85BF}'),
        0x596F => Some('\u{85C2}'),
        0x5970 => Some('\u{85C7}'),
        0x5971 => Some('\u{85CA}'),
        0x5972 => Some('\u{85CB}'),
        0x5973 => Some('\u{85CE}'),
        0x5975 => Some('\u{85D8}'),
        0x5976 => Some('\u{85DA}'),
        0x5977 => Some('\u{85DF}'),
        0x5978 => Some('\u{85E0}'),
        0x5979 => Some('\u{85E6}'),
        0x597A => Some('\u{85E8}'),
        0x597B => Some('\u{85ED}'),
        0x597C => Some('\u{85F3}'),
        0x597D => Some('\u{85F6}'),
        0x597E => Some('\u{85FC}'),
        0x5A21 => Some('\u{85FF}'),
        0x5A22 => Some('\u{8600}'),
        0x5A23 => Some('\u{8604}'),
        0x5A24 => Some('\u{8605}'),
        0x5A25 => Some('\u{860D}'),
        0x5A26 => Some('\u{860E}'),
        0x5A27 => Some('\u{8610}'),
        0x5A28 => Some('\u{8611}'),
        0x5A29 => Some('\u{8612}'),
        0x5A2A => Some('\u{8618}'),
        0x5A2B => Some('\u{8619}'),
        0x5A2C => Some('\u{861B}'),
        0x5A2D => Some('\u{861E}'),
        0x5A2E => Some('\u{8621}'),
        0x5A2F => Some('\u{8627}'),
        0x5A30 => Some('\u{8629}'),
        0x5A31 => Some('\u{8636}'),
        0x5A32 => Some('\u{8638}'),
        0x5A33 => Some('\u{863A}'),
        0x5A34 => Some('\u{863C}'),
        0x5A35 => Some('\u{863D}'),
        0x5A36 => Some('\u{8640}'),
        0x3866 => Some('\u{8641}'),
        0x5A37 => Some('\u{8642}'),
        0x5A38 => Some('\u{8646}'),
        0x5A39 => Some('\u{8652}'),
        0x5A3A => Some('\u{8653}'),
        0x5A3B => Some('\u{8656}'),
        0x5A3C => Some('\u{8657}'),
        0x5A3D => Some('\u{8658}'),
        0x5A3E => Some('\u{8659}'),
        0x5A3F => Some('\u{865D}'),
        0x5A40 => Some('\u{8660}'),
        0x5A41 => Some('\u{8661}'),
        0x5A42 => Some('\u{8662}'),
        0x5A43 => Some('\u{8663}'),
        0x5A44 => Some('\u{8664}'),
        0x5A45 => Some('\u{8669}'),
        0x5A46 => Some('\u{866C}'),
        0x5A47 => Some('\u{866F}'),
        0x5A48 => Some('\u{8675}'),
        0x5A49 => Some('\u{8676}'),
        0x5A4A => Some('\u{8677}'),
        0x5A4B => Some('\u{867A}'),
        0x5A6D => Some('\u{8688}'),
        0x5A4C => Some('\u{868D}'),
        0x5A4D => Some('\u{8691}'),
        0x5A4E => Some('\u{8696}'),
        0x5A4F => Some('\u{8698}'),
        0x5A50 => Some('\u{869A}'),
        0x5A51 => Some('\u{869C}'),
        0x5A52 => Some('\u{86A1}'),
        0x5A53 => Some('\u{86A6}'),
        0x5A54 => Some('\u{86A7}'),
        0x5A55 => Some('\u{86A8}'),
        0x5A56 => Some('\u{86AD}'),
        0x5A57 => Some('\u{86B1}'),
        0x5A58 => Some('\u{86B3}'),
        0x5A59 => Some('\u{86B4}'),
        0x5A5A => Some('\u{86B5}'),
        0x5A5B => Some('\u{86B7}'),
        0x5A5C => Some('\u{86B8}'),
        0x5A5D => Some('\u{86B9}'),
        0x5A5E => Some('\u{86BF}'),
        0x5A5F => Some('\u{86C0}'),
        0x5A60 => Some('\u{86C1}'),
        0x5A61 => Some('\u{86C3}'),
        0x5A62 => Some('\u{86C5}'),
        0x5A63 => Some('\u{86D1}'),
        0x5A64 => Some('\u{86D2}'),
        0x5A65 => Some('\u{86D5}'),
        0x5A66 => Some('\u{86D7}'),
        0x5A67 => Some('\u{86DA}'),
        0x5A68 => Some('\u{86DC}'),
        0x5A69 => Some('\u{86E0}'),
        0x5A6A => Some('\u{86E3}'),
        0x5A6B => Some('\u{86E5}'),
        0x5A6C => Some('\u{86E7}'),
        0x5A6E => Some('\u{86FA}'),
        0x5A6F => Some('\u{86FC}'),
        0x5A70 => Some('\u{86FD}'),
        0x5A71 => Some('\u{8704}'),
        0x5A72 => Some('\u{8705}'),
        0x5A73 => Some('\u{8707}'),
        0x5A74 => Some('\u{870B}'),
        0x5A75 => Some('\u{870E}'),
        0x5A76 => Some('\u{870F}'),
        0x5A77 => Some('\u{8710}'),
        0x5A78 => Some('\u{8713}'),
        0x5A79 => Some('\u{8714}'),
        0x5A7A => Some('\u{8719}'),
        0x5A7B => Some('\u{871E}'),
        0x5A7C => Some('\u{871F}'),
        0x5A7D => Some('\u{8721}'),
        0x5A7E => Some('\u{8723}'),
        0x5B21 => Some('\u{8728}'),
        0x5B22 => Some('\u{872E}'),
        0x5B23 => Some('\u{872F}'),
        0x5B24 => Some('\u{8731}'),
        0x5B25 => Some('\u{8732}'),
        0x5B26 => Some('\u{8739}'),
        0x5B27 => Some('\u{873A}'),
        0x5B28 => Some('\u{873C}'),
        0x5B29 => Some('\u{873D}'),
        0x5B2A => Some('\u{873E}'),
        0x5B2B => Some('\u{8740}'),
        0x5B2C => Some('\u{8743}'),
        0x5B2D => Some('\u{8745}'),
        0x5B2E => Some('\u{874D}'),
        0x5B2F => Some('\u{8758}'),
        0x5B30 => Some('\u{875D}'),
        0x5B31 => Some('\u{8761}'),
        0x5B32 => Some('\u{8764}'),
        0x5B33 => Some('\u{8765}'),
        0x5B34 => Some('\u{876F}'),
        0x5B35 => Some('\u{8771}'),
        0x5B36 => Some('\u{8772}'),
        0x5B37 => Some('\u{877B}'),
        0x5B38 => Some('\u{8783}'),
        0x5B39 => Some('\u{8784}'),
        0x5B3A => Some('\u{8785}'),
        0x5B3B => Some('\u{8786}'),
        0x5B3C => Some('\u{8787}'),
        0x5B3D => Some('\u{8788}'),
        0x5B3E => Some('\u{8789}'),
        0x5B3F => Some('\u{878B}'),
        0x5B40 => Some('\u{878C}'),
        0x5B41 => Some('\u{8790}'),
        0x5B42 => Some('\u{8793}'),
        0x5B43 => Some('\u{8795}'),
        0x5B44 => Some('\u{8797}'),
        0x5B45 => Some('\u{8798}'),
        0x5B46 => Some('\u{8799}'),
        0x5B47 => Some('\u{879E}'),
        0x5B48 => Some('\u{87A0}'),
        0x5B49 => Some('\u{87A3}'),
        0x5B4A => Some('\u{87A7}'),
        0x5B4B => Some('\u{87AC}'),
        0x5B4C => Some('\u{87AD}'),
        0x5B4D => Some('\u{87AE}'),
        0x5B4E => Some('\u{87B1}'),
        0x5B4F => Some('\u{87B5}'),
        0x5B50 => Some('\u{87BE}'),
        0x5B51 => Some('\u{87BF}'),
        0x5B52 => Some('\u{87C1}'),
        0x5B53 => Some('\u{87C8}'),
        0x5B54 => Some('\u{87C9}'),
        0x5B55 => Some('\u{87CA}'),
        0x5B56 => Some('\u{87CE}'),
        0x5B57 => Some('\u{87D5}'),
        0x5B58 => Some('\u{87D6}'),
        0x5B59 => Some('\u{87D9}'),
        0x5B5A => Some('\u{87DA}'),
        0x5B5B => Some('\u{87DC}'),
        0x5B5C => Some('\u{87DF}'),
        0x5B5D => Some('\u{87E2}'),
        0x5B5E => Some('\u{87E3}'),
        0x5B5F => Some('\u{87E4}'),
        0x5B60 => Some('\u{87EA}'),
        0x5B61 => Some('\u{87EB}'),
        0x5B62 => Some('\u{87ED}'),
        0x5B63 => Some('\u{87F1}'),
        0x5B64 => Some('\u{87F3}'),
        0x5B65 => Some('\u{87F8}'),
        0x5B66 => Some('\u{87FA}'),
        0x5B67 => Some('\u{87FF}'),
        0x5B68 => Some('\u{8801}'),
        0x5B69 => Some('\u{8803}'),
        0x5B6A => Some('\u{8806}'),
        0x5B6B => Some('\u{8809}'),
        0x5B6C => Some('\u{880A}'),
        0x5B6D => Some('\u{880B}'),
        0x5B6E => Some('\u{8810}'),
        0x5B70 => Some('\u{8812}'),
        0x5B71 => Some('\u{8813}'),
        0x5B72 => Some('\u{8814}'),
        0x5B73 => Some('\u{8818}'),
        0x5B6F => Some('\u{8819}'),
        0x5B74 => Some('\u{881A}'),
        0x5B75 => Some('\u{881B}'),
        0x5B76 => Some('\u{881C}'),
        0x5B77 => Some('\u{881E}'),
        0x5B78 => Some('\u{881F}'),
        0x5B79 => Some('\u{8828}'),
        0x5B7A => Some('\u{882D}'),
        0x5B7B => Some('\u{882E}'),
        0x5B7C => Some('\u{8830}'),
        0x5B7D => Some('\u{8832}'),
        0x5B7E => Some('\u{8835}'),
        0x5C21 => Some('\u{883A}'),
        0x5C22 => Some('\u{883C}'),
        0x5C23 => Some('\u{8841}'),
        0x5C24 => Some('\u{8843}'),
        0x5C25 => Some('\u{8845}'),
        0x5C26 => Some('\u{8848}'),
        0x5C27 => Some('\u{8849}'),
        0x5C28 => Some('\u{884A}'),
        0x5C29 => Some('\u{884B}'),
        0x5C2A => Some('\u{884E}'),
        0x5C2B => Some('\u{8851}'),
        0x5C2C => Some('\u{8855}'),
        0x5C2D => Some('\u{8856}'),
        0x5C2E => Some('\u{8858}'),
        0x5C2F => Some('\u{885A}'),
        0x5C30 => Some('\u{885C}'),
        0x5C31 => Some('\u{885F}'),
        0x5C32 => Some('\u{8860}'),
        0x5C33 => Some('\u{8864}'),
        0x5C34 => Some('\u{8869}'),
        0x5C35 => Some('\u{8871}'),
        0x5C36 => Some('\u{8879}'),
        0x5C37 => Some('\u{887B}'),
        0x5C38 => Some('\u{8880}'),
        0x5C39 => Some('\u{8898}'),
        0x5C3A => Some('\u{889A}'),
        0x5C3B => Some('\u{889B}'),
        0x5C3C => Some('\u{889C}'),
        0x5C3D => Some('\u{889F}'),
        0x5C3E => Some('\u{88A0}'),
        0x5C3F => Some('\u{88A8}'),
        0x5C40 => Some('\u{88AA}'),
        0x5C41 => Some('\u{88BA}'),
        0x5C42 => Some('\u{88BD}'),
        0x5C43 => Some('\u{88BE}'),
        0x5C44 => Some('\u{88C0}'),
        0x5C45 => Some('\u{88CA}'),
        0x5C46 => Some('\u{88CB}'),
        0x5C47 => Some('\u{88CC}'),
        0x5C48 => Some('\u{88CD}'),
        0x5C49 => Some('\u{88CE}'),
        0x5C4A => Some('\u{88D1}'),
        0x5C4B => Some('\u{88D2}'),
        0x5C4C => Some('\u{88D3}'),
        0x5C4D => Some('\u{88DB}'),
        0x5C4E => Some('\u{88DE}'),
        0x5C4F => Some('\u{88E7}'),
        0x5C50 => Some('\u{88EF}'),
        0x5C51 => Some('\u{88F0}'),
        0x5C52 => Some('\u{88F1}'),
        0x5C53 => Some('\u{88F5}'),
        0x5C54 => Some('\u{88F7}'),
        0x5C55 => Some('\u{8901}'),
        0x5C56 => Some('\u{8906}'),
        0x5C57 => Some('\u{890D}'),
        0x5C58 => Some('\u{890E}'),
        0x5C59 => Some('\u{890F}'),
        0x5C5A => Some('\u{8915}'),
        0x5C5B => Some('\u{8916}'),
        0x5C5C => Some('\u{8918}'),
        0x5C5D => Some('\u{8919}'),
        0x5C5E => Some('\u{891A}'),
        0x5C5F => Some('\u{891C}'),
        0x5C60 => Some('\u{8920}'),
        0x5C61 => Some('\u{8926}'),
        0x5C62 => Some('\u{8927}'),
        0x5C63 => Some('\u{8928}'),
        0x5C64 => Some('\u{8930}'),
        0x5C65 => Some('\u{8931}'),
        0x5C66 => Some('\u{8932}'),
        0x5C67 => Some('\u{8935}'),
        0x5C68 => Some('\u{8939}'),
        0x5C69 => Some('\u{893A}'),
        0x5C6A => Some('\u{893E}'),
        0x5C6B => Some('\u{8940}'),
        0x5C6C => Some('\u{8942}'),
        0x5C6D => Some('\u{8945}'),
        0x5C6E => Some('\u{8946}'),
        0x5C6F => Some('\u{8949}'),
        0x5C70 => Some('\u{894F}'),
        0x5C71 => Some('\u{8952}'),
        0x5C72 => Some('\u{8957}'),
        0x5C73 => Some('\u{895A}'),
        0x5C74 => Some('\u{895B}'),
        0x5C75 => Some('\u{895C}'),
        0x5C76 => Some('\u{8961}'),
        0x5C77 => Some('\u{8962}'),
        0x5C78 => Some('\u{8963}'),
        0x5C79 => Some('\u{896B}'),
        0x5C7A => Some('\u{896E}'),
        0x5C7B => Some('\u{8970}'),
        0x5C7C => Some('\u{8973}'),
        0x5C7D => Some('\u{8975}'),
        0x5C7E => Some('\u{897A}'),
        0x5D21 => Some('\u{897B}'),
        0x5D22 => Some('\u{897C}'),
        0x5D23 => Some('\u{897D}'),
        0x5D24 => Some('\u{8989}'),
        0x5D25 => Some('\u{898D}'),
        0x5D26 => Some('\u{8990}'),
        0x5D27 => Some('\u{8994}'),
        0x5D28 => Some('\u{8995}'),
        0x5D29 => Some('\u{899B}'),
        0x5D2A => Some('\u{899C}'),
        0x5D2B => Some('\u{899F}'),
        0x5D2C => Some('\u{89A0}'),
        0x5D2D => Some('\u{89A5}'),
        0x5D2E => Some('\u{89B0}'),
        0x5D2F => Some('\u{89B4}'),
        0x5D30 => Some('\u{89B5}'),
        0x5D31 => Some('\u{89B6}'),
        0x5D32 => Some('\u{89B7}'),
        0x5D33 => Some('\u{89BC}'),
        0x5D34 => Some('\u{89D4}'),
        0x5D35 => Some('\u{89D5}'),
        0x5D36 => Some('\u{89D6}'),
        0x5D37 => Some('\u{89D7}'),
        0x5D38 => Some('\u{89D8}'),
        0x5D39 => Some('\u{89E5}'),
        0x5D3A => Some('\u{89E9}'),
        0x5D3B => Some('\u{89EB}'),
        0x5D3C => Some('\u{89ED}'),
        0x5D3D => Some('\u{89F1}'),
        0x5D3E => Some('\u{89F3}'),
        0x5D3F => Some('\u{89F6}'),
        0x5D40 => Some('\u{89F9}'),
        0x5D41 => Some('\u{89FD}'),
        0x5D42 => Some('\u{89FF}'),
        0x5D43 => Some('\u{8A04}'),
        0x5D44 => Some('\u{8A05}'),
        0x5D45 => Some('\u{8A07}'),
        0x5D46 => Some('\u{8A0F}'),
        0x5D47 => Some('\u{8A11}'),
        0x5D48 => Some('\u{8A12}'),
        0x5D49 => Some('\u{8A14}'),
        0x5D4A => Some('\u{8A15}'),
        0x5D4B => Some('\u{8A1E}'),
        0x5D4C => Some('\u{8A20}'),
        0x5D4D => Some('\u{8A22}'),
        0x5D4E => Some('\u{8A24}'),
        0x5D4F => Some('\u{8A26}'),
        0x5D50 => Some('\u{8A2B}'),
        0x5D51 => Some('\u{8A2C}'),
        0x5D52 => Some('\u{8A2F}'),
        0x5D53 => Some('\u{8A35}'),
        0x5D54 => Some('\u{8A37}'),
        0x5D55 => Some('\u{8A3D}'),
        0x5D56 => Some('\u{8A3E}'),
        0x5D57 => Some('\u{8A40}'),
        0x5D58 => Some('\u{8A43}'),
        0x5D59 => Some('\u{8A45}'),
        0x5D5A => Some('\u{8A47}'),
        0x5D5B => Some('\u{8A49}'),
        0x5D5C => Some('\u{8A4D}'),
        0x5D5D => Some('\u{8A4E}'),
        0x5D5E => Some('\u{8A53}'),
        0x5D5F => Some('\u{8A56}'),
        0x5D60 => Some('\u{8A57}'),
        0x5D61 => Some('\u{8A58}'),
        0x5D62 => Some('\u{8A5C}'),
        0x5D63 => Some('\u{8A5D}'),
        0x5D64 => Some('\u{8A61}'),
        0x5D65 => Some('\u{8A65}'),
        0x5D66 => Some('\u{8A67}'),
        0x5D67 => Some('\u{8A75}'),
        0x5D68 => Some('\u{8A76}'),
        0x5D69 => Some('\u{8A77}'),
        0x5D6A => Some('\u{8A79}'),
        0x5D6B => Some('\u{8A7A}'),
        0x5D6C => Some('\u{8A7B}'),
        0x5D6D => Some('\u{8A7E}'),
        0x5D6E => Some('\u{8A7F}'),
        0x5D6F => Some('\u{8A80}'),
        0x5D70 => Some('\u{8A83}'),
        0x5D71 => Some('\u{8A86}'),
        0x5D72 => Some('\u{8A8B}'),
        0x5D73 => Some('\u{8A8F}'),
        0x5D74 => Some('\u{8A90}'),
        0x5D75 => Some('\u{8A92}'),
        0x5D76 => Some('\u{8A96}'),
        0x5D77 => Some('\u{8A97}'),
        0x5D78 => Some('\u{8A99}'),
        0x5D79 => Some('\u{8A9F}'),
        0x5D7A => Some('\u{8AA7}'),
        0x5D7B => Some('\u{8AA9}'),
        0x5D7C => Some('\u{8AAE}'),
        0x5D7D => Some('\u{8AAF}'),
        0x5D7E => Some('\u{8AB3}'),
        0x5E21 => Some('\u{8AB6}'),
        0x5E22 => Some('\u{8AB7}'),
        0x5E23 => Some('\u{8ABB}'),
        0x5E24 => Some('\u{8ABE}'),
        0x5E25 => Some('\u{8AC3}'),
        0x5E26 => Some('\u{8AC6}'),
        0x5E27 => Some('\u{8AC8}'),
        0x5E28 => Some('\u{8AC9}'),
        0x5E29 => Some('\u{8ACA}'),
        0x5E2A => Some('\u{8AD1}'),
        0x5E2B => Some('\u{8AD3}'),
        0x5E2C => Some('\u{8AD4}'),
        0x5E2D => Some('\u{8AD5}'),
        0x5E2E => Some('\u{8AD7}'),
        0x5E2F => Some('\u{8ADD}'),
        0x5E30 => Some('\u{8ADF}'),
        0x5E31 => Some('\u{8AEC}'),
        0x5E32 => Some('\u{8AF0}'),
        0x5E33 => Some('\u{8AF4}'),
        0x5E34 => Some('\u{8AF5}'),
        0x5E35 => Some('\u{8AF6}'),
        0x5E36 => Some('\u{8AFC}'),
        0x5E37 => Some('\u{8AFF}'),
        0x5E38 => Some('\u{8B05}'),
        0x5E39 => Some('\u{8B06}'),
        0x5E3F => Some('\u{8B0A}'),
        0x5E3A => Some('\u{8B0B}'),
        0x5E3B => Some('\u{8B11}'),
        0x5E3C => Some('\u{8B1C}'),
        0x5E3D => Some('\u{8B1E}'),
        0x5E3E => Some('\u{8B1F}'),
        0x5E40 => Some('\u{8B2D}'),
        0x5E41 => Some('\u{8B30}'),
        0x5E42 => Some('\u{8B37}'),
        0x5E43 => Some('\u{8B3C}'),
        0x5E44 => Some('\u{8B42}'),
        0x5E45 => Some('\u{8B43}'),
        0x5E46 => Some('\u{8B44}'),
        0x5E47 => Some('\u{8B45}'),
        0x5E48 => Some('\u{8B46}'),
        0x5E49 => Some('\u{8B48}'),
        0x5E4E => Some('\u{8B4D}'),
        0x5E4A => Some('\u{8B52}'),
        0x5E4B => Some('\u{8B53}'),
        0x5E4C => Some('\u{8B54}'),
        0x5E4D => Some('\u{8B59}'),
        0x5E4F => Some('\u{8B5E}'),
        0x5E50 => Some('\u{8B63}'),
        0x5E51 => Some('\u{8B6D}'),
        0x5E52 => Some('\u{8B76}'),
        0x5E53 => Some('\u{8B78}'),
        0x5E54 => Some('\u{8B79}'),
        0x5E55 => Some('\u{8B7C}'),
        0x5E56 => Some('\u{8B7E}'),
        0x5E57 => Some('\u{8B81}'),
        0x5E58 => Some('\u{8B84}'),
        0x5E59 => Some('\u{8B85}'),
        0x5E5A => Some('\u{8B8B}'),
        0x5E5B => Some('\u{8B8D}'),
        0x5E5C => Some('\u{8B8F}'),
        0x5E5D => Some('\u{8B94}'),
        0x5E5E => Some('\u{8B95}'),
        0x5E5F => Some('\u{8B9C}'),
        0x5E60 => Some('\u{8B9E}'),
        0x5E61 => Some('\u{8B9F}'),
        0x5E62 => Some('\u{8C38}'),
        0x5E63 => Some('\u{8C39}'),
        0x5E64 => Some('\u{8C3D}'),
        0x5E65 => Some('\u{8C3E}'),
        0x5E66 => Some('\u{8C45}'),
        0x5E67 => Some('\u{8C47}'),
        0x5E68 => Some('\u{8C49}'),
        0x5E69 => Some('\u{8C4B}'),
        0x5E6A => Some('\u{8C4F}'),
        0x5E6B => Some('\u{8C51}'),
        0x5E6C => Some('\u{8C53}'),
        0x5E6D => Some('\u{8C54}'),
        0x5E6E => Some('\u{8C57}'),
        0x5E6F => Some('\u{8C58}'),
        0x5E72 => Some('\u{8C59}'),
        0x5E70 => Some('\u{8C5B}'),
        0x5E71 => Some('\u{8C5D}'),
        0x5E73 => Some('\u{8C63}'),
        0x5E74 => Some('\u{8C64}'),
        0x5E75 => Some('\u{8C66}'),
        0x5E76 => Some('\u{8C68}'),
        0x5E77 => Some('\u{8C69}'),
        0x5E78 => Some('\u{8C6D}'),
        0x5E79 => Some('\u{8C73}'),
        0x5E7A => Some('\u{8C75}'),
        0x5E7B => Some('\u{8C76}'),
        0x5E7C => Some('\u{8C7B}'),
        0x5E7D => Some('\u{8C7E}'),
        0x5E7E => Some('\u{8C86}'),
        0x5F21 => Some('\u{8C87}'),
        0x5F22 => Some('\u{8C8B}'),
        0x5F23 => Some('\u{8C90}'),
        0x5F24 => Some('\u{8C92}'),
        0x5F25 => Some('\u{8C93}'),
        0x5F26 => Some('\u{8C99}'),
        0x5F27 => Some('\u{8C9B}'),
        0x5F28 => Some('\u{8C9C}'),
        0x5F29 => Some('\u{8CA4}'),
        0x5F2A => Some('\u{8CB9}'),
        0x5F2B => Some('\u{8CBA}'),
        0x5F2C => Some('\u{8CC5}'),
        0x5F2D => Some('\u{8CC6}'),
        0x5F2E => Some('\u{8CC9}'),
        0x5F2F => Some('\u{8CCB}'),
        0x5F30 => Some('\u{8CCF}'),
        0x5F32 => Some('\u{8CD5}'),
        0x5F31 => Some('\u{8CD6}'),
        0x5F33 => Some('\u{8CD9}'),
        0x5F34 => Some('\u{8CDD}'),
        0x5F35 => Some('\u{8CE1}'),
        0x5F36 => Some('\u{8CE8}'),
        0x5F37 => Some('\u{8CEC}'),
        0x5F38 => Some('\u{8CEF}'),
        0x5F39 => Some('\u{8CF0}'),
        0x5F3A => Some('\u{8CF2}'),
        0x5F3B => Some('\u{8CF5}'),
        0x5F3C => Some('\u{8CF7}'),
        0x5F3D => Some('\u{8CF8}'),
        0x5F3E => Some('\u{8CFE}'),
        0x5F3F => Some('\u{8CFF}'),
        0x5F40 => Some('\u{8D01}'),
        0x5F41 => Some('\u{8D03}'),
        0x5F42 => Some('\u{8D09}'),
        0x5F43 => Some('\u{8D12}'),
        0x5F44 => Some('\u{8D17}'),
        0x5F45 => Some('\u{8D1B}'),
        0x5F46 => Some('\u{8D65}'),
        0x5F47 => Some('\u{8D69}'),
        0x5F48 => Some('\u{8D6C}'),
        0x5F49 => Some('\u{8D6E}'),
        0x5F4A => Some('\u{8D7F}'),
        0x5F4B => Some('\u{8D82}'),
        0x5F4C => Some('\u{8D84}'),
        0x5F4D => Some('\u{8D88}'),
        0x5F4E => Some('\u{8D8D}'),
        0x5F4F => Some('\u{8D90}'),
        0x5F50 => Some('\u{8D91}'),
        0x5F51 => Some('\u{8D95}'),
        0x5F52 => Some('\u{8D9E}'),
        0x5F53 => Some('\u{8D9F}'),
        0x5F54 => Some('\u{8DA0}'),
        0x5F55 => Some('\u{8DA6}'),
        0x5F56 => Some('\u{8DAB}'),
        0x5F57 => Some('\u{8DAC}'),
        0x5F58 => Some('\u{8DAF}'),
        0x5F59 => Some('\u{8DB2}'),
        0x5F5A => Some('\u{8DB5}'),
        0x5F5B => Some('\u{8DB7}'),
        0x5F5C => Some('\u{8DB9}'),
        0x5F5D => Some('\u{8DBB}'),
        0x5F6F => Some('\u{8DBC}'),
        0x5F5E => Some('\u{8DC0}'),
        0x5F5F => Some('\u{8DC5}'),
        0x5F60 => Some('\u{8DC6}'),
        0x5F61 => Some('\u{8DC7}'),
        0x5F62 => Some('\u{8DC8}'),
        0x5F63 => Some('\u{8DCA}'),
        0x5F64 => Some('\u{8DCE}'),
        0x5F65 => Some('\u{8DD1}'),
        0x5F66 => Some('\u{8DD4}'),
        0x5F67 => Some('\u{8DD5}'),
        0x5F68 => Some('\u{8DD7}'),
        0x5F69 => Some('\u{8DD9}'),
        0x5F6A => Some('\u{8DE4}'),
        0x5F6B => Some('\u{8DE5}'),
        0x5F6C => Some('\u{8DE7}'),
        0x5F6D => Some('\u{8DEC}'),
        0x5F6E => Some('\u{8DF0}'),
        0x5F70 => Some('\u{8DF1}'),
        0x5F71 => Some('\u{8DF2}'),
        0x5F72 => Some('\u{8DF4}'),
        0x5F73 => Some('\u{8DFD}'),
        0x5F74 => Some('\u{8E01}'),
        0x5F75 => Some('\u{8E04}'),
        0x5F76 => Some('\u{8E05}'),
        0x5F77 => Some('\u{8E06}'),
        0x5F78 => Some('\u{8E0B}'),
        0x5F79 => Some('\u{8E11}'),
        0x5F7A => Some('\u{8E14}'),
        0x5F7B => Some('\u{8E16}'),
        0x5F7C => Some('\u{8E20}'),
        0x5F7D => Some('\u{8E21}'),
        0x5F7E => Some('\u{8E22}'),
        0x6021 => Some('\u{8E23}'),
        0x6022 => Some('\u{8E26}'),
        0x6023 => Some('\u{8E27}'),
        0x6024 => Some('\u{8E31}'),
        0x6025 => Some('\u{8E33}'),
        0x6026 => Some('\u{8E36}'),
        0x6027 => Some('\u{8E37}'),
        0x6028 => Some('\u{8E38}'),
        0x6029 => Some('\u{8E39}'),
        0x602A => Some('\u{8E3D}'),
        0x602B => Some('\u{8E40}'),
        0x602C => Some('\u{8E41}'),
        0x602D => Some('\u{8E4B}'),
        0x602E => Some('\u{8E4D}'),
        0x602F => Some('\u{8E4E}'),
        0x6030 => Some('\u{8E4F}'),
        0x6031 => Some('\u{8E54}'),
        0x6032 => Some('\u{8E5B}'),
        0x6033 => Some('\u{8E5C}'),
        0x6034 => Some('\u{8E5D}'),
        0x6035 => Some('\u{8E5E}'),
        0x6036 => Some('\u{8E61}'),
        0x6037 => Some('\u{8E62}'),
        0x6038 => Some('\u{8E69}'),
        0x6039 => Some('\u{8E6C}'),
        0x603A => Some('\u{8E6D}'),
        0x603B => Some('\u{8E6F}'),
        0x603C => Some('\u{8E70}'),
        0x603D => Some('\u{8E71}'),
        0x603E => Some('\u{8E79}'),
        0x603F => Some('\u{8E7A}'),
        0x6040 => Some('\u{8E7B}'),
        0x6041 => Some('\u{8E82}'),
        0x6042 => Some('\u{8E83}'),
        0x6043 => Some('\u{8E89}'),
        0x6044 => Some('\u{8E90}'),
        0x6045 => Some('\u{8E92}'),
        0x6046 => Some('\u{8E95}'),
        0x6047 => Some('\u{8E9A}'),
        0x6048 => Some('\u{8E9B}'),
        0x6049 => Some('\u{8E9D}'),
        0x604A => Some('\u{8E9E}'),
        0x604B => Some('\u{8EA2}'),
        0x604C => Some('\u{8EA7}'),
        0x604D => Some('\u{8EA9}'),
        0x604E => Some('\u{8EAD}'),
        0x604F => Some('\u{8EAE}'),
        0x6050 => Some('\u{8EB3}'),
        0x6051 => Some('\u{8EB5}'),
        0x6052 => Some('\u{8EBA}'),
        0x6053 => Some('\u{8EBB}'),
        0x6054 => Some('\u{8EC0}'),
        0x6055 => Some('\u{8EC1}'),
        0x6056 => Some('\u{8EC3}'),
        0x6057 => Some('\u{8EC4}'),
        0x6058 => Some('\u{8EC7}'),
        0x6059 => Some('\u{8ECF}'),
        0x605A => Some('\u{8ED1}'),
        0x605B => Some('\u{8ED4}'),
        0x605C => Some('\u{8EDC}'),
        0x605D => Some('\u{8EE8}'),
        0x6064 => Some('\u{8EED}'),
        0x605E => Some('\u{8EEE}'),
        0x605F => Some('\u{8EF0}'),
        0x6060 => Some('\u{8EF1}'),
        0x6061 => Some('\u{8EF7}'),
        0x6062 => Some('\u{8EF9}'),
        0x6063 => Some('\u{8EFA}'),
        0x6065 => Some('\u{8F00}'),
        0x6066 => Some('\u{8F02}'),
        0x6067 => Some('\u{8F07}'),
        0x6068 => Some('\u{8F08}'),
        0x6069 => Some('\u{8F0F}'),
        0x606A => Some('\u{8F10}'),
        0x606B => Some('\u{8F16}'),
        0x606C => Some('\u{8F17}'),
        0x606D => Some('\u{8F18}'),
        0x606E => Some('\u{8F1E}'),
        0x606F => Some('\u{8F20}'),
        0x6070 => Some('\u{8F21}'),
        0x6071 => Some('\u{8F23}'),
        0x6072 => Some('\u{8F25}'),
        0x6073 => Some('\u{8F27}'),
        0x6074 => Some('\u{8F28}'),
        0x6075 => Some('\u{8F2C}'),
        0x6076 => Some('\u{8F2D}'),
        0x6077 => Some('\u{8F2E}'),
        0x6078 => Some('\u{8F34}'),
        0x6079 => Some('\u{8F35}'),
        0x607A => Some('\u{8F36}'),
        0x607B => Some('\u{8F37}'),
        0x607C => Some('\u{8F3A}'),
        0x607D => Some('\u{8F40}'),
        0x607E => Some('\u{8F41}'),
        0x6121 => Some('\u{8F43}'),
        0x6122 => Some('\u{8F47}'),
        0x6123 => Some('\u{8F4F}'),
        0x6124 => Some('\u{8F51}'),
        0x6125 => Some('\u{8F52}'),
        0x6126 => Some('\u{8F53}'),
        0x6127 => Some('\u{8F54}'),
        0x6128 => Some('\u{8F55}'),
        0x6129 => Some('\u{8F58}'),
        0x612A => Some('\u{8F5D}'),
        0x612B => Some('\u{8F5E}'),
        0x612C => Some('\u{8F65}'),
        0x612D => Some('\u{8F9D}'),
        0x612E => Some('\u{8FA0}'),
        0x612F => Some('\u{8FA1}'),
        0x6130 => Some('\u{8FA4}'),
        0x6131 => Some('\u{8FA5}'),
        0x6132 => Some('\u{8FA6}'),
        0x6133 => Some('\u{8FB5}'),
        0x6134 => Some('\u{8FB6}'),
        0x6135 => Some('\u{8FB8}'),
        0x6136 => Some('\u{8FBE}'),
        0x6137 => Some('\u{8FC0}'),
        0x6138 => Some('\u{8FC1}'),
        0x6139 => Some('\u{8FC6}'),
        0x613A => Some('\u{8FCA}'),
        0x613B => Some('\u{8FCB}'),
        0x613C => Some('\u{8FCD}'),
        0x613D => Some('\u{8FD0}'),
        0x613E => Some('\u{8FD2}'),
        0x613F => Some('\u{8FD3}'),
        0x6140 => Some('\u{8FD5}'),
        0x6141 => Some('\u{8FE0}'),
        0x6142 => Some('\u{8FE3}'),
        0x6143 => Some('\u{8FE4}'),
        0x6144 => Some('\u{8FE8}'),
        0x6145 => Some('\u{8FEE}'),
        0x6146 => Some('\u{8FF1}'),
        0x6147 => Some('\u{8FF5}'),
        0x6148 => Some('\u{8FF6}'),
        0x6149 => Some('\u{8FFB}'),
        0x614A => Some('\u{8FFE}'),
        0x614B => Some('\u{9002}'),
        0x614C => Some('\u{9004}'),
        0x614D => Some('\u{9008}'),
        0x614E => Some('\u{900C}'),
        0x614F => Some('\u{9018}'),
        0x6150 => Some('\u{901B}'),
        0x6151 => Some('\u{9028}'),
        0x6152 => Some('\u{9029}'),
        0x6154 => Some('\u{902A}'),
        0x6155 => Some('\u{902C}'),
        0x6156 => Some('\u{902D}'),
        0x6153 => Some('\u{902F}'),
        0x6157 => Some('\u{9033}'),
        0x6158 => Some('\u{9034}'),
        0x6159 => Some('\u{9037}'),
        0x615A => Some('\u{903F}'),
        0x615B => Some('\u{9043}'),
        0x615C => Some('\u{9044}'),
        0x615D => Some('\u{904C}'),
        0x615E => Some('\u{905B}'),
        0x615F => Some('\u{905D}'),
        0x6160 => Some('\u{9062}'),
        0x6161 => Some('\u{9066}'),
        0x6162 => Some('\u{9067}'),
        0x6163 => Some('\u{906C}'),
        0x6164 => Some('\u{9070}'),
        0x6165 => Some('\u{9074}'),
        0x6166 => Some('\u{9079}'),
        0x6167 => Some('\u{9085}'),
        0x6168 => Some('\u{9088}'),
        0x6169 => Some('\u{908B}'),
        0x616A => Some('\u{908C}'),
        0x616B => Some('\u{908E}'),
        0x616C => Some('\u{9090}'),
        0x616D => Some('\u{9095}'),
        0x616E => Some('\u{9097}'),
        0x616F => Some('\u{9098}'),
        0x6170 => Some('\u{9099}'),
        0x6171 => Some('\u{909B}'),
        0x6172 => Some('\u{90A0}'),
        0x6173 => Some('\u{90A1}'),
        0x6174 => Some('\u{90A2}'),
        0x6175 => Some('\u{90A5}'),
        0x6176 => Some('\u{90B0}'),
        0x6177 => Some('\u{90B2}'),
        0x6178 => Some('\u{90B3}'),
        0x6179 => Some('\u{90B4}'),
        0x617A => Some('\u{90B6}'),
        0x617B => Some('\u{90BD}'),
        0x617D => Some('\u{90BE}'),
        0x617E => Some('\u{90C3}'),
        0x6221 => Some('\u{90C4}'),
        0x6222 => Some('\u{90C5}'),
        0x6223 => Some('\u{90C7}'),
        0x6224 => Some('\u{90C8}'),
        0x617C => Some('\u{90CC}'),
        0x622D => Some('\u{90D2}'),
        0x6225 => Some('\u{90D5}'),
        0x6226 => Some('\u{90D7}'),
        0x6227 => Some('\u{90D8}'),
        0x6228 => Some('\u{90D9}'),
        0x6229 => Some('\u{90DC}'),
        0x622A => Some('\u{90DD}'),
        0x622B => Some('\u{90DF}'),
        0x622C => Some('\u{90E5}'),
        0x622F => Some('\u{90EB}'),
        0x6230 => Some('\u{90EF}'),
        0x6231 => Some('\u{90F0}'),
        0x6232 => Some('\u{90F4}'),
        0x622E => Some('\u{90F6}'),
        0x6233 => Some('\u{90FE}'),
        0x6234 => Some('\u{90FF}'),
        0x6235 => Some('\u{9100}'),
        0x6236 => Some('\u{9104}'),
        0x6237 => Some('\u{9105}'),
        0x6238 => Some('\u{9106}'),
        0x6239 => Some('\u{9108}'),
        0x623A => Some('\u{910D}'),
        0x623B => Some('\u{9110}'),
        0x623C => Some('\u{9114}'),
        0x623D => Some('\u{9116}'),
        0x623E => Some('\u{9117}'),
        0x623F => Some('\u{9118}'),
        0x6240 => Some('\u{911A}'),
        0x6241 => Some('\u{911C}'),
        0x6242 => Some('\u{911E}'),
        0x6243 => Some('\u{9120}'),
        0x6245 => Some('\u{9122}'),
        0x6246 => Some('\u{9123}'),
        0x6244 => Some('\u{9125}'),
        0x6247 => Some('\u{9127}'),
        0x6248 => Some('\u{9129}'),
        0x6249 => Some('\u{912E}'),
        0x624A => Some('\u{912F}'),
        0x624B => Some('\u{9131}'),
        0x624C => Some('\u{9134}'),
        0x624D => Some('\u{9136}'),
        0x624E => Some('\u{9137}'),
        0x624F => Some('\u{9139}'),
        0x6250 => Some('\u{913A}'),
        0x6251 => Some('\u{913C}'),
        0x6252 => Some('\u{913D}'),
        0x6253 => Some('\u{9143}'),
        0x6254 => Some('\u{9147}'),
        0x6255 => Some('\u{9148}'),
        0x6256 => Some('\u{914F}'),
        0x6257 => Some('\u{9153}'),
        0x6258 => Some('\u{9157}'),
        0x6259 => Some('\u{9159}'),
        0x625A => Some('\u{915A}'),
        0x625B => Some('\u{915B}'),
        0x625C => Some('\u{9161}'),
        0x625D => Some('\u{9164}'),
        0x625E => Some('\u{9167}'),
        0x625F => Some('\u{916D}'),
        0x6260 => Some('\u{9174}'),
        0x6261 => Some('\u{9179}'),
        0x6262 => Some('\u{917A}'),
        0x6263 => Some('\u{917B}'),
        0x6264 => Some('\u{9181}'),
        0x6265 => Some('\u{9183}'),
        0x6266 => Some('\u{9185}'),
        0x6267 => Some('\u{9186}'),
        0x6268 => Some('\u{918A}'),
        0x6269 => Some('\u{918E}'),
        0x626A => Some('\u{9191}'),
        0x626B => Some('\u{9193}'),
        0x626C => Some('\u{9194}'),
        0x626D => Some('\u{9195}'),
        0x626E => Some('\u{9198}'),
        0x626F => Some('\u{919E}'),
        0x6270 => Some('\u{91A1}'),
        0x6271 => Some('\u{91A6}'),
        0x6272 => Some('\u{91A8}'),
        0x6273 => Some('\u{91AC}'),
        0x6274 => Some('\u{91AD}'),
        0x6275 => Some('\u{91AE}'),
        0x6276 => Some('\u{91B0}'),
        0x6277 => Some('\u{91B1}'),
        0x6278 => Some('\u{91B2}'),
        0x6279 => Some('\u{91B3}'),
        0x627A => Some('\u{91B6}'),
        0x627B => Some('\u{91BB}'),
        0x627C => Some('\u{91BC}'),
        0x627D => Some('\u{91BD}'),
        0x627E => Some('\u{91BF}'),
        0x6321 => Some('\u{91C2}'),
        0x6322 => Some('\u{91C3}'),
        0x6323 => Some('\u{91C5}'),
        0x6324 => Some('\u{91D3}'),
        0x6325 => Some('\u{91D4}'),
        0x6326 => Some('\u{91D7}'),
        0x6327 => Some('\u{91D9}'),
        0x6328 => Some('\u{91DA}'),
        0x6329 => Some('\u{91DE}'),
        0x632A => Some('\u{91E4}'),
        0x632B => Some('\u{91E5}'),
        0x632C => Some('\u{91E9}'),
        0x632D => Some('\u{91EA}'),
        0x632E => Some('\u{91EC}'),
        0x632F => Some('\u{91ED}'),
        0x6330 => Some('\u{91EE}'),
        0x6331 => Some('\u{91EF}'),
        0x6332 => Some('\u{91F0}'),
        0x6333 => Some('\u{91F1}'),
        0x6334 => Some('\u{91F7}'),
        0x6335 => Some('\u{91F9}'),
        0x6336 => Some('\u{91FB}'),
        0x6337 => Some('\u{91FD}'),
        0x6338 => Some('\u{9200}'),
        0x6339 => Some('\u{9201}'),
        0x633A => Some('\u{9204}'),
        0x633B => Some('\u{9205}'),
        0x633C => Some('\u{9206}'),
        0x633D => Some('\u{9207}'),
        0x633E => Some('\u{9209}'),
        0x633F => Some('\u{920A}'),
        0x6340 => Some('\u{920C}'),
        0x6341 => Some('\u{9210}'),
        0x6342 => Some('\u{9212}'),
        0x6343 => Some('\u{9213}'),
        0x6344 => Some('\u{9216}'),
        0x6345 => Some('\u{9218}'),
        0x6346 => Some('\u{921C}'),
        0x6347 => Some('\u{921D}'),
        0x6348 => Some('\u{9223}'),
        0x6349 => Some('\u{9224}'),
        0x634A => Some('\u{9225}'),
        0x634B => Some('\u{9226}'),
        0x634C => Some('\u{9228}'),
        0x634D => Some('\u{922E}'),
        0x634E => Some('\u{922F}'),
        0x634F => Some('\u{9230}'),
        0x6350 => Some('\u{9233}'),
        0x6351 => Some('\u{9235}'),
        0x6352 => Some('\u{9236}'),
        0x6353 => Some('\u{9238}'),
        0x6354 => Some('\u{9239}'),
        0x6355 => Some('\u{923A}'),
        0x6356 => Some('\u{923C}'),
        0x6357 => Some('\u{923E}'),
        0x6358 => Some('\u{9240}'),
        0x6359 => Some('\u{9242}'),
        0x635A => Some('\u{9243}'),
        0x635B => Some('\u{9246}'),
        0x635C => Some('\u{9247}'),
        0x635D => Some('\u{924A}'),
        0x635E => Some('\u{924D}'),
        0x635F => Some('\u{924E}'),
        0x6360 => Some('\u{924F}'),
        0x6361 => Some('\u{9251}'),
        0x6362 => Some('\u{9258}'),
        0x6363 => Some('\u{9259}'),
        0x6364 => Some('\u{925C}'),
        0x6365 => Some('\u{925D}'),
        0x6366 => Some('\u{9260}'),
        0x6367 => Some('\u{9261}'),
        0x6368 => Some('\u{9265}'),
        0x6369 => Some('\u{9267}'),
        0x636A => Some('\u{9268}'),
        0x636B => Some('\u{9269}'),
        0x636C => Some('\u{926E}'),
        0x636D => Some('\u{926F}'),
        0x636E => Some('\u{9270}'),
        0x636F => Some('\u{9275}'),
        0x6370 => Some('\u{9276}'),
        0x6371 => Some('\u{9277}'),
        0x6372 => Some('\u{9278}'),
        0x6373 => Some('\u{9279}'),
        0x6374 => Some('\u{927B}'),
        0x6375 => Some('\u{927C}'),
        0x6376 => Some('\u{927D}'),
        0x6377 => Some('\u{927F}'),
        0x6378 => Some('\u{9288}'),
        0x6379 => Some('\u{9289}'),
        0x637A => Some('\u{928A}'),
        0x637B => Some('\u{928D}'),
        0x637C => Some('\u{928E}'),
        0x637D => Some('\u{9292}'),
        0x637E => Some('\u{9297}'),
        0x6421 => Some('\u{9299}'),
        0x6422 => Some('\u{929F}'),
        0x6423 => Some('\u{92A0}'),
        0x6424 => Some('\u{92A4}'),
        0x6425 => Some('\u{92A5}'),
        0x6426 => Some('\u{92A7}'),
        0x6427 => Some('\u{92A8}'),
        0x6428 => Some('\u{92AB}'),
        0x6429 => Some('\u{92AF}'),
        0x642A => Some('\u{92B2}'),
        0x642B => Some('\u{92B6}'),
        0x642C => Some('\u{92B8}'),
        0x642D => Some('\u{92BA}'),
        0x642E => Some('\u{92BB}'),
        0x642F => Some('\u{92BC}'),
        0x6430 => Some('\u{92BD}'),
        0x6431 => Some('\u{92BF}'),
        0x6432 => Some('\u{92C0}'),
        0x6433 => Some('\u{92C1}'),
        0x6434 => Some('\u{92C2}'),
        0x6435 => Some('\u{92C3}'),
        0x6436 => Some('\u{92C5}'),
        0x6437 => Some('\u{92C6}'),
        0x6438 => Some('\u{92C7}'),
        0x6439 => Some('\u{92C8}'),
        0x643A => Some('\u{92CB}'),
        0x643B => Some('\u{92CC}'),
        0x643C => Some('\u{92CD}'),
        0x643D => Some('\u{92CE}'),
        0x643E => Some('\u{92D0}'),
        0x643F => Some('\u{92D3}'),
        0x6440 => Some('\u{92D5}'),
        0x6441 => Some('\u{92D7}'),
        0x6442 => Some('\u{92D8}'),
        0x6443 => Some('\u{92D9}'),
        0x6444 => Some('\u{92DC}'),
        0x6445 => Some('\u{92DD}'),
        0x6446 => Some('\u{92DF}'),
        0x6447 => Some('\u{92E0}'),
        0x6448 => Some('\u{92E1}'),
        0x6449 => Some('\u{92E3}'),
        0x644A => Some('\u{92E5}'),
        0x644B => Some('\u{92E7}'),
        0x644C => Some('\u{92E8}'),
        0x644D => Some('\u{92EC}'),
        0x644E => Some('\u{92EE}'),
        0x644F => Some('\u{92F0}'),
        0x6450 => Some('\u{92F9}'),
        0x6451 => Some('\u{92FB}'),
        0x6452 => Some('\u{92FF}'),
        0x6453 => Some('\u{9300}'),
        0x6454 => Some('\u{9302}'),
        0x6455 => Some('\u{9308}'),
        0x6456 => Some('\u{930D}'),
        0x6457 => Some('\u{9311}'),
        0x6458 => Some('\u{9314}'),
        0x6459 => Some('\u{9315}'),
        0x645A => Some('\u{931C}'),
        0x645B => Some('\u{931D}'),
        0x645C => Some('\u{931E}'),
        0x645D => Some('\u{931F}'),
        0x645E => Some('\u{9321}'),
        0x645F => Some('\u{9324}'),
        0x6460 => Some('\u{9325}'),
        0x6461 => Some('\u{9327}'),
        0x6462 => Some('\u{9329}'),
        0x6463 => Some('\u{932A}'),
        0x6464 => Some('\u{9333}'),
        0x6465 => Some('\u{9334}'),
        0x6466 => Some('\u{9336}'),
        0x6467 => Some('\u{9337}'),
        0x6468 => Some('\u{9347}'),
        0x6469 => Some('\u{9348}'),
        0x646A => Some('\u{9349}'),
        0x646B => Some('\u{9350}'),
        0x646C => Some('\u{9351}'),
        0x646D => Some('\u{9352}'),
        0x646E => Some('\u{9355}'),
        0x646F => Some('\u{9357}'),
        0x6470 => Some('\u{9358}'),
        0x6471 => Some('\u{935A}'),
        0x6472 => Some('\u{935E}'),
        0x6473 => Some('\u{9364}'),
        0x6474 => Some('\u{9365}'),
        0x6475 => Some('\u{9367}'),
        0x6476 => Some('\u{9369}'),
        0x6477 => Some('\u{936A}'),
        0x6478 => Some('\u{936D}'),
        0x6479 => Some('\u{936F}'),
        0x647A => Some('\u{9370}'),
        0x647B => Some('\u{9371}'),
        0x647C => Some('\u{9373}'),
        0x647D => Some('\u{9374}'),
        0x647E => Some('\u{9376}'),
        0x6521 => Some('\u{937A}'),
        0x6522 => Some('\u{937D}'),
        0x6523 => Some('\u{937F}'),
        0x6524 => Some('\u{9380}'),
        0x6525 => Some('\u{9381}'),
        0x6526 => Some('\u{9382}'),
        0x6527 => Some('\u{9388}'),
        0x6528 => Some('\u{938A}'),
        0x6529 => Some('\u{938B}'),
        0x652A => Some('\u{938D}'),
        0x652B => Some('\u{938F}'),
        0x652C => Some('\u{9392}'),
        0x652D => Some('\u{9395}'),
        0x652E => Some('\u{9398}'),
        0x652F => Some('\u{939B}'),
        0x6530 => Some('\u{939E}'),
        0x6531 => Some('\u{93A1}'),
        0x6532 => Some('\u{93A3}'),
        0x6533 => Some('\u{93A4}'),
        0x6534 => Some('\u{93A6}'),
        0x6535 => Some('\u{93A8}'),
        0x653B => Some('\u{93A9}'),
        0x6536 => Some('\u{93AB}'),
        0x6537 => Some('\u{93B4}'),
        0x6538 => Some('\u{93B5}'),
        0x6539 => Some('\u{93B6}'),
        0x653A => Some('\u{93BA}'),
        0x653C => Some('\u{93C1}'),
        0x653D => Some('\u{93C4}'),
        0x653E => Some('\u{93C5}'),
        0x653F => Some('\u{93C6}'),
        0x6540 => Some('\u{93C7}'),
        0x6541 => Some('\u{93C9}'),
        0x6542 => Some('\u{93CA}'),
        0x6543 => Some('\u{93CB}'),
        0x6544 => Some('\u{93CC}'),
        0x6545 => Some('\u{93CD}'),
        0x6546 => Some('\u{93D3}'),
        0x6547 => Some('\u{93D9}'),
        0x6548 => Some('\u{93DC}'),
        0x6549 => Some('\u{93DE}'),
        0x654A => Some('\u{93DF}'),
        0x654B => Some('\u{93E2}'),
        0x654C => Some('\u{93E6}'),
        0x654D => Some('\u{93E7}'),
        0x654F => Some('\u{93F7}'),
        0x6550 => Some('\u{93F8}'),
        0x654E => Some('\u{93F9}'),
        0x6551 => Some('\u{93FA}'),
        0x6552 => Some('\u{93FB}'),
        0x6553 => Some('\u{93FD}'),
        0x6554 => Some('\u{9401}'),
        0x6555 => Some('\u{9402}'),
        0x6556 => Some('\u{9404}'),
        0x6557 => Some('\u{9408}'),
        0x6558 => Some('\u{9409}'),
        0x6559 => Some('\u{940D}'),
        0x655A => Some('\u{940E}'),
        0x655B => Some('\u{940F}'),
        0x655C => Some('\u{9415}'),
        0x655D => Some('\u{9416}'),
        0x655E => Some('\u{9417}'),
        0x655F => Some('\u{941F}'),
        0x6560 => Some('\u{942E}'),
        0x6561 => Some('\u{942F}'),
        0x6562 => Some('\u{9431}'),
        0x6563 => Some('\u{9432}'),
        0x6564 => Some('\u{9433}'),
        0x6565 => Some('\u{9434}'),
        0x6566 => Some('\u{943B}'),
        0x6568 => Some('\u{943D}'),
        0x6567 => Some('\u{943F}'),
        0x6569 => Some('\u{9443}'),
        0x656A => Some('\u{9445}'),
        0x656B => Some('\u{9448}'),
        0x656C => Some('\u{944A}'),
        0x656D => Some('\u{944C}'),
        0x656E => Some('\u{9455}'),
        0x656F => Some('\u{9459}'),
        0x6570 => Some('\u{945C}'),
        0x6571 => Some('\u{945F}'),
        0x6572 => Some('\u{9461}'),
        0x6573 => Some('\u{9463}'),
        0x6574 => Some('\u{9468}'),
        0x6575 => Some('\u{946B}'),
        0x6576 => Some('\u{946D}'),
        0x6577 => Some('\u{946E}'),
        0x6578 => Some('\u{946F}'),
        0x6579 => Some('\u{9471}'),
        0x657A => Some('\u{9472}'),
        0x657C => Some('\u{9483}'),
        0x657B => Some('\u{9484}'),
        0x657D => Some('\u{9578}'),
        0x657E => Some('\u{9579}'),
        0x6621 => Some('\u{957E}'),
        0x6622 => Some('\u{9584}'),
        0x6623 => Some('\u{9588}'),
        0x6624 => Some('\u{958C}'),
        0x6625 => Some('\u{958D}'),
        0x6626 => Some('\u{958E}'),
        0x6627 => Some('\u{959D}'),
        0x6628 => Some('\u{959E}'),
        0x6629 => Some('\u{959F}'),
        0x662A => Some('\u{95A1}'),
        0x662B => Some('\u{95A6}'),
        0x662C => Some('\u{95A9}'),
        0x662D => Some('\u{95AB}'),
        0x662E => Some('\u{95AC}'),
        0x662F => Some('\u{95B4}'),
        0x6630 => Some('\u{95B6}'),
        0x6631 => Some('\u{95BA}'),
        0x6632 => Some('\u{95BD}'),
        0x6633 => Some('\u{95BF}'),
        0x6634 => Some('\u{95C6}'),
        0x6635 => Some('\u{95C8}'),
        0x6636 => Some('\u{95C9}'),
        0x6637 => Some('\u{95CB}'),
        0x6638 => Some('\u{95D0}'),
        0x6639 => Some('\u{95D1}'),
        0x663A => Some('\u{95D2}'),
        0x663B => Some('\u{95D3}'),
        0x663C => Some('\u{95D9}'),
        0x663D => Some('\u{95DA}'),
        0x663E => Some('\u{95DD}'),
        0x663F => Some('\u{95DE}'),
        0x6640 => Some('\u{95DF}'),
        0x6641 => Some('\u{95E0}'),
        0x6642 => Some('\u{95E4}'),
        0x6643 => Some('\u{95E6}'),
        0x6644 => Some('\u{961D}'),
        0x6645 => Some('\u{961E}'),
        0x6646 => Some('\u{9622}'),
        0x6647 => Some('\u{9624}'),
        0x6648 => Some('\u{9625}'),
        0x6649 => Some('\u{9626}'),
        0x664A => Some('\u{962C}'),
        0x664B => Some('\u{9631}'),
        0x664C => Some('\u{9633}'),
        0x664D => Some('\u{9637}'),
        0x664E => Some('\u{9638}'),
        0x664F => Some('\u{9639}'),
        0x6650 => Some('\u{963A}'),
        0x6651 => Some('\u{963C}'),
        0x6652 => Some('\u{963D}'),
        0x6653 => Some('\u{9641}'),
        0x6654 => Some('\u{9652}'),
        0x6655 => Some('\u{9654}'),
        0x6656 => Some('\u{9656}'),
        0x6657 => Some('\u{9657}'),
        0x6658 => Some('\u{9658}'),
        0x6659 => Some('\u{9661}'),
        0x665A => Some('\u{966E}'),
        0x665B => Some('\u{9674}'),
        0x665C => Some('\u{967B}'),
        0x665D => Some('\u{967C}'),
        0x665E => Some('\u{967E}'),
        0x665F => Some('\u{967F}'),
        0x6660 => Some('\u{9681}'),
        0x6661 => Some('\u{9682}'),
        0x6662 => Some('\u{9683}'),
        0x6663 => Some('\u{9684}'),
        0x6664 => Some('\u{9689}'),
        0x6665 => Some('\u{9691}'),
        0x6666 => Some('\u{9696}'),
        0x6667 => Some('\u{969A}'),
        0x6668 => Some('\u{969D}'),
        0x6669 => Some('\u{969F}'),
        0x666A => Some('\u{96A4}'),
        0x666B => Some('\u{96A5}'),
        0x666C => Some('\u{96A6}'),
        0x666D => Some('\u{96A9}'),
        0x666E => Some('\u{96AE}'),
        0x666F => Some('\u{96AF}'),
        0x6670 => Some('\u{96B3}'),
        0x6671 => Some('\u{96BA}'),
        0x6672 => Some('\u{96CA}'),
        0x6673 => Some('\u{96D2}'),
        0x6675 => Some('\u{96D8}'),
        0x6676 => Some('\u{96DA}'),
        0x6677 => Some('\u{96DD}'),
        0x6678 => Some('\u{96DE}'),
        0x6679 => Some('\u{96DF}'),
        0x667A => Some('\u{96E9}'),
        0x667B => Some('\u{96EF}'),
        0x667C => Some('\u{96F1}'),
        0x667D => Some('\u{96FA}'),
        0x667E => Some('\u{9702}'),
        0x6721 => Some('\u{9703}'),
        0x6722 => Some('\u{9705}'),
        0x6723 => Some('\u{9709}'),
        0x6724 => Some('\u{971A}'),
        0x6725 => Some('\u{971B}'),
        0x6726 => Some('\u{971D}'),
        0x6727 => Some('\u{9721}'),
        0x6728 => Some('\u{9722}'),
        0x6729 => Some('\u{9723}'),
        0x672A => Some('\u{9728}'),
        0x672B => Some('\u{9731}'),
        0x672C => Some('\u{9733}'),
        0x672D => Some('\u{9741}'),
        0x672E => Some('\u{9743}'),
        0x672F => Some('\u{974A}'),
        0x6730 => Some('\u{974E}'),
        0x6731 => Some('\u{974F}'),
        0x6732 => Some('\u{9755}'),
        0x6733 => Some('\u{9757}'),
        0x6734 => Some('\u{9758}'),
        0x6735 => Some('\u{975A}'),
        0x6736 => Some('\u{975B}'),
        0x6737 => Some('\u{9763}'),
        0x6738 => Some('\u{9767}'),
        0x6739 => Some('\u{976A}'),
        0x673A => Some('\u{976E}'),
        0x673B => Some('\u{9773}'),
        0x673C => Some('\u{9776}'),
        0x673D => Some('\u{9777}'),
        0x673E => Some('\u{9778}'),
        0x673F => Some('\u{977B}'),
        0x6740 => Some('\u{977D}'),
        0x6741 => Some('\u{977F}'),
        0x6742 => Some('\u{9780}'),
        0x6743 => Some('\u{9789}'),
        0x6744 => Some('\u{9795}'),
        0x6745 => Some('\u{9796}'),
        0x6746 => Some('\u{9797}'),
        0x6747 => Some('\u{9799}'),
        0x6748 => Some('\u{979A}'),
        0x6749 => Some('\u{979E}'),
        0x674A => Some('\u{979F}'),
        0x674B => Some('\u{97A2}'),
        0x674C => Some('\u{97AC}'),
        0x674D => Some('\u{97AE}'),
        0x674E => Some('\u{97B1}'),
        0x674F => Some('\u{97B2}'),
        0x6750 => Some('\u{97B5}'),
        0x6751 => Some('\u{97B6}'),
        0x6752 => Some('\u{97B8}'),
        0x6753 => Some('\u{97B9}'),
        0x6754 => Some('\u{97BA}'),
        0x6755 => Some('\u{97BC}'),
        0x6756 => Some('\u{97BE}'),
        0x6757 => Some('\u{97BF}'),
        0x6758 => Some('\u{97C1}'),
        0x6759 => Some('\u{97C4}'),
        0x675A => Some('\u{97C5}'),
        0x675B => Some('\u{97C7}'),
        0x675C => Some('\u{97C9}'),
        0x675D => Some('\u{97CA}'),
        0x675E => Some('\u{97CC}'),
        0x675F => Some('\u{97CD}'),
        0x6760 => Some('\u{97CE}'),
        0x6761 => Some('\u{97D0}'),
        0x6762 => Some('\u{97D1}'),
        0x6763 => Some('\u{97D4}'),
        0x6764 => Some('\u{97D7}'),
        0x6765 => Some('\u{97D8}'),
        0x6766 => Some('\u{97D9}'),
        0x676A => Some('\u{97DB}'),
        0x6767 => Some('\u{97DD}'),
        0x6768 => Some('\u{97DE}'),
        0x6769 => Some('\u{97E0}'),
        0x676B => Some('\u{97E1}'),
        0x676C => Some('\u{97E4}'),
        0x676D => Some('\u{97EF}'),
        0x676E => Some('\u{97F1}'),
        0x676F => Some('\u{97F4}'),
        0x6770 => Some('\u{97F7}'),
        0x6771 => Some('\u{97F8}'),
        0x6772 => Some('\u{97FA}'),
        0x6773 => Some('\u{9807}'),
        0x6774 => Some('\u{980A}'),
        0x6776 => Some('\u{980D}'),
        0x6777 => Some('\u{980E}'),
        0x6778 => Some('\u{9814}'),
        0x6779 => Some('\u{9816}'),
        0x6775 => Some('\u{9819}'),
        0x677A => Some('\u{981C}'),
        0x677B => Some('\u{981E}'),
        0x677C => Some('\u{9820}'),
        0x677D => Some('\u{9823}'),
        0x6828 => Some('\u{9825}'),
        0x677E => Some('\u{9826}'),
        0x6821 => Some('\u{982B}'),
        0x6822 => Some('\u{982E}'),
        0x6823 => Some('\u{982F}'),
        0x6824 => Some('\u{9830}'),
        0x6825 => Some('\u{9832}'),
        0x6826 => Some('\u{9833}'),
        0x6827 => Some('\u{9835}'),
        0x6829 => Some('\u{983E}'),
        0x682A => Some('\u{9844}'),
        0x682B => Some('\u{9847}'),
        0x682C => Some('\u{984A}'),
        0x682D => Some('\u{9851}'),
        0x682E => Some('\u{9852}'),
        0x682F => Some('\u{9853}'),
        0x6830 => Some('\u{9856}'),
        0x6831 => Some('\u{9857}'),
        0x6832 => Some('\u{9859}'),
        0x6833 => Some('\u{985A}'),
        0x6834 => Some('\u{9862}'),
        0x6835 => Some('\u{9863}'),
        0x6836 => Some('\u{9865}'),
        0x6837 => Some('\u{9866}'),
        0x6838 => Some('\u{986A}'),
        0x6839 => Some('\u{986C}'),
        0x683A => Some('\u{98AB}'),
        0x683B => Some('\u{98AD}'),
        0x683C => Some('\u{98AE}'),
        0x683D => Some('\u{98B0}'),
        0x683E => Some('\u{98B4}'),
        0x683F => Some('\u{98B7}'),
        0x6840 => Some('\u{98B8}'),
        0x6841 => Some('\u{98BA}'),
        0x6842 => Some('\u{98BB}'),
        0x6843 => Some('\u{98BF}'),
        0x6844 => Some('\u{98C2}'),
        0x6845 => Some('\u{98C5}'),
        0x6846 => Some('\u{98C8}'),
        0x6847 => Some('\u{98CC}'),
        0x6848 => Some('\u{98E1}'),
        0x6849 => Some('\u{98E3}'),
        0x684A => Some('\u{98E5}'),
        0x684B => Some('\u{98E6}'),
        0x684C => Some('\u{98E7}'),
        0x684D => Some('\u{98EA}'),
        0x684E => Some('\u{98F3}'),
        0x684F => Some('\u{98F6}'),
        0x6850 => Some('\u{9902}'),
        0x6851 => Some('\u{9907}'),
        0x6852 => Some('\u{9908}'),
        0x6853 => Some('\u{9911}'),
        0x6854 => Some('\u{9915}'),
        0x6855 => Some('\u{9916}'),
        0x6856 => Some('\u{9917}'),
        0x6857 => Some('\u{991A}'),
        0x6858 => Some('\u{991B}'),
        0x6859 => Some('\u{991C}'),
        0x685A => Some('\u{991F}'),
        0x685B => Some('\u{9922}'),
        0x685C => Some('\u{9926}'),
        0x685D => Some('\u{9927}'),
        0x685E => Some('\u{992B}'),
        0x685F => Some('\u{9931}'),
        0x6860 => Some('\u{9932}'),
        0x6861 => Some('\u{9933}'),
        0x6862 => Some('\u{9934}'),
        0x6863 => Some('\u{9935}'),
        0x6864 => Some('\u{9939}'),
        0x6865 => Some('\u{993A}'),
        0x6866 => Some('\u{993B}'),
        0x6867 => Some('\u{993C}'),
        0x6868 => Some('\u{9940}'),
        0x6869 => Some('\u{9941}'),
        0x686A => Some('\u{9946}'),
        0x686B => Some('\u{9947}'),
        0x686C => Some('\u{9948}'),
        0x686D => Some('\u{994D}'),
        0x686E => Some('\u{994E}'),
        0x686F => Some('\u{9954}'),
        0x6870 => Some('\u{9958}'),
        0x6871 => Some('\u{9959}'),
        0x6872 => Some('\u{995B}'),
        0x6873 => Some('\u{995C}'),
        0x6874 => Some('\u{995E}'),
        0x6875 => Some('\u{995F}'),
        0x6876 => Some('\u{9960}'),
        0x6877 => Some('\u{999B}'),
        0x6878 => Some('\u{999D}'),
        0x6879 => Some('\u{999F}'),
        0x687A => Some('\u{99A6}'),
        0x687B => Some('\u{99B0}'),
        0x687C => Some('\u{99B1}'),
        0x687D => Some('\u{99B2}'),
        0x687E => Some('\u{99B5}'),
        0x6921 => Some('\u{99B9}'),
        0x6922 => Some('\u{99BA}'),
        0x6923 => Some('\u{99BD}'),
        0x6924 => Some('\u{99BF}'),
        0x6925 => Some('\u{99C3}'),
        0x6926 => Some('\u{99C9}'),
        0x6927 => Some('\u{99D3}'),
        0x6928 => Some('\u{99D4}'),
        0x6929 => Some('\u{99D9}'),
        0x692A => Some('\u{99DA}'),
        0x692B => Some('\u{99DC}'),
        0x692C => Some('\u{99DE}'),
        0x692D => Some('\u{99E7}'),
        0x692E => Some('\u{99EA}'),
        0x692F => Some('\u{99EB}'),
        0x6930 => Some('\u{99EC}'),
        0x6931 => Some('\u{99F0}'),
        0x6932 => Some('\u{99F4}'),
        0x6933 => Some('\u{99F5}'),
        0x6934 => Some('\u{99F9}'),
        0x6935 => Some('\u{99FD}'),
        0x6936 => Some('\u{99FE}'),
        0x6937 => Some('\u{9A02}'),
        0x6938 => Some('\u{9A03}'),
        0x6939 => Some('\u{9A04}'),
        0x693A => Some('\u{9A0B}'),
        0x693B => Some('\u{9A0C}'),
        0x693C => Some('\u{9A10}'),
        0x693D => Some('\u{9A11}'),
        0x693E => Some('\u{9A16}'),
        0x693F => Some('\u{9A1E}'),
        0x6940 => Some('\u{9A20}'),
        0x6941 => Some('\u{9A22}'),
        0x6942 => Some('\u{9A23}'),
        0x6943 => Some('\u{9A24}'),
        0x6944 => Some('\u{9A27}'),
        0x6945 => Some('\u{9A2D}'),
        0x6946 => Some('\u{9A2E}'),
        0x6947 => Some('\u{9A33}'),
        0x6948 => Some('\u{9A35}'),
        0x6949 => Some('\u{9A36}'),
        0x694A => Some('\u{9A38}'),
        0x694C => Some('\u{9A41}'),
        0x694D => Some('\u{9A44}'),
        0x694B => Some('\u{9A47}'),
        0x694E => Some('\u{9A4A}'),
        0x694F => Some('\u{9A4B}'),
        0x6950 => Some('\u{9A4C}'),
        0x6951 => Some('\u{9A4E}'),
        0x6952 => Some('\u{9A51}'),
        0x6953 => Some('\u{9A54}'),
        0x6954 => Some('\u{9A56}'),
        0x6955 => Some('\u{9A5D}'),
        0x6956 => Some('\u{9AAA}'),
        0x6957 => Some('\u{9AAC}'),
        0x6958 => Some('\u{9AAE}'),
        0x6959 => Some('\u{9AAF}'),
        0x695A => Some('\u{9AB2}'),
        0x695B => Some('\u{9AB4}'),
        0x695C => Some('\u{9AB5}'),
        0x695D => Some('\u{9AB6}'),
        0x695E => Some('\u{9AB9}'),
        0x695F => Some('\u{9ABB}'),
        0x6960 => Some('\u{9ABE}'),
        0x6961 => Some('\u{9ABF}'),
        0x6962 => Some('\u{9AC1}'),
        0x6963 => Some('\u{9AC3}'),
        0x6964 => Some('\u{9AC6}'),
        0x6965 => Some('\u{9AC8}'),
        0x6966 => Some('\u{9ACE}'),
        0x6967 => Some('\u{9AD0}'),
        0x6968 => Some('\u{9AD2}'),
        0x6969 => Some('\u{9AD5}'),
        0x696A => Some('\u{9AD6}'),
        0x696B => Some('\u{9AD7}'),
        0x696C => Some('\u{9ADB}'),
        0x696D => Some('\u{9ADC}'),
        0x696E => Some('\u{9AE0}'),
        0x696F => Some('\u{9AE4}'),
        0x6970 => Some('\u{9AE5}'),
        0x6971 => Some('\u{9AE7}'),
        0x6972 => Some('\u{9AE9}'),
        0x6973 => Some('\u{9AEC}'),
        0x6974 => Some('\u{9AF2}'),
        0x6975 => Some('\u{9AF3}'),
        0x6976 => Some('\u{9AF5}'),
        0x6977 => Some('\u{9AF9}'),
        0x6978 => Some('\u{9AFA}'),
        0x6979 => Some('\u{9AFD}'),
        0x697A => Some('\u{9AFF}'),
        0x697B => Some('\u{9B00}'),
        0x697C => Some('\u{9B01}'),
        0x697D => Some('\u{9B02}'),
        0x697E => Some('\u{9B03}'),
        0x6A21 => Some('\u{9B04}'),
        0x6A22 => Some('\u{9B05}'),
        0x6A23 => Some('\u{9B08}'),
        0x6A24 => Some('\u{9B09}'),
        0x6A25 => Some('\u{9B0B}'),
        0x6A26 => Some('\u{9B0C}'),
        0x6A27 => Some('\u{9B0D}'),
        0x6A28 => Some('\u{9B0E}'),
        0x6A29 => Some('\u{9B10}'),
        0x6A2A => Some('\u{9B12}'),
        0x6A2B => Some('\u{9B16}'),
        0x6A2C => Some('\u{9B19}'),
        0x6A2D => Some('\u{9B1B}'),
        0x6A2E => Some('\u{9B1C}'),
        0x6A2F => Some('\u{9B20}'),
        0x6A30 => Some('\u{9B26}'),
        0x6A31 => Some('\u{9B2B}'),
        0x6A32 => Some('\u{9B2D}'),
        0x6A33 => Some('\u{9B33}'),
        0x6A34 => Some('\u{9B34}'),
        0x6A35 => Some('\u{9B35}'),
        0x6A36 => Some('\u{9B37}'),
        0x6A37 => Some('\u{9B39}'),
        0x6A38 => Some('\u{9B3A}'),
        0x6A39 => Some('\u{9B3D}'),
        0x6A3A => Some('\u{9B48}'),
        0x6A3B => Some('\u{9B4B}'),
        0x6A3C => Some('\u{9B4C}'),
        0x6A3D => Some('\u{9B55}'),
        0x6A3E => Some('\u{9B56}'),
        0x6A3F => Some('\u{9B57}'),
        0x6A40 => Some('\u{9B5B}'),
        0x6A41 => Some('\u{9B5E}'),
        0x6A42 => Some('\u{9B61}'),
        0x6A43 => Some('\u{9B63}'),
        0x6A44 => Some('\u{9B65}'),
        0x6A45 => Some('\u{9B66}'),
        0x6A46 => Some('\u{9B68}'),
        0x6A47 => Some('\u{9B6A}'),
        0x6A48 => Some('\u{9B6B}'),
        0x6A49 => Some('\u{9B6C}'),
        0x6A4A => Some('\u{9B6D}'),
        0x6A4B => Some('\u{9B6E}'),
        0x6A4C => Some('\u{9B73}'),
        0x6A4D => Some('\u{9B75}'),
        0x6A4E => Some('\u{9B77}'),
        0x6A4F => Some('\u{9B78}'),
        0x6A50 => Some('\u{9B79}'),
        0x6A51 => Some('\u{9B7F}'),
        0x6A52 => Some('\u{9B80}'),
        0x6A53 => Some('\u{9B84}'),
        0x6A54 => Some('\u{9B85}'),
        0x6A55 => Some('\u{9B86}'),
        0x6A56 => Some('\u{9B87}'),
        0x6A57 => Some('\u{9B89}'),
        0x6A58 => Some('\u{9B8A}'),
        0x6A59 => Some('\u{9B8B}'),
        0x6A5A => Some('\u{9B8D}'),
        0x6A5B => Some('\u{9B8F}'),
        0x6A5C => Some('\u{9B90}'),
        0x6A5D => Some('\u{9B94}'),
        0x6A5E => Some('\u{9B9A}'),
        0x6A5F => Some('\u{9B9D}'),
        0x6A60 => Some('\u{9B9E}'),
        0x6A61 => Some('\u{9BA6}'),
        0x6A62 => Some('\u{9BA7}'),
        0x6A63 => Some('\u{9BA9}'),
        0x6A64 => Some('\u{9BAC}'),
        0x6A65 => Some('\u{9BB0}'),
        0x6A66 => Some('\u{9BB1}'),
        0x6A67 => Some('\u{9BB2}'),
        0x6A68 => Some('\u{9BB7}'),
        0x6A69 => Some('\u{9BB8}'),
        0x6A6A => Some('\u{9BBB}'),
        0x6A6B => Some('\u{9BBC}'),
        0x6A6C => Some('\u{9BBE}'),
        0x6A6D => Some('\u{9BBF}'),
        0x6A6E => Some('\u{9BC1}'),
        0x6A6F => Some('\u{9BC7}'),
        0x6A70 => Some('\u{9BC8}'),
        0x6A71 => Some('\u{9BCE}'),
        0x6A72 => Some('\u{9BD0}'),
        0x6A73 => Some('\u{9BD7}'),
        0x6A74 => Some('\u{9BD8}'),
        0x6A75 => Some('\u{9BDD}'),
        0x6A76 => Some('\u{9BDF}'),
        0x6A77 => Some('\u{9BE5}'),
        0x6A78 => Some('\u{9BE7}'),
        0x6A79 => Some('\u{9BEA}'),
        0x6A7A => Some('\u{9BEB}'),
        0x6A7B => Some('\u{9BEF}'),
        0x6A7C => Some('\u{9BF3}'),
        0x6A7D => Some('\u{9BF7}'),
        0x6A7E => Some('\u{9BF8}'),
        0x6B21 => Some('\u{9BF9}'),
        0x6B22 => Some('\u{9BFA}'),
        0x6B23 => Some('\u{9BFD}'),
        0x6B24 => Some('\u{9BFF}'),
        0x6B25 => Some('\u{9C00}'),
        0x6B26 => Some('\u{9C02}'),
        0x6B27 => Some('\u{9C0B}'),
        0x6B28 => Some('\u{9C0F}'),
        0x6B29 => Some('\u{9C11}'),
        0x6B2A => Some('\u{9C16}'),
        0x6B2B => Some('\u{9C18}'),
        0x6B2C => Some('\u{9C19}'),
        0x6B2D => Some('\u{9C1A}'),
        0x6B2E => Some('\u{9C1C}'),
        0x6B2F => Some('\u{9C1E}'),
        0x6B30 => Some('\u{9C22}'),
        0x6B31 => Some('\u{9C23}'),
        0x6B32 => Some('\u{9C26}'),
        0x6B33 => Some('\u{9C27}'),
        0x6B34 => Some('\u{9C28}'),
        0x6B35 => Some('\u{9C29}'),
        0x6B36 => Some('\u{9C2A}'),
        0x6B37 => Some('\u{9C31}'),
        0x6B38 => Some('\u{9C35}'),
        0x6B39 => Some('\u{9C36}'),
        0x6B3A => Some('\u{9C37}'),
        0x6B3B => Some('\u{9C3D}'),
        0x6B3C => Some('\u{9C41}'),
        0x6B3D => Some('\u{9C43}'),
        0x6B3E => Some('\u{9C44}'),
        0x6B3F => Some('\u{9C45}'),
        0x6B40 => Some('\u{9C49}'),
        0x6B41 => Some('\u{9C4A}'),
        0x6B42 => Some('\u{9C4E}'),
        0x6B43 => Some('\u{9C4F}'),
        0x6B44 => Some('\u{9C50}'),
        0x6B45 => Some('\u{9C53}'),
        0x6B46 => Some('\u{9C54}'),
        0x6B47 => Some('\u{9C56}'),
        0x6B48 => Some('\u{9C58}'),
        0x6B49 => Some('\u{9C5B}'),
        0x6B50 => Some('\u{9C5C}'),
        0x6B4A => Some('\u{9C5D}'),
        0x6B4B => Some('\u{9C5E}'),
        0x6B4C => Some('\u{9C5F}'),
        0x6B4D => Some('\u{9C63}'),
        0x6B52 => Some('\u{9C68}'),
        0x6B4E => Some('\u{9C69}'),
        0x6B4F => Some('\u{9C6A}'),
        0x6B51 => Some('\u{9C6B}'),
        0x6B53 => Some('\u{9C6E}'),
        0x6B54 => Some('\u{9C70}'),
        0x6B55 => Some('\u{9C72}'),
        0x6B56 => Some('\u{9C75}'),
        0x6B57 => Some('\u{9C77}'),
        0x6B58 => Some('\u{9C7B}'),
        0x6B59 => Some('\u{9CE6}'),
        0x6B5A => Some('\u{9CF2}'),
        0x6B5B => Some('\u{9CF7}'),
        0x6B5C => Some('\u{9CF9}'),
        0x6B5E => Some('\u{9D02}'),
        0x6B5D => Some('\u{9D0B}'),
        0x6B5F => Some('\u{9D11}'),
        0x6B60 => Some('\u{9D17}'),
        0x6B61 => Some('\u{9D18}'),
        0x6B62 => Some('\u{9D1C}'),
        0x6B63 => Some('\u{9D1D}'),
        0x6B64 => Some('\u{9D1E}'),
        0x6B65 => Some('\u{9D2F}'),
        0x6B66 => Some('\u{9D30}'),
        0x6B67 => Some('\u{9D32}'),
        0x6B68 => Some('\u{9D33}'),
        0x6B69 => Some('\u{9D34}'),
        0x6B6A => Some('\u{9D3A}'),
        0x6B6B => Some('\u{9D3C}'),
        0x6B6D => Some('\u{9D3D}'),
        0x6B6E => Some('\u{9D42}'),
        0x6B6F => Some('\u{9D43}'),
        0x6B6C => Some('\u{9D45}'),
        0x6B70 => Some('\u{9D47}'),
        0x6B71 => Some('\u{9D4A}'),
        0x6B72 => Some('\u{9D53}'),
        0x6B73 => Some('\u{9D54}'),
        0x6B74 => Some('\u{9D5F}'),
        0x6B76 => Some('\u{9D62}'),
        0x6B75 => Some('\u{9D63}'),
        0x6B77 => Some('\u{9D65}'),
        0x6B78 => Some('\u{9D69}'),
        0x6B79 => Some('\u{9D6A}'),
        0x6B7A => Some('\u{9D6B}'),
        0x6B7B => Some('\u{9D70}'),
        0x6B7C => Some('\u{9D76}'),
        0x6B7D => Some('\u{9D77}'),
        0x6B7E => Some('\u{9D7B}'),
        0x6C21 => Some('\u{9D7C}'),
        0x6C22 => Some('\u{9D7E}'),
        0x6C23 => Some('\u{9D83}'),
        0x6C24 => Some('\u{9D84}'),
        0x6C25 => Some('\u{9D86}'),
        0x6C26 => Some('\u{9D8A}'),
        0x6C27 => Some('\u{9D8D}'),
        0x6C28 => Some('\u{9D8E}'),
        0x6C29 => Some('\u{9D92}'),
        0x6C2A => Some('\u{9D93}'),
        0x6C2B => Some('\u{9D95}'),
        0x6C2C => Some('\u{9D96}'),
        0x6C2D => Some('\u{9D97}'),
        0x6C2E => Some('\u{9D98}'),
        0x6C2F => Some('\u{9DA1}'),
        0x6C30 => Some('\u{9DAA}'),
        0x6C31 => Some('\u{9DAC}'),
        0x6C32 => Some('\u{9DAE}'),
        0x6C33 => Some('\u{9DB1}'),
        0x6C34 => Some('\u{9DB5}'),
        0x6C35 => Some('\u{9DB9}'),
        0x6C36 => Some('\u{9DBC}'),
        0x6C37 => Some('\u{9DBF}'),
        0x6C38 => Some('\u{9DC3}'),
        0x6C39 => Some('\u{9DC7}'),
        0x6C3A => Some('\u{9DC9}'),
        0x6C3B => Some('\u{9DCA}'),
        0x6C3C => Some('\u{9DD4}'),
        0x6C3D => Some('\u{9DD5}'),
        0x6C3E => Some('\u{9DD6}'),
        0x6C3F => Some('\u{9DD7}'),
        0x6C40 => Some('\u{9DDA}'),
        0x6C41 => Some('\u{9DDE}'),
        0x6C42 => Some('\u{9DDF}'),
        0x6C43 => Some('\u{9DE0}'),
        0x6C44 => Some('\u{9DE5}'),
        0x6C45 => Some('\u{9DE7}'),
        0x6C46 => Some('\u{9DE9}'),
        0x6C47 => Some('\u{9DEB}'),
        0x6C48 => Some('\u{9DEE}'),
        0x6C49 => Some('\u{9DF0}'),
        0x6C4A => Some('\u{9DF3}'),
        0x6C4B => Some('\u{9DF4}'),
        0x6C4C => Some('\u{9DFE}'),
        0x6C4E => Some('\u{9E02}'),
        0x6C4F => Some('\u{9E07}'),
        0x6C4D => Some('\u{9E0A}'),
        0x6C50 => Some('\u{9E0E}'),
        0x6C51 => Some('\u{9E10}'),
        0x6C52 => Some('\u{9E11}'),
        0x6C53 => Some('\u{9E12}'),
        0x6C54 => Some('\u{9E15}'),
        0x6C55 => Some('\u{9E16}'),
        0x6C56 => Some('\u{9E19}'),
        0x6C57 => Some('\u{9E1C}'),
        0x6C58 => Some('\u{9E1D}'),
        0x6C59 => Some('\u{9E7A}'),
        0x6C5A => Some('\u{9E7B}'),
        0x6C5B => Some('\u{9E7C}'),
        0x6C5C => Some('\u{9E80}'),
        0x6C5D => Some('\u{9E82}'),
        0x6C5E => Some('\u{9E83}'),
        0x6C5F => Some('\u{9E84}'),
        0x6C60 => Some('\u{9E85}'),
        0x6C61 => Some('\u{9E87}'),
        0x6C62 => Some('\u{9E8E}'),
        0x6C63 => Some('\u{9E8F}'),
        0x6C64 => Some('\u{9E96}'),
        0x6C65 => Some('\u{9E98}'),
        0x6C66 => Some('\u{9E9B}'),
        0x6C67 => Some('\u{9E9E}'),
        0x6C68 => Some('\u{9EA4}'),
        0x6C69 => Some('\u{9EA8}'),
        0x6C6A => Some('\u{9EAC}'),
        0x6C6B => Some('\u{9EAE}'),
        0x6C6C => Some('\u{9EAF}'),
        0x6C6D => Some('\u{9EB0}'),
        0x6C6E => Some('\u{9EB3}'),
        0x6C6F => Some('\u{9EB4}'),
        0x6C70 => Some('\u{9EB5}'),
        0x6C71 => Some('\u{9EC6}'),
        0x6C72 => Some('\u{9EC8}'),
        0x6C73 => Some('\u{9ECB}'),
        0x6C74 => Some('\u{9ED5}'),
        0x6C75 => Some('\u{9EDF}'),
        0x6C76 => Some('\u{9EE4}'),
        0x6C77 => Some('\u{9EE7}'),
        0x6C78 => Some('\u{9EEC}'),
        0x6C79 => Some('\u{9EED}'),
        0x6C7A => Some('\u{9EEE}'),
        0x6C7B => Some('\u{9EF0}'),
        0x6C7C => Some('\u{9EF1}'),
        0x6C7D => Some('\u{9EF2}'),
        0x6C7E => Some('\u{9EF5}'),
        0x6D21 => Some('\u{9EF8}'),
        0x6D22 => Some('\u{9EFF}'),
        0x6D23 => Some('\u{9F02}'),
        0x6D24 => Some('\u{9F03}'),
        0x6D25 => Some('\u{9F09}'),
        0x6D26 => Some('\u{9F0F}'),
        0x6D27 => Some('\u{9F10}'),
        0x6D28 => Some('\u{9F11}'),
        0x6D29 => Some('\u{9F12}'),
        0x6D2A => Some('\u{9F14}'),
        0x6D2B => Some('\u{9F16}'),
        0x6D2C => Some('\u{9F17}'),
        0x6D2D => Some('\u{9F19}'),
        0x6D2E => Some('\u{9F1A}'),
        0x6D2F => Some('\u{9F1B}'),
        0x6D30 => Some('\u{9F1F}'),
        0x6D31 => Some('\u{9F22}'),
        0x6D32 => Some('\u{9F26}'),
        0x6D33 => Some('\u{9F2A}'),
        0x6D34 => Some('\u{9F2B}'),
        0x6D35 => Some('\u{9F2F}'),
        0x6D36 => Some('\u{9F31}'),
        0x6D37 => Some('\u{9F32}'),
        0x6D38 => Some('\u{9F34}'),
        0x6D39 => Some('\u{9F37}'),
        0x6D3A => Some('\u{9F39}'),
        0x6D3B => Some('\u{9F3A}'),
        0x6D3C => Some('\u{9F3C}'),
        0x6D3D => Some('\u{9F3D}'),
        0x6D3E => Some('\u{9F3F}'),
        0x6D3F => Some('\u{9F41}'),
        0x6D40 => Some('\u{9F43}'),
        0x6D41 => Some('\u{9F44}'),
        0x6D42 => Some('\u{9F45}'),
        0x6D43 => Some('\u{9F46}'),
        0x6D44 => Some('\u{9F47}'),
        0x6D45 => Some('\u{9F53}'),
        0x6D46 => Some('\u{9F55}'),
        0x6D47 => Some('\u{9F56}'),
        0x6D48 => Some('\u{9F57}'),
        0x6D49 => Some('\u{9F58}'),
        0x6D4A => Some('\u{9F5A}'),
        0x6D4B => Some('\u{9F5D}'),
        0x6D4C => Some('\u{9F5E}'),
        0x6D4D => Some('\u{9F68}'),
        0x6D4E => Some('\u{9F69}'),
        0x6D4F => Some('\u{9F6D}'),
        0x6D50 => Some('\u{9F6E}'),
        0x6D51 => Some('\u{9F6F}'),
        0x6D52 => Some('\u{9F70}'),
        0x6D53 => Some('\u{9F71}'),
        0x6D54 => Some('\u{9F73}'),
        0x6D55 => Some('\u{9F75}'),
        0x6D56 => Some('\u{9F7A}'),
        0x6D57 => Some('\u{9F7D}'),
        0x6D58 => Some('\u{9F8F}'),
        0x6D59 => Some('\u{9F90}'),
        0x6D5A => Some('\u{9F91}'),
        0x6D5B => Some('\u{9F92}'),
        0x6D5C => Some('\u{9F94}'),
        0x6D5D => Some('\u{9F96}'),
        0x6D5E => Some('\u{9F97}'),
        0x6D5F => Some('\u{9F9E}'),
        0x6D60 => Some('\u{9FA1}'),
        0x6D61 => Some('\u{9FA2}'),
        0x6D62 => Some('\u{9FA3}'),
        0x6D63 => Some('\u{9FA5}'),
        _ => None,
    }
}
