import json
import pandas as pd
import textwrap


with open("./assets/pokemon.json", "r") as f:
    data = json.load(f)

df = pd.read_csv("./pokemon_species_flavor_text.csv")

languages = {"en": 9, "fr": 5, "de": 6, "ja": 11, "zh_hans": 12, "zh_hant": 4}

for p in data:
    idx = p["idx"]
    name = p["slug"]
    desc = {}
    for lang, id in languages.items():
        descriptions = list(df.query(f"language_id == {id} and species_id == {idx}")
                            ["flavor_text"])
        if descriptions == []:
            print(f"could not find {lang} desc for pokemon {name} ({idx})")
            continue
        latest_desc = descriptions[0]#.replace("\f", " ")
        # remove double space
        latest_desc = " ".join(latest_desc.split())
        # latest_desc = textwrap.fill(latest_desc, 50)
        words = latest_desc.split(" ")
        new_words = []
        for word in words:
            if word.isupper() or not word.islower():
                new_words.append(word.lower().title())
            else:
                new_words.append(word)
        desc[lang] = " ".join(new_words)

    p["desc"] = desc

with open("./assets/pokemon.json", "w") as f:
    json.dump(data, f)
