import json
import pandas as pd


with open("./pokemon.json", "r") as f:
    data = json.load(f)

df = pd.read_csv("./pokemon_species_flavor_text.csv")

languages = {"en": 9, "fr": 5, "de": 6, "ja": 11, "zh_hans": 12, "zh_hant": 4}

for p in data:
    idx = p["idx"]
    name = p["slug"]
    desc = {}
    for lang, id in languages.items():
        descriptions = list(df.query(f"language_id == {id} and species_id == {idx}")
                            ["flavor_text"])
        if descriptions == []:
            print(f"could not find desc for pokemon {name} ({idx})")
            continue
        latest_desc = descriptions[-1]#.replace("\n", " ")
        desc[lang] = latest_desc

    p["desc"] = desc

with open("./pokemon2.json", "w") as f:
    json.dump(data, f)
