use super::{
    color::{RGBPrimaries, WhitePoint},
};
use crate::{
    FType, Mat3,
};#[rustfmt::skip]
pub const BT_709_D65_TO_BT_2020_D65: [FType; 9] = [
    0.6274523942229207, 0.3292484773484975, 0.04329912842858205,
    0.06910918409232207, 0.919531079275882, 0.01135973663179622,
    0.016397562151213345, 0.088030140698202, 0.8955722971505848];


#[rustfmt::skip]
pub const BT_709_D65_TO_AP1_D60: [FType; 9] = [
    0.6141439932086278, 0.3348473538601437, 0.05100865293122844,
    0.07058736865623247, 0.9163972000879493, 0.01301543125581777,
    0.020322353402197846, 0.1081907727011861, 0.8714868738966164];


#[rustfmt::skip]
pub const BT_709_D65_TO_AP0_D60: [FType; 9] = [
    0.44031076211968634, 0.3795605229730174, 0.18012871490729662,
    0.09011947729436987, 0.8131824149012692, 0.09669810780436126,
    0.017244301211473752, 0.11019333877094085, 0.8725623600175858];


#[rustfmt::skip]
pub const BT_709_D65_TO_CIE_RGB_E: [FType; 9] = [
    0.8458657280419494, 0.21621113822313157, -0.0620768662650813,
    0.09647578689010416, 0.8152111904937543, 0.08831302261614174,
    0.0159702649068187, 0.10221736503498981, 0.8818123700581916];


#[rustfmt::skip]
pub const BT_709_D65_TO_CIE_XYZ_D65: [FType; 9] = [
    0.4124564390896922, 0.357576077643909, 0.18043748326639894,
    0.21267285140562253, 0.715152155287818, 0.07217499330655958,
    0.0193338955823293, 0.11919202588130297, 0.9503040785363679];


#[rustfmt::skip]
pub const BT_709_D65_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.5329726559395586, 0.3154915630402366, 0.15153578102020504,
    0.10009717799863485, 0.8723090507654531, 0.027593771235912504,
    0.015622008755598295, 0.11222577163625706, 0.872152219608145];


#[rustfmt::skip]
pub const BT_709_D65_TO_APPLE_D65: [FType; 9] = [
    0.9339964668491743, 0.07679518382044535, -0.010791650669619457,
    -0.02343991165235305, 1.0401905017945687, -0.016750590142215978,
    -0.0009532408239193435, -0.03208655629779869, 1.0330397971217185];


#[rustfmt::skip]
pub const BT_709_D65_TO_P3_D60: [FType; 9] = [
    0.8075781604673232, 0.18392605492200859, 0.008495784610668078,
    0.033102859164962355, 0.9660576203335867, 0.0008395205014512276,
    0.01650441376091509, 0.07026264373757989, 0.913232942501505];


#[rustfmt::skip]
pub const BT_709_D65_TO_P3_P3_DCI: [FType; 9] = [
    0.8508162319504055, 0.142111793278051, 0.007071974771543588,
    0.03353364183459157, 0.9644901042729992, 0.0019762538924096677,
    0.01652157729855184, 0.0675453243302976, 0.9159330983711503];


#[rustfmt::skip]
pub const BT_709_D65_TO_P3_D65: [FType; 9] = [
    0.8224885805723389, 0.17751141942766147, 0.00000000000000005551115123125783,
    0.033200048527963384, 0.9667999514720368, -0.00000000000000001734723475976807,
    0.017089065365509325, 0.07241151216859087, 0.9104994224658999];


#[rustfmt::skip]
pub const BT_709_D65_TO_ADOBE_1998_D65: [FType; 9] = [
    0.7151627357665418, 0.2848372642334579, 0.0,
    0.00000000000000004206704429243757, 1.0, 0.000000000000000027755575615628914,
    0.000000000000000003469446951953614, 0.04117050854683148, 0.9588294914531689];


#[rustfmt::skip]
pub const BT_709_D65_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.597501984923119, 0.3893468845053031, 0.013151130571577963,
    0.09702573461016586, 0.8418084763809839, 0.06116578900885043,
    0.010172006119462146, 0.06338000171115732, 0.9264479921693811];


#[rustfmt::skip]
pub const BT_2020_D65_TO_BT_709_D65: [FType; 9] = [
    1.6603626561622697, -0.5875399968755312, -0.07282265928673903,
    -0.12456354851556833, 1.1329113745720412, -0.008347826056473065,
    -0.018156605779362994, -0.1006017318464808, 1.1187583376258436];


#[rustfmt::skip]
pub const BT_2020_D65_TO_AP1_D60: [FType; 9] = [
    0.9770658332195041, 0.013386657258545143, 0.009547509521950659,
    0.0028146277665209727, 0.9954145343208096, 0.0017708379126687088,
    0.004442606498810242, 0.022957272767006, 0.9726001207341838];


#[rustfmt::skip]
pub const BT_2020_D65_TO_AP0_D60: [FType; 9] = [
    0.6805256148458169, 0.15318698933962568, 0.16628739581455765,
    0.046582418078859995, 0.8585868129242537, 0.09483076899688637,
    -0.0009370503256916523, 0.02692628565393756, 0.9740107646717544];


#[rustfmt::skip]
pub const BT_2020_D65_TO_CIE_RGB_E: [FType; 9] = [
    1.3786389455514936, -0.24578684915486262, -0.13285209639663143,
    0.05703573036187016, 0.8579942038410319, 0.08497006579709794,
    -0.0022268458228812643, 0.017708194541964817, 0.9845186512809164];


#[rustfmt::skip]
pub const BT_2020_D65_TO_CIE_XYZ_D65: [FType; 9] = [
    0.6370101914111008, 0.14461502739696927, 0.16884478119192986,
    0.26272171736164046, 0.6779892755022618, 0.0592890071360975,
    0.00000000000000004994515405547192, 0.028072328847646908, 1.060757671152353];


#[rustfmt::skip]
pub const BT_2020_D65_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.8428777706211985, 0.02903646573698275, 0.12808576364181884,
    0.057038696344272555, 0.9266617689312463, 0.01629953472448147,
    -0.003876364428896088, 0.03022327450505458, 0.9736530899238417];


#[rustfmt::skip]
pub const BT_2020_D65_TO_APPLE_D65: [FType; 9] = [
    1.5414029136852074, -0.4606724852049418, -0.08073042848026585,
    -0.16818444014524703, 1.1939006752016097, -0.025716235056363355,
    -0.016342406504998852, -0.13971675014669718, 1.1560591566516965];


#[rustfmt::skip]
pub const BT_2020_D65_TO_P3_D60: [FType; 9] = [
    1.3178078828946478, -0.2669672408216405, -0.05084064207300748,
    -0.06538805693234334, 1.074923955581199, -0.009535898648855661,
    0.0020699375167084716, -0.021968470506622317, 1.0198985329899135];


#[rustfmt::skip]
pub const BT_2020_D65_TO_P3_P3_DCI: [FType; 9] = [
    1.394833146472516, -0.33959995210584965, -0.055233194366666294,
    -0.064498185331963, 1.0727806394101889, -0.008282454078225733,
    0.0023878884958014805, -0.025328677193069016, 1.022940788697267];


#[rustfmt::skip]
pub const BT_2020_D65_TO_P3_D65: [FType; 9] = [
    1.343517871996279, -0.282140231873606, -0.06137764012267283,
    -0.06530391190143064, 1.0757923055499805, -0.010488393648550264,
    0.0028226319764587523, -0.01960250237098883, 1.0167798703945299];


#[rustfmt::skip]
pub const BT_2020_D65_TO_ADOBE_1998_D65: [FType; 9] = [
    1.151949159163225, -0.09749133498570377, -0.05445782417752176,
    -0.12456354851556817, 1.1329113745720412, -0.008347826056473065,
    -0.022537433724726153, -0.04981736995604846, 1.0723548036807746];


#[rustfmt::skip]
pub const BT_2020_D65_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.943332773318376, 0.08871617324415176, -0.0320489465625276,
    0.055128692326713746, 0.8905345139894264, 0.05433679368385984,
    -0.00782676978795735, -0.02737480806261575, 1.0352015778505734];


#[rustfmt::skip]
pub const AP1_D60_TO_BT_709_D65: [FType; 9] = [
    1.70150705829719, -0.6110425859262977, -0.09046447237089245,
    -0.13072902802234107, 1.140104545849696, -0.009375517827355101,
    -0.023448377492443606, -0.1272893163664402, 1.1507376938588838];


#[rustfmt::skip]
pub const AP1_D60_TO_BT_2020_D65: [FType; 9] = [
    1.0235570497856787, -0.013533964229444466, -0.010023085556234018,
    -0.002886007096581449, 1.004686935863517, -0.0018009287669354355,
    -0.004607244286351307, -0.023652830658976578, 1.028260074945328];


#[rustfmt::skip]
pub const AP1_D60_TO_AP0_D60: [FType; 9] = [
    0.6953485652425724, 0.1407615899913178, 0.16388984476611007,
    0.044764966266919184, 0.8597374933493469, 0.09549754038373406,
    -0.005524339448726105, 0.004027057756628111, 1.0014972816920982];


#[rustfmt::skip]
pub const AP1_D60_TO_CIE_RGB_E: [FType; 9] = [
    1.4124370364812864, -0.2624549583886008, -0.1499820780926857,
    0.05551166869030181, 0.8592338655338057, 0.08525446577589288,
    -0.00686632764683196, -0.0054653231735984735, 1.0123316508204308];


#[rustfmt::skip]
pub const AP1_D60_TO_CIE_XYZ_D65: [FType; 9] = [
    0.65082100305539, 0.13267789859374557, 0.16697109835086446,
    0.2666808251374308, 0.6762089485818938, 0.0571102262806755,
    -0.004968186659891823, 0.003113980486518425, 1.0906842061733732];


#[rustfmt::skip]
pub const AP1_D60_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.8620595623780856, 0.014735489314968304, 0.12320494830694627,
    0.05563291137426895, 0.9298474833987243, 0.014519605227006998,
    -0.008540762358878459, 0.007387739975208292, 1.0011530223836702];


#[rustfmt::skip]
pub const AP1_D60_TO_APPLE_D65: [FType; 9] = [
    1.5794152677295317, -0.48178341634029087, -0.09763185138924052,
    -0.17547349421914055, 1.2023808750435392, -0.026907380824398953,
    -0.02165040880038787, -0.16749448751267396, 1.189144896313062];


#[rustfmt::skip]
pub const AP1_D60_TO_P3_D60: [FType; 9] = [
    1.3498562534092278, -0.28485113880786134, -0.06500511460136688,
    -0.06998671059441484, 1.081072565838644, -0.011085855244228823,
    -0.0025168213891498996, -0.04622293706936381, 1.0487397584585134];


#[rustfmt::skip]
pub const AP1_D60_TO_P3_P3_DCI: [FType; 9] = [
    1.4289258610376225, -0.3587628358179171, -0.07016302521970591,
    -0.06907546554409785, 1.0788775130796278, -0.009802047535528706,
    -0.002195699257895263, -0.049675153925283176, 1.051870853183178];


#[rustfmt::skip]
pub const AP1_D60_TO_P3_D65: [FType; 9] = [
    1.3762642298880274, -0.30019397293806327, -0.07607025694996405,
    -0.06989870104184694, 1.0819663760951292, -0.012067675053282375,
    -0.0017388554289439586, -0.04378230153446635, 1.0455211569634102];


#[rustfmt::skip]
pub const AP1_D60_TO_ADOBE_1998_D65: [FType; 9] = [
    1.1796179440401169, -0.11225062764095695, -0.0673673163991601,
    -0.13072902802234096, 1.1401045458496961, -0.00937551782735508,
    -0.027865176431994407, -0.07511006652986907, 1.1029752429618633];


#[rustfmt::skip]
pub const AP1_D60_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.9654465322442687, 0.07712299655349224, -0.04256952879776088,
    0.05360692986711079, 0.8926770634112212, 0.05371600672166812,
    -0.012701568057950956, -0.05188263242874399, 1.0645842004866954];


#[rustfmt::skip]
pub const AP0_D60_TO_BT_709_D65: [FType; 9] = [
    2.5160003103784887, -1.120815791571519, -0.3951845188069694,
    -0.2770794071389051, 1.3719171373747592, -0.09483773023585473,
    -0.014731740460086115, -0.15110489612376043, 1.1658366365838464];


#[rustfmt::skip]
pub const AP0_D60_TO_BT_2020_D65: [FType; 9] = [
    1.4868045741853277, -0.2580996336789089, -0.22870494050641854,
    -0.08107174635702696, 1.1823452693102523, -0.10127352295322543,
    0.0036715936220255846, -0.03293394690523746, 1.0292623532832117];


#[rustfmt::skip]
pub const AP0_D60_TO_AP1_D60: [FType; 9] = [
    1.4516557250041906, -0.2366671199242865, -0.2149886050799043,
    -0.0765086914114762, 1.1761388905796017, -0.09963019916812614,
    0.00831509386898968, -0.006034772993874998, 0.9977196791248852];


#[rustfmt::skip]
pub const AP0_D60_TO_CIE_RGB_E: [FType; 9] = [
    2.069205280578771, -0.642055781290266, -0.427149499288505,
    0.015553871876073877, 0.9969260872585566, -0.012479959134630403,
    -0.001131766411004165, -0.010912136852638905, 1.0120439032636432];


#[rustfmt::skip]
pub const AP0_D60_TO_CIE_XYZ_D65: [FType; 9] = [
    0.9360054029938909, 0.0010120714020409225, 0.013452525604068349,
    0.3358677616752651, 0.7318564125095669, -0.06772417418483223,
    0.0016187983759302863, -0.0017437516095178966, 1.0889549532335876];


#[rustfmt::skip]
pub const AP0_D60_TO_PRO_PHOTO_D50: [FType; 9] = [
    1.2513107667262555, -0.18743368567091243, -0.06387708105534297,
    0.009739152008420904, 1.0803756841033534, -0.09011483611177436,
    -0.0046387915338147005, 0.004668594705548271, 0.9999701968282665];


#[rustfmt::skip]
pub const AP0_D60_TO_APPLE_D65: [FType; 9] = [
    2.328816016277643, -0.9398506893120087, -0.38896532696563385,
    -0.34694342719479554, 1.455858094862869, -0.10891466766807434,
    -0.008726304388860531, -0.19904906033145844, 1.207775364720319];


#[rustfmt::skip]
pub const AP0_D60_TO_P3_D60: [FType; 9] = [
    1.980779622441597, -0.654098803073904, -0.3266808193676931,
    -0.18440023636872904, 1.2881219420707029, -0.10372170570197396,
    0.008603267785723689, -0.06009785142650678, 1.0514945836407827];


#[rustfmt::skip]
pub const AP0_D60_TO_P3_P3_DCI: [FType; 9] = [
    2.1011734697364726, -0.7597112738874179, -0.3414621958490551,
    -0.18289880667877567, 1.2853168459242563, -0.10241803924547992,
    0.009359586506648344, -0.06425303242530164, 1.0548934459186528];


#[rustfmt::skip]
pub const AP0_D60_TO_P3_D65: [FType; 9] = [
    2.0201967651473653, -0.6783272311001937, -0.34186953404717135,
    -0.18434902497485728, 1.2891582831664907, -0.10480925819163375,
    0.009519113721169023, -0.057392020490003706, 1.0478729067688344];


#[rustfmt::skip]
pub const AP0_D60_TO_ADOBE_1998_D65: [FType; 9] = [
    1.7204271248548744, -0.41079256362580624, -0.3096345612290683,
    -0.2770794071389049, 1.3719171373747592, -0.09483773023585478,
    -0.025532727313327733, -0.08840130447659705, 1.1139340317899247];


#[rustfmt::skip]
pub const AP0_D60_TO_ADOBE_WIDE_D50: [FType; 9] = [
    1.395241436545884, -0.1375251971797913, -0.2577162393660929,
    0.009967906305015595, 1.0369010493999957, -0.046868955705011456,
    -0.005616714115258846, -0.06443966219709778, 1.0700563763123572];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_BT_709_D65: [FType; 9] = [
    1.2185334191192088, -0.33818327540366827, 0.1196498562844589,
    -0.14361955351160366, 1.282135043995923, -0.13851549048431913,
    -0.005420528602215063, -0.14249696827539357, 1.1479174968776085];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_BT_2020_D65: [FType; 9] = [
    0.717050487791725, 0.20377711062258566, 0.07917240158568983,
    -0.047912368438415454, 1.1539727225157472, -0.10606035407733123,
    0.0024836527186421226, -0.020295190175264297, 1.0178115374566221];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_AP1_D60: [FType; 9] = [
    0.6999878585579238, 0.21435772118210014, 0.08565442025997627,
    -0.04567003955800025, 1.149218837423462, -0.10354879786546178,
    0.004501236779897692, 0.007658263657653921, 0.9878404995624483];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_AP0_D60: [FType; 9] = [
    0.48104467274943546, 0.3120743163183718, 0.20688101093219316,
    -0.007499455413997103, 0.9983535840969844, 0.009145871317012957,
    0.00045708997161162675, 0.011113516053665774, 0.9884293939747227];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_CIE_XYZ_D65: [FType; 9] = [
    0.45025897180509056, 0.2932631561804732, 0.20694787201443635,
    0.15604791692624442, 0.834714520874453, 0.009237562199302746,
    0.0012895419111052487, 0.010866423081768984, 1.076674035007126];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.6033128312832805, 0.20266696119208083, 0.19402020752463883,
    -0.003458452670432044, 1.080634782922561, -0.07717633025212906,
    -0.001809401524296317, 0.014326445396159904, 0.9874829561281367];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_APPLE_D65: [FType; 9] = [
    1.1271351146339714, -0.21586241048509802, 0.0887272958511266,
    -0.17786321407137096, 1.3439785891923755, -0.16611537512100455,
    -0.002152920678724392, -0.1880219673641468, 1.1901748880428713];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_P3_D60: [FType; 9] = [
    0.957599547549719, -0.038502010482023286, 0.08090246293230446,
    -0.09841237458277918, 1.2273018670851046, -0.12888949250232523,
    0.0050698849231954665, -0.045628244520213065, 1.0405583595970171];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_P3_P3_DCI: [FType; 9] = [
    1.0162996460197995, -0.10653304472536686, 0.09023339870556724,
    -0.09766848724257338, 1.2249844352556476, -0.12731594801307364,
    0.005466423195296596, -0.049502783404690914, 1.044036360209394];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_P3_D65: [FType; 9] = [
    0.9767357114699056, -0.05055827060240418, 0.0738225591324988,
    -0.09839600871775112, 1.2283403971611084, -0.12994438844335726,
    0.005488500040855956, -0.04268130607669524, 1.0371928060358393];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_ADOBE_1998_D65: [FType; 9] = [
    0.830541492927576, 0.12334376188146558, 0.04611474519095815,
    -0.1436195535116035, 1.2821350439959234, -0.1385154904843191,
    -0.01111025273841082, -0.08384414383808768, 1.0949543965764987];


#[rustfmt::skip]
pub const CIE_RGB_E_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.6720870248256822, 0.295256110337545, 0.03265686483677277,
    -0.0030026082918414576, 1.037783727676027, -0.034781119384185474,
    -0.0017295159912901915, -0.05419431121347184, 1.0559238272047626];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_BT_709_D65: [FType; 9] = [
    3.240454162114104, -1.5371385127977162, -0.4985314095560159,
    -0.9692660305051866, 1.8760108454466937, 0.04155601753034983,
    0.05564343095911472, -0.20402591351675378, 1.057225188223179];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_BT_2020_D65: [FType; 9] = [
    1.7165106697619739, -0.355641669986716, -0.25334554182190727,
    -0.6666930011826243, 1.616502208346911, 0.01576875038999502,
    0.01764363876745901, -0.04277978166904463, 0.9423050727200187];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_AP1_D60: [FType; 9] = [
    1.6683875898867835, -0.32625420396515725, -0.23832751540142538,
    -0.6587733206900565, 1.6080130379716489, 0.01665203947781438,
    0.009480533572179267, -0.006077114685137944, 0.9157225204492794];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_AP0_D60: [FType; 9] = [
    1.06893470000754, -0.0015098980622441612, -0.013299106613449435,
    -0.4907814415963974, 1.3672839905988126, 0.09109690786928681,
    -0.0023749289879929675, 0.0021916865089035313, 0.9184772758339819];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_CIE_RGB_E: [FType; 9] = [
    2.52796883750449, -0.8819330576680001, -0.47833498646702716,
    -0.47261710988528555, 1.3630302419998659, 0.07914747245465469,
    0.0017421574634275722, -0.012700198200724612, 0.92856031685062];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_PRO_PHOTO_D50: [FType; 9] = [
    1.4297101770354976, -0.25830442795549097, -0.09238559188435147,
    -0.5196038018429585, 1.4769681681094518, 0.015520932953928073,
    -0.009624683083990499, 0.0085819200915327, 0.9189368886229329];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_APPLE_D65: [FType; 9] = [
    2.951537290948746, -1.2894115658994107, -0.47384447804399604,
    -1.085109338223177, 1.9908566080903678, 0.037202561107440885,
    0.08549335448914223, -0.26949635273220945, 1.0912975249496384];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_P3_D60: [FType; 9] = [
    2.439119468762483, -0.8980455789709774, -0.38597788681768497,
    -0.8290518233399817, 1.761279609428826, 0.024530254586231606,
    0.03619401666215811, -0.07987927368905673, 0.9601847365265239];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_P3_P3_DCI: [FType; 9] = [
    2.6196803751992856, -1.0426619981020324, -0.4107763453556871,
    -0.8260733000294576, 1.757444836598104, 0.025452139343051752,
    0.03903368565135238, -0.08555427887032041, 0.9629179317885062];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_P3_D65: [FType; 9] = [
    2.493180755328967, -0.9312655254971399, -0.40265972375888176,
    -0.8295031158210789, 1.7626941211197926, 0.023625088741739585,
    0.0358536257800717, -0.07618895478265218, 0.9570926215180214];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_ADOBE_1998_D65: [FType; 9] = [
    2.0413689792600795, -0.5649463871751956, -0.34469438437784833,
    -0.9692660305051864, 1.876010845446694, 0.041556017530349806,
    0.013447387216170281, -0.11838974235412561, 1.0154095719504168];


#[rustfmt::skip]
pub const CIE_XYZ_D65_TO_ADOBE_WIDE_D50: [FType; 9] = [
    1.5595288587075375, -0.1907075059542211, -0.2677900943044664,
    -0.4981254404399512, 1.417620432099403, 0.05127784436097246,
    0.023080581784363265, -0.0857536096921985, 0.9770269088136947];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_BT_709_D65: [FType; 9] = [
    2.014817406399223, -0.6864632345027819, -0.3283541718964413,
    -0.23099828322662186, 1.2297708723281646, 0.001227410898457293,
    -0.006365327585173719, -0.1459470578200357, 1.152312385405209];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_BT_2020_D65: [FType; 9] = [
    1.1878705594081254, -0.032142193233522465, -0.15572836617460267,
    -0.0732400220799353, 1.0817137033090751, -0.008473681229139692,
    0.007002671223725079, -0.03370556246894202, 1.026702891245217];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_AP1_D60: [FType; 9] = [
    1.1597141568820133, -0.017246312393758734, -0.1424678444882549,
    -0.06954836841710854, 1.0766033868504017, -0.007055018433293462,
    0.01040664918027808, -0.008091632700577207, 0.9976849835202989];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_AP0_D60: [FType; 9] = [
    0.7983213802784045, 0.13822606951717306, 0.06345255020442248,
    -0.006884965417016886, 0.9240515355290525, 0.08283342988796424,
    0.0037355009029674093, -0.003672929650349064, 0.9999374287473817];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_CIE_RGB_E: [FType; 9] = [
    1.6547157301806925, -0.30570562757692443, -0.3490101026037681,
    0.0055065679320672745, 0.9234068703273834, 0.07108656174054917,
    0.0029521072759545975, -0.013956982496940848, 1.0110048752209866];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_CIE_XYZ_D65: [FType; 9] = [
    0.7472764091110655, 0.13026614385564078, 0.07292744703329353,
    0.26283862528744534, 0.7229474684675605, 0.014213906244994037,
    0.005372119234487403, -0.0053872111511367735, 1.0888450919166492];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_APPLE_D65: [FType; 9] = [
    1.8641614756921925, -0.5451387457857313, -0.3190227299064614,
    -0.2874027391513043, 1.2977313176967176, -0.010328578545413376,
    -0.0010843035022783526, -0.18957386655002437, 1.190658170052303];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_P3_D60: [FType; 9] = [
    1.584581853357658, -0.32942574591068857, -0.2551561074469701,
    -0.15646677877091197, 1.165183101156069, -0.008716322385156738,
    0.01120980320896767, -0.05820638163507183, 1.0469965784261037];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_P3_P3_DCI: [FType; 9] = [
    1.6813667580710945, -0.4103212524753601, -0.2710455055957345,
    -0.15524397251125266, 1.1627937962041544, -0.0075498236929013515,
    0.011854893344772854, -0.061953923835351504, 1.0500990304905784];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_P3_D65: [FType; 9] = [
    1.616159475560828, -0.34630979824352387, -0.2698496773173037,
    -0.1564370933461824, 1.1661518069904386, -0.00971471364425635,
    0.011908784270627207, -0.05556615845500732, 1.04365737418438];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_ADOBE_1998_D65: [FType; 9] = [
    1.3751254093936205, -0.1406483538822113, -0.23447705551140952,
    -0.23099828322662164, 1.2297708723281646, 0.0012274108984572825,
    -0.015613580605309985, -0.08930805101884001, 1.1049216316241501];


#[rustfmt::skip]
pub const PRO_PHOTO_D50_TO_ADOBE_WIDE_D50: [FType; 9] = [
    1.113835226426624, 0.06672494379025404, -0.18056017021687829,
    0.0006434858275612965, 0.9596999777766997, 0.039656536395739,
    -0.00004308155947052583, -0.06425218691005824, 1.064295268469529];


#[rustfmt::skip]
pub const APPLE_D65_TO_BT_709_D65: [FType; 9] = [
    1.0687054988550844, -0.07859531961022259, 0.009889820755138279,
    0.02411041553491973, 0.9600703144118777, 0.01581927005320257,
    0.0017350289124138177, 0.029747576048495428, 0.9685173950390905];


#[rustfmt::skip]
pub const APPLE_D65_TO_BT_2020_D65: [FType; 9] = [
    0.6785752668186412, 0.26807491181921705, 0.05334982136214203,
    0.09604735095096123, 0.8777207586094969, 0.0262318904395423,
    0.02120045193936393, 0.10986745823615428, 0.8689320898244818];


#[rustfmt::skip]
pub const APPLE_D65_TO_AP1_D60: [FType; 9] = [
    0.6645008729608355, 0.27472554464976623, 0.06077358238939848,
    0.09755440847132052, 0.8746450887457072, 0.027800502782971956,
    0.025839190240474576, 0.12819812935931924, 0.8459626804002062];


#[rustfmt::skip]
pub const APPLE_D65_TO_AP0_D60: [FType; 9] = [
    0.4800264231402328, 0.3351568181976468, 0.18481675866212088,
    0.11608512088021444, 0.7765058619430704, 0.10740901717671578,
    0.022599807638077504, 0.1303946471964188, 0.8470055451655039];


#[rustfmt::skip]
pub const APPLE_D65_TO_CIE_RGB_E: [FType; 9] = [
    0.9090865900795666, 0.1392501719103686, -0.04833676198993514,
    0.12291251015492827, 0.7777046170204908, 0.09938287282458137,
    0.021061983027342822, 0.12311245025169504, 0.8558255667209621];


#[rustfmt::skip]
pub const APPLE_D65_TO_CIE_XYZ_D65: [FType; 9] = [
    0.449728836561033, 0.3162486093896715, 0.18449255404929576,
    0.24465248708920198, 0.6720282949530518, 0.08331921795774648,
    0.025184814847417834, 0.14118241490610334, 0.9224627702464787];


#[rustfmt::skip]
pub const APPLE_D65_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.577460359786002, 0.2655127500552227, 0.15702689015877572,
    0.12805401422674054, 0.8304317027441366, 0.041514283029123716,
    0.020914345965193353, 0.13246122956749434, 0.8466244244673125];


#[rustfmt::skip]
pub const APPLE_D65_TO_P3_D60: [FType; 9] = [
    0.8675124948905033, 0.11336281074414185, 0.019124694365354966,
    0.05867071486668177, 0.924906487197536, 0.01642279793578276,
    0.020916904837773406, 0.09332637519708435, 0.8857567199651418];


#[rustfmt::skip]
pub const APPLE_D65_TO_P3_P3_DCI: [FType; 9] = [
    0.9127106300696042, 0.0697775144817165, 0.01751185544867956,
    0.0590952734762466, 0.9234015191217945, 0.017503207401959667,
    0.020874416753276785, 0.09079653161772622, 0.8883290516289966];


#[rustfmt::skip]
pub const APPLE_D65_TO_P3_D65: [FType; 9] = [
    0.8832779428877661, 0.1057796913957724, 0.01094236571646201,
    0.05879102299322121, 0.9255865649580165, 0.015622412048762697,
    0.021588792597024824, 0.09526217351241187, 0.8831490338905631];


#[rustfmt::skip]
pub const APPLE_D65_TO_ADOBE_1998_D65: [FType; 9] = [
    0.7711658930904475, 0.21725535803794266, 0.011578748871609867,
    0.024110415534919837, 0.960070314411878, 0.015819270053202605,
    0.00265623495859435, 0.06804943629959671, 0.929294328741809];


#[rustfmt::skip]
pub const APPLE_D65_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.647963789628587, 0.3272307406063183, 0.024805469765095067,
    0.12409441268708254, 0.8023890939316797, 0.07351649338123839,
    0.01400641110437829, 0.08760936820025444, 0.8983842206953676];


#[rustfmt::skip]
pub const P3_D60_TO_BT_709_D65: [FType; 9] = [
    1.2482102533002837, -0.2368158837072179, -0.011394369593065612,
    -0.042754335519770426, 1.0433156964464794, -0.0005613609267097336,
    -0.019268846991021594, -0.07599113930920087, 1.0952599863002228];


#[rustfmt::skip]
pub const P3_D60_TO_BT_2020_D65: [FType; 9] = [
    0.7682813877763954, 0.19162906112629663, 0.04008955109730836,
    0.04672996287001924, 0.942131816546889, 0.011138220583091395,
    -0.0005527105281827093, 0.0199044651851114, 0.9806482453430717];


#[rustfmt::skip]
pub const P3_D60_TO_AP1_D60: [FType; 9] = [
    0.7512817752823954, 0.20003624206980417, 0.04868198264780052,
    0.048677131594867806, 0.9383863154947397, 0.012936552910391818,
    0.003948398063807901, 0.04183919484945107, 0.9542124070867413];


#[rustfmt::skip]
pub const P3_D60_TO_AP0_D60: [FType; 9] = [
    0.5299016773207688, 0.2780406828639037, 0.1920576398153277,
    0.07585772073182523, 0.8197160545049514, 0.10442622476322316,
    -0.000000000000000040839745589962587, 0.044575707697196904, 0.9554242923028036];


#[rustfmt::skip]
pub const P3_D60_TO_CIE_RGB_E: [FType; 9] = [
    1.0477704607483118, 0.02997932616307752, -0.07774978691138923,
    0.0838665635134947, 0.820964625027786, 0.09516881145871928,
    -0.001427494749481395, 0.035853042335789106, 0.9655744524136928];


#[rustfmt::skip]
pub const P3_D60_TO_CIE_XYZ_D65: [FType; 9] = [
    0.49606760645754155, 0.26167684843839906, 0.19272554510405962,
    0.23349384962564138, 0.6902804997421549, 0.07622565063220348,
    0.0007255269520290713, 0.04756164830722708, 1.0405428247407442];


#[rustfmt::skip]
pub const P3_D60_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.6488533819544192, 0.19142553266236823, 0.15972108538321278,
    0.0871156299151109, 0.8842922410375262, 0.028592129047362653,
    -0.0021039544611262738, 0.04711152846611486, 0.9549924259950119];


#[rustfmt::skip]
pub const P3_D60_TO_APPLE_D65: [FType; 9] = [
    1.16274858207755, -0.14024350815553172, -0.02250507392201745,
    -0.07340782722066358, 1.092070917637793, -0.018663090417130518,
    -0.019723491363024835, -0.1117525363973299, 1.1314760277603555];


#[rustfmt::skip]
pub const P3_D60_TO_P3_P3_DCI: [FType; 9] = [
    1.0557853803038855, -0.0537567406846886, -0.0020286396191970812,
    0.0005828219109824108, 0.9981761880454939, 0.001240990043524539,
    0.00008557199901031035, -0.003044274509056047, 1.0029587025100455];


#[rustfmt::skip]
pub const P3_D60_TO_P3_D65: [FType; 9] = [
    1.0190492967079894, -0.009577909859960168, -0.009471386848028673,
    0.00010575147693769788, 1.0008152658631984, -0.0009210173401365991,
    0.0006905664648886753, 0.0023112166790994343, 0.996998216856012];


#[rustfmt::skip]
pub const P3_D60_TO_ADOBE_1998_D65: [FType; 9] = [
    0.8804954315985086, 0.12781329344261477, -0.008308725041123566,
    -0.04275433551977037, 1.0433156964464796, -0.0005613609267097544,
    -0.02023575649722097, -0.029908707661194814, 1.0501444641584161];


#[rustfmt::skip]
pub const P3_D60_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.7289084294918491, 0.2637143859951938, 0.007377184512957158,
    0.08393896050232541, 0.8506467037323988, 0.06541433576527553,
    -0.007864552129707538, -0.006685380427873408, 1.0145499325575817];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_BT_709_D65: [FType; 9] = [
    1.182354106621989, -0.17359964469264416, -0.008754461929344093,
    -0.04107090001594271, 1.0430042167369105, -0.0019333167209677135,
    -0.018298506227700292, -0.07378477562253867, 1.0920832818502393];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_BT_2020_D65: [FType; 9] = [
    0.7275560743544834, 0.2312872210542876, 0.041156704591229526,
    0.043737692386858484, 0.9462392876834534, 0.010023019929688555,
    -0.0006153874156946622, 0.022889595985874547, 0.9777257914298204];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_AP1_D60: [FType; 9] = [
    0.7114498080831262, 0.23886836101684814, 0.049681830900025675,
    0.04558384447674402, 0.9425918611042775, 0.011824294418978044,
    0.003637817603697678, 0.0450130153609723, 0.9513491670353302];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_AP0_D60: [FType; 9] = [
    0.501718259081526, 0.30615467729678786, 0.19212706362168616,
    0.07138556948062749, 0.825373130292669, 0.10324130022670353,
    -0.00010345702471034101, 0.047556694480555, 0.9525467625441557];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_CIE_RGB_E: [FType; 9] = [
    0.9923687450848496, 0.08324746667516547, -0.0756162117600152,
    0.07897108912812728, 0.8270043903322568, 0.09402452053961594,
    -0.0014515000280000195, 0.03877638257583654, 0.9626751174521637];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_CIE_XYZ_D65: [FType; 9] = [
    0.4696818568161132, 0.2880375262929713, 0.19275061689091594,
    0.22076198199592964, 0.7036613664472136, 0.07557665155685697,
    0.0005750419617924146, 0.05084345498400761, 1.0374115030542002];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.6144320075931488, 0.22535413329252127, 0.16021385911433034,
    0.08201886686616203, 0.8904091834916181, 0.027571949642219824,
    -0.0020975500622206896, 0.049988422041326364, 0.9521091280208949];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_APPLE_D65: [FType; 9] = [
    1.1013579819201393, -0.08124749471613638, -0.02011048720400227,
    -0.07012932511971914, 1.090228178451082, -0.02009885333136297,
    -0.01871232961829197, -0.10952354089061031, 1.1282358705089028];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_P3_D60: [FType; 9] = [
    0.9471338856671345, 0.05101350957153741, 0.0018526047613276475,
    -0.0005529164308617503, 1.0017935831975777, -0.00124066676671589,
    -0.00008248731390037532, 0.003036385579039527, 0.9970461017348607];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_P3_D65: [FType; 9] = [
    0.965182197130394, 0.04236143363088979, -0.00754363076128306,
    -0.0004531304252394793, 1.0026129094981415, -0.0021597790729021293,
    0.0005705412846523529, 0.005377861265457126, 0.9940515974498907];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_ADOBE_1998_D65: [FType; 9] = [
    0.8338770747364402, 0.17293447085281105, -0.006811545589251122,
    -0.041070900015942546, 1.043004216736911, -0.001933316720967665,
    -0.01923605726079095, -0.027806004867596726, 1.047042062128388];


#[rustfmt::skip]
pub const P3_P3_DCI_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.6902274525789381, 0.30139395680820025, 0.008378590612861947,
    0.0790257014272277, 0.8566530534780787, 0.06432124509469359,
    -0.007528774859710993, -0.00401800483478959, 1.0115467796945015];


#[rustfmt::skip]
pub const P3_D65_TO_BT_709_D65: [FType; 9] = [
    1.224900542983793, -0.22490054298379336, 0.0,
    -0.04206325973338326, 1.042063259733383, 0.000000000000000020816681711721685,
    -0.01964475842589928, -0.0786535768895766, 1.098298335315476];


#[rustfmt::skip]
pub const P3_D65_TO_BT_2020_D65: [FType; 9] = [
    0.7538669132425743, 0.19857772608370303, 0.047555360673722624,
    0.045750243217439035, 0.941773376950237, 0.012476379832324028,
    -0.0012107533203739543, 0.017605190205230055, 0.9836055631151441];


#[rustfmt::skip]
pub const P3_D65_TO_AP1_D60: [FType; 9] = [
    0.7371784868705633, 0.20679879452838343, 0.05602271860105304,
    0.04766016774574233, 0.9380450057725793, 0.014294826481677674,
    0.003221856035134071, 0.039625561114924386, 0.9571525828499419];


#[rustfmt::skip]
pub const P3_D65_TO_AP0_D60: [FType; 9] = [
    0.5198327536497372, 0.2823321786250631, 0.19783506772519982,
    0.07428268257461915, 0.8195139465956947, 0.10620337082968641,
    -0.0006538138863785318, 0.042320026420121455, 0.9583337874662574];


#[rustfmt::skip]
pub const P3_D65_TO_CIE_RGB_E: [FType; 9] = [
    1.0282263293472498, 0.0399525895332899, -0.06817891888054028,
    0.08214791570802277, 0.8208580385659908, 0.09699404572598645,
    -0.002060600405534458, 0.033567542310028294, 0.9684930580955062];


#[rustfmt::skip]
pub const P3_D65_TO_CIE_XYZ_D65: [FType; 9] = [
    0.48663265, 0.2656631625, 0.1981741875,
    0.2290036, 0.6917267249999999, 0.079269675,
    -0.00000000000000003972579210032023, 0.04511261250000004, 1.0437173875];


#[rustfmt::skip]
pub const P3_D65_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.6365910082850053, 0.19697749567977313, 0.16643149603522167,
    0.08537485254155586, 0.8843189544449657, 0.030306193013478776,
    -0.0027183944386991875, 0.04483506350137651, 0.957883330937323];


#[rustfmt::skip]
pub const P3_D65_TO_APPLE_D65: [FType; 9] = [
    1.1410345229956071, -0.12918207102985801, -0.011852451965749244,
    -0.0721363024628075, 1.0905334477315547, -0.018397145268747618,
    -0.02011177731010516, -0.11447411218331474, 1.1345858894934204];


#[rustfmt::skip]
pub const P3_D65_TO_P3_D60: [FType; 9] = [
    0.9812995002020412, 0.009369593702863117, 0.00933090609509557,
    -0.00010431461347204616, 0.9991822706442649, 0.0009220439692071078,
    -0.0006794509977291543, -0.002322769506927544, 1.0030022205046567];


#[rustfmt::skip]
pub const P3_D65_TO_P3_P3_DCI: [FType; 9] = [
    1.0360486519876642, -0.04381579010664352, 0.007767138118979333,
    0.0004669552947975098, 0.9973625283450084, 0.002170516360194257,
    -0.0005971719689227621, -0.005370625232457939, 1.0059677972013803];


#[rustfmt::skip]
pub const P3_D65_TO_ADOBE_1998_D65: [FType; 9] = [
    0.8640220395350139, 0.13597796046498564, 0.0,
    -0.04206325973338315, 1.0420632597333832, 0.000000000000000027755575615628914,
    -0.020567739525586215, -0.03251309478881315, 1.0530808343143996];


#[rustfmt::skip]
pub const P3_D65_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.7152449558537866, 0.27031117933193294, 0.01444386481428056,
    0.08223607927060822, 0.8505856364827138, 0.06717828424667806,
    -0.008406120655241963, -0.009110166900753794, 1.0175162875559962];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_BT_709_D65: [FType; 9] = [
    1.3982831459026692, -0.39828314590266956, 0.00000000000000005551115123125783,
    0.000000000000000010842021724855044, 0.9999999999999998, 0.0,
    0.000000000000000006938893903907228, -0.0429383002022965, 1.042938300202296];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_BT_2020_D65: [FType; 9] = [
    0.8773561076981875, 0.07748557289826628, 0.04515831940354631,
    0.09663420734337877, 0.8915182882431102, 0.01184750441351132,
    0.022928434789933144, 0.043044915911570086, 0.9340266492984967];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_AP1_D60: [FType; 9] = [
    0.8587471948609877, 0.08805392735530782, 0.0531988777837043,
    0.09870112790562824, 0.8877245803440288, 0.01357429175034244,
    0.02841640424737102, 0.06267655684227907, 0.9089070389103497];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_AP0_D60: [FType; 9] = [
    0.615679117631517, 0.19645774662544324, 0.18786313574303995,
    0.12601254621827573, 0.7731372935954656, 0.10085016018625892,
    0.024112415746872735, 0.06585887967588244, 0.9100287045772449];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_CIE_RGB_E: [FType; 9] = [
    1.182759791217749, -0.1180174498333602, -0.06474234138438917,
    0.13490046679613024, 0.7729944995108641, 0.0921050336930058,
    0.02233095225480546, 0.057993153419345814, 0.9196758943258484];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_CIE_XYZ_D65: [FType; 9] = [
    0.5767308871981476, 0.185553950711214, 0.18818516209063835,
    0.2973768637115448, 0.6273490714521998, 0.07527406483625534,
    0.027034260337413137, 0.07068721931855779, 0.9911085203440287];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.7452466820272671, 0.09671084809569294, 0.15804246987704001,
    0.13996419694791049, 0.8312572021831361, 0.028778600868953598,
    0.021843991548097033, 0.06855505501612455, 0.9096009534357784];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_APPLE_D65: [FType; 9] = [
    1.3059915179278416, -0.2947364921220919, -0.01125502580574994,
    -0.03277563340493284, 1.0502454654152404, -0.017469832010308065,
    -0.0013329005780727855, -0.07606386947337708, 1.0773967700514497];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_P3_D60: [FType; 9] = [
    1.1292229307805395, -0.13808350994127472, 0.00886057916073496,
    0.04628717005155653, 0.9528372618636752, 0.0008755680847685569,
    0.023077843594891664, 0.024476543663847106, 0.9524456127412606];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_P3_P3_DCI: [FType; 9] = [
    1.1896819973966681, -0.1970576307439755, 0.007375633347307176,
    0.046889526198046115, 0.9510493629266364, 0.002061110875317917,
    0.02310184308029319, 0.0216364482054762, 0.95526170871423];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_P3_D65: [FType; 9] = [
    1.150071919911711, -0.1500719199117111, 0.00000000000000011102230246251565,
    0.04642306829980194, 0.9535769317001981, 0.000000000000000010408340855860843,
    0.023895352079820728, 0.02650992791842105, 0.9495947200017577];


#[rustfmt::skip]
pub const ADOBE_1998_D65_TO_ADOBE_WIDE_D50: [FType; 9] = [
    0.8354769551613883, 0.15080722707455171, 0.013715817764060001,
    0.13566944942422027, 0.8005384065563572, 0.06379214401942276,
    0.014223344716862733, 0.01954856110417299, 0.9662280941789644];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_BT_709_D65: [FType; 9] = [
    1.8093866923489754, -0.8391010386181105, 0.029714346269134995,
    -0.20813865470257426, 1.2903771373179227, -0.08223848261534873,
    -0.005627152586981786, -0.07906408658737296, 1.0846912391743542];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_BT_2020_D65: [FType; 9] = [
    1.0665310262487178, -0.10506465404786897, 0.03853362779915137,
    -0.0664086467533202, 1.127654146400289, -0.06124549964696849,
    0.0063075337164284345, 0.029025263872785353, 0.9646672024107859];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_AP1_D60: [FType; 9] = [
    1.0412422572612832, -0.08728244520195952, 0.046040187940676186,
    -0.06309107472265485, 1.1222390081591018, -0.059147933436447066,
    0.00934832430492482, 0.053651078057901, 0.9370005976371737];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_AP0_D60: [FType; 9] = [
    0.7166776050835062, 0.10606929095115247, 0.17725310396534144,
    -0.006737845934949693, 0.9660473020918684, 0.04069054384308091,
    0.003356074300453388, 0.05873290799264664, 0.9379110177068998];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_CIE_RGB_E: [FType; 9] = [
    1.4858456123903017, -0.4258648506053944, -0.059980761784907244,
    0.004388093591317532, 0.9639945608509651, 0.031617345557717044,
    0.002658907190655399, 0.04877859542761592, 0.9485624973817286];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_CIE_XYZ_D65: [FType; 9] = [
    0.6708524390571574, 0.10104924421804815, 0.17856831672479434,
    0.23555047994769124, 0.7386555304664713, 0.02579398958583737,
    0.004826519405767202, 0.0624446493344398, 1.0215588312597925];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_PRO_PHOTO_D50: [FType; 9] = [
    0.897834926579531, -0.052095847301785764, 0.15426092072225456,
    -0.0006020048599792438, 1.039434333443575, -0.0388323285835958,
    0.0, 0.06274920755669666, 0.9372507924433031];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_APPLE_D65: [FType; 9] = [
    1.6740374578348158, -0.6837694239377945, 0.009731966102978384,
    -0.2588214577648681, 1.3632308662929693, -0.10440940852810146,
    -0.0008594011663698442, -0.12228024126437372, 1.1231396424307434];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_P3_D60: [FType; 9] = [
    1.4228912478686708, -0.44097740843507904, 0.01808616056640766,
    -0.141182784719579, 1.2187356471820507, -0.07755286246247128,
    0.0100995933657206, 0.004612509917540142, 0.9852878967167386];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_P3_P3_DCI: [FType; 9] = [
    1.5098368151741686, -0.5311021141391654, 0.02126529896499718,
    -0.1400834681780238, 1.216261615322336, -0.0761781471443117,
    0.010681033859055975, 0.0008782557798583945, 0.9884407103610852];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_P3_D65: [FType; 9] = [
    1.4512529042625706, -0.4610943449674783, 0.009841440704908222,
    -0.1411567152740667, 1.2196783585376076, -0.07852164326354114,
    0.010725573548710347, 0.007110902108159581, 0.9821635243431295];


#[rustfmt::skip]
pub const ADOBE_WIDE_D50_TO_ADOBE_1998_D65: [FType; 9] = [
    1.234720291973154, -0.23254630073963653, -0.002173991233517858,
    -0.2081386547025741, 1.2903771373179227, -0.08223848261534872,
    -0.013964654115663472, -0.022683494974196666, 1.03664814908986];



pub fn const_conversion_matrix(
    src_primaries: RGBPrimaries,
    src_wp: WhitePoint,
    dst_primaries: RGBPrimaries,
    dst_wp: WhitePoint,
) -> Option<Mat3> {
    if src_primaries == dst_primaries && src_wp == dst_wp {
        return Some(Mat3::IDENTITY);
    }
    match (src_primaries, src_wp, dst_primaries, dst_wp) {

        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_P3_D60).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_P3_D65).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::BT_709, WhitePoint::D65, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&BT_709_D65_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_P3_D60).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_P3_D65).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::BT_2020, WhitePoint::D65, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&BT_2020_D65_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_P3_D60).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_P3_D65).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::AP1, WhitePoint::D60, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&AP1_D60_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_P3_D60).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_P3_D65).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::AP0, WhitePoint::D60, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&AP0_D60_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_P3_D60).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_P3_D65).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::CIE_RGB, WhitePoint::E, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&CIE_RGB_E_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_P3_D60).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_P3_D65).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::CIE_XYZ, WhitePoint::D65, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&CIE_XYZ_D65_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_P3_D60).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_P3_D65).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::PRO_PHOTO, WhitePoint::D50, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&PRO_PHOTO_D50_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_P3_D60).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_P3_D65).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::APPLE, WhitePoint::D65, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&APPLE_D65_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_P3_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D60, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&P3_D60_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_P3_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_P3_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::P3_DCI, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&P3_P3_DCI_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_P3_D60).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_ADOBE_1998_D65).transpose())
        }
        (RGBPrimaries::P3, WhitePoint::D65, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&P3_D65_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_P3_D60).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_P3_D65).transpose())
        }
        (RGBPrimaries::ADOBE_1998, WhitePoint::D65, RGBPrimaries::ADOBE_WIDE, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&ADOBE_1998_D65_TO_ADOBE_WIDE_D50).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::BT_709, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_BT_709_D65).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::BT_2020, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_BT_2020_D65).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::AP1, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_AP1_D60).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::AP0, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_AP0_D60).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::CIE_RGB, WhitePoint::E) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_CIE_RGB_E).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::CIE_XYZ, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_CIE_XYZ_D65).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::PRO_PHOTO, WhitePoint::D50) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_PRO_PHOTO_D50).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::APPLE, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_APPLE_D65).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::P3, WhitePoint::D60) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_P3_D60).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::P3, WhitePoint::P3_DCI) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_P3_P3_DCI).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::P3, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_P3_D65).transpose())
        }
        (RGBPrimaries::ADOBE_WIDE, WhitePoint::D50, RGBPrimaries::ADOBE_1998, WhitePoint::D65) => {
            Some(Mat3::from_cols_array(&ADOBE_WIDE_D50_TO_ADOBE_1998_D65).transpose())
        }
        _ => None,
    }
}