<div align="center">

![Logo](./docs/theme/favicon.png)

<h1>Koifish</h1>
<h3>A toolchain for community collaboration</h3>

![Status](https://img.shields.io/badge/status-alpha-critical?color=%23E5531A&style=flat-square)
[![Contribute](https://img.shields.io/badge/contribute-now-a94064?color=%23E5531A&)](https://gitpod.io/#https://github.com/trisasnava/koifish)
[![downloads](https://img.shields.io/crates/d/koifish?style=flat-square&color=%23E5531A)](https://crates.io/crates/koifish)
[![GitHub Release](https://img.shields.io/github/v/release/trisasnava/koifish?include_prereleases&sort=semver&color=%23E5531A&style=flat-square)](https://github.com/trisasnava/koifish/releases)
![Top Lang](https://img.shields.io/github/languages/top/trisasnava/koifish?color=%23E5531A&style=flat-square)
[![Rust Build](https://img.shields.io/github/workflow/status/trisasnava/koifish/cargo-test?label=rust%20build&style=flat-square)](https://github.com/trisasnava/koifish/actions?query=workflow:cargo-test)
[![Docs Build](https://img.shields.io/github/workflow/status/trisasnava/koifish/mdbook-deploy?label=docs%20build&style=flat-square)](https://github.com/trisasnava/koifish/actions?query=workflow:mdbook-deploy)

</div>

-----------------------------------------------------------------------------------------------

## What is Koifish

A toolchain for community collaboration.

## Community

<a href="https://trisasnava.slack.com/join/shared_invite/enQtODg1NjI0NTc1NzAzLTBjYTM1YjQxZWZkMTExYTBlNTcxNjQzYTc0MjRmNDNjMmIxZmMwZjM5ODFkZWExNjJkNWMwZWRjOGJlODdiM2Q"><img src="https://img.shields.io/badge/discuss%20on-slack-4A154B?logo=slack&style=flat-square"/></a>
<a href="https://discord.gg/JeqN3Q9E"><img src="https://img.shields.io/badge/talk-on%20discord-7289DA?logo=DISCORD&style=flat-square"/></a>

## Installation

![Linux supported](https://img.shields.io/badge/Linux%20x86__64-supported%20✓-228B22?style=flat-square&logo=linux)
![macOS supported](https://img.shields.io/badge/macOS%20x86__64-supported%20✓-228B22?style=flat-square&logo=apple)
![Windows supported](https://img.shields.io/badge/Windows%20x86__64-supported%20✓-228B22?style=flat-square&logo=windows)

### Cargo

```shell
cargo install koifish
```

### Binary

Download from [release](https://github.com/trisasnava/koifish/releases/latest) and to `PATH`

## How to use

```shell script
> koi -h

    █▄▀ █▀█ ░ █▀▀ ░ █▀ █░█
    █░█ █▄█ █ █▀▀ █ ▄█ █▀█   0.0.7

USAGE:
    koi [FLAGS] <SUBCOMMAND>

FLAGS:
    -d, --debug      Activate debug mode
    -h, --help       Prints help information
    -V, --version    Prints version information

SUBCOMMANDS:
    clone     Speed up git clone via `https://github.com.cnpmjs.org`
    help      Prints this message or the help of the given subcommand(s)
    login     Log in via GitHub Oauth
    meet      Start a online meeting via https://meet.jit.si/
    open      Open channels "docs,github,site,slack,discord"
    update    Update from GitHub release

```

## Contributing

- [Code of conduct](DOCS/src/contribution/CODE_OF_CONDUCT.md)

- [Sign the CLA](DOCS/src/contribution/CLA.md)

- [Contribute code](DOCS/src/contribution/code.md)

- [Contribute docs](DOCS/src/contribution/DOCS.md)

- [FAQ](docs/src/FAQ.md)

[![Contribute Now](https://img.shields.io/badge/Contribute-now-a94064?style=for-the-badge&color=%23E5531A)](https://gitpod.io/#https://GITHUB.com/trisasnava/koifish)

## LICENSE

[Apache 2.0](LICENSE)