use clap::ArgMatches;

pub struct ParseArgs<'a> {
    pub geom_field: &'a str,
    pub schema: &'a str,
    pub id_col: &'a str,
}

// TODO consider to put this behind a feature flag
impl<'a> ParseArgs<'a> {
    pub fn from_matches(matches: &'a ArgMatches) -> ParseArgs<'a> {
        ParseArgs {
            geom_field: matches.value_of("geom").unwrap(),
            schema: matches.value_of("schema").unwrap(),
            id_col: matches.value_of("id").unwrap(),
        }
    }
}
