//! Pre-defined TTLV tag code to name mappings for improved diagnostic reporting.
use std::collections::HashMap;

use kmip_ttlv::types::TtlvTag;

pub fn make_kmip_tag_map() -> HashMap<TtlvTag, &'static str> {
    vec![
        // KMIP 1.0: http://docs.oasis-open.org/kmip/spec/v1.0/os/kmip-spec-1.0-os.html#_Toc262581263
        (b"\x42\x00\x01".into(), "Activation Date"),
        (b"\x42\x00\x02".into(), "Application Data"),
        (b"\x42\x00\x03".into(), "Application Namespace"),
        (b"\x42\x00\x04".into(), "Application Specific Information"),
        (b"\x42\x00\x05".into(), "Archive Date"),
        (b"\x42\x00\x06".into(), "Asynchronous Correlation Value"),
        (b"\x42\x00\x07".into(), "Asynchronous Indicator"),
        (b"\x42\x00\x08".into(), "Attribute"),
        (b"\x42\x00\x09".into(), "Attribute Index"),
        (b"\x42\x00\x0A".into(), "Attribute Name"),
        (b"\x42\x00\x0B".into(), "Attribute Value"),
        (b"\x42\x00\x0C".into(), "Authentication"),
        (b"\x42\x00\x0D".into(), "Batch Count"),
        (b"\x42\x00\x0E".into(), "Batch Error Continuation Option"),
        (b"\x42\x00\x0F".into(), "Batch Item"),
        (b"\x42\x00\x10".into(), "Batch Order Option"),
        (b"\x42\x00\x11".into(), "Block Cipher Mode"),
        (b"\x42\x00\x12".into(), "Cancellation Result"),
        (b"\x42\x00\x13".into(), "Certificate"),
        (b"\x42\x00\x14".into(), "Certificate Identifier"),
        (b"\x42\x00\x15".into(), "Certificate Issuer"),
        (b"\x42\x00\x16".into(), "Certificate Issuer Alternative Name"),
        (b"\x42\x00\x17".into(), "Certificate Issuer Distinguished Name"),
        (b"\x42\x00\x18".into(), "Certificate Request"),
        (b"\x42\x00\x19".into(), "Certificate Request Type"),
        (b"\x42\x00\x1A".into(), "Certificate Subject"),
        (b"\x42\x00\x1B".into(), "Certificate Subject  Alternative Name"),
        (b"\x42\x00\x1C".into(), "Certificate Subject Distinguished Name"),
        (b"\x42\x00\x1D".into(), "Certificate Type"),
        (b"\x42\x00\x1E".into(), "Certificate Value"),
        (b"\x42\x00\x1F".into(), "Common Template-Attribute"),
        (b"\x42\x00\x20".into(), "Compromise  Date"),
        (b"\x42\x00\x21".into(), "Compromise Occurrence Date"),
        (b"\x42\x00\x22".into(), "Contact Information"),
        (b"\x42\x00\x23".into(), "Credential"),
        (b"\x42\x00\x24".into(), "Credential Type"),
        (b"\x42\x00\x25".into(), "Credential Value"),
        (b"\x42\x00\x26".into(), "Criticality Indicator"),
        (b"\x42\x00\x27".into(), "CRT Coefficient"),
        (b"\x42\x00\x28".into(), "Cryptographic Algorithm"),
        (b"\x42\x00\x29".into(), "Cryptographic Domain Parameters"),
        (b"\x42\x00\x2A".into(), "Cryptographic Length"),
        (b"\x42\x00\x2B".into(), "Cryptographic Parameters"),
        (b"\x42\x00\x2C".into(), "Cryptographic Usage Mask"),
        (b"\x42\x00\x2D".into(), "Custom Attribute"),
        (b"\x42\x00\x2E".into(), "D"),
        (b"\x42\x00\x2F".into(), "Deactivation Date"),
        (b"\x42\x00\x30".into(), "Derivation Data"),
        (b"\x42\x00\x31".into(), "Derivation Method"),
        (b"\x42\x00\x32".into(), "Derivation Parameters"),
        (b"\x42\x00\x33".into(), "Destroy Date"),
        (b"\x42\x00\x34".into(), "Digest"),
        (b"\x42\x00\x35".into(), "Digest Value"),
        (b"\x42\x00\x36".into(), "Encryption Key Information"),
        (b"\x42\x00\x37".into(), "G"),
        (b"\x42\x00\x38".into(), "Hashing Algorithm"),
        (b"\x42\x00\x39".into(), "Initial Date"),
        (b"\x42\x00\x3A".into(), "Initialization Vector"),
        (b"\x42\x00\x3B".into(), "Issuer"),
        (b"\x42\x00\x3C".into(), "Iteration Count"),
        (b"\x42\x00\x3D".into(), "IV/Counter/Nonce"),
        (b"\x42\x00\x3E".into(), "J"),
        (b"\x42\x00\x3F".into(), "Key"),
        (b"\x42\x00\x40".into(), "Key Block"),
        (b"\x42\x00\x41".into(), "Key Compression Type"),
        (b"\x42\x00\x42".into(), "Key Format Type"),
        (b"\x42\x00\x43".into(), "Key Material"),
        (b"\x42\x00\x44".into(), "Key Part Identifier"),
        (b"\x42\x00\x45".into(), "Key Value"),
        (b"\x42\x00\x46".into(), "Key Wrapping Data"),
        (b"\x42\x00\x47".into(), "Key Wrapping Specification"),
        (b"\x42\x00\x48".into(), "Last Change Date"),
        (b"\x42\x00\x49".into(), "Lease Time"),
        (b"\x42\x00\x4A".into(), "Link"),
        (b"\x42\x00\x4B".into(), "Link Type"),
        (b"\x42\x00\x4C".into(), "Linked Object Identifier"),
        (b"\x42\x00\x4D".into(), "MAC/Signature"),
        (b"\x42\x00\x4E".into(), "MAC/Signature Key Information"),
        (b"\x42\x00\x4F".into(), "Maximum Items"),
        (b"\x42\x00\x50".into(), "Maximum Response Size"),
        (b"\x42\x00\x51".into(), "Message Extension"),
        (b"\x42\x00\x52".into(), "Modulus"),
        (b"\x42\x00\x53".into(), "Name"),
        (b"\x42\x00\x54".into(), "Name Type"),
        (b"\x42\x00\x55".into(), "Name Value"),
        (b"\x42\x00\x56".into(), "Object Group"),
        (b"\x42\x00\x57".into(), "Object Type"),
        (b"\x42\x00\x58".into(), "Offset"),
        (b"\x42\x00\x59".into(), "Opaque Data Type"),
        (b"\x42\x00\x5A".into(), "Opaque Data Value"),
        (b"\x42\x00\x5B".into(), "Opaque Object"),
        (b"\x42\x00\x5C".into(), "Operation"),
        (b"\x42\x00\x5D".into(), "Operation Policy Name"),
        (b"\x42\x00\x5E".into(), "P"),
        (b"\x42\x00\x5F".into(), "Padding Method"),
        (b"\x42\x00\x60".into(), "Prime Exponent P"),
        (b"\x42\x00\x61".into(), "Prime Exponent Q"),
        (b"\x42\x00\x62".into(), "Prime Field Size"),
        (b"\x42\x00\x63".into(), "Private Exponent"),
        (b"\x42\x00\x64".into(), "Private Key"),
        (b"\x42\x00\x65".into(), "Private Key Template-Attribute"),
        (b"\x42\x00\x66".into(), "Private Key Unique Identifier"),
        (b"\x42\x00\x67".into(), "Process Start Date"),
        (b"\x42\x00\x68".into(), "Protect Stop Date"),
        (b"\x42\x00\x69".into(), "Protocol Version"),
        (b"\x42\x00\x6A".into(), "Protocol Version Major"),
        (b"\x42\x00\x6B".into(), "Protocol Version Minor"),
        (b"\x42\x00\x6C".into(), "Public Exponent"),
        (b"\x42\x00\x6D".into(), "Public Key"),
        (b"\x42\x00\x6E".into(), "Public Key Template-Attribute"),
        (b"\x42\x00\x6F".into(), "Public Key Unique Identifier"),
        (b"\x42\x00\x70".into(), "Put Function"),
        (b"\x42\x00\x71".into(), "Q"),
        (b"\x42\x00\x72".into(), "Q String"),
        (b"\x42\x00\x73".into(), "Qlength"),
        (b"\x42\x00\x74".into(), "Query Function"),
        (b"\x42\x00\x75".into(), "Recommended Curve"),
        (b"\x42\x00\x76".into(), "Replaced Unique Identifier"),
        (b"\x42\x00\x77".into(), "Request Header"),
        (b"\x42\x00\x78".into(), "Request Message"),
        (b"\x42\x00\x79".into(), "Request Payload"),
        (b"\x42\x00\x7A".into(), "Response Header"),
        (b"\x42\x00\x7B".into(), "Response Message"),
        (b"\x42\x00\x7C".into(), "Response Payload"),
        (b"\x42\x00\x7D".into(), "Result Message"),
        (b"\x42\x00\x7E".into(), "Result Reason"),
        (b"\x42\x00\x7F".into(), "Result Status"),
        (b"\x42\x00\x80".into(), "Revocation Message"),
        (b"\x42\x00\x81".into(), "Revocation Reason"),
        (b"\x42\x00\x82".into(), "Revocation Reason Code"),
        (b"\x42\x00\x83".into(), "Key Role Type"),
        (b"\x42\x00\x84".into(), "Salt"),
        (b"\x42\x00\x85".into(), "Secret Data"),
        (b"\x42\x00\x86".into(), "Secret Data Type"),
        (b"\x42\x00\x87".into(), "Serial Number"),
        (b"\x42\x00\x88".into(), "Server Information"),
        (b"\x42\x00\x89".into(), "Split Key"),
        (b"\x42\x00\x8A".into(), "Split Key Method"),
        (b"\x42\x00\x8B".into(), "Split Key Parts"),
        (b"\x42\x00\x8C".into(), "Split Key Threshold"),
        (b"\x42\x00\x8D".into(), "State"),
        (b"\x42\x00\x8E".into(), "Storage Status Mask"),
        (b"\x42\x00\x8F".into(), "Symmetric Key"),
        (b"\x42\x00\x90".into(), "Template"),
        (b"\x42\x00\x91".into(), "Template-Attribute"),
        (b"\x42\x00\x92".into(), "Time Stamp"),
        (b"\x42\x00\x93".into(), "Unique Batch Item ID"),
        (b"\x42\x00\x94".into(), "Unique Identifier"),
        (b"\x42\x00\x95".into(), "Usage Limits"),
        (b"\x42\x00\x96".into(), "Usage Limits Count"),
        (b"\x42\x00\x97".into(), "Usage Limits Total"),
        (b"\x42\x00\x98".into(), "Usage Limits Unit"),
        (b"\x42\x00\x99".into(), "Username"),
        (b"\x42\x00\x9A".into(), "Validity Date"),
        (b"\x42\x00\x9B".into(), "Validity Indicator"),
        (b"\x42\x00\x9C".into(), "Vendor Extension"),
        (b"\x42\x00\x9D".into(), "Vendor Identification"),
        (b"\x42\x00\x9E".into(), "Wrapping Method"),
        (b"\x42\x00\x9F".into(), "X"),
        (b"\x42\x00\xA0".into(), "Y"),
        (b"\x42\x00\xA1".into(), "Password"),
        // KMIP 1.1: http://docs.oasis-open.org/kmip/spec/v1.1/cs01/kmip-spec-v1.1-cs01.html#_Toc332787683
        (b"\x42\x00\xA2".into(), "Device Identifier"),
        (b"\x42\x00\xA3".into(), "Encoding Option"),
        (b"\x42\x00\xA4".into(), "Extension Information"),
        (b"\x42\x00\xA5".into(), "Extension Name"),
        (b"\x42\x00\xA6".into(), "Extension Tag"),
        (b"\x42\x00\xA7".into(), "Extension Type"),
        (b"\x42\x00\xA8".into(), "Fresh"),
        (b"\x42\x00\xA9".into(), "Machine Identifier"),
        (b"\x42\x00\xAA".into(), "Media Identifier"),
        (b"\x42\x00\xAB".into(), "Network Identifier"),
        (b"\x42\x00\xAC".into(), "Object Group Member"),
        (b"\x42\x00\xAD".into(), "Certificate Length"),
        (b"\x42\x00\xAE".into(), "Digital Signature Algorithm"),
        (b"\x42\x00\xAF".into(), "Certificate Serial Number"),
        (b"\x42\x00\xB0".into(), "Device Serial Number"),
        (b"\x42\x00\xB1".into(), "Issuer Alternative Name"),
        (b"\x42\x00\xB2".into(), "Issuer Distinguished Name"),
        (b"\x42\x00\xB3".into(), "Subject Alternative Name"),
        (b"\x42\x00\xB4".into(), "Subject Distinguished Name"),
        (b"\x42\x00\xB5".into(), "X.509 Certificate Identifier"),
        (b"\x42\x00\xB6".into(), "X.509 Certificate Issuer"),
        (b"\x42\x00\xB7".into(), "X.509 Certificate Subject"),
        // KMIP 1.2: http://docs.oasis-open.org/kmip/spec/v1.2/os/kmip-spec-v1.2-os.html#_Toc409613596
        (b"\x42\x00\xB8".into(), "Key Value Location"),
        (b"\x42\x00\xB9".into(), "Key Value Location Value"),
        (b"\x42\x00\xBA".into(), "Key Value Location Type"),
        (b"\x42\x00\xBB".into(), "Key Value Present"),
        (b"\x42\x00\xBC".into(), "Original Creation Date"),
        (b"\x42\x00\xBD".into(), "PGP Key"),
        (b"\x42\x00\xBE".into(), "PGP Key Version"),
        (b"\x42\x00\xBF".into(), "Alternative Name"),
        (b"\x42\x00\xC0".into(), "Alternative Name Value"),
        (b"\x42\x00\xC1".into(), "Alternative Name Type"),
        (b"\x42\x00\xC2".into(), "Data"),
        (b"\x42\x00\xC3".into(), "Signature Data"),
        (b"\x42\x00\xC4".into(), "Data Length"),
        (b"\x42\x00\xC5".into(), "Random IV"),
        (b"\x42\x00\xC6".into(), "MAC Data"),
        (b"\x42\x00\xC7".into(), "Attestation Type"),
        (b"\x42\x00\xC8".into(), "Nonce"),
        (b"\x42\x00\xC9".into(), "Nonce ID"),
        (b"\x42\x00\xCA".into(), "Nonce Value"),
        (b"\x42\x00\xCB".into(), "Attestation Measurement"),
        (b"\x42\x00\xCC".into(), "Attestation Assertion"),
        (b"\x42\x00\xCD".into(), "IV Length"),
        (b"\x42\x00\xCE".into(), "Tag Length"),
        (b"\x42\x00\xCF".into(), "Fixed Field Length"),
        (b"\x42\x00\xD0".into(), "Counter Length"),
        (b"\x42\x00\xD1".into(), "Initial Counter Value"),
        (b"\x42\x00\xD2".into(), "Invocation Field Length"),
        (b"\x42\x00\xD3".into(), "Attestation Capable Indicator"),
        // KMIP 1.3: http://docs.oasis-open.org/kmip/spec/v1.3/os/kmip-spec-v1.3-os.html#_Toc473102933
        (b"\x42\x00\xD4".into(), "Offset Items"),
        (b"\x42\x00\xD5".into(), "Located Items"),
        (b"\x42\x00\xD6".into(), "Correlation Value"),
        (b"\x42\x00\xD7".into(), "Init Indicator"),
        (b"\x42\x00\xD8".into(), "Final Indicator"),
        (b"\x42\x00\xD9".into(), "RNG Parameters"),
        (b"\x42\x00\xDA".into(), "RNG Algorithm"),
        (b"\x42\x00\xDB".into(), "DRBG Algorithm"),
        (b"\x42\x00\xDC".into(), "FIPS186 Variation"),
        (b"\x42\x00\xDD".into(), "Prediction Resistance"),
        (b"\x42\x00\xDE".into(), "Random Number Generator"),
        (b"\x42\x00\xDF".into(), "Validation Information"),
        (b"\x42\x00\xE0".into(), "Validation Authority Type"),
        (b"\x42\x00\xE1".into(), "Validation Authority Country"),
        (b"\x42\x00\xE2".into(), "Validation Authority URI"),
        (b"\x42\x00\xE3".into(), "Validation Version Major"),
        (b"\x42\x00\xE4".into(), "Validation Version Minor"),
        (b"\x42\x00\xE5".into(), "Validation Type"),
        (b"\x42\x00\xE6".into(), "Validation Level"),
        (b"\x42\x00\xE7".into(), "Validation Certificate Identifier"),
        (b"\x42\x00\xE8".into(), "Validation Certificate URI"),
        (b"\x42\x00\xE9".into(), "Validation Vendor URI"),
        (b"\x42\x00\xEA".into(), "Validation Profile"),
        (b"\x42\x00\xEB".into(), "Profile Information"),
        (b"\x42\x00\xEC".into(), "Profile Name"),
        (b"\x42\x00\xED".into(), "Server URI"),
        (b"\x42\x00\xEE".into(), "Server Port"),
        (b"\x42\x00\xEF".into(), "Streaming Capability"),
        (b"\x42\x00\xF0".into(), "Asynchronous Capability"),
        (b"\x42\x00\xF1".into(), "Attestation Capability"),
        (b"\x42\x00\xF2".into(), "Unwrap Mode"),
        (b"\x42\x00\xF3".into(), "Destroy Action"),
        (b"\x42\x00\xF4".into(), "Shredding Algorithm"),
        (b"\x42\x00\xF5".into(), "RNG Mode"),
        (b"\x42\x00\xF6".into(), "Client Registration Method"),
        (b"\x42\x00\xF7".into(), "Capability Information"),
        // KMIP 1.4: https://docs.oasis-open.org/kmip/spec/v1.4/errata01/os/kmip-spec-v1.4-errata01-os-redlined.html#_Toc490660919
        (b"\x42\x00\xF8".into(), "Key Wrap Type"),
        (b"\x42\x00\xF9".into(), "Batch Undo Capability"),
        (b"\x42\x00\xFA".into(), "Batch Continue Capability"),
        (b"\x42\x00\xFB".into(), "PKCS#12 Friendly Name"),
        (b"\x42\x00\xFC".into(), "Description"),
        (b"\x42\x00\xFD".into(), "Comment"),
        (b"\x42\x00\xFE".into(), "Authenticated Encryption Additional Data"),
        (b"\x42\x00\xFF".into(), "Authenticated Encryption Tag"),
        (b"\x42\x01\x00".into(), "Salt Length"),
        (b"\x42\x01\x01".into(), "Mask Generator"),
        (b"\x42\x01\x02".into(), "Mask Generator Hashing Algorithm"),
        (b"\x42\x01\x03".into(), "P Source"),
        (b"\x42\x01\x04".into(), "Trailer Field"),
        (b"\x42\x01\x05".into(), "Client Correlation Value"),
        (b"\x42\x01\x06".into(), "Server Correlation Value"),
        (b"\x42\x01\x07".into(), "Digested Data"),
        (b"\x42\x01\x08".into(), "Certificate Subject CN"),
        (b"\x42\x01\x09".into(), "Certificate Subject O"),
        (b"\x42\x01\x0A".into(), "Certificate Subject OU"),
        (b"\x42\x01\x0B".into(), "Certificate Subject Email"),
        (b"\x42\x01\x0C".into(), "Certificate Subject C"),
        (b"\x42\x01\x0D".into(), "Certificate Subject ST"),
        (b"\x42\x01\x0E".into(), "Certificate Subject L"),
        (b"\x42\x01\x0F".into(), "Certificate Subject UID"),
        (b"\x42\x01\x10".into(), "Certificate Subject Serial Number"),
        (b"\x42\x01\x11".into(), "Certificate Subject Title"),
        (b"\x42\x01\x12".into(), "Certificate Subject DC"),
        (b"\x42\x01\x13".into(), "Certificate Subject DN Qualifier"),
        (b"\x42\x01\x14".into(), "Certificate Issuer CN"),
        (b"\x42\x01\x15".into(), "Certificate Issuer O"),
        (b"\x42\x01\x16".into(), "Certificate Issuer OU"),
        (b"\x42\x01\x17".into(), "Certificate Issuer Email"),
        (b"\x42\x01\x18".into(), "Certificate Issuer C"),
        (b"\x42\x01\x19".into(), "Certificate Issuer ST"),
        (b"\x42\x01\x1A".into(), "Certificate Issuer L"),
        (b"\x42\x01\x1B".into(), "Certificate Issuer UID"),
        (b"\x42\x01\x1C".into(), "Certificate Issuer Serial Number"),
        (b"\x42\x01\x1D".into(), "Certificate Issuer Title"),
        (b"\x42\x01\x1E".into(), "Certificate Issuer DC"),
        (b"\x42\x01\x1F".into(), "Certificate Issuer DN Qualifier"),
        (b"\x42\x01\x20".into(), "Sensitive"),
        (b"\x42\x01\x21".into(), "Always Sensitive"),
        (b"\x42\x01\x22".into(), "Extractable"),
        (b"\x42\x01\x23".into(), "Never Extractable"),
        (b"\x42\x01\x24".into(), "Replace Existing"),
    ]
    .into_iter()
    .collect()
}
