use super::super::device::device::{
    device_gdb_node_to_gql_interface, DeviceValue, DEVICE_MODEL_ALIAS, DEVICE_MODEL_NAME,
};
use super::user::{User, UserValue, USER_MODEL_ALIAS, USER_MODEL_NAME};
use crate::identify_temporalize;
use juniper::{graphql_interface, graphql_object};
use klub_stores::dbs::controller::ModelParams;

use crate::graph_context::GraphContext;

identify_temporalize!(
    pub struct Creator {
        name: Option<String>,
        model_type: String,
    }
);

impl Creator {
    pub fn new(id: &str, name: Option<String>) -> Self {
        Self {
            model_name: "Creator",
            model_alias: "creator",
            id: id.to_owned(),
            created: "".to_string(),
            updated: "".to_string(),
            name: name.to_owned(),
            model_type: USER_MODEL_NAME.to_string(),
        }
    }
}

#[graphql_object(context = GraphContext, impl = UserValue)]
impl Creator {
    fn id(&self) -> &str {
        &self.id
    }
    fn model_type(&self) -> &str {
        &self.model_type
    }
}

#[graphql_interface]
impl User for Creator {
    fn id(&self) -> &str {
        &self.id
    }
    fn name(&self) -> Option<String> {
        self.name.to_owned()
    }
    fn model_type(&self) -> &str {
        &self.model_type
    }
    async fn devices(&self, ctx: &GraphContext) -> Vec<DeviceValue> {
        let id_str = &self.id[..];
        let node_one_model_params = ModelParams {
            model_name: USER_MODEL_NAME,
            model_alias: USER_MODEL_ALIAS,
        };
        let rel_model_params = ModelParams {
            model_name: "AUTHORIZED_BY",
            model_alias: "authorizedBy",
        };
        let node_two_model_params = ModelParams {
            model_name: DEVICE_MODEL_NAME,
            model_alias: DEVICE_MODEL_ALIAS,
        };
        let mut devices = vec![];
        let rows = ctx
            .find_nodes_with_rels(
                id_str,
                node_one_model_params,
                node_two_model_params,
                rel_model_params,
            )
            .await
            .unwrap();
        for row in rows {
            match row.node_two {
                Some(device_node) => {
                    let device = device_gdb_node_to_gql_interface(device_node);
                    devices.push(device);
                }
                None => {
                    println!("Connot find user devices");
                }
            }
        }
        devices
    }
}
