use super::topic::TopicValue;
use super::topic::{Topic, TOPIC_MODEL_NAME};
use crate::graph_context::GraphContext;
use crate::identify_temporalize;
use juniper::graphql_interface;

identify_temporalize!(
    pub struct Discussion {
        heading: String,
        blurb: Option<String>,
        description: Option<String>,
        model_type: String,
    }
);

impl Discussion {
    pub fn new(
        id: &str,
        heading: String,
        blurb: Option<String>,
        description: Option<String>,
    ) -> Self {
        Self {
            id: id.to_owned(),
            model_type: TOPIC_MODEL_NAME.to_string(),
            model_name: "Discussion",
            model_alias: "discussion",
            created: "".to_string(),
            updated: "".to_string(),
            heading: heading.to_owned(),
            blurb: blurb.to_owned(),
            description: description.to_owned(),
        }
    }
}

#[graphql_object(context = GraphContext, impl = TopicValue)]
impl Discussion {
    fn id(&self) -> &str {
        &self.id
    }
    fn model_type(&self) -> &str {
        &self.model_type
    }
}

#[graphql_interface]
impl Topic for Discussion {
    fn id(&self) -> &str {
        &self.id
    }
    fn model_type(&self) -> &str {
        &self.model_type
    }
    fn model_name(&self) -> &str {
        &self.model_name
    }
    fn model_alias(&self) -> &str {
        &self.model_alias
    }
    fn heading(&self) -> &str {
        &self.heading
    }
    fn blurb(&self) -> Option<String> {
        self.blurb.to_owned()
    }
    fn description(&self) -> Option<String> {
        self.description.to_owned()
    }
}
