#[macro_export]
// Injects model_name, model_alias and id to struct
macro_rules! identify {
    (pub struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        #[derive(Clone)]
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: String,
            pub $( $field: $ty ),*
        }
    };
}

#[macro_export]
// Injects model_name, model_alias, id, created and updated to struct
macro_rules! identify_temporalize {
    (pub struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        #[derive(Clone)]
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: String,
            pub created: String,
            pub updated: String,
            pub $( $field: $ty ),*
        }
    };
}

#[macro_export]
// Injects model_name, model_alias, id, longitude, latitude, city, address and zipcode to struct
macro_rules! identify_localize {
    (struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        #[derive(Clone)]
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: String,
            pub longitude: f64,
            pub latitude: f64,
            pub city: str,
            pub address: str,
            pub zipcode: str,
            pub $( $field: $ty ),*
        }
    };
}

#[macro_export]
// Injects model_name, model_alias, id, created, updated, longitude, latitude, city, address and zipcode to struct
macro_rules! identify_temporalize_localize {
    (pub struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        #[derive(Clone)]
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: String,
            pub created: String,
            pub updated: String,
            pub longitude: Option<f64>,
            pub latitude: Option<f64>,
            pub city: Option<String>,
            pub address: Option<String>,
            pub zipcode: Option<String>,
            pub $( $field: $ty ),*
        }
    };
}
