use super::device::{Device, DeviceValue, DEVICE_MODEL_NAME};
use crate::identify_temporalize_localize;
use juniper::{graphql_interface, graphql_object};

use crate::graph_context::GraphContext;

identify_temporalize_localize!(
    pub struct WebMobileApp {
        os: Option<String>,
        carrier: Option<String>,
        locale: Option<String>,
        language: Option<String>,
        browser: Option<String>,
        battery_life: Option<f64>,
        model_type: String,
    }
);

impl WebMobileApp {
    pub fn new(
        id: &str,
        os: Option<String>,
        carrier: Option<String>,
        locale: Option<String>,
        language: Option<String>,
        battery_life: Option<f64>,
        browser: Option<String>,
        longitude: Option<f64>,
        latitude: Option<f64>,
        city: Option<String>,
        address: Option<String>,
        zipcode: Option<String>,
    ) -> Self {
        Self {
            model_name: "WebMobileApp",
            model_alias: "webMobileApp",
            id: id.to_owned(),
            os: os.to_owned(),
            carrier: carrier.to_owned(),
            locale: locale.to_owned(),
            language: language.to_owned(),
            browser: browser.to_owned(),
            battery_life: battery_life.to_owned(),
            model_type: DEVICE_MODEL_NAME.to_owned(),
            longitude: longitude.to_owned(),
            latitude: latitude.to_owned(),
            city: city.to_owned(),
            address: address.to_owned(),
            zipcode: zipcode.to_owned(),
            created: "".to_string(),
            updated: "".to_string(),
        }
    }
}

#[graphql_object(context = GraphContext, impl = DeviceValue)]
impl WebMobileApp {
    fn id(&self) -> &str {
        &self.id
    }
    fn model_type(&self) -> &str {
        &self.model_type
    }
}

#[graphql_interface]
impl Device for WebMobileApp {
    fn id(&self) -> &str {
        &self.id
    }

    fn os(&self) -> Option<String> {
        self.os.to_owned()
    }
    fn locale(&self) -> Option<String> {
        self.locale.to_owned()
    }
    fn language(&self) -> Option<String> {
        self.language.to_owned()
    }
    fn browser(&self) -> Option<String> {
        self.browser.to_owned()
    }
    fn battery_life(&self) -> Option<f64> {
        self.battery_life.to_owned()
    }
    fn latitude(&self) -> Option<f64> {
        self.latitude.to_owned()
    }
    fn longitude(&self) -> Option<f64> {
        self.longitude.to_owned()
    }
    fn model_type(&self) -> &str {
        &self.model_type
    }
}
