use std::collections::HashMap;

use juniper::Context;

use super::comment::comment::CommentValue;
use super::comment::opinion::Opinion;
use super::comment::solution::Solution;
use super::topic::discussion::Discussion;
use super::topic::problem::Problem;
use super::topic::topic::{Topic, TopicValue};
use super::user::commenter::Commenter;
use super::user::creator::Creator;
use super::user::follower::Follower;
use super::user::user::{User, UserValue};

#[derive(Default, Clone)]
pub struct Database {
    creators: HashMap<String, Creator>,
    problems: HashMap<String, Problem>,
    discussions: HashMap<String, Discussion>,
    followers: HashMap<String, Follower>,
    commenters: HashMap<String, Commenter>,
    solutions: HashMap<String, Solution>,
    opinions: HashMap<String, Opinion>,
}

impl Context for Database {}

impl Database {
    pub fn new() -> Database {
        let mut creators = HashMap::new();
        let mut followers = HashMap::new();
        let mut commenters = HashMap::new();
        let mut problems = HashMap::new();
        let mut discussions = HashMap::new();
        let mut solutions = HashMap::new();
        let mut opinions = HashMap::new();

        creators.insert("2000".to_owned(), Creator::new("2000", "Luke Skywalker"));

        followers.insert("6000".to_owned(), Follower::new("6000", "Y Skywalker"));

        commenters.insert("7000".to_owned(), Commenter::new("7000", "V Skywalker"));

        problems.insert(
            "4000".to_owned(),
            Problem::new("4000", "Luke Skywalker", "", ""),
        );

        discussions.insert(
            "5000".to_owned(),
            Discussion::new("5000", "Luke Skywalker", "", ""),
        );

        solutions.insert("8000".to_owned(), Solution::new("8000", "V Skywalker"));

        opinions.insert("9000".to_owned(), Opinion::new("9000", "V Skywalker"));

        Database {
            problems,
            creators,
            discussions,
            followers,
            commenters,
            solutions,
            opinions,
        }
    }
}
