use super::comment::{Comment, CommentValue, COMMENT_MODEL_NAME};
use crate::graph_context::GraphContext;
use juniper::graphql_interface;

#[derive(Clone)]
pub struct Opinion {
    id: String,
    heading: String,
    model_type: String,
    text: String,
}

impl Opinion {
    pub fn new(id: &str, heading: String, text: String) -> Self {
        Self {
            id: id.to_owned(),
            heading: heading.to_owned(),
            text: text.to_owned(),
            model_type: COMMENT_MODEL_NAME.to_string(),
        }
    }
}

#[graphql_object(context = GraphContext, impl = CommentValue)]
impl Opinion {
    fn id(&self) -> &str {
        &self.id
    }
    fn heading(&self) -> &str {
        self.heading.as_str()
    }
    fn model_type(&self) -> &str {
        self.model_type.as_str()
    }

    fn text(&self) -> &str {
        self.text.as_str()
    }
}

#[graphql_interface]
impl Comment for Opinion {
    fn id(&self) -> &str {
        &self.id
    }
    fn heading(&self) -> &str {
        self.heading.as_str()
    }
    fn model_type(&self) -> &str {
        self.model_type.as_str()
    }
    fn text(&self) -> &str {
        self.text.as_str()
    }
}
