use super::super::database::Database;
use super::super::topic::topic::TopicValue;
use juniper::graphql_interface;

use super::commenter::Commenter;
use super::creator::Creator;
use super::follower::Follower;

pub enum UserType {
    Creator,
    Follower,
    Commenter,
}
#[graphql_interface(for = [Creator, Follower, Commenter], context = Database)]
pub trait User {
    fn id(&self) -> &str;

    fn name(&self) -> Option<&str>;

    fn topics(&self, ctx: &Database) -> Vec<TopicValue>;

    #[graphql(ignore)]
    fn topic_ids(&self) -> &[String];
}
