use super::super::topic::topic::TopicValue;
use super::user::{User, UserValue};
use juniper::{graphql_interface, graphql_object};

use super::super::database::Database;

#[derive(Clone)]
pub struct Follower {
    id: String,
    name: String,
    topic_ids: Vec<String>,
}

impl Follower {
    pub fn new(id: &str, name: &str, topic_ids: &[&str]) -> Self {
        Self {
            id: id.to_owned(),
            name: name.to_owned(),
            topic_ids: topic_ids
                .to_owned()
                .into_iter()
                .map(ToOwned::to_owned)
                .collect(),
        }
    }
}

#[graphql_object(context = Database, impl = UserValue)]
impl Follower {
    fn id(&self) -> &str {
        &self.id
    }
    fn name(&self) -> Option<&str> {
        Some(self.name.as_str())
    }
    fn topics(&self, ctx: &Database) -> Vec<TopicValue> {
        ctx.get_topics(self)
    }
}

#[graphql_interface]
impl User for Follower {
    fn id(&self) -> &str {
        &self.id
    }

    fn name(&self) -> Option<&str> {
        Some(&self.name)
    }

    fn topics(&self, ctx: &Database) -> Vec<TopicValue> {
        ctx.get_topics(self)
    }
    fn topic_ids(&self) -> &[String] {
        &self.topic_ids
    }
}
