use super::super::comment::comment::CommentValue;
use super::super::user::user::UserValue;
use super::discussion::Discussion;
use super::problem::Problem;
use juniper::graphql_interface;

use super::super::database::Database;

#[derive(GraphQLEnum, Copy, Clone, Eq, PartialEq, Debug)]
pub enum TopicType {
    #[graphql(name = "Problem")]
    Problem,
    #[graphql(name = "Discussion")]
    Discussion,
}

#[graphql_interface(for = [Problem, Discussion], context = Database)]
pub trait Topic {
    fn id(&self) -> &str;

    fn name(&self) -> Option<&str>;

    fn commenters(&self, ctx: &Database) -> Vec<UserValue>;
    fn comments(&self, ctx: &Database) -> Vec<CommentValue>;

    fn topic_type(&self) -> &str;

    #[graphql(ignore)]
    fn commenter_ids(&self) -> &[String];

    fn comment_ids(&self) -> &[String];
}
