use super::super::comment::comment::CommentValue;
use super::super::database::Database;
use super::super::user::user::UserValue;
use super::topic::{Topic, TopicType};
use juniper::graphql_interface;

#[derive(Clone)]
pub struct Problem {
    id: String,
    name: String,
    commenter_ids: Vec<String>,
    topic_type: TopicType,
    comment_ids: Vec<String>,
}

impl Problem {
    pub fn new(
        id: &str,
        name: &str,
        commenter_ids: &[&str],
        topic_type: TopicType,
        comment_ids: &[&str],
    ) -> Self {
        Self {
            id: id.to_owned(),
            name: name.to_owned(),
            commenter_ids: commenter_ids
                .to_owned()
                .into_iter()
                .map(ToOwned::to_owned)
                .collect(),
            topic_type: topic_type.to_owned(),
            comment_ids: comment_ids
                .to_owned()
                .into_iter()
                .map(ToOwned::to_owned)
                .collect(),
        }
    }
}

#[graphql_object(context = Database, impl = UserValue)]
impl Problem {
    fn id(&self) -> &str {
        &self.id
    }
    fn name(&self) -> Option<&str> {
        Some(self.name.as_str())
    }
    fn commenters(&self, ctx: &Database) -> Vec<UserValue> {
        ctx.get_commenters(self)
    }
}

#[graphql_interface]
impl Topic for Problem {
    fn id(&self) -> &str {
        &self.id
    }

    fn name(&self) -> Option<&str> {
        Some(&self.name)
    }

    fn topic_type(&self) -> &str {
        self.topic_type()
    }
    fn commenters(&self, ctx: &Database) -> Vec<UserValue> {
        ctx.get_commenters(self)
    }
    fn commenter_ids(&self) -> &[String] {
        &self.commenter_ids
    }
    fn comments(&self, ctx: &Database) -> Vec<CommentValue> {
        println!("HEERERERE");
        println!("{:?}", &self.id);
        println!("{:?}", &self.comment_ids);
        ctx.get_comments(self)
    }

    fn comment_ids(&self) -> &[String] {
        &self.comment_ids
    }
}
