use crate::{identify_temporalize, models::model::ModelTrait};

use super::traits;

/*
* Subscribers subscribe to schedules and connect other
* subscribers (connect/sync additional personal calendars)
*/

identify_temporalize!(
    pub struct Subscriber {
        is_subscribed: bool,
        name: &'static str,
    }
);

impl Subscriber {
    pub fn new(name: &'static str) -> Subscriber {
        Subscriber {
            model_name: "Subscriber",
            model_alias: "subscriber",
            id: 0,
            created: "2021-05-10".to_string(),
            updated: "2021-05-10".to_string(),
            name,
            is_subscribed: false,
        }
    }
    fn is_subscribed(&self) -> bool {
        self.is_subscribed
    }

    pub fn subscribe(&mut self) {
        if self.is_subscribed() {
            println!("{} user is already subscribed", self.name)
        } else {
            println!("{} subsribing user", self.name);
            self.is_subscribed = true;
        }
    }
}

impl ModelTrait for Subscriber {
    fn register(&mut self, name: &'static str, alias: &'static str) {
        self.model_name = name;
        self.model_alias = alias;
    }
}

impl traits::User for Subscriber {
    fn name(&self) -> &'static str {
        self.name
    }

    fn auth_type(&self) -> &'static str {
        if self.is_subscribed() {
            "noooo auth type"
        } else {
            "subsribeeeeeed"
        }
    }
}
