use super::traits;
use crate::{identify_temporalize, models::model::ModelTrait};

/*
* Creators create schedules
*/

identify_temporalize!(
    pub struct Creator {
        is_subscribed: bool,
        name: &'static str,
    }
);

impl Creator {
    pub fn new(name: &'static str) -> Self {
        Self {
            model_name: "Creator",
            model_alias: "creator",
            id: 123213,
            name,
            created: "".to_string(),
            updated: "".to_string(),
            is_subscribed: false,
        }
    }
}

impl traits::User for Creator {
    fn name(&self) -> &'static str {
        self.name
    }
    fn auth_type(&self) -> &'static str {
        "subsribeeeeeed"
    }
}

impl ModelTrait for Creator {
    fn register(&mut self, name: &'static str, alias: &'static str) {
        self.model_name = name;
        self.model_alias = alias;
    }
}
