use std::sync::Arc;

use super::user;
use klub_stores::stores::dbs::controller::{Controller, ModelParams};
use klub_stores::stores::stores::Stores;
pub enum Models {
    Creator(user::creator::Creator),
    Subscriber(user::subscriber::Subscriber),
}

pub trait ModelTrait {
    fn register(&mut self, name: &'static str, alias: &'static str);
}
pub struct Model {
    pub model: Models,
    pub stores: Arc<Stores>,
}

impl Model {
    pub fn new(model: Models, stores: Arc<Stores>) -> Self {
        Self { model, stores }
    }

    async fn find_by_id_exec(
        &mut self,
        model_name: &'static str,
        model_alias: &'static str,
        id: &'static str,
    ) -> &'static str {
        let graph = &self.stores.graph;
        let neo_4j = &graph.db;
        match neo_4j {
            None => {
                println!("Something is fucked up. Never established connection with Neo4J");
                "chukkeh"
            }
            Some(conn) => {
                let neo_4j_conn = conn;
                let model_params = ModelParams {
                    model_name,
                    model_alias,
                };
                neo_4j_conn.find_by_id(model_params, id).await
            }
        }
    }

    pub async fn find_by_id(&mut self, id: &'static str) -> &'static str {
        let model = &self.model;
        match model {
            Models::Creator(c) => {
                let model_name = c.model_name;
                let model_alias = c.model_alias;
                &self.find_by_id_exec(model_name, model_alias, id).await
            }
            Models::Subscriber(_) => "chukke kaiko",
        }
    }
}

#[tokio::test]
async fn testing() {
    use super::user::creator::Creator;
    let creator = Creator::new("chode");
    let mut stores = Stores::new();
    let _ = stores.connect_graph().await;
    // let model = Model::new(Models::Creator(creator), stores);
    // let model = model.model;
    // match model {
    //     Models::Creator(_) => {}
    //     Models::Subscriber(_) => {}
    // }
}
