#[macro_export]
macro_rules! identify {
    (pub struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: u64,
            $( $field: $ty ),*
        }
    };
}

#[macro_export]
macro_rules! identify_temporalize {
    (pub struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: u64,
            pub created: String,
            pub updated: String,
            $( $field: $ty ),*
        }
    };
}

#[macro_export]
macro_rules! identify_localize {
    (struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: u64,
            pub longitude: f64,
            pub latitude: f64,
            pub city: str,
            pub address: str,
            pub zipcode: str,
            $( $field: $ty ),*
        }
    };
}

#[macro_export]
macro_rules! identify_temporalize_localize {
    (struct $name:ident { $( $field:ident: $ty:ty ),* $(,)* }) => {
        pub struct $name {
            pub model_name: &'static str,
            pub model_alias: &'static str,
            pub id: u64,
            pub created: str,
            pub updated: str,
            pub longitude: f64,
            pub latitude: f64,
            pub city: str,
            pub address: str,
            pub zipcode: str,
            $( $field: $ty ),*
        }
    };
}
