use juniper::graphql_interface;

use super::super::database::Database;
use super::super::topic::topic::TopicValue;
use super::comment::{Comment, CommentValue};

#[derive(Clone)]
pub struct Opinion {
    id: String,
    name: String,
    topic_id: String,
    opinion: String,
}

impl Opinion {
    pub fn new(id: &str, name: &str, topic_id: &str, opinion: &str) -> Self {
        Self {
            id: id.to_owned(),
            name: name.to_owned(),
            topic_id: topic_id.to_owned(),
            opinion: opinion.to_owned(),
        }
    }
}

#[graphql_object(context = Database, impl = CommentValue)]
impl Opinion {
    fn id(&self) -> &str {
        &self.id
    }
    fn name(&self) -> Option<&str> {
        Some(self.name.as_str())
    }
    fn topic(&self, ctx: &Database) -> Option<TopicValue> {
        ctx.get_topic(self.topic_id.as_str())
    }

    fn opinion(&self) -> &str {
        &self.opinion
    }
}

#[graphql_interface]
impl Comment for Opinion {
    fn id(&self) -> &str {
        &self.id
    }

    fn text(&self) -> &str {
        &self.text()
    }

    fn topic(&self, ctx: &Database) -> Option<TopicValue> {
        ctx.get_topic(self.topic_id.as_str())
    }

    fn topic_id(&self) -> &str {
        &self.topic_id()
    }
}
