use super::super::topic::topic::TopicValue;
use super::opinion::Opinion;
use super::solution::Solution;
use juniper::graphql_interface;

use super::super::database::Database;

#[derive(GraphQLEnum, Copy, Clone, Eq, PartialEq, Debug)]
pub enum CommentType {
    #[graphql(name = "Solution")]
    Solution,
    #[graphql(name = "Opinion")]
    Opinion,
}

#[graphql_interface(for = [Solution, Opinion], context = Database)]
pub trait Comment {
    fn id(&self) -> &str;

    fn text(&self) -> &str;

    fn topic(&self, ctx: &Database) -> Option<TopicValue>;

    fn topic_id(&self) -> &str;
}
