use super::traits;
use crate::{identify_temporalize, models::model::ModelTrait};

/*
* Creators create schedules
*/

identify_temporalize!(
    pub struct Creator {
        is_subscribed: bool,
        name: &'static str,
    }
);

impl Creator {
    pub fn new(name: &'static str) -> Self {
        Self {
            model_name: "Creator",
            model_alias: "creator",
            id: 123213,
            name,
            created: "".to_string(),
            updated: "".to_string(),
            is_subscribed: false,
        }
    }
    fn is_subscribed(&self) -> bool {
        self.is_subscribed
    }
    pub fn subscribe(&mut self) {
        if self.is_subscribed() {
            println!("{} user is already subscribed", self.name)
        } else {
            println!("{} subsribing user", self.name);
            self.is_subscribed = true;
        }
    }
}

impl traits::User for Creator {
    fn name(&self) -> &'static str {
        self.name
    }
    fn auth_type(&self) -> &'static str {
        if self.is_subscribed() {
            "noooo auth type"
        } else {
            "subsribeeeeeed"
        }
    }
}

impl ModelTrait for Creator {
    fn register(&mut self, name: &'static str, alias: &'static str) {
        self.model_name = name;
        self.model_alias = alias;
    }
}
