use clap::{Args, Parser};
use console::style;

use crate::commands::{module_deploy_command, init_command, login_command, new_command, BaseCommand, build_command, publish_command, module_list_command, ModuleCommand, module_get_command, module_delete_command};

mod commands;
mod global_config;
mod project_config;
mod error;
mod client;

#[derive(Parser)]
#[clap(author, version, about, long_about = None)]
#[clap(propagate_version = true)]
struct Cli {
    #[clap(subcommand)]
    pub command: BaseCommand,
    #[clap(flatten)]
    pub config: GlobalArgs,
}

#[derive(Args)]
pub struct GlobalArgs {
    #[clap(long)]
    token: Option<String>
}

fn main() {
    let cli: Cli = Cli::parse();

    let res = match cli.command {
        BaseCommand::Login(args) => login_command(args),
        BaseCommand::Init(args) => init_command(args),
        BaseCommand::New(args) => new_command(args),
        BaseCommand::Publish(args) => publish_command(args),
        BaseCommand::Build(args) => build_command(args),
        BaseCommand::Module(args) => match args.command {
            ModuleCommand::Deploy(args) => module_deploy_command(args),
            ModuleCommand::List(args) => module_list_command(args),
            ModuleCommand::Get(args) => module_get_command(args),
            ModuleCommand::Delete(args) => module_delete_command(args)
        }
    };

    if let Err(e) = res {
        println!("{}", style(e).red());
    }
}
