use serde::{Deserialize, Serialize};

use crate::error::CliError;

#[derive(Default, Serialize, Deserialize)]
pub struct GlobalConfig {
    #[serde(default)]
    pub token: Option<String>,
}

impl GlobalConfig {
    pub fn read_or_default() -> Result<Self, CliError> {
        Ok(confy::load("kite")?)
    }

    pub fn flush(&self) -> Result<(), CliError> {
        confy::store("kite", self)?;
        Ok(())
    }
}
