use clap::Args;

use crate::commands::{BuildArgs, DeployArgs};
use crate::error::CliResult;
use crate::project_config::ProjectConfig;
use crate::{build_command, module_deploy_command};

#[derive(Args)]
pub struct PublishArgs {}

pub fn publish_command(_: PublishArgs) -> CliResult {
    let config = ProjectConfig::read()?;

    build_command(BuildArgs {})?;
    module_deploy_command(DeployArgs {
        path: config.build.file,
        kind: None, // TODO: read from config
        id: Some(config.package.id),
        name: config.package.name,
        guild_id: config.package.guild_id,
    })?;

    Ok(())
}
