use clap::Args;
use nanoid::nanoid;
use crate::error::CliResult;

use crate::project_config::{BuildConfig, PackageConfig, ProjectConfig, ProjectType};

#[derive(Args)]
pub struct NewArgs {
    #[clap(long)]
    pub id: Option<String>,
    #[clap(long)]
    pub name: String,
    #[clap(long = "type", name = "type")]
    pub kind: Option<ProjectType>,
    #[clap(long)]
    pub guild_id: u64,
}

pub fn new_command(args: NewArgs) -> CliResult {
    let kind = args.kind.unwrap_or_default();

    git2::Repository::clone(
        "https://github.com/kitediscord/kite-rust-template",
        format!("./{}", args.name),
    ).expect("Cloning template directory");

    let config = ProjectConfig {
        package: PackageConfig {
            id: args.id.unwrap_or_else(|| nanoid!()),
            name: args.name.clone(),
            kind,
            guild_id: args.guild_id,
        },
        build: BuildConfig {
            command: Some(String::from("cargo build --release")),
            file: String::from("")
        }
    };

    config.flush_to(&format!("./{}", args.name))?;
    println!("Created new project at {}! Use `cd ./{0}` to start working.", args.name);

    Ok(())
}
