use clap::Args;
use crate::client::ApiClient;
use crate::error::CliResult;
use crate::global_config::GlobalConfig;

#[derive(Args)]
pub struct ModuleListArgs {
    #[clap(long)]
    pub guild_id: u64
}

pub fn module_list_command(args: ModuleListArgs) -> CliResult {
    let token = GlobalConfig::read_or_default()?.token.unwrap();
    let client = ApiClient::new(token);
    let modules = client.module_list(args.guild_id)?.modules;

    println!("{:#?}", modules);

    Ok(())
}
